// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('chimera.js_interop');
goog.require('cljs.core');
goog.require('cognitect.transit');
goog.require('goog.string');
/**
 * Convert json string to cljs object using transit.
 * Fast, but doesn't preserve keywords.
 */
chimera.js_interop.json__GT_cljs = (function chimera$js_interop$json__GT_cljs(s){
return cognitect.transit.read(cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$json),s);
});
/**
 * Convert json to js using JSON.parse.
 * If error occurs, return the string unmodified.
 */
chimera.js_interop.str__GT_json = (function chimera$js_interop$str__GT_json(string){
try{return JSON.parse(string);
}catch (e43582){if((e43582 instanceof Error)){
var _ = e43582;
return string;
} else {
throw e43582;

}
}});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
chimera.js_interop.json__GT_js__GT_cljs = (function chimera$js_interop$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(chimera.js_interop.str__GT_json(s),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
chimera.js_interop.format = (function chimera$js_interop$format(var_args){
var args__7658__auto__ = [];
var len__7651__auto___43585 = arguments.length;
var i__7652__auto___43586 = (0);
while(true){
if((i__7652__auto___43586 < len__7651__auto___43585)){
args__7658__auto__.push((arguments[i__7652__auto___43586]));

var G__43587 = (i__7652__auto___43586 + (1));
i__7652__auto___43586 = G__43587;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
});

chimera.js_interop.format.cljs$lang$maxFixedArity = (1);

chimera.js_interop.format.cljs$lang$applyTo = (function (seq43583){
var G__43584 = cljs.core.first(seq43583);
var seq43583__$1 = cljs.core.next(seq43583);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic(G__43584,seq43583__$1);
});

/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
chimera.js_interop.safe_regex = (function chimera$js_interop$safe_regex(var_args){
var args__7658__auto__ = [];
var len__7651__auto___43593 = arguments.length;
var i__7652__auto___43594 = (0);
while(true){
if((i__7652__auto___43594 < len__7651__auto___43593)){
args__7658__auto__.push((arguments[i__7652__auto___43594]));

var G__43595 = (i__7652__auto___43594 + (1));
i__7652__auto___43594 = G__43595;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (query_string,p__43590){
var map__43591 = p__43590;
var map__43591__$1 = ((((!((map__43591 == null)))?((((map__43591.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43591.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43591):map__43591);
var ignore_case_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__43591__$1,cljs.core.cst$kw$ignore_DASH_case_QMARK_,true);
return cljs.core.re_pattern([cljs.core.str((cljs.core.truth_(ignore_case_QMARK_)?"(?i)":null)),cljs.core.str(goog.string.regExpEscape(query_string))].join(''));
});

chimera.js_interop.safe_regex.cljs$lang$maxFixedArity = (1);

chimera.js_interop.safe_regex.cljs$lang$applyTo = (function (seq43588){
var G__43589 = cljs.core.first(seq43588);
var seq43588__$1 = cljs.core.next(seq43588);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__43589,seq43588__$1);
});

