// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async20293 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20293 = (function (fn_handler,f,meta20294){
this.fn_handler = fn_handler;
this.f = f;
this.meta20294 = meta20294;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20293.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20295,meta20294__$1){
var self__ = this;
var _20295__$1 = this;
return (new cljs.core.async.t_cljs$core$async20293(self__.fn_handler,self__.f,meta20294__$1));
});

cljs.core.async.t_cljs$core$async20293.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20295){
var self__ = this;
var _20295__$1 = this;
return self__.meta20294;
});

cljs.core.async.t_cljs$core$async20293.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20293.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async20293.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async20293.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fn_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)))], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$meta20294], null);
});

cljs.core.async.t_cljs$core$async20293.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20293.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20293";

cljs.core.async.t_cljs$core$async20293.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async20293");
});

cljs.core.async.__GT_t_cljs$core$async20293 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async20293(fn_handler__$1,f__$1,meta20294){
return (new cljs.core.async.t_cljs$core$async20293(fn_handler__$1,f__$1,meta20294));
});

}

return (new cljs.core.async.t_cljs$core$async20293(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args20298 = [];
var len__5627__auto___20301 = arguments.length;
var i__5628__auto___20302 = (0);
while(true){
if((i__5628__auto___20302 < len__5627__auto___20301)){
args20298.push((arguments[i__5628__auto___20302]));

var G__20303 = (i__5628__auto___20302 + (1));
i__5628__auto___20302 = G__20303;
continue;
} else {
}
break;
}

var G__20300 = args20298.length;
switch (G__20300) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20298.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$sym$buf_DASH_or_DASH_n], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args20305 = [];
var len__5627__auto___20308 = arguments.length;
var i__5628__auto___20309 = (0);
while(true){
if((i__5628__auto___20309 < len__5627__auto___20308)){
args20305.push((arguments[i__5628__auto___20309]));

var G__20310 = (i__5628__auto___20309 + (1));
i__5628__auto___20309 = G__20310;
continue;
} else {
}
break;
}

var G__20307 = args20305.length;
switch (G__20307) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20305.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_20312 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_20312) : fn1.call(null,val_20312));
} else {
cljs.core.async.impl.dispatch.run(((function (val_20312,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_20312) : fn1.call(null,val_20312));
});})(val_20312,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args20313 = [];
var len__5627__auto___20316 = arguments.length;
var i__5628__auto___20317 = (0);
while(true){
if((i__5628__auto___20317 < len__5627__auto___20316)){
args20313.push((arguments[i__5628__auto___20317]));

var G__20318 = (i__5628__auto___20317 + (1));
i__5628__auto___20317 = G__20318;
continue;
} else {
}
break;
}

var G__20315 = args20313.length;
switch (G__20315) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20313.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4423__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5472__auto___20320 = n;
var x_20321 = (0);
while(true){
if((x_20321 < n__5472__auto___20320)){
(a[x_20321] = (0));

var G__20322 = (x_20321 + (1));
x_20321 = G__20322;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__20323 = (i + (1));
i = G__20323;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async20327 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20327 = (function (alt_flag,flag,meta20328){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta20328 = meta20328;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20327.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_20329,meta20328__$1){
var self__ = this;
var _20329__$1 = this;
return (new cljs.core.async.t_cljs$core$async20327(self__.alt_flag,self__.flag,meta20328__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async20327.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_20329){
var self__ = this;
var _20329__$1 = this;
return self__.meta20328;
});})(flag))
;

cljs.core.async.t_cljs$core$async20327.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20327.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async20327.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async20327.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta20328], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async20327.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20327.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20327";

cljs.core.async.t_cljs$core$async20327.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async20327");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async20327 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async20327(alt_flag__$1,flag__$1,meta20328){
return (new cljs.core.async.t_cljs$core$async20327(alt_flag__$1,flag__$1,meta20328));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async20327(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async20333 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20333 = (function (alt_handler,flag,cb,meta20334){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta20334 = meta20334;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20333.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20335,meta20334__$1){
var self__ = this;
var _20335__$1 = this;
return (new cljs.core.async.t_cljs$core$async20333(self__.alt_handler,self__.flag,self__.cb,meta20334__$1));
});

cljs.core.async.t_cljs$core$async20333.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20335){
var self__ = this;
var _20335__$1 = this;
return self__.meta20334;
});

cljs.core.async.t_cljs$core$async20333.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20333.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async20333.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async20333.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta20334], null);
});

cljs.core.async.t_cljs$core$async20333.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20333.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20333";

cljs.core.async.t_cljs$core$async20333.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async20333");
});

cljs.core.async.__GT_t_cljs$core$async20333 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async20333(alt_handler__$1,flag__$1,cb__$1,meta20334){
return (new cljs.core.async.t_cljs$core$async20333(alt_handler__$1,flag__$1,cb__$1,meta20334));
});

}

return (new cljs.core.async.t_cljs$core$async20333(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20336_SHARP_){
var G__20340 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20336_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__20340) : fret.call(null,G__20340));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20337_SHARP_){
var G__20341 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20337_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__20341) : fret.call(null,G__20341));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__4569__auto__ = wport;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return port;
}
})()], null));
} else {
var G__20342 = (i + (1));
i = G__20342;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4569__auto__ = ret;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4425__auto__ = (function (){var and__4557__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___20348 = arguments.length;
var i__5628__auto___20349 = (0);
while(true){
if((i__5628__auto___20349 < len__5627__auto___20348)){
args__5634__auto__.push((arguments[i__5628__auto___20349]));

var G__20350 = (i__5628__auto___20349 + (1));
i__5628__auto___20349 = G__20350;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__20345){
var map__20346 = p__20345;
var map__20346__$1 = ((((!((map__20346 == null)))?((((map__20346.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20346.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20346):map__20346);
var opts = map__20346__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq20343){
var G__20344 = cljs.core.first(seq20343);
var seq20343__$1 = cljs.core.next(seq20343);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20344,seq20343__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args20351 = [];
var len__5627__auto___20401 = arguments.length;
var i__5628__auto___20402 = (0);
while(true){
if((i__5628__auto___20402 < len__5627__auto___20401)){
args20351.push((arguments[i__5628__auto___20402]));

var G__20403 = (i__5628__auto___20402 + (1));
i__5628__auto___20402 = G__20403;
continue;
} else {
}
break;
}

var G__20353 = args20351.length;
switch (G__20353) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20351.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__10205__auto___20405 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___20405){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___20405){
return (function (state_20377){
var state_val_20378 = (state_20377[(1)]);
if((state_val_20378 === (7))){
var inst_20373 = (state_20377[(2)]);
var state_20377__$1 = state_20377;
var statearr_20379_20406 = state_20377__$1;
(statearr_20379_20406[(2)] = inst_20373);

(statearr_20379_20406[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20378 === (1))){
var state_20377__$1 = state_20377;
var statearr_20380_20407 = state_20377__$1;
(statearr_20380_20407[(2)] = null);

(statearr_20380_20407[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20378 === (4))){
var inst_20356 = (state_20377[(7)]);
var inst_20356__$1 = (state_20377[(2)]);
var inst_20357 = (inst_20356__$1 == null);
var state_20377__$1 = (function (){var statearr_20381 = state_20377;
(statearr_20381[(7)] = inst_20356__$1);

return statearr_20381;
})();
if(cljs.core.truth_(inst_20357)){
var statearr_20382_20408 = state_20377__$1;
(statearr_20382_20408[(1)] = (5));

} else {
var statearr_20383_20409 = state_20377__$1;
(statearr_20383_20409[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20378 === (13))){
var state_20377__$1 = state_20377;
var statearr_20384_20410 = state_20377__$1;
(statearr_20384_20410[(2)] = null);

(statearr_20384_20410[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20378 === (6))){
var inst_20356 = (state_20377[(7)]);
var state_20377__$1 = state_20377;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20377__$1,(11),to,inst_20356);
} else {
if((state_val_20378 === (3))){
var inst_20375 = (state_20377[(2)]);
var state_20377__$1 = state_20377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20377__$1,inst_20375);
} else {
if((state_val_20378 === (12))){
var state_20377__$1 = state_20377;
var statearr_20385_20411 = state_20377__$1;
(statearr_20385_20411[(2)] = null);

(statearr_20385_20411[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20378 === (2))){
var state_20377__$1 = state_20377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20377__$1,(4),from);
} else {
if((state_val_20378 === (11))){
var inst_20366 = (state_20377[(2)]);
var state_20377__$1 = state_20377;
if(cljs.core.truth_(inst_20366)){
var statearr_20386_20412 = state_20377__$1;
(statearr_20386_20412[(1)] = (12));

} else {
var statearr_20387_20413 = state_20377__$1;
(statearr_20387_20413[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20378 === (9))){
var state_20377__$1 = state_20377;
var statearr_20388_20414 = state_20377__$1;
(statearr_20388_20414[(2)] = null);

(statearr_20388_20414[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20378 === (5))){
var state_20377__$1 = state_20377;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20389_20415 = state_20377__$1;
(statearr_20389_20415[(1)] = (8));

} else {
var statearr_20390_20416 = state_20377__$1;
(statearr_20390_20416[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20378 === (14))){
var inst_20371 = (state_20377[(2)]);
var state_20377__$1 = state_20377;
var statearr_20391_20417 = state_20377__$1;
(statearr_20391_20417[(2)] = inst_20371);

(statearr_20391_20417[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20378 === (10))){
var inst_20363 = (state_20377[(2)]);
var state_20377__$1 = state_20377;
var statearr_20392_20418 = state_20377__$1;
(statearr_20392_20418[(2)] = inst_20363);

(statearr_20392_20418[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20378 === (8))){
var inst_20360 = cljs.core.async.close_BANG_(to);
var state_20377__$1 = state_20377;
var statearr_20393_20419 = state_20377__$1;
(statearr_20393_20419[(2)] = inst_20360);

(statearr_20393_20419[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto___20405))
;
return ((function (switch__10138__auto__,c__10205__auto___20405){
return (function() {
var cljs$core$async$state_machine__10139__auto__ = null;
var cljs$core$async$state_machine__10139__auto____0 = (function (){
var statearr_20397 = [null,null,null,null,null,null,null,null];
(statearr_20397[(0)] = cljs$core$async$state_machine__10139__auto__);

(statearr_20397[(1)] = (1));

return statearr_20397;
});
var cljs$core$async$state_machine__10139__auto____1 = (function (state_20377){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_20377);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e20398){if((e20398 instanceof Object)){
var ex__10142__auto__ = e20398;
var statearr_20399_20420 = state_20377;
(statearr_20399_20420[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20377);

return cljs.core.cst$kw$recur;
} else {
throw e20398;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__20421 = state_20377;
state_20377 = G__20421;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$state_machine__10139__auto__ = function(state_20377){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10139__auto____1.call(this,state_20377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10139__auto____0;
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10139__auto____1;
return cljs$core$async$state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___20405))
})();
var state__10207__auto__ = (function (){var statearr_20400 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_20400[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___20405);

return statearr_20400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___20405))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$pos_QMARK_,cljs.core.cst$sym$n)], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__20605){
var vec__20606 = p__20605;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20606,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20606,(1),null);
var job = vec__20606;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__10205__auto___20788 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___20788,res,vec__20606,v,p,job,jobs,results){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___20788,res,vec__20606,v,p,job,jobs,results){
return (function (state_20611){
var state_val_20612 = (state_20611[(1)]);
if((state_val_20612 === (1))){
var state_20611__$1 = state_20611;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20611__$1,(2),res,v);
} else {
if((state_val_20612 === (2))){
var inst_20608 = (state_20611[(2)]);
var inst_20609 = cljs.core.async.close_BANG_(res);
var state_20611__$1 = (function (){var statearr_20613 = state_20611;
(statearr_20613[(7)] = inst_20608);

return statearr_20613;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_20611__$1,inst_20609);
} else {
return null;
}
}
});})(c__10205__auto___20788,res,vec__20606,v,p,job,jobs,results))
;
return ((function (switch__10138__auto__,c__10205__auto___20788,res,vec__20606,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0 = (function (){
var statearr_20617 = [null,null,null,null,null,null,null,null];
(statearr_20617[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__);

(statearr_20617[(1)] = (1));

return statearr_20617;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1 = (function (state_20611){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_20611);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e20618){if((e20618 instanceof Object)){
var ex__10142__auto__ = e20618;
var statearr_20619_20789 = state_20611;
(statearr_20619_20789[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20611);

return cljs.core.cst$kw$recur;
} else {
throw e20618;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__20790 = state_20611;
state_20611 = G__20790;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__ = function(state_20611){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1.call(this,state_20611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___20788,res,vec__20606,v,p,job,jobs,results))
})();
var state__10207__auto__ = (function (){var statearr_20620 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_20620[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___20788);

return statearr_20620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___20788,res,vec__20606,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__20621){
var vec__20622 = p__20621;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20622,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20622,(1),null);
var job = vec__20622;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__5472__auto___20791 = n;
var __20792 = (0);
while(true){
if((__20792 < n__5472__auto___20791)){
var G__20623_20793 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__20623_20793) {
case "compute":
var c__10205__auto___20795 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__20792,c__10205__auto___20795,G__20623_20793,n__5472__auto___20791,jobs,results,process,async){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (__20792,c__10205__auto___20795,G__20623_20793,n__5472__auto___20791,jobs,results,process,async){
return (function (state_20636){
var state_val_20637 = (state_20636[(1)]);
if((state_val_20637 === (1))){
var state_20636__$1 = state_20636;
var statearr_20638_20796 = state_20636__$1;
(statearr_20638_20796[(2)] = null);

(statearr_20638_20796[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20637 === (2))){
var state_20636__$1 = state_20636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20636__$1,(4),jobs);
} else {
if((state_val_20637 === (3))){
var inst_20634 = (state_20636[(2)]);
var state_20636__$1 = state_20636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20636__$1,inst_20634);
} else {
if((state_val_20637 === (4))){
var inst_20626 = (state_20636[(2)]);
var inst_20627 = process(inst_20626);
var state_20636__$1 = state_20636;
if(cljs.core.truth_(inst_20627)){
var statearr_20639_20797 = state_20636__$1;
(statearr_20639_20797[(1)] = (5));

} else {
var statearr_20640_20798 = state_20636__$1;
(statearr_20640_20798[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20637 === (5))){
var state_20636__$1 = state_20636;
var statearr_20641_20799 = state_20636__$1;
(statearr_20641_20799[(2)] = null);

(statearr_20641_20799[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20637 === (6))){
var state_20636__$1 = state_20636;
var statearr_20642_20800 = state_20636__$1;
(statearr_20642_20800[(2)] = null);

(statearr_20642_20800[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20637 === (7))){
var inst_20632 = (state_20636[(2)]);
var state_20636__$1 = state_20636;
var statearr_20643_20801 = state_20636__$1;
(statearr_20643_20801[(2)] = inst_20632);

(statearr_20643_20801[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__20792,c__10205__auto___20795,G__20623_20793,n__5472__auto___20791,jobs,results,process,async))
;
return ((function (__20792,switch__10138__auto__,c__10205__auto___20795,G__20623_20793,n__5472__auto___20791,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0 = (function (){
var statearr_20647 = [null,null,null,null,null,null,null];
(statearr_20647[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__);

(statearr_20647[(1)] = (1));

return statearr_20647;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1 = (function (state_20636){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_20636);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e20648){if((e20648 instanceof Object)){
var ex__10142__auto__ = e20648;
var statearr_20649_20802 = state_20636;
(statearr_20649_20802[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20636);

return cljs.core.cst$kw$recur;
} else {
throw e20648;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__20803 = state_20636;
state_20636 = G__20803;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__ = function(state_20636){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1.call(this,state_20636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__;
})()
;})(__20792,switch__10138__auto__,c__10205__auto___20795,G__20623_20793,n__5472__auto___20791,jobs,results,process,async))
})();
var state__10207__auto__ = (function (){var statearr_20650 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_20650[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___20795);

return statearr_20650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(__20792,c__10205__auto___20795,G__20623_20793,n__5472__auto___20791,jobs,results,process,async))
);


break;
case "async":
var c__10205__auto___20804 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__20792,c__10205__auto___20804,G__20623_20793,n__5472__auto___20791,jobs,results,process,async){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (__20792,c__10205__auto___20804,G__20623_20793,n__5472__auto___20791,jobs,results,process,async){
return (function (state_20663){
var state_val_20664 = (state_20663[(1)]);
if((state_val_20664 === (1))){
var state_20663__$1 = state_20663;
var statearr_20665_20805 = state_20663__$1;
(statearr_20665_20805[(2)] = null);

(statearr_20665_20805[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20664 === (2))){
var state_20663__$1 = state_20663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20663__$1,(4),jobs);
} else {
if((state_val_20664 === (3))){
var inst_20661 = (state_20663[(2)]);
var state_20663__$1 = state_20663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20663__$1,inst_20661);
} else {
if((state_val_20664 === (4))){
var inst_20653 = (state_20663[(2)]);
var inst_20654 = async(inst_20653);
var state_20663__$1 = state_20663;
if(cljs.core.truth_(inst_20654)){
var statearr_20666_20806 = state_20663__$1;
(statearr_20666_20806[(1)] = (5));

} else {
var statearr_20667_20807 = state_20663__$1;
(statearr_20667_20807[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20664 === (5))){
var state_20663__$1 = state_20663;
var statearr_20668_20808 = state_20663__$1;
(statearr_20668_20808[(2)] = null);

(statearr_20668_20808[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20664 === (6))){
var state_20663__$1 = state_20663;
var statearr_20669_20809 = state_20663__$1;
(statearr_20669_20809[(2)] = null);

(statearr_20669_20809[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20664 === (7))){
var inst_20659 = (state_20663[(2)]);
var state_20663__$1 = state_20663;
var statearr_20670_20810 = state_20663__$1;
(statearr_20670_20810[(2)] = inst_20659);

(statearr_20670_20810[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__20792,c__10205__auto___20804,G__20623_20793,n__5472__auto___20791,jobs,results,process,async))
;
return ((function (__20792,switch__10138__auto__,c__10205__auto___20804,G__20623_20793,n__5472__auto___20791,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0 = (function (){
var statearr_20674 = [null,null,null,null,null,null,null];
(statearr_20674[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__);

(statearr_20674[(1)] = (1));

return statearr_20674;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1 = (function (state_20663){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_20663);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e20675){if((e20675 instanceof Object)){
var ex__10142__auto__ = e20675;
var statearr_20676_20811 = state_20663;
(statearr_20676_20811[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20663);

return cljs.core.cst$kw$recur;
} else {
throw e20675;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__20812 = state_20663;
state_20663 = G__20812;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__ = function(state_20663){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1.call(this,state_20663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__;
})()
;})(__20792,switch__10138__auto__,c__10205__auto___20804,G__20623_20793,n__5472__auto___20791,jobs,results,process,async))
})();
var state__10207__auto__ = (function (){var statearr_20677 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_20677[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___20804);

return statearr_20677;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(__20792,c__10205__auto___20804,G__20623_20793,n__5472__auto___20791,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__20813 = (__20792 + (1));
__20792 = G__20813;
continue;
} else {
}
break;
}

var c__10205__auto___20814 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___20814,jobs,results,process,async){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___20814,jobs,results,process,async){
return (function (state_20699){
var state_val_20700 = (state_20699[(1)]);
if((state_val_20700 === (1))){
var state_20699__$1 = state_20699;
var statearr_20701_20815 = state_20699__$1;
(statearr_20701_20815[(2)] = null);

(statearr_20701_20815[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20700 === (2))){
var state_20699__$1 = state_20699;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20699__$1,(4),from);
} else {
if((state_val_20700 === (3))){
var inst_20697 = (state_20699[(2)]);
var state_20699__$1 = state_20699;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20699__$1,inst_20697);
} else {
if((state_val_20700 === (4))){
var inst_20680 = (state_20699[(7)]);
var inst_20680__$1 = (state_20699[(2)]);
var inst_20681 = (inst_20680__$1 == null);
var state_20699__$1 = (function (){var statearr_20702 = state_20699;
(statearr_20702[(7)] = inst_20680__$1);

return statearr_20702;
})();
if(cljs.core.truth_(inst_20681)){
var statearr_20703_20816 = state_20699__$1;
(statearr_20703_20816[(1)] = (5));

} else {
var statearr_20704_20817 = state_20699__$1;
(statearr_20704_20817[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20700 === (5))){
var inst_20683 = cljs.core.async.close_BANG_(jobs);
var state_20699__$1 = state_20699;
var statearr_20705_20818 = state_20699__$1;
(statearr_20705_20818[(2)] = inst_20683);

(statearr_20705_20818[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20700 === (6))){
var inst_20685 = (state_20699[(8)]);
var inst_20680 = (state_20699[(7)]);
var inst_20685__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_20686 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20687 = [inst_20680,inst_20685__$1];
var inst_20688 = (new cljs.core.PersistentVector(null,2,(5),inst_20686,inst_20687,null));
var state_20699__$1 = (function (){var statearr_20706 = state_20699;
(statearr_20706[(8)] = inst_20685__$1);

return statearr_20706;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20699__$1,(8),jobs,inst_20688);
} else {
if((state_val_20700 === (7))){
var inst_20695 = (state_20699[(2)]);
var state_20699__$1 = state_20699;
var statearr_20707_20819 = state_20699__$1;
(statearr_20707_20819[(2)] = inst_20695);

(statearr_20707_20819[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20700 === (8))){
var inst_20685 = (state_20699[(8)]);
var inst_20690 = (state_20699[(2)]);
var state_20699__$1 = (function (){var statearr_20708 = state_20699;
(statearr_20708[(9)] = inst_20690);

return statearr_20708;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20699__$1,(9),results,inst_20685);
} else {
if((state_val_20700 === (9))){
var inst_20692 = (state_20699[(2)]);
var state_20699__$1 = (function (){var statearr_20709 = state_20699;
(statearr_20709[(10)] = inst_20692);

return statearr_20709;
})();
var statearr_20710_20820 = state_20699__$1;
(statearr_20710_20820[(2)] = null);

(statearr_20710_20820[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__10205__auto___20814,jobs,results,process,async))
;
return ((function (switch__10138__auto__,c__10205__auto___20814,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0 = (function (){
var statearr_20714 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20714[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__);

(statearr_20714[(1)] = (1));

return statearr_20714;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1 = (function (state_20699){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_20699);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e20715){if((e20715 instanceof Object)){
var ex__10142__auto__ = e20715;
var statearr_20716_20821 = state_20699;
(statearr_20716_20821[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20699);

return cljs.core.cst$kw$recur;
} else {
throw e20715;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__20822 = state_20699;
state_20699 = G__20822;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__ = function(state_20699){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1.call(this,state_20699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___20814,jobs,results,process,async))
})();
var state__10207__auto__ = (function (){var statearr_20717 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_20717[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___20814);

return statearr_20717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___20814,jobs,results,process,async))
);


var c__10205__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto__,jobs,results,process,async){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto__,jobs,results,process,async){
return (function (state_20755){
var state_val_20756 = (state_20755[(1)]);
if((state_val_20756 === (7))){
var inst_20751 = (state_20755[(2)]);
var state_20755__$1 = state_20755;
var statearr_20757_20823 = state_20755__$1;
(statearr_20757_20823[(2)] = inst_20751);

(statearr_20757_20823[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (20))){
var state_20755__$1 = state_20755;
var statearr_20758_20824 = state_20755__$1;
(statearr_20758_20824[(2)] = null);

(statearr_20758_20824[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (1))){
var state_20755__$1 = state_20755;
var statearr_20759_20825 = state_20755__$1;
(statearr_20759_20825[(2)] = null);

(statearr_20759_20825[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (4))){
var inst_20720 = (state_20755[(7)]);
var inst_20720__$1 = (state_20755[(2)]);
var inst_20721 = (inst_20720__$1 == null);
var state_20755__$1 = (function (){var statearr_20760 = state_20755;
(statearr_20760[(7)] = inst_20720__$1);

return statearr_20760;
})();
if(cljs.core.truth_(inst_20721)){
var statearr_20761_20826 = state_20755__$1;
(statearr_20761_20826[(1)] = (5));

} else {
var statearr_20762_20827 = state_20755__$1;
(statearr_20762_20827[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (15))){
var inst_20733 = (state_20755[(8)]);
var state_20755__$1 = state_20755;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20755__$1,(18),to,inst_20733);
} else {
if((state_val_20756 === (21))){
var inst_20746 = (state_20755[(2)]);
var state_20755__$1 = state_20755;
var statearr_20763_20828 = state_20755__$1;
(statearr_20763_20828[(2)] = inst_20746);

(statearr_20763_20828[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (13))){
var inst_20748 = (state_20755[(2)]);
var state_20755__$1 = (function (){var statearr_20764 = state_20755;
(statearr_20764[(9)] = inst_20748);

return statearr_20764;
})();
var statearr_20765_20829 = state_20755__$1;
(statearr_20765_20829[(2)] = null);

(statearr_20765_20829[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (6))){
var inst_20720 = (state_20755[(7)]);
var state_20755__$1 = state_20755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20755__$1,(11),inst_20720);
} else {
if((state_val_20756 === (17))){
var inst_20741 = (state_20755[(2)]);
var state_20755__$1 = state_20755;
if(cljs.core.truth_(inst_20741)){
var statearr_20766_20830 = state_20755__$1;
(statearr_20766_20830[(1)] = (19));

} else {
var statearr_20767_20831 = state_20755__$1;
(statearr_20767_20831[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (3))){
var inst_20753 = (state_20755[(2)]);
var state_20755__$1 = state_20755;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20755__$1,inst_20753);
} else {
if((state_val_20756 === (12))){
var inst_20730 = (state_20755[(10)]);
var state_20755__$1 = state_20755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20755__$1,(14),inst_20730);
} else {
if((state_val_20756 === (2))){
var state_20755__$1 = state_20755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20755__$1,(4),results);
} else {
if((state_val_20756 === (19))){
var state_20755__$1 = state_20755;
var statearr_20768_20832 = state_20755__$1;
(statearr_20768_20832[(2)] = null);

(statearr_20768_20832[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (11))){
var inst_20730 = (state_20755[(2)]);
var state_20755__$1 = (function (){var statearr_20769 = state_20755;
(statearr_20769[(10)] = inst_20730);

return statearr_20769;
})();
var statearr_20770_20833 = state_20755__$1;
(statearr_20770_20833[(2)] = null);

(statearr_20770_20833[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (9))){
var state_20755__$1 = state_20755;
var statearr_20771_20834 = state_20755__$1;
(statearr_20771_20834[(2)] = null);

(statearr_20771_20834[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (5))){
var state_20755__$1 = state_20755;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20772_20835 = state_20755__$1;
(statearr_20772_20835[(1)] = (8));

} else {
var statearr_20773_20836 = state_20755__$1;
(statearr_20773_20836[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (14))){
var inst_20735 = (state_20755[(11)]);
var inst_20733 = (state_20755[(8)]);
var inst_20733__$1 = (state_20755[(2)]);
var inst_20734 = (inst_20733__$1 == null);
var inst_20735__$1 = cljs.core.not(inst_20734);
var state_20755__$1 = (function (){var statearr_20774 = state_20755;
(statearr_20774[(11)] = inst_20735__$1);

(statearr_20774[(8)] = inst_20733__$1);

return statearr_20774;
})();
if(inst_20735__$1){
var statearr_20775_20837 = state_20755__$1;
(statearr_20775_20837[(1)] = (15));

} else {
var statearr_20776_20838 = state_20755__$1;
(statearr_20776_20838[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (16))){
var inst_20735 = (state_20755[(11)]);
var state_20755__$1 = state_20755;
var statearr_20777_20839 = state_20755__$1;
(statearr_20777_20839[(2)] = inst_20735);

(statearr_20777_20839[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (10))){
var inst_20727 = (state_20755[(2)]);
var state_20755__$1 = state_20755;
var statearr_20778_20840 = state_20755__$1;
(statearr_20778_20840[(2)] = inst_20727);

(statearr_20778_20840[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (18))){
var inst_20738 = (state_20755[(2)]);
var state_20755__$1 = state_20755;
var statearr_20779_20841 = state_20755__$1;
(statearr_20779_20841[(2)] = inst_20738);

(statearr_20779_20841[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20756 === (8))){
var inst_20724 = cljs.core.async.close_BANG_(to);
var state_20755__$1 = state_20755;
var statearr_20780_20842 = state_20755__$1;
(statearr_20780_20842[(2)] = inst_20724);

(statearr_20780_20842[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto__,jobs,results,process,async))
;
return ((function (switch__10138__auto__,c__10205__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0 = (function (){
var statearr_20784 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20784[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__);

(statearr_20784[(1)] = (1));

return statearr_20784;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1 = (function (state_20755){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_20755);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e20785){if((e20785 instanceof Object)){
var ex__10142__auto__ = e20785;
var statearr_20786_20843 = state_20755;
(statearr_20786_20843[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20755);

return cljs.core.cst$kw$recur;
} else {
throw e20785;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__20844 = state_20755;
state_20755 = G__20844;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__ = function(state_20755){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1.call(this,state_20755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10139__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto__,jobs,results,process,async))
})();
var state__10207__auto__ = (function (){var statearr_20787 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_20787[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto__);

return statearr_20787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto__,jobs,results,process,async))
);

return c__10205__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args20845 = [];
var len__5627__auto___20848 = arguments.length;
var i__5628__auto___20849 = (0);
while(true){
if((i__5628__auto___20849 < len__5627__auto___20848)){
args20845.push((arguments[i__5628__auto___20849]));

var G__20850 = (i__5628__auto___20849 + (1));
i__5628__auto___20849 = G__20850;
continue;
} else {
}
break;
}

var G__20847 = args20845.length;
switch (G__20847) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20845.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args20852 = [];
var len__5627__auto___20855 = arguments.length;
var i__5628__auto___20856 = (0);
while(true){
if((i__5628__auto___20856 < len__5627__auto___20855)){
args20852.push((arguments[i__5628__auto___20856]));

var G__20857 = (i__5628__auto___20856 + (1));
i__5628__auto___20856 = G__20857;
continue;
} else {
}
break;
}

var G__20854 = args20852.length;
switch (G__20854) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20852.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args20859 = [];
var len__5627__auto___20912 = arguments.length;
var i__5628__auto___20913 = (0);
while(true){
if((i__5628__auto___20913 < len__5627__auto___20912)){
args20859.push((arguments[i__5628__auto___20913]));

var G__20914 = (i__5628__auto___20913 + (1));
i__5628__auto___20913 = G__20914;
continue;
} else {
}
break;
}

var G__20861 = args20859.length;
switch (G__20861) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20859.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__10205__auto___20916 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___20916,tc,fc){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___20916,tc,fc){
return (function (state_20887){
var state_val_20888 = (state_20887[(1)]);
if((state_val_20888 === (7))){
var inst_20883 = (state_20887[(2)]);
var state_20887__$1 = state_20887;
var statearr_20889_20917 = state_20887__$1;
(statearr_20889_20917[(2)] = inst_20883);

(statearr_20889_20917[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20888 === (1))){
var state_20887__$1 = state_20887;
var statearr_20890_20918 = state_20887__$1;
(statearr_20890_20918[(2)] = null);

(statearr_20890_20918[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20888 === (4))){
var inst_20864 = (state_20887[(7)]);
var inst_20864__$1 = (state_20887[(2)]);
var inst_20865 = (inst_20864__$1 == null);
var state_20887__$1 = (function (){var statearr_20891 = state_20887;
(statearr_20891[(7)] = inst_20864__$1);

return statearr_20891;
})();
if(cljs.core.truth_(inst_20865)){
var statearr_20892_20919 = state_20887__$1;
(statearr_20892_20919[(1)] = (5));

} else {
var statearr_20893_20920 = state_20887__$1;
(statearr_20893_20920[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20888 === (13))){
var state_20887__$1 = state_20887;
var statearr_20894_20921 = state_20887__$1;
(statearr_20894_20921[(2)] = null);

(statearr_20894_20921[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20888 === (6))){
var inst_20864 = (state_20887[(7)]);
var inst_20870 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_20864) : p.call(null,inst_20864));
var state_20887__$1 = state_20887;
if(cljs.core.truth_(inst_20870)){
var statearr_20895_20922 = state_20887__$1;
(statearr_20895_20922[(1)] = (9));

} else {
var statearr_20896_20923 = state_20887__$1;
(statearr_20896_20923[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20888 === (3))){
var inst_20885 = (state_20887[(2)]);
var state_20887__$1 = state_20887;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20887__$1,inst_20885);
} else {
if((state_val_20888 === (12))){
var state_20887__$1 = state_20887;
var statearr_20897_20924 = state_20887__$1;
(statearr_20897_20924[(2)] = null);

(statearr_20897_20924[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20888 === (2))){
var state_20887__$1 = state_20887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20887__$1,(4),ch);
} else {
if((state_val_20888 === (11))){
var inst_20864 = (state_20887[(7)]);
var inst_20874 = (state_20887[(2)]);
var state_20887__$1 = state_20887;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20887__$1,(8),inst_20874,inst_20864);
} else {
if((state_val_20888 === (9))){
var state_20887__$1 = state_20887;
var statearr_20898_20925 = state_20887__$1;
(statearr_20898_20925[(2)] = tc);

(statearr_20898_20925[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20888 === (5))){
var inst_20867 = cljs.core.async.close_BANG_(tc);
var inst_20868 = cljs.core.async.close_BANG_(fc);
var state_20887__$1 = (function (){var statearr_20899 = state_20887;
(statearr_20899[(8)] = inst_20867);

return statearr_20899;
})();
var statearr_20900_20926 = state_20887__$1;
(statearr_20900_20926[(2)] = inst_20868);

(statearr_20900_20926[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20888 === (14))){
var inst_20881 = (state_20887[(2)]);
var state_20887__$1 = state_20887;
var statearr_20901_20927 = state_20887__$1;
(statearr_20901_20927[(2)] = inst_20881);

(statearr_20901_20927[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20888 === (10))){
var state_20887__$1 = state_20887;
var statearr_20902_20928 = state_20887__$1;
(statearr_20902_20928[(2)] = fc);

(statearr_20902_20928[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20888 === (8))){
var inst_20876 = (state_20887[(2)]);
var state_20887__$1 = state_20887;
if(cljs.core.truth_(inst_20876)){
var statearr_20903_20929 = state_20887__$1;
(statearr_20903_20929[(1)] = (12));

} else {
var statearr_20904_20930 = state_20887__$1;
(statearr_20904_20930[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto___20916,tc,fc))
;
return ((function (switch__10138__auto__,c__10205__auto___20916,tc,fc){
return (function() {
var cljs$core$async$state_machine__10139__auto__ = null;
var cljs$core$async$state_machine__10139__auto____0 = (function (){
var statearr_20908 = [null,null,null,null,null,null,null,null,null];
(statearr_20908[(0)] = cljs$core$async$state_machine__10139__auto__);

(statearr_20908[(1)] = (1));

return statearr_20908;
});
var cljs$core$async$state_machine__10139__auto____1 = (function (state_20887){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_20887);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e20909){if((e20909 instanceof Object)){
var ex__10142__auto__ = e20909;
var statearr_20910_20931 = state_20887;
(statearr_20910_20931[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20887);

return cljs.core.cst$kw$recur;
} else {
throw e20909;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__20932 = state_20887;
state_20887 = G__20932;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$state_machine__10139__auto__ = function(state_20887){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10139__auto____1.call(this,state_20887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10139__auto____0;
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10139__auto____1;
return cljs$core$async$state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___20916,tc,fc))
})();
var state__10207__auto__ = (function (){var statearr_20911 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_20911[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___20916);

return statearr_20911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___20916,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__10205__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto__){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto__){
return (function (state_20979){
var state_val_20980 = (state_20979[(1)]);
if((state_val_20980 === (1))){
var inst_20965 = init;
var state_20979__$1 = (function (){var statearr_20981 = state_20979;
(statearr_20981[(7)] = inst_20965);

return statearr_20981;
})();
var statearr_20982_20997 = state_20979__$1;
(statearr_20982_20997[(2)] = null);

(statearr_20982_20997[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20980 === (2))){
var state_20979__$1 = state_20979;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20979__$1,(4),ch);
} else {
if((state_val_20980 === (3))){
var inst_20977 = (state_20979[(2)]);
var state_20979__$1 = state_20979;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20979__$1,inst_20977);
} else {
if((state_val_20980 === (4))){
var inst_20968 = (state_20979[(8)]);
var inst_20968__$1 = (state_20979[(2)]);
var inst_20969 = (inst_20968__$1 == null);
var state_20979__$1 = (function (){var statearr_20983 = state_20979;
(statearr_20983[(8)] = inst_20968__$1);

return statearr_20983;
})();
if(cljs.core.truth_(inst_20969)){
var statearr_20984_20998 = state_20979__$1;
(statearr_20984_20998[(1)] = (5));

} else {
var statearr_20985_20999 = state_20979__$1;
(statearr_20985_20999[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20980 === (5))){
var inst_20965 = (state_20979[(7)]);
var state_20979__$1 = state_20979;
var statearr_20986_21000 = state_20979__$1;
(statearr_20986_21000[(2)] = inst_20965);

(statearr_20986_21000[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20980 === (6))){
var inst_20968 = (state_20979[(8)]);
var inst_20965 = (state_20979[(7)]);
var inst_20972 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_20965,inst_20968) : f.call(null,inst_20965,inst_20968));
var inst_20965__$1 = inst_20972;
var state_20979__$1 = (function (){var statearr_20987 = state_20979;
(statearr_20987[(7)] = inst_20965__$1);

return statearr_20987;
})();
var statearr_20988_21001 = state_20979__$1;
(statearr_20988_21001[(2)] = null);

(statearr_20988_21001[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20980 === (7))){
var inst_20975 = (state_20979[(2)]);
var state_20979__$1 = state_20979;
var statearr_20989_21002 = state_20979__$1;
(statearr_20989_21002[(2)] = inst_20975);

(statearr_20989_21002[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__10205__auto__))
;
return ((function (switch__10138__auto__,c__10205__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10139__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10139__auto____0 = (function (){
var statearr_20993 = [null,null,null,null,null,null,null,null,null];
(statearr_20993[(0)] = cljs$core$async$reduce_$_state_machine__10139__auto__);

(statearr_20993[(1)] = (1));

return statearr_20993;
});
var cljs$core$async$reduce_$_state_machine__10139__auto____1 = (function (state_20979){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_20979);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e20994){if((e20994 instanceof Object)){
var ex__10142__auto__ = e20994;
var statearr_20995_21003 = state_20979;
(statearr_20995_21003[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20979);

return cljs.core.cst$kw$recur;
} else {
throw e20994;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__21004 = state_20979;
state_20979 = G__21004;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10139__auto__ = function(state_20979){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10139__auto____1.call(this,state_20979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10139__auto____0;
cljs$core$async$reduce_$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10139__auto____1;
return cljs$core$async$reduce_$_state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto__))
})();
var state__10207__auto__ = (function (){var statearr_20996 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_20996[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto__);

return statearr_20996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto__))
);

return c__10205__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args21005 = [];
var len__5627__auto___21057 = arguments.length;
var i__5628__auto___21058 = (0);
while(true){
if((i__5628__auto___21058 < len__5627__auto___21057)){
args21005.push((arguments[i__5628__auto___21058]));

var G__21059 = (i__5628__auto___21058 + (1));
i__5628__auto___21058 = G__21059;
continue;
} else {
}
break;
}

var G__21007 = args21005.length;
switch (G__21007) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21005.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__10205__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto__){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto__){
return (function (state_21032){
var state_val_21033 = (state_21032[(1)]);
if((state_val_21033 === (7))){
var inst_21014 = (state_21032[(2)]);
var state_21032__$1 = state_21032;
var statearr_21034_21061 = state_21032__$1;
(statearr_21034_21061[(2)] = inst_21014);

(statearr_21034_21061[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21033 === (1))){
var inst_21008 = cljs.core.seq(coll);
var inst_21009 = inst_21008;
var state_21032__$1 = (function (){var statearr_21035 = state_21032;
(statearr_21035[(7)] = inst_21009);

return statearr_21035;
})();
var statearr_21036_21062 = state_21032__$1;
(statearr_21036_21062[(2)] = null);

(statearr_21036_21062[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21033 === (4))){
var inst_21009 = (state_21032[(7)]);
var inst_21012 = cljs.core.first(inst_21009);
var state_21032__$1 = state_21032;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21032__$1,(7),ch,inst_21012);
} else {
if((state_val_21033 === (13))){
var inst_21026 = (state_21032[(2)]);
var state_21032__$1 = state_21032;
var statearr_21037_21063 = state_21032__$1;
(statearr_21037_21063[(2)] = inst_21026);

(statearr_21037_21063[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21033 === (6))){
var inst_21017 = (state_21032[(2)]);
var state_21032__$1 = state_21032;
if(cljs.core.truth_(inst_21017)){
var statearr_21038_21064 = state_21032__$1;
(statearr_21038_21064[(1)] = (8));

} else {
var statearr_21039_21065 = state_21032__$1;
(statearr_21039_21065[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21033 === (3))){
var inst_21030 = (state_21032[(2)]);
var state_21032__$1 = state_21032;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21032__$1,inst_21030);
} else {
if((state_val_21033 === (12))){
var state_21032__$1 = state_21032;
var statearr_21040_21066 = state_21032__$1;
(statearr_21040_21066[(2)] = null);

(statearr_21040_21066[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21033 === (2))){
var inst_21009 = (state_21032[(7)]);
var state_21032__$1 = state_21032;
if(cljs.core.truth_(inst_21009)){
var statearr_21041_21067 = state_21032__$1;
(statearr_21041_21067[(1)] = (4));

} else {
var statearr_21042_21068 = state_21032__$1;
(statearr_21042_21068[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21033 === (11))){
var inst_21023 = cljs.core.async.close_BANG_(ch);
var state_21032__$1 = state_21032;
var statearr_21043_21069 = state_21032__$1;
(statearr_21043_21069[(2)] = inst_21023);

(statearr_21043_21069[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21033 === (9))){
var state_21032__$1 = state_21032;
if(cljs.core.truth_(close_QMARK_)){
var statearr_21044_21070 = state_21032__$1;
(statearr_21044_21070[(1)] = (11));

} else {
var statearr_21045_21071 = state_21032__$1;
(statearr_21045_21071[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21033 === (5))){
var inst_21009 = (state_21032[(7)]);
var state_21032__$1 = state_21032;
var statearr_21046_21072 = state_21032__$1;
(statearr_21046_21072[(2)] = inst_21009);

(statearr_21046_21072[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21033 === (10))){
var inst_21028 = (state_21032[(2)]);
var state_21032__$1 = state_21032;
var statearr_21047_21073 = state_21032__$1;
(statearr_21047_21073[(2)] = inst_21028);

(statearr_21047_21073[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21033 === (8))){
var inst_21009 = (state_21032[(7)]);
var inst_21019 = cljs.core.next(inst_21009);
var inst_21009__$1 = inst_21019;
var state_21032__$1 = (function (){var statearr_21048 = state_21032;
(statearr_21048[(7)] = inst_21009__$1);

return statearr_21048;
})();
var statearr_21049_21074 = state_21032__$1;
(statearr_21049_21074[(2)] = null);

(statearr_21049_21074[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto__))
;
return ((function (switch__10138__auto__,c__10205__auto__){
return (function() {
var cljs$core$async$state_machine__10139__auto__ = null;
var cljs$core$async$state_machine__10139__auto____0 = (function (){
var statearr_21053 = [null,null,null,null,null,null,null,null];
(statearr_21053[(0)] = cljs$core$async$state_machine__10139__auto__);

(statearr_21053[(1)] = (1));

return statearr_21053;
});
var cljs$core$async$state_machine__10139__auto____1 = (function (state_21032){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_21032);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e21054){if((e21054 instanceof Object)){
var ex__10142__auto__ = e21054;
var statearr_21055_21075 = state_21032;
(statearr_21055_21075[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_21032);

return cljs.core.cst$kw$recur;
} else {
throw e21054;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__21076 = state_21032;
state_21032 = G__21076;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$state_machine__10139__auto__ = function(state_21032){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10139__auto____1.call(this,state_21032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10139__auto____0;
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10139__auto____1;
return cljs$core$async$state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto__))
})();
var state__10207__auto__ = (function (){var statearr_21056 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_21056[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto__);

return statearr_21056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto__))
);

return c__10205__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5224__auto__ = (((_ == null))?null:_);
var m__5225__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5225__auto__.call(null,_));
} else {
var m__5225__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__5225__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5225__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5225__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5225__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto__.call(null,m));
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__21301 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__21301) : cljs.core.atom.call(null,G__21301));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async21302 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21302 = (function (mult,ch,cs,meta21303){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta21303 = meta21303;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21302.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_21304,meta21303__$1){
var self__ = this;
var _21304__$1 = this;
return (new cljs.core.async.t_cljs$core$async21302(self__.mult,self__.ch,self__.cs,meta21303__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async21302.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_21304){
var self__ = this;
var _21304__$1 = this;
return self__.meta21303;
});})(cs))
;

cljs.core.async.t_cljs$core$async21302.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async21302.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async21302.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async21302.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21302.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21302.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__21305_21525 = self__.cs;
var G__21306_21526 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__21305_21525,G__21306_21526) : cljs.core.reset_BANG_.call(null,G__21305_21525,G__21306_21526));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21302.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta21303], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async21302.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21302.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21302";

cljs.core.async.t_cljs$core$async21302.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async21302");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async21302 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async21302(mult__$1,ch__$1,cs__$1,meta21303){
return (new cljs.core.async.t_cljs$core$async21302(mult__$1,ch__$1,cs__$1,meta21303));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async21302(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__10205__auto___21527 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___21527,cs,m,dchan,dctr,done){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___21527,cs,m,dchan,dctr,done){
return (function (state_21437){
var state_val_21438 = (state_21437[(1)]);
if((state_val_21438 === (7))){
var inst_21433 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
var statearr_21439_21528 = state_21437__$1;
(statearr_21439_21528[(2)] = inst_21433);

(statearr_21439_21528[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (20))){
var inst_21338 = (state_21437[(7)]);
var inst_21348 = cljs.core.first(inst_21338);
var inst_21349 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21348,(0),null);
var inst_21350 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21348,(1),null);
var state_21437__$1 = (function (){var statearr_21440 = state_21437;
(statearr_21440[(8)] = inst_21349);

return statearr_21440;
})();
if(cljs.core.truth_(inst_21350)){
var statearr_21441_21529 = state_21437__$1;
(statearr_21441_21529[(1)] = (22));

} else {
var statearr_21442_21530 = state_21437__$1;
(statearr_21442_21530[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (27))){
var inst_21380 = (state_21437[(9)]);
var inst_21385 = (state_21437[(10)]);
var inst_21309 = (state_21437[(11)]);
var inst_21378 = (state_21437[(12)]);
var inst_21385__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_21378,inst_21380);
var inst_21386 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_21385__$1,inst_21309,done);
var state_21437__$1 = (function (){var statearr_21443 = state_21437;
(statearr_21443[(10)] = inst_21385__$1);

return statearr_21443;
})();
if(cljs.core.truth_(inst_21386)){
var statearr_21444_21531 = state_21437__$1;
(statearr_21444_21531[(1)] = (30));

} else {
var statearr_21445_21532 = state_21437__$1;
(statearr_21445_21532[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (1))){
var state_21437__$1 = state_21437;
var statearr_21446_21533 = state_21437__$1;
(statearr_21446_21533[(2)] = null);

(statearr_21446_21533[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (24))){
var inst_21338 = (state_21437[(7)]);
var inst_21355 = (state_21437[(2)]);
var inst_21356 = cljs.core.next(inst_21338);
var inst_21318 = inst_21356;
var inst_21319 = null;
var inst_21320 = (0);
var inst_21321 = (0);
var state_21437__$1 = (function (){var statearr_21447 = state_21437;
(statearr_21447[(13)] = inst_21319);

(statearr_21447[(14)] = inst_21321);

(statearr_21447[(15)] = inst_21320);

(statearr_21447[(16)] = inst_21318);

(statearr_21447[(17)] = inst_21355);

return statearr_21447;
})();
var statearr_21448_21534 = state_21437__$1;
(statearr_21448_21534[(2)] = null);

(statearr_21448_21534[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (39))){
var state_21437__$1 = state_21437;
var statearr_21452_21535 = state_21437__$1;
(statearr_21452_21535[(2)] = null);

(statearr_21452_21535[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (4))){
var inst_21309 = (state_21437[(11)]);
var inst_21309__$1 = (state_21437[(2)]);
var inst_21310 = (inst_21309__$1 == null);
var state_21437__$1 = (function (){var statearr_21453 = state_21437;
(statearr_21453[(11)] = inst_21309__$1);

return statearr_21453;
})();
if(cljs.core.truth_(inst_21310)){
var statearr_21454_21536 = state_21437__$1;
(statearr_21454_21536[(1)] = (5));

} else {
var statearr_21455_21537 = state_21437__$1;
(statearr_21455_21537[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (15))){
var inst_21319 = (state_21437[(13)]);
var inst_21321 = (state_21437[(14)]);
var inst_21320 = (state_21437[(15)]);
var inst_21318 = (state_21437[(16)]);
var inst_21334 = (state_21437[(2)]);
var inst_21335 = (inst_21321 + (1));
var tmp21449 = inst_21319;
var tmp21450 = inst_21320;
var tmp21451 = inst_21318;
var inst_21318__$1 = tmp21451;
var inst_21319__$1 = tmp21449;
var inst_21320__$1 = tmp21450;
var inst_21321__$1 = inst_21335;
var state_21437__$1 = (function (){var statearr_21456 = state_21437;
(statearr_21456[(13)] = inst_21319__$1);

(statearr_21456[(14)] = inst_21321__$1);

(statearr_21456[(15)] = inst_21320__$1);

(statearr_21456[(16)] = inst_21318__$1);

(statearr_21456[(18)] = inst_21334);

return statearr_21456;
})();
var statearr_21457_21538 = state_21437__$1;
(statearr_21457_21538[(2)] = null);

(statearr_21457_21538[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (21))){
var inst_21359 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
var statearr_21461_21539 = state_21437__$1;
(statearr_21461_21539[(2)] = inst_21359);

(statearr_21461_21539[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (31))){
var inst_21385 = (state_21437[(10)]);
var inst_21389 = done(null);
var inst_21390 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_21385);
var state_21437__$1 = (function (){var statearr_21462 = state_21437;
(statearr_21462[(19)] = inst_21389);

return statearr_21462;
})();
var statearr_21463_21540 = state_21437__$1;
(statearr_21463_21540[(2)] = inst_21390);

(statearr_21463_21540[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (32))){
var inst_21379 = (state_21437[(20)]);
var inst_21380 = (state_21437[(9)]);
var inst_21378 = (state_21437[(12)]);
var inst_21377 = (state_21437[(21)]);
var inst_21392 = (state_21437[(2)]);
var inst_21393 = (inst_21380 + (1));
var tmp21458 = inst_21379;
var tmp21459 = inst_21378;
var tmp21460 = inst_21377;
var inst_21377__$1 = tmp21460;
var inst_21378__$1 = tmp21459;
var inst_21379__$1 = tmp21458;
var inst_21380__$1 = inst_21393;
var state_21437__$1 = (function (){var statearr_21464 = state_21437;
(statearr_21464[(20)] = inst_21379__$1);

(statearr_21464[(9)] = inst_21380__$1);

(statearr_21464[(22)] = inst_21392);

(statearr_21464[(12)] = inst_21378__$1);

(statearr_21464[(21)] = inst_21377__$1);

return statearr_21464;
})();
var statearr_21465_21541 = state_21437__$1;
(statearr_21465_21541[(2)] = null);

(statearr_21465_21541[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (40))){
var inst_21405 = (state_21437[(23)]);
var inst_21409 = done(null);
var inst_21410 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_21405);
var state_21437__$1 = (function (){var statearr_21466 = state_21437;
(statearr_21466[(24)] = inst_21409);

return statearr_21466;
})();
var statearr_21467_21542 = state_21437__$1;
(statearr_21467_21542[(2)] = inst_21410);

(statearr_21467_21542[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (33))){
var inst_21396 = (state_21437[(25)]);
var inst_21398 = cljs.core.chunked_seq_QMARK_(inst_21396);
var state_21437__$1 = state_21437;
if(inst_21398){
var statearr_21468_21543 = state_21437__$1;
(statearr_21468_21543[(1)] = (36));

} else {
var statearr_21469_21544 = state_21437__$1;
(statearr_21469_21544[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (13))){
var inst_21328 = (state_21437[(26)]);
var inst_21331 = cljs.core.async.close_BANG_(inst_21328);
var state_21437__$1 = state_21437;
var statearr_21470_21545 = state_21437__$1;
(statearr_21470_21545[(2)] = inst_21331);

(statearr_21470_21545[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (22))){
var inst_21349 = (state_21437[(8)]);
var inst_21352 = cljs.core.async.close_BANG_(inst_21349);
var state_21437__$1 = state_21437;
var statearr_21471_21546 = state_21437__$1;
(statearr_21471_21546[(2)] = inst_21352);

(statearr_21471_21546[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (36))){
var inst_21396 = (state_21437[(25)]);
var inst_21400 = cljs.core.chunk_first(inst_21396);
var inst_21401 = cljs.core.chunk_rest(inst_21396);
var inst_21402 = cljs.core.count(inst_21400);
var inst_21377 = inst_21401;
var inst_21378 = inst_21400;
var inst_21379 = inst_21402;
var inst_21380 = (0);
var state_21437__$1 = (function (){var statearr_21472 = state_21437;
(statearr_21472[(20)] = inst_21379);

(statearr_21472[(9)] = inst_21380);

(statearr_21472[(12)] = inst_21378);

(statearr_21472[(21)] = inst_21377);

return statearr_21472;
})();
var statearr_21473_21547 = state_21437__$1;
(statearr_21473_21547[(2)] = null);

(statearr_21473_21547[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (41))){
var inst_21396 = (state_21437[(25)]);
var inst_21412 = (state_21437[(2)]);
var inst_21413 = cljs.core.next(inst_21396);
var inst_21377 = inst_21413;
var inst_21378 = null;
var inst_21379 = (0);
var inst_21380 = (0);
var state_21437__$1 = (function (){var statearr_21474 = state_21437;
(statearr_21474[(20)] = inst_21379);

(statearr_21474[(9)] = inst_21380);

(statearr_21474[(27)] = inst_21412);

(statearr_21474[(12)] = inst_21378);

(statearr_21474[(21)] = inst_21377);

return statearr_21474;
})();
var statearr_21475_21548 = state_21437__$1;
(statearr_21475_21548[(2)] = null);

(statearr_21475_21548[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (43))){
var state_21437__$1 = state_21437;
var statearr_21476_21549 = state_21437__$1;
(statearr_21476_21549[(2)] = null);

(statearr_21476_21549[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (29))){
var inst_21421 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
var statearr_21477_21550 = state_21437__$1;
(statearr_21477_21550[(2)] = inst_21421);

(statearr_21477_21550[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (44))){
var inst_21430 = (state_21437[(2)]);
var state_21437__$1 = (function (){var statearr_21478 = state_21437;
(statearr_21478[(28)] = inst_21430);

return statearr_21478;
})();
var statearr_21479_21551 = state_21437__$1;
(statearr_21479_21551[(2)] = null);

(statearr_21479_21551[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (6))){
var inst_21369 = (state_21437[(29)]);
var inst_21368 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_21369__$1 = cljs.core.keys(inst_21368);
var inst_21370 = cljs.core.count(inst_21369__$1);
var inst_21371 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_21370) : cljs.core.reset_BANG_.call(null,dctr,inst_21370));
var inst_21376 = cljs.core.seq(inst_21369__$1);
var inst_21377 = inst_21376;
var inst_21378 = null;
var inst_21379 = (0);
var inst_21380 = (0);
var state_21437__$1 = (function (){var statearr_21480 = state_21437;
(statearr_21480[(30)] = inst_21371);

(statearr_21480[(20)] = inst_21379);

(statearr_21480[(9)] = inst_21380);

(statearr_21480[(29)] = inst_21369__$1);

(statearr_21480[(12)] = inst_21378);

(statearr_21480[(21)] = inst_21377);

return statearr_21480;
})();
var statearr_21481_21552 = state_21437__$1;
(statearr_21481_21552[(2)] = null);

(statearr_21481_21552[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (28))){
var inst_21396 = (state_21437[(25)]);
var inst_21377 = (state_21437[(21)]);
var inst_21396__$1 = cljs.core.seq(inst_21377);
var state_21437__$1 = (function (){var statearr_21482 = state_21437;
(statearr_21482[(25)] = inst_21396__$1);

return statearr_21482;
})();
if(inst_21396__$1){
var statearr_21483_21553 = state_21437__$1;
(statearr_21483_21553[(1)] = (33));

} else {
var statearr_21484_21554 = state_21437__$1;
(statearr_21484_21554[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (25))){
var inst_21379 = (state_21437[(20)]);
var inst_21380 = (state_21437[(9)]);
var inst_21382 = (inst_21380 < inst_21379);
var inst_21383 = inst_21382;
var state_21437__$1 = state_21437;
if(cljs.core.truth_(inst_21383)){
var statearr_21485_21555 = state_21437__$1;
(statearr_21485_21555[(1)] = (27));

} else {
var statearr_21486_21556 = state_21437__$1;
(statearr_21486_21556[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (34))){
var state_21437__$1 = state_21437;
var statearr_21487_21557 = state_21437__$1;
(statearr_21487_21557[(2)] = null);

(statearr_21487_21557[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (17))){
var state_21437__$1 = state_21437;
var statearr_21488_21558 = state_21437__$1;
(statearr_21488_21558[(2)] = null);

(statearr_21488_21558[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (3))){
var inst_21435 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21437__$1,inst_21435);
} else {
if((state_val_21438 === (12))){
var inst_21364 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
var statearr_21489_21559 = state_21437__$1;
(statearr_21489_21559[(2)] = inst_21364);

(statearr_21489_21559[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (2))){
var state_21437__$1 = state_21437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21437__$1,(4),ch);
} else {
if((state_val_21438 === (23))){
var state_21437__$1 = state_21437;
var statearr_21490_21560 = state_21437__$1;
(statearr_21490_21560[(2)] = null);

(statearr_21490_21560[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (35))){
var inst_21419 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
var statearr_21491_21561 = state_21437__$1;
(statearr_21491_21561[(2)] = inst_21419);

(statearr_21491_21561[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (19))){
var inst_21338 = (state_21437[(7)]);
var inst_21342 = cljs.core.chunk_first(inst_21338);
var inst_21343 = cljs.core.chunk_rest(inst_21338);
var inst_21344 = cljs.core.count(inst_21342);
var inst_21318 = inst_21343;
var inst_21319 = inst_21342;
var inst_21320 = inst_21344;
var inst_21321 = (0);
var state_21437__$1 = (function (){var statearr_21492 = state_21437;
(statearr_21492[(13)] = inst_21319);

(statearr_21492[(14)] = inst_21321);

(statearr_21492[(15)] = inst_21320);

(statearr_21492[(16)] = inst_21318);

return statearr_21492;
})();
var statearr_21493_21562 = state_21437__$1;
(statearr_21493_21562[(2)] = null);

(statearr_21493_21562[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (11))){
var inst_21338 = (state_21437[(7)]);
var inst_21318 = (state_21437[(16)]);
var inst_21338__$1 = cljs.core.seq(inst_21318);
var state_21437__$1 = (function (){var statearr_21494 = state_21437;
(statearr_21494[(7)] = inst_21338__$1);

return statearr_21494;
})();
if(inst_21338__$1){
var statearr_21495_21563 = state_21437__$1;
(statearr_21495_21563[(1)] = (16));

} else {
var statearr_21496_21564 = state_21437__$1;
(statearr_21496_21564[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (9))){
var inst_21366 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
var statearr_21497_21565 = state_21437__$1;
(statearr_21497_21565[(2)] = inst_21366);

(statearr_21497_21565[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (5))){
var inst_21316 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_21317 = cljs.core.seq(inst_21316);
var inst_21318 = inst_21317;
var inst_21319 = null;
var inst_21320 = (0);
var inst_21321 = (0);
var state_21437__$1 = (function (){var statearr_21498 = state_21437;
(statearr_21498[(13)] = inst_21319);

(statearr_21498[(14)] = inst_21321);

(statearr_21498[(15)] = inst_21320);

(statearr_21498[(16)] = inst_21318);

return statearr_21498;
})();
var statearr_21499_21566 = state_21437__$1;
(statearr_21499_21566[(2)] = null);

(statearr_21499_21566[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (14))){
var state_21437__$1 = state_21437;
var statearr_21500_21567 = state_21437__$1;
(statearr_21500_21567[(2)] = null);

(statearr_21500_21567[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (45))){
var inst_21427 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
var statearr_21501_21568 = state_21437__$1;
(statearr_21501_21568[(2)] = inst_21427);

(statearr_21501_21568[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (26))){
var inst_21369 = (state_21437[(29)]);
var inst_21423 = (state_21437[(2)]);
var inst_21424 = cljs.core.seq(inst_21369);
var state_21437__$1 = (function (){var statearr_21502 = state_21437;
(statearr_21502[(31)] = inst_21423);

return statearr_21502;
})();
if(inst_21424){
var statearr_21503_21569 = state_21437__$1;
(statearr_21503_21569[(1)] = (42));

} else {
var statearr_21504_21570 = state_21437__$1;
(statearr_21504_21570[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (16))){
var inst_21338 = (state_21437[(7)]);
var inst_21340 = cljs.core.chunked_seq_QMARK_(inst_21338);
var state_21437__$1 = state_21437;
if(inst_21340){
var statearr_21505_21571 = state_21437__$1;
(statearr_21505_21571[(1)] = (19));

} else {
var statearr_21506_21572 = state_21437__$1;
(statearr_21506_21572[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (38))){
var inst_21416 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
var statearr_21507_21573 = state_21437__$1;
(statearr_21507_21573[(2)] = inst_21416);

(statearr_21507_21573[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (30))){
var state_21437__$1 = state_21437;
var statearr_21508_21574 = state_21437__$1;
(statearr_21508_21574[(2)] = null);

(statearr_21508_21574[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (10))){
var inst_21319 = (state_21437[(13)]);
var inst_21321 = (state_21437[(14)]);
var inst_21327 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_21319,inst_21321);
var inst_21328 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21327,(0),null);
var inst_21329 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21327,(1),null);
var state_21437__$1 = (function (){var statearr_21509 = state_21437;
(statearr_21509[(26)] = inst_21328);

return statearr_21509;
})();
if(cljs.core.truth_(inst_21329)){
var statearr_21510_21575 = state_21437__$1;
(statearr_21510_21575[(1)] = (13));

} else {
var statearr_21511_21576 = state_21437__$1;
(statearr_21511_21576[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (18))){
var inst_21362 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
var statearr_21512_21577 = state_21437__$1;
(statearr_21512_21577[(2)] = inst_21362);

(statearr_21512_21577[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (42))){
var state_21437__$1 = state_21437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21437__$1,(45),dchan);
} else {
if((state_val_21438 === (37))){
var inst_21309 = (state_21437[(11)]);
var inst_21405 = (state_21437[(23)]);
var inst_21396 = (state_21437[(25)]);
var inst_21405__$1 = cljs.core.first(inst_21396);
var inst_21406 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_21405__$1,inst_21309,done);
var state_21437__$1 = (function (){var statearr_21513 = state_21437;
(statearr_21513[(23)] = inst_21405__$1);

return statearr_21513;
})();
if(cljs.core.truth_(inst_21406)){
var statearr_21514_21578 = state_21437__$1;
(statearr_21514_21578[(1)] = (39));

} else {
var statearr_21515_21579 = state_21437__$1;
(statearr_21515_21579[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21438 === (8))){
var inst_21321 = (state_21437[(14)]);
var inst_21320 = (state_21437[(15)]);
var inst_21323 = (inst_21321 < inst_21320);
var inst_21324 = inst_21323;
var state_21437__$1 = state_21437;
if(cljs.core.truth_(inst_21324)){
var statearr_21516_21580 = state_21437__$1;
(statearr_21516_21580[(1)] = (10));

} else {
var statearr_21517_21581 = state_21437__$1;
(statearr_21517_21581[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto___21527,cs,m,dchan,dctr,done))
;
return ((function (switch__10138__auto__,c__10205__auto___21527,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10139__auto__ = null;
var cljs$core$async$mult_$_state_machine__10139__auto____0 = (function (){
var statearr_21521 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21521[(0)] = cljs$core$async$mult_$_state_machine__10139__auto__);

(statearr_21521[(1)] = (1));

return statearr_21521;
});
var cljs$core$async$mult_$_state_machine__10139__auto____1 = (function (state_21437){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_21437);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e21522){if((e21522 instanceof Object)){
var ex__10142__auto__ = e21522;
var statearr_21523_21582 = state_21437;
(statearr_21523_21582[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_21437);

return cljs.core.cst$kw$recur;
} else {
throw e21522;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__21583 = state_21437;
state_21437 = G__21583;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10139__auto__ = function(state_21437){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10139__auto____1.call(this,state_21437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10139__auto____0;
cljs$core$async$mult_$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10139__auto____1;
return cljs$core$async$mult_$_state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___21527,cs,m,dchan,dctr,done))
})();
var state__10207__auto__ = (function (){var statearr_21524 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_21524[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___21527);

return statearr_21524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___21527,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args21584 = [];
var len__5627__auto___21587 = arguments.length;
var i__5628__auto___21588 = (0);
while(true){
if((i__5628__auto___21588 < len__5627__auto___21587)){
args21584.push((arguments[i__5628__auto___21588]));

var G__21589 = (i__5628__auto___21588 + (1));
i__5628__auto___21588 = G__21589;
continue;
} else {
}
break;
}

var G__21586 = args21584.length;
switch (G__21586) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21584.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto__.call(null,m));
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5225__auto__.call(null,m,state_map));
} else {
var m__5225__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5225__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5225__auto__.call(null,m,mode));
} else {
var m__5225__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5225__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___21601 = arguments.length;
var i__5628__auto___21602 = (0);
while(true){
if((i__5628__auto___21602 < len__5627__auto___21601)){
args__5634__auto__.push((arguments[i__5628__auto___21602]));

var G__21603 = (i__5628__auto___21602 + (1));
i__5628__auto___21602 = G__21603;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__21595){
var map__21596 = p__21595;
var map__21596__$1 = ((((!((map__21596 == null)))?((((map__21596.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21596.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21596):map__21596);
var opts = map__21596__$1;
var statearr_21598_21604 = state;
(statearr_21598_21604[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts(((function (map__21596,map__21596__$1,opts){
return (function (val){
var statearr_21599_21605 = state;
(statearr_21599_21605[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__21596,map__21596__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_21600_21606 = state;
(statearr_21600_21606[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq21591){
var G__21592 = cljs.core.first(seq21591);
var seq21591__$1 = cljs.core.next(seq21591);
var G__21593 = cljs.core.first(seq21591__$1);
var seq21591__$2 = cljs.core.next(seq21591__$1);
var G__21594 = cljs.core.first(seq21591__$2);
var seq21591__$3 = cljs.core.next(seq21591__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21592,G__21593,G__21594,seq21591__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__21773 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__21773) : cljs.core.atom.call(null,G__21773));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute) : cljs.core.atom.call(null,cljs.core.cst$kw$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async21774 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21774 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta21775){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta21775 = meta21775;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21774.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_21776,meta21775__$1){
var self__ = this;
var _21776__$1 = this;
return (new cljs.core.async.t_cljs$core$async21774(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta21775__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21774.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_21776){
var self__ = this;
var _21776__$1 = this;
return self__.meta21775;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21774.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async21774.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21774.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async21774.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21774.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21774.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__21777_21939 = self__.cs;
var G__21778_21940 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__21777_21939,G__21778_21940) : cljs.core.reset_BANG_.call(null,G__21777_21939,G__21778_21940));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21774.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21774.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$mode)], 0)))].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21774.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta21775], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21774.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21774.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21774";

cljs.core.async.t_cljs$core$async21774.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async21774");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async21774 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async21774(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta21775){
return (new cljs.core.async.t_cljs$core$async21774(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta21775));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async21774(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10205__auto___21941 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___21941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___21941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_21876){
var state_val_21877 = (state_21876[(1)]);
if((state_val_21877 === (7))){
var inst_21794 = (state_21876[(2)]);
var state_21876__$1 = state_21876;
var statearr_21878_21942 = state_21876__$1;
(statearr_21878_21942[(2)] = inst_21794);

(statearr_21878_21942[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (20))){
var inst_21806 = (state_21876[(7)]);
var state_21876__$1 = state_21876;
var statearr_21879_21943 = state_21876__$1;
(statearr_21879_21943[(2)] = inst_21806);

(statearr_21879_21943[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (27))){
var state_21876__$1 = state_21876;
var statearr_21880_21944 = state_21876__$1;
(statearr_21880_21944[(2)] = null);

(statearr_21880_21944[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (1))){
var inst_21782 = (state_21876[(8)]);
var inst_21782__$1 = calc_state();
var inst_21784 = (inst_21782__$1 == null);
var inst_21785 = cljs.core.not(inst_21784);
var state_21876__$1 = (function (){var statearr_21881 = state_21876;
(statearr_21881[(8)] = inst_21782__$1);

return statearr_21881;
})();
if(inst_21785){
var statearr_21882_21945 = state_21876__$1;
(statearr_21882_21945[(1)] = (2));

} else {
var statearr_21883_21946 = state_21876__$1;
(statearr_21883_21946[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (24))){
var inst_21850 = (state_21876[(9)]);
var inst_21829 = (state_21876[(10)]);
var inst_21836 = (state_21876[(11)]);
var inst_21850__$1 = (inst_21829.cljs$core$IFn$_invoke$arity$1 ? inst_21829.cljs$core$IFn$_invoke$arity$1(inst_21836) : inst_21829.call(null,inst_21836));
var state_21876__$1 = (function (){var statearr_21884 = state_21876;
(statearr_21884[(9)] = inst_21850__$1);

return statearr_21884;
})();
if(cljs.core.truth_(inst_21850__$1)){
var statearr_21885_21947 = state_21876__$1;
(statearr_21885_21947[(1)] = (29));

} else {
var statearr_21886_21948 = state_21876__$1;
(statearr_21886_21948[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (4))){
var inst_21797 = (state_21876[(2)]);
var state_21876__$1 = state_21876;
if(cljs.core.truth_(inst_21797)){
var statearr_21887_21949 = state_21876__$1;
(statearr_21887_21949[(1)] = (8));

} else {
var statearr_21888_21950 = state_21876__$1;
(statearr_21888_21950[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (15))){
var inst_21823 = (state_21876[(2)]);
var state_21876__$1 = state_21876;
if(cljs.core.truth_(inst_21823)){
var statearr_21889_21951 = state_21876__$1;
(statearr_21889_21951[(1)] = (19));

} else {
var statearr_21890_21952 = state_21876__$1;
(statearr_21890_21952[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (21))){
var inst_21828 = (state_21876[(12)]);
var inst_21828__$1 = (state_21876[(2)]);
var inst_21829 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21828__$1,cljs.core.cst$kw$solos);
var inst_21830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21828__$1,cljs.core.cst$kw$mutes);
var inst_21831 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21828__$1,cljs.core.cst$kw$reads);
var state_21876__$1 = (function (){var statearr_21891 = state_21876;
(statearr_21891[(13)] = inst_21830);

(statearr_21891[(12)] = inst_21828__$1);

(statearr_21891[(10)] = inst_21829);

return statearr_21891;
})();
return cljs.core.async.ioc_alts_BANG_(state_21876__$1,(22),inst_21831);
} else {
if((state_val_21877 === (31))){
var inst_21858 = (state_21876[(2)]);
var state_21876__$1 = state_21876;
if(cljs.core.truth_(inst_21858)){
var statearr_21892_21953 = state_21876__$1;
(statearr_21892_21953[(1)] = (32));

} else {
var statearr_21893_21954 = state_21876__$1;
(statearr_21893_21954[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (32))){
var inst_21835 = (state_21876[(14)]);
var state_21876__$1 = state_21876;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21876__$1,(35),out,inst_21835);
} else {
if((state_val_21877 === (33))){
var inst_21828 = (state_21876[(12)]);
var inst_21806 = inst_21828;
var state_21876__$1 = (function (){var statearr_21894 = state_21876;
(statearr_21894[(7)] = inst_21806);

return statearr_21894;
})();
var statearr_21895_21955 = state_21876__$1;
(statearr_21895_21955[(2)] = null);

(statearr_21895_21955[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (13))){
var inst_21806 = (state_21876[(7)]);
var inst_21813 = inst_21806.cljs$lang$protocol_mask$partition0$;
var inst_21814 = (inst_21813 & (64));
var inst_21815 = inst_21806.cljs$core$ISeq$;
var inst_21816 = (inst_21814) || (inst_21815);
var state_21876__$1 = state_21876;
if(cljs.core.truth_(inst_21816)){
var statearr_21896_21956 = state_21876__$1;
(statearr_21896_21956[(1)] = (16));

} else {
var statearr_21897_21957 = state_21876__$1;
(statearr_21897_21957[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (22))){
var inst_21835 = (state_21876[(14)]);
var inst_21836 = (state_21876[(11)]);
var inst_21834 = (state_21876[(2)]);
var inst_21835__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21834,(0),null);
var inst_21836__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21834,(1),null);
var inst_21837 = (inst_21835__$1 == null);
var inst_21838 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21836__$1,change);
var inst_21839 = (inst_21837) || (inst_21838);
var state_21876__$1 = (function (){var statearr_21898 = state_21876;
(statearr_21898[(14)] = inst_21835__$1);

(statearr_21898[(11)] = inst_21836__$1);

return statearr_21898;
})();
if(cljs.core.truth_(inst_21839)){
var statearr_21899_21958 = state_21876__$1;
(statearr_21899_21958[(1)] = (23));

} else {
var statearr_21900_21959 = state_21876__$1;
(statearr_21900_21959[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (36))){
var inst_21828 = (state_21876[(12)]);
var inst_21806 = inst_21828;
var state_21876__$1 = (function (){var statearr_21901 = state_21876;
(statearr_21901[(7)] = inst_21806);

return statearr_21901;
})();
var statearr_21902_21960 = state_21876__$1;
(statearr_21902_21960[(2)] = null);

(statearr_21902_21960[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (29))){
var inst_21850 = (state_21876[(9)]);
var state_21876__$1 = state_21876;
var statearr_21903_21961 = state_21876__$1;
(statearr_21903_21961[(2)] = inst_21850);

(statearr_21903_21961[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (6))){
var state_21876__$1 = state_21876;
var statearr_21904_21962 = state_21876__$1;
(statearr_21904_21962[(2)] = false);

(statearr_21904_21962[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (28))){
var inst_21846 = (state_21876[(2)]);
var inst_21847 = calc_state();
var inst_21806 = inst_21847;
var state_21876__$1 = (function (){var statearr_21905 = state_21876;
(statearr_21905[(15)] = inst_21846);

(statearr_21905[(7)] = inst_21806);

return statearr_21905;
})();
var statearr_21906_21963 = state_21876__$1;
(statearr_21906_21963[(2)] = null);

(statearr_21906_21963[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (25))){
var inst_21872 = (state_21876[(2)]);
var state_21876__$1 = state_21876;
var statearr_21907_21964 = state_21876__$1;
(statearr_21907_21964[(2)] = inst_21872);

(statearr_21907_21964[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (34))){
var inst_21870 = (state_21876[(2)]);
var state_21876__$1 = state_21876;
var statearr_21908_21965 = state_21876__$1;
(statearr_21908_21965[(2)] = inst_21870);

(statearr_21908_21965[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (17))){
var state_21876__$1 = state_21876;
var statearr_21909_21966 = state_21876__$1;
(statearr_21909_21966[(2)] = false);

(statearr_21909_21966[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (3))){
var state_21876__$1 = state_21876;
var statearr_21910_21967 = state_21876__$1;
(statearr_21910_21967[(2)] = false);

(statearr_21910_21967[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (12))){
var inst_21874 = (state_21876[(2)]);
var state_21876__$1 = state_21876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21876__$1,inst_21874);
} else {
if((state_val_21877 === (2))){
var inst_21782 = (state_21876[(8)]);
var inst_21787 = inst_21782.cljs$lang$protocol_mask$partition0$;
var inst_21788 = (inst_21787 & (64));
var inst_21789 = inst_21782.cljs$core$ISeq$;
var inst_21790 = (inst_21788) || (inst_21789);
var state_21876__$1 = state_21876;
if(cljs.core.truth_(inst_21790)){
var statearr_21911_21968 = state_21876__$1;
(statearr_21911_21968[(1)] = (5));

} else {
var statearr_21912_21969 = state_21876__$1;
(statearr_21912_21969[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (23))){
var inst_21835 = (state_21876[(14)]);
var inst_21841 = (inst_21835 == null);
var state_21876__$1 = state_21876;
if(cljs.core.truth_(inst_21841)){
var statearr_21913_21970 = state_21876__$1;
(statearr_21913_21970[(1)] = (26));

} else {
var statearr_21914_21971 = state_21876__$1;
(statearr_21914_21971[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (35))){
var inst_21861 = (state_21876[(2)]);
var state_21876__$1 = state_21876;
if(cljs.core.truth_(inst_21861)){
var statearr_21915_21972 = state_21876__$1;
(statearr_21915_21972[(1)] = (36));

} else {
var statearr_21916_21973 = state_21876__$1;
(statearr_21916_21973[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (19))){
var inst_21806 = (state_21876[(7)]);
var inst_21825 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_21806);
var state_21876__$1 = state_21876;
var statearr_21917_21974 = state_21876__$1;
(statearr_21917_21974[(2)] = inst_21825);

(statearr_21917_21974[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (11))){
var inst_21806 = (state_21876[(7)]);
var inst_21810 = (inst_21806 == null);
var inst_21811 = cljs.core.not(inst_21810);
var state_21876__$1 = state_21876;
if(inst_21811){
var statearr_21918_21975 = state_21876__$1;
(statearr_21918_21975[(1)] = (13));

} else {
var statearr_21919_21976 = state_21876__$1;
(statearr_21919_21976[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (9))){
var inst_21782 = (state_21876[(8)]);
var state_21876__$1 = state_21876;
var statearr_21920_21977 = state_21876__$1;
(statearr_21920_21977[(2)] = inst_21782);

(statearr_21920_21977[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (5))){
var state_21876__$1 = state_21876;
var statearr_21921_21978 = state_21876__$1;
(statearr_21921_21978[(2)] = true);

(statearr_21921_21978[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (14))){
var state_21876__$1 = state_21876;
var statearr_21922_21979 = state_21876__$1;
(statearr_21922_21979[(2)] = false);

(statearr_21922_21979[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (26))){
var inst_21836 = (state_21876[(11)]);
var inst_21843 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_21836);
var state_21876__$1 = state_21876;
var statearr_21923_21980 = state_21876__$1;
(statearr_21923_21980[(2)] = inst_21843);

(statearr_21923_21980[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (16))){
var state_21876__$1 = state_21876;
var statearr_21924_21981 = state_21876__$1;
(statearr_21924_21981[(2)] = true);

(statearr_21924_21981[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (38))){
var inst_21866 = (state_21876[(2)]);
var state_21876__$1 = state_21876;
var statearr_21925_21982 = state_21876__$1;
(statearr_21925_21982[(2)] = inst_21866);

(statearr_21925_21982[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (30))){
var inst_21830 = (state_21876[(13)]);
var inst_21829 = (state_21876[(10)]);
var inst_21836 = (state_21876[(11)]);
var inst_21853 = cljs.core.empty_QMARK_(inst_21829);
var inst_21854 = (inst_21830.cljs$core$IFn$_invoke$arity$1 ? inst_21830.cljs$core$IFn$_invoke$arity$1(inst_21836) : inst_21830.call(null,inst_21836));
var inst_21855 = cljs.core.not(inst_21854);
var inst_21856 = (inst_21853) && (inst_21855);
var state_21876__$1 = state_21876;
var statearr_21926_21983 = state_21876__$1;
(statearr_21926_21983[(2)] = inst_21856);

(statearr_21926_21983[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (10))){
var inst_21782 = (state_21876[(8)]);
var inst_21802 = (state_21876[(2)]);
var inst_21803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21802,cljs.core.cst$kw$solos);
var inst_21804 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21802,cljs.core.cst$kw$mutes);
var inst_21805 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21802,cljs.core.cst$kw$reads);
var inst_21806 = inst_21782;
var state_21876__$1 = (function (){var statearr_21927 = state_21876;
(statearr_21927[(16)] = inst_21805);

(statearr_21927[(17)] = inst_21803);

(statearr_21927[(7)] = inst_21806);

(statearr_21927[(18)] = inst_21804);

return statearr_21927;
})();
var statearr_21928_21984 = state_21876__$1;
(statearr_21928_21984[(2)] = null);

(statearr_21928_21984[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (18))){
var inst_21820 = (state_21876[(2)]);
var state_21876__$1 = state_21876;
var statearr_21929_21985 = state_21876__$1;
(statearr_21929_21985[(2)] = inst_21820);

(statearr_21929_21985[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (37))){
var state_21876__$1 = state_21876;
var statearr_21930_21986 = state_21876__$1;
(statearr_21930_21986[(2)] = null);

(statearr_21930_21986[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21877 === (8))){
var inst_21782 = (state_21876[(8)]);
var inst_21799 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_21782);
var state_21876__$1 = state_21876;
var statearr_21931_21987 = state_21876__$1;
(statearr_21931_21987[(2)] = inst_21799);

(statearr_21931_21987[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto___21941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10138__auto__,c__10205__auto___21941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10139__auto__ = null;
var cljs$core$async$mix_$_state_machine__10139__auto____0 = (function (){
var statearr_21935 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21935[(0)] = cljs$core$async$mix_$_state_machine__10139__auto__);

(statearr_21935[(1)] = (1));

return statearr_21935;
});
var cljs$core$async$mix_$_state_machine__10139__auto____1 = (function (state_21876){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_21876);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e21936){if((e21936 instanceof Object)){
var ex__10142__auto__ = e21936;
var statearr_21937_21988 = state_21876;
(statearr_21937_21988[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_21876);

return cljs.core.cst$kw$recur;
} else {
throw e21936;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__21989 = state_21876;
state_21876 = G__21989;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10139__auto__ = function(state_21876){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10139__auto____1.call(this,state_21876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10139__auto____0;
cljs$core$async$mix_$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10139__auto____1;
return cljs$core$async$mix_$_state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___21941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__10207__auto__ = (function (){var statearr_21938 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_21938[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___21941);

return statearr_21938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___21941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5225__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5225__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5225__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5225__auto__.call(null,p,v,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5225__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args21990 = [];
var len__5627__auto___21993 = arguments.length;
var i__5628__auto___21994 = (0);
while(true){
if((i__5628__auto___21994 < len__5627__auto___21993)){
args21990.push((arguments[i__5628__auto___21994]));

var G__21995 = (i__5628__auto___21994 + (1));
i__5628__auto___21994 = G__21995;
continue;
} else {
}
break;
}

var G__21992 = args21990.length;
switch (G__21992) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21990.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5225__auto__.call(null,p));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__5225__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5225__auto__.call(null,p,v));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__5225__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args21998 = [];
var len__5627__auto___22126 = arguments.length;
var i__5628__auto___22127 = (0);
while(true){
if((i__5628__auto___22127 < len__5627__auto___22126)){
args21998.push((arguments[i__5628__auto___22127]));

var G__22128 = (i__5628__auto___22127 + (1));
i__5628__auto___22127 = G__22128;
continue;
} else {
}
break;
}

var G__22000 = args21998.length;
switch (G__22000) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21998.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__22001 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__22001) : cljs.core.atom.call(null,G__22001));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__4569__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__4569__auto__,mults){
return (function (p1__21997_SHARP_){
if(cljs.core.truth_((p1__21997_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__21997_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__21997_SHARP_.call(null,topic)))){
return p1__21997_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__21997_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__4569__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async22002 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22002 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta22003){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta22003 = meta22003;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22002.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_22004,meta22003__$1){
var self__ = this;
var _22004__$1 = this;
return (new cljs.core.async.t_cljs$core$async22002(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta22003__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22002.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_22004){
var self__ = this;
var _22004__$1 = this;
return self__.meta22003;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22002.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async22002.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22002.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async22002.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22002.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22002.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__22005 = self__.mults;
var G__22006 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__22005,G__22006) : cljs.core.reset_BANG_.call(null,G__22005,G__22006));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22002.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22002.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta22003], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22002.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22002.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22002";

cljs.core.async.t_cljs$core$async22002.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async22002");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async22002 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async22002(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22003){
return (new cljs.core.async.t_cljs$core$async22002(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22003));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async22002(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10205__auto___22130 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___22130,mults,ensure_mult,p){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___22130,mults,ensure_mult,p){
return (function (state_22078){
var state_val_22079 = (state_22078[(1)]);
if((state_val_22079 === (7))){
var inst_22074 = (state_22078[(2)]);
var state_22078__$1 = state_22078;
var statearr_22080_22131 = state_22078__$1;
(statearr_22080_22131[(2)] = inst_22074);

(statearr_22080_22131[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (20))){
var state_22078__$1 = state_22078;
var statearr_22081_22132 = state_22078__$1;
(statearr_22081_22132[(2)] = null);

(statearr_22081_22132[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (1))){
var state_22078__$1 = state_22078;
var statearr_22082_22133 = state_22078__$1;
(statearr_22082_22133[(2)] = null);

(statearr_22082_22133[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (24))){
var inst_22057 = (state_22078[(7)]);
var inst_22066 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_22057);
var state_22078__$1 = state_22078;
var statearr_22083_22134 = state_22078__$1;
(statearr_22083_22134[(2)] = inst_22066);

(statearr_22083_22134[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (4))){
var inst_22009 = (state_22078[(8)]);
var inst_22009__$1 = (state_22078[(2)]);
var inst_22010 = (inst_22009__$1 == null);
var state_22078__$1 = (function (){var statearr_22084 = state_22078;
(statearr_22084[(8)] = inst_22009__$1);

return statearr_22084;
})();
if(cljs.core.truth_(inst_22010)){
var statearr_22085_22135 = state_22078__$1;
(statearr_22085_22135[(1)] = (5));

} else {
var statearr_22086_22136 = state_22078__$1;
(statearr_22086_22136[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (15))){
var inst_22051 = (state_22078[(2)]);
var state_22078__$1 = state_22078;
var statearr_22087_22137 = state_22078__$1;
(statearr_22087_22137[(2)] = inst_22051);

(statearr_22087_22137[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (21))){
var inst_22071 = (state_22078[(2)]);
var state_22078__$1 = (function (){var statearr_22088 = state_22078;
(statearr_22088[(9)] = inst_22071);

return statearr_22088;
})();
var statearr_22089_22138 = state_22078__$1;
(statearr_22089_22138[(2)] = null);

(statearr_22089_22138[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (13))){
var inst_22033 = (state_22078[(10)]);
var inst_22035 = cljs.core.chunked_seq_QMARK_(inst_22033);
var state_22078__$1 = state_22078;
if(inst_22035){
var statearr_22090_22139 = state_22078__$1;
(statearr_22090_22139[(1)] = (16));

} else {
var statearr_22091_22140 = state_22078__$1;
(statearr_22091_22140[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (22))){
var inst_22063 = (state_22078[(2)]);
var state_22078__$1 = state_22078;
if(cljs.core.truth_(inst_22063)){
var statearr_22092_22141 = state_22078__$1;
(statearr_22092_22141[(1)] = (23));

} else {
var statearr_22093_22142 = state_22078__$1;
(statearr_22093_22142[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (6))){
var inst_22009 = (state_22078[(8)]);
var inst_22057 = (state_22078[(7)]);
var inst_22059 = (state_22078[(11)]);
var inst_22057__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_22009) : topic_fn.call(null,inst_22009));
var inst_22058 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_22059__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22058,inst_22057__$1);
var state_22078__$1 = (function (){var statearr_22094 = state_22078;
(statearr_22094[(7)] = inst_22057__$1);

(statearr_22094[(11)] = inst_22059__$1);

return statearr_22094;
})();
if(cljs.core.truth_(inst_22059__$1)){
var statearr_22095_22143 = state_22078__$1;
(statearr_22095_22143[(1)] = (19));

} else {
var statearr_22096_22144 = state_22078__$1;
(statearr_22096_22144[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (25))){
var inst_22068 = (state_22078[(2)]);
var state_22078__$1 = state_22078;
var statearr_22097_22145 = state_22078__$1;
(statearr_22097_22145[(2)] = inst_22068);

(statearr_22097_22145[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (17))){
var inst_22033 = (state_22078[(10)]);
var inst_22042 = cljs.core.first(inst_22033);
var inst_22043 = cljs.core.async.muxch_STAR_(inst_22042);
var inst_22044 = cljs.core.async.close_BANG_(inst_22043);
var inst_22045 = cljs.core.next(inst_22033);
var inst_22019 = inst_22045;
var inst_22020 = null;
var inst_22021 = (0);
var inst_22022 = (0);
var state_22078__$1 = (function (){var statearr_22098 = state_22078;
(statearr_22098[(12)] = inst_22019);

(statearr_22098[(13)] = inst_22022);

(statearr_22098[(14)] = inst_22020);

(statearr_22098[(15)] = inst_22021);

(statearr_22098[(16)] = inst_22044);

return statearr_22098;
})();
var statearr_22099_22146 = state_22078__$1;
(statearr_22099_22146[(2)] = null);

(statearr_22099_22146[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (3))){
var inst_22076 = (state_22078[(2)]);
var state_22078__$1 = state_22078;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22078__$1,inst_22076);
} else {
if((state_val_22079 === (12))){
var inst_22053 = (state_22078[(2)]);
var state_22078__$1 = state_22078;
var statearr_22100_22147 = state_22078__$1;
(statearr_22100_22147[(2)] = inst_22053);

(statearr_22100_22147[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (2))){
var state_22078__$1 = state_22078;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22078__$1,(4),ch);
} else {
if((state_val_22079 === (23))){
var state_22078__$1 = state_22078;
var statearr_22101_22148 = state_22078__$1;
(statearr_22101_22148[(2)] = null);

(statearr_22101_22148[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (19))){
var inst_22009 = (state_22078[(8)]);
var inst_22059 = (state_22078[(11)]);
var inst_22061 = cljs.core.async.muxch_STAR_(inst_22059);
var state_22078__$1 = state_22078;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22078__$1,(22),inst_22061,inst_22009);
} else {
if((state_val_22079 === (11))){
var inst_22019 = (state_22078[(12)]);
var inst_22033 = (state_22078[(10)]);
var inst_22033__$1 = cljs.core.seq(inst_22019);
var state_22078__$1 = (function (){var statearr_22102 = state_22078;
(statearr_22102[(10)] = inst_22033__$1);

return statearr_22102;
})();
if(inst_22033__$1){
var statearr_22103_22149 = state_22078__$1;
(statearr_22103_22149[(1)] = (13));

} else {
var statearr_22104_22150 = state_22078__$1;
(statearr_22104_22150[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (9))){
var inst_22055 = (state_22078[(2)]);
var state_22078__$1 = state_22078;
var statearr_22105_22151 = state_22078__$1;
(statearr_22105_22151[(2)] = inst_22055);

(statearr_22105_22151[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (5))){
var inst_22016 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_22017 = cljs.core.vals(inst_22016);
var inst_22018 = cljs.core.seq(inst_22017);
var inst_22019 = inst_22018;
var inst_22020 = null;
var inst_22021 = (0);
var inst_22022 = (0);
var state_22078__$1 = (function (){var statearr_22106 = state_22078;
(statearr_22106[(12)] = inst_22019);

(statearr_22106[(13)] = inst_22022);

(statearr_22106[(14)] = inst_22020);

(statearr_22106[(15)] = inst_22021);

return statearr_22106;
})();
var statearr_22107_22152 = state_22078__$1;
(statearr_22107_22152[(2)] = null);

(statearr_22107_22152[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (14))){
var state_22078__$1 = state_22078;
var statearr_22111_22153 = state_22078__$1;
(statearr_22111_22153[(2)] = null);

(statearr_22111_22153[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (16))){
var inst_22033 = (state_22078[(10)]);
var inst_22037 = cljs.core.chunk_first(inst_22033);
var inst_22038 = cljs.core.chunk_rest(inst_22033);
var inst_22039 = cljs.core.count(inst_22037);
var inst_22019 = inst_22038;
var inst_22020 = inst_22037;
var inst_22021 = inst_22039;
var inst_22022 = (0);
var state_22078__$1 = (function (){var statearr_22112 = state_22078;
(statearr_22112[(12)] = inst_22019);

(statearr_22112[(13)] = inst_22022);

(statearr_22112[(14)] = inst_22020);

(statearr_22112[(15)] = inst_22021);

return statearr_22112;
})();
var statearr_22113_22154 = state_22078__$1;
(statearr_22113_22154[(2)] = null);

(statearr_22113_22154[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (10))){
var inst_22019 = (state_22078[(12)]);
var inst_22022 = (state_22078[(13)]);
var inst_22020 = (state_22078[(14)]);
var inst_22021 = (state_22078[(15)]);
var inst_22027 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_22020,inst_22022);
var inst_22028 = cljs.core.async.muxch_STAR_(inst_22027);
var inst_22029 = cljs.core.async.close_BANG_(inst_22028);
var inst_22030 = (inst_22022 + (1));
var tmp22108 = inst_22019;
var tmp22109 = inst_22020;
var tmp22110 = inst_22021;
var inst_22019__$1 = tmp22108;
var inst_22020__$1 = tmp22109;
var inst_22021__$1 = tmp22110;
var inst_22022__$1 = inst_22030;
var state_22078__$1 = (function (){var statearr_22114 = state_22078;
(statearr_22114[(12)] = inst_22019__$1);

(statearr_22114[(13)] = inst_22022__$1);

(statearr_22114[(14)] = inst_22020__$1);

(statearr_22114[(15)] = inst_22021__$1);

(statearr_22114[(17)] = inst_22029);

return statearr_22114;
})();
var statearr_22115_22155 = state_22078__$1;
(statearr_22115_22155[(2)] = null);

(statearr_22115_22155[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (18))){
var inst_22048 = (state_22078[(2)]);
var state_22078__$1 = state_22078;
var statearr_22116_22156 = state_22078__$1;
(statearr_22116_22156[(2)] = inst_22048);

(statearr_22116_22156[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22079 === (8))){
var inst_22022 = (state_22078[(13)]);
var inst_22021 = (state_22078[(15)]);
var inst_22024 = (inst_22022 < inst_22021);
var inst_22025 = inst_22024;
var state_22078__$1 = state_22078;
if(cljs.core.truth_(inst_22025)){
var statearr_22117_22157 = state_22078__$1;
(statearr_22117_22157[(1)] = (10));

} else {
var statearr_22118_22158 = state_22078__$1;
(statearr_22118_22158[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto___22130,mults,ensure_mult,p))
;
return ((function (switch__10138__auto__,c__10205__auto___22130,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10139__auto__ = null;
var cljs$core$async$state_machine__10139__auto____0 = (function (){
var statearr_22122 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22122[(0)] = cljs$core$async$state_machine__10139__auto__);

(statearr_22122[(1)] = (1));

return statearr_22122;
});
var cljs$core$async$state_machine__10139__auto____1 = (function (state_22078){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_22078);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e22123){if((e22123 instanceof Object)){
var ex__10142__auto__ = e22123;
var statearr_22124_22159 = state_22078;
(statearr_22124_22159[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22078);

return cljs.core.cst$kw$recur;
} else {
throw e22123;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__22160 = state_22078;
state_22078 = G__22160;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$state_machine__10139__auto__ = function(state_22078){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10139__auto____1.call(this,state_22078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10139__auto____0;
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10139__auto____1;
return cljs$core$async$state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___22130,mults,ensure_mult,p))
})();
var state__10207__auto__ = (function (){var statearr_22125 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_22125[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___22130);

return statearr_22125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___22130,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args22161 = [];
var len__5627__auto___22164 = arguments.length;
var i__5628__auto___22165 = (0);
while(true){
if((i__5628__auto___22165 < len__5627__auto___22164)){
args22161.push((arguments[i__5628__auto___22165]));

var G__22166 = (i__5628__auto___22165 + (1));
i__5628__auto___22165 = G__22166;
continue;
} else {
}
break;
}

var G__22163 = args22161.length;
switch (G__22163) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22161.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args22168 = [];
var len__5627__auto___22171 = arguments.length;
var i__5628__auto___22172 = (0);
while(true){
if((i__5628__auto___22172 < len__5627__auto___22171)){
args22168.push((arguments[i__5628__auto___22172]));

var G__22173 = (i__5628__auto___22172 + (1));
i__5628__auto___22172 = G__22173;
continue;
} else {
}
break;
}

var G__22170 = args22168.length;
switch (G__22170) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22168.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args22175 = [];
var len__5627__auto___22246 = arguments.length;
var i__5628__auto___22247 = (0);
while(true){
if((i__5628__auto___22247 < len__5627__auto___22246)){
args22175.push((arguments[i__5628__auto___22247]));

var G__22248 = (i__5628__auto___22247 + (1));
i__5628__auto___22247 = G__22248;
continue;
} else {
}
break;
}

var G__22177 = args22175.length;
switch (G__22177) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22175.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__10205__auto___22250 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___22250,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___22250,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_22216){
var state_val_22217 = (state_22216[(1)]);
if((state_val_22217 === (7))){
var state_22216__$1 = state_22216;
var statearr_22218_22251 = state_22216__$1;
(statearr_22218_22251[(2)] = null);

(statearr_22218_22251[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22217 === (1))){
var state_22216__$1 = state_22216;
var statearr_22219_22252 = state_22216__$1;
(statearr_22219_22252[(2)] = null);

(statearr_22219_22252[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22217 === (4))){
var inst_22180 = (state_22216[(7)]);
var inst_22182 = (inst_22180 < cnt);
var state_22216__$1 = state_22216;
if(cljs.core.truth_(inst_22182)){
var statearr_22220_22253 = state_22216__$1;
(statearr_22220_22253[(1)] = (6));

} else {
var statearr_22221_22254 = state_22216__$1;
(statearr_22221_22254[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22217 === (15))){
var inst_22212 = (state_22216[(2)]);
var state_22216__$1 = state_22216;
var statearr_22222_22255 = state_22216__$1;
(statearr_22222_22255[(2)] = inst_22212);

(statearr_22222_22255[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22217 === (13))){
var inst_22205 = cljs.core.async.close_BANG_(out);
var state_22216__$1 = state_22216;
var statearr_22223_22256 = state_22216__$1;
(statearr_22223_22256[(2)] = inst_22205);

(statearr_22223_22256[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22217 === (6))){
var state_22216__$1 = state_22216;
var statearr_22224_22257 = state_22216__$1;
(statearr_22224_22257[(2)] = null);

(statearr_22224_22257[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22217 === (3))){
var inst_22214 = (state_22216[(2)]);
var state_22216__$1 = state_22216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22216__$1,inst_22214);
} else {
if((state_val_22217 === (12))){
var inst_22202 = (state_22216[(8)]);
var inst_22202__$1 = (state_22216[(2)]);
var inst_22203 = cljs.core.some(cljs.core.nil_QMARK_,inst_22202__$1);
var state_22216__$1 = (function (){var statearr_22225 = state_22216;
(statearr_22225[(8)] = inst_22202__$1);

return statearr_22225;
})();
if(cljs.core.truth_(inst_22203)){
var statearr_22226_22258 = state_22216__$1;
(statearr_22226_22258[(1)] = (13));

} else {
var statearr_22227_22259 = state_22216__$1;
(statearr_22227_22259[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22217 === (2))){
var inst_22179 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_22180 = (0);
var state_22216__$1 = (function (){var statearr_22228 = state_22216;
(statearr_22228[(7)] = inst_22180);

(statearr_22228[(9)] = inst_22179);

return statearr_22228;
})();
var statearr_22229_22260 = state_22216__$1;
(statearr_22229_22260[(2)] = null);

(statearr_22229_22260[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22217 === (11))){
var inst_22180 = (state_22216[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_22216,(10),Object,null,(9));
var inst_22189 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_22180) : chs__$1.call(null,inst_22180));
var inst_22190 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_22180) : done.call(null,inst_22180));
var inst_22191 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_22189,inst_22190);
var state_22216__$1 = state_22216;
var statearr_22230_22261 = state_22216__$1;
(statearr_22230_22261[(2)] = inst_22191);


cljs.core.async.impl.ioc_helpers.process_exception(state_22216__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_22217 === (9))){
var inst_22180 = (state_22216[(7)]);
var inst_22193 = (state_22216[(2)]);
var inst_22194 = (inst_22180 + (1));
var inst_22180__$1 = inst_22194;
var state_22216__$1 = (function (){var statearr_22231 = state_22216;
(statearr_22231[(7)] = inst_22180__$1);

(statearr_22231[(10)] = inst_22193);

return statearr_22231;
})();
var statearr_22232_22262 = state_22216__$1;
(statearr_22232_22262[(2)] = null);

(statearr_22232_22262[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22217 === (5))){
var inst_22200 = (state_22216[(2)]);
var state_22216__$1 = (function (){var statearr_22233 = state_22216;
(statearr_22233[(11)] = inst_22200);

return statearr_22233;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22216__$1,(12),dchan);
} else {
if((state_val_22217 === (14))){
var inst_22202 = (state_22216[(8)]);
var inst_22207 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_22202);
var state_22216__$1 = state_22216;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22216__$1,(16),out,inst_22207);
} else {
if((state_val_22217 === (16))){
var inst_22209 = (state_22216[(2)]);
var state_22216__$1 = (function (){var statearr_22234 = state_22216;
(statearr_22234[(12)] = inst_22209);

return statearr_22234;
})();
var statearr_22235_22263 = state_22216__$1;
(statearr_22235_22263[(2)] = null);

(statearr_22235_22263[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22217 === (10))){
var inst_22184 = (state_22216[(2)]);
var inst_22185 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_22216__$1 = (function (){var statearr_22236 = state_22216;
(statearr_22236[(13)] = inst_22184);

return statearr_22236;
})();
var statearr_22237_22264 = state_22216__$1;
(statearr_22237_22264[(2)] = inst_22185);


cljs.core.async.impl.ioc_helpers.process_exception(state_22216__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_22217 === (8))){
var inst_22198 = (state_22216[(2)]);
var state_22216__$1 = state_22216;
var statearr_22238_22265 = state_22216__$1;
(statearr_22238_22265[(2)] = inst_22198);

(statearr_22238_22265[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto___22250,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10138__auto__,c__10205__auto___22250,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10139__auto__ = null;
var cljs$core$async$state_machine__10139__auto____0 = (function (){
var statearr_22242 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22242[(0)] = cljs$core$async$state_machine__10139__auto__);

(statearr_22242[(1)] = (1));

return statearr_22242;
});
var cljs$core$async$state_machine__10139__auto____1 = (function (state_22216){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_22216);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e22243){if((e22243 instanceof Object)){
var ex__10142__auto__ = e22243;
var statearr_22244_22266 = state_22216;
(statearr_22244_22266[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22216);

return cljs.core.cst$kw$recur;
} else {
throw e22243;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__22267 = state_22216;
state_22216 = G__22267;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$state_machine__10139__auto__ = function(state_22216){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10139__auto____1.call(this,state_22216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10139__auto____0;
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10139__auto____1;
return cljs$core$async$state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___22250,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__10207__auto__ = (function (){var statearr_22245 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_22245[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___22250);

return statearr_22245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___22250,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args22269 = [];
var len__5627__auto___22325 = arguments.length;
var i__5628__auto___22326 = (0);
while(true){
if((i__5628__auto___22326 < len__5627__auto___22325)){
args22269.push((arguments[i__5628__auto___22326]));

var G__22327 = (i__5628__auto___22326 + (1));
i__5628__auto___22326 = G__22327;
continue;
} else {
}
break;
}

var G__22271 = args22269.length;
switch (G__22271) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22269.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__10205__auto___22329 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___22329,out){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___22329,out){
return (function (state_22301){
var state_val_22302 = (state_22301[(1)]);
if((state_val_22302 === (7))){
var inst_22281 = (state_22301[(7)]);
var inst_22280 = (state_22301[(8)]);
var inst_22280__$1 = (state_22301[(2)]);
var inst_22281__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22280__$1,(0),null);
var inst_22282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22280__$1,(1),null);
var inst_22283 = (inst_22281__$1 == null);
var state_22301__$1 = (function (){var statearr_22303 = state_22301;
(statearr_22303[(9)] = inst_22282);

(statearr_22303[(7)] = inst_22281__$1);

(statearr_22303[(8)] = inst_22280__$1);

return statearr_22303;
})();
if(cljs.core.truth_(inst_22283)){
var statearr_22304_22330 = state_22301__$1;
(statearr_22304_22330[(1)] = (8));

} else {
var statearr_22305_22331 = state_22301__$1;
(statearr_22305_22331[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22302 === (1))){
var inst_22272 = cljs.core.vec(chs);
var inst_22273 = inst_22272;
var state_22301__$1 = (function (){var statearr_22306 = state_22301;
(statearr_22306[(10)] = inst_22273);

return statearr_22306;
})();
var statearr_22307_22332 = state_22301__$1;
(statearr_22307_22332[(2)] = null);

(statearr_22307_22332[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22302 === (4))){
var inst_22273 = (state_22301[(10)]);
var state_22301__$1 = state_22301;
return cljs.core.async.ioc_alts_BANG_(state_22301__$1,(7),inst_22273);
} else {
if((state_val_22302 === (6))){
var inst_22297 = (state_22301[(2)]);
var state_22301__$1 = state_22301;
var statearr_22308_22333 = state_22301__$1;
(statearr_22308_22333[(2)] = inst_22297);

(statearr_22308_22333[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22302 === (3))){
var inst_22299 = (state_22301[(2)]);
var state_22301__$1 = state_22301;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22301__$1,inst_22299);
} else {
if((state_val_22302 === (2))){
var inst_22273 = (state_22301[(10)]);
var inst_22275 = cljs.core.count(inst_22273);
var inst_22276 = (inst_22275 > (0));
var state_22301__$1 = state_22301;
if(cljs.core.truth_(inst_22276)){
var statearr_22310_22334 = state_22301__$1;
(statearr_22310_22334[(1)] = (4));

} else {
var statearr_22311_22335 = state_22301__$1;
(statearr_22311_22335[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22302 === (11))){
var inst_22273 = (state_22301[(10)]);
var inst_22290 = (state_22301[(2)]);
var tmp22309 = inst_22273;
var inst_22273__$1 = tmp22309;
var state_22301__$1 = (function (){var statearr_22312 = state_22301;
(statearr_22312[(11)] = inst_22290);

(statearr_22312[(10)] = inst_22273__$1);

return statearr_22312;
})();
var statearr_22313_22336 = state_22301__$1;
(statearr_22313_22336[(2)] = null);

(statearr_22313_22336[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22302 === (9))){
var inst_22281 = (state_22301[(7)]);
var state_22301__$1 = state_22301;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22301__$1,(11),out,inst_22281);
} else {
if((state_val_22302 === (5))){
var inst_22295 = cljs.core.async.close_BANG_(out);
var state_22301__$1 = state_22301;
var statearr_22314_22337 = state_22301__$1;
(statearr_22314_22337[(2)] = inst_22295);

(statearr_22314_22337[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22302 === (10))){
var inst_22293 = (state_22301[(2)]);
var state_22301__$1 = state_22301;
var statearr_22315_22338 = state_22301__$1;
(statearr_22315_22338[(2)] = inst_22293);

(statearr_22315_22338[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22302 === (8))){
var inst_22282 = (state_22301[(9)]);
var inst_22273 = (state_22301[(10)]);
var inst_22281 = (state_22301[(7)]);
var inst_22280 = (state_22301[(8)]);
var inst_22285 = (function (){var cs = inst_22273;
var vec__22278 = inst_22280;
var v = inst_22281;
var c = inst_22282;
return ((function (cs,vec__22278,v,c,inst_22282,inst_22273,inst_22281,inst_22280,state_val_22302,c__10205__auto___22329,out){
return (function (p1__22268_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__22268_SHARP_);
});
;})(cs,vec__22278,v,c,inst_22282,inst_22273,inst_22281,inst_22280,state_val_22302,c__10205__auto___22329,out))
})();
var inst_22286 = cljs.core.filterv(inst_22285,inst_22273);
var inst_22273__$1 = inst_22286;
var state_22301__$1 = (function (){var statearr_22316 = state_22301;
(statearr_22316[(10)] = inst_22273__$1);

return statearr_22316;
})();
var statearr_22317_22339 = state_22301__$1;
(statearr_22317_22339[(2)] = null);

(statearr_22317_22339[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto___22329,out))
;
return ((function (switch__10138__auto__,c__10205__auto___22329,out){
return (function() {
var cljs$core$async$state_machine__10139__auto__ = null;
var cljs$core$async$state_machine__10139__auto____0 = (function (){
var statearr_22321 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22321[(0)] = cljs$core$async$state_machine__10139__auto__);

(statearr_22321[(1)] = (1));

return statearr_22321;
});
var cljs$core$async$state_machine__10139__auto____1 = (function (state_22301){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_22301);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e22322){if((e22322 instanceof Object)){
var ex__10142__auto__ = e22322;
var statearr_22323_22340 = state_22301;
(statearr_22323_22340[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22301);

return cljs.core.cst$kw$recur;
} else {
throw e22322;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__22341 = state_22301;
state_22301 = G__22341;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$state_machine__10139__auto__ = function(state_22301){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10139__auto____1.call(this,state_22301);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10139__auto____0;
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10139__auto____1;
return cljs$core$async$state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___22329,out))
})();
var state__10207__auto__ = (function (){var statearr_22324 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_22324[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___22329);

return statearr_22324;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___22329,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args22342 = [];
var len__5627__auto___22391 = arguments.length;
var i__5628__auto___22392 = (0);
while(true){
if((i__5628__auto___22392 < len__5627__auto___22391)){
args22342.push((arguments[i__5628__auto___22392]));

var G__22393 = (i__5628__auto___22392 + (1));
i__5628__auto___22392 = G__22393;
continue;
} else {
}
break;
}

var G__22344 = args22342.length;
switch (G__22344) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22342.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__10205__auto___22395 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___22395,out){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___22395,out){
return (function (state_22368){
var state_val_22369 = (state_22368[(1)]);
if((state_val_22369 === (7))){
var inst_22350 = (state_22368[(7)]);
var inst_22350__$1 = (state_22368[(2)]);
var inst_22351 = (inst_22350__$1 == null);
var inst_22352 = cljs.core.not(inst_22351);
var state_22368__$1 = (function (){var statearr_22370 = state_22368;
(statearr_22370[(7)] = inst_22350__$1);

return statearr_22370;
})();
if(inst_22352){
var statearr_22371_22396 = state_22368__$1;
(statearr_22371_22396[(1)] = (8));

} else {
var statearr_22372_22397 = state_22368__$1;
(statearr_22372_22397[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22369 === (1))){
var inst_22345 = (0);
var state_22368__$1 = (function (){var statearr_22373 = state_22368;
(statearr_22373[(8)] = inst_22345);

return statearr_22373;
})();
var statearr_22374_22398 = state_22368__$1;
(statearr_22374_22398[(2)] = null);

(statearr_22374_22398[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22369 === (4))){
var state_22368__$1 = state_22368;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22368__$1,(7),ch);
} else {
if((state_val_22369 === (6))){
var inst_22363 = (state_22368[(2)]);
var state_22368__$1 = state_22368;
var statearr_22375_22399 = state_22368__$1;
(statearr_22375_22399[(2)] = inst_22363);

(statearr_22375_22399[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22369 === (3))){
var inst_22365 = (state_22368[(2)]);
var inst_22366 = cljs.core.async.close_BANG_(out);
var state_22368__$1 = (function (){var statearr_22376 = state_22368;
(statearr_22376[(9)] = inst_22365);

return statearr_22376;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_22368__$1,inst_22366);
} else {
if((state_val_22369 === (2))){
var inst_22345 = (state_22368[(8)]);
var inst_22347 = (inst_22345 < n);
var state_22368__$1 = state_22368;
if(cljs.core.truth_(inst_22347)){
var statearr_22377_22400 = state_22368__$1;
(statearr_22377_22400[(1)] = (4));

} else {
var statearr_22378_22401 = state_22368__$1;
(statearr_22378_22401[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22369 === (11))){
var inst_22345 = (state_22368[(8)]);
var inst_22355 = (state_22368[(2)]);
var inst_22356 = (inst_22345 + (1));
var inst_22345__$1 = inst_22356;
var state_22368__$1 = (function (){var statearr_22379 = state_22368;
(statearr_22379[(8)] = inst_22345__$1);

(statearr_22379[(10)] = inst_22355);

return statearr_22379;
})();
var statearr_22380_22402 = state_22368__$1;
(statearr_22380_22402[(2)] = null);

(statearr_22380_22402[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22369 === (9))){
var state_22368__$1 = state_22368;
var statearr_22381_22403 = state_22368__$1;
(statearr_22381_22403[(2)] = null);

(statearr_22381_22403[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22369 === (5))){
var state_22368__$1 = state_22368;
var statearr_22382_22404 = state_22368__$1;
(statearr_22382_22404[(2)] = null);

(statearr_22382_22404[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22369 === (10))){
var inst_22360 = (state_22368[(2)]);
var state_22368__$1 = state_22368;
var statearr_22383_22405 = state_22368__$1;
(statearr_22383_22405[(2)] = inst_22360);

(statearr_22383_22405[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22369 === (8))){
var inst_22350 = (state_22368[(7)]);
var state_22368__$1 = state_22368;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22368__$1,(11),out,inst_22350);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto___22395,out))
;
return ((function (switch__10138__auto__,c__10205__auto___22395,out){
return (function() {
var cljs$core$async$state_machine__10139__auto__ = null;
var cljs$core$async$state_machine__10139__auto____0 = (function (){
var statearr_22387 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22387[(0)] = cljs$core$async$state_machine__10139__auto__);

(statearr_22387[(1)] = (1));

return statearr_22387;
});
var cljs$core$async$state_machine__10139__auto____1 = (function (state_22368){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_22368);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e22388){if((e22388 instanceof Object)){
var ex__10142__auto__ = e22388;
var statearr_22389_22406 = state_22368;
(statearr_22389_22406[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22368);

return cljs.core.cst$kw$recur;
} else {
throw e22388;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__22407 = state_22368;
state_22368 = G__22407;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$state_machine__10139__auto__ = function(state_22368){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10139__auto____1.call(this,state_22368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10139__auto____0;
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10139__auto____1;
return cljs$core$async$state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___22395,out))
})();
var state__10207__auto__ = (function (){var statearr_22390 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_22390[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___22395);

return statearr_22390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___22395,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22417 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22417 = (function (map_LT_,f,ch,meta22418){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22418 = meta22418;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22419,meta22418__$1){
var self__ = this;
var _22419__$1 = this;
return (new cljs.core.async.t_cljs$core$async22417(self__.map_LT_,self__.f,self__.ch,meta22418__$1));
});

cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22419){
var self__ = this;
var _22419__$1 = this;
return self__.meta22418;
});

cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async22420 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22420 = (function (map_LT_,f,ch,meta22418,_,fn1,meta22421){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22418 = meta22418;
this._ = _;
this.fn1 = fn1;
this.meta22421 = meta22421;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22420.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_22422,meta22421__$1){
var self__ = this;
var _22422__$1 = this;
return (new cljs.core.async.t_cljs$core$async22420(self__.map_LT_,self__.f,self__.ch,self__.meta22418,self__._,self__.fn1,meta22421__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async22420.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_22422){
var self__ = this;
var _22422__$1 = this;
return self__.meta22421;
});})(___$1))
;

cljs.core.async.t_cljs$core$async22420.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async22420.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22420.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__22408_SHARP_){
var G__22423 = (((p1__22408_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__22408_SHARP_) : self__.f.call(null,p1__22408_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__22423) : f1.call(null,G__22423));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async22420.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta22418,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async22417], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta22421], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22420.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22420.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22420";

cljs.core.async.t_cljs$core$async22420.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async22420");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async22420 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22420(map_LT___$1,f__$1,ch__$1,meta22418__$1,___$2,fn1__$1,meta22421){
return (new cljs.core.async.t_cljs$core$async22420(map_LT___$1,f__$1,ch__$1,meta22418__$1,___$2,fn1__$1,meta22421));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async22420(self__.map_LT_,self__.f,self__.ch,self__.meta22418,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4557__auto__ = ret;
if(cljs.core.truth_(and__4557__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__4557__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__22424 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__22424) : self__.f.call(null,G__22424));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22417.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async22417.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta22418], null);
});

cljs.core.async.t_cljs$core$async22417.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22417.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22417";

cljs.core.async.t_cljs$core$async22417.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async22417");
});

cljs.core.async.__GT_t_cljs$core$async22417 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22417(map_LT___$1,f__$1,ch__$1,meta22418){
return (new cljs.core.async.t_cljs$core$async22417(map_LT___$1,f__$1,ch__$1,meta22418));
});

}

return (new cljs.core.async.t_cljs$core$async22417(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22428 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22428 = (function (map_GT_,f,ch,meta22429){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta22429 = meta22429;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22428.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22430,meta22429__$1){
var self__ = this;
var _22430__$1 = this;
return (new cljs.core.async.t_cljs$core$async22428(self__.map_GT_,self__.f,self__.ch,meta22429__$1));
});

cljs.core.async.t_cljs$core$async22428.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22430){
var self__ = this;
var _22430__$1 = this;
return self__.meta22429;
});

cljs.core.async.t_cljs$core$async22428.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22428.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async22428.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22428.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22428.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22428.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async22428.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta22429], null);
});

cljs.core.async.t_cljs$core$async22428.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22428.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22428";

cljs.core.async.t_cljs$core$async22428.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async22428");
});

cljs.core.async.__GT_t_cljs$core$async22428 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async22428(map_GT___$1,f__$1,ch__$1,meta22429){
return (new cljs.core.async.t_cljs$core$async22428(map_GT___$1,f__$1,ch__$1,meta22429));
});

}

return (new cljs.core.async.t_cljs$core$async22428(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async22434 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22434 = (function (filter_GT_,p,ch,meta22435){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta22435 = meta22435;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22434.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22436,meta22435__$1){
var self__ = this;
var _22436__$1 = this;
return (new cljs.core.async.t_cljs$core$async22434(self__.filter_GT_,self__.p,self__.ch,meta22435__$1));
});

cljs.core.async.t_cljs$core$async22434.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22436){
var self__ = this;
var _22436__$1 = this;
return self__.meta22435;
});

cljs.core.async.t_cljs$core$async22434.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22434.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async22434.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async22434.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22434.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22434.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22434.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async22434.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta22435], null);
});

cljs.core.async.t_cljs$core$async22434.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22434.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22434";

cljs.core.async.t_cljs$core$async22434.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async22434");
});

cljs.core.async.__GT_t_cljs$core$async22434 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async22434(filter_GT___$1,p__$1,ch__$1,meta22435){
return (new cljs.core.async.t_cljs$core$async22434(filter_GT___$1,p__$1,ch__$1,meta22435));
});

}

return (new cljs.core.async.t_cljs$core$async22434(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args22437 = [];
var len__5627__auto___22481 = arguments.length;
var i__5628__auto___22482 = (0);
while(true){
if((i__5628__auto___22482 < len__5627__auto___22481)){
args22437.push((arguments[i__5628__auto___22482]));

var G__22483 = (i__5628__auto___22482 + (1));
i__5628__auto___22482 = G__22483;
continue;
} else {
}
break;
}

var G__22439 = args22437.length;
switch (G__22439) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22437.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__10205__auto___22485 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___22485,out){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___22485,out){
return (function (state_22460){
var state_val_22461 = (state_22460[(1)]);
if((state_val_22461 === (7))){
var inst_22456 = (state_22460[(2)]);
var state_22460__$1 = state_22460;
var statearr_22462_22486 = state_22460__$1;
(statearr_22462_22486[(2)] = inst_22456);

(statearr_22462_22486[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22461 === (1))){
var state_22460__$1 = state_22460;
var statearr_22463_22487 = state_22460__$1;
(statearr_22463_22487[(2)] = null);

(statearr_22463_22487[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22461 === (4))){
var inst_22442 = (state_22460[(7)]);
var inst_22442__$1 = (state_22460[(2)]);
var inst_22443 = (inst_22442__$1 == null);
var state_22460__$1 = (function (){var statearr_22464 = state_22460;
(statearr_22464[(7)] = inst_22442__$1);

return statearr_22464;
})();
if(cljs.core.truth_(inst_22443)){
var statearr_22465_22488 = state_22460__$1;
(statearr_22465_22488[(1)] = (5));

} else {
var statearr_22466_22489 = state_22460__$1;
(statearr_22466_22489[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22461 === (6))){
var inst_22442 = (state_22460[(7)]);
var inst_22447 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_22442) : p.call(null,inst_22442));
var state_22460__$1 = state_22460;
if(cljs.core.truth_(inst_22447)){
var statearr_22467_22490 = state_22460__$1;
(statearr_22467_22490[(1)] = (8));

} else {
var statearr_22468_22491 = state_22460__$1;
(statearr_22468_22491[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22461 === (3))){
var inst_22458 = (state_22460[(2)]);
var state_22460__$1 = state_22460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22460__$1,inst_22458);
} else {
if((state_val_22461 === (2))){
var state_22460__$1 = state_22460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22460__$1,(4),ch);
} else {
if((state_val_22461 === (11))){
var inst_22450 = (state_22460[(2)]);
var state_22460__$1 = state_22460;
var statearr_22469_22492 = state_22460__$1;
(statearr_22469_22492[(2)] = inst_22450);

(statearr_22469_22492[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22461 === (9))){
var state_22460__$1 = state_22460;
var statearr_22470_22493 = state_22460__$1;
(statearr_22470_22493[(2)] = null);

(statearr_22470_22493[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22461 === (5))){
var inst_22445 = cljs.core.async.close_BANG_(out);
var state_22460__$1 = state_22460;
var statearr_22471_22494 = state_22460__$1;
(statearr_22471_22494[(2)] = inst_22445);

(statearr_22471_22494[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22461 === (10))){
var inst_22453 = (state_22460[(2)]);
var state_22460__$1 = (function (){var statearr_22472 = state_22460;
(statearr_22472[(8)] = inst_22453);

return statearr_22472;
})();
var statearr_22473_22495 = state_22460__$1;
(statearr_22473_22495[(2)] = null);

(statearr_22473_22495[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22461 === (8))){
var inst_22442 = (state_22460[(7)]);
var state_22460__$1 = state_22460;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22460__$1,(11),out,inst_22442);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto___22485,out))
;
return ((function (switch__10138__auto__,c__10205__auto___22485,out){
return (function() {
var cljs$core$async$state_machine__10139__auto__ = null;
var cljs$core$async$state_machine__10139__auto____0 = (function (){
var statearr_22477 = [null,null,null,null,null,null,null,null,null];
(statearr_22477[(0)] = cljs$core$async$state_machine__10139__auto__);

(statearr_22477[(1)] = (1));

return statearr_22477;
});
var cljs$core$async$state_machine__10139__auto____1 = (function (state_22460){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_22460);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e22478){if((e22478 instanceof Object)){
var ex__10142__auto__ = e22478;
var statearr_22479_22496 = state_22460;
(statearr_22479_22496[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22460);

return cljs.core.cst$kw$recur;
} else {
throw e22478;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__22497 = state_22460;
state_22460 = G__22497;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$state_machine__10139__auto__ = function(state_22460){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10139__auto____1.call(this,state_22460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10139__auto____0;
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10139__auto____1;
return cljs$core$async$state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___22485,out))
})();
var state__10207__auto__ = (function (){var statearr_22480 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_22480[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___22485);

return statearr_22480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___22485,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args22498 = [];
var len__5627__auto___22501 = arguments.length;
var i__5628__auto___22502 = (0);
while(true){
if((i__5628__auto___22502 < len__5627__auto___22501)){
args22498.push((arguments[i__5628__auto___22502]));

var G__22503 = (i__5628__auto___22502 + (1));
i__5628__auto___22502 = G__22503;
continue;
} else {
}
break;
}

var G__22500 = args22498.length;
switch (G__22500) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22498.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__10205__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto__){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto__){
return (function (state_22670){
var state_val_22671 = (state_22670[(1)]);
if((state_val_22671 === (7))){
var inst_22666 = (state_22670[(2)]);
var state_22670__$1 = state_22670;
var statearr_22672_22713 = state_22670__$1;
(statearr_22672_22713[(2)] = inst_22666);

(statearr_22672_22713[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (20))){
var inst_22636 = (state_22670[(7)]);
var inst_22647 = (state_22670[(2)]);
var inst_22648 = cljs.core.next(inst_22636);
var inst_22622 = inst_22648;
var inst_22623 = null;
var inst_22624 = (0);
var inst_22625 = (0);
var state_22670__$1 = (function (){var statearr_22673 = state_22670;
(statearr_22673[(8)] = inst_22622);

(statearr_22673[(9)] = inst_22647);

(statearr_22673[(10)] = inst_22623);

(statearr_22673[(11)] = inst_22625);

(statearr_22673[(12)] = inst_22624);

return statearr_22673;
})();
var statearr_22674_22714 = state_22670__$1;
(statearr_22674_22714[(2)] = null);

(statearr_22674_22714[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (1))){
var state_22670__$1 = state_22670;
var statearr_22675_22715 = state_22670__$1;
(statearr_22675_22715[(2)] = null);

(statearr_22675_22715[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (4))){
var inst_22611 = (state_22670[(13)]);
var inst_22611__$1 = (state_22670[(2)]);
var inst_22612 = (inst_22611__$1 == null);
var state_22670__$1 = (function (){var statearr_22676 = state_22670;
(statearr_22676[(13)] = inst_22611__$1);

return statearr_22676;
})();
if(cljs.core.truth_(inst_22612)){
var statearr_22677_22716 = state_22670__$1;
(statearr_22677_22716[(1)] = (5));

} else {
var statearr_22678_22717 = state_22670__$1;
(statearr_22678_22717[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (15))){
var state_22670__$1 = state_22670;
var statearr_22682_22718 = state_22670__$1;
(statearr_22682_22718[(2)] = null);

(statearr_22682_22718[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (21))){
var state_22670__$1 = state_22670;
var statearr_22683_22719 = state_22670__$1;
(statearr_22683_22719[(2)] = null);

(statearr_22683_22719[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (13))){
var inst_22622 = (state_22670[(8)]);
var inst_22623 = (state_22670[(10)]);
var inst_22625 = (state_22670[(11)]);
var inst_22624 = (state_22670[(12)]);
var inst_22632 = (state_22670[(2)]);
var inst_22633 = (inst_22625 + (1));
var tmp22679 = inst_22622;
var tmp22680 = inst_22623;
var tmp22681 = inst_22624;
var inst_22622__$1 = tmp22679;
var inst_22623__$1 = tmp22680;
var inst_22624__$1 = tmp22681;
var inst_22625__$1 = inst_22633;
var state_22670__$1 = (function (){var statearr_22684 = state_22670;
(statearr_22684[(8)] = inst_22622__$1);

(statearr_22684[(10)] = inst_22623__$1);

(statearr_22684[(14)] = inst_22632);

(statearr_22684[(11)] = inst_22625__$1);

(statearr_22684[(12)] = inst_22624__$1);

return statearr_22684;
})();
var statearr_22685_22720 = state_22670__$1;
(statearr_22685_22720[(2)] = null);

(statearr_22685_22720[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (22))){
var state_22670__$1 = state_22670;
var statearr_22686_22721 = state_22670__$1;
(statearr_22686_22721[(2)] = null);

(statearr_22686_22721[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (6))){
var inst_22611 = (state_22670[(13)]);
var inst_22620 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_22611) : f.call(null,inst_22611));
var inst_22621 = cljs.core.seq(inst_22620);
var inst_22622 = inst_22621;
var inst_22623 = null;
var inst_22624 = (0);
var inst_22625 = (0);
var state_22670__$1 = (function (){var statearr_22687 = state_22670;
(statearr_22687[(8)] = inst_22622);

(statearr_22687[(10)] = inst_22623);

(statearr_22687[(11)] = inst_22625);

(statearr_22687[(12)] = inst_22624);

return statearr_22687;
})();
var statearr_22688_22722 = state_22670__$1;
(statearr_22688_22722[(2)] = null);

(statearr_22688_22722[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (17))){
var inst_22636 = (state_22670[(7)]);
var inst_22640 = cljs.core.chunk_first(inst_22636);
var inst_22641 = cljs.core.chunk_rest(inst_22636);
var inst_22642 = cljs.core.count(inst_22640);
var inst_22622 = inst_22641;
var inst_22623 = inst_22640;
var inst_22624 = inst_22642;
var inst_22625 = (0);
var state_22670__$1 = (function (){var statearr_22689 = state_22670;
(statearr_22689[(8)] = inst_22622);

(statearr_22689[(10)] = inst_22623);

(statearr_22689[(11)] = inst_22625);

(statearr_22689[(12)] = inst_22624);

return statearr_22689;
})();
var statearr_22690_22723 = state_22670__$1;
(statearr_22690_22723[(2)] = null);

(statearr_22690_22723[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (3))){
var inst_22668 = (state_22670[(2)]);
var state_22670__$1 = state_22670;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22670__$1,inst_22668);
} else {
if((state_val_22671 === (12))){
var inst_22656 = (state_22670[(2)]);
var state_22670__$1 = state_22670;
var statearr_22691_22724 = state_22670__$1;
(statearr_22691_22724[(2)] = inst_22656);

(statearr_22691_22724[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (2))){
var state_22670__$1 = state_22670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22670__$1,(4),in$);
} else {
if((state_val_22671 === (23))){
var inst_22664 = (state_22670[(2)]);
var state_22670__$1 = state_22670;
var statearr_22692_22725 = state_22670__$1;
(statearr_22692_22725[(2)] = inst_22664);

(statearr_22692_22725[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (19))){
var inst_22651 = (state_22670[(2)]);
var state_22670__$1 = state_22670;
var statearr_22693_22726 = state_22670__$1;
(statearr_22693_22726[(2)] = inst_22651);

(statearr_22693_22726[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (11))){
var inst_22622 = (state_22670[(8)]);
var inst_22636 = (state_22670[(7)]);
var inst_22636__$1 = cljs.core.seq(inst_22622);
var state_22670__$1 = (function (){var statearr_22694 = state_22670;
(statearr_22694[(7)] = inst_22636__$1);

return statearr_22694;
})();
if(inst_22636__$1){
var statearr_22695_22727 = state_22670__$1;
(statearr_22695_22727[(1)] = (14));

} else {
var statearr_22696_22728 = state_22670__$1;
(statearr_22696_22728[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (9))){
var inst_22658 = (state_22670[(2)]);
var inst_22659 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_22670__$1 = (function (){var statearr_22697 = state_22670;
(statearr_22697[(15)] = inst_22658);

return statearr_22697;
})();
if(cljs.core.truth_(inst_22659)){
var statearr_22698_22729 = state_22670__$1;
(statearr_22698_22729[(1)] = (21));

} else {
var statearr_22699_22730 = state_22670__$1;
(statearr_22699_22730[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (5))){
var inst_22614 = cljs.core.async.close_BANG_(out);
var state_22670__$1 = state_22670;
var statearr_22700_22731 = state_22670__$1;
(statearr_22700_22731[(2)] = inst_22614);

(statearr_22700_22731[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (14))){
var inst_22636 = (state_22670[(7)]);
var inst_22638 = cljs.core.chunked_seq_QMARK_(inst_22636);
var state_22670__$1 = state_22670;
if(inst_22638){
var statearr_22701_22732 = state_22670__$1;
(statearr_22701_22732[(1)] = (17));

} else {
var statearr_22702_22733 = state_22670__$1;
(statearr_22702_22733[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (16))){
var inst_22654 = (state_22670[(2)]);
var state_22670__$1 = state_22670;
var statearr_22703_22734 = state_22670__$1;
(statearr_22703_22734[(2)] = inst_22654);

(statearr_22703_22734[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22671 === (10))){
var inst_22623 = (state_22670[(10)]);
var inst_22625 = (state_22670[(11)]);
var inst_22630 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_22623,inst_22625);
var state_22670__$1 = state_22670;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22670__$1,(13),out,inst_22630);
} else {
if((state_val_22671 === (18))){
var inst_22636 = (state_22670[(7)]);
var inst_22645 = cljs.core.first(inst_22636);
var state_22670__$1 = state_22670;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22670__$1,(20),out,inst_22645);
} else {
if((state_val_22671 === (8))){
var inst_22625 = (state_22670[(11)]);
var inst_22624 = (state_22670[(12)]);
var inst_22627 = (inst_22625 < inst_22624);
var inst_22628 = inst_22627;
var state_22670__$1 = state_22670;
if(cljs.core.truth_(inst_22628)){
var statearr_22704_22735 = state_22670__$1;
(statearr_22704_22735[(1)] = (10));

} else {
var statearr_22705_22736 = state_22670__$1;
(statearr_22705_22736[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto__))
;
return ((function (switch__10138__auto__,c__10205__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10139__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10139__auto____0 = (function (){
var statearr_22709 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22709[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10139__auto__);

(statearr_22709[(1)] = (1));

return statearr_22709;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10139__auto____1 = (function (state_22670){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_22670);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e22710){if((e22710 instanceof Object)){
var ex__10142__auto__ = e22710;
var statearr_22711_22737 = state_22670;
(statearr_22711_22737[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22670);

return cljs.core.cst$kw$recur;
} else {
throw e22710;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__22738 = state_22670;
state_22670 = G__22738;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10139__auto__ = function(state_22670){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10139__auto____1.call(this,state_22670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10139__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10139__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto__))
})();
var state__10207__auto__ = (function (){var statearr_22712 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_22712[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto__);

return statearr_22712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto__))
);

return c__10205__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args22739 = [];
var len__5627__auto___22742 = arguments.length;
var i__5628__auto___22743 = (0);
while(true){
if((i__5628__auto___22743 < len__5627__auto___22742)){
args22739.push((arguments[i__5628__auto___22743]));

var G__22744 = (i__5628__auto___22743 + (1));
i__5628__auto___22743 = G__22744;
continue;
} else {
}
break;
}

var G__22741 = args22739.length;
switch (G__22741) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22739.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args22746 = [];
var len__5627__auto___22749 = arguments.length;
var i__5628__auto___22750 = (0);
while(true){
if((i__5628__auto___22750 < len__5627__auto___22749)){
args22746.push((arguments[i__5628__auto___22750]));

var G__22751 = (i__5628__auto___22750 + (1));
i__5628__auto___22750 = G__22751;
continue;
} else {
}
break;
}

var G__22748 = args22746.length;
switch (G__22748) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22746.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args22753 = [];
var len__5627__auto___22804 = arguments.length;
var i__5628__auto___22805 = (0);
while(true){
if((i__5628__auto___22805 < len__5627__auto___22804)){
args22753.push((arguments[i__5628__auto___22805]));

var G__22806 = (i__5628__auto___22805 + (1));
i__5628__auto___22805 = G__22806;
continue;
} else {
}
break;
}

var G__22755 = args22753.length;
switch (G__22755) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22753.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__10205__auto___22808 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___22808,out){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___22808,out){
return (function (state_22779){
var state_val_22780 = (state_22779[(1)]);
if((state_val_22780 === (7))){
var inst_22774 = (state_22779[(2)]);
var state_22779__$1 = state_22779;
var statearr_22781_22809 = state_22779__$1;
(statearr_22781_22809[(2)] = inst_22774);

(statearr_22781_22809[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22780 === (1))){
var inst_22756 = null;
var state_22779__$1 = (function (){var statearr_22782 = state_22779;
(statearr_22782[(7)] = inst_22756);

return statearr_22782;
})();
var statearr_22783_22810 = state_22779__$1;
(statearr_22783_22810[(2)] = null);

(statearr_22783_22810[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22780 === (4))){
var inst_22759 = (state_22779[(8)]);
var inst_22759__$1 = (state_22779[(2)]);
var inst_22760 = (inst_22759__$1 == null);
var inst_22761 = cljs.core.not(inst_22760);
var state_22779__$1 = (function (){var statearr_22784 = state_22779;
(statearr_22784[(8)] = inst_22759__$1);

return statearr_22784;
})();
if(inst_22761){
var statearr_22785_22811 = state_22779__$1;
(statearr_22785_22811[(1)] = (5));

} else {
var statearr_22786_22812 = state_22779__$1;
(statearr_22786_22812[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22780 === (6))){
var state_22779__$1 = state_22779;
var statearr_22787_22813 = state_22779__$1;
(statearr_22787_22813[(2)] = null);

(statearr_22787_22813[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22780 === (3))){
var inst_22776 = (state_22779[(2)]);
var inst_22777 = cljs.core.async.close_BANG_(out);
var state_22779__$1 = (function (){var statearr_22788 = state_22779;
(statearr_22788[(9)] = inst_22776);

return statearr_22788;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_22779__$1,inst_22777);
} else {
if((state_val_22780 === (2))){
var state_22779__$1 = state_22779;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22779__$1,(4),ch);
} else {
if((state_val_22780 === (11))){
var inst_22759 = (state_22779[(8)]);
var inst_22768 = (state_22779[(2)]);
var inst_22756 = inst_22759;
var state_22779__$1 = (function (){var statearr_22789 = state_22779;
(statearr_22789[(7)] = inst_22756);

(statearr_22789[(10)] = inst_22768);

return statearr_22789;
})();
var statearr_22790_22814 = state_22779__$1;
(statearr_22790_22814[(2)] = null);

(statearr_22790_22814[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22780 === (9))){
var inst_22759 = (state_22779[(8)]);
var state_22779__$1 = state_22779;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22779__$1,(11),out,inst_22759);
} else {
if((state_val_22780 === (5))){
var inst_22759 = (state_22779[(8)]);
var inst_22756 = (state_22779[(7)]);
var inst_22763 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_22759,inst_22756);
var state_22779__$1 = state_22779;
if(inst_22763){
var statearr_22792_22815 = state_22779__$1;
(statearr_22792_22815[(1)] = (8));

} else {
var statearr_22793_22816 = state_22779__$1;
(statearr_22793_22816[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22780 === (10))){
var inst_22771 = (state_22779[(2)]);
var state_22779__$1 = state_22779;
var statearr_22794_22817 = state_22779__$1;
(statearr_22794_22817[(2)] = inst_22771);

(statearr_22794_22817[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22780 === (8))){
var inst_22756 = (state_22779[(7)]);
var tmp22791 = inst_22756;
var inst_22756__$1 = tmp22791;
var state_22779__$1 = (function (){var statearr_22795 = state_22779;
(statearr_22795[(7)] = inst_22756__$1);

return statearr_22795;
})();
var statearr_22796_22818 = state_22779__$1;
(statearr_22796_22818[(2)] = null);

(statearr_22796_22818[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto___22808,out))
;
return ((function (switch__10138__auto__,c__10205__auto___22808,out){
return (function() {
var cljs$core$async$state_machine__10139__auto__ = null;
var cljs$core$async$state_machine__10139__auto____0 = (function (){
var statearr_22800 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22800[(0)] = cljs$core$async$state_machine__10139__auto__);

(statearr_22800[(1)] = (1));

return statearr_22800;
});
var cljs$core$async$state_machine__10139__auto____1 = (function (state_22779){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_22779);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e22801){if((e22801 instanceof Object)){
var ex__10142__auto__ = e22801;
var statearr_22802_22819 = state_22779;
(statearr_22802_22819[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22779);

return cljs.core.cst$kw$recur;
} else {
throw e22801;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__22820 = state_22779;
state_22779 = G__22820;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$state_machine__10139__auto__ = function(state_22779){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10139__auto____1.call(this,state_22779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10139__auto____0;
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10139__auto____1;
return cljs$core$async$state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___22808,out))
})();
var state__10207__auto__ = (function (){var statearr_22803 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_22803[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___22808);

return statearr_22803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___22808,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args22821 = [];
var len__5627__auto___22891 = arguments.length;
var i__5628__auto___22892 = (0);
while(true){
if((i__5628__auto___22892 < len__5627__auto___22891)){
args22821.push((arguments[i__5628__auto___22892]));

var G__22893 = (i__5628__auto___22892 + (1));
i__5628__auto___22892 = G__22893;
continue;
} else {
}
break;
}

var G__22823 = args22821.length;
switch (G__22823) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22821.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__10205__auto___22895 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___22895,out){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___22895,out){
return (function (state_22861){
var state_val_22862 = (state_22861[(1)]);
if((state_val_22862 === (7))){
var inst_22857 = (state_22861[(2)]);
var state_22861__$1 = state_22861;
var statearr_22863_22896 = state_22861__$1;
(statearr_22863_22896[(2)] = inst_22857);

(statearr_22863_22896[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22862 === (1))){
var inst_22824 = (new Array(n));
var inst_22825 = inst_22824;
var inst_22826 = (0);
var state_22861__$1 = (function (){var statearr_22864 = state_22861;
(statearr_22864[(7)] = inst_22826);

(statearr_22864[(8)] = inst_22825);

return statearr_22864;
})();
var statearr_22865_22897 = state_22861__$1;
(statearr_22865_22897[(2)] = null);

(statearr_22865_22897[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22862 === (4))){
var inst_22829 = (state_22861[(9)]);
var inst_22829__$1 = (state_22861[(2)]);
var inst_22830 = (inst_22829__$1 == null);
var inst_22831 = cljs.core.not(inst_22830);
var state_22861__$1 = (function (){var statearr_22866 = state_22861;
(statearr_22866[(9)] = inst_22829__$1);

return statearr_22866;
})();
if(inst_22831){
var statearr_22867_22898 = state_22861__$1;
(statearr_22867_22898[(1)] = (5));

} else {
var statearr_22868_22899 = state_22861__$1;
(statearr_22868_22899[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22862 === (15))){
var inst_22851 = (state_22861[(2)]);
var state_22861__$1 = state_22861;
var statearr_22869_22900 = state_22861__$1;
(statearr_22869_22900[(2)] = inst_22851);

(statearr_22869_22900[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22862 === (13))){
var state_22861__$1 = state_22861;
var statearr_22870_22901 = state_22861__$1;
(statearr_22870_22901[(2)] = null);

(statearr_22870_22901[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22862 === (6))){
var inst_22826 = (state_22861[(7)]);
var inst_22847 = (inst_22826 > (0));
var state_22861__$1 = state_22861;
if(cljs.core.truth_(inst_22847)){
var statearr_22871_22902 = state_22861__$1;
(statearr_22871_22902[(1)] = (12));

} else {
var statearr_22872_22903 = state_22861__$1;
(statearr_22872_22903[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22862 === (3))){
var inst_22859 = (state_22861[(2)]);
var state_22861__$1 = state_22861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22861__$1,inst_22859);
} else {
if((state_val_22862 === (12))){
var inst_22825 = (state_22861[(8)]);
var inst_22849 = cljs.core.vec(inst_22825);
var state_22861__$1 = state_22861;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22861__$1,(15),out,inst_22849);
} else {
if((state_val_22862 === (2))){
var state_22861__$1 = state_22861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22861__$1,(4),ch);
} else {
if((state_val_22862 === (11))){
var inst_22841 = (state_22861[(2)]);
var inst_22842 = (new Array(n));
var inst_22825 = inst_22842;
var inst_22826 = (0);
var state_22861__$1 = (function (){var statearr_22873 = state_22861;
(statearr_22873[(7)] = inst_22826);

(statearr_22873[(8)] = inst_22825);

(statearr_22873[(10)] = inst_22841);

return statearr_22873;
})();
var statearr_22874_22904 = state_22861__$1;
(statearr_22874_22904[(2)] = null);

(statearr_22874_22904[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22862 === (9))){
var inst_22825 = (state_22861[(8)]);
var inst_22839 = cljs.core.vec(inst_22825);
var state_22861__$1 = state_22861;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22861__$1,(11),out,inst_22839);
} else {
if((state_val_22862 === (5))){
var inst_22834 = (state_22861[(11)]);
var inst_22826 = (state_22861[(7)]);
var inst_22825 = (state_22861[(8)]);
var inst_22829 = (state_22861[(9)]);
var inst_22833 = (inst_22825[inst_22826] = inst_22829);
var inst_22834__$1 = (inst_22826 + (1));
var inst_22835 = (inst_22834__$1 < n);
var state_22861__$1 = (function (){var statearr_22875 = state_22861;
(statearr_22875[(11)] = inst_22834__$1);

(statearr_22875[(12)] = inst_22833);

return statearr_22875;
})();
if(cljs.core.truth_(inst_22835)){
var statearr_22876_22905 = state_22861__$1;
(statearr_22876_22905[(1)] = (8));

} else {
var statearr_22877_22906 = state_22861__$1;
(statearr_22877_22906[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22862 === (14))){
var inst_22854 = (state_22861[(2)]);
var inst_22855 = cljs.core.async.close_BANG_(out);
var state_22861__$1 = (function (){var statearr_22879 = state_22861;
(statearr_22879[(13)] = inst_22854);

return statearr_22879;
})();
var statearr_22880_22907 = state_22861__$1;
(statearr_22880_22907[(2)] = inst_22855);

(statearr_22880_22907[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22862 === (10))){
var inst_22845 = (state_22861[(2)]);
var state_22861__$1 = state_22861;
var statearr_22881_22908 = state_22861__$1;
(statearr_22881_22908[(2)] = inst_22845);

(statearr_22881_22908[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22862 === (8))){
var inst_22834 = (state_22861[(11)]);
var inst_22825 = (state_22861[(8)]);
var tmp22878 = inst_22825;
var inst_22825__$1 = tmp22878;
var inst_22826 = inst_22834;
var state_22861__$1 = (function (){var statearr_22882 = state_22861;
(statearr_22882[(7)] = inst_22826);

(statearr_22882[(8)] = inst_22825__$1);

return statearr_22882;
})();
var statearr_22883_22909 = state_22861__$1;
(statearr_22883_22909[(2)] = null);

(statearr_22883_22909[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto___22895,out))
;
return ((function (switch__10138__auto__,c__10205__auto___22895,out){
return (function() {
var cljs$core$async$state_machine__10139__auto__ = null;
var cljs$core$async$state_machine__10139__auto____0 = (function (){
var statearr_22887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22887[(0)] = cljs$core$async$state_machine__10139__auto__);

(statearr_22887[(1)] = (1));

return statearr_22887;
});
var cljs$core$async$state_machine__10139__auto____1 = (function (state_22861){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_22861);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e22888){if((e22888 instanceof Object)){
var ex__10142__auto__ = e22888;
var statearr_22889_22910 = state_22861;
(statearr_22889_22910[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22861);

return cljs.core.cst$kw$recur;
} else {
throw e22888;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__22911 = state_22861;
state_22861 = G__22911;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$state_machine__10139__auto__ = function(state_22861){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10139__auto____1.call(this,state_22861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10139__auto____0;
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10139__auto____1;
return cljs$core$async$state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___22895,out))
})();
var state__10207__auto__ = (function (){var statearr_22890 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_22890[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___22895);

return statearr_22890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___22895,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args22912 = [];
var len__5627__auto___22986 = arguments.length;
var i__5628__auto___22987 = (0);
while(true){
if((i__5628__auto___22987 < len__5627__auto___22986)){
args22912.push((arguments[i__5628__auto___22987]));

var G__22988 = (i__5628__auto___22987 + (1));
i__5628__auto___22987 = G__22988;
continue;
} else {
}
break;
}

var G__22914 = args22912.length;
switch (G__22914) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22912.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__10205__auto___22990 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto___22990,out){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto___22990,out){
return (function (state_22956){
var state_val_22957 = (state_22956[(1)]);
if((state_val_22957 === (7))){
var inst_22952 = (state_22956[(2)]);
var state_22956__$1 = state_22956;
var statearr_22958_22991 = state_22956__$1;
(statearr_22958_22991[(2)] = inst_22952);

(statearr_22958_22991[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22957 === (1))){
var inst_22915 = [];
var inst_22916 = inst_22915;
var inst_22917 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_22956__$1 = (function (){var statearr_22959 = state_22956;
(statearr_22959[(7)] = inst_22917);

(statearr_22959[(8)] = inst_22916);

return statearr_22959;
})();
var statearr_22960_22992 = state_22956__$1;
(statearr_22960_22992[(2)] = null);

(statearr_22960_22992[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22957 === (4))){
var inst_22920 = (state_22956[(9)]);
var inst_22920__$1 = (state_22956[(2)]);
var inst_22921 = (inst_22920__$1 == null);
var inst_22922 = cljs.core.not(inst_22921);
var state_22956__$1 = (function (){var statearr_22961 = state_22956;
(statearr_22961[(9)] = inst_22920__$1);

return statearr_22961;
})();
if(inst_22922){
var statearr_22962_22993 = state_22956__$1;
(statearr_22962_22993[(1)] = (5));

} else {
var statearr_22963_22994 = state_22956__$1;
(statearr_22963_22994[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22957 === (15))){
var inst_22946 = (state_22956[(2)]);
var state_22956__$1 = state_22956;
var statearr_22964_22995 = state_22956__$1;
(statearr_22964_22995[(2)] = inst_22946);

(statearr_22964_22995[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22957 === (13))){
var state_22956__$1 = state_22956;
var statearr_22965_22996 = state_22956__$1;
(statearr_22965_22996[(2)] = null);

(statearr_22965_22996[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22957 === (6))){
var inst_22916 = (state_22956[(8)]);
var inst_22941 = inst_22916.length;
var inst_22942 = (inst_22941 > (0));
var state_22956__$1 = state_22956;
if(cljs.core.truth_(inst_22942)){
var statearr_22966_22997 = state_22956__$1;
(statearr_22966_22997[(1)] = (12));

} else {
var statearr_22967_22998 = state_22956__$1;
(statearr_22967_22998[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22957 === (3))){
var inst_22954 = (state_22956[(2)]);
var state_22956__$1 = state_22956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22956__$1,inst_22954);
} else {
if((state_val_22957 === (12))){
var inst_22916 = (state_22956[(8)]);
var inst_22944 = cljs.core.vec(inst_22916);
var state_22956__$1 = state_22956;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22956__$1,(15),out,inst_22944);
} else {
if((state_val_22957 === (2))){
var state_22956__$1 = state_22956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22956__$1,(4),ch);
} else {
if((state_val_22957 === (11))){
var inst_22924 = (state_22956[(10)]);
var inst_22920 = (state_22956[(9)]);
var inst_22934 = (state_22956[(2)]);
var inst_22935 = [];
var inst_22936 = inst_22935.push(inst_22920);
var inst_22916 = inst_22935;
var inst_22917 = inst_22924;
var state_22956__$1 = (function (){var statearr_22968 = state_22956;
(statearr_22968[(7)] = inst_22917);

(statearr_22968[(11)] = inst_22934);

(statearr_22968[(12)] = inst_22936);

(statearr_22968[(8)] = inst_22916);

return statearr_22968;
})();
var statearr_22969_22999 = state_22956__$1;
(statearr_22969_22999[(2)] = null);

(statearr_22969_22999[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22957 === (9))){
var inst_22916 = (state_22956[(8)]);
var inst_22932 = cljs.core.vec(inst_22916);
var state_22956__$1 = state_22956;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22956__$1,(11),out,inst_22932);
} else {
if((state_val_22957 === (5))){
var inst_22917 = (state_22956[(7)]);
var inst_22924 = (state_22956[(10)]);
var inst_22920 = (state_22956[(9)]);
var inst_22924__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_22920) : f.call(null,inst_22920));
var inst_22925 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_22924__$1,inst_22917);
var inst_22926 = cljs.core.keyword_identical_QMARK_(inst_22917,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_22927 = (inst_22925) || (inst_22926);
var state_22956__$1 = (function (){var statearr_22970 = state_22956;
(statearr_22970[(10)] = inst_22924__$1);

return statearr_22970;
})();
if(cljs.core.truth_(inst_22927)){
var statearr_22971_23000 = state_22956__$1;
(statearr_22971_23000[(1)] = (8));

} else {
var statearr_22972_23001 = state_22956__$1;
(statearr_22972_23001[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22957 === (14))){
var inst_22949 = (state_22956[(2)]);
var inst_22950 = cljs.core.async.close_BANG_(out);
var state_22956__$1 = (function (){var statearr_22974 = state_22956;
(statearr_22974[(13)] = inst_22949);

return statearr_22974;
})();
var statearr_22975_23002 = state_22956__$1;
(statearr_22975_23002[(2)] = inst_22950);

(statearr_22975_23002[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22957 === (10))){
var inst_22939 = (state_22956[(2)]);
var state_22956__$1 = state_22956;
var statearr_22976_23003 = state_22956__$1;
(statearr_22976_23003[(2)] = inst_22939);

(statearr_22976_23003[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22957 === (8))){
var inst_22924 = (state_22956[(10)]);
var inst_22916 = (state_22956[(8)]);
var inst_22920 = (state_22956[(9)]);
var inst_22929 = inst_22916.push(inst_22920);
var tmp22973 = inst_22916;
var inst_22916__$1 = tmp22973;
var inst_22917 = inst_22924;
var state_22956__$1 = (function (){var statearr_22977 = state_22956;
(statearr_22977[(14)] = inst_22929);

(statearr_22977[(7)] = inst_22917);

(statearr_22977[(8)] = inst_22916__$1);

return statearr_22977;
})();
var statearr_22978_23004 = state_22956__$1;
(statearr_22978_23004[(2)] = null);

(statearr_22978_23004[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto___22990,out))
;
return ((function (switch__10138__auto__,c__10205__auto___22990,out){
return (function() {
var cljs$core$async$state_machine__10139__auto__ = null;
var cljs$core$async$state_machine__10139__auto____0 = (function (){
var statearr_22982 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22982[(0)] = cljs$core$async$state_machine__10139__auto__);

(statearr_22982[(1)] = (1));

return statearr_22982;
});
var cljs$core$async$state_machine__10139__auto____1 = (function (state_22956){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_22956);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e22983){if((e22983 instanceof Object)){
var ex__10142__auto__ = e22983;
var statearr_22984_23005 = state_22956;
(statearr_22984_23005[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22956);

return cljs.core.cst$kw$recur;
} else {
throw e22983;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__23006 = state_22956;
state_22956 = G__23006;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
cljs$core$async$state_machine__10139__auto__ = function(state_22956){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10139__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10139__auto____1.call(this,state_22956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10139__auto____0;
cljs$core$async$state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10139__auto____1;
return cljs$core$async$state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto___22990,out))
})();
var state__10207__auto__ = (function (){var statearr_22985 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_22985[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto___22990);

return statearr_22985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto___22990,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
