// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.charting');
goog.require('cljs.core');
goog.require('c2.layout.histogram');
goog.require('hatti.maths');
goog.require('cljs_time.coerce');
goog.require('c2.scale');
goog.require('cljs_time.format');
goog.require('hatti.ona.forms');
goog.require('hatti.utils');
goog.require('c2.svg');
goog.require('clojure.string');
hatti.charting.millis_in_day = (86400000);
/**
 * Parse an integer from a string.
 */
hatti.charting.parse_int = (function hatti$charting$parse_int(st){
var ans = parseInt(st);
if(cljs.core.truth_(isNaN(ans))){
return null;
} else {
return ans;
}
});
/**
 * Converts string to integer, for typ (int|date).
 */
hatti.charting.str__GT_int = (function hatti$charting$str__GT_int(typ){
var G__13425 = typ;
switch (G__13425) {
case "int":
return hatti.charting.parse_int;

break;
case "date":
return ((function (G__13425){
return (function (date_string){
if(cljs.core.truth_(date_string)){
return hatti.maths.floor((cljs_time.coerce.to_long((new Date(date_string))) / hatti.charting.millis_in_day));
} else {
return null;
}
});
;})(G__13425))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});
/**
 * Converts integers to strings, for type (int|date).
 * Optional digits parameter = number of digits after decimal, default is 1.
 */
hatti.charting.int__GT_str = (function hatti$charting$int__GT_str(var_args){
var args__5634__auto__ = [];
var len__5627__auto___13437 = arguments.length;
var i__5628__auto___13438 = (0);
while(true){
if((i__5628__auto___13438 < len__5627__auto___13437)){
args__5634__auto__.push((arguments[i__5628__auto___13438]));

var G__13439 = (i__5628__auto___13438 + (1));
i__5628__auto___13438 = G__13439;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic = (function (typ,p__13433){
var map__13434 = p__13433;
var map__13434__$1 = ((((!((map__13434 == null)))?((((map__13434.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13434.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13434):map__13434);
var digits = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__13434__$1,cljs.core.cst$kw$digits,(1));
var int_fmt_s = [cljs.core.str("%."),cljs.core.str(digits),cljs.core.str("f")].join('');
var d__GT_millis = ((function (int_fmt_s,map__13434,map__13434__$1,digits){
return (function (p1__13427_SHARP_){
return (hatti.charting.millis_in_day * p1__13427_SHARP_);
});})(int_fmt_s,map__13434,map__13434__$1,digits))
;
var date__GT_str = ((function (int_fmt_s,d__GT_millis,map__13434,map__13434__$1,digits){
return (function (p1__13428_SHARP_){
if(cljs.core.truth_(p1__13428_SHARP_)){
return moment(p1__13428_SHARP_).format("ll");
} else {
return null;
}
});})(int_fmt_s,d__GT_millis,map__13434,map__13434__$1,digits))
;
var G__13436 = typ;
switch (G__13436) {
case "int":
return ((function (G__13436,int_fmt_s,d__GT_millis,date__GT_str,map__13434,map__13434__$1,digits){
return (function (p1__13429_SHARP_){
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic(int_fmt_s,cljs.core.array_seq([p1__13429_SHARP_], 0));
});
;})(G__13436,int_fmt_s,d__GT_millis,date__GT_str,map__13434,map__13434__$1,digits))

break;
case "date":
return ((function (G__13436,int_fmt_s,d__GT_millis,date__GT_str,map__13434,map__13434__$1,digits){
return (function (p1__13430_SHARP_){
return date__GT_str(d__GT_millis(p1__13430_SHARP_));
});
;})(G__13436,int_fmt_s,d__GT_millis,date__GT_str,map__13434,map__13434__$1,digits))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});

hatti.charting.int__GT_str.cljs$lang$maxFixedArity = (1);

hatti.charting.int__GT_str.cljs$lang$applyTo = (function (seq13431){
var G__13432 = cljs.core.first(seq13431);
var seq13431__$1 = cljs.core.next(seq13431);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(G__13432,seq13431__$1);
});
/**
 * Converts a range of typ (int|date) to a string.
 */
hatti.charting.range__GT_str = (function hatti$charting$range__GT_str(p__13441,typ){
var vec__13444 = p__13441;
var mn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13444,(0),null);
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13444,(1),null);
var vec__13445 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.maths.ceil(mn),hatti.maths.floor(mx)], null);
var mn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13445,(0),null);
var mx__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13445,(1),null);
var fmt = hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(typ,cljs.core.array_seq([cljs.core.cst$kw$digits,(0)], 0));
if((mx__$1 <= mn__$1)){
return (fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(mn__$1) : fmt.call(null,mn__$1));
} else {
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" to ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(mn__$1) : fmt.call(null,mn__$1)),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(mx__$1) : fmt.call(null,mx__$1))], null));
}
});
/**
 * Given a list of answers, returns each one as a bin, in string form.
 * nil is mapped to nil. The bins, in order, are returned as metadata.
 * eg. (evenly-spaced-bins [1 2 10] 5 'int') => ['1 to 2' '1 to 2' '9 to 10']
 * metadata of this above value would be:
 * {:bins ['1 to 2', '3 to 4', '5 to 6', '7 to 8', '9 to 10']}
 */
hatti.charting.evenly_spaced_bins = (function hatti$charting$evenly_spaced_bins(answers,bins,typ){
var numbers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.charting.str__GT_int(typ),answers);
var mx = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,numbers));
var mn = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,numbers));
var s = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(bins - ((1) / (10000)))], null)], 0));
var is = cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.maths.floor,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s){
return (function (p1__13446_SHARP_){
if(cljs.core.truth_(p1__13446_SHARP_)){
return (s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(p1__13446_SHARP_) : s.call(null,p1__13446_SHARP_));
} else {
return null;
}
});})(numbers,mx,mn,s))
,numbers));
var t = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),bins], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null)], 0));
var lbounds = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.float$,cljs.core.map.cljs$core$IFn$_invoke$arity$2(t,cljs.core.range.cljs$core$IFn$_invoke$arity$1(bins))));
var ubounds = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s,is,t,lbounds){
return (function (p1__13447_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__13447_SHARP_,hatti.maths.floor(p1__13447_SHARP_))){
return (p1__13447_SHARP_ - (1));
} else {
return p1__13447_SHARP_;
}
});})(numbers,mx,mn,s,is,t,lbounds))
,cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),lbounds)),mx);
var fmt = hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(typ,cljs.core.array_seq([cljs.core.cst$kw$digits,(0)], 0));
var strings = cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt){
return (function (p1__13448_SHARP_,p2__13449_SHARP_){
return hatti.charting.range__GT_str(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13448_SHARP_,p2__13449_SHARP_], null),typ);
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt))
,lbounds,ubounds);
var results = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings){
return (function (i){
if(cljs.core.truth_(i)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(strings,(i | (0)));
} else {
return null;
}
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings))
,is);
var strings__$1 = cljs.core.vec(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(strings));
return cljs.core.with_meta(results,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$bins,((cljs.core.contains_QMARK_(cljs.core.set(answers),null))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(strings__$1,null):strings__$1)], null));
});
/**
 * Take chart-data from the ona API, returns label->count map.
 * eg. Input: {:field_xpath 'D' :data [{:count 2 :D ['Option_1']}]}
 * Output: {:Option_1 2}
 * eg. Input: {:field_xpath 'D' :data [{:count 1 :D ['O1' 'O_2']
 * :count 2 :D ['O1']}]}
 * Output: {:Option_1 3 :O_2 1}
 */
hatti.charting.label_count_pairs = (function hatti$charting$label_count_pairs(var_args){
var args13452 = [];
var len__5627__auto___13463 = arguments.length;
var i__5628__auto___13464 = (0);
while(true){
if((i__5628__auto___13464 < len__5627__auto___13463)){
args13452.push((arguments[i__5628__auto___13464]));

var G__13465 = (i__5628__auto___13464 + (1));
i__5628__auto___13464 = G__13465;
continue;
} else {
}
break;
}

var G__13454 = args13452.length;
switch (G__13454) {
case 1:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13452.length)].join('')));

}
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2(chart_data,null);
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__13455 = chart_data;
var map__13455__$1 = ((((!((map__13455 == null)))?((((map__13455.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13455.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13455):map__13455);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13455__$1,cljs.core.cst$kw$data);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13455__$1,cljs.core.cst$kw$field_xpath);
var unboxed = (function (){var iter__5341__auto__ = ((function (map__13455,map__13455__$1,data,field_xpath){
return (function hatti$charting$iter__13457(s__13458){
return (new cljs.core.LazySeq(null,((function (map__13455,map__13455__$1,data,field_xpath){
return (function (){
var s__13458__$1 = s__13458;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__13458__$1);
if(temp__4425__auto__){
var s__13458__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__13458__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__13458__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__13460 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__13459 = (0);
while(true){
if((i__13459 < size__5340__auto__)){
var data_item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__13459);
cljs.core.chunk_append(b__13460,(function (){var labels = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,data_item);
var count = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (i__13459,labels,count,data_item,c__5339__auto__,size__5340__auto__,b__13460,s__13458__$2,temp__4425__auto__,map__13455,map__13455__$1,data,field_xpath){
return (function (p1__13450_SHARP_){
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,p1__13450_SHARP_], null),cljs.core.array_seq([language], 0));
});})(i__13459,labels,count,data_item,c__5339__auto__,size__5340__auto__,b__13460,s__13458__$2,temp__4425__auto__,map__13455,map__13455__$1,data,field_xpath))
;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__13459,labels,count,labelify,data_item,c__5339__auto__,size__5340__auto__,b__13460,s__13458__$2,temp__4425__auto__,map__13455,map__13455__$1,data,field_xpath){
return (function (p1__13451_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify(p1__13451_SHARP_)],[count]);
});})(i__13459,labels,count,labelify,data_item,c__5339__auto__,size__5340__auto__,b__13460,s__13458__$2,temp__4425__auto__,map__13455,map__13455__$1,data,field_xpath))
,labels);
})());

var G__13467 = (i__13459 + (1));
i__13459 = G__13467;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__13460),hatti$charting$iter__13457(cljs.core.chunk_rest(s__13458__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__13460),null);
}
} else {
var data_item = cljs.core.first(s__13458__$2);
return cljs.core.cons((function (){var labels = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,data_item);
var count = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (labels,count,data_item,s__13458__$2,temp__4425__auto__,map__13455,map__13455__$1,data,field_xpath){
return (function (p1__13450_SHARP_){
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,p1__13450_SHARP_], null),cljs.core.array_seq([language], 0));
});})(labels,count,data_item,s__13458__$2,temp__4425__auto__,map__13455,map__13455__$1,data,field_xpath))
;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (labels,count,labelify,data_item,s__13458__$2,temp__4425__auto__,map__13455,map__13455__$1,data,field_xpath){
return (function (p1__13451_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify(p1__13451_SHARP_)],[count]);
});})(labels,count,labelify,data_item,s__13458__$2,temp__4425__auto__,map__13455,map__13455__$1,data,field_xpath))
,labels);
})(),hatti$charting$iter__13457(cljs.core.rest(s__13458__$2)));
}
} else {
return null;
}
break;
}
});})(map__13455,map__13455__$1,data,field_xpath))
,null,null));
});})(map__13455,map__13455__$1,data,field_xpath))
;
return iter__5341__auto__(data);
})();
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.last,cljs.core._GT_,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,cljs.core._PLUS_,cljs.core.flatten(unboxed)));
});

hatti.charting.label_count_pairs.cljs$lang$maxFixedArity = 2;
/**
 * Determine number of bins if there are n possible of values of data.
 *   Custom algorithm, based on a pleasant range of bins being between
 *   roughly 7 and 15 (though customizable). Idea is that we try to divide
 *   n into a number between 
 */
hatti.charting.num_bins = (function hatti$charting$num_bins(var_args){
var args__5634__auto__ = [];
var len__5627__auto___13473 = arguments.length;
var i__5628__auto___13474 = (0);
while(true){
if((i__5628__auto___13474 < len__5627__auto___13473)){
args__5634__auto__.push((arguments[i__5628__auto___13474]));

var G__13475 = (i__5628__auto___13474 + (1));
i__5628__auto___13474 = G__13475;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__13470){
var map__13471 = p__13470;
var map__13471__$1 = ((((!((map__13471 == null)))?((((map__13471.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13471.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13471):map__13471);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__13471__$1,cljs.core.cst$kw$data_DASH_type,"int");
var rough_min = (7);
var rough_max = (15);
var real_max = (24);
var full_range = cljs.core.range.cljs$core$IFn$_invoke$arity$2(rough_min,rough_max);
var best_guess = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.maths.gcd,n),full_range));
if((best_guess < rough_min)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(cljs.core.min,real_max,n),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.maths.lcm,n),full_range));
} else {
return best_guess;
}
});

hatti.charting.num_bins.cljs$lang$maxFixedArity = (1);

hatti.charting.num_bins.cljs$lang$applyTo = (function (seq13468){
var G__13469 = cljs.core.first(seq13468);
var seq13468__$1 = cljs.core.next(seq13468);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(G__13469,seq13468__$1);
});
/**
 * Turn numerical / date chart-data from ona API histogram-friendly.
 *   Return data looks like [(x dx y)] with-meta {:bins num-bins}.
 */
hatti.charting.extract_data_for_histogram = (function hatti$charting$extract_data_for_histogram(var_args){
var args__5634__auto__ = [];
var len__5627__auto___13489 = arguments.length;
var i__5628__auto___13490 = (0);
while(true){
if((i__5628__auto___13490 < len__5627__auto___13489)){
args__5634__auto__.push((arguments[i__5628__auto___13490]));

var G__13491 = (i__5628__auto___13490 + (1));
i__5628__auto___13490 = G__13491;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__13478){
var map__13479 = p__13478;
var map__13479__$1 = ((((!((map__13479 == null)))?((((map__13479.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13479.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13479):map__13479);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__13479__$1,cljs.core.cst$kw$data_DASH_type,"int");
var map__13481 = chart_data;
var map__13481__$1 = ((((!((map__13481 == null)))?((((map__13481.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13481.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13481):map__13481);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13481__$1,cljs.core.cst$kw$data);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13481__$1,cljs.core.cst$kw$field_xpath);
var retype_fn = hatti.charting.str__GT_int(data_type);
var qn_key = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath);
var retyped_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__13481,map__13481__$1,data,field_xpath,retype_fn,qn_key,map__13479,map__13479__$1,data_type){
return (function (el){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(el,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [qn_key], null),retype_fn);
});})(map__13481,map__13481__$1,data,field_xpath,retype_fn,qn_key,map__13479,map__13479__$1,data_type))
,data);
var data_range = (cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(qn_key,retyped_data)) - cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.map.cljs$core$IFn$_invoke$arity$2(qn_key,retyped_data)));
var bins = (((data_range === (0)))?(1):hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(data_range,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,data_type], 0)));
var binned_data = c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic(retyped_data,cljs.core.array_seq([cljs.core.cst$kw$value,qn_key,cljs.core.cst$kw$bins,bins], 0));
return cljs.core.with_meta((function (){var iter__5341__auto__ = ((function (map__13481,map__13481__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__13479,map__13479__$1,data_type){
return (function hatti$charting$iter__13483(s__13484){
return (new cljs.core.LazySeq(null,((function (map__13481,map__13481__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__13479,map__13479__$1,data_type){
return (function (){
var s__13484__$1 = s__13484;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__13484__$1);
if(temp__4425__auto__){
var s__13484__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__13484__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__13484__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__13486 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__13485 = (0);
while(true){
if((i__13485 < size__5340__auto__)){
var data_item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__13485);
cljs.core.chunk_append(b__13486,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.cst$kw$dx.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data_item))], null));

var G__13492 = (i__13485 + (1));
i__13485 = G__13492;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__13486),hatti$charting$iter__13483(cljs.core.chunk_rest(s__13484__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__13486),null);
}
} else {
var data_item = cljs.core.first(s__13484__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.cst$kw$dx.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data_item))], null),hatti$charting$iter__13483(cljs.core.rest(s__13484__$2)));
}
} else {
return null;
}
break;
}
});})(map__13481,map__13481__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__13479,map__13479__$1,data_type))
,null,null));
});})(map__13481,map__13481__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__13479,map__13479__$1,data_type))
;
return iter__5341__auto__(binned_data);
})(),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$bins,bins], null));
});

hatti.charting.extract_data_for_histogram.cljs$lang$maxFixedArity = (1);

hatti.charting.extract_data_for_histogram.cljs$lang$applyTo = (function (seq13476){
var G__13477 = cljs.core.first(seq13476);
var seq13476__$1 = cljs.core.next(seq13476);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(G__13477,seq13476__$1);
});
/**
 * Produces a linear mapping [0,max-count] -> [0, max-length], for data which
 * is a vector, each element a map with key :count. If total-asmax?, then
 * linear map is [0,total-count] -> [0, max-length].
 */
hatti.charting.counts__GT_lengths = (function hatti$charting$counts__GT_lengths(var_args){
var args__5634__auto__ = [];
var len__5627__auto___13499 = arguments.length;
var i__5628__auto___13500 = (0);
while(true){
if((i__5628__auto___13500 < len__5627__auto___13499)){
args__5634__auto__.push((arguments[i__5628__auto___13500]));

var G__13501 = (i__5628__auto___13500 + (1));
i__5628__auto___13500 = G__13501;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic = (function (data,max_length,p__13496){
var map__13497 = p__13496;
var map__13497__$1 = ((((!((map__13497 == null)))?((((map__13497.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13497.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13497):map__13497);
var total_as_max_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13497__$1,cljs.core.cst$kw$total_DASH_as_DASH_max_QMARK_);
var datamin_as_min_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13497__$1,cljs.core.cst$kw$datamin_DASH_as_DASH_min_QMARK_);
var counts = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data);
var xmax = (cljs.core.truth_(total_as_max_QMARK_)?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),counts):cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(0),counts));
var xmin = (cljs.core.truth_(datamin_as_min_QMARK_)?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(0),counts):(0));
var scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),max_length], null)], 0));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(scale,counts);
});

hatti.charting.counts__GT_lengths.cljs$lang$maxFixedArity = (2);

hatti.charting.counts__GT_lengths.cljs$lang$applyTo = (function (seq13493){
var G__13494 = cljs.core.first(seq13493);
var seq13493__$1 = cljs.core.next(seq13493);
var G__13495 = cljs.core.first(seq13493__$1);
var seq13493__$2 = cljs.core.next(seq13493__$1);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic(G__13494,G__13495,seq13493__$2);
});
hatti.charting.response_count_message = (function hatti$charting$response_count_message(response_count){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$t_DASH_right$t_DASH_grey,[cljs.core.str("Based on "),cljs.core.str(response_count),cljs.core.str(" responses.")].join('')], null);
});
/**
 * Create numeric (or date) chart out of some chart-data from ona API.
 */
hatti.charting.numeric_chart = (function hatti$charting$numeric_chart(var_args){
var args__5634__auto__ = [];
var len__5627__auto___13530 = arguments.length;
var i__5628__auto___13531 = (0);
while(true){
if((i__5628__auto___13531 < len__5627__auto___13530)){
args__5634__auto__.push((arguments[i__5628__auto___13531]));

var G__13532 = (i__5628__auto___13531 + (1));
i__5628__auto___13531 = G__13532;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__13504){
var map__13505 = p__13504;
var map__13505__$1 = ((((!((map__13505 == null)))?((((map__13505.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13505.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13505):map__13505);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__13505__$1,cljs.core.cst$kw$data_DASH_type,"int");
var chart_width = 700.0;
var chart_height = 300.0;
var margin = 33.0;
var small_margin = 2.0;
var y_lim = 8.0;
var neg_margin = (-15);
var extracted_data = hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(chart_data,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,data_type], 0));
var map__13507 = cljs.core.meta(chart_data);
var map__13507__$1 = ((((!((map__13507 == null)))?((((map__13507.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13507.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13507):map__13507);
var nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13507__$1,cljs.core.cst$kw$nil_DASH_count);
var non_nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13507__$1,cljs.core.cst$kw$non_DASH_nil_DASH_count);
var bins = cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(extracted_data));
var x_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,extracted_data);
var dx_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.second,extracted_data);
var y_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.last,extracted_data);
var xmin = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,x_series);
var xmax = (cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,x_series) + cljs.core.last(dx_series));
var x_scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_width], null)], 0));
var y_scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,y_series)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null)], 0));
var bin_width = hatti.maths.floor(((chart_width / bins) - small_margin));
var x_ticks = cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((2),cljs.core.rest(x_series));
var fmt = hatti.charting.int__GT_str(data_type);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(extracted_data))){
var vec__13509 = cljs.core.first(extracted_data);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13509,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13509,(1),null);
var total = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13509,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,total," records have identical value: ",(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(value) : fmt.call(null,value))], null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,(margin + chart_width),cljs.core.cst$kw$height,(margin + chart_height)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$chart,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [margin,(0)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,(function (){var iter__5341__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__13507,map__13507__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__13505,map__13505__$1,data_type){
return (function hatti$charting$iter__13510(s__13511){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__13507,map__13507__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__13505,map__13505__$1,data_type){
return (function (){
var s__13511__$1 = s__13511;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__13511__$1);
if(temp__4425__auto__){
var s__13511__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__13511__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__13511__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__13513 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__13512 = (0);
while(true){
if((i__13512 < size__5340__auto__)){
var vec__13520 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__13512);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13520,(0),null);
var dx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13520,(1),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13520,(2),null);
cljs.core.chunk_append(b__13513,(function (){var x_scaled = (x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x));
var y_scaled = (y_scale.cljs$core$IFn$_invoke$arity$1 ? y_scale.cljs$core$IFn$_invoke$arity$1(y) : y_scale.call(null,y));
var vec__13521 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13521,(0),null);
var txt_ht = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13521,(1),null);
var txt_cls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13521,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$bars,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(1),cljs.core.cst$kw$height,y_scaled__$1,cljs.core.cst$kw$width,bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$y,txt_ht,cljs.core.cst$kw$x,(bin_width / 2.0),cljs.core.cst$kw$dy,"1em",cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,txt_cls], null),y], null):null)], null);
})());

var G__13533 = (i__13512 + (1));
i__13512 = G__13533;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__13513),hatti$charting$iter__13510(cljs.core.chunk_rest(s__13511__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__13513),null);
}
} else {
var vec__13522 = cljs.core.first(s__13511__$2);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13522,(0),null);
var dx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13522,(1),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13522,(2),null);
return cljs.core.cons((function (){var x_scaled = (x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x));
var y_scaled = (y_scale.cljs$core$IFn$_invoke$arity$1 ? y_scale.cljs$core$IFn$_invoke$arity$1(y) : y_scale.call(null,y));
var vec__13523 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13523,(0),null);
var txt_ht = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13523,(1),null);
var txt_cls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13523,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$bars,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(1),cljs.core.cst$kw$height,y_scaled__$1,cljs.core.cst$kw$width,bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$y,txt_ht,cljs.core.cst$kw$x,(bin_width / 2.0),cljs.core.cst$kw$dy,"1em",cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,txt_cls], null),y], null):null)], null);
})(),hatti$charting$iter__13510(cljs.core.rest(s__13511__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__13507,map__13507__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__13505,map__13505__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__13507,map__13507__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__13505,map__13505__$1,data_type))
;
return iter__5341__auto__(extracted_data);
})()], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$axis,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$x1,(0),cljs.core.cst$kw$x2,chart_width], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,(function (){var iter__5341__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__13507,map__13507__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__13505,map__13505__$1,data_type){
return (function hatti$charting$iter__13524(s__13525){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__13507,map__13507__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__13505,map__13505__$1,data_type){
return (function (){
var s__13525__$1 = s__13525;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__13525__$1);
if(temp__4425__auto__){
var s__13525__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__13525__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__13525__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__13527 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__13526 = (0);
while(true){
if((i__13526 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__13526);
cljs.core.chunk_append(b__13527,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$tick,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x)),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$y,(25),cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,data_type], null),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(x) : fmt.call(null,x))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,"tick",cljs.core.cst$kw$y2,(10),cljs.core.cst$kw$x2,(0)], null)], null)], null));

var G__13534 = (i__13526 + (1));
i__13526 = G__13534;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__13527),hatti$charting$iter__13524(cljs.core.chunk_rest(s__13525__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__13527),null);
}
} else {
var x = cljs.core.first(s__13525__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$tick,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x)),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$y,(25),cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,data_type], null),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(x) : fmt.call(null,x))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,"tick",cljs.core.cst$kw$y2,(10),cljs.core.cst$kw$x2,(0)], null)], null)], null),hatti$charting$iter__13524(cljs.core.rest(s__13525__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__13507,map__13507__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__13505,map__13505__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__13507,map__13507__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__13505,map__13505__$1,data_type))
;
return iter__5341__auto__(x_ticks);
})()], null)], null)], null)], null),hatti.charting.response_count_message(non_nil_count)], null);
}
});

hatti.charting.numeric_chart.cljs$lang$maxFixedArity = (1);

hatti.charting.numeric_chart.cljs$lang$applyTo = (function (seq13502){
var G__13503 = cljs.core.first(seq13502);
var seq13502__$1 = cljs.core.next(seq13502);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(G__13503,seq13502__$1);
});
/**
 * Create category bar chart out of some data + count data. Data of form:
 *   {'Label1' 1 'Label2' 2}, etc. where the numbers are counts.
 */
hatti.charting.table_chart_h = (function hatti$charting$table_chart_h(data,nil_count,non_nil_count,field_type){
var max_count = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.vals(data));
var percent_s = ((function (max_count){
return (function (n,total){
var s = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),total], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null)], 0));
return [cljs.core.str(hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic("%.1f",cljs.core.array_seq([(s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(n) : s.call(null,n))], 0))),cljs.core.str("%")].join('');
});})(max_count))
;
var select_mult_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(field_type,"select all that apply");
var bar_div = ((select_mult_QMARK_)?cljs.core.cst$kw$div$bars$select_DASH_mult:cljs.core.cst$kw$div$bars$select_DASH_one);
var tdr = cljs.core.cst$kw$td$t_DASH_right;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_SHARP_bar_DASH_chart$table,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$t_DASH_right,"Count"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$t_DASH_right,"Percent"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tfoot,((select_mult_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(4)], null),hatti.charting.response_count_message(non_nil_count)], null)], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"Total"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,non_nil_count], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"100%"], null)], null)),(((!(select_mult_QMARK_)) && ((nil_count > (0))))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,"No response"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,nil_count], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td], null)], null):null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,(function (){var iter__5341__auto__ = ((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function hatti$charting$table_chart_h_$_iter__13545(s__13546){
return (new cljs.core.LazySeq(null,((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function (){
var s__13546__$1 = s__13546;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__13546__$1);
if(temp__4425__auto__){
var s__13546__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__13546__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__13546__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__13548 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__13547 = (0);
while(true){
if((i__13547 < size__5340__auto__)){
var vec__13553 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__13547);
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13553,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13553,(1),null);
cljs.core.chunk_append(b__13548,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,percent_s(val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,percent_s(val,non_nil_count)], null)], null));

var G__13555 = (i__13547 + (1));
i__13547 = G__13555;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__13548),hatti$charting$table_chart_h_$_iter__13545(cljs.core.chunk_rest(s__13546__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__13548),null);
}
} else {
var vec__13554 = cljs.core.first(s__13546__$2);
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13554,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13554,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,percent_s(val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,percent_s(val,non_nil_count)], null)], null),hatti$charting$table_chart_h_$_iter__13545(cljs.core.rest(s__13546__$2)));
}
} else {
return null;
}
break;
}
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
,null,null));
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
;
return iter__5341__auto__(data);
})()], null)], null);
});
/**
 * Removes nil from Ona API chart data; adds nil- and non-nil-count metadata.
 * ex. Input:  {:field_xpath 'D' :data [{:D nil :count 5} {:D 1 :count 10}]}
 *     Output: {:field_xpath 'D' :data [{:D 1 :count 10}]}
 *             w/ metadata: {:nil-count 5 :non-nil-count 10}
 */
hatti.charting.extract_nil = (function hatti$charting$extract_nil(chart_data){
var map__13561 = chart_data;
var map__13561__$1 = ((((!((map__13561 == null)))?((((map__13561.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13561.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13561):map__13561);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13561__$1,cljs.core.cst$kw$field_xpath);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13561__$1,cljs.core.cst$kw$data);
var na_QMARK_ = ((function (map__13561,map__13561__$1,field_xpath,data){
return (function (p1__13556_SHARP_){
return ((p1__13556_SHARP_ == null)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__13556_SHARP_));
});})(map__13561,map__13561__$1,field_xpath,data))
;
var nil_data = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__13561,map__13561__$1,field_xpath,data,na_QMARK_){
return (function (p1__13557_SHARP_){
return na_QMARK_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,p1__13557_SHARP_));
});})(map__13561,map__13561__$1,field_xpath,data,na_QMARK_))
,data));
var non_nil_data = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__13561,map__13561__$1,field_xpath,data,na_QMARK_,nil_data){
return (function (p1__13558_SHARP_){
return na_QMARK_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,p1__13558_SHARP_));
});})(map__13561,map__13561__$1,field_xpath,data,na_QMARK_,nil_data))
,data);
var nil_count = (function (){var temp__4423__auto__ = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(nil_data);
if(cljs.core.truth_(temp__4423__auto__)){
var n = temp__4423__auto__;
return n;
} else {
return (0);
}
})();
var non_nil_count = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,non_nil_data));
return cljs.core.with_meta(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(chart_data,cljs.core.cst$kw$data,non_nil_data),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$nil_DASH_count,nil_count,cljs.core.cst$kw$non_DASH_nil_DASH_count,non_nil_count], null));
});
/**
 * Make chart depending on datatype.
 */
hatti.charting.make_chart = (function hatti$charting$make_chart(var_args){
var args13564 = [];
var len__5627__auto___13572 = arguments.length;
var i__5628__auto___13573 = (0);
while(true){
if((i__5628__auto___13573 < len__5627__auto___13572)){
args13564.push((arguments[i__5628__auto___13573]));

var G__13574 = (i__5628__auto___13573 + (1));
i__5628__auto___13573 = G__13574;
continue;
} else {
}
break;
}

var G__13566 = args13564.length;
switch (G__13566) {
case 1:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13564.length)].join('')));

}
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2(chart_data,null);
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__13567 = chart_data;
var map__13567__$1 = ((((!((map__13567 == null)))?((((map__13567.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13567.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13567):map__13567);
var field_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13567__$1,cljs.core.cst$kw$field_label);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13567__$1,cljs.core.cst$kw$data_type);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13567__$1,cljs.core.cst$kw$field_xpath);
var field_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13567__$1,cljs.core.cst$kw$field_type);
var chart_data__$1 = hatti.charting.extract_nil(chart_data);
var map__13568 = cljs.core.meta(chart_data__$1);
var map__13568__$1 = ((((!((map__13568 == null)))?((((map__13568.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13568.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13568):map__13568);
var nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13568__$1,cljs.core.cst$kw$nil_DASH_count);
var non_nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13568__$1,cljs.core.cst$kw$non_DASH_nil_DASH_count);
var not_supported = ((function (map__13567,map__13567__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__13568,map__13568__$1,nil_count,non_nil_count){
return (function (p1__13563_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$div$t_DASH_red,[cljs.core.str("Aplogies. At the moment, making a chart of\n                                     this data type ("),cljs.core.str(p1__13563_SHARP_),cljs.core.str(") is not supported.")].join('')],null));
});})(map__13567,map__13567__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__13568,map__13568__$1,nil_count,non_nil_count))
;
var chart = (((non_nil_count === (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"No data"], null):(function (){var G__13571 = data_type;
switch (G__13571) {
case "categorized":
return hatti.charting.table_chart_h(hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2(chart_data__$1,language),nil_count,non_nil_count,field_type);

break;
case "time_based":
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(chart_data__$1,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,"date"], 0));

break;
case "numeric":
return hatti.charting.numeric_chart(chart_data__$1);

break;
default:
return not_supported(data_type);

}
})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$label,field_label,cljs.core.cst$kw$name,field_xpath,cljs.core.cst$kw$chart,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,chart], null)], null);
});

hatti.charting.make_chart.cljs$lang$maxFixedArity = 2;
