// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.utils');
goog.require('hatti.utils.om.state');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__5341__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__15019(s__15020){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__15020__$1 = s__15020;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__15020__$1);
if(temp__4425__auto__){
var s__15020__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__15020__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__15020__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__15022 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__15021 = (0);
while(true){
if((i__15021 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__15021);
cljs.core.chunk_append(b__15022,(function (){var iter__5341__auto__ = ((function (i__15021,datum,c__5339__auto__,size__5340__auto__,b__15022,s__15020__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__15019_$_iter__15037(s__15038){
return (new cljs.core.LazySeq(null,((function (i__15021,datum,c__5339__auto__,size__5340__auto__,b__15022,s__15020__$2,temp__4425__auto__,osmfields){
return (function (){
var s__15038__$1 = s__15038;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__15038__$1);
if(temp__4425__auto____$1){
var s__15038__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__15038__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first(s__15038__$2);
var size__5340__auto____$1 = cljs.core.count(c__5339__auto____$1);
var b__15040 = cljs.core.chunk_buffer(size__5340__auto____$1);
if((function (){var i__15039 = (0);
while(true){
if((i__15039 < size__5340__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto____$1,i__15039);
cljs.core.chunk_append(b__15040,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__15049 = (i__15039 + (1));
i__15039 = G__15049;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__15040),hatti$ona$post_process$ona_osm_link_$_iter__15019_$_iter__15037(cljs.core.chunk_rest(s__15038__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__15040),null);
}
} else {
var field = cljs.core.first(s__15038__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__15019_$_iter__15037(cljs.core.rest(s__15038__$2)));
}
} else {
return null;
}
break;
}
});})(i__15021,datum,c__5339__auto__,size__5340__auto__,b__15022,s__15020__$2,temp__4425__auto__,osmfields))
,null,null));
});})(i__15021,datum,c__5339__auto__,size__5340__auto__,b__15022,s__15020__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})());

var G__15050 = (i__15021 + (1));
i__15021 = G__15050;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__15022),hatti$ona$post_process$ona_osm_link_$_iter__15019(cljs.core.chunk_rest(s__15020__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__15022),null);
}
} else {
var datum = cljs.core.first(s__15020__$2);
return cljs.core.cons((function (){var iter__5341__auto__ = ((function (datum,s__15020__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__15019_$_iter__15043(s__15044){
return (new cljs.core.LazySeq(null,((function (datum,s__15020__$2,temp__4425__auto__,osmfields){
return (function (){
var s__15044__$1 = s__15044;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__15044__$1);
if(temp__4425__auto____$1){
var s__15044__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__15044__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__15044__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__15046 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__15045 = (0);
while(true){
if((i__15045 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__15045);
cljs.core.chunk_append(b__15046,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__15051 = (i__15045 + (1));
i__15045 = G__15051;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__15046),hatti$ona$post_process$ona_osm_link_$_iter__15019_$_iter__15043(cljs.core.chunk_rest(s__15044__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__15046),null);
}
} else {
var field = cljs.core.first(s__15044__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__15019_$_iter__15043(cljs.core.rest(s__15044__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__15020__$2,temp__4425__auto__,osmfields))
,null,null));
});})(datum,s__15020__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__15019(cljs.core.rest(s__15020__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5341__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__15053 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__15053);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$features) : osmgeo.call(null,cljs.core.cst$kw$features));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__15076(s__15077){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__15077__$1 = s__15077;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__15077__$1);
if(temp__4425__auto__){
var s__15077__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__15077__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__15077__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__15079 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__15078 = (0);
while(true){
if((i__15078 < size__5340__auto__)){
var map__15090 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__15078);
var map__15090__$1 = ((((!((map__15090 == null)))?((((map__15090.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15090.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15090):map__15090);
var feature = map__15090__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15090__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15090__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15090__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__15079,(function (){var map__15092 = properties;
var map__15092__$1 = ((((!((map__15092 == null)))?((((map__15092.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15092.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15092):map__15092);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15092__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15092__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15092__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__15098 = (i__15078 + (1));
i__15078 = G__15098;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__15079),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__15076(cljs.core.chunk_rest(s__15077__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__15079),null);
}
} else {
var map__15094 = cljs.core.first(s__15077__$2);
var map__15094__$1 = ((((!((map__15094 == null)))?((((map__15094.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15094.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15094):map__15094);
var feature = map__15094__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15094__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15094__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15094__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__15096 = properties;
var map__15096__$1 = ((((!((map__15096 == null)))?((((map__15096.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15096.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15096):map__15096);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15096__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15096__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15096__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__15076(cljs.core.rest(s__15077__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5341__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__15099_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__15099_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4423__auto__ = (function (){var G__15111 = osm_val__GT_osm_id(osm_val);
return (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(G__15111) : osm_data.call(null,G__15111));
})();
if(cljs.core.truth_(temp__4423__auto__)){
var osm_submission_data = temp__4423__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5341__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__15112(s__15113){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__15113__$1 = s__15113;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__15113__$1);
if(temp__4425__auto__){
var s__15113__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__15113__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__15113__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__15115 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__15114 = (0);
while(true){
if((i__15114 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__15114);
cljs.core.chunk_append(b__15115,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__15122 = (i__15114 + (1));
i__15114 = G__15122;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__15115),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__15112(cljs.core.chunk_rest(s__15113__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__15115),null);
}
} else {
var datum = cljs.core.first(s__15113__$2);
return cljs.core.cons(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__15112(cljs.core.rest(s__15113__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5341__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__15118 = cljs.core.seq(osm_fields);
var chunk__15119 = null;
var count__15120 = (0);
var i__15121 = (0);
while(true){
if((i__15121 < count__15120)){
var osm_field = chunk__15119.cljs$core$IIndexed$_nth$arity$2(null,i__15121);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__15123 = seq__15118;
var G__15124 = chunk__15119;
var G__15125 = count__15120;
var G__15126 = (i__15121 + (1));
seq__15118 = G__15123;
chunk__15119 = G__15124;
count__15120 = G__15125;
i__15121 = G__15126;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__15118);
if(temp__4425__auto__){
var seq__15118__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15118__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__15118__$1);
var G__15127 = cljs.core.chunk_rest(seq__15118__$1);
var G__15128 = c__5372__auto__;
var G__15129 = cljs.core.count(c__5372__auto__);
var G__15130 = (0);
seq__15118 = G__15127;
chunk__15119 = G__15128;
count__15120 = G__15129;
i__15121 = G__15130;
continue;
} else {
var osm_field = cljs.core.first(seq__15118__$1);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__15131 = cljs.core.next(seq__15118__$1);
var G__15132 = null;
var G__15133 = (0);
var G__15134 = (0);
seq__15118 = G__15131;
chunk__15119 = G__15132;
count__15120 = G__15133;
i__15121 = G__15134;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4569__auto__ = attachments;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments");
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__15135_SHARP_){
return hatti.utils.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__15135_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5634__auto__ = [];
var len__5627__auto___15148 = arguments.length;
var i__5628__auto___15149 = (0);
while(true){
if((i__5628__auto___15149 < len__5627__auto___15148)){
args__5634__auto__.push((arguments[i__5628__auto___15149]));

var G__15150 = (i__5628__auto___15149 + (1));
i__5628__auto___15149 = G__15150;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__15139){
var map__15140 = p__15139;
var map__15140__$1 = ((((!((map__15140 == null)))?((((map__15140.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15140.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15140):map__15140);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15140__$1,cljs.core.cst$kw$attachments);
var image_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.image_QMARK_,flat_form);
var iter__5341__auto__ = ((function (image_fields,map__15140,map__15140__$1,attachments){
return (function hatti$ona$post_process$iter__15142(s__15143){
return (new cljs.core.LazySeq(null,((function (image_fields,map__15140,map__15140__$1,attachments){
return (function (){
var s__15143__$1 = s__15143;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__15143__$1);
if(temp__4425__auto__){
var s__15143__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__15143__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__15143__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__15145 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__15144 = (0);
while(true){
if((i__15144 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__15144);
cljs.core.chunk_append(b__15145,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__15144,attach_map,record,c__5339__auto__,size__5340__auto__,b__15145,s__15143__$2,temp__4425__auto__,image_fields,map__15140,map__15140__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__15144,attach_map,record,c__5339__auto__,size__5340__auto__,b__15145,s__15143__$2,temp__4425__auto__,image_fields,map__15140,map__15140__$1,attachments))
,record,image_fields);
})());

var G__15151 = (i__15144 + (1));
i__15144 = G__15151;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__15145),hatti$ona$post_process$iter__15142(cljs.core.chunk_rest(s__15143__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__15145),null);
}
} else {
var record = cljs.core.first(s__15143__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__15143__$2,temp__4425__auto__,image_fields,map__15140,map__15140__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__15143__$2,temp__4425__auto__,image_fields,map__15140,map__15140__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__15142(cljs.core.rest(s__15143__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__15140,map__15140__$1,attachments))
,null,null));
});})(image_fields,map__15140,map__15140__$1,attachments))
;
return iter__5341__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq15136){
var G__15137 = cljs.core.first(seq15136);
var seq15136__$1 = cljs.core.next(seq15136);
var G__15138 = cljs.core.first(seq15136__$1);
var seq15136__$2 = cljs.core.next(seq15136__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__15137,G__15138,seq15136__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments")], 0)));
});})(repeat_fields))
;
var iter__5341__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__15158(s__15159){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__15159__$1 = s__15159;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__15159__$1);
if(temp__4425__auto__){
var s__15159__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__15159__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__15159__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__15161 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__15160 = (0);
while(true){
if((i__15160 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__15160);
cljs.core.chunk_append(b__15161,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__15164 = (i__15160 + (1));
i__15160 = G__15164;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__15161),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__15158(cljs.core.chunk_rest(s__15159__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__15161),null);
}
} else {
var record = cljs.core.first(s__15159__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__15158(cljs.core.rest(s__15159__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5341__auto__(data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___15172 = arguments.length;
var i__5628__auto___15173 = (0);
while(true){
if((i__5628__auto___15173 < len__5627__auto___15172)){
args__5634__auto__.push((arguments[i__5628__auto___15173]));

var G__15174 = (i__5628__auto___15173 + (1));
i__5628__auto___15173 = G__15174;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__15169){
var map__15170 = p__15169;
var map__15170__$1 = ((((!((map__15170 == null)))?((((map__15170.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15170.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15170):map__15170);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15170__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__15170,map__15170__$1,app_data_keys){
return (function (p1__15165_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__15165_SHARP_));
});})(map__15170,map__15170__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq15166){
var G__15167 = cljs.core.first(seq15166);
var seq15166__$1 = cljs.core.next(seq15166);
var G__15168 = cljs.core.first(seq15166__$1);
var seq15166__$2 = cljs.core.next(seq15166__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15167,G__15168,seq15166__$2);
});
