// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__10205__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__10205__auto__){
return (function (){
var f__10206__auto__ = (function (){var switch__10138__auto__ = ((function (c__10205__auto__){
return (function (state_13754){
var state_val_13755 = (state_13754[(1)]);
if((state_val_13755 === (7))){
var inst_13711 = (state_13754[(7)]);
var inst_13711__$1 = (state_13754[(2)]);
var inst_13713 = (inst_13711__$1 == null);
var inst_13714 = cljs.core.not(inst_13713);
var state_13754__$1 = (function (){var statearr_13756 = state_13754;
(statearr_13756[(7)] = inst_13711__$1);

return statearr_13756;
})();
if(inst_13714){
var statearr_13757_13794 = state_13754__$1;
(statearr_13757_13794[(1)] = (8));

} else {
var statearr_13758_13795 = state_13754__$1;
(statearr_13758_13795[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (20))){
var inst_13733 = (state_13754[(8)]);
var inst_13741 = (state_13754[(2)]);
var state_13754__$1 = (function (){var statearr_13759 = state_13754;
(statearr_13759[(9)] = inst_13741);

return statearr_13759;
})();
if(cljs.core.truth_(inst_13733)){
var statearr_13760_13796 = state_13754__$1;
(statearr_13760_13796[(1)] = (21));

} else {
var statearr_13761_13797 = state_13754__$1;
(statearr_13761_13797[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (1))){
var state_13754__$1 = state_13754;
var statearr_13762_13798 = state_13754__$1;
(statearr_13762_13798[(2)] = null);

(statearr_13762_13798[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (4))){
var state_13754__$1 = state_13754;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13754__$1,(7),agg_data_channel);
} else {
if((state_val_13755 === (15))){
var inst_13711 = (state_13754[(7)]);
var state_13754__$1 = state_13754;
var statearr_13763_13799 = state_13754__$1;
(statearr_13763_13799[(2)] = inst_13711);

(statearr_13763_13799[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (21))){
var inst_13743 = cljs.core.async.close_BANG_(agg_data_channel);
var state_13754__$1 = state_13754;
var statearr_13764_13800 = state_13754__$1;
(statearr_13764_13800[(2)] = inst_13743);

(statearr_13764_13800[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (13))){
var inst_13723 = (state_13754[(2)]);
var state_13754__$1 = state_13754;
var statearr_13765_13801 = state_13754__$1;
(statearr_13765_13801[(2)] = inst_13723);

(statearr_13765_13801[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (22))){
var state_13754__$1 = state_13754;
var statearr_13766_13802 = state_13754__$1;
(statearr_13766_13802[(2)] = null);

(statearr_13766_13802[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (6))){
var inst_13750 = (state_13754[(2)]);
var state_13754__$1 = state_13754;
var statearr_13767_13803 = state_13754__$1;
(statearr_13767_13803[(2)] = inst_13750);

(statearr_13767_13803[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (17))){
var inst_13733 = (state_13754[(8)]);
var inst_13732 = (state_13754[(10)]);
var inst_13735 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_13732,inst_13733) : callback.call(null,inst_13732,inst_13733));
var state_13754__$1 = state_13754;
var statearr_13768_13804 = state_13754__$1;
(statearr_13768_13804[(2)] = inst_13735);

(statearr_13768_13804[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (3))){
var inst_13752 = (state_13754[(2)]);
var state_13754__$1 = state_13754;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13754__$1,inst_13752);
} else {
if((state_val_13755 === (12))){
var state_13754__$1 = state_13754;
var statearr_13769_13805 = state_13754__$1;
(statearr_13769_13805[(2)] = false);

(statearr_13769_13805[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (2))){
var state_13754__$1 = state_13754;
var statearr_13770_13806 = state_13754__$1;
(statearr_13770_13806[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (23))){
var inst_13746 = (state_13754[(2)]);
var state_13754__$1 = (function (){var statearr_13772 = state_13754;
(statearr_13772[(11)] = inst_13746);

return statearr_13772;
})();
var statearr_13773_13807 = state_13754__$1;
(statearr_13773_13807[(2)] = null);

(statearr_13773_13807[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (19))){
var inst_13738 = (state_13754[(2)]);
var inst_13739 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_13754__$1 = (function (){var statearr_13774 = state_13754;
(statearr_13774[(12)] = inst_13738);

return statearr_13774;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13754__$1,(20),inst_13739);
} else {
if((state_val_13755 === (11))){
var state_13754__$1 = state_13754;
var statearr_13775_13808 = state_13754__$1;
(statearr_13775_13808[(2)] = true);

(statearr_13775_13808[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (9))){
var state_13754__$1 = state_13754;
var statearr_13776_13809 = state_13754__$1;
(statearr_13776_13809[(2)] = false);

(statearr_13776_13809[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (5))){
var state_13754__$1 = state_13754;
var statearr_13777_13810 = state_13754__$1;
(statearr_13777_13810[(2)] = null);

(statearr_13777_13810[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (14))){
var inst_13711 = (state_13754[(7)]);
var inst_13728 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_13711);
var state_13754__$1 = state_13754;
var statearr_13778_13811 = state_13754__$1;
(statearr_13778_13811[(2)] = inst_13728);

(statearr_13778_13811[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (16))){
var inst_13732 = (state_13754[(10)]);
var inst_13731 = (state_13754[(2)]);
var inst_13732__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13731,cljs.core.cst$kw$data);
var inst_13733 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13731,cljs.core.cst$kw$completed_QMARK_);
var state_13754__$1 = (function (){var statearr_13779 = state_13754;
(statearr_13779[(8)] = inst_13733);

(statearr_13779[(10)] = inst_13732__$1);

return statearr_13779;
})();
if(cljs.core.truth_(inst_13732__$1)){
var statearr_13780_13812 = state_13754__$1;
(statearr_13780_13812[(1)] = (17));

} else {
var statearr_13781_13813 = state_13754__$1;
(statearr_13781_13813[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (10))){
var inst_13726 = (state_13754[(2)]);
var state_13754__$1 = state_13754;
if(cljs.core.truth_(inst_13726)){
var statearr_13782_13814 = state_13754__$1;
(statearr_13782_13814[(1)] = (14));

} else {
var statearr_13783_13815 = state_13754__$1;
(statearr_13783_13815[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (18))){
var state_13754__$1 = state_13754;
var statearr_13784_13816 = state_13754__$1;
(statearr_13784_13816[(2)] = null);

(statearr_13784_13816[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13755 === (8))){
var inst_13711 = (state_13754[(7)]);
var inst_13716 = inst_13711.cljs$lang$protocol_mask$partition0$;
var inst_13717 = (inst_13716 & (64));
var inst_13718 = inst_13711.cljs$core$ISeq$;
var inst_13719 = (inst_13717) || (inst_13718);
var state_13754__$1 = state_13754;
if(cljs.core.truth_(inst_13719)){
var statearr_13785_13817 = state_13754__$1;
(statearr_13785_13817[(1)] = (11));

} else {
var statearr_13786_13818 = state_13754__$1;
(statearr_13786_13818[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10205__auto__))
;
return ((function (switch__10138__auto__,c__10205__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__10139__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__10139__auto____0 = (function (){
var statearr_13790 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13790[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__10139__auto__);

(statearr_13790[(1)] = (1));

return statearr_13790;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__10139__auto____1 = (function (state_13754){
while(true){
var ret_value__10140__auto__ = (function (){try{while(true){
var result__10141__auto__ = switch__10138__auto__(state_13754);
if(cljs.core.keyword_identical_QMARK_(result__10141__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10141__auto__;
}
break;
}
}catch (e13791){if((e13791 instanceof Object)){
var ex__10142__auto__ = e13791;
var statearr_13792_13819 = state_13754;
(statearr_13792_13819[(5)] = ex__10142__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_13754);

return cljs.core.cst$kw$recur;
} else {
throw e13791;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10140__auto__,cljs.core.cst$kw$recur)){
var G__13820 = state_13754;
state_13754 = G__13820;
continue;
} else {
return ret_value__10140__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__10139__auto__ = function(state_13754){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__10139__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__10139__auto____1.call(this,state_13754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__10139__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__10139__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__10139__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__10139__auto__;
})()
;})(switch__10138__auto__,c__10205__auto__))
})();
var state__10207__auto__ = (function (){var statearr_13793 = (f__10206__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10206__auto__.cljs$core$IFn$_invoke$arity$0() : f__10206__auto__.call(null));
(statearr_13793[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10205__auto__);

return statearr_13793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10207__auto__);
});})(c__10205__auto__))
);

return c__10205__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__13823_13825 = agg;
var G__13824_13826 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__13823_13825,G__13824_13826) : cljs.core.reset_BANG_.call(null,G__13823_13825,G__13824_13826));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___13834 = arguments.length;
var i__5628__auto___13835 = (0);
while(true){
if((i__5628__auto___13835 < len__5627__auto___13834)){
args__5634__auto__.push((arguments[i__5628__auto___13835]));

var G__13836 = (i__5628__auto___13835 + (1));
i__5628__auto___13835 = G__13836;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__13830){
var map__13831 = p__13830;
var map__13831__$1 = ((((!((map__13831 == null)))?((((map__13831.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13831.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13831):map__13831);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13831__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__13833 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__13833) : cljs.core.atom.call(null,G__13833));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__13831,map__13831__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__13831,map__13831__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__13831,map__13831__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__13831,map__13831__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq13827){
var G__13828 = cljs.core.first(seq13827);
var seq13827__$1 = cljs.core.next(seq13827);
var G__13829 = cljs.core.first(seq13827__$1);
var seq13827__$2 = cljs.core.next(seq13827__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13828,G__13829,seq13827__$2);
});
