// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.utils');
goog.require('hatti.utils.om.state');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__5341__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__30809(s__30810){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__30810__$1 = s__30810;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__30810__$1);
if(temp__4425__auto__){
var s__30810__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30810__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30810__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30812 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30811 = (0);
while(true){
if((i__30811 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30811);
cljs.core.chunk_append(b__30812,(function (){var iter__5341__auto__ = ((function (i__30811,datum,c__5339__auto__,size__5340__auto__,b__30812,s__30810__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__30809_$_iter__30827(s__30828){
return (new cljs.core.LazySeq(null,((function (i__30811,datum,c__5339__auto__,size__5340__auto__,b__30812,s__30810__$2,temp__4425__auto__,osmfields){
return (function (){
var s__30828__$1 = s__30828;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__30828__$1);
if(temp__4425__auto____$1){
var s__30828__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__30828__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first(s__30828__$2);
var size__5340__auto____$1 = cljs.core.count(c__5339__auto____$1);
var b__30830 = cljs.core.chunk_buffer(size__5340__auto____$1);
if((function (){var i__30829 = (0);
while(true){
if((i__30829 < size__5340__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto____$1,i__30829);
cljs.core.chunk_append(b__30830,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__30839 = (i__30829 + (1));
i__30829 = G__30839;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30830),hatti$ona$post_process$ona_osm_link_$_iter__30809_$_iter__30827(cljs.core.chunk_rest(s__30828__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30830),null);
}
} else {
var field = cljs.core.first(s__30828__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__30809_$_iter__30827(cljs.core.rest(s__30828__$2)));
}
} else {
return null;
}
break;
}
});})(i__30811,datum,c__5339__auto__,size__5340__auto__,b__30812,s__30810__$2,temp__4425__auto__,osmfields))
,null,null));
});})(i__30811,datum,c__5339__auto__,size__5340__auto__,b__30812,s__30810__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})());

var G__30840 = (i__30811 + (1));
i__30811 = G__30840;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30812),hatti$ona$post_process$ona_osm_link_$_iter__30809(cljs.core.chunk_rest(s__30810__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30812),null);
}
} else {
var datum = cljs.core.first(s__30810__$2);
return cljs.core.cons((function (){var iter__5341__auto__ = ((function (datum,s__30810__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__30809_$_iter__30833(s__30834){
return (new cljs.core.LazySeq(null,((function (datum,s__30810__$2,temp__4425__auto__,osmfields){
return (function (){
var s__30834__$1 = s__30834;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__30834__$1);
if(temp__4425__auto____$1){
var s__30834__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__30834__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30834__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30836 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30835 = (0);
while(true){
if((i__30835 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30835);
cljs.core.chunk_append(b__30836,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__30841 = (i__30835 + (1));
i__30835 = G__30841;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30836),hatti$ona$post_process$ona_osm_link_$_iter__30809_$_iter__30833(cljs.core.chunk_rest(s__30834__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30836),null);
}
} else {
var field = cljs.core.first(s__30834__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__30809_$_iter__30833(cljs.core.rest(s__30834__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__30810__$2,temp__4425__auto__,osmfields))
,null,null));
});})(datum,s__30810__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__30809(cljs.core.rest(s__30810__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5341__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__30843 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__30843);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$features) : osmgeo.call(null,cljs.core.cst$kw$features));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__30866(s__30867){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__30867__$1 = s__30867;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__30867__$1);
if(temp__4425__auto__){
var s__30867__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30867__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30867__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30869 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30868 = (0);
while(true){
if((i__30868 < size__5340__auto__)){
var map__30880 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30868);
var map__30880__$1 = ((((!((map__30880 == null)))?((((map__30880.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30880.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30880):map__30880);
var feature = map__30880__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30880__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30880__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30880__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__30869,(function (){var map__30882 = properties;
var map__30882__$1 = ((((!((map__30882 == null)))?((((map__30882.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30882.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30882):map__30882);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30882__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30882__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30882__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__30888 = (i__30868 + (1));
i__30868 = G__30888;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30869),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__30866(cljs.core.chunk_rest(s__30867__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30869),null);
}
} else {
var map__30884 = cljs.core.first(s__30867__$2);
var map__30884__$1 = ((((!((map__30884 == null)))?((((map__30884.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30884.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30884):map__30884);
var feature = map__30884__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30884__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30884__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30884__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__30886 = properties;
var map__30886__$1 = ((((!((map__30886 == null)))?((((map__30886.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30886.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30886):map__30886);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30886__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30886__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30886__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__30866(cljs.core.rest(s__30867__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5341__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__30889_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__30889_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4423__auto__ = (function (){var G__30901 = osm_val__GT_osm_id(osm_val);
return (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(G__30901) : osm_data.call(null,G__30901));
})();
if(cljs.core.truth_(temp__4423__auto__)){
var osm_submission_data = temp__4423__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5341__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__30902(s__30903){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__30903__$1 = s__30903;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__30903__$1);
if(temp__4425__auto__){
var s__30903__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30903__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30903__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30905 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30904 = (0);
while(true){
if((i__30904 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30904);
cljs.core.chunk_append(b__30905,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__30912 = (i__30904 + (1));
i__30904 = G__30912;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30905),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__30902(cljs.core.chunk_rest(s__30903__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30905),null);
}
} else {
var datum = cljs.core.first(s__30903__$2);
return cljs.core.cons(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__30902(cljs.core.rest(s__30903__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5341__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__30908 = cljs.core.seq(osm_fields);
var chunk__30909 = null;
var count__30910 = (0);
var i__30911 = (0);
while(true){
if((i__30911 < count__30910)){
var osm_field = chunk__30909.cljs$core$IIndexed$_nth$arity$2(null,i__30911);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__30913 = seq__30908;
var G__30914 = chunk__30909;
var G__30915 = count__30910;
var G__30916 = (i__30911 + (1));
seq__30908 = G__30913;
chunk__30909 = G__30914;
count__30910 = G__30915;
i__30911 = G__30916;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__30908);
if(temp__4425__auto__){
var seq__30908__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__30908__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__30908__$1);
var G__30917 = cljs.core.chunk_rest(seq__30908__$1);
var G__30918 = c__5372__auto__;
var G__30919 = cljs.core.count(c__5372__auto__);
var G__30920 = (0);
seq__30908 = G__30917;
chunk__30909 = G__30918;
count__30910 = G__30919;
i__30911 = G__30920;
continue;
} else {
var osm_field = cljs.core.first(seq__30908__$1);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__30921 = cljs.core.next(seq__30908__$1);
var G__30922 = null;
var G__30923 = (0);
var G__30924 = (0);
seq__30908 = G__30921;
chunk__30909 = G__30922;
count__30910 = G__30923;
i__30911 = G__30924;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4569__auto__ = attachments;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments");
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__30925_SHARP_){
return hatti.utils.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__30925_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5634__auto__ = [];
var len__5627__auto___30938 = arguments.length;
var i__5628__auto___30939 = (0);
while(true){
if((i__5628__auto___30939 < len__5627__auto___30938)){
args__5634__auto__.push((arguments[i__5628__auto___30939]));

var G__30940 = (i__5628__auto___30939 + (1));
i__5628__auto___30939 = G__30940;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__30929){
var map__30930 = p__30929;
var map__30930__$1 = ((((!((map__30930 == null)))?((((map__30930.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30930.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30930):map__30930);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30930__$1,cljs.core.cst$kw$attachments);
var image_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.image_QMARK_,flat_form);
var iter__5341__auto__ = ((function (image_fields,map__30930,map__30930__$1,attachments){
return (function hatti$ona$post_process$iter__30932(s__30933){
return (new cljs.core.LazySeq(null,((function (image_fields,map__30930,map__30930__$1,attachments){
return (function (){
var s__30933__$1 = s__30933;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__30933__$1);
if(temp__4425__auto__){
var s__30933__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30933__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30933__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30935 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30934 = (0);
while(true){
if((i__30934 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30934);
cljs.core.chunk_append(b__30935,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__30934,attach_map,record,c__5339__auto__,size__5340__auto__,b__30935,s__30933__$2,temp__4425__auto__,image_fields,map__30930,map__30930__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__30934,attach_map,record,c__5339__auto__,size__5340__auto__,b__30935,s__30933__$2,temp__4425__auto__,image_fields,map__30930,map__30930__$1,attachments))
,record,image_fields);
})());

var G__30941 = (i__30934 + (1));
i__30934 = G__30941;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30935),hatti$ona$post_process$iter__30932(cljs.core.chunk_rest(s__30933__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30935),null);
}
} else {
var record = cljs.core.first(s__30933__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__30933__$2,temp__4425__auto__,image_fields,map__30930,map__30930__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__30933__$2,temp__4425__auto__,image_fields,map__30930,map__30930__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__30932(cljs.core.rest(s__30933__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__30930,map__30930__$1,attachments))
,null,null));
});})(image_fields,map__30930,map__30930__$1,attachments))
;
return iter__5341__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq30926){
var G__30927 = cljs.core.first(seq30926);
var seq30926__$1 = cljs.core.next(seq30926);
var G__30928 = cljs.core.first(seq30926__$1);
var seq30926__$2 = cljs.core.next(seq30926__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__30927,G__30928,seq30926__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments")], 0)));
});})(repeat_fields))
;
var iter__5341__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__30948(s__30949){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__30949__$1 = s__30949;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__30949__$1);
if(temp__4425__auto__){
var s__30949__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30949__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30949__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30951 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30950 = (0);
while(true){
if((i__30950 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30950);
cljs.core.chunk_append(b__30951,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__30954 = (i__30950 + (1));
i__30950 = G__30954;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30951),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__30948(cljs.core.chunk_rest(s__30949__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30951),null);
}
} else {
var record = cljs.core.first(s__30949__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__30948(cljs.core.rest(s__30949__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5341__auto__(data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___30962 = arguments.length;
var i__5628__auto___30963 = (0);
while(true){
if((i__5628__auto___30963 < len__5627__auto___30962)){
args__5634__auto__.push((arguments[i__5628__auto___30963]));

var G__30964 = (i__5628__auto___30963 + (1));
i__5628__auto___30963 = G__30964;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__30959){
var map__30960 = p__30959;
var map__30960__$1 = ((((!((map__30960 == null)))?((((map__30960.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30960.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30960):map__30960);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30960__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__30960,map__30960__$1,app_data_keys){
return (function (p1__30955_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__30955_SHARP_));
});})(map__30960,map__30960__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq30956){
var G__30957 = cljs.core.first(seq30956);
var seq30956__$1 = cljs.core.next(seq30956);
var G__30958 = cljs.core.first(seq30956__$1);
var seq30956__$2 = cljs.core.next(seq30956__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30957,G__30958,seq30956__$2);
});
