// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.utils.om.state');
goog.require('cljs.core');
goog.require('om.core');
/**
 * A transact! function that optionally uses swap! if this atom is not yet
 * transactable?
 */
hatti.utils.om.state.transact_BANG_ = (function hatti$utils$om$state$transact_BANG_(app_state){
if(((!((app_state == null)))?(((false) || (app_state.om$core$ITransact$))?true:(((!app_state.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(om.core.ITransact,app_state):false)):cljs.core.native_satisfies_QMARK_(om.core.ITransact,app_state))){
return om.core.transact_BANG_;
} else {
return cljs.core.swap_BANG_;
}
});
/**
 * Like om/transact! but also works on atoms that are not transactable?
 */
hatti.utils.om.state.transact_app_state_BANG_ = (function hatti$utils$om$state$transact_app_state_BANG_(var_args){
var args30238 = [];
var len__5627__auto___30241 = arguments.length;
var i__5628__auto___30242 = (0);
while(true){
if((i__5628__auto___30242 < len__5627__auto___30241)){
args30238.push((arguments[i__5628__auto___30242]));

var G__30243 = (i__5628__auto___30242 + (1));
i__5628__auto___30242 = G__30243;
continue;
} else {
}
break;
}

var G__30240 = args30238.length;
switch (G__30240) {
case 2:
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30238.length)].join('')));

}
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,transact_fn){
return hatti.utils.om.state.transact_BANG_(app_state).call(null,app_state,transact_fn);
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,transact_fn){
return hatti.utils.om.state.transact_BANG_(app_state).call(null,app_state,(function (p1__30237_SHARP_){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(p1__30237_SHARP_,ks,transact_fn);
}));
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$lang$maxFixedArity = 3;
/**
 * Like om/update! but also works on atoms that are not transactable?
 */
hatti.utils.om.state.update_app_state_BANG_ = (function hatti$utils$om$state$update_app_state_BANG_(var_args){
var args30245 = [];
var len__5627__auto___30248 = arguments.length;
var i__5628__auto___30249 = (0);
while(true){
if((i__5628__auto___30249 < len__5627__auto___30248)){
args30245.push((arguments[i__5628__auto___30249]));

var G__30250 = (i__5628__auto___30249 + (1));
i__5628__auto___30249 = G__30250;
continue;
} else {
}
break;
}

var G__30247 = args30245.length;
switch (G__30247) {
case 2:
return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30245.length)].join('')));

}
});

hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,update_val){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2(app_state,(function (){
return update_val;
}));
});

hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,update_val){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,ks,(function (){
return update_val;
}));
});

hatti.utils.om.state.update_app_state_BANG_.cljs$lang$maxFixedArity = 3;
/**
 * Merges provided state into existing app-state, possibly after zoomint into
 * ks.
 */
hatti.utils.om.state.merge_into_app_state_BANG_ = (function hatti$utils$om$state$merge_into_app_state_BANG_(var_args){
var args30254 = [];
var len__5627__auto___30257 = arguments.length;
var i__5628__auto___30258 = (0);
while(true){
if((i__5628__auto___30258 < len__5627__auto___30257)){
args30254.push((arguments[i__5628__auto___30258]));

var G__30259 = (i__5628__auto___30258 + (1));
i__5628__auto___30258 = G__30259;
continue;
} else {
}
break;
}

var G__30256 = args30254.length;
switch (G__30256) {
case 2:
return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30254.length)].join('')));

}
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,state_to_merge){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2(app_state,(function (p1__30252_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__30252_SHARP_,state_to_merge], 0));
}));
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,state_to_merge){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,ks,(function (p1__30253_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__30253_SHARP_,state_to_merge], 0));
}));
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$lang$maxFixedArity = 3;
