// Compiled by ClojureScript 1.7.145 {}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
c2.dom.select;

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__5224__auto__ = (((x == null))?null:x);
var m__5225__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,x);
} else {
var m__5225__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return c2.dom.select.call(null,selector);
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render.call(null,v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args23908 = [];
var len__5627__auto___23911 = arguments.length;
var i__5628__auto___23912 = (0);
while(true){
if((i__5628__auto___23912 < len__5627__auto___23911)){
args23908.push((arguments[i__5628__auto___23912]));

var G__23913 = (i__5628__auto___23912 + (1));
i__5628__auto___23912 = G__23913;
continue;
} else {
}
break;
}

var G__23910 = args23908.length;
switch (G__23910) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23908.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;
/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args23915 = [];
var len__5627__auto___23918 = arguments.length;
var i__5628__auto___23919 = (0);
while(true){
if((i__5628__auto___23919 < len__5627__auto___23918)){
args23915.push((arguments[i__5628__auto___23919]));

var G__23920 = (i__5628__auto___23919 + (1));
i__5628__auto___23919 = G__23920;
continue;
} else {
}
break;
}

var G__23917 = args23915.length;
switch (G__23917) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23915.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;
/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom.call(null,node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom.call(null,node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.appendChild(c2.dom.__GT_dom.call(null,container),el__$1);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.insertChildAt(c2.dom.__GT_dom.call(null,container),el__$1,(0));

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
return goog.dom.removeNode(c2.dom.__GT_dom.call(null,el));
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom.call(null,new$);
goog.dom.replaceNode(new$__$1,c2.dom.__GT_dom.call(null,old));

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args23922 = [];
var len__5627__auto___23931 = arguments.length;
var i__5628__auto___23932 = (0);
while(true){
if((i__5628__auto___23932 < len__5627__auto___23931)){
args23922.push((arguments[i__5628__auto___23932]));

var G__23933 = (i__5628__auto___23932 + (1));
i__5628__auto___23932 = G__23933;
continue;
} else {
}
break;
}

var G__23924 = args23922.length;
switch (G__23924) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23922.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return goog.style.getComputedStyle(el__$1,cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__23925_23935 = cljs.core.seq.call(null,x);
var chunk__23926_23936 = null;
var count__23927_23937 = (0);
var i__23928_23938 = (0);
while(true){
if((i__23928_23938 < count__23927_23937)){
var vec__23929_23939 = cljs.core._nth.call(null,chunk__23926_23936,i__23928_23938);
var k_23940 = cljs.core.nth.call(null,vec__23929_23939,(0),null);
var v_23941 = cljs.core.nth.call(null,vec__23929_23939,(1),null);
c2.dom.style.call(null,el__$1,k_23940,v_23941);

var G__23942 = seq__23925_23935;
var G__23943 = chunk__23926_23936;
var G__23944 = count__23927_23937;
var G__23945 = (i__23928_23938 + (1));
seq__23925_23935 = G__23942;
chunk__23926_23936 = G__23943;
count__23927_23937 = G__23944;
i__23928_23938 = G__23945;
continue;
} else {
var temp__4425__auto___23946 = cljs.core.seq.call(null,seq__23925_23935);
if(temp__4425__auto___23946){
var seq__23925_23947__$1 = temp__4425__auto___23946;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23925_23947__$1)){
var c__5372__auto___23948 = cljs.core.chunk_first.call(null,seq__23925_23947__$1);
var G__23949 = cljs.core.chunk_rest.call(null,seq__23925_23947__$1);
var G__23950 = c__5372__auto___23948;
var G__23951 = cljs.core.count.call(null,c__5372__auto___23948);
var G__23952 = (0);
seq__23925_23935 = G__23949;
chunk__23926_23936 = G__23950;
count__23927_23937 = G__23951;
i__23928_23938 = G__23952;
continue;
} else {
var vec__23930_23953 = cljs.core.first.call(null,seq__23925_23947__$1);
var k_23954 = cljs.core.nth.call(null,vec__23930_23953,(0),null);
var v_23955 = cljs.core.nth.call(null,vec__23930_23953,(1),null);
c2.dom.style.call(null,el__$1,k_23954,v_23955);

var G__23956 = cljs.core.next.call(null,seq__23925_23947__$1);
var G__23957 = null;
var G__23958 = (0);
var G__23959 = (0);
seq__23925_23935 = G__23956;
chunk__23926_23936 = G__23957;
count__23927_23937 = G__23958;
i__23928_23938 = G__23959;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
goog.style.setStyle(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,k),((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"height","height",1025178622),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null).call(null,cljs.core.keyword.call(null,k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null)));

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args23960 = [];
var len__5627__auto___23973 = arguments.length;
var i__5628__auto___23974 = (0);
while(true){
if((i__5628__auto___23974 < len__5627__auto___23973)){
args23960.push((arguments[i__5628__auto___23974]));

var G__23975 = (i__5628__auto___23974 + (1));
i__5628__auto___23974 = G__23975;
continue;
} else {
}
break;
}

var G__23962 = args23960.length;
switch (G__23962) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23960.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom.call(null,el).attributes;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (attrs){
return (function c2$dom$iter__23963(s__23964){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__23964__$1 = s__23964;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23964__$1);
if(temp__4425__auto__){
var s__23964__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23964__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23964__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23966 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23965 = (0);
while(true){
if((i__23965 < size__5340__auto__)){
var i = cljs.core._nth.call(null,c__5339__auto__,i__23965);
cljs.core.chunk_append.call(null,b__23966,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null));

var G__23977 = (i__23965 + (1));
i__23965 = G__23977;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23966),c2$dom$iter__23963.call(null,cljs.core.chunk_rest.call(null,s__23964__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23966),null);
}
} else {
var i = cljs.core.first.call(null,s__23964__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__23963.call(null,cljs.core.rest.call(null,s__23964__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__5341__auto__.call(null,cljs.core.range.call(null,attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__23967_23978 = cljs.core.seq.call(null,x);
var chunk__23968_23979 = null;
var count__23969_23980 = (0);
var i__23970_23981 = (0);
while(true){
if((i__23970_23981 < count__23969_23980)){
var vec__23971_23982 = cljs.core._nth.call(null,chunk__23968_23979,i__23970_23981);
var k_23983 = cljs.core.nth.call(null,vec__23971_23982,(0),null);
var v_23984 = cljs.core.nth.call(null,vec__23971_23982,(1),null);
c2.dom.attr.call(null,el__$1,k_23983,v_23984);

var G__23985 = seq__23967_23978;
var G__23986 = chunk__23968_23979;
var G__23987 = count__23969_23980;
var G__23988 = (i__23970_23981 + (1));
seq__23967_23978 = G__23985;
chunk__23968_23979 = G__23986;
count__23969_23980 = G__23987;
i__23970_23981 = G__23988;
continue;
} else {
var temp__4425__auto___23989 = cljs.core.seq.call(null,seq__23967_23978);
if(temp__4425__auto___23989){
var seq__23967_23990__$1 = temp__4425__auto___23989;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23967_23990__$1)){
var c__5372__auto___23991 = cljs.core.chunk_first.call(null,seq__23967_23990__$1);
var G__23992 = cljs.core.chunk_rest.call(null,seq__23967_23990__$1);
var G__23993 = c__5372__auto___23991;
var G__23994 = cljs.core.count.call(null,c__5372__auto___23991);
var G__23995 = (0);
seq__23967_23978 = G__23992;
chunk__23968_23979 = G__23993;
count__23969_23980 = G__23994;
i__23970_23981 = G__23995;
continue;
} else {
var vec__23972_23996 = cljs.core.first.call(null,seq__23967_23990__$1);
var k_23997 = cljs.core.nth.call(null,vec__23972_23996,(0),null);
var v_23998 = cljs.core.nth.call(null,vec__23972_23996,(1),null);
c2.dom.attr.call(null,el__$1,k_23997,v_23998);

var G__23999 = cljs.core.next.call(null,seq__23967_23990__$1);
var G__24000 = null;
var G__24001 = (0);
var G__24002 = (0);
seq__23967_23978 = G__23999;
chunk__23968_23979 = G__24000;
count__23969_23980 = G__24001;
i__23970_23981 = G__24002;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name.call(null,k));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"style","style",-496642736),k)){
c2.dom.style.call(null,el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name.call(null,k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args24003 = [];
var len__5627__auto___24006 = arguments.length;
var i__5628__auto___24007 = (0);
while(true){
if((i__5628__auto___24007 < len__5627__auto___24006)){
args24003.push((arguments[i__5628__auto___24007]));

var G__24008 = (i__5628__auto___24007 + (1));
i__5628__auto___24007 = G__24008;
continue;
} else {
}
break;
}

var G__24005 = args24003.length;
switch (G__24005) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24003.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.getTextContent(c2.dom.__GT_dom.call(null,el));
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;
/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args24010 = [];
var len__5627__auto___24013 = arguments.length;
var i__5628__auto___24014 = (0);
while(true){
if((i__5628__auto___24014 < len__5627__auto___24013)){
args24010.push((arguments[i__5628__auto___24014]));

var G__24015 = (i__5628__auto___24014 + (1));
i__5628__auto___24014 = G__24015;
continue;
} else {
}
break;
}

var G__24012 = args24010.length;
switch (G__24012) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24010.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.forms.getValue(c2.dom.__GT_dom.call(null,el));
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;
/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
goog.dom.classes.enable(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,class$),classed_QMARK_);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__4569__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return ((function (or__4569__auto____$1,or__4569__auto__){
return (function (p1__24017_SHARP_){
return setTimeout(((function (or__4569__auto____$1,or__4569__auto__){
return (function (){
return p1__24017_SHARP_.call(null);
});})(or__4569__auto____$1,or__4569__auto__))
,(10));
});
;})(or__4569__auto____$1,or__4569__auto__))
}
}
})();
