// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.charting');
goog.require('cljs.core');
goog.require('c2.layout.histogram');
goog.require('hatti.maths');
goog.require('cljs_time.coerce');
goog.require('c2.scale');
goog.require('cljs_time.format');
goog.require('hatti.ona.forms');
goog.require('hatti.utils');
goog.require('c2.svg');
goog.require('clojure.string');
hatti.charting.millis_in_day = (86400000);
/**
 * Parse an integer from a string.
 */
hatti.charting.parse_int = (function hatti$charting$parse_int(st){
var ans = parseInt(st);
if(cljs.core.truth_(isNaN(ans))){
return null;
} else {
return ans;
}
});
/**
 * Converts string to integer, for typ (int|date).
 */
hatti.charting.str__GT_int = (function hatti$charting$str__GT_int(typ){
var G__91323 = typ;
switch (G__91323) {
case "int":
return hatti.charting.parse_int;

break;
case "date":
return ((function (G__91323){
return (function (date_string){
if(cljs.core.truth_(date_string)){
return hatti.maths.floor.call(null,(cljs_time.coerce.to_long.call(null,(new Date(date_string))) / hatti.charting.millis_in_day));
} else {
return null;
}
});
;})(G__91323))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});
/**
 * Converts integers to strings, for type (int|date).
 * Optional digits parameter = number of digits after decimal, default is 1.
 */
hatti.charting.int__GT_str = (function hatti$charting$int__GT_str(var_args){
var args__5634__auto__ = [];
var len__5627__auto___91335 = arguments.length;
var i__5628__auto___91336 = (0);
while(true){
if((i__5628__auto___91336 < len__5627__auto___91335)){
args__5634__auto__.push((arguments[i__5628__auto___91336]));

var G__91337 = (i__5628__auto___91336 + (1));
i__5628__auto___91336 = G__91337;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic = (function (typ,p__91331){
var map__91332 = p__91331;
var map__91332__$1 = ((((!((map__91332 == null)))?((((map__91332.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91332.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91332):map__91332);
var digits = cljs.core.get.call(null,map__91332__$1,new cljs.core.Keyword(null,"digits","digits",-1134635061),(1));
var int_fmt_s = [cljs.core.str("%."),cljs.core.str(digits),cljs.core.str("f")].join('');
var d__GT_millis = ((function (int_fmt_s,map__91332,map__91332__$1,digits){
return (function (p1__91325_SHARP_){
return (hatti.charting.millis_in_day * p1__91325_SHARP_);
});})(int_fmt_s,map__91332,map__91332__$1,digits))
;
var date__GT_str = ((function (int_fmt_s,d__GT_millis,map__91332,map__91332__$1,digits){
return (function (p1__91326_SHARP_){
if(cljs.core.truth_(p1__91326_SHARP_)){
return moment(p1__91326_SHARP_).format("ll");
} else {
return null;
}
});})(int_fmt_s,d__GT_millis,map__91332,map__91332__$1,digits))
;
var G__91334 = typ;
switch (G__91334) {
case "int":
return ((function (G__91334,int_fmt_s,d__GT_millis,date__GT_str,map__91332,map__91332__$1,digits){
return (function (p1__91327_SHARP_){
return hatti.utils.format.call(null,int_fmt_s,p1__91327_SHARP_);
});
;})(G__91334,int_fmt_s,d__GT_millis,date__GT_str,map__91332,map__91332__$1,digits))

break;
case "date":
return ((function (G__91334,int_fmt_s,d__GT_millis,date__GT_str,map__91332,map__91332__$1,digits){
return (function (p1__91328_SHARP_){
return date__GT_str.call(null,d__GT_millis.call(null,p1__91328_SHARP_));
});
;})(G__91334,int_fmt_s,d__GT_millis,date__GT_str,map__91332,map__91332__$1,digits))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});

hatti.charting.int__GT_str.cljs$lang$maxFixedArity = (1);

hatti.charting.int__GT_str.cljs$lang$applyTo = (function (seq91329){
var G__91330 = cljs.core.first.call(null,seq91329);
var seq91329__$1 = cljs.core.next.call(null,seq91329);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(G__91330,seq91329__$1);
});
/**
 * Converts a range of typ (int|date) to a string.
 */
hatti.charting.range__GT_str = (function hatti$charting$range__GT_str(p__91339,typ){
var vec__91342 = p__91339;
var mn = cljs.core.nth.call(null,vec__91342,(0),null);
var mx = cljs.core.nth.call(null,vec__91342,(1),null);
var vec__91343 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.maths.ceil.call(null,mn),hatti.maths.floor.call(null,mx)], null);
var mn__$1 = cljs.core.nth.call(null,vec__91343,(0),null);
var mx__$1 = cljs.core.nth.call(null,vec__91343,(1),null);
var fmt = hatti.charting.int__GT_str.call(null,typ,new cljs.core.Keyword(null,"digits","digits",-1134635061),(0));
if((mx__$1 <= mn__$1)){
return fmt.call(null,mn__$1);
} else {
return clojure.string.join.call(null," to ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fmt.call(null,mn__$1),fmt.call(null,mx__$1)], null));
}
});
/**
 * Given a list of answers, returns each one as a bin, in string form.
 * nil is mapped to nil. The bins, in order, are returned as metadata.
 * eg. (evenly-spaced-bins [1 2 10] 5 'int') => ['1 to 2' '1 to 2' '9 to 10']
 * metadata of this above value would be:
 * {:bins ['1 to 2', '3 to 4', '5 to 6', '7 to 8', '9 to 10']}
 */
hatti.charting.evenly_spaced_bins = (function hatti$charting$evenly_spaced_bins(answers,bins,typ){
var numbers = cljs.core.map.call(null,hatti.charting.str__GT_int.call(null,typ),answers);
var mx = cljs.core.reduce.call(null,cljs.core.max,cljs.core.remove.call(null,cljs.core.nil_QMARK_,numbers));
var mn = cljs.core.reduce.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,numbers));
var s = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(bins - ((1) / (10000)))], null));
var is = cljs.core.map.call(null,hatti.maths.floor,cljs.core.map.call(null,((function (numbers,mx,mn,s){
return (function (p1__91344_SHARP_){
if(cljs.core.truth_(p1__91344_SHARP_)){
return s.call(null,p1__91344_SHARP_);
} else {
return null;
}
});})(numbers,mx,mn,s))
,numbers));
var t = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),bins], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null));
var lbounds = cljs.core.distinct.call(null,cljs.core.map.call(null,cljs.core.float$,cljs.core.map.call(null,t,cljs.core.range.call(null,bins))));
var ubounds = cljs.core.conj.call(null,cljs.core.mapv.call(null,((function (numbers,mx,mn,s,is,t,lbounds){
return (function (p1__91345_SHARP_){
if(cljs.core._EQ_.call(null,p1__91345_SHARP_,hatti.maths.floor.call(null,p1__91345_SHARP_))){
return (p1__91345_SHARP_ - (1));
} else {
return p1__91345_SHARP_;
}
});})(numbers,mx,mn,s,is,t,lbounds))
,cljs.core.drop.call(null,(1),lbounds)),mx);
var fmt = hatti.charting.int__GT_str.call(null,typ,new cljs.core.Keyword(null,"digits","digits",-1134635061),(0));
var strings = cljs.core.mapv.call(null,((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt){
return (function (p1__91346_SHARP_,p2__91347_SHARP_){
return hatti.charting.range__GT_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__91346_SHARP_,p2__91347_SHARP_], null),typ);
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt))
,lbounds,ubounds);
var results = cljs.core.map.call(null,((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings){
return (function (i){
if(cljs.core.truth_(i)){
return cljs.core.get.call(null,strings,(i | (0)));
} else {
return null;
}
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings))
,is);
var strings__$1 = cljs.core.vec.call(null,cljs.core.distinct.call(null,strings));
return cljs.core.with_meta.call(null,results,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bins","bins",1670395210),((cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,answers),null))?cljs.core.conj.call(null,strings__$1,null):strings__$1)], null));
});
/**
 * Take chart-data from the ona API, returns label->count map.
 * eg. Input: {:field_xpath 'D' :data [{:count 2 :D ['Option_1']}]}
 * Output: {:Option_1 2}
 * eg. Input: {:field_xpath 'D' :data [{:count 1 :D ['O1' 'O_2']
 * :count 2 :D ['O1']}]}
 * Output: {:Option_1 3 :O_2 1}
 */
hatti.charting.label_count_pairs = (function hatti$charting$label_count_pairs(var_args){
var args91350 = [];
var len__5627__auto___91359 = arguments.length;
var i__5628__auto___91360 = (0);
while(true){
if((i__5628__auto___91360 < len__5627__auto___91359)){
args91350.push((arguments[i__5628__auto___91360]));

var G__91361 = (i__5628__auto___91360 + (1));
i__5628__auto___91360 = G__91361;
continue;
} else {
}
break;
}

var G__91352 = args91350.length;
switch (G__91352) {
case 1:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args91350.length)].join('')));

}
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.label_count_pairs.call(null,chart_data,null);
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__91353 = chart_data;
var map__91353__$1 = ((((!((map__91353 == null)))?((((map__91353.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91353.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91353):map__91353);
var data = cljs.core.get.call(null,map__91353__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var field_xpath = cljs.core.get.call(null,map__91353__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var unboxed = (function (){var iter__5341__auto__ = ((function (map__91353,map__91353__$1,data,field_xpath){
return (function hatti$charting$iter__91355(s__91356){
return (new cljs.core.LazySeq(null,((function (map__91353,map__91353__$1,data,field_xpath){
return (function (){
var s__91356__$1 = s__91356;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__91356__$1);
if(temp__4425__auto__){
var s__91356__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__91356__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__91356__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__91358 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__91357 = (0);
while(true){
if((i__91357 < size__5340__auto__)){
var data_item = cljs.core._nth.call(null,c__5339__auto__,i__91357);
cljs.core.chunk_append.call(null,b__91358,(function (){var labels = cljs.core.keyword.call(null,field_xpath).call(null,data_item);
var count = new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (i__91357,labels,count,data_item,c__5339__auto__,size__5340__auto__,b__91358,s__91356__$2,temp__4425__auto__,map__91353,map__91353__$1,data,field_xpath){
return (function (p1__91348_SHARP_){
return hatti.ona.forms.get_label.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),p1__91348_SHARP_], null),language);
});})(i__91357,labels,count,data_item,c__5339__auto__,size__5340__auto__,b__91358,s__91356__$2,temp__4425__auto__,map__91353,map__91353__$1,data,field_xpath))
;
return cljs.core.map.call(null,((function (i__91357,labels,count,labelify,data_item,c__5339__auto__,size__5340__auto__,b__91358,s__91356__$2,temp__4425__auto__,map__91353,map__91353__$1,data,field_xpath){
return (function (p1__91349_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify.call(null,p1__91349_SHARP_)],[count]);
});})(i__91357,labels,count,labelify,data_item,c__5339__auto__,size__5340__auto__,b__91358,s__91356__$2,temp__4425__auto__,map__91353,map__91353__$1,data,field_xpath))
,labels);
})());

var G__91363 = (i__91357 + (1));
i__91357 = G__91363;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91358),hatti$charting$iter__91355.call(null,cljs.core.chunk_rest.call(null,s__91356__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91358),null);
}
} else {
var data_item = cljs.core.first.call(null,s__91356__$2);
return cljs.core.cons.call(null,(function (){var labels = cljs.core.keyword.call(null,field_xpath).call(null,data_item);
var count = new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (labels,count,data_item,s__91356__$2,temp__4425__auto__,map__91353,map__91353__$1,data,field_xpath){
return (function (p1__91348_SHARP_){
return hatti.ona.forms.get_label.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),p1__91348_SHARP_], null),language);
});})(labels,count,data_item,s__91356__$2,temp__4425__auto__,map__91353,map__91353__$1,data,field_xpath))
;
return cljs.core.map.call(null,((function (labels,count,labelify,data_item,s__91356__$2,temp__4425__auto__,map__91353,map__91353__$1,data,field_xpath){
return (function (p1__91349_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify.call(null,p1__91349_SHARP_)],[count]);
});})(labels,count,labelify,data_item,s__91356__$2,temp__4425__auto__,map__91353,map__91353__$1,data,field_xpath))
,labels);
})(),hatti$charting$iter__91355.call(null,cljs.core.rest.call(null,s__91356__$2)));
}
} else {
return null;
}
break;
}
});})(map__91353,map__91353__$1,data,field_xpath))
,null,null));
});})(map__91353,map__91353__$1,data,field_xpath))
;
return iter__5341__auto__.call(null,data);
})();
return cljs.core.sort_by.call(null,cljs.core.last,cljs.core._GT_,cljs.core.apply.call(null,cljs.core.merge_with,cljs.core._PLUS_,cljs.core.flatten.call(null,unboxed)));
});

hatti.charting.label_count_pairs.cljs$lang$maxFixedArity = 2;
/**
 * Determine number of bins if there are n possible of values of data.
 *   Custom algorithm, based on a pleasant range of bins being between
 *   roughly 7 and 15 (though customizable). Idea is that we try to divide
 *   n into a number between 
 */
hatti.charting.num_bins = (function hatti$charting$num_bins(var_args){
var args__5634__auto__ = [];
var len__5627__auto___91369 = arguments.length;
var i__5628__auto___91370 = (0);
while(true){
if((i__5628__auto___91370 < len__5627__auto___91369)){
args__5634__auto__.push((arguments[i__5628__auto___91370]));

var G__91371 = (i__5628__auto___91370 + (1));
i__5628__auto___91370 = G__91371;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__91366){
var map__91367 = p__91366;
var map__91367__$1 = ((((!((map__91367 == null)))?((((map__91367.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91367.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91367):map__91367);
var data_type = cljs.core.get.call(null,map__91367__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"int");
var rough_min = (7);
var rough_max = (15);
var real_max = (24);
var full_range = cljs.core.range.call(null,rough_min,rough_max);
var best_guess = cljs.core.apply.call(null,cljs.core.max,cljs.core.map.call(null,cljs.core.partial.call(null,hatti.maths.gcd,n),full_range));
if((best_guess < rough_min)){
return cljs.core.apply.call(null,cljs.core.partial.call(null,cljs.core.min,real_max,n),cljs.core.map.call(null,cljs.core.partial.call(null,hatti.maths.lcm,n),full_range));
} else {
return best_guess;
}
});

hatti.charting.num_bins.cljs$lang$maxFixedArity = (1);

hatti.charting.num_bins.cljs$lang$applyTo = (function (seq91364){
var G__91365 = cljs.core.first.call(null,seq91364);
var seq91364__$1 = cljs.core.next.call(null,seq91364);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(G__91365,seq91364__$1);
});
/**
 * Turn numerical / date chart-data from ona API histogram-friendly.
 *   Return data looks like [(x dx y)] with-meta {:bins num-bins}.
 */
hatti.charting.extract_data_for_histogram = (function hatti$charting$extract_data_for_histogram(var_args){
var args__5634__auto__ = [];
var len__5627__auto___91383 = arguments.length;
var i__5628__auto___91384 = (0);
while(true){
if((i__5628__auto___91384 < len__5627__auto___91383)){
args__5634__auto__.push((arguments[i__5628__auto___91384]));

var G__91385 = (i__5628__auto___91384 + (1));
i__5628__auto___91384 = G__91385;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__91374){
var map__91375 = p__91374;
var map__91375__$1 = ((((!((map__91375 == null)))?((((map__91375.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91375.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91375):map__91375);
var data_type = cljs.core.get.call(null,map__91375__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"int");
var map__91377 = chart_data;
var map__91377__$1 = ((((!((map__91377 == null)))?((((map__91377.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91377.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91377):map__91377);
var data = cljs.core.get.call(null,map__91377__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var field_xpath = cljs.core.get.call(null,map__91377__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var retype_fn = hatti.charting.str__GT_int.call(null,data_type);
var qn_key = cljs.core.keyword.call(null,field_xpath);
var retyped_data = cljs.core.map.call(null,((function (map__91377,map__91377__$1,data,field_xpath,retype_fn,qn_key,map__91375,map__91375__$1,data_type){
return (function (el){
return cljs.core.update_in.call(null,el,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [qn_key], null),retype_fn);
});})(map__91377,map__91377__$1,data,field_xpath,retype_fn,qn_key,map__91375,map__91375__$1,data_type))
,data);
var data_range = (cljs.core.apply.call(null,cljs.core.max,cljs.core.map.call(null,qn_key,retyped_data)) - cljs.core.apply.call(null,cljs.core.min,cljs.core.map.call(null,qn_key,retyped_data)));
var bins = (((data_range === (0)))?(1):hatti.charting.num_bins.call(null,data_range,new cljs.core.Keyword(null,"data-type","data-type",-326421468),data_type));
var binned_data = c2.layout.histogram.histogram.call(null,retyped_data,new cljs.core.Keyword(null,"value","value",305978217),qn_key,new cljs.core.Keyword(null,"bins","bins",1670395210),bins);
return cljs.core.with_meta.call(null,(function (){var iter__5341__auto__ = ((function (map__91377,map__91377__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__91375,map__91375__$1,data_type){
return (function hatti$charting$iter__91379(s__91380){
return (new cljs.core.LazySeq(null,((function (map__91377,map__91377__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__91375,map__91375__$1,data_type){
return (function (){
var s__91380__$1 = s__91380;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__91380__$1);
if(temp__4425__auto__){
var s__91380__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__91380__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__91380__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__91382 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__91381 = (0);
while(true){
if((i__91381 < size__5340__auto__)){
var data_item = cljs.core._nth.call(null,c__5339__auto__,i__91381);
cljs.core.chunk_append.call(null,b__91382,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),new cljs.core.Keyword(null,"dx","dx",-381796732).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),data_item))], null));

var G__91386 = (i__91381 + (1));
i__91381 = G__91386;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91382),hatti$charting$iter__91379.call(null,cljs.core.chunk_rest.call(null,s__91380__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91382),null);
}
} else {
var data_item = cljs.core.first.call(null,s__91380__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),new cljs.core.Keyword(null,"dx","dx",-381796732).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),data_item))], null),hatti$charting$iter__91379.call(null,cljs.core.rest.call(null,s__91380__$2)));
}
} else {
return null;
}
break;
}
});})(map__91377,map__91377__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__91375,map__91375__$1,data_type))
,null,null));
});})(map__91377,map__91377__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__91375,map__91375__$1,data_type))
;
return iter__5341__auto__.call(null,binned_data);
})(),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bins","bins",1670395210),bins], null));
});

hatti.charting.extract_data_for_histogram.cljs$lang$maxFixedArity = (1);

hatti.charting.extract_data_for_histogram.cljs$lang$applyTo = (function (seq91372){
var G__91373 = cljs.core.first.call(null,seq91372);
var seq91372__$1 = cljs.core.next.call(null,seq91372);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(G__91373,seq91372__$1);
});
/**
 * Produces a linear mapping [0,max-count] -> [0, max-length], for data which
 * is a vector, each element a map with key :count. If total-asmax?, then
 * linear map is [0,total-count] -> [0, max-length].
 */
hatti.charting.counts__GT_lengths = (function hatti$charting$counts__GT_lengths(var_args){
var args__5634__auto__ = [];
var len__5627__auto___91393 = arguments.length;
var i__5628__auto___91394 = (0);
while(true){
if((i__5628__auto___91394 < len__5627__auto___91393)){
args__5634__auto__.push((arguments[i__5628__auto___91394]));

var G__91395 = (i__5628__auto___91394 + (1));
i__5628__auto___91394 = G__91395;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic = (function (data,max_length,p__91390){
var map__91391 = p__91390;
var map__91391__$1 = ((((!((map__91391 == null)))?((((map__91391.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91391.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91391):map__91391);
var total_as_max_QMARK_ = cljs.core.get.call(null,map__91391__$1,new cljs.core.Keyword(null,"total-as-max?","total-as-max?",-1709426453));
var datamin_as_min_QMARK_ = cljs.core.get.call(null,map__91391__$1,new cljs.core.Keyword(null,"datamin-as-min?","datamin-as-min?",1074079715));
var counts = cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),data);
var xmax = (cljs.core.truth_(total_as_max_QMARK_)?cljs.core.reduce.call(null,cljs.core._PLUS_,(0),counts):cljs.core.reduce.call(null,cljs.core.max,(0),counts));
var xmin = (cljs.core.truth_(datamin_as_min_QMARK_)?cljs.core.reduce.call(null,cljs.core.min,(0),counts):(0));
var scale = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),max_length], null));
return cljs.core.map.call(null,scale,counts);
});

hatti.charting.counts__GT_lengths.cljs$lang$maxFixedArity = (2);

hatti.charting.counts__GT_lengths.cljs$lang$applyTo = (function (seq91387){
var G__91388 = cljs.core.first.call(null,seq91387);
var seq91387__$1 = cljs.core.next.call(null,seq91387);
var G__91389 = cljs.core.first.call(null,seq91387__$1);
var seq91387__$2 = cljs.core.next.call(null,seq91387__$1);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic(G__91388,G__91389,seq91387__$2);
});
hatti.charting.response_count_message = (function hatti$charting$response_count_message(response_count){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.t-right.t-grey","div.t-right.t-grey",-2075084293),[cljs.core.str("Based on "),cljs.core.str(response_count),cljs.core.str(" responses.")].join('')], null);
});
/**
 * Create numeric (or date) chart out of some chart-data from ona API.
 */
hatti.charting.numeric_chart = (function hatti$charting$numeric_chart(var_args){
var args__5634__auto__ = [];
var len__5627__auto___91420 = arguments.length;
var i__5628__auto___91421 = (0);
while(true){
if((i__5628__auto___91421 < len__5627__auto___91420)){
args__5634__auto__.push((arguments[i__5628__auto___91421]));

var G__91422 = (i__5628__auto___91421 + (1));
i__5628__auto___91421 = G__91422;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__91398){
var map__91399 = p__91398;
var map__91399__$1 = ((((!((map__91399 == null)))?((((map__91399.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91399.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91399):map__91399);
var data_type = cljs.core.get.call(null,map__91399__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"int");
var chart_width = 700.0;
var chart_height = 300.0;
var margin = 33.0;
var small_margin = 2.0;
var y_lim = 8.0;
var neg_margin = (-15);
var extracted_data = hatti.charting.extract_data_for_histogram.call(null,chart_data,new cljs.core.Keyword(null,"data-type","data-type",-326421468),data_type);
var map__91401 = cljs.core.meta.call(null,chart_data);
var map__91401__$1 = ((((!((map__91401 == null)))?((((map__91401.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91401.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91401):map__91401);
var nil_count = cljs.core.get.call(null,map__91401__$1,new cljs.core.Keyword(null,"nil-count","nil-count",785567731));
var non_nil_count = cljs.core.get.call(null,map__91401__$1,new cljs.core.Keyword(null,"non-nil-count","non-nil-count",-593781457));
var bins = new cljs.core.Keyword(null,"bins","bins",1670395210).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,extracted_data));
var x_series = cljs.core.map.call(null,cljs.core.first,extracted_data);
var dx_series = cljs.core.map.call(null,cljs.core.second,extracted_data);
var y_series = cljs.core.map.call(null,cljs.core.last,extracted_data);
var xmin = cljs.core.apply.call(null,cljs.core.min,x_series);
var xmax = (cljs.core.apply.call(null,cljs.core.max,x_series) + cljs.core.last.call(null,dx_series));
var x_scale = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_width], null));
var y_scale = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),cljs.core.apply.call(null,cljs.core.max,y_series)], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null));
var bin_width = hatti.maths.floor.call(null,((chart_width / bins) - small_margin));
var x_ticks = cljs.core.take_nth.call(null,(2),cljs.core.rest.call(null,x_series));
var fmt = hatti.charting.int__GT_str.call(null,data_type);
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,extracted_data))){
var vec__91403 = cljs.core.first.call(null,extracted_data);
var value = cljs.core.nth.call(null,vec__91403,(0),null);
var _ = cljs.core.nth.call(null,vec__91403,(1),null);
var total = cljs.core.nth.call(null,vec__91403,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),total," records have identical value: ",fmt.call(null,value)], null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),(margin + chart_width),new cljs.core.Keyword(null,"height","height",1025178622),(margin + chart_height)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.chart","g.chart",376683303),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [margin,(0)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),(function (){var iter__5341__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__91401,map__91401__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__91399,map__91399__$1,data_type){
return (function hatti$charting$iter__91404(s__91405){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__91401,map__91401__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__91399,map__91399__$1,data_type){
return (function (){
var s__91405__$1 = s__91405;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__91405__$1);
if(temp__4425__auto__){
var s__91405__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__91405__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__91405__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__91407 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__91406 = (0);
while(true){
if((i__91406 < size__5340__auto__)){
var vec__91412 = cljs.core._nth.call(null,c__5339__auto__,i__91406);
var x = cljs.core.nth.call(null,vec__91412,(0),null);
var dx = cljs.core.nth.call(null,vec__91412,(1),null);
var y = cljs.core.nth.call(null,vec__91412,(2),null);
cljs.core.chunk_append.call(null,b__91407,(function (){var x_scaled = x_scale.call(null,x);
var y_scaled = y_scale.call(null,y);
var vec__91413 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.call(null,vec__91413,(0),null);
var txt_ht = cljs.core.nth.call(null,vec__91413,(1),null);
var txt_cls = cljs.core.nth.call(null,vec__91413,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.bars","g.bars",-1370310225),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rect","rect",-108902628),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"x","x",2099068185),(1),new cljs.core.Keyword(null,"height","height",1025178622),y_scaled__$1,new cljs.core.Keyword(null,"width","width",-384071477),bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"y","y",-1757859776),txt_ht,new cljs.core.Keyword(null,"x","x",2099068185),(bin_width / 2.0),new cljs.core.Keyword(null,"dy","dy",1719547243),"1em",new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),txt_cls], null),y], null):null)], null);
})());

var G__91423 = (i__91406 + (1));
i__91406 = G__91423;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91407),hatti$charting$iter__91404.call(null,cljs.core.chunk_rest.call(null,s__91405__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91407),null);
}
} else {
var vec__91414 = cljs.core.first.call(null,s__91405__$2);
var x = cljs.core.nth.call(null,vec__91414,(0),null);
var dx = cljs.core.nth.call(null,vec__91414,(1),null);
var y = cljs.core.nth.call(null,vec__91414,(2),null);
return cljs.core.cons.call(null,(function (){var x_scaled = x_scale.call(null,x);
var y_scaled = y_scale.call(null,y);
var vec__91415 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.call(null,vec__91415,(0),null);
var txt_ht = cljs.core.nth.call(null,vec__91415,(1),null);
var txt_cls = cljs.core.nth.call(null,vec__91415,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.bars","g.bars",-1370310225),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rect","rect",-108902628),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"x","x",2099068185),(1),new cljs.core.Keyword(null,"height","height",1025178622),y_scaled__$1,new cljs.core.Keyword(null,"width","width",-384071477),bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"y","y",-1757859776),txt_ht,new cljs.core.Keyword(null,"x","x",2099068185),(bin_width / 2.0),new cljs.core.Keyword(null,"dy","dy",1719547243),"1em",new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),txt_cls], null),y], null):null)], null);
})(),hatti$charting$iter__91404.call(null,cljs.core.rest.call(null,s__91405__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__91401,map__91401__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__91399,map__91399__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__91401,map__91401__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__91399,map__91399__$1,data_type))
;
return iter__5341__auto__.call(null,extracted_data);
})()], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.axis","g.axis",837167470),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x1","x1",-1863922247),(0),new cljs.core.Keyword(null,"x2","x2",-1362513475),chart_width], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),(function (){var iter__5341__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__91401,map__91401__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__91399,map__91399__$1,data_type){
return (function hatti$charting$iter__91416(s__91417){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__91401,map__91401__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__91399,map__91399__$1,data_type){
return (function (){
var s__91417__$1 = s__91417;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__91417__$1);
if(temp__4425__auto__){
var s__91417__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__91417__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__91417__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__91419 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__91418 = (0);
while(true){
if((i__91418 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__91418);
cljs.core.chunk_append.call(null,b__91419,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.tick","g.tick",368840735),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scale.call(null,x),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"y","y",-1757859776),(25),new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),data_type], null),fmt.call(null,x)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),"tick",new cljs.core.Keyword(null,"y2","y2",-718691301),(10),new cljs.core.Keyword(null,"x2","x2",-1362513475),(0)], null)], null)], null));

var G__91424 = (i__91418 + (1));
i__91418 = G__91424;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91419),hatti$charting$iter__91416.call(null,cljs.core.chunk_rest.call(null,s__91417__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91419),null);
}
} else {
var x = cljs.core.first.call(null,s__91417__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.tick","g.tick",368840735),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scale.call(null,x),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"y","y",-1757859776),(25),new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),data_type], null),fmt.call(null,x)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),"tick",new cljs.core.Keyword(null,"y2","y2",-718691301),(10),new cljs.core.Keyword(null,"x2","x2",-1362513475),(0)], null)], null)], null),hatti$charting$iter__91416.call(null,cljs.core.rest.call(null,s__91417__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__91401,map__91401__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__91399,map__91399__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__91401,map__91401__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__91399,map__91399__$1,data_type))
;
return iter__5341__auto__.call(null,x_ticks);
})()], null)], null)], null)], null),hatti.charting.response_count_message.call(null,non_nil_count)], null);
}
});

hatti.charting.numeric_chart.cljs$lang$maxFixedArity = (1);

hatti.charting.numeric_chart.cljs$lang$applyTo = (function (seq91396){
var G__91397 = cljs.core.first.call(null,seq91396);
var seq91396__$1 = cljs.core.next.call(null,seq91396);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(G__91397,seq91396__$1);
});
/**
 * Create category bar chart out of some data + count data. Data of form:
 *   {'Label1' 1 'Label2' 2}, etc. where the numbers are counts.
 */
hatti.charting.table_chart_h = (function hatti$charting$table_chart_h(data,nil_count,non_nil_count,field_type){
var max_count = cljs.core.apply.call(null,cljs.core.max,cljs.core.vals.call(null,data));
var percent_s = ((function (max_count){
return (function (n,total){
var s = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),total], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null));
return [cljs.core.str(hatti.utils.format.call(null,"%.1f",s.call(null,n))),cljs.core.str("%")].join('');
});})(max_count))
;
var select_mult_QMARK_ = cljs.core._EQ_.call(null,field_type,"select all that apply");
var bar_div = ((select_mult_QMARK_)?new cljs.core.Keyword(null,"div.bars.select-mult","div.bars.select-mult",514551318):new cljs.core.Keyword(null,"div.bars.select-one","div.bars.select-one",-235690381));
var tdr = new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table#bar-chart.table","table#bar-chart.table",-82390780),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th.t-right","th.t-right",-959248017),"Count"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th.t-right","th.t-right",-959248017),"Percent"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tfoot","tfoot",-701599890),((select_mult_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr.t-grey","tr.t-grey",1706085529),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"col-span","col-span",-232603210),(4)], null),hatti.charting.response_count_message.call(null,non_nil_count)], null)], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr.t-grey","tr.t-grey",1706085529),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"Total"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,non_nil_count], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"100%"], null)], null)),(((!(select_mult_QMARK_)) && ((nil_count > (0))))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr.t-grey","tr.t-grey",1706085529),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),"No response"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),nil_count], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353)], null)], null):null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),(function (){var iter__5341__auto__ = ((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function hatti$charting$table_chart_h_$_iter__91433(s__91434){
return (new cljs.core.LazySeq(null,((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function (){
var s__91434__$1 = s__91434;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__91434__$1);
if(temp__4425__auto__){
var s__91434__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__91434__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__91434__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__91436 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__91435 = (0);
while(true){
if((i__91435 < size__5340__auto__)){
var vec__91439 = cljs.core._nth.call(null,c__5339__auto__,i__91435);
var label = cljs.core.nth.call(null,vec__91439,(0),null);
var val = cljs.core.nth.call(null,vec__91439,(1),null);
cljs.core.chunk_append.call(null,b__91436,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),percent_s.call(null,val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),percent_s.call(null,val,non_nil_count)], null)], null));

var G__91441 = (i__91435 + (1));
i__91435 = G__91441;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91436),hatti$charting$table_chart_h_$_iter__91433.call(null,cljs.core.chunk_rest.call(null,s__91434__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91436),null);
}
} else {
var vec__91440 = cljs.core.first.call(null,s__91434__$2);
var label = cljs.core.nth.call(null,vec__91440,(0),null);
var val = cljs.core.nth.call(null,vec__91440,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),percent_s.call(null,val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),percent_s.call(null,val,non_nil_count)], null)], null),hatti$charting$table_chart_h_$_iter__91433.call(null,cljs.core.rest.call(null,s__91434__$2)));
}
} else {
return null;
}
break;
}
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
,null,null));
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
;
return iter__5341__auto__.call(null,data);
})()], null)], null);
});
/**
 * Removes nil from Ona API chart data; adds nil- and non-nil-count metadata.
 * ex. Input:  {:field_xpath 'D' :data [{:D nil :count 5} {:D 1 :count 10}]}
 *     Output: {:field_xpath 'D' :data [{:D 1 :count 10}]}
 *             w/ metadata: {:nil-count 5 :non-nil-count 10}
 */
hatti.charting.extract_nil = (function hatti$charting$extract_nil(chart_data){
var map__91447 = chart_data;
var map__91447__$1 = ((((!((map__91447 == null)))?((((map__91447.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91447.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91447):map__91447);
var field_xpath = cljs.core.get.call(null,map__91447__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var data = cljs.core.get.call(null,map__91447__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var na_QMARK_ = ((function (map__91447,map__91447__$1,field_xpath,data){
return (function (p1__91442_SHARP_){
return ((p1__91442_SHARP_ == null)) || (cljs.core._EQ_.call(null,cljs.core.PersistentVector.EMPTY,p1__91442_SHARP_));
});})(map__91447,map__91447__$1,field_xpath,data))
;
var nil_data = cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__91447,map__91447__$1,field_xpath,data,na_QMARK_){
return (function (p1__91443_SHARP_){
return na_QMARK_.call(null,cljs.core.keyword.call(null,field_xpath).call(null,p1__91443_SHARP_));
});})(map__91447,map__91447__$1,field_xpath,data,na_QMARK_))
,data));
var non_nil_data = cljs.core.remove.call(null,((function (map__91447,map__91447__$1,field_xpath,data,na_QMARK_,nil_data){
return (function (p1__91444_SHARP_){
return na_QMARK_.call(null,cljs.core.keyword.call(null,field_xpath).call(null,p1__91444_SHARP_));
});})(map__91447,map__91447__$1,field_xpath,data,na_QMARK_,nil_data))
,data);
var nil_count = (function (){var temp__4423__auto__ = new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(nil_data);
if(cljs.core.truth_(temp__4423__auto__)){
var n = temp__4423__auto__;
return n;
} else {
return (0);
}
})();
var non_nil_count = cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),non_nil_data));
return cljs.core.with_meta.call(null,cljs.core.assoc.call(null,chart_data,new cljs.core.Keyword(null,"data","data",-232669377),non_nil_data),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"nil-count","nil-count",785567731),nil_count,new cljs.core.Keyword(null,"non-nil-count","non-nil-count",-593781457),non_nil_count], null));
});
/**
 * Make chart depending on datatype.
 */
hatti.charting.make_chart = (function hatti$charting$make_chart(var_args){
var args91450 = [];
var len__5627__auto___91458 = arguments.length;
var i__5628__auto___91459 = (0);
while(true){
if((i__5628__auto___91459 < len__5627__auto___91458)){
args91450.push((arguments[i__5628__auto___91459]));

var G__91460 = (i__5628__auto___91459 + (1));
i__5628__auto___91459 = G__91460;
continue;
} else {
}
break;
}

var G__91452 = args91450.length;
switch (G__91452) {
case 1:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args91450.length)].join('')));

}
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.make_chart.call(null,chart_data,null);
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__91453 = chart_data;
var map__91453__$1 = ((((!((map__91453 == null)))?((((map__91453.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91453.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91453):map__91453);
var field_label = cljs.core.get.call(null,map__91453__$1,new cljs.core.Keyword(null,"field_label","field_label",-690619633));
var data_type = cljs.core.get.call(null,map__91453__$1,new cljs.core.Keyword(null,"data_type","data_type",1391137078));
var field_xpath = cljs.core.get.call(null,map__91453__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var field_type = cljs.core.get.call(null,map__91453__$1,new cljs.core.Keyword(null,"field_type","field_type",1135193526));
var chart_data__$1 = hatti.charting.extract_nil.call(null,chart_data);
var map__91454 = cljs.core.meta.call(null,chart_data__$1);
var map__91454__$1 = ((((!((map__91454 == null)))?((((map__91454.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91454.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91454):map__91454);
var nil_count = cljs.core.get.call(null,map__91454__$1,new cljs.core.Keyword(null,"nil-count","nil-count",785567731));
var non_nil_count = cljs.core.get.call(null,map__91454__$1,new cljs.core.Keyword(null,"non-nil-count","non-nil-count",-593781457));
var not_supported = ((function (map__91453,map__91453__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__91454,map__91454__$1,nil_count,non_nil_count){
return (function (p1__91449_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"div.t-red","div.t-red",-489419212),[cljs.core.str("Aplogies. At the moment, making a chart of\n                                     this data type ("),cljs.core.str(p1__91449_SHARP_),cljs.core.str(") is not supported.")].join('')],null));
});})(map__91453,map__91453__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__91454,map__91454__$1,nil_count,non_nil_count))
;
var chart = (((non_nil_count === (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),"No data"], null):(function (){var G__91457 = data_type;
switch (G__91457) {
case "categorized":
return hatti.charting.table_chart_h.call(null,hatti.charting.label_count_pairs.call(null,chart_data__$1,language),nil_count,non_nil_count,field_type);

break;
case "time_based":
return hatti.charting.numeric_chart.call(null,chart_data__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"date");

break;
case "numeric":
return hatti.charting.numeric_chart.call(null,chart_data__$1);

break;
default:
return not_supported.call(null,data_type);

}
})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"label","label",1718410804),field_label,new cljs.core.Keyword(null,"name","name",1843675177),field_xpath,new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),chart], null)], null);
});

hatti.charting.make_chart.cljs$lang$maxFixedArity = 2;
