// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.map.style');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('hatti.ona.forms');
hatti.map.style.user_customizable_styles = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["color",null], null), null);
/**
 * Saturated qualitative palette from colorbrewer.
 * Saturated red+brown disabled due to clash with the :clicked color.
 */
hatti.map.style.qualitative_palette = new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#1f78b4","#33a02c","#6a3d9a","#ffff99","#b15928","#a6cee3","#b2df8a","#fb9a99","#fdbf6f","#cab2d6"], null);
/**
 * Color palette of YlGnBl from colorbrewer.
 */
hatti.map.style.sequential_palette = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#ffffcc","#bdd7e7","#6baed6","#3182bd","#08519c"], null);
/**
 * A Grey Color for deselected points.
 */
hatti.map.style.grey = "#d9d9d9";
hatti.map.style.customizable_style_QMARK_ = (function hatti$map$style$customizable_style_QMARK_(p__91195){
var vec__91197 = p__91195;
var style_name = cljs.core.nth.call(null,vec__91197,(0),null);
var _ = cljs.core.nth.call(null,vec__91197,(1),null);
return cljs.core.contains_QMARK_.call(null,hatti.map.style.user_customizable_styles,style_name);
});
/**
 * Return a map of a form field answer name to CSS rules
 */
hatti.map.style.get_css_rule_map = (function hatti$map$style$get_css_rule_map(appearance_attribute){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__91201){
var vec__91202 = p__91201;
var key = cljs.core.nth.call(null,vec__91202,(0),null);
var value = cljs.core.nth.call(null,vec__91202,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,key),value], null);
}),cljs.core.filter.call(null,hatti.map.style.customizable_style_QMARK_,cljs.core.map.call(null,(function (p1__91198_SHARP_){
return clojure.string.split.call(null,p1__91198_SHARP_,/:/);
}),clojure.string.split.call(null,appearance_attribute,/;/)))));
});
/**
 * Return a map 
 */
hatti.map.style.group_user_defined_styles_by_answer = (function hatti$map$style$group_user_defined_styles_by_answer(p__91203){
var map__91209 = p__91203;
var map__91209__$1 = ((((!((map__91209 == null)))?((((map__91209.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91209.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91209):map__91209);
var children = cljs.core.get.call(null,map__91209__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,((function (map__91209,map__91209__$1,children){
return (function (p__91211){
var map__91212 = p__91211;
var map__91212__$1 = ((((!((map__91212 == null)))?((((map__91212.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91212.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91212):map__91212);
var name = cljs.core.get.call(null,map__91212__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var appearance = cljs.core.get.call(null,map__91212__$1,new cljs.core.Keyword(null,"appearance","appearance",-216383432));
return cljs.core.PersistentArrayMap.fromArray([name,hatti.map.style.get_css_rule_map.call(null,appearance)], true, false);
});})(map__91209,map__91209__$1,children))
,children));
});
hatti.map.style.style_map__GT_color_map = (function hatti$map$style$style_map__GT_color_map(p__91214){
var vec__91216 = p__91214;
var answer = cljs.core.nth.call(null,vec__91216,(0),null);
var style = cljs.core.nth.call(null,vec__91216,(1),null);
return cljs.core.PersistentArrayMap.fromArray([answer,new cljs.core.Keyword(null,"color","color",1011675173).cljs$core$IFn$_invoke$arity$1(style)], true, false);
});
hatti.map.style.group_user_defined_colors_by_answer = (function hatti$map$style$group_user_defined_colors_by_answer(field){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,hatti.map.style.style_map__GT_color_map,hatti.map.style.group_user_defined_styles_by_answer.call(null,field)));
});
/**
 * Return the appropriate set of colors given the field. For a select_one,
 * returns a mapping of answer to color. Returns a string for all other field
 * types
 */
hatti.map.style.field__GT_colors = (function hatti$map$style$field__GT_colors(field){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_.call(null,field))){
if((cljs.core.count.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(field)) <= cljs.core.count.call(null,hatti.map.style.qualitative_palette))){
return hatti.map.style.qualitative_palette;
} else {
return cljs.core.repeat.call(null,"#f30");
}
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_.call(null,field))){
return hatti.map.style.qualitative_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))){
return hatti.map.style.sequential_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))){
return hatti.map.style.sequential_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_.call(null,field))){
return cljs.core.repeat.call(null,"#f30");
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))){
return cljs.core.repeat.call(null,"#f30");
} else {
return null;
}
}
}
}
}
}
});
hatti.map.style.answer__GT_color = (function hatti$map$style$answer__GT_color(p__91217,answers){
var map__91220 = p__91217;
var map__91220__$1 = ((((!((map__91220 == null)))?((((map__91220.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91220.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91220):map__91220);
var field = map__91220__$1;
var children = cljs.core.get.call(null,map__91220__$1,new cljs.core.Keyword(null,"children","children",-940561982));
if(cljs.core.truth_((function (){var and__4557__auto__ = hatti.ona.forms.select_one_QMARK_.call(null,field);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.every_QMARK_.call(null,new cljs.core.Keyword(null,"appearance","appearance",-216383432),children);
} else {
return and__4557__auto__;
}
})())){
return hatti.map.style.group_user_defined_colors_by_answer.call(null,field);
} else {
return cljs.core.zipmap.call(null,answers,hatti.map.style.field__GT_colors.call(null,field));

}
});
