// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('hatti.constants');
goog.require('hatti.ona.forms');
goog.require('hatti.utils');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"point","point",1813198264),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),{"radius": (6), "fillColor": "#f30", "reset": {"fillColor": "#f30"}, "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9},new cljs.core.Keyword(null,"hover","hover",-341141711),{"fillColor": "#631400"},new cljs.core.Keyword(null,"clicked","clicked",114423720),{"fillColor": "#ad2300"}], null),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),{"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8},new cljs.core.Keyword(null,"hover","hover",-341141711),{"fillColor": "#631400", "color": "#222"},new cljs.core.Keyword(null,"clicked","clicked",114423720),{"fillColor": "#ad2300", "color": "#222"}], null),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),{"color": "#f30", "opacity": (1), "weight": (6), "reset": {"color": "#f30"}},new cljs.core.Keyword(null,"hover","hover",-341141711),{"color": "#631400"},new cljs.core.Keyword(null,"clicked","clicked",114423720),{"color": "#ad2300"}], null)], null);
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",new cljs.core.Keyword(null,"point","point",1813198264),"Polygon",new cljs.core.Keyword(null,"shape","shape",1190694006),"LineString",new cljs.core.Keyword(null,"line","line",212345235)], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(marker_or_keyword,style_type){
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype.call(null,marker_or_keyword));
return style_type.call(null,kw.call(null,hatti.map.utils.ona_styles));
});
hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.call(null,s);
var tc = cljs.core.js__GT_clj.call(null,t);
return cljs.core._EQ_.call(null,cljs.core.select_keys.call(null,sc,cljs.core.keys.call(null,tc)),cljs.core.select_keys.call(null,tc,cljs.core.keys.call(null,sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args91224 = [];
var len__5627__auto___91227 = arguments.length;
var i__5628__auto___91228 = (0);
while(true){
if((i__5628__auto___91228 < len__5627__auto___91227)){
args91224.push((arguments[i__5628__auto___91228]));

var G__91229 = (i__5628__auto___91228 + (1));
i__5628__auto___91228 = G__91229;
continue;
} else {
}
break;
}

var G__91226 = args91224.length;
switch (G__91226) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args91224.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
return kw.call(null,cljs.core.js__GT_clj.call(null,hatti.map.utils.get_style.call(null,marker)));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;
/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style.call(null,hatti.map.utils.get_style.call(null,marker),hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"clicked","clicked",114423720)));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = marker__GT_style.call(null,marker);
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return marker.setStyle(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"reset","reset",-800929946),style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,style,new cljs.core.Keyword(null,"reset","reset",-800929946),style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4423__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4423__auto__)){
var rstyle = temp__4423__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__4569__auto__ = hatti.map.utils.is_clicked_QMARK_.call(null,marker);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return id_selected_QMARK_.call(null,hatti.map.utils.get_id.call(null,marker));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"clicked","clicked",114423720)));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style.call(null,marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"hover","hover",-341141711)));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__5634__auto__ = [];
var len__5627__auto___91240 = arguments.length;
var i__5628__auto___91241 = (0);
while(true){
if((i__5628__auto___91241 < len__5627__auto___91240)){
args__5634__auto__.push((arguments[i__5628__auto___91241]));

var G__91242 = (i__5628__auto___91241 + (1));
i__5628__auto___91241 = G__91242;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__91233){
var map__91234 = p__91233;
var map__91234__$1 = ((((!((map__91234 == null)))?((((map__91234.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91234.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91234):map__91234);
var preserve_clicked_QMARK_ = cljs.core.get.call(null,map__91234__$1,new cljs.core.Keyword(null,"preserve-clicked?","preserve-clicked?",-727263842),true);
var seq__91236 = cljs.core.seq.call(null,markers);
var chunk__91237 = null;
var count__91238 = (0);
var i__91239 = (0);
while(true){
if((i__91239 < count__91238)){
var marker = cljs.core._nth.call(null,chunk__91237,i__91239);
if(cljs.core.not.call(null,(function (){var and__4557__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return hatti.map.utils.is_clicked_QMARK_.call(null,marker);
} else {
return and__4557__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
} else {
}

var G__91243 = seq__91236;
var G__91244 = chunk__91237;
var G__91245 = count__91238;
var G__91246 = (i__91239 + (1));
seq__91236 = G__91243;
chunk__91237 = G__91244;
count__91238 = G__91245;
i__91239 = G__91246;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__91236);
if(temp__4425__auto__){
var seq__91236__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__91236__$1)){
var c__5372__auto__ = cljs.core.chunk_first.call(null,seq__91236__$1);
var G__91247 = cljs.core.chunk_rest.call(null,seq__91236__$1);
var G__91248 = c__5372__auto__;
var G__91249 = cljs.core.count.call(null,c__5372__auto__);
var G__91250 = (0);
seq__91236 = G__91247;
chunk__91237 = G__91248;
count__91238 = G__91249;
i__91239 = G__91250;
continue;
} else {
var marker = cljs.core.first.call(null,seq__91236__$1);
if(cljs.core.not.call(null,(function (){var and__4557__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return hatti.map.utils.is_clicked_QMARK_.call(null,marker);
} else {
return and__4557__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
} else {
}

var G__91251 = cljs.core.next.call(null,seq__91236__$1);
var G__91252 = null;
var G__91253 = (0);
var G__91254 = (0);
seq__91236 = G__91251;
chunk__91237 = G__91252;
count__91238 = G__91253;
i__91239 = G__91254;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq91231){
var G__91232 = cljs.core.first.call(null,seq91231);
var seq91231__$1 = cljs.core.next.call(null,seq91231);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__91232,seq91231__$1);
});
hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string.call(null,maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.get_as_geom = (function hatti$map$utils$get_as_geom(record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq.call(null,s)) && (cljs.core.not_EQ_.call(null,s,"n/a"))){
var iter__5341__auto__ = ((function (geotype){
return (function hatti$map$utils$get_as_geom_$_iter__91266(s__91267){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__91267__$1 = s__91267;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__91267__$1);
if(temp__4425__auto__){
var s__91267__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__91267__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__91267__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__91269 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__91268 = (0);
while(true){
if((i__91268 < size__5340__auto__)){
var coord_string = cljs.core._nth.call(null,c__5339__auto__,i__91268);
cljs.core.chunk_append.call(null,b__91269,(function (){var vec__91272 = clojure.string.split.call(null,coord_string,/ /);
var lat = cljs.core.nth.call(null,vec__91272,(0),null);
var lng = cljs.core.nth.call(null,vec__91272,(1),null);
var _ = cljs.core.nth.call(null,vec__91272,(2),null);
var ___$1 = cljs.core.nth.call(null,vec__91272,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.call(null,lng),cljs.reader.read_string.call(null,lat)], null);
})());

var G__91275 = (i__91268 + (1));
i__91268 = G__91275;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91269),hatti$map$utils$get_as_geom_$_iter__91266.call(null,cljs.core.chunk_rest.call(null,s__91267__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91269),null);
}
} else {
var coord_string = cljs.core.first.call(null,s__91267__$2);
return cljs.core.cons.call(null,(function (){var vec__91273 = clojure.string.split.call(null,coord_string,/ /);
var lat = cljs.core.nth.call(null,vec__91273,(0),null);
var lng = cljs.core.nth.call(null,vec__91273,(1),null);
var _ = cljs.core.nth.call(null,vec__91273,(2),null);
var ___$1 = cljs.core.nth.call(null,vec__91273,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.call(null,lng),cljs.reader.read_string.call(null,lat)], null);
})(),hatti$map$utils$get_as_geom_$_iter__91266.call(null,cljs.core.rest.call(null,s__91267__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__5341__auto__.call(null,clojure.string.split.call(null,s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__91274 = geotype;
switch (G__91274) {
case "Point":
return ((function (G__91274,geotype,parse){
return (function (p1__91255_SHARP_){
return cljs.core.first.call(null,parse.call(null,p1__91255_SHARP_));
});
;})(G__91274,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__91274,geotype,parse){
return (function (p1__91256_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse.call(null,p1__91256_SHARP_)],null));
});
;})(G__91274,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var key = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(geofield);
var value = cljs.core.get.call(null,record,key);
var coords = coordfn.call(null,value);
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_.call(null,geofield))){
return new cljs.core.Keyword(null,"geom","geom",1207084371).cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__4569__auto__ = (coords == null);
if(or__4569__auto__){
return or__4569__auto__;
} else {
return cljs.core.some.call(null,cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),geotype,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668),coords], null);
}
}
});
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args91277 = [];
var len__5627__auto___91288 = arguments.length;
var i__5628__auto___91289 = (0);
while(true){
if((i__5628__auto___91289 < len__5627__auto___91288)){
args91277.push((arguments[i__5628__auto___91289]));

var G__91290 = (i__5628__auto___91289 + (1));
i__5628__auto___91289 = G__91290;
continue;
} else {
}
break;
}

var G__91279 = args91277.length;
switch (G__91279) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args91277.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.call(null,dataset,form,hatti.ona.forms.default_geofield.call(null,form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"FeatureCollection",new cljs.core.Keyword(null,"features","features",-1146962336),(function (){var iter__5341__auto__ = (function hatti$map$utils$iter__91280(s__91281){
return (new cljs.core.LazySeq(null,(function (){
var s__91281__$1 = s__91281;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__91281__$1);
if(temp__4425__auto__){
var s__91281__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__91281__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__91281__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__91283 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__91282 = (0);
while(true){
if((i__91282 < size__5340__auto__)){
var vec__91286 = cljs.core._nth.call(null,c__5339__auto__,i__91282);
var idx = cljs.core.nth.call(null,vec__91286,(0),null);
var record = cljs.core.nth.call(null,vec__91286,(1),null);
var geo = hatti.map.utils.get_as_geom.call(null,record,geofield);
if(cljs.core.truth_(geo)){
cljs.core.chunk_append.call(null,b__91283,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"Feature",new cljs.core.Keyword(null,"properties","properties",685819552),cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.call(null,hatti.constants._rank),(idx + (1)),cljs.core.keyword.call(null,hatti.constants._id),record.call(null,hatti.constants._id)], true, false),new cljs.core.Keyword(null,"geometry","geometry",-405034994),geo], null));

var G__91292 = (i__91282 + (1));
i__91282 = G__91292;
continue;
} else {
var G__91293 = (i__91282 + (1));
i__91282 = G__91293;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91283),hatti$map$utils$iter__91280.call(null,cljs.core.chunk_rest.call(null,s__91281__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__91283),null);
}
} else {
var vec__91287 = cljs.core.first.call(null,s__91281__$2);
var idx = cljs.core.nth.call(null,vec__91287,(0),null);
var record = cljs.core.nth.call(null,vec__91287,(1),null);
var geo = hatti.map.utils.get_as_geom.call(null,record,geofield);
if(cljs.core.truth_(geo)){
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"Feature",new cljs.core.Keyword(null,"properties","properties",685819552),cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.call(null,hatti.constants._rank),(idx + (1)),cljs.core.keyword.call(null,hatti.constants._id),record.call(null,hatti.constants._id)], true, false),new cljs.core.Keyword(null,"geometry","geometry",-405034994),geo], null),hatti$map$utils$iter__91280.call(null,cljs.core.rest.call(null,s__91281__$2)));
} else {
var G__91294 = cljs.core.rest.call(null,s__91281__$2);
s__91281__$1 = G__91294;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,hatti.utils.indexed.call(null,dataset));
})()], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;
/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__91296){
var map__91299 = p__91296;
var map__91299__$1 = ((((!((map__91299 == null)))?((((map__91299.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91299.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91299):map__91299);
var mapbox_tiles = cljs.core.get.call(null,map__91299__$1,new cljs.core.Keyword(null,"mapbox-tiles","mapbox-tiles",69952469));
var include_google_maps_QMARK_ = cljs.core.get.call(null,map__91299__$1,new cljs.core.Keyword(null,"include-google-maps?","include-google-maps?",1820261665));
var layers = cljs.core.map.call(null,((function (map__91299,map__91299__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__91295_SHARP_){
return L.tileLayer(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(p1__91295_SHARP_));
});})(map__91299,map__91299__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js.call(null,nlayers));
var m = L.map(id,{"layers": cljs.core.first.call(null,layers), "zoomControl": false});
var z = L.control.zoom.call(null,{"position": "bottomleft"});
z.addTo(m);

L.control.layers.call(null,named_layers,null,{"position": "bottomleft"}).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return cljs.core.async.put_BANG_.call(null,event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mapped-submission-to-rank","mapped-submission-to-rank",-1281314361),((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style.call(null,marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style.call(null,marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not.call(null,layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__5634__auto__ = [];
var len__5627__auto___91313 = arguments.length;
var i__5628__auto___91314 = (0);
while(true){
if((i__5628__auto___91314 < len__5627__auto___91313)){
args__5634__auto__.push((arguments[i__5628__auto___91314]));

var G__91315 = (i__5628__auto___91314 + (1));
i__5628__auto___91314 = G__91315;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__91310){
var map__91311 = p__91310;
var map__91311__$1 = ((((!((map__91311 == null)))?((((map__91311.cljs$lang$protocol_mask$partition0$ & (64))) || (map__91311.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__91311):map__91311);
var rezoom_QMARK_ = cljs.core.get.call(null,map__91311__$1,new cljs.core.Keyword(null,"rezoom?","rezoom?",746240707));
var on_events = ((function (map__91311,map__91311__$1,rezoom_QMARK_){
return (function (p1__91301_SHARP_,p2__91302_SHARP_){
return hatti.map.utils.register_mouse_events.call(null,p1__91301_SHARP_,p2__91302_SHARP_,event_chan);
});})(map__91311,map__91311__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",new cljs.core.Keyword(null,"point","point",1813198264),"Polygon",new cljs.core.Keyword(null,"shape","shape",1190694006),"LineString",new cljs.core.Keyword(null,"line","line",212345235)], null).call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__91311,map__91311__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style.call(null,geometry_type,new cljs.core.Keyword(null,"normal","normal",-1519123858));
});})(on_events,geometry_type,map__91311,map__91311__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__91311,map__91311__$1,rezoom_QMARK_){
return (function (p1__91304_SHARP_,p2__91303_SHARP_){
return L.circleMarker(p2__91303_SHARP_);
});})(on_events,geometry_type,stylefn,map__91311,map__91311__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js.call(null,geojson),{"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn});
var ids = cljs.core.map.call(null,((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__91311,map__91311__$1,rezoom_QMARK_){
return (function (p1__91305_SHARP_){
return cljs.core.get_in.call(null,p1__91305_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"properties","properties",685819552),cljs.core.keyword.call(null,hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__91311,map__91311__$1,rezoom_QMARK_))
,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"feature-layer","feature-layer",2086639246),feature_layer,new cljs.core.Keyword(null,"markers","markers",-246919693),markers,new cljs.core.Keyword(null,"id->marker","id->marker",-1702427771),cljs.core.zipmap.call(null,ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq91306){
var G__91307 = cljs.core.first.call(null,seq91306);
var seq91306__$1 = cljs.core.next.call(null,seq91306);
var G__91308 = cljs.core.first.call(null,seq91306__$1);
var seq91306__$2 = cljs.core.next.call(null,seq91306__$1);
var G__91309 = cljs.core.first.call(null,seq91306__$2);
var seq91306__$3 = cljs.core.next.call(null,seq91306__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__91307,G__91308,G__91309,seq91306__$3);
});
