// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._id,new cljs.core.Keyword(null,"label","label",1718410804),"id",new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._id,new cljs.core.Keyword(null,"type","type",1174270348),"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.call(null,extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___93584 = arguments.length;
var i__5628__auto___93585 = (0);
while(true){
if((i__5628__auto___93585 < len__5627__auto___93584)){
args__5634__auto__.push((arguments[i__5628__auto___93585]));

var G__93586 = (i__5628__auto___93585 + (1));
i__5628__auto___93585 = G__93586;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__93581){
var map__93582 = p__93581;
var map__93582__$1 = ((((!((map__93582 == null)))?((((map__93582.cljs$lang$protocol_mask$partition0$ & (64))) || (map__93582.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__93582):map__93582);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__93582__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,hatti.views.table.get_extra_fields.call(null,is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),cljs.core.not.call(null,is_filtered_dataview_QMARK_)))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq93579){
var G__93580 = cljs.core.first.call(null,seq93579);
var seq93579__$1 = cljs.core.next.call(null,seq93579);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__93580,seq93579__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__93587_SHARP_){
if(typeof p1__93587_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__93587_SHARP_);
} else {
return p1__93587_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__93591){
var vec__93592 = p__93591;
var fname = cljs.core.nth.call(null,vec__93592,(0),null);
var answer = cljs.core.nth.call(null,vec__93592,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__93588_SHARP_){
return cljs.core.re_find.call(null,hatti.utils.safe_regex.call(null,query),[cljs.core.str(p1__93588_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,clj_value,language,true);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args93593 = [];
var len__5627__auto___93615 = arguments.length;
var i__5628__auto___93616 = (0);
while(true){
if((i__5628__auto___93616 < len__5627__auto___93615)){
args93593.push((arguments[i__5628__auto___93616]));

var G__93617 = (i__5628__auto___93616 + (1));
i__5628__auto___93616 = G__93617;
continue;
} else {
}
break;
}

var G__93599 = args93593.length;
switch (G__93599) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args93593.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__93600){
var map__93601 = p__93600;
var map__93601__$1 = ((((!((map__93601 == null)))?((((map__93601.cljs$lang$protocol_mask$partition0$ & (64))) || (map__93601.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__93601):map__93601);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__93601__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.clj__GT_js.call(null,(function (){var iter__5341__auto__ = ((function (map__93601,map__93601__$1,is_filtered_dataview_QMARK_){
return (function hatti$views$table$iter__93603(s__93604){
return (new cljs.core.LazySeq(null,((function (map__93601,map__93601__$1,is_filtered_dataview_QMARK_){
return (function (){
var s__93604__$1 = s__93604;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__93604__$1);
if(temp__4425__auto__){
var s__93604__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__93604__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__93604__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__93606 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__93605 = (0);
while(true){
if((i__93605 < size__5340__auto__)){
var field = cljs.core._nth.call(null,c__5339__auto__,i__93605);
cljs.core.chunk_append.call(null,b__93606,(function (){var map__93611 = field;
var map__93611__$1 = ((((!((map__93611 == null)))?((((map__93611.cljs$lang$protocol_mask$partition0$ & (64))) || (map__93611.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__93611):map__93611);
var name = cljs.core.get.call(null,map__93611__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__93611__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__93611__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})());

var G__93619 = (i__93605 + (1));
i__93605 = G__93619;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__93606),hatti$views$table$iter__93603.call(null,cljs.core.chunk_rest.call(null,s__93604__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__93606),null);
}
} else {
var field = cljs.core.first.call(null,s__93604__$2);
return cljs.core.cons.call(null,(function (){var map__93613 = field;
var map__93613__$1 = ((((!((map__93613 == null)))?((((map__93613.cljs$lang$protocol_mask$partition0$ & (64))) || (map__93613.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__93613):map__93613);
var name = cljs.core.get.call(null,map__93613__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__93613__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__93613__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})(),hatti$views$table$iter__93603.call(null,cljs.core.rest.call(null,s__93604__$2)));
}
} else {
return null;
}
break;
}
});})(map__93601,map__93601__$1,is_filtered_dataview_QMARK_))
,null,null));
});})(map__93601,map__93601__$1,is_filtered_dataview_QMARK_))
;
return iter__5341__auto__.call(null,hatti.views.table.all_fields.call(null,form,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_));
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq93594){
var G__93595 = cljs.core.first.call(null,seq93594);
var seq93594__$1 = cljs.core.next.call(null,seq93594);
var G__93596 = cljs.core.first.call(null,seq93594__$1);
var seq93594__$2 = cljs.core.next.call(null,seq93594__$1);
var G__93597 = cljs.core.first.call(null,seq93594__$2);
var seq93594__$3 = cljs.core.next.call(null,seq93594__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__93595,G__93596,G__93597,seq93594__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": true};
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__93628(s__93629){
return (new cljs.core.LazySeq(null,(function (){
var s__93629__$1 = s__93629;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__93629__$1);
if(temp__4425__auto__){
var s__93629__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__93629__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__93629__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__93631 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__93630 = (0);
while(true){
if((i__93630 < size__5340__auto__)){
var vec__93634 = cljs.core._nth.call(null,c__5339__auto__,i__93630);
var handler_key = cljs.core.nth.call(null,vec__93634,(0),null);
var handler_function = cljs.core.nth.call(null,vec__93634,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__93631,event.subscribe(handler_function));

var G__93636 = (i__93630 + (1));
i__93630 = G__93636;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__93631),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__93628.call(null,cljs.core.chunk_rest.call(null,s__93629__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__93631),null);
}
} else {
var vec__93635 = cljs.core.first.call(null,s__93629__$2);
var handler_key = cljs.core.nth.call(null,vec__93635,(0),null);
var handler_function = cljs.core.nth.call(null,vec__93635,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__93628.call(null,cljs.core.rest.call(null,s__93629__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__93645(s__93646){
return (new cljs.core.LazySeq(null,(function (){
var s__93646__$1 = s__93646;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__93646__$1);
if(temp__4425__auto__){
var s__93646__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__93646__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__93646__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__93648 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__93647 = (0);
while(true){
if((i__93647 < size__5340__auto__)){
var vec__93651 = cljs.core._nth.call(null,c__5339__auto__,i__93647);
var handler_key = cljs.core.nth.call(null,vec__93651,(0),null);
var handler_function = cljs.core.nth.call(null,vec__93651,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__93648,event.subscribe(handler_function));

var G__93653 = (i__93647 + (1));
i__93647 = G__93653;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__93648),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__93645.call(null,cljs.core.chunk_rest.call(null,s__93646__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__93648),null);
}
} else {
var vec__93652 = cljs.core.first.call(null,s__93646__$2);
var handler_key = cljs.core.nth.call(null,vec__93652,(0),null);
var handler_function = cljs.core.nth.call(null,vec__93652,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__93645.call(null,cljs.core.rest.call(null,s__93646__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,p__93654){
var map__93663 = p__93654;
var map__93663__$1 = ((((!((map__93663 == null)))?((((map__93663.cljs$lang$protocol_mask$partition0$ & (64))) || (map__93663.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__93663):map__93663);
var grid_event_handlers = cljs.core.get.call(null,map__93663__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__93663__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,true,current_language,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__93665 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__93665__$1 = ((((!((map__93665 == null)))?((((map__93665.cljs$lang$protocol_mask$partition0$ & (64))) || (map__93665.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__93665):map__93665);
var map__93666 = cljs.core.get.call(null,map__93665__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__93666__$1 = ((((!((map__93666 == null)))?((((map__93666.cljs$lang$protocol_mask$partition0$ & (64))) || (map__93666.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__93666):map__93666);
var map__93667 = cljs.core.get.call(null,map__93666__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__93667__$1 = ((((!((map__93667 == null)))?((((map__93667.cljs$lang$protocol_mask$partition0$ & (64))) || (map__93667.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__93667):map__93667);
var num_displayed_records = cljs.core.get.call(null,map__93667__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__93667__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__93665,map__93665__$1,map__93666,map__93666__$1,map__93667,map__93667__$1,num_displayed_records,total_page_count,map__93663,map__93663__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__93665,map__93665__$1,map__93666,map__93666__$1,map__93667,map__93667__$1,num_displayed_records,total_page_count,map__93663,map__93663__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__93665,map__93665__$1,map__93666,map__93666__$1,map__93667,map__93667__$1,num_displayed_records,total_page_count,map__93663,map__93663__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__93665,map__93665__$1,map__93666,map__93666__$1,map__93667,map__93667__$1,num_displayed_records,total_page_count,map__93663,map__93663__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__93665,map__93665__$1,map__93666,map__93666__$1,map__93667,map__93667__$1,num_displayed_records,total_page_count,map__93663,map__93663__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__93665,map__93665__$1,map__93666,map__93666__$1,map__93667,map__93667__$1,num_displayed_records,total_page_count,map__93663,map__93663__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__8429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto__,event_chan){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__,event_chan){
return (function (state_93932){
var state_val_93933 = (state_93932[(1)]);
if((state_val_93933 === (7))){
var inst_93841 = (state_93932[(7)]);
var inst_93841__$1 = (state_93932[(2)]);
var inst_93843 = (inst_93841__$1 == null);
var inst_93844 = cljs.core.not.call(null,inst_93843);
var state_93932__$1 = (function (){var statearr_93934 = state_93932;
(statearr_93934[(7)] = inst_93841__$1);

return statearr_93934;
})();
if(inst_93844){
var statearr_93935_94002 = state_93932__$1;
(statearr_93935_94002[(1)] = (8));

} else {
var statearr_93936_94003 = state_93932__$1;
(statearr_93936_94003[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (20))){
var inst_93871 = (state_93932[(8)]);
var inst_93863 = (state_93932[(9)]);
var inst_93880 = inst_93871.call(null,inst_93863);
var state_93932__$1 = state_93932;
var statearr_93937_94004 = state_93932__$1;
(statearr_93937_94004[(2)] = inst_93880);

(statearr_93937_94004[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (27))){
var state_93932__$1 = state_93932;
var statearr_93938_94005 = state_93932__$1;
(statearr_93938_94005[(2)] = null);

(statearr_93938_94005[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (1))){
var state_93932__$1 = state_93932;
var statearr_93939_94006 = state_93932__$1;
(statearr_93939_94006[(2)] = null);

(statearr_93939_94006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (24))){
var state_93932__$1 = state_93932;
var statearr_93940_94007 = state_93932__$1;
(statearr_93940_94007[(2)] = null);

(statearr_93940_94007[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (4))){
var state_93932__$1 = state_93932;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_93932__$1,(7),event_chan);
} else {
if((state_val_93933 === (15))){
var inst_93841 = (state_93932[(7)]);
var state_93932__$1 = state_93932;
var statearr_93941_94008 = state_93932__$1;
(statearr_93941_94008[(2)] = inst_93841);

(statearr_93941_94008[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (21))){
var state_93932__$1 = state_93932;
var statearr_93942_94009 = state_93932__$1;
(statearr_93942_94009[(2)] = null);

(statearr_93942_94009[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (31))){
var inst_93867 = (state_93932[(10)]);
var inst_93905 = (state_93932[(2)]);
var inst_93906 = cljs.core._EQ_.call(null,inst_93867,new cljs.core.Keyword(null,"table","table",-564943036));
var state_93932__$1 = (function (){var statearr_93943 = state_93932;
(statearr_93943[(11)] = inst_93905);

return statearr_93943;
})();
if(inst_93906){
var statearr_93944_94010 = state_93932__$1;
(statearr_93944_94010[(1)] = (32));

} else {
var statearr_93945_94011 = state_93932__$1;
(statearr_93945_94011[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (32))){
var inst_93841 = (state_93932[(7)]);
var inst_93872 = (state_93932[(12)]);
var inst_93861 = (state_93932[(13)]);
var inst_93871 = (state_93932[(8)]);
var inst_93862 = (state_93932[(14)]);
var inst_93866 = (state_93932[(15)]);
var inst_93863 = (state_93932[(9)]);
var inst_93865 = (state_93932[(16)]);
var inst_93864 = (state_93932[(17)]);
var inst_93867 = (state_93932[(10)]);
var inst_93919 = cljs.core.async.chan.call(null,(1));
var inst_93920 = (function (){var new_columns = inst_93866;
var submission_clicked = inst_93863;
var submission_unclicked = inst_93864;
var get_submission_data = inst_93872;
var map__93839 = inst_93861;
var re_render = inst_93867;
var update_data_BANG_ = inst_93871;
var submission_to_rank = inst_93862;
var e = inst_93841;
var c__8429__auto____$1 = inst_93919;
var filter_by = inst_93865;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__93839,re_render,update_data_BANG_,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_93841,inst_93872,inst_93861,inst_93871,inst_93862,inst_93866,inst_93863,inst_93865,inst_93864,inst_93867,inst_93919,state_val_93933,c__8429__auto__,event_chan){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__93839,re_render,update_data_BANG_,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_93841,inst_93872,inst_93861,inst_93871,inst_93862,inst_93866,inst_93863,inst_93865,inst_93864,inst_93867,inst_93919,state_val_93933,c__8429__auto__,event_chan){
return (function (state_93917){
var state_val_93918 = (state_93917[(1)]);
if((state_val_93918 === (1))){
var inst_93908 = cljs.core.async.timeout.call(null,(20));
var state_93917__$1 = state_93917;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_93917__$1,(2),inst_93908);
} else {
if((state_val_93918 === (2))){
var inst_93910 = (state_93917[(2)]);
var inst_93911 = grid.resizeCanvas();
var inst_93912 = grid.invalidateAllRows();
var inst_93913 = hatti.views.table.resizeColumns.call(null,grid);
var inst_93914 = grid.render();
var inst_93915 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_93917__$1 = (function (){var statearr_93946 = state_93917;
(statearr_93946[(7)] = inst_93912);

(statearr_93946[(8)] = inst_93911);

(statearr_93946[(9)] = inst_93914);

(statearr_93946[(10)] = inst_93913);

(statearr_93946[(11)] = inst_93910);

return statearr_93946;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_93917__$1,inst_93915);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__93839,re_render,update_data_BANG_,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_93841,inst_93872,inst_93861,inst_93871,inst_93862,inst_93866,inst_93863,inst_93865,inst_93864,inst_93867,inst_93919,state_val_93933,c__8429__auto__,event_chan))
;
return ((function (switch__8364__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__93839,re_render,update_data_BANG_,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_93841,inst_93872,inst_93861,inst_93871,inst_93862,inst_93866,inst_93863,inst_93865,inst_93864,inst_93867,inst_93919,state_val_93933,c__8429__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8365__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8365__auto____0 = (function (){
var statearr_93950 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_93950[(0)] = hatti$views$table$handle_table_events_$_state_machine__8365__auto__);

(statearr_93950[(1)] = (1));

return statearr_93950;
});
var hatti$views$table$handle_table_events_$_state_machine__8365__auto____1 = (function (state_93917){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_93917);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e93951){if((e93951 instanceof Object)){
var ex__8368__auto__ = e93951;
var statearr_93952_94012 = state_93917;
(statearr_93952_94012[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_93917);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e93951;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__94013 = state_93917;
state_93917 = G__94013;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8365__auto__ = function(state_93917){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8365__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8365__auto____1.call(this,state_93917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8365__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8365__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__93839,re_render,update_data_BANG_,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_93841,inst_93872,inst_93861,inst_93871,inst_93862,inst_93866,inst_93863,inst_93865,inst_93864,inst_93867,inst_93919,state_val_93933,c__8429__auto__,event_chan))
})();
var state__8431__auto__ = (function (){var statearr_93953 = f__8430__auto__.call(null);
(statearr_93953[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto____$1);

return statearr_93953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__93839,re_render,update_data_BANG_,submission_to_rank,e,c__8429__auto____$1,filter_by,inst_93841,inst_93872,inst_93861,inst_93871,inst_93862,inst_93866,inst_93863,inst_93865,inst_93864,inst_93867,inst_93919,state_val_93933,c__8429__auto__,event_chan))
})();
var inst_93921 = cljs.core.async.impl.dispatch.run.call(null,inst_93920);
var state_93932__$1 = (function (){var statearr_93954 = state_93932;
(statearr_93954[(18)] = inst_93921);

return statearr_93954;
})();
var statearr_93955_94014 = state_93932__$1;
(statearr_93955_94014[(2)] = inst_93919);

(statearr_93955_94014[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (33))){
var state_93932__$1 = state_93932;
var statearr_93956_94015 = state_93932__$1;
(statearr_93956_94015[(2)] = null);

(statearr_93956_94015[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (13))){
var inst_93853 = (state_93932[(2)]);
var state_93932__$1 = state_93932;
var statearr_93957_94016 = state_93932__$1;
(statearr_93957_94016[(2)] = inst_93853);

(statearr_93957_94016[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (22))){
var inst_93864 = (state_93932[(17)]);
var inst_93883 = (state_93932[(2)]);
var state_93932__$1 = (function (){var statearr_93958 = state_93932;
(statearr_93958[(19)] = inst_93883);

return statearr_93958;
})();
if(cljs.core.truth_(inst_93864)){
var statearr_93959_94017 = state_93932__$1;
(statearr_93959_94017[(1)] = (23));

} else {
var statearr_93960_94018 = state_93932__$1;
(statearr_93960_94018[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (29))){
var inst_93865 = (state_93932[(16)]);
var inst_93897 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_93898 = [inst_93865];
var inst_93899 = cljs.core.PersistentHashMap.fromArrays(inst_93897,inst_93898);
var inst_93900 = cljs.core.clj__GT_js.call(null,inst_93899);
var inst_93901 = dataview.setFilterArgs(inst_93900);
var inst_93902 = dataview.refresh();
var state_93932__$1 = (function (){var statearr_93961 = state_93932;
(statearr_93961[(20)] = inst_93901);

return statearr_93961;
})();
var statearr_93962_94019 = state_93932__$1;
(statearr_93962_94019[(2)] = inst_93902);

(statearr_93962_94019[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (6))){
var inst_93928 = (state_93932[(2)]);
var state_93932__$1 = state_93932;
var statearr_93963_94020 = state_93932__$1;
(statearr_93963_94020[(2)] = inst_93928);

(statearr_93963_94020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (28))){
var inst_93865 = (state_93932[(16)]);
var inst_93895 = (state_93932[(2)]);
var state_93932__$1 = (function (){var statearr_93964 = state_93932;
(statearr_93964[(21)] = inst_93895);

return statearr_93964;
})();
if(cljs.core.truth_(inst_93865)){
var statearr_93965_94021 = state_93932__$1;
(statearr_93965_94021[(1)] = (29));

} else {
var statearr_93966_94022 = state_93932__$1;
(statearr_93966_94022[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (25))){
var inst_93866 = (state_93932[(15)]);
var inst_93888 = (state_93932[(2)]);
var state_93932__$1 = (function (){var statearr_93967 = state_93932;
(statearr_93967[(22)] = inst_93888);

return statearr_93967;
})();
if(cljs.core.truth_(inst_93866)){
var statearr_93968_94023 = state_93932__$1;
(statearr_93968_94023[(1)] = (26));

} else {
var statearr_93969_94024 = state_93932__$1;
(statearr_93969_94024[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (34))){
var inst_93924 = (state_93932[(2)]);
var state_93932__$1 = (function (){var statearr_93970 = state_93932;
(statearr_93970[(23)] = inst_93924);

return statearr_93970;
})();
var statearr_93971_94025 = state_93932__$1;
(statearr_93971_94025[(2)] = null);

(statearr_93971_94025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (17))){
var inst_93872 = (state_93932[(12)]);
var inst_93871 = (state_93932[(8)]);
var inst_93862 = (state_93932[(14)]);
var inst_93874 = inst_93872.call(null,hatti.constants._rank,inst_93862);
var inst_93875 = inst_93871.call(null,inst_93874);
var state_93932__$1 = state_93932;
var statearr_93972_94026 = state_93932__$1;
(statearr_93972_94026[(2)] = inst_93875);

(statearr_93972_94026[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (3))){
var inst_93930 = (state_93932[(2)]);
var state_93932__$1 = state_93932;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_93932__$1,inst_93930);
} else {
if((state_val_93933 === (12))){
var state_93932__$1 = state_93932;
var statearr_93973_94027 = state_93932__$1;
(statearr_93973_94027[(2)] = false);

(statearr_93973_94027[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (2))){
var state_93932__$1 = state_93932;
var statearr_93974_94028 = state_93932__$1;
(statearr_93974_94028[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (23))){
var inst_93871 = (state_93932[(8)]);
var inst_93885 = inst_93871.call(null,null);
var state_93932__$1 = state_93932;
var statearr_93976_94029 = state_93932__$1;
(statearr_93976_94029[(2)] = inst_93885);

(statearr_93976_94029[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (19))){
var inst_93863 = (state_93932[(9)]);
var inst_93878 = (state_93932[(2)]);
var state_93932__$1 = (function (){var statearr_93977 = state_93932;
(statearr_93977[(24)] = inst_93878);

return statearr_93977;
})();
if(cljs.core.truth_(inst_93863)){
var statearr_93978_94030 = state_93932__$1;
(statearr_93978_94030[(1)] = (20));

} else {
var statearr_93979_94031 = state_93932__$1;
(statearr_93979_94031[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (11))){
var state_93932__$1 = state_93932;
var statearr_93980_94032 = state_93932__$1;
(statearr_93980_94032[(2)] = true);

(statearr_93980_94032[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (9))){
var state_93932__$1 = state_93932;
var statearr_93981_94033 = state_93932__$1;
(statearr_93981_94033[(2)] = false);

(statearr_93981_94033[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (5))){
var state_93932__$1 = state_93932;
var statearr_93982_94034 = state_93932__$1;
(statearr_93982_94034[(2)] = null);

(statearr_93982_94034[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (14))){
var inst_93841 = (state_93932[(7)]);
var inst_93858 = cljs.core.apply.call(null,cljs.core.hash_map,inst_93841);
var state_93932__$1 = state_93932;
var statearr_93983_94035 = state_93932__$1;
(statearr_93983_94035[(2)] = inst_93858);

(statearr_93983_94035[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (26))){
var inst_93866 = (state_93932[(15)]);
var inst_93890 = grid.setColumns(inst_93866);
var inst_93891 = hatti.views.table.resizeColumns.call(null,grid);
var inst_93892 = grid.render();
var state_93932__$1 = (function (){var statearr_93984 = state_93932;
(statearr_93984[(25)] = inst_93891);

(statearr_93984[(26)] = inst_93890);

return statearr_93984;
})();
var statearr_93985_94036 = state_93932__$1;
(statearr_93985_94036[(2)] = inst_93892);

(statearr_93985_94036[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (16))){
var inst_93841 = (state_93932[(7)]);
var inst_93861 = (state_93932[(13)]);
var inst_93871 = (state_93932[(8)]);
var inst_93862 = (state_93932[(14)]);
var inst_93866 = (state_93932[(15)]);
var inst_93863 = (state_93932[(9)]);
var inst_93865 = (state_93932[(16)]);
var inst_93864 = (state_93932[(17)]);
var inst_93867 = (state_93932[(10)]);
var inst_93861__$1 = (state_93932[(2)]);
var inst_93862__$1 = cljs.core.get.call(null,inst_93861__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_93863__$1 = cljs.core.get.call(null,inst_93861__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_93864__$1 = cljs.core.get.call(null,inst_93861__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_93865__$1 = cljs.core.get.call(null,inst_93861__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_93866__$1 = cljs.core.get.call(null,inst_93861__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_93867__$1 = cljs.core.get.call(null,inst_93861__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_93868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_93869 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_93870 = (new cljs.core.PersistentVector(null,3,(5),inst_93868,inst_93869,null));
var inst_93871__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_93870);
var inst_93872 = (function (){var e = inst_93841;
var map__93839 = inst_93861__$1;
var submission_to_rank = inst_93862__$1;
var submission_clicked = inst_93863__$1;
var submission_unclicked = inst_93864__$1;
var filter_by = inst_93865__$1;
var new_columns = inst_93866__$1;
var re_render = inst_93867__$1;
var update_data_BANG_ = inst_93871__$1;
return ((function (e,map__93839,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_93841,inst_93861,inst_93871,inst_93862,inst_93866,inst_93863,inst_93865,inst_93864,inst_93867,inst_93861__$1,inst_93862__$1,inst_93863__$1,inst_93864__$1,inst_93865__$1,inst_93866__$1,inst_93867__$1,inst_93868,inst_93869,inst_93870,inst_93871__$1,state_val_93933,c__8429__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (e,map__93839,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_93841,inst_93861,inst_93871,inst_93862,inst_93866,inst_93863,inst_93865,inst_93864,inst_93867,inst_93861__$1,inst_93862__$1,inst_93863__$1,inst_93864__$1,inst_93865__$1,inst_93866__$1,inst_93867__$1,inst_93868,inst_93869,inst_93870,inst_93871__$1,state_val_93933,c__8429__auto__,event_chan){
return (function (p1__93671_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__93671_SHARP_,field));
});})(e,map__93839,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_93841,inst_93861,inst_93871,inst_93862,inst_93866,inst_93863,inst_93865,inst_93864,inst_93867,inst_93861__$1,inst_93862__$1,inst_93863__$1,inst_93864__$1,inst_93865__$1,inst_93866__$1,inst_93867__$1,inst_93868,inst_93869,inst_93870,inst_93871__$1,state_val_93933,c__8429__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(e,map__93839,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_93841,inst_93861,inst_93871,inst_93862,inst_93866,inst_93863,inst_93865,inst_93864,inst_93867,inst_93861__$1,inst_93862__$1,inst_93863__$1,inst_93864__$1,inst_93865__$1,inst_93866__$1,inst_93867__$1,inst_93868,inst_93869,inst_93870,inst_93871__$1,state_val_93933,c__8429__auto__,event_chan))
})();
var state_93932__$1 = (function (){var statearr_93986 = state_93932;
(statearr_93986[(12)] = inst_93872);

(statearr_93986[(13)] = inst_93861__$1);

(statearr_93986[(8)] = inst_93871__$1);

(statearr_93986[(14)] = inst_93862__$1);

(statearr_93986[(15)] = inst_93866__$1);

(statearr_93986[(9)] = inst_93863__$1);

(statearr_93986[(16)] = inst_93865__$1);

(statearr_93986[(17)] = inst_93864__$1);

(statearr_93986[(10)] = inst_93867__$1);

return statearr_93986;
})();
if(cljs.core.truth_(inst_93862__$1)){
var statearr_93987_94037 = state_93932__$1;
(statearr_93987_94037[(1)] = (17));

} else {
var statearr_93988_94038 = state_93932__$1;
(statearr_93988_94038[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (30))){
var state_93932__$1 = state_93932;
var statearr_93989_94039 = state_93932__$1;
(statearr_93989_94039[(2)] = null);

(statearr_93989_94039[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (10))){
var inst_93856 = (state_93932[(2)]);
var state_93932__$1 = state_93932;
if(cljs.core.truth_(inst_93856)){
var statearr_93990_94040 = state_93932__$1;
(statearr_93990_94040[(1)] = (14));

} else {
var statearr_93991_94041 = state_93932__$1;
(statearr_93991_94041[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (18))){
var state_93932__$1 = state_93932;
var statearr_93992_94042 = state_93932__$1;
(statearr_93992_94042[(2)] = null);

(statearr_93992_94042[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93933 === (8))){
var inst_93841 = (state_93932[(7)]);
var inst_93846 = inst_93841.cljs$lang$protocol_mask$partition0$;
var inst_93847 = (inst_93846 & (64));
var inst_93848 = inst_93841.cljs$core$ISeq$;
var inst_93849 = (inst_93847) || (inst_93848);
var state_93932__$1 = state_93932;
if(cljs.core.truth_(inst_93849)){
var statearr_93993_94043 = state_93932__$1;
(statearr_93993_94043[(1)] = (11));

} else {
var statearr_93994_94044 = state_93932__$1;
(statearr_93994_94044[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto__,event_chan))
;
return ((function (switch__8364__auto__,c__8429__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8365__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8365__auto____0 = (function (){
var statearr_93998 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_93998[(0)] = hatti$views$table$handle_table_events_$_state_machine__8365__auto__);

(statearr_93998[(1)] = (1));

return statearr_93998;
});
var hatti$views$table$handle_table_events_$_state_machine__8365__auto____1 = (function (state_93932){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_93932);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e93999){if((e93999 instanceof Object)){
var ex__8368__auto__ = e93999;
var statearr_94000_94045 = state_93932;
(statearr_94000_94045[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_93932);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e93999;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__94046 = state_93932;
state_93932 = G__94046;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8365__auto__ = function(state_93932){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8365__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8365__auto____1.call(this,state_93932);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8365__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8365__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__,event_chan))
})();
var state__8431__auto__ = (function (){var statearr_94001 = f__8430__auto__.call(null);
(statearr_94001[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_94001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto__,event_chan))
);

return c__8429__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),k);

return colset_BANG_.call(null,k);
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__94055(s__94056){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__94056__$1 = s__94056;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__94056__$1);
if(temp__4425__auto__){
var s__94056__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__94056__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__94056__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__94058 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__94057 = (0);
while(true){
if((i__94057 < size__5340__auto__)){
var vec__94061 = cljs.core._nth.call(null,c__5339__auto__,i__94057);
var k = cljs.core.nth.call(null,vec__94061,(0),null);
var v = cljs.core.nth.call(null,vec__94061,(1),null);
cljs.core.chunk_append.call(null,b__94058,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__94057,vec__94061,k,v,c__5339__auto__,size__5340__auto__,b__94058,s__94056__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__94057,vec__94061,k,v,c__5339__auto__,size__5340__auto__,b__94058,s__94056__$2,temp__4425__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__94063 = (i__94057 + (1));
i__94057 = G__94063;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__94058),hatti$views$table$render_options_$_iter__94055.call(null,cljs.core.chunk_rest.call(null,s__94056__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__94058),null);
}
} else {
var vec__94062 = cljs.core.first.call(null,s__94056__$2);
var k = cljs.core.nth.call(null,vec__94062,(0),null);
var v = cljs.core.nth.call(null,vec__94062,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__94062,k,v,s__94056__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__94062,k,v,s__94056__$2,temp__4425__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__94055.call(null,cljs.core.rest.call(null,s__94056__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table94065 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table94065 = (function (_,owner,meta94066){
this._ = _;
this.owner = owner;
this.meta94066 = meta94066;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table94065.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_94067,meta94066__$1){
var self__ = this;
var _94067__$1 = this;
return (new hatti.views.table.t_hatti$views$table94065(self__._,self__.owner,meta94066__$1));
});

hatti.views.table.t_hatti$views$table94065.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_94067){
var self__ = this;
var _94067__$1 = this;
return self__.meta94066;
});

hatti.views.table.t_hatti$views$table94065.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table94065.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table94065.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table94065.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__94068){
var self__ = this;
var map__94069 = p__94068;
var map__94069__$1 = ((((!((map__94069 == null)))?((((map__94069.cljs$lang$protocol_mask$partition0$ & (64))) || (map__94069.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__94069):map__94069);
var name_or_label = cljs.core.get.call(null,map__94069__$1,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208));
var language = cljs.core.get.call(null,map__94069__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__94071 = om.core.get_shared.call(null,self__.owner);
var map__94071__$1 = ((((!((map__94071 == null)))?((((map__94071.cljs$lang$protocol_mask$partition0$ & (64))) || (map__94071.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__94071):map__94071);
var flat_form = cljs.core.get.call(null,map__94071__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__94071,map__94071__$1,flat_form,new_language,___$2,map__94069,map__94069__$1,name_or_label,language){
return (function (p1__94064_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__94064_SHARP_),new_language)], null));
});})(options,map__94071,map__94071__$1,flat_form,new_language,___$2,map__94069,map__94069__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,name_or_label);
} else {
}

return React.DOM.div({"className": "label-changer"},React.DOM.span({"className": "label-changer-label"},"Show:"),React.DOM.div({"id": "header-display-dropdown", "className": "drop-hover"},(function (){var attrs94075 = options.call(null,name_or_label);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs94075))?sablono.interpreter.attributes.call(null,attrs94075):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs94075))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i({"className": "fa fa-angle-down"})], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs94075),React.DOM.i({"className": "fa fa-angle-down"})], null))));
})(),React.DOM.ul({"className": "submenu no-dot"},sablono.interpreter.interpret.call(null,hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_)))));
});

hatti.views.table.t_hatti$views$table94065.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta94066","meta94066",1435706285,null)], null);
});

hatti.views.table.t_hatti$views$table94065.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table94065.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table94065";

hatti.views.table.t_hatti$views$table94065.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table94065");
});

hatti.views.table.__GT_t_hatti$views$table94065 = (function hatti$views$table$__GT_t_hatti$views$table94065(___$1,owner__$1,meta94066){
return (new hatti.views.table.t_hatti$views$table94065(___$1,owner__$1,meta94066));
});

}

return (new hatti.views.table.t_hatti$views$table94065(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__8429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8429__auto__,query){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__,query){
return (function (state_94122){
var state_val_94123 = (state_94122[(1)]);
if((state_val_94123 === (1))){
var inst_94108 = cljs.core.async.timeout.call(null,(150));
var state_94122__$1 = state_94122;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_94122__$1,(2),inst_94108);
} else {
if((state_val_94123 === (2))){
var inst_94110 = (state_94122[(2)]);
var inst_94111 = input.value;
var inst_94112 = cljs.core._EQ_.call(null,query,inst_94111);
var state_94122__$1 = (function (){var statearr_94124 = state_94122;
(statearr_94124[(7)] = inst_94110);

return statearr_94124;
})();
if(inst_94112){
var statearr_94125_94136 = state_94122__$1;
(statearr_94125_94136[(1)] = (3));

} else {
var statearr_94126_94137 = state_94122__$1;
(statearr_94126_94137[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_94123 === (3))){
var inst_94114 = [query_event_key];
var inst_94115 = [query];
var inst_94116 = cljs.core.PersistentHashMap.fromArrays(inst_94114,inst_94115);
var inst_94117 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_94116);
var state_94122__$1 = state_94122;
var statearr_94127_94138 = state_94122__$1;
(statearr_94127_94138[(2)] = inst_94117);

(statearr_94127_94138[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_94123 === (4))){
var state_94122__$1 = state_94122;
var statearr_94128_94139 = state_94122__$1;
(statearr_94128_94139[(2)] = null);

(statearr_94128_94139[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_94123 === (5))){
var inst_94120 = (state_94122[(2)]);
var state_94122__$1 = state_94122;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_94122__$1,inst_94120);
} else {
return null;
}
}
}
}
}
});})(c__8429__auto__,query))
;
return ((function (switch__8364__auto__,c__8429__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__8365__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__8365__auto____0 = (function (){
var statearr_94132 = [null,null,null,null,null,null,null,null];
(statearr_94132[(0)] = hatti$views$table$delayed_search_$_state_machine__8365__auto__);

(statearr_94132[(1)] = (1));

return statearr_94132;
});
var hatti$views$table$delayed_search_$_state_machine__8365__auto____1 = (function (state_94122){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__.call(null,state_94122);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e94133){if((e94133 instanceof Object)){
var ex__8368__auto__ = e94133;
var statearr_94134_94140 = state_94122;
(statearr_94134_94140[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_94122);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e94133;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__94141 = state_94122;
state_94122 = G__94141;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__8365__auto__ = function(state_94122){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__8365__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__8365__auto____1.call(this,state_94122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__8365__auto____0;
hatti$views$table$delayed_search_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__8365__auto____1;
return hatti$views$table$delayed_search_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__,query))
})();
var state__8431__auto__ = (function (){var statearr_94135 = f__8430__auto__.call(null);
(statearr_94135[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_94135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8431__auto__);
});})(c__8429__auto__,query))
);

return c__8429__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table94143 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table94143 = (function (_,owner,meta94144){
this._ = _;
this.owner = owner;
this.meta94144 = meta94144;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table94143.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_94145,meta94144__$1){
var self__ = this;
var _94145__$1 = this;
return (new hatti.views.table.t_hatti$views$table94143(self__._,self__.owner,meta94144__$1));
});

hatti.views.table.t_hatti$views$table94143.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_94145){
var self__ = this;
var _94145__$1 = this;
return self__.meta94144;
});

hatti.views.table.t_hatti$views$table94143.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table94143.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
return React.DOM.div({"className": "table-search"},React.DOM.i({"className": "fa fa-search"}),sablono.interpreter.input.call(null,{"type": "text", "placeholder": "Search", "onChange": ((function (this__6567__auto____$1){
return (function (p1__94142_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__94142_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__6567__auto____$1))
}));
});

hatti.views.table.t_hatti$views$table94143.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta94144","meta94144",959024293,null)], null);
});

hatti.views.table.t_hatti$views$table94143.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table94143.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table94143";

hatti.views.table.t_hatti$views$table94143.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table94143");
});

hatti.views.table.__GT_t_hatti$views$table94143 = (function hatti$views$table$__GT_t_hatti$views$table94143(___$1,owner__$1,meta94144){
return (new hatti.views.table.t_hatti$views$table94143(___$1,owner__$1,meta94144));
});

}

return (new hatti.views.table.t_hatti$views$table94143(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table94148 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table94148 = (function (app_state,owner,meta94149){
this.app_state = app_state;
this.owner = owner;
this.meta94149 = meta94149;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table94148.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_94150,meta94149__$1){
var self__ = this;
var _94150__$1 = this;
return (new hatti.views.table.t_hatti$views$table94148(self__.app_state,self__.owner,meta94149__$1));
});

hatti.views.table.t_hatti$views$table94148.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_94150){
var self__ = this;
var _94150__$1 = this;
return self__.meta94149;
});

hatti.views.table.t_hatti$views$table94148.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table94148.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
return React.DOM.div({"className": "topbar"},React.DOM.div({"id": hatti.views.table.pager_id}),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.app_state)),React.DOM.div({"style": {"clear": "both"}}));
});

hatti.views.table.t_hatti$views$table94148.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta94149","meta94149",-93305094,null)], null);
});

hatti.views.table.t_hatti$views$table94148.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table94148.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table94148";

hatti.views.table.t_hatti$views$table94148.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table94148");
});

hatti.views.table.__GT_t_hatti$views$table94148 = (function hatti$views$table$__GT_t_hatti$views$table94148(app_state__$1,owner__$1,meta94149){
return (new hatti.views.table.t_hatti$views$table94148(app_state__$1,owner__$1,meta94149));
});

}

return (new hatti.views.table.t_hatti$views$table94148(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq.call(null,data)){
var map__94156 = om.core.get_shared.call(null,owner);
var map__94156__$1 = ((((!((map__94156 == null)))?((((map__94156.cljs$lang$protocol_mask$partition0$ & (64))) || (map__94156.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__94156):map__94156);
var flat_form = cljs.core.get.call(null,map__94156__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__94156__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__94157 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,is_filtered_dataview_QMARK_,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__94157,(0),null);
var dataview = cljs.core.nth.call(null,vec__94157,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner,p__94160){
var map__94161 = p__94160;
var map__94161__$1 = ((((!((map__94161 == null)))?((((map__94161.cljs$lang$protocol_mask$partition0$ & (64))) || (map__94161.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__94161):map__94161);
var opts = map__94161__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__94161__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

if(typeof hatti.views.table.t_hatti$views$table94163 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table94163 = (function (app_state,owner,p__94160,map__94161,opts,slick_grid_event_handlers,meta94164){
this.app_state = app_state;
this.owner = owner;
this.p__94160 = p__94160;
this.map__94161 = map__94161;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta94164 = meta94164;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table94163.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__94161,map__94161__$1,opts,slick_grid_event_handlers){
return (function (_94165,meta94164__$1){
var self__ = this;
var _94165__$1 = this;
return (new hatti.views.table.t_hatti$views$table94163(self__.app_state,self__.owner,self__.p__94160,self__.map__94161,self__.opts,self__.slick_grid_event_handlers,meta94164__$1));
});})(map__94161,map__94161__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table94163.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__94161,map__94161__$1,opts,slick_grid_event_handlers){
return (function (_94165){
var self__ = this;
var _94165__$1 = this;
return self__.meta94164;
});})(map__94161,map__94161__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table94163.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table94163.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__94161,map__94161__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null)));
var map__94166 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__94166__$1 = ((((!((map__94166 == null)))?((((map__94166.cljs$lang$protocol_mask$partition0$ & (64))) || (map__94166.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__94166):map__94166);
var dataset_info = map__94166__$1;
var num_of_submissions = cljs.core.get.call(null,map__94166__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var with_info = ((function (no_data_QMARK_,map__94166,map__94166__$1,dataset_info,num_of_submissions,___$2,map__94161,map__94161__$1,opts,slick_grid_event_handlers){
return (function (p1__94159_SHARP_){
return cljs.core.merge.call(null,p1__94159_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),dataset_info], null));
});})(no_data_QMARK_,map__94166,map__94166__$1,dataset_info,num_of_submissions,___$2,map__94161,map__94161__$1,opts,slick_grid_event_handlers))
;
var attrs94168 = om.core.build.call(null,hatti.views.submission_view,with_info.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855)], null))),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null));
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs94168))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs94168)):{"className": "table-view"}),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs94168))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs94168),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null))));
});})(map__94161,map__94161__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table94163.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table94163.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__94161,map__94161__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__94177 = temp__4425__auto__;
var grid = cljs.core.nth.call(null,vec__94177,(0),null);
var dataview = cljs.core.nth.call(null,vec__94177,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__94161,map__94161__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table94163.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table94163.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__94161,map__94161__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__94178 = om.core.get_state.call(null,self__.owner);
var map__94178__$1 = ((((!((map__94178 == null)))?((((map__94178.cljs$lang$protocol_mask$partition0$ & (64))) || (map__94178.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__94178):map__94178);
var grid = cljs.core.get.call(null,map__94178__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__94178__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__94180 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__94180,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__94180,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__94161,map__94161__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table94163.getBasis = ((function (map__94161,map__94161__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__94160","p__94160",-1220551889,null),new cljs.core.Symbol(null,"map__94161","map__94161",-425401885,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"meta94164","meta94164",549621317,null)], null);
});})(map__94161,map__94161__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table94163.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table94163.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table94163";

hatti.views.table.t_hatti$views$table94163.cljs$lang$ctorPrWriter = ((function (map__94161,map__94161__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table94163");
});})(map__94161,map__94161__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table94163 = ((function (map__94161,map__94161__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table94163(app_state__$1,owner__$1,p__94160__$1,map__94161__$2,opts__$1,slick_grid_event_handlers__$1,meta94164){
return (new hatti.views.table.t_hatti$views$table94163(app_state__$1,owner__$1,p__94160__$1,map__94161__$2,opts__$1,slick_grid_event_handlers__$1,meta94164));
});})(map__94161,map__94161__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table94163(app_state,owner,p__94160,map__94161__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
