// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"id",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___28912 = arguments.length;
var i__5628__auto___28913 = (0);
while(true){
if((i__5628__auto___28913 < len__5627__auto___28912)){
args__5634__auto__.push((arguments[i__5628__auto___28913]));

var G__28914 = (i__5628__auto___28913 + (1));
i__5628__auto___28913 = G__28914;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__28909){
var map__28910 = p__28909;
var map__28910__$1 = ((((!((map__28910 == null)))?((((map__28910.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28910.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28910):map__28910);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28910__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq28907){
var G__28908 = cljs.core.first(seq28907);
var seq28907__$1 = cljs.core.next(seq28907);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__28908,seq28907__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__28915_SHARP_){
if(typeof p1__28915_SHARP_ === 'string'){
return clojure.string.lower_case(p1__28915_SHARP_);
} else {
return p1__28915_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__28919){
var vec__28920 = p__28919;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28920,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28920,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__28916_SHARP_){
return cljs.core.re_find(hatti.utils.safe_regex(query),[cljs.core.str(p1__28916_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(field,clj_value,language,true);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args28921 = [];
var len__5627__auto___28945 = arguments.length;
var i__5628__auto___28946 = (0);
while(true){
if((i__5628__auto___28946 < len__5627__auto___28945)){
args28921.push((arguments[i__5628__auto___28946]));

var G__28947 = (i__5628__auto___28946 + (1));
i__5628__auto___28946 = G__28947;
continue;
} else {
}
break;
}

var G__28927 = args28921.length;
switch (G__28927) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args28921.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2(form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns(form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__28928){
var map__28929 = p__28928;
var map__28929__$1 = ((((!((map__28929 == null)))?((((map__28929.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28929.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28929):map__28929);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28929__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.clj__GT_js((function (){var iter__5341__auto__ = ((function (map__28929,map__28929__$1,is_filtered_dataview_QMARK_){
return (function hatti$views$table$iter__28931(s__28932){
return (new cljs.core.LazySeq(null,((function (map__28929,map__28929__$1,is_filtered_dataview_QMARK_){
return (function (){
var s__28932__$1 = s__28932;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__28932__$1);
if(temp__4425__auto__){
var s__28932__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28932__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__28932__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__28934 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__28933 = (0);
while(true){
if((i__28933 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__28933);
cljs.core.chunk_append(b__28934,(function (){var map__28941 = field;
var map__28941__$1 = ((((!((map__28941 == null)))?((((map__28941.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28941.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28941):map__28941);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28941__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28941__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28941__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})());

var G__28949 = (i__28933 + (1));
i__28933 = G__28949;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28934),hatti$views$table$iter__28931(cljs.core.chunk_rest(s__28932__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28934),null);
}
} else {
var field = cljs.core.first(s__28932__$2);
return cljs.core.cons((function (){var map__28943 = field;
var map__28943__$1 = ((((!((map__28943 == null)))?((((map__28943.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28943.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28943):map__28943);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28943__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28943__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28943__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})(),hatti$views$table$iter__28931(cljs.core.rest(s__28932__$2)));
}
} else {
return null;
}
break;
}
});})(map__28929,map__28929__$1,is_filtered_dataview_QMARK_))
,null,null));
});})(map__28929,map__28929__$1,is_filtered_dataview_QMARK_))
;
return iter__5341__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq28922){
var G__28923 = cljs.core.first(seq28922);
var seq28922__$1 = cljs.core.next(seq28922);
var G__28924 = cljs.core.first(seq28922__$1);
var seq28922__$2 = cljs.core.next(seq28922__$1);
var G__28925 = cljs.core.first(seq28922__$2);
var seq28922__$3 = cljs.core.next(seq28922__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__28923,G__28924,G__28925,seq28922__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__28951 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__28951);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": true};
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__28962(s__28963){
return (new cljs.core.LazySeq(null,(function (){
var s__28963__$1 = s__28963;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__28963__$1);
if(temp__4425__auto__){
var s__28963__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28963__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__28963__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__28965 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__28964 = (0);
while(true){
if((i__28964 < size__5340__auto__)){
var vec__28970 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__28964);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28970,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28970,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__28965,event.subscribe(handler_function));

var G__28972 = (i__28964 + (1));
i__28964 = G__28972;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28965),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__28962(cljs.core.chunk_rest(s__28963__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28965),null);
}
} else {
var vec__28971 = cljs.core.first(s__28963__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28971,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28971,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__28962(cljs.core.rest(s__28963__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__28983(s__28984){
return (new cljs.core.LazySeq(null,(function (){
var s__28984__$1 = s__28984;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__28984__$1);
if(temp__4425__auto__){
var s__28984__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28984__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__28984__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__28986 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__28985 = (0);
while(true){
if((i__28985 < size__5340__auto__)){
var vec__28991 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__28985);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28991,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28991,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__28986,event.subscribe(handler_function));

var G__28993 = (i__28985 + (1));
i__28985 = G__28993;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28986),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__28983(cljs.core.chunk_rest(s__28984__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28986),null);
}
} else {
var vec__28992 = cljs.core.first(s__28984__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28992,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28992,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__28983(cljs.core.rest(s__28984__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,p__28994){
var map__29003 = p__28994;
var map__29003__$1 = ((((!((map__29003 == null)))?((((map__29003.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29003.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29003):map__29003);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29003__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29003__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,true,current_language,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__29005 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__29005__$1 = ((((!((map__29005 == null)))?((((map__29005.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29005.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29005):map__29005);
var map__29006 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29005__$1,cljs.core.cst$kw$table_DASH_page);
var map__29006__$1 = ((((!((map__29006 == null)))?((((map__29006.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29006.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29006):map__29006);
var map__29007 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29006__$1,cljs.core.cst$kw$paging);
var map__29007__$1 = ((((!((map__29007 == null)))?((((map__29007.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29007.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29007):map__29007);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29007__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29007__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__29005,map__29005__$1,map__29006,map__29006__$1,map__29007,map__29007__$1,num_displayed_records,total_page_count,map__29003,map__29003__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__29005,map__29005__$1,map__29006,map__29006__$1,map__29007,map__29007__$1,num_displayed_records,total_page_count,map__29003,map__29003__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__29005,map__29005__$1,map__29006,map__29006__$1,map__29007,map__29007__$1,num_displayed_records,total_page_count,map__29003,map__29003__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__29005,map__29005__$1,map__29006,map__29006__$1,map__29007,map__29007__$1,num_displayed_records,total_page_count,map__29003,map__29003__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__29005,map__29005__$1,map__29006,map__29006__$1,map__29007,map__29007__$1,num_displayed_records,total_page_count,map__29003,map__29003__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__29005,map__29005__$1,map__29006,map__29006__$1,map__29007,map__29007__$1,num_displayed_records,total_page_count,map__29003,map__29003__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__7694__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7694__auto__,event_chan){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__,event_chan){
return (function (state_29272){
var state_val_29273 = (state_29272[(1)]);
if((state_val_29273 === (7))){
var inst_29181 = (state_29272[(7)]);
var inst_29181__$1 = (state_29272[(2)]);
var inst_29183 = (inst_29181__$1 == null);
var inst_29184 = cljs.core.not(inst_29183);
var state_29272__$1 = (function (){var statearr_29274 = state_29272;
(statearr_29274[(7)] = inst_29181__$1);

return statearr_29274;
})();
if(inst_29184){
var statearr_29275_29342 = state_29272__$1;
(statearr_29275_29342[(1)] = (8));

} else {
var statearr_29276_29343 = state_29272__$1;
(statearr_29276_29343[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (20))){
var inst_29203 = (state_29272[(8)]);
var inst_29211 = (state_29272[(9)]);
var inst_29220 = (inst_29211.cljs$core$IFn$_invoke$arity$1 ? inst_29211.cljs$core$IFn$_invoke$arity$1(inst_29203) : inst_29211.call(null,inst_29203));
var state_29272__$1 = state_29272;
var statearr_29277_29344 = state_29272__$1;
(statearr_29277_29344[(2)] = inst_29220);

(statearr_29277_29344[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (27))){
var state_29272__$1 = state_29272;
var statearr_29278_29345 = state_29272__$1;
(statearr_29278_29345[(2)] = null);

(statearr_29278_29345[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (1))){
var state_29272__$1 = state_29272;
var statearr_29279_29346 = state_29272__$1;
(statearr_29279_29346[(2)] = null);

(statearr_29279_29346[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (24))){
var state_29272__$1 = state_29272;
var statearr_29280_29347 = state_29272__$1;
(statearr_29280_29347[(2)] = null);

(statearr_29280_29347[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (4))){
var state_29272__$1 = state_29272;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29272__$1,(7),event_chan);
} else {
if((state_val_29273 === (15))){
var inst_29181 = (state_29272[(7)]);
var state_29272__$1 = state_29272;
var statearr_29281_29348 = state_29272__$1;
(statearr_29281_29348[(2)] = inst_29181);

(statearr_29281_29348[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (21))){
var state_29272__$1 = state_29272;
var statearr_29282_29349 = state_29272__$1;
(statearr_29282_29349[(2)] = null);

(statearr_29282_29349[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (31))){
var inst_29207 = (state_29272[(10)]);
var inst_29245 = (state_29272[(2)]);
var inst_29246 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29207,cljs.core.cst$kw$table);
var state_29272__$1 = (function (){var statearr_29283 = state_29272;
(statearr_29283[(11)] = inst_29245);

return statearr_29283;
})();
if(inst_29246){
var statearr_29284_29350 = state_29272__$1;
(statearr_29284_29350[(1)] = (32));

} else {
var statearr_29285_29351 = state_29272__$1;
(statearr_29285_29351[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (32))){
var inst_29181 = (state_29272[(7)]);
var inst_29202 = (state_29272[(12)]);
var inst_29201 = (state_29272[(13)]);
var inst_29207 = (state_29272[(10)]);
var inst_29206 = (state_29272[(14)]);
var inst_29203 = (state_29272[(8)]);
var inst_29205 = (state_29272[(15)]);
var inst_29204 = (state_29272[(16)]);
var inst_29212 = (state_29272[(17)]);
var inst_29211 = (state_29272[(9)]);
var inst_29259 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_29260 = (function (){var new_columns = inst_29206;
var map__29179 = inst_29201;
var submission_clicked = inst_29203;
var submission_unclicked = inst_29204;
var get_submission_data = inst_29212;
var re_render = inst_29207;
var update_data_BANG_ = inst_29211;
var c__7694__auto____$1 = inst_29259;
var submission_to_rank = inst_29202;
var e = inst_29181;
var filter_by = inst_29205;
return ((function (new_columns,map__29179,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_29181,inst_29202,inst_29201,inst_29207,inst_29206,inst_29203,inst_29205,inst_29204,inst_29212,inst_29211,inst_29259,state_val_29273,c__7694__auto__,event_chan){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (new_columns,map__29179,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_29181,inst_29202,inst_29201,inst_29207,inst_29206,inst_29203,inst_29205,inst_29204,inst_29212,inst_29211,inst_29259,state_val_29273,c__7694__auto__,event_chan){
return (function (state_29257){
var state_val_29258 = (state_29257[(1)]);
if((state_val_29258 === (1))){
var inst_29248 = cljs.core.async.timeout((20));
var state_29257__$1 = state_29257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29257__$1,(2),inst_29248);
} else {
if((state_val_29258 === (2))){
var inst_29250 = (state_29257[(2)]);
var inst_29251 = grid.resizeCanvas();
var inst_29252 = grid.invalidateAllRows();
var inst_29253 = hatti.views.table.resizeColumns(grid);
var inst_29254 = grid.render();
var inst_29255 = hatti.views.table.init_sg_pager(grid,dataview);
var state_29257__$1 = (function (){var statearr_29286 = state_29257;
(statearr_29286[(7)] = inst_29250);

(statearr_29286[(8)] = inst_29254);

(statearr_29286[(9)] = inst_29251);

(statearr_29286[(10)] = inst_29252);

(statearr_29286[(11)] = inst_29253);

return statearr_29286;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29257__$1,inst_29255);
} else {
return null;
}
}
});})(new_columns,map__29179,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_29181,inst_29202,inst_29201,inst_29207,inst_29206,inst_29203,inst_29205,inst_29204,inst_29212,inst_29211,inst_29259,state_val_29273,c__7694__auto__,event_chan))
;
return ((function (switch__7673__auto__,new_columns,map__29179,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_29181,inst_29202,inst_29201,inst_29207,inst_29206,inst_29203,inst_29205,inst_29204,inst_29212,inst_29211,inst_29259,state_val_29273,c__7694__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____0 = (function (){
var statearr_29290 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29290[(0)] = hatti$views$table$handle_table_events_$_state_machine__7674__auto__);

(statearr_29290[(1)] = (1));

return statearr_29290;
});
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____1 = (function (state_29257){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__(state_29257);
if(cljs.core.keyword_identical_QMARK_(result__7676__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e29291){if((e29291 instanceof Object)){
var ex__7677__auto__ = e29291;
var statearr_29292_29352 = state_29257;
(statearr_29292_29352[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29257);

return cljs.core.cst$kw$recur;
} else {
throw e29291;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7675__auto__,cljs.core.cst$kw$recur)){
var G__29353 = state_29257;
state_29257 = G__29353;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = function(state_29257){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____1.call(this,state_29257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____0;
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,new_columns,map__29179,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_29181,inst_29202,inst_29201,inst_29207,inst_29206,inst_29203,inst_29205,inst_29204,inst_29212,inst_29211,inst_29259,state_val_29273,c__7694__auto__,event_chan))
})();
var state__7696__auto__ = (function (){var statearr_29293 = (f__7695__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7695__auto__.cljs$core$IFn$_invoke$arity$0() : f__7695__auto__.call(null));
(statearr_29293[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto____$1);

return statearr_29293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7696__auto__);
});
;})(new_columns,map__29179,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_29181,inst_29202,inst_29201,inst_29207,inst_29206,inst_29203,inst_29205,inst_29204,inst_29212,inst_29211,inst_29259,state_val_29273,c__7694__auto__,event_chan))
})();
var inst_29261 = cljs.core.async.impl.dispatch.run(inst_29260);
var state_29272__$1 = (function (){var statearr_29294 = state_29272;
(statearr_29294[(18)] = inst_29261);

return statearr_29294;
})();
var statearr_29295_29354 = state_29272__$1;
(statearr_29295_29354[(2)] = inst_29259);

(statearr_29295_29354[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (33))){
var state_29272__$1 = state_29272;
var statearr_29296_29355 = state_29272__$1;
(statearr_29296_29355[(2)] = null);

(statearr_29296_29355[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (13))){
var inst_29193 = (state_29272[(2)]);
var state_29272__$1 = state_29272;
var statearr_29297_29356 = state_29272__$1;
(statearr_29297_29356[(2)] = inst_29193);

(statearr_29297_29356[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (22))){
var inst_29204 = (state_29272[(16)]);
var inst_29223 = (state_29272[(2)]);
var state_29272__$1 = (function (){var statearr_29298 = state_29272;
(statearr_29298[(19)] = inst_29223);

return statearr_29298;
})();
if(cljs.core.truth_(inst_29204)){
var statearr_29299_29357 = state_29272__$1;
(statearr_29299_29357[(1)] = (23));

} else {
var statearr_29300_29358 = state_29272__$1;
(statearr_29300_29358[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (29))){
var inst_29205 = (state_29272[(15)]);
var inst_29237 = [cljs.core.cst$kw$query];
var inst_29238 = [inst_29205];
var inst_29239 = cljs.core.PersistentHashMap.fromArrays(inst_29237,inst_29238);
var inst_29240 = cljs.core.clj__GT_js(inst_29239);
var inst_29241 = dataview.setFilterArgs(inst_29240);
var inst_29242 = dataview.refresh();
var state_29272__$1 = (function (){var statearr_29301 = state_29272;
(statearr_29301[(20)] = inst_29241);

return statearr_29301;
})();
var statearr_29302_29359 = state_29272__$1;
(statearr_29302_29359[(2)] = inst_29242);

(statearr_29302_29359[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (6))){
var inst_29268 = (state_29272[(2)]);
var state_29272__$1 = state_29272;
var statearr_29303_29360 = state_29272__$1;
(statearr_29303_29360[(2)] = inst_29268);

(statearr_29303_29360[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (28))){
var inst_29205 = (state_29272[(15)]);
var inst_29235 = (state_29272[(2)]);
var state_29272__$1 = (function (){var statearr_29304 = state_29272;
(statearr_29304[(21)] = inst_29235);

return statearr_29304;
})();
if(cljs.core.truth_(inst_29205)){
var statearr_29305_29361 = state_29272__$1;
(statearr_29305_29361[(1)] = (29));

} else {
var statearr_29306_29362 = state_29272__$1;
(statearr_29306_29362[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (25))){
var inst_29206 = (state_29272[(14)]);
var inst_29228 = (state_29272[(2)]);
var state_29272__$1 = (function (){var statearr_29307 = state_29272;
(statearr_29307[(22)] = inst_29228);

return statearr_29307;
})();
if(cljs.core.truth_(inst_29206)){
var statearr_29308_29363 = state_29272__$1;
(statearr_29308_29363[(1)] = (26));

} else {
var statearr_29309_29364 = state_29272__$1;
(statearr_29309_29364[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (34))){
var inst_29264 = (state_29272[(2)]);
var state_29272__$1 = (function (){var statearr_29310 = state_29272;
(statearr_29310[(23)] = inst_29264);

return statearr_29310;
})();
var statearr_29311_29365 = state_29272__$1;
(statearr_29311_29365[(2)] = null);

(statearr_29311_29365[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (17))){
var inst_29202 = (state_29272[(12)]);
var inst_29212 = (state_29272[(17)]);
var inst_29211 = (state_29272[(9)]);
var inst_29214 = (inst_29212.cljs$core$IFn$_invoke$arity$2 ? inst_29212.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_29202) : inst_29212.call(null,hatti.constants._rank,inst_29202));
var inst_29215 = (inst_29211.cljs$core$IFn$_invoke$arity$1 ? inst_29211.cljs$core$IFn$_invoke$arity$1(inst_29214) : inst_29211.call(null,inst_29214));
var state_29272__$1 = state_29272;
var statearr_29312_29366 = state_29272__$1;
(statearr_29312_29366[(2)] = inst_29215);

(statearr_29312_29366[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (3))){
var inst_29270 = (state_29272[(2)]);
var state_29272__$1 = state_29272;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29272__$1,inst_29270);
} else {
if((state_val_29273 === (12))){
var state_29272__$1 = state_29272;
var statearr_29313_29367 = state_29272__$1;
(statearr_29313_29367[(2)] = false);

(statearr_29313_29367[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (2))){
var state_29272__$1 = state_29272;
var statearr_29314_29368 = state_29272__$1;
(statearr_29314_29368[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (23))){
var inst_29211 = (state_29272[(9)]);
var inst_29225 = (inst_29211.cljs$core$IFn$_invoke$arity$1 ? inst_29211.cljs$core$IFn$_invoke$arity$1(null) : inst_29211.call(null,null));
var state_29272__$1 = state_29272;
var statearr_29316_29369 = state_29272__$1;
(statearr_29316_29369[(2)] = inst_29225);

(statearr_29316_29369[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (19))){
var inst_29203 = (state_29272[(8)]);
var inst_29218 = (state_29272[(2)]);
var state_29272__$1 = (function (){var statearr_29317 = state_29272;
(statearr_29317[(24)] = inst_29218);

return statearr_29317;
})();
if(cljs.core.truth_(inst_29203)){
var statearr_29318_29370 = state_29272__$1;
(statearr_29318_29370[(1)] = (20));

} else {
var statearr_29319_29371 = state_29272__$1;
(statearr_29319_29371[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (11))){
var state_29272__$1 = state_29272;
var statearr_29320_29372 = state_29272__$1;
(statearr_29320_29372[(2)] = true);

(statearr_29320_29372[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (9))){
var state_29272__$1 = state_29272;
var statearr_29321_29373 = state_29272__$1;
(statearr_29321_29373[(2)] = false);

(statearr_29321_29373[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (5))){
var state_29272__$1 = state_29272;
var statearr_29322_29374 = state_29272__$1;
(statearr_29322_29374[(2)] = null);

(statearr_29322_29374[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (14))){
var inst_29181 = (state_29272[(7)]);
var inst_29198 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29181);
var state_29272__$1 = state_29272;
var statearr_29323_29375 = state_29272__$1;
(statearr_29323_29375[(2)] = inst_29198);

(statearr_29323_29375[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (26))){
var inst_29206 = (state_29272[(14)]);
var inst_29230 = grid.setColumns(inst_29206);
var inst_29231 = hatti.views.table.resizeColumns(grid);
var inst_29232 = grid.render();
var state_29272__$1 = (function (){var statearr_29324 = state_29272;
(statearr_29324[(25)] = inst_29231);

(statearr_29324[(26)] = inst_29230);

return statearr_29324;
})();
var statearr_29325_29376 = state_29272__$1;
(statearr_29325_29376[(2)] = inst_29232);

(statearr_29325_29376[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (16))){
var inst_29181 = (state_29272[(7)]);
var inst_29202 = (state_29272[(12)]);
var inst_29201 = (state_29272[(13)]);
var inst_29207 = (state_29272[(10)]);
var inst_29206 = (state_29272[(14)]);
var inst_29203 = (state_29272[(8)]);
var inst_29205 = (state_29272[(15)]);
var inst_29204 = (state_29272[(16)]);
var inst_29211 = (state_29272[(9)]);
var inst_29201__$1 = (state_29272[(2)]);
var inst_29202__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29201__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_29203__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29201__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_29204__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29201__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_29205__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29201__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_29206__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29201__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_29207__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29201__$1,cljs.core.cst$kw$re_DASH_render);
var inst_29208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29209 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_29210 = (new cljs.core.PersistentVector(null,3,(5),inst_29208,inst_29209,null));
var inst_29211__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_29210);
var inst_29212 = (function (){var e = inst_29181;
var map__29179 = inst_29201__$1;
var submission_to_rank = inst_29202__$1;
var submission_clicked = inst_29203__$1;
var submission_unclicked = inst_29204__$1;
var filter_by = inst_29205__$1;
var new_columns = inst_29206__$1;
var re_render = inst_29207__$1;
var update_data_BANG_ = inst_29211__$1;
return ((function (e,map__29179,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29181,inst_29202,inst_29201,inst_29207,inst_29206,inst_29203,inst_29205,inst_29204,inst_29211,inst_29201__$1,inst_29202__$1,inst_29203__$1,inst_29204__$1,inst_29205__$1,inst_29206__$1,inst_29207__$1,inst_29208,inst_29209,inst_29210,inst_29211__$1,state_val_29273,c__7694__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (e,map__29179,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29181,inst_29202,inst_29201,inst_29207,inst_29206,inst_29203,inst_29205,inst_29204,inst_29211,inst_29201__$1,inst_29202__$1,inst_29203__$1,inst_29204__$1,inst_29205__$1,inst_29206__$1,inst_29207__$1,inst_29208,inst_29209,inst_29210,inst_29211__$1,state_val_29273,c__7694__auto__,event_chan){
return (function (p1__29011_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__29011_SHARP_,field));
});})(e,map__29179,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29181,inst_29202,inst_29201,inst_29207,inst_29206,inst_29203,inst_29205,inst_29204,inst_29211,inst_29201__$1,inst_29202__$1,inst_29203__$1,inst_29204__$1,inst_29205__$1,inst_29206__$1,inst_29207__$1,inst_29208,inst_29209,inst_29210,inst_29211__$1,state_val_29273,c__7694__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(e,map__29179,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29181,inst_29202,inst_29201,inst_29207,inst_29206,inst_29203,inst_29205,inst_29204,inst_29211,inst_29201__$1,inst_29202__$1,inst_29203__$1,inst_29204__$1,inst_29205__$1,inst_29206__$1,inst_29207__$1,inst_29208,inst_29209,inst_29210,inst_29211__$1,state_val_29273,c__7694__auto__,event_chan))
})();
var state_29272__$1 = (function (){var statearr_29326 = state_29272;
(statearr_29326[(12)] = inst_29202__$1);

(statearr_29326[(13)] = inst_29201__$1);

(statearr_29326[(10)] = inst_29207__$1);

(statearr_29326[(14)] = inst_29206__$1);

(statearr_29326[(8)] = inst_29203__$1);

(statearr_29326[(15)] = inst_29205__$1);

(statearr_29326[(16)] = inst_29204__$1);

(statearr_29326[(17)] = inst_29212);

(statearr_29326[(9)] = inst_29211__$1);

return statearr_29326;
})();
if(cljs.core.truth_(inst_29202__$1)){
var statearr_29327_29377 = state_29272__$1;
(statearr_29327_29377[(1)] = (17));

} else {
var statearr_29328_29378 = state_29272__$1;
(statearr_29328_29378[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (30))){
var state_29272__$1 = state_29272;
var statearr_29329_29379 = state_29272__$1;
(statearr_29329_29379[(2)] = null);

(statearr_29329_29379[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (10))){
var inst_29196 = (state_29272[(2)]);
var state_29272__$1 = state_29272;
if(cljs.core.truth_(inst_29196)){
var statearr_29330_29380 = state_29272__$1;
(statearr_29330_29380[(1)] = (14));

} else {
var statearr_29331_29381 = state_29272__$1;
(statearr_29331_29381[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (18))){
var state_29272__$1 = state_29272;
var statearr_29332_29382 = state_29272__$1;
(statearr_29332_29382[(2)] = null);

(statearr_29332_29382[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29273 === (8))){
var inst_29181 = (state_29272[(7)]);
var inst_29186 = inst_29181.cljs$lang$protocol_mask$partition0$;
var inst_29187 = (inst_29186 & (64));
var inst_29188 = inst_29181.cljs$core$ISeq$;
var inst_29189 = (inst_29187) || (inst_29188);
var state_29272__$1 = state_29272;
if(cljs.core.truth_(inst_29189)){
var statearr_29333_29383 = state_29272__$1;
(statearr_29333_29383[(1)] = (11));

} else {
var statearr_29334_29384 = state_29272__$1;
(statearr_29334_29384[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__,event_chan))
;
return ((function (switch__7673__auto__,c__7694__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____0 = (function (){
var statearr_29338 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29338[(0)] = hatti$views$table$handle_table_events_$_state_machine__7674__auto__);

(statearr_29338[(1)] = (1));

return statearr_29338;
});
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____1 = (function (state_29272){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__(state_29272);
if(cljs.core.keyword_identical_QMARK_(result__7676__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e29339){if((e29339 instanceof Object)){
var ex__7677__auto__ = e29339;
var statearr_29340_29385 = state_29272;
(statearr_29340_29385[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29272);

return cljs.core.cst$kw$recur;
} else {
throw e29339;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7675__auto__,cljs.core.cst$kw$recur)){
var G__29386 = state_29272;
state_29272 = G__29386;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = function(state_29272){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____1.call(this,state_29272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____0;
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__,event_chan))
})();
var state__7696__auto__ = (function (){var statearr_29341 = (f__7695__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7695__auto__.cljs$core$IFn$_invoke$arity$0() : f__7695__auto__.call(null));
(statearr_29341[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_29341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7696__auto__);
});})(c__7694__auto__,event_chan))
);

return c__7694__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__29397(s__29398){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__29398__$1 = s__29398;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__29398__$1);
if(temp__4425__auto__){
var s__29398__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29398__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29398__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29400 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29399 = (0);
while(true){
if((i__29399 < size__5340__auto__)){
var vec__29405 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29399);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29405,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29405,(1),null);
cljs.core.chunk_append(b__29400,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__29399,vec__29405,k,v,c__5339__auto__,size__5340__auto__,b__29400,s__29398__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__29399,vec__29405,k,v,c__5339__auto__,size__5340__auto__,b__29400,s__29398__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__29407 = (i__29399 + (1));
i__29399 = G__29407;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29400),hatti$views$table$render_options_$_iter__29397(cljs.core.chunk_rest(s__29398__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29400),null);
}
} else {
var vec__29406 = cljs.core.first(s__29398__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29406,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29406,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__29406,k,v,s__29398__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__29406,k,v,s__29398__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__29397(cljs.core.rest(s__29398__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table29409 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29409 = (function (_,owner,meta29410){
this._ = _;
this.owner = owner;
this.meta29410 = meta29410;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29409.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29411,meta29410__$1){
var self__ = this;
var _29411__$1 = this;
return (new hatti.views.table.t_hatti$views$table29409(self__._,self__.owner,meta29410__$1));
});

hatti.views.table.t_hatti$views$table29409.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29411){
var self__ = this;
var _29411__$1 = this;
return self__.meta29410;
});

hatti.views.table.t_hatti$views$table29409.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table29409.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table29409.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table29409.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__29412){
var self__ = this;
var map__29413 = p__29412;
var map__29413__$1 = ((((!((map__29413 == null)))?((((map__29413.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29413.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29413):map__29413);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29413__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29413__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__29415 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__29415__$1 = ((((!((map__29415 == null)))?((((map__29415.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29415.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29415):map__29415);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29415__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__29415,map__29415__$1,flat_form,new_language,___$2,map__29413,map__29413__$1,name_or_label,language){
return (function (p1__29408_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns(flat_form,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__29408_SHARP_),new_language)], null));
});})(options,map__29415,map__29415__$1,flat_form,new_language,___$2,map__29413,map__29413__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__29424 = {"className": "label-changer"};
var G__29425 = (function (){var G__29427 = {"className": "label-changer-label"};
var G__29428 = "Show:";
return React.DOM.span(G__29427,G__29428);
})();
var G__29426 = (function (){var G__29429 = {"id": "header-display-dropdown", "className": "drop-hover"};
var G__29430 = (function (){var attrs29419 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs29419))?sablono.interpreter.attributes(attrs29419):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs29419))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__29432 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__29432);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs29419),(function (){var G__29433 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__29433);
})()], null))));
})();
var G__29431 = (function (){var G__29434 = {"className": "submenu no-dot"};
var G__29435 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__29434,G__29435);
})();
return React.DOM.div(G__29429,G__29430,G__29431);
})();
return React.DOM.div(G__29424,G__29425,G__29426);
});

hatti.views.table.t_hatti$views$table29409.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta29410], null);
});

hatti.views.table.t_hatti$views$table29409.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29409.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29409";

hatti.views.table.t_hatti$views$table29409.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29409");
});

hatti.views.table.__GT_t_hatti$views$table29409 = (function hatti$views$table$__GT_t_hatti$views$table29409(___$1,owner__$1,meta29410){
return (new hatti.views.table.t_hatti$views$table29409(___$1,owner__$1,meta29410));
});

}

return (new hatti.views.table.t_hatti$views$table29409(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__7694__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7694__auto__,query){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__,query){
return (function (state_29478){
var state_val_29479 = (state_29478[(1)]);
if((state_val_29479 === (1))){
var inst_29464 = cljs.core.async.timeout((150));
var state_29478__$1 = state_29478;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29478__$1,(2),inst_29464);
} else {
if((state_val_29479 === (2))){
var inst_29466 = (state_29478[(2)]);
var inst_29467 = input.value;
var inst_29468 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_29467);
var state_29478__$1 = (function (){var statearr_29480 = state_29478;
(statearr_29480[(7)] = inst_29466);

return statearr_29480;
})();
if(inst_29468){
var statearr_29481_29492 = state_29478__$1;
(statearr_29481_29492[(1)] = (3));

} else {
var statearr_29482_29493 = state_29478__$1;
(statearr_29482_29493[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29479 === (3))){
var inst_29470 = [query_event_key];
var inst_29471 = [query];
var inst_29472 = cljs.core.PersistentHashMap.fromArrays(inst_29470,inst_29471);
var inst_29473 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_29472);
var state_29478__$1 = state_29478;
var statearr_29483_29494 = state_29478__$1;
(statearr_29483_29494[(2)] = inst_29473);

(statearr_29483_29494[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29479 === (4))){
var state_29478__$1 = state_29478;
var statearr_29484_29495 = state_29478__$1;
(statearr_29484_29495[(2)] = null);

(statearr_29484_29495[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29479 === (5))){
var inst_29476 = (state_29478[(2)]);
var state_29478__$1 = state_29478;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29478__$1,inst_29476);
} else {
return null;
}
}
}
}
}
});})(c__7694__auto__,query))
;
return ((function (switch__7673__auto__,c__7694__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__7674__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__7674__auto____0 = (function (){
var statearr_29488 = [null,null,null,null,null,null,null,null];
(statearr_29488[(0)] = hatti$views$table$delayed_search_$_state_machine__7674__auto__);

(statearr_29488[(1)] = (1));

return statearr_29488;
});
var hatti$views$table$delayed_search_$_state_machine__7674__auto____1 = (function (state_29478){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__(state_29478);
if(cljs.core.keyword_identical_QMARK_(result__7676__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e29489){if((e29489 instanceof Object)){
var ex__7677__auto__ = e29489;
var statearr_29490_29496 = state_29478;
(statearr_29490_29496[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29478);

return cljs.core.cst$kw$recur;
} else {
throw e29489;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7675__auto__,cljs.core.cst$kw$recur)){
var G__29497 = state_29478;
state_29478 = G__29497;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__7674__auto__ = function(state_29478){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__7674__auto____1.call(this,state_29478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__7674__auto____0;
hatti$views$table$delayed_search_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__7674__auto____1;
return hatti$views$table$delayed_search_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__,query))
})();
var state__7696__auto__ = (function (){var statearr_29491 = (f__7695__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7695__auto__.cljs$core$IFn$_invoke$arity$0() : f__7695__auto__.call(null));
(statearr_29491[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_29491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7696__auto__);
});})(c__7694__auto__,query))
);

return c__7694__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table29499 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29499 = (function (_,owner,meta29500){
this._ = _;
this.owner = owner;
this.meta29500 = meta29500;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29499.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29501,meta29500__$1){
var self__ = this;
var _29501__$1 = this;
return (new hatti.views.table.t_hatti$views$table29499(self__._,self__.owner,meta29500__$1));
});

hatti.views.table.t_hatti$views$table29499.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29501){
var self__ = this;
var _29501__$1 = this;
return self__.meta29500;
});

hatti.views.table.t_hatti$views$table29499.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table29499.prototype.om$core$IRender$render$arity$1 = (function (this__6323__auto__){
var self__ = this;
var this__6323__auto____$1 = this;
var G__29504 = {"className": "table-search"};
var G__29505 = (function (){var G__29507 = {"className": "fa fa-search"};
return React.DOM.i(G__29507);
})();
var G__29506 = (function (){var G__29508 = {"type": "text", "placeholder": "Search", "onChange": ((function (G__29504,G__29505,this__6323__auto____$1){
return (function (p1__29498_SHARP_){
return hatti.views.table.delayed_search(p1__29498_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__29504,G__29505,this__6323__auto____$1))
};
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__29508) : sablono.interpreter.input.call(null,G__29508));
})();
return React.DOM.div(G__29504,G__29505,G__29506);
});

hatti.views.table.t_hatti$views$table29499.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta29500], null);
});

hatti.views.table.t_hatti$views$table29499.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29499.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29499";

hatti.views.table.t_hatti$views$table29499.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29499");
});

hatti.views.table.__GT_t_hatti$views$table29499 = (function hatti$views$table$__GT_t_hatti$views$table29499(___$1,owner__$1,meta29500){
return (new hatti.views.table.t_hatti$views$table29499(___$1,owner__$1,meta29500));
});

}

return (new hatti.views.table.t_hatti$views$table29499(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table29509 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29509 = (function (app_state,owner,meta29510){
this.app_state = app_state;
this.owner = owner;
this.meta29510 = meta29510;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29509.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29511,meta29510__$1){
var self__ = this;
var _29511__$1 = this;
return (new hatti.views.table.t_hatti$views$table29509(self__.app_state,self__.owner,meta29510__$1));
});

hatti.views.table.t_hatti$views$table29509.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29511){
var self__ = this;
var _29511__$1 = this;
return self__.meta29510;
});

hatti.views.table.t_hatti$views$table29509.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table29509.prototype.om$core$IRender$render$arity$1 = (function (this__6323__auto__){
var self__ = this;
var this__6323__auto____$1 = this;
var G__29514 = {"className": "topbar"};
var G__29515 = (function (){var G__29519 = {"id": hatti.views.table.pager_id};
return React.DOM.div(G__29519);
})();
var G__29516 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,null));
var G__29517 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.app_state));
var G__29518 = (function (){var G__29520 = {"style": {"clear": "both"}};
return React.DOM.div(G__29520);
})();
return React.DOM.div(G__29514,G__29515,G__29516,G__29517,G__29518);
});

hatti.views.table.t_hatti$views$table29509.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta29510], null);
});

hatti.views.table.t_hatti$views$table29509.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29509.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29509";

hatti.views.table.t_hatti$views$table29509.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29509");
});

hatti.views.table.__GT_t_hatti$views$table29509 = (function hatti$views$table$__GT_t_hatti$views$table29509(app_state__$1,owner__$1,meta29510){
return (new hatti.views.table.t_hatti$views$table29509(app_state__$1,owner__$1,meta29510));
});

}

return (new hatti.views.table.t_hatti$views$table29509(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq(data)){
var map__29524 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__29524__$1 = ((((!((map__29524 == null)))?((((map__29524.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29524.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29524):map__29524);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29524__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29524__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__29525 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29525,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29525,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,p__29528){
var map__29529 = p__29528;
var map__29529__$1 = ((((!((map__29529 == null)))?((((map__29529.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29529.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29529):map__29529);
var opts = map__29529__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29529__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

if(typeof hatti.views.table.t_hatti$views$table29531 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29531 = (function (app_state,owner,p__29528,map__29529,opts,slick_grid_event_handlers,meta29532){
this.app_state = app_state;
this.owner = owner;
this.p__29528 = p__29528;
this.map__29529 = map__29529;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta29532 = meta29532;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29531.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__29529,map__29529__$1,opts,slick_grid_event_handlers){
return (function (_29533,meta29532__$1){
var self__ = this;
var _29533__$1 = this;
return (new hatti.views.table.t_hatti$views$table29531(self__.app_state,self__.owner,self__.p__29528,self__.map__29529,self__.opts,self__.slick_grid_event_handlers,meta29532__$1));
});})(map__29529,map__29529__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29531.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__29529,map__29529__$1,opts,slick_grid_event_handlers){
return (function (_29533){
var self__ = this;
var _29533__$1 = this;
return self__.meta29532;
});})(map__29529,map__29529__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29531.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table29531.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__29529,map__29529__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null)));
var map__29534 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__29534__$1 = ((((!((map__29534 == null)))?((((map__29534.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29534.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29534):map__29534);
var dataset_info = map__29534__$1;
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29534__$1,cljs.core.cst$kw$num_of_submissions);
var with_info = ((function (no_data_QMARK_,map__29534,map__29534__$1,dataset_info,num_of_submissions,___$2,map__29529,map__29529__$1,opts,slick_grid_event_handlers){
return (function (p1__29527_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__29527_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dataset_DASH_info,dataset_info], null)], 0));
});})(no_data_QMARK_,map__29534,map__29534__$1,dataset_info,num_of_submissions,___$2,map__29529,map__29529__$1,opts,slick_grid_event_handlers))
;
var attrs29536 = om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked], null))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs29536))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs29536], 0))):{"className": "table-view"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs29536))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__29537 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__29538 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__29543 = {"className": "empty-state"};
var G__29544 = "No data";
return React.DOM.span(G__29543,G__29544);
})():(function (){var G__29546 = null;
var G__29547 = (function (){var G__29549 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__29549);
})();
var G__29548 = "Loading...";
return React.DOM.span(G__29546,G__29547,G__29548);
})());
return React.DOM.div(G__29537,G__29538);
})()], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs29536),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__29550 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__29551 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__29556 = {"className": "empty-state"};
var G__29557 = "No data";
return React.DOM.span(G__29556,G__29557);
})():(function (){var G__29559 = null;
var G__29560 = (function (){var G__29562 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__29562);
})();
var G__29561 = "Loading...";
return React.DOM.span(G__29559,G__29560,G__29561);
})());
return React.DOM.div(G__29550,G__29551);
})()], null))));
});})(map__29529,map__29529__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29531.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table29531.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__29529,map__29529__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__29563 = temp__4425__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29563,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29563,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__29529,map__29529__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29531.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table29531.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__29529,map__29529__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__29564 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__29564__$1 = ((((!((map__29564 == null)))?((((map__29564.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29564.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29564):map__29564);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29564__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29564__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__29566 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29566,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29566,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__29529,map__29529__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29531.getBasis = ((function (map__29529,map__29529__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__29528,cljs.core.cst$sym$map__29529,cljs.core.cst$sym$opts,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$meta29532], null);
});})(map__29529,map__29529__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29531.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29531.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29531";

hatti.views.table.t_hatti$views$table29531.cljs$lang$ctorPrWriter = ((function (map__29529,map__29529__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29531");
});})(map__29529,map__29529__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table29531 = ((function (map__29529,map__29529__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table29531(app_state__$1,owner__$1,p__29528__$1,map__29529__$2,opts__$1,slick_grid_event_handlers__$1,meta29532){
return (new hatti.views.table.t_hatti$views$table29531(app_state__$1,owner__$1,p__29528__$1,map__29529__$2,opts__$1,slick_grid_event_handlers__$1,meta29532));
});})(map__29529,map__29529__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table29531(app_state,owner,p__29528,map__29529__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
