// Compiled by ClojureScript 1.7.145 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__19521__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__19520 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__19520,(0),null);
var body = cljs.core.nthnext.call(null,vec__19520,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__19521 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__19522__i = 0, G__19522__a = new Array(arguments.length -  0);
while (G__19522__i < G__19522__a.length) {G__19522__a[G__19522__i] = arguments[G__19522__i + 0]; ++G__19522__i;}
  args = new cljs.core.IndexedSeq(G__19522__a,0);
} 
return G__19521__delegate.call(this,args);};
G__19521.cljs$lang$maxFixedArity = 0;
G__19521.cljs$lang$applyTo = (function (arglist__19523){
var args = cljs.core.seq(arglist__19523);
return G__19521__delegate(args);
});
G__19521.cljs$core$IFn$_invoke$arity$variadic = G__19521__delegate;
return G__19521;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5341__auto__ = (function sablono$core$update_arglists_$_iter__19528(s__19529){
return (new cljs.core.LazySeq(null,(function (){
var s__19529__$1 = s__19529;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__19529__$1);
if(temp__4425__auto__){
var s__19529__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19529__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__19529__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__19531 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__19530 = (0);
while(true){
if((i__19530 < size__5340__auto__)){
var args = cljs.core._nth.call(null,c__5339__auto__,i__19530);
cljs.core.chunk_append.call(null,b__19531,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__19532 = (i__19530 + (1));
i__19530 = G__19532;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19531),sablono$core$update_arglists_$_iter__19528.call(null,cljs.core.chunk_rest.call(null,s__19529__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19531),null);
}
} else {
var args = cljs.core.first.call(null,s__19529__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__19528.call(null,cljs.core.rest.call(null,s__19529__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5634__auto__ = [];
var len__5627__auto___19538 = arguments.length;
var i__5628__auto___19539 = (0);
while(true){
if((i__5628__auto___19539 < len__5627__auto___19538)){
args__5634__auto__.push((arguments[i__5628__auto___19539]));

var G__19540 = (i__5628__auto___19539 + (1));
i__5628__auto___19539 = G__19540;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5341__auto__ = (function sablono$core$iter__19534(s__19535){
return (new cljs.core.LazySeq(null,(function (){
var s__19535__$1 = s__19535;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__19535__$1);
if(temp__4425__auto__){
var s__19535__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19535__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__19535__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__19537 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__19536 = (0);
while(true){
if((i__19536 < size__5340__auto__)){
var style = cljs.core._nth.call(null,c__5339__auto__,i__19536);
cljs.core.chunk_append.call(null,b__19537,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__19541 = (i__19536 + (1));
i__19536 = G__19541;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19537),sablono$core$iter__19534.call(null,cljs.core.chunk_rest.call(null,s__19535__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19537),null);
}
} else {
var style = cljs.core.first.call(null,s__19535__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__19534.call(null,cljs.core.rest.call(null,s__19535__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq19533){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19533));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to19542 = (function sablono$core$link_to19542(var_args){
var args__5634__auto__ = [];
var len__5627__auto___19545 = arguments.length;
var i__5628__auto___19546 = (0);
while(true){
if((i__5628__auto___19546 < len__5627__auto___19545)){
args__5634__auto__.push((arguments[i__5628__auto___19546]));

var G__19547 = (i__5628__auto___19546 + (1));
i__5628__auto___19546 = G__19547;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.link_to19542.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.link_to19542.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to19542.cljs$lang$maxFixedArity = (1);

sablono.core.link_to19542.cljs$lang$applyTo = (function (seq19543){
var G__19544 = cljs.core.first.call(null,seq19543);
var seq19543__$1 = cljs.core.next.call(null,seq19543);
return sablono.core.link_to19542.cljs$core$IFn$_invoke$arity$variadic(G__19544,seq19543__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to19542);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to19548 = (function sablono$core$mail_to19548(var_args){
var args__5634__auto__ = [];
var len__5627__auto___19553 = arguments.length;
var i__5628__auto___19554 = (0);
while(true){
if((i__5628__auto___19554 < len__5627__auto___19553)){
args__5634__auto__.push((arguments[i__5628__auto___19554]));

var G__19555 = (i__5628__auto___19554 + (1));
i__5628__auto___19554 = G__19555;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.mail_to19548.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.mail_to19548.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__19551){
var vec__19552 = p__19551;
var content = cljs.core.nth.call(null,vec__19552,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4569__auto__ = content;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to19548.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to19548.cljs$lang$applyTo = (function (seq19549){
var G__19550 = cljs.core.first.call(null,seq19549);
var seq19549__$1 = cljs.core.next.call(null,seq19549);
return sablono.core.mail_to19548.cljs$core$IFn$_invoke$arity$variadic(G__19550,seq19549__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to19548);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list19556 = (function sablono$core$unordered_list19556(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5341__auto__ = (function sablono$core$unordered_list19556_$_iter__19561(s__19562){
return (new cljs.core.LazySeq(null,(function (){
var s__19562__$1 = s__19562;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__19562__$1);
if(temp__4425__auto__){
var s__19562__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19562__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__19562__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__19564 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__19563 = (0);
while(true){
if((i__19563 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__19563);
cljs.core.chunk_append.call(null,b__19564,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19565 = (i__19563 + (1));
i__19563 = G__19565;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19564),sablono$core$unordered_list19556_$_iter__19561.call(null,cljs.core.chunk_rest.call(null,s__19562__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19564),null);
}
} else {
var x = cljs.core.first.call(null,s__19562__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list19556_$_iter__19561.call(null,cljs.core.rest.call(null,s__19562__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list19556);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list19566 = (function sablono$core$ordered_list19566(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5341__auto__ = (function sablono$core$ordered_list19566_$_iter__19571(s__19572){
return (new cljs.core.LazySeq(null,(function (){
var s__19572__$1 = s__19572;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__19572__$1);
if(temp__4425__auto__){
var s__19572__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19572__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__19572__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__19574 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__19573 = (0);
while(true){
if((i__19573 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__19573);
cljs.core.chunk_append.call(null,b__19574,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19575 = (i__19573 + (1));
i__19573 = G__19575;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19574),sablono$core$ordered_list19566_$_iter__19571.call(null,cljs.core.chunk_rest.call(null,s__19572__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19574),null);
}
} else {
var x = cljs.core.first.call(null,s__19572__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list19566_$_iter__19571.call(null,cljs.core.rest.call(null,s__19572__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list19566);
/**
 * Create an image element.
 */
sablono.core.image19576 = (function sablono$core$image19576(var_args){
var args19577 = [];
var len__5627__auto___19580 = arguments.length;
var i__5628__auto___19581 = (0);
while(true){
if((i__5628__auto___19581 < len__5627__auto___19580)){
args19577.push((arguments[i__5628__auto___19581]));

var G__19582 = (i__5628__auto___19581 + (1));
i__5628__auto___19581 = G__19582;
continue;
} else {
}
break;
}

var G__19579 = args19577.length;
switch (G__19579) {
case 1:
return sablono.core.image19576.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image19576.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19577.length)].join('')));

}
});

sablono.core.image19576.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image19576.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image19576.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image19576);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__19584_SHARP_,p2__19585_SHARP_){
return [cljs.core.str(p1__19584_SHARP_),cljs.core.str("["),cljs.core.str(p2__19585_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__19586_SHARP_,p2__19587_SHARP_){
return [cljs.core.str(p1__19586_SHARP_),cljs.core.str("-"),cljs.core.str(p2__19587_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field19588 = (function sablono$core$color_field19588(var_args){
var args19589 = [];
var len__5627__auto___19656 = arguments.length;
var i__5628__auto___19657 = (0);
while(true){
if((i__5628__auto___19657 < len__5627__auto___19656)){
args19589.push((arguments[i__5628__auto___19657]));

var G__19658 = (i__5628__auto___19657 + (1));
i__5628__auto___19657 = G__19658;
continue;
} else {
}
break;
}

var G__19591 = args19589.length;
switch (G__19591) {
case 1:
return sablono.core.color_field19588.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field19588.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19589.length)].join('')));

}
});

sablono.core.color_field19588.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.color_field19588.call(null,name__8891__auto__,null);
});

sablono.core.color_field19588.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.color_field19588.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field19588);

/**
 * Creates a date input field.
 */
sablono.core.date_field19592 = (function sablono$core$date_field19592(var_args){
var args19593 = [];
var len__5627__auto___19660 = arguments.length;
var i__5628__auto___19661 = (0);
while(true){
if((i__5628__auto___19661 < len__5627__auto___19660)){
args19593.push((arguments[i__5628__auto___19661]));

var G__19662 = (i__5628__auto___19661 + (1));
i__5628__auto___19661 = G__19662;
continue;
} else {
}
break;
}

var G__19595 = args19593.length;
switch (G__19595) {
case 1:
return sablono.core.date_field19592.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field19592.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19593.length)].join('')));

}
});

sablono.core.date_field19592.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.date_field19592.call(null,name__8891__auto__,null);
});

sablono.core.date_field19592.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.date_field19592.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field19592);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field19596 = (function sablono$core$datetime_field19596(var_args){
var args19597 = [];
var len__5627__auto___19664 = arguments.length;
var i__5628__auto___19665 = (0);
while(true){
if((i__5628__auto___19665 < len__5627__auto___19664)){
args19597.push((arguments[i__5628__auto___19665]));

var G__19666 = (i__5628__auto___19665 + (1));
i__5628__auto___19665 = G__19666;
continue;
} else {
}
break;
}

var G__19599 = args19597.length;
switch (G__19599) {
case 1:
return sablono.core.datetime_field19596.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field19596.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19597.length)].join('')));

}
});

sablono.core.datetime_field19596.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.datetime_field19596.call(null,name__8891__auto__,null);
});

sablono.core.datetime_field19596.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.datetime_field19596.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field19596);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field19600 = (function sablono$core$datetime_local_field19600(var_args){
var args19601 = [];
var len__5627__auto___19668 = arguments.length;
var i__5628__auto___19669 = (0);
while(true){
if((i__5628__auto___19669 < len__5627__auto___19668)){
args19601.push((arguments[i__5628__auto___19669]));

var G__19670 = (i__5628__auto___19669 + (1));
i__5628__auto___19669 = G__19670;
continue;
} else {
}
break;
}

var G__19603 = args19601.length;
switch (G__19603) {
case 1:
return sablono.core.datetime_local_field19600.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field19600.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19601.length)].join('')));

}
});

sablono.core.datetime_local_field19600.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.datetime_local_field19600.call(null,name__8891__auto__,null);
});

sablono.core.datetime_local_field19600.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.datetime_local_field19600.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field19600);

/**
 * Creates a email input field.
 */
sablono.core.email_field19604 = (function sablono$core$email_field19604(var_args){
var args19605 = [];
var len__5627__auto___19672 = arguments.length;
var i__5628__auto___19673 = (0);
while(true){
if((i__5628__auto___19673 < len__5627__auto___19672)){
args19605.push((arguments[i__5628__auto___19673]));

var G__19674 = (i__5628__auto___19673 + (1));
i__5628__auto___19673 = G__19674;
continue;
} else {
}
break;
}

var G__19607 = args19605.length;
switch (G__19607) {
case 1:
return sablono.core.email_field19604.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field19604.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19605.length)].join('')));

}
});

sablono.core.email_field19604.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.email_field19604.call(null,name__8891__auto__,null);
});

sablono.core.email_field19604.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.email_field19604.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field19604);

/**
 * Creates a file input field.
 */
sablono.core.file_field19608 = (function sablono$core$file_field19608(var_args){
var args19609 = [];
var len__5627__auto___19676 = arguments.length;
var i__5628__auto___19677 = (0);
while(true){
if((i__5628__auto___19677 < len__5627__auto___19676)){
args19609.push((arguments[i__5628__auto___19677]));

var G__19678 = (i__5628__auto___19677 + (1));
i__5628__auto___19677 = G__19678;
continue;
} else {
}
break;
}

var G__19611 = args19609.length;
switch (G__19611) {
case 1:
return sablono.core.file_field19608.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field19608.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19609.length)].join('')));

}
});

sablono.core.file_field19608.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.file_field19608.call(null,name__8891__auto__,null);
});

sablono.core.file_field19608.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.file_field19608.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field19608);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field19612 = (function sablono$core$hidden_field19612(var_args){
var args19613 = [];
var len__5627__auto___19680 = arguments.length;
var i__5628__auto___19681 = (0);
while(true){
if((i__5628__auto___19681 < len__5627__auto___19680)){
args19613.push((arguments[i__5628__auto___19681]));

var G__19682 = (i__5628__auto___19681 + (1));
i__5628__auto___19681 = G__19682;
continue;
} else {
}
break;
}

var G__19615 = args19613.length;
switch (G__19615) {
case 1:
return sablono.core.hidden_field19612.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field19612.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19613.length)].join('')));

}
});

sablono.core.hidden_field19612.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.hidden_field19612.call(null,name__8891__auto__,null);
});

sablono.core.hidden_field19612.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.hidden_field19612.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field19612);

/**
 * Creates a month input field.
 */
sablono.core.month_field19616 = (function sablono$core$month_field19616(var_args){
var args19617 = [];
var len__5627__auto___19684 = arguments.length;
var i__5628__auto___19685 = (0);
while(true){
if((i__5628__auto___19685 < len__5627__auto___19684)){
args19617.push((arguments[i__5628__auto___19685]));

var G__19686 = (i__5628__auto___19685 + (1));
i__5628__auto___19685 = G__19686;
continue;
} else {
}
break;
}

var G__19619 = args19617.length;
switch (G__19619) {
case 1:
return sablono.core.month_field19616.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field19616.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19617.length)].join('')));

}
});

sablono.core.month_field19616.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.month_field19616.call(null,name__8891__auto__,null);
});

sablono.core.month_field19616.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.month_field19616.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field19616);

/**
 * Creates a number input field.
 */
sablono.core.number_field19620 = (function sablono$core$number_field19620(var_args){
var args19621 = [];
var len__5627__auto___19688 = arguments.length;
var i__5628__auto___19689 = (0);
while(true){
if((i__5628__auto___19689 < len__5627__auto___19688)){
args19621.push((arguments[i__5628__auto___19689]));

var G__19690 = (i__5628__auto___19689 + (1));
i__5628__auto___19689 = G__19690;
continue;
} else {
}
break;
}

var G__19623 = args19621.length;
switch (G__19623) {
case 1:
return sablono.core.number_field19620.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field19620.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19621.length)].join('')));

}
});

sablono.core.number_field19620.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.number_field19620.call(null,name__8891__auto__,null);
});

sablono.core.number_field19620.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.number_field19620.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field19620);

/**
 * Creates a password input field.
 */
sablono.core.password_field19624 = (function sablono$core$password_field19624(var_args){
var args19625 = [];
var len__5627__auto___19692 = arguments.length;
var i__5628__auto___19693 = (0);
while(true){
if((i__5628__auto___19693 < len__5627__auto___19692)){
args19625.push((arguments[i__5628__auto___19693]));

var G__19694 = (i__5628__auto___19693 + (1));
i__5628__auto___19693 = G__19694;
continue;
} else {
}
break;
}

var G__19627 = args19625.length;
switch (G__19627) {
case 1:
return sablono.core.password_field19624.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field19624.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19625.length)].join('')));

}
});

sablono.core.password_field19624.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.password_field19624.call(null,name__8891__auto__,null);
});

sablono.core.password_field19624.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.password_field19624.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field19624);

/**
 * Creates a range input field.
 */
sablono.core.range_field19628 = (function sablono$core$range_field19628(var_args){
var args19629 = [];
var len__5627__auto___19696 = arguments.length;
var i__5628__auto___19697 = (0);
while(true){
if((i__5628__auto___19697 < len__5627__auto___19696)){
args19629.push((arguments[i__5628__auto___19697]));

var G__19698 = (i__5628__auto___19697 + (1));
i__5628__auto___19697 = G__19698;
continue;
} else {
}
break;
}

var G__19631 = args19629.length;
switch (G__19631) {
case 1:
return sablono.core.range_field19628.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field19628.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19629.length)].join('')));

}
});

sablono.core.range_field19628.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.range_field19628.call(null,name__8891__auto__,null);
});

sablono.core.range_field19628.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.range_field19628.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field19628);

/**
 * Creates a search input field.
 */
sablono.core.search_field19632 = (function sablono$core$search_field19632(var_args){
var args19633 = [];
var len__5627__auto___19700 = arguments.length;
var i__5628__auto___19701 = (0);
while(true){
if((i__5628__auto___19701 < len__5627__auto___19700)){
args19633.push((arguments[i__5628__auto___19701]));

var G__19702 = (i__5628__auto___19701 + (1));
i__5628__auto___19701 = G__19702;
continue;
} else {
}
break;
}

var G__19635 = args19633.length;
switch (G__19635) {
case 1:
return sablono.core.search_field19632.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field19632.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19633.length)].join('')));

}
});

sablono.core.search_field19632.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.search_field19632.call(null,name__8891__auto__,null);
});

sablono.core.search_field19632.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.search_field19632.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field19632);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field19636 = (function sablono$core$tel_field19636(var_args){
var args19637 = [];
var len__5627__auto___19704 = arguments.length;
var i__5628__auto___19705 = (0);
while(true){
if((i__5628__auto___19705 < len__5627__auto___19704)){
args19637.push((arguments[i__5628__auto___19705]));

var G__19706 = (i__5628__auto___19705 + (1));
i__5628__auto___19705 = G__19706;
continue;
} else {
}
break;
}

var G__19639 = args19637.length;
switch (G__19639) {
case 1:
return sablono.core.tel_field19636.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field19636.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19637.length)].join('')));

}
});

sablono.core.tel_field19636.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.tel_field19636.call(null,name__8891__auto__,null);
});

sablono.core.tel_field19636.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.tel_field19636.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field19636);

/**
 * Creates a text input field.
 */
sablono.core.text_field19640 = (function sablono$core$text_field19640(var_args){
var args19641 = [];
var len__5627__auto___19708 = arguments.length;
var i__5628__auto___19709 = (0);
while(true){
if((i__5628__auto___19709 < len__5627__auto___19708)){
args19641.push((arguments[i__5628__auto___19709]));

var G__19710 = (i__5628__auto___19709 + (1));
i__5628__auto___19709 = G__19710;
continue;
} else {
}
break;
}

var G__19643 = args19641.length;
switch (G__19643) {
case 1:
return sablono.core.text_field19640.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field19640.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19641.length)].join('')));

}
});

sablono.core.text_field19640.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.text_field19640.call(null,name__8891__auto__,null);
});

sablono.core.text_field19640.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.text_field19640.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field19640);

/**
 * Creates a time input field.
 */
sablono.core.time_field19644 = (function sablono$core$time_field19644(var_args){
var args19645 = [];
var len__5627__auto___19712 = arguments.length;
var i__5628__auto___19713 = (0);
while(true){
if((i__5628__auto___19713 < len__5627__auto___19712)){
args19645.push((arguments[i__5628__auto___19713]));

var G__19714 = (i__5628__auto___19713 + (1));
i__5628__auto___19713 = G__19714;
continue;
} else {
}
break;
}

var G__19647 = args19645.length;
switch (G__19647) {
case 1:
return sablono.core.time_field19644.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field19644.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19645.length)].join('')));

}
});

sablono.core.time_field19644.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.time_field19644.call(null,name__8891__auto__,null);
});

sablono.core.time_field19644.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.time_field19644.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field19644);

/**
 * Creates a url input field.
 */
sablono.core.url_field19648 = (function sablono$core$url_field19648(var_args){
var args19649 = [];
var len__5627__auto___19716 = arguments.length;
var i__5628__auto___19717 = (0);
while(true){
if((i__5628__auto___19717 < len__5627__auto___19716)){
args19649.push((arguments[i__5628__auto___19717]));

var G__19718 = (i__5628__auto___19717 + (1));
i__5628__auto___19717 = G__19718;
continue;
} else {
}
break;
}

var G__19651 = args19649.length;
switch (G__19651) {
case 1:
return sablono.core.url_field19648.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field19648.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19649.length)].join('')));

}
});

sablono.core.url_field19648.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.url_field19648.call(null,name__8891__auto__,null);
});

sablono.core.url_field19648.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.url_field19648.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field19648);

/**
 * Creates a week input field.
 */
sablono.core.week_field19652 = (function sablono$core$week_field19652(var_args){
var args19653 = [];
var len__5627__auto___19720 = arguments.length;
var i__5628__auto___19721 = (0);
while(true){
if((i__5628__auto___19721 < len__5627__auto___19720)){
args19653.push((arguments[i__5628__auto___19721]));

var G__19722 = (i__5628__auto___19721 + (1));
i__5628__auto___19721 = G__19722;
continue;
} else {
}
break;
}

var G__19655 = args19653.length;
switch (G__19655) {
case 1:
return sablono.core.week_field19652.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field19652.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19653.length)].join('')));

}
});

sablono.core.week_field19652.cljs$core$IFn$_invoke$arity$1 = (function (name__8891__auto__){
return sablono.core.week_field19652.call(null,name__8891__auto__,null);
});

sablono.core.week_field19652.cljs$core$IFn$_invoke$arity$2 = (function (name__8891__auto__,value__8892__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__8891__auto__,value__8892__auto__);
});

sablono.core.week_field19652.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field19652);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box19724 = (function sablono$core$check_box19724(var_args){
var args19725 = [];
var len__5627__auto___19728 = arguments.length;
var i__5628__auto___19729 = (0);
while(true){
if((i__5628__auto___19729 < len__5627__auto___19728)){
args19725.push((arguments[i__5628__auto___19729]));

var G__19730 = (i__5628__auto___19729 + (1));
i__5628__auto___19729 = G__19730;
continue;
} else {
}
break;
}

var G__19727 = args19725.length;
switch (G__19727) {
case 1:
return sablono.core.check_box19724.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box19724.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box19724.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19725.length)].join('')));

}
});

sablono.core.check_box19724.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box19724.call(null,name,null);
});

sablono.core.check_box19724.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box19724.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box19724.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box19724.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box19724);
/**
 * Creates a radio button.
 */
sablono.core.radio_button19732 = (function sablono$core$radio_button19732(var_args){
var args19733 = [];
var len__5627__auto___19736 = arguments.length;
var i__5628__auto___19737 = (0);
while(true){
if((i__5628__auto___19737 < len__5627__auto___19736)){
args19733.push((arguments[i__5628__auto___19737]));

var G__19738 = (i__5628__auto___19737 + (1));
i__5628__auto___19737 = G__19738;
continue;
} else {
}
break;
}

var G__19735 = args19733.length;
switch (G__19735) {
case 1:
return sablono.core.radio_button19732.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button19732.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button19732.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19733.length)].join('')));

}
});

sablono.core.radio_button19732.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button19732.call(null,group,null);
});

sablono.core.radio_button19732.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button19732.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button19732.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button19732.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button19732);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options19740 = (function sablono$core$select_options19740(var_args){
var args19741 = [];
var len__5627__auto___19752 = arguments.length;
var i__5628__auto___19753 = (0);
while(true){
if((i__5628__auto___19753 < len__5627__auto___19752)){
args19741.push((arguments[i__5628__auto___19753]));

var G__19754 = (i__5628__auto___19753 + (1));
i__5628__auto___19753 = G__19754;
continue;
} else {
}
break;
}

var G__19743 = args19741.length;
switch (G__19743) {
case 1:
return sablono.core.select_options19740.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options19740.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19741.length)].join('')));

}
});

sablono.core.select_options19740.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options19740.call(null,coll,null);
});

sablono.core.select_options19740.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__5341__auto__ = (function sablono$core$iter__19744(s__19745){
return (new cljs.core.LazySeq(null,(function (){
var s__19745__$1 = s__19745;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__19745__$1);
if(temp__4425__auto__){
var s__19745__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19745__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__19745__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__19747 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__19746 = (0);
while(true){
if((i__19746 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__19746);
cljs.core.chunk_append.call(null,b__19747,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19750 = x;
var text = cljs.core.nth.call(null,vec__19750,(0),null);
var val = cljs.core.nth.call(null,vec__19750,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19750,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19740.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__19756 = (i__19746 + (1));
i__19746 = G__19756;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19747),sablono$core$iter__19744.call(null,cljs.core.chunk_rest.call(null,s__19745__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19747),null);
}
} else {
var x = cljs.core.first.call(null,s__19745__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19751 = x;
var text = cljs.core.nth.call(null,vec__19751,(0),null);
var val = cljs.core.nth.call(null,vec__19751,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19751,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19740.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__19744.call(null,cljs.core.rest.call(null,s__19745__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,coll);
});

sablono.core.select_options19740.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options19740);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down19757 = (function sablono$core$drop_down19757(var_args){
var args19758 = [];
var len__5627__auto___19761 = arguments.length;
var i__5628__auto___19762 = (0);
while(true){
if((i__5628__auto___19762 < len__5627__auto___19761)){
args19758.push((arguments[i__5628__auto___19762]));

var G__19763 = (i__5628__auto___19762 + (1));
i__5628__auto___19762 = G__19763;
continue;
} else {
}
break;
}

var G__19760 = args19758.length;
switch (G__19760) {
case 2:
return sablono.core.drop_down19757.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down19757.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19758.length)].join('')));

}
});

sablono.core.drop_down19757.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down19757.call(null,name,options,null);
});

sablono.core.drop_down19757.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down19757.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down19757);
/**
 * Creates a text area element.
 */
sablono.core.text_area19765 = (function sablono$core$text_area19765(var_args){
var args19766 = [];
var len__5627__auto___19769 = arguments.length;
var i__5628__auto___19770 = (0);
while(true){
if((i__5628__auto___19770 < len__5627__auto___19769)){
args19766.push((arguments[i__5628__auto___19770]));

var G__19771 = (i__5628__auto___19770 + (1));
i__5628__auto___19770 = G__19771;
continue;
} else {
}
break;
}

var G__19768 = args19766.length;
switch (G__19768) {
case 1:
return sablono.core.text_area19765.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area19765.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19766.length)].join('')));

}
});

sablono.core.text_area19765.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area19765.call(null,name,null);
});

sablono.core.text_area19765.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area19765.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area19765);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label19773 = (function sablono$core$label19773(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label19773);
/**
 * Creates a submit button.
 */
sablono.core.submit_button19774 = (function sablono$core$submit_button19774(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button19774);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button19775 = (function sablono$core$reset_button19775(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button19775);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to19776 = (function sablono$core$form_to19776(var_args){
var args__5634__auto__ = [];
var len__5627__auto___19781 = arguments.length;
var i__5628__auto___19782 = (0);
while(true){
if((i__5628__auto___19782 < len__5627__auto___19781)){
args__5634__auto__.push((arguments[i__5628__auto___19782]));

var G__19783 = (i__5628__auto___19782 + (1));
i__5628__auto___19782 = G__19783;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.form_to19776.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.form_to19776.cljs$core$IFn$_invoke$arity$variadic = (function (p__19779,body){
var vec__19780 = p__19779;
var method = cljs.core.nth.call(null,vec__19780,(0),null);
var action = cljs.core.nth.call(null,vec__19780,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to19776.cljs$lang$maxFixedArity = (1);

sablono.core.form_to19776.cljs$lang$applyTo = (function (seq19777){
var G__19778 = cljs.core.first.call(null,seq19777);
var seq19777__$1 = cljs.core.next.call(null,seq19777);
return sablono.core.form_to19776.cljs$core$IFn$_invoke$arity$variadic(G__19778,seq19777__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to19776);
