// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('inflections.core');
hatti.utils.url = (function hatti$utils$url(var_args){
var args__5634__auto__ = [];
var len__5627__auto___94241 = arguments.length;
var i__5628__auto___94242 = (0);
while(true){
if((i__5628__auto___94242 < len__5627__auto___94241)){
args__5634__auto__.push((arguments[i__5628__auto___94242]));

var G__94243 = (i__5628__auto___94242 + (1));
i__5628__auto___94242 = G__94243;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("/",args);
});

hatti.utils.url.cljs$lang$maxFixedArity = (0);

hatti.utils.url.cljs$lang$applyTo = (function (seq94240){
return hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq94240));
});
/**
 * Get last parameter form url
 */
hatti.utils.last_url_param = (function hatti$utils$last_url_param(url){
var last_param = cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(url)].join(''),/\//));
return cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(last_param)].join(''),/.json/));
});
/**
 * Convert json to js using JSON.parse
 */
hatti.utils.json__GT_js = (function hatti$utils$json__GT_js(s){
return JSON.parse(s);
});
/**
 * Convert json string to cljs object.
 * Fast, but doesn't preserve keywords.
 */
hatti.utils.json__GT_cljs = (function hatti$utils$json__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.utils.json__GT_js(s));
});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
hatti.utils.json__GT_js__GT_cljs = (function hatti$utils$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(hatti.utils.json__GT_js(s),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
hatti.utils.format = (function hatti$utils$format(var_args){
var args__5634__auto__ = [];
var len__5627__auto___94246 = arguments.length;
var i__5628__auto___94247 = (0);
while(true){
if((i__5628__auto___94247 < len__5627__auto___94246)){
args__5634__auto__.push((arguments[i__5628__auto___94247]));

var G__94248 = (i__5628__auto___94247 + (1));
i__5628__auto___94247 = G__94248;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
});

hatti.utils.format.cljs$lang$maxFixedArity = (1);

hatti.utils.format.cljs$lang$applyTo = (function (seq94244){
var G__94245 = cljs.core.first(seq94244);
var seq94244__$1 = cljs.core.next(seq94244);
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic(G__94245,seq94244__$1);
});
/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
hatti.utils.safe_regex = (function hatti$utils$safe_regex(var_args){
var args__5634__auto__ = [];
var len__5627__auto___94254 = arguments.length;
var i__5628__auto___94255 = (0);
while(true){
if((i__5628__auto___94255 < len__5627__auto___94254)){
args__5634__auto__.push((arguments[i__5628__auto___94255]));

var G__94256 = (i__5628__auto___94255 + (1));
i__5628__auto___94255 = G__94256;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__94251){
var map__94252 = p__94251;
var map__94252__$1 = ((((!((map__94252 == null)))?((((map__94252.cljs$lang$protocol_mask$partition0$ & (64))) || (map__94252.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__94252):map__94252);
var ignore_case_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__94252__$1,cljs.core.cst$kw$ignore_DASH_case_QMARK_,true);
var s__$1 = s.replace(/\/[\-\[\]\\/\{\}\(\)\*\+\?\.\\\^\$\|]\//,"\\$&");
return (new RegExp(s__$1,"i"));

});

hatti.utils.safe_regex.cljs$lang$maxFixedArity = (1);

hatti.utils.safe_regex.cljs$lang$applyTo = (function (seq94249){
var G__94250 = cljs.core.first(seq94249);
var seq94249__$1 = cljs.core.next(seq94249);
return hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__94250,seq94249__$1);
});
/**
 * Given a seq, produces a two-el seq. [a b c] => [[0 a] [1 b] [2 c]].
 */
hatti.utils.indexed = (function hatti$utils$indexed(coll){
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,coll);
});
/**
 * Helper function to create a click function that prevents default
 */
hatti.utils.click_fn = (function hatti$utils$click_fn(f){
return (function (event){
event.preventDefault();

return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
});
/**
 * Create an appropriately pluralized string prefix by number.
 */
hatti.utils.pluralize_number = (function hatti$utils$pluralize_number(number,kind){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [number,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),number))?kind:inflections.core.plural(kind))], null));
});
/**
 * True if substring is a substring of string
 */
hatti.utils.substring_QMARK_ = (function hatti$utils$substring_QMARK_(var_args){
var args94257 = [];
var len__5627__auto___94266 = arguments.length;
var i__5628__auto___94267 = (0);
while(true){
if((i__5628__auto___94267 < len__5627__auto___94266)){
args94257.push((arguments[i__5628__auto___94267]));

var G__94268 = (i__5628__auto___94267 + (1));
i__5628__auto___94267 = G__94268;
continue;
} else {
}
break;
}

var G__94262 = args94257.length;
switch (G__94262) {
case 2:
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args94257.slice((2)),(0)));
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (substring,string){
return cljs.core.complement(cljs.core.nil_QMARK_).call(null,cljs.core.re_find(cljs.core.re_pattern(substring),string));
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,string,p__94263){
var map__94264 = p__94263;
var map__94264__$1 = ((((!((map__94264 == null)))?((((map__94264.cljs$lang$protocol_mask$partition0$ & (64))) || (map__94264.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__94264):map__94264);
var case_sensitive_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__94264__$1,cljs.core.cst$kw$case_DASH_sensitive_QMARK_);
if(cljs.core.truth_(case_sensitive_QMARK_)){
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2(substring,string);
} else {
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2(clojure.string.lower_case(substring),clojure.string.lower_case(string));
}
});

hatti.utils.substring_QMARK_.cljs$lang$applyTo = (function (seq94258){
var G__94259 = cljs.core.first(seq94258);
var seq94258__$1 = cljs.core.next(seq94258);
var G__94260 = cljs.core.first(seq94258__$1);
var seq94258__$2 = cljs.core.next(seq94258__$1);
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__94259,G__94260,seq94258__$2);
});

hatti.utils.substring_QMARK_.cljs$lang$maxFixedArity = (2);
hatti.utils.hyphen__GT_camel_case = (function hatti$utils$hyphen__GT_camel_case(source_string){
return clojure.string.replace(source_string,/(-)(.)/,(function (p1__94270_SHARP_){
var vec__94272 = p1__94270_SHARP_;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__94272,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__94272,(1),null);
var letter_to_uppercase = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__94272,(2),null);
return clojure.string.upper_case(letter_to_uppercase);
}));
});
