// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"id",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___32660 = arguments.length;
var i__5628__auto___32661 = (0);
while(true){
if((i__5628__auto___32661 < len__5627__auto___32660)){
args__5634__auto__.push((arguments[i__5628__auto___32661]));

var G__32662 = (i__5628__auto___32661 + (1));
i__5628__auto___32661 = G__32662;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__32657){
var map__32658 = p__32657;
var map__32658__$1 = ((((!((map__32658 == null)))?((((map__32658.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32658.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32658):map__32658);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32658__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq32655){
var G__32656 = cljs.core.first(seq32655);
var seq32655__$1 = cljs.core.next(seq32655);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__32656,seq32655__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__32663_SHARP_){
if(typeof p1__32663_SHARP_ === 'string'){
return clojure.string.lower_case(p1__32663_SHARP_);
} else {
return p1__32663_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__32667){
var vec__32668 = p__32667;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32668,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32668,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__32664_SHARP_){
return cljs.core.re_find(hatti.utils.safe_regex(query),[cljs.core.str(p1__32664_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(field,clj_value,language,true);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args32669 = [];
var len__5627__auto___32693 = arguments.length;
var i__5628__auto___32694 = (0);
while(true){
if((i__5628__auto___32694 < len__5627__auto___32693)){
args32669.push((arguments[i__5628__auto___32694]));

var G__32695 = (i__5628__auto___32694 + (1));
i__5628__auto___32694 = G__32695;
continue;
} else {
}
break;
}

var G__32675 = args32669.length;
switch (G__32675) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args32669.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2(form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns(form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__32676){
var map__32677 = p__32676;
var map__32677__$1 = ((((!((map__32677 == null)))?((((map__32677.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32677.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32677):map__32677);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32677__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.clj__GT_js((function (){var iter__5341__auto__ = ((function (map__32677,map__32677__$1,is_filtered_dataview_QMARK_){
return (function hatti$views$table$iter__32679(s__32680){
return (new cljs.core.LazySeq(null,((function (map__32677,map__32677__$1,is_filtered_dataview_QMARK_){
return (function (){
var s__32680__$1 = s__32680;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__32680__$1);
if(temp__4425__auto__){
var s__32680__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__32680__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__32680__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__32682 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__32681 = (0);
while(true){
if((i__32681 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__32681);
cljs.core.chunk_append(b__32682,(function (){var map__32689 = field;
var map__32689__$1 = ((((!((map__32689 == null)))?((((map__32689.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32689.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32689):map__32689);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32689__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32689__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32689__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})());

var G__32697 = (i__32681 + (1));
i__32681 = G__32697;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32682),hatti$views$table$iter__32679(cljs.core.chunk_rest(s__32680__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32682),null);
}
} else {
var field = cljs.core.first(s__32680__$2);
return cljs.core.cons((function (){var map__32691 = field;
var map__32691__$1 = ((((!((map__32691 == null)))?((((map__32691.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32691.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32691):map__32691);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32691__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32691__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32691__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})(),hatti$views$table$iter__32679(cljs.core.rest(s__32680__$2)));
}
} else {
return null;
}
break;
}
});})(map__32677,map__32677__$1,is_filtered_dataview_QMARK_))
,null,null));
});})(map__32677,map__32677__$1,is_filtered_dataview_QMARK_))
;
return iter__5341__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq32670){
var G__32671 = cljs.core.first(seq32670);
var seq32670__$1 = cljs.core.next(seq32670);
var G__32672 = cljs.core.first(seq32670__$1);
var seq32670__$2 = cljs.core.next(seq32670__$1);
var G__32673 = cljs.core.first(seq32670__$2);
var seq32670__$3 = cljs.core.next(seq32670__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__32671,G__32672,G__32673,seq32670__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__32699 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__32699);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": true};
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__32710(s__32711){
return (new cljs.core.LazySeq(null,(function (){
var s__32711__$1 = s__32711;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__32711__$1);
if(temp__4425__auto__){
var s__32711__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__32711__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__32711__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__32713 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__32712 = (0);
while(true){
if((i__32712 < size__5340__auto__)){
var vec__32718 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__32712);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32718,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32718,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__32713,event.subscribe(handler_function));

var G__32720 = (i__32712 + (1));
i__32712 = G__32720;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32713),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__32710(cljs.core.chunk_rest(s__32711__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32713),null);
}
} else {
var vec__32719 = cljs.core.first(s__32711__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32719,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32719,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__32710(cljs.core.rest(s__32711__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__32731(s__32732){
return (new cljs.core.LazySeq(null,(function (){
var s__32732__$1 = s__32732;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__32732__$1);
if(temp__4425__auto__){
var s__32732__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__32732__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__32732__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__32734 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__32733 = (0);
while(true){
if((i__32733 < size__5340__auto__)){
var vec__32739 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__32733);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32739,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32739,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__32734,event.subscribe(handler_function));

var G__32741 = (i__32733 + (1));
i__32733 = G__32741;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32734),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__32731(cljs.core.chunk_rest(s__32732__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32734),null);
}
} else {
var vec__32740 = cljs.core.first(s__32732__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32740,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32740,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__32731(cljs.core.rest(s__32732__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,p__32742){
var map__32751 = p__32742;
var map__32751__$1 = ((((!((map__32751 == null)))?((((map__32751.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32751.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32751):map__32751);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32751__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32751__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,true,current_language,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__32753 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__32753__$1 = ((((!((map__32753 == null)))?((((map__32753.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32753.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32753):map__32753);
var map__32754 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32753__$1,cljs.core.cst$kw$table_DASH_page);
var map__32754__$1 = ((((!((map__32754 == null)))?((((map__32754.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32754.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32754):map__32754);
var map__32755 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32754__$1,cljs.core.cst$kw$paging);
var map__32755__$1 = ((((!((map__32755 == null)))?((((map__32755.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32755.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32755):map__32755);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32755__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32755__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__32753,map__32753__$1,map__32754,map__32754__$1,map__32755,map__32755__$1,num_displayed_records,total_page_count,map__32751,map__32751__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__32753,map__32753__$1,map__32754,map__32754__$1,map__32755,map__32755__$1,num_displayed_records,total_page_count,map__32751,map__32751__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__32753,map__32753__$1,map__32754,map__32754__$1,map__32755,map__32755__$1,num_displayed_records,total_page_count,map__32751,map__32751__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__32753,map__32753__$1,map__32754,map__32754__$1,map__32755,map__32755__$1,num_displayed_records,total_page_count,map__32751,map__32751__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__32753,map__32753__$1,map__32754,map__32754__$1,map__32755,map__32755__$1,num_displayed_records,total_page_count,map__32751,map__32751__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__32753,map__32753__$1,map__32754,map__32754__$1,map__32755,map__32755__$1,num_displayed_records,total_page_count,map__32751,map__32751__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__8400__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto__,event_chan){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__,event_chan){
return (function (state_33020){
var state_val_33021 = (state_33020[(1)]);
if((state_val_33021 === (7))){
var inst_32929 = (state_33020[(7)]);
var inst_32929__$1 = (state_33020[(2)]);
var inst_32931 = (inst_32929__$1 == null);
var inst_32932 = cljs.core.not(inst_32931);
var state_33020__$1 = (function (){var statearr_33022 = state_33020;
(statearr_33022[(7)] = inst_32929__$1);

return statearr_33022;
})();
if(inst_32932){
var statearr_33023_33090 = state_33020__$1;
(statearr_33023_33090[(1)] = (8));

} else {
var statearr_33024_33091 = state_33020__$1;
(statearr_33024_33091[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (20))){
var inst_32951 = (state_33020[(8)]);
var inst_32959 = (state_33020[(9)]);
var inst_32968 = (inst_32959.cljs$core$IFn$_invoke$arity$1 ? inst_32959.cljs$core$IFn$_invoke$arity$1(inst_32951) : inst_32959.call(null,inst_32951));
var state_33020__$1 = state_33020;
var statearr_33025_33092 = state_33020__$1;
(statearr_33025_33092[(2)] = inst_32968);

(statearr_33025_33092[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (27))){
var state_33020__$1 = state_33020;
var statearr_33026_33093 = state_33020__$1;
(statearr_33026_33093[(2)] = null);

(statearr_33026_33093[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (1))){
var state_33020__$1 = state_33020;
var statearr_33027_33094 = state_33020__$1;
(statearr_33027_33094[(2)] = null);

(statearr_33027_33094[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (24))){
var state_33020__$1 = state_33020;
var statearr_33028_33095 = state_33020__$1;
(statearr_33028_33095[(2)] = null);

(statearr_33028_33095[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (4))){
var state_33020__$1 = state_33020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33020__$1,(7),event_chan);
} else {
if((state_val_33021 === (15))){
var inst_32929 = (state_33020[(7)]);
var state_33020__$1 = state_33020;
var statearr_33029_33096 = state_33020__$1;
(statearr_33029_33096[(2)] = inst_32929);

(statearr_33029_33096[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (21))){
var state_33020__$1 = state_33020;
var statearr_33030_33097 = state_33020__$1;
(statearr_33030_33097[(2)] = null);

(statearr_33030_33097[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (31))){
var inst_32955 = (state_33020[(10)]);
var inst_32993 = (state_33020[(2)]);
var inst_32994 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32955,cljs.core.cst$kw$table);
var state_33020__$1 = (function (){var statearr_33031 = state_33020;
(statearr_33031[(11)] = inst_32993);

return statearr_33031;
})();
if(inst_32994){
var statearr_33032_33098 = state_33020__$1;
(statearr_33032_33098[(1)] = (32));

} else {
var statearr_33033_33099 = state_33020__$1;
(statearr_33033_33099[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (32))){
var inst_32949 = (state_33020[(12)]);
var inst_32953 = (state_33020[(13)]);
var inst_32951 = (state_33020[(8)]);
var inst_32959 = (state_33020[(9)]);
var inst_32954 = (state_33020[(14)]);
var inst_32960 = (state_33020[(15)]);
var inst_32929 = (state_33020[(7)]);
var inst_32952 = (state_33020[(16)]);
var inst_32950 = (state_33020[(17)]);
var inst_32955 = (state_33020[(10)]);
var inst_33007 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_33008 = (function (){var new_columns = inst_32954;
var submission_clicked = inst_32951;
var submission_unclicked = inst_32952;
var get_submission_data = inst_32960;
var c__8400__auto____$1 = inst_33007;
var re_render = inst_32955;
var update_data_BANG_ = inst_32959;
var map__32927 = inst_32949;
var submission_to_rank = inst_32950;
var e = inst_32929;
var filter_by = inst_32953;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__8400__auto____$1,re_render,update_data_BANG_,map__32927,submission_to_rank,e,filter_by,inst_32949,inst_32953,inst_32951,inst_32959,inst_32954,inst_32960,inst_32929,inst_32952,inst_32950,inst_32955,inst_33007,state_val_33021,c__8400__auto__,event_chan){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__8400__auto____$1,re_render,update_data_BANG_,map__32927,submission_to_rank,e,filter_by,inst_32949,inst_32953,inst_32951,inst_32959,inst_32954,inst_32960,inst_32929,inst_32952,inst_32950,inst_32955,inst_33007,state_val_33021,c__8400__auto__,event_chan){
return (function (state_33005){
var state_val_33006 = (state_33005[(1)]);
if((state_val_33006 === (1))){
var inst_32996 = cljs.core.async.timeout((20));
var state_33005__$1 = state_33005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33005__$1,(2),inst_32996);
} else {
if((state_val_33006 === (2))){
var inst_32998 = (state_33005[(2)]);
var inst_32999 = grid.resizeCanvas();
var inst_33000 = grid.invalidateAllRows();
var inst_33001 = hatti.views.table.resizeColumns(grid);
var inst_33002 = grid.render();
var inst_33003 = hatti.views.table.init_sg_pager(grid,dataview);
var state_33005__$1 = (function (){var statearr_33034 = state_33005;
(statearr_33034[(7)] = inst_33002);

(statearr_33034[(8)] = inst_32999);

(statearr_33034[(9)] = inst_33001);

(statearr_33034[(10)] = inst_33000);

(statearr_33034[(11)] = inst_32998);

return statearr_33034;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33005__$1,inst_33003);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__8400__auto____$1,re_render,update_data_BANG_,map__32927,submission_to_rank,e,filter_by,inst_32949,inst_32953,inst_32951,inst_32959,inst_32954,inst_32960,inst_32929,inst_32952,inst_32950,inst_32955,inst_33007,state_val_33021,c__8400__auto__,event_chan))
;
return ((function (switch__8335__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__8400__auto____$1,re_render,update_data_BANG_,map__32927,submission_to_rank,e,filter_by,inst_32949,inst_32953,inst_32951,inst_32959,inst_32954,inst_32960,inst_32929,inst_32952,inst_32950,inst_32955,inst_33007,state_val_33021,c__8400__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8336__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8336__auto____0 = (function (){
var statearr_33038 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33038[(0)] = hatti$views$table$handle_table_events_$_state_machine__8336__auto__);

(statearr_33038[(1)] = (1));

return statearr_33038;
});
var hatti$views$table$handle_table_events_$_state_machine__8336__auto____1 = (function (state_33005){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_33005);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e33039){if((e33039 instanceof Object)){
var ex__8339__auto__ = e33039;
var statearr_33040_33100 = state_33005;
(statearr_33040_33100[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33005);

return cljs.core.cst$kw$recur;
} else {
throw e33039;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__33101 = state_33005;
state_33005 = G__33101;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8336__auto__ = function(state_33005){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8336__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8336__auto____1.call(this,state_33005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8336__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8336__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__8400__auto____$1,re_render,update_data_BANG_,map__32927,submission_to_rank,e,filter_by,inst_32949,inst_32953,inst_32951,inst_32959,inst_32954,inst_32960,inst_32929,inst_32952,inst_32950,inst_32955,inst_33007,state_val_33021,c__8400__auto__,event_chan))
})();
var state__8402__auto__ = (function (){var statearr_33041 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_33041[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto____$1);

return statearr_33041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__8400__auto____$1,re_render,update_data_BANG_,map__32927,submission_to_rank,e,filter_by,inst_32949,inst_32953,inst_32951,inst_32959,inst_32954,inst_32960,inst_32929,inst_32952,inst_32950,inst_32955,inst_33007,state_val_33021,c__8400__auto__,event_chan))
})();
var inst_33009 = cljs.core.async.impl.dispatch.run(inst_33008);
var state_33020__$1 = (function (){var statearr_33042 = state_33020;
(statearr_33042[(18)] = inst_33009);

return statearr_33042;
})();
var statearr_33043_33102 = state_33020__$1;
(statearr_33043_33102[(2)] = inst_33007);

(statearr_33043_33102[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (33))){
var state_33020__$1 = state_33020;
var statearr_33044_33103 = state_33020__$1;
(statearr_33044_33103[(2)] = null);

(statearr_33044_33103[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (13))){
var inst_32941 = (state_33020[(2)]);
var state_33020__$1 = state_33020;
var statearr_33045_33104 = state_33020__$1;
(statearr_33045_33104[(2)] = inst_32941);

(statearr_33045_33104[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (22))){
var inst_32952 = (state_33020[(16)]);
var inst_32971 = (state_33020[(2)]);
var state_33020__$1 = (function (){var statearr_33046 = state_33020;
(statearr_33046[(19)] = inst_32971);

return statearr_33046;
})();
if(cljs.core.truth_(inst_32952)){
var statearr_33047_33105 = state_33020__$1;
(statearr_33047_33105[(1)] = (23));

} else {
var statearr_33048_33106 = state_33020__$1;
(statearr_33048_33106[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (29))){
var inst_32953 = (state_33020[(13)]);
var inst_32985 = [cljs.core.cst$kw$query];
var inst_32986 = [inst_32953];
var inst_32987 = cljs.core.PersistentHashMap.fromArrays(inst_32985,inst_32986);
var inst_32988 = cljs.core.clj__GT_js(inst_32987);
var inst_32989 = dataview.setFilterArgs(inst_32988);
var inst_32990 = dataview.refresh();
var state_33020__$1 = (function (){var statearr_33049 = state_33020;
(statearr_33049[(20)] = inst_32989);

return statearr_33049;
})();
var statearr_33050_33107 = state_33020__$1;
(statearr_33050_33107[(2)] = inst_32990);

(statearr_33050_33107[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (6))){
var inst_33016 = (state_33020[(2)]);
var state_33020__$1 = state_33020;
var statearr_33051_33108 = state_33020__$1;
(statearr_33051_33108[(2)] = inst_33016);

(statearr_33051_33108[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (28))){
var inst_32953 = (state_33020[(13)]);
var inst_32983 = (state_33020[(2)]);
var state_33020__$1 = (function (){var statearr_33052 = state_33020;
(statearr_33052[(21)] = inst_32983);

return statearr_33052;
})();
if(cljs.core.truth_(inst_32953)){
var statearr_33053_33109 = state_33020__$1;
(statearr_33053_33109[(1)] = (29));

} else {
var statearr_33054_33110 = state_33020__$1;
(statearr_33054_33110[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (25))){
var inst_32954 = (state_33020[(14)]);
var inst_32976 = (state_33020[(2)]);
var state_33020__$1 = (function (){var statearr_33055 = state_33020;
(statearr_33055[(22)] = inst_32976);

return statearr_33055;
})();
if(cljs.core.truth_(inst_32954)){
var statearr_33056_33111 = state_33020__$1;
(statearr_33056_33111[(1)] = (26));

} else {
var statearr_33057_33112 = state_33020__$1;
(statearr_33057_33112[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (34))){
var inst_33012 = (state_33020[(2)]);
var state_33020__$1 = (function (){var statearr_33058 = state_33020;
(statearr_33058[(23)] = inst_33012);

return statearr_33058;
})();
var statearr_33059_33113 = state_33020__$1;
(statearr_33059_33113[(2)] = null);

(statearr_33059_33113[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (17))){
var inst_32959 = (state_33020[(9)]);
var inst_32960 = (state_33020[(15)]);
var inst_32950 = (state_33020[(17)]);
var inst_32962 = (inst_32960.cljs$core$IFn$_invoke$arity$2 ? inst_32960.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_32950) : inst_32960.call(null,hatti.constants._rank,inst_32950));
var inst_32963 = (inst_32959.cljs$core$IFn$_invoke$arity$1 ? inst_32959.cljs$core$IFn$_invoke$arity$1(inst_32962) : inst_32959.call(null,inst_32962));
var state_33020__$1 = state_33020;
var statearr_33060_33114 = state_33020__$1;
(statearr_33060_33114[(2)] = inst_32963);

(statearr_33060_33114[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (3))){
var inst_33018 = (state_33020[(2)]);
var state_33020__$1 = state_33020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33020__$1,inst_33018);
} else {
if((state_val_33021 === (12))){
var state_33020__$1 = state_33020;
var statearr_33061_33115 = state_33020__$1;
(statearr_33061_33115[(2)] = false);

(statearr_33061_33115[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (2))){
var state_33020__$1 = state_33020;
var statearr_33062_33116 = state_33020__$1;
(statearr_33062_33116[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (23))){
var inst_32959 = (state_33020[(9)]);
var inst_32973 = (inst_32959.cljs$core$IFn$_invoke$arity$1 ? inst_32959.cljs$core$IFn$_invoke$arity$1(null) : inst_32959.call(null,null));
var state_33020__$1 = state_33020;
var statearr_33064_33117 = state_33020__$1;
(statearr_33064_33117[(2)] = inst_32973);

(statearr_33064_33117[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (19))){
var inst_32951 = (state_33020[(8)]);
var inst_32966 = (state_33020[(2)]);
var state_33020__$1 = (function (){var statearr_33065 = state_33020;
(statearr_33065[(24)] = inst_32966);

return statearr_33065;
})();
if(cljs.core.truth_(inst_32951)){
var statearr_33066_33118 = state_33020__$1;
(statearr_33066_33118[(1)] = (20));

} else {
var statearr_33067_33119 = state_33020__$1;
(statearr_33067_33119[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (11))){
var state_33020__$1 = state_33020;
var statearr_33068_33120 = state_33020__$1;
(statearr_33068_33120[(2)] = true);

(statearr_33068_33120[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (9))){
var state_33020__$1 = state_33020;
var statearr_33069_33121 = state_33020__$1;
(statearr_33069_33121[(2)] = false);

(statearr_33069_33121[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (5))){
var state_33020__$1 = state_33020;
var statearr_33070_33122 = state_33020__$1;
(statearr_33070_33122[(2)] = null);

(statearr_33070_33122[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (14))){
var inst_32929 = (state_33020[(7)]);
var inst_32946 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32929);
var state_33020__$1 = state_33020;
var statearr_33071_33123 = state_33020__$1;
(statearr_33071_33123[(2)] = inst_32946);

(statearr_33071_33123[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (26))){
var inst_32954 = (state_33020[(14)]);
var inst_32978 = grid.setColumns(inst_32954);
var inst_32979 = hatti.views.table.resizeColumns(grid);
var inst_32980 = grid.render();
var state_33020__$1 = (function (){var statearr_33072 = state_33020;
(statearr_33072[(25)] = inst_32978);

(statearr_33072[(26)] = inst_32979);

return statearr_33072;
})();
var statearr_33073_33124 = state_33020__$1;
(statearr_33073_33124[(2)] = inst_32980);

(statearr_33073_33124[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (16))){
var inst_32949 = (state_33020[(12)]);
var inst_32953 = (state_33020[(13)]);
var inst_32951 = (state_33020[(8)]);
var inst_32959 = (state_33020[(9)]);
var inst_32954 = (state_33020[(14)]);
var inst_32929 = (state_33020[(7)]);
var inst_32952 = (state_33020[(16)]);
var inst_32950 = (state_33020[(17)]);
var inst_32955 = (state_33020[(10)]);
var inst_32949__$1 = (state_33020[(2)]);
var inst_32950__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32949__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_32951__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32949__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_32952__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32949__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_32953__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32949__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_32954__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32949__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_32955__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32949__$1,cljs.core.cst$kw$re_DASH_render);
var inst_32956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32957 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_32958 = (new cljs.core.PersistentVector(null,3,(5),inst_32956,inst_32957,null));
var inst_32959__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_32958);
var inst_32960 = (function (){var e = inst_32929;
var map__32927 = inst_32949__$1;
var submission_to_rank = inst_32950__$1;
var submission_clicked = inst_32951__$1;
var submission_unclicked = inst_32952__$1;
var filter_by = inst_32953__$1;
var new_columns = inst_32954__$1;
var re_render = inst_32955__$1;
var update_data_BANG_ = inst_32959__$1;
return ((function (e,map__32927,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_32949,inst_32953,inst_32951,inst_32959,inst_32954,inst_32929,inst_32952,inst_32950,inst_32955,inst_32949__$1,inst_32950__$1,inst_32951__$1,inst_32952__$1,inst_32953__$1,inst_32954__$1,inst_32955__$1,inst_32956,inst_32957,inst_32958,inst_32959__$1,state_val_33021,c__8400__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (e,map__32927,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_32949,inst_32953,inst_32951,inst_32959,inst_32954,inst_32929,inst_32952,inst_32950,inst_32955,inst_32949__$1,inst_32950__$1,inst_32951__$1,inst_32952__$1,inst_32953__$1,inst_32954__$1,inst_32955__$1,inst_32956,inst_32957,inst_32958,inst_32959__$1,state_val_33021,c__8400__auto__,event_chan){
return (function (p1__32759_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__32759_SHARP_,field));
});})(e,map__32927,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_32949,inst_32953,inst_32951,inst_32959,inst_32954,inst_32929,inst_32952,inst_32950,inst_32955,inst_32949__$1,inst_32950__$1,inst_32951__$1,inst_32952__$1,inst_32953__$1,inst_32954__$1,inst_32955__$1,inst_32956,inst_32957,inst_32958,inst_32959__$1,state_val_33021,c__8400__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(e,map__32927,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_32949,inst_32953,inst_32951,inst_32959,inst_32954,inst_32929,inst_32952,inst_32950,inst_32955,inst_32949__$1,inst_32950__$1,inst_32951__$1,inst_32952__$1,inst_32953__$1,inst_32954__$1,inst_32955__$1,inst_32956,inst_32957,inst_32958,inst_32959__$1,state_val_33021,c__8400__auto__,event_chan))
})();
var state_33020__$1 = (function (){var statearr_33074 = state_33020;
(statearr_33074[(12)] = inst_32949__$1);

(statearr_33074[(13)] = inst_32953__$1);

(statearr_33074[(8)] = inst_32951__$1);

(statearr_33074[(9)] = inst_32959__$1);

(statearr_33074[(14)] = inst_32954__$1);

(statearr_33074[(15)] = inst_32960);

(statearr_33074[(16)] = inst_32952__$1);

(statearr_33074[(17)] = inst_32950__$1);

(statearr_33074[(10)] = inst_32955__$1);

return statearr_33074;
})();
if(cljs.core.truth_(inst_32950__$1)){
var statearr_33075_33125 = state_33020__$1;
(statearr_33075_33125[(1)] = (17));

} else {
var statearr_33076_33126 = state_33020__$1;
(statearr_33076_33126[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (30))){
var state_33020__$1 = state_33020;
var statearr_33077_33127 = state_33020__$1;
(statearr_33077_33127[(2)] = null);

(statearr_33077_33127[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (10))){
var inst_32944 = (state_33020[(2)]);
var state_33020__$1 = state_33020;
if(cljs.core.truth_(inst_32944)){
var statearr_33078_33128 = state_33020__$1;
(statearr_33078_33128[(1)] = (14));

} else {
var statearr_33079_33129 = state_33020__$1;
(statearr_33079_33129[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (18))){
var state_33020__$1 = state_33020;
var statearr_33080_33130 = state_33020__$1;
(statearr_33080_33130[(2)] = null);

(statearr_33080_33130[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (8))){
var inst_32929 = (state_33020[(7)]);
var inst_32934 = inst_32929.cljs$lang$protocol_mask$partition0$;
var inst_32935 = (inst_32934 & (64));
var inst_32936 = inst_32929.cljs$core$ISeq$;
var inst_32937 = (inst_32935) || (inst_32936);
var state_33020__$1 = state_33020;
if(cljs.core.truth_(inst_32937)){
var statearr_33081_33131 = state_33020__$1;
(statearr_33081_33131[(1)] = (11));

} else {
var statearr_33082_33132 = state_33020__$1;
(statearr_33082_33132[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto__,event_chan))
;
return ((function (switch__8335__auto__,c__8400__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8336__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8336__auto____0 = (function (){
var statearr_33086 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33086[(0)] = hatti$views$table$handle_table_events_$_state_machine__8336__auto__);

(statearr_33086[(1)] = (1));

return statearr_33086;
});
var hatti$views$table$handle_table_events_$_state_machine__8336__auto____1 = (function (state_33020){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_33020);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e33087){if((e33087 instanceof Object)){
var ex__8339__auto__ = e33087;
var statearr_33088_33133 = state_33020;
(statearr_33088_33133[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33020);

return cljs.core.cst$kw$recur;
} else {
throw e33087;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__33134 = state_33020;
state_33020 = G__33134;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8336__auto__ = function(state_33020){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8336__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8336__auto____1.call(this,state_33020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8336__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8336__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__,event_chan))
})();
var state__8402__auto__ = (function (){var statearr_33089 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_33089[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_33089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto__,event_chan))
);

return c__8400__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__33145(s__33146){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__33146__$1 = s__33146;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__33146__$1);
if(temp__4425__auto__){
var s__33146__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33146__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__33146__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__33148 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__33147 = (0);
while(true){
if((i__33147 < size__5340__auto__)){
var vec__33153 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__33147);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33153,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33153,(1),null);
cljs.core.chunk_append(b__33148,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__33147,vec__33153,k,v,c__5339__auto__,size__5340__auto__,b__33148,s__33146__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__33147,vec__33153,k,v,c__5339__auto__,size__5340__auto__,b__33148,s__33146__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__33155 = (i__33147 + (1));
i__33147 = G__33155;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33148),hatti$views$table$render_options_$_iter__33145(cljs.core.chunk_rest(s__33146__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33148),null);
}
} else {
var vec__33154 = cljs.core.first(s__33146__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33154,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33154,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__33154,k,v,s__33146__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__33154,k,v,s__33146__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__33145(cljs.core.rest(s__33146__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table33157 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table33157 = (function (_,owner,meta33158){
this._ = _;
this.owner = owner;
this.meta33158 = meta33158;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table33157.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33159,meta33158__$1){
var self__ = this;
var _33159__$1 = this;
return (new hatti.views.table.t_hatti$views$table33157(self__._,self__.owner,meta33158__$1));
});

hatti.views.table.t_hatti$views$table33157.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33159){
var self__ = this;
var _33159__$1 = this;
return self__.meta33158;
});

hatti.views.table.t_hatti$views$table33157.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table33157.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table33157.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table33157.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__33160){
var self__ = this;
var map__33161 = p__33160;
var map__33161__$1 = ((((!((map__33161 == null)))?((((map__33161.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33161.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33161):map__33161);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33161__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33161__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__33163 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__33163__$1 = ((((!((map__33163 == null)))?((((map__33163.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33163.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33163):map__33163);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33163__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__33163,map__33163__$1,flat_form,new_language,___$2,map__33161,map__33161__$1,name_or_label,language){
return (function (p1__33156_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns(flat_form,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__33156_SHARP_),new_language)], null));
});})(options,map__33163,map__33163__$1,flat_form,new_language,___$2,map__33161,map__33161__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__33172 = {"className": "label-changer"};
var G__33173 = (function (){var G__33175 = {"className": "label-changer-label"};
var G__33176 = "Show:";
return React.DOM.span(G__33175,G__33176);
})();
var G__33174 = (function (){var G__33177 = {"id": "header-display-dropdown", "className": "drop-hover"};
var G__33178 = (function (){var attrs33167 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs33167))?sablono.interpreter.attributes(attrs33167):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs33167))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__33180 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__33180);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs33167),(function (){var G__33181 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__33181);
})()], null))));
})();
var G__33179 = (function (){var G__33182 = {"className": "submenu no-dot"};
var G__33183 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__33182,G__33183);
})();
return React.DOM.div(G__33177,G__33178,G__33179);
})();
return React.DOM.div(G__33172,G__33173,G__33174);
});

hatti.views.table.t_hatti$views$table33157.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta33158], null);
});

hatti.views.table.t_hatti$views$table33157.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table33157.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table33157";

hatti.views.table.t_hatti$views$table33157.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table33157");
});

hatti.views.table.__GT_t_hatti$views$table33157 = (function hatti$views$table$__GT_t_hatti$views$table33157(___$1,owner__$1,meta33158){
return (new hatti.views.table.t_hatti$views$table33157(___$1,owner__$1,meta33158));
});

}

return (new hatti.views.table.t_hatti$views$table33157(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__8400__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto__,query){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__,query){
return (function (state_33226){
var state_val_33227 = (state_33226[(1)]);
if((state_val_33227 === (1))){
var inst_33212 = cljs.core.async.timeout((150));
var state_33226__$1 = state_33226;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33226__$1,(2),inst_33212);
} else {
if((state_val_33227 === (2))){
var inst_33214 = (state_33226[(2)]);
var inst_33215 = input.value;
var inst_33216 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_33215);
var state_33226__$1 = (function (){var statearr_33228 = state_33226;
(statearr_33228[(7)] = inst_33214);

return statearr_33228;
})();
if(inst_33216){
var statearr_33229_33240 = state_33226__$1;
(statearr_33229_33240[(1)] = (3));

} else {
var statearr_33230_33241 = state_33226__$1;
(statearr_33230_33241[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33227 === (3))){
var inst_33218 = [query_event_key];
var inst_33219 = [query];
var inst_33220 = cljs.core.PersistentHashMap.fromArrays(inst_33218,inst_33219);
var inst_33221 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_33220);
var state_33226__$1 = state_33226;
var statearr_33231_33242 = state_33226__$1;
(statearr_33231_33242[(2)] = inst_33221);

(statearr_33231_33242[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33227 === (4))){
var state_33226__$1 = state_33226;
var statearr_33232_33243 = state_33226__$1;
(statearr_33232_33243[(2)] = null);

(statearr_33232_33243[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33227 === (5))){
var inst_33224 = (state_33226[(2)]);
var state_33226__$1 = state_33226;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33226__$1,inst_33224);
} else {
return null;
}
}
}
}
}
});})(c__8400__auto__,query))
;
return ((function (switch__8335__auto__,c__8400__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__8336__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__8336__auto____0 = (function (){
var statearr_33236 = [null,null,null,null,null,null,null,null];
(statearr_33236[(0)] = hatti$views$table$delayed_search_$_state_machine__8336__auto__);

(statearr_33236[(1)] = (1));

return statearr_33236;
});
var hatti$views$table$delayed_search_$_state_machine__8336__auto____1 = (function (state_33226){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_33226);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e33237){if((e33237 instanceof Object)){
var ex__8339__auto__ = e33237;
var statearr_33238_33244 = state_33226;
(statearr_33238_33244[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33226);

return cljs.core.cst$kw$recur;
} else {
throw e33237;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__33245 = state_33226;
state_33226 = G__33245;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__8336__auto__ = function(state_33226){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__8336__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__8336__auto____1.call(this,state_33226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__8336__auto____0;
hatti$views$table$delayed_search_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__8336__auto____1;
return hatti$views$table$delayed_search_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__,query))
})();
var state__8402__auto__ = (function (){var statearr_33239 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_33239[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_33239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto__,query))
);

return c__8400__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table33247 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table33247 = (function (_,owner,meta33248){
this._ = _;
this.owner = owner;
this.meta33248 = meta33248;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table33247.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33249,meta33248__$1){
var self__ = this;
var _33249__$1 = this;
return (new hatti.views.table.t_hatti$views$table33247(self__._,self__.owner,meta33248__$1));
});

hatti.views.table.t_hatti$views$table33247.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33249){
var self__ = this;
var _33249__$1 = this;
return self__.meta33248;
});

hatti.views.table.t_hatti$views$table33247.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table33247.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
var G__33252 = {"className": "table-search"};
var G__33253 = (function (){var G__33255 = {"className": "fa fa-search"};
return React.DOM.i(G__33255);
})();
var G__33254 = (function (){var G__33256 = {"type": "text", "placeholder": "Search", "onChange": ((function (G__33252,G__33253,this__6567__auto____$1){
return (function (p1__33246_SHARP_){
return hatti.views.table.delayed_search(p1__33246_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__33252,G__33253,this__6567__auto____$1))
};
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__33256) : sablono.interpreter.input.call(null,G__33256));
})();
return React.DOM.div(G__33252,G__33253,G__33254);
});

hatti.views.table.t_hatti$views$table33247.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta33248], null);
});

hatti.views.table.t_hatti$views$table33247.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table33247.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table33247";

hatti.views.table.t_hatti$views$table33247.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table33247");
});

hatti.views.table.__GT_t_hatti$views$table33247 = (function hatti$views$table$__GT_t_hatti$views$table33247(___$1,owner__$1,meta33248){
return (new hatti.views.table.t_hatti$views$table33247(___$1,owner__$1,meta33248));
});

}

return (new hatti.views.table.t_hatti$views$table33247(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table33257 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table33257 = (function (app_state,owner,meta33258){
this.app_state = app_state;
this.owner = owner;
this.meta33258 = meta33258;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table33257.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33259,meta33258__$1){
var self__ = this;
var _33259__$1 = this;
return (new hatti.views.table.t_hatti$views$table33257(self__.app_state,self__.owner,meta33258__$1));
});

hatti.views.table.t_hatti$views$table33257.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33259){
var self__ = this;
var _33259__$1 = this;
return self__.meta33258;
});

hatti.views.table.t_hatti$views$table33257.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table33257.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
var G__33262 = {"className": "topbar"};
var G__33263 = (function (){var G__33267 = {"id": hatti.views.table.pager_id};
return React.DOM.div(G__33267);
})();
var G__33264 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,null));
var G__33265 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.app_state));
var G__33266 = (function (){var G__33268 = {"style": {"clear": "both"}};
return React.DOM.div(G__33268);
})();
return React.DOM.div(G__33262,G__33263,G__33264,G__33265,G__33266);
});

hatti.views.table.t_hatti$views$table33257.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta33258], null);
});

hatti.views.table.t_hatti$views$table33257.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table33257.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table33257";

hatti.views.table.t_hatti$views$table33257.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table33257");
});

hatti.views.table.__GT_t_hatti$views$table33257 = (function hatti$views$table$__GT_t_hatti$views$table33257(app_state__$1,owner__$1,meta33258){
return (new hatti.views.table.t_hatti$views$table33257(app_state__$1,owner__$1,meta33258));
});

}

return (new hatti.views.table.t_hatti$views$table33257(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq(data)){
var map__33272 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__33272__$1 = ((((!((map__33272 == null)))?((((map__33272.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33272.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33272):map__33272);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33272__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33272__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__33273 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33273,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33273,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,p__33276){
var map__33277 = p__33276;
var map__33277__$1 = ((((!((map__33277 == null)))?((((map__33277.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33277.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33277):map__33277);
var opts = map__33277__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33277__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

if(typeof hatti.views.table.t_hatti$views$table33279 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table33279 = (function (app_state,owner,p__33276,map__33277,opts,slick_grid_event_handlers,meta33280){
this.app_state = app_state;
this.owner = owner;
this.p__33276 = p__33276;
this.map__33277 = map__33277;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta33280 = meta33280;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table33279.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__33277,map__33277__$1,opts,slick_grid_event_handlers){
return (function (_33281,meta33280__$1){
var self__ = this;
var _33281__$1 = this;
return (new hatti.views.table.t_hatti$views$table33279(self__.app_state,self__.owner,self__.p__33276,self__.map__33277,self__.opts,self__.slick_grid_event_handlers,meta33280__$1));
});})(map__33277,map__33277__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33279.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__33277,map__33277__$1,opts,slick_grid_event_handlers){
return (function (_33281){
var self__ = this;
var _33281__$1 = this;
return self__.meta33280;
});})(map__33277,map__33277__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33279.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table33279.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__33277,map__33277__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null)));
var map__33282 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__33282__$1 = ((((!((map__33282 == null)))?((((map__33282.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33282.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33282):map__33282);
var dataset_info = map__33282__$1;
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33282__$1,cljs.core.cst$kw$num_of_submissions);
var with_info = ((function (no_data_QMARK_,map__33282,map__33282__$1,dataset_info,num_of_submissions,___$2,map__33277,map__33277__$1,opts,slick_grid_event_handlers){
return (function (p1__33275_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__33275_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dataset_DASH_info,dataset_info], null)], 0));
});})(no_data_QMARK_,map__33282,map__33282__$1,dataset_info,num_of_submissions,___$2,map__33277,map__33277__$1,opts,slick_grid_event_handlers))
;
var attrs33284 = om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked], null))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs33284))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs33284], 0))):{"className": "table-view"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs33284))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__33285 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__33286 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__33291 = {"className": "empty-state"};
var G__33292 = "No data";
return React.DOM.span(G__33291,G__33292);
})():(function (){var G__33294 = null;
var G__33295 = (function (){var G__33297 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__33297);
})();
var G__33296 = "Loading...";
return React.DOM.span(G__33294,G__33295,G__33296);
})());
return React.DOM.div(G__33285,G__33286);
})()], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs33284),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__33298 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__33299 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__33304 = {"className": "empty-state"};
var G__33305 = "No data";
return React.DOM.span(G__33304,G__33305);
})():(function (){var G__33307 = null;
var G__33308 = (function (){var G__33310 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__33310);
})();
var G__33309 = "Loading...";
return React.DOM.span(G__33307,G__33308,G__33309);
})());
return React.DOM.div(G__33298,G__33299);
})()], null))));
});})(map__33277,map__33277__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33279.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table33279.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__33277,map__33277__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__33311 = temp__4425__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33311,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33311,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__33277,map__33277__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33279.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table33279.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__33277,map__33277__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__33312 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__33312__$1 = ((((!((map__33312 == null)))?((((map__33312.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33312.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33312):map__33312);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33312__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33312__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__33314 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33314,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33314,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__33277,map__33277__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33279.getBasis = ((function (map__33277,map__33277__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__33276,cljs.core.cst$sym$map__33277,cljs.core.cst$sym$opts,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$meta33280], null);
});})(map__33277,map__33277__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33279.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table33279.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table33279";

hatti.views.table.t_hatti$views$table33279.cljs$lang$ctorPrWriter = ((function (map__33277,map__33277__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table33279");
});})(map__33277,map__33277__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table33279 = ((function (map__33277,map__33277__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table33279(app_state__$1,owner__$1,p__33276__$1,map__33277__$2,opts__$1,slick_grid_event_handlers__$1,meta33280){
return (new hatti.views.table.t_hatti$views$table33279(app_state__$1,owner__$1,p__33276__$1,map__33277__$2,opts__$1,slick_grid_event_handlers__$1,meta33280));
});})(map__33277,map__33277__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table33279(app_state,owner,p__33276,map__33277__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
