// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('inflections.core');
hatti.utils.url = (function hatti$utils$url(var_args){
var args__5634__auto__ = [];
var len__5627__auto___7023 = arguments.length;
var i__5628__auto___7024 = (0);
while(true){
if((i__5628__auto___7024 < len__5627__auto___7023)){
args__5634__auto__.push((arguments[i__5628__auto___7024]));

var G__7025 = (i__5628__auto___7024 + (1));
i__5628__auto___7024 = G__7025;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return clojure.string.join.call(null,"/",args);
});

hatti.utils.url.cljs$lang$maxFixedArity = (0);

hatti.utils.url.cljs$lang$applyTo = (function (seq7022){
return hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq7022));
});
/**
 * Get last parameter form url
 */
hatti.utils.last_url_param = (function hatti$utils$last_url_param(url){
var last_param = cljs.core.last.call(null,clojure.string.split.call(null,[cljs.core.str(url)].join(''),/\//));
return cljs.core.first.call(null,clojure.string.split.call(null,[cljs.core.str(last_param)].join(''),/.json/));
});
/**
 * Convert json to js using JSON.parse
 */
hatti.utils.json__GT_js = (function hatti$utils$json__GT_js(s){
return JSON.parse(s);
});
/**
 * Convert json string to cljs object.
 * Fast, but doesn't preserve keywords.
 */
hatti.utils.json__GT_cljs = (function hatti$utils$json__GT_cljs(s){
return cljs.core.js__GT_clj.call(null,hatti.utils.json__GT_js.call(null,s));
});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
hatti.utils.json__GT_js__GT_cljs = (function hatti$utils$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.call(null,hatti.utils.json__GT_js.call(null,s),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
hatti.utils.format = (function hatti$utils$format(var_args){
var args__5634__auto__ = [];
var len__5627__auto___7028 = arguments.length;
var i__5628__auto___7029 = (0);
while(true){
if((i__5628__auto___7029 < len__5627__auto___7028)){
args__5634__auto__.push((arguments[i__5628__auto___7029]));

var G__7030 = (i__5628__auto___7029 + (1));
i__5628__auto___7029 = G__7030;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.call(null,goog.string.format,fmt,args);
});

hatti.utils.format.cljs$lang$maxFixedArity = (1);

hatti.utils.format.cljs$lang$applyTo = (function (seq7026){
var G__7027 = cljs.core.first.call(null,seq7026);
var seq7026__$1 = cljs.core.next.call(null,seq7026);
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic(G__7027,seq7026__$1);
});
/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
hatti.utils.safe_regex = (function hatti$utils$safe_regex(var_args){
var args__5634__auto__ = [];
var len__5627__auto___7036 = arguments.length;
var i__5628__auto___7037 = (0);
while(true){
if((i__5628__auto___7037 < len__5627__auto___7036)){
args__5634__auto__.push((arguments[i__5628__auto___7037]));

var G__7038 = (i__5628__auto___7037 + (1));
i__5628__auto___7037 = G__7038;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__7033){
var map__7034 = p__7033;
var map__7034__$1 = ((((!((map__7034 == null)))?((((map__7034.cljs$lang$protocol_mask$partition0$ & (64))) || (map__7034.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7034):map__7034);
var ignore_case_QMARK_ = cljs.core.get.call(null,map__7034__$1,new cljs.core.Keyword(null,"ignore-case?","ignore-case?",-956106212),true);
var s__$1 = s.replace(/\/[\-\[\]\\/\{\}\(\)\*\+\?\.\\\^\$\|]\//,"\\$&");
return (new RegExp(s__$1,"i"));

});

hatti.utils.safe_regex.cljs$lang$maxFixedArity = (1);

hatti.utils.safe_regex.cljs$lang$applyTo = (function (seq7031){
var G__7032 = cljs.core.first.call(null,seq7031);
var seq7031__$1 = cljs.core.next.call(null,seq7031);
return hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__7032,seq7031__$1);
});
/**
 * Given a seq, produces a two-el seq. [a b c] => [[0 a] [1 b] [2 c]].
 */
hatti.utils.indexed = (function hatti$utils$indexed(coll){
return cljs.core.map_indexed.call(null,cljs.core.vector,coll);
});
/**
 * Helper function to create a click function that prevents default
 */
hatti.utils.click_fn = (function hatti$utils$click_fn(f){
return (function (event){
event.preventDefault();

return f.call(null);
});
});
/**
 * Create an appropriately pluralized string prefix by number.
 */
hatti.utils.pluralize_number = (function hatti$utils$pluralize_number(number,kind){
return clojure.string.join.call(null," ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [number,((cljs.core._EQ_.call(null,(1),number))?kind:inflections.core.plural.call(null,kind))], null));
});
/**
 * True if substring is a substring of string
 */
hatti.utils.substring_QMARK_ = (function hatti$utils$substring_QMARK_(var_args){
var args7039 = [];
var len__5627__auto___7048 = arguments.length;
var i__5628__auto___7049 = (0);
while(true){
if((i__5628__auto___7049 < len__5627__auto___7048)){
args7039.push((arguments[i__5628__auto___7049]));

var G__7050 = (i__5628__auto___7049 + (1));
i__5628__auto___7049 = G__7050;
continue;
} else {
}
break;
}

var G__7044 = args7039.length;
switch (G__7044) {
case 2:
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args7039.slice((2)),(0)));
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (substring,string){
return cljs.core.complement.call(null,cljs.core.nil_QMARK_).call(null,cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,substring),string));
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,string,p__7045){
var map__7046 = p__7045;
var map__7046__$1 = ((((!((map__7046 == null)))?((((map__7046.cljs$lang$protocol_mask$partition0$ & (64))) || (map__7046.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7046):map__7046);
var case_sensitive_QMARK_ = cljs.core.get.call(null,map__7046__$1,new cljs.core.Keyword(null,"case-sensitive?","case-sensitive?",-2133754107));
if(cljs.core.truth_(case_sensitive_QMARK_)){
return hatti.utils.substring_QMARK_.call(null,substring,string);
} else {
return hatti.utils.substring_QMARK_.call(null,clojure.string.lower_case.call(null,substring),clojure.string.lower_case.call(null,string));
}
});

hatti.utils.substring_QMARK_.cljs$lang$applyTo = (function (seq7040){
var G__7041 = cljs.core.first.call(null,seq7040);
var seq7040__$1 = cljs.core.next.call(null,seq7040);
var G__7042 = cljs.core.first.call(null,seq7040__$1);
var seq7040__$2 = cljs.core.next.call(null,seq7040__$1);
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__7041,G__7042,seq7040__$2);
});

hatti.utils.substring_QMARK_.cljs$lang$maxFixedArity = (2);
hatti.utils.hyphen__GT_camel_case = (function hatti$utils$hyphen__GT_camel_case(source_string){
return clojure.string.replace.call(null,source_string,/(-)(.)/,(function (p1__7052_SHARP_){
var vec__7054 = p1__7052_SHARP_;
var _ = cljs.core.nth.call(null,vec__7054,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__7054,(1),null);
var letter_to_uppercase = cljs.core.nth.call(null,vec__7054,(2),null);
return clojure.string.upper_case.call(null,letter_to_uppercase);
}));
});
