// Compiled by ClojureScript 1.7.145 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async13789 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13789 = (function (fn_handler,f,meta13790){
this.fn_handler = fn_handler;
this.f = f;
this.meta13790 = meta13790;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13789.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13791,meta13790__$1){
var self__ = this;
var _13791__$1 = this;
return (new cljs.core.async.t_cljs$core$async13789(self__.fn_handler,self__.f,meta13790__$1));
});

cljs.core.async.t_cljs$core$async13789.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13791){
var self__ = this;
var _13791__$1 = this;
return self__.meta13790;
});

cljs.core.async.t_cljs$core$async13789.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13789.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async13789.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async13789.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta13790","meta13790",74081486,null)], null);
});

cljs.core.async.t_cljs$core$async13789.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13789.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13789";

cljs.core.async.t_cljs$core$async13789.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async13789");
});

cljs.core.async.__GT_t_cljs$core$async13789 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async13789(fn_handler__$1,f__$1,meta13790){
return (new cljs.core.async.t_cljs$core$async13789(fn_handler__$1,f__$1,meta13790));
});

}

return (new cljs.core.async.t_cljs$core$async13789(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args13794 = [];
var len__5627__auto___13797 = arguments.length;
var i__5628__auto___13798 = (0);
while(true){
if((i__5628__auto___13798 < len__5627__auto___13797)){
args13794.push((arguments[i__5628__auto___13798]));

var G__13799 = (i__5628__auto___13798 + (1));
i__5628__auto___13798 = G__13799;
continue;
} else {
}
break;
}

var G__13796 = args13794.length;
switch (G__13796) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13794.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args13801 = [];
var len__5627__auto___13804 = arguments.length;
var i__5628__auto___13805 = (0);
while(true){
if((i__5628__auto___13805 < len__5627__auto___13804)){
args13801.push((arguments[i__5628__auto___13805]));

var G__13806 = (i__5628__auto___13805 + (1));
i__5628__auto___13805 = G__13806;
continue;
} else {
}
break;
}

var G__13803 = args13801.length;
switch (G__13803) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13801.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_13808 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_13808);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_13808,ret){
return (function (){
return fn1.call(null,val_13808);
});})(val_13808,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args13809 = [];
var len__5627__auto___13812 = arguments.length;
var i__5628__auto___13813 = (0);
while(true){
if((i__5628__auto___13813 < len__5627__auto___13812)){
args13809.push((arguments[i__5628__auto___13813]));

var G__13814 = (i__5628__auto___13813 + (1));
i__5628__auto___13813 = G__13814;
continue;
} else {
}
break;
}

var G__13811 = args13809.length;
switch (G__13811) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13809.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5472__auto___13816 = n;
var x_13817 = (0);
while(true){
if((x_13817 < n__5472__auto___13816)){
(a[x_13817] = (0));

var G__13818 = (x_13817 + (1));
x_13817 = G__13818;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__13819 = (i + (1));
i = G__13819;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async13823 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13823 = (function (alt_flag,flag,meta13824){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta13824 = meta13824;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13823.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_13825,meta13824__$1){
var self__ = this;
var _13825__$1 = this;
return (new cljs.core.async.t_cljs$core$async13823(self__.alt_flag,self__.flag,meta13824__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async13823.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_13825){
var self__ = this;
var _13825__$1 = this;
return self__.meta13824;
});})(flag))
;

cljs.core.async.t_cljs$core$async13823.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13823.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async13823.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async13823.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta13824","meta13824",34801754,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async13823.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13823.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13823";

cljs.core.async.t_cljs$core$async13823.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async13823");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async13823 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async13823(alt_flag__$1,flag__$1,meta13824){
return (new cljs.core.async.t_cljs$core$async13823(alt_flag__$1,flag__$1,meta13824));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async13823(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async13829 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13829 = (function (alt_handler,flag,cb,meta13830){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta13830 = meta13830;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13831,meta13830__$1){
var self__ = this;
var _13831__$1 = this;
return (new cljs.core.async.t_cljs$core$async13829(self__.alt_handler,self__.flag,self__.cb,meta13830__$1));
});

cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13831){
var self__ = this;
var _13831__$1 = this;
return self__.meta13830;
});

cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async13829.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta13830","meta13830",538204164,null)], null);
});

cljs.core.async.t_cljs$core$async13829.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13829.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13829";

cljs.core.async.t_cljs$core$async13829.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async13829");
});

cljs.core.async.__GT_t_cljs$core$async13829 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async13829(alt_handler__$1,flag__$1,cb__$1,meta13830){
return (new cljs.core.async.t_cljs$core$async13829(alt_handler__$1,flag__$1,cb__$1,meta13830));
});

}

return (new cljs.core.async.t_cljs$core$async13829(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13832_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13832_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13833_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13833_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4569__auto__ = wport;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return port;
}
})()], null));
} else {
var G__13834 = (i + (1));
i = G__13834;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4569__auto__ = ret;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4557__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___13840 = arguments.length;
var i__5628__auto___13841 = (0);
while(true){
if((i__5628__auto___13841 < len__5627__auto___13840)){
args__5634__auto__.push((arguments[i__5628__auto___13841]));

var G__13842 = (i__5628__auto___13841 + (1));
i__5628__auto___13841 = G__13842;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__13837){
var map__13838 = p__13837;
var map__13838__$1 = ((((!((map__13838 == null)))?((((map__13838.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13838.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13838):map__13838);
var opts = map__13838__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq13835){
var G__13836 = cljs.core.first.call(null,seq13835);
var seq13835__$1 = cljs.core.next.call(null,seq13835);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13836,seq13835__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args13843 = [];
var len__5627__auto___13893 = arguments.length;
var i__5628__auto___13894 = (0);
while(true){
if((i__5628__auto___13894 < len__5627__auto___13893)){
args13843.push((arguments[i__5628__auto___13894]));

var G__13895 = (i__5628__auto___13894 + (1));
i__5628__auto___13894 = G__13895;
continue;
} else {
}
break;
}

var G__13845 = args13843.length;
switch (G__13845) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13843.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__7694__auto___13897 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___13897){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___13897){
return (function (state_13869){
var state_val_13870 = (state_13869[(1)]);
if((state_val_13870 === (7))){
var inst_13865 = (state_13869[(2)]);
var state_13869__$1 = state_13869;
var statearr_13871_13898 = state_13869__$1;
(statearr_13871_13898[(2)] = inst_13865);

(statearr_13871_13898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13870 === (1))){
var state_13869__$1 = state_13869;
var statearr_13872_13899 = state_13869__$1;
(statearr_13872_13899[(2)] = null);

(statearr_13872_13899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13870 === (4))){
var inst_13848 = (state_13869[(7)]);
var inst_13848__$1 = (state_13869[(2)]);
var inst_13849 = (inst_13848__$1 == null);
var state_13869__$1 = (function (){var statearr_13873 = state_13869;
(statearr_13873[(7)] = inst_13848__$1);

return statearr_13873;
})();
if(cljs.core.truth_(inst_13849)){
var statearr_13874_13900 = state_13869__$1;
(statearr_13874_13900[(1)] = (5));

} else {
var statearr_13875_13901 = state_13869__$1;
(statearr_13875_13901[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13870 === (13))){
var state_13869__$1 = state_13869;
var statearr_13876_13902 = state_13869__$1;
(statearr_13876_13902[(2)] = null);

(statearr_13876_13902[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13870 === (6))){
var inst_13848 = (state_13869[(7)]);
var state_13869__$1 = state_13869;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13869__$1,(11),to,inst_13848);
} else {
if((state_val_13870 === (3))){
var inst_13867 = (state_13869[(2)]);
var state_13869__$1 = state_13869;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13869__$1,inst_13867);
} else {
if((state_val_13870 === (12))){
var state_13869__$1 = state_13869;
var statearr_13877_13903 = state_13869__$1;
(statearr_13877_13903[(2)] = null);

(statearr_13877_13903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13870 === (2))){
var state_13869__$1 = state_13869;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13869__$1,(4),from);
} else {
if((state_val_13870 === (11))){
var inst_13858 = (state_13869[(2)]);
var state_13869__$1 = state_13869;
if(cljs.core.truth_(inst_13858)){
var statearr_13878_13904 = state_13869__$1;
(statearr_13878_13904[(1)] = (12));

} else {
var statearr_13879_13905 = state_13869__$1;
(statearr_13879_13905[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13870 === (9))){
var state_13869__$1 = state_13869;
var statearr_13880_13906 = state_13869__$1;
(statearr_13880_13906[(2)] = null);

(statearr_13880_13906[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13870 === (5))){
var state_13869__$1 = state_13869;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13881_13907 = state_13869__$1;
(statearr_13881_13907[(1)] = (8));

} else {
var statearr_13882_13908 = state_13869__$1;
(statearr_13882_13908[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13870 === (14))){
var inst_13863 = (state_13869[(2)]);
var state_13869__$1 = state_13869;
var statearr_13883_13909 = state_13869__$1;
(statearr_13883_13909[(2)] = inst_13863);

(statearr_13883_13909[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13870 === (10))){
var inst_13855 = (state_13869[(2)]);
var state_13869__$1 = state_13869;
var statearr_13884_13910 = state_13869__$1;
(statearr_13884_13910[(2)] = inst_13855);

(statearr_13884_13910[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13870 === (8))){
var inst_13852 = cljs.core.async.close_BANG_.call(null,to);
var state_13869__$1 = state_13869;
var statearr_13885_13911 = state_13869__$1;
(statearr_13885_13911[(2)] = inst_13852);

(statearr_13885_13911[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___13897))
;
return ((function (switch__7673__auto__,c__7694__auto___13897){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_13889 = [null,null,null,null,null,null,null,null];
(statearr_13889[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_13889[(1)] = (1));

return statearr_13889;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_13869){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_13869);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e13890){if((e13890 instanceof Object)){
var ex__7677__auto__ = e13890;
var statearr_13891_13912 = state_13869;
(statearr_13891_13912[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13869);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13890;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13913 = state_13869;
state_13869 = G__13913;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_13869){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_13869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___13897))
})();
var state__7696__auto__ = (function (){var statearr_13892 = f__7695__auto__.call(null);
(statearr_13892[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___13897);

return statearr_13892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___13897))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14097){
var vec__14098 = p__14097;
var v = cljs.core.nth.call(null,vec__14098,(0),null);
var p = cljs.core.nth.call(null,vec__14098,(1),null);
var job = vec__14098;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__7694__auto___14280 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___14280,res,vec__14098,v,p,job,jobs,results){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___14280,res,vec__14098,v,p,job,jobs,results){
return (function (state_14103){
var state_val_14104 = (state_14103[(1)]);
if((state_val_14104 === (1))){
var state_14103__$1 = state_14103;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14103__$1,(2),res,v);
} else {
if((state_val_14104 === (2))){
var inst_14100 = (state_14103[(2)]);
var inst_14101 = cljs.core.async.close_BANG_.call(null,res);
var state_14103__$1 = (function (){var statearr_14105 = state_14103;
(statearr_14105[(7)] = inst_14100);

return statearr_14105;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14103__$1,inst_14101);
} else {
return null;
}
}
});})(c__7694__auto___14280,res,vec__14098,v,p,job,jobs,results))
;
return ((function (switch__7673__auto__,c__7694__auto___14280,res,vec__14098,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14109 = [null,null,null,null,null,null,null,null];
(statearr_14109[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14109[(1)] = (1));

return statearr_14109;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14103){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14103);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14110){if((e14110 instanceof Object)){
var ex__7677__auto__ = e14110;
var statearr_14111_14281 = state_14103;
(statearr_14111_14281[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14103);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14110;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14282 = state_14103;
state_14103 = G__14282;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14103){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___14280,res,vec__14098,v,p,job,jobs,results))
})();
var state__7696__auto__ = (function (){var statearr_14112 = f__7695__auto__.call(null);
(statearr_14112[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14280);

return statearr_14112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___14280,res,vec__14098,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14113){
var vec__14114 = p__14113;
var v = cljs.core.nth.call(null,vec__14114,(0),null);
var p = cljs.core.nth.call(null,vec__14114,(1),null);
var job = vec__14114;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5472__auto___14283 = n;
var __14284 = (0);
while(true){
if((__14284 < n__5472__auto___14283)){
var G__14115_14285 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14115_14285) {
case "compute":
var c__7694__auto___14287 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__14284,c__7694__auto___14287,G__14115_14285,n__5472__auto___14283,jobs,results,process,async){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (__14284,c__7694__auto___14287,G__14115_14285,n__5472__auto___14283,jobs,results,process,async){
return (function (state_14128){
var state_val_14129 = (state_14128[(1)]);
if((state_val_14129 === (1))){
var state_14128__$1 = state_14128;
var statearr_14130_14288 = state_14128__$1;
(statearr_14130_14288[(2)] = null);

(statearr_14130_14288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (2))){
var state_14128__$1 = state_14128;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14128__$1,(4),jobs);
} else {
if((state_val_14129 === (3))){
var inst_14126 = (state_14128[(2)]);
var state_14128__$1 = state_14128;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14128__$1,inst_14126);
} else {
if((state_val_14129 === (4))){
var inst_14118 = (state_14128[(2)]);
var inst_14119 = process.call(null,inst_14118);
var state_14128__$1 = state_14128;
if(cljs.core.truth_(inst_14119)){
var statearr_14131_14289 = state_14128__$1;
(statearr_14131_14289[(1)] = (5));

} else {
var statearr_14132_14290 = state_14128__$1;
(statearr_14132_14290[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (5))){
var state_14128__$1 = state_14128;
var statearr_14133_14291 = state_14128__$1;
(statearr_14133_14291[(2)] = null);

(statearr_14133_14291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (6))){
var state_14128__$1 = state_14128;
var statearr_14134_14292 = state_14128__$1;
(statearr_14134_14292[(2)] = null);

(statearr_14134_14292[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (7))){
var inst_14124 = (state_14128[(2)]);
var state_14128__$1 = state_14128;
var statearr_14135_14293 = state_14128__$1;
(statearr_14135_14293[(2)] = inst_14124);

(statearr_14135_14293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14284,c__7694__auto___14287,G__14115_14285,n__5472__auto___14283,jobs,results,process,async))
;
return ((function (__14284,switch__7673__auto__,c__7694__auto___14287,G__14115_14285,n__5472__auto___14283,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14139 = [null,null,null,null,null,null,null];
(statearr_14139[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14139[(1)] = (1));

return statearr_14139;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14128){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14128);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14140){if((e14140 instanceof Object)){
var ex__7677__auto__ = e14140;
var statearr_14141_14294 = state_14128;
(statearr_14141_14294[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14128);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14140;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14295 = state_14128;
state_14128 = G__14295;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14128){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(__14284,switch__7673__auto__,c__7694__auto___14287,G__14115_14285,n__5472__auto___14283,jobs,results,process,async))
})();
var state__7696__auto__ = (function (){var statearr_14142 = f__7695__auto__.call(null);
(statearr_14142[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14287);

return statearr_14142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(__14284,c__7694__auto___14287,G__14115_14285,n__5472__auto___14283,jobs,results,process,async))
);


break;
case "async":
var c__7694__auto___14296 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__14284,c__7694__auto___14296,G__14115_14285,n__5472__auto___14283,jobs,results,process,async){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (__14284,c__7694__auto___14296,G__14115_14285,n__5472__auto___14283,jobs,results,process,async){
return (function (state_14155){
var state_val_14156 = (state_14155[(1)]);
if((state_val_14156 === (1))){
var state_14155__$1 = state_14155;
var statearr_14157_14297 = state_14155__$1;
(statearr_14157_14297[(2)] = null);

(statearr_14157_14297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14156 === (2))){
var state_14155__$1 = state_14155;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14155__$1,(4),jobs);
} else {
if((state_val_14156 === (3))){
var inst_14153 = (state_14155[(2)]);
var state_14155__$1 = state_14155;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14155__$1,inst_14153);
} else {
if((state_val_14156 === (4))){
var inst_14145 = (state_14155[(2)]);
var inst_14146 = async.call(null,inst_14145);
var state_14155__$1 = state_14155;
if(cljs.core.truth_(inst_14146)){
var statearr_14158_14298 = state_14155__$1;
(statearr_14158_14298[(1)] = (5));

} else {
var statearr_14159_14299 = state_14155__$1;
(statearr_14159_14299[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14156 === (5))){
var state_14155__$1 = state_14155;
var statearr_14160_14300 = state_14155__$1;
(statearr_14160_14300[(2)] = null);

(statearr_14160_14300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14156 === (6))){
var state_14155__$1 = state_14155;
var statearr_14161_14301 = state_14155__$1;
(statearr_14161_14301[(2)] = null);

(statearr_14161_14301[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14156 === (7))){
var inst_14151 = (state_14155[(2)]);
var state_14155__$1 = state_14155;
var statearr_14162_14302 = state_14155__$1;
(statearr_14162_14302[(2)] = inst_14151);

(statearr_14162_14302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14284,c__7694__auto___14296,G__14115_14285,n__5472__auto___14283,jobs,results,process,async))
;
return ((function (__14284,switch__7673__auto__,c__7694__auto___14296,G__14115_14285,n__5472__auto___14283,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14166 = [null,null,null,null,null,null,null];
(statearr_14166[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14166[(1)] = (1));

return statearr_14166;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14155){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14155);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14167){if((e14167 instanceof Object)){
var ex__7677__auto__ = e14167;
var statearr_14168_14303 = state_14155;
(statearr_14168_14303[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14155);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14167;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14304 = state_14155;
state_14155 = G__14304;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14155){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(__14284,switch__7673__auto__,c__7694__auto___14296,G__14115_14285,n__5472__auto___14283,jobs,results,process,async))
})();
var state__7696__auto__ = (function (){var statearr_14169 = f__7695__auto__.call(null);
(statearr_14169[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14296);

return statearr_14169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(__14284,c__7694__auto___14296,G__14115_14285,n__5472__auto___14283,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__14305 = (__14284 + (1));
__14284 = G__14305;
continue;
} else {
}
break;
}

var c__7694__auto___14306 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___14306,jobs,results,process,async){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___14306,jobs,results,process,async){
return (function (state_14191){
var state_val_14192 = (state_14191[(1)]);
if((state_val_14192 === (1))){
var state_14191__$1 = state_14191;
var statearr_14193_14307 = state_14191__$1;
(statearr_14193_14307[(2)] = null);

(statearr_14193_14307[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14192 === (2))){
var state_14191__$1 = state_14191;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14191__$1,(4),from);
} else {
if((state_val_14192 === (3))){
var inst_14189 = (state_14191[(2)]);
var state_14191__$1 = state_14191;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14191__$1,inst_14189);
} else {
if((state_val_14192 === (4))){
var inst_14172 = (state_14191[(7)]);
var inst_14172__$1 = (state_14191[(2)]);
var inst_14173 = (inst_14172__$1 == null);
var state_14191__$1 = (function (){var statearr_14194 = state_14191;
(statearr_14194[(7)] = inst_14172__$1);

return statearr_14194;
})();
if(cljs.core.truth_(inst_14173)){
var statearr_14195_14308 = state_14191__$1;
(statearr_14195_14308[(1)] = (5));

} else {
var statearr_14196_14309 = state_14191__$1;
(statearr_14196_14309[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14192 === (5))){
var inst_14175 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14191__$1 = state_14191;
var statearr_14197_14310 = state_14191__$1;
(statearr_14197_14310[(2)] = inst_14175);

(statearr_14197_14310[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14192 === (6))){
var inst_14172 = (state_14191[(7)]);
var inst_14177 = (state_14191[(8)]);
var inst_14177__$1 = cljs.core.async.chan.call(null,(1));
var inst_14178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14179 = [inst_14172,inst_14177__$1];
var inst_14180 = (new cljs.core.PersistentVector(null,2,(5),inst_14178,inst_14179,null));
var state_14191__$1 = (function (){var statearr_14198 = state_14191;
(statearr_14198[(8)] = inst_14177__$1);

return statearr_14198;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14191__$1,(8),jobs,inst_14180);
} else {
if((state_val_14192 === (7))){
var inst_14187 = (state_14191[(2)]);
var state_14191__$1 = state_14191;
var statearr_14199_14311 = state_14191__$1;
(statearr_14199_14311[(2)] = inst_14187);

(statearr_14199_14311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14192 === (8))){
var inst_14177 = (state_14191[(8)]);
var inst_14182 = (state_14191[(2)]);
var state_14191__$1 = (function (){var statearr_14200 = state_14191;
(statearr_14200[(9)] = inst_14182);

return statearr_14200;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14191__$1,(9),results,inst_14177);
} else {
if((state_val_14192 === (9))){
var inst_14184 = (state_14191[(2)]);
var state_14191__$1 = (function (){var statearr_14201 = state_14191;
(statearr_14201[(10)] = inst_14184);

return statearr_14201;
})();
var statearr_14202_14312 = state_14191__$1;
(statearr_14202_14312[(2)] = null);

(statearr_14202_14312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___14306,jobs,results,process,async))
;
return ((function (switch__7673__auto__,c__7694__auto___14306,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14206 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14206[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14206[(1)] = (1));

return statearr_14206;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14191){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14191);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14207){if((e14207 instanceof Object)){
var ex__7677__auto__ = e14207;
var statearr_14208_14313 = state_14191;
(statearr_14208_14313[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14191);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14207;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14314 = state_14191;
state_14191 = G__14314;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14191){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___14306,jobs,results,process,async))
})();
var state__7696__auto__ = (function (){var statearr_14209 = f__7695__auto__.call(null);
(statearr_14209[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14306);

return statearr_14209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___14306,jobs,results,process,async))
);


var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__,jobs,results,process,async){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__,jobs,results,process,async){
return (function (state_14247){
var state_val_14248 = (state_14247[(1)]);
if((state_val_14248 === (7))){
var inst_14243 = (state_14247[(2)]);
var state_14247__$1 = state_14247;
var statearr_14249_14315 = state_14247__$1;
(statearr_14249_14315[(2)] = inst_14243);

(statearr_14249_14315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (20))){
var state_14247__$1 = state_14247;
var statearr_14250_14316 = state_14247__$1;
(statearr_14250_14316[(2)] = null);

(statearr_14250_14316[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (1))){
var state_14247__$1 = state_14247;
var statearr_14251_14317 = state_14247__$1;
(statearr_14251_14317[(2)] = null);

(statearr_14251_14317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (4))){
var inst_14212 = (state_14247[(7)]);
var inst_14212__$1 = (state_14247[(2)]);
var inst_14213 = (inst_14212__$1 == null);
var state_14247__$1 = (function (){var statearr_14252 = state_14247;
(statearr_14252[(7)] = inst_14212__$1);

return statearr_14252;
})();
if(cljs.core.truth_(inst_14213)){
var statearr_14253_14318 = state_14247__$1;
(statearr_14253_14318[(1)] = (5));

} else {
var statearr_14254_14319 = state_14247__$1;
(statearr_14254_14319[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (15))){
var inst_14225 = (state_14247[(8)]);
var state_14247__$1 = state_14247;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14247__$1,(18),to,inst_14225);
} else {
if((state_val_14248 === (21))){
var inst_14238 = (state_14247[(2)]);
var state_14247__$1 = state_14247;
var statearr_14255_14320 = state_14247__$1;
(statearr_14255_14320[(2)] = inst_14238);

(statearr_14255_14320[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (13))){
var inst_14240 = (state_14247[(2)]);
var state_14247__$1 = (function (){var statearr_14256 = state_14247;
(statearr_14256[(9)] = inst_14240);

return statearr_14256;
})();
var statearr_14257_14321 = state_14247__$1;
(statearr_14257_14321[(2)] = null);

(statearr_14257_14321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (6))){
var inst_14212 = (state_14247[(7)]);
var state_14247__$1 = state_14247;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14247__$1,(11),inst_14212);
} else {
if((state_val_14248 === (17))){
var inst_14233 = (state_14247[(2)]);
var state_14247__$1 = state_14247;
if(cljs.core.truth_(inst_14233)){
var statearr_14258_14322 = state_14247__$1;
(statearr_14258_14322[(1)] = (19));

} else {
var statearr_14259_14323 = state_14247__$1;
(statearr_14259_14323[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (3))){
var inst_14245 = (state_14247[(2)]);
var state_14247__$1 = state_14247;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14247__$1,inst_14245);
} else {
if((state_val_14248 === (12))){
var inst_14222 = (state_14247[(10)]);
var state_14247__$1 = state_14247;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14247__$1,(14),inst_14222);
} else {
if((state_val_14248 === (2))){
var state_14247__$1 = state_14247;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14247__$1,(4),results);
} else {
if((state_val_14248 === (19))){
var state_14247__$1 = state_14247;
var statearr_14260_14324 = state_14247__$1;
(statearr_14260_14324[(2)] = null);

(statearr_14260_14324[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (11))){
var inst_14222 = (state_14247[(2)]);
var state_14247__$1 = (function (){var statearr_14261 = state_14247;
(statearr_14261[(10)] = inst_14222);

return statearr_14261;
})();
var statearr_14262_14325 = state_14247__$1;
(statearr_14262_14325[(2)] = null);

(statearr_14262_14325[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (9))){
var state_14247__$1 = state_14247;
var statearr_14263_14326 = state_14247__$1;
(statearr_14263_14326[(2)] = null);

(statearr_14263_14326[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (5))){
var state_14247__$1 = state_14247;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14264_14327 = state_14247__$1;
(statearr_14264_14327[(1)] = (8));

} else {
var statearr_14265_14328 = state_14247__$1;
(statearr_14265_14328[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (14))){
var inst_14225 = (state_14247[(8)]);
var inst_14227 = (state_14247[(11)]);
var inst_14225__$1 = (state_14247[(2)]);
var inst_14226 = (inst_14225__$1 == null);
var inst_14227__$1 = cljs.core.not.call(null,inst_14226);
var state_14247__$1 = (function (){var statearr_14266 = state_14247;
(statearr_14266[(8)] = inst_14225__$1);

(statearr_14266[(11)] = inst_14227__$1);

return statearr_14266;
})();
if(inst_14227__$1){
var statearr_14267_14329 = state_14247__$1;
(statearr_14267_14329[(1)] = (15));

} else {
var statearr_14268_14330 = state_14247__$1;
(statearr_14268_14330[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (16))){
var inst_14227 = (state_14247[(11)]);
var state_14247__$1 = state_14247;
var statearr_14269_14331 = state_14247__$1;
(statearr_14269_14331[(2)] = inst_14227);

(statearr_14269_14331[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (10))){
var inst_14219 = (state_14247[(2)]);
var state_14247__$1 = state_14247;
var statearr_14270_14332 = state_14247__$1;
(statearr_14270_14332[(2)] = inst_14219);

(statearr_14270_14332[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (18))){
var inst_14230 = (state_14247[(2)]);
var state_14247__$1 = state_14247;
var statearr_14271_14333 = state_14247__$1;
(statearr_14271_14333[(2)] = inst_14230);

(statearr_14271_14333[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14248 === (8))){
var inst_14216 = cljs.core.async.close_BANG_.call(null,to);
var state_14247__$1 = state_14247;
var statearr_14272_14334 = state_14247__$1;
(statearr_14272_14334[(2)] = inst_14216);

(statearr_14272_14334[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__,jobs,results,process,async))
;
return ((function (switch__7673__auto__,c__7694__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14276 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14276[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14276[(1)] = (1));

return statearr_14276;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14247){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14247);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14277){if((e14277 instanceof Object)){
var ex__7677__auto__ = e14277;
var statearr_14278_14335 = state_14247;
(statearr_14278_14335[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14247);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14277;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14336 = state_14247;
state_14247 = G__14336;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14247){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__,jobs,results,process,async))
})();
var state__7696__auto__ = (function (){var statearr_14279 = f__7695__auto__.call(null);
(statearr_14279[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_14279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__,jobs,results,process,async))
);

return c__7694__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args14337 = [];
var len__5627__auto___14340 = arguments.length;
var i__5628__auto___14341 = (0);
while(true){
if((i__5628__auto___14341 < len__5627__auto___14340)){
args14337.push((arguments[i__5628__auto___14341]));

var G__14342 = (i__5628__auto___14341 + (1));
i__5628__auto___14341 = G__14342;
continue;
} else {
}
break;
}

var G__14339 = args14337.length;
switch (G__14339) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14337.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args14344 = [];
var len__5627__auto___14347 = arguments.length;
var i__5628__auto___14348 = (0);
while(true){
if((i__5628__auto___14348 < len__5627__auto___14347)){
args14344.push((arguments[i__5628__auto___14348]));

var G__14349 = (i__5628__auto___14348 + (1));
i__5628__auto___14348 = G__14349;
continue;
} else {
}
break;
}

var G__14346 = args14344.length;
switch (G__14346) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14344.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args14351 = [];
var len__5627__auto___14404 = arguments.length;
var i__5628__auto___14405 = (0);
while(true){
if((i__5628__auto___14405 < len__5627__auto___14404)){
args14351.push((arguments[i__5628__auto___14405]));

var G__14406 = (i__5628__auto___14405 + (1));
i__5628__auto___14405 = G__14406;
continue;
} else {
}
break;
}

var G__14353 = args14351.length;
switch (G__14353) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14351.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__7694__auto___14408 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___14408,tc,fc){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___14408,tc,fc){
return (function (state_14379){
var state_val_14380 = (state_14379[(1)]);
if((state_val_14380 === (7))){
var inst_14375 = (state_14379[(2)]);
var state_14379__$1 = state_14379;
var statearr_14381_14409 = state_14379__$1;
(statearr_14381_14409[(2)] = inst_14375);

(statearr_14381_14409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14380 === (1))){
var state_14379__$1 = state_14379;
var statearr_14382_14410 = state_14379__$1;
(statearr_14382_14410[(2)] = null);

(statearr_14382_14410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14380 === (4))){
var inst_14356 = (state_14379[(7)]);
var inst_14356__$1 = (state_14379[(2)]);
var inst_14357 = (inst_14356__$1 == null);
var state_14379__$1 = (function (){var statearr_14383 = state_14379;
(statearr_14383[(7)] = inst_14356__$1);

return statearr_14383;
})();
if(cljs.core.truth_(inst_14357)){
var statearr_14384_14411 = state_14379__$1;
(statearr_14384_14411[(1)] = (5));

} else {
var statearr_14385_14412 = state_14379__$1;
(statearr_14385_14412[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14380 === (13))){
var state_14379__$1 = state_14379;
var statearr_14386_14413 = state_14379__$1;
(statearr_14386_14413[(2)] = null);

(statearr_14386_14413[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14380 === (6))){
var inst_14356 = (state_14379[(7)]);
var inst_14362 = p.call(null,inst_14356);
var state_14379__$1 = state_14379;
if(cljs.core.truth_(inst_14362)){
var statearr_14387_14414 = state_14379__$1;
(statearr_14387_14414[(1)] = (9));

} else {
var statearr_14388_14415 = state_14379__$1;
(statearr_14388_14415[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14380 === (3))){
var inst_14377 = (state_14379[(2)]);
var state_14379__$1 = state_14379;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14379__$1,inst_14377);
} else {
if((state_val_14380 === (12))){
var state_14379__$1 = state_14379;
var statearr_14389_14416 = state_14379__$1;
(statearr_14389_14416[(2)] = null);

(statearr_14389_14416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14380 === (2))){
var state_14379__$1 = state_14379;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14379__$1,(4),ch);
} else {
if((state_val_14380 === (11))){
var inst_14356 = (state_14379[(7)]);
var inst_14366 = (state_14379[(2)]);
var state_14379__$1 = state_14379;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14379__$1,(8),inst_14366,inst_14356);
} else {
if((state_val_14380 === (9))){
var state_14379__$1 = state_14379;
var statearr_14390_14417 = state_14379__$1;
(statearr_14390_14417[(2)] = tc);

(statearr_14390_14417[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14380 === (5))){
var inst_14359 = cljs.core.async.close_BANG_.call(null,tc);
var inst_14360 = cljs.core.async.close_BANG_.call(null,fc);
var state_14379__$1 = (function (){var statearr_14391 = state_14379;
(statearr_14391[(8)] = inst_14359);

return statearr_14391;
})();
var statearr_14392_14418 = state_14379__$1;
(statearr_14392_14418[(2)] = inst_14360);

(statearr_14392_14418[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14380 === (14))){
var inst_14373 = (state_14379[(2)]);
var state_14379__$1 = state_14379;
var statearr_14393_14419 = state_14379__$1;
(statearr_14393_14419[(2)] = inst_14373);

(statearr_14393_14419[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14380 === (10))){
var state_14379__$1 = state_14379;
var statearr_14394_14420 = state_14379__$1;
(statearr_14394_14420[(2)] = fc);

(statearr_14394_14420[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14380 === (8))){
var inst_14368 = (state_14379[(2)]);
var state_14379__$1 = state_14379;
if(cljs.core.truth_(inst_14368)){
var statearr_14395_14421 = state_14379__$1;
(statearr_14395_14421[(1)] = (12));

} else {
var statearr_14396_14422 = state_14379__$1;
(statearr_14396_14422[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___14408,tc,fc))
;
return ((function (switch__7673__auto__,c__7694__auto___14408,tc,fc){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_14400 = [null,null,null,null,null,null,null,null,null];
(statearr_14400[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_14400[(1)] = (1));

return statearr_14400;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_14379){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14379);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14401){if((e14401 instanceof Object)){
var ex__7677__auto__ = e14401;
var statearr_14402_14423 = state_14379;
(statearr_14402_14423[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14379);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14401;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14424 = state_14379;
state_14379 = G__14424;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_14379){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_14379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___14408,tc,fc))
})();
var state__7696__auto__ = (function (){var statearr_14403 = f__7695__auto__.call(null);
(statearr_14403[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14408);

return statearr_14403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___14408,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__){
return (function (state_14471){
var state_val_14472 = (state_14471[(1)]);
if((state_val_14472 === (1))){
var inst_14457 = init;
var state_14471__$1 = (function (){var statearr_14473 = state_14471;
(statearr_14473[(7)] = inst_14457);

return statearr_14473;
})();
var statearr_14474_14489 = state_14471__$1;
(statearr_14474_14489[(2)] = null);

(statearr_14474_14489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14472 === (2))){
var state_14471__$1 = state_14471;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14471__$1,(4),ch);
} else {
if((state_val_14472 === (3))){
var inst_14469 = (state_14471[(2)]);
var state_14471__$1 = state_14471;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14471__$1,inst_14469);
} else {
if((state_val_14472 === (4))){
var inst_14460 = (state_14471[(8)]);
var inst_14460__$1 = (state_14471[(2)]);
var inst_14461 = (inst_14460__$1 == null);
var state_14471__$1 = (function (){var statearr_14475 = state_14471;
(statearr_14475[(8)] = inst_14460__$1);

return statearr_14475;
})();
if(cljs.core.truth_(inst_14461)){
var statearr_14476_14490 = state_14471__$1;
(statearr_14476_14490[(1)] = (5));

} else {
var statearr_14477_14491 = state_14471__$1;
(statearr_14477_14491[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14472 === (5))){
var inst_14457 = (state_14471[(7)]);
var state_14471__$1 = state_14471;
var statearr_14478_14492 = state_14471__$1;
(statearr_14478_14492[(2)] = inst_14457);

(statearr_14478_14492[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14472 === (6))){
var inst_14460 = (state_14471[(8)]);
var inst_14457 = (state_14471[(7)]);
var inst_14464 = f.call(null,inst_14457,inst_14460);
var inst_14457__$1 = inst_14464;
var state_14471__$1 = (function (){var statearr_14479 = state_14471;
(statearr_14479[(7)] = inst_14457__$1);

return statearr_14479;
})();
var statearr_14480_14493 = state_14471__$1;
(statearr_14480_14493[(2)] = null);

(statearr_14480_14493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14472 === (7))){
var inst_14467 = (state_14471[(2)]);
var state_14471__$1 = state_14471;
var statearr_14481_14494 = state_14471__$1;
(statearr_14481_14494[(2)] = inst_14467);

(statearr_14481_14494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__7694__auto__))
;
return ((function (switch__7673__auto__,c__7694__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__7674__auto__ = null;
var cljs$core$async$reduce_$_state_machine__7674__auto____0 = (function (){
var statearr_14485 = [null,null,null,null,null,null,null,null,null];
(statearr_14485[(0)] = cljs$core$async$reduce_$_state_machine__7674__auto__);

(statearr_14485[(1)] = (1));

return statearr_14485;
});
var cljs$core$async$reduce_$_state_machine__7674__auto____1 = (function (state_14471){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14471);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14486){if((e14486 instanceof Object)){
var ex__7677__auto__ = e14486;
var statearr_14487_14495 = state_14471;
(statearr_14487_14495[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14471);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14486;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14496 = state_14471;
state_14471 = G__14496;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__7674__auto__ = function(state_14471){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__7674__auto____1.call(this,state_14471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__7674__auto____0;
cljs$core$async$reduce_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__7674__auto____1;
return cljs$core$async$reduce_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__))
})();
var state__7696__auto__ = (function (){var statearr_14488 = f__7695__auto__.call(null);
(statearr_14488[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_14488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__))
);

return c__7694__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args14497 = [];
var len__5627__auto___14549 = arguments.length;
var i__5628__auto___14550 = (0);
while(true){
if((i__5628__auto___14550 < len__5627__auto___14549)){
args14497.push((arguments[i__5628__auto___14550]));

var G__14551 = (i__5628__auto___14550 + (1));
i__5628__auto___14550 = G__14551;
continue;
} else {
}
break;
}

var G__14499 = args14497.length;
switch (G__14499) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14497.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__){
return (function (state_14524){
var state_val_14525 = (state_14524[(1)]);
if((state_val_14525 === (7))){
var inst_14506 = (state_14524[(2)]);
var state_14524__$1 = state_14524;
var statearr_14526_14553 = state_14524__$1;
(statearr_14526_14553[(2)] = inst_14506);

(statearr_14526_14553[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14525 === (1))){
var inst_14500 = cljs.core.seq.call(null,coll);
var inst_14501 = inst_14500;
var state_14524__$1 = (function (){var statearr_14527 = state_14524;
(statearr_14527[(7)] = inst_14501);

return statearr_14527;
})();
var statearr_14528_14554 = state_14524__$1;
(statearr_14528_14554[(2)] = null);

(statearr_14528_14554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14525 === (4))){
var inst_14501 = (state_14524[(7)]);
var inst_14504 = cljs.core.first.call(null,inst_14501);
var state_14524__$1 = state_14524;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14524__$1,(7),ch,inst_14504);
} else {
if((state_val_14525 === (13))){
var inst_14518 = (state_14524[(2)]);
var state_14524__$1 = state_14524;
var statearr_14529_14555 = state_14524__$1;
(statearr_14529_14555[(2)] = inst_14518);

(statearr_14529_14555[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14525 === (6))){
var inst_14509 = (state_14524[(2)]);
var state_14524__$1 = state_14524;
if(cljs.core.truth_(inst_14509)){
var statearr_14530_14556 = state_14524__$1;
(statearr_14530_14556[(1)] = (8));

} else {
var statearr_14531_14557 = state_14524__$1;
(statearr_14531_14557[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14525 === (3))){
var inst_14522 = (state_14524[(2)]);
var state_14524__$1 = state_14524;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14524__$1,inst_14522);
} else {
if((state_val_14525 === (12))){
var state_14524__$1 = state_14524;
var statearr_14532_14558 = state_14524__$1;
(statearr_14532_14558[(2)] = null);

(statearr_14532_14558[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14525 === (2))){
var inst_14501 = (state_14524[(7)]);
var state_14524__$1 = state_14524;
if(cljs.core.truth_(inst_14501)){
var statearr_14533_14559 = state_14524__$1;
(statearr_14533_14559[(1)] = (4));

} else {
var statearr_14534_14560 = state_14524__$1;
(statearr_14534_14560[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14525 === (11))){
var inst_14515 = cljs.core.async.close_BANG_.call(null,ch);
var state_14524__$1 = state_14524;
var statearr_14535_14561 = state_14524__$1;
(statearr_14535_14561[(2)] = inst_14515);

(statearr_14535_14561[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14525 === (9))){
var state_14524__$1 = state_14524;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14536_14562 = state_14524__$1;
(statearr_14536_14562[(1)] = (11));

} else {
var statearr_14537_14563 = state_14524__$1;
(statearr_14537_14563[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14525 === (5))){
var inst_14501 = (state_14524[(7)]);
var state_14524__$1 = state_14524;
var statearr_14538_14564 = state_14524__$1;
(statearr_14538_14564[(2)] = inst_14501);

(statearr_14538_14564[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14525 === (10))){
var inst_14520 = (state_14524[(2)]);
var state_14524__$1 = state_14524;
var statearr_14539_14565 = state_14524__$1;
(statearr_14539_14565[(2)] = inst_14520);

(statearr_14539_14565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14525 === (8))){
var inst_14501 = (state_14524[(7)]);
var inst_14511 = cljs.core.next.call(null,inst_14501);
var inst_14501__$1 = inst_14511;
var state_14524__$1 = (function (){var statearr_14540 = state_14524;
(statearr_14540[(7)] = inst_14501__$1);

return statearr_14540;
})();
var statearr_14541_14566 = state_14524__$1;
(statearr_14541_14566[(2)] = null);

(statearr_14541_14566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__))
;
return ((function (switch__7673__auto__,c__7694__auto__){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_14545 = [null,null,null,null,null,null,null,null];
(statearr_14545[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_14545[(1)] = (1));

return statearr_14545;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_14524){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14524);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14546){if((e14546 instanceof Object)){
var ex__7677__auto__ = e14546;
var statearr_14547_14567 = state_14524;
(statearr_14547_14567[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14524);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14546;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14568 = state_14524;
state_14524 = G__14568;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_14524){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_14524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__))
})();
var state__7696__auto__ = (function (){var statearr_14548 = f__7695__auto__.call(null);
(statearr_14548[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_14548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__))
);

return c__7694__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5224__auto__ = (((_ == null))?null:_);
var m__5225__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,_);
} else {
var m__5225__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async14790 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14790 = (function (mult,ch,cs,meta14791){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta14791 = meta14791;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14790.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_14792,meta14791__$1){
var self__ = this;
var _14792__$1 = this;
return (new cljs.core.async.t_cljs$core$async14790(self__.mult,self__.ch,self__.cs,meta14791__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async14790.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_14792){
var self__ = this;
var _14792__$1 = this;
return self__.meta14791;
});})(cs))
;

cljs.core.async.t_cljs$core$async14790.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async14790.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async14790.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async14790.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14790.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14790.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14790.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta14791","meta14791",-329478967,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async14790.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14790.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14790";

cljs.core.async.t_cljs$core$async14790.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async14790");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async14790 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async14790(mult__$1,ch__$1,cs__$1,meta14791){
return (new cljs.core.async.t_cljs$core$async14790(mult__$1,ch__$1,cs__$1,meta14791));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async14790(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__7694__auto___15011 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15011,cs,m,dchan,dctr,done){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15011,cs,m,dchan,dctr,done){
return (function (state_14923){
var state_val_14924 = (state_14923[(1)]);
if((state_val_14924 === (7))){
var inst_14919 = (state_14923[(2)]);
var state_14923__$1 = state_14923;
var statearr_14925_15012 = state_14923__$1;
(statearr_14925_15012[(2)] = inst_14919);

(statearr_14925_15012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (20))){
var inst_14824 = (state_14923[(7)]);
var inst_14834 = cljs.core.first.call(null,inst_14824);
var inst_14835 = cljs.core.nth.call(null,inst_14834,(0),null);
var inst_14836 = cljs.core.nth.call(null,inst_14834,(1),null);
var state_14923__$1 = (function (){var statearr_14926 = state_14923;
(statearr_14926[(8)] = inst_14835);

return statearr_14926;
})();
if(cljs.core.truth_(inst_14836)){
var statearr_14927_15013 = state_14923__$1;
(statearr_14927_15013[(1)] = (22));

} else {
var statearr_14928_15014 = state_14923__$1;
(statearr_14928_15014[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (27))){
var inst_14864 = (state_14923[(9)]);
var inst_14866 = (state_14923[(10)]);
var inst_14795 = (state_14923[(11)]);
var inst_14871 = (state_14923[(12)]);
var inst_14871__$1 = cljs.core._nth.call(null,inst_14864,inst_14866);
var inst_14872 = cljs.core.async.put_BANG_.call(null,inst_14871__$1,inst_14795,done);
var state_14923__$1 = (function (){var statearr_14929 = state_14923;
(statearr_14929[(12)] = inst_14871__$1);

return statearr_14929;
})();
if(cljs.core.truth_(inst_14872)){
var statearr_14930_15015 = state_14923__$1;
(statearr_14930_15015[(1)] = (30));

} else {
var statearr_14931_15016 = state_14923__$1;
(statearr_14931_15016[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (1))){
var state_14923__$1 = state_14923;
var statearr_14932_15017 = state_14923__$1;
(statearr_14932_15017[(2)] = null);

(statearr_14932_15017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (24))){
var inst_14824 = (state_14923[(7)]);
var inst_14841 = (state_14923[(2)]);
var inst_14842 = cljs.core.next.call(null,inst_14824);
var inst_14804 = inst_14842;
var inst_14805 = null;
var inst_14806 = (0);
var inst_14807 = (0);
var state_14923__$1 = (function (){var statearr_14933 = state_14923;
(statearr_14933[(13)] = inst_14804);

(statearr_14933[(14)] = inst_14805);

(statearr_14933[(15)] = inst_14841);

(statearr_14933[(16)] = inst_14806);

(statearr_14933[(17)] = inst_14807);

return statearr_14933;
})();
var statearr_14934_15018 = state_14923__$1;
(statearr_14934_15018[(2)] = null);

(statearr_14934_15018[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (39))){
var state_14923__$1 = state_14923;
var statearr_14938_15019 = state_14923__$1;
(statearr_14938_15019[(2)] = null);

(statearr_14938_15019[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (4))){
var inst_14795 = (state_14923[(11)]);
var inst_14795__$1 = (state_14923[(2)]);
var inst_14796 = (inst_14795__$1 == null);
var state_14923__$1 = (function (){var statearr_14939 = state_14923;
(statearr_14939[(11)] = inst_14795__$1);

return statearr_14939;
})();
if(cljs.core.truth_(inst_14796)){
var statearr_14940_15020 = state_14923__$1;
(statearr_14940_15020[(1)] = (5));

} else {
var statearr_14941_15021 = state_14923__$1;
(statearr_14941_15021[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (15))){
var inst_14804 = (state_14923[(13)]);
var inst_14805 = (state_14923[(14)]);
var inst_14806 = (state_14923[(16)]);
var inst_14807 = (state_14923[(17)]);
var inst_14820 = (state_14923[(2)]);
var inst_14821 = (inst_14807 + (1));
var tmp14935 = inst_14804;
var tmp14936 = inst_14805;
var tmp14937 = inst_14806;
var inst_14804__$1 = tmp14935;
var inst_14805__$1 = tmp14936;
var inst_14806__$1 = tmp14937;
var inst_14807__$1 = inst_14821;
var state_14923__$1 = (function (){var statearr_14942 = state_14923;
(statearr_14942[(18)] = inst_14820);

(statearr_14942[(13)] = inst_14804__$1);

(statearr_14942[(14)] = inst_14805__$1);

(statearr_14942[(16)] = inst_14806__$1);

(statearr_14942[(17)] = inst_14807__$1);

return statearr_14942;
})();
var statearr_14943_15022 = state_14923__$1;
(statearr_14943_15022[(2)] = null);

(statearr_14943_15022[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (21))){
var inst_14845 = (state_14923[(2)]);
var state_14923__$1 = state_14923;
var statearr_14947_15023 = state_14923__$1;
(statearr_14947_15023[(2)] = inst_14845);

(statearr_14947_15023[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (31))){
var inst_14871 = (state_14923[(12)]);
var inst_14875 = done.call(null,null);
var inst_14876 = cljs.core.async.untap_STAR_.call(null,m,inst_14871);
var state_14923__$1 = (function (){var statearr_14948 = state_14923;
(statearr_14948[(19)] = inst_14875);

return statearr_14948;
})();
var statearr_14949_15024 = state_14923__$1;
(statearr_14949_15024[(2)] = inst_14876);

(statearr_14949_15024[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (32))){
var inst_14864 = (state_14923[(9)]);
var inst_14865 = (state_14923[(20)]);
var inst_14866 = (state_14923[(10)]);
var inst_14863 = (state_14923[(21)]);
var inst_14878 = (state_14923[(2)]);
var inst_14879 = (inst_14866 + (1));
var tmp14944 = inst_14864;
var tmp14945 = inst_14865;
var tmp14946 = inst_14863;
var inst_14863__$1 = tmp14946;
var inst_14864__$1 = tmp14944;
var inst_14865__$1 = tmp14945;
var inst_14866__$1 = inst_14879;
var state_14923__$1 = (function (){var statearr_14950 = state_14923;
(statearr_14950[(9)] = inst_14864__$1);

(statearr_14950[(22)] = inst_14878);

(statearr_14950[(20)] = inst_14865__$1);

(statearr_14950[(10)] = inst_14866__$1);

(statearr_14950[(21)] = inst_14863__$1);

return statearr_14950;
})();
var statearr_14951_15025 = state_14923__$1;
(statearr_14951_15025[(2)] = null);

(statearr_14951_15025[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (40))){
var inst_14891 = (state_14923[(23)]);
var inst_14895 = done.call(null,null);
var inst_14896 = cljs.core.async.untap_STAR_.call(null,m,inst_14891);
var state_14923__$1 = (function (){var statearr_14952 = state_14923;
(statearr_14952[(24)] = inst_14895);

return statearr_14952;
})();
var statearr_14953_15026 = state_14923__$1;
(statearr_14953_15026[(2)] = inst_14896);

(statearr_14953_15026[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (33))){
var inst_14882 = (state_14923[(25)]);
var inst_14884 = cljs.core.chunked_seq_QMARK_.call(null,inst_14882);
var state_14923__$1 = state_14923;
if(inst_14884){
var statearr_14954_15027 = state_14923__$1;
(statearr_14954_15027[(1)] = (36));

} else {
var statearr_14955_15028 = state_14923__$1;
(statearr_14955_15028[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (13))){
var inst_14814 = (state_14923[(26)]);
var inst_14817 = cljs.core.async.close_BANG_.call(null,inst_14814);
var state_14923__$1 = state_14923;
var statearr_14956_15029 = state_14923__$1;
(statearr_14956_15029[(2)] = inst_14817);

(statearr_14956_15029[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (22))){
var inst_14835 = (state_14923[(8)]);
var inst_14838 = cljs.core.async.close_BANG_.call(null,inst_14835);
var state_14923__$1 = state_14923;
var statearr_14957_15030 = state_14923__$1;
(statearr_14957_15030[(2)] = inst_14838);

(statearr_14957_15030[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (36))){
var inst_14882 = (state_14923[(25)]);
var inst_14886 = cljs.core.chunk_first.call(null,inst_14882);
var inst_14887 = cljs.core.chunk_rest.call(null,inst_14882);
var inst_14888 = cljs.core.count.call(null,inst_14886);
var inst_14863 = inst_14887;
var inst_14864 = inst_14886;
var inst_14865 = inst_14888;
var inst_14866 = (0);
var state_14923__$1 = (function (){var statearr_14958 = state_14923;
(statearr_14958[(9)] = inst_14864);

(statearr_14958[(20)] = inst_14865);

(statearr_14958[(10)] = inst_14866);

(statearr_14958[(21)] = inst_14863);

return statearr_14958;
})();
var statearr_14959_15031 = state_14923__$1;
(statearr_14959_15031[(2)] = null);

(statearr_14959_15031[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (41))){
var inst_14882 = (state_14923[(25)]);
var inst_14898 = (state_14923[(2)]);
var inst_14899 = cljs.core.next.call(null,inst_14882);
var inst_14863 = inst_14899;
var inst_14864 = null;
var inst_14865 = (0);
var inst_14866 = (0);
var state_14923__$1 = (function (){var statearr_14960 = state_14923;
(statearr_14960[(27)] = inst_14898);

(statearr_14960[(9)] = inst_14864);

(statearr_14960[(20)] = inst_14865);

(statearr_14960[(10)] = inst_14866);

(statearr_14960[(21)] = inst_14863);

return statearr_14960;
})();
var statearr_14961_15032 = state_14923__$1;
(statearr_14961_15032[(2)] = null);

(statearr_14961_15032[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (43))){
var state_14923__$1 = state_14923;
var statearr_14962_15033 = state_14923__$1;
(statearr_14962_15033[(2)] = null);

(statearr_14962_15033[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (29))){
var inst_14907 = (state_14923[(2)]);
var state_14923__$1 = state_14923;
var statearr_14963_15034 = state_14923__$1;
(statearr_14963_15034[(2)] = inst_14907);

(statearr_14963_15034[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (44))){
var inst_14916 = (state_14923[(2)]);
var state_14923__$1 = (function (){var statearr_14964 = state_14923;
(statearr_14964[(28)] = inst_14916);

return statearr_14964;
})();
var statearr_14965_15035 = state_14923__$1;
(statearr_14965_15035[(2)] = null);

(statearr_14965_15035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (6))){
var inst_14855 = (state_14923[(29)]);
var inst_14854 = cljs.core.deref.call(null,cs);
var inst_14855__$1 = cljs.core.keys.call(null,inst_14854);
var inst_14856 = cljs.core.count.call(null,inst_14855__$1);
var inst_14857 = cljs.core.reset_BANG_.call(null,dctr,inst_14856);
var inst_14862 = cljs.core.seq.call(null,inst_14855__$1);
var inst_14863 = inst_14862;
var inst_14864 = null;
var inst_14865 = (0);
var inst_14866 = (0);
var state_14923__$1 = (function (){var statearr_14966 = state_14923;
(statearr_14966[(29)] = inst_14855__$1);

(statearr_14966[(9)] = inst_14864);

(statearr_14966[(20)] = inst_14865);

(statearr_14966[(10)] = inst_14866);

(statearr_14966[(30)] = inst_14857);

(statearr_14966[(21)] = inst_14863);

return statearr_14966;
})();
var statearr_14967_15036 = state_14923__$1;
(statearr_14967_15036[(2)] = null);

(statearr_14967_15036[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (28))){
var inst_14882 = (state_14923[(25)]);
var inst_14863 = (state_14923[(21)]);
var inst_14882__$1 = cljs.core.seq.call(null,inst_14863);
var state_14923__$1 = (function (){var statearr_14968 = state_14923;
(statearr_14968[(25)] = inst_14882__$1);

return statearr_14968;
})();
if(inst_14882__$1){
var statearr_14969_15037 = state_14923__$1;
(statearr_14969_15037[(1)] = (33));

} else {
var statearr_14970_15038 = state_14923__$1;
(statearr_14970_15038[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (25))){
var inst_14865 = (state_14923[(20)]);
var inst_14866 = (state_14923[(10)]);
var inst_14868 = (inst_14866 < inst_14865);
var inst_14869 = inst_14868;
var state_14923__$1 = state_14923;
if(cljs.core.truth_(inst_14869)){
var statearr_14971_15039 = state_14923__$1;
(statearr_14971_15039[(1)] = (27));

} else {
var statearr_14972_15040 = state_14923__$1;
(statearr_14972_15040[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (34))){
var state_14923__$1 = state_14923;
var statearr_14973_15041 = state_14923__$1;
(statearr_14973_15041[(2)] = null);

(statearr_14973_15041[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (17))){
var state_14923__$1 = state_14923;
var statearr_14974_15042 = state_14923__$1;
(statearr_14974_15042[(2)] = null);

(statearr_14974_15042[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (3))){
var inst_14921 = (state_14923[(2)]);
var state_14923__$1 = state_14923;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14923__$1,inst_14921);
} else {
if((state_val_14924 === (12))){
var inst_14850 = (state_14923[(2)]);
var state_14923__$1 = state_14923;
var statearr_14975_15043 = state_14923__$1;
(statearr_14975_15043[(2)] = inst_14850);

(statearr_14975_15043[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (2))){
var state_14923__$1 = state_14923;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14923__$1,(4),ch);
} else {
if((state_val_14924 === (23))){
var state_14923__$1 = state_14923;
var statearr_14976_15044 = state_14923__$1;
(statearr_14976_15044[(2)] = null);

(statearr_14976_15044[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (35))){
var inst_14905 = (state_14923[(2)]);
var state_14923__$1 = state_14923;
var statearr_14977_15045 = state_14923__$1;
(statearr_14977_15045[(2)] = inst_14905);

(statearr_14977_15045[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (19))){
var inst_14824 = (state_14923[(7)]);
var inst_14828 = cljs.core.chunk_first.call(null,inst_14824);
var inst_14829 = cljs.core.chunk_rest.call(null,inst_14824);
var inst_14830 = cljs.core.count.call(null,inst_14828);
var inst_14804 = inst_14829;
var inst_14805 = inst_14828;
var inst_14806 = inst_14830;
var inst_14807 = (0);
var state_14923__$1 = (function (){var statearr_14978 = state_14923;
(statearr_14978[(13)] = inst_14804);

(statearr_14978[(14)] = inst_14805);

(statearr_14978[(16)] = inst_14806);

(statearr_14978[(17)] = inst_14807);

return statearr_14978;
})();
var statearr_14979_15046 = state_14923__$1;
(statearr_14979_15046[(2)] = null);

(statearr_14979_15046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (11))){
var inst_14804 = (state_14923[(13)]);
var inst_14824 = (state_14923[(7)]);
var inst_14824__$1 = cljs.core.seq.call(null,inst_14804);
var state_14923__$1 = (function (){var statearr_14980 = state_14923;
(statearr_14980[(7)] = inst_14824__$1);

return statearr_14980;
})();
if(inst_14824__$1){
var statearr_14981_15047 = state_14923__$1;
(statearr_14981_15047[(1)] = (16));

} else {
var statearr_14982_15048 = state_14923__$1;
(statearr_14982_15048[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (9))){
var inst_14852 = (state_14923[(2)]);
var state_14923__$1 = state_14923;
var statearr_14983_15049 = state_14923__$1;
(statearr_14983_15049[(2)] = inst_14852);

(statearr_14983_15049[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (5))){
var inst_14802 = cljs.core.deref.call(null,cs);
var inst_14803 = cljs.core.seq.call(null,inst_14802);
var inst_14804 = inst_14803;
var inst_14805 = null;
var inst_14806 = (0);
var inst_14807 = (0);
var state_14923__$1 = (function (){var statearr_14984 = state_14923;
(statearr_14984[(13)] = inst_14804);

(statearr_14984[(14)] = inst_14805);

(statearr_14984[(16)] = inst_14806);

(statearr_14984[(17)] = inst_14807);

return statearr_14984;
})();
var statearr_14985_15050 = state_14923__$1;
(statearr_14985_15050[(2)] = null);

(statearr_14985_15050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (14))){
var state_14923__$1 = state_14923;
var statearr_14986_15051 = state_14923__$1;
(statearr_14986_15051[(2)] = null);

(statearr_14986_15051[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (45))){
var inst_14913 = (state_14923[(2)]);
var state_14923__$1 = state_14923;
var statearr_14987_15052 = state_14923__$1;
(statearr_14987_15052[(2)] = inst_14913);

(statearr_14987_15052[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (26))){
var inst_14855 = (state_14923[(29)]);
var inst_14909 = (state_14923[(2)]);
var inst_14910 = cljs.core.seq.call(null,inst_14855);
var state_14923__$1 = (function (){var statearr_14988 = state_14923;
(statearr_14988[(31)] = inst_14909);

return statearr_14988;
})();
if(inst_14910){
var statearr_14989_15053 = state_14923__$1;
(statearr_14989_15053[(1)] = (42));

} else {
var statearr_14990_15054 = state_14923__$1;
(statearr_14990_15054[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (16))){
var inst_14824 = (state_14923[(7)]);
var inst_14826 = cljs.core.chunked_seq_QMARK_.call(null,inst_14824);
var state_14923__$1 = state_14923;
if(inst_14826){
var statearr_14991_15055 = state_14923__$1;
(statearr_14991_15055[(1)] = (19));

} else {
var statearr_14992_15056 = state_14923__$1;
(statearr_14992_15056[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (38))){
var inst_14902 = (state_14923[(2)]);
var state_14923__$1 = state_14923;
var statearr_14993_15057 = state_14923__$1;
(statearr_14993_15057[(2)] = inst_14902);

(statearr_14993_15057[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (30))){
var state_14923__$1 = state_14923;
var statearr_14994_15058 = state_14923__$1;
(statearr_14994_15058[(2)] = null);

(statearr_14994_15058[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (10))){
var inst_14805 = (state_14923[(14)]);
var inst_14807 = (state_14923[(17)]);
var inst_14813 = cljs.core._nth.call(null,inst_14805,inst_14807);
var inst_14814 = cljs.core.nth.call(null,inst_14813,(0),null);
var inst_14815 = cljs.core.nth.call(null,inst_14813,(1),null);
var state_14923__$1 = (function (){var statearr_14995 = state_14923;
(statearr_14995[(26)] = inst_14814);

return statearr_14995;
})();
if(cljs.core.truth_(inst_14815)){
var statearr_14996_15059 = state_14923__$1;
(statearr_14996_15059[(1)] = (13));

} else {
var statearr_14997_15060 = state_14923__$1;
(statearr_14997_15060[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (18))){
var inst_14848 = (state_14923[(2)]);
var state_14923__$1 = state_14923;
var statearr_14998_15061 = state_14923__$1;
(statearr_14998_15061[(2)] = inst_14848);

(statearr_14998_15061[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (42))){
var state_14923__$1 = state_14923;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14923__$1,(45),dchan);
} else {
if((state_val_14924 === (37))){
var inst_14891 = (state_14923[(23)]);
var inst_14882 = (state_14923[(25)]);
var inst_14795 = (state_14923[(11)]);
var inst_14891__$1 = cljs.core.first.call(null,inst_14882);
var inst_14892 = cljs.core.async.put_BANG_.call(null,inst_14891__$1,inst_14795,done);
var state_14923__$1 = (function (){var statearr_14999 = state_14923;
(statearr_14999[(23)] = inst_14891__$1);

return statearr_14999;
})();
if(cljs.core.truth_(inst_14892)){
var statearr_15000_15062 = state_14923__$1;
(statearr_15000_15062[(1)] = (39));

} else {
var statearr_15001_15063 = state_14923__$1;
(statearr_15001_15063[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14924 === (8))){
var inst_14806 = (state_14923[(16)]);
var inst_14807 = (state_14923[(17)]);
var inst_14809 = (inst_14807 < inst_14806);
var inst_14810 = inst_14809;
var state_14923__$1 = state_14923;
if(cljs.core.truth_(inst_14810)){
var statearr_15002_15064 = state_14923__$1;
(statearr_15002_15064[(1)] = (10));

} else {
var statearr_15003_15065 = state_14923__$1;
(statearr_15003_15065[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15011,cs,m,dchan,dctr,done))
;
return ((function (switch__7673__auto__,c__7694__auto___15011,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__7674__auto__ = null;
var cljs$core$async$mult_$_state_machine__7674__auto____0 = (function (){
var statearr_15007 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15007[(0)] = cljs$core$async$mult_$_state_machine__7674__auto__);

(statearr_15007[(1)] = (1));

return statearr_15007;
});
var cljs$core$async$mult_$_state_machine__7674__auto____1 = (function (state_14923){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14923);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15008){if((e15008 instanceof Object)){
var ex__7677__auto__ = e15008;
var statearr_15009_15066 = state_14923;
(statearr_15009_15066[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14923);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15008;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15067 = state_14923;
state_14923 = G__15067;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__7674__auto__ = function(state_14923){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__7674__auto____1.call(this,state_14923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__7674__auto____0;
cljs$core$async$mult_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__7674__auto____1;
return cljs$core$async$mult_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15011,cs,m,dchan,dctr,done))
})();
var state__7696__auto__ = (function (){var statearr_15010 = f__7695__auto__.call(null);
(statearr_15010[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15011);

return statearr_15010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15011,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15068 = [];
var len__5627__auto___15071 = arguments.length;
var i__5628__auto___15072 = (0);
while(true){
if((i__5628__auto___15072 < len__5627__auto___15071)){
args15068.push((arguments[i__5628__auto___15072]));

var G__15073 = (i__5628__auto___15072 + (1));
i__5628__auto___15072 = G__15073;
continue;
} else {
}
break;
}

var G__15070 = args15068.length;
switch (G__15070) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15068.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,state_map);
} else {
var m__5225__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,mode);
} else {
var m__5225__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___15085 = arguments.length;
var i__5628__auto___15086 = (0);
while(true){
if((i__5628__auto___15086 < len__5627__auto___15085)){
args__5634__auto__.push((arguments[i__5628__auto___15086]));

var G__15087 = (i__5628__auto___15086 + (1));
i__5628__auto___15086 = G__15087;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15079){
var map__15080 = p__15079;
var map__15080__$1 = ((((!((map__15080 == null)))?((((map__15080.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15080.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15080):map__15080);
var opts = map__15080__$1;
var statearr_15082_15088 = state;
(statearr_15082_15088[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__15080,map__15080__$1,opts){
return (function (val){
var statearr_15083_15089 = state;
(statearr_15083_15089[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__15080,map__15080__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_15084_15090 = state;
(statearr_15084_15090[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15075){
var G__15076 = cljs.core.first.call(null,seq15075);
var seq15075__$1 = cljs.core.next.call(null,seq15075);
var G__15077 = cljs.core.first.call(null,seq15075__$1);
var seq15075__$2 = cljs.core.next.call(null,seq15075__$1);
var G__15078 = cljs.core.first.call(null,seq15075__$2);
var seq15075__$3 = cljs.core.next.call(null,seq15075__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15076,G__15077,G__15078,seq15075__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15254 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15254 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta15255){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta15255 = meta15255;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15254.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15256,meta15255__$1){
var self__ = this;
var _15256__$1 = this;
return (new cljs.core.async.t_cljs$core$async15254(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta15255__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15254.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15256){
var self__ = this;
var _15256__$1 = this;
return self__.meta15255;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15254.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15254.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15254.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async15254.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15254.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15254.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15254.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15254.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15254.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta15255","meta15255",10938284,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15254.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15254.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15254";

cljs.core.async.t_cljs$core$async15254.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15254");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async15254 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async15254(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15255){
return (new cljs.core.async.t_cljs$core$async15254(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15255));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async15254(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7694__auto___15417 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15417,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15417,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_15354){
var state_val_15355 = (state_15354[(1)]);
if((state_val_15355 === (7))){
var inst_15272 = (state_15354[(2)]);
var state_15354__$1 = state_15354;
var statearr_15356_15418 = state_15354__$1;
(statearr_15356_15418[(2)] = inst_15272);

(statearr_15356_15418[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (20))){
var inst_15284 = (state_15354[(7)]);
var state_15354__$1 = state_15354;
var statearr_15357_15419 = state_15354__$1;
(statearr_15357_15419[(2)] = inst_15284);

(statearr_15357_15419[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (27))){
var state_15354__$1 = state_15354;
var statearr_15358_15420 = state_15354__$1;
(statearr_15358_15420[(2)] = null);

(statearr_15358_15420[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (1))){
var inst_15260 = (state_15354[(8)]);
var inst_15260__$1 = calc_state.call(null);
var inst_15262 = (inst_15260__$1 == null);
var inst_15263 = cljs.core.not.call(null,inst_15262);
var state_15354__$1 = (function (){var statearr_15359 = state_15354;
(statearr_15359[(8)] = inst_15260__$1);

return statearr_15359;
})();
if(inst_15263){
var statearr_15360_15421 = state_15354__$1;
(statearr_15360_15421[(1)] = (2));

} else {
var statearr_15361_15422 = state_15354__$1;
(statearr_15361_15422[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (24))){
var inst_15307 = (state_15354[(9)]);
var inst_15314 = (state_15354[(10)]);
var inst_15328 = (state_15354[(11)]);
var inst_15328__$1 = inst_15307.call(null,inst_15314);
var state_15354__$1 = (function (){var statearr_15362 = state_15354;
(statearr_15362[(11)] = inst_15328__$1);

return statearr_15362;
})();
if(cljs.core.truth_(inst_15328__$1)){
var statearr_15363_15423 = state_15354__$1;
(statearr_15363_15423[(1)] = (29));

} else {
var statearr_15364_15424 = state_15354__$1;
(statearr_15364_15424[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (4))){
var inst_15275 = (state_15354[(2)]);
var state_15354__$1 = state_15354;
if(cljs.core.truth_(inst_15275)){
var statearr_15365_15425 = state_15354__$1;
(statearr_15365_15425[(1)] = (8));

} else {
var statearr_15366_15426 = state_15354__$1;
(statearr_15366_15426[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (15))){
var inst_15301 = (state_15354[(2)]);
var state_15354__$1 = state_15354;
if(cljs.core.truth_(inst_15301)){
var statearr_15367_15427 = state_15354__$1;
(statearr_15367_15427[(1)] = (19));

} else {
var statearr_15368_15428 = state_15354__$1;
(statearr_15368_15428[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (21))){
var inst_15306 = (state_15354[(12)]);
var inst_15306__$1 = (state_15354[(2)]);
var inst_15307 = cljs.core.get.call(null,inst_15306__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_15308 = cljs.core.get.call(null,inst_15306__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_15309 = cljs.core.get.call(null,inst_15306__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_15354__$1 = (function (){var statearr_15369 = state_15354;
(statearr_15369[(9)] = inst_15307);

(statearr_15369[(13)] = inst_15308);

(statearr_15369[(12)] = inst_15306__$1);

return statearr_15369;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_15354__$1,(22),inst_15309);
} else {
if((state_val_15355 === (31))){
var inst_15336 = (state_15354[(2)]);
var state_15354__$1 = state_15354;
if(cljs.core.truth_(inst_15336)){
var statearr_15370_15429 = state_15354__$1;
(statearr_15370_15429[(1)] = (32));

} else {
var statearr_15371_15430 = state_15354__$1;
(statearr_15371_15430[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (32))){
var inst_15313 = (state_15354[(14)]);
var state_15354__$1 = state_15354;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15354__$1,(35),out,inst_15313);
} else {
if((state_val_15355 === (33))){
var inst_15306 = (state_15354[(12)]);
var inst_15284 = inst_15306;
var state_15354__$1 = (function (){var statearr_15372 = state_15354;
(statearr_15372[(7)] = inst_15284);

return statearr_15372;
})();
var statearr_15373_15431 = state_15354__$1;
(statearr_15373_15431[(2)] = null);

(statearr_15373_15431[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (13))){
var inst_15284 = (state_15354[(7)]);
var inst_15291 = inst_15284.cljs$lang$protocol_mask$partition0$;
var inst_15292 = (inst_15291 & (64));
var inst_15293 = inst_15284.cljs$core$ISeq$;
var inst_15294 = (inst_15292) || (inst_15293);
var state_15354__$1 = state_15354;
if(cljs.core.truth_(inst_15294)){
var statearr_15374_15432 = state_15354__$1;
(statearr_15374_15432[(1)] = (16));

} else {
var statearr_15375_15433 = state_15354__$1;
(statearr_15375_15433[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (22))){
var inst_15313 = (state_15354[(14)]);
var inst_15314 = (state_15354[(10)]);
var inst_15312 = (state_15354[(2)]);
var inst_15313__$1 = cljs.core.nth.call(null,inst_15312,(0),null);
var inst_15314__$1 = cljs.core.nth.call(null,inst_15312,(1),null);
var inst_15315 = (inst_15313__$1 == null);
var inst_15316 = cljs.core._EQ_.call(null,inst_15314__$1,change);
var inst_15317 = (inst_15315) || (inst_15316);
var state_15354__$1 = (function (){var statearr_15376 = state_15354;
(statearr_15376[(14)] = inst_15313__$1);

(statearr_15376[(10)] = inst_15314__$1);

return statearr_15376;
})();
if(cljs.core.truth_(inst_15317)){
var statearr_15377_15434 = state_15354__$1;
(statearr_15377_15434[(1)] = (23));

} else {
var statearr_15378_15435 = state_15354__$1;
(statearr_15378_15435[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (36))){
var inst_15306 = (state_15354[(12)]);
var inst_15284 = inst_15306;
var state_15354__$1 = (function (){var statearr_15379 = state_15354;
(statearr_15379[(7)] = inst_15284);

return statearr_15379;
})();
var statearr_15380_15436 = state_15354__$1;
(statearr_15380_15436[(2)] = null);

(statearr_15380_15436[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (29))){
var inst_15328 = (state_15354[(11)]);
var state_15354__$1 = state_15354;
var statearr_15381_15437 = state_15354__$1;
(statearr_15381_15437[(2)] = inst_15328);

(statearr_15381_15437[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (6))){
var state_15354__$1 = state_15354;
var statearr_15382_15438 = state_15354__$1;
(statearr_15382_15438[(2)] = false);

(statearr_15382_15438[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (28))){
var inst_15324 = (state_15354[(2)]);
var inst_15325 = calc_state.call(null);
var inst_15284 = inst_15325;
var state_15354__$1 = (function (){var statearr_15383 = state_15354;
(statearr_15383[(15)] = inst_15324);

(statearr_15383[(7)] = inst_15284);

return statearr_15383;
})();
var statearr_15384_15439 = state_15354__$1;
(statearr_15384_15439[(2)] = null);

(statearr_15384_15439[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (25))){
var inst_15350 = (state_15354[(2)]);
var state_15354__$1 = state_15354;
var statearr_15385_15440 = state_15354__$1;
(statearr_15385_15440[(2)] = inst_15350);

(statearr_15385_15440[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (34))){
var inst_15348 = (state_15354[(2)]);
var state_15354__$1 = state_15354;
var statearr_15386_15441 = state_15354__$1;
(statearr_15386_15441[(2)] = inst_15348);

(statearr_15386_15441[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (17))){
var state_15354__$1 = state_15354;
var statearr_15387_15442 = state_15354__$1;
(statearr_15387_15442[(2)] = false);

(statearr_15387_15442[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (3))){
var state_15354__$1 = state_15354;
var statearr_15388_15443 = state_15354__$1;
(statearr_15388_15443[(2)] = false);

(statearr_15388_15443[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (12))){
var inst_15352 = (state_15354[(2)]);
var state_15354__$1 = state_15354;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15354__$1,inst_15352);
} else {
if((state_val_15355 === (2))){
var inst_15260 = (state_15354[(8)]);
var inst_15265 = inst_15260.cljs$lang$protocol_mask$partition0$;
var inst_15266 = (inst_15265 & (64));
var inst_15267 = inst_15260.cljs$core$ISeq$;
var inst_15268 = (inst_15266) || (inst_15267);
var state_15354__$1 = state_15354;
if(cljs.core.truth_(inst_15268)){
var statearr_15389_15444 = state_15354__$1;
(statearr_15389_15444[(1)] = (5));

} else {
var statearr_15390_15445 = state_15354__$1;
(statearr_15390_15445[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (23))){
var inst_15313 = (state_15354[(14)]);
var inst_15319 = (inst_15313 == null);
var state_15354__$1 = state_15354;
if(cljs.core.truth_(inst_15319)){
var statearr_15391_15446 = state_15354__$1;
(statearr_15391_15446[(1)] = (26));

} else {
var statearr_15392_15447 = state_15354__$1;
(statearr_15392_15447[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (35))){
var inst_15339 = (state_15354[(2)]);
var state_15354__$1 = state_15354;
if(cljs.core.truth_(inst_15339)){
var statearr_15393_15448 = state_15354__$1;
(statearr_15393_15448[(1)] = (36));

} else {
var statearr_15394_15449 = state_15354__$1;
(statearr_15394_15449[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (19))){
var inst_15284 = (state_15354[(7)]);
var inst_15303 = cljs.core.apply.call(null,cljs.core.hash_map,inst_15284);
var state_15354__$1 = state_15354;
var statearr_15395_15450 = state_15354__$1;
(statearr_15395_15450[(2)] = inst_15303);

(statearr_15395_15450[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (11))){
var inst_15284 = (state_15354[(7)]);
var inst_15288 = (inst_15284 == null);
var inst_15289 = cljs.core.not.call(null,inst_15288);
var state_15354__$1 = state_15354;
if(inst_15289){
var statearr_15396_15451 = state_15354__$1;
(statearr_15396_15451[(1)] = (13));

} else {
var statearr_15397_15452 = state_15354__$1;
(statearr_15397_15452[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (9))){
var inst_15260 = (state_15354[(8)]);
var state_15354__$1 = state_15354;
var statearr_15398_15453 = state_15354__$1;
(statearr_15398_15453[(2)] = inst_15260);

(statearr_15398_15453[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (5))){
var state_15354__$1 = state_15354;
var statearr_15399_15454 = state_15354__$1;
(statearr_15399_15454[(2)] = true);

(statearr_15399_15454[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (14))){
var state_15354__$1 = state_15354;
var statearr_15400_15455 = state_15354__$1;
(statearr_15400_15455[(2)] = false);

(statearr_15400_15455[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (26))){
var inst_15314 = (state_15354[(10)]);
var inst_15321 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_15314);
var state_15354__$1 = state_15354;
var statearr_15401_15456 = state_15354__$1;
(statearr_15401_15456[(2)] = inst_15321);

(statearr_15401_15456[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (16))){
var state_15354__$1 = state_15354;
var statearr_15402_15457 = state_15354__$1;
(statearr_15402_15457[(2)] = true);

(statearr_15402_15457[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (38))){
var inst_15344 = (state_15354[(2)]);
var state_15354__$1 = state_15354;
var statearr_15403_15458 = state_15354__$1;
(statearr_15403_15458[(2)] = inst_15344);

(statearr_15403_15458[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (30))){
var inst_15307 = (state_15354[(9)]);
var inst_15308 = (state_15354[(13)]);
var inst_15314 = (state_15354[(10)]);
var inst_15331 = cljs.core.empty_QMARK_.call(null,inst_15307);
var inst_15332 = inst_15308.call(null,inst_15314);
var inst_15333 = cljs.core.not.call(null,inst_15332);
var inst_15334 = (inst_15331) && (inst_15333);
var state_15354__$1 = state_15354;
var statearr_15404_15459 = state_15354__$1;
(statearr_15404_15459[(2)] = inst_15334);

(statearr_15404_15459[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (10))){
var inst_15260 = (state_15354[(8)]);
var inst_15280 = (state_15354[(2)]);
var inst_15281 = cljs.core.get.call(null,inst_15280,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_15282 = cljs.core.get.call(null,inst_15280,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_15283 = cljs.core.get.call(null,inst_15280,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_15284 = inst_15260;
var state_15354__$1 = (function (){var statearr_15405 = state_15354;
(statearr_15405[(16)] = inst_15282);

(statearr_15405[(17)] = inst_15283);

(statearr_15405[(18)] = inst_15281);

(statearr_15405[(7)] = inst_15284);

return statearr_15405;
})();
var statearr_15406_15460 = state_15354__$1;
(statearr_15406_15460[(2)] = null);

(statearr_15406_15460[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (18))){
var inst_15298 = (state_15354[(2)]);
var state_15354__$1 = state_15354;
var statearr_15407_15461 = state_15354__$1;
(statearr_15407_15461[(2)] = inst_15298);

(statearr_15407_15461[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (37))){
var state_15354__$1 = state_15354;
var statearr_15408_15462 = state_15354__$1;
(statearr_15408_15462[(2)] = null);

(statearr_15408_15462[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15355 === (8))){
var inst_15260 = (state_15354[(8)]);
var inst_15277 = cljs.core.apply.call(null,cljs.core.hash_map,inst_15260);
var state_15354__$1 = state_15354;
var statearr_15409_15463 = state_15354__$1;
(statearr_15409_15463[(2)] = inst_15277);

(statearr_15409_15463[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15417,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__7673__auto__,c__7694__auto___15417,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__7674__auto__ = null;
var cljs$core$async$mix_$_state_machine__7674__auto____0 = (function (){
var statearr_15413 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15413[(0)] = cljs$core$async$mix_$_state_machine__7674__auto__);

(statearr_15413[(1)] = (1));

return statearr_15413;
});
var cljs$core$async$mix_$_state_machine__7674__auto____1 = (function (state_15354){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15354);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15414){if((e15414 instanceof Object)){
var ex__7677__auto__ = e15414;
var statearr_15415_15464 = state_15354;
(statearr_15415_15464[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15354);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15414;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15465 = state_15354;
state_15354 = G__15465;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__7674__auto__ = function(state_15354){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__7674__auto____1.call(this,state_15354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__7674__auto____0;
cljs$core$async$mix_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__7674__auto____1;
return cljs$core$async$mix_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15417,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__7696__auto__ = (function (){var statearr_15416 = f__7695__auto__.call(null);
(statearr_15416[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15417);

return statearr_15416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15417,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args15466 = [];
var len__5627__auto___15469 = arguments.length;
var i__5628__auto___15470 = (0);
while(true){
if((i__5628__auto___15470 < len__5627__auto___15469)){
args15466.push((arguments[i__5628__auto___15470]));

var G__15471 = (i__5628__auto___15470 + (1));
i__5628__auto___15470 = G__15471;
continue;
} else {
}
break;
}

var G__15468 = args15466.length;
switch (G__15468) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15466.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args15474 = [];
var len__5627__auto___15599 = arguments.length;
var i__5628__auto___15600 = (0);
while(true){
if((i__5628__auto___15600 < len__5627__auto___15599)){
args15474.push((arguments[i__5628__auto___15600]));

var G__15601 = (i__5628__auto___15600 + (1));
i__5628__auto___15600 = G__15601;
continue;
} else {
}
break;
}

var G__15476 = args15474.length;
switch (G__15476) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15474.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4569__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4569__auto__,mults){
return (function (p1__15473_SHARP_){
if(cljs.core.truth_(p1__15473_SHARP_.call(null,topic))){
return p1__15473_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__15473_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4569__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async15477 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15477 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta15478){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta15478 = meta15478;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_15479,meta15478__$1){
var self__ = this;
var _15479__$1 = this;
return (new cljs.core.async.t_cljs$core$async15477(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta15478__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_15479){
var self__ = this;
var _15479__$1 = this;
return self__.meta15478;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15477.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta15478","meta15478",273049759,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15477.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15477.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15477";

cljs.core.async.t_cljs$core$async15477.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15477");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async15477 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async15477(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15478){
return (new cljs.core.async.t_cljs$core$async15477(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15478));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async15477(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7694__auto___15603 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15603,mults,ensure_mult,p){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15603,mults,ensure_mult,p){
return (function (state_15551){
var state_val_15552 = (state_15551[(1)]);
if((state_val_15552 === (7))){
var inst_15547 = (state_15551[(2)]);
var state_15551__$1 = state_15551;
var statearr_15553_15604 = state_15551__$1;
(statearr_15553_15604[(2)] = inst_15547);

(statearr_15553_15604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (20))){
var state_15551__$1 = state_15551;
var statearr_15554_15605 = state_15551__$1;
(statearr_15554_15605[(2)] = null);

(statearr_15554_15605[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (1))){
var state_15551__$1 = state_15551;
var statearr_15555_15606 = state_15551__$1;
(statearr_15555_15606[(2)] = null);

(statearr_15555_15606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (24))){
var inst_15530 = (state_15551[(7)]);
var inst_15539 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_15530);
var state_15551__$1 = state_15551;
var statearr_15556_15607 = state_15551__$1;
(statearr_15556_15607[(2)] = inst_15539);

(statearr_15556_15607[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (4))){
var inst_15482 = (state_15551[(8)]);
var inst_15482__$1 = (state_15551[(2)]);
var inst_15483 = (inst_15482__$1 == null);
var state_15551__$1 = (function (){var statearr_15557 = state_15551;
(statearr_15557[(8)] = inst_15482__$1);

return statearr_15557;
})();
if(cljs.core.truth_(inst_15483)){
var statearr_15558_15608 = state_15551__$1;
(statearr_15558_15608[(1)] = (5));

} else {
var statearr_15559_15609 = state_15551__$1;
(statearr_15559_15609[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (15))){
var inst_15524 = (state_15551[(2)]);
var state_15551__$1 = state_15551;
var statearr_15560_15610 = state_15551__$1;
(statearr_15560_15610[(2)] = inst_15524);

(statearr_15560_15610[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (21))){
var inst_15544 = (state_15551[(2)]);
var state_15551__$1 = (function (){var statearr_15561 = state_15551;
(statearr_15561[(9)] = inst_15544);

return statearr_15561;
})();
var statearr_15562_15611 = state_15551__$1;
(statearr_15562_15611[(2)] = null);

(statearr_15562_15611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (13))){
var inst_15506 = (state_15551[(10)]);
var inst_15508 = cljs.core.chunked_seq_QMARK_.call(null,inst_15506);
var state_15551__$1 = state_15551;
if(inst_15508){
var statearr_15563_15612 = state_15551__$1;
(statearr_15563_15612[(1)] = (16));

} else {
var statearr_15564_15613 = state_15551__$1;
(statearr_15564_15613[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (22))){
var inst_15536 = (state_15551[(2)]);
var state_15551__$1 = state_15551;
if(cljs.core.truth_(inst_15536)){
var statearr_15565_15614 = state_15551__$1;
(statearr_15565_15614[(1)] = (23));

} else {
var statearr_15566_15615 = state_15551__$1;
(statearr_15566_15615[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (6))){
var inst_15532 = (state_15551[(11)]);
var inst_15530 = (state_15551[(7)]);
var inst_15482 = (state_15551[(8)]);
var inst_15530__$1 = topic_fn.call(null,inst_15482);
var inst_15531 = cljs.core.deref.call(null,mults);
var inst_15532__$1 = cljs.core.get.call(null,inst_15531,inst_15530__$1);
var state_15551__$1 = (function (){var statearr_15567 = state_15551;
(statearr_15567[(11)] = inst_15532__$1);

(statearr_15567[(7)] = inst_15530__$1);

return statearr_15567;
})();
if(cljs.core.truth_(inst_15532__$1)){
var statearr_15568_15616 = state_15551__$1;
(statearr_15568_15616[(1)] = (19));

} else {
var statearr_15569_15617 = state_15551__$1;
(statearr_15569_15617[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (25))){
var inst_15541 = (state_15551[(2)]);
var state_15551__$1 = state_15551;
var statearr_15570_15618 = state_15551__$1;
(statearr_15570_15618[(2)] = inst_15541);

(statearr_15570_15618[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (17))){
var inst_15506 = (state_15551[(10)]);
var inst_15515 = cljs.core.first.call(null,inst_15506);
var inst_15516 = cljs.core.async.muxch_STAR_.call(null,inst_15515);
var inst_15517 = cljs.core.async.close_BANG_.call(null,inst_15516);
var inst_15518 = cljs.core.next.call(null,inst_15506);
var inst_15492 = inst_15518;
var inst_15493 = null;
var inst_15494 = (0);
var inst_15495 = (0);
var state_15551__$1 = (function (){var statearr_15571 = state_15551;
(statearr_15571[(12)] = inst_15517);

(statearr_15571[(13)] = inst_15495);

(statearr_15571[(14)] = inst_15493);

(statearr_15571[(15)] = inst_15494);

(statearr_15571[(16)] = inst_15492);

return statearr_15571;
})();
var statearr_15572_15619 = state_15551__$1;
(statearr_15572_15619[(2)] = null);

(statearr_15572_15619[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (3))){
var inst_15549 = (state_15551[(2)]);
var state_15551__$1 = state_15551;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15551__$1,inst_15549);
} else {
if((state_val_15552 === (12))){
var inst_15526 = (state_15551[(2)]);
var state_15551__$1 = state_15551;
var statearr_15573_15620 = state_15551__$1;
(statearr_15573_15620[(2)] = inst_15526);

(statearr_15573_15620[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (2))){
var state_15551__$1 = state_15551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15551__$1,(4),ch);
} else {
if((state_val_15552 === (23))){
var state_15551__$1 = state_15551;
var statearr_15574_15621 = state_15551__$1;
(statearr_15574_15621[(2)] = null);

(statearr_15574_15621[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (19))){
var inst_15532 = (state_15551[(11)]);
var inst_15482 = (state_15551[(8)]);
var inst_15534 = cljs.core.async.muxch_STAR_.call(null,inst_15532);
var state_15551__$1 = state_15551;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15551__$1,(22),inst_15534,inst_15482);
} else {
if((state_val_15552 === (11))){
var inst_15506 = (state_15551[(10)]);
var inst_15492 = (state_15551[(16)]);
var inst_15506__$1 = cljs.core.seq.call(null,inst_15492);
var state_15551__$1 = (function (){var statearr_15575 = state_15551;
(statearr_15575[(10)] = inst_15506__$1);

return statearr_15575;
})();
if(inst_15506__$1){
var statearr_15576_15622 = state_15551__$1;
(statearr_15576_15622[(1)] = (13));

} else {
var statearr_15577_15623 = state_15551__$1;
(statearr_15577_15623[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (9))){
var inst_15528 = (state_15551[(2)]);
var state_15551__$1 = state_15551;
var statearr_15578_15624 = state_15551__$1;
(statearr_15578_15624[(2)] = inst_15528);

(statearr_15578_15624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (5))){
var inst_15489 = cljs.core.deref.call(null,mults);
var inst_15490 = cljs.core.vals.call(null,inst_15489);
var inst_15491 = cljs.core.seq.call(null,inst_15490);
var inst_15492 = inst_15491;
var inst_15493 = null;
var inst_15494 = (0);
var inst_15495 = (0);
var state_15551__$1 = (function (){var statearr_15579 = state_15551;
(statearr_15579[(13)] = inst_15495);

(statearr_15579[(14)] = inst_15493);

(statearr_15579[(15)] = inst_15494);

(statearr_15579[(16)] = inst_15492);

return statearr_15579;
})();
var statearr_15580_15625 = state_15551__$1;
(statearr_15580_15625[(2)] = null);

(statearr_15580_15625[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (14))){
var state_15551__$1 = state_15551;
var statearr_15584_15626 = state_15551__$1;
(statearr_15584_15626[(2)] = null);

(statearr_15584_15626[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (16))){
var inst_15506 = (state_15551[(10)]);
var inst_15510 = cljs.core.chunk_first.call(null,inst_15506);
var inst_15511 = cljs.core.chunk_rest.call(null,inst_15506);
var inst_15512 = cljs.core.count.call(null,inst_15510);
var inst_15492 = inst_15511;
var inst_15493 = inst_15510;
var inst_15494 = inst_15512;
var inst_15495 = (0);
var state_15551__$1 = (function (){var statearr_15585 = state_15551;
(statearr_15585[(13)] = inst_15495);

(statearr_15585[(14)] = inst_15493);

(statearr_15585[(15)] = inst_15494);

(statearr_15585[(16)] = inst_15492);

return statearr_15585;
})();
var statearr_15586_15627 = state_15551__$1;
(statearr_15586_15627[(2)] = null);

(statearr_15586_15627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (10))){
var inst_15495 = (state_15551[(13)]);
var inst_15493 = (state_15551[(14)]);
var inst_15494 = (state_15551[(15)]);
var inst_15492 = (state_15551[(16)]);
var inst_15500 = cljs.core._nth.call(null,inst_15493,inst_15495);
var inst_15501 = cljs.core.async.muxch_STAR_.call(null,inst_15500);
var inst_15502 = cljs.core.async.close_BANG_.call(null,inst_15501);
var inst_15503 = (inst_15495 + (1));
var tmp15581 = inst_15493;
var tmp15582 = inst_15494;
var tmp15583 = inst_15492;
var inst_15492__$1 = tmp15583;
var inst_15493__$1 = tmp15581;
var inst_15494__$1 = tmp15582;
var inst_15495__$1 = inst_15503;
var state_15551__$1 = (function (){var statearr_15587 = state_15551;
(statearr_15587[(13)] = inst_15495__$1);

(statearr_15587[(14)] = inst_15493__$1);

(statearr_15587[(15)] = inst_15494__$1);

(statearr_15587[(17)] = inst_15502);

(statearr_15587[(16)] = inst_15492__$1);

return statearr_15587;
})();
var statearr_15588_15628 = state_15551__$1;
(statearr_15588_15628[(2)] = null);

(statearr_15588_15628[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (18))){
var inst_15521 = (state_15551[(2)]);
var state_15551__$1 = state_15551;
var statearr_15589_15629 = state_15551__$1;
(statearr_15589_15629[(2)] = inst_15521);

(statearr_15589_15629[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15552 === (8))){
var inst_15495 = (state_15551[(13)]);
var inst_15494 = (state_15551[(15)]);
var inst_15497 = (inst_15495 < inst_15494);
var inst_15498 = inst_15497;
var state_15551__$1 = state_15551;
if(cljs.core.truth_(inst_15498)){
var statearr_15590_15630 = state_15551__$1;
(statearr_15590_15630[(1)] = (10));

} else {
var statearr_15591_15631 = state_15551__$1;
(statearr_15591_15631[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15603,mults,ensure_mult,p))
;
return ((function (switch__7673__auto__,c__7694__auto___15603,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15595 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15595[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15595[(1)] = (1));

return statearr_15595;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15551){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15551);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15596){if((e15596 instanceof Object)){
var ex__7677__auto__ = e15596;
var statearr_15597_15632 = state_15551;
(statearr_15597_15632[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15551);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15596;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15633 = state_15551;
state_15551 = G__15633;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15551){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15603,mults,ensure_mult,p))
})();
var state__7696__auto__ = (function (){var statearr_15598 = f__7695__auto__.call(null);
(statearr_15598[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15603);

return statearr_15598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15603,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args15634 = [];
var len__5627__auto___15637 = arguments.length;
var i__5628__auto___15638 = (0);
while(true){
if((i__5628__auto___15638 < len__5627__auto___15637)){
args15634.push((arguments[i__5628__auto___15638]));

var G__15639 = (i__5628__auto___15638 + (1));
i__5628__auto___15638 = G__15639;
continue;
} else {
}
break;
}

var G__15636 = args15634.length;
switch (G__15636) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15634.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args15641 = [];
var len__5627__auto___15644 = arguments.length;
var i__5628__auto___15645 = (0);
while(true){
if((i__5628__auto___15645 < len__5627__auto___15644)){
args15641.push((arguments[i__5628__auto___15645]));

var G__15646 = (i__5628__auto___15645 + (1));
i__5628__auto___15645 = G__15646;
continue;
} else {
}
break;
}

var G__15643 = args15641.length;
switch (G__15643) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15641.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args15648 = [];
var len__5627__auto___15719 = arguments.length;
var i__5628__auto___15720 = (0);
while(true){
if((i__5628__auto___15720 < len__5627__auto___15719)){
args15648.push((arguments[i__5628__auto___15720]));

var G__15721 = (i__5628__auto___15720 + (1));
i__5628__auto___15720 = G__15721;
continue;
} else {
}
break;
}

var G__15650 = args15648.length;
switch (G__15650) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15648.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__7694__auto___15723 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15723,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15723,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_15689){
var state_val_15690 = (state_15689[(1)]);
if((state_val_15690 === (7))){
var state_15689__$1 = state_15689;
var statearr_15691_15724 = state_15689__$1;
(statearr_15691_15724[(2)] = null);

(statearr_15691_15724[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15690 === (1))){
var state_15689__$1 = state_15689;
var statearr_15692_15725 = state_15689__$1;
(statearr_15692_15725[(2)] = null);

(statearr_15692_15725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15690 === (4))){
var inst_15653 = (state_15689[(7)]);
var inst_15655 = (inst_15653 < cnt);
var state_15689__$1 = state_15689;
if(cljs.core.truth_(inst_15655)){
var statearr_15693_15726 = state_15689__$1;
(statearr_15693_15726[(1)] = (6));

} else {
var statearr_15694_15727 = state_15689__$1;
(statearr_15694_15727[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15690 === (15))){
var inst_15685 = (state_15689[(2)]);
var state_15689__$1 = state_15689;
var statearr_15695_15728 = state_15689__$1;
(statearr_15695_15728[(2)] = inst_15685);

(statearr_15695_15728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15690 === (13))){
var inst_15678 = cljs.core.async.close_BANG_.call(null,out);
var state_15689__$1 = state_15689;
var statearr_15696_15729 = state_15689__$1;
(statearr_15696_15729[(2)] = inst_15678);

(statearr_15696_15729[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15690 === (6))){
var state_15689__$1 = state_15689;
var statearr_15697_15730 = state_15689__$1;
(statearr_15697_15730[(2)] = null);

(statearr_15697_15730[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15690 === (3))){
var inst_15687 = (state_15689[(2)]);
var state_15689__$1 = state_15689;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15689__$1,inst_15687);
} else {
if((state_val_15690 === (12))){
var inst_15675 = (state_15689[(8)]);
var inst_15675__$1 = (state_15689[(2)]);
var inst_15676 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_15675__$1);
var state_15689__$1 = (function (){var statearr_15698 = state_15689;
(statearr_15698[(8)] = inst_15675__$1);

return statearr_15698;
})();
if(cljs.core.truth_(inst_15676)){
var statearr_15699_15731 = state_15689__$1;
(statearr_15699_15731[(1)] = (13));

} else {
var statearr_15700_15732 = state_15689__$1;
(statearr_15700_15732[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15690 === (2))){
var inst_15652 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_15653 = (0);
var state_15689__$1 = (function (){var statearr_15701 = state_15689;
(statearr_15701[(7)] = inst_15653);

(statearr_15701[(9)] = inst_15652);

return statearr_15701;
})();
var statearr_15702_15733 = state_15689__$1;
(statearr_15702_15733[(2)] = null);

(statearr_15702_15733[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15690 === (11))){
var inst_15653 = (state_15689[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_15689,(10),Object,null,(9));
var inst_15662 = chs__$1.call(null,inst_15653);
var inst_15663 = done.call(null,inst_15653);
var inst_15664 = cljs.core.async.take_BANG_.call(null,inst_15662,inst_15663);
var state_15689__$1 = state_15689;
var statearr_15703_15734 = state_15689__$1;
(statearr_15703_15734[(2)] = inst_15664);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15689__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15690 === (9))){
var inst_15653 = (state_15689[(7)]);
var inst_15666 = (state_15689[(2)]);
var inst_15667 = (inst_15653 + (1));
var inst_15653__$1 = inst_15667;
var state_15689__$1 = (function (){var statearr_15704 = state_15689;
(statearr_15704[(7)] = inst_15653__$1);

(statearr_15704[(10)] = inst_15666);

return statearr_15704;
})();
var statearr_15705_15735 = state_15689__$1;
(statearr_15705_15735[(2)] = null);

(statearr_15705_15735[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15690 === (5))){
var inst_15673 = (state_15689[(2)]);
var state_15689__$1 = (function (){var statearr_15706 = state_15689;
(statearr_15706[(11)] = inst_15673);

return statearr_15706;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15689__$1,(12),dchan);
} else {
if((state_val_15690 === (14))){
var inst_15675 = (state_15689[(8)]);
var inst_15680 = cljs.core.apply.call(null,f,inst_15675);
var state_15689__$1 = state_15689;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15689__$1,(16),out,inst_15680);
} else {
if((state_val_15690 === (16))){
var inst_15682 = (state_15689[(2)]);
var state_15689__$1 = (function (){var statearr_15707 = state_15689;
(statearr_15707[(12)] = inst_15682);

return statearr_15707;
})();
var statearr_15708_15736 = state_15689__$1;
(statearr_15708_15736[(2)] = null);

(statearr_15708_15736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15690 === (10))){
var inst_15657 = (state_15689[(2)]);
var inst_15658 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_15689__$1 = (function (){var statearr_15709 = state_15689;
(statearr_15709[(13)] = inst_15657);

return statearr_15709;
})();
var statearr_15710_15737 = state_15689__$1;
(statearr_15710_15737[(2)] = inst_15658);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15689__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15690 === (8))){
var inst_15671 = (state_15689[(2)]);
var state_15689__$1 = state_15689;
var statearr_15711_15738 = state_15689__$1;
(statearr_15711_15738[(2)] = inst_15671);

(statearr_15711_15738[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15723,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__7673__auto__,c__7694__auto___15723,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15715 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15715[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15715[(1)] = (1));

return statearr_15715;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15689){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15689);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15716){if((e15716 instanceof Object)){
var ex__7677__auto__ = e15716;
var statearr_15717_15739 = state_15689;
(statearr_15717_15739[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15689);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15716;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15740 = state_15689;
state_15689 = G__15740;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15689){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15723,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__7696__auto__ = (function (){var statearr_15718 = f__7695__auto__.call(null);
(statearr_15718[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15723);

return statearr_15718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15723,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args15742 = [];
var len__5627__auto___15798 = arguments.length;
var i__5628__auto___15799 = (0);
while(true){
if((i__5628__auto___15799 < len__5627__auto___15798)){
args15742.push((arguments[i__5628__auto___15799]));

var G__15800 = (i__5628__auto___15799 + (1));
i__5628__auto___15799 = G__15800;
continue;
} else {
}
break;
}

var G__15744 = args15742.length;
switch (G__15744) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15742.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___15802 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15802,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15802,out){
return (function (state_15774){
var state_val_15775 = (state_15774[(1)]);
if((state_val_15775 === (7))){
var inst_15753 = (state_15774[(7)]);
var inst_15754 = (state_15774[(8)]);
var inst_15753__$1 = (state_15774[(2)]);
var inst_15754__$1 = cljs.core.nth.call(null,inst_15753__$1,(0),null);
var inst_15755 = cljs.core.nth.call(null,inst_15753__$1,(1),null);
var inst_15756 = (inst_15754__$1 == null);
var state_15774__$1 = (function (){var statearr_15776 = state_15774;
(statearr_15776[(7)] = inst_15753__$1);

(statearr_15776[(8)] = inst_15754__$1);

(statearr_15776[(9)] = inst_15755);

return statearr_15776;
})();
if(cljs.core.truth_(inst_15756)){
var statearr_15777_15803 = state_15774__$1;
(statearr_15777_15803[(1)] = (8));

} else {
var statearr_15778_15804 = state_15774__$1;
(statearr_15778_15804[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15775 === (1))){
var inst_15745 = cljs.core.vec.call(null,chs);
var inst_15746 = inst_15745;
var state_15774__$1 = (function (){var statearr_15779 = state_15774;
(statearr_15779[(10)] = inst_15746);

return statearr_15779;
})();
var statearr_15780_15805 = state_15774__$1;
(statearr_15780_15805[(2)] = null);

(statearr_15780_15805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15775 === (4))){
var inst_15746 = (state_15774[(10)]);
var state_15774__$1 = state_15774;
return cljs.core.async.ioc_alts_BANG_.call(null,state_15774__$1,(7),inst_15746);
} else {
if((state_val_15775 === (6))){
var inst_15770 = (state_15774[(2)]);
var state_15774__$1 = state_15774;
var statearr_15781_15806 = state_15774__$1;
(statearr_15781_15806[(2)] = inst_15770);

(statearr_15781_15806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15775 === (3))){
var inst_15772 = (state_15774[(2)]);
var state_15774__$1 = state_15774;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15774__$1,inst_15772);
} else {
if((state_val_15775 === (2))){
var inst_15746 = (state_15774[(10)]);
var inst_15748 = cljs.core.count.call(null,inst_15746);
var inst_15749 = (inst_15748 > (0));
var state_15774__$1 = state_15774;
if(cljs.core.truth_(inst_15749)){
var statearr_15783_15807 = state_15774__$1;
(statearr_15783_15807[(1)] = (4));

} else {
var statearr_15784_15808 = state_15774__$1;
(statearr_15784_15808[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15775 === (11))){
var inst_15746 = (state_15774[(10)]);
var inst_15763 = (state_15774[(2)]);
var tmp15782 = inst_15746;
var inst_15746__$1 = tmp15782;
var state_15774__$1 = (function (){var statearr_15785 = state_15774;
(statearr_15785[(10)] = inst_15746__$1);

(statearr_15785[(11)] = inst_15763);

return statearr_15785;
})();
var statearr_15786_15809 = state_15774__$1;
(statearr_15786_15809[(2)] = null);

(statearr_15786_15809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15775 === (9))){
var inst_15754 = (state_15774[(8)]);
var state_15774__$1 = state_15774;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15774__$1,(11),out,inst_15754);
} else {
if((state_val_15775 === (5))){
var inst_15768 = cljs.core.async.close_BANG_.call(null,out);
var state_15774__$1 = state_15774;
var statearr_15787_15810 = state_15774__$1;
(statearr_15787_15810[(2)] = inst_15768);

(statearr_15787_15810[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15775 === (10))){
var inst_15766 = (state_15774[(2)]);
var state_15774__$1 = state_15774;
var statearr_15788_15811 = state_15774__$1;
(statearr_15788_15811[(2)] = inst_15766);

(statearr_15788_15811[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15775 === (8))){
var inst_15753 = (state_15774[(7)]);
var inst_15754 = (state_15774[(8)]);
var inst_15746 = (state_15774[(10)]);
var inst_15755 = (state_15774[(9)]);
var inst_15758 = (function (){var cs = inst_15746;
var vec__15751 = inst_15753;
var v = inst_15754;
var c = inst_15755;
return ((function (cs,vec__15751,v,c,inst_15753,inst_15754,inst_15746,inst_15755,state_val_15775,c__7694__auto___15802,out){
return (function (p1__15741_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__15741_SHARP_);
});
;})(cs,vec__15751,v,c,inst_15753,inst_15754,inst_15746,inst_15755,state_val_15775,c__7694__auto___15802,out))
})();
var inst_15759 = cljs.core.filterv.call(null,inst_15758,inst_15746);
var inst_15746__$1 = inst_15759;
var state_15774__$1 = (function (){var statearr_15789 = state_15774;
(statearr_15789[(10)] = inst_15746__$1);

return statearr_15789;
})();
var statearr_15790_15812 = state_15774__$1;
(statearr_15790_15812[(2)] = null);

(statearr_15790_15812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15802,out))
;
return ((function (switch__7673__auto__,c__7694__auto___15802,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15794 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15794[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15794[(1)] = (1));

return statearr_15794;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15774){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15774);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15795){if((e15795 instanceof Object)){
var ex__7677__auto__ = e15795;
var statearr_15796_15813 = state_15774;
(statearr_15796_15813[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15774);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15795;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15814 = state_15774;
state_15774 = G__15814;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15774){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15802,out))
})();
var state__7696__auto__ = (function (){var statearr_15797 = f__7695__auto__.call(null);
(statearr_15797[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15802);

return statearr_15797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15802,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args15815 = [];
var len__5627__auto___15864 = arguments.length;
var i__5628__auto___15865 = (0);
while(true){
if((i__5628__auto___15865 < len__5627__auto___15864)){
args15815.push((arguments[i__5628__auto___15865]));

var G__15866 = (i__5628__auto___15865 + (1));
i__5628__auto___15865 = G__15866;
continue;
} else {
}
break;
}

var G__15817 = args15815.length;
switch (G__15817) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15815.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___15868 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15868,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15868,out){
return (function (state_15841){
var state_val_15842 = (state_15841[(1)]);
if((state_val_15842 === (7))){
var inst_15823 = (state_15841[(7)]);
var inst_15823__$1 = (state_15841[(2)]);
var inst_15824 = (inst_15823__$1 == null);
var inst_15825 = cljs.core.not.call(null,inst_15824);
var state_15841__$1 = (function (){var statearr_15843 = state_15841;
(statearr_15843[(7)] = inst_15823__$1);

return statearr_15843;
})();
if(inst_15825){
var statearr_15844_15869 = state_15841__$1;
(statearr_15844_15869[(1)] = (8));

} else {
var statearr_15845_15870 = state_15841__$1;
(statearr_15845_15870[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15842 === (1))){
var inst_15818 = (0);
var state_15841__$1 = (function (){var statearr_15846 = state_15841;
(statearr_15846[(8)] = inst_15818);

return statearr_15846;
})();
var statearr_15847_15871 = state_15841__$1;
(statearr_15847_15871[(2)] = null);

(statearr_15847_15871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15842 === (4))){
var state_15841__$1 = state_15841;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15841__$1,(7),ch);
} else {
if((state_val_15842 === (6))){
var inst_15836 = (state_15841[(2)]);
var state_15841__$1 = state_15841;
var statearr_15848_15872 = state_15841__$1;
(statearr_15848_15872[(2)] = inst_15836);

(statearr_15848_15872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15842 === (3))){
var inst_15838 = (state_15841[(2)]);
var inst_15839 = cljs.core.async.close_BANG_.call(null,out);
var state_15841__$1 = (function (){var statearr_15849 = state_15841;
(statearr_15849[(9)] = inst_15838);

return statearr_15849;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15841__$1,inst_15839);
} else {
if((state_val_15842 === (2))){
var inst_15818 = (state_15841[(8)]);
var inst_15820 = (inst_15818 < n);
var state_15841__$1 = state_15841;
if(cljs.core.truth_(inst_15820)){
var statearr_15850_15873 = state_15841__$1;
(statearr_15850_15873[(1)] = (4));

} else {
var statearr_15851_15874 = state_15841__$1;
(statearr_15851_15874[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15842 === (11))){
var inst_15818 = (state_15841[(8)]);
var inst_15828 = (state_15841[(2)]);
var inst_15829 = (inst_15818 + (1));
var inst_15818__$1 = inst_15829;
var state_15841__$1 = (function (){var statearr_15852 = state_15841;
(statearr_15852[(10)] = inst_15828);

(statearr_15852[(8)] = inst_15818__$1);

return statearr_15852;
})();
var statearr_15853_15875 = state_15841__$1;
(statearr_15853_15875[(2)] = null);

(statearr_15853_15875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15842 === (9))){
var state_15841__$1 = state_15841;
var statearr_15854_15876 = state_15841__$1;
(statearr_15854_15876[(2)] = null);

(statearr_15854_15876[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15842 === (5))){
var state_15841__$1 = state_15841;
var statearr_15855_15877 = state_15841__$1;
(statearr_15855_15877[(2)] = null);

(statearr_15855_15877[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15842 === (10))){
var inst_15833 = (state_15841[(2)]);
var state_15841__$1 = state_15841;
var statearr_15856_15878 = state_15841__$1;
(statearr_15856_15878[(2)] = inst_15833);

(statearr_15856_15878[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15842 === (8))){
var inst_15823 = (state_15841[(7)]);
var state_15841__$1 = state_15841;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15841__$1,(11),out,inst_15823);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15868,out))
;
return ((function (switch__7673__auto__,c__7694__auto___15868,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15860 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15860[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15860[(1)] = (1));

return statearr_15860;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15841){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15841);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15861){if((e15861 instanceof Object)){
var ex__7677__auto__ = e15861;
var statearr_15862_15879 = state_15841;
(statearr_15862_15879[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15841);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15861;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15880 = state_15841;
state_15841 = G__15880;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15841){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15868,out))
})();
var state__7696__auto__ = (function (){var statearr_15863 = f__7695__auto__.call(null);
(statearr_15863[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15868);

return statearr_15863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15868,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async15888 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15888 = (function (map_LT_,f,ch,meta15889){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta15889 = meta15889;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15888.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15890,meta15889__$1){
var self__ = this;
var _15890__$1 = this;
return (new cljs.core.async.t_cljs$core$async15888(self__.map_LT_,self__.f,self__.ch,meta15889__$1));
});

cljs.core.async.t_cljs$core$async15888.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15890){
var self__ = this;
var _15890__$1 = this;
return self__.meta15889;
});

cljs.core.async.t_cljs$core$async15888.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async15888.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15888.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15888.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async15888.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async15891 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15891 = (function (map_LT_,f,ch,meta15889,_,fn1,meta15892){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta15889 = meta15889;
this._ = _;
this.fn1 = fn1;
this.meta15892 = meta15892;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15891.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_15893,meta15892__$1){
var self__ = this;
var _15893__$1 = this;
return (new cljs.core.async.t_cljs$core$async15891(self__.map_LT_,self__.f,self__.ch,self__.meta15889,self__._,self__.fn1,meta15892__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async15891.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_15893){
var self__ = this;
var _15893__$1 = this;
return self__.meta15892;
});})(___$1))
;

cljs.core.async.t_cljs$core$async15891.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async15891.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async15891.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__15881_SHARP_){
return f1.call(null,(((p1__15881_SHARP_ == null))?null:self__.f.call(null,p1__15881_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async15891.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15889","meta15889",892897892,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async15888","cljs.core.async/t_cljs$core$async15888",1340431885,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta15892","meta15892",-1164503956,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async15891.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15891.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15891";

cljs.core.async.t_cljs$core$async15891.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15891");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async15891 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15891(map_LT___$1,f__$1,ch__$1,meta15889__$1,___$2,fn1__$1,meta15892){
return (new cljs.core.async.t_cljs$core$async15891(map_LT___$1,f__$1,ch__$1,meta15889__$1,___$2,fn1__$1,meta15892));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async15891(self__.map_LT_,self__.f,self__.ch,self__.meta15889,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4557__auto__ = ret;
if(cljs.core.truth_(and__4557__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4557__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async15888.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async15888.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async15888.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15889","meta15889",892897892,null)], null);
});

cljs.core.async.t_cljs$core$async15888.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15888.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15888";

cljs.core.async.t_cljs$core$async15888.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15888");
});

cljs.core.async.__GT_t_cljs$core$async15888 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15888(map_LT___$1,f__$1,ch__$1,meta15889){
return (new cljs.core.async.t_cljs$core$async15888(map_LT___$1,f__$1,ch__$1,meta15889));
});

}

return (new cljs.core.async.t_cljs$core$async15888(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async15897 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15897 = (function (map_GT_,f,ch,meta15898){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta15898 = meta15898;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15897.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15899,meta15898__$1){
var self__ = this;
var _15899__$1 = this;
return (new cljs.core.async.t_cljs$core$async15897(self__.map_GT_,self__.f,self__.ch,meta15898__$1));
});

cljs.core.async.t_cljs$core$async15897.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15899){
var self__ = this;
var _15899__$1 = this;
return self__.meta15898;
});

cljs.core.async.t_cljs$core$async15897.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async15897.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15897.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async15897.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async15897.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async15897.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async15897.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15898","meta15898",1412915772,null)], null);
});

cljs.core.async.t_cljs$core$async15897.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15897.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15897";

cljs.core.async.t_cljs$core$async15897.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15897");
});

cljs.core.async.__GT_t_cljs$core$async15897 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async15897(map_GT___$1,f__$1,ch__$1,meta15898){
return (new cljs.core.async.t_cljs$core$async15897(map_GT___$1,f__$1,ch__$1,meta15898));
});

}

return (new cljs.core.async.t_cljs$core$async15897(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async15903 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15903 = (function (filter_GT_,p,ch,meta15904){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta15904 = meta15904;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15903.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15905,meta15904__$1){
var self__ = this;
var _15905__$1 = this;
return (new cljs.core.async.t_cljs$core$async15903(self__.filter_GT_,self__.p,self__.ch,meta15904__$1));
});

cljs.core.async.t_cljs$core$async15903.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15905){
var self__ = this;
var _15905__$1 = this;
return self__.meta15904;
});

cljs.core.async.t_cljs$core$async15903.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async15903.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15903.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15903.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async15903.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async15903.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async15903.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async15903.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15904","meta15904",-963740210,null)], null);
});

cljs.core.async.t_cljs$core$async15903.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15903.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15903";

cljs.core.async.t_cljs$core$async15903.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15903");
});

cljs.core.async.__GT_t_cljs$core$async15903 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async15903(filter_GT___$1,p__$1,ch__$1,meta15904){
return (new cljs.core.async.t_cljs$core$async15903(filter_GT___$1,p__$1,ch__$1,meta15904));
});

}

return (new cljs.core.async.t_cljs$core$async15903(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args15906 = [];
var len__5627__auto___15950 = arguments.length;
var i__5628__auto___15951 = (0);
while(true){
if((i__5628__auto___15951 < len__5627__auto___15950)){
args15906.push((arguments[i__5628__auto___15951]));

var G__15952 = (i__5628__auto___15951 + (1));
i__5628__auto___15951 = G__15952;
continue;
} else {
}
break;
}

var G__15908 = args15906.length;
switch (G__15908) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15906.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___15954 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15954,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15954,out){
return (function (state_15929){
var state_val_15930 = (state_15929[(1)]);
if((state_val_15930 === (7))){
var inst_15925 = (state_15929[(2)]);
var state_15929__$1 = state_15929;
var statearr_15931_15955 = state_15929__$1;
(statearr_15931_15955[(2)] = inst_15925);

(statearr_15931_15955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15930 === (1))){
var state_15929__$1 = state_15929;
var statearr_15932_15956 = state_15929__$1;
(statearr_15932_15956[(2)] = null);

(statearr_15932_15956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15930 === (4))){
var inst_15911 = (state_15929[(7)]);
var inst_15911__$1 = (state_15929[(2)]);
var inst_15912 = (inst_15911__$1 == null);
var state_15929__$1 = (function (){var statearr_15933 = state_15929;
(statearr_15933[(7)] = inst_15911__$1);

return statearr_15933;
})();
if(cljs.core.truth_(inst_15912)){
var statearr_15934_15957 = state_15929__$1;
(statearr_15934_15957[(1)] = (5));

} else {
var statearr_15935_15958 = state_15929__$1;
(statearr_15935_15958[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15930 === (6))){
var inst_15911 = (state_15929[(7)]);
var inst_15916 = p.call(null,inst_15911);
var state_15929__$1 = state_15929;
if(cljs.core.truth_(inst_15916)){
var statearr_15936_15959 = state_15929__$1;
(statearr_15936_15959[(1)] = (8));

} else {
var statearr_15937_15960 = state_15929__$1;
(statearr_15937_15960[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15930 === (3))){
var inst_15927 = (state_15929[(2)]);
var state_15929__$1 = state_15929;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15929__$1,inst_15927);
} else {
if((state_val_15930 === (2))){
var state_15929__$1 = state_15929;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15929__$1,(4),ch);
} else {
if((state_val_15930 === (11))){
var inst_15919 = (state_15929[(2)]);
var state_15929__$1 = state_15929;
var statearr_15938_15961 = state_15929__$1;
(statearr_15938_15961[(2)] = inst_15919);

(statearr_15938_15961[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15930 === (9))){
var state_15929__$1 = state_15929;
var statearr_15939_15962 = state_15929__$1;
(statearr_15939_15962[(2)] = null);

(statearr_15939_15962[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15930 === (5))){
var inst_15914 = cljs.core.async.close_BANG_.call(null,out);
var state_15929__$1 = state_15929;
var statearr_15940_15963 = state_15929__$1;
(statearr_15940_15963[(2)] = inst_15914);

(statearr_15940_15963[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15930 === (10))){
var inst_15922 = (state_15929[(2)]);
var state_15929__$1 = (function (){var statearr_15941 = state_15929;
(statearr_15941[(8)] = inst_15922);

return statearr_15941;
})();
var statearr_15942_15964 = state_15929__$1;
(statearr_15942_15964[(2)] = null);

(statearr_15942_15964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15930 === (8))){
var inst_15911 = (state_15929[(7)]);
var state_15929__$1 = state_15929;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15929__$1,(11),out,inst_15911);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15954,out))
;
return ((function (switch__7673__auto__,c__7694__auto___15954,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15946 = [null,null,null,null,null,null,null,null,null];
(statearr_15946[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15946[(1)] = (1));

return statearr_15946;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15929){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15929);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15947){if((e15947 instanceof Object)){
var ex__7677__auto__ = e15947;
var statearr_15948_15965 = state_15929;
(statearr_15948_15965[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15929);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15947;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15966 = state_15929;
state_15929 = G__15966;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15929){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15954,out))
})();
var state__7696__auto__ = (function (){var statearr_15949 = f__7695__auto__.call(null);
(statearr_15949[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15954);

return statearr_15949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15954,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args15967 = [];
var len__5627__auto___15970 = arguments.length;
var i__5628__auto___15971 = (0);
while(true){
if((i__5628__auto___15971 < len__5627__auto___15970)){
args15967.push((arguments[i__5628__auto___15971]));

var G__15972 = (i__5628__auto___15971 + (1));
i__5628__auto___15971 = G__15972;
continue;
} else {
}
break;
}

var G__15969 = args15967.length;
switch (G__15969) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15967.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__){
return (function (state_16139){
var state_val_16140 = (state_16139[(1)]);
if((state_val_16140 === (7))){
var inst_16135 = (state_16139[(2)]);
var state_16139__$1 = state_16139;
var statearr_16141_16182 = state_16139__$1;
(statearr_16141_16182[(2)] = inst_16135);

(statearr_16141_16182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (20))){
var inst_16105 = (state_16139[(7)]);
var inst_16116 = (state_16139[(2)]);
var inst_16117 = cljs.core.next.call(null,inst_16105);
var inst_16091 = inst_16117;
var inst_16092 = null;
var inst_16093 = (0);
var inst_16094 = (0);
var state_16139__$1 = (function (){var statearr_16142 = state_16139;
(statearr_16142[(8)] = inst_16092);

(statearr_16142[(9)] = inst_16093);

(statearr_16142[(10)] = inst_16091);

(statearr_16142[(11)] = inst_16094);

(statearr_16142[(12)] = inst_16116);

return statearr_16142;
})();
var statearr_16143_16183 = state_16139__$1;
(statearr_16143_16183[(2)] = null);

(statearr_16143_16183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (1))){
var state_16139__$1 = state_16139;
var statearr_16144_16184 = state_16139__$1;
(statearr_16144_16184[(2)] = null);

(statearr_16144_16184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (4))){
var inst_16080 = (state_16139[(13)]);
var inst_16080__$1 = (state_16139[(2)]);
var inst_16081 = (inst_16080__$1 == null);
var state_16139__$1 = (function (){var statearr_16145 = state_16139;
(statearr_16145[(13)] = inst_16080__$1);

return statearr_16145;
})();
if(cljs.core.truth_(inst_16081)){
var statearr_16146_16185 = state_16139__$1;
(statearr_16146_16185[(1)] = (5));

} else {
var statearr_16147_16186 = state_16139__$1;
(statearr_16147_16186[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (15))){
var state_16139__$1 = state_16139;
var statearr_16151_16187 = state_16139__$1;
(statearr_16151_16187[(2)] = null);

(statearr_16151_16187[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (21))){
var state_16139__$1 = state_16139;
var statearr_16152_16188 = state_16139__$1;
(statearr_16152_16188[(2)] = null);

(statearr_16152_16188[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (13))){
var inst_16092 = (state_16139[(8)]);
var inst_16093 = (state_16139[(9)]);
var inst_16091 = (state_16139[(10)]);
var inst_16094 = (state_16139[(11)]);
var inst_16101 = (state_16139[(2)]);
var inst_16102 = (inst_16094 + (1));
var tmp16148 = inst_16092;
var tmp16149 = inst_16093;
var tmp16150 = inst_16091;
var inst_16091__$1 = tmp16150;
var inst_16092__$1 = tmp16148;
var inst_16093__$1 = tmp16149;
var inst_16094__$1 = inst_16102;
var state_16139__$1 = (function (){var statearr_16153 = state_16139;
(statearr_16153[(8)] = inst_16092__$1);

(statearr_16153[(9)] = inst_16093__$1);

(statearr_16153[(10)] = inst_16091__$1);

(statearr_16153[(14)] = inst_16101);

(statearr_16153[(11)] = inst_16094__$1);

return statearr_16153;
})();
var statearr_16154_16189 = state_16139__$1;
(statearr_16154_16189[(2)] = null);

(statearr_16154_16189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (22))){
var state_16139__$1 = state_16139;
var statearr_16155_16190 = state_16139__$1;
(statearr_16155_16190[(2)] = null);

(statearr_16155_16190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (6))){
var inst_16080 = (state_16139[(13)]);
var inst_16089 = f.call(null,inst_16080);
var inst_16090 = cljs.core.seq.call(null,inst_16089);
var inst_16091 = inst_16090;
var inst_16092 = null;
var inst_16093 = (0);
var inst_16094 = (0);
var state_16139__$1 = (function (){var statearr_16156 = state_16139;
(statearr_16156[(8)] = inst_16092);

(statearr_16156[(9)] = inst_16093);

(statearr_16156[(10)] = inst_16091);

(statearr_16156[(11)] = inst_16094);

return statearr_16156;
})();
var statearr_16157_16191 = state_16139__$1;
(statearr_16157_16191[(2)] = null);

(statearr_16157_16191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (17))){
var inst_16105 = (state_16139[(7)]);
var inst_16109 = cljs.core.chunk_first.call(null,inst_16105);
var inst_16110 = cljs.core.chunk_rest.call(null,inst_16105);
var inst_16111 = cljs.core.count.call(null,inst_16109);
var inst_16091 = inst_16110;
var inst_16092 = inst_16109;
var inst_16093 = inst_16111;
var inst_16094 = (0);
var state_16139__$1 = (function (){var statearr_16158 = state_16139;
(statearr_16158[(8)] = inst_16092);

(statearr_16158[(9)] = inst_16093);

(statearr_16158[(10)] = inst_16091);

(statearr_16158[(11)] = inst_16094);

return statearr_16158;
})();
var statearr_16159_16192 = state_16139__$1;
(statearr_16159_16192[(2)] = null);

(statearr_16159_16192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (3))){
var inst_16137 = (state_16139[(2)]);
var state_16139__$1 = state_16139;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16139__$1,inst_16137);
} else {
if((state_val_16140 === (12))){
var inst_16125 = (state_16139[(2)]);
var state_16139__$1 = state_16139;
var statearr_16160_16193 = state_16139__$1;
(statearr_16160_16193[(2)] = inst_16125);

(statearr_16160_16193[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (2))){
var state_16139__$1 = state_16139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16139__$1,(4),in$);
} else {
if((state_val_16140 === (23))){
var inst_16133 = (state_16139[(2)]);
var state_16139__$1 = state_16139;
var statearr_16161_16194 = state_16139__$1;
(statearr_16161_16194[(2)] = inst_16133);

(statearr_16161_16194[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (19))){
var inst_16120 = (state_16139[(2)]);
var state_16139__$1 = state_16139;
var statearr_16162_16195 = state_16139__$1;
(statearr_16162_16195[(2)] = inst_16120);

(statearr_16162_16195[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (11))){
var inst_16091 = (state_16139[(10)]);
var inst_16105 = (state_16139[(7)]);
var inst_16105__$1 = cljs.core.seq.call(null,inst_16091);
var state_16139__$1 = (function (){var statearr_16163 = state_16139;
(statearr_16163[(7)] = inst_16105__$1);

return statearr_16163;
})();
if(inst_16105__$1){
var statearr_16164_16196 = state_16139__$1;
(statearr_16164_16196[(1)] = (14));

} else {
var statearr_16165_16197 = state_16139__$1;
(statearr_16165_16197[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (9))){
var inst_16127 = (state_16139[(2)]);
var inst_16128 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_16139__$1 = (function (){var statearr_16166 = state_16139;
(statearr_16166[(15)] = inst_16127);

return statearr_16166;
})();
if(cljs.core.truth_(inst_16128)){
var statearr_16167_16198 = state_16139__$1;
(statearr_16167_16198[(1)] = (21));

} else {
var statearr_16168_16199 = state_16139__$1;
(statearr_16168_16199[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (5))){
var inst_16083 = cljs.core.async.close_BANG_.call(null,out);
var state_16139__$1 = state_16139;
var statearr_16169_16200 = state_16139__$1;
(statearr_16169_16200[(2)] = inst_16083);

(statearr_16169_16200[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (14))){
var inst_16105 = (state_16139[(7)]);
var inst_16107 = cljs.core.chunked_seq_QMARK_.call(null,inst_16105);
var state_16139__$1 = state_16139;
if(inst_16107){
var statearr_16170_16201 = state_16139__$1;
(statearr_16170_16201[(1)] = (17));

} else {
var statearr_16171_16202 = state_16139__$1;
(statearr_16171_16202[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (16))){
var inst_16123 = (state_16139[(2)]);
var state_16139__$1 = state_16139;
var statearr_16172_16203 = state_16139__$1;
(statearr_16172_16203[(2)] = inst_16123);

(statearr_16172_16203[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16140 === (10))){
var inst_16092 = (state_16139[(8)]);
var inst_16094 = (state_16139[(11)]);
var inst_16099 = cljs.core._nth.call(null,inst_16092,inst_16094);
var state_16139__$1 = state_16139;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16139__$1,(13),out,inst_16099);
} else {
if((state_val_16140 === (18))){
var inst_16105 = (state_16139[(7)]);
var inst_16114 = cljs.core.first.call(null,inst_16105);
var state_16139__$1 = state_16139;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16139__$1,(20),out,inst_16114);
} else {
if((state_val_16140 === (8))){
var inst_16093 = (state_16139[(9)]);
var inst_16094 = (state_16139[(11)]);
var inst_16096 = (inst_16094 < inst_16093);
var inst_16097 = inst_16096;
var state_16139__$1 = state_16139;
if(cljs.core.truth_(inst_16097)){
var statearr_16173_16204 = state_16139__$1;
(statearr_16173_16204[(1)] = (10));

} else {
var statearr_16174_16205 = state_16139__$1;
(statearr_16174_16205[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__))
;
return ((function (switch__7673__auto__,c__7694__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_16178 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16178[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__);

(statearr_16178[(1)] = (1));

return statearr_16178;
});
var cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____1 = (function (state_16139){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_16139);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e16179){if((e16179 instanceof Object)){
var ex__7677__auto__ = e16179;
var statearr_16180_16206 = state_16139;
(statearr_16180_16206[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16139);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16179;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16207 = state_16139;
state_16139 = G__16207;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__ = function(state_16139){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____1.call(this,state_16139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__))
})();
var state__7696__auto__ = (function (){var statearr_16181 = f__7695__auto__.call(null);
(statearr_16181[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_16181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__))
);

return c__7694__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args16208 = [];
var len__5627__auto___16211 = arguments.length;
var i__5628__auto___16212 = (0);
while(true){
if((i__5628__auto___16212 < len__5627__auto___16211)){
args16208.push((arguments[i__5628__auto___16212]));

var G__16213 = (i__5628__auto___16212 + (1));
i__5628__auto___16212 = G__16213;
continue;
} else {
}
break;
}

var G__16210 = args16208.length;
switch (G__16210) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16208.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args16215 = [];
var len__5627__auto___16218 = arguments.length;
var i__5628__auto___16219 = (0);
while(true){
if((i__5628__auto___16219 < len__5627__auto___16218)){
args16215.push((arguments[i__5628__auto___16219]));

var G__16220 = (i__5628__auto___16219 + (1));
i__5628__auto___16219 = G__16220;
continue;
} else {
}
break;
}

var G__16217 = args16215.length;
switch (G__16217) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16215.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args16222 = [];
var len__5627__auto___16273 = arguments.length;
var i__5628__auto___16274 = (0);
while(true){
if((i__5628__auto___16274 < len__5627__auto___16273)){
args16222.push((arguments[i__5628__auto___16274]));

var G__16275 = (i__5628__auto___16274 + (1));
i__5628__auto___16274 = G__16275;
continue;
} else {
}
break;
}

var G__16224 = args16222.length;
switch (G__16224) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16222.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___16277 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___16277,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___16277,out){
return (function (state_16248){
var state_val_16249 = (state_16248[(1)]);
if((state_val_16249 === (7))){
var inst_16243 = (state_16248[(2)]);
var state_16248__$1 = state_16248;
var statearr_16250_16278 = state_16248__$1;
(statearr_16250_16278[(2)] = inst_16243);

(statearr_16250_16278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16249 === (1))){
var inst_16225 = null;
var state_16248__$1 = (function (){var statearr_16251 = state_16248;
(statearr_16251[(7)] = inst_16225);

return statearr_16251;
})();
var statearr_16252_16279 = state_16248__$1;
(statearr_16252_16279[(2)] = null);

(statearr_16252_16279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16249 === (4))){
var inst_16228 = (state_16248[(8)]);
var inst_16228__$1 = (state_16248[(2)]);
var inst_16229 = (inst_16228__$1 == null);
var inst_16230 = cljs.core.not.call(null,inst_16229);
var state_16248__$1 = (function (){var statearr_16253 = state_16248;
(statearr_16253[(8)] = inst_16228__$1);

return statearr_16253;
})();
if(inst_16230){
var statearr_16254_16280 = state_16248__$1;
(statearr_16254_16280[(1)] = (5));

} else {
var statearr_16255_16281 = state_16248__$1;
(statearr_16255_16281[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16249 === (6))){
var state_16248__$1 = state_16248;
var statearr_16256_16282 = state_16248__$1;
(statearr_16256_16282[(2)] = null);

(statearr_16256_16282[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16249 === (3))){
var inst_16245 = (state_16248[(2)]);
var inst_16246 = cljs.core.async.close_BANG_.call(null,out);
var state_16248__$1 = (function (){var statearr_16257 = state_16248;
(statearr_16257[(9)] = inst_16245);

return statearr_16257;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16248__$1,inst_16246);
} else {
if((state_val_16249 === (2))){
var state_16248__$1 = state_16248;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16248__$1,(4),ch);
} else {
if((state_val_16249 === (11))){
var inst_16228 = (state_16248[(8)]);
var inst_16237 = (state_16248[(2)]);
var inst_16225 = inst_16228;
var state_16248__$1 = (function (){var statearr_16258 = state_16248;
(statearr_16258[(10)] = inst_16237);

(statearr_16258[(7)] = inst_16225);

return statearr_16258;
})();
var statearr_16259_16283 = state_16248__$1;
(statearr_16259_16283[(2)] = null);

(statearr_16259_16283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16249 === (9))){
var inst_16228 = (state_16248[(8)]);
var state_16248__$1 = state_16248;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16248__$1,(11),out,inst_16228);
} else {
if((state_val_16249 === (5))){
var inst_16225 = (state_16248[(7)]);
var inst_16228 = (state_16248[(8)]);
var inst_16232 = cljs.core._EQ_.call(null,inst_16228,inst_16225);
var state_16248__$1 = state_16248;
if(inst_16232){
var statearr_16261_16284 = state_16248__$1;
(statearr_16261_16284[(1)] = (8));

} else {
var statearr_16262_16285 = state_16248__$1;
(statearr_16262_16285[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16249 === (10))){
var inst_16240 = (state_16248[(2)]);
var state_16248__$1 = state_16248;
var statearr_16263_16286 = state_16248__$1;
(statearr_16263_16286[(2)] = inst_16240);

(statearr_16263_16286[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16249 === (8))){
var inst_16225 = (state_16248[(7)]);
var tmp16260 = inst_16225;
var inst_16225__$1 = tmp16260;
var state_16248__$1 = (function (){var statearr_16264 = state_16248;
(statearr_16264[(7)] = inst_16225__$1);

return statearr_16264;
})();
var statearr_16265_16287 = state_16248__$1;
(statearr_16265_16287[(2)] = null);

(statearr_16265_16287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___16277,out))
;
return ((function (switch__7673__auto__,c__7694__auto___16277,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_16269 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16269[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_16269[(1)] = (1));

return statearr_16269;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_16248){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_16248);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e16270){if((e16270 instanceof Object)){
var ex__7677__auto__ = e16270;
var statearr_16271_16288 = state_16248;
(statearr_16271_16288[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16248);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16270;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16289 = state_16248;
state_16248 = G__16289;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_16248){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_16248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___16277,out))
})();
var state__7696__auto__ = (function (){var statearr_16272 = f__7695__auto__.call(null);
(statearr_16272[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___16277);

return statearr_16272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___16277,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args16290 = [];
var len__5627__auto___16360 = arguments.length;
var i__5628__auto___16361 = (0);
while(true){
if((i__5628__auto___16361 < len__5627__auto___16360)){
args16290.push((arguments[i__5628__auto___16361]));

var G__16362 = (i__5628__auto___16361 + (1));
i__5628__auto___16361 = G__16362;
continue;
} else {
}
break;
}

var G__16292 = args16290.length;
switch (G__16292) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16290.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___16364 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___16364,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___16364,out){
return (function (state_16330){
var state_val_16331 = (state_16330[(1)]);
if((state_val_16331 === (7))){
var inst_16326 = (state_16330[(2)]);
var state_16330__$1 = state_16330;
var statearr_16332_16365 = state_16330__$1;
(statearr_16332_16365[(2)] = inst_16326);

(statearr_16332_16365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (1))){
var inst_16293 = (new Array(n));
var inst_16294 = inst_16293;
var inst_16295 = (0);
var state_16330__$1 = (function (){var statearr_16333 = state_16330;
(statearr_16333[(7)] = inst_16294);

(statearr_16333[(8)] = inst_16295);

return statearr_16333;
})();
var statearr_16334_16366 = state_16330__$1;
(statearr_16334_16366[(2)] = null);

(statearr_16334_16366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (4))){
var inst_16298 = (state_16330[(9)]);
var inst_16298__$1 = (state_16330[(2)]);
var inst_16299 = (inst_16298__$1 == null);
var inst_16300 = cljs.core.not.call(null,inst_16299);
var state_16330__$1 = (function (){var statearr_16335 = state_16330;
(statearr_16335[(9)] = inst_16298__$1);

return statearr_16335;
})();
if(inst_16300){
var statearr_16336_16367 = state_16330__$1;
(statearr_16336_16367[(1)] = (5));

} else {
var statearr_16337_16368 = state_16330__$1;
(statearr_16337_16368[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (15))){
var inst_16320 = (state_16330[(2)]);
var state_16330__$1 = state_16330;
var statearr_16338_16369 = state_16330__$1;
(statearr_16338_16369[(2)] = inst_16320);

(statearr_16338_16369[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (13))){
var state_16330__$1 = state_16330;
var statearr_16339_16370 = state_16330__$1;
(statearr_16339_16370[(2)] = null);

(statearr_16339_16370[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (6))){
var inst_16295 = (state_16330[(8)]);
var inst_16316 = (inst_16295 > (0));
var state_16330__$1 = state_16330;
if(cljs.core.truth_(inst_16316)){
var statearr_16340_16371 = state_16330__$1;
(statearr_16340_16371[(1)] = (12));

} else {
var statearr_16341_16372 = state_16330__$1;
(statearr_16341_16372[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (3))){
var inst_16328 = (state_16330[(2)]);
var state_16330__$1 = state_16330;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16330__$1,inst_16328);
} else {
if((state_val_16331 === (12))){
var inst_16294 = (state_16330[(7)]);
var inst_16318 = cljs.core.vec.call(null,inst_16294);
var state_16330__$1 = state_16330;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16330__$1,(15),out,inst_16318);
} else {
if((state_val_16331 === (2))){
var state_16330__$1 = state_16330;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16330__$1,(4),ch);
} else {
if((state_val_16331 === (11))){
var inst_16310 = (state_16330[(2)]);
var inst_16311 = (new Array(n));
var inst_16294 = inst_16311;
var inst_16295 = (0);
var state_16330__$1 = (function (){var statearr_16342 = state_16330;
(statearr_16342[(10)] = inst_16310);

(statearr_16342[(7)] = inst_16294);

(statearr_16342[(8)] = inst_16295);

return statearr_16342;
})();
var statearr_16343_16373 = state_16330__$1;
(statearr_16343_16373[(2)] = null);

(statearr_16343_16373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (9))){
var inst_16294 = (state_16330[(7)]);
var inst_16308 = cljs.core.vec.call(null,inst_16294);
var state_16330__$1 = state_16330;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16330__$1,(11),out,inst_16308);
} else {
if((state_val_16331 === (5))){
var inst_16303 = (state_16330[(11)]);
var inst_16298 = (state_16330[(9)]);
var inst_16294 = (state_16330[(7)]);
var inst_16295 = (state_16330[(8)]);
var inst_16302 = (inst_16294[inst_16295] = inst_16298);
var inst_16303__$1 = (inst_16295 + (1));
var inst_16304 = (inst_16303__$1 < n);
var state_16330__$1 = (function (){var statearr_16344 = state_16330;
(statearr_16344[(11)] = inst_16303__$1);

(statearr_16344[(12)] = inst_16302);

return statearr_16344;
})();
if(cljs.core.truth_(inst_16304)){
var statearr_16345_16374 = state_16330__$1;
(statearr_16345_16374[(1)] = (8));

} else {
var statearr_16346_16375 = state_16330__$1;
(statearr_16346_16375[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (14))){
var inst_16323 = (state_16330[(2)]);
var inst_16324 = cljs.core.async.close_BANG_.call(null,out);
var state_16330__$1 = (function (){var statearr_16348 = state_16330;
(statearr_16348[(13)] = inst_16323);

return statearr_16348;
})();
var statearr_16349_16376 = state_16330__$1;
(statearr_16349_16376[(2)] = inst_16324);

(statearr_16349_16376[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (10))){
var inst_16314 = (state_16330[(2)]);
var state_16330__$1 = state_16330;
var statearr_16350_16377 = state_16330__$1;
(statearr_16350_16377[(2)] = inst_16314);

(statearr_16350_16377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (8))){
var inst_16303 = (state_16330[(11)]);
var inst_16294 = (state_16330[(7)]);
var tmp16347 = inst_16294;
var inst_16294__$1 = tmp16347;
var inst_16295 = inst_16303;
var state_16330__$1 = (function (){var statearr_16351 = state_16330;
(statearr_16351[(7)] = inst_16294__$1);

(statearr_16351[(8)] = inst_16295);

return statearr_16351;
})();
var statearr_16352_16378 = state_16330__$1;
(statearr_16352_16378[(2)] = null);

(statearr_16352_16378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___16364,out))
;
return ((function (switch__7673__auto__,c__7694__auto___16364,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_16356 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16356[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_16356[(1)] = (1));

return statearr_16356;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_16330){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_16330);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e16357){if((e16357 instanceof Object)){
var ex__7677__auto__ = e16357;
var statearr_16358_16379 = state_16330;
(statearr_16358_16379[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16330);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16357;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16380 = state_16330;
state_16330 = G__16380;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_16330){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_16330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___16364,out))
})();
var state__7696__auto__ = (function (){var statearr_16359 = f__7695__auto__.call(null);
(statearr_16359[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___16364);

return statearr_16359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___16364,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args16381 = [];
var len__5627__auto___16455 = arguments.length;
var i__5628__auto___16456 = (0);
while(true){
if((i__5628__auto___16456 < len__5627__auto___16455)){
args16381.push((arguments[i__5628__auto___16456]));

var G__16457 = (i__5628__auto___16456 + (1));
i__5628__auto___16456 = G__16457;
continue;
} else {
}
break;
}

var G__16383 = args16381.length;
switch (G__16383) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16381.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___16459 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___16459,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___16459,out){
return (function (state_16425){
var state_val_16426 = (state_16425[(1)]);
if((state_val_16426 === (7))){
var inst_16421 = (state_16425[(2)]);
var state_16425__$1 = state_16425;
var statearr_16427_16460 = state_16425__$1;
(statearr_16427_16460[(2)] = inst_16421);

(statearr_16427_16460[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16426 === (1))){
var inst_16384 = [];
var inst_16385 = inst_16384;
var inst_16386 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_16425__$1 = (function (){var statearr_16428 = state_16425;
(statearr_16428[(7)] = inst_16386);

(statearr_16428[(8)] = inst_16385);

return statearr_16428;
})();
var statearr_16429_16461 = state_16425__$1;
(statearr_16429_16461[(2)] = null);

(statearr_16429_16461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16426 === (4))){
var inst_16389 = (state_16425[(9)]);
var inst_16389__$1 = (state_16425[(2)]);
var inst_16390 = (inst_16389__$1 == null);
var inst_16391 = cljs.core.not.call(null,inst_16390);
var state_16425__$1 = (function (){var statearr_16430 = state_16425;
(statearr_16430[(9)] = inst_16389__$1);

return statearr_16430;
})();
if(inst_16391){
var statearr_16431_16462 = state_16425__$1;
(statearr_16431_16462[(1)] = (5));

} else {
var statearr_16432_16463 = state_16425__$1;
(statearr_16432_16463[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16426 === (15))){
var inst_16415 = (state_16425[(2)]);
var state_16425__$1 = state_16425;
var statearr_16433_16464 = state_16425__$1;
(statearr_16433_16464[(2)] = inst_16415);

(statearr_16433_16464[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16426 === (13))){
var state_16425__$1 = state_16425;
var statearr_16434_16465 = state_16425__$1;
(statearr_16434_16465[(2)] = null);

(statearr_16434_16465[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16426 === (6))){
var inst_16385 = (state_16425[(8)]);
var inst_16410 = inst_16385.length;
var inst_16411 = (inst_16410 > (0));
var state_16425__$1 = state_16425;
if(cljs.core.truth_(inst_16411)){
var statearr_16435_16466 = state_16425__$1;
(statearr_16435_16466[(1)] = (12));

} else {
var statearr_16436_16467 = state_16425__$1;
(statearr_16436_16467[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16426 === (3))){
var inst_16423 = (state_16425[(2)]);
var state_16425__$1 = state_16425;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16425__$1,inst_16423);
} else {
if((state_val_16426 === (12))){
var inst_16385 = (state_16425[(8)]);
var inst_16413 = cljs.core.vec.call(null,inst_16385);
var state_16425__$1 = state_16425;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16425__$1,(15),out,inst_16413);
} else {
if((state_val_16426 === (2))){
var state_16425__$1 = state_16425;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16425__$1,(4),ch);
} else {
if((state_val_16426 === (11))){
var inst_16389 = (state_16425[(9)]);
var inst_16393 = (state_16425[(10)]);
var inst_16403 = (state_16425[(2)]);
var inst_16404 = [];
var inst_16405 = inst_16404.push(inst_16389);
var inst_16385 = inst_16404;
var inst_16386 = inst_16393;
var state_16425__$1 = (function (){var statearr_16437 = state_16425;
(statearr_16437[(11)] = inst_16403);

(statearr_16437[(12)] = inst_16405);

(statearr_16437[(7)] = inst_16386);

(statearr_16437[(8)] = inst_16385);

return statearr_16437;
})();
var statearr_16438_16468 = state_16425__$1;
(statearr_16438_16468[(2)] = null);

(statearr_16438_16468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16426 === (9))){
var inst_16385 = (state_16425[(8)]);
var inst_16401 = cljs.core.vec.call(null,inst_16385);
var state_16425__$1 = state_16425;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16425__$1,(11),out,inst_16401);
} else {
if((state_val_16426 === (5))){
var inst_16389 = (state_16425[(9)]);
var inst_16386 = (state_16425[(7)]);
var inst_16393 = (state_16425[(10)]);
var inst_16393__$1 = f.call(null,inst_16389);
var inst_16394 = cljs.core._EQ_.call(null,inst_16393__$1,inst_16386);
var inst_16395 = cljs.core.keyword_identical_QMARK_.call(null,inst_16386,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_16396 = (inst_16394) || (inst_16395);
var state_16425__$1 = (function (){var statearr_16439 = state_16425;
(statearr_16439[(10)] = inst_16393__$1);

return statearr_16439;
})();
if(cljs.core.truth_(inst_16396)){
var statearr_16440_16469 = state_16425__$1;
(statearr_16440_16469[(1)] = (8));

} else {
var statearr_16441_16470 = state_16425__$1;
(statearr_16441_16470[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16426 === (14))){
var inst_16418 = (state_16425[(2)]);
var inst_16419 = cljs.core.async.close_BANG_.call(null,out);
var state_16425__$1 = (function (){var statearr_16443 = state_16425;
(statearr_16443[(13)] = inst_16418);

return statearr_16443;
})();
var statearr_16444_16471 = state_16425__$1;
(statearr_16444_16471[(2)] = inst_16419);

(statearr_16444_16471[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16426 === (10))){
var inst_16408 = (state_16425[(2)]);
var state_16425__$1 = state_16425;
var statearr_16445_16472 = state_16425__$1;
(statearr_16445_16472[(2)] = inst_16408);

(statearr_16445_16472[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16426 === (8))){
var inst_16389 = (state_16425[(9)]);
var inst_16385 = (state_16425[(8)]);
var inst_16393 = (state_16425[(10)]);
var inst_16398 = inst_16385.push(inst_16389);
var tmp16442 = inst_16385;
var inst_16385__$1 = tmp16442;
var inst_16386 = inst_16393;
var state_16425__$1 = (function (){var statearr_16446 = state_16425;
(statearr_16446[(7)] = inst_16386);

(statearr_16446[(14)] = inst_16398);

(statearr_16446[(8)] = inst_16385__$1);

return statearr_16446;
})();
var statearr_16447_16473 = state_16425__$1;
(statearr_16447_16473[(2)] = null);

(statearr_16447_16473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___16459,out))
;
return ((function (switch__7673__auto__,c__7694__auto___16459,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_16451 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16451[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_16451[(1)] = (1));

return statearr_16451;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_16425){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_16425);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e16452){if((e16452 instanceof Object)){
var ex__7677__auto__ = e16452;
var statearr_16453_16474 = state_16425;
(statearr_16453_16474[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16425);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16452;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16475 = state_16425;
state_16425 = G__16475;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_16425){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_16425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___16459,out))
})();
var state__7696__auto__ = (function (){var statearr_16454 = f__7695__auto__.call(null);
(statearr_16454[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___16459);

return statearr_16454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___16459,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
