// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__8429__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto__){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__){
return (function (state_94816){
var state_val_94817 = (state_94816[(1)]);
if((state_val_94817 === (7))){
var inst_94773 = (state_94816[(7)]);
var inst_94773__$1 = (state_94816[(2)]);
var inst_94775 = (inst_94773__$1 == null);
var inst_94776 = cljs.core.not(inst_94775);
var state_94816__$1 = (function (){var statearr_94818 = state_94816;
(statearr_94818[(7)] = inst_94773__$1);

return statearr_94818;
})();
if(inst_94776){
var statearr_94819_94856 = state_94816__$1;
(statearr_94819_94856[(1)] = (8));

} else {
var statearr_94820_94857 = state_94816__$1;
(statearr_94820_94857[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (20))){
var inst_94795 = (state_94816[(8)]);
var inst_94803 = (state_94816[(2)]);
var state_94816__$1 = (function (){var statearr_94821 = state_94816;
(statearr_94821[(9)] = inst_94803);

return statearr_94821;
})();
if(cljs.core.truth_(inst_94795)){
var statearr_94822_94858 = state_94816__$1;
(statearr_94822_94858[(1)] = (21));

} else {
var statearr_94823_94859 = state_94816__$1;
(statearr_94823_94859[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (1))){
var state_94816__$1 = state_94816;
var statearr_94824_94860 = state_94816__$1;
(statearr_94824_94860[(2)] = null);

(statearr_94824_94860[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (4))){
var state_94816__$1 = state_94816;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_94816__$1,(7),agg_data_channel);
} else {
if((state_val_94817 === (15))){
var inst_94773 = (state_94816[(7)]);
var state_94816__$1 = state_94816;
var statearr_94825_94861 = state_94816__$1;
(statearr_94825_94861[(2)] = inst_94773);

(statearr_94825_94861[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (21))){
var inst_94805 = cljs.core.async.close_BANG_(agg_data_channel);
var state_94816__$1 = state_94816;
var statearr_94826_94862 = state_94816__$1;
(statearr_94826_94862[(2)] = inst_94805);

(statearr_94826_94862[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (13))){
var inst_94785 = (state_94816[(2)]);
var state_94816__$1 = state_94816;
var statearr_94827_94863 = state_94816__$1;
(statearr_94827_94863[(2)] = inst_94785);

(statearr_94827_94863[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (22))){
var state_94816__$1 = state_94816;
var statearr_94828_94864 = state_94816__$1;
(statearr_94828_94864[(2)] = null);

(statearr_94828_94864[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (6))){
var inst_94812 = (state_94816[(2)]);
var state_94816__$1 = state_94816;
var statearr_94829_94865 = state_94816__$1;
(statearr_94829_94865[(2)] = inst_94812);

(statearr_94829_94865[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (17))){
var inst_94795 = (state_94816[(8)]);
var inst_94794 = (state_94816[(10)]);
var inst_94797 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_94794,inst_94795) : callback.call(null,inst_94794,inst_94795));
var state_94816__$1 = state_94816;
var statearr_94830_94866 = state_94816__$1;
(statearr_94830_94866[(2)] = inst_94797);

(statearr_94830_94866[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (3))){
var inst_94814 = (state_94816[(2)]);
var state_94816__$1 = state_94816;
return cljs.core.async.impl.ioc_helpers.return_chan(state_94816__$1,inst_94814);
} else {
if((state_val_94817 === (12))){
var state_94816__$1 = state_94816;
var statearr_94831_94867 = state_94816__$1;
(statearr_94831_94867[(2)] = false);

(statearr_94831_94867[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (2))){
var state_94816__$1 = state_94816;
var statearr_94832_94868 = state_94816__$1;
(statearr_94832_94868[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (23))){
var inst_94808 = (state_94816[(2)]);
var state_94816__$1 = (function (){var statearr_94834 = state_94816;
(statearr_94834[(11)] = inst_94808);

return statearr_94834;
})();
var statearr_94835_94869 = state_94816__$1;
(statearr_94835_94869[(2)] = null);

(statearr_94835_94869[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (19))){
var inst_94800 = (state_94816[(2)]);
var inst_94801 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_94816__$1 = (function (){var statearr_94836 = state_94816;
(statearr_94836[(12)] = inst_94800);

return statearr_94836;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_94816__$1,(20),inst_94801);
} else {
if((state_val_94817 === (11))){
var state_94816__$1 = state_94816;
var statearr_94837_94870 = state_94816__$1;
(statearr_94837_94870[(2)] = true);

(statearr_94837_94870[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (9))){
var state_94816__$1 = state_94816;
var statearr_94838_94871 = state_94816__$1;
(statearr_94838_94871[(2)] = false);

(statearr_94838_94871[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (5))){
var state_94816__$1 = state_94816;
var statearr_94839_94872 = state_94816__$1;
(statearr_94839_94872[(2)] = null);

(statearr_94839_94872[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (14))){
var inst_94773 = (state_94816[(7)]);
var inst_94790 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_94773);
var state_94816__$1 = state_94816;
var statearr_94840_94873 = state_94816__$1;
(statearr_94840_94873[(2)] = inst_94790);

(statearr_94840_94873[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (16))){
var inst_94794 = (state_94816[(10)]);
var inst_94793 = (state_94816[(2)]);
var inst_94794__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_94793,cljs.core.cst$kw$data);
var inst_94795 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_94793,cljs.core.cst$kw$completed_QMARK_);
var state_94816__$1 = (function (){var statearr_94841 = state_94816;
(statearr_94841[(8)] = inst_94795);

(statearr_94841[(10)] = inst_94794__$1);

return statearr_94841;
})();
if(cljs.core.truth_(inst_94794__$1)){
var statearr_94842_94874 = state_94816__$1;
(statearr_94842_94874[(1)] = (17));

} else {
var statearr_94843_94875 = state_94816__$1;
(statearr_94843_94875[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (10))){
var inst_94788 = (state_94816[(2)]);
var state_94816__$1 = state_94816;
if(cljs.core.truth_(inst_94788)){
var statearr_94844_94876 = state_94816__$1;
(statearr_94844_94876[(1)] = (14));

} else {
var statearr_94845_94877 = state_94816__$1;
(statearr_94845_94877[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (18))){
var state_94816__$1 = state_94816;
var statearr_94846_94878 = state_94816__$1;
(statearr_94846_94878[(2)] = null);

(statearr_94846_94878[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_94817 === (8))){
var inst_94773 = (state_94816[(7)]);
var inst_94778 = inst_94773.cljs$lang$protocol_mask$partition0$;
var inst_94779 = (inst_94778 & (64));
var inst_94780 = inst_94773.cljs$core$ISeq$;
var inst_94781 = (inst_94779) || (inst_94780);
var state_94816__$1 = state_94816;
if(cljs.core.truth_(inst_94781)){
var statearr_94847_94879 = state_94816__$1;
(statearr_94847_94879[(1)] = (11));

} else {
var statearr_94848_94880 = state_94816__$1;
(statearr_94848_94880[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto__))
;
return ((function (switch__8364__auto__,c__8429__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____0 = (function (){
var statearr_94852 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_94852[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__);

(statearr_94852[(1)] = (1));

return statearr_94852;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____1 = (function (state_94816){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_94816);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e94853){if((e94853 instanceof Object)){
var ex__8368__auto__ = e94853;
var statearr_94854_94881 = state_94816;
(statearr_94854_94881[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_94816);

return cljs.core.cst$kw$recur;
} else {
throw e94853;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__94882 = state_94816;
state_94816 = G__94882;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__ = function(state_94816){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____1.call(this,state_94816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__))
})();
var state__8431__auto__ = (function (){var statearr_94855 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_94855[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_94855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto__))
);

return c__8429__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__94885_94887 = agg;
var G__94886_94888 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__94885_94887,G__94886_94888) : cljs.core.reset_BANG_.call(null,G__94885_94887,G__94886_94888));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___94896 = arguments.length;
var i__5628__auto___94897 = (0);
while(true){
if((i__5628__auto___94897 < len__5627__auto___94896)){
args__5634__auto__.push((arguments[i__5628__auto___94897]));

var G__94898 = (i__5628__auto___94897 + (1));
i__5628__auto___94897 = G__94898;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__94892){
var map__94893 = p__94892;
var map__94893__$1 = ((((!((map__94893 == null)))?((((map__94893.cljs$lang$protocol_mask$partition0$ & (64))) || (map__94893.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__94893):map__94893);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__94893__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__94895 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__94895) : cljs.core.atom.call(null,G__94895));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__94893,map__94893__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__94893,map__94893__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__94893,map__94893__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__94893,map__94893__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq94889){
var G__94890 = cljs.core.first(seq94889);
var seq94889__$1 = cljs.core.next(seq94889);
var G__94891 = cljs.core.first(seq94889__$1);
var seq94889__$2 = cljs.core.next(seq94889__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__94890,G__94891,seq94889__$2);
});
