// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async36138 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36138 = (function (fn_handler,f,meta36139){
this.fn_handler = fn_handler;
this.f = f;
this.meta36139 = meta36139;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36138.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36140,meta36139__$1){
var self__ = this;
var _36140__$1 = this;
return (new cljs.core.async.t_cljs$core$async36138(self__.fn_handler,self__.f,meta36139__$1));
});

cljs.core.async.t_cljs$core$async36138.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36140){
var self__ = this;
var _36140__$1 = this;
return self__.meta36139;
});

cljs.core.async.t_cljs$core$async36138.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async36138.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async36138.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async36138.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fn_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)))], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$meta36139], null);
});

cljs.core.async.t_cljs$core$async36138.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36138.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36138";

cljs.core.async.t_cljs$core$async36138.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async36138");
});

cljs.core.async.__GT_t_cljs$core$async36138 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async36138(fn_handler__$1,f__$1,meta36139){
return (new cljs.core.async.t_cljs$core$async36138(fn_handler__$1,f__$1,meta36139));
});

}

return (new cljs.core.async.t_cljs$core$async36138(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args36143 = [];
var len__5627__auto___36146 = arguments.length;
var i__5628__auto___36147 = (0);
while(true){
if((i__5628__auto___36147 < len__5627__auto___36146)){
args36143.push((arguments[i__5628__auto___36147]));

var G__36148 = (i__5628__auto___36147 + (1));
i__5628__auto___36147 = G__36148;
continue;
} else {
}
break;
}

var G__36145 = args36143.length;
switch (G__36145) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36143.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$sym$buf_DASH_or_DASH_n], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args36150 = [];
var len__5627__auto___36153 = arguments.length;
var i__5628__auto___36154 = (0);
while(true){
if((i__5628__auto___36154 < len__5627__auto___36153)){
args36150.push((arguments[i__5628__auto___36154]));

var G__36155 = (i__5628__auto___36154 + (1));
i__5628__auto___36154 = G__36155;
continue;
} else {
}
break;
}

var G__36152 = args36150.length;
switch (G__36152) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36150.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_36157 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_36157) : fn1.call(null,val_36157));
} else {
cljs.core.async.impl.dispatch.run(((function (val_36157,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_36157) : fn1.call(null,val_36157));
});})(val_36157,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args36158 = [];
var len__5627__auto___36161 = arguments.length;
var i__5628__auto___36162 = (0);
while(true){
if((i__5628__auto___36162 < len__5627__auto___36161)){
args36158.push((arguments[i__5628__auto___36162]));

var G__36163 = (i__5628__auto___36162 + (1));
i__5628__auto___36162 = G__36163;
continue;
} else {
}
break;
}

var G__36160 = args36158.length;
switch (G__36160) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36158.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4423__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5472__auto___36165 = n;
var x_36166 = (0);
while(true){
if((x_36166 < n__5472__auto___36165)){
(a[x_36166] = (0));

var G__36167 = (x_36166 + (1));
x_36166 = G__36167;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__36168 = (i + (1));
i = G__36168;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async36172 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36172 = (function (alt_flag,flag,meta36173){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta36173 = meta36173;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36172.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_36174,meta36173__$1){
var self__ = this;
var _36174__$1 = this;
return (new cljs.core.async.t_cljs$core$async36172(self__.alt_flag,self__.flag,meta36173__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async36172.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_36174){
var self__ = this;
var _36174__$1 = this;
return self__.meta36173;
});})(flag))
;

cljs.core.async.t_cljs$core$async36172.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async36172.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async36172.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async36172.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta36173], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async36172.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36172.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36172";

cljs.core.async.t_cljs$core$async36172.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async36172");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async36172 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async36172(alt_flag__$1,flag__$1,meta36173){
return (new cljs.core.async.t_cljs$core$async36172(alt_flag__$1,flag__$1,meta36173));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async36172(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async36178 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36178 = (function (alt_handler,flag,cb,meta36179){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta36179 = meta36179;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36178.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36180,meta36179__$1){
var self__ = this;
var _36180__$1 = this;
return (new cljs.core.async.t_cljs$core$async36178(self__.alt_handler,self__.flag,self__.cb,meta36179__$1));
});

cljs.core.async.t_cljs$core$async36178.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36180){
var self__ = this;
var _36180__$1 = this;
return self__.meta36179;
});

cljs.core.async.t_cljs$core$async36178.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async36178.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async36178.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async36178.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta36179], null);
});

cljs.core.async.t_cljs$core$async36178.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36178.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36178";

cljs.core.async.t_cljs$core$async36178.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async36178");
});

cljs.core.async.__GT_t_cljs$core$async36178 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async36178(alt_handler__$1,flag__$1,cb__$1,meta36179){
return (new cljs.core.async.t_cljs$core$async36178(alt_handler__$1,flag__$1,cb__$1,meta36179));
});

}

return (new cljs.core.async.t_cljs$core$async36178(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__36181_SHARP_){
var G__36185 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36181_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__36185) : fret.call(null,G__36185));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__36182_SHARP_){
var G__36186 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36182_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__36186) : fret.call(null,G__36186));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__4569__auto__ = wport;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return port;
}
})()], null));
} else {
var G__36187 = (i + (1));
i = G__36187;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4569__auto__ = ret;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4425__auto__ = (function (){var and__4557__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___36193 = arguments.length;
var i__5628__auto___36194 = (0);
while(true){
if((i__5628__auto___36194 < len__5627__auto___36193)){
args__5634__auto__.push((arguments[i__5628__auto___36194]));

var G__36195 = (i__5628__auto___36194 + (1));
i__5628__auto___36194 = G__36195;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__36190){
var map__36191 = p__36190;
var map__36191__$1 = ((((!((map__36191 == null)))?((((map__36191.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36191.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36191):map__36191);
var opts = map__36191__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq36188){
var G__36189 = cljs.core.first(seq36188);
var seq36188__$1 = cljs.core.next(seq36188);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__36189,seq36188__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args36196 = [];
var len__5627__auto___36246 = arguments.length;
var i__5628__auto___36247 = (0);
while(true){
if((i__5628__auto___36247 < len__5627__auto___36246)){
args36196.push((arguments[i__5628__auto___36247]));

var G__36248 = (i__5628__auto___36247 + (1));
i__5628__auto___36247 = G__36248;
continue;
} else {
}
break;
}

var G__36198 = args36196.length;
switch (G__36198) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36196.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8437__auto___36250 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___36250){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___36250){
return (function (state_36222){
var state_val_36223 = (state_36222[(1)]);
if((state_val_36223 === (7))){
var inst_36218 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
var statearr_36224_36251 = state_36222__$1;
(statearr_36224_36251[(2)] = inst_36218);

(statearr_36224_36251[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (1))){
var state_36222__$1 = state_36222;
var statearr_36225_36252 = state_36222__$1;
(statearr_36225_36252[(2)] = null);

(statearr_36225_36252[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (4))){
var inst_36201 = (state_36222[(7)]);
var inst_36201__$1 = (state_36222[(2)]);
var inst_36202 = (inst_36201__$1 == null);
var state_36222__$1 = (function (){var statearr_36226 = state_36222;
(statearr_36226[(7)] = inst_36201__$1);

return statearr_36226;
})();
if(cljs.core.truth_(inst_36202)){
var statearr_36227_36253 = state_36222__$1;
(statearr_36227_36253[(1)] = (5));

} else {
var statearr_36228_36254 = state_36222__$1;
(statearr_36228_36254[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (13))){
var state_36222__$1 = state_36222;
var statearr_36229_36255 = state_36222__$1;
(statearr_36229_36255[(2)] = null);

(statearr_36229_36255[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (6))){
var inst_36201 = (state_36222[(7)]);
var state_36222__$1 = state_36222;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36222__$1,(11),to,inst_36201);
} else {
if((state_val_36223 === (3))){
var inst_36220 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36222__$1,inst_36220);
} else {
if((state_val_36223 === (12))){
var state_36222__$1 = state_36222;
var statearr_36230_36256 = state_36222__$1;
(statearr_36230_36256[(2)] = null);

(statearr_36230_36256[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (2))){
var state_36222__$1 = state_36222;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36222__$1,(4),from);
} else {
if((state_val_36223 === (11))){
var inst_36211 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
if(cljs.core.truth_(inst_36211)){
var statearr_36231_36257 = state_36222__$1;
(statearr_36231_36257[(1)] = (12));

} else {
var statearr_36232_36258 = state_36222__$1;
(statearr_36232_36258[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (9))){
var state_36222__$1 = state_36222;
var statearr_36233_36259 = state_36222__$1;
(statearr_36233_36259[(2)] = null);

(statearr_36233_36259[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (5))){
var state_36222__$1 = state_36222;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36234_36260 = state_36222__$1;
(statearr_36234_36260[(1)] = (8));

} else {
var statearr_36235_36261 = state_36222__$1;
(statearr_36235_36261[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (14))){
var inst_36216 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
var statearr_36236_36262 = state_36222__$1;
(statearr_36236_36262[(2)] = inst_36216);

(statearr_36236_36262[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (10))){
var inst_36208 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
var statearr_36237_36263 = state_36222__$1;
(statearr_36237_36263[(2)] = inst_36208);

(statearr_36237_36263[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (8))){
var inst_36205 = cljs.core.async.close_BANG_(to);
var state_36222__$1 = state_36222;
var statearr_36238_36264 = state_36222__$1;
(statearr_36238_36264[(2)] = inst_36205);

(statearr_36238_36264[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto___36250))
;
return ((function (switch__8372__auto__,c__8437__auto___36250){
return (function() {
var cljs$core$async$state_machine__8373__auto__ = null;
var cljs$core$async$state_machine__8373__auto____0 = (function (){
var statearr_36242 = [null,null,null,null,null,null,null,null];
(statearr_36242[(0)] = cljs$core$async$state_machine__8373__auto__);

(statearr_36242[(1)] = (1));

return statearr_36242;
});
var cljs$core$async$state_machine__8373__auto____1 = (function (state_36222){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_36222);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e36243){if((e36243 instanceof Object)){
var ex__8376__auto__ = e36243;
var statearr_36244_36265 = state_36222;
(statearr_36244_36265[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36222);

return cljs.core.cst$kw$recur;
} else {
throw e36243;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__36266 = state_36222;
state_36222 = G__36266;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$state_machine__8373__auto__ = function(state_36222){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8373__auto____1.call(this,state_36222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8373__auto____0;
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8373__auto____1;
return cljs$core$async$state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___36250))
})();
var state__8439__auto__ = (function (){var statearr_36245 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_36245[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___36250);

return statearr_36245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___36250))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$pos_QMARK_,cljs.core.cst$sym$n)], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__36450){
var vec__36451 = p__36450;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36451,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36451,(1),null);
var job = vec__36451;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__8437__auto___36633 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___36633,res,vec__36451,v,p,job,jobs,results){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___36633,res,vec__36451,v,p,job,jobs,results){
return (function (state_36456){
var state_val_36457 = (state_36456[(1)]);
if((state_val_36457 === (1))){
var state_36456__$1 = state_36456;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36456__$1,(2),res,v);
} else {
if((state_val_36457 === (2))){
var inst_36453 = (state_36456[(2)]);
var inst_36454 = cljs.core.async.close_BANG_(res);
var state_36456__$1 = (function (){var statearr_36458 = state_36456;
(statearr_36458[(7)] = inst_36453);

return statearr_36458;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_36456__$1,inst_36454);
} else {
return null;
}
}
});})(c__8437__auto___36633,res,vec__36451,v,p,job,jobs,results))
;
return ((function (switch__8372__auto__,c__8437__auto___36633,res,vec__36451,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0 = (function (){
var statearr_36462 = [null,null,null,null,null,null,null,null];
(statearr_36462[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__);

(statearr_36462[(1)] = (1));

return statearr_36462;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1 = (function (state_36456){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_36456);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e36463){if((e36463 instanceof Object)){
var ex__8376__auto__ = e36463;
var statearr_36464_36634 = state_36456;
(statearr_36464_36634[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36456);

return cljs.core.cst$kw$recur;
} else {
throw e36463;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__36635 = state_36456;
state_36456 = G__36635;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__ = function(state_36456){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1.call(this,state_36456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___36633,res,vec__36451,v,p,job,jobs,results))
})();
var state__8439__auto__ = (function (){var statearr_36465 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_36465[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___36633);

return statearr_36465;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___36633,res,vec__36451,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__36466){
var vec__36467 = p__36466;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36467,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36467,(1),null);
var job = vec__36467;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__5472__auto___36636 = n;
var __36637 = (0);
while(true){
if((__36637 < n__5472__auto___36636)){
var G__36468_36638 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__36468_36638) {
case "compute":
var c__8437__auto___36640 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__36637,c__8437__auto___36640,G__36468_36638,n__5472__auto___36636,jobs,results,process,async){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (__36637,c__8437__auto___36640,G__36468_36638,n__5472__auto___36636,jobs,results,process,async){
return (function (state_36481){
var state_val_36482 = (state_36481[(1)]);
if((state_val_36482 === (1))){
var state_36481__$1 = state_36481;
var statearr_36483_36641 = state_36481__$1;
(statearr_36483_36641[(2)] = null);

(statearr_36483_36641[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36482 === (2))){
var state_36481__$1 = state_36481;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36481__$1,(4),jobs);
} else {
if((state_val_36482 === (3))){
var inst_36479 = (state_36481[(2)]);
var state_36481__$1 = state_36481;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36481__$1,inst_36479);
} else {
if((state_val_36482 === (4))){
var inst_36471 = (state_36481[(2)]);
var inst_36472 = process(inst_36471);
var state_36481__$1 = state_36481;
if(cljs.core.truth_(inst_36472)){
var statearr_36484_36642 = state_36481__$1;
(statearr_36484_36642[(1)] = (5));

} else {
var statearr_36485_36643 = state_36481__$1;
(statearr_36485_36643[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36482 === (5))){
var state_36481__$1 = state_36481;
var statearr_36486_36644 = state_36481__$1;
(statearr_36486_36644[(2)] = null);

(statearr_36486_36644[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36482 === (6))){
var state_36481__$1 = state_36481;
var statearr_36487_36645 = state_36481__$1;
(statearr_36487_36645[(2)] = null);

(statearr_36487_36645[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36482 === (7))){
var inst_36477 = (state_36481[(2)]);
var state_36481__$1 = state_36481;
var statearr_36488_36646 = state_36481__$1;
(statearr_36488_36646[(2)] = inst_36477);

(statearr_36488_36646[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__36637,c__8437__auto___36640,G__36468_36638,n__5472__auto___36636,jobs,results,process,async))
;
return ((function (__36637,switch__8372__auto__,c__8437__auto___36640,G__36468_36638,n__5472__auto___36636,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0 = (function (){
var statearr_36492 = [null,null,null,null,null,null,null];
(statearr_36492[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__);

(statearr_36492[(1)] = (1));

return statearr_36492;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1 = (function (state_36481){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_36481);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e36493){if((e36493 instanceof Object)){
var ex__8376__auto__ = e36493;
var statearr_36494_36647 = state_36481;
(statearr_36494_36647[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36481);

return cljs.core.cst$kw$recur;
} else {
throw e36493;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__36648 = state_36481;
state_36481 = G__36648;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__ = function(state_36481){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1.call(this,state_36481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__;
})()
;})(__36637,switch__8372__auto__,c__8437__auto___36640,G__36468_36638,n__5472__auto___36636,jobs,results,process,async))
})();
var state__8439__auto__ = (function (){var statearr_36495 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_36495[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___36640);

return statearr_36495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(__36637,c__8437__auto___36640,G__36468_36638,n__5472__auto___36636,jobs,results,process,async))
);


break;
case "async":
var c__8437__auto___36649 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__36637,c__8437__auto___36649,G__36468_36638,n__5472__auto___36636,jobs,results,process,async){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (__36637,c__8437__auto___36649,G__36468_36638,n__5472__auto___36636,jobs,results,process,async){
return (function (state_36508){
var state_val_36509 = (state_36508[(1)]);
if((state_val_36509 === (1))){
var state_36508__$1 = state_36508;
var statearr_36510_36650 = state_36508__$1;
(statearr_36510_36650[(2)] = null);

(statearr_36510_36650[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36509 === (2))){
var state_36508__$1 = state_36508;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36508__$1,(4),jobs);
} else {
if((state_val_36509 === (3))){
var inst_36506 = (state_36508[(2)]);
var state_36508__$1 = state_36508;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36508__$1,inst_36506);
} else {
if((state_val_36509 === (4))){
var inst_36498 = (state_36508[(2)]);
var inst_36499 = async(inst_36498);
var state_36508__$1 = state_36508;
if(cljs.core.truth_(inst_36499)){
var statearr_36511_36651 = state_36508__$1;
(statearr_36511_36651[(1)] = (5));

} else {
var statearr_36512_36652 = state_36508__$1;
(statearr_36512_36652[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36509 === (5))){
var state_36508__$1 = state_36508;
var statearr_36513_36653 = state_36508__$1;
(statearr_36513_36653[(2)] = null);

(statearr_36513_36653[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36509 === (6))){
var state_36508__$1 = state_36508;
var statearr_36514_36654 = state_36508__$1;
(statearr_36514_36654[(2)] = null);

(statearr_36514_36654[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36509 === (7))){
var inst_36504 = (state_36508[(2)]);
var state_36508__$1 = state_36508;
var statearr_36515_36655 = state_36508__$1;
(statearr_36515_36655[(2)] = inst_36504);

(statearr_36515_36655[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__36637,c__8437__auto___36649,G__36468_36638,n__5472__auto___36636,jobs,results,process,async))
;
return ((function (__36637,switch__8372__auto__,c__8437__auto___36649,G__36468_36638,n__5472__auto___36636,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0 = (function (){
var statearr_36519 = [null,null,null,null,null,null,null];
(statearr_36519[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__);

(statearr_36519[(1)] = (1));

return statearr_36519;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1 = (function (state_36508){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_36508);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e36520){if((e36520 instanceof Object)){
var ex__8376__auto__ = e36520;
var statearr_36521_36656 = state_36508;
(statearr_36521_36656[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36508);

return cljs.core.cst$kw$recur;
} else {
throw e36520;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__36657 = state_36508;
state_36508 = G__36657;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__ = function(state_36508){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1.call(this,state_36508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__;
})()
;})(__36637,switch__8372__auto__,c__8437__auto___36649,G__36468_36638,n__5472__auto___36636,jobs,results,process,async))
})();
var state__8439__auto__ = (function (){var statearr_36522 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_36522[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___36649);

return statearr_36522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(__36637,c__8437__auto___36649,G__36468_36638,n__5472__auto___36636,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__36658 = (__36637 + (1));
__36637 = G__36658;
continue;
} else {
}
break;
}

var c__8437__auto___36659 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___36659,jobs,results,process,async){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___36659,jobs,results,process,async){
return (function (state_36544){
var state_val_36545 = (state_36544[(1)]);
if((state_val_36545 === (1))){
var state_36544__$1 = state_36544;
var statearr_36546_36660 = state_36544__$1;
(statearr_36546_36660[(2)] = null);

(statearr_36546_36660[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36545 === (2))){
var state_36544__$1 = state_36544;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36544__$1,(4),from);
} else {
if((state_val_36545 === (3))){
var inst_36542 = (state_36544[(2)]);
var state_36544__$1 = state_36544;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36544__$1,inst_36542);
} else {
if((state_val_36545 === (4))){
var inst_36525 = (state_36544[(7)]);
var inst_36525__$1 = (state_36544[(2)]);
var inst_36526 = (inst_36525__$1 == null);
var state_36544__$1 = (function (){var statearr_36547 = state_36544;
(statearr_36547[(7)] = inst_36525__$1);

return statearr_36547;
})();
if(cljs.core.truth_(inst_36526)){
var statearr_36548_36661 = state_36544__$1;
(statearr_36548_36661[(1)] = (5));

} else {
var statearr_36549_36662 = state_36544__$1;
(statearr_36549_36662[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36545 === (5))){
var inst_36528 = cljs.core.async.close_BANG_(jobs);
var state_36544__$1 = state_36544;
var statearr_36550_36663 = state_36544__$1;
(statearr_36550_36663[(2)] = inst_36528);

(statearr_36550_36663[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36545 === (6))){
var inst_36530 = (state_36544[(8)]);
var inst_36525 = (state_36544[(7)]);
var inst_36530__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_36531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36532 = [inst_36525,inst_36530__$1];
var inst_36533 = (new cljs.core.PersistentVector(null,2,(5),inst_36531,inst_36532,null));
var state_36544__$1 = (function (){var statearr_36551 = state_36544;
(statearr_36551[(8)] = inst_36530__$1);

return statearr_36551;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36544__$1,(8),jobs,inst_36533);
} else {
if((state_val_36545 === (7))){
var inst_36540 = (state_36544[(2)]);
var state_36544__$1 = state_36544;
var statearr_36552_36664 = state_36544__$1;
(statearr_36552_36664[(2)] = inst_36540);

(statearr_36552_36664[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36545 === (8))){
var inst_36530 = (state_36544[(8)]);
var inst_36535 = (state_36544[(2)]);
var state_36544__$1 = (function (){var statearr_36553 = state_36544;
(statearr_36553[(9)] = inst_36535);

return statearr_36553;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36544__$1,(9),results,inst_36530);
} else {
if((state_val_36545 === (9))){
var inst_36537 = (state_36544[(2)]);
var state_36544__$1 = (function (){var statearr_36554 = state_36544;
(statearr_36554[(10)] = inst_36537);

return statearr_36554;
})();
var statearr_36555_36665 = state_36544__$1;
(statearr_36555_36665[(2)] = null);

(statearr_36555_36665[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8437__auto___36659,jobs,results,process,async))
;
return ((function (switch__8372__auto__,c__8437__auto___36659,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0 = (function (){
var statearr_36559 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36559[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__);

(statearr_36559[(1)] = (1));

return statearr_36559;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1 = (function (state_36544){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_36544);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e36560){if((e36560 instanceof Object)){
var ex__8376__auto__ = e36560;
var statearr_36561_36666 = state_36544;
(statearr_36561_36666[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36544);

return cljs.core.cst$kw$recur;
} else {
throw e36560;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__36667 = state_36544;
state_36544 = G__36667;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__ = function(state_36544){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1.call(this,state_36544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___36659,jobs,results,process,async))
})();
var state__8439__auto__ = (function (){var statearr_36562 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_36562[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___36659);

return statearr_36562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___36659,jobs,results,process,async))
);


var c__8437__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto__,jobs,results,process,async){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto__,jobs,results,process,async){
return (function (state_36600){
var state_val_36601 = (state_36600[(1)]);
if((state_val_36601 === (7))){
var inst_36596 = (state_36600[(2)]);
var state_36600__$1 = state_36600;
var statearr_36602_36668 = state_36600__$1;
(statearr_36602_36668[(2)] = inst_36596);

(statearr_36602_36668[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (20))){
var state_36600__$1 = state_36600;
var statearr_36603_36669 = state_36600__$1;
(statearr_36603_36669[(2)] = null);

(statearr_36603_36669[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (1))){
var state_36600__$1 = state_36600;
var statearr_36604_36670 = state_36600__$1;
(statearr_36604_36670[(2)] = null);

(statearr_36604_36670[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (4))){
var inst_36565 = (state_36600[(7)]);
var inst_36565__$1 = (state_36600[(2)]);
var inst_36566 = (inst_36565__$1 == null);
var state_36600__$1 = (function (){var statearr_36605 = state_36600;
(statearr_36605[(7)] = inst_36565__$1);

return statearr_36605;
})();
if(cljs.core.truth_(inst_36566)){
var statearr_36606_36671 = state_36600__$1;
(statearr_36606_36671[(1)] = (5));

} else {
var statearr_36607_36672 = state_36600__$1;
(statearr_36607_36672[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (15))){
var inst_36578 = (state_36600[(8)]);
var state_36600__$1 = state_36600;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36600__$1,(18),to,inst_36578);
} else {
if((state_val_36601 === (21))){
var inst_36591 = (state_36600[(2)]);
var state_36600__$1 = state_36600;
var statearr_36608_36673 = state_36600__$1;
(statearr_36608_36673[(2)] = inst_36591);

(statearr_36608_36673[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (13))){
var inst_36593 = (state_36600[(2)]);
var state_36600__$1 = (function (){var statearr_36609 = state_36600;
(statearr_36609[(9)] = inst_36593);

return statearr_36609;
})();
var statearr_36610_36674 = state_36600__$1;
(statearr_36610_36674[(2)] = null);

(statearr_36610_36674[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (6))){
var inst_36565 = (state_36600[(7)]);
var state_36600__$1 = state_36600;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36600__$1,(11),inst_36565);
} else {
if((state_val_36601 === (17))){
var inst_36586 = (state_36600[(2)]);
var state_36600__$1 = state_36600;
if(cljs.core.truth_(inst_36586)){
var statearr_36611_36675 = state_36600__$1;
(statearr_36611_36675[(1)] = (19));

} else {
var statearr_36612_36676 = state_36600__$1;
(statearr_36612_36676[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (3))){
var inst_36598 = (state_36600[(2)]);
var state_36600__$1 = state_36600;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36600__$1,inst_36598);
} else {
if((state_val_36601 === (12))){
var inst_36575 = (state_36600[(10)]);
var state_36600__$1 = state_36600;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36600__$1,(14),inst_36575);
} else {
if((state_val_36601 === (2))){
var state_36600__$1 = state_36600;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36600__$1,(4),results);
} else {
if((state_val_36601 === (19))){
var state_36600__$1 = state_36600;
var statearr_36613_36677 = state_36600__$1;
(statearr_36613_36677[(2)] = null);

(statearr_36613_36677[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (11))){
var inst_36575 = (state_36600[(2)]);
var state_36600__$1 = (function (){var statearr_36614 = state_36600;
(statearr_36614[(10)] = inst_36575);

return statearr_36614;
})();
var statearr_36615_36678 = state_36600__$1;
(statearr_36615_36678[(2)] = null);

(statearr_36615_36678[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (9))){
var state_36600__$1 = state_36600;
var statearr_36616_36679 = state_36600__$1;
(statearr_36616_36679[(2)] = null);

(statearr_36616_36679[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (5))){
var state_36600__$1 = state_36600;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36617_36680 = state_36600__$1;
(statearr_36617_36680[(1)] = (8));

} else {
var statearr_36618_36681 = state_36600__$1;
(statearr_36618_36681[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (14))){
var inst_36580 = (state_36600[(11)]);
var inst_36578 = (state_36600[(8)]);
var inst_36578__$1 = (state_36600[(2)]);
var inst_36579 = (inst_36578__$1 == null);
var inst_36580__$1 = cljs.core.not(inst_36579);
var state_36600__$1 = (function (){var statearr_36619 = state_36600;
(statearr_36619[(11)] = inst_36580__$1);

(statearr_36619[(8)] = inst_36578__$1);

return statearr_36619;
})();
if(inst_36580__$1){
var statearr_36620_36682 = state_36600__$1;
(statearr_36620_36682[(1)] = (15));

} else {
var statearr_36621_36683 = state_36600__$1;
(statearr_36621_36683[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (16))){
var inst_36580 = (state_36600[(11)]);
var state_36600__$1 = state_36600;
var statearr_36622_36684 = state_36600__$1;
(statearr_36622_36684[(2)] = inst_36580);

(statearr_36622_36684[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (10))){
var inst_36572 = (state_36600[(2)]);
var state_36600__$1 = state_36600;
var statearr_36623_36685 = state_36600__$1;
(statearr_36623_36685[(2)] = inst_36572);

(statearr_36623_36685[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (18))){
var inst_36583 = (state_36600[(2)]);
var state_36600__$1 = state_36600;
var statearr_36624_36686 = state_36600__$1;
(statearr_36624_36686[(2)] = inst_36583);

(statearr_36624_36686[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (8))){
var inst_36569 = cljs.core.async.close_BANG_(to);
var state_36600__$1 = state_36600;
var statearr_36625_36687 = state_36600__$1;
(statearr_36625_36687[(2)] = inst_36569);

(statearr_36625_36687[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto__,jobs,results,process,async))
;
return ((function (switch__8372__auto__,c__8437__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0 = (function (){
var statearr_36629 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36629[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__);

(statearr_36629[(1)] = (1));

return statearr_36629;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1 = (function (state_36600){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_36600);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e36630){if((e36630 instanceof Object)){
var ex__8376__auto__ = e36630;
var statearr_36631_36688 = state_36600;
(statearr_36631_36688[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36600);

return cljs.core.cst$kw$recur;
} else {
throw e36630;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__36689 = state_36600;
state_36600 = G__36689;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__ = function(state_36600){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1.call(this,state_36600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8373__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto__,jobs,results,process,async))
})();
var state__8439__auto__ = (function (){var statearr_36632 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_36632[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto__);

return statearr_36632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto__,jobs,results,process,async))
);

return c__8437__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args36690 = [];
var len__5627__auto___36693 = arguments.length;
var i__5628__auto___36694 = (0);
while(true){
if((i__5628__auto___36694 < len__5627__auto___36693)){
args36690.push((arguments[i__5628__auto___36694]));

var G__36695 = (i__5628__auto___36694 + (1));
i__5628__auto___36694 = G__36695;
continue;
} else {
}
break;
}

var G__36692 = args36690.length;
switch (G__36692) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36690.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args36697 = [];
var len__5627__auto___36700 = arguments.length;
var i__5628__auto___36701 = (0);
while(true){
if((i__5628__auto___36701 < len__5627__auto___36700)){
args36697.push((arguments[i__5628__auto___36701]));

var G__36702 = (i__5628__auto___36701 + (1));
i__5628__auto___36701 = G__36702;
continue;
} else {
}
break;
}

var G__36699 = args36697.length;
switch (G__36699) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36697.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args36704 = [];
var len__5627__auto___36757 = arguments.length;
var i__5628__auto___36758 = (0);
while(true){
if((i__5628__auto___36758 < len__5627__auto___36757)){
args36704.push((arguments[i__5628__auto___36758]));

var G__36759 = (i__5628__auto___36758 + (1));
i__5628__auto___36758 = G__36759;
continue;
} else {
}
break;
}

var G__36706 = args36704.length;
switch (G__36706) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36704.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__8437__auto___36761 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___36761,tc,fc){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___36761,tc,fc){
return (function (state_36732){
var state_val_36733 = (state_36732[(1)]);
if((state_val_36733 === (7))){
var inst_36728 = (state_36732[(2)]);
var state_36732__$1 = state_36732;
var statearr_36734_36762 = state_36732__$1;
(statearr_36734_36762[(2)] = inst_36728);

(statearr_36734_36762[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36733 === (1))){
var state_36732__$1 = state_36732;
var statearr_36735_36763 = state_36732__$1;
(statearr_36735_36763[(2)] = null);

(statearr_36735_36763[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36733 === (4))){
var inst_36709 = (state_36732[(7)]);
var inst_36709__$1 = (state_36732[(2)]);
var inst_36710 = (inst_36709__$1 == null);
var state_36732__$1 = (function (){var statearr_36736 = state_36732;
(statearr_36736[(7)] = inst_36709__$1);

return statearr_36736;
})();
if(cljs.core.truth_(inst_36710)){
var statearr_36737_36764 = state_36732__$1;
(statearr_36737_36764[(1)] = (5));

} else {
var statearr_36738_36765 = state_36732__$1;
(statearr_36738_36765[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36733 === (13))){
var state_36732__$1 = state_36732;
var statearr_36739_36766 = state_36732__$1;
(statearr_36739_36766[(2)] = null);

(statearr_36739_36766[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36733 === (6))){
var inst_36709 = (state_36732[(7)]);
var inst_36715 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_36709) : p.call(null,inst_36709));
var state_36732__$1 = state_36732;
if(cljs.core.truth_(inst_36715)){
var statearr_36740_36767 = state_36732__$1;
(statearr_36740_36767[(1)] = (9));

} else {
var statearr_36741_36768 = state_36732__$1;
(statearr_36741_36768[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36733 === (3))){
var inst_36730 = (state_36732[(2)]);
var state_36732__$1 = state_36732;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36732__$1,inst_36730);
} else {
if((state_val_36733 === (12))){
var state_36732__$1 = state_36732;
var statearr_36742_36769 = state_36732__$1;
(statearr_36742_36769[(2)] = null);

(statearr_36742_36769[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36733 === (2))){
var state_36732__$1 = state_36732;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36732__$1,(4),ch);
} else {
if((state_val_36733 === (11))){
var inst_36709 = (state_36732[(7)]);
var inst_36719 = (state_36732[(2)]);
var state_36732__$1 = state_36732;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36732__$1,(8),inst_36719,inst_36709);
} else {
if((state_val_36733 === (9))){
var state_36732__$1 = state_36732;
var statearr_36743_36770 = state_36732__$1;
(statearr_36743_36770[(2)] = tc);

(statearr_36743_36770[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36733 === (5))){
var inst_36712 = cljs.core.async.close_BANG_(tc);
var inst_36713 = cljs.core.async.close_BANG_(fc);
var state_36732__$1 = (function (){var statearr_36744 = state_36732;
(statearr_36744[(8)] = inst_36712);

return statearr_36744;
})();
var statearr_36745_36771 = state_36732__$1;
(statearr_36745_36771[(2)] = inst_36713);

(statearr_36745_36771[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36733 === (14))){
var inst_36726 = (state_36732[(2)]);
var state_36732__$1 = state_36732;
var statearr_36746_36772 = state_36732__$1;
(statearr_36746_36772[(2)] = inst_36726);

(statearr_36746_36772[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36733 === (10))){
var state_36732__$1 = state_36732;
var statearr_36747_36773 = state_36732__$1;
(statearr_36747_36773[(2)] = fc);

(statearr_36747_36773[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36733 === (8))){
var inst_36721 = (state_36732[(2)]);
var state_36732__$1 = state_36732;
if(cljs.core.truth_(inst_36721)){
var statearr_36748_36774 = state_36732__$1;
(statearr_36748_36774[(1)] = (12));

} else {
var statearr_36749_36775 = state_36732__$1;
(statearr_36749_36775[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto___36761,tc,fc))
;
return ((function (switch__8372__auto__,c__8437__auto___36761,tc,fc){
return (function() {
var cljs$core$async$state_machine__8373__auto__ = null;
var cljs$core$async$state_machine__8373__auto____0 = (function (){
var statearr_36753 = [null,null,null,null,null,null,null,null,null];
(statearr_36753[(0)] = cljs$core$async$state_machine__8373__auto__);

(statearr_36753[(1)] = (1));

return statearr_36753;
});
var cljs$core$async$state_machine__8373__auto____1 = (function (state_36732){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_36732);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e36754){if((e36754 instanceof Object)){
var ex__8376__auto__ = e36754;
var statearr_36755_36776 = state_36732;
(statearr_36755_36776[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36732);

return cljs.core.cst$kw$recur;
} else {
throw e36754;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__36777 = state_36732;
state_36732 = G__36777;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$state_machine__8373__auto__ = function(state_36732){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8373__auto____1.call(this,state_36732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8373__auto____0;
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8373__auto____1;
return cljs$core$async$state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___36761,tc,fc))
})();
var state__8439__auto__ = (function (){var statearr_36756 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_36756[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___36761);

return statearr_36756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___36761,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8437__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto__){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto__){
return (function (state_36824){
var state_val_36825 = (state_36824[(1)]);
if((state_val_36825 === (1))){
var inst_36810 = init;
var state_36824__$1 = (function (){var statearr_36826 = state_36824;
(statearr_36826[(7)] = inst_36810);

return statearr_36826;
})();
var statearr_36827_36842 = state_36824__$1;
(statearr_36827_36842[(2)] = null);

(statearr_36827_36842[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36825 === (2))){
var state_36824__$1 = state_36824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36824__$1,(4),ch);
} else {
if((state_val_36825 === (3))){
var inst_36822 = (state_36824[(2)]);
var state_36824__$1 = state_36824;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36824__$1,inst_36822);
} else {
if((state_val_36825 === (4))){
var inst_36813 = (state_36824[(8)]);
var inst_36813__$1 = (state_36824[(2)]);
var inst_36814 = (inst_36813__$1 == null);
var state_36824__$1 = (function (){var statearr_36828 = state_36824;
(statearr_36828[(8)] = inst_36813__$1);

return statearr_36828;
})();
if(cljs.core.truth_(inst_36814)){
var statearr_36829_36843 = state_36824__$1;
(statearr_36829_36843[(1)] = (5));

} else {
var statearr_36830_36844 = state_36824__$1;
(statearr_36830_36844[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36825 === (5))){
var inst_36810 = (state_36824[(7)]);
var state_36824__$1 = state_36824;
var statearr_36831_36845 = state_36824__$1;
(statearr_36831_36845[(2)] = inst_36810);

(statearr_36831_36845[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36825 === (6))){
var inst_36810 = (state_36824[(7)]);
var inst_36813 = (state_36824[(8)]);
var inst_36817 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_36810,inst_36813) : f.call(null,inst_36810,inst_36813));
var inst_36810__$1 = inst_36817;
var state_36824__$1 = (function (){var statearr_36832 = state_36824;
(statearr_36832[(7)] = inst_36810__$1);

return statearr_36832;
})();
var statearr_36833_36846 = state_36824__$1;
(statearr_36833_36846[(2)] = null);

(statearr_36833_36846[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36825 === (7))){
var inst_36820 = (state_36824[(2)]);
var state_36824__$1 = state_36824;
var statearr_36834_36847 = state_36824__$1;
(statearr_36834_36847[(2)] = inst_36820);

(statearr_36834_36847[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__8437__auto__))
;
return ((function (switch__8372__auto__,c__8437__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8373__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8373__auto____0 = (function (){
var statearr_36838 = [null,null,null,null,null,null,null,null,null];
(statearr_36838[(0)] = cljs$core$async$reduce_$_state_machine__8373__auto__);

(statearr_36838[(1)] = (1));

return statearr_36838;
});
var cljs$core$async$reduce_$_state_machine__8373__auto____1 = (function (state_36824){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_36824);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e36839){if((e36839 instanceof Object)){
var ex__8376__auto__ = e36839;
var statearr_36840_36848 = state_36824;
(statearr_36840_36848[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36824);

return cljs.core.cst$kw$recur;
} else {
throw e36839;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__36849 = state_36824;
state_36824 = G__36849;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8373__auto__ = function(state_36824){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8373__auto____1.call(this,state_36824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8373__auto____0;
cljs$core$async$reduce_$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8373__auto____1;
return cljs$core$async$reduce_$_state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto__))
})();
var state__8439__auto__ = (function (){var statearr_36841 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_36841[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto__);

return statearr_36841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto__))
);

return c__8437__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args36850 = [];
var len__5627__auto___36902 = arguments.length;
var i__5628__auto___36903 = (0);
while(true){
if((i__5628__auto___36903 < len__5627__auto___36902)){
args36850.push((arguments[i__5628__auto___36903]));

var G__36904 = (i__5628__auto___36903 + (1));
i__5628__auto___36903 = G__36904;
continue;
} else {
}
break;
}

var G__36852 = args36850.length;
switch (G__36852) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36850.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8437__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto__){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto__){
return (function (state_36877){
var state_val_36878 = (state_36877[(1)]);
if((state_val_36878 === (7))){
var inst_36859 = (state_36877[(2)]);
var state_36877__$1 = state_36877;
var statearr_36879_36906 = state_36877__$1;
(statearr_36879_36906[(2)] = inst_36859);

(statearr_36879_36906[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36878 === (1))){
var inst_36853 = cljs.core.seq(coll);
var inst_36854 = inst_36853;
var state_36877__$1 = (function (){var statearr_36880 = state_36877;
(statearr_36880[(7)] = inst_36854);

return statearr_36880;
})();
var statearr_36881_36907 = state_36877__$1;
(statearr_36881_36907[(2)] = null);

(statearr_36881_36907[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36878 === (4))){
var inst_36854 = (state_36877[(7)]);
var inst_36857 = cljs.core.first(inst_36854);
var state_36877__$1 = state_36877;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36877__$1,(7),ch,inst_36857);
} else {
if((state_val_36878 === (13))){
var inst_36871 = (state_36877[(2)]);
var state_36877__$1 = state_36877;
var statearr_36882_36908 = state_36877__$1;
(statearr_36882_36908[(2)] = inst_36871);

(statearr_36882_36908[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36878 === (6))){
var inst_36862 = (state_36877[(2)]);
var state_36877__$1 = state_36877;
if(cljs.core.truth_(inst_36862)){
var statearr_36883_36909 = state_36877__$1;
(statearr_36883_36909[(1)] = (8));

} else {
var statearr_36884_36910 = state_36877__$1;
(statearr_36884_36910[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36878 === (3))){
var inst_36875 = (state_36877[(2)]);
var state_36877__$1 = state_36877;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36877__$1,inst_36875);
} else {
if((state_val_36878 === (12))){
var state_36877__$1 = state_36877;
var statearr_36885_36911 = state_36877__$1;
(statearr_36885_36911[(2)] = null);

(statearr_36885_36911[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36878 === (2))){
var inst_36854 = (state_36877[(7)]);
var state_36877__$1 = state_36877;
if(cljs.core.truth_(inst_36854)){
var statearr_36886_36912 = state_36877__$1;
(statearr_36886_36912[(1)] = (4));

} else {
var statearr_36887_36913 = state_36877__$1;
(statearr_36887_36913[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36878 === (11))){
var inst_36868 = cljs.core.async.close_BANG_(ch);
var state_36877__$1 = state_36877;
var statearr_36888_36914 = state_36877__$1;
(statearr_36888_36914[(2)] = inst_36868);

(statearr_36888_36914[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36878 === (9))){
var state_36877__$1 = state_36877;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36889_36915 = state_36877__$1;
(statearr_36889_36915[(1)] = (11));

} else {
var statearr_36890_36916 = state_36877__$1;
(statearr_36890_36916[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36878 === (5))){
var inst_36854 = (state_36877[(7)]);
var state_36877__$1 = state_36877;
var statearr_36891_36917 = state_36877__$1;
(statearr_36891_36917[(2)] = inst_36854);

(statearr_36891_36917[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36878 === (10))){
var inst_36873 = (state_36877[(2)]);
var state_36877__$1 = state_36877;
var statearr_36892_36918 = state_36877__$1;
(statearr_36892_36918[(2)] = inst_36873);

(statearr_36892_36918[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36878 === (8))){
var inst_36854 = (state_36877[(7)]);
var inst_36864 = cljs.core.next(inst_36854);
var inst_36854__$1 = inst_36864;
var state_36877__$1 = (function (){var statearr_36893 = state_36877;
(statearr_36893[(7)] = inst_36854__$1);

return statearr_36893;
})();
var statearr_36894_36919 = state_36877__$1;
(statearr_36894_36919[(2)] = null);

(statearr_36894_36919[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto__))
;
return ((function (switch__8372__auto__,c__8437__auto__){
return (function() {
var cljs$core$async$state_machine__8373__auto__ = null;
var cljs$core$async$state_machine__8373__auto____0 = (function (){
var statearr_36898 = [null,null,null,null,null,null,null,null];
(statearr_36898[(0)] = cljs$core$async$state_machine__8373__auto__);

(statearr_36898[(1)] = (1));

return statearr_36898;
});
var cljs$core$async$state_machine__8373__auto____1 = (function (state_36877){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_36877);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e36899){if((e36899 instanceof Object)){
var ex__8376__auto__ = e36899;
var statearr_36900_36920 = state_36877;
(statearr_36900_36920[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36877);

return cljs.core.cst$kw$recur;
} else {
throw e36899;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__36921 = state_36877;
state_36877 = G__36921;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$state_machine__8373__auto__ = function(state_36877){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8373__auto____1.call(this,state_36877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8373__auto____0;
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8373__auto____1;
return cljs$core$async$state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto__))
})();
var state__8439__auto__ = (function (){var statearr_36901 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_36901[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto__);

return statearr_36901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto__))
);

return c__8437__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5224__auto__ = (((_ == null))?null:_);
var m__5225__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5225__auto__.call(null,_));
} else {
var m__5225__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__5225__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5225__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5225__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5225__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto__.call(null,m));
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__37146 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__37146) : cljs.core.atom.call(null,G__37146));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async37147 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37147 = (function (mult,ch,cs,meta37148){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta37148 = meta37148;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37147.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_37149,meta37148__$1){
var self__ = this;
var _37149__$1 = this;
return (new cljs.core.async.t_cljs$core$async37147(self__.mult,self__.ch,self__.cs,meta37148__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async37147.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_37149){
var self__ = this;
var _37149__$1 = this;
return self__.meta37148;
});})(cs))
;

cljs.core.async.t_cljs$core$async37147.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async37147.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async37147.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async37147.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37147.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37147.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__37150_37370 = self__.cs;
var G__37151_37371 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__37150_37370,G__37151_37371) : cljs.core.reset_BANG_.call(null,G__37150_37370,G__37151_37371));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37147.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta37148], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async37147.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37147.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37147";

cljs.core.async.t_cljs$core$async37147.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async37147");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async37147 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async37147(mult__$1,ch__$1,cs__$1,meta37148){
return (new cljs.core.async.t_cljs$core$async37147(mult__$1,ch__$1,cs__$1,meta37148));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async37147(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8437__auto___37372 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___37372,cs,m,dchan,dctr,done){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___37372,cs,m,dchan,dctr,done){
return (function (state_37282){
var state_val_37283 = (state_37282[(1)]);
if((state_val_37283 === (7))){
var inst_37278 = (state_37282[(2)]);
var state_37282__$1 = state_37282;
var statearr_37284_37373 = state_37282__$1;
(statearr_37284_37373[(2)] = inst_37278);

(statearr_37284_37373[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (20))){
var inst_37183 = (state_37282[(7)]);
var inst_37193 = cljs.core.first(inst_37183);
var inst_37194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37193,(0),null);
var inst_37195 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37193,(1),null);
var state_37282__$1 = (function (){var statearr_37285 = state_37282;
(statearr_37285[(8)] = inst_37194);

return statearr_37285;
})();
if(cljs.core.truth_(inst_37195)){
var statearr_37286_37374 = state_37282__$1;
(statearr_37286_37374[(1)] = (22));

} else {
var statearr_37287_37375 = state_37282__$1;
(statearr_37287_37375[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (27))){
var inst_37230 = (state_37282[(9)]);
var inst_37223 = (state_37282[(10)]);
var inst_37154 = (state_37282[(11)]);
var inst_37225 = (state_37282[(12)]);
var inst_37230__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37223,inst_37225);
var inst_37231 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37230__$1,inst_37154,done);
var state_37282__$1 = (function (){var statearr_37288 = state_37282;
(statearr_37288[(9)] = inst_37230__$1);

return statearr_37288;
})();
if(cljs.core.truth_(inst_37231)){
var statearr_37289_37376 = state_37282__$1;
(statearr_37289_37376[(1)] = (30));

} else {
var statearr_37290_37377 = state_37282__$1;
(statearr_37290_37377[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (1))){
var state_37282__$1 = state_37282;
var statearr_37291_37378 = state_37282__$1;
(statearr_37291_37378[(2)] = null);

(statearr_37291_37378[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (24))){
var inst_37183 = (state_37282[(7)]);
var inst_37200 = (state_37282[(2)]);
var inst_37201 = cljs.core.next(inst_37183);
var inst_37163 = inst_37201;
var inst_37164 = null;
var inst_37165 = (0);
var inst_37166 = (0);
var state_37282__$1 = (function (){var statearr_37292 = state_37282;
(statearr_37292[(13)] = inst_37165);

(statearr_37292[(14)] = inst_37166);

(statearr_37292[(15)] = inst_37163);

(statearr_37292[(16)] = inst_37164);

(statearr_37292[(17)] = inst_37200);

return statearr_37292;
})();
var statearr_37293_37379 = state_37282__$1;
(statearr_37293_37379[(2)] = null);

(statearr_37293_37379[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (39))){
var state_37282__$1 = state_37282;
var statearr_37297_37380 = state_37282__$1;
(statearr_37297_37380[(2)] = null);

(statearr_37297_37380[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (4))){
var inst_37154 = (state_37282[(11)]);
var inst_37154__$1 = (state_37282[(2)]);
var inst_37155 = (inst_37154__$1 == null);
var state_37282__$1 = (function (){var statearr_37298 = state_37282;
(statearr_37298[(11)] = inst_37154__$1);

return statearr_37298;
})();
if(cljs.core.truth_(inst_37155)){
var statearr_37299_37381 = state_37282__$1;
(statearr_37299_37381[(1)] = (5));

} else {
var statearr_37300_37382 = state_37282__$1;
(statearr_37300_37382[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (15))){
var inst_37165 = (state_37282[(13)]);
var inst_37166 = (state_37282[(14)]);
var inst_37163 = (state_37282[(15)]);
var inst_37164 = (state_37282[(16)]);
var inst_37179 = (state_37282[(2)]);
var inst_37180 = (inst_37166 + (1));
var tmp37294 = inst_37165;
var tmp37295 = inst_37163;
var tmp37296 = inst_37164;
var inst_37163__$1 = tmp37295;
var inst_37164__$1 = tmp37296;
var inst_37165__$1 = tmp37294;
var inst_37166__$1 = inst_37180;
var state_37282__$1 = (function (){var statearr_37301 = state_37282;
(statearr_37301[(13)] = inst_37165__$1);

(statearr_37301[(18)] = inst_37179);

(statearr_37301[(14)] = inst_37166__$1);

(statearr_37301[(15)] = inst_37163__$1);

(statearr_37301[(16)] = inst_37164__$1);

return statearr_37301;
})();
var statearr_37302_37383 = state_37282__$1;
(statearr_37302_37383[(2)] = null);

(statearr_37302_37383[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (21))){
var inst_37204 = (state_37282[(2)]);
var state_37282__$1 = state_37282;
var statearr_37306_37384 = state_37282__$1;
(statearr_37306_37384[(2)] = inst_37204);

(statearr_37306_37384[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (31))){
var inst_37230 = (state_37282[(9)]);
var inst_37234 = done(null);
var inst_37235 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37230);
var state_37282__$1 = (function (){var statearr_37307 = state_37282;
(statearr_37307[(19)] = inst_37234);

return statearr_37307;
})();
var statearr_37308_37385 = state_37282__$1;
(statearr_37308_37385[(2)] = inst_37235);

(statearr_37308_37385[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (32))){
var inst_37223 = (state_37282[(10)]);
var inst_37222 = (state_37282[(20)]);
var inst_37224 = (state_37282[(21)]);
var inst_37225 = (state_37282[(12)]);
var inst_37237 = (state_37282[(2)]);
var inst_37238 = (inst_37225 + (1));
var tmp37303 = inst_37223;
var tmp37304 = inst_37222;
var tmp37305 = inst_37224;
var inst_37222__$1 = tmp37304;
var inst_37223__$1 = tmp37303;
var inst_37224__$1 = tmp37305;
var inst_37225__$1 = inst_37238;
var state_37282__$1 = (function (){var statearr_37309 = state_37282;
(statearr_37309[(10)] = inst_37223__$1);

(statearr_37309[(22)] = inst_37237);

(statearr_37309[(20)] = inst_37222__$1);

(statearr_37309[(21)] = inst_37224__$1);

(statearr_37309[(12)] = inst_37225__$1);

return statearr_37309;
})();
var statearr_37310_37386 = state_37282__$1;
(statearr_37310_37386[(2)] = null);

(statearr_37310_37386[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (40))){
var inst_37250 = (state_37282[(23)]);
var inst_37254 = done(null);
var inst_37255 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37250);
var state_37282__$1 = (function (){var statearr_37311 = state_37282;
(statearr_37311[(24)] = inst_37254);

return statearr_37311;
})();
var statearr_37312_37387 = state_37282__$1;
(statearr_37312_37387[(2)] = inst_37255);

(statearr_37312_37387[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (33))){
var inst_37241 = (state_37282[(25)]);
var inst_37243 = cljs.core.chunked_seq_QMARK_(inst_37241);
var state_37282__$1 = state_37282;
if(inst_37243){
var statearr_37313_37388 = state_37282__$1;
(statearr_37313_37388[(1)] = (36));

} else {
var statearr_37314_37389 = state_37282__$1;
(statearr_37314_37389[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (13))){
var inst_37173 = (state_37282[(26)]);
var inst_37176 = cljs.core.async.close_BANG_(inst_37173);
var state_37282__$1 = state_37282;
var statearr_37315_37390 = state_37282__$1;
(statearr_37315_37390[(2)] = inst_37176);

(statearr_37315_37390[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (22))){
var inst_37194 = (state_37282[(8)]);
var inst_37197 = cljs.core.async.close_BANG_(inst_37194);
var state_37282__$1 = state_37282;
var statearr_37316_37391 = state_37282__$1;
(statearr_37316_37391[(2)] = inst_37197);

(statearr_37316_37391[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (36))){
var inst_37241 = (state_37282[(25)]);
var inst_37245 = cljs.core.chunk_first(inst_37241);
var inst_37246 = cljs.core.chunk_rest(inst_37241);
var inst_37247 = cljs.core.count(inst_37245);
var inst_37222 = inst_37246;
var inst_37223 = inst_37245;
var inst_37224 = inst_37247;
var inst_37225 = (0);
var state_37282__$1 = (function (){var statearr_37317 = state_37282;
(statearr_37317[(10)] = inst_37223);

(statearr_37317[(20)] = inst_37222);

(statearr_37317[(21)] = inst_37224);

(statearr_37317[(12)] = inst_37225);

return statearr_37317;
})();
var statearr_37318_37392 = state_37282__$1;
(statearr_37318_37392[(2)] = null);

(statearr_37318_37392[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (41))){
var inst_37241 = (state_37282[(25)]);
var inst_37257 = (state_37282[(2)]);
var inst_37258 = cljs.core.next(inst_37241);
var inst_37222 = inst_37258;
var inst_37223 = null;
var inst_37224 = (0);
var inst_37225 = (0);
var state_37282__$1 = (function (){var statearr_37319 = state_37282;
(statearr_37319[(10)] = inst_37223);

(statearr_37319[(20)] = inst_37222);

(statearr_37319[(21)] = inst_37224);

(statearr_37319[(12)] = inst_37225);

(statearr_37319[(27)] = inst_37257);

return statearr_37319;
})();
var statearr_37320_37393 = state_37282__$1;
(statearr_37320_37393[(2)] = null);

(statearr_37320_37393[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (43))){
var state_37282__$1 = state_37282;
var statearr_37321_37394 = state_37282__$1;
(statearr_37321_37394[(2)] = null);

(statearr_37321_37394[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (29))){
var inst_37266 = (state_37282[(2)]);
var state_37282__$1 = state_37282;
var statearr_37322_37395 = state_37282__$1;
(statearr_37322_37395[(2)] = inst_37266);

(statearr_37322_37395[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (44))){
var inst_37275 = (state_37282[(2)]);
var state_37282__$1 = (function (){var statearr_37323 = state_37282;
(statearr_37323[(28)] = inst_37275);

return statearr_37323;
})();
var statearr_37324_37396 = state_37282__$1;
(statearr_37324_37396[(2)] = null);

(statearr_37324_37396[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (6))){
var inst_37214 = (state_37282[(29)]);
var inst_37213 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_37214__$1 = cljs.core.keys(inst_37213);
var inst_37215 = cljs.core.count(inst_37214__$1);
var inst_37216 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_37215) : cljs.core.reset_BANG_.call(null,dctr,inst_37215));
var inst_37221 = cljs.core.seq(inst_37214__$1);
var inst_37222 = inst_37221;
var inst_37223 = null;
var inst_37224 = (0);
var inst_37225 = (0);
var state_37282__$1 = (function (){var statearr_37325 = state_37282;
(statearr_37325[(29)] = inst_37214__$1);

(statearr_37325[(10)] = inst_37223);

(statearr_37325[(20)] = inst_37222);

(statearr_37325[(30)] = inst_37216);

(statearr_37325[(21)] = inst_37224);

(statearr_37325[(12)] = inst_37225);

return statearr_37325;
})();
var statearr_37326_37397 = state_37282__$1;
(statearr_37326_37397[(2)] = null);

(statearr_37326_37397[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (28))){
var inst_37222 = (state_37282[(20)]);
var inst_37241 = (state_37282[(25)]);
var inst_37241__$1 = cljs.core.seq(inst_37222);
var state_37282__$1 = (function (){var statearr_37327 = state_37282;
(statearr_37327[(25)] = inst_37241__$1);

return statearr_37327;
})();
if(inst_37241__$1){
var statearr_37328_37398 = state_37282__$1;
(statearr_37328_37398[(1)] = (33));

} else {
var statearr_37329_37399 = state_37282__$1;
(statearr_37329_37399[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (25))){
var inst_37224 = (state_37282[(21)]);
var inst_37225 = (state_37282[(12)]);
var inst_37227 = (inst_37225 < inst_37224);
var inst_37228 = inst_37227;
var state_37282__$1 = state_37282;
if(cljs.core.truth_(inst_37228)){
var statearr_37330_37400 = state_37282__$1;
(statearr_37330_37400[(1)] = (27));

} else {
var statearr_37331_37401 = state_37282__$1;
(statearr_37331_37401[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (34))){
var state_37282__$1 = state_37282;
var statearr_37332_37402 = state_37282__$1;
(statearr_37332_37402[(2)] = null);

(statearr_37332_37402[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (17))){
var state_37282__$1 = state_37282;
var statearr_37333_37403 = state_37282__$1;
(statearr_37333_37403[(2)] = null);

(statearr_37333_37403[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (3))){
var inst_37280 = (state_37282[(2)]);
var state_37282__$1 = state_37282;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37282__$1,inst_37280);
} else {
if((state_val_37283 === (12))){
var inst_37209 = (state_37282[(2)]);
var state_37282__$1 = state_37282;
var statearr_37334_37404 = state_37282__$1;
(statearr_37334_37404[(2)] = inst_37209);

(statearr_37334_37404[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (2))){
var state_37282__$1 = state_37282;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37282__$1,(4),ch);
} else {
if((state_val_37283 === (23))){
var state_37282__$1 = state_37282;
var statearr_37335_37405 = state_37282__$1;
(statearr_37335_37405[(2)] = null);

(statearr_37335_37405[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (35))){
var inst_37264 = (state_37282[(2)]);
var state_37282__$1 = state_37282;
var statearr_37336_37406 = state_37282__$1;
(statearr_37336_37406[(2)] = inst_37264);

(statearr_37336_37406[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (19))){
var inst_37183 = (state_37282[(7)]);
var inst_37187 = cljs.core.chunk_first(inst_37183);
var inst_37188 = cljs.core.chunk_rest(inst_37183);
var inst_37189 = cljs.core.count(inst_37187);
var inst_37163 = inst_37188;
var inst_37164 = inst_37187;
var inst_37165 = inst_37189;
var inst_37166 = (0);
var state_37282__$1 = (function (){var statearr_37337 = state_37282;
(statearr_37337[(13)] = inst_37165);

(statearr_37337[(14)] = inst_37166);

(statearr_37337[(15)] = inst_37163);

(statearr_37337[(16)] = inst_37164);

return statearr_37337;
})();
var statearr_37338_37407 = state_37282__$1;
(statearr_37338_37407[(2)] = null);

(statearr_37338_37407[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (11))){
var inst_37183 = (state_37282[(7)]);
var inst_37163 = (state_37282[(15)]);
var inst_37183__$1 = cljs.core.seq(inst_37163);
var state_37282__$1 = (function (){var statearr_37339 = state_37282;
(statearr_37339[(7)] = inst_37183__$1);

return statearr_37339;
})();
if(inst_37183__$1){
var statearr_37340_37408 = state_37282__$1;
(statearr_37340_37408[(1)] = (16));

} else {
var statearr_37341_37409 = state_37282__$1;
(statearr_37341_37409[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (9))){
var inst_37211 = (state_37282[(2)]);
var state_37282__$1 = state_37282;
var statearr_37342_37410 = state_37282__$1;
(statearr_37342_37410[(2)] = inst_37211);

(statearr_37342_37410[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (5))){
var inst_37161 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_37162 = cljs.core.seq(inst_37161);
var inst_37163 = inst_37162;
var inst_37164 = null;
var inst_37165 = (0);
var inst_37166 = (0);
var state_37282__$1 = (function (){var statearr_37343 = state_37282;
(statearr_37343[(13)] = inst_37165);

(statearr_37343[(14)] = inst_37166);

(statearr_37343[(15)] = inst_37163);

(statearr_37343[(16)] = inst_37164);

return statearr_37343;
})();
var statearr_37344_37411 = state_37282__$1;
(statearr_37344_37411[(2)] = null);

(statearr_37344_37411[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (14))){
var state_37282__$1 = state_37282;
var statearr_37345_37412 = state_37282__$1;
(statearr_37345_37412[(2)] = null);

(statearr_37345_37412[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (45))){
var inst_37272 = (state_37282[(2)]);
var state_37282__$1 = state_37282;
var statearr_37346_37413 = state_37282__$1;
(statearr_37346_37413[(2)] = inst_37272);

(statearr_37346_37413[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (26))){
var inst_37214 = (state_37282[(29)]);
var inst_37268 = (state_37282[(2)]);
var inst_37269 = cljs.core.seq(inst_37214);
var state_37282__$1 = (function (){var statearr_37347 = state_37282;
(statearr_37347[(31)] = inst_37268);

return statearr_37347;
})();
if(inst_37269){
var statearr_37348_37414 = state_37282__$1;
(statearr_37348_37414[(1)] = (42));

} else {
var statearr_37349_37415 = state_37282__$1;
(statearr_37349_37415[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (16))){
var inst_37183 = (state_37282[(7)]);
var inst_37185 = cljs.core.chunked_seq_QMARK_(inst_37183);
var state_37282__$1 = state_37282;
if(inst_37185){
var statearr_37350_37416 = state_37282__$1;
(statearr_37350_37416[(1)] = (19));

} else {
var statearr_37351_37417 = state_37282__$1;
(statearr_37351_37417[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (38))){
var inst_37261 = (state_37282[(2)]);
var state_37282__$1 = state_37282;
var statearr_37352_37418 = state_37282__$1;
(statearr_37352_37418[(2)] = inst_37261);

(statearr_37352_37418[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (30))){
var state_37282__$1 = state_37282;
var statearr_37353_37419 = state_37282__$1;
(statearr_37353_37419[(2)] = null);

(statearr_37353_37419[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (10))){
var inst_37166 = (state_37282[(14)]);
var inst_37164 = (state_37282[(16)]);
var inst_37172 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37164,inst_37166);
var inst_37173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37172,(0),null);
var inst_37174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37172,(1),null);
var state_37282__$1 = (function (){var statearr_37354 = state_37282;
(statearr_37354[(26)] = inst_37173);

return statearr_37354;
})();
if(cljs.core.truth_(inst_37174)){
var statearr_37355_37420 = state_37282__$1;
(statearr_37355_37420[(1)] = (13));

} else {
var statearr_37356_37421 = state_37282__$1;
(statearr_37356_37421[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (18))){
var inst_37207 = (state_37282[(2)]);
var state_37282__$1 = state_37282;
var statearr_37357_37422 = state_37282__$1;
(statearr_37357_37422[(2)] = inst_37207);

(statearr_37357_37422[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (42))){
var state_37282__$1 = state_37282;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37282__$1,(45),dchan);
} else {
if((state_val_37283 === (37))){
var inst_37154 = (state_37282[(11)]);
var inst_37250 = (state_37282[(23)]);
var inst_37241 = (state_37282[(25)]);
var inst_37250__$1 = cljs.core.first(inst_37241);
var inst_37251 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37250__$1,inst_37154,done);
var state_37282__$1 = (function (){var statearr_37358 = state_37282;
(statearr_37358[(23)] = inst_37250__$1);

return statearr_37358;
})();
if(cljs.core.truth_(inst_37251)){
var statearr_37359_37423 = state_37282__$1;
(statearr_37359_37423[(1)] = (39));

} else {
var statearr_37360_37424 = state_37282__$1;
(statearr_37360_37424[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37283 === (8))){
var inst_37165 = (state_37282[(13)]);
var inst_37166 = (state_37282[(14)]);
var inst_37168 = (inst_37166 < inst_37165);
var inst_37169 = inst_37168;
var state_37282__$1 = state_37282;
if(cljs.core.truth_(inst_37169)){
var statearr_37361_37425 = state_37282__$1;
(statearr_37361_37425[(1)] = (10));

} else {
var statearr_37362_37426 = state_37282__$1;
(statearr_37362_37426[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto___37372,cs,m,dchan,dctr,done))
;
return ((function (switch__8372__auto__,c__8437__auto___37372,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8373__auto__ = null;
var cljs$core$async$mult_$_state_machine__8373__auto____0 = (function (){
var statearr_37366 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37366[(0)] = cljs$core$async$mult_$_state_machine__8373__auto__);

(statearr_37366[(1)] = (1));

return statearr_37366;
});
var cljs$core$async$mult_$_state_machine__8373__auto____1 = (function (state_37282){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_37282);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e37367){if((e37367 instanceof Object)){
var ex__8376__auto__ = e37367;
var statearr_37368_37427 = state_37282;
(statearr_37368_37427[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37282);

return cljs.core.cst$kw$recur;
} else {
throw e37367;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__37428 = state_37282;
state_37282 = G__37428;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8373__auto__ = function(state_37282){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8373__auto____1.call(this,state_37282);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8373__auto____0;
cljs$core$async$mult_$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8373__auto____1;
return cljs$core$async$mult_$_state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___37372,cs,m,dchan,dctr,done))
})();
var state__8439__auto__ = (function (){var statearr_37369 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_37369[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___37372);

return statearr_37369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___37372,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args37429 = [];
var len__5627__auto___37432 = arguments.length;
var i__5628__auto___37433 = (0);
while(true){
if((i__5628__auto___37433 < len__5627__auto___37432)){
args37429.push((arguments[i__5628__auto___37433]));

var G__37434 = (i__5628__auto___37433 + (1));
i__5628__auto___37433 = G__37434;
continue;
} else {
}
break;
}

var G__37431 = args37429.length;
switch (G__37431) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37429.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto__.call(null,m));
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5225__auto__.call(null,m,state_map));
} else {
var m__5225__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5225__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5225__auto__.call(null,m,mode));
} else {
var m__5225__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5225__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___37446 = arguments.length;
var i__5628__auto___37447 = (0);
while(true){
if((i__5628__auto___37447 < len__5627__auto___37446)){
args__5634__auto__.push((arguments[i__5628__auto___37447]));

var G__37448 = (i__5628__auto___37447 + (1));
i__5628__auto___37447 = G__37448;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__37440){
var map__37441 = p__37440;
var map__37441__$1 = ((((!((map__37441 == null)))?((((map__37441.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37441.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37441):map__37441);
var opts = map__37441__$1;
var statearr_37443_37449 = state;
(statearr_37443_37449[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts(((function (map__37441,map__37441__$1,opts){
return (function (val){
var statearr_37444_37450 = state;
(statearr_37444_37450[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__37441,map__37441__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_37445_37451 = state;
(statearr_37445_37451[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq37436){
var G__37437 = cljs.core.first(seq37436);
var seq37436__$1 = cljs.core.next(seq37436);
var G__37438 = cljs.core.first(seq37436__$1);
var seq37436__$2 = cljs.core.next(seq37436__$1);
var G__37439 = cljs.core.first(seq37436__$2);
var seq37436__$3 = cljs.core.next(seq37436__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__37437,G__37438,G__37439,seq37436__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__37618 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__37618) : cljs.core.atom.call(null,G__37618));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute) : cljs.core.atom.call(null,cljs.core.cst$kw$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async37619 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37619 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta37620){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta37620 = meta37620;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37619.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37621,meta37620__$1){
var self__ = this;
var _37621__$1 = this;
return (new cljs.core.async.t_cljs$core$async37619(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta37620__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37619.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37621){
var self__ = this;
var _37621__$1 = this;
return self__.meta37620;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37619.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async37619.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37619.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async37619.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37619.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37619.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__37622_37784 = self__.cs;
var G__37623_37785 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__37622_37784,G__37623_37785) : cljs.core.reset_BANG_.call(null,G__37622_37784,G__37623_37785));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37619.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37619.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$mode)], 0)))].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37619.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta37620], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37619.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37619.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37619";

cljs.core.async.t_cljs$core$async37619.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async37619");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async37619 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async37619(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta37620){
return (new cljs.core.async.t_cljs$core$async37619(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta37620));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async37619(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8437__auto___37786 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___37786,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___37786,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_37721){
var state_val_37722 = (state_37721[(1)]);
if((state_val_37722 === (7))){
var inst_37639 = (state_37721[(2)]);
var state_37721__$1 = state_37721;
var statearr_37723_37787 = state_37721__$1;
(statearr_37723_37787[(2)] = inst_37639);

(statearr_37723_37787[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (20))){
var inst_37651 = (state_37721[(7)]);
var state_37721__$1 = state_37721;
var statearr_37724_37788 = state_37721__$1;
(statearr_37724_37788[(2)] = inst_37651);

(statearr_37724_37788[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (27))){
var state_37721__$1 = state_37721;
var statearr_37725_37789 = state_37721__$1;
(statearr_37725_37789[(2)] = null);

(statearr_37725_37789[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (1))){
var inst_37627 = (state_37721[(8)]);
var inst_37627__$1 = calc_state();
var inst_37629 = (inst_37627__$1 == null);
var inst_37630 = cljs.core.not(inst_37629);
var state_37721__$1 = (function (){var statearr_37726 = state_37721;
(statearr_37726[(8)] = inst_37627__$1);

return statearr_37726;
})();
if(inst_37630){
var statearr_37727_37790 = state_37721__$1;
(statearr_37727_37790[(1)] = (2));

} else {
var statearr_37728_37791 = state_37721__$1;
(statearr_37728_37791[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (24))){
var inst_37695 = (state_37721[(9)]);
var inst_37681 = (state_37721[(10)]);
var inst_37674 = (state_37721[(11)]);
var inst_37695__$1 = (inst_37674.cljs$core$IFn$_invoke$arity$1 ? inst_37674.cljs$core$IFn$_invoke$arity$1(inst_37681) : inst_37674.call(null,inst_37681));
var state_37721__$1 = (function (){var statearr_37729 = state_37721;
(statearr_37729[(9)] = inst_37695__$1);

return statearr_37729;
})();
if(cljs.core.truth_(inst_37695__$1)){
var statearr_37730_37792 = state_37721__$1;
(statearr_37730_37792[(1)] = (29));

} else {
var statearr_37731_37793 = state_37721__$1;
(statearr_37731_37793[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (4))){
var inst_37642 = (state_37721[(2)]);
var state_37721__$1 = state_37721;
if(cljs.core.truth_(inst_37642)){
var statearr_37732_37794 = state_37721__$1;
(statearr_37732_37794[(1)] = (8));

} else {
var statearr_37733_37795 = state_37721__$1;
(statearr_37733_37795[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (15))){
var inst_37668 = (state_37721[(2)]);
var state_37721__$1 = state_37721;
if(cljs.core.truth_(inst_37668)){
var statearr_37734_37796 = state_37721__$1;
(statearr_37734_37796[(1)] = (19));

} else {
var statearr_37735_37797 = state_37721__$1;
(statearr_37735_37797[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (21))){
var inst_37673 = (state_37721[(12)]);
var inst_37673__$1 = (state_37721[(2)]);
var inst_37674 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37673__$1,cljs.core.cst$kw$solos);
var inst_37675 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37673__$1,cljs.core.cst$kw$mutes);
var inst_37676 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37673__$1,cljs.core.cst$kw$reads);
var state_37721__$1 = (function (){var statearr_37736 = state_37721;
(statearr_37736[(13)] = inst_37675);

(statearr_37736[(12)] = inst_37673__$1);

(statearr_37736[(11)] = inst_37674);

return statearr_37736;
})();
return cljs.core.async.ioc_alts_BANG_(state_37721__$1,(22),inst_37676);
} else {
if((state_val_37722 === (31))){
var inst_37703 = (state_37721[(2)]);
var state_37721__$1 = state_37721;
if(cljs.core.truth_(inst_37703)){
var statearr_37737_37798 = state_37721__$1;
(statearr_37737_37798[(1)] = (32));

} else {
var statearr_37738_37799 = state_37721__$1;
(statearr_37738_37799[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (32))){
var inst_37680 = (state_37721[(14)]);
var state_37721__$1 = state_37721;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37721__$1,(35),out,inst_37680);
} else {
if((state_val_37722 === (33))){
var inst_37673 = (state_37721[(12)]);
var inst_37651 = inst_37673;
var state_37721__$1 = (function (){var statearr_37739 = state_37721;
(statearr_37739[(7)] = inst_37651);

return statearr_37739;
})();
var statearr_37740_37800 = state_37721__$1;
(statearr_37740_37800[(2)] = null);

(statearr_37740_37800[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (13))){
var inst_37651 = (state_37721[(7)]);
var inst_37658 = inst_37651.cljs$lang$protocol_mask$partition0$;
var inst_37659 = (inst_37658 & (64));
var inst_37660 = inst_37651.cljs$core$ISeq$;
var inst_37661 = (inst_37659) || (inst_37660);
var state_37721__$1 = state_37721;
if(cljs.core.truth_(inst_37661)){
var statearr_37741_37801 = state_37721__$1;
(statearr_37741_37801[(1)] = (16));

} else {
var statearr_37742_37802 = state_37721__$1;
(statearr_37742_37802[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (22))){
var inst_37680 = (state_37721[(14)]);
var inst_37681 = (state_37721[(10)]);
var inst_37679 = (state_37721[(2)]);
var inst_37680__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37679,(0),null);
var inst_37681__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37679,(1),null);
var inst_37682 = (inst_37680__$1 == null);
var inst_37683 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37681__$1,change);
var inst_37684 = (inst_37682) || (inst_37683);
var state_37721__$1 = (function (){var statearr_37743 = state_37721;
(statearr_37743[(14)] = inst_37680__$1);

(statearr_37743[(10)] = inst_37681__$1);

return statearr_37743;
})();
if(cljs.core.truth_(inst_37684)){
var statearr_37744_37803 = state_37721__$1;
(statearr_37744_37803[(1)] = (23));

} else {
var statearr_37745_37804 = state_37721__$1;
(statearr_37745_37804[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (36))){
var inst_37673 = (state_37721[(12)]);
var inst_37651 = inst_37673;
var state_37721__$1 = (function (){var statearr_37746 = state_37721;
(statearr_37746[(7)] = inst_37651);

return statearr_37746;
})();
var statearr_37747_37805 = state_37721__$1;
(statearr_37747_37805[(2)] = null);

(statearr_37747_37805[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (29))){
var inst_37695 = (state_37721[(9)]);
var state_37721__$1 = state_37721;
var statearr_37748_37806 = state_37721__$1;
(statearr_37748_37806[(2)] = inst_37695);

(statearr_37748_37806[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (6))){
var state_37721__$1 = state_37721;
var statearr_37749_37807 = state_37721__$1;
(statearr_37749_37807[(2)] = false);

(statearr_37749_37807[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (28))){
var inst_37691 = (state_37721[(2)]);
var inst_37692 = calc_state();
var inst_37651 = inst_37692;
var state_37721__$1 = (function (){var statearr_37750 = state_37721;
(statearr_37750[(15)] = inst_37691);

(statearr_37750[(7)] = inst_37651);

return statearr_37750;
})();
var statearr_37751_37808 = state_37721__$1;
(statearr_37751_37808[(2)] = null);

(statearr_37751_37808[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (25))){
var inst_37717 = (state_37721[(2)]);
var state_37721__$1 = state_37721;
var statearr_37752_37809 = state_37721__$1;
(statearr_37752_37809[(2)] = inst_37717);

(statearr_37752_37809[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (34))){
var inst_37715 = (state_37721[(2)]);
var state_37721__$1 = state_37721;
var statearr_37753_37810 = state_37721__$1;
(statearr_37753_37810[(2)] = inst_37715);

(statearr_37753_37810[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (17))){
var state_37721__$1 = state_37721;
var statearr_37754_37811 = state_37721__$1;
(statearr_37754_37811[(2)] = false);

(statearr_37754_37811[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (3))){
var state_37721__$1 = state_37721;
var statearr_37755_37812 = state_37721__$1;
(statearr_37755_37812[(2)] = false);

(statearr_37755_37812[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (12))){
var inst_37719 = (state_37721[(2)]);
var state_37721__$1 = state_37721;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37721__$1,inst_37719);
} else {
if((state_val_37722 === (2))){
var inst_37627 = (state_37721[(8)]);
var inst_37632 = inst_37627.cljs$lang$protocol_mask$partition0$;
var inst_37633 = (inst_37632 & (64));
var inst_37634 = inst_37627.cljs$core$ISeq$;
var inst_37635 = (inst_37633) || (inst_37634);
var state_37721__$1 = state_37721;
if(cljs.core.truth_(inst_37635)){
var statearr_37756_37813 = state_37721__$1;
(statearr_37756_37813[(1)] = (5));

} else {
var statearr_37757_37814 = state_37721__$1;
(statearr_37757_37814[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (23))){
var inst_37680 = (state_37721[(14)]);
var inst_37686 = (inst_37680 == null);
var state_37721__$1 = state_37721;
if(cljs.core.truth_(inst_37686)){
var statearr_37758_37815 = state_37721__$1;
(statearr_37758_37815[(1)] = (26));

} else {
var statearr_37759_37816 = state_37721__$1;
(statearr_37759_37816[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (35))){
var inst_37706 = (state_37721[(2)]);
var state_37721__$1 = state_37721;
if(cljs.core.truth_(inst_37706)){
var statearr_37760_37817 = state_37721__$1;
(statearr_37760_37817[(1)] = (36));

} else {
var statearr_37761_37818 = state_37721__$1;
(statearr_37761_37818[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (19))){
var inst_37651 = (state_37721[(7)]);
var inst_37670 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37651);
var state_37721__$1 = state_37721;
var statearr_37762_37819 = state_37721__$1;
(statearr_37762_37819[(2)] = inst_37670);

(statearr_37762_37819[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (11))){
var inst_37651 = (state_37721[(7)]);
var inst_37655 = (inst_37651 == null);
var inst_37656 = cljs.core.not(inst_37655);
var state_37721__$1 = state_37721;
if(inst_37656){
var statearr_37763_37820 = state_37721__$1;
(statearr_37763_37820[(1)] = (13));

} else {
var statearr_37764_37821 = state_37721__$1;
(statearr_37764_37821[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (9))){
var inst_37627 = (state_37721[(8)]);
var state_37721__$1 = state_37721;
var statearr_37765_37822 = state_37721__$1;
(statearr_37765_37822[(2)] = inst_37627);

(statearr_37765_37822[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (5))){
var state_37721__$1 = state_37721;
var statearr_37766_37823 = state_37721__$1;
(statearr_37766_37823[(2)] = true);

(statearr_37766_37823[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (14))){
var state_37721__$1 = state_37721;
var statearr_37767_37824 = state_37721__$1;
(statearr_37767_37824[(2)] = false);

(statearr_37767_37824[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (26))){
var inst_37681 = (state_37721[(10)]);
var inst_37688 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_37681);
var state_37721__$1 = state_37721;
var statearr_37768_37825 = state_37721__$1;
(statearr_37768_37825[(2)] = inst_37688);

(statearr_37768_37825[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (16))){
var state_37721__$1 = state_37721;
var statearr_37769_37826 = state_37721__$1;
(statearr_37769_37826[(2)] = true);

(statearr_37769_37826[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (38))){
var inst_37711 = (state_37721[(2)]);
var state_37721__$1 = state_37721;
var statearr_37770_37827 = state_37721__$1;
(statearr_37770_37827[(2)] = inst_37711);

(statearr_37770_37827[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (30))){
var inst_37675 = (state_37721[(13)]);
var inst_37681 = (state_37721[(10)]);
var inst_37674 = (state_37721[(11)]);
var inst_37698 = cljs.core.empty_QMARK_(inst_37674);
var inst_37699 = (inst_37675.cljs$core$IFn$_invoke$arity$1 ? inst_37675.cljs$core$IFn$_invoke$arity$1(inst_37681) : inst_37675.call(null,inst_37681));
var inst_37700 = cljs.core.not(inst_37699);
var inst_37701 = (inst_37698) && (inst_37700);
var state_37721__$1 = state_37721;
var statearr_37771_37828 = state_37721__$1;
(statearr_37771_37828[(2)] = inst_37701);

(statearr_37771_37828[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (10))){
var inst_37627 = (state_37721[(8)]);
var inst_37647 = (state_37721[(2)]);
var inst_37648 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37647,cljs.core.cst$kw$solos);
var inst_37649 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37647,cljs.core.cst$kw$mutes);
var inst_37650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37647,cljs.core.cst$kw$reads);
var inst_37651 = inst_37627;
var state_37721__$1 = (function (){var statearr_37772 = state_37721;
(statearr_37772[(16)] = inst_37648);

(statearr_37772[(17)] = inst_37649);

(statearr_37772[(18)] = inst_37650);

(statearr_37772[(7)] = inst_37651);

return statearr_37772;
})();
var statearr_37773_37829 = state_37721__$1;
(statearr_37773_37829[(2)] = null);

(statearr_37773_37829[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (18))){
var inst_37665 = (state_37721[(2)]);
var state_37721__$1 = state_37721;
var statearr_37774_37830 = state_37721__$1;
(statearr_37774_37830[(2)] = inst_37665);

(statearr_37774_37830[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (37))){
var state_37721__$1 = state_37721;
var statearr_37775_37831 = state_37721__$1;
(statearr_37775_37831[(2)] = null);

(statearr_37775_37831[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37722 === (8))){
var inst_37627 = (state_37721[(8)]);
var inst_37644 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37627);
var state_37721__$1 = state_37721;
var statearr_37776_37832 = state_37721__$1;
(statearr_37776_37832[(2)] = inst_37644);

(statearr_37776_37832[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto___37786,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8372__auto__,c__8437__auto___37786,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8373__auto__ = null;
var cljs$core$async$mix_$_state_machine__8373__auto____0 = (function (){
var statearr_37780 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37780[(0)] = cljs$core$async$mix_$_state_machine__8373__auto__);

(statearr_37780[(1)] = (1));

return statearr_37780;
});
var cljs$core$async$mix_$_state_machine__8373__auto____1 = (function (state_37721){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_37721);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e37781){if((e37781 instanceof Object)){
var ex__8376__auto__ = e37781;
var statearr_37782_37833 = state_37721;
(statearr_37782_37833[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37721);

return cljs.core.cst$kw$recur;
} else {
throw e37781;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__37834 = state_37721;
state_37721 = G__37834;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8373__auto__ = function(state_37721){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8373__auto____1.call(this,state_37721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8373__auto____0;
cljs$core$async$mix_$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8373__auto____1;
return cljs$core$async$mix_$_state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___37786,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8439__auto__ = (function (){var statearr_37783 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_37783[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___37786);

return statearr_37783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___37786,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5225__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5225__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5225__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5225__auto__.call(null,p,v,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5225__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args37835 = [];
var len__5627__auto___37838 = arguments.length;
var i__5628__auto___37839 = (0);
while(true){
if((i__5628__auto___37839 < len__5627__auto___37838)){
args37835.push((arguments[i__5628__auto___37839]));

var G__37840 = (i__5628__auto___37839 + (1));
i__5628__auto___37839 = G__37840;
continue;
} else {
}
break;
}

var G__37837 = args37835.length;
switch (G__37837) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37835.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5225__auto__.call(null,p));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__5225__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5225__auto__.call(null,p,v));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__5225__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args37843 = [];
var len__5627__auto___37971 = arguments.length;
var i__5628__auto___37972 = (0);
while(true){
if((i__5628__auto___37972 < len__5627__auto___37971)){
args37843.push((arguments[i__5628__auto___37972]));

var G__37973 = (i__5628__auto___37972 + (1));
i__5628__auto___37972 = G__37973;
continue;
} else {
}
break;
}

var G__37845 = args37843.length;
switch (G__37845) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37843.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__37846 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__37846) : cljs.core.atom.call(null,G__37846));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__4569__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__4569__auto__,mults){
return (function (p1__37842_SHARP_){
if(cljs.core.truth_((p1__37842_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__37842_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__37842_SHARP_.call(null,topic)))){
return p1__37842_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__37842_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__4569__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async37847 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37847 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta37848){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta37848 = meta37848;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37847.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_37849,meta37848__$1){
var self__ = this;
var _37849__$1 = this;
return (new cljs.core.async.t_cljs$core$async37847(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta37848__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37847.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_37849){
var self__ = this;
var _37849__$1 = this;
return self__.meta37848;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37847.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async37847.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37847.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async37847.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37847.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37847.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__37850 = self__.mults;
var G__37851 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__37850,G__37851) : cljs.core.reset_BANG_.call(null,G__37850,G__37851));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37847.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37847.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta37848], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37847.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37847.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37847";

cljs.core.async.t_cljs$core$async37847.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async37847");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async37847 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async37847(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37848){
return (new cljs.core.async.t_cljs$core$async37847(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37848));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async37847(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8437__auto___37975 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___37975,mults,ensure_mult,p){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___37975,mults,ensure_mult,p){
return (function (state_37923){
var state_val_37924 = (state_37923[(1)]);
if((state_val_37924 === (7))){
var inst_37919 = (state_37923[(2)]);
var state_37923__$1 = state_37923;
var statearr_37925_37976 = state_37923__$1;
(statearr_37925_37976[(2)] = inst_37919);

(statearr_37925_37976[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (20))){
var state_37923__$1 = state_37923;
var statearr_37926_37977 = state_37923__$1;
(statearr_37926_37977[(2)] = null);

(statearr_37926_37977[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (1))){
var state_37923__$1 = state_37923;
var statearr_37927_37978 = state_37923__$1;
(statearr_37927_37978[(2)] = null);

(statearr_37927_37978[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (24))){
var inst_37902 = (state_37923[(7)]);
var inst_37911 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_37902);
var state_37923__$1 = state_37923;
var statearr_37928_37979 = state_37923__$1;
(statearr_37928_37979[(2)] = inst_37911);

(statearr_37928_37979[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (4))){
var inst_37854 = (state_37923[(8)]);
var inst_37854__$1 = (state_37923[(2)]);
var inst_37855 = (inst_37854__$1 == null);
var state_37923__$1 = (function (){var statearr_37929 = state_37923;
(statearr_37929[(8)] = inst_37854__$1);

return statearr_37929;
})();
if(cljs.core.truth_(inst_37855)){
var statearr_37930_37980 = state_37923__$1;
(statearr_37930_37980[(1)] = (5));

} else {
var statearr_37931_37981 = state_37923__$1;
(statearr_37931_37981[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (15))){
var inst_37896 = (state_37923[(2)]);
var state_37923__$1 = state_37923;
var statearr_37932_37982 = state_37923__$1;
(statearr_37932_37982[(2)] = inst_37896);

(statearr_37932_37982[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (21))){
var inst_37916 = (state_37923[(2)]);
var state_37923__$1 = (function (){var statearr_37933 = state_37923;
(statearr_37933[(9)] = inst_37916);

return statearr_37933;
})();
var statearr_37934_37983 = state_37923__$1;
(statearr_37934_37983[(2)] = null);

(statearr_37934_37983[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (13))){
var inst_37878 = (state_37923[(10)]);
var inst_37880 = cljs.core.chunked_seq_QMARK_(inst_37878);
var state_37923__$1 = state_37923;
if(inst_37880){
var statearr_37935_37984 = state_37923__$1;
(statearr_37935_37984[(1)] = (16));

} else {
var statearr_37936_37985 = state_37923__$1;
(statearr_37936_37985[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (22))){
var inst_37908 = (state_37923[(2)]);
var state_37923__$1 = state_37923;
if(cljs.core.truth_(inst_37908)){
var statearr_37937_37986 = state_37923__$1;
(statearr_37937_37986[(1)] = (23));

} else {
var statearr_37938_37987 = state_37923__$1;
(statearr_37938_37987[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (6))){
var inst_37902 = (state_37923[(7)]);
var inst_37854 = (state_37923[(8)]);
var inst_37904 = (state_37923[(11)]);
var inst_37902__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_37854) : topic_fn.call(null,inst_37854));
var inst_37903 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_37904__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37903,inst_37902__$1);
var state_37923__$1 = (function (){var statearr_37939 = state_37923;
(statearr_37939[(7)] = inst_37902__$1);

(statearr_37939[(11)] = inst_37904__$1);

return statearr_37939;
})();
if(cljs.core.truth_(inst_37904__$1)){
var statearr_37940_37988 = state_37923__$1;
(statearr_37940_37988[(1)] = (19));

} else {
var statearr_37941_37989 = state_37923__$1;
(statearr_37941_37989[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (25))){
var inst_37913 = (state_37923[(2)]);
var state_37923__$1 = state_37923;
var statearr_37942_37990 = state_37923__$1;
(statearr_37942_37990[(2)] = inst_37913);

(statearr_37942_37990[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (17))){
var inst_37878 = (state_37923[(10)]);
var inst_37887 = cljs.core.first(inst_37878);
var inst_37888 = cljs.core.async.muxch_STAR_(inst_37887);
var inst_37889 = cljs.core.async.close_BANG_(inst_37888);
var inst_37890 = cljs.core.next(inst_37878);
var inst_37864 = inst_37890;
var inst_37865 = null;
var inst_37866 = (0);
var inst_37867 = (0);
var state_37923__$1 = (function (){var statearr_37943 = state_37923;
(statearr_37943[(12)] = inst_37865);

(statearr_37943[(13)] = inst_37889);

(statearr_37943[(14)] = inst_37867);

(statearr_37943[(15)] = inst_37866);

(statearr_37943[(16)] = inst_37864);

return statearr_37943;
})();
var statearr_37944_37991 = state_37923__$1;
(statearr_37944_37991[(2)] = null);

(statearr_37944_37991[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (3))){
var inst_37921 = (state_37923[(2)]);
var state_37923__$1 = state_37923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37923__$1,inst_37921);
} else {
if((state_val_37924 === (12))){
var inst_37898 = (state_37923[(2)]);
var state_37923__$1 = state_37923;
var statearr_37945_37992 = state_37923__$1;
(statearr_37945_37992[(2)] = inst_37898);

(statearr_37945_37992[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (2))){
var state_37923__$1 = state_37923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37923__$1,(4),ch);
} else {
if((state_val_37924 === (23))){
var state_37923__$1 = state_37923;
var statearr_37946_37993 = state_37923__$1;
(statearr_37946_37993[(2)] = null);

(statearr_37946_37993[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (19))){
var inst_37854 = (state_37923[(8)]);
var inst_37904 = (state_37923[(11)]);
var inst_37906 = cljs.core.async.muxch_STAR_(inst_37904);
var state_37923__$1 = state_37923;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37923__$1,(22),inst_37906,inst_37854);
} else {
if((state_val_37924 === (11))){
var inst_37864 = (state_37923[(16)]);
var inst_37878 = (state_37923[(10)]);
var inst_37878__$1 = cljs.core.seq(inst_37864);
var state_37923__$1 = (function (){var statearr_37947 = state_37923;
(statearr_37947[(10)] = inst_37878__$1);

return statearr_37947;
})();
if(inst_37878__$1){
var statearr_37948_37994 = state_37923__$1;
(statearr_37948_37994[(1)] = (13));

} else {
var statearr_37949_37995 = state_37923__$1;
(statearr_37949_37995[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (9))){
var inst_37900 = (state_37923[(2)]);
var state_37923__$1 = state_37923;
var statearr_37950_37996 = state_37923__$1;
(statearr_37950_37996[(2)] = inst_37900);

(statearr_37950_37996[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (5))){
var inst_37861 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_37862 = cljs.core.vals(inst_37861);
var inst_37863 = cljs.core.seq(inst_37862);
var inst_37864 = inst_37863;
var inst_37865 = null;
var inst_37866 = (0);
var inst_37867 = (0);
var state_37923__$1 = (function (){var statearr_37951 = state_37923;
(statearr_37951[(12)] = inst_37865);

(statearr_37951[(14)] = inst_37867);

(statearr_37951[(15)] = inst_37866);

(statearr_37951[(16)] = inst_37864);

return statearr_37951;
})();
var statearr_37952_37997 = state_37923__$1;
(statearr_37952_37997[(2)] = null);

(statearr_37952_37997[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (14))){
var state_37923__$1 = state_37923;
var statearr_37956_37998 = state_37923__$1;
(statearr_37956_37998[(2)] = null);

(statearr_37956_37998[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (16))){
var inst_37878 = (state_37923[(10)]);
var inst_37882 = cljs.core.chunk_first(inst_37878);
var inst_37883 = cljs.core.chunk_rest(inst_37878);
var inst_37884 = cljs.core.count(inst_37882);
var inst_37864 = inst_37883;
var inst_37865 = inst_37882;
var inst_37866 = inst_37884;
var inst_37867 = (0);
var state_37923__$1 = (function (){var statearr_37957 = state_37923;
(statearr_37957[(12)] = inst_37865);

(statearr_37957[(14)] = inst_37867);

(statearr_37957[(15)] = inst_37866);

(statearr_37957[(16)] = inst_37864);

return statearr_37957;
})();
var statearr_37958_37999 = state_37923__$1;
(statearr_37958_37999[(2)] = null);

(statearr_37958_37999[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (10))){
var inst_37865 = (state_37923[(12)]);
var inst_37867 = (state_37923[(14)]);
var inst_37866 = (state_37923[(15)]);
var inst_37864 = (state_37923[(16)]);
var inst_37872 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37865,inst_37867);
var inst_37873 = cljs.core.async.muxch_STAR_(inst_37872);
var inst_37874 = cljs.core.async.close_BANG_(inst_37873);
var inst_37875 = (inst_37867 + (1));
var tmp37953 = inst_37865;
var tmp37954 = inst_37866;
var tmp37955 = inst_37864;
var inst_37864__$1 = tmp37955;
var inst_37865__$1 = tmp37953;
var inst_37866__$1 = tmp37954;
var inst_37867__$1 = inst_37875;
var state_37923__$1 = (function (){var statearr_37959 = state_37923;
(statearr_37959[(12)] = inst_37865__$1);

(statearr_37959[(17)] = inst_37874);

(statearr_37959[(14)] = inst_37867__$1);

(statearr_37959[(15)] = inst_37866__$1);

(statearr_37959[(16)] = inst_37864__$1);

return statearr_37959;
})();
var statearr_37960_38000 = state_37923__$1;
(statearr_37960_38000[(2)] = null);

(statearr_37960_38000[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (18))){
var inst_37893 = (state_37923[(2)]);
var state_37923__$1 = state_37923;
var statearr_37961_38001 = state_37923__$1;
(statearr_37961_38001[(2)] = inst_37893);

(statearr_37961_38001[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37924 === (8))){
var inst_37867 = (state_37923[(14)]);
var inst_37866 = (state_37923[(15)]);
var inst_37869 = (inst_37867 < inst_37866);
var inst_37870 = inst_37869;
var state_37923__$1 = state_37923;
if(cljs.core.truth_(inst_37870)){
var statearr_37962_38002 = state_37923__$1;
(statearr_37962_38002[(1)] = (10));

} else {
var statearr_37963_38003 = state_37923__$1;
(statearr_37963_38003[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto___37975,mults,ensure_mult,p))
;
return ((function (switch__8372__auto__,c__8437__auto___37975,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8373__auto__ = null;
var cljs$core$async$state_machine__8373__auto____0 = (function (){
var statearr_37967 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37967[(0)] = cljs$core$async$state_machine__8373__auto__);

(statearr_37967[(1)] = (1));

return statearr_37967;
});
var cljs$core$async$state_machine__8373__auto____1 = (function (state_37923){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_37923);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e37968){if((e37968 instanceof Object)){
var ex__8376__auto__ = e37968;
var statearr_37969_38004 = state_37923;
(statearr_37969_38004[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37923);

return cljs.core.cst$kw$recur;
} else {
throw e37968;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__38005 = state_37923;
state_37923 = G__38005;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$state_machine__8373__auto__ = function(state_37923){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8373__auto____1.call(this,state_37923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8373__auto____0;
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8373__auto____1;
return cljs$core$async$state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___37975,mults,ensure_mult,p))
})();
var state__8439__auto__ = (function (){var statearr_37970 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_37970[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___37975);

return statearr_37970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___37975,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args38006 = [];
var len__5627__auto___38009 = arguments.length;
var i__5628__auto___38010 = (0);
while(true){
if((i__5628__auto___38010 < len__5627__auto___38009)){
args38006.push((arguments[i__5628__auto___38010]));

var G__38011 = (i__5628__auto___38010 + (1));
i__5628__auto___38010 = G__38011;
continue;
} else {
}
break;
}

var G__38008 = args38006.length;
switch (G__38008) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38006.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args38013 = [];
var len__5627__auto___38016 = arguments.length;
var i__5628__auto___38017 = (0);
while(true){
if((i__5628__auto___38017 < len__5627__auto___38016)){
args38013.push((arguments[i__5628__auto___38017]));

var G__38018 = (i__5628__auto___38017 + (1));
i__5628__auto___38017 = G__38018;
continue;
} else {
}
break;
}

var G__38015 = args38013.length;
switch (G__38015) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38013.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args38020 = [];
var len__5627__auto___38091 = arguments.length;
var i__5628__auto___38092 = (0);
while(true){
if((i__5628__auto___38092 < len__5627__auto___38091)){
args38020.push((arguments[i__5628__auto___38092]));

var G__38093 = (i__5628__auto___38092 + (1));
i__5628__auto___38092 = G__38093;
continue;
} else {
}
break;
}

var G__38022 = args38020.length;
switch (G__38022) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38020.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__8437__auto___38095 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___38095,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___38095,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_38061){
var state_val_38062 = (state_38061[(1)]);
if((state_val_38062 === (7))){
var state_38061__$1 = state_38061;
var statearr_38063_38096 = state_38061__$1;
(statearr_38063_38096[(2)] = null);

(statearr_38063_38096[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38062 === (1))){
var state_38061__$1 = state_38061;
var statearr_38064_38097 = state_38061__$1;
(statearr_38064_38097[(2)] = null);

(statearr_38064_38097[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38062 === (4))){
var inst_38025 = (state_38061[(7)]);
var inst_38027 = (inst_38025 < cnt);
var state_38061__$1 = state_38061;
if(cljs.core.truth_(inst_38027)){
var statearr_38065_38098 = state_38061__$1;
(statearr_38065_38098[(1)] = (6));

} else {
var statearr_38066_38099 = state_38061__$1;
(statearr_38066_38099[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38062 === (15))){
var inst_38057 = (state_38061[(2)]);
var state_38061__$1 = state_38061;
var statearr_38067_38100 = state_38061__$1;
(statearr_38067_38100[(2)] = inst_38057);

(statearr_38067_38100[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38062 === (13))){
var inst_38050 = cljs.core.async.close_BANG_(out);
var state_38061__$1 = state_38061;
var statearr_38068_38101 = state_38061__$1;
(statearr_38068_38101[(2)] = inst_38050);

(statearr_38068_38101[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38062 === (6))){
var state_38061__$1 = state_38061;
var statearr_38069_38102 = state_38061__$1;
(statearr_38069_38102[(2)] = null);

(statearr_38069_38102[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38062 === (3))){
var inst_38059 = (state_38061[(2)]);
var state_38061__$1 = state_38061;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38061__$1,inst_38059);
} else {
if((state_val_38062 === (12))){
var inst_38047 = (state_38061[(8)]);
var inst_38047__$1 = (state_38061[(2)]);
var inst_38048 = cljs.core.some(cljs.core.nil_QMARK_,inst_38047__$1);
var state_38061__$1 = (function (){var statearr_38070 = state_38061;
(statearr_38070[(8)] = inst_38047__$1);

return statearr_38070;
})();
if(cljs.core.truth_(inst_38048)){
var statearr_38071_38103 = state_38061__$1;
(statearr_38071_38103[(1)] = (13));

} else {
var statearr_38072_38104 = state_38061__$1;
(statearr_38072_38104[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38062 === (2))){
var inst_38024 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_38025 = (0);
var state_38061__$1 = (function (){var statearr_38073 = state_38061;
(statearr_38073[(9)] = inst_38024);

(statearr_38073[(7)] = inst_38025);

return statearr_38073;
})();
var statearr_38074_38105 = state_38061__$1;
(statearr_38074_38105[(2)] = null);

(statearr_38074_38105[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38062 === (11))){
var inst_38025 = (state_38061[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_38061,(10),Object,null,(9));
var inst_38034 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_38025) : chs__$1.call(null,inst_38025));
var inst_38035 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_38025) : done.call(null,inst_38025));
var inst_38036 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38034,inst_38035);
var state_38061__$1 = state_38061;
var statearr_38075_38106 = state_38061__$1;
(statearr_38075_38106[(2)] = inst_38036);


cljs.core.async.impl.ioc_helpers.process_exception(state_38061__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_38062 === (9))){
var inst_38025 = (state_38061[(7)]);
var inst_38038 = (state_38061[(2)]);
var inst_38039 = (inst_38025 + (1));
var inst_38025__$1 = inst_38039;
var state_38061__$1 = (function (){var statearr_38076 = state_38061;
(statearr_38076[(10)] = inst_38038);

(statearr_38076[(7)] = inst_38025__$1);

return statearr_38076;
})();
var statearr_38077_38107 = state_38061__$1;
(statearr_38077_38107[(2)] = null);

(statearr_38077_38107[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38062 === (5))){
var inst_38045 = (state_38061[(2)]);
var state_38061__$1 = (function (){var statearr_38078 = state_38061;
(statearr_38078[(11)] = inst_38045);

return statearr_38078;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38061__$1,(12),dchan);
} else {
if((state_val_38062 === (14))){
var inst_38047 = (state_38061[(8)]);
var inst_38052 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_38047);
var state_38061__$1 = state_38061;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38061__$1,(16),out,inst_38052);
} else {
if((state_val_38062 === (16))){
var inst_38054 = (state_38061[(2)]);
var state_38061__$1 = (function (){var statearr_38079 = state_38061;
(statearr_38079[(12)] = inst_38054);

return statearr_38079;
})();
var statearr_38080_38108 = state_38061__$1;
(statearr_38080_38108[(2)] = null);

(statearr_38080_38108[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38062 === (10))){
var inst_38029 = (state_38061[(2)]);
var inst_38030 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_38061__$1 = (function (){var statearr_38081 = state_38061;
(statearr_38081[(13)] = inst_38029);

return statearr_38081;
})();
var statearr_38082_38109 = state_38061__$1;
(statearr_38082_38109[(2)] = inst_38030);


cljs.core.async.impl.ioc_helpers.process_exception(state_38061__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_38062 === (8))){
var inst_38043 = (state_38061[(2)]);
var state_38061__$1 = state_38061;
var statearr_38083_38110 = state_38061__$1;
(statearr_38083_38110[(2)] = inst_38043);

(statearr_38083_38110[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto___38095,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8372__auto__,c__8437__auto___38095,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8373__auto__ = null;
var cljs$core$async$state_machine__8373__auto____0 = (function (){
var statearr_38087 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38087[(0)] = cljs$core$async$state_machine__8373__auto__);

(statearr_38087[(1)] = (1));

return statearr_38087;
});
var cljs$core$async$state_machine__8373__auto____1 = (function (state_38061){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_38061);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e38088){if((e38088 instanceof Object)){
var ex__8376__auto__ = e38088;
var statearr_38089_38111 = state_38061;
(statearr_38089_38111[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38061);

return cljs.core.cst$kw$recur;
} else {
throw e38088;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__38112 = state_38061;
state_38061 = G__38112;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$state_machine__8373__auto__ = function(state_38061){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8373__auto____1.call(this,state_38061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8373__auto____0;
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8373__auto____1;
return cljs$core$async$state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___38095,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8439__auto__ = (function (){var statearr_38090 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_38090[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___38095);

return statearr_38090;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___38095,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args38114 = [];
var len__5627__auto___38170 = arguments.length;
var i__5628__auto___38171 = (0);
while(true){
if((i__5628__auto___38171 < len__5627__auto___38170)){
args38114.push((arguments[i__5628__auto___38171]));

var G__38172 = (i__5628__auto___38171 + (1));
i__5628__auto___38171 = G__38172;
continue;
} else {
}
break;
}

var G__38116 = args38114.length;
switch (G__38116) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38114.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8437__auto___38174 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___38174,out){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___38174,out){
return (function (state_38146){
var state_val_38147 = (state_38146[(1)]);
if((state_val_38147 === (7))){
var inst_38125 = (state_38146[(7)]);
var inst_38126 = (state_38146[(8)]);
var inst_38125__$1 = (state_38146[(2)]);
var inst_38126__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38125__$1,(0),null);
var inst_38127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38125__$1,(1),null);
var inst_38128 = (inst_38126__$1 == null);
var state_38146__$1 = (function (){var statearr_38148 = state_38146;
(statearr_38148[(9)] = inst_38127);

(statearr_38148[(7)] = inst_38125__$1);

(statearr_38148[(8)] = inst_38126__$1);

return statearr_38148;
})();
if(cljs.core.truth_(inst_38128)){
var statearr_38149_38175 = state_38146__$1;
(statearr_38149_38175[(1)] = (8));

} else {
var statearr_38150_38176 = state_38146__$1;
(statearr_38150_38176[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38147 === (1))){
var inst_38117 = cljs.core.vec(chs);
var inst_38118 = inst_38117;
var state_38146__$1 = (function (){var statearr_38151 = state_38146;
(statearr_38151[(10)] = inst_38118);

return statearr_38151;
})();
var statearr_38152_38177 = state_38146__$1;
(statearr_38152_38177[(2)] = null);

(statearr_38152_38177[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38147 === (4))){
var inst_38118 = (state_38146[(10)]);
var state_38146__$1 = state_38146;
return cljs.core.async.ioc_alts_BANG_(state_38146__$1,(7),inst_38118);
} else {
if((state_val_38147 === (6))){
var inst_38142 = (state_38146[(2)]);
var state_38146__$1 = state_38146;
var statearr_38153_38178 = state_38146__$1;
(statearr_38153_38178[(2)] = inst_38142);

(statearr_38153_38178[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38147 === (3))){
var inst_38144 = (state_38146[(2)]);
var state_38146__$1 = state_38146;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38146__$1,inst_38144);
} else {
if((state_val_38147 === (2))){
var inst_38118 = (state_38146[(10)]);
var inst_38120 = cljs.core.count(inst_38118);
var inst_38121 = (inst_38120 > (0));
var state_38146__$1 = state_38146;
if(cljs.core.truth_(inst_38121)){
var statearr_38155_38179 = state_38146__$1;
(statearr_38155_38179[(1)] = (4));

} else {
var statearr_38156_38180 = state_38146__$1;
(statearr_38156_38180[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38147 === (11))){
var inst_38118 = (state_38146[(10)]);
var inst_38135 = (state_38146[(2)]);
var tmp38154 = inst_38118;
var inst_38118__$1 = tmp38154;
var state_38146__$1 = (function (){var statearr_38157 = state_38146;
(statearr_38157[(11)] = inst_38135);

(statearr_38157[(10)] = inst_38118__$1);

return statearr_38157;
})();
var statearr_38158_38181 = state_38146__$1;
(statearr_38158_38181[(2)] = null);

(statearr_38158_38181[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38147 === (9))){
var inst_38126 = (state_38146[(8)]);
var state_38146__$1 = state_38146;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38146__$1,(11),out,inst_38126);
} else {
if((state_val_38147 === (5))){
var inst_38140 = cljs.core.async.close_BANG_(out);
var state_38146__$1 = state_38146;
var statearr_38159_38182 = state_38146__$1;
(statearr_38159_38182[(2)] = inst_38140);

(statearr_38159_38182[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38147 === (10))){
var inst_38138 = (state_38146[(2)]);
var state_38146__$1 = state_38146;
var statearr_38160_38183 = state_38146__$1;
(statearr_38160_38183[(2)] = inst_38138);

(statearr_38160_38183[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38147 === (8))){
var inst_38127 = (state_38146[(9)]);
var inst_38125 = (state_38146[(7)]);
var inst_38126 = (state_38146[(8)]);
var inst_38118 = (state_38146[(10)]);
var inst_38130 = (function (){var cs = inst_38118;
var vec__38123 = inst_38125;
var v = inst_38126;
var c = inst_38127;
return ((function (cs,vec__38123,v,c,inst_38127,inst_38125,inst_38126,inst_38118,state_val_38147,c__8437__auto___38174,out){
return (function (p1__38113_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__38113_SHARP_);
});
;})(cs,vec__38123,v,c,inst_38127,inst_38125,inst_38126,inst_38118,state_val_38147,c__8437__auto___38174,out))
})();
var inst_38131 = cljs.core.filterv(inst_38130,inst_38118);
var inst_38118__$1 = inst_38131;
var state_38146__$1 = (function (){var statearr_38161 = state_38146;
(statearr_38161[(10)] = inst_38118__$1);

return statearr_38161;
})();
var statearr_38162_38184 = state_38146__$1;
(statearr_38162_38184[(2)] = null);

(statearr_38162_38184[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto___38174,out))
;
return ((function (switch__8372__auto__,c__8437__auto___38174,out){
return (function() {
var cljs$core$async$state_machine__8373__auto__ = null;
var cljs$core$async$state_machine__8373__auto____0 = (function (){
var statearr_38166 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38166[(0)] = cljs$core$async$state_machine__8373__auto__);

(statearr_38166[(1)] = (1));

return statearr_38166;
});
var cljs$core$async$state_machine__8373__auto____1 = (function (state_38146){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_38146);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e38167){if((e38167 instanceof Object)){
var ex__8376__auto__ = e38167;
var statearr_38168_38185 = state_38146;
(statearr_38168_38185[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38146);

return cljs.core.cst$kw$recur;
} else {
throw e38167;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__38186 = state_38146;
state_38146 = G__38186;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$state_machine__8373__auto__ = function(state_38146){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8373__auto____1.call(this,state_38146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8373__auto____0;
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8373__auto____1;
return cljs$core$async$state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___38174,out))
})();
var state__8439__auto__ = (function (){var statearr_38169 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_38169[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___38174);

return statearr_38169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___38174,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args38187 = [];
var len__5627__auto___38236 = arguments.length;
var i__5628__auto___38237 = (0);
while(true){
if((i__5628__auto___38237 < len__5627__auto___38236)){
args38187.push((arguments[i__5628__auto___38237]));

var G__38238 = (i__5628__auto___38237 + (1));
i__5628__auto___38237 = G__38238;
continue;
} else {
}
break;
}

var G__38189 = args38187.length;
switch (G__38189) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38187.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8437__auto___38240 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___38240,out){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___38240,out){
return (function (state_38213){
var state_val_38214 = (state_38213[(1)]);
if((state_val_38214 === (7))){
var inst_38195 = (state_38213[(7)]);
var inst_38195__$1 = (state_38213[(2)]);
var inst_38196 = (inst_38195__$1 == null);
var inst_38197 = cljs.core.not(inst_38196);
var state_38213__$1 = (function (){var statearr_38215 = state_38213;
(statearr_38215[(7)] = inst_38195__$1);

return statearr_38215;
})();
if(inst_38197){
var statearr_38216_38241 = state_38213__$1;
(statearr_38216_38241[(1)] = (8));

} else {
var statearr_38217_38242 = state_38213__$1;
(statearr_38217_38242[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38214 === (1))){
var inst_38190 = (0);
var state_38213__$1 = (function (){var statearr_38218 = state_38213;
(statearr_38218[(8)] = inst_38190);

return statearr_38218;
})();
var statearr_38219_38243 = state_38213__$1;
(statearr_38219_38243[(2)] = null);

(statearr_38219_38243[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38214 === (4))){
var state_38213__$1 = state_38213;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38213__$1,(7),ch);
} else {
if((state_val_38214 === (6))){
var inst_38208 = (state_38213[(2)]);
var state_38213__$1 = state_38213;
var statearr_38220_38244 = state_38213__$1;
(statearr_38220_38244[(2)] = inst_38208);

(statearr_38220_38244[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38214 === (3))){
var inst_38210 = (state_38213[(2)]);
var inst_38211 = cljs.core.async.close_BANG_(out);
var state_38213__$1 = (function (){var statearr_38221 = state_38213;
(statearr_38221[(9)] = inst_38210);

return statearr_38221;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38213__$1,inst_38211);
} else {
if((state_val_38214 === (2))){
var inst_38190 = (state_38213[(8)]);
var inst_38192 = (inst_38190 < n);
var state_38213__$1 = state_38213;
if(cljs.core.truth_(inst_38192)){
var statearr_38222_38245 = state_38213__$1;
(statearr_38222_38245[(1)] = (4));

} else {
var statearr_38223_38246 = state_38213__$1;
(statearr_38223_38246[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38214 === (11))){
var inst_38190 = (state_38213[(8)]);
var inst_38200 = (state_38213[(2)]);
var inst_38201 = (inst_38190 + (1));
var inst_38190__$1 = inst_38201;
var state_38213__$1 = (function (){var statearr_38224 = state_38213;
(statearr_38224[(8)] = inst_38190__$1);

(statearr_38224[(10)] = inst_38200);

return statearr_38224;
})();
var statearr_38225_38247 = state_38213__$1;
(statearr_38225_38247[(2)] = null);

(statearr_38225_38247[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38214 === (9))){
var state_38213__$1 = state_38213;
var statearr_38226_38248 = state_38213__$1;
(statearr_38226_38248[(2)] = null);

(statearr_38226_38248[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38214 === (5))){
var state_38213__$1 = state_38213;
var statearr_38227_38249 = state_38213__$1;
(statearr_38227_38249[(2)] = null);

(statearr_38227_38249[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38214 === (10))){
var inst_38205 = (state_38213[(2)]);
var state_38213__$1 = state_38213;
var statearr_38228_38250 = state_38213__$1;
(statearr_38228_38250[(2)] = inst_38205);

(statearr_38228_38250[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38214 === (8))){
var inst_38195 = (state_38213[(7)]);
var state_38213__$1 = state_38213;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38213__$1,(11),out,inst_38195);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto___38240,out))
;
return ((function (switch__8372__auto__,c__8437__auto___38240,out){
return (function() {
var cljs$core$async$state_machine__8373__auto__ = null;
var cljs$core$async$state_machine__8373__auto____0 = (function (){
var statearr_38232 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38232[(0)] = cljs$core$async$state_machine__8373__auto__);

(statearr_38232[(1)] = (1));

return statearr_38232;
});
var cljs$core$async$state_machine__8373__auto____1 = (function (state_38213){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_38213);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e38233){if((e38233 instanceof Object)){
var ex__8376__auto__ = e38233;
var statearr_38234_38251 = state_38213;
(statearr_38234_38251[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38213);

return cljs.core.cst$kw$recur;
} else {
throw e38233;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__38252 = state_38213;
state_38213 = G__38252;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$state_machine__8373__auto__ = function(state_38213){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8373__auto____1.call(this,state_38213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8373__auto____0;
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8373__auto____1;
return cljs$core$async$state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___38240,out))
})();
var state__8439__auto__ = (function (){var statearr_38235 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_38235[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___38240);

return statearr_38235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___38240,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async38262 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38262 = (function (map_LT_,f,ch,meta38263){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta38263 = meta38263;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38262.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38264,meta38263__$1){
var self__ = this;
var _38264__$1 = this;
return (new cljs.core.async.t_cljs$core$async38262(self__.map_LT_,self__.f,self__.ch,meta38263__$1));
});

cljs.core.async.t_cljs$core$async38262.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38264){
var self__ = this;
var _38264__$1 = this;
return self__.meta38263;
});

cljs.core.async.t_cljs$core$async38262.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async38262.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38262.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async38262.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async38262.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async38265 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38265 = (function (map_LT_,f,ch,meta38263,_,fn1,meta38266){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta38263 = meta38263;
this._ = _;
this.fn1 = fn1;
this.meta38266 = meta38266;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38265.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_38267,meta38266__$1){
var self__ = this;
var _38267__$1 = this;
return (new cljs.core.async.t_cljs$core$async38265(self__.map_LT_,self__.f,self__.ch,self__.meta38263,self__._,self__.fn1,meta38266__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async38265.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_38267){
var self__ = this;
var _38267__$1 = this;
return self__.meta38266;
});})(___$1))
;

cljs.core.async.t_cljs$core$async38265.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async38265.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38265.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__38253_SHARP_){
var G__38268 = (((p1__38253_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__38253_SHARP_) : self__.f.call(null,p1__38253_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__38268) : f1.call(null,G__38268));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async38265.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38263,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async38262], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta38266], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38265.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38265.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38265";

cljs.core.async.t_cljs$core$async38265.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38265");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async38265 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38265(map_LT___$1,f__$1,ch__$1,meta38263__$1,___$2,fn1__$1,meta38266){
return (new cljs.core.async.t_cljs$core$async38265(map_LT___$1,f__$1,ch__$1,meta38263__$1,___$2,fn1__$1,meta38266));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async38265(self__.map_LT_,self__.f,self__.ch,self__.meta38263,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4557__auto__ = ret;
if(cljs.core.truth_(and__4557__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__4557__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__38269 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__38269) : self__.f.call(null,G__38269));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async38262.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async38262.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async38262.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38263], null);
});

cljs.core.async.t_cljs$core$async38262.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38262.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38262";

cljs.core.async.t_cljs$core$async38262.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38262");
});

cljs.core.async.__GT_t_cljs$core$async38262 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38262(map_LT___$1,f__$1,ch__$1,meta38263){
return (new cljs.core.async.t_cljs$core$async38262(map_LT___$1,f__$1,ch__$1,meta38263));
});

}

return (new cljs.core.async.t_cljs$core$async38262(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async38273 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38273 = (function (map_GT_,f,ch,meta38274){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta38274 = meta38274;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38273.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38275,meta38274__$1){
var self__ = this;
var _38275__$1 = this;
return (new cljs.core.async.t_cljs$core$async38273(self__.map_GT_,self__.f,self__.ch,meta38274__$1));
});

cljs.core.async.t_cljs$core$async38273.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38275){
var self__ = this;
var _38275__$1 = this;
return self__.meta38274;
});

cljs.core.async.t_cljs$core$async38273.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async38273.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38273.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async38273.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38273.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async38273.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async38273.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38274], null);
});

cljs.core.async.t_cljs$core$async38273.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38273.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38273";

cljs.core.async.t_cljs$core$async38273.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38273");
});

cljs.core.async.__GT_t_cljs$core$async38273 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async38273(map_GT___$1,f__$1,ch__$1,meta38274){
return (new cljs.core.async.t_cljs$core$async38273(map_GT___$1,f__$1,ch__$1,meta38274));
});

}

return (new cljs.core.async.t_cljs$core$async38273(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async38279 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38279 = (function (filter_GT_,p,ch,meta38280){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta38280 = meta38280;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38279.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38281,meta38280__$1){
var self__ = this;
var _38281__$1 = this;
return (new cljs.core.async.t_cljs$core$async38279(self__.filter_GT_,self__.p,self__.ch,meta38280__$1));
});

cljs.core.async.t_cljs$core$async38279.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38281){
var self__ = this;
var _38281__$1 = this;
return self__.meta38280;
});

cljs.core.async.t_cljs$core$async38279.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async38279.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38279.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async38279.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async38279.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38279.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async38279.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async38279.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38280], null);
});

cljs.core.async.t_cljs$core$async38279.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38279.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38279";

cljs.core.async.t_cljs$core$async38279.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38279");
});

cljs.core.async.__GT_t_cljs$core$async38279 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async38279(filter_GT___$1,p__$1,ch__$1,meta38280){
return (new cljs.core.async.t_cljs$core$async38279(filter_GT___$1,p__$1,ch__$1,meta38280));
});

}

return (new cljs.core.async.t_cljs$core$async38279(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args38282 = [];
var len__5627__auto___38326 = arguments.length;
var i__5628__auto___38327 = (0);
while(true){
if((i__5628__auto___38327 < len__5627__auto___38326)){
args38282.push((arguments[i__5628__auto___38327]));

var G__38328 = (i__5628__auto___38327 + (1));
i__5628__auto___38327 = G__38328;
continue;
} else {
}
break;
}

var G__38284 = args38282.length;
switch (G__38284) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38282.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8437__auto___38330 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___38330,out){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___38330,out){
return (function (state_38305){
var state_val_38306 = (state_38305[(1)]);
if((state_val_38306 === (7))){
var inst_38301 = (state_38305[(2)]);
var state_38305__$1 = state_38305;
var statearr_38307_38331 = state_38305__$1;
(statearr_38307_38331[(2)] = inst_38301);

(statearr_38307_38331[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38306 === (1))){
var state_38305__$1 = state_38305;
var statearr_38308_38332 = state_38305__$1;
(statearr_38308_38332[(2)] = null);

(statearr_38308_38332[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38306 === (4))){
var inst_38287 = (state_38305[(7)]);
var inst_38287__$1 = (state_38305[(2)]);
var inst_38288 = (inst_38287__$1 == null);
var state_38305__$1 = (function (){var statearr_38309 = state_38305;
(statearr_38309[(7)] = inst_38287__$1);

return statearr_38309;
})();
if(cljs.core.truth_(inst_38288)){
var statearr_38310_38333 = state_38305__$1;
(statearr_38310_38333[(1)] = (5));

} else {
var statearr_38311_38334 = state_38305__$1;
(statearr_38311_38334[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38306 === (6))){
var inst_38287 = (state_38305[(7)]);
var inst_38292 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_38287) : p.call(null,inst_38287));
var state_38305__$1 = state_38305;
if(cljs.core.truth_(inst_38292)){
var statearr_38312_38335 = state_38305__$1;
(statearr_38312_38335[(1)] = (8));

} else {
var statearr_38313_38336 = state_38305__$1;
(statearr_38313_38336[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38306 === (3))){
var inst_38303 = (state_38305[(2)]);
var state_38305__$1 = state_38305;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38305__$1,inst_38303);
} else {
if((state_val_38306 === (2))){
var state_38305__$1 = state_38305;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38305__$1,(4),ch);
} else {
if((state_val_38306 === (11))){
var inst_38295 = (state_38305[(2)]);
var state_38305__$1 = state_38305;
var statearr_38314_38337 = state_38305__$1;
(statearr_38314_38337[(2)] = inst_38295);

(statearr_38314_38337[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38306 === (9))){
var state_38305__$1 = state_38305;
var statearr_38315_38338 = state_38305__$1;
(statearr_38315_38338[(2)] = null);

(statearr_38315_38338[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38306 === (5))){
var inst_38290 = cljs.core.async.close_BANG_(out);
var state_38305__$1 = state_38305;
var statearr_38316_38339 = state_38305__$1;
(statearr_38316_38339[(2)] = inst_38290);

(statearr_38316_38339[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38306 === (10))){
var inst_38298 = (state_38305[(2)]);
var state_38305__$1 = (function (){var statearr_38317 = state_38305;
(statearr_38317[(8)] = inst_38298);

return statearr_38317;
})();
var statearr_38318_38340 = state_38305__$1;
(statearr_38318_38340[(2)] = null);

(statearr_38318_38340[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38306 === (8))){
var inst_38287 = (state_38305[(7)]);
var state_38305__$1 = state_38305;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38305__$1,(11),out,inst_38287);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto___38330,out))
;
return ((function (switch__8372__auto__,c__8437__auto___38330,out){
return (function() {
var cljs$core$async$state_machine__8373__auto__ = null;
var cljs$core$async$state_machine__8373__auto____0 = (function (){
var statearr_38322 = [null,null,null,null,null,null,null,null,null];
(statearr_38322[(0)] = cljs$core$async$state_machine__8373__auto__);

(statearr_38322[(1)] = (1));

return statearr_38322;
});
var cljs$core$async$state_machine__8373__auto____1 = (function (state_38305){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_38305);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e38323){if((e38323 instanceof Object)){
var ex__8376__auto__ = e38323;
var statearr_38324_38341 = state_38305;
(statearr_38324_38341[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38305);

return cljs.core.cst$kw$recur;
} else {
throw e38323;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__38342 = state_38305;
state_38305 = G__38342;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$state_machine__8373__auto__ = function(state_38305){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8373__auto____1.call(this,state_38305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8373__auto____0;
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8373__auto____1;
return cljs$core$async$state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___38330,out))
})();
var state__8439__auto__ = (function (){var statearr_38325 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_38325[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___38330);

return statearr_38325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___38330,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args38343 = [];
var len__5627__auto___38346 = arguments.length;
var i__5628__auto___38347 = (0);
while(true){
if((i__5628__auto___38347 < len__5627__auto___38346)){
args38343.push((arguments[i__5628__auto___38347]));

var G__38348 = (i__5628__auto___38347 + (1));
i__5628__auto___38347 = G__38348;
continue;
} else {
}
break;
}

var G__38345 = args38343.length;
switch (G__38345) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38343.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8437__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto__){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto__){
return (function (state_38515){
var state_val_38516 = (state_38515[(1)]);
if((state_val_38516 === (7))){
var inst_38511 = (state_38515[(2)]);
var state_38515__$1 = state_38515;
var statearr_38517_38558 = state_38515__$1;
(statearr_38517_38558[(2)] = inst_38511);

(statearr_38517_38558[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (20))){
var inst_38481 = (state_38515[(7)]);
var inst_38492 = (state_38515[(2)]);
var inst_38493 = cljs.core.next(inst_38481);
var inst_38467 = inst_38493;
var inst_38468 = null;
var inst_38469 = (0);
var inst_38470 = (0);
var state_38515__$1 = (function (){var statearr_38518 = state_38515;
(statearr_38518[(8)] = inst_38492);

(statearr_38518[(9)] = inst_38468);

(statearr_38518[(10)] = inst_38469);

(statearr_38518[(11)] = inst_38467);

(statearr_38518[(12)] = inst_38470);

return statearr_38518;
})();
var statearr_38519_38559 = state_38515__$1;
(statearr_38519_38559[(2)] = null);

(statearr_38519_38559[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (1))){
var state_38515__$1 = state_38515;
var statearr_38520_38560 = state_38515__$1;
(statearr_38520_38560[(2)] = null);

(statearr_38520_38560[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (4))){
var inst_38456 = (state_38515[(13)]);
var inst_38456__$1 = (state_38515[(2)]);
var inst_38457 = (inst_38456__$1 == null);
var state_38515__$1 = (function (){var statearr_38521 = state_38515;
(statearr_38521[(13)] = inst_38456__$1);

return statearr_38521;
})();
if(cljs.core.truth_(inst_38457)){
var statearr_38522_38561 = state_38515__$1;
(statearr_38522_38561[(1)] = (5));

} else {
var statearr_38523_38562 = state_38515__$1;
(statearr_38523_38562[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (15))){
var state_38515__$1 = state_38515;
var statearr_38527_38563 = state_38515__$1;
(statearr_38527_38563[(2)] = null);

(statearr_38527_38563[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (21))){
var state_38515__$1 = state_38515;
var statearr_38528_38564 = state_38515__$1;
(statearr_38528_38564[(2)] = null);

(statearr_38528_38564[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (13))){
var inst_38468 = (state_38515[(9)]);
var inst_38469 = (state_38515[(10)]);
var inst_38467 = (state_38515[(11)]);
var inst_38470 = (state_38515[(12)]);
var inst_38477 = (state_38515[(2)]);
var inst_38478 = (inst_38470 + (1));
var tmp38524 = inst_38468;
var tmp38525 = inst_38469;
var tmp38526 = inst_38467;
var inst_38467__$1 = tmp38526;
var inst_38468__$1 = tmp38524;
var inst_38469__$1 = tmp38525;
var inst_38470__$1 = inst_38478;
var state_38515__$1 = (function (){var statearr_38529 = state_38515;
(statearr_38529[(9)] = inst_38468__$1);

(statearr_38529[(10)] = inst_38469__$1);

(statearr_38529[(14)] = inst_38477);

(statearr_38529[(11)] = inst_38467__$1);

(statearr_38529[(12)] = inst_38470__$1);

return statearr_38529;
})();
var statearr_38530_38565 = state_38515__$1;
(statearr_38530_38565[(2)] = null);

(statearr_38530_38565[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (22))){
var state_38515__$1 = state_38515;
var statearr_38531_38566 = state_38515__$1;
(statearr_38531_38566[(2)] = null);

(statearr_38531_38566[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (6))){
var inst_38456 = (state_38515[(13)]);
var inst_38465 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38456) : f.call(null,inst_38456));
var inst_38466 = cljs.core.seq(inst_38465);
var inst_38467 = inst_38466;
var inst_38468 = null;
var inst_38469 = (0);
var inst_38470 = (0);
var state_38515__$1 = (function (){var statearr_38532 = state_38515;
(statearr_38532[(9)] = inst_38468);

(statearr_38532[(10)] = inst_38469);

(statearr_38532[(11)] = inst_38467);

(statearr_38532[(12)] = inst_38470);

return statearr_38532;
})();
var statearr_38533_38567 = state_38515__$1;
(statearr_38533_38567[(2)] = null);

(statearr_38533_38567[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (17))){
var inst_38481 = (state_38515[(7)]);
var inst_38485 = cljs.core.chunk_first(inst_38481);
var inst_38486 = cljs.core.chunk_rest(inst_38481);
var inst_38487 = cljs.core.count(inst_38485);
var inst_38467 = inst_38486;
var inst_38468 = inst_38485;
var inst_38469 = inst_38487;
var inst_38470 = (0);
var state_38515__$1 = (function (){var statearr_38534 = state_38515;
(statearr_38534[(9)] = inst_38468);

(statearr_38534[(10)] = inst_38469);

(statearr_38534[(11)] = inst_38467);

(statearr_38534[(12)] = inst_38470);

return statearr_38534;
})();
var statearr_38535_38568 = state_38515__$1;
(statearr_38535_38568[(2)] = null);

(statearr_38535_38568[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (3))){
var inst_38513 = (state_38515[(2)]);
var state_38515__$1 = state_38515;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38515__$1,inst_38513);
} else {
if((state_val_38516 === (12))){
var inst_38501 = (state_38515[(2)]);
var state_38515__$1 = state_38515;
var statearr_38536_38569 = state_38515__$1;
(statearr_38536_38569[(2)] = inst_38501);

(statearr_38536_38569[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (2))){
var state_38515__$1 = state_38515;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38515__$1,(4),in$);
} else {
if((state_val_38516 === (23))){
var inst_38509 = (state_38515[(2)]);
var state_38515__$1 = state_38515;
var statearr_38537_38570 = state_38515__$1;
(statearr_38537_38570[(2)] = inst_38509);

(statearr_38537_38570[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (19))){
var inst_38496 = (state_38515[(2)]);
var state_38515__$1 = state_38515;
var statearr_38538_38571 = state_38515__$1;
(statearr_38538_38571[(2)] = inst_38496);

(statearr_38538_38571[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (11))){
var inst_38467 = (state_38515[(11)]);
var inst_38481 = (state_38515[(7)]);
var inst_38481__$1 = cljs.core.seq(inst_38467);
var state_38515__$1 = (function (){var statearr_38539 = state_38515;
(statearr_38539[(7)] = inst_38481__$1);

return statearr_38539;
})();
if(inst_38481__$1){
var statearr_38540_38572 = state_38515__$1;
(statearr_38540_38572[(1)] = (14));

} else {
var statearr_38541_38573 = state_38515__$1;
(statearr_38541_38573[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (9))){
var inst_38503 = (state_38515[(2)]);
var inst_38504 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_38515__$1 = (function (){var statearr_38542 = state_38515;
(statearr_38542[(15)] = inst_38503);

return statearr_38542;
})();
if(cljs.core.truth_(inst_38504)){
var statearr_38543_38574 = state_38515__$1;
(statearr_38543_38574[(1)] = (21));

} else {
var statearr_38544_38575 = state_38515__$1;
(statearr_38544_38575[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (5))){
var inst_38459 = cljs.core.async.close_BANG_(out);
var state_38515__$1 = state_38515;
var statearr_38545_38576 = state_38515__$1;
(statearr_38545_38576[(2)] = inst_38459);

(statearr_38545_38576[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (14))){
var inst_38481 = (state_38515[(7)]);
var inst_38483 = cljs.core.chunked_seq_QMARK_(inst_38481);
var state_38515__$1 = state_38515;
if(inst_38483){
var statearr_38546_38577 = state_38515__$1;
(statearr_38546_38577[(1)] = (17));

} else {
var statearr_38547_38578 = state_38515__$1;
(statearr_38547_38578[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (16))){
var inst_38499 = (state_38515[(2)]);
var state_38515__$1 = state_38515;
var statearr_38548_38579 = state_38515__$1;
(statearr_38548_38579[(2)] = inst_38499);

(statearr_38548_38579[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38516 === (10))){
var inst_38468 = (state_38515[(9)]);
var inst_38470 = (state_38515[(12)]);
var inst_38475 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_38468,inst_38470);
var state_38515__$1 = state_38515;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38515__$1,(13),out,inst_38475);
} else {
if((state_val_38516 === (18))){
var inst_38481 = (state_38515[(7)]);
var inst_38490 = cljs.core.first(inst_38481);
var state_38515__$1 = state_38515;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38515__$1,(20),out,inst_38490);
} else {
if((state_val_38516 === (8))){
var inst_38469 = (state_38515[(10)]);
var inst_38470 = (state_38515[(12)]);
var inst_38472 = (inst_38470 < inst_38469);
var inst_38473 = inst_38472;
var state_38515__$1 = state_38515;
if(cljs.core.truth_(inst_38473)){
var statearr_38549_38580 = state_38515__$1;
(statearr_38549_38580[(1)] = (10));

} else {
var statearr_38550_38581 = state_38515__$1;
(statearr_38550_38581[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto__))
;
return ((function (switch__8372__auto__,c__8437__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8373__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8373__auto____0 = (function (){
var statearr_38554 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38554[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8373__auto__);

(statearr_38554[(1)] = (1));

return statearr_38554;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8373__auto____1 = (function (state_38515){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_38515);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e38555){if((e38555 instanceof Object)){
var ex__8376__auto__ = e38555;
var statearr_38556_38582 = state_38515;
(statearr_38556_38582[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38515);

return cljs.core.cst$kw$recur;
} else {
throw e38555;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__38583 = state_38515;
state_38515 = G__38583;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8373__auto__ = function(state_38515){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8373__auto____1.call(this,state_38515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8373__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8373__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto__))
})();
var state__8439__auto__ = (function (){var statearr_38557 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_38557[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto__);

return statearr_38557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto__))
);

return c__8437__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args38584 = [];
var len__5627__auto___38587 = arguments.length;
var i__5628__auto___38588 = (0);
while(true){
if((i__5628__auto___38588 < len__5627__auto___38587)){
args38584.push((arguments[i__5628__auto___38588]));

var G__38589 = (i__5628__auto___38588 + (1));
i__5628__auto___38588 = G__38589;
continue;
} else {
}
break;
}

var G__38586 = args38584.length;
switch (G__38586) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38584.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args38591 = [];
var len__5627__auto___38594 = arguments.length;
var i__5628__auto___38595 = (0);
while(true){
if((i__5628__auto___38595 < len__5627__auto___38594)){
args38591.push((arguments[i__5628__auto___38595]));

var G__38596 = (i__5628__auto___38595 + (1));
i__5628__auto___38595 = G__38596;
continue;
} else {
}
break;
}

var G__38593 = args38591.length;
switch (G__38593) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38591.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args38598 = [];
var len__5627__auto___38649 = arguments.length;
var i__5628__auto___38650 = (0);
while(true){
if((i__5628__auto___38650 < len__5627__auto___38649)){
args38598.push((arguments[i__5628__auto___38650]));

var G__38651 = (i__5628__auto___38650 + (1));
i__5628__auto___38650 = G__38651;
continue;
} else {
}
break;
}

var G__38600 = args38598.length;
switch (G__38600) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38598.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8437__auto___38653 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___38653,out){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___38653,out){
return (function (state_38624){
var state_val_38625 = (state_38624[(1)]);
if((state_val_38625 === (7))){
var inst_38619 = (state_38624[(2)]);
var state_38624__$1 = state_38624;
var statearr_38626_38654 = state_38624__$1;
(statearr_38626_38654[(2)] = inst_38619);

(statearr_38626_38654[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38625 === (1))){
var inst_38601 = null;
var state_38624__$1 = (function (){var statearr_38627 = state_38624;
(statearr_38627[(7)] = inst_38601);

return statearr_38627;
})();
var statearr_38628_38655 = state_38624__$1;
(statearr_38628_38655[(2)] = null);

(statearr_38628_38655[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38625 === (4))){
var inst_38604 = (state_38624[(8)]);
var inst_38604__$1 = (state_38624[(2)]);
var inst_38605 = (inst_38604__$1 == null);
var inst_38606 = cljs.core.not(inst_38605);
var state_38624__$1 = (function (){var statearr_38629 = state_38624;
(statearr_38629[(8)] = inst_38604__$1);

return statearr_38629;
})();
if(inst_38606){
var statearr_38630_38656 = state_38624__$1;
(statearr_38630_38656[(1)] = (5));

} else {
var statearr_38631_38657 = state_38624__$1;
(statearr_38631_38657[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38625 === (6))){
var state_38624__$1 = state_38624;
var statearr_38632_38658 = state_38624__$1;
(statearr_38632_38658[(2)] = null);

(statearr_38632_38658[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38625 === (3))){
var inst_38621 = (state_38624[(2)]);
var inst_38622 = cljs.core.async.close_BANG_(out);
var state_38624__$1 = (function (){var statearr_38633 = state_38624;
(statearr_38633[(9)] = inst_38621);

return statearr_38633;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38624__$1,inst_38622);
} else {
if((state_val_38625 === (2))){
var state_38624__$1 = state_38624;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38624__$1,(4),ch);
} else {
if((state_val_38625 === (11))){
var inst_38604 = (state_38624[(8)]);
var inst_38613 = (state_38624[(2)]);
var inst_38601 = inst_38604;
var state_38624__$1 = (function (){var statearr_38634 = state_38624;
(statearr_38634[(7)] = inst_38601);

(statearr_38634[(10)] = inst_38613);

return statearr_38634;
})();
var statearr_38635_38659 = state_38624__$1;
(statearr_38635_38659[(2)] = null);

(statearr_38635_38659[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38625 === (9))){
var inst_38604 = (state_38624[(8)]);
var state_38624__$1 = state_38624;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38624__$1,(11),out,inst_38604);
} else {
if((state_val_38625 === (5))){
var inst_38604 = (state_38624[(8)]);
var inst_38601 = (state_38624[(7)]);
var inst_38608 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38604,inst_38601);
var state_38624__$1 = state_38624;
if(inst_38608){
var statearr_38637_38660 = state_38624__$1;
(statearr_38637_38660[(1)] = (8));

} else {
var statearr_38638_38661 = state_38624__$1;
(statearr_38638_38661[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38625 === (10))){
var inst_38616 = (state_38624[(2)]);
var state_38624__$1 = state_38624;
var statearr_38639_38662 = state_38624__$1;
(statearr_38639_38662[(2)] = inst_38616);

(statearr_38639_38662[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38625 === (8))){
var inst_38601 = (state_38624[(7)]);
var tmp38636 = inst_38601;
var inst_38601__$1 = tmp38636;
var state_38624__$1 = (function (){var statearr_38640 = state_38624;
(statearr_38640[(7)] = inst_38601__$1);

return statearr_38640;
})();
var statearr_38641_38663 = state_38624__$1;
(statearr_38641_38663[(2)] = null);

(statearr_38641_38663[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto___38653,out))
;
return ((function (switch__8372__auto__,c__8437__auto___38653,out){
return (function() {
var cljs$core$async$state_machine__8373__auto__ = null;
var cljs$core$async$state_machine__8373__auto____0 = (function (){
var statearr_38645 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38645[(0)] = cljs$core$async$state_machine__8373__auto__);

(statearr_38645[(1)] = (1));

return statearr_38645;
});
var cljs$core$async$state_machine__8373__auto____1 = (function (state_38624){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_38624);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e38646){if((e38646 instanceof Object)){
var ex__8376__auto__ = e38646;
var statearr_38647_38664 = state_38624;
(statearr_38647_38664[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38624);

return cljs.core.cst$kw$recur;
} else {
throw e38646;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__38665 = state_38624;
state_38624 = G__38665;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$state_machine__8373__auto__ = function(state_38624){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8373__auto____1.call(this,state_38624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8373__auto____0;
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8373__auto____1;
return cljs$core$async$state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___38653,out))
})();
var state__8439__auto__ = (function (){var statearr_38648 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_38648[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___38653);

return statearr_38648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___38653,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args38666 = [];
var len__5627__auto___38736 = arguments.length;
var i__5628__auto___38737 = (0);
while(true){
if((i__5628__auto___38737 < len__5627__auto___38736)){
args38666.push((arguments[i__5628__auto___38737]));

var G__38738 = (i__5628__auto___38737 + (1));
i__5628__auto___38737 = G__38738;
continue;
} else {
}
break;
}

var G__38668 = args38666.length;
switch (G__38668) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38666.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8437__auto___38740 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___38740,out){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___38740,out){
return (function (state_38706){
var state_val_38707 = (state_38706[(1)]);
if((state_val_38707 === (7))){
var inst_38702 = (state_38706[(2)]);
var state_38706__$1 = state_38706;
var statearr_38708_38741 = state_38706__$1;
(statearr_38708_38741[(2)] = inst_38702);

(statearr_38708_38741[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38707 === (1))){
var inst_38669 = (new Array(n));
var inst_38670 = inst_38669;
var inst_38671 = (0);
var state_38706__$1 = (function (){var statearr_38709 = state_38706;
(statearr_38709[(7)] = inst_38671);

(statearr_38709[(8)] = inst_38670);

return statearr_38709;
})();
var statearr_38710_38742 = state_38706__$1;
(statearr_38710_38742[(2)] = null);

(statearr_38710_38742[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38707 === (4))){
var inst_38674 = (state_38706[(9)]);
var inst_38674__$1 = (state_38706[(2)]);
var inst_38675 = (inst_38674__$1 == null);
var inst_38676 = cljs.core.not(inst_38675);
var state_38706__$1 = (function (){var statearr_38711 = state_38706;
(statearr_38711[(9)] = inst_38674__$1);

return statearr_38711;
})();
if(inst_38676){
var statearr_38712_38743 = state_38706__$1;
(statearr_38712_38743[(1)] = (5));

} else {
var statearr_38713_38744 = state_38706__$1;
(statearr_38713_38744[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38707 === (15))){
var inst_38696 = (state_38706[(2)]);
var state_38706__$1 = state_38706;
var statearr_38714_38745 = state_38706__$1;
(statearr_38714_38745[(2)] = inst_38696);

(statearr_38714_38745[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38707 === (13))){
var state_38706__$1 = state_38706;
var statearr_38715_38746 = state_38706__$1;
(statearr_38715_38746[(2)] = null);

(statearr_38715_38746[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38707 === (6))){
var inst_38671 = (state_38706[(7)]);
var inst_38692 = (inst_38671 > (0));
var state_38706__$1 = state_38706;
if(cljs.core.truth_(inst_38692)){
var statearr_38716_38747 = state_38706__$1;
(statearr_38716_38747[(1)] = (12));

} else {
var statearr_38717_38748 = state_38706__$1;
(statearr_38717_38748[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38707 === (3))){
var inst_38704 = (state_38706[(2)]);
var state_38706__$1 = state_38706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38706__$1,inst_38704);
} else {
if((state_val_38707 === (12))){
var inst_38670 = (state_38706[(8)]);
var inst_38694 = cljs.core.vec(inst_38670);
var state_38706__$1 = state_38706;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38706__$1,(15),out,inst_38694);
} else {
if((state_val_38707 === (2))){
var state_38706__$1 = state_38706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38706__$1,(4),ch);
} else {
if((state_val_38707 === (11))){
var inst_38686 = (state_38706[(2)]);
var inst_38687 = (new Array(n));
var inst_38670 = inst_38687;
var inst_38671 = (0);
var state_38706__$1 = (function (){var statearr_38718 = state_38706;
(statearr_38718[(7)] = inst_38671);

(statearr_38718[(8)] = inst_38670);

(statearr_38718[(10)] = inst_38686);

return statearr_38718;
})();
var statearr_38719_38749 = state_38706__$1;
(statearr_38719_38749[(2)] = null);

(statearr_38719_38749[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38707 === (9))){
var inst_38670 = (state_38706[(8)]);
var inst_38684 = cljs.core.vec(inst_38670);
var state_38706__$1 = state_38706;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38706__$1,(11),out,inst_38684);
} else {
if((state_val_38707 === (5))){
var inst_38674 = (state_38706[(9)]);
var inst_38671 = (state_38706[(7)]);
var inst_38670 = (state_38706[(8)]);
var inst_38679 = (state_38706[(11)]);
var inst_38678 = (inst_38670[inst_38671] = inst_38674);
var inst_38679__$1 = (inst_38671 + (1));
var inst_38680 = (inst_38679__$1 < n);
var state_38706__$1 = (function (){var statearr_38720 = state_38706;
(statearr_38720[(11)] = inst_38679__$1);

(statearr_38720[(12)] = inst_38678);

return statearr_38720;
})();
if(cljs.core.truth_(inst_38680)){
var statearr_38721_38750 = state_38706__$1;
(statearr_38721_38750[(1)] = (8));

} else {
var statearr_38722_38751 = state_38706__$1;
(statearr_38722_38751[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38707 === (14))){
var inst_38699 = (state_38706[(2)]);
var inst_38700 = cljs.core.async.close_BANG_(out);
var state_38706__$1 = (function (){var statearr_38724 = state_38706;
(statearr_38724[(13)] = inst_38699);

return statearr_38724;
})();
var statearr_38725_38752 = state_38706__$1;
(statearr_38725_38752[(2)] = inst_38700);

(statearr_38725_38752[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38707 === (10))){
var inst_38690 = (state_38706[(2)]);
var state_38706__$1 = state_38706;
var statearr_38726_38753 = state_38706__$1;
(statearr_38726_38753[(2)] = inst_38690);

(statearr_38726_38753[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38707 === (8))){
var inst_38670 = (state_38706[(8)]);
var inst_38679 = (state_38706[(11)]);
var tmp38723 = inst_38670;
var inst_38670__$1 = tmp38723;
var inst_38671 = inst_38679;
var state_38706__$1 = (function (){var statearr_38727 = state_38706;
(statearr_38727[(7)] = inst_38671);

(statearr_38727[(8)] = inst_38670__$1);

return statearr_38727;
})();
var statearr_38728_38754 = state_38706__$1;
(statearr_38728_38754[(2)] = null);

(statearr_38728_38754[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto___38740,out))
;
return ((function (switch__8372__auto__,c__8437__auto___38740,out){
return (function() {
var cljs$core$async$state_machine__8373__auto__ = null;
var cljs$core$async$state_machine__8373__auto____0 = (function (){
var statearr_38732 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38732[(0)] = cljs$core$async$state_machine__8373__auto__);

(statearr_38732[(1)] = (1));

return statearr_38732;
});
var cljs$core$async$state_machine__8373__auto____1 = (function (state_38706){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_38706);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e38733){if((e38733 instanceof Object)){
var ex__8376__auto__ = e38733;
var statearr_38734_38755 = state_38706;
(statearr_38734_38755[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38706);

return cljs.core.cst$kw$recur;
} else {
throw e38733;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__38756 = state_38706;
state_38706 = G__38756;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$state_machine__8373__auto__ = function(state_38706){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8373__auto____1.call(this,state_38706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8373__auto____0;
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8373__auto____1;
return cljs$core$async$state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___38740,out))
})();
var state__8439__auto__ = (function (){var statearr_38735 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_38735[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___38740);

return statearr_38735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___38740,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args38757 = [];
var len__5627__auto___38831 = arguments.length;
var i__5628__auto___38832 = (0);
while(true){
if((i__5628__auto___38832 < len__5627__auto___38831)){
args38757.push((arguments[i__5628__auto___38832]));

var G__38833 = (i__5628__auto___38832 + (1));
i__5628__auto___38832 = G__38833;
continue;
} else {
}
break;
}

var G__38759 = args38757.length;
switch (G__38759) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38757.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8437__auto___38835 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto___38835,out){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto___38835,out){
return (function (state_38801){
var state_val_38802 = (state_38801[(1)]);
if((state_val_38802 === (7))){
var inst_38797 = (state_38801[(2)]);
var state_38801__$1 = state_38801;
var statearr_38803_38836 = state_38801__$1;
(statearr_38803_38836[(2)] = inst_38797);

(statearr_38803_38836[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38802 === (1))){
var inst_38760 = [];
var inst_38761 = inst_38760;
var inst_38762 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_38801__$1 = (function (){var statearr_38804 = state_38801;
(statearr_38804[(7)] = inst_38761);

(statearr_38804[(8)] = inst_38762);

return statearr_38804;
})();
var statearr_38805_38837 = state_38801__$1;
(statearr_38805_38837[(2)] = null);

(statearr_38805_38837[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38802 === (4))){
var inst_38765 = (state_38801[(9)]);
var inst_38765__$1 = (state_38801[(2)]);
var inst_38766 = (inst_38765__$1 == null);
var inst_38767 = cljs.core.not(inst_38766);
var state_38801__$1 = (function (){var statearr_38806 = state_38801;
(statearr_38806[(9)] = inst_38765__$1);

return statearr_38806;
})();
if(inst_38767){
var statearr_38807_38838 = state_38801__$1;
(statearr_38807_38838[(1)] = (5));

} else {
var statearr_38808_38839 = state_38801__$1;
(statearr_38808_38839[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38802 === (15))){
var inst_38791 = (state_38801[(2)]);
var state_38801__$1 = state_38801;
var statearr_38809_38840 = state_38801__$1;
(statearr_38809_38840[(2)] = inst_38791);

(statearr_38809_38840[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38802 === (13))){
var state_38801__$1 = state_38801;
var statearr_38810_38841 = state_38801__$1;
(statearr_38810_38841[(2)] = null);

(statearr_38810_38841[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38802 === (6))){
var inst_38761 = (state_38801[(7)]);
var inst_38786 = inst_38761.length;
var inst_38787 = (inst_38786 > (0));
var state_38801__$1 = state_38801;
if(cljs.core.truth_(inst_38787)){
var statearr_38811_38842 = state_38801__$1;
(statearr_38811_38842[(1)] = (12));

} else {
var statearr_38812_38843 = state_38801__$1;
(statearr_38812_38843[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38802 === (3))){
var inst_38799 = (state_38801[(2)]);
var state_38801__$1 = state_38801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38801__$1,inst_38799);
} else {
if((state_val_38802 === (12))){
var inst_38761 = (state_38801[(7)]);
var inst_38789 = cljs.core.vec(inst_38761);
var state_38801__$1 = state_38801;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38801__$1,(15),out,inst_38789);
} else {
if((state_val_38802 === (2))){
var state_38801__$1 = state_38801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38801__$1,(4),ch);
} else {
if((state_val_38802 === (11))){
var inst_38769 = (state_38801[(10)]);
var inst_38765 = (state_38801[(9)]);
var inst_38779 = (state_38801[(2)]);
var inst_38780 = [];
var inst_38781 = inst_38780.push(inst_38765);
var inst_38761 = inst_38780;
var inst_38762 = inst_38769;
var state_38801__$1 = (function (){var statearr_38813 = state_38801;
(statearr_38813[(11)] = inst_38779);

(statearr_38813[(7)] = inst_38761);

(statearr_38813[(12)] = inst_38781);

(statearr_38813[(8)] = inst_38762);

return statearr_38813;
})();
var statearr_38814_38844 = state_38801__$1;
(statearr_38814_38844[(2)] = null);

(statearr_38814_38844[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38802 === (9))){
var inst_38761 = (state_38801[(7)]);
var inst_38777 = cljs.core.vec(inst_38761);
var state_38801__$1 = state_38801;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38801__$1,(11),out,inst_38777);
} else {
if((state_val_38802 === (5))){
var inst_38769 = (state_38801[(10)]);
var inst_38765 = (state_38801[(9)]);
var inst_38762 = (state_38801[(8)]);
var inst_38769__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38765) : f.call(null,inst_38765));
var inst_38770 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38769__$1,inst_38762);
var inst_38771 = cljs.core.keyword_identical_QMARK_(inst_38762,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_38772 = (inst_38770) || (inst_38771);
var state_38801__$1 = (function (){var statearr_38815 = state_38801;
(statearr_38815[(10)] = inst_38769__$1);

return statearr_38815;
})();
if(cljs.core.truth_(inst_38772)){
var statearr_38816_38845 = state_38801__$1;
(statearr_38816_38845[(1)] = (8));

} else {
var statearr_38817_38846 = state_38801__$1;
(statearr_38817_38846[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38802 === (14))){
var inst_38794 = (state_38801[(2)]);
var inst_38795 = cljs.core.async.close_BANG_(out);
var state_38801__$1 = (function (){var statearr_38819 = state_38801;
(statearr_38819[(13)] = inst_38794);

return statearr_38819;
})();
var statearr_38820_38847 = state_38801__$1;
(statearr_38820_38847[(2)] = inst_38795);

(statearr_38820_38847[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38802 === (10))){
var inst_38784 = (state_38801[(2)]);
var state_38801__$1 = state_38801;
var statearr_38821_38848 = state_38801__$1;
(statearr_38821_38848[(2)] = inst_38784);

(statearr_38821_38848[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38802 === (8))){
var inst_38769 = (state_38801[(10)]);
var inst_38761 = (state_38801[(7)]);
var inst_38765 = (state_38801[(9)]);
var inst_38774 = inst_38761.push(inst_38765);
var tmp38818 = inst_38761;
var inst_38761__$1 = tmp38818;
var inst_38762 = inst_38769;
var state_38801__$1 = (function (){var statearr_38822 = state_38801;
(statearr_38822[(14)] = inst_38774);

(statearr_38822[(7)] = inst_38761__$1);

(statearr_38822[(8)] = inst_38762);

return statearr_38822;
})();
var statearr_38823_38849 = state_38801__$1;
(statearr_38823_38849[(2)] = null);

(statearr_38823_38849[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto___38835,out))
;
return ((function (switch__8372__auto__,c__8437__auto___38835,out){
return (function() {
var cljs$core$async$state_machine__8373__auto__ = null;
var cljs$core$async$state_machine__8373__auto____0 = (function (){
var statearr_38827 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38827[(0)] = cljs$core$async$state_machine__8373__auto__);

(statearr_38827[(1)] = (1));

return statearr_38827;
});
var cljs$core$async$state_machine__8373__auto____1 = (function (state_38801){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_38801);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e38828){if((e38828 instanceof Object)){
var ex__8376__auto__ = e38828;
var statearr_38829_38850 = state_38801;
(statearr_38829_38850[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38801);

return cljs.core.cst$kw$recur;
} else {
throw e38828;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__38851 = state_38801;
state_38801 = G__38851;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
cljs$core$async$state_machine__8373__auto__ = function(state_38801){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8373__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8373__auto____1.call(this,state_38801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8373__auto____0;
cljs$core$async$state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8373__auto____1;
return cljs$core$async$state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto___38835,out))
})();
var state__8439__auto__ = (function (){var statearr_38830 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_38830[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto___38835);

return statearr_38830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto___38835,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
