// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('hatti.constants');
goog.require('hatti.ona.forms');
goog.require('hatti.utils');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"radius": (6), "fillColor": "#f30", "reset": {"fillColor": "#f30"}, "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9},cljs.core.cst$kw$hover,{"fillColor": "#631400"},cljs.core.cst$kw$clicked,{"fillColor": "#ad2300"}], null),cljs.core.cst$kw$shape,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8},cljs.core.cst$kw$hover,{"fillColor": "#631400", "color": "#222"},cljs.core.cst$kw$clicked,{"fillColor": "#ad2300", "color": "#222"}], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"color": "#f30", "opacity": (1), "weight": (6), "reset": {"color": "#f30"}},cljs.core.cst$kw$hover,{"color": "#631400"},cljs.core.cst$kw$clicked,{"color": "#ad2300"}], null)], null);
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(marker_or_keyword,style_type){
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype(marker_or_keyword));
var G__28995 = (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.ona_styles) : kw.call(null,hatti.map.utils.ona_styles));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__28995) : style_type.call(null,G__28995));
});
hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(s);
var tc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(t);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.select_keys(sc,cljs.core.keys(tc)),cljs.core.select_keys(tc,cljs.core.keys(sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args28996 = [];
var len__5627__auto___29000 = arguments.length;
var i__5628__auto___29001 = (0);
while(true){
if((i__5628__auto___29001 < len__5627__auto___29000)){
args28996.push((arguments[i__5628__auto___29001]));

var G__29002 = (i__5628__auto___29001 + (1));
i__5628__auto___29001 = G__29002;
continue;
} else {
}
break;
}

var G__28998 = args28996.length;
switch (G__28998) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28996.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
var G__28999 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker));
return (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(G__28999) : kw.call(null,G__28999));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;
/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker),hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = (marker__GT_style.cljs$core$IFn$_invoke$arity$1 ? marker__GT_style.cljs$core$IFn$_invoke$arity$1(marker) : marker__GT_style.call(null,marker));
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return marker.setStyle(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reset,style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(style,cljs.core.cst$kw$reset,style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4423__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4423__auto__)){
var rstyle = temp__4423__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__4569__auto__ = hatti.map.utils.is_clicked_QMARK_(marker);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var G__29005 = hatti.map.utils.get_id(marker);
return (id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__29005) : id_selected_QMARK_.call(null,G__29005));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style(marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$hover));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__5634__auto__ = [];
var len__5627__auto___29015 = arguments.length;
var i__5628__auto___29016 = (0);
while(true){
if((i__5628__auto___29016 < len__5627__auto___29015)){
args__5634__auto__.push((arguments[i__5628__auto___29016]));

var G__29017 = (i__5628__auto___29016 + (1));
i__5628__auto___29016 = G__29017;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__29008){
var map__29009 = p__29008;
var map__29009__$1 = ((((!((map__29009 == null)))?((((map__29009.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29009.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29009):map__29009);
var preserve_clicked_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29009__$1,cljs.core.cst$kw$preserve_DASH_clicked_QMARK_,true);
var seq__29011 = cljs.core.seq(markers);
var chunk__29012 = null;
var count__29013 = (0);
var i__29014 = (0);
while(true){
if((i__29014 < count__29013)){
var marker = chunk__29012.cljs$core$IIndexed$_nth$arity$2(null,i__29014);
if(cljs.core.not((function (){var and__4557__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__4557__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__29018 = seq__29011;
var G__29019 = chunk__29012;
var G__29020 = count__29013;
var G__29021 = (i__29014 + (1));
seq__29011 = G__29018;
chunk__29012 = G__29019;
count__29013 = G__29020;
i__29014 = G__29021;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__29011);
if(temp__4425__auto__){
var seq__29011__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__29011__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__29011__$1);
var G__29022 = cljs.core.chunk_rest(seq__29011__$1);
var G__29023 = c__5372__auto__;
var G__29024 = cljs.core.count(c__5372__auto__);
var G__29025 = (0);
seq__29011 = G__29022;
chunk__29012 = G__29023;
count__29013 = G__29024;
i__29014 = G__29025;
continue;
} else {
var marker = cljs.core.first(seq__29011__$1);
if(cljs.core.not((function (){var and__4557__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__4557__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__29026 = cljs.core.next(seq__29011__$1);
var G__29027 = null;
var G__29028 = (0);
var G__29029 = (0);
seq__29011 = G__29026;
chunk__29012 = G__29027;
count__29013 = G__29028;
i__29014 = G__29029;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq29006){
var G__29007 = cljs.core.first(seq29006);
var seq29006__$1 = cljs.core.next(seq29006);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__29007,seq29006__$1);
});
hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string(maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"Feature",cljs.core.cst$kw$properties,cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._rank),(index + (1)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id),record_id], true, false),cljs.core.cst$kw$geometry,geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__5482__auto__ = (function (){var G__29030 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29030) : cljs.core.atom.call(null,G__29030));
})();
var prefer_table__5483__auto__ = (function (){var G__29031 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29031) : cljs.core.atom.call(null,G__29031));
})();
var method_cache__5484__auto__ = (function (){var G__29032 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29032) : cljs.core.atom.call(null,G__29032));
})();
var cached_hierarchy__5485__auto__ = (function (){var G__29033 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29033) : cljs.core.atom.call(null,G__29033));
})();
var hierarchy__5486__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("hatti.map.utils","get-as-geom"),((function (method_table__5482__auto__,prefer_table__5483__auto__,method_cache__5484__auto__,cached_hierarchy__5485__auto__,hierarchy__5486__auto__){
return (function() { 
var G__29036__delegate = function (record,field,p__29034){
var vec__29035 = p__29034;
var repeat_child_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29035,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return cljs.core.cst$kw$repeat;
} else {
return cljs.core.cst$kw$default;

}
};
var G__29036 = function (record,field,var_args){
var p__29034 = null;
if (arguments.length > 2) {
var G__29037__i = 0, G__29037__a = new Array(arguments.length -  2);
while (G__29037__i < G__29037__a.length) {G__29037__a[G__29037__i] = arguments[G__29037__i + 2]; ++G__29037__i;}
  p__29034 = new cljs.core.IndexedSeq(G__29037__a,0);
} 
return G__29036__delegate.call(this,record,field,p__29034);};
G__29036.cljs$lang$maxFixedArity = 2;
G__29036.cljs$lang$applyTo = (function (arglist__29038){
var record = cljs.core.first(arglist__29038);
arglist__29038 = cljs.core.next(arglist__29038);
var field = cljs.core.first(arglist__29038);
var p__29034 = cljs.core.rest(arglist__29038);
return G__29036__delegate(record,field,p__29034);
});
G__29036.cljs$core$IFn$_invoke$arity$variadic = G__29036__delegate;
return G__29036;
})()
;})(method_table__5482__auto__,prefer_table__5483__auto__,method_cache__5484__auto__,cached_hierarchy__5485__auto__,hierarchy__5486__auto__))
,cljs.core.cst$kw$default,hierarchy__5486__auto__,method_table__5482__auto__,prefer_table__5483__auto__,method_cache__5484__auto__,cached_hierarchy__5485__auto__));
})();
}
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$repeat,(function (record,p__29039){
var map__29040 = p__29039;
var map__29040__$1 = ((((!((map__29040 == null)))?((((map__29040.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29040.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29040):map__29040);
var field = map__29040__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29040__$1,cljs.core.cst$kw$children);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29040__$1,cljs.core.cst$kw$full_DASH_name);
var iter__5341__auto__ = ((function (map__29040,map__29040__$1,field,children,full_name){
return (function hatti$map$utils$iter__29042(s__29043){
return (new cljs.core.LazySeq(null,((function (map__29040,map__29040__$1,field,children,full_name){
return (function (){
var s__29043__$1 = s__29043;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__29043__$1);
if(temp__4425__auto__){
var s__29043__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29043__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29043__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29045 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29044 = (0);
while(true){
if((i__29044 < size__5340__auto__)){
var child_record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29044);
cljs.core.chunk_append(b__29045,(function (){var iter__5341__auto__ = ((function (i__29044,child_record,c__5339__auto__,size__5340__auto__,b__29045,s__29043__$2,temp__4425__auto__,map__29040,map__29040__$1,field,children,full_name){
return (function hatti$map$utils$iter__29042_$_iter__29060(s__29061){
return (new cljs.core.LazySeq(null,((function (i__29044,child_record,c__5339__auto__,size__5340__auto__,b__29045,s__29043__$2,temp__4425__auto__,map__29040,map__29040__$1,field,children,full_name){
return (function (){
var s__29061__$1 = s__29061;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__29061__$1);
if(temp__4425__auto____$1){
var s__29061__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__29061__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first(s__29061__$2);
var size__5340__auto____$1 = cljs.core.count(c__5339__auto____$1);
var b__29063 = cljs.core.chunk_buffer(size__5340__auto____$1);
if((function (){var i__29062 = (0);
while(true){
if((i__29062 < size__5340__auto____$1)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto____$1,i__29062);
cljs.core.chunk_append(b__29063,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__29072 = (i__29062 + (1));
i__29062 = G__29072;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29063),hatti$map$utils$iter__29042_$_iter__29060(cljs.core.chunk_rest(s__29061__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29063),null);
}
} else {
var child = cljs.core.first(s__29061__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__29042_$_iter__29060(cljs.core.rest(s__29061__$2)));
}
} else {
return null;
}
break;
}
});})(i__29044,child_record,c__5339__auto__,size__5340__auto__,b__29045,s__29043__$2,temp__4425__auto__,map__29040,map__29040__$1,field,children,full_name))
,null,null));
});})(i__29044,child_record,c__5339__auto__,size__5340__auto__,b__29045,s__29043__$2,temp__4425__auto__,map__29040,map__29040__$1,field,children,full_name))
;
return iter__5341__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})());

var G__29073 = (i__29044 + (1));
i__29044 = G__29073;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29045),hatti$map$utils$iter__29042(cljs.core.chunk_rest(s__29043__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29045),null);
}
} else {
var child_record = cljs.core.first(s__29043__$2);
return cljs.core.cons((function (){var iter__5341__auto__ = ((function (child_record,s__29043__$2,temp__4425__auto__,map__29040,map__29040__$1,field,children,full_name){
return (function hatti$map$utils$iter__29042_$_iter__29066(s__29067){
return (new cljs.core.LazySeq(null,((function (child_record,s__29043__$2,temp__4425__auto__,map__29040,map__29040__$1,field,children,full_name){
return (function (){
var s__29067__$1 = s__29067;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__29067__$1);
if(temp__4425__auto____$1){
var s__29067__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__29067__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29067__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29069 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29068 = (0);
while(true){
if((i__29068 < size__5340__auto__)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29068);
cljs.core.chunk_append(b__29069,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__29074 = (i__29068 + (1));
i__29068 = G__29074;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29069),hatti$map$utils$iter__29042_$_iter__29066(cljs.core.chunk_rest(s__29067__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29069),null);
}
} else {
var child = cljs.core.first(s__29067__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__29042_$_iter__29066(cljs.core.rest(s__29067__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__29043__$2,temp__4425__auto__,map__29040,map__29040__$1,field,children,full_name))
,null,null));
});})(child_record,s__29043__$2,temp__4425__auto__,map__29040,map__29040__$1,field,children,full_name))
;
return iter__5341__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__29042(cljs.core.rest(s__29043__$2)));
}
} else {
return null;
}
break;
}
});})(map__29040,map__29040__$1,field,children,full_name))
,null,null));
});})(map__29040,map__29040__$1,field,children,full_name))
;
return iter__5341__auto__(cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,full_name));
}));
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq(s)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,"n/a"))){
var iter__5341__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__29077(s__29078){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__29078__$1 = s__29078;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__29078__$1);
if(temp__4425__auto__){
var s__29078__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29078__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29078__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29080 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29079 = (0);
while(true){
if((i__29079 < size__5340__auto__)){
var coord_string = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29079);
cljs.core.chunk_append(b__29080,(function (){var vec__29085 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29085,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29085,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29085,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29085,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})());

var G__29088 = (i__29079 + (1));
i__29079 = G__29088;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29080),hatti$map$utils$iter__29077(cljs.core.chunk_rest(s__29078__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29080),null);
}
} else {
var coord_string = cljs.core.first(s__29078__$2);
return cljs.core.cons((function (){var vec__29086 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29086,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29086,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29086,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29086,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})(),hatti$map$utils$iter__29077(cljs.core.rest(s__29078__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__5341__auto__(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__29087 = geotype;
switch (G__29087) {
case "Point":
return ((function (G__29087,geotype,parse){
return (function (p1__29075_SHARP_){
return cljs.core.first(parse(p1__29075_SHARP_));
});
;})(G__29087,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__29087,geotype,parse){
return (function (p1__29076_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse(p1__29076_SHARP_)],null));
});
;})(G__29087,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield));
var coords = (coordfn.cljs$core$IFn$_invoke$arity$1 ? coordfn.cljs$core$IFn$_invoke$arity$1(value) : coordfn.call(null,value));
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(geofield))){
return cljs.core.cst$kw$geom.cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__4569__auto__ = (coords == null);
if(or__4569__auto__){
return or__4569__auto__;
} else {
return cljs.core.some(cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,geotype,cljs.core.cst$kw$coordinates,coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args29091 = [];
var len__5627__auto___29104 = arguments.length;
var i__5628__auto___29105 = (0);
while(true){
if((i__5628__auto___29105 < len__5627__auto___29104)){
args29091.push((arguments[i__5628__auto___29105]));

var G__29106 = (i__5628__auto___29105 + (1));
i__5628__auto___29105 = G__29106;
continue;
} else {
}
break;
}

var G__29093 = args29091.length;
switch (G__29093) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29091.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3(dataset,form,hatti.ona.forms.default_geofield(form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__5341__auto__ = (function hatti$map$utils$iter__29094(s__29095){
return (new cljs.core.LazySeq(null,(function (){
var s__29095__$1 = s__29095;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__29095__$1);
if(temp__4425__auto__){
var s__29095__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29095__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29095__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29097 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29096 = (0);
while(true){
if((i__29096 < size__5340__auto__)){
var vec__29102 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29096);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29102,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29102,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append(b__29097,((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__29096,s__29095__$1,geom_or_geoms,vec__29102,idx,record,c__5339__auto__,size__5340__auto__,b__29097,s__29095__$2,temp__4425__auto__){
return (function (p1__29090_SHARP_){
return hatti.map.utils.make_feature(p1__29090_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(i__29096,s__29095__$1,geom_or_geoms,vec__29102,idx,record,c__5339__auto__,size__5340__auto__,b__29097,s__29095__$2,temp__4425__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))));

var G__29108 = (i__29096 + (1));
i__29096 = G__29108;
continue;
} else {
var G__29109 = (i__29096 + (1));
i__29096 = G__29109;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29097),hatti$map$utils$iter__29094(cljs.core.chunk_rest(s__29095__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29097),null);
}
} else {
var vec__29103 = cljs.core.first(s__29095__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29103,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29103,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons(((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (s__29095__$1,geom_or_geoms,vec__29103,idx,record,s__29095__$2,temp__4425__auto__){
return (function (p1__29090_SHARP_){
return hatti.map.utils.make_feature(p1__29090_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(s__29095__$1,geom_or_geoms,vec__29103,idx,record,s__29095__$2,temp__4425__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))),hatti$map$utils$iter__29094(cljs.core.rest(s__29095__$2)));
} else {
var G__29110 = cljs.core.rest(s__29095__$2);
s__29095__$1 = G__29110;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(hatti.utils.indexed(dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,cljs.core.flatten(features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;
/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__29112){
var map__29115 = p__29112;
var map__29115__$1 = ((((!((map__29115 == null)))?((((map__29115.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29115.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29115):map__29115);
var mapbox_tiles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29115__$1,cljs.core.cst$kw$mapbox_DASH_tiles);
var include_google_maps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29115__$1,cljs.core.cst$kw$include_DASH_google_DASH_maps_QMARK_);
var layers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__29115,map__29115__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__29111_SHARP_){
return L.tileLayer(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(p1__29111_SHARP_));
});})(map__29115,map__29115__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name,mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js(nlayers));
var m = L.map(id,{"layers": cljs.core.first(layers), "zoomControl": false});
var z = L.control.zoom.call(null,{"position": "bottomleft"});
z.addTo(m);

L.control.layers.call(null,named_layers,null,{"position": "bottomleft"}).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank,((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style(marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style(marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not(layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__5634__auto__ = [];
var len__5627__auto___29129 = arguments.length;
var i__5628__auto___29130 = (0);
while(true){
if((i__5628__auto___29130 < len__5627__auto___29129)){
args__5634__auto__.push((arguments[i__5628__auto___29130]));

var G__29131 = (i__5628__auto___29130 + (1));
i__5628__auto___29130 = G__29131;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__29126){
var map__29127 = p__29126;
var map__29127__$1 = ((((!((map__29127 == null)))?((((map__29127.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29127.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29127):map__29127);
var rezoom_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29127__$1,cljs.core.cst$kw$rezoom_QMARK_);
var on_events = ((function (map__29127,map__29127__$1,rezoom_QMARK_){
return (function (p1__29117_SHARP_,p2__29118_SHARP_){
return hatti.map.utils.register_mouse_events(p1__29117_SHARP_,p2__29118_SHARP_,event_chan);
});})(map__29127,map__29127__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__29127,map__29127__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style(geometry_type,cljs.core.cst$kw$normal);
});})(on_events,geometry_type,map__29127,map__29127__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__29127,map__29127__$1,rezoom_QMARK_){
return (function (p1__29120_SHARP_,p2__29119_SHARP_){
return L.circleMarker(p2__29119_SHARP_);
});})(on_events,geometry_type,stylefn,map__29127,map__29127__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js(geojson),{"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn});
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__29127,map__29127__$1,rezoom_QMARK_){
return (function (p1__29121_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__29121_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$properties,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__29127,map__29127__$1,rezoom_QMARK_))
,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$feature_DASH_layer,feature_layer,cljs.core.cst$kw$markers,markers,cljs.core.cst$kw$id_DASH__GT_marker,cljs.core.zipmap(ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq29122){
var G__29123 = cljs.core.first(seq29122);
var seq29122__$1 = cljs.core.next(seq29122);
var G__29124 = cljs.core.first(seq29122__$1);
var seq29122__$2 = cljs.core.next(seq29122__$1);
var G__29125 = cljs.core.first(seq29122__$2);
var seq29122__$3 = cljs.core.next(seq29122__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__29123,G__29124,G__29125,seq29122__$3);
});
