// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"id",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___28835 = arguments.length;
var i__5628__auto___28836 = (0);
while(true){
if((i__5628__auto___28836 < len__5627__auto___28835)){
args__5634__auto__.push((arguments[i__5628__auto___28836]));

var G__28837 = (i__5628__auto___28836 + (1));
i__5628__auto___28836 = G__28837;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__28832){
var map__28833 = p__28832;
var map__28833__$1 = ((((!((map__28833 == null)))?((((map__28833.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28833.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28833):map__28833);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28833__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq28830){
var G__28831 = cljs.core.first(seq28830);
var seq28830__$1 = cljs.core.next(seq28830);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__28831,seq28830__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__28838_SHARP_){
if(typeof p1__28838_SHARP_ === 'string'){
return clojure.string.lower_case(p1__28838_SHARP_);
} else {
return p1__28838_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__28842){
var vec__28843 = p__28842;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28843,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28843,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__28839_SHARP_){
return cljs.core.re_find(hatti.utils.safe_regex(query),[cljs.core.str(p1__28839_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(field,clj_value,language,true);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args28844 = [];
var len__5627__auto___28868 = arguments.length;
var i__5628__auto___28869 = (0);
while(true){
if((i__5628__auto___28869 < len__5627__auto___28868)){
args28844.push((arguments[i__5628__auto___28869]));

var G__28870 = (i__5628__auto___28869 + (1));
i__5628__auto___28869 = G__28870;
continue;
} else {
}
break;
}

var G__28850 = args28844.length;
switch (G__28850) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args28844.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2(form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns(form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__28851){
var map__28852 = p__28851;
var map__28852__$1 = ((((!((map__28852 == null)))?((((map__28852.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28852.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28852):map__28852);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28852__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.clj__GT_js((function (){var iter__5341__auto__ = ((function (map__28852,map__28852__$1,is_filtered_dataview_QMARK_){
return (function hatti$views$table$iter__28854(s__28855){
return (new cljs.core.LazySeq(null,((function (map__28852,map__28852__$1,is_filtered_dataview_QMARK_){
return (function (){
var s__28855__$1 = s__28855;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__28855__$1);
if(temp__4425__auto__){
var s__28855__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28855__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__28855__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__28857 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__28856 = (0);
while(true){
if((i__28856 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__28856);
cljs.core.chunk_append(b__28857,(function (){var map__28864 = field;
var map__28864__$1 = ((((!((map__28864 == null)))?((((map__28864.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28864.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28864):map__28864);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28864__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28864__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28864__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})());

var G__28872 = (i__28856 + (1));
i__28856 = G__28872;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28857),hatti$views$table$iter__28854(cljs.core.chunk_rest(s__28855__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28857),null);
}
} else {
var field = cljs.core.first(s__28855__$2);
return cljs.core.cons((function (){var map__28866 = field;
var map__28866__$1 = ((((!((map__28866 == null)))?((((map__28866.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28866.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28866):map__28866);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28866__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28866__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28866__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})(),hatti$views$table$iter__28854(cljs.core.rest(s__28855__$2)));
}
} else {
return null;
}
break;
}
});})(map__28852,map__28852__$1,is_filtered_dataview_QMARK_))
,null,null));
});})(map__28852,map__28852__$1,is_filtered_dataview_QMARK_))
;
return iter__5341__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq28845){
var G__28846 = cljs.core.first(seq28845);
var seq28845__$1 = cljs.core.next(seq28845);
var G__28847 = cljs.core.first(seq28845__$1);
var seq28845__$2 = cljs.core.next(seq28845__$1);
var G__28848 = cljs.core.first(seq28845__$2);
var seq28845__$3 = cljs.core.next(seq28845__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__28846,G__28847,G__28848,seq28845__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__28874 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__28874);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false};
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__28885(s__28886){
return (new cljs.core.LazySeq(null,(function (){
var s__28886__$1 = s__28886;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__28886__$1);
if(temp__4425__auto__){
var s__28886__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28886__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__28886__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__28888 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__28887 = (0);
while(true){
if((i__28887 < size__5340__auto__)){
var vec__28893 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__28887);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28893,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28893,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__28888,event.subscribe(handler_function));

var G__28895 = (i__28887 + (1));
i__28887 = G__28895;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28888),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__28885(cljs.core.chunk_rest(s__28886__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28888),null);
}
} else {
var vec__28894 = cljs.core.first(s__28886__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28894,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28894,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__28885(cljs.core.rest(s__28886__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__28906(s__28907){
return (new cljs.core.LazySeq(null,(function (){
var s__28907__$1 = s__28907;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__28907__$1);
if(temp__4425__auto__){
var s__28907__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28907__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__28907__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__28909 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__28908 = (0);
while(true){
if((i__28908 < size__5340__auto__)){
var vec__28914 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__28908);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28914,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28914,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__28909,event.subscribe(handler_function));

var G__28916 = (i__28908 + (1));
i__28908 = G__28916;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28909),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__28906(cljs.core.chunk_rest(s__28907__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28909),null);
}
} else {
var vec__28915 = cljs.core.first(s__28907__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28915,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28915,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__28906(cljs.core.rest(s__28907__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,p__28917){
var map__28926 = p__28917;
var map__28926__$1 = ((((!((map__28926 == null)))?((((map__28926.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28926.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28926):map__28926);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28926__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28926__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,true,current_language,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__28928 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__28928__$1 = ((((!((map__28928 == null)))?((((map__28928.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28928.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28928):map__28928);
var map__28929 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28928__$1,cljs.core.cst$kw$table_DASH_page);
var map__28929__$1 = ((((!((map__28929 == null)))?((((map__28929.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28929.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28929):map__28929);
var map__28930 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28929__$1,cljs.core.cst$kw$paging);
var map__28930__$1 = ((((!((map__28930 == null)))?((((map__28930.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28930.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28930):map__28930);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28930__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28930__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__28928,map__28928__$1,map__28929,map__28929__$1,map__28930,map__28930__$1,num_displayed_records,total_page_count,map__28926,map__28926__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__28928,map__28928__$1,map__28929,map__28929__$1,map__28930,map__28930__$1,num_displayed_records,total_page_count,map__28926,map__28926__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__28928,map__28928__$1,map__28929,map__28929__$1,map__28930,map__28930__$1,num_displayed_records,total_page_count,map__28926,map__28926__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__28928,map__28928__$1,map__28929,map__28929__$1,map__28930,map__28930__$1,num_displayed_records,total_page_count,map__28926,map__28926__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__28928,map__28928__$1,map__28929,map__28929__$1,map__28930,map__28930__$1,num_displayed_records,total_page_count,map__28926,map__28926__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__28928,map__28928__$1,map__28929,map__28929__$1,map__28930,map__28930__$1,num_displayed_records,total_page_count,map__28926,map__28926__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__7694__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7694__auto__,event_chan){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__,event_chan){
return (function (state_29195){
var state_val_29196 = (state_29195[(1)]);
if((state_val_29196 === (7))){
var inst_29104 = (state_29195[(7)]);
var inst_29104__$1 = (state_29195[(2)]);
var inst_29106 = (inst_29104__$1 == null);
var inst_29107 = cljs.core.not(inst_29106);
var state_29195__$1 = (function (){var statearr_29197 = state_29195;
(statearr_29197[(7)] = inst_29104__$1);

return statearr_29197;
})();
if(inst_29107){
var statearr_29198_29265 = state_29195__$1;
(statearr_29198_29265[(1)] = (8));

} else {
var statearr_29199_29266 = state_29195__$1;
(statearr_29199_29266[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (20))){
var inst_29134 = (state_29195[(8)]);
var inst_29126 = (state_29195[(9)]);
var inst_29143 = (inst_29134.cljs$core$IFn$_invoke$arity$1 ? inst_29134.cljs$core$IFn$_invoke$arity$1(inst_29126) : inst_29134.call(null,inst_29126));
var state_29195__$1 = state_29195;
var statearr_29200_29267 = state_29195__$1;
(statearr_29200_29267[(2)] = inst_29143);

(statearr_29200_29267[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (27))){
var state_29195__$1 = state_29195;
var statearr_29201_29268 = state_29195__$1;
(statearr_29201_29268[(2)] = null);

(statearr_29201_29268[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (1))){
var state_29195__$1 = state_29195;
var statearr_29202_29269 = state_29195__$1;
(statearr_29202_29269[(2)] = null);

(statearr_29202_29269[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (24))){
var state_29195__$1 = state_29195;
var statearr_29203_29270 = state_29195__$1;
(statearr_29203_29270[(2)] = null);

(statearr_29203_29270[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (4))){
var state_29195__$1 = state_29195;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29195__$1,(7),event_chan);
} else {
if((state_val_29196 === (15))){
var inst_29104 = (state_29195[(7)]);
var state_29195__$1 = state_29195;
var statearr_29204_29271 = state_29195__$1;
(statearr_29204_29271[(2)] = inst_29104);

(statearr_29204_29271[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (21))){
var state_29195__$1 = state_29195;
var statearr_29205_29272 = state_29195__$1;
(statearr_29205_29272[(2)] = null);

(statearr_29205_29272[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (31))){
var inst_29130 = (state_29195[(10)]);
var inst_29168 = (state_29195[(2)]);
var inst_29169 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29130,cljs.core.cst$kw$table);
var state_29195__$1 = (function (){var statearr_29206 = state_29195;
(statearr_29206[(11)] = inst_29168);

return statearr_29206;
})();
if(inst_29169){
var statearr_29207_29273 = state_29195__$1;
(statearr_29207_29273[(1)] = (32));

} else {
var statearr_29208_29274 = state_29195__$1;
(statearr_29208_29274[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (32))){
var inst_29127 = (state_29195[(12)]);
var inst_29130 = (state_29195[(10)]);
var inst_29128 = (state_29195[(13)]);
var inst_29134 = (state_29195[(8)]);
var inst_29126 = (state_29195[(9)]);
var inst_29125 = (state_29195[(14)]);
var inst_29135 = (state_29195[(15)]);
var inst_29129 = (state_29195[(16)]);
var inst_29104 = (state_29195[(7)]);
var inst_29124 = (state_29195[(17)]);
var inst_29182 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_29183 = (function (){var new_columns = inst_29129;
var submission_clicked = inst_29126;
var submission_unclicked = inst_29127;
var map__29102 = inst_29124;
var get_submission_data = inst_29135;
var re_render = inst_29130;
var update_data_BANG_ = inst_29134;
var c__7694__auto____$1 = inst_29182;
var submission_to_rank = inst_29125;
var e = inst_29104;
var filter_by = inst_29128;
return ((function (new_columns,submission_clicked,submission_unclicked,map__29102,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_29127,inst_29130,inst_29128,inst_29134,inst_29126,inst_29125,inst_29135,inst_29129,inst_29104,inst_29124,inst_29182,state_val_29196,c__7694__auto__,event_chan){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,map__29102,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_29127,inst_29130,inst_29128,inst_29134,inst_29126,inst_29125,inst_29135,inst_29129,inst_29104,inst_29124,inst_29182,state_val_29196,c__7694__auto__,event_chan){
return (function (state_29180){
var state_val_29181 = (state_29180[(1)]);
if((state_val_29181 === (1))){
var inst_29171 = cljs.core.async.timeout((20));
var state_29180__$1 = state_29180;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29180__$1,(2),inst_29171);
} else {
if((state_val_29181 === (2))){
var inst_29173 = (state_29180[(2)]);
var inst_29174 = grid.resizeCanvas();
var inst_29175 = grid.invalidateAllRows();
var inst_29176 = hatti.views.table.resizeColumns(grid);
var inst_29177 = grid.render();
var inst_29178 = hatti.views.table.init_sg_pager(grid,dataview);
var state_29180__$1 = (function (){var statearr_29209 = state_29180;
(statearr_29209[(7)] = inst_29177);

(statearr_29209[(8)] = inst_29173);

(statearr_29209[(9)] = inst_29176);

(statearr_29209[(10)] = inst_29175);

(statearr_29209[(11)] = inst_29174);

return statearr_29209;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29180__$1,inst_29178);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,map__29102,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_29127,inst_29130,inst_29128,inst_29134,inst_29126,inst_29125,inst_29135,inst_29129,inst_29104,inst_29124,inst_29182,state_val_29196,c__7694__auto__,event_chan))
;
return ((function (switch__7673__auto__,new_columns,submission_clicked,submission_unclicked,map__29102,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_29127,inst_29130,inst_29128,inst_29134,inst_29126,inst_29125,inst_29135,inst_29129,inst_29104,inst_29124,inst_29182,state_val_29196,c__7694__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____0 = (function (){
var statearr_29213 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29213[(0)] = hatti$views$table$handle_table_events_$_state_machine__7674__auto__);

(statearr_29213[(1)] = (1));

return statearr_29213;
});
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____1 = (function (state_29180){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__(state_29180);
if(cljs.core.keyword_identical_QMARK_(result__7676__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e29214){if((e29214 instanceof Object)){
var ex__7677__auto__ = e29214;
var statearr_29215_29275 = state_29180;
(statearr_29215_29275[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29180);

return cljs.core.cst$kw$recur;
} else {
throw e29214;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7675__auto__,cljs.core.cst$kw$recur)){
var G__29276 = state_29180;
state_29180 = G__29276;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = function(state_29180){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____1.call(this,state_29180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____0;
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,new_columns,submission_clicked,submission_unclicked,map__29102,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_29127,inst_29130,inst_29128,inst_29134,inst_29126,inst_29125,inst_29135,inst_29129,inst_29104,inst_29124,inst_29182,state_val_29196,c__7694__auto__,event_chan))
})();
var state__7696__auto__ = (function (){var statearr_29216 = (f__7695__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7695__auto__.cljs$core$IFn$_invoke$arity$0() : f__7695__auto__.call(null));
(statearr_29216[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto____$1);

return statearr_29216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7696__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,map__29102,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,filter_by,inst_29127,inst_29130,inst_29128,inst_29134,inst_29126,inst_29125,inst_29135,inst_29129,inst_29104,inst_29124,inst_29182,state_val_29196,c__7694__auto__,event_chan))
})();
var inst_29184 = cljs.core.async.impl.dispatch.run(inst_29183);
var state_29195__$1 = (function (){var statearr_29217 = state_29195;
(statearr_29217[(18)] = inst_29184);

return statearr_29217;
})();
var statearr_29218_29277 = state_29195__$1;
(statearr_29218_29277[(2)] = inst_29182);

(statearr_29218_29277[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (33))){
var state_29195__$1 = state_29195;
var statearr_29219_29278 = state_29195__$1;
(statearr_29219_29278[(2)] = null);

(statearr_29219_29278[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (13))){
var inst_29116 = (state_29195[(2)]);
var state_29195__$1 = state_29195;
var statearr_29220_29279 = state_29195__$1;
(statearr_29220_29279[(2)] = inst_29116);

(statearr_29220_29279[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (22))){
var inst_29127 = (state_29195[(12)]);
var inst_29146 = (state_29195[(2)]);
var state_29195__$1 = (function (){var statearr_29221 = state_29195;
(statearr_29221[(19)] = inst_29146);

return statearr_29221;
})();
if(cljs.core.truth_(inst_29127)){
var statearr_29222_29280 = state_29195__$1;
(statearr_29222_29280[(1)] = (23));

} else {
var statearr_29223_29281 = state_29195__$1;
(statearr_29223_29281[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (29))){
var inst_29128 = (state_29195[(13)]);
var inst_29160 = [cljs.core.cst$kw$query];
var inst_29161 = [inst_29128];
var inst_29162 = cljs.core.PersistentHashMap.fromArrays(inst_29160,inst_29161);
var inst_29163 = cljs.core.clj__GT_js(inst_29162);
var inst_29164 = dataview.setFilterArgs(inst_29163);
var inst_29165 = dataview.refresh();
var state_29195__$1 = (function (){var statearr_29224 = state_29195;
(statearr_29224[(20)] = inst_29164);

return statearr_29224;
})();
var statearr_29225_29282 = state_29195__$1;
(statearr_29225_29282[(2)] = inst_29165);

(statearr_29225_29282[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (6))){
var inst_29191 = (state_29195[(2)]);
var state_29195__$1 = state_29195;
var statearr_29226_29283 = state_29195__$1;
(statearr_29226_29283[(2)] = inst_29191);

(statearr_29226_29283[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (28))){
var inst_29128 = (state_29195[(13)]);
var inst_29158 = (state_29195[(2)]);
var state_29195__$1 = (function (){var statearr_29227 = state_29195;
(statearr_29227[(21)] = inst_29158);

return statearr_29227;
})();
if(cljs.core.truth_(inst_29128)){
var statearr_29228_29284 = state_29195__$1;
(statearr_29228_29284[(1)] = (29));

} else {
var statearr_29229_29285 = state_29195__$1;
(statearr_29229_29285[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (25))){
var inst_29129 = (state_29195[(16)]);
var inst_29151 = (state_29195[(2)]);
var state_29195__$1 = (function (){var statearr_29230 = state_29195;
(statearr_29230[(22)] = inst_29151);

return statearr_29230;
})();
if(cljs.core.truth_(inst_29129)){
var statearr_29231_29286 = state_29195__$1;
(statearr_29231_29286[(1)] = (26));

} else {
var statearr_29232_29287 = state_29195__$1;
(statearr_29232_29287[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (34))){
var inst_29187 = (state_29195[(2)]);
var state_29195__$1 = (function (){var statearr_29233 = state_29195;
(statearr_29233[(23)] = inst_29187);

return statearr_29233;
})();
var statearr_29234_29288 = state_29195__$1;
(statearr_29234_29288[(2)] = null);

(statearr_29234_29288[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (17))){
var inst_29134 = (state_29195[(8)]);
var inst_29125 = (state_29195[(14)]);
var inst_29135 = (state_29195[(15)]);
var inst_29137 = (inst_29135.cljs$core$IFn$_invoke$arity$2 ? inst_29135.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_29125) : inst_29135.call(null,hatti.constants._rank,inst_29125));
var inst_29138 = (inst_29134.cljs$core$IFn$_invoke$arity$1 ? inst_29134.cljs$core$IFn$_invoke$arity$1(inst_29137) : inst_29134.call(null,inst_29137));
var state_29195__$1 = state_29195;
var statearr_29235_29289 = state_29195__$1;
(statearr_29235_29289[(2)] = inst_29138);

(statearr_29235_29289[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (3))){
var inst_29193 = (state_29195[(2)]);
var state_29195__$1 = state_29195;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29195__$1,inst_29193);
} else {
if((state_val_29196 === (12))){
var state_29195__$1 = state_29195;
var statearr_29236_29290 = state_29195__$1;
(statearr_29236_29290[(2)] = false);

(statearr_29236_29290[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (2))){
var state_29195__$1 = state_29195;
var statearr_29237_29291 = state_29195__$1;
(statearr_29237_29291[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (23))){
var inst_29134 = (state_29195[(8)]);
var inst_29148 = (inst_29134.cljs$core$IFn$_invoke$arity$1 ? inst_29134.cljs$core$IFn$_invoke$arity$1(null) : inst_29134.call(null,null));
var state_29195__$1 = state_29195;
var statearr_29239_29292 = state_29195__$1;
(statearr_29239_29292[(2)] = inst_29148);

(statearr_29239_29292[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (19))){
var inst_29126 = (state_29195[(9)]);
var inst_29141 = (state_29195[(2)]);
var state_29195__$1 = (function (){var statearr_29240 = state_29195;
(statearr_29240[(24)] = inst_29141);

return statearr_29240;
})();
if(cljs.core.truth_(inst_29126)){
var statearr_29241_29293 = state_29195__$1;
(statearr_29241_29293[(1)] = (20));

} else {
var statearr_29242_29294 = state_29195__$1;
(statearr_29242_29294[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (11))){
var state_29195__$1 = state_29195;
var statearr_29243_29295 = state_29195__$1;
(statearr_29243_29295[(2)] = true);

(statearr_29243_29295[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (9))){
var state_29195__$1 = state_29195;
var statearr_29244_29296 = state_29195__$1;
(statearr_29244_29296[(2)] = false);

(statearr_29244_29296[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (5))){
var state_29195__$1 = state_29195;
var statearr_29245_29297 = state_29195__$1;
(statearr_29245_29297[(2)] = null);

(statearr_29245_29297[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (14))){
var inst_29104 = (state_29195[(7)]);
var inst_29121 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29104);
var state_29195__$1 = state_29195;
var statearr_29246_29298 = state_29195__$1;
(statearr_29246_29298[(2)] = inst_29121);

(statearr_29246_29298[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (26))){
var inst_29129 = (state_29195[(16)]);
var inst_29153 = grid.setColumns(inst_29129);
var inst_29154 = hatti.views.table.resizeColumns(grid);
var inst_29155 = grid.render();
var state_29195__$1 = (function (){var statearr_29247 = state_29195;
(statearr_29247[(25)] = inst_29153);

(statearr_29247[(26)] = inst_29154);

return statearr_29247;
})();
var statearr_29248_29299 = state_29195__$1;
(statearr_29248_29299[(2)] = inst_29155);

(statearr_29248_29299[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (16))){
var inst_29127 = (state_29195[(12)]);
var inst_29130 = (state_29195[(10)]);
var inst_29128 = (state_29195[(13)]);
var inst_29134 = (state_29195[(8)]);
var inst_29126 = (state_29195[(9)]);
var inst_29125 = (state_29195[(14)]);
var inst_29129 = (state_29195[(16)]);
var inst_29104 = (state_29195[(7)]);
var inst_29124 = (state_29195[(17)]);
var inst_29124__$1 = (state_29195[(2)]);
var inst_29125__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29124__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_29126__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29124__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_29127__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29124__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_29128__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29124__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_29129__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29124__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_29130__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29124__$1,cljs.core.cst$kw$re_DASH_render);
var inst_29131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29132 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_29133 = (new cljs.core.PersistentVector(null,3,(5),inst_29131,inst_29132,null));
var inst_29134__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_29133);
var inst_29135 = (function (){var e = inst_29104;
var map__29102 = inst_29124__$1;
var submission_to_rank = inst_29125__$1;
var submission_clicked = inst_29126__$1;
var submission_unclicked = inst_29127__$1;
var filter_by = inst_29128__$1;
var new_columns = inst_29129__$1;
var re_render = inst_29130__$1;
var update_data_BANG_ = inst_29134__$1;
return ((function (e,map__29102,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29127,inst_29130,inst_29128,inst_29134,inst_29126,inst_29125,inst_29129,inst_29104,inst_29124,inst_29124__$1,inst_29125__$1,inst_29126__$1,inst_29127__$1,inst_29128__$1,inst_29129__$1,inst_29130__$1,inst_29131,inst_29132,inst_29133,inst_29134__$1,state_val_29196,c__7694__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (e,map__29102,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29127,inst_29130,inst_29128,inst_29134,inst_29126,inst_29125,inst_29129,inst_29104,inst_29124,inst_29124__$1,inst_29125__$1,inst_29126__$1,inst_29127__$1,inst_29128__$1,inst_29129__$1,inst_29130__$1,inst_29131,inst_29132,inst_29133,inst_29134__$1,state_val_29196,c__7694__auto__,event_chan){
return (function (p1__28934_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__28934_SHARP_,field));
});})(e,map__29102,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29127,inst_29130,inst_29128,inst_29134,inst_29126,inst_29125,inst_29129,inst_29104,inst_29124,inst_29124__$1,inst_29125__$1,inst_29126__$1,inst_29127__$1,inst_29128__$1,inst_29129__$1,inst_29130__$1,inst_29131,inst_29132,inst_29133,inst_29134__$1,state_val_29196,c__7694__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(e,map__29102,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29127,inst_29130,inst_29128,inst_29134,inst_29126,inst_29125,inst_29129,inst_29104,inst_29124,inst_29124__$1,inst_29125__$1,inst_29126__$1,inst_29127__$1,inst_29128__$1,inst_29129__$1,inst_29130__$1,inst_29131,inst_29132,inst_29133,inst_29134__$1,state_val_29196,c__7694__auto__,event_chan))
})();
var state_29195__$1 = (function (){var statearr_29249 = state_29195;
(statearr_29249[(12)] = inst_29127__$1);

(statearr_29249[(10)] = inst_29130__$1);

(statearr_29249[(13)] = inst_29128__$1);

(statearr_29249[(8)] = inst_29134__$1);

(statearr_29249[(9)] = inst_29126__$1);

(statearr_29249[(14)] = inst_29125__$1);

(statearr_29249[(15)] = inst_29135);

(statearr_29249[(16)] = inst_29129__$1);

(statearr_29249[(17)] = inst_29124__$1);

return statearr_29249;
})();
if(cljs.core.truth_(inst_29125__$1)){
var statearr_29250_29300 = state_29195__$1;
(statearr_29250_29300[(1)] = (17));

} else {
var statearr_29251_29301 = state_29195__$1;
(statearr_29251_29301[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (30))){
var state_29195__$1 = state_29195;
var statearr_29252_29302 = state_29195__$1;
(statearr_29252_29302[(2)] = null);

(statearr_29252_29302[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (10))){
var inst_29119 = (state_29195[(2)]);
var state_29195__$1 = state_29195;
if(cljs.core.truth_(inst_29119)){
var statearr_29253_29303 = state_29195__$1;
(statearr_29253_29303[(1)] = (14));

} else {
var statearr_29254_29304 = state_29195__$1;
(statearr_29254_29304[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (18))){
var state_29195__$1 = state_29195;
var statearr_29255_29305 = state_29195__$1;
(statearr_29255_29305[(2)] = null);

(statearr_29255_29305[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29196 === (8))){
var inst_29104 = (state_29195[(7)]);
var inst_29109 = inst_29104.cljs$lang$protocol_mask$partition0$;
var inst_29110 = (inst_29109 & (64));
var inst_29111 = inst_29104.cljs$core$ISeq$;
var inst_29112 = (inst_29110) || (inst_29111);
var state_29195__$1 = state_29195;
if(cljs.core.truth_(inst_29112)){
var statearr_29256_29306 = state_29195__$1;
(statearr_29256_29306[(1)] = (11));

} else {
var statearr_29257_29307 = state_29195__$1;
(statearr_29257_29307[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__,event_chan))
;
return ((function (switch__7673__auto__,c__7694__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____0 = (function (){
var statearr_29261 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29261[(0)] = hatti$views$table$handle_table_events_$_state_machine__7674__auto__);

(statearr_29261[(1)] = (1));

return statearr_29261;
});
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____1 = (function (state_29195){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__(state_29195);
if(cljs.core.keyword_identical_QMARK_(result__7676__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e29262){if((e29262 instanceof Object)){
var ex__7677__auto__ = e29262;
var statearr_29263_29308 = state_29195;
(statearr_29263_29308[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29195);

return cljs.core.cst$kw$recur;
} else {
throw e29262;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7675__auto__,cljs.core.cst$kw$recur)){
var G__29309 = state_29195;
state_29195 = G__29309;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = function(state_29195){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____1.call(this,state_29195);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____0;
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__,event_chan))
})();
var state__7696__auto__ = (function (){var statearr_29264 = (f__7695__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7695__auto__.cljs$core$IFn$_invoke$arity$0() : f__7695__auto__.call(null));
(statearr_29264[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_29264;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7696__auto__);
});})(c__7694__auto__,event_chan))
);

return c__7694__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__29320(s__29321){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__29321__$1 = s__29321;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__29321__$1);
if(temp__4425__auto__){
var s__29321__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29321__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29321__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29323 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29322 = (0);
while(true){
if((i__29322 < size__5340__auto__)){
var vec__29328 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29322);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29328,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29328,(1),null);
cljs.core.chunk_append(b__29323,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__29322,vec__29328,k,v,c__5339__auto__,size__5340__auto__,b__29323,s__29321__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__29322,vec__29328,k,v,c__5339__auto__,size__5340__auto__,b__29323,s__29321__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__29330 = (i__29322 + (1));
i__29322 = G__29330;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29323),hatti$views$table$render_options_$_iter__29320(cljs.core.chunk_rest(s__29321__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29323),null);
}
} else {
var vec__29329 = cljs.core.first(s__29321__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29329,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29329,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__29329,k,v,s__29321__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__29329,k,v,s__29321__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__29320(cljs.core.rest(s__29321__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table29332 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29332 = (function (_,owner,meta29333){
this._ = _;
this.owner = owner;
this.meta29333 = meta29333;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29332.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29334,meta29333__$1){
var self__ = this;
var _29334__$1 = this;
return (new hatti.views.table.t_hatti$views$table29332(self__._,self__.owner,meta29333__$1));
});

hatti.views.table.t_hatti$views$table29332.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29334){
var self__ = this;
var _29334__$1 = this;
return self__.meta29333;
});

hatti.views.table.t_hatti$views$table29332.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table29332.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table29332.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table29332.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__29335){
var self__ = this;
var map__29336 = p__29335;
var map__29336__$1 = ((((!((map__29336 == null)))?((((map__29336.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29336.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29336):map__29336);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29336__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29336__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__29338 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__29338__$1 = ((((!((map__29338 == null)))?((((map__29338.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29338.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29338):map__29338);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29338__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__29338,map__29338__$1,flat_form,new_language,___$2,map__29336,map__29336__$1,name_or_label,language){
return (function (p1__29331_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns(flat_form,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__29331_SHARP_),new_language)], null));
});})(options,map__29338,map__29338__$1,flat_form,new_language,___$2,map__29336,map__29336__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__29347 = {"className": "label-changer"};
var G__29348 = (function (){var G__29350 = {"className": "label-changer-label"};
var G__29351 = "Show:";
return React.DOM.span(G__29350,G__29351);
})();
var G__29349 = (function (){var G__29352 = {"id": "header-display-dropdown", "className": "drop-hover"};
var G__29353 = (function (){var attrs29342 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs29342))?sablono.interpreter.attributes(attrs29342):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs29342))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__29355 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__29355);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs29342),(function (){var G__29356 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__29356);
})()], null))));
})();
var G__29354 = (function (){var G__29357 = {"className": "submenu no-dot"};
var G__29358 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__29357,G__29358);
})();
return React.DOM.div(G__29352,G__29353,G__29354);
})();
return React.DOM.div(G__29347,G__29348,G__29349);
});

hatti.views.table.t_hatti$views$table29332.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta29333], null);
});

hatti.views.table.t_hatti$views$table29332.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29332.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29332";

hatti.views.table.t_hatti$views$table29332.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29332");
});

hatti.views.table.__GT_t_hatti$views$table29332 = (function hatti$views$table$__GT_t_hatti$views$table29332(___$1,owner__$1,meta29333){
return (new hatti.views.table.t_hatti$views$table29332(___$1,owner__$1,meta29333));
});

}

return (new hatti.views.table.t_hatti$views$table29332(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__7694__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7694__auto__,query){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__,query){
return (function (state_29401){
var state_val_29402 = (state_29401[(1)]);
if((state_val_29402 === (1))){
var inst_29387 = cljs.core.async.timeout((150));
var state_29401__$1 = state_29401;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29401__$1,(2),inst_29387);
} else {
if((state_val_29402 === (2))){
var inst_29389 = (state_29401[(2)]);
var inst_29390 = input.value;
var inst_29391 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_29390);
var state_29401__$1 = (function (){var statearr_29403 = state_29401;
(statearr_29403[(7)] = inst_29389);

return statearr_29403;
})();
if(inst_29391){
var statearr_29404_29415 = state_29401__$1;
(statearr_29404_29415[(1)] = (3));

} else {
var statearr_29405_29416 = state_29401__$1;
(statearr_29405_29416[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29402 === (3))){
var inst_29393 = [query_event_key];
var inst_29394 = [query];
var inst_29395 = cljs.core.PersistentHashMap.fromArrays(inst_29393,inst_29394);
var inst_29396 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_29395);
var state_29401__$1 = state_29401;
var statearr_29406_29417 = state_29401__$1;
(statearr_29406_29417[(2)] = inst_29396);

(statearr_29406_29417[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29402 === (4))){
var state_29401__$1 = state_29401;
var statearr_29407_29418 = state_29401__$1;
(statearr_29407_29418[(2)] = null);

(statearr_29407_29418[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29402 === (5))){
var inst_29399 = (state_29401[(2)]);
var state_29401__$1 = state_29401;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29401__$1,inst_29399);
} else {
return null;
}
}
}
}
}
});})(c__7694__auto__,query))
;
return ((function (switch__7673__auto__,c__7694__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__7674__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__7674__auto____0 = (function (){
var statearr_29411 = [null,null,null,null,null,null,null,null];
(statearr_29411[(0)] = hatti$views$table$delayed_search_$_state_machine__7674__auto__);

(statearr_29411[(1)] = (1));

return statearr_29411;
});
var hatti$views$table$delayed_search_$_state_machine__7674__auto____1 = (function (state_29401){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__(state_29401);
if(cljs.core.keyword_identical_QMARK_(result__7676__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e29412){if((e29412 instanceof Object)){
var ex__7677__auto__ = e29412;
var statearr_29413_29419 = state_29401;
(statearr_29413_29419[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29401);

return cljs.core.cst$kw$recur;
} else {
throw e29412;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7675__auto__,cljs.core.cst$kw$recur)){
var G__29420 = state_29401;
state_29401 = G__29420;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__7674__auto__ = function(state_29401){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__7674__auto____1.call(this,state_29401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__7674__auto____0;
hatti$views$table$delayed_search_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__7674__auto____1;
return hatti$views$table$delayed_search_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__,query))
})();
var state__7696__auto__ = (function (){var statearr_29414 = (f__7695__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7695__auto__.cljs$core$IFn$_invoke$arity$0() : f__7695__auto__.call(null));
(statearr_29414[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_29414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7696__auto__);
});})(c__7694__auto__,query))
);

return c__7694__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table29422 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29422 = (function (_,owner,meta29423){
this._ = _;
this.owner = owner;
this.meta29423 = meta29423;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29422.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29424,meta29423__$1){
var self__ = this;
var _29424__$1 = this;
return (new hatti.views.table.t_hatti$views$table29422(self__._,self__.owner,meta29423__$1));
});

hatti.views.table.t_hatti$views$table29422.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29424){
var self__ = this;
var _29424__$1 = this;
return self__.meta29423;
});

hatti.views.table.t_hatti$views$table29422.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table29422.prototype.om$core$IRender$render$arity$1 = (function (this__6323__auto__){
var self__ = this;
var this__6323__auto____$1 = this;
var G__29427 = {"className": "table-search"};
var G__29428 = (function (){var G__29430 = {"className": "fa fa-search"};
return React.DOM.i(G__29430);
})();
var G__29429 = (function (){var G__29431 = {"type": "text", "placeholder": "Search", "onChange": ((function (G__29427,G__29428,this__6323__auto____$1){
return (function (p1__29421_SHARP_){
return hatti.views.table.delayed_search(p1__29421_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__29427,G__29428,this__6323__auto____$1))
};
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__29431) : sablono.interpreter.input.call(null,G__29431));
})();
return React.DOM.div(G__29427,G__29428,G__29429);
});

hatti.views.table.t_hatti$views$table29422.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta29423], null);
});

hatti.views.table.t_hatti$views$table29422.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29422.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29422";

hatti.views.table.t_hatti$views$table29422.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29422");
});

hatti.views.table.__GT_t_hatti$views$table29422 = (function hatti$views$table$__GT_t_hatti$views$table29422(___$1,owner__$1,meta29423){
return (new hatti.views.table.t_hatti$views$table29422(___$1,owner__$1,meta29423));
});

}

return (new hatti.views.table.t_hatti$views$table29422(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table29432 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29432 = (function (app_state,owner,meta29433){
this.app_state = app_state;
this.owner = owner;
this.meta29433 = meta29433;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29432.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29434,meta29433__$1){
var self__ = this;
var _29434__$1 = this;
return (new hatti.views.table.t_hatti$views$table29432(self__.app_state,self__.owner,meta29433__$1));
});

hatti.views.table.t_hatti$views$table29432.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29434){
var self__ = this;
var _29434__$1 = this;
return self__.meta29433;
});

hatti.views.table.t_hatti$views$table29432.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table29432.prototype.om$core$IRender$render$arity$1 = (function (this__6323__auto__){
var self__ = this;
var this__6323__auto____$1 = this;
var G__29437 = {"className": "topbar"};
var G__29438 = (function (){var G__29442 = {"id": hatti.views.table.pager_id};
return React.DOM.div(G__29442);
})();
var G__29439 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,null));
var G__29440 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.app_state));
var G__29441 = (function (){var G__29443 = {"style": {"clear": "both"}};
return React.DOM.div(G__29443);
})();
return React.DOM.div(G__29437,G__29438,G__29439,G__29440,G__29441);
});

hatti.views.table.t_hatti$views$table29432.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta29433], null);
});

hatti.views.table.t_hatti$views$table29432.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29432.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29432";

hatti.views.table.t_hatti$views$table29432.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29432");
});

hatti.views.table.__GT_t_hatti$views$table29432 = (function hatti$views$table$__GT_t_hatti$views$table29432(app_state__$1,owner__$1,meta29433){
return (new hatti.views.table.t_hatti$views$table29432(app_state__$1,owner__$1,meta29433));
});

}

return (new hatti.views.table.t_hatti$views$table29432(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq(data)){
var map__29447 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__29447__$1 = ((((!((map__29447 == null)))?((((map__29447.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29447.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29447):map__29447);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29447__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29447__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__29448 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29448,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29448,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,p__29451){
var map__29452 = p__29451;
var map__29452__$1 = ((((!((map__29452 == null)))?((((map__29452.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29452.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29452):map__29452);
var opts = map__29452__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29452__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

if(typeof hatti.views.table.t_hatti$views$table29454 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29454 = (function (app_state,owner,p__29451,map__29452,opts,slick_grid_event_handlers,meta29455){
this.app_state = app_state;
this.owner = owner;
this.p__29451 = p__29451;
this.map__29452 = map__29452;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta29455 = meta29455;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29454.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__29452,map__29452__$1,opts,slick_grid_event_handlers){
return (function (_29456,meta29455__$1){
var self__ = this;
var _29456__$1 = this;
return (new hatti.views.table.t_hatti$views$table29454(self__.app_state,self__.owner,self__.p__29451,self__.map__29452,self__.opts,self__.slick_grid_event_handlers,meta29455__$1));
});})(map__29452,map__29452__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29454.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__29452,map__29452__$1,opts,slick_grid_event_handlers){
return (function (_29456){
var self__ = this;
var _29456__$1 = this;
return self__.meta29455;
});})(map__29452,map__29452__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29454.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table29454.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__29452,map__29452__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null)));
var map__29457 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__29457__$1 = ((((!((map__29457 == null)))?((((map__29457.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29457.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29457):map__29457);
var dataset_info = map__29457__$1;
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29457__$1,cljs.core.cst$kw$num_of_submissions);
var with_info = ((function (no_data_QMARK_,map__29457,map__29457__$1,dataset_info,num_of_submissions,___$2,map__29452,map__29452__$1,opts,slick_grid_event_handlers){
return (function (p1__29450_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__29450_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dataset_DASH_info,dataset_info], null)], 0));
});})(no_data_QMARK_,map__29457,map__29457__$1,dataset_info,num_of_submissions,___$2,map__29452,map__29452__$1,opts,slick_grid_event_handlers))
;
var attrs29459 = om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked], null))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs29459))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs29459], 0))):{"className": "table-view"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs29459))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__29460 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__29461 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__29466 = {"className": "empty-state"};
var G__29467 = "No data";
return React.DOM.span(G__29466,G__29467);
})():(function (){var G__29469 = null;
var G__29470 = (function (){var G__29472 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__29472);
})();
var G__29471 = "Loading...";
return React.DOM.span(G__29469,G__29470,G__29471);
})());
return React.DOM.div(G__29460,G__29461);
})()], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs29459),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__29473 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__29474 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__29479 = {"className": "empty-state"};
var G__29480 = "No data";
return React.DOM.span(G__29479,G__29480);
})():(function (){var G__29482 = null;
var G__29483 = (function (){var G__29485 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__29485);
})();
var G__29484 = "Loading...";
return React.DOM.span(G__29482,G__29483,G__29484);
})());
return React.DOM.div(G__29473,G__29474);
})()], null))));
});})(map__29452,map__29452__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29454.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table29454.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__29452,map__29452__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__29486 = temp__4425__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29486,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29486,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__29452,map__29452__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29454.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table29454.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__29452,map__29452__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__29487 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__29487__$1 = ((((!((map__29487 == null)))?((((map__29487.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29487.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29487):map__29487);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29487__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29487__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__29489 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29489,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29489,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__29452,map__29452__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29454.getBasis = ((function (map__29452,map__29452__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__29451,cljs.core.cst$sym$map__29452,cljs.core.cst$sym$opts,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$meta29455], null);
});})(map__29452,map__29452__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29454.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29454.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29454";

hatti.views.table.t_hatti$views$table29454.cljs$lang$ctorPrWriter = ((function (map__29452,map__29452__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29454");
});})(map__29452,map__29452__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table29454 = ((function (map__29452,map__29452__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table29454(app_state__$1,owner__$1,p__29451__$1,map__29452__$2,opts__$1,slick_grid_event_handlers__$1,meta29455){
return (new hatti.views.table.t_hatti$views$table29454(app_state__$1,owner__$1,p__29451__$1,map__29452__$2,opts__$1,slick_grid_event_handlers__$1,meta29455));
});})(map__29452,map__29452__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table29454(app_state,owner,p__29451,map__29452__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
