// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__41906__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__41905 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41905,(0),null);
var body = cljs.core.nthnext(vec__41905,(1));
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.first(body),cljs.core.first(args)], 0)),cljs.core.rest(body));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.first(args),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__41906 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__41907__i = 0, G__41907__a = new Array(arguments.length -  0);
while (G__41907__i < G__41907__a.length) {G__41907__a[G__41907__i] = arguments[G__41907__i + 0]; ++G__41907__i;}
  args = new cljs.core.IndexedSeq(G__41907__a,0);
} 
return G__41906__delegate.call(this,args);};
G__41906.cljs$lang$maxFixedArity = 0;
G__41906.cljs$lang$applyTo = (function (arglist__41908){
var args = cljs.core.seq(arglist__41908);
return G__41906__delegate(args);
});
G__41906.cljs$core$IFn$_invoke$arity$variadic = G__41906__delegate;
return G__41906;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5341__auto__ = (function sablono$core$update_arglists_$_iter__41915(s__41916){
return (new cljs.core.LazySeq(null,(function (){
var s__41916__$1 = s__41916;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__41916__$1);
if(temp__4425__auto__){
var s__41916__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41916__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__41916__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__41918 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__41917 = (0);
while(true){
if((i__41917 < size__5340__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__41917);
cljs.core.chunk_append(b__41918,cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)));

var G__41921 = (i__41917 + (1));
i__41917 = G__41921;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41918),sablono$core$update_arglists_$_iter__41915(cljs.core.chunk_rest(s__41916__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41918),null);
}
} else {
var args = cljs.core.first(s__41916__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)),sablono$core$update_arglists_$_iter__41915(cljs.core.rest(s__41916__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5634__auto__ = [];
var len__5627__auto___41929 = arguments.length;
var i__5628__auto___41930 = (0);
while(true){
if((i__5628__auto___41930 < len__5627__auto___41929)){
args__5634__auto__.push((arguments[i__5628__auto___41930]));

var G__41931 = (i__5628__auto___41930 + (1));
i__5628__auto___41930 = G__41931;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5341__auto__ = (function sablono$core$iter__41923(s__41924){
return (new cljs.core.LazySeq(null,(function (){
var s__41924__$1 = s__41924;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__41924__$1);
if(temp__4425__auto__){
var s__41924__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41924__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__41924__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__41926 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__41925 = (0);
while(true){
if((i__41925 < size__5340__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__41925);
cljs.core.chunk_append(b__41926,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null));

var G__41932 = (i__41925 + (1));
i__41925 = G__41932;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41926),sablono$core$iter__41923(cljs.core.chunk_rest(s__41924__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41926),null);
}
} else {
var style = cljs.core.first(s__41924__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null),sablono$core$iter__41923(cljs.core.rest(s__41924__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq41922){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41922));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__41937 = goog.dom.getDocument().body;
var G__41938 = (function (){var G__41939 = "script";
var G__41940 = {"src": src};
return goog.dom.createDom(G__41939,G__41940);
})();
return goog.dom.appendChild(G__41937,G__41938);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to41941 = (function sablono$core$link_to41941(var_args){
var args__5634__auto__ = [];
var len__5627__auto___41944 = arguments.length;
var i__5628__auto___41945 = (0);
while(true){
if((i__5628__auto___41945 < len__5627__auto___41944)){
args__5634__auto__.push((arguments[i__5628__auto___41945]));

var G__41946 = (i__5628__auto___41945 + (1));
i__5628__auto___41945 = G__41946;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.link_to41941.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.link_to41941.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([url], 0))], null),content], null);
});

sablono.core.link_to41941.cljs$lang$maxFixedArity = (1);

sablono.core.link_to41941.cljs$lang$applyTo = (function (seq41942){
var G__41943 = cljs.core.first(seq41942);
var seq41942__$1 = cljs.core.next(seq41942);
return sablono.core.link_to41941.cljs$core$IFn$_invoke$arity$variadic(G__41943,seq41942__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to41941);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to41947 = (function sablono$core$mail_to41947(var_args){
var args__5634__auto__ = [];
var len__5627__auto___41952 = arguments.length;
var i__5628__auto___41953 = (0);
while(true){
if((i__5628__auto___41953 < len__5627__auto___41952)){
args__5634__auto__.push((arguments[i__5628__auto___41953]));

var G__41954 = (i__5628__auto___41953 + (1));
i__5628__auto___41953 = G__41954;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.mail_to41947.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.mail_to41947.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__41950){
var vec__41951 = p__41950;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41951,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4569__auto__ = content;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to41947.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to41947.cljs$lang$applyTo = (function (seq41948){
var G__41949 = cljs.core.first(seq41948);
var seq41948__$1 = cljs.core.next(seq41948);
return sablono.core.mail_to41947.cljs$core$IFn$_invoke$arity$variadic(G__41949,seq41948__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to41947);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list41955 = (function sablono$core$unordered_list41955(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__5341__auto__ = (function sablono$core$unordered_list41955_$_iter__41962(s__41963){
return (new cljs.core.LazySeq(null,(function (){
var s__41963__$1 = s__41963;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__41963__$1);
if(temp__4425__auto__){
var s__41963__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41963__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__41963__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__41965 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__41964 = (0);
while(true){
if((i__41964 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__41964);
cljs.core.chunk_append(b__41965,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__41968 = (i__41964 + (1));
i__41964 = G__41968;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41965),sablono$core$unordered_list41955_$_iter__41962(cljs.core.chunk_rest(s__41963__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41965),null);
}
} else {
var x = cljs.core.first(s__41963__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$unordered_list41955_$_iter__41962(cljs.core.rest(s__41963__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list41955);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list41969 = (function sablono$core$ordered_list41969(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol,(function (){var iter__5341__auto__ = (function sablono$core$ordered_list41969_$_iter__41976(s__41977){
return (new cljs.core.LazySeq(null,(function (){
var s__41977__$1 = s__41977;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__41977__$1);
if(temp__4425__auto__){
var s__41977__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41977__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__41977__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__41979 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__41978 = (0);
while(true){
if((i__41978 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__41978);
cljs.core.chunk_append(b__41979,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__41982 = (i__41978 + (1));
i__41978 = G__41982;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41979),sablono$core$ordered_list41969_$_iter__41976(cljs.core.chunk_rest(s__41977__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41979),null);
}
} else {
var x = cljs.core.first(s__41977__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$ordered_list41969_$_iter__41976(cljs.core.rest(s__41977__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list41969);
/**
 * Create an image element.
 */
sablono.core.image41983 = (function sablono$core$image41983(var_args){
var args41984 = [];
var len__5627__auto___41987 = arguments.length;
var i__5628__auto___41988 = (0);
while(true){
if((i__5628__auto___41988 < len__5627__auto___41987)){
args41984.push((arguments[i__5628__auto___41988]));

var G__41989 = (i__5628__auto___41988 + (1));
i__5628__auto___41988 = G__41989;
continue;
} else {
}
break;
}

var G__41986 = args41984.length;
switch (G__41986) {
case 1:
return sablono.core.image41983.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image41983.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41984.length)].join('')));

}
});

sablono.core.image41983.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0))], null)], null);
});

sablono.core.image41983.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0)),cljs.core.cst$kw$alt,alt], null)], null);
});

sablono.core.image41983.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs(sablono.core.image41983);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__41991_SHARP_,p2__41992_SHARP_){
return [cljs.core.str(p1__41991_SHARP_),cljs.core.str("["),cljs.core.str(p2__41992_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__41993_SHARP_,p2__41994_SHARP_){
return [cljs.core.str(p1__41993_SHARP_),cljs.core.str("-"),cljs.core.str(p2__41994_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field41995 = (function sablono$core$color_field41995(var_args){
var args41996 = [];
var len__5627__auto___42063 = arguments.length;
var i__5628__auto___42064 = (0);
while(true){
if((i__5628__auto___42064 < len__5627__auto___42063)){
args41996.push((arguments[i__5628__auto___42064]));

var G__42065 = (i__5628__auto___42064 + (1));
i__5628__auto___42064 = G__42065;
continue;
} else {
}
break;
}

var G__41998 = args41996.length;
switch (G__41998) {
case 1:
return sablono.core.color_field41995.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field41995.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41996.length)].join('')));

}
});

sablono.core.color_field41995.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.color_field41995.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.color_field41995.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$color)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.color_field41995.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field41995);

/**
 * Creates a date input field.
 */
sablono.core.date_field41999 = (function sablono$core$date_field41999(var_args){
var args42000 = [];
var len__5627__auto___42067 = arguments.length;
var i__5628__auto___42068 = (0);
while(true){
if((i__5628__auto___42068 < len__5627__auto___42067)){
args42000.push((arguments[i__5628__auto___42068]));

var G__42069 = (i__5628__auto___42068 + (1));
i__5628__auto___42068 = G__42069;
continue;
} else {
}
break;
}

var G__42002 = args42000.length;
switch (G__42002) {
case 1:
return sablono.core.date_field41999.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field41999.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42000.length)].join('')));

}
});

sablono.core.date_field41999.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.date_field41999.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.date_field41999.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$date)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.date_field41999.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field41999);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field42003 = (function sablono$core$datetime_field42003(var_args){
var args42004 = [];
var len__5627__auto___42071 = arguments.length;
var i__5628__auto___42072 = (0);
while(true){
if((i__5628__auto___42072 < len__5627__auto___42071)){
args42004.push((arguments[i__5628__auto___42072]));

var G__42073 = (i__5628__auto___42072 + (1));
i__5628__auto___42072 = G__42073;
continue;
} else {
}
break;
}

var G__42006 = args42004.length;
switch (G__42006) {
case 1:
return sablono.core.datetime_field42003.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field42003.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42004.length)].join('')));

}
});

sablono.core.datetime_field42003.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.datetime_field42003.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.datetime_field42003.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.datetime_field42003.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field42003);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field42007 = (function sablono$core$datetime_local_field42007(var_args){
var args42008 = [];
var len__5627__auto___42075 = arguments.length;
var i__5628__auto___42076 = (0);
while(true){
if((i__5628__auto___42076 < len__5627__auto___42075)){
args42008.push((arguments[i__5628__auto___42076]));

var G__42077 = (i__5628__auto___42076 + (1));
i__5628__auto___42076 = G__42077;
continue;
} else {
}
break;
}

var G__42010 = args42008.length;
switch (G__42010) {
case 1:
return sablono.core.datetime_local_field42007.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field42007.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42008.length)].join('')));

}
});

sablono.core.datetime_local_field42007.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.datetime_local_field42007.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.datetime_local_field42007.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime_DASH_local)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.datetime_local_field42007.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field42007);

/**
 * Creates a email input field.
 */
sablono.core.email_field42011 = (function sablono$core$email_field42011(var_args){
var args42012 = [];
var len__5627__auto___42079 = arguments.length;
var i__5628__auto___42080 = (0);
while(true){
if((i__5628__auto___42080 < len__5627__auto___42079)){
args42012.push((arguments[i__5628__auto___42080]));

var G__42081 = (i__5628__auto___42080 + (1));
i__5628__auto___42080 = G__42081;
continue;
} else {
}
break;
}

var G__42014 = args42012.length;
switch (G__42014) {
case 1:
return sablono.core.email_field42011.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field42011.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42012.length)].join('')));

}
});

sablono.core.email_field42011.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.email_field42011.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.email_field42011.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$email)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.email_field42011.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field42011);

/**
 * Creates a file input field.
 */
sablono.core.file_field42015 = (function sablono$core$file_field42015(var_args){
var args42016 = [];
var len__5627__auto___42083 = arguments.length;
var i__5628__auto___42084 = (0);
while(true){
if((i__5628__auto___42084 < len__5627__auto___42083)){
args42016.push((arguments[i__5628__auto___42084]));

var G__42085 = (i__5628__auto___42084 + (1));
i__5628__auto___42084 = G__42085;
continue;
} else {
}
break;
}

var G__42018 = args42016.length;
switch (G__42018) {
case 1:
return sablono.core.file_field42015.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field42015.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42016.length)].join('')));

}
});

sablono.core.file_field42015.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.file_field42015.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.file_field42015.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$file)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.file_field42015.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field42015);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field42019 = (function sablono$core$hidden_field42019(var_args){
var args42020 = [];
var len__5627__auto___42087 = arguments.length;
var i__5628__auto___42088 = (0);
while(true){
if((i__5628__auto___42088 < len__5627__auto___42087)){
args42020.push((arguments[i__5628__auto___42088]));

var G__42089 = (i__5628__auto___42088 + (1));
i__5628__auto___42088 = G__42089;
continue;
} else {
}
break;
}

var G__42022 = args42020.length;
switch (G__42022) {
case 1:
return sablono.core.hidden_field42019.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field42019.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42020.length)].join('')));

}
});

sablono.core.hidden_field42019.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.hidden_field42019.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.hidden_field42019.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$hidden)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.hidden_field42019.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field42019);

/**
 * Creates a month input field.
 */
sablono.core.month_field42023 = (function sablono$core$month_field42023(var_args){
var args42024 = [];
var len__5627__auto___42091 = arguments.length;
var i__5628__auto___42092 = (0);
while(true){
if((i__5628__auto___42092 < len__5627__auto___42091)){
args42024.push((arguments[i__5628__auto___42092]));

var G__42093 = (i__5628__auto___42092 + (1));
i__5628__auto___42092 = G__42093;
continue;
} else {
}
break;
}

var G__42026 = args42024.length;
switch (G__42026) {
case 1:
return sablono.core.month_field42023.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field42023.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42024.length)].join('')));

}
});

sablono.core.month_field42023.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.month_field42023.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.month_field42023.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$month)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.month_field42023.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field42023);

/**
 * Creates a number input field.
 */
sablono.core.number_field42027 = (function sablono$core$number_field42027(var_args){
var args42028 = [];
var len__5627__auto___42095 = arguments.length;
var i__5628__auto___42096 = (0);
while(true){
if((i__5628__auto___42096 < len__5627__auto___42095)){
args42028.push((arguments[i__5628__auto___42096]));

var G__42097 = (i__5628__auto___42096 + (1));
i__5628__auto___42096 = G__42097;
continue;
} else {
}
break;
}

var G__42030 = args42028.length;
switch (G__42030) {
case 1:
return sablono.core.number_field42027.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field42027.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42028.length)].join('')));

}
});

sablono.core.number_field42027.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.number_field42027.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.number_field42027.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$number)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.number_field42027.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field42027);

/**
 * Creates a password input field.
 */
sablono.core.password_field42031 = (function sablono$core$password_field42031(var_args){
var args42032 = [];
var len__5627__auto___42099 = arguments.length;
var i__5628__auto___42100 = (0);
while(true){
if((i__5628__auto___42100 < len__5627__auto___42099)){
args42032.push((arguments[i__5628__auto___42100]));

var G__42101 = (i__5628__auto___42100 + (1));
i__5628__auto___42100 = G__42101;
continue;
} else {
}
break;
}

var G__42034 = args42032.length;
switch (G__42034) {
case 1:
return sablono.core.password_field42031.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field42031.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42032.length)].join('')));

}
});

sablono.core.password_field42031.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.password_field42031.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.password_field42031.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$password)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.password_field42031.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field42031);

/**
 * Creates a range input field.
 */
sablono.core.range_field42035 = (function sablono$core$range_field42035(var_args){
var args42036 = [];
var len__5627__auto___42103 = arguments.length;
var i__5628__auto___42104 = (0);
while(true){
if((i__5628__auto___42104 < len__5627__auto___42103)){
args42036.push((arguments[i__5628__auto___42104]));

var G__42105 = (i__5628__auto___42104 + (1));
i__5628__auto___42104 = G__42105;
continue;
} else {
}
break;
}

var G__42038 = args42036.length;
switch (G__42038) {
case 1:
return sablono.core.range_field42035.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field42035.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42036.length)].join('')));

}
});

sablono.core.range_field42035.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.range_field42035.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.range_field42035.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$range)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.range_field42035.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field42035);

/**
 * Creates a search input field.
 */
sablono.core.search_field42039 = (function sablono$core$search_field42039(var_args){
var args42040 = [];
var len__5627__auto___42107 = arguments.length;
var i__5628__auto___42108 = (0);
while(true){
if((i__5628__auto___42108 < len__5627__auto___42107)){
args42040.push((arguments[i__5628__auto___42108]));

var G__42109 = (i__5628__auto___42108 + (1));
i__5628__auto___42108 = G__42109;
continue;
} else {
}
break;
}

var G__42042 = args42040.length;
switch (G__42042) {
case 1:
return sablono.core.search_field42039.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field42039.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42040.length)].join('')));

}
});

sablono.core.search_field42039.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.search_field42039.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.search_field42039.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$search)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.search_field42039.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field42039);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field42043 = (function sablono$core$tel_field42043(var_args){
var args42044 = [];
var len__5627__auto___42111 = arguments.length;
var i__5628__auto___42112 = (0);
while(true){
if((i__5628__auto___42112 < len__5627__auto___42111)){
args42044.push((arguments[i__5628__auto___42112]));

var G__42113 = (i__5628__auto___42112 + (1));
i__5628__auto___42112 = G__42113;
continue;
} else {
}
break;
}

var G__42046 = args42044.length;
switch (G__42046) {
case 1:
return sablono.core.tel_field42043.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field42043.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42044.length)].join('')));

}
});

sablono.core.tel_field42043.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.tel_field42043.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.tel_field42043.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$tel)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.tel_field42043.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field42043);

/**
 * Creates a text input field.
 */
sablono.core.text_field42047 = (function sablono$core$text_field42047(var_args){
var args42048 = [];
var len__5627__auto___42115 = arguments.length;
var i__5628__auto___42116 = (0);
while(true){
if((i__5628__auto___42116 < len__5627__auto___42115)){
args42048.push((arguments[i__5628__auto___42116]));

var G__42117 = (i__5628__auto___42116 + (1));
i__5628__auto___42116 = G__42117;
continue;
} else {
}
break;
}

var G__42050 = args42048.length;
switch (G__42050) {
case 1:
return sablono.core.text_field42047.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field42047.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42048.length)].join('')));

}
});

sablono.core.text_field42047.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.text_field42047.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.text_field42047.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$text)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.text_field42047.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field42047);

/**
 * Creates a time input field.
 */
sablono.core.time_field42051 = (function sablono$core$time_field42051(var_args){
var args42052 = [];
var len__5627__auto___42119 = arguments.length;
var i__5628__auto___42120 = (0);
while(true){
if((i__5628__auto___42120 < len__5627__auto___42119)){
args42052.push((arguments[i__5628__auto___42120]));

var G__42121 = (i__5628__auto___42120 + (1));
i__5628__auto___42120 = G__42121;
continue;
} else {
}
break;
}

var G__42054 = args42052.length;
switch (G__42054) {
case 1:
return sablono.core.time_field42051.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field42051.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42052.length)].join('')));

}
});

sablono.core.time_field42051.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.time_field42051.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.time_field42051.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$time)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.time_field42051.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field42051);

/**
 * Creates a url input field.
 */
sablono.core.url_field42055 = (function sablono$core$url_field42055(var_args){
var args42056 = [];
var len__5627__auto___42123 = arguments.length;
var i__5628__auto___42124 = (0);
while(true){
if((i__5628__auto___42124 < len__5627__auto___42123)){
args42056.push((arguments[i__5628__auto___42124]));

var G__42125 = (i__5628__auto___42124 + (1));
i__5628__auto___42124 = G__42125;
continue;
} else {
}
break;
}

var G__42058 = args42056.length;
switch (G__42058) {
case 1:
return sablono.core.url_field42055.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field42055.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42056.length)].join('')));

}
});

sablono.core.url_field42055.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.url_field42055.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.url_field42055.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$url)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.url_field42055.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field42055);

/**
 * Creates a week input field.
 */
sablono.core.week_field42059 = (function sablono$core$week_field42059(var_args){
var args42060 = [];
var len__5627__auto___42127 = arguments.length;
var i__5628__auto___42128 = (0);
while(true){
if((i__5628__auto___42128 < len__5627__auto___42127)){
args42060.push((arguments[i__5628__auto___42128]));

var G__42129 = (i__5628__auto___42128 + (1));
i__5628__auto___42128 = G__42129;
continue;
} else {
}
break;
}

var G__42062 = args42060.length;
switch (G__42062) {
case 1:
return sablono.core.week_field42059.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field42059.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42060.length)].join('')));

}
});

sablono.core.week_field42059.cljs$core$IFn$_invoke$arity$1 = (function (name__12458__auto__){
return sablono.core.week_field42059.cljs$core$IFn$_invoke$arity$2(name__12458__auto__,null);
});

sablono.core.week_field42059.cljs$core$IFn$_invoke$arity$2 = (function (name__12458__auto__,value__12459__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$week)].join(''),name__12458__auto__,value__12459__auto__);
});

sablono.core.week_field42059.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field42059);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box42131 = (function sablono$core$check_box42131(var_args){
var args42132 = [];
var len__5627__auto___42135 = arguments.length;
var i__5628__auto___42136 = (0);
while(true){
if((i__5628__auto___42136 < len__5627__auto___42135)){
args42132.push((arguments[i__5628__auto___42136]));

var G__42137 = (i__5628__auto___42136 + (1));
i__5628__auto___42136 = G__42137;
continue;
} else {
}
break;
}

var G__42134 = args42132.length;
switch (G__42134) {
case 1:
return sablono.core.check_box42131.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box42131.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box42131.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42132.length)].join('')));

}
});

sablono.core.check_box42131.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box42131.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.check_box42131.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box42131.cljs$core$IFn$_invoke$arity$3(name,checked_QMARK_,"true");
});

sablono.core.check_box42131.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.check_box42131.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box42131);
/**
 * Creates a radio button.
 */
sablono.core.radio_button42139 = (function sablono$core$radio_button42139(var_args){
var args42140 = [];
var len__5627__auto___42143 = arguments.length;
var i__5628__auto___42144 = (0);
while(true){
if((i__5628__auto___42144 < len__5627__auto___42143)){
args42140.push((arguments[i__5628__auto___42144]));

var G__42145 = (i__5628__auto___42144 + (1));
i__5628__auto___42144 = G__42145;
continue;
} else {
}
break;
}

var G__42142 = args42140.length;
switch (G__42142) {
case 1:
return sablono.core.radio_button42139.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button42139.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button42139.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42140.length)].join('')));

}
});

sablono.core.radio_button42139.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button42139.cljs$core$IFn$_invoke$arity$2(group,null);
});

sablono.core.radio_button42139.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button42139.cljs$core$IFn$_invoke$arity$3(group,checked_QMARK_,"true");
});

sablono.core.radio_button42139.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$name,sablono.core.make_name(group),cljs.core.cst$kw$id,sablono.core.make_id([cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([group], 0))),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([value], 0)))].join('')),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.radio_button42139.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button42139);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options42147 = (function sablono$core$select_options42147(var_args){
var args42148 = [];
var len__5627__auto___42161 = arguments.length;
var i__5628__auto___42162 = (0);
while(true){
if((i__5628__auto___42162 < len__5627__auto___42161)){
args42148.push((arguments[i__5628__auto___42162]));

var G__42163 = (i__5628__auto___42162 + (1));
i__5628__auto___42162 = G__42163;
continue;
} else {
}
break;
}

var G__42150 = args42148.length;
switch (G__42150) {
case 1:
return sablono.core.select_options42147.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options42147.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42148.length)].join('')));

}
});

sablono.core.select_options42147.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options42147.cljs$core$IFn$_invoke$arity$2(coll,null);
});

sablono.core.select_options42147.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__5341__auto__ = (function sablono$core$iter__42151(s__42152){
return (new cljs.core.LazySeq(null,(function (){
var s__42152__$1 = s__42152;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__42152__$1);
if(temp__4425__auto__){
var s__42152__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__42152__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__42152__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__42154 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__42153 = (0);
while(true){
if((i__42153 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__42153);
cljs.core.chunk_append(b__42154,((cljs.core.sequential_QMARK_(x))?(function (){var vec__42159 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42159,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42159,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42159,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options42147.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)));

var G__42165 = (i__42153 + (1));
i__42153 = G__42165;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42154),sablono$core$iter__42151(cljs.core.chunk_rest(s__42152__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42154),null);
}
} else {
var x = cljs.core.first(s__42152__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__42160 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42160,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42160,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42160,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options42147.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)),sablono$core$iter__42151(cljs.core.rest(s__42152__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
});

sablono.core.select_options42147.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options42147);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down42166 = (function sablono$core$drop_down42166(var_args){
var args42167 = [];
var len__5627__auto___42170 = arguments.length;
var i__5628__auto___42171 = (0);
while(true){
if((i__5628__auto___42171 < len__5627__auto___42170)){
args42167.push((arguments[i__5628__auto___42171]));

var G__42172 = (i__5628__auto___42171 + (1));
i__5628__auto___42171 = G__42172;
continue;
} else {
}
break;
}

var G__42169 = args42167.length;
switch (G__42169) {
case 2:
return sablono.core.drop_down42166.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down42166.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42167.length)].join('')));

}
});

sablono.core.drop_down42166.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down42166.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down42166.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down42166.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down42166);
/**
 * Creates a text area element.
 */
sablono.core.text_area42174 = (function sablono$core$text_area42174(var_args){
var args42175 = [];
var len__5627__auto___42178 = arguments.length;
var i__5628__auto___42179 = (0);
while(true){
if((i__5628__auto___42179 < len__5627__auto___42178)){
args42175.push((arguments[i__5628__auto___42179]));

var G__42180 = (i__5628__auto___42179 + (1));
i__5628__auto___42179 = G__42180;
continue;
} else {
}
break;
}

var G__42177 = args42175.length;
switch (G__42177) {
case 1:
return sablono.core.text_area42174.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area42174.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42175.length)].join('')));

}
});

sablono.core.text_area42174.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area42174.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.text_area42174.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});

sablono.core.text_area42174.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area42174);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label42182 = (function sablono$core$label42182(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$htmlFor,sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label42182);
/**
 * Creates a submit button.
 */
sablono.core.submit_button42183 = (function sablono$core$submit_button42183(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button42183);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button42184 = (function sablono$core$reset_button42184(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"reset",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button42184);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to42185 = (function sablono$core$form_to42185(var_args){
var args__5634__auto__ = [];
var len__5627__auto___42190 = arguments.length;
var i__5628__auto___42191 = (0);
while(true){
if((i__5628__auto___42191 < len__5627__auto___42190)){
args__5634__auto__.push((arguments[i__5628__auto___42191]));

var G__42192 = (i__5628__auto___42191 + (1));
i__5628__auto___42191 = G__42192;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.form_to42185.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.form_to42185.cljs$core$IFn$_invoke$arity$variadic = (function (p__42188,body){
var vec__42189 = p__42188;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42189,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42189,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$get,null,cljs.core.cst$kw$post,null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,method_str,cljs.core.cst$kw$action,action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,"POST",cljs.core.cst$kw$action,action_uri], null),(sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2("_method",method_str) : sablono.core.hidden_field.call(null,"_method",method_str))], null)),body));
});

sablono.core.form_to42185.cljs$lang$maxFixedArity = (1);

sablono.core.form_to42185.cljs$lang$applyTo = (function (seq42186){
var G__42187 = cljs.core.first(seq42186);
var seq42186__$1 = cljs.core.next(seq42186);
return sablono.core.form_to42185.cljs$core$IFn$_invoke$arity$variadic(G__42187,seq42186__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to42185);
