// Compiled by ClojureScript 1.7.145 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async13788 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13788 = (function (fn_handler,f,meta13789){
this.fn_handler = fn_handler;
this.f = f;
this.meta13789 = meta13789;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13788.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13790,meta13789__$1){
var self__ = this;
var _13790__$1 = this;
return (new cljs.core.async.t_cljs$core$async13788(self__.fn_handler,self__.f,meta13789__$1));
});

cljs.core.async.t_cljs$core$async13788.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13790){
var self__ = this;
var _13790__$1 = this;
return self__.meta13789;
});

cljs.core.async.t_cljs$core$async13788.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13788.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async13788.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async13788.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta13789","meta13789",-882776100,null)], null);
});

cljs.core.async.t_cljs$core$async13788.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13788.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13788";

cljs.core.async.t_cljs$core$async13788.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async13788");
});

cljs.core.async.__GT_t_cljs$core$async13788 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async13788(fn_handler__$1,f__$1,meta13789){
return (new cljs.core.async.t_cljs$core$async13788(fn_handler__$1,f__$1,meta13789));
});

}

return (new cljs.core.async.t_cljs$core$async13788(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args13793 = [];
var len__5627__auto___13796 = arguments.length;
var i__5628__auto___13797 = (0);
while(true){
if((i__5628__auto___13797 < len__5627__auto___13796)){
args13793.push((arguments[i__5628__auto___13797]));

var G__13798 = (i__5628__auto___13797 + (1));
i__5628__auto___13797 = G__13798;
continue;
} else {
}
break;
}

var G__13795 = args13793.length;
switch (G__13795) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13793.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args13800 = [];
var len__5627__auto___13803 = arguments.length;
var i__5628__auto___13804 = (0);
while(true){
if((i__5628__auto___13804 < len__5627__auto___13803)){
args13800.push((arguments[i__5628__auto___13804]));

var G__13805 = (i__5628__auto___13804 + (1));
i__5628__auto___13804 = G__13805;
continue;
} else {
}
break;
}

var G__13802 = args13800.length;
switch (G__13802) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13800.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_13807 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_13807);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_13807,ret){
return (function (){
return fn1.call(null,val_13807);
});})(val_13807,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args13808 = [];
var len__5627__auto___13811 = arguments.length;
var i__5628__auto___13812 = (0);
while(true){
if((i__5628__auto___13812 < len__5627__auto___13811)){
args13808.push((arguments[i__5628__auto___13812]));

var G__13813 = (i__5628__auto___13812 + (1));
i__5628__auto___13812 = G__13813;
continue;
} else {
}
break;
}

var G__13810 = args13808.length;
switch (G__13810) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13808.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5472__auto___13815 = n;
var x_13816 = (0);
while(true){
if((x_13816 < n__5472__auto___13815)){
(a[x_13816] = (0));

var G__13817 = (x_13816 + (1));
x_13816 = G__13817;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__13818 = (i + (1));
i = G__13818;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async13822 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13822 = (function (alt_flag,flag,meta13823){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta13823 = meta13823;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13822.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_13824,meta13823__$1){
var self__ = this;
var _13824__$1 = this;
return (new cljs.core.async.t_cljs$core$async13822(self__.alt_flag,self__.flag,meta13823__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async13822.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_13824){
var self__ = this;
var _13824__$1 = this;
return self__.meta13823;
});})(flag))
;

cljs.core.async.t_cljs$core$async13822.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13822.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async13822.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async13822.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta13823","meta13823",1404348341,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async13822.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13822.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13822";

cljs.core.async.t_cljs$core$async13822.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async13822");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async13822 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async13822(alt_flag__$1,flag__$1,meta13823){
return (new cljs.core.async.t_cljs$core$async13822(alt_flag__$1,flag__$1,meta13823));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async13822(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async13828 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13828 = (function (alt_handler,flag,cb,meta13829){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta13829 = meta13829;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13828.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13830,meta13829__$1){
var self__ = this;
var _13830__$1 = this;
return (new cljs.core.async.t_cljs$core$async13828(self__.alt_handler,self__.flag,self__.cb,meta13829__$1));
});

cljs.core.async.t_cljs$core$async13828.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13830){
var self__ = this;
var _13830__$1 = this;
return self__.meta13829;
});

cljs.core.async.t_cljs$core$async13828.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13828.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async13828.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async13828.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta13829","meta13829",-1552612763,null)], null);
});

cljs.core.async.t_cljs$core$async13828.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13828.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13828";

cljs.core.async.t_cljs$core$async13828.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async13828");
});

cljs.core.async.__GT_t_cljs$core$async13828 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async13828(alt_handler__$1,flag__$1,cb__$1,meta13829){
return (new cljs.core.async.t_cljs$core$async13828(alt_handler__$1,flag__$1,cb__$1,meta13829));
});

}

return (new cljs.core.async.t_cljs$core$async13828(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13831_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13831_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13832_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13832_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4569__auto__ = wport;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return port;
}
})()], null));
} else {
var G__13833 = (i + (1));
i = G__13833;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4569__auto__ = ret;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4557__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___13839 = arguments.length;
var i__5628__auto___13840 = (0);
while(true){
if((i__5628__auto___13840 < len__5627__auto___13839)){
args__5634__auto__.push((arguments[i__5628__auto___13840]));

var G__13841 = (i__5628__auto___13840 + (1));
i__5628__auto___13840 = G__13841;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__13836){
var map__13837 = p__13836;
var map__13837__$1 = ((((!((map__13837 == null)))?((((map__13837.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13837.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13837):map__13837);
var opts = map__13837__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq13834){
var G__13835 = cljs.core.first.call(null,seq13834);
var seq13834__$1 = cljs.core.next.call(null,seq13834);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13835,seq13834__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args13842 = [];
var len__5627__auto___13892 = arguments.length;
var i__5628__auto___13893 = (0);
while(true){
if((i__5628__auto___13893 < len__5627__auto___13892)){
args13842.push((arguments[i__5628__auto___13893]));

var G__13894 = (i__5628__auto___13893 + (1));
i__5628__auto___13893 = G__13894;
continue;
} else {
}
break;
}

var G__13844 = args13842.length;
switch (G__13844) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13842.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__7694__auto___13896 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___13896){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___13896){
return (function (state_13868){
var state_val_13869 = (state_13868[(1)]);
if((state_val_13869 === (7))){
var inst_13864 = (state_13868[(2)]);
var state_13868__$1 = state_13868;
var statearr_13870_13897 = state_13868__$1;
(statearr_13870_13897[(2)] = inst_13864);

(statearr_13870_13897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13869 === (1))){
var state_13868__$1 = state_13868;
var statearr_13871_13898 = state_13868__$1;
(statearr_13871_13898[(2)] = null);

(statearr_13871_13898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13869 === (4))){
var inst_13847 = (state_13868[(7)]);
var inst_13847__$1 = (state_13868[(2)]);
var inst_13848 = (inst_13847__$1 == null);
var state_13868__$1 = (function (){var statearr_13872 = state_13868;
(statearr_13872[(7)] = inst_13847__$1);

return statearr_13872;
})();
if(cljs.core.truth_(inst_13848)){
var statearr_13873_13899 = state_13868__$1;
(statearr_13873_13899[(1)] = (5));

} else {
var statearr_13874_13900 = state_13868__$1;
(statearr_13874_13900[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13869 === (13))){
var state_13868__$1 = state_13868;
var statearr_13875_13901 = state_13868__$1;
(statearr_13875_13901[(2)] = null);

(statearr_13875_13901[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13869 === (6))){
var inst_13847 = (state_13868[(7)]);
var state_13868__$1 = state_13868;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13868__$1,(11),to,inst_13847);
} else {
if((state_val_13869 === (3))){
var inst_13866 = (state_13868[(2)]);
var state_13868__$1 = state_13868;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13868__$1,inst_13866);
} else {
if((state_val_13869 === (12))){
var state_13868__$1 = state_13868;
var statearr_13876_13902 = state_13868__$1;
(statearr_13876_13902[(2)] = null);

(statearr_13876_13902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13869 === (2))){
var state_13868__$1 = state_13868;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13868__$1,(4),from);
} else {
if((state_val_13869 === (11))){
var inst_13857 = (state_13868[(2)]);
var state_13868__$1 = state_13868;
if(cljs.core.truth_(inst_13857)){
var statearr_13877_13903 = state_13868__$1;
(statearr_13877_13903[(1)] = (12));

} else {
var statearr_13878_13904 = state_13868__$1;
(statearr_13878_13904[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13869 === (9))){
var state_13868__$1 = state_13868;
var statearr_13879_13905 = state_13868__$1;
(statearr_13879_13905[(2)] = null);

(statearr_13879_13905[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13869 === (5))){
var state_13868__$1 = state_13868;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13880_13906 = state_13868__$1;
(statearr_13880_13906[(1)] = (8));

} else {
var statearr_13881_13907 = state_13868__$1;
(statearr_13881_13907[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13869 === (14))){
var inst_13862 = (state_13868[(2)]);
var state_13868__$1 = state_13868;
var statearr_13882_13908 = state_13868__$1;
(statearr_13882_13908[(2)] = inst_13862);

(statearr_13882_13908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13869 === (10))){
var inst_13854 = (state_13868[(2)]);
var state_13868__$1 = state_13868;
var statearr_13883_13909 = state_13868__$1;
(statearr_13883_13909[(2)] = inst_13854);

(statearr_13883_13909[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13869 === (8))){
var inst_13851 = cljs.core.async.close_BANG_.call(null,to);
var state_13868__$1 = state_13868;
var statearr_13884_13910 = state_13868__$1;
(statearr_13884_13910[(2)] = inst_13851);

(statearr_13884_13910[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___13896))
;
return ((function (switch__7673__auto__,c__7694__auto___13896){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_13888 = [null,null,null,null,null,null,null,null];
(statearr_13888[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_13888[(1)] = (1));

return statearr_13888;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_13868){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_13868);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e13889){if((e13889 instanceof Object)){
var ex__7677__auto__ = e13889;
var statearr_13890_13911 = state_13868;
(statearr_13890_13911[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13868);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13889;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13912 = state_13868;
state_13868 = G__13912;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_13868){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_13868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___13896))
})();
var state__7696__auto__ = (function (){var statearr_13891 = f__7695__auto__.call(null);
(statearr_13891[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___13896);

return statearr_13891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___13896))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14096){
var vec__14097 = p__14096;
var v = cljs.core.nth.call(null,vec__14097,(0),null);
var p = cljs.core.nth.call(null,vec__14097,(1),null);
var job = vec__14097;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__7694__auto___14279 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___14279,res,vec__14097,v,p,job,jobs,results){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___14279,res,vec__14097,v,p,job,jobs,results){
return (function (state_14102){
var state_val_14103 = (state_14102[(1)]);
if((state_val_14103 === (1))){
var state_14102__$1 = state_14102;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14102__$1,(2),res,v);
} else {
if((state_val_14103 === (2))){
var inst_14099 = (state_14102[(2)]);
var inst_14100 = cljs.core.async.close_BANG_.call(null,res);
var state_14102__$1 = (function (){var statearr_14104 = state_14102;
(statearr_14104[(7)] = inst_14099);

return statearr_14104;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14102__$1,inst_14100);
} else {
return null;
}
}
});})(c__7694__auto___14279,res,vec__14097,v,p,job,jobs,results))
;
return ((function (switch__7673__auto__,c__7694__auto___14279,res,vec__14097,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14108 = [null,null,null,null,null,null,null,null];
(statearr_14108[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14108[(1)] = (1));

return statearr_14108;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14102){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14102);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14109){if((e14109 instanceof Object)){
var ex__7677__auto__ = e14109;
var statearr_14110_14280 = state_14102;
(statearr_14110_14280[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14102);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14109;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14281 = state_14102;
state_14102 = G__14281;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14102){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___14279,res,vec__14097,v,p,job,jobs,results))
})();
var state__7696__auto__ = (function (){var statearr_14111 = f__7695__auto__.call(null);
(statearr_14111[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14279);

return statearr_14111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___14279,res,vec__14097,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14112){
var vec__14113 = p__14112;
var v = cljs.core.nth.call(null,vec__14113,(0),null);
var p = cljs.core.nth.call(null,vec__14113,(1),null);
var job = vec__14113;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5472__auto___14282 = n;
var __14283 = (0);
while(true){
if((__14283 < n__5472__auto___14282)){
var G__14114_14284 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14114_14284) {
case "compute":
var c__7694__auto___14286 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__14283,c__7694__auto___14286,G__14114_14284,n__5472__auto___14282,jobs,results,process,async){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (__14283,c__7694__auto___14286,G__14114_14284,n__5472__auto___14282,jobs,results,process,async){
return (function (state_14127){
var state_val_14128 = (state_14127[(1)]);
if((state_val_14128 === (1))){
var state_14127__$1 = state_14127;
var statearr_14129_14287 = state_14127__$1;
(statearr_14129_14287[(2)] = null);

(statearr_14129_14287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14128 === (2))){
var state_14127__$1 = state_14127;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14127__$1,(4),jobs);
} else {
if((state_val_14128 === (3))){
var inst_14125 = (state_14127[(2)]);
var state_14127__$1 = state_14127;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14127__$1,inst_14125);
} else {
if((state_val_14128 === (4))){
var inst_14117 = (state_14127[(2)]);
var inst_14118 = process.call(null,inst_14117);
var state_14127__$1 = state_14127;
if(cljs.core.truth_(inst_14118)){
var statearr_14130_14288 = state_14127__$1;
(statearr_14130_14288[(1)] = (5));

} else {
var statearr_14131_14289 = state_14127__$1;
(statearr_14131_14289[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14128 === (5))){
var state_14127__$1 = state_14127;
var statearr_14132_14290 = state_14127__$1;
(statearr_14132_14290[(2)] = null);

(statearr_14132_14290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14128 === (6))){
var state_14127__$1 = state_14127;
var statearr_14133_14291 = state_14127__$1;
(statearr_14133_14291[(2)] = null);

(statearr_14133_14291[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14128 === (7))){
var inst_14123 = (state_14127[(2)]);
var state_14127__$1 = state_14127;
var statearr_14134_14292 = state_14127__$1;
(statearr_14134_14292[(2)] = inst_14123);

(statearr_14134_14292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14283,c__7694__auto___14286,G__14114_14284,n__5472__auto___14282,jobs,results,process,async))
;
return ((function (__14283,switch__7673__auto__,c__7694__auto___14286,G__14114_14284,n__5472__auto___14282,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14138 = [null,null,null,null,null,null,null];
(statearr_14138[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14138[(1)] = (1));

return statearr_14138;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14127){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14127);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14139){if((e14139 instanceof Object)){
var ex__7677__auto__ = e14139;
var statearr_14140_14293 = state_14127;
(statearr_14140_14293[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14127);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14139;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14294 = state_14127;
state_14127 = G__14294;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14127){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(__14283,switch__7673__auto__,c__7694__auto___14286,G__14114_14284,n__5472__auto___14282,jobs,results,process,async))
})();
var state__7696__auto__ = (function (){var statearr_14141 = f__7695__auto__.call(null);
(statearr_14141[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14286);

return statearr_14141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(__14283,c__7694__auto___14286,G__14114_14284,n__5472__auto___14282,jobs,results,process,async))
);


break;
case "async":
var c__7694__auto___14295 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__14283,c__7694__auto___14295,G__14114_14284,n__5472__auto___14282,jobs,results,process,async){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (__14283,c__7694__auto___14295,G__14114_14284,n__5472__auto___14282,jobs,results,process,async){
return (function (state_14154){
var state_val_14155 = (state_14154[(1)]);
if((state_val_14155 === (1))){
var state_14154__$1 = state_14154;
var statearr_14156_14296 = state_14154__$1;
(statearr_14156_14296[(2)] = null);

(statearr_14156_14296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14155 === (2))){
var state_14154__$1 = state_14154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14154__$1,(4),jobs);
} else {
if((state_val_14155 === (3))){
var inst_14152 = (state_14154[(2)]);
var state_14154__$1 = state_14154;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14154__$1,inst_14152);
} else {
if((state_val_14155 === (4))){
var inst_14144 = (state_14154[(2)]);
var inst_14145 = async.call(null,inst_14144);
var state_14154__$1 = state_14154;
if(cljs.core.truth_(inst_14145)){
var statearr_14157_14297 = state_14154__$1;
(statearr_14157_14297[(1)] = (5));

} else {
var statearr_14158_14298 = state_14154__$1;
(statearr_14158_14298[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14155 === (5))){
var state_14154__$1 = state_14154;
var statearr_14159_14299 = state_14154__$1;
(statearr_14159_14299[(2)] = null);

(statearr_14159_14299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14155 === (6))){
var state_14154__$1 = state_14154;
var statearr_14160_14300 = state_14154__$1;
(statearr_14160_14300[(2)] = null);

(statearr_14160_14300[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14155 === (7))){
var inst_14150 = (state_14154[(2)]);
var state_14154__$1 = state_14154;
var statearr_14161_14301 = state_14154__$1;
(statearr_14161_14301[(2)] = inst_14150);

(statearr_14161_14301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14283,c__7694__auto___14295,G__14114_14284,n__5472__auto___14282,jobs,results,process,async))
;
return ((function (__14283,switch__7673__auto__,c__7694__auto___14295,G__14114_14284,n__5472__auto___14282,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14165 = [null,null,null,null,null,null,null];
(statearr_14165[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14165[(1)] = (1));

return statearr_14165;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14154){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14154);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14166){if((e14166 instanceof Object)){
var ex__7677__auto__ = e14166;
var statearr_14167_14302 = state_14154;
(statearr_14167_14302[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14154);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14166;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14303 = state_14154;
state_14154 = G__14303;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14154){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(__14283,switch__7673__auto__,c__7694__auto___14295,G__14114_14284,n__5472__auto___14282,jobs,results,process,async))
})();
var state__7696__auto__ = (function (){var statearr_14168 = f__7695__auto__.call(null);
(statearr_14168[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14295);

return statearr_14168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(__14283,c__7694__auto___14295,G__14114_14284,n__5472__auto___14282,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__14304 = (__14283 + (1));
__14283 = G__14304;
continue;
} else {
}
break;
}

var c__7694__auto___14305 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___14305,jobs,results,process,async){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___14305,jobs,results,process,async){
return (function (state_14190){
var state_val_14191 = (state_14190[(1)]);
if((state_val_14191 === (1))){
var state_14190__$1 = state_14190;
var statearr_14192_14306 = state_14190__$1;
(statearr_14192_14306[(2)] = null);

(statearr_14192_14306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14191 === (2))){
var state_14190__$1 = state_14190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14190__$1,(4),from);
} else {
if((state_val_14191 === (3))){
var inst_14188 = (state_14190[(2)]);
var state_14190__$1 = state_14190;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14190__$1,inst_14188);
} else {
if((state_val_14191 === (4))){
var inst_14171 = (state_14190[(7)]);
var inst_14171__$1 = (state_14190[(2)]);
var inst_14172 = (inst_14171__$1 == null);
var state_14190__$1 = (function (){var statearr_14193 = state_14190;
(statearr_14193[(7)] = inst_14171__$1);

return statearr_14193;
})();
if(cljs.core.truth_(inst_14172)){
var statearr_14194_14307 = state_14190__$1;
(statearr_14194_14307[(1)] = (5));

} else {
var statearr_14195_14308 = state_14190__$1;
(statearr_14195_14308[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14191 === (5))){
var inst_14174 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14190__$1 = state_14190;
var statearr_14196_14309 = state_14190__$1;
(statearr_14196_14309[(2)] = inst_14174);

(statearr_14196_14309[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14191 === (6))){
var inst_14171 = (state_14190[(7)]);
var inst_14176 = (state_14190[(8)]);
var inst_14176__$1 = cljs.core.async.chan.call(null,(1));
var inst_14177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14178 = [inst_14171,inst_14176__$1];
var inst_14179 = (new cljs.core.PersistentVector(null,2,(5),inst_14177,inst_14178,null));
var state_14190__$1 = (function (){var statearr_14197 = state_14190;
(statearr_14197[(8)] = inst_14176__$1);

return statearr_14197;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14190__$1,(8),jobs,inst_14179);
} else {
if((state_val_14191 === (7))){
var inst_14186 = (state_14190[(2)]);
var state_14190__$1 = state_14190;
var statearr_14198_14310 = state_14190__$1;
(statearr_14198_14310[(2)] = inst_14186);

(statearr_14198_14310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14191 === (8))){
var inst_14176 = (state_14190[(8)]);
var inst_14181 = (state_14190[(2)]);
var state_14190__$1 = (function (){var statearr_14199 = state_14190;
(statearr_14199[(9)] = inst_14181);

return statearr_14199;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14190__$1,(9),results,inst_14176);
} else {
if((state_val_14191 === (9))){
var inst_14183 = (state_14190[(2)]);
var state_14190__$1 = (function (){var statearr_14200 = state_14190;
(statearr_14200[(10)] = inst_14183);

return statearr_14200;
})();
var statearr_14201_14311 = state_14190__$1;
(statearr_14201_14311[(2)] = null);

(statearr_14201_14311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___14305,jobs,results,process,async))
;
return ((function (switch__7673__auto__,c__7694__auto___14305,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14205 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14205[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14205[(1)] = (1));

return statearr_14205;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14190){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14190);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14206){if((e14206 instanceof Object)){
var ex__7677__auto__ = e14206;
var statearr_14207_14312 = state_14190;
(statearr_14207_14312[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14190);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14206;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14313 = state_14190;
state_14190 = G__14313;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14190){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___14305,jobs,results,process,async))
})();
var state__7696__auto__ = (function (){var statearr_14208 = f__7695__auto__.call(null);
(statearr_14208[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14305);

return statearr_14208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___14305,jobs,results,process,async))
);


var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__,jobs,results,process,async){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__,jobs,results,process,async){
return (function (state_14246){
var state_val_14247 = (state_14246[(1)]);
if((state_val_14247 === (7))){
var inst_14242 = (state_14246[(2)]);
var state_14246__$1 = state_14246;
var statearr_14248_14314 = state_14246__$1;
(statearr_14248_14314[(2)] = inst_14242);

(statearr_14248_14314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (20))){
var state_14246__$1 = state_14246;
var statearr_14249_14315 = state_14246__$1;
(statearr_14249_14315[(2)] = null);

(statearr_14249_14315[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (1))){
var state_14246__$1 = state_14246;
var statearr_14250_14316 = state_14246__$1;
(statearr_14250_14316[(2)] = null);

(statearr_14250_14316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (4))){
var inst_14211 = (state_14246[(7)]);
var inst_14211__$1 = (state_14246[(2)]);
var inst_14212 = (inst_14211__$1 == null);
var state_14246__$1 = (function (){var statearr_14251 = state_14246;
(statearr_14251[(7)] = inst_14211__$1);

return statearr_14251;
})();
if(cljs.core.truth_(inst_14212)){
var statearr_14252_14317 = state_14246__$1;
(statearr_14252_14317[(1)] = (5));

} else {
var statearr_14253_14318 = state_14246__$1;
(statearr_14253_14318[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (15))){
var inst_14224 = (state_14246[(8)]);
var state_14246__$1 = state_14246;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14246__$1,(18),to,inst_14224);
} else {
if((state_val_14247 === (21))){
var inst_14237 = (state_14246[(2)]);
var state_14246__$1 = state_14246;
var statearr_14254_14319 = state_14246__$1;
(statearr_14254_14319[(2)] = inst_14237);

(statearr_14254_14319[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (13))){
var inst_14239 = (state_14246[(2)]);
var state_14246__$1 = (function (){var statearr_14255 = state_14246;
(statearr_14255[(9)] = inst_14239);

return statearr_14255;
})();
var statearr_14256_14320 = state_14246__$1;
(statearr_14256_14320[(2)] = null);

(statearr_14256_14320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (6))){
var inst_14211 = (state_14246[(7)]);
var state_14246__$1 = state_14246;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14246__$1,(11),inst_14211);
} else {
if((state_val_14247 === (17))){
var inst_14232 = (state_14246[(2)]);
var state_14246__$1 = state_14246;
if(cljs.core.truth_(inst_14232)){
var statearr_14257_14321 = state_14246__$1;
(statearr_14257_14321[(1)] = (19));

} else {
var statearr_14258_14322 = state_14246__$1;
(statearr_14258_14322[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (3))){
var inst_14244 = (state_14246[(2)]);
var state_14246__$1 = state_14246;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14246__$1,inst_14244);
} else {
if((state_val_14247 === (12))){
var inst_14221 = (state_14246[(10)]);
var state_14246__$1 = state_14246;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14246__$1,(14),inst_14221);
} else {
if((state_val_14247 === (2))){
var state_14246__$1 = state_14246;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14246__$1,(4),results);
} else {
if((state_val_14247 === (19))){
var state_14246__$1 = state_14246;
var statearr_14259_14323 = state_14246__$1;
(statearr_14259_14323[(2)] = null);

(statearr_14259_14323[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (11))){
var inst_14221 = (state_14246[(2)]);
var state_14246__$1 = (function (){var statearr_14260 = state_14246;
(statearr_14260[(10)] = inst_14221);

return statearr_14260;
})();
var statearr_14261_14324 = state_14246__$1;
(statearr_14261_14324[(2)] = null);

(statearr_14261_14324[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (9))){
var state_14246__$1 = state_14246;
var statearr_14262_14325 = state_14246__$1;
(statearr_14262_14325[(2)] = null);

(statearr_14262_14325[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (5))){
var state_14246__$1 = state_14246;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14263_14326 = state_14246__$1;
(statearr_14263_14326[(1)] = (8));

} else {
var statearr_14264_14327 = state_14246__$1;
(statearr_14264_14327[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (14))){
var inst_14224 = (state_14246[(8)]);
var inst_14226 = (state_14246[(11)]);
var inst_14224__$1 = (state_14246[(2)]);
var inst_14225 = (inst_14224__$1 == null);
var inst_14226__$1 = cljs.core.not.call(null,inst_14225);
var state_14246__$1 = (function (){var statearr_14265 = state_14246;
(statearr_14265[(8)] = inst_14224__$1);

(statearr_14265[(11)] = inst_14226__$1);

return statearr_14265;
})();
if(inst_14226__$1){
var statearr_14266_14328 = state_14246__$1;
(statearr_14266_14328[(1)] = (15));

} else {
var statearr_14267_14329 = state_14246__$1;
(statearr_14267_14329[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (16))){
var inst_14226 = (state_14246[(11)]);
var state_14246__$1 = state_14246;
var statearr_14268_14330 = state_14246__$1;
(statearr_14268_14330[(2)] = inst_14226);

(statearr_14268_14330[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (10))){
var inst_14218 = (state_14246[(2)]);
var state_14246__$1 = state_14246;
var statearr_14269_14331 = state_14246__$1;
(statearr_14269_14331[(2)] = inst_14218);

(statearr_14269_14331[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (18))){
var inst_14229 = (state_14246[(2)]);
var state_14246__$1 = state_14246;
var statearr_14270_14332 = state_14246__$1;
(statearr_14270_14332[(2)] = inst_14229);

(statearr_14270_14332[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14247 === (8))){
var inst_14215 = cljs.core.async.close_BANG_.call(null,to);
var state_14246__$1 = state_14246;
var statearr_14271_14333 = state_14246__$1;
(statearr_14271_14333[(2)] = inst_14215);

(statearr_14271_14333[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__,jobs,results,process,async))
;
return ((function (switch__7673__auto__,c__7694__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_14275 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14275[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__);

(statearr_14275[(1)] = (1));

return statearr_14275;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1 = (function (state_14246){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14246);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14276){if((e14276 instanceof Object)){
var ex__7677__auto__ = e14276;
var statearr_14277_14334 = state_14246;
(statearr_14277_14334[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14246);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14276;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14335 = state_14246;
state_14246 = G__14335;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__ = function(state_14246){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1.call(this,state_14246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__,jobs,results,process,async))
})();
var state__7696__auto__ = (function (){var statearr_14278 = f__7695__auto__.call(null);
(statearr_14278[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_14278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__,jobs,results,process,async))
);

return c__7694__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args14336 = [];
var len__5627__auto___14339 = arguments.length;
var i__5628__auto___14340 = (0);
while(true){
if((i__5628__auto___14340 < len__5627__auto___14339)){
args14336.push((arguments[i__5628__auto___14340]));

var G__14341 = (i__5628__auto___14340 + (1));
i__5628__auto___14340 = G__14341;
continue;
} else {
}
break;
}

var G__14338 = args14336.length;
switch (G__14338) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14336.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args14343 = [];
var len__5627__auto___14346 = arguments.length;
var i__5628__auto___14347 = (0);
while(true){
if((i__5628__auto___14347 < len__5627__auto___14346)){
args14343.push((arguments[i__5628__auto___14347]));

var G__14348 = (i__5628__auto___14347 + (1));
i__5628__auto___14347 = G__14348;
continue;
} else {
}
break;
}

var G__14345 = args14343.length;
switch (G__14345) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14343.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args14350 = [];
var len__5627__auto___14403 = arguments.length;
var i__5628__auto___14404 = (0);
while(true){
if((i__5628__auto___14404 < len__5627__auto___14403)){
args14350.push((arguments[i__5628__auto___14404]));

var G__14405 = (i__5628__auto___14404 + (1));
i__5628__auto___14404 = G__14405;
continue;
} else {
}
break;
}

var G__14352 = args14350.length;
switch (G__14352) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14350.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__7694__auto___14407 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___14407,tc,fc){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___14407,tc,fc){
return (function (state_14378){
var state_val_14379 = (state_14378[(1)]);
if((state_val_14379 === (7))){
var inst_14374 = (state_14378[(2)]);
var state_14378__$1 = state_14378;
var statearr_14380_14408 = state_14378__$1;
(statearr_14380_14408[(2)] = inst_14374);

(statearr_14380_14408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14379 === (1))){
var state_14378__$1 = state_14378;
var statearr_14381_14409 = state_14378__$1;
(statearr_14381_14409[(2)] = null);

(statearr_14381_14409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14379 === (4))){
var inst_14355 = (state_14378[(7)]);
var inst_14355__$1 = (state_14378[(2)]);
var inst_14356 = (inst_14355__$1 == null);
var state_14378__$1 = (function (){var statearr_14382 = state_14378;
(statearr_14382[(7)] = inst_14355__$1);

return statearr_14382;
})();
if(cljs.core.truth_(inst_14356)){
var statearr_14383_14410 = state_14378__$1;
(statearr_14383_14410[(1)] = (5));

} else {
var statearr_14384_14411 = state_14378__$1;
(statearr_14384_14411[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14379 === (13))){
var state_14378__$1 = state_14378;
var statearr_14385_14412 = state_14378__$1;
(statearr_14385_14412[(2)] = null);

(statearr_14385_14412[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14379 === (6))){
var inst_14355 = (state_14378[(7)]);
var inst_14361 = p.call(null,inst_14355);
var state_14378__$1 = state_14378;
if(cljs.core.truth_(inst_14361)){
var statearr_14386_14413 = state_14378__$1;
(statearr_14386_14413[(1)] = (9));

} else {
var statearr_14387_14414 = state_14378__$1;
(statearr_14387_14414[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14379 === (3))){
var inst_14376 = (state_14378[(2)]);
var state_14378__$1 = state_14378;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14378__$1,inst_14376);
} else {
if((state_val_14379 === (12))){
var state_14378__$1 = state_14378;
var statearr_14388_14415 = state_14378__$1;
(statearr_14388_14415[(2)] = null);

(statearr_14388_14415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14379 === (2))){
var state_14378__$1 = state_14378;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14378__$1,(4),ch);
} else {
if((state_val_14379 === (11))){
var inst_14355 = (state_14378[(7)]);
var inst_14365 = (state_14378[(2)]);
var state_14378__$1 = state_14378;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14378__$1,(8),inst_14365,inst_14355);
} else {
if((state_val_14379 === (9))){
var state_14378__$1 = state_14378;
var statearr_14389_14416 = state_14378__$1;
(statearr_14389_14416[(2)] = tc);

(statearr_14389_14416[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14379 === (5))){
var inst_14358 = cljs.core.async.close_BANG_.call(null,tc);
var inst_14359 = cljs.core.async.close_BANG_.call(null,fc);
var state_14378__$1 = (function (){var statearr_14390 = state_14378;
(statearr_14390[(8)] = inst_14358);

return statearr_14390;
})();
var statearr_14391_14417 = state_14378__$1;
(statearr_14391_14417[(2)] = inst_14359);

(statearr_14391_14417[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14379 === (14))){
var inst_14372 = (state_14378[(2)]);
var state_14378__$1 = state_14378;
var statearr_14392_14418 = state_14378__$1;
(statearr_14392_14418[(2)] = inst_14372);

(statearr_14392_14418[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14379 === (10))){
var state_14378__$1 = state_14378;
var statearr_14393_14419 = state_14378__$1;
(statearr_14393_14419[(2)] = fc);

(statearr_14393_14419[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14379 === (8))){
var inst_14367 = (state_14378[(2)]);
var state_14378__$1 = state_14378;
if(cljs.core.truth_(inst_14367)){
var statearr_14394_14420 = state_14378__$1;
(statearr_14394_14420[(1)] = (12));

} else {
var statearr_14395_14421 = state_14378__$1;
(statearr_14395_14421[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___14407,tc,fc))
;
return ((function (switch__7673__auto__,c__7694__auto___14407,tc,fc){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_14399 = [null,null,null,null,null,null,null,null,null];
(statearr_14399[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_14399[(1)] = (1));

return statearr_14399;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_14378){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14378);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14400){if((e14400 instanceof Object)){
var ex__7677__auto__ = e14400;
var statearr_14401_14422 = state_14378;
(statearr_14401_14422[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14378);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14400;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14423 = state_14378;
state_14378 = G__14423;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_14378){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_14378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___14407,tc,fc))
})();
var state__7696__auto__ = (function (){var statearr_14402 = f__7695__auto__.call(null);
(statearr_14402[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___14407);

return statearr_14402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___14407,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__){
return (function (state_14470){
var state_val_14471 = (state_14470[(1)]);
if((state_val_14471 === (1))){
var inst_14456 = init;
var state_14470__$1 = (function (){var statearr_14472 = state_14470;
(statearr_14472[(7)] = inst_14456);

return statearr_14472;
})();
var statearr_14473_14488 = state_14470__$1;
(statearr_14473_14488[(2)] = null);

(statearr_14473_14488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (2))){
var state_14470__$1 = state_14470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14470__$1,(4),ch);
} else {
if((state_val_14471 === (3))){
var inst_14468 = (state_14470[(2)]);
var state_14470__$1 = state_14470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14470__$1,inst_14468);
} else {
if((state_val_14471 === (4))){
var inst_14459 = (state_14470[(8)]);
var inst_14459__$1 = (state_14470[(2)]);
var inst_14460 = (inst_14459__$1 == null);
var state_14470__$1 = (function (){var statearr_14474 = state_14470;
(statearr_14474[(8)] = inst_14459__$1);

return statearr_14474;
})();
if(cljs.core.truth_(inst_14460)){
var statearr_14475_14489 = state_14470__$1;
(statearr_14475_14489[(1)] = (5));

} else {
var statearr_14476_14490 = state_14470__$1;
(statearr_14476_14490[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (5))){
var inst_14456 = (state_14470[(7)]);
var state_14470__$1 = state_14470;
var statearr_14477_14491 = state_14470__$1;
(statearr_14477_14491[(2)] = inst_14456);

(statearr_14477_14491[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (6))){
var inst_14456 = (state_14470[(7)]);
var inst_14459 = (state_14470[(8)]);
var inst_14463 = f.call(null,inst_14456,inst_14459);
var inst_14456__$1 = inst_14463;
var state_14470__$1 = (function (){var statearr_14478 = state_14470;
(statearr_14478[(7)] = inst_14456__$1);

return statearr_14478;
})();
var statearr_14479_14492 = state_14470__$1;
(statearr_14479_14492[(2)] = null);

(statearr_14479_14492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (7))){
var inst_14466 = (state_14470[(2)]);
var state_14470__$1 = state_14470;
var statearr_14480_14493 = state_14470__$1;
(statearr_14480_14493[(2)] = inst_14466);

(statearr_14480_14493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__7694__auto__))
;
return ((function (switch__7673__auto__,c__7694__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__7674__auto__ = null;
var cljs$core$async$reduce_$_state_machine__7674__auto____0 = (function (){
var statearr_14484 = [null,null,null,null,null,null,null,null,null];
(statearr_14484[(0)] = cljs$core$async$reduce_$_state_machine__7674__auto__);

(statearr_14484[(1)] = (1));

return statearr_14484;
});
var cljs$core$async$reduce_$_state_machine__7674__auto____1 = (function (state_14470){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14485){if((e14485 instanceof Object)){
var ex__7677__auto__ = e14485;
var statearr_14486_14494 = state_14470;
(statearr_14486_14494[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14470);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14485;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14495 = state_14470;
state_14470 = G__14495;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__7674__auto__ = function(state_14470){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__7674__auto____1.call(this,state_14470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__7674__auto____0;
cljs$core$async$reduce_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__7674__auto____1;
return cljs$core$async$reduce_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__))
})();
var state__7696__auto__ = (function (){var statearr_14487 = f__7695__auto__.call(null);
(statearr_14487[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_14487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__))
);

return c__7694__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args14496 = [];
var len__5627__auto___14548 = arguments.length;
var i__5628__auto___14549 = (0);
while(true){
if((i__5628__auto___14549 < len__5627__auto___14548)){
args14496.push((arguments[i__5628__auto___14549]));

var G__14550 = (i__5628__auto___14549 + (1));
i__5628__auto___14549 = G__14550;
continue;
} else {
}
break;
}

var G__14498 = args14496.length;
switch (G__14498) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14496.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__){
return (function (state_14523){
var state_val_14524 = (state_14523[(1)]);
if((state_val_14524 === (7))){
var inst_14505 = (state_14523[(2)]);
var state_14523__$1 = state_14523;
var statearr_14525_14552 = state_14523__$1;
(statearr_14525_14552[(2)] = inst_14505);

(statearr_14525_14552[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14524 === (1))){
var inst_14499 = cljs.core.seq.call(null,coll);
var inst_14500 = inst_14499;
var state_14523__$1 = (function (){var statearr_14526 = state_14523;
(statearr_14526[(7)] = inst_14500);

return statearr_14526;
})();
var statearr_14527_14553 = state_14523__$1;
(statearr_14527_14553[(2)] = null);

(statearr_14527_14553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14524 === (4))){
var inst_14500 = (state_14523[(7)]);
var inst_14503 = cljs.core.first.call(null,inst_14500);
var state_14523__$1 = state_14523;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14523__$1,(7),ch,inst_14503);
} else {
if((state_val_14524 === (13))){
var inst_14517 = (state_14523[(2)]);
var state_14523__$1 = state_14523;
var statearr_14528_14554 = state_14523__$1;
(statearr_14528_14554[(2)] = inst_14517);

(statearr_14528_14554[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14524 === (6))){
var inst_14508 = (state_14523[(2)]);
var state_14523__$1 = state_14523;
if(cljs.core.truth_(inst_14508)){
var statearr_14529_14555 = state_14523__$1;
(statearr_14529_14555[(1)] = (8));

} else {
var statearr_14530_14556 = state_14523__$1;
(statearr_14530_14556[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14524 === (3))){
var inst_14521 = (state_14523[(2)]);
var state_14523__$1 = state_14523;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14523__$1,inst_14521);
} else {
if((state_val_14524 === (12))){
var state_14523__$1 = state_14523;
var statearr_14531_14557 = state_14523__$1;
(statearr_14531_14557[(2)] = null);

(statearr_14531_14557[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14524 === (2))){
var inst_14500 = (state_14523[(7)]);
var state_14523__$1 = state_14523;
if(cljs.core.truth_(inst_14500)){
var statearr_14532_14558 = state_14523__$1;
(statearr_14532_14558[(1)] = (4));

} else {
var statearr_14533_14559 = state_14523__$1;
(statearr_14533_14559[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14524 === (11))){
var inst_14514 = cljs.core.async.close_BANG_.call(null,ch);
var state_14523__$1 = state_14523;
var statearr_14534_14560 = state_14523__$1;
(statearr_14534_14560[(2)] = inst_14514);

(statearr_14534_14560[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14524 === (9))){
var state_14523__$1 = state_14523;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14535_14561 = state_14523__$1;
(statearr_14535_14561[(1)] = (11));

} else {
var statearr_14536_14562 = state_14523__$1;
(statearr_14536_14562[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14524 === (5))){
var inst_14500 = (state_14523[(7)]);
var state_14523__$1 = state_14523;
var statearr_14537_14563 = state_14523__$1;
(statearr_14537_14563[(2)] = inst_14500);

(statearr_14537_14563[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14524 === (10))){
var inst_14519 = (state_14523[(2)]);
var state_14523__$1 = state_14523;
var statearr_14538_14564 = state_14523__$1;
(statearr_14538_14564[(2)] = inst_14519);

(statearr_14538_14564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14524 === (8))){
var inst_14500 = (state_14523[(7)]);
var inst_14510 = cljs.core.next.call(null,inst_14500);
var inst_14500__$1 = inst_14510;
var state_14523__$1 = (function (){var statearr_14539 = state_14523;
(statearr_14539[(7)] = inst_14500__$1);

return statearr_14539;
})();
var statearr_14540_14565 = state_14523__$1;
(statearr_14540_14565[(2)] = null);

(statearr_14540_14565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__))
;
return ((function (switch__7673__auto__,c__7694__auto__){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_14544 = [null,null,null,null,null,null,null,null];
(statearr_14544[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_14544[(1)] = (1));

return statearr_14544;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_14523){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14523);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e14545){if((e14545 instanceof Object)){
var ex__7677__auto__ = e14545;
var statearr_14546_14566 = state_14523;
(statearr_14546_14566[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14523);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14545;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14567 = state_14523;
state_14523 = G__14567;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_14523){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_14523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__))
})();
var state__7696__auto__ = (function (){var statearr_14547 = f__7695__auto__.call(null);
(statearr_14547[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_14547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__))
);

return c__7694__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5224__auto__ = (((_ == null))?null:_);
var m__5225__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,_);
} else {
var m__5225__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async14789 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14789 = (function (mult,ch,cs,meta14790){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta14790 = meta14790;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14789.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_14791,meta14790__$1){
var self__ = this;
var _14791__$1 = this;
return (new cljs.core.async.t_cljs$core$async14789(self__.mult,self__.ch,self__.cs,meta14790__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async14789.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_14791){
var self__ = this;
var _14791__$1 = this;
return self__.meta14790;
});})(cs))
;

cljs.core.async.t_cljs$core$async14789.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async14789.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async14789.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async14789.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14789.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14789.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14789.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta14790","meta14790",-1063721191,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async14789.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14789.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14789";

cljs.core.async.t_cljs$core$async14789.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async14789");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async14789 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async14789(mult__$1,ch__$1,cs__$1,meta14790){
return (new cljs.core.async.t_cljs$core$async14789(mult__$1,ch__$1,cs__$1,meta14790));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async14789(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__7694__auto___15010 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15010,cs,m,dchan,dctr,done){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15010,cs,m,dchan,dctr,done){
return (function (state_14922){
var state_val_14923 = (state_14922[(1)]);
if((state_val_14923 === (7))){
var inst_14918 = (state_14922[(2)]);
var state_14922__$1 = state_14922;
var statearr_14924_15011 = state_14922__$1;
(statearr_14924_15011[(2)] = inst_14918);

(statearr_14924_15011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (20))){
var inst_14823 = (state_14922[(7)]);
var inst_14833 = cljs.core.first.call(null,inst_14823);
var inst_14834 = cljs.core.nth.call(null,inst_14833,(0),null);
var inst_14835 = cljs.core.nth.call(null,inst_14833,(1),null);
var state_14922__$1 = (function (){var statearr_14925 = state_14922;
(statearr_14925[(8)] = inst_14834);

return statearr_14925;
})();
if(cljs.core.truth_(inst_14835)){
var statearr_14926_15012 = state_14922__$1;
(statearr_14926_15012[(1)] = (22));

} else {
var statearr_14927_15013 = state_14922__$1;
(statearr_14927_15013[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (27))){
var inst_14865 = (state_14922[(9)]);
var inst_14794 = (state_14922[(10)]);
var inst_14863 = (state_14922[(11)]);
var inst_14870 = (state_14922[(12)]);
var inst_14870__$1 = cljs.core._nth.call(null,inst_14863,inst_14865);
var inst_14871 = cljs.core.async.put_BANG_.call(null,inst_14870__$1,inst_14794,done);
var state_14922__$1 = (function (){var statearr_14928 = state_14922;
(statearr_14928[(12)] = inst_14870__$1);

return statearr_14928;
})();
if(cljs.core.truth_(inst_14871)){
var statearr_14929_15014 = state_14922__$1;
(statearr_14929_15014[(1)] = (30));

} else {
var statearr_14930_15015 = state_14922__$1;
(statearr_14930_15015[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (1))){
var state_14922__$1 = state_14922;
var statearr_14931_15016 = state_14922__$1;
(statearr_14931_15016[(2)] = null);

(statearr_14931_15016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (24))){
var inst_14823 = (state_14922[(7)]);
var inst_14840 = (state_14922[(2)]);
var inst_14841 = cljs.core.next.call(null,inst_14823);
var inst_14803 = inst_14841;
var inst_14804 = null;
var inst_14805 = (0);
var inst_14806 = (0);
var state_14922__$1 = (function (){var statearr_14932 = state_14922;
(statearr_14932[(13)] = inst_14840);

(statearr_14932[(14)] = inst_14804);

(statearr_14932[(15)] = inst_14805);

(statearr_14932[(16)] = inst_14803);

(statearr_14932[(17)] = inst_14806);

return statearr_14932;
})();
var statearr_14933_15017 = state_14922__$1;
(statearr_14933_15017[(2)] = null);

(statearr_14933_15017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (39))){
var state_14922__$1 = state_14922;
var statearr_14937_15018 = state_14922__$1;
(statearr_14937_15018[(2)] = null);

(statearr_14937_15018[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (4))){
var inst_14794 = (state_14922[(10)]);
var inst_14794__$1 = (state_14922[(2)]);
var inst_14795 = (inst_14794__$1 == null);
var state_14922__$1 = (function (){var statearr_14938 = state_14922;
(statearr_14938[(10)] = inst_14794__$1);

return statearr_14938;
})();
if(cljs.core.truth_(inst_14795)){
var statearr_14939_15019 = state_14922__$1;
(statearr_14939_15019[(1)] = (5));

} else {
var statearr_14940_15020 = state_14922__$1;
(statearr_14940_15020[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (15))){
var inst_14804 = (state_14922[(14)]);
var inst_14805 = (state_14922[(15)]);
var inst_14803 = (state_14922[(16)]);
var inst_14806 = (state_14922[(17)]);
var inst_14819 = (state_14922[(2)]);
var inst_14820 = (inst_14806 + (1));
var tmp14934 = inst_14804;
var tmp14935 = inst_14805;
var tmp14936 = inst_14803;
var inst_14803__$1 = tmp14936;
var inst_14804__$1 = tmp14934;
var inst_14805__$1 = tmp14935;
var inst_14806__$1 = inst_14820;
var state_14922__$1 = (function (){var statearr_14941 = state_14922;
(statearr_14941[(18)] = inst_14819);

(statearr_14941[(14)] = inst_14804__$1);

(statearr_14941[(15)] = inst_14805__$1);

(statearr_14941[(16)] = inst_14803__$1);

(statearr_14941[(17)] = inst_14806__$1);

return statearr_14941;
})();
var statearr_14942_15021 = state_14922__$1;
(statearr_14942_15021[(2)] = null);

(statearr_14942_15021[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (21))){
var inst_14844 = (state_14922[(2)]);
var state_14922__$1 = state_14922;
var statearr_14946_15022 = state_14922__$1;
(statearr_14946_15022[(2)] = inst_14844);

(statearr_14946_15022[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (31))){
var inst_14870 = (state_14922[(12)]);
var inst_14874 = done.call(null,null);
var inst_14875 = cljs.core.async.untap_STAR_.call(null,m,inst_14870);
var state_14922__$1 = (function (){var statearr_14947 = state_14922;
(statearr_14947[(19)] = inst_14874);

return statearr_14947;
})();
var statearr_14948_15023 = state_14922__$1;
(statearr_14948_15023[(2)] = inst_14875);

(statearr_14948_15023[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (32))){
var inst_14864 = (state_14922[(20)]);
var inst_14862 = (state_14922[(21)]);
var inst_14865 = (state_14922[(9)]);
var inst_14863 = (state_14922[(11)]);
var inst_14877 = (state_14922[(2)]);
var inst_14878 = (inst_14865 + (1));
var tmp14943 = inst_14864;
var tmp14944 = inst_14862;
var tmp14945 = inst_14863;
var inst_14862__$1 = tmp14944;
var inst_14863__$1 = tmp14945;
var inst_14864__$1 = tmp14943;
var inst_14865__$1 = inst_14878;
var state_14922__$1 = (function (){var statearr_14949 = state_14922;
(statearr_14949[(20)] = inst_14864__$1);

(statearr_14949[(21)] = inst_14862__$1);

(statearr_14949[(9)] = inst_14865__$1);

(statearr_14949[(11)] = inst_14863__$1);

(statearr_14949[(22)] = inst_14877);

return statearr_14949;
})();
var statearr_14950_15024 = state_14922__$1;
(statearr_14950_15024[(2)] = null);

(statearr_14950_15024[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (40))){
var inst_14890 = (state_14922[(23)]);
var inst_14894 = done.call(null,null);
var inst_14895 = cljs.core.async.untap_STAR_.call(null,m,inst_14890);
var state_14922__$1 = (function (){var statearr_14951 = state_14922;
(statearr_14951[(24)] = inst_14894);

return statearr_14951;
})();
var statearr_14952_15025 = state_14922__$1;
(statearr_14952_15025[(2)] = inst_14895);

(statearr_14952_15025[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (33))){
var inst_14881 = (state_14922[(25)]);
var inst_14883 = cljs.core.chunked_seq_QMARK_.call(null,inst_14881);
var state_14922__$1 = state_14922;
if(inst_14883){
var statearr_14953_15026 = state_14922__$1;
(statearr_14953_15026[(1)] = (36));

} else {
var statearr_14954_15027 = state_14922__$1;
(statearr_14954_15027[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (13))){
var inst_14813 = (state_14922[(26)]);
var inst_14816 = cljs.core.async.close_BANG_.call(null,inst_14813);
var state_14922__$1 = state_14922;
var statearr_14955_15028 = state_14922__$1;
(statearr_14955_15028[(2)] = inst_14816);

(statearr_14955_15028[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (22))){
var inst_14834 = (state_14922[(8)]);
var inst_14837 = cljs.core.async.close_BANG_.call(null,inst_14834);
var state_14922__$1 = state_14922;
var statearr_14956_15029 = state_14922__$1;
(statearr_14956_15029[(2)] = inst_14837);

(statearr_14956_15029[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (36))){
var inst_14881 = (state_14922[(25)]);
var inst_14885 = cljs.core.chunk_first.call(null,inst_14881);
var inst_14886 = cljs.core.chunk_rest.call(null,inst_14881);
var inst_14887 = cljs.core.count.call(null,inst_14885);
var inst_14862 = inst_14886;
var inst_14863 = inst_14885;
var inst_14864 = inst_14887;
var inst_14865 = (0);
var state_14922__$1 = (function (){var statearr_14957 = state_14922;
(statearr_14957[(20)] = inst_14864);

(statearr_14957[(21)] = inst_14862);

(statearr_14957[(9)] = inst_14865);

(statearr_14957[(11)] = inst_14863);

return statearr_14957;
})();
var statearr_14958_15030 = state_14922__$1;
(statearr_14958_15030[(2)] = null);

(statearr_14958_15030[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (41))){
var inst_14881 = (state_14922[(25)]);
var inst_14897 = (state_14922[(2)]);
var inst_14898 = cljs.core.next.call(null,inst_14881);
var inst_14862 = inst_14898;
var inst_14863 = null;
var inst_14864 = (0);
var inst_14865 = (0);
var state_14922__$1 = (function (){var statearr_14959 = state_14922;
(statearr_14959[(20)] = inst_14864);

(statearr_14959[(21)] = inst_14862);

(statearr_14959[(9)] = inst_14865);

(statearr_14959[(11)] = inst_14863);

(statearr_14959[(27)] = inst_14897);

return statearr_14959;
})();
var statearr_14960_15031 = state_14922__$1;
(statearr_14960_15031[(2)] = null);

(statearr_14960_15031[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (43))){
var state_14922__$1 = state_14922;
var statearr_14961_15032 = state_14922__$1;
(statearr_14961_15032[(2)] = null);

(statearr_14961_15032[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (29))){
var inst_14906 = (state_14922[(2)]);
var state_14922__$1 = state_14922;
var statearr_14962_15033 = state_14922__$1;
(statearr_14962_15033[(2)] = inst_14906);

(statearr_14962_15033[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (44))){
var inst_14915 = (state_14922[(2)]);
var state_14922__$1 = (function (){var statearr_14963 = state_14922;
(statearr_14963[(28)] = inst_14915);

return statearr_14963;
})();
var statearr_14964_15034 = state_14922__$1;
(statearr_14964_15034[(2)] = null);

(statearr_14964_15034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (6))){
var inst_14854 = (state_14922[(29)]);
var inst_14853 = cljs.core.deref.call(null,cs);
var inst_14854__$1 = cljs.core.keys.call(null,inst_14853);
var inst_14855 = cljs.core.count.call(null,inst_14854__$1);
var inst_14856 = cljs.core.reset_BANG_.call(null,dctr,inst_14855);
var inst_14861 = cljs.core.seq.call(null,inst_14854__$1);
var inst_14862 = inst_14861;
var inst_14863 = null;
var inst_14864 = (0);
var inst_14865 = (0);
var state_14922__$1 = (function (){var statearr_14965 = state_14922;
(statearr_14965[(20)] = inst_14864);

(statearr_14965[(21)] = inst_14862);

(statearr_14965[(9)] = inst_14865);

(statearr_14965[(29)] = inst_14854__$1);

(statearr_14965[(11)] = inst_14863);

(statearr_14965[(30)] = inst_14856);

return statearr_14965;
})();
var statearr_14966_15035 = state_14922__$1;
(statearr_14966_15035[(2)] = null);

(statearr_14966_15035[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (28))){
var inst_14862 = (state_14922[(21)]);
var inst_14881 = (state_14922[(25)]);
var inst_14881__$1 = cljs.core.seq.call(null,inst_14862);
var state_14922__$1 = (function (){var statearr_14967 = state_14922;
(statearr_14967[(25)] = inst_14881__$1);

return statearr_14967;
})();
if(inst_14881__$1){
var statearr_14968_15036 = state_14922__$1;
(statearr_14968_15036[(1)] = (33));

} else {
var statearr_14969_15037 = state_14922__$1;
(statearr_14969_15037[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (25))){
var inst_14864 = (state_14922[(20)]);
var inst_14865 = (state_14922[(9)]);
var inst_14867 = (inst_14865 < inst_14864);
var inst_14868 = inst_14867;
var state_14922__$1 = state_14922;
if(cljs.core.truth_(inst_14868)){
var statearr_14970_15038 = state_14922__$1;
(statearr_14970_15038[(1)] = (27));

} else {
var statearr_14971_15039 = state_14922__$1;
(statearr_14971_15039[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (34))){
var state_14922__$1 = state_14922;
var statearr_14972_15040 = state_14922__$1;
(statearr_14972_15040[(2)] = null);

(statearr_14972_15040[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (17))){
var state_14922__$1 = state_14922;
var statearr_14973_15041 = state_14922__$1;
(statearr_14973_15041[(2)] = null);

(statearr_14973_15041[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (3))){
var inst_14920 = (state_14922[(2)]);
var state_14922__$1 = state_14922;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14922__$1,inst_14920);
} else {
if((state_val_14923 === (12))){
var inst_14849 = (state_14922[(2)]);
var state_14922__$1 = state_14922;
var statearr_14974_15042 = state_14922__$1;
(statearr_14974_15042[(2)] = inst_14849);

(statearr_14974_15042[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (2))){
var state_14922__$1 = state_14922;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14922__$1,(4),ch);
} else {
if((state_val_14923 === (23))){
var state_14922__$1 = state_14922;
var statearr_14975_15043 = state_14922__$1;
(statearr_14975_15043[(2)] = null);

(statearr_14975_15043[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (35))){
var inst_14904 = (state_14922[(2)]);
var state_14922__$1 = state_14922;
var statearr_14976_15044 = state_14922__$1;
(statearr_14976_15044[(2)] = inst_14904);

(statearr_14976_15044[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (19))){
var inst_14823 = (state_14922[(7)]);
var inst_14827 = cljs.core.chunk_first.call(null,inst_14823);
var inst_14828 = cljs.core.chunk_rest.call(null,inst_14823);
var inst_14829 = cljs.core.count.call(null,inst_14827);
var inst_14803 = inst_14828;
var inst_14804 = inst_14827;
var inst_14805 = inst_14829;
var inst_14806 = (0);
var state_14922__$1 = (function (){var statearr_14977 = state_14922;
(statearr_14977[(14)] = inst_14804);

(statearr_14977[(15)] = inst_14805);

(statearr_14977[(16)] = inst_14803);

(statearr_14977[(17)] = inst_14806);

return statearr_14977;
})();
var statearr_14978_15045 = state_14922__$1;
(statearr_14978_15045[(2)] = null);

(statearr_14978_15045[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (11))){
var inst_14823 = (state_14922[(7)]);
var inst_14803 = (state_14922[(16)]);
var inst_14823__$1 = cljs.core.seq.call(null,inst_14803);
var state_14922__$1 = (function (){var statearr_14979 = state_14922;
(statearr_14979[(7)] = inst_14823__$1);

return statearr_14979;
})();
if(inst_14823__$1){
var statearr_14980_15046 = state_14922__$1;
(statearr_14980_15046[(1)] = (16));

} else {
var statearr_14981_15047 = state_14922__$1;
(statearr_14981_15047[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (9))){
var inst_14851 = (state_14922[(2)]);
var state_14922__$1 = state_14922;
var statearr_14982_15048 = state_14922__$1;
(statearr_14982_15048[(2)] = inst_14851);

(statearr_14982_15048[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (5))){
var inst_14801 = cljs.core.deref.call(null,cs);
var inst_14802 = cljs.core.seq.call(null,inst_14801);
var inst_14803 = inst_14802;
var inst_14804 = null;
var inst_14805 = (0);
var inst_14806 = (0);
var state_14922__$1 = (function (){var statearr_14983 = state_14922;
(statearr_14983[(14)] = inst_14804);

(statearr_14983[(15)] = inst_14805);

(statearr_14983[(16)] = inst_14803);

(statearr_14983[(17)] = inst_14806);

return statearr_14983;
})();
var statearr_14984_15049 = state_14922__$1;
(statearr_14984_15049[(2)] = null);

(statearr_14984_15049[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (14))){
var state_14922__$1 = state_14922;
var statearr_14985_15050 = state_14922__$1;
(statearr_14985_15050[(2)] = null);

(statearr_14985_15050[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (45))){
var inst_14912 = (state_14922[(2)]);
var state_14922__$1 = state_14922;
var statearr_14986_15051 = state_14922__$1;
(statearr_14986_15051[(2)] = inst_14912);

(statearr_14986_15051[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (26))){
var inst_14854 = (state_14922[(29)]);
var inst_14908 = (state_14922[(2)]);
var inst_14909 = cljs.core.seq.call(null,inst_14854);
var state_14922__$1 = (function (){var statearr_14987 = state_14922;
(statearr_14987[(31)] = inst_14908);

return statearr_14987;
})();
if(inst_14909){
var statearr_14988_15052 = state_14922__$1;
(statearr_14988_15052[(1)] = (42));

} else {
var statearr_14989_15053 = state_14922__$1;
(statearr_14989_15053[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (16))){
var inst_14823 = (state_14922[(7)]);
var inst_14825 = cljs.core.chunked_seq_QMARK_.call(null,inst_14823);
var state_14922__$1 = state_14922;
if(inst_14825){
var statearr_14990_15054 = state_14922__$1;
(statearr_14990_15054[(1)] = (19));

} else {
var statearr_14991_15055 = state_14922__$1;
(statearr_14991_15055[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (38))){
var inst_14901 = (state_14922[(2)]);
var state_14922__$1 = state_14922;
var statearr_14992_15056 = state_14922__$1;
(statearr_14992_15056[(2)] = inst_14901);

(statearr_14992_15056[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (30))){
var state_14922__$1 = state_14922;
var statearr_14993_15057 = state_14922__$1;
(statearr_14993_15057[(2)] = null);

(statearr_14993_15057[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (10))){
var inst_14804 = (state_14922[(14)]);
var inst_14806 = (state_14922[(17)]);
var inst_14812 = cljs.core._nth.call(null,inst_14804,inst_14806);
var inst_14813 = cljs.core.nth.call(null,inst_14812,(0),null);
var inst_14814 = cljs.core.nth.call(null,inst_14812,(1),null);
var state_14922__$1 = (function (){var statearr_14994 = state_14922;
(statearr_14994[(26)] = inst_14813);

return statearr_14994;
})();
if(cljs.core.truth_(inst_14814)){
var statearr_14995_15058 = state_14922__$1;
(statearr_14995_15058[(1)] = (13));

} else {
var statearr_14996_15059 = state_14922__$1;
(statearr_14996_15059[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (18))){
var inst_14847 = (state_14922[(2)]);
var state_14922__$1 = state_14922;
var statearr_14997_15060 = state_14922__$1;
(statearr_14997_15060[(2)] = inst_14847);

(statearr_14997_15060[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (42))){
var state_14922__$1 = state_14922;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14922__$1,(45),dchan);
} else {
if((state_val_14923 === (37))){
var inst_14794 = (state_14922[(10)]);
var inst_14881 = (state_14922[(25)]);
var inst_14890 = (state_14922[(23)]);
var inst_14890__$1 = cljs.core.first.call(null,inst_14881);
var inst_14891 = cljs.core.async.put_BANG_.call(null,inst_14890__$1,inst_14794,done);
var state_14922__$1 = (function (){var statearr_14998 = state_14922;
(statearr_14998[(23)] = inst_14890__$1);

return statearr_14998;
})();
if(cljs.core.truth_(inst_14891)){
var statearr_14999_15061 = state_14922__$1;
(statearr_14999_15061[(1)] = (39));

} else {
var statearr_15000_15062 = state_14922__$1;
(statearr_15000_15062[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14923 === (8))){
var inst_14805 = (state_14922[(15)]);
var inst_14806 = (state_14922[(17)]);
var inst_14808 = (inst_14806 < inst_14805);
var inst_14809 = inst_14808;
var state_14922__$1 = state_14922;
if(cljs.core.truth_(inst_14809)){
var statearr_15001_15063 = state_14922__$1;
(statearr_15001_15063[(1)] = (10));

} else {
var statearr_15002_15064 = state_14922__$1;
(statearr_15002_15064[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15010,cs,m,dchan,dctr,done))
;
return ((function (switch__7673__auto__,c__7694__auto___15010,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__7674__auto__ = null;
var cljs$core$async$mult_$_state_machine__7674__auto____0 = (function (){
var statearr_15006 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15006[(0)] = cljs$core$async$mult_$_state_machine__7674__auto__);

(statearr_15006[(1)] = (1));

return statearr_15006;
});
var cljs$core$async$mult_$_state_machine__7674__auto____1 = (function (state_14922){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_14922);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15007){if((e15007 instanceof Object)){
var ex__7677__auto__ = e15007;
var statearr_15008_15065 = state_14922;
(statearr_15008_15065[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14922);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15007;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15066 = state_14922;
state_14922 = G__15066;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__7674__auto__ = function(state_14922){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__7674__auto____1.call(this,state_14922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__7674__auto____0;
cljs$core$async$mult_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__7674__auto____1;
return cljs$core$async$mult_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15010,cs,m,dchan,dctr,done))
})();
var state__7696__auto__ = (function (){var statearr_15009 = f__7695__auto__.call(null);
(statearr_15009[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15010);

return statearr_15009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15010,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15067 = [];
var len__5627__auto___15070 = arguments.length;
var i__5628__auto___15071 = (0);
while(true){
if((i__5628__auto___15071 < len__5627__auto___15070)){
args15067.push((arguments[i__5628__auto___15071]));

var G__15072 = (i__5628__auto___15071 + (1));
i__5628__auto___15071 = G__15072;
continue;
} else {
}
break;
}

var G__15069 = args15067.length;
switch (G__15069) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15067.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,state_map);
} else {
var m__5225__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,mode);
} else {
var m__5225__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___15084 = arguments.length;
var i__5628__auto___15085 = (0);
while(true){
if((i__5628__auto___15085 < len__5627__auto___15084)){
args__5634__auto__.push((arguments[i__5628__auto___15085]));

var G__15086 = (i__5628__auto___15085 + (1));
i__5628__auto___15085 = G__15086;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15078){
var map__15079 = p__15078;
var map__15079__$1 = ((((!((map__15079 == null)))?((((map__15079.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15079.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15079):map__15079);
var opts = map__15079__$1;
var statearr_15081_15087 = state;
(statearr_15081_15087[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__15079,map__15079__$1,opts){
return (function (val){
var statearr_15082_15088 = state;
(statearr_15082_15088[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__15079,map__15079__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_15083_15089 = state;
(statearr_15083_15089[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15074){
var G__15075 = cljs.core.first.call(null,seq15074);
var seq15074__$1 = cljs.core.next.call(null,seq15074);
var G__15076 = cljs.core.first.call(null,seq15074__$1);
var seq15074__$2 = cljs.core.next.call(null,seq15074__$1);
var G__15077 = cljs.core.first.call(null,seq15074__$2);
var seq15074__$3 = cljs.core.next.call(null,seq15074__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15075,G__15076,G__15077,seq15074__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15253 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15253 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta15254){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta15254 = meta15254;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15253.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15255,meta15254__$1){
var self__ = this;
var _15255__$1 = this;
return (new cljs.core.async.t_cljs$core$async15253(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta15254__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15253.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15255){
var self__ = this;
var _15255__$1 = this;
return self__.meta15254;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15253.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15253.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15253.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async15253.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15253.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15253.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15253.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15253.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15253.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta15254","meta15254",-528431827,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15253.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15253.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15253";

cljs.core.async.t_cljs$core$async15253.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15253");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async15253 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async15253(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15254){
return (new cljs.core.async.t_cljs$core$async15253(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15254));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async15253(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7694__auto___15416 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15416,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15416,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_15353){
var state_val_15354 = (state_15353[(1)]);
if((state_val_15354 === (7))){
var inst_15271 = (state_15353[(2)]);
var state_15353__$1 = state_15353;
var statearr_15355_15417 = state_15353__$1;
(statearr_15355_15417[(2)] = inst_15271);

(statearr_15355_15417[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (20))){
var inst_15283 = (state_15353[(7)]);
var state_15353__$1 = state_15353;
var statearr_15356_15418 = state_15353__$1;
(statearr_15356_15418[(2)] = inst_15283);

(statearr_15356_15418[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (27))){
var state_15353__$1 = state_15353;
var statearr_15357_15419 = state_15353__$1;
(statearr_15357_15419[(2)] = null);

(statearr_15357_15419[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (1))){
var inst_15259 = (state_15353[(8)]);
var inst_15259__$1 = calc_state.call(null);
var inst_15261 = (inst_15259__$1 == null);
var inst_15262 = cljs.core.not.call(null,inst_15261);
var state_15353__$1 = (function (){var statearr_15358 = state_15353;
(statearr_15358[(8)] = inst_15259__$1);

return statearr_15358;
})();
if(inst_15262){
var statearr_15359_15420 = state_15353__$1;
(statearr_15359_15420[(1)] = (2));

} else {
var statearr_15360_15421 = state_15353__$1;
(statearr_15360_15421[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (24))){
var inst_15313 = (state_15353[(9)]);
var inst_15306 = (state_15353[(10)]);
var inst_15327 = (state_15353[(11)]);
var inst_15327__$1 = inst_15306.call(null,inst_15313);
var state_15353__$1 = (function (){var statearr_15361 = state_15353;
(statearr_15361[(11)] = inst_15327__$1);

return statearr_15361;
})();
if(cljs.core.truth_(inst_15327__$1)){
var statearr_15362_15422 = state_15353__$1;
(statearr_15362_15422[(1)] = (29));

} else {
var statearr_15363_15423 = state_15353__$1;
(statearr_15363_15423[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (4))){
var inst_15274 = (state_15353[(2)]);
var state_15353__$1 = state_15353;
if(cljs.core.truth_(inst_15274)){
var statearr_15364_15424 = state_15353__$1;
(statearr_15364_15424[(1)] = (8));

} else {
var statearr_15365_15425 = state_15353__$1;
(statearr_15365_15425[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (15))){
var inst_15300 = (state_15353[(2)]);
var state_15353__$1 = state_15353;
if(cljs.core.truth_(inst_15300)){
var statearr_15366_15426 = state_15353__$1;
(statearr_15366_15426[(1)] = (19));

} else {
var statearr_15367_15427 = state_15353__$1;
(statearr_15367_15427[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (21))){
var inst_15305 = (state_15353[(12)]);
var inst_15305__$1 = (state_15353[(2)]);
var inst_15306 = cljs.core.get.call(null,inst_15305__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_15307 = cljs.core.get.call(null,inst_15305__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_15308 = cljs.core.get.call(null,inst_15305__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_15353__$1 = (function (){var statearr_15368 = state_15353;
(statearr_15368[(13)] = inst_15307);

(statearr_15368[(12)] = inst_15305__$1);

(statearr_15368[(10)] = inst_15306);

return statearr_15368;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_15353__$1,(22),inst_15308);
} else {
if((state_val_15354 === (31))){
var inst_15335 = (state_15353[(2)]);
var state_15353__$1 = state_15353;
if(cljs.core.truth_(inst_15335)){
var statearr_15369_15428 = state_15353__$1;
(statearr_15369_15428[(1)] = (32));

} else {
var statearr_15370_15429 = state_15353__$1;
(statearr_15370_15429[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (32))){
var inst_15312 = (state_15353[(14)]);
var state_15353__$1 = state_15353;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15353__$1,(35),out,inst_15312);
} else {
if((state_val_15354 === (33))){
var inst_15305 = (state_15353[(12)]);
var inst_15283 = inst_15305;
var state_15353__$1 = (function (){var statearr_15371 = state_15353;
(statearr_15371[(7)] = inst_15283);

return statearr_15371;
})();
var statearr_15372_15430 = state_15353__$1;
(statearr_15372_15430[(2)] = null);

(statearr_15372_15430[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (13))){
var inst_15283 = (state_15353[(7)]);
var inst_15290 = inst_15283.cljs$lang$protocol_mask$partition0$;
var inst_15291 = (inst_15290 & (64));
var inst_15292 = inst_15283.cljs$core$ISeq$;
var inst_15293 = (inst_15291) || (inst_15292);
var state_15353__$1 = state_15353;
if(cljs.core.truth_(inst_15293)){
var statearr_15373_15431 = state_15353__$1;
(statearr_15373_15431[(1)] = (16));

} else {
var statearr_15374_15432 = state_15353__$1;
(statearr_15374_15432[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (22))){
var inst_15312 = (state_15353[(14)]);
var inst_15313 = (state_15353[(9)]);
var inst_15311 = (state_15353[(2)]);
var inst_15312__$1 = cljs.core.nth.call(null,inst_15311,(0),null);
var inst_15313__$1 = cljs.core.nth.call(null,inst_15311,(1),null);
var inst_15314 = (inst_15312__$1 == null);
var inst_15315 = cljs.core._EQ_.call(null,inst_15313__$1,change);
var inst_15316 = (inst_15314) || (inst_15315);
var state_15353__$1 = (function (){var statearr_15375 = state_15353;
(statearr_15375[(14)] = inst_15312__$1);

(statearr_15375[(9)] = inst_15313__$1);

return statearr_15375;
})();
if(cljs.core.truth_(inst_15316)){
var statearr_15376_15433 = state_15353__$1;
(statearr_15376_15433[(1)] = (23));

} else {
var statearr_15377_15434 = state_15353__$1;
(statearr_15377_15434[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (36))){
var inst_15305 = (state_15353[(12)]);
var inst_15283 = inst_15305;
var state_15353__$1 = (function (){var statearr_15378 = state_15353;
(statearr_15378[(7)] = inst_15283);

return statearr_15378;
})();
var statearr_15379_15435 = state_15353__$1;
(statearr_15379_15435[(2)] = null);

(statearr_15379_15435[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (29))){
var inst_15327 = (state_15353[(11)]);
var state_15353__$1 = state_15353;
var statearr_15380_15436 = state_15353__$1;
(statearr_15380_15436[(2)] = inst_15327);

(statearr_15380_15436[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (6))){
var state_15353__$1 = state_15353;
var statearr_15381_15437 = state_15353__$1;
(statearr_15381_15437[(2)] = false);

(statearr_15381_15437[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (28))){
var inst_15323 = (state_15353[(2)]);
var inst_15324 = calc_state.call(null);
var inst_15283 = inst_15324;
var state_15353__$1 = (function (){var statearr_15382 = state_15353;
(statearr_15382[(15)] = inst_15323);

(statearr_15382[(7)] = inst_15283);

return statearr_15382;
})();
var statearr_15383_15438 = state_15353__$1;
(statearr_15383_15438[(2)] = null);

(statearr_15383_15438[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (25))){
var inst_15349 = (state_15353[(2)]);
var state_15353__$1 = state_15353;
var statearr_15384_15439 = state_15353__$1;
(statearr_15384_15439[(2)] = inst_15349);

(statearr_15384_15439[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (34))){
var inst_15347 = (state_15353[(2)]);
var state_15353__$1 = state_15353;
var statearr_15385_15440 = state_15353__$1;
(statearr_15385_15440[(2)] = inst_15347);

(statearr_15385_15440[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (17))){
var state_15353__$1 = state_15353;
var statearr_15386_15441 = state_15353__$1;
(statearr_15386_15441[(2)] = false);

(statearr_15386_15441[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (3))){
var state_15353__$1 = state_15353;
var statearr_15387_15442 = state_15353__$1;
(statearr_15387_15442[(2)] = false);

(statearr_15387_15442[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (12))){
var inst_15351 = (state_15353[(2)]);
var state_15353__$1 = state_15353;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15353__$1,inst_15351);
} else {
if((state_val_15354 === (2))){
var inst_15259 = (state_15353[(8)]);
var inst_15264 = inst_15259.cljs$lang$protocol_mask$partition0$;
var inst_15265 = (inst_15264 & (64));
var inst_15266 = inst_15259.cljs$core$ISeq$;
var inst_15267 = (inst_15265) || (inst_15266);
var state_15353__$1 = state_15353;
if(cljs.core.truth_(inst_15267)){
var statearr_15388_15443 = state_15353__$1;
(statearr_15388_15443[(1)] = (5));

} else {
var statearr_15389_15444 = state_15353__$1;
(statearr_15389_15444[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (23))){
var inst_15312 = (state_15353[(14)]);
var inst_15318 = (inst_15312 == null);
var state_15353__$1 = state_15353;
if(cljs.core.truth_(inst_15318)){
var statearr_15390_15445 = state_15353__$1;
(statearr_15390_15445[(1)] = (26));

} else {
var statearr_15391_15446 = state_15353__$1;
(statearr_15391_15446[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (35))){
var inst_15338 = (state_15353[(2)]);
var state_15353__$1 = state_15353;
if(cljs.core.truth_(inst_15338)){
var statearr_15392_15447 = state_15353__$1;
(statearr_15392_15447[(1)] = (36));

} else {
var statearr_15393_15448 = state_15353__$1;
(statearr_15393_15448[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (19))){
var inst_15283 = (state_15353[(7)]);
var inst_15302 = cljs.core.apply.call(null,cljs.core.hash_map,inst_15283);
var state_15353__$1 = state_15353;
var statearr_15394_15449 = state_15353__$1;
(statearr_15394_15449[(2)] = inst_15302);

(statearr_15394_15449[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (11))){
var inst_15283 = (state_15353[(7)]);
var inst_15287 = (inst_15283 == null);
var inst_15288 = cljs.core.not.call(null,inst_15287);
var state_15353__$1 = state_15353;
if(inst_15288){
var statearr_15395_15450 = state_15353__$1;
(statearr_15395_15450[(1)] = (13));

} else {
var statearr_15396_15451 = state_15353__$1;
(statearr_15396_15451[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (9))){
var inst_15259 = (state_15353[(8)]);
var state_15353__$1 = state_15353;
var statearr_15397_15452 = state_15353__$1;
(statearr_15397_15452[(2)] = inst_15259);

(statearr_15397_15452[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (5))){
var state_15353__$1 = state_15353;
var statearr_15398_15453 = state_15353__$1;
(statearr_15398_15453[(2)] = true);

(statearr_15398_15453[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (14))){
var state_15353__$1 = state_15353;
var statearr_15399_15454 = state_15353__$1;
(statearr_15399_15454[(2)] = false);

(statearr_15399_15454[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (26))){
var inst_15313 = (state_15353[(9)]);
var inst_15320 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_15313);
var state_15353__$1 = state_15353;
var statearr_15400_15455 = state_15353__$1;
(statearr_15400_15455[(2)] = inst_15320);

(statearr_15400_15455[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (16))){
var state_15353__$1 = state_15353;
var statearr_15401_15456 = state_15353__$1;
(statearr_15401_15456[(2)] = true);

(statearr_15401_15456[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (38))){
var inst_15343 = (state_15353[(2)]);
var state_15353__$1 = state_15353;
var statearr_15402_15457 = state_15353__$1;
(statearr_15402_15457[(2)] = inst_15343);

(statearr_15402_15457[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (30))){
var inst_15307 = (state_15353[(13)]);
var inst_15313 = (state_15353[(9)]);
var inst_15306 = (state_15353[(10)]);
var inst_15330 = cljs.core.empty_QMARK_.call(null,inst_15306);
var inst_15331 = inst_15307.call(null,inst_15313);
var inst_15332 = cljs.core.not.call(null,inst_15331);
var inst_15333 = (inst_15330) && (inst_15332);
var state_15353__$1 = state_15353;
var statearr_15403_15458 = state_15353__$1;
(statearr_15403_15458[(2)] = inst_15333);

(statearr_15403_15458[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (10))){
var inst_15259 = (state_15353[(8)]);
var inst_15279 = (state_15353[(2)]);
var inst_15280 = cljs.core.get.call(null,inst_15279,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_15281 = cljs.core.get.call(null,inst_15279,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_15282 = cljs.core.get.call(null,inst_15279,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_15283 = inst_15259;
var state_15353__$1 = (function (){var statearr_15404 = state_15353;
(statearr_15404[(16)] = inst_15282);

(statearr_15404[(7)] = inst_15283);

(statearr_15404[(17)] = inst_15280);

(statearr_15404[(18)] = inst_15281);

return statearr_15404;
})();
var statearr_15405_15459 = state_15353__$1;
(statearr_15405_15459[(2)] = null);

(statearr_15405_15459[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (18))){
var inst_15297 = (state_15353[(2)]);
var state_15353__$1 = state_15353;
var statearr_15406_15460 = state_15353__$1;
(statearr_15406_15460[(2)] = inst_15297);

(statearr_15406_15460[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (37))){
var state_15353__$1 = state_15353;
var statearr_15407_15461 = state_15353__$1;
(statearr_15407_15461[(2)] = null);

(statearr_15407_15461[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15354 === (8))){
var inst_15259 = (state_15353[(8)]);
var inst_15276 = cljs.core.apply.call(null,cljs.core.hash_map,inst_15259);
var state_15353__$1 = state_15353;
var statearr_15408_15462 = state_15353__$1;
(statearr_15408_15462[(2)] = inst_15276);

(statearr_15408_15462[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15416,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__7673__auto__,c__7694__auto___15416,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__7674__auto__ = null;
var cljs$core$async$mix_$_state_machine__7674__auto____0 = (function (){
var statearr_15412 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15412[(0)] = cljs$core$async$mix_$_state_machine__7674__auto__);

(statearr_15412[(1)] = (1));

return statearr_15412;
});
var cljs$core$async$mix_$_state_machine__7674__auto____1 = (function (state_15353){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15353);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15413){if((e15413 instanceof Object)){
var ex__7677__auto__ = e15413;
var statearr_15414_15463 = state_15353;
(statearr_15414_15463[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15353);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15413;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15464 = state_15353;
state_15353 = G__15464;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__7674__auto__ = function(state_15353){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__7674__auto____1.call(this,state_15353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__7674__auto____0;
cljs$core$async$mix_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__7674__auto____1;
return cljs$core$async$mix_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15416,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__7696__auto__ = (function (){var statearr_15415 = f__7695__auto__.call(null);
(statearr_15415[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15416);

return statearr_15415;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15416,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args15465 = [];
var len__5627__auto___15468 = arguments.length;
var i__5628__auto___15469 = (0);
while(true){
if((i__5628__auto___15469 < len__5627__auto___15468)){
args15465.push((arguments[i__5628__auto___15469]));

var G__15470 = (i__5628__auto___15469 + (1));
i__5628__auto___15469 = G__15470;
continue;
} else {
}
break;
}

var G__15467 = args15465.length;
switch (G__15467) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15465.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args15473 = [];
var len__5627__auto___15598 = arguments.length;
var i__5628__auto___15599 = (0);
while(true){
if((i__5628__auto___15599 < len__5627__auto___15598)){
args15473.push((arguments[i__5628__auto___15599]));

var G__15600 = (i__5628__auto___15599 + (1));
i__5628__auto___15599 = G__15600;
continue;
} else {
}
break;
}

var G__15475 = args15473.length;
switch (G__15475) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15473.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4569__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4569__auto__,mults){
return (function (p1__15472_SHARP_){
if(cljs.core.truth_(p1__15472_SHARP_.call(null,topic))){
return p1__15472_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__15472_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4569__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async15476 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15476 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta15477){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta15477 = meta15477;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15476.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_15478,meta15477__$1){
var self__ = this;
var _15478__$1 = this;
return (new cljs.core.async.t_cljs$core$async15476(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta15477__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15476.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_15478){
var self__ = this;
var _15478__$1 = this;
return self__.meta15477;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15476.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15476.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15476.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async15476.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15476.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15476.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15476.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15476.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta15477","meta15477",401471061,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15476.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15476.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15476";

cljs.core.async.t_cljs$core$async15476.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15476");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async15476 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async15476(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15477){
return (new cljs.core.async.t_cljs$core$async15476(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15477));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async15476(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7694__auto___15602 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15602,mults,ensure_mult,p){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15602,mults,ensure_mult,p){
return (function (state_15550){
var state_val_15551 = (state_15550[(1)]);
if((state_val_15551 === (7))){
var inst_15546 = (state_15550[(2)]);
var state_15550__$1 = state_15550;
var statearr_15552_15603 = state_15550__$1;
(statearr_15552_15603[(2)] = inst_15546);

(statearr_15552_15603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (20))){
var state_15550__$1 = state_15550;
var statearr_15553_15604 = state_15550__$1;
(statearr_15553_15604[(2)] = null);

(statearr_15553_15604[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (1))){
var state_15550__$1 = state_15550;
var statearr_15554_15605 = state_15550__$1;
(statearr_15554_15605[(2)] = null);

(statearr_15554_15605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (24))){
var inst_15529 = (state_15550[(7)]);
var inst_15538 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_15529);
var state_15550__$1 = state_15550;
var statearr_15555_15606 = state_15550__$1;
(statearr_15555_15606[(2)] = inst_15538);

(statearr_15555_15606[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (4))){
var inst_15481 = (state_15550[(8)]);
var inst_15481__$1 = (state_15550[(2)]);
var inst_15482 = (inst_15481__$1 == null);
var state_15550__$1 = (function (){var statearr_15556 = state_15550;
(statearr_15556[(8)] = inst_15481__$1);

return statearr_15556;
})();
if(cljs.core.truth_(inst_15482)){
var statearr_15557_15607 = state_15550__$1;
(statearr_15557_15607[(1)] = (5));

} else {
var statearr_15558_15608 = state_15550__$1;
(statearr_15558_15608[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (15))){
var inst_15523 = (state_15550[(2)]);
var state_15550__$1 = state_15550;
var statearr_15559_15609 = state_15550__$1;
(statearr_15559_15609[(2)] = inst_15523);

(statearr_15559_15609[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (21))){
var inst_15543 = (state_15550[(2)]);
var state_15550__$1 = (function (){var statearr_15560 = state_15550;
(statearr_15560[(9)] = inst_15543);

return statearr_15560;
})();
var statearr_15561_15610 = state_15550__$1;
(statearr_15561_15610[(2)] = null);

(statearr_15561_15610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (13))){
var inst_15505 = (state_15550[(10)]);
var inst_15507 = cljs.core.chunked_seq_QMARK_.call(null,inst_15505);
var state_15550__$1 = state_15550;
if(inst_15507){
var statearr_15562_15611 = state_15550__$1;
(statearr_15562_15611[(1)] = (16));

} else {
var statearr_15563_15612 = state_15550__$1;
(statearr_15563_15612[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (22))){
var inst_15535 = (state_15550[(2)]);
var state_15550__$1 = state_15550;
if(cljs.core.truth_(inst_15535)){
var statearr_15564_15613 = state_15550__$1;
(statearr_15564_15613[(1)] = (23));

} else {
var statearr_15565_15614 = state_15550__$1;
(statearr_15565_15614[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (6))){
var inst_15531 = (state_15550[(11)]);
var inst_15481 = (state_15550[(8)]);
var inst_15529 = (state_15550[(7)]);
var inst_15529__$1 = topic_fn.call(null,inst_15481);
var inst_15530 = cljs.core.deref.call(null,mults);
var inst_15531__$1 = cljs.core.get.call(null,inst_15530,inst_15529__$1);
var state_15550__$1 = (function (){var statearr_15566 = state_15550;
(statearr_15566[(11)] = inst_15531__$1);

(statearr_15566[(7)] = inst_15529__$1);

return statearr_15566;
})();
if(cljs.core.truth_(inst_15531__$1)){
var statearr_15567_15615 = state_15550__$1;
(statearr_15567_15615[(1)] = (19));

} else {
var statearr_15568_15616 = state_15550__$1;
(statearr_15568_15616[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (25))){
var inst_15540 = (state_15550[(2)]);
var state_15550__$1 = state_15550;
var statearr_15569_15617 = state_15550__$1;
(statearr_15569_15617[(2)] = inst_15540);

(statearr_15569_15617[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (17))){
var inst_15505 = (state_15550[(10)]);
var inst_15514 = cljs.core.first.call(null,inst_15505);
var inst_15515 = cljs.core.async.muxch_STAR_.call(null,inst_15514);
var inst_15516 = cljs.core.async.close_BANG_.call(null,inst_15515);
var inst_15517 = cljs.core.next.call(null,inst_15505);
var inst_15491 = inst_15517;
var inst_15492 = null;
var inst_15493 = (0);
var inst_15494 = (0);
var state_15550__$1 = (function (){var statearr_15570 = state_15550;
(statearr_15570[(12)] = inst_15491);

(statearr_15570[(13)] = inst_15493);

(statearr_15570[(14)] = inst_15516);

(statearr_15570[(15)] = inst_15494);

(statearr_15570[(16)] = inst_15492);

return statearr_15570;
})();
var statearr_15571_15618 = state_15550__$1;
(statearr_15571_15618[(2)] = null);

(statearr_15571_15618[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (3))){
var inst_15548 = (state_15550[(2)]);
var state_15550__$1 = state_15550;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15550__$1,inst_15548);
} else {
if((state_val_15551 === (12))){
var inst_15525 = (state_15550[(2)]);
var state_15550__$1 = state_15550;
var statearr_15572_15619 = state_15550__$1;
(statearr_15572_15619[(2)] = inst_15525);

(statearr_15572_15619[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (2))){
var state_15550__$1 = state_15550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15550__$1,(4),ch);
} else {
if((state_val_15551 === (23))){
var state_15550__$1 = state_15550;
var statearr_15573_15620 = state_15550__$1;
(statearr_15573_15620[(2)] = null);

(statearr_15573_15620[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (19))){
var inst_15531 = (state_15550[(11)]);
var inst_15481 = (state_15550[(8)]);
var inst_15533 = cljs.core.async.muxch_STAR_.call(null,inst_15531);
var state_15550__$1 = state_15550;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15550__$1,(22),inst_15533,inst_15481);
} else {
if((state_val_15551 === (11))){
var inst_15491 = (state_15550[(12)]);
var inst_15505 = (state_15550[(10)]);
var inst_15505__$1 = cljs.core.seq.call(null,inst_15491);
var state_15550__$1 = (function (){var statearr_15574 = state_15550;
(statearr_15574[(10)] = inst_15505__$1);

return statearr_15574;
})();
if(inst_15505__$1){
var statearr_15575_15621 = state_15550__$1;
(statearr_15575_15621[(1)] = (13));

} else {
var statearr_15576_15622 = state_15550__$1;
(statearr_15576_15622[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (9))){
var inst_15527 = (state_15550[(2)]);
var state_15550__$1 = state_15550;
var statearr_15577_15623 = state_15550__$1;
(statearr_15577_15623[(2)] = inst_15527);

(statearr_15577_15623[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (5))){
var inst_15488 = cljs.core.deref.call(null,mults);
var inst_15489 = cljs.core.vals.call(null,inst_15488);
var inst_15490 = cljs.core.seq.call(null,inst_15489);
var inst_15491 = inst_15490;
var inst_15492 = null;
var inst_15493 = (0);
var inst_15494 = (0);
var state_15550__$1 = (function (){var statearr_15578 = state_15550;
(statearr_15578[(12)] = inst_15491);

(statearr_15578[(13)] = inst_15493);

(statearr_15578[(15)] = inst_15494);

(statearr_15578[(16)] = inst_15492);

return statearr_15578;
})();
var statearr_15579_15624 = state_15550__$1;
(statearr_15579_15624[(2)] = null);

(statearr_15579_15624[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (14))){
var state_15550__$1 = state_15550;
var statearr_15583_15625 = state_15550__$1;
(statearr_15583_15625[(2)] = null);

(statearr_15583_15625[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (16))){
var inst_15505 = (state_15550[(10)]);
var inst_15509 = cljs.core.chunk_first.call(null,inst_15505);
var inst_15510 = cljs.core.chunk_rest.call(null,inst_15505);
var inst_15511 = cljs.core.count.call(null,inst_15509);
var inst_15491 = inst_15510;
var inst_15492 = inst_15509;
var inst_15493 = inst_15511;
var inst_15494 = (0);
var state_15550__$1 = (function (){var statearr_15584 = state_15550;
(statearr_15584[(12)] = inst_15491);

(statearr_15584[(13)] = inst_15493);

(statearr_15584[(15)] = inst_15494);

(statearr_15584[(16)] = inst_15492);

return statearr_15584;
})();
var statearr_15585_15626 = state_15550__$1;
(statearr_15585_15626[(2)] = null);

(statearr_15585_15626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (10))){
var inst_15491 = (state_15550[(12)]);
var inst_15493 = (state_15550[(13)]);
var inst_15494 = (state_15550[(15)]);
var inst_15492 = (state_15550[(16)]);
var inst_15499 = cljs.core._nth.call(null,inst_15492,inst_15494);
var inst_15500 = cljs.core.async.muxch_STAR_.call(null,inst_15499);
var inst_15501 = cljs.core.async.close_BANG_.call(null,inst_15500);
var inst_15502 = (inst_15494 + (1));
var tmp15580 = inst_15491;
var tmp15581 = inst_15493;
var tmp15582 = inst_15492;
var inst_15491__$1 = tmp15580;
var inst_15492__$1 = tmp15582;
var inst_15493__$1 = tmp15581;
var inst_15494__$1 = inst_15502;
var state_15550__$1 = (function (){var statearr_15586 = state_15550;
(statearr_15586[(12)] = inst_15491__$1);

(statearr_15586[(13)] = inst_15493__$1);

(statearr_15586[(15)] = inst_15494__$1);

(statearr_15586[(17)] = inst_15501);

(statearr_15586[(16)] = inst_15492__$1);

return statearr_15586;
})();
var statearr_15587_15627 = state_15550__$1;
(statearr_15587_15627[(2)] = null);

(statearr_15587_15627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (18))){
var inst_15520 = (state_15550[(2)]);
var state_15550__$1 = state_15550;
var statearr_15588_15628 = state_15550__$1;
(statearr_15588_15628[(2)] = inst_15520);

(statearr_15588_15628[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15551 === (8))){
var inst_15493 = (state_15550[(13)]);
var inst_15494 = (state_15550[(15)]);
var inst_15496 = (inst_15494 < inst_15493);
var inst_15497 = inst_15496;
var state_15550__$1 = state_15550;
if(cljs.core.truth_(inst_15497)){
var statearr_15589_15629 = state_15550__$1;
(statearr_15589_15629[(1)] = (10));

} else {
var statearr_15590_15630 = state_15550__$1;
(statearr_15590_15630[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15602,mults,ensure_mult,p))
;
return ((function (switch__7673__auto__,c__7694__auto___15602,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15594 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15594[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15594[(1)] = (1));

return statearr_15594;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15550){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15550);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15595){if((e15595 instanceof Object)){
var ex__7677__auto__ = e15595;
var statearr_15596_15631 = state_15550;
(statearr_15596_15631[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15550);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15595;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15632 = state_15550;
state_15550 = G__15632;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15550){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15602,mults,ensure_mult,p))
})();
var state__7696__auto__ = (function (){var statearr_15597 = f__7695__auto__.call(null);
(statearr_15597[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15602);

return statearr_15597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15602,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args15633 = [];
var len__5627__auto___15636 = arguments.length;
var i__5628__auto___15637 = (0);
while(true){
if((i__5628__auto___15637 < len__5627__auto___15636)){
args15633.push((arguments[i__5628__auto___15637]));

var G__15638 = (i__5628__auto___15637 + (1));
i__5628__auto___15637 = G__15638;
continue;
} else {
}
break;
}

var G__15635 = args15633.length;
switch (G__15635) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15633.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args15640 = [];
var len__5627__auto___15643 = arguments.length;
var i__5628__auto___15644 = (0);
while(true){
if((i__5628__auto___15644 < len__5627__auto___15643)){
args15640.push((arguments[i__5628__auto___15644]));

var G__15645 = (i__5628__auto___15644 + (1));
i__5628__auto___15644 = G__15645;
continue;
} else {
}
break;
}

var G__15642 = args15640.length;
switch (G__15642) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15640.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args15647 = [];
var len__5627__auto___15718 = arguments.length;
var i__5628__auto___15719 = (0);
while(true){
if((i__5628__auto___15719 < len__5627__auto___15718)){
args15647.push((arguments[i__5628__auto___15719]));

var G__15720 = (i__5628__auto___15719 + (1));
i__5628__auto___15719 = G__15720;
continue;
} else {
}
break;
}

var G__15649 = args15647.length;
switch (G__15649) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15647.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__7694__auto___15722 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15722,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15722,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_15688){
var state_val_15689 = (state_15688[(1)]);
if((state_val_15689 === (7))){
var state_15688__$1 = state_15688;
var statearr_15690_15723 = state_15688__$1;
(statearr_15690_15723[(2)] = null);

(statearr_15690_15723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15689 === (1))){
var state_15688__$1 = state_15688;
var statearr_15691_15724 = state_15688__$1;
(statearr_15691_15724[(2)] = null);

(statearr_15691_15724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15689 === (4))){
var inst_15652 = (state_15688[(7)]);
var inst_15654 = (inst_15652 < cnt);
var state_15688__$1 = state_15688;
if(cljs.core.truth_(inst_15654)){
var statearr_15692_15725 = state_15688__$1;
(statearr_15692_15725[(1)] = (6));

} else {
var statearr_15693_15726 = state_15688__$1;
(statearr_15693_15726[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15689 === (15))){
var inst_15684 = (state_15688[(2)]);
var state_15688__$1 = state_15688;
var statearr_15694_15727 = state_15688__$1;
(statearr_15694_15727[(2)] = inst_15684);

(statearr_15694_15727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15689 === (13))){
var inst_15677 = cljs.core.async.close_BANG_.call(null,out);
var state_15688__$1 = state_15688;
var statearr_15695_15728 = state_15688__$1;
(statearr_15695_15728[(2)] = inst_15677);

(statearr_15695_15728[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15689 === (6))){
var state_15688__$1 = state_15688;
var statearr_15696_15729 = state_15688__$1;
(statearr_15696_15729[(2)] = null);

(statearr_15696_15729[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15689 === (3))){
var inst_15686 = (state_15688[(2)]);
var state_15688__$1 = state_15688;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15688__$1,inst_15686);
} else {
if((state_val_15689 === (12))){
var inst_15674 = (state_15688[(8)]);
var inst_15674__$1 = (state_15688[(2)]);
var inst_15675 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_15674__$1);
var state_15688__$1 = (function (){var statearr_15697 = state_15688;
(statearr_15697[(8)] = inst_15674__$1);

return statearr_15697;
})();
if(cljs.core.truth_(inst_15675)){
var statearr_15698_15730 = state_15688__$1;
(statearr_15698_15730[(1)] = (13));

} else {
var statearr_15699_15731 = state_15688__$1;
(statearr_15699_15731[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15689 === (2))){
var inst_15651 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_15652 = (0);
var state_15688__$1 = (function (){var statearr_15700 = state_15688;
(statearr_15700[(9)] = inst_15651);

(statearr_15700[(7)] = inst_15652);

return statearr_15700;
})();
var statearr_15701_15732 = state_15688__$1;
(statearr_15701_15732[(2)] = null);

(statearr_15701_15732[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15689 === (11))){
var inst_15652 = (state_15688[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_15688,(10),Object,null,(9));
var inst_15661 = chs__$1.call(null,inst_15652);
var inst_15662 = done.call(null,inst_15652);
var inst_15663 = cljs.core.async.take_BANG_.call(null,inst_15661,inst_15662);
var state_15688__$1 = state_15688;
var statearr_15702_15733 = state_15688__$1;
(statearr_15702_15733[(2)] = inst_15663);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15688__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15689 === (9))){
var inst_15652 = (state_15688[(7)]);
var inst_15665 = (state_15688[(2)]);
var inst_15666 = (inst_15652 + (1));
var inst_15652__$1 = inst_15666;
var state_15688__$1 = (function (){var statearr_15703 = state_15688;
(statearr_15703[(10)] = inst_15665);

(statearr_15703[(7)] = inst_15652__$1);

return statearr_15703;
})();
var statearr_15704_15734 = state_15688__$1;
(statearr_15704_15734[(2)] = null);

(statearr_15704_15734[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15689 === (5))){
var inst_15672 = (state_15688[(2)]);
var state_15688__$1 = (function (){var statearr_15705 = state_15688;
(statearr_15705[(11)] = inst_15672);

return statearr_15705;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15688__$1,(12),dchan);
} else {
if((state_val_15689 === (14))){
var inst_15674 = (state_15688[(8)]);
var inst_15679 = cljs.core.apply.call(null,f,inst_15674);
var state_15688__$1 = state_15688;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15688__$1,(16),out,inst_15679);
} else {
if((state_val_15689 === (16))){
var inst_15681 = (state_15688[(2)]);
var state_15688__$1 = (function (){var statearr_15706 = state_15688;
(statearr_15706[(12)] = inst_15681);

return statearr_15706;
})();
var statearr_15707_15735 = state_15688__$1;
(statearr_15707_15735[(2)] = null);

(statearr_15707_15735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15689 === (10))){
var inst_15656 = (state_15688[(2)]);
var inst_15657 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_15688__$1 = (function (){var statearr_15708 = state_15688;
(statearr_15708[(13)] = inst_15656);

return statearr_15708;
})();
var statearr_15709_15736 = state_15688__$1;
(statearr_15709_15736[(2)] = inst_15657);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15688__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15689 === (8))){
var inst_15670 = (state_15688[(2)]);
var state_15688__$1 = state_15688;
var statearr_15710_15737 = state_15688__$1;
(statearr_15710_15737[(2)] = inst_15670);

(statearr_15710_15737[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15722,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__7673__auto__,c__7694__auto___15722,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15714 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15714[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15714[(1)] = (1));

return statearr_15714;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15688){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15688);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15715){if((e15715 instanceof Object)){
var ex__7677__auto__ = e15715;
var statearr_15716_15738 = state_15688;
(statearr_15716_15738[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15688);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15715;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15739 = state_15688;
state_15688 = G__15739;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15688){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15722,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__7696__auto__ = (function (){var statearr_15717 = f__7695__auto__.call(null);
(statearr_15717[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15722);

return statearr_15717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15722,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args15741 = [];
var len__5627__auto___15797 = arguments.length;
var i__5628__auto___15798 = (0);
while(true){
if((i__5628__auto___15798 < len__5627__auto___15797)){
args15741.push((arguments[i__5628__auto___15798]));

var G__15799 = (i__5628__auto___15798 + (1));
i__5628__auto___15798 = G__15799;
continue;
} else {
}
break;
}

var G__15743 = args15741.length;
switch (G__15743) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15741.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___15801 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15801,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15801,out){
return (function (state_15773){
var state_val_15774 = (state_15773[(1)]);
if((state_val_15774 === (7))){
var inst_15752 = (state_15773[(7)]);
var inst_15753 = (state_15773[(8)]);
var inst_15752__$1 = (state_15773[(2)]);
var inst_15753__$1 = cljs.core.nth.call(null,inst_15752__$1,(0),null);
var inst_15754 = cljs.core.nth.call(null,inst_15752__$1,(1),null);
var inst_15755 = (inst_15753__$1 == null);
var state_15773__$1 = (function (){var statearr_15775 = state_15773;
(statearr_15775[(7)] = inst_15752__$1);

(statearr_15775[(8)] = inst_15753__$1);

(statearr_15775[(9)] = inst_15754);

return statearr_15775;
})();
if(cljs.core.truth_(inst_15755)){
var statearr_15776_15802 = state_15773__$1;
(statearr_15776_15802[(1)] = (8));

} else {
var statearr_15777_15803 = state_15773__$1;
(statearr_15777_15803[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (1))){
var inst_15744 = cljs.core.vec.call(null,chs);
var inst_15745 = inst_15744;
var state_15773__$1 = (function (){var statearr_15778 = state_15773;
(statearr_15778[(10)] = inst_15745);

return statearr_15778;
})();
var statearr_15779_15804 = state_15773__$1;
(statearr_15779_15804[(2)] = null);

(statearr_15779_15804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (4))){
var inst_15745 = (state_15773[(10)]);
var state_15773__$1 = state_15773;
return cljs.core.async.ioc_alts_BANG_.call(null,state_15773__$1,(7),inst_15745);
} else {
if((state_val_15774 === (6))){
var inst_15769 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
var statearr_15780_15805 = state_15773__$1;
(statearr_15780_15805[(2)] = inst_15769);

(statearr_15780_15805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (3))){
var inst_15771 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15773__$1,inst_15771);
} else {
if((state_val_15774 === (2))){
var inst_15745 = (state_15773[(10)]);
var inst_15747 = cljs.core.count.call(null,inst_15745);
var inst_15748 = (inst_15747 > (0));
var state_15773__$1 = state_15773;
if(cljs.core.truth_(inst_15748)){
var statearr_15782_15806 = state_15773__$1;
(statearr_15782_15806[(1)] = (4));

} else {
var statearr_15783_15807 = state_15773__$1;
(statearr_15783_15807[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (11))){
var inst_15745 = (state_15773[(10)]);
var inst_15762 = (state_15773[(2)]);
var tmp15781 = inst_15745;
var inst_15745__$1 = tmp15781;
var state_15773__$1 = (function (){var statearr_15784 = state_15773;
(statearr_15784[(11)] = inst_15762);

(statearr_15784[(10)] = inst_15745__$1);

return statearr_15784;
})();
var statearr_15785_15808 = state_15773__$1;
(statearr_15785_15808[(2)] = null);

(statearr_15785_15808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (9))){
var inst_15753 = (state_15773[(8)]);
var state_15773__$1 = state_15773;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15773__$1,(11),out,inst_15753);
} else {
if((state_val_15774 === (5))){
var inst_15767 = cljs.core.async.close_BANG_.call(null,out);
var state_15773__$1 = state_15773;
var statearr_15786_15809 = state_15773__$1;
(statearr_15786_15809[(2)] = inst_15767);

(statearr_15786_15809[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (10))){
var inst_15765 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
var statearr_15787_15810 = state_15773__$1;
(statearr_15787_15810[(2)] = inst_15765);

(statearr_15787_15810[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (8))){
var inst_15752 = (state_15773[(7)]);
var inst_15753 = (state_15773[(8)]);
var inst_15754 = (state_15773[(9)]);
var inst_15745 = (state_15773[(10)]);
var inst_15757 = (function (){var cs = inst_15745;
var vec__15750 = inst_15752;
var v = inst_15753;
var c = inst_15754;
return ((function (cs,vec__15750,v,c,inst_15752,inst_15753,inst_15754,inst_15745,state_val_15774,c__7694__auto___15801,out){
return (function (p1__15740_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__15740_SHARP_);
});
;})(cs,vec__15750,v,c,inst_15752,inst_15753,inst_15754,inst_15745,state_val_15774,c__7694__auto___15801,out))
})();
var inst_15758 = cljs.core.filterv.call(null,inst_15757,inst_15745);
var inst_15745__$1 = inst_15758;
var state_15773__$1 = (function (){var statearr_15788 = state_15773;
(statearr_15788[(10)] = inst_15745__$1);

return statearr_15788;
})();
var statearr_15789_15811 = state_15773__$1;
(statearr_15789_15811[(2)] = null);

(statearr_15789_15811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15801,out))
;
return ((function (switch__7673__auto__,c__7694__auto___15801,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15793 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15793[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15793[(1)] = (1));

return statearr_15793;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15773){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15773);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15794){if((e15794 instanceof Object)){
var ex__7677__auto__ = e15794;
var statearr_15795_15812 = state_15773;
(statearr_15795_15812[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15773);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15794;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15813 = state_15773;
state_15773 = G__15813;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15773){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15801,out))
})();
var state__7696__auto__ = (function (){var statearr_15796 = f__7695__auto__.call(null);
(statearr_15796[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15801);

return statearr_15796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15801,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args15814 = [];
var len__5627__auto___15863 = arguments.length;
var i__5628__auto___15864 = (0);
while(true){
if((i__5628__auto___15864 < len__5627__auto___15863)){
args15814.push((arguments[i__5628__auto___15864]));

var G__15865 = (i__5628__auto___15864 + (1));
i__5628__auto___15864 = G__15865;
continue;
} else {
}
break;
}

var G__15816 = args15814.length;
switch (G__15816) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15814.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___15867 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15867,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15867,out){
return (function (state_15840){
var state_val_15841 = (state_15840[(1)]);
if((state_val_15841 === (7))){
var inst_15822 = (state_15840[(7)]);
var inst_15822__$1 = (state_15840[(2)]);
var inst_15823 = (inst_15822__$1 == null);
var inst_15824 = cljs.core.not.call(null,inst_15823);
var state_15840__$1 = (function (){var statearr_15842 = state_15840;
(statearr_15842[(7)] = inst_15822__$1);

return statearr_15842;
})();
if(inst_15824){
var statearr_15843_15868 = state_15840__$1;
(statearr_15843_15868[(1)] = (8));

} else {
var statearr_15844_15869 = state_15840__$1;
(statearr_15844_15869[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (1))){
var inst_15817 = (0);
var state_15840__$1 = (function (){var statearr_15845 = state_15840;
(statearr_15845[(8)] = inst_15817);

return statearr_15845;
})();
var statearr_15846_15870 = state_15840__$1;
(statearr_15846_15870[(2)] = null);

(statearr_15846_15870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (4))){
var state_15840__$1 = state_15840;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15840__$1,(7),ch);
} else {
if((state_val_15841 === (6))){
var inst_15835 = (state_15840[(2)]);
var state_15840__$1 = state_15840;
var statearr_15847_15871 = state_15840__$1;
(statearr_15847_15871[(2)] = inst_15835);

(statearr_15847_15871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (3))){
var inst_15837 = (state_15840[(2)]);
var inst_15838 = cljs.core.async.close_BANG_.call(null,out);
var state_15840__$1 = (function (){var statearr_15848 = state_15840;
(statearr_15848[(9)] = inst_15837);

return statearr_15848;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15840__$1,inst_15838);
} else {
if((state_val_15841 === (2))){
var inst_15817 = (state_15840[(8)]);
var inst_15819 = (inst_15817 < n);
var state_15840__$1 = state_15840;
if(cljs.core.truth_(inst_15819)){
var statearr_15849_15872 = state_15840__$1;
(statearr_15849_15872[(1)] = (4));

} else {
var statearr_15850_15873 = state_15840__$1;
(statearr_15850_15873[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (11))){
var inst_15817 = (state_15840[(8)]);
var inst_15827 = (state_15840[(2)]);
var inst_15828 = (inst_15817 + (1));
var inst_15817__$1 = inst_15828;
var state_15840__$1 = (function (){var statearr_15851 = state_15840;
(statearr_15851[(10)] = inst_15827);

(statearr_15851[(8)] = inst_15817__$1);

return statearr_15851;
})();
var statearr_15852_15874 = state_15840__$1;
(statearr_15852_15874[(2)] = null);

(statearr_15852_15874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (9))){
var state_15840__$1 = state_15840;
var statearr_15853_15875 = state_15840__$1;
(statearr_15853_15875[(2)] = null);

(statearr_15853_15875[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (5))){
var state_15840__$1 = state_15840;
var statearr_15854_15876 = state_15840__$1;
(statearr_15854_15876[(2)] = null);

(statearr_15854_15876[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (10))){
var inst_15832 = (state_15840[(2)]);
var state_15840__$1 = state_15840;
var statearr_15855_15877 = state_15840__$1;
(statearr_15855_15877[(2)] = inst_15832);

(statearr_15855_15877[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (8))){
var inst_15822 = (state_15840[(7)]);
var state_15840__$1 = state_15840;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15840__$1,(11),out,inst_15822);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15867,out))
;
return ((function (switch__7673__auto__,c__7694__auto___15867,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15859 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15859[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15859[(1)] = (1));

return statearr_15859;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15840){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15840);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15860){if((e15860 instanceof Object)){
var ex__7677__auto__ = e15860;
var statearr_15861_15878 = state_15840;
(statearr_15861_15878[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15840);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15860;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15879 = state_15840;
state_15840 = G__15879;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15840){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15867,out))
})();
var state__7696__auto__ = (function (){var statearr_15862 = f__7695__auto__.call(null);
(statearr_15862[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15867);

return statearr_15862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15867,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async15887 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15887 = (function (map_LT_,f,ch,meta15888){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta15888 = meta15888;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15887.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15889,meta15888__$1){
var self__ = this;
var _15889__$1 = this;
return (new cljs.core.async.t_cljs$core$async15887(self__.map_LT_,self__.f,self__.ch,meta15888__$1));
});

cljs.core.async.t_cljs$core$async15887.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15889){
var self__ = this;
var _15889__$1 = this;
return self__.meta15888;
});

cljs.core.async.t_cljs$core$async15887.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async15887.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15887.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15887.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async15887.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async15890 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15890 = (function (map_LT_,f,ch,meta15888,_,fn1,meta15891){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta15888 = meta15888;
this._ = _;
this.fn1 = fn1;
this.meta15891 = meta15891;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15890.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_15892,meta15891__$1){
var self__ = this;
var _15892__$1 = this;
return (new cljs.core.async.t_cljs$core$async15890(self__.map_LT_,self__.f,self__.ch,self__.meta15888,self__._,self__.fn1,meta15891__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async15890.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_15892){
var self__ = this;
var _15892__$1 = this;
return self__.meta15891;
});})(___$1))
;

cljs.core.async.t_cljs$core$async15890.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async15890.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async15890.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__15880_SHARP_){
return f1.call(null,(((p1__15880_SHARP_ == null))?null:self__.f.call(null,p1__15880_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async15890.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15888","meta15888",268580022,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async15887","cljs.core.async/t_cljs$core$async15887",-1121405830,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta15891","meta15891",1427967945,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async15890.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15890.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15890";

cljs.core.async.t_cljs$core$async15890.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15890");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async15890 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15890(map_LT___$1,f__$1,ch__$1,meta15888__$1,___$2,fn1__$1,meta15891){
return (new cljs.core.async.t_cljs$core$async15890(map_LT___$1,f__$1,ch__$1,meta15888__$1,___$2,fn1__$1,meta15891));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async15890(self__.map_LT_,self__.f,self__.ch,self__.meta15888,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4557__auto__ = ret;
if(cljs.core.truth_(and__4557__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4557__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async15887.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async15887.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async15887.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15888","meta15888",268580022,null)], null);
});

cljs.core.async.t_cljs$core$async15887.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15887.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15887";

cljs.core.async.t_cljs$core$async15887.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15887");
});

cljs.core.async.__GT_t_cljs$core$async15887 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15887(map_LT___$1,f__$1,ch__$1,meta15888){
return (new cljs.core.async.t_cljs$core$async15887(map_LT___$1,f__$1,ch__$1,meta15888));
});

}

return (new cljs.core.async.t_cljs$core$async15887(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async15896 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15896 = (function (map_GT_,f,ch,meta15897){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta15897 = meta15897;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15898,meta15897__$1){
var self__ = this;
var _15898__$1 = this;
return (new cljs.core.async.t_cljs$core$async15896(self__.map_GT_,self__.f,self__.ch,meta15897__$1));
});

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15898){
var self__ = this;
var _15898__$1 = this;
return self__.meta15897;
});

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async15896.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async15896.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15897","meta15897",-1716869482,null)], null);
});

cljs.core.async.t_cljs$core$async15896.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15896.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15896";

cljs.core.async.t_cljs$core$async15896.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15896");
});

cljs.core.async.__GT_t_cljs$core$async15896 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async15896(map_GT___$1,f__$1,ch__$1,meta15897){
return (new cljs.core.async.t_cljs$core$async15896(map_GT___$1,f__$1,ch__$1,meta15897));
});

}

return (new cljs.core.async.t_cljs$core$async15896(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async15902 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15902 = (function (filter_GT_,p,ch,meta15903){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta15903 = meta15903;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15902.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15904,meta15903__$1){
var self__ = this;
var _15904__$1 = this;
return (new cljs.core.async.t_cljs$core$async15902(self__.filter_GT_,self__.p,self__.ch,meta15903__$1));
});

cljs.core.async.t_cljs$core$async15902.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15904){
var self__ = this;
var _15904__$1 = this;
return self__.meta15903;
});

cljs.core.async.t_cljs$core$async15902.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async15902.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15902.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15902.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async15902.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async15902.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async15902.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async15902.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15903","meta15903",1281756573,null)], null);
});

cljs.core.async.t_cljs$core$async15902.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15902.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15902";

cljs.core.async.t_cljs$core$async15902.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async15902");
});

cljs.core.async.__GT_t_cljs$core$async15902 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async15902(filter_GT___$1,p__$1,ch__$1,meta15903){
return (new cljs.core.async.t_cljs$core$async15902(filter_GT___$1,p__$1,ch__$1,meta15903));
});

}

return (new cljs.core.async.t_cljs$core$async15902(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args15905 = [];
var len__5627__auto___15949 = arguments.length;
var i__5628__auto___15950 = (0);
while(true){
if((i__5628__auto___15950 < len__5627__auto___15949)){
args15905.push((arguments[i__5628__auto___15950]));

var G__15951 = (i__5628__auto___15950 + (1));
i__5628__auto___15950 = G__15951;
continue;
} else {
}
break;
}

var G__15907 = args15905.length;
switch (G__15907) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15905.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___15953 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___15953,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___15953,out){
return (function (state_15928){
var state_val_15929 = (state_15928[(1)]);
if((state_val_15929 === (7))){
var inst_15924 = (state_15928[(2)]);
var state_15928__$1 = state_15928;
var statearr_15930_15954 = state_15928__$1;
(statearr_15930_15954[(2)] = inst_15924);

(statearr_15930_15954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15929 === (1))){
var state_15928__$1 = state_15928;
var statearr_15931_15955 = state_15928__$1;
(statearr_15931_15955[(2)] = null);

(statearr_15931_15955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15929 === (4))){
var inst_15910 = (state_15928[(7)]);
var inst_15910__$1 = (state_15928[(2)]);
var inst_15911 = (inst_15910__$1 == null);
var state_15928__$1 = (function (){var statearr_15932 = state_15928;
(statearr_15932[(7)] = inst_15910__$1);

return statearr_15932;
})();
if(cljs.core.truth_(inst_15911)){
var statearr_15933_15956 = state_15928__$1;
(statearr_15933_15956[(1)] = (5));

} else {
var statearr_15934_15957 = state_15928__$1;
(statearr_15934_15957[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15929 === (6))){
var inst_15910 = (state_15928[(7)]);
var inst_15915 = p.call(null,inst_15910);
var state_15928__$1 = state_15928;
if(cljs.core.truth_(inst_15915)){
var statearr_15935_15958 = state_15928__$1;
(statearr_15935_15958[(1)] = (8));

} else {
var statearr_15936_15959 = state_15928__$1;
(statearr_15936_15959[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15929 === (3))){
var inst_15926 = (state_15928[(2)]);
var state_15928__$1 = state_15928;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15928__$1,inst_15926);
} else {
if((state_val_15929 === (2))){
var state_15928__$1 = state_15928;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15928__$1,(4),ch);
} else {
if((state_val_15929 === (11))){
var inst_15918 = (state_15928[(2)]);
var state_15928__$1 = state_15928;
var statearr_15937_15960 = state_15928__$1;
(statearr_15937_15960[(2)] = inst_15918);

(statearr_15937_15960[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15929 === (9))){
var state_15928__$1 = state_15928;
var statearr_15938_15961 = state_15928__$1;
(statearr_15938_15961[(2)] = null);

(statearr_15938_15961[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15929 === (5))){
var inst_15913 = cljs.core.async.close_BANG_.call(null,out);
var state_15928__$1 = state_15928;
var statearr_15939_15962 = state_15928__$1;
(statearr_15939_15962[(2)] = inst_15913);

(statearr_15939_15962[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15929 === (10))){
var inst_15921 = (state_15928[(2)]);
var state_15928__$1 = (function (){var statearr_15940 = state_15928;
(statearr_15940[(8)] = inst_15921);

return statearr_15940;
})();
var statearr_15941_15963 = state_15928__$1;
(statearr_15941_15963[(2)] = null);

(statearr_15941_15963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15929 === (8))){
var inst_15910 = (state_15928[(7)]);
var state_15928__$1 = state_15928;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15928__$1,(11),out,inst_15910);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___15953,out))
;
return ((function (switch__7673__auto__,c__7694__auto___15953,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_15945 = [null,null,null,null,null,null,null,null,null];
(statearr_15945[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_15945[(1)] = (1));

return statearr_15945;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_15928){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_15928);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e15946){if((e15946 instanceof Object)){
var ex__7677__auto__ = e15946;
var statearr_15947_15964 = state_15928;
(statearr_15947_15964[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15928);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15946;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15965 = state_15928;
state_15928 = G__15965;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_15928){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_15928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___15953,out))
})();
var state__7696__auto__ = (function (){var statearr_15948 = f__7695__auto__.call(null);
(statearr_15948[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___15953);

return statearr_15948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___15953,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args15966 = [];
var len__5627__auto___15969 = arguments.length;
var i__5628__auto___15970 = (0);
while(true){
if((i__5628__auto___15970 < len__5627__auto___15969)){
args15966.push((arguments[i__5628__auto___15970]));

var G__15971 = (i__5628__auto___15970 + (1));
i__5628__auto___15970 = G__15971;
continue;
} else {
}
break;
}

var G__15968 = args15966.length;
switch (G__15968) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15966.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__){
return (function (state_16138){
var state_val_16139 = (state_16138[(1)]);
if((state_val_16139 === (7))){
var inst_16134 = (state_16138[(2)]);
var state_16138__$1 = state_16138;
var statearr_16140_16181 = state_16138__$1;
(statearr_16140_16181[(2)] = inst_16134);

(statearr_16140_16181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (20))){
var inst_16104 = (state_16138[(7)]);
var inst_16115 = (state_16138[(2)]);
var inst_16116 = cljs.core.next.call(null,inst_16104);
var inst_16090 = inst_16116;
var inst_16091 = null;
var inst_16092 = (0);
var inst_16093 = (0);
var state_16138__$1 = (function (){var statearr_16141 = state_16138;
(statearr_16141[(8)] = inst_16092);

(statearr_16141[(9)] = inst_16093);

(statearr_16141[(10)] = inst_16115);

(statearr_16141[(11)] = inst_16091);

(statearr_16141[(12)] = inst_16090);

return statearr_16141;
})();
var statearr_16142_16182 = state_16138__$1;
(statearr_16142_16182[(2)] = null);

(statearr_16142_16182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (1))){
var state_16138__$1 = state_16138;
var statearr_16143_16183 = state_16138__$1;
(statearr_16143_16183[(2)] = null);

(statearr_16143_16183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (4))){
var inst_16079 = (state_16138[(13)]);
var inst_16079__$1 = (state_16138[(2)]);
var inst_16080 = (inst_16079__$1 == null);
var state_16138__$1 = (function (){var statearr_16144 = state_16138;
(statearr_16144[(13)] = inst_16079__$1);

return statearr_16144;
})();
if(cljs.core.truth_(inst_16080)){
var statearr_16145_16184 = state_16138__$1;
(statearr_16145_16184[(1)] = (5));

} else {
var statearr_16146_16185 = state_16138__$1;
(statearr_16146_16185[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (15))){
var state_16138__$1 = state_16138;
var statearr_16150_16186 = state_16138__$1;
(statearr_16150_16186[(2)] = null);

(statearr_16150_16186[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (21))){
var state_16138__$1 = state_16138;
var statearr_16151_16187 = state_16138__$1;
(statearr_16151_16187[(2)] = null);

(statearr_16151_16187[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (13))){
var inst_16092 = (state_16138[(8)]);
var inst_16093 = (state_16138[(9)]);
var inst_16091 = (state_16138[(11)]);
var inst_16090 = (state_16138[(12)]);
var inst_16100 = (state_16138[(2)]);
var inst_16101 = (inst_16093 + (1));
var tmp16147 = inst_16092;
var tmp16148 = inst_16091;
var tmp16149 = inst_16090;
var inst_16090__$1 = tmp16149;
var inst_16091__$1 = tmp16148;
var inst_16092__$1 = tmp16147;
var inst_16093__$1 = inst_16101;
var state_16138__$1 = (function (){var statearr_16152 = state_16138;
(statearr_16152[(8)] = inst_16092__$1);

(statearr_16152[(9)] = inst_16093__$1);

(statearr_16152[(11)] = inst_16091__$1);

(statearr_16152[(12)] = inst_16090__$1);

(statearr_16152[(14)] = inst_16100);

return statearr_16152;
})();
var statearr_16153_16188 = state_16138__$1;
(statearr_16153_16188[(2)] = null);

(statearr_16153_16188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (22))){
var state_16138__$1 = state_16138;
var statearr_16154_16189 = state_16138__$1;
(statearr_16154_16189[(2)] = null);

(statearr_16154_16189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (6))){
var inst_16079 = (state_16138[(13)]);
var inst_16088 = f.call(null,inst_16079);
var inst_16089 = cljs.core.seq.call(null,inst_16088);
var inst_16090 = inst_16089;
var inst_16091 = null;
var inst_16092 = (0);
var inst_16093 = (0);
var state_16138__$1 = (function (){var statearr_16155 = state_16138;
(statearr_16155[(8)] = inst_16092);

(statearr_16155[(9)] = inst_16093);

(statearr_16155[(11)] = inst_16091);

(statearr_16155[(12)] = inst_16090);

return statearr_16155;
})();
var statearr_16156_16190 = state_16138__$1;
(statearr_16156_16190[(2)] = null);

(statearr_16156_16190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (17))){
var inst_16104 = (state_16138[(7)]);
var inst_16108 = cljs.core.chunk_first.call(null,inst_16104);
var inst_16109 = cljs.core.chunk_rest.call(null,inst_16104);
var inst_16110 = cljs.core.count.call(null,inst_16108);
var inst_16090 = inst_16109;
var inst_16091 = inst_16108;
var inst_16092 = inst_16110;
var inst_16093 = (0);
var state_16138__$1 = (function (){var statearr_16157 = state_16138;
(statearr_16157[(8)] = inst_16092);

(statearr_16157[(9)] = inst_16093);

(statearr_16157[(11)] = inst_16091);

(statearr_16157[(12)] = inst_16090);

return statearr_16157;
})();
var statearr_16158_16191 = state_16138__$1;
(statearr_16158_16191[(2)] = null);

(statearr_16158_16191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (3))){
var inst_16136 = (state_16138[(2)]);
var state_16138__$1 = state_16138;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16138__$1,inst_16136);
} else {
if((state_val_16139 === (12))){
var inst_16124 = (state_16138[(2)]);
var state_16138__$1 = state_16138;
var statearr_16159_16192 = state_16138__$1;
(statearr_16159_16192[(2)] = inst_16124);

(statearr_16159_16192[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (2))){
var state_16138__$1 = state_16138;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16138__$1,(4),in$);
} else {
if((state_val_16139 === (23))){
var inst_16132 = (state_16138[(2)]);
var state_16138__$1 = state_16138;
var statearr_16160_16193 = state_16138__$1;
(statearr_16160_16193[(2)] = inst_16132);

(statearr_16160_16193[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (19))){
var inst_16119 = (state_16138[(2)]);
var state_16138__$1 = state_16138;
var statearr_16161_16194 = state_16138__$1;
(statearr_16161_16194[(2)] = inst_16119);

(statearr_16161_16194[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (11))){
var inst_16104 = (state_16138[(7)]);
var inst_16090 = (state_16138[(12)]);
var inst_16104__$1 = cljs.core.seq.call(null,inst_16090);
var state_16138__$1 = (function (){var statearr_16162 = state_16138;
(statearr_16162[(7)] = inst_16104__$1);

return statearr_16162;
})();
if(inst_16104__$1){
var statearr_16163_16195 = state_16138__$1;
(statearr_16163_16195[(1)] = (14));

} else {
var statearr_16164_16196 = state_16138__$1;
(statearr_16164_16196[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (9))){
var inst_16126 = (state_16138[(2)]);
var inst_16127 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_16138__$1 = (function (){var statearr_16165 = state_16138;
(statearr_16165[(15)] = inst_16126);

return statearr_16165;
})();
if(cljs.core.truth_(inst_16127)){
var statearr_16166_16197 = state_16138__$1;
(statearr_16166_16197[(1)] = (21));

} else {
var statearr_16167_16198 = state_16138__$1;
(statearr_16167_16198[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (5))){
var inst_16082 = cljs.core.async.close_BANG_.call(null,out);
var state_16138__$1 = state_16138;
var statearr_16168_16199 = state_16138__$1;
(statearr_16168_16199[(2)] = inst_16082);

(statearr_16168_16199[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (14))){
var inst_16104 = (state_16138[(7)]);
var inst_16106 = cljs.core.chunked_seq_QMARK_.call(null,inst_16104);
var state_16138__$1 = state_16138;
if(inst_16106){
var statearr_16169_16200 = state_16138__$1;
(statearr_16169_16200[(1)] = (17));

} else {
var statearr_16170_16201 = state_16138__$1;
(statearr_16170_16201[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (16))){
var inst_16122 = (state_16138[(2)]);
var state_16138__$1 = state_16138;
var statearr_16171_16202 = state_16138__$1;
(statearr_16171_16202[(2)] = inst_16122);

(statearr_16171_16202[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16139 === (10))){
var inst_16093 = (state_16138[(9)]);
var inst_16091 = (state_16138[(11)]);
var inst_16098 = cljs.core._nth.call(null,inst_16091,inst_16093);
var state_16138__$1 = state_16138;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16138__$1,(13),out,inst_16098);
} else {
if((state_val_16139 === (18))){
var inst_16104 = (state_16138[(7)]);
var inst_16113 = cljs.core.first.call(null,inst_16104);
var state_16138__$1 = state_16138;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16138__$1,(20),out,inst_16113);
} else {
if((state_val_16139 === (8))){
var inst_16092 = (state_16138[(8)]);
var inst_16093 = (state_16138[(9)]);
var inst_16095 = (inst_16093 < inst_16092);
var inst_16096 = inst_16095;
var state_16138__$1 = state_16138;
if(cljs.core.truth_(inst_16096)){
var statearr_16172_16203 = state_16138__$1;
(statearr_16172_16203[(1)] = (10));

} else {
var statearr_16173_16204 = state_16138__$1;
(statearr_16173_16204[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__))
;
return ((function (switch__7673__auto__,c__7694__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____0 = (function (){
var statearr_16177 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16177[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__);

(statearr_16177[(1)] = (1));

return statearr_16177;
});
var cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____1 = (function (state_16138){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_16138);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e16178){if((e16178 instanceof Object)){
var ex__7677__auto__ = e16178;
var statearr_16179_16205 = state_16138;
(statearr_16179_16205[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16138);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16178;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16206 = state_16138;
state_16138 = G__16206;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__ = function(state_16138){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____1.call(this,state_16138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__7674__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__))
})();
var state__7696__auto__ = (function (){var statearr_16180 = f__7695__auto__.call(null);
(statearr_16180[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_16180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__))
);

return c__7694__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args16207 = [];
var len__5627__auto___16210 = arguments.length;
var i__5628__auto___16211 = (0);
while(true){
if((i__5628__auto___16211 < len__5627__auto___16210)){
args16207.push((arguments[i__5628__auto___16211]));

var G__16212 = (i__5628__auto___16211 + (1));
i__5628__auto___16211 = G__16212;
continue;
} else {
}
break;
}

var G__16209 = args16207.length;
switch (G__16209) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16207.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args16214 = [];
var len__5627__auto___16217 = arguments.length;
var i__5628__auto___16218 = (0);
while(true){
if((i__5628__auto___16218 < len__5627__auto___16217)){
args16214.push((arguments[i__5628__auto___16218]));

var G__16219 = (i__5628__auto___16218 + (1));
i__5628__auto___16218 = G__16219;
continue;
} else {
}
break;
}

var G__16216 = args16214.length;
switch (G__16216) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16214.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args16221 = [];
var len__5627__auto___16272 = arguments.length;
var i__5628__auto___16273 = (0);
while(true){
if((i__5628__auto___16273 < len__5627__auto___16272)){
args16221.push((arguments[i__5628__auto___16273]));

var G__16274 = (i__5628__auto___16273 + (1));
i__5628__auto___16273 = G__16274;
continue;
} else {
}
break;
}

var G__16223 = args16221.length;
switch (G__16223) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16221.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___16276 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___16276,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___16276,out){
return (function (state_16247){
var state_val_16248 = (state_16247[(1)]);
if((state_val_16248 === (7))){
var inst_16242 = (state_16247[(2)]);
var state_16247__$1 = state_16247;
var statearr_16249_16277 = state_16247__$1;
(statearr_16249_16277[(2)] = inst_16242);

(statearr_16249_16277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (1))){
var inst_16224 = null;
var state_16247__$1 = (function (){var statearr_16250 = state_16247;
(statearr_16250[(7)] = inst_16224);

return statearr_16250;
})();
var statearr_16251_16278 = state_16247__$1;
(statearr_16251_16278[(2)] = null);

(statearr_16251_16278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (4))){
var inst_16227 = (state_16247[(8)]);
var inst_16227__$1 = (state_16247[(2)]);
var inst_16228 = (inst_16227__$1 == null);
var inst_16229 = cljs.core.not.call(null,inst_16228);
var state_16247__$1 = (function (){var statearr_16252 = state_16247;
(statearr_16252[(8)] = inst_16227__$1);

return statearr_16252;
})();
if(inst_16229){
var statearr_16253_16279 = state_16247__$1;
(statearr_16253_16279[(1)] = (5));

} else {
var statearr_16254_16280 = state_16247__$1;
(statearr_16254_16280[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (6))){
var state_16247__$1 = state_16247;
var statearr_16255_16281 = state_16247__$1;
(statearr_16255_16281[(2)] = null);

(statearr_16255_16281[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (3))){
var inst_16244 = (state_16247[(2)]);
var inst_16245 = cljs.core.async.close_BANG_.call(null,out);
var state_16247__$1 = (function (){var statearr_16256 = state_16247;
(statearr_16256[(9)] = inst_16244);

return statearr_16256;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16247__$1,inst_16245);
} else {
if((state_val_16248 === (2))){
var state_16247__$1 = state_16247;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16247__$1,(4),ch);
} else {
if((state_val_16248 === (11))){
var inst_16227 = (state_16247[(8)]);
var inst_16236 = (state_16247[(2)]);
var inst_16224 = inst_16227;
var state_16247__$1 = (function (){var statearr_16257 = state_16247;
(statearr_16257[(7)] = inst_16224);

(statearr_16257[(10)] = inst_16236);

return statearr_16257;
})();
var statearr_16258_16282 = state_16247__$1;
(statearr_16258_16282[(2)] = null);

(statearr_16258_16282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (9))){
var inst_16227 = (state_16247[(8)]);
var state_16247__$1 = state_16247;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16247__$1,(11),out,inst_16227);
} else {
if((state_val_16248 === (5))){
var inst_16227 = (state_16247[(8)]);
var inst_16224 = (state_16247[(7)]);
var inst_16231 = cljs.core._EQ_.call(null,inst_16227,inst_16224);
var state_16247__$1 = state_16247;
if(inst_16231){
var statearr_16260_16283 = state_16247__$1;
(statearr_16260_16283[(1)] = (8));

} else {
var statearr_16261_16284 = state_16247__$1;
(statearr_16261_16284[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (10))){
var inst_16239 = (state_16247[(2)]);
var state_16247__$1 = state_16247;
var statearr_16262_16285 = state_16247__$1;
(statearr_16262_16285[(2)] = inst_16239);

(statearr_16262_16285[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (8))){
var inst_16224 = (state_16247[(7)]);
var tmp16259 = inst_16224;
var inst_16224__$1 = tmp16259;
var state_16247__$1 = (function (){var statearr_16263 = state_16247;
(statearr_16263[(7)] = inst_16224__$1);

return statearr_16263;
})();
var statearr_16264_16286 = state_16247__$1;
(statearr_16264_16286[(2)] = null);

(statearr_16264_16286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___16276,out))
;
return ((function (switch__7673__auto__,c__7694__auto___16276,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_16268 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16268[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_16268[(1)] = (1));

return statearr_16268;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_16247){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_16247);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e16269){if((e16269 instanceof Object)){
var ex__7677__auto__ = e16269;
var statearr_16270_16287 = state_16247;
(statearr_16270_16287[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16247);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16269;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16288 = state_16247;
state_16247 = G__16288;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_16247){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_16247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___16276,out))
})();
var state__7696__auto__ = (function (){var statearr_16271 = f__7695__auto__.call(null);
(statearr_16271[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___16276);

return statearr_16271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___16276,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args16289 = [];
var len__5627__auto___16359 = arguments.length;
var i__5628__auto___16360 = (0);
while(true){
if((i__5628__auto___16360 < len__5627__auto___16359)){
args16289.push((arguments[i__5628__auto___16360]));

var G__16361 = (i__5628__auto___16360 + (1));
i__5628__auto___16360 = G__16361;
continue;
} else {
}
break;
}

var G__16291 = args16289.length;
switch (G__16291) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16289.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___16363 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___16363,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___16363,out){
return (function (state_16329){
var state_val_16330 = (state_16329[(1)]);
if((state_val_16330 === (7))){
var inst_16325 = (state_16329[(2)]);
var state_16329__$1 = state_16329;
var statearr_16331_16364 = state_16329__$1;
(statearr_16331_16364[(2)] = inst_16325);

(statearr_16331_16364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16330 === (1))){
var inst_16292 = (new Array(n));
var inst_16293 = inst_16292;
var inst_16294 = (0);
var state_16329__$1 = (function (){var statearr_16332 = state_16329;
(statearr_16332[(7)] = inst_16294);

(statearr_16332[(8)] = inst_16293);

return statearr_16332;
})();
var statearr_16333_16365 = state_16329__$1;
(statearr_16333_16365[(2)] = null);

(statearr_16333_16365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16330 === (4))){
var inst_16297 = (state_16329[(9)]);
var inst_16297__$1 = (state_16329[(2)]);
var inst_16298 = (inst_16297__$1 == null);
var inst_16299 = cljs.core.not.call(null,inst_16298);
var state_16329__$1 = (function (){var statearr_16334 = state_16329;
(statearr_16334[(9)] = inst_16297__$1);

return statearr_16334;
})();
if(inst_16299){
var statearr_16335_16366 = state_16329__$1;
(statearr_16335_16366[(1)] = (5));

} else {
var statearr_16336_16367 = state_16329__$1;
(statearr_16336_16367[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16330 === (15))){
var inst_16319 = (state_16329[(2)]);
var state_16329__$1 = state_16329;
var statearr_16337_16368 = state_16329__$1;
(statearr_16337_16368[(2)] = inst_16319);

(statearr_16337_16368[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16330 === (13))){
var state_16329__$1 = state_16329;
var statearr_16338_16369 = state_16329__$1;
(statearr_16338_16369[(2)] = null);

(statearr_16338_16369[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16330 === (6))){
var inst_16294 = (state_16329[(7)]);
var inst_16315 = (inst_16294 > (0));
var state_16329__$1 = state_16329;
if(cljs.core.truth_(inst_16315)){
var statearr_16339_16370 = state_16329__$1;
(statearr_16339_16370[(1)] = (12));

} else {
var statearr_16340_16371 = state_16329__$1;
(statearr_16340_16371[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16330 === (3))){
var inst_16327 = (state_16329[(2)]);
var state_16329__$1 = state_16329;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16329__$1,inst_16327);
} else {
if((state_val_16330 === (12))){
var inst_16293 = (state_16329[(8)]);
var inst_16317 = cljs.core.vec.call(null,inst_16293);
var state_16329__$1 = state_16329;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16329__$1,(15),out,inst_16317);
} else {
if((state_val_16330 === (2))){
var state_16329__$1 = state_16329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16329__$1,(4),ch);
} else {
if((state_val_16330 === (11))){
var inst_16309 = (state_16329[(2)]);
var inst_16310 = (new Array(n));
var inst_16293 = inst_16310;
var inst_16294 = (0);
var state_16329__$1 = (function (){var statearr_16341 = state_16329;
(statearr_16341[(10)] = inst_16309);

(statearr_16341[(7)] = inst_16294);

(statearr_16341[(8)] = inst_16293);

return statearr_16341;
})();
var statearr_16342_16372 = state_16329__$1;
(statearr_16342_16372[(2)] = null);

(statearr_16342_16372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16330 === (9))){
var inst_16293 = (state_16329[(8)]);
var inst_16307 = cljs.core.vec.call(null,inst_16293);
var state_16329__$1 = state_16329;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16329__$1,(11),out,inst_16307);
} else {
if((state_val_16330 === (5))){
var inst_16297 = (state_16329[(9)]);
var inst_16302 = (state_16329[(11)]);
var inst_16294 = (state_16329[(7)]);
var inst_16293 = (state_16329[(8)]);
var inst_16301 = (inst_16293[inst_16294] = inst_16297);
var inst_16302__$1 = (inst_16294 + (1));
var inst_16303 = (inst_16302__$1 < n);
var state_16329__$1 = (function (){var statearr_16343 = state_16329;
(statearr_16343[(12)] = inst_16301);

(statearr_16343[(11)] = inst_16302__$1);

return statearr_16343;
})();
if(cljs.core.truth_(inst_16303)){
var statearr_16344_16373 = state_16329__$1;
(statearr_16344_16373[(1)] = (8));

} else {
var statearr_16345_16374 = state_16329__$1;
(statearr_16345_16374[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16330 === (14))){
var inst_16322 = (state_16329[(2)]);
var inst_16323 = cljs.core.async.close_BANG_.call(null,out);
var state_16329__$1 = (function (){var statearr_16347 = state_16329;
(statearr_16347[(13)] = inst_16322);

return statearr_16347;
})();
var statearr_16348_16375 = state_16329__$1;
(statearr_16348_16375[(2)] = inst_16323);

(statearr_16348_16375[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16330 === (10))){
var inst_16313 = (state_16329[(2)]);
var state_16329__$1 = state_16329;
var statearr_16349_16376 = state_16329__$1;
(statearr_16349_16376[(2)] = inst_16313);

(statearr_16349_16376[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16330 === (8))){
var inst_16302 = (state_16329[(11)]);
var inst_16293 = (state_16329[(8)]);
var tmp16346 = inst_16293;
var inst_16293__$1 = tmp16346;
var inst_16294 = inst_16302;
var state_16329__$1 = (function (){var statearr_16350 = state_16329;
(statearr_16350[(7)] = inst_16294);

(statearr_16350[(8)] = inst_16293__$1);

return statearr_16350;
})();
var statearr_16351_16377 = state_16329__$1;
(statearr_16351_16377[(2)] = null);

(statearr_16351_16377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___16363,out))
;
return ((function (switch__7673__auto__,c__7694__auto___16363,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_16355 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16355[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_16355[(1)] = (1));

return statearr_16355;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_16329){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_16329);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e16356){if((e16356 instanceof Object)){
var ex__7677__auto__ = e16356;
var statearr_16357_16378 = state_16329;
(statearr_16357_16378[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16329);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16356;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16379 = state_16329;
state_16329 = G__16379;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_16329){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_16329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___16363,out))
})();
var state__7696__auto__ = (function (){var statearr_16358 = f__7695__auto__.call(null);
(statearr_16358[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___16363);

return statearr_16358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___16363,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args16380 = [];
var len__5627__auto___16454 = arguments.length;
var i__5628__auto___16455 = (0);
while(true){
if((i__5628__auto___16455 < len__5627__auto___16454)){
args16380.push((arguments[i__5628__auto___16455]));

var G__16456 = (i__5628__auto___16455 + (1));
i__5628__auto___16455 = G__16456;
continue;
} else {
}
break;
}

var G__16382 = args16380.length;
switch (G__16382) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16380.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7694__auto___16458 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto___16458,out){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto___16458,out){
return (function (state_16424){
var state_val_16425 = (state_16424[(1)]);
if((state_val_16425 === (7))){
var inst_16420 = (state_16424[(2)]);
var state_16424__$1 = state_16424;
var statearr_16426_16459 = state_16424__$1;
(statearr_16426_16459[(2)] = inst_16420);

(statearr_16426_16459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (1))){
var inst_16383 = [];
var inst_16384 = inst_16383;
var inst_16385 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_16424__$1 = (function (){var statearr_16427 = state_16424;
(statearr_16427[(7)] = inst_16384);

(statearr_16427[(8)] = inst_16385);

return statearr_16427;
})();
var statearr_16428_16460 = state_16424__$1;
(statearr_16428_16460[(2)] = null);

(statearr_16428_16460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (4))){
var inst_16388 = (state_16424[(9)]);
var inst_16388__$1 = (state_16424[(2)]);
var inst_16389 = (inst_16388__$1 == null);
var inst_16390 = cljs.core.not.call(null,inst_16389);
var state_16424__$1 = (function (){var statearr_16429 = state_16424;
(statearr_16429[(9)] = inst_16388__$1);

return statearr_16429;
})();
if(inst_16390){
var statearr_16430_16461 = state_16424__$1;
(statearr_16430_16461[(1)] = (5));

} else {
var statearr_16431_16462 = state_16424__$1;
(statearr_16431_16462[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (15))){
var inst_16414 = (state_16424[(2)]);
var state_16424__$1 = state_16424;
var statearr_16432_16463 = state_16424__$1;
(statearr_16432_16463[(2)] = inst_16414);

(statearr_16432_16463[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (13))){
var state_16424__$1 = state_16424;
var statearr_16433_16464 = state_16424__$1;
(statearr_16433_16464[(2)] = null);

(statearr_16433_16464[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (6))){
var inst_16384 = (state_16424[(7)]);
var inst_16409 = inst_16384.length;
var inst_16410 = (inst_16409 > (0));
var state_16424__$1 = state_16424;
if(cljs.core.truth_(inst_16410)){
var statearr_16434_16465 = state_16424__$1;
(statearr_16434_16465[(1)] = (12));

} else {
var statearr_16435_16466 = state_16424__$1;
(statearr_16435_16466[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (3))){
var inst_16422 = (state_16424[(2)]);
var state_16424__$1 = state_16424;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16424__$1,inst_16422);
} else {
if((state_val_16425 === (12))){
var inst_16384 = (state_16424[(7)]);
var inst_16412 = cljs.core.vec.call(null,inst_16384);
var state_16424__$1 = state_16424;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16424__$1,(15),out,inst_16412);
} else {
if((state_val_16425 === (2))){
var state_16424__$1 = state_16424;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16424__$1,(4),ch);
} else {
if((state_val_16425 === (11))){
var inst_16392 = (state_16424[(10)]);
var inst_16388 = (state_16424[(9)]);
var inst_16402 = (state_16424[(2)]);
var inst_16403 = [];
var inst_16404 = inst_16403.push(inst_16388);
var inst_16384 = inst_16403;
var inst_16385 = inst_16392;
var state_16424__$1 = (function (){var statearr_16436 = state_16424;
(statearr_16436[(11)] = inst_16402);

(statearr_16436[(7)] = inst_16384);

(statearr_16436[(12)] = inst_16404);

(statearr_16436[(8)] = inst_16385);

return statearr_16436;
})();
var statearr_16437_16467 = state_16424__$1;
(statearr_16437_16467[(2)] = null);

(statearr_16437_16467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (9))){
var inst_16384 = (state_16424[(7)]);
var inst_16400 = cljs.core.vec.call(null,inst_16384);
var state_16424__$1 = state_16424;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16424__$1,(11),out,inst_16400);
} else {
if((state_val_16425 === (5))){
var inst_16392 = (state_16424[(10)]);
var inst_16388 = (state_16424[(9)]);
var inst_16385 = (state_16424[(8)]);
var inst_16392__$1 = f.call(null,inst_16388);
var inst_16393 = cljs.core._EQ_.call(null,inst_16392__$1,inst_16385);
var inst_16394 = cljs.core.keyword_identical_QMARK_.call(null,inst_16385,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_16395 = (inst_16393) || (inst_16394);
var state_16424__$1 = (function (){var statearr_16438 = state_16424;
(statearr_16438[(10)] = inst_16392__$1);

return statearr_16438;
})();
if(cljs.core.truth_(inst_16395)){
var statearr_16439_16468 = state_16424__$1;
(statearr_16439_16468[(1)] = (8));

} else {
var statearr_16440_16469 = state_16424__$1;
(statearr_16440_16469[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (14))){
var inst_16417 = (state_16424[(2)]);
var inst_16418 = cljs.core.async.close_BANG_.call(null,out);
var state_16424__$1 = (function (){var statearr_16442 = state_16424;
(statearr_16442[(13)] = inst_16417);

return statearr_16442;
})();
var statearr_16443_16470 = state_16424__$1;
(statearr_16443_16470[(2)] = inst_16418);

(statearr_16443_16470[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (10))){
var inst_16407 = (state_16424[(2)]);
var state_16424__$1 = state_16424;
var statearr_16444_16471 = state_16424__$1;
(statearr_16444_16471[(2)] = inst_16407);

(statearr_16444_16471[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (8))){
var inst_16392 = (state_16424[(10)]);
var inst_16384 = (state_16424[(7)]);
var inst_16388 = (state_16424[(9)]);
var inst_16397 = inst_16384.push(inst_16388);
var tmp16441 = inst_16384;
var inst_16384__$1 = tmp16441;
var inst_16385 = inst_16392;
var state_16424__$1 = (function (){var statearr_16445 = state_16424;
(statearr_16445[(7)] = inst_16384__$1);

(statearr_16445[(14)] = inst_16397);

(statearr_16445[(8)] = inst_16385);

return statearr_16445;
})();
var statearr_16446_16472 = state_16424__$1;
(statearr_16446_16472[(2)] = null);

(statearr_16446_16472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto___16458,out))
;
return ((function (switch__7673__auto__,c__7694__auto___16458,out){
return (function() {
var cljs$core$async$state_machine__7674__auto__ = null;
var cljs$core$async$state_machine__7674__auto____0 = (function (){
var statearr_16450 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16450[(0)] = cljs$core$async$state_machine__7674__auto__);

(statearr_16450[(1)] = (1));

return statearr_16450;
});
var cljs$core$async$state_machine__7674__auto____1 = (function (state_16424){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_16424);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e16451){if((e16451 instanceof Object)){
var ex__7677__auto__ = e16451;
var statearr_16452_16473 = state_16424;
(statearr_16452_16473[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16424);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16451;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16474 = state_16424;
state_16424 = G__16474;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
cljs$core$async$state_machine__7674__auto__ = function(state_16424){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7674__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7674__auto____1.call(this,state_16424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7674__auto____0;
cljs$core$async$state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7674__auto____1;
return cljs$core$async$state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto___16458,out))
})();
var state__7696__auto__ = (function (){var statearr_16453 = f__7695__auto__.call(null);
(statearr_16453[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto___16458);

return statearr_16453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto___16458,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
