// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.utils');
goog.require('hatti.utils.om.state');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten.call(null,(function (){var iter__5341__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__9143(s__9144){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__9144__$1 = s__9144;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__9144__$1);
if(temp__4425__auto__){
var s__9144__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9144__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__9144__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__9146 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__9145 = (0);
while(true){
if((i__9145 < size__5340__auto__)){
var datum = cljs.core._nth.call(null,c__5339__auto__,i__9145);
cljs.core.chunk_append.call(null,b__9146,(function (){var iter__5341__auto__ = ((function (i__9145,datum,c__5339__auto__,size__5340__auto__,b__9146,s__9144__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__9143_$_iter__9155(s__9156){
return (new cljs.core.LazySeq(null,((function (i__9145,datum,c__5339__auto__,size__5340__auto__,b__9146,s__9144__$2,temp__4425__auto__,osmfields){
return (function (){
var s__9156__$1 = s__9156;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__9156__$1);
if(temp__4425__auto____$1){
var s__9156__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9156__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first.call(null,s__9156__$2);
var size__5340__auto____$1 = cljs.core.count.call(null,c__5339__auto____$1);
var b__9158 = cljs.core.chunk_buffer.call(null,size__5340__auto____$1);
if((function (){var i__9157 = (0);
while(true){
if((i__9157 < size__5340__auto____$1)){
var field = cljs.core._nth.call(null,c__5339__auto____$1,i__9157);
cljs.core.chunk_append.call(null,b__9158,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__9163 = (i__9157 + (1));
i__9157 = G__9163;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9158),hatti$ona$post_process$ona_osm_link_$_iter__9143_$_iter__9155.call(null,cljs.core.chunk_rest.call(null,s__9156__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9158),null);
}
} else {
var field = cljs.core.first.call(null,s__9156__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__9143_$_iter__9155.call(null,cljs.core.rest.call(null,s__9156__$2)));
}
} else {
return null;
}
break;
}
});})(i__9145,datum,c__5339__auto__,size__5340__auto__,b__9146,s__9144__$2,temp__4425__auto__,osmfields))
,null,null));
});})(i__9145,datum,c__5339__auto__,size__5340__auto__,b__9146,s__9144__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__.call(null,osmfields);
})());

var G__9164 = (i__9145 + (1));
i__9145 = G__9164;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9146),hatti$ona$post_process$ona_osm_link_$_iter__9143.call(null,cljs.core.chunk_rest.call(null,s__9144__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9146),null);
}
} else {
var datum = cljs.core.first.call(null,s__9144__$2);
return cljs.core.cons.call(null,(function (){var iter__5341__auto__ = ((function (datum,s__9144__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__9143_$_iter__9159(s__9160){
return (new cljs.core.LazySeq(null,((function (datum,s__9144__$2,temp__4425__auto__,osmfields){
return (function (){
var s__9160__$1 = s__9160;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__9160__$1);
if(temp__4425__auto____$1){
var s__9160__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9160__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__9160__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__9162 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__9161 = (0);
while(true){
if((i__9161 < size__5340__auto__)){
var field = cljs.core._nth.call(null,c__5339__auto__,i__9161);
cljs.core.chunk_append.call(null,b__9162,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__9165 = (i__9161 + (1));
i__9161 = G__9165;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9162),hatti$ona$post_process$ona_osm_link_$_iter__9143_$_iter__9159.call(null,cljs.core.chunk_rest.call(null,s__9160__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9162),null);
}
} else {
var field = cljs.core.first.call(null,s__9160__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__9143_$_iter__9159.call(null,cljs.core.rest.call(null,s__9160__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__9144__$2,temp__4425__auto__,osmfields))
,null,null));
});})(datum,s__9144__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__.call(null,osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__9143.call(null,cljs.core.rest.call(null,s__9144__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5341__auto__.call(null,data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.call(null,osmtogeojson(jQuery.parseXML(osm_xml_string)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link.call(null,data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson.call(null,osm_xml);
var featureset = osmgeo.call(null,new cljs.core.Keyword(null,"features","features",-1146962336));
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__9186(s__9187){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__9187__$1 = s__9187;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__9187__$1);
if(temp__4425__auto__){
var s__9187__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9187__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__9187__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__9189 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__9188 = (0);
while(true){
if((i__9188 < size__5340__auto__)){
var map__9198 = cljs.core._nth.call(null,c__5339__auto__,i__9188);
var map__9198__$1 = ((((!((map__9198 == null)))?((((map__9198.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9198.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9198):map__9198);
var feature = map__9198__$1;
var type = cljs.core.get.call(null,map__9198__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__9198__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__9198__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
cljs.core.chunk_append.call(null,b__9189,(function (){var map__9200 = properties;
var map__9200__$1 = ((((!((map__9200 == null)))?((((map__9200.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9200.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9200):map__9200);
var type__$1 = cljs.core.get.call(null,map__9200__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__9200__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__9200__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})());

var G__9206 = (i__9188 + (1));
i__9188 = G__9206;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9189),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__9186.call(null,cljs.core.chunk_rest.call(null,s__9187__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9189),null);
}
} else {
var map__9202 = cljs.core.first.call(null,s__9187__$2);
var map__9202__$1 = ((((!((map__9202 == null)))?((((map__9202.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9202.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9202):map__9202);
var feature = map__9202__$1;
var type = cljs.core.get.call(null,map__9202__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__9202__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__9202__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
return cljs.core.cons.call(null,(function (){var map__9204 = properties;
var map__9204__$1 = ((((!((map__9204 == null)))?((((map__9204.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9204.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9204):map__9204);
var type__$1 = cljs.core.get.call(null,map__9204__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__9204__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__9204__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__9186.call(null,cljs.core.rest.call(null,s__9187__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5341__auto__.call(null,featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq.call(null,osm_fields)){
var data = cljs.core.get_in.call(null,app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data.call(null,data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__9207_SHARP_){
return cljs.core.re_find.call(null,/[-]?[0-9]+/,p1__9207_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4423__auto__ = osm_data.call(null,osm_val__GT_osm_id.call(null,osm_val));
if(cljs.core.truth_(temp__4423__auto__)){
var osm_submission_data = temp__4423__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5341__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__9216(s__9217){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__9217__$1 = s__9217;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__9217__$1);
if(temp__4425__auto__){
var s__9217__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9217__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__9217__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__9219 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__9218 = (0);
while(true){
if((i__9218 < size__5340__auto__)){
var datum = cljs.core._nth.call(null,c__5339__auto__,i__9218);
cljs.core.chunk_append.call(null,b__9219,cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__9224 = (i__9218 + (1));
i__9218 = G__9224;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9219),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__9216.call(null,cljs.core.chunk_rest.call(null,s__9217__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9219),null);
}
} else {
var datum = cljs.core.first.call(null,s__9217__$2);
return cljs.core.cons.call(null,cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__9216.call(null,cljs.core.rest.call(null,s__9217__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5341__auto__.call(null,data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__9220 = cljs.core.seq.call(null,osm_fields);
var chunk__9221 = null;
var count__9222 = (0);
var i__9223 = (0);
while(true){
if((i__9223 < count__9222)){
var osm_field = cljs.core._nth.call(null,chunk__9221,i__9223);
hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__9225 = seq__9220;
var G__9226 = chunk__9221;
var G__9227 = count__9222;
var G__9228 = (i__9223 + (1));
seq__9220 = G__9225;
chunk__9221 = G__9226;
count__9222 = G__9227;
i__9223 = G__9228;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__9220);
if(temp__4425__auto__){
var seq__9220__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9220__$1)){
var c__5372__auto__ = cljs.core.chunk_first.call(null,seq__9220__$1);
var G__9229 = cljs.core.chunk_rest.call(null,seq__9220__$1);
var G__9230 = c__5372__auto__;
var G__9231 = cljs.core.count.call(null,c__5372__auto__);
var G__9232 = (0);
seq__9220 = G__9229;
chunk__9221 = G__9230;
count__9222 = G__9231;
i__9223 = G__9232;
continue;
} else {
var osm_field = cljs.core.first.call(null,seq__9220__$1);
hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__9233 = cljs.core.next.call(null,seq__9220__$1);
var G__9234 = null;
var G__9235 = (0);
var G__9236 = (0);
seq__9220 = G__9233;
chunk__9221 = G__9234;
count__9222 = G__9235;
i__9223 = G__9236;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.call(null,media_obj,"id");
var fname = cljs.core.get.call(null,media_obj,"filename");
var file_url = hatti.ona.urls.media_url.call(null,media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"filename","filename",-1428840783),fname,new cljs.core.Keyword(null,"download_url","download_url",-2115471203),file_url,new cljs.core.Keyword(null,"small_download_url","small_download_url",1654303565),[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4569__auto__ = attachments;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.call(null,record,"_attachments");
}
})();
var fnames = cljs.core.map.call(null,((function (attachments__$1){
return (function (p1__9237_SHARP_){
return hatti.utils.last_url_param.call(null,cljs.core.get.call(null,p1__9237_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap.call(null,fnames,cljs.core.map.call(null,hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.call(null,fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5634__auto__ = [];
var len__5627__auto___9248 = arguments.length;
var i__5628__auto___9249 = (0);
while(true){
if((i__5628__auto___9249 < len__5627__auto___9248)){
args__5634__auto__.push((arguments[i__5628__auto___9249]));

var G__9250 = (i__5628__auto___9249 + (1));
i__5628__auto___9249 = G__9250;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__9241){
var map__9242 = p__9241;
var map__9242__$1 = ((((!((map__9242 == null)))?((((map__9242.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9242.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9242):map__9242);
var attachments = cljs.core.get.call(null,map__9242__$1,new cljs.core.Keyword(null,"attachments","attachments",-1535547830));
var image_fields = cljs.core.filter.call(null,hatti.ona.forms.image_QMARK_,flat_form);
var iter__5341__auto__ = ((function (image_fields,map__9242,map__9242__$1,attachments){
return (function hatti$ona$post_process$iter__9244(s__9245){
return (new cljs.core.LazySeq(null,((function (image_fields,map__9242,map__9242__$1,attachments){
return (function (){
var s__9245__$1 = s__9245;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__9245__$1);
if(temp__4425__auto__){
var s__9245__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9245__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__9245__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__9247 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__9246 = (0);
while(true){
if((i__9246 < size__5340__auto__)){
var record = cljs.core._nth.call(null,c__5339__auto__,i__9246);
cljs.core.chunk_append.call(null,b__9247,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (i__9246,attach_map,record,c__5339__auto__,size__5340__auto__,b__9247,s__9245__$2,temp__4425__auto__,image_fields,map__9242,map__9242__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__9246,attach_map,record,c__5339__auto__,size__5340__auto__,b__9247,s__9245__$2,temp__4425__auto__,image_fields,map__9242,map__9242__$1,attachments))
,record,image_fields);
})());

var G__9251 = (i__9246 + (1));
i__9246 = G__9251;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9247),hatti$ona$post_process$iter__9244.call(null,cljs.core.chunk_rest.call(null,s__9245__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9247),null);
}
} else {
var record = cljs.core.first.call(null,s__9245__$2);
return cljs.core.cons.call(null,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (attach_map,record,s__9245__$2,temp__4425__auto__,image_fields,map__9242,map__9242__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__9245__$2,temp__4425__auto__,image_fields,map__9242,map__9242__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__9244.call(null,cljs.core.rest.call(null,s__9245__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__9242,map__9242__$1,attachments))
,null,null));
});})(image_fields,map__9242,map__9242__$1,attachments))
;
return iter__5341__auto__.call(null,data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq9238){
var G__9239 = cljs.core.first.call(null,seq9238);
var seq9238__$1 = cljs.core.next.call(null,seq9238);
var G__9240 = cljs.core.first.call(null,seq9238__$1);
var seq9238__$2 = cljs.core.next.call(null,seq9238__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__9239,G__9240,seq9238__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.call(null,hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.call(null,record,key,hatti.ona.post_process.integrate_attachments.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.call(null,record,key),new cljs.core.Keyword(null,"attachments","attachments",-1535547830),cljs.core.get.call(null,record,"_attachments")));
});})(repeat_fields))
;
var iter__5341__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__9256(s__9257){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__9257__$1 = s__9257;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__9257__$1);
if(temp__4425__auto__){
var s__9257__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9257__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__9257__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__9259 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__9258 = (0);
while(true){
if((i__9258 < size__5340__auto__)){
var record = cljs.core._nth.call(null,c__5339__auto__,i__9258);
cljs.core.chunk_append.call(null,b__9259,cljs.core.reduce.call(null,integrate,record,repeat_fields));

var G__9260 = (i__9258 + (1));
i__9258 = G__9260;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9259),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__9256.call(null,cljs.core.chunk_rest.call(null,s__9257__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9259),null);
}
} else {
var record = cljs.core.first.call(null,s__9257__$2);
return cljs.core.cons.call(null,cljs.core.reduce.call(null,integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__9256.call(null,cljs.core.rest.call(null,s__9257__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5341__auto__.call(null,data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___9268 = arguments.length;
var i__5628__auto___9269 = (0);
while(true){
if((i__5628__auto___9269 < len__5627__auto___9268)){
args__5634__auto__.push((arguments[i__5628__auto___9269]));

var G__9270 = (i__5628__auto___9269 + (1));
i__5628__auto___9269 = G__9270;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__9265){
var map__9266 = p__9265;
var map__9266__$1 = ((((!((map__9266 == null)))?((((map__9266.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9266.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9266):map__9266);
var app_data_keys = cljs.core.get.call(null,map__9266__$1,new cljs.core.Keyword(null,"app-data-keys","app-data-keys",-662378404),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
return hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,app_data_keys,((function (map__9266,map__9266__$1,app_data_keys){
return (function (p1__9261_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats.call(null,flat_form,hatti.ona.post_process.integrate_attachments.call(null,flat_form,p1__9261_SHARP_));
});})(map__9266,map__9266__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq9262){
var G__9263 = cljs.core.first.call(null,seq9262);
var seq9262__$1 = cljs.core.next.call(null,seq9262);
var G__9264 = cljs.core.first.call(null,seq9262__$1);
var seq9262__$2 = cljs.core.next.call(null,seq9262__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9263,G__9264,seq9262__$2);
});
