// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.map.viewby');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('hatti.utils');
goog.require('hatti.charting');
goog.require('hatti.ona.forms');
goog.require('hatti.map.style');
goog.require('hatti.map.utils');
hatti.map.viewby.marker_styler = (function hatti$map$viewby$marker_styler(id_color,id_selected_QMARK_){
return (function (marker){
var id = hatti.map.utils.get_id.call(null,marker);
var geotype = hatti.map.utils.marker__GT_geotype.call(null,marker);
var color_key = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"line","line",212345235),geotype))?new cljs.core.Keyword(null,"color","color",1011675173):new cljs.core.Keyword(null,"fillColor","fillColor",-176906116));
return cljs.core.PersistentArrayMap.fromArray([color_key,(cljs.core.truth_(id_selected_QMARK_.call(null,id))?id_color.call(null,id):hatti.map.style.grey)], true, false);
});
});
hatti.map.viewby.move_nil_to_end = (function hatti$map$viewby$move_nil_to_end(s){
var no_nil = cljs.core.vec.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,s));
if(cljs.core._EQ_.call(null,s,no_nil)){
return s;
} else {
return cljs.core.conj.call(null,no_nil,null);
}
});
hatti.map.viewby.all_but_nil_selected = (function hatti$map$viewby$all_but_nil_selected(answers){
return cljs.core.merge.call(null,cljs.core.zipmap.call(null,answers,cljs.core.repeat.call(null,true)),new cljs.core.PersistentArrayMap(null, 1, [null,false], null));
});
/**
 * Preproccesses answers depending on the field. For multi-selects, return type
 * is a list of list of strings. For other types, a list of strings.
 */
hatti.map.viewby.preprocess_answers = (function hatti$map$viewby$preprocess_answers(field,raw_answers){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_.call(null,field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_.call(null,field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_.call(null,field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))){
return hatti.charting.evenly_spaced_bins.call(null,raw_answers,(5),"int");
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))){
return hatti.charting.evenly_spaced_bins.call(null,raw_answers,(5),"date");
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))){
return cljs.core.map.call(null,(function (p1__8088_SHARP_){
if(cljs.core.truth_(p1__8088_SHARP_)){
return clojure.string.split.call(null,p1__8088_SHARP_,/ /);
} else {
return null;
}
}),raw_answers);
} else {
return null;
}
}
}
}
}
}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_info = (function hatti$map$viewby$viewby_info(field,raw_answers,ids){
var fname = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var preprocessed_answers = hatti.map.viewby.preprocess_answers.call(null,field,raw_answers);
var answer__GT_count = cljs.core.frequencies.call(null,cljs.core.flatten.call(null,preprocessed_answers));
var sorted_answers = (cljs.core.truth_((function (){var or__4569__auto__ = hatti.ona.forms.categorical_QMARK_.call(null,field);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = hatti.ona.forms.text_QMARK_.call(null,field);
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_.call(null,field);
}
}
})())?cljs.core.map.call(null,cljs.core.first,cljs.core.sort_by.call(null,cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__4569__auto__ = hatti.ona.forms.time_based_QMARK_.call(null,field);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_.call(null,field);
}
})())?new cljs.core.Keyword(null,"bins","bins",1670395210).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,preprocessed_answers)):null));
var sorted_answers_with_nil_at_end = hatti.map.viewby.move_nil_to_end.call(null,sorted_answers);
var answer__GT_color_map = hatti.map.style.answer__GT_color.call(null,field,sorted_answers);
var defaults = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"answers","answers",-2066449770),sorted_answers_with_nil_at_end,new cljs.core.Keyword(null,"id->answers","id->answers",-655129337),cljs.core.zipmap.call(null,ids,preprocessed_answers),new cljs.core.Keyword(null,"answer->count","answer->count",-99425122),answer__GT_count,new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958),hatti.map.viewby.all_but_nil_selected.call(null,sorted_answers),new cljs.core.Keyword(null,"answer->color","answer->color",-142632854),answer__GT_color_map,new cljs.core.Keyword(null,"visible-answers","visible-answers",-771956023),sorted_answers_with_nil_at_end,new cljs.core.Keyword(null,"field","field",-1302436500),field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))){
return cljs.core.merge.call(null,defaults,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id-color","id-color",-484052665),((function (fname,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults){
return (function (){
return cljs.core.first.call(null,cljs.core.vals.call(null,answer__GT_color_map));
});})(fname,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults))
], null));
} else {
return defaults;

}
});
/**
 * Generates id-color and id-selected? functions based on viewby-info.
 */
hatti.map.viewby.id_color_selected = (function hatti$map$viewby$id_color_selected(p__8091){
var map__8095 = p__8091;
var map__8095__$1 = ((((!((map__8095 == null)))?((((map__8095.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8095.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8095):map__8095);
var field = cljs.core.get.call(null,map__8095__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var id__GT_answers = cljs.core.get.call(null,map__8095__$1,new cljs.core.Keyword(null,"id->answers","id->answers",-655129337));
var answer__GT_color = cljs.core.get.call(null,map__8095__$1,new cljs.core.Keyword(null,"answer->color","answer->color",-142632854));
var answer__GT_selected_QMARK_ = cljs.core.get.call(null,map__8095__$1,new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958));
var G__8097 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(field);
switch (G__8097) {
case "select all that apply":
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id-color","id-color",-484052665),((function (G__8097,map__8095,map__8095__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (){
return cljs.core.first.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#f30"], null));
});})(G__8097,map__8095,map__8095__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,new cljs.core.Keyword(null,"id-selected?","id-selected?",1326938375),((function (G__8097,map__8095,map__8095__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (id){
var answers = id__GT_answers.call(null,id);
if((answers == null)){
return cljs.core.get.call(null,answer__GT_selected_QMARK_,answers);
} else {
return cljs.core.some.call(null,cljs.core.identity,cljs.core.map.call(null,answer__GT_selected_QMARK_,answers));
}
});})(G__8097,map__8095,map__8095__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

break;
default:
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id-color","id-color",-484052665),((function (G__8097,map__8095,map__8095__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__8089_SHARP_){
return answer__GT_color.call(null,id__GT_answers.call(null,p1__8089_SHARP_));
});})(G__8097,map__8095,map__8095__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,new cljs.core.Keyword(null,"id-selected?","id-selected?",1326938375),((function (G__8097,map__8095,map__8095__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__8090_SHARP_){
return answer__GT_selected_QMARK_.call(null,id__GT_answers.call(null,p1__8090_SHARP_));
});})(G__8097,map__8095,map__8095__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

}
});
hatti.map.viewby.view_by_BANG_ = (function hatti$map$viewby$view_by_BANG_(view_by_info,markers){
var map__8105 = hatti.map.viewby.id_color_selected.call(null,view_by_info);
var map__8105__$1 = ((((!((map__8105 == null)))?((((map__8105.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8105.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8105):map__8105);
var id_selected_QMARK_ = cljs.core.get.call(null,map__8105__$1,new cljs.core.Keyword(null,"id-selected?","id-selected?",1326938375));
var id_color = cljs.core.get.call(null,map__8105__$1,new cljs.core.Keyword(null,"id-color","id-color",-484052665));
var m__GT_s = hatti.map.viewby.marker_styler.call(null,id_color,id_selected_QMARK_);
var seq__8107 = cljs.core.seq.call(null,markers);
var chunk__8108 = null;
var count__8109 = (0);
var i__8110 = (0);
while(true){
if((i__8110 < count__8109)){
var marker = cljs.core._nth.call(null,chunk__8108,i__8110);
hatti.map.utils.re_style_marker.call(null,m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected.call(null,id_selected_QMARK_,marker);

var G__8111 = seq__8107;
var G__8112 = chunk__8108;
var G__8113 = count__8109;
var G__8114 = (i__8110 + (1));
seq__8107 = G__8111;
chunk__8108 = G__8112;
count__8109 = G__8113;
i__8110 = G__8114;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__8107);
if(temp__4425__auto__){
var seq__8107__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8107__$1)){
var c__5372__auto__ = cljs.core.chunk_first.call(null,seq__8107__$1);
var G__8115 = cljs.core.chunk_rest.call(null,seq__8107__$1);
var G__8116 = c__5372__auto__;
var G__8117 = cljs.core.count.call(null,c__5372__auto__);
var G__8118 = (0);
seq__8107 = G__8115;
chunk__8108 = G__8116;
count__8109 = G__8117;
i__8110 = G__8118;
continue;
} else {
var marker = cljs.core.first.call(null,seq__8107__$1);
hatti.map.utils.re_style_marker.call(null,m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected.call(null,id_selected_QMARK_,marker);

var G__8119 = cljs.core.next.call(null,seq__8107__$1);
var G__8120 = null;
var G__8121 = (0);
var G__8122 = (0);
seq__8107 = G__8119;
chunk__8108 = G__8120;
count__8109 = G__8121;
i__8110 = G__8122;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Given a list of answers + query, returns map from answers to true/false.
 * True if query is in the answer, false if not.
 */
hatti.map.viewby.filter_answer_data_structures = (function hatti$map$viewby$filter_answer_data_structures(answers,query,field,language){
var query_present_QMARK_ = (function (ans){
if(cljs.core.truth_(ans)){
return cljs.core.re_find.call(null,hatti.utils.safe_regex.call(null,query),hatti.ona.forms.format_answer.call(null,field,ans,language));
} else {
return null;
}
});
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"visible-answers","visible-answers",-771956023),cljs.core.filter.call(null,query_present_QMARK_,answers),new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958),cljs.core.zipmap.call(null,answers,cljs.core.map.call(null,query_present_QMARK_,answers))], null);
});
/**
 * This function appropriately toggles answer->selected? when answer is clicked
 * answer->selected? is a map from answers to true/false. Special rules:
 * First click = select the answer. If nothing clicked, make everything
 * clicked.
 */
hatti.map.viewby.toggle_answer_selected = (function hatti$map$viewby$toggle_answer_selected(answer__GT_selected_QMARK_,visible_answers,answer){
var all_answers = cljs.core.vals.call(null,answer__GT_selected_QMARK_);
var all_visible_selected_QMARK_ = ((function (all_answers){
return (function (a__GT_s,visible){
return cljs.core._EQ_.call(null,cljs.core.set.call(null,visible),cljs.core.set.call(null,cljs.core.keys.call(null,cljs.core.filter.call(null,cljs.core.second,a__GT_s))));
});})(all_answers))
;
if((answer == null)){
return answer__GT_selected_QMARK_;
} else {
if(cljs.core.truth_(all_visible_selected_QMARK_.call(null,answer__GT_selected_QMARK_,visible_answers))){
return cljs.core.merge.call(null,cljs.core.zipmap.call(null,all_answers,cljs.core.repeat.call(null,false)),cljs.core.PersistentArrayMap.fromArray([answer,true], true, false));
} else {
var toggled = cljs.core.update_in.call(null,answer__GT_selected_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer], null),cljs.core.not);
if(cljs.core.every_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.vals.call(null,toggled))){
return cljs.core.merge.call(null,cljs.core.zipmap.call(null,all_answers,cljs.core.repeat.call(null,false)),hatti.map.viewby.all_but_nil_selected.call(null,visible_answers));
} else {
return toggled;
}
}
}
});
