// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.utils');
goog.require('hatti.utils.om.state');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__5341__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__26917(s__26918){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__26918__$1 = s__26918;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__26918__$1);
if(temp__4425__auto__){
var s__26918__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26918__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__26918__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__26920 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__26919 = (0);
while(true){
if((i__26919 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__26919);
cljs.core.chunk_append(b__26920,(function (){var iter__5341__auto__ = ((function (i__26919,datum,c__5339__auto__,size__5340__auto__,b__26920,s__26918__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__26917_$_iter__26935(s__26936){
return (new cljs.core.LazySeq(null,((function (i__26919,datum,c__5339__auto__,size__5340__auto__,b__26920,s__26918__$2,temp__4425__auto__,osmfields){
return (function (){
var s__26936__$1 = s__26936;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__26936__$1);
if(temp__4425__auto____$1){
var s__26936__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__26936__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first(s__26936__$2);
var size__5340__auto____$1 = cljs.core.count(c__5339__auto____$1);
var b__26938 = cljs.core.chunk_buffer(size__5340__auto____$1);
if((function (){var i__26937 = (0);
while(true){
if((i__26937 < size__5340__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto____$1,i__26937);
cljs.core.chunk_append(b__26938,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__26947 = (i__26937 + (1));
i__26937 = G__26947;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26938),hatti$ona$post_process$ona_osm_link_$_iter__26917_$_iter__26935(cljs.core.chunk_rest(s__26936__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26938),null);
}
} else {
var field = cljs.core.first(s__26936__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__26917_$_iter__26935(cljs.core.rest(s__26936__$2)));
}
} else {
return null;
}
break;
}
});})(i__26919,datum,c__5339__auto__,size__5340__auto__,b__26920,s__26918__$2,temp__4425__auto__,osmfields))
,null,null));
});})(i__26919,datum,c__5339__auto__,size__5340__auto__,b__26920,s__26918__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})());

var G__26948 = (i__26919 + (1));
i__26919 = G__26948;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26920),hatti$ona$post_process$ona_osm_link_$_iter__26917(cljs.core.chunk_rest(s__26918__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26920),null);
}
} else {
var datum = cljs.core.first(s__26918__$2);
return cljs.core.cons((function (){var iter__5341__auto__ = ((function (datum,s__26918__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__26917_$_iter__26941(s__26942){
return (new cljs.core.LazySeq(null,((function (datum,s__26918__$2,temp__4425__auto__,osmfields){
return (function (){
var s__26942__$1 = s__26942;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__26942__$1);
if(temp__4425__auto____$1){
var s__26942__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__26942__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__26942__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__26944 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__26943 = (0);
while(true){
if((i__26943 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__26943);
cljs.core.chunk_append(b__26944,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__26949 = (i__26943 + (1));
i__26943 = G__26949;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26944),hatti$ona$post_process$ona_osm_link_$_iter__26917_$_iter__26941(cljs.core.chunk_rest(s__26942__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26944),null);
}
} else {
var field = cljs.core.first(s__26942__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__26917_$_iter__26941(cljs.core.rest(s__26942__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__26918__$2,temp__4425__auto__,osmfields))
,null,null));
});})(datum,s__26918__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__26917(cljs.core.rest(s__26918__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5341__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__26951 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__26951);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$features) : osmgeo.call(null,cljs.core.cst$kw$features));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__26974(s__26975){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__26975__$1 = s__26975;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__26975__$1);
if(temp__4425__auto__){
var s__26975__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26975__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__26975__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__26977 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__26976 = (0);
while(true){
if((i__26976 < size__5340__auto__)){
var map__26988 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__26976);
var map__26988__$1 = ((((!((map__26988 == null)))?((((map__26988.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26988.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26988):map__26988);
var feature = map__26988__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26988__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26988__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26988__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__26977,(function (){var map__26990 = properties;
var map__26990__$1 = ((((!((map__26990 == null)))?((((map__26990.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26990.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26990):map__26990);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26990__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26990__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26990__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__26996 = (i__26976 + (1));
i__26976 = G__26996;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26977),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__26974(cljs.core.chunk_rest(s__26975__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26977),null);
}
} else {
var map__26992 = cljs.core.first(s__26975__$2);
var map__26992__$1 = ((((!((map__26992 == null)))?((((map__26992.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26992.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26992):map__26992);
var feature = map__26992__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26992__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26992__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26992__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__26994 = properties;
var map__26994__$1 = ((((!((map__26994 == null)))?((((map__26994.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26994.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26994):map__26994);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26994__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26994__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26994__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__26974(cljs.core.rest(s__26975__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5341__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__26997_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__26997_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4423__auto__ = (function (){var G__27009 = osm_val__GT_osm_id(osm_val);
return (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(G__27009) : osm_data.call(null,G__27009));
})();
if(cljs.core.truth_(temp__4423__auto__)){
var osm_submission_data = temp__4423__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5341__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__27010(s__27011){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__27011__$1 = s__27011;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27011__$1);
if(temp__4425__auto__){
var s__27011__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27011__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27011__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27013 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27012 = (0);
while(true){
if((i__27012 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27012);
cljs.core.chunk_append(b__27013,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__27020 = (i__27012 + (1));
i__27012 = G__27020;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27013),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__27010(cljs.core.chunk_rest(s__27011__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27013),null);
}
} else {
var datum = cljs.core.first(s__27011__$2);
return cljs.core.cons(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__27010(cljs.core.rest(s__27011__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5341__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__27016 = cljs.core.seq(osm_fields);
var chunk__27017 = null;
var count__27018 = (0);
var i__27019 = (0);
while(true){
if((i__27019 < count__27018)){
var osm_field = chunk__27017.cljs$core$IIndexed$_nth$arity$2(null,i__27019);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__27021 = seq__27016;
var G__27022 = chunk__27017;
var G__27023 = count__27018;
var G__27024 = (i__27019 + (1));
seq__27016 = G__27021;
chunk__27017 = G__27022;
count__27018 = G__27023;
i__27019 = G__27024;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__27016);
if(temp__4425__auto__){
var seq__27016__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27016__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__27016__$1);
var G__27025 = cljs.core.chunk_rest(seq__27016__$1);
var G__27026 = c__5372__auto__;
var G__27027 = cljs.core.count(c__5372__auto__);
var G__27028 = (0);
seq__27016 = G__27025;
chunk__27017 = G__27026;
count__27018 = G__27027;
i__27019 = G__27028;
continue;
} else {
var osm_field = cljs.core.first(seq__27016__$1);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__27029 = cljs.core.next(seq__27016__$1);
var G__27030 = null;
var G__27031 = (0);
var G__27032 = (0);
seq__27016 = G__27029;
chunk__27017 = G__27030;
count__27018 = G__27031;
i__27019 = G__27032;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4569__auto__ = attachments;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments");
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__27033_SHARP_){
return hatti.utils.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__27033_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5634__auto__ = [];
var len__5627__auto___27046 = arguments.length;
var i__5628__auto___27047 = (0);
while(true){
if((i__5628__auto___27047 < len__5627__auto___27046)){
args__5634__auto__.push((arguments[i__5628__auto___27047]));

var G__27048 = (i__5628__auto___27047 + (1));
i__5628__auto___27047 = G__27048;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__27037){
var map__27038 = p__27037;
var map__27038__$1 = ((((!((map__27038 == null)))?((((map__27038.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27038.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27038):map__27038);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27038__$1,cljs.core.cst$kw$attachments);
var image_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.image_QMARK_,flat_form);
var iter__5341__auto__ = ((function (image_fields,map__27038,map__27038__$1,attachments){
return (function hatti$ona$post_process$iter__27040(s__27041){
return (new cljs.core.LazySeq(null,((function (image_fields,map__27038,map__27038__$1,attachments){
return (function (){
var s__27041__$1 = s__27041;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27041__$1);
if(temp__4425__auto__){
var s__27041__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27041__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27041__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27043 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27042 = (0);
while(true){
if((i__27042 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27042);
cljs.core.chunk_append(b__27043,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__27042,attach_map,record,c__5339__auto__,size__5340__auto__,b__27043,s__27041__$2,temp__4425__auto__,image_fields,map__27038,map__27038__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__27042,attach_map,record,c__5339__auto__,size__5340__auto__,b__27043,s__27041__$2,temp__4425__auto__,image_fields,map__27038,map__27038__$1,attachments))
,record,image_fields);
})());

var G__27049 = (i__27042 + (1));
i__27042 = G__27049;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27043),hatti$ona$post_process$iter__27040(cljs.core.chunk_rest(s__27041__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27043),null);
}
} else {
var record = cljs.core.first(s__27041__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__27041__$2,temp__4425__auto__,image_fields,map__27038,map__27038__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__27041__$2,temp__4425__auto__,image_fields,map__27038,map__27038__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__27040(cljs.core.rest(s__27041__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__27038,map__27038__$1,attachments))
,null,null));
});})(image_fields,map__27038,map__27038__$1,attachments))
;
return iter__5341__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq27034){
var G__27035 = cljs.core.first(seq27034);
var seq27034__$1 = cljs.core.next(seq27034);
var G__27036 = cljs.core.first(seq27034__$1);
var seq27034__$2 = cljs.core.next(seq27034__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__27035,G__27036,seq27034__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments")], 0)));
});})(repeat_fields))
;
var iter__5341__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__27056(s__27057){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__27057__$1 = s__27057;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27057__$1);
if(temp__4425__auto__){
var s__27057__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27057__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27057__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27059 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27058 = (0);
while(true){
if((i__27058 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27058);
cljs.core.chunk_append(b__27059,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__27062 = (i__27058 + (1));
i__27058 = G__27062;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27059),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__27056(cljs.core.chunk_rest(s__27057__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27059),null);
}
} else {
var record = cljs.core.first(s__27057__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__27056(cljs.core.rest(s__27057__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5341__auto__(data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___27070 = arguments.length;
var i__5628__auto___27071 = (0);
while(true){
if((i__5628__auto___27071 < len__5627__auto___27070)){
args__5634__auto__.push((arguments[i__5628__auto___27071]));

var G__27072 = (i__5628__auto___27071 + (1));
i__5628__auto___27071 = G__27072;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__27067){
var map__27068 = p__27067;
var map__27068__$1 = ((((!((map__27068 == null)))?((((map__27068.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27068.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27068):map__27068);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27068__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__27068,map__27068__$1,app_data_keys){
return (function (p1__27063_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__27063_SHARP_));
});})(map__27068,map__27068__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq27064){
var G__27065 = cljs.core.first(seq27064);
var seq27064__$1 = cljs.core.next(seq27064);
var G__27066 = cljs.core.first(seq27064__$1);
var seq27064__$2 = cljs.core.next(seq27064__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__27065,G__27066,seq27064__$2);
});
