// Compiled by ClojureScript 1.8.51 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args11901 = [];
var len__7280__auto___11907 = arguments.length;
var i__7281__auto___11908 = (0);
while(true){
if((i__7281__auto___11908 < len__7280__auto___11907)){
args11901.push((arguments[i__7281__auto___11908]));

var G__11909 = (i__7281__auto___11908 + (1));
i__7281__auto___11908 = G__11909;
continue;
} else {
}
break;
}

var G__11903 = args11901.length;
switch (G__11903) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11901.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async11904 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11904 = (function (f,blockable,meta11905){
this.f = f;
this.blockable = blockable;
this.meta11905 = meta11905;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11906,meta11905__$1){
var self__ = this;
var _11906__$1 = this;
return (new cljs.core.async.t_cljs$core$async11904(self__.f,self__.blockable,meta11905__$1));
});

cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11906){
var self__ = this;
var _11906__$1 = this;
return self__.meta11905;
});

cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async11904.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11905","meta11905",1107737781,null)], null);
});

cljs.core.async.t_cljs$core$async11904.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11904.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11904";

cljs.core.async.t_cljs$core$async11904.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async11904");
});

cljs.core.async.__GT_t_cljs$core$async11904 = (function cljs$core$async$__GT_t_cljs$core$async11904(f__$1,blockable__$1,meta11905){
return (new cljs.core.async.t_cljs$core$async11904(f__$1,blockable__$1,meta11905));
});

}

return (new cljs.core.async.t_cljs$core$async11904(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args11913 = [];
var len__7280__auto___11916 = arguments.length;
var i__7281__auto___11917 = (0);
while(true){
if((i__7281__auto___11917 < len__7280__auto___11916)){
args11913.push((arguments[i__7281__auto___11917]));

var G__11918 = (i__7281__auto___11917 + (1));
i__7281__auto___11917 = G__11918;
continue;
} else {
}
break;
}

var G__11915 = args11913.length;
switch (G__11915) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11913.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args11920 = [];
var len__7280__auto___11923 = arguments.length;
var i__7281__auto___11924 = (0);
while(true){
if((i__7281__auto___11924 < len__7280__auto___11923)){
args11920.push((arguments[i__7281__auto___11924]));

var G__11925 = (i__7281__auto___11924 + (1));
i__7281__auto___11924 = G__11925;
continue;
} else {
}
break;
}

var G__11922 = args11920.length;
switch (G__11922) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11920.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args11927 = [];
var len__7280__auto___11930 = arguments.length;
var i__7281__auto___11931 = (0);
while(true){
if((i__7281__auto___11931 < len__7280__auto___11930)){
args11927.push((arguments[i__7281__auto___11931]));

var G__11932 = (i__7281__auto___11931 + (1));
i__7281__auto___11931 = G__11932;
continue;
} else {
}
break;
}

var G__11929 = args11927.length;
switch (G__11929) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11927.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11934 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11934);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_11934,ret){
return (function (){
return fn1.call(null,val_11934);
});})(val_11934,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args11935 = [];
var len__7280__auto___11938 = arguments.length;
var i__7281__auto___11939 = (0);
while(true){
if((i__7281__auto___11939 < len__7280__auto___11938)){
args11935.push((arguments[i__7281__auto___11939]));

var G__11940 = (i__7281__auto___11939 + (1));
i__7281__auto___11939 = G__11940;
continue;
} else {
}
break;
}

var G__11937 = args11935.length;
switch (G__11937) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11935.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7125__auto___11942 = n;
var x_11943 = (0);
while(true){
if((x_11943 < n__7125__auto___11942)){
(a[x_11943] = (0));

var G__11944 = (x_11943 + (1));
x_11943 = G__11944;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__11945 = (i + (1));
i = G__11945;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async11949 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11949 = (function (alt_flag,flag,meta11950){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta11950 = meta11950;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11949.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_11951,meta11950__$1){
var self__ = this;
var _11951__$1 = this;
return (new cljs.core.async.t_cljs$core$async11949(self__.alt_flag,self__.flag,meta11950__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async11949.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_11951){
var self__ = this;
var _11951__$1 = this;
return self__.meta11950;
});})(flag))
;

cljs.core.async.t_cljs$core$async11949.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11949.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async11949.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11949.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11949.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11950","meta11950",-559948424,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async11949.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11949.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11949";

cljs.core.async.t_cljs$core$async11949.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async11949");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async11949 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11949(alt_flag__$1,flag__$1,meta11950){
return (new cljs.core.async.t_cljs$core$async11949(alt_flag__$1,flag__$1,meta11950));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async11949(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async11955 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11955 = (function (alt_handler,flag,cb,meta11956){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta11956 = meta11956;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11955.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11957,meta11956__$1){
var self__ = this;
var _11957__$1 = this;
return (new cljs.core.async.t_cljs$core$async11955(self__.alt_handler,self__.flag,self__.cb,meta11956__$1));
});

cljs.core.async.t_cljs$core$async11955.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11957){
var self__ = this;
var _11957__$1 = this;
return self__.meta11956;
});

cljs.core.async.t_cljs$core$async11955.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11955.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async11955.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11955.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async11955.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11956","meta11956",1006708310,null)], null);
});

cljs.core.async.t_cljs$core$async11955.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11955.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11955";

cljs.core.async.t_cljs$core$async11955.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async11955");
});

cljs.core.async.__GT_t_cljs$core$async11955 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11955(alt_handler__$1,flag__$1,cb__$1,meta11956){
return (new cljs.core.async.t_cljs$core$async11955(alt_handler__$1,flag__$1,cb__$1,meta11956));
});

}

return (new cljs.core.async.t_cljs$core$async11955(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11958_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11958_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11959_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11959_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6210__auto__ = wport;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11960 = (i + (1));
i = G__11960;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6210__auto__ = ret;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6198__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6198__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___11966 = arguments.length;
var i__7281__auto___11967 = (0);
while(true){
if((i__7281__auto___11967 < len__7280__auto___11966)){
args__7287__auto__.push((arguments[i__7281__auto___11967]));

var G__11968 = (i__7281__auto___11967 + (1));
i__7281__auto___11967 = G__11968;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11963){
var map__11964 = p__11963;
var map__11964__$1 = ((((!((map__11964 == null)))?((((map__11964.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11964.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11964):map__11964);
var opts = map__11964__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11961){
var G__11962 = cljs.core.first.call(null,seq11961);
var seq11961__$1 = cljs.core.next.call(null,seq11961);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11962,seq11961__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args11969 = [];
var len__7280__auto___12019 = arguments.length;
var i__7281__auto___12020 = (0);
while(true){
if((i__7281__auto___12020 < len__7280__auto___12019)){
args11969.push((arguments[i__7281__auto___12020]));

var G__12021 = (i__7281__auto___12020 + (1));
i__7281__auto___12020 = G__12021;
continue;
} else {
}
break;
}

var G__11971 = args11969.length;
switch (G__11971) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11969.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11856__auto___12023 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___12023){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___12023){
return (function (state_11995){
var state_val_11996 = (state_11995[(1)]);
if((state_val_11996 === (7))){
var inst_11991 = (state_11995[(2)]);
var state_11995__$1 = state_11995;
var statearr_11997_12024 = state_11995__$1;
(statearr_11997_12024[(2)] = inst_11991);

(statearr_11997_12024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11996 === (1))){
var state_11995__$1 = state_11995;
var statearr_11998_12025 = state_11995__$1;
(statearr_11998_12025[(2)] = null);

(statearr_11998_12025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11996 === (4))){
var inst_11974 = (state_11995[(7)]);
var inst_11974__$1 = (state_11995[(2)]);
var inst_11975 = (inst_11974__$1 == null);
var state_11995__$1 = (function (){var statearr_11999 = state_11995;
(statearr_11999[(7)] = inst_11974__$1);

return statearr_11999;
})();
if(cljs.core.truth_(inst_11975)){
var statearr_12000_12026 = state_11995__$1;
(statearr_12000_12026[(1)] = (5));

} else {
var statearr_12001_12027 = state_11995__$1;
(statearr_12001_12027[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11996 === (13))){
var state_11995__$1 = state_11995;
var statearr_12002_12028 = state_11995__$1;
(statearr_12002_12028[(2)] = null);

(statearr_12002_12028[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11996 === (6))){
var inst_11974 = (state_11995[(7)]);
var state_11995__$1 = state_11995;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11995__$1,(11),to,inst_11974);
} else {
if((state_val_11996 === (3))){
var inst_11993 = (state_11995[(2)]);
var state_11995__$1 = state_11995;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11995__$1,inst_11993);
} else {
if((state_val_11996 === (12))){
var state_11995__$1 = state_11995;
var statearr_12003_12029 = state_11995__$1;
(statearr_12003_12029[(2)] = null);

(statearr_12003_12029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11996 === (2))){
var state_11995__$1 = state_11995;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11995__$1,(4),from);
} else {
if((state_val_11996 === (11))){
var inst_11984 = (state_11995[(2)]);
var state_11995__$1 = state_11995;
if(cljs.core.truth_(inst_11984)){
var statearr_12004_12030 = state_11995__$1;
(statearr_12004_12030[(1)] = (12));

} else {
var statearr_12005_12031 = state_11995__$1;
(statearr_12005_12031[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11996 === (9))){
var state_11995__$1 = state_11995;
var statearr_12006_12032 = state_11995__$1;
(statearr_12006_12032[(2)] = null);

(statearr_12006_12032[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11996 === (5))){
var state_11995__$1 = state_11995;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12007_12033 = state_11995__$1;
(statearr_12007_12033[(1)] = (8));

} else {
var statearr_12008_12034 = state_11995__$1;
(statearr_12008_12034[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11996 === (14))){
var inst_11989 = (state_11995[(2)]);
var state_11995__$1 = state_11995;
var statearr_12009_12035 = state_11995__$1;
(statearr_12009_12035[(2)] = inst_11989);

(statearr_12009_12035[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11996 === (10))){
var inst_11981 = (state_11995[(2)]);
var state_11995__$1 = state_11995;
var statearr_12010_12036 = state_11995__$1;
(statearr_12010_12036[(2)] = inst_11981);

(statearr_12010_12036[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11996 === (8))){
var inst_11978 = cljs.core.async.close_BANG_.call(null,to);
var state_11995__$1 = state_11995;
var statearr_12011_12037 = state_11995__$1;
(statearr_12011_12037[(2)] = inst_11978);

(statearr_12011_12037[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___12023))
;
return ((function (switch__11791__auto__,c__11856__auto___12023){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_12015 = [null,null,null,null,null,null,null,null];
(statearr_12015[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_12015[(1)] = (1));

return statearr_12015;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_11995){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_11995);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e12016){if((e12016 instanceof Object)){
var ex__11795__auto__ = e12016;
var statearr_12017_12038 = state_11995;
(statearr_12017_12038[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11995);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12016;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12039 = state_11995;
state_11995 = G__12039;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_11995){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_11995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___12023))
})();
var state__11858__auto__ = (function (){var statearr_12018 = f__11857__auto__.call(null);
(statearr_12018[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___12023);

return statearr_12018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___12023))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__12223){
var vec__12224 = p__12223;
var v = cljs.core.nth.call(null,vec__12224,(0),null);
var p = cljs.core.nth.call(null,vec__12224,(1),null);
var job = vec__12224;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11856__auto___12406 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___12406,res,vec__12224,v,p,job,jobs,results){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___12406,res,vec__12224,v,p,job,jobs,results){
return (function (state_12229){
var state_val_12230 = (state_12229[(1)]);
if((state_val_12230 === (1))){
var state_12229__$1 = state_12229;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12229__$1,(2),res,v);
} else {
if((state_val_12230 === (2))){
var inst_12226 = (state_12229[(2)]);
var inst_12227 = cljs.core.async.close_BANG_.call(null,res);
var state_12229__$1 = (function (){var statearr_12231 = state_12229;
(statearr_12231[(7)] = inst_12226);

return statearr_12231;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12229__$1,inst_12227);
} else {
return null;
}
}
});})(c__11856__auto___12406,res,vec__12224,v,p,job,jobs,results))
;
return ((function (switch__11791__auto__,c__11856__auto___12406,res,vec__12224,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0 = (function (){
var statearr_12235 = [null,null,null,null,null,null,null,null];
(statearr_12235[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__);

(statearr_12235[(1)] = (1));

return statearr_12235;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1 = (function (state_12229){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_12229);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e12236){if((e12236 instanceof Object)){
var ex__11795__auto__ = e12236;
var statearr_12237_12407 = state_12229;
(statearr_12237_12407[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12229);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12236;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12408 = state_12229;
state_12229 = G__12408;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = function(state_12229){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1.call(this,state_12229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___12406,res,vec__12224,v,p,job,jobs,results))
})();
var state__11858__auto__ = (function (){var statearr_12238 = f__11857__auto__.call(null);
(statearr_12238[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___12406);

return statearr_12238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___12406,res,vec__12224,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__12239){
var vec__12240 = p__12239;
var v = cljs.core.nth.call(null,vec__12240,(0),null);
var p = cljs.core.nth.call(null,vec__12240,(1),null);
var job = vec__12240;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7125__auto___12409 = n;
var __12410 = (0);
while(true){
if((__12410 < n__7125__auto___12409)){
var G__12241_12411 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__12241_12411) {
case "compute":
var c__11856__auto___12413 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12410,c__11856__auto___12413,G__12241_12411,n__7125__auto___12409,jobs,results,process,async){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (__12410,c__11856__auto___12413,G__12241_12411,n__7125__auto___12409,jobs,results,process,async){
return (function (state_12254){
var state_val_12255 = (state_12254[(1)]);
if((state_val_12255 === (1))){
var state_12254__$1 = state_12254;
var statearr_12256_12414 = state_12254__$1;
(statearr_12256_12414[(2)] = null);

(statearr_12256_12414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12255 === (2))){
var state_12254__$1 = state_12254;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12254__$1,(4),jobs);
} else {
if((state_val_12255 === (3))){
var inst_12252 = (state_12254[(2)]);
var state_12254__$1 = state_12254;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12254__$1,inst_12252);
} else {
if((state_val_12255 === (4))){
var inst_12244 = (state_12254[(2)]);
var inst_12245 = process.call(null,inst_12244);
var state_12254__$1 = state_12254;
if(cljs.core.truth_(inst_12245)){
var statearr_12257_12415 = state_12254__$1;
(statearr_12257_12415[(1)] = (5));

} else {
var statearr_12258_12416 = state_12254__$1;
(statearr_12258_12416[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12255 === (5))){
var state_12254__$1 = state_12254;
var statearr_12259_12417 = state_12254__$1;
(statearr_12259_12417[(2)] = null);

(statearr_12259_12417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12255 === (6))){
var state_12254__$1 = state_12254;
var statearr_12260_12418 = state_12254__$1;
(statearr_12260_12418[(2)] = null);

(statearr_12260_12418[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12255 === (7))){
var inst_12250 = (state_12254[(2)]);
var state_12254__$1 = state_12254;
var statearr_12261_12419 = state_12254__$1;
(statearr_12261_12419[(2)] = inst_12250);

(statearr_12261_12419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12410,c__11856__auto___12413,G__12241_12411,n__7125__auto___12409,jobs,results,process,async))
;
return ((function (__12410,switch__11791__auto__,c__11856__auto___12413,G__12241_12411,n__7125__auto___12409,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0 = (function (){
var statearr_12265 = [null,null,null,null,null,null,null];
(statearr_12265[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__);

(statearr_12265[(1)] = (1));

return statearr_12265;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1 = (function (state_12254){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_12254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e12266){if((e12266 instanceof Object)){
var ex__11795__auto__ = e12266;
var statearr_12267_12420 = state_12254;
(statearr_12267_12420[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12254);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12266;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12421 = state_12254;
state_12254 = G__12421;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = function(state_12254){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1.call(this,state_12254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__;
})()
;})(__12410,switch__11791__auto__,c__11856__auto___12413,G__12241_12411,n__7125__auto___12409,jobs,results,process,async))
})();
var state__11858__auto__ = (function (){var statearr_12268 = f__11857__auto__.call(null);
(statearr_12268[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___12413);

return statearr_12268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(__12410,c__11856__auto___12413,G__12241_12411,n__7125__auto___12409,jobs,results,process,async))
);


break;
case "async":
var c__11856__auto___12422 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12410,c__11856__auto___12422,G__12241_12411,n__7125__auto___12409,jobs,results,process,async){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (__12410,c__11856__auto___12422,G__12241_12411,n__7125__auto___12409,jobs,results,process,async){
return (function (state_12281){
var state_val_12282 = (state_12281[(1)]);
if((state_val_12282 === (1))){
var state_12281__$1 = state_12281;
var statearr_12283_12423 = state_12281__$1;
(statearr_12283_12423[(2)] = null);

(statearr_12283_12423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12282 === (2))){
var state_12281__$1 = state_12281;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12281__$1,(4),jobs);
} else {
if((state_val_12282 === (3))){
var inst_12279 = (state_12281[(2)]);
var state_12281__$1 = state_12281;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12281__$1,inst_12279);
} else {
if((state_val_12282 === (4))){
var inst_12271 = (state_12281[(2)]);
var inst_12272 = async.call(null,inst_12271);
var state_12281__$1 = state_12281;
if(cljs.core.truth_(inst_12272)){
var statearr_12284_12424 = state_12281__$1;
(statearr_12284_12424[(1)] = (5));

} else {
var statearr_12285_12425 = state_12281__$1;
(statearr_12285_12425[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12282 === (5))){
var state_12281__$1 = state_12281;
var statearr_12286_12426 = state_12281__$1;
(statearr_12286_12426[(2)] = null);

(statearr_12286_12426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12282 === (6))){
var state_12281__$1 = state_12281;
var statearr_12287_12427 = state_12281__$1;
(statearr_12287_12427[(2)] = null);

(statearr_12287_12427[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12282 === (7))){
var inst_12277 = (state_12281[(2)]);
var state_12281__$1 = state_12281;
var statearr_12288_12428 = state_12281__$1;
(statearr_12288_12428[(2)] = inst_12277);

(statearr_12288_12428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12410,c__11856__auto___12422,G__12241_12411,n__7125__auto___12409,jobs,results,process,async))
;
return ((function (__12410,switch__11791__auto__,c__11856__auto___12422,G__12241_12411,n__7125__auto___12409,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0 = (function (){
var statearr_12292 = [null,null,null,null,null,null,null];
(statearr_12292[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__);

(statearr_12292[(1)] = (1));

return statearr_12292;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1 = (function (state_12281){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_12281);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e12293){if((e12293 instanceof Object)){
var ex__11795__auto__ = e12293;
var statearr_12294_12429 = state_12281;
(statearr_12294_12429[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12281);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12293;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12430 = state_12281;
state_12281 = G__12430;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = function(state_12281){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1.call(this,state_12281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__;
})()
;})(__12410,switch__11791__auto__,c__11856__auto___12422,G__12241_12411,n__7125__auto___12409,jobs,results,process,async))
})();
var state__11858__auto__ = (function (){var statearr_12295 = f__11857__auto__.call(null);
(statearr_12295[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___12422);

return statearr_12295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(__12410,c__11856__auto___12422,G__12241_12411,n__7125__auto___12409,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__12431 = (__12410 + (1));
__12410 = G__12431;
continue;
} else {
}
break;
}

var c__11856__auto___12432 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___12432,jobs,results,process,async){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___12432,jobs,results,process,async){
return (function (state_12317){
var state_val_12318 = (state_12317[(1)]);
if((state_val_12318 === (1))){
var state_12317__$1 = state_12317;
var statearr_12319_12433 = state_12317__$1;
(statearr_12319_12433[(2)] = null);

(statearr_12319_12433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12318 === (2))){
var state_12317__$1 = state_12317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12317__$1,(4),from);
} else {
if((state_val_12318 === (3))){
var inst_12315 = (state_12317[(2)]);
var state_12317__$1 = state_12317;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12317__$1,inst_12315);
} else {
if((state_val_12318 === (4))){
var inst_12298 = (state_12317[(7)]);
var inst_12298__$1 = (state_12317[(2)]);
var inst_12299 = (inst_12298__$1 == null);
var state_12317__$1 = (function (){var statearr_12320 = state_12317;
(statearr_12320[(7)] = inst_12298__$1);

return statearr_12320;
})();
if(cljs.core.truth_(inst_12299)){
var statearr_12321_12434 = state_12317__$1;
(statearr_12321_12434[(1)] = (5));

} else {
var statearr_12322_12435 = state_12317__$1;
(statearr_12322_12435[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12318 === (5))){
var inst_12301 = cljs.core.async.close_BANG_.call(null,jobs);
var state_12317__$1 = state_12317;
var statearr_12323_12436 = state_12317__$1;
(statearr_12323_12436[(2)] = inst_12301);

(statearr_12323_12436[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12318 === (6))){
var inst_12298 = (state_12317[(7)]);
var inst_12303 = (state_12317[(8)]);
var inst_12303__$1 = cljs.core.async.chan.call(null,(1));
var inst_12304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12305 = [inst_12298,inst_12303__$1];
var inst_12306 = (new cljs.core.PersistentVector(null,2,(5),inst_12304,inst_12305,null));
var state_12317__$1 = (function (){var statearr_12324 = state_12317;
(statearr_12324[(8)] = inst_12303__$1);

return statearr_12324;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12317__$1,(8),jobs,inst_12306);
} else {
if((state_val_12318 === (7))){
var inst_12313 = (state_12317[(2)]);
var state_12317__$1 = state_12317;
var statearr_12325_12437 = state_12317__$1;
(statearr_12325_12437[(2)] = inst_12313);

(statearr_12325_12437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12318 === (8))){
var inst_12303 = (state_12317[(8)]);
var inst_12308 = (state_12317[(2)]);
var state_12317__$1 = (function (){var statearr_12326 = state_12317;
(statearr_12326[(9)] = inst_12308);

return statearr_12326;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12317__$1,(9),results,inst_12303);
} else {
if((state_val_12318 === (9))){
var inst_12310 = (state_12317[(2)]);
var state_12317__$1 = (function (){var statearr_12327 = state_12317;
(statearr_12327[(10)] = inst_12310);

return statearr_12327;
})();
var statearr_12328_12438 = state_12317__$1;
(statearr_12328_12438[(2)] = null);

(statearr_12328_12438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___12432,jobs,results,process,async))
;
return ((function (switch__11791__auto__,c__11856__auto___12432,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0 = (function (){
var statearr_12332 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12332[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__);

(statearr_12332[(1)] = (1));

return statearr_12332;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1 = (function (state_12317){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_12317);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e12333){if((e12333 instanceof Object)){
var ex__11795__auto__ = e12333;
var statearr_12334_12439 = state_12317;
(statearr_12334_12439[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12317);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12333;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12440 = state_12317;
state_12317 = G__12440;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = function(state_12317){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1.call(this,state_12317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___12432,jobs,results,process,async))
})();
var state__11858__auto__ = (function (){var statearr_12335 = f__11857__auto__.call(null);
(statearr_12335[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___12432);

return statearr_12335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___12432,jobs,results,process,async))
);


var c__11856__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto__,jobs,results,process,async){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__,jobs,results,process,async){
return (function (state_12373){
var state_val_12374 = (state_12373[(1)]);
if((state_val_12374 === (7))){
var inst_12369 = (state_12373[(2)]);
var state_12373__$1 = state_12373;
var statearr_12375_12441 = state_12373__$1;
(statearr_12375_12441[(2)] = inst_12369);

(statearr_12375_12441[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (20))){
var state_12373__$1 = state_12373;
var statearr_12376_12442 = state_12373__$1;
(statearr_12376_12442[(2)] = null);

(statearr_12376_12442[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (1))){
var state_12373__$1 = state_12373;
var statearr_12377_12443 = state_12373__$1;
(statearr_12377_12443[(2)] = null);

(statearr_12377_12443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (4))){
var inst_12338 = (state_12373[(7)]);
var inst_12338__$1 = (state_12373[(2)]);
var inst_12339 = (inst_12338__$1 == null);
var state_12373__$1 = (function (){var statearr_12378 = state_12373;
(statearr_12378[(7)] = inst_12338__$1);

return statearr_12378;
})();
if(cljs.core.truth_(inst_12339)){
var statearr_12379_12444 = state_12373__$1;
(statearr_12379_12444[(1)] = (5));

} else {
var statearr_12380_12445 = state_12373__$1;
(statearr_12380_12445[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (15))){
var inst_12351 = (state_12373[(8)]);
var state_12373__$1 = state_12373;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12373__$1,(18),to,inst_12351);
} else {
if((state_val_12374 === (21))){
var inst_12364 = (state_12373[(2)]);
var state_12373__$1 = state_12373;
var statearr_12381_12446 = state_12373__$1;
(statearr_12381_12446[(2)] = inst_12364);

(statearr_12381_12446[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (13))){
var inst_12366 = (state_12373[(2)]);
var state_12373__$1 = (function (){var statearr_12382 = state_12373;
(statearr_12382[(9)] = inst_12366);

return statearr_12382;
})();
var statearr_12383_12447 = state_12373__$1;
(statearr_12383_12447[(2)] = null);

(statearr_12383_12447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (6))){
var inst_12338 = (state_12373[(7)]);
var state_12373__$1 = state_12373;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12373__$1,(11),inst_12338);
} else {
if((state_val_12374 === (17))){
var inst_12359 = (state_12373[(2)]);
var state_12373__$1 = state_12373;
if(cljs.core.truth_(inst_12359)){
var statearr_12384_12448 = state_12373__$1;
(statearr_12384_12448[(1)] = (19));

} else {
var statearr_12385_12449 = state_12373__$1;
(statearr_12385_12449[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (3))){
var inst_12371 = (state_12373[(2)]);
var state_12373__$1 = state_12373;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12373__$1,inst_12371);
} else {
if((state_val_12374 === (12))){
var inst_12348 = (state_12373[(10)]);
var state_12373__$1 = state_12373;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12373__$1,(14),inst_12348);
} else {
if((state_val_12374 === (2))){
var state_12373__$1 = state_12373;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12373__$1,(4),results);
} else {
if((state_val_12374 === (19))){
var state_12373__$1 = state_12373;
var statearr_12386_12450 = state_12373__$1;
(statearr_12386_12450[(2)] = null);

(statearr_12386_12450[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (11))){
var inst_12348 = (state_12373[(2)]);
var state_12373__$1 = (function (){var statearr_12387 = state_12373;
(statearr_12387[(10)] = inst_12348);

return statearr_12387;
})();
var statearr_12388_12451 = state_12373__$1;
(statearr_12388_12451[(2)] = null);

(statearr_12388_12451[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (9))){
var state_12373__$1 = state_12373;
var statearr_12389_12452 = state_12373__$1;
(statearr_12389_12452[(2)] = null);

(statearr_12389_12452[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (5))){
var state_12373__$1 = state_12373;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12390_12453 = state_12373__$1;
(statearr_12390_12453[(1)] = (8));

} else {
var statearr_12391_12454 = state_12373__$1;
(statearr_12391_12454[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (14))){
var inst_12351 = (state_12373[(8)]);
var inst_12353 = (state_12373[(11)]);
var inst_12351__$1 = (state_12373[(2)]);
var inst_12352 = (inst_12351__$1 == null);
var inst_12353__$1 = cljs.core.not.call(null,inst_12352);
var state_12373__$1 = (function (){var statearr_12392 = state_12373;
(statearr_12392[(8)] = inst_12351__$1);

(statearr_12392[(11)] = inst_12353__$1);

return statearr_12392;
})();
if(inst_12353__$1){
var statearr_12393_12455 = state_12373__$1;
(statearr_12393_12455[(1)] = (15));

} else {
var statearr_12394_12456 = state_12373__$1;
(statearr_12394_12456[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (16))){
var inst_12353 = (state_12373[(11)]);
var state_12373__$1 = state_12373;
var statearr_12395_12457 = state_12373__$1;
(statearr_12395_12457[(2)] = inst_12353);

(statearr_12395_12457[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (10))){
var inst_12345 = (state_12373[(2)]);
var state_12373__$1 = state_12373;
var statearr_12396_12458 = state_12373__$1;
(statearr_12396_12458[(2)] = inst_12345);

(statearr_12396_12458[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (18))){
var inst_12356 = (state_12373[(2)]);
var state_12373__$1 = state_12373;
var statearr_12397_12459 = state_12373__$1;
(statearr_12397_12459[(2)] = inst_12356);

(statearr_12397_12459[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12374 === (8))){
var inst_12342 = cljs.core.async.close_BANG_.call(null,to);
var state_12373__$1 = state_12373;
var statearr_12398_12460 = state_12373__$1;
(statearr_12398_12460[(2)] = inst_12342);

(statearr_12398_12460[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto__,jobs,results,process,async))
;
return ((function (switch__11791__auto__,c__11856__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0 = (function (){
var statearr_12402 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12402[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__);

(statearr_12402[(1)] = (1));

return statearr_12402;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1 = (function (state_12373){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_12373);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e12403){if((e12403 instanceof Object)){
var ex__11795__auto__ = e12403;
var statearr_12404_12461 = state_12373;
(statearr_12404_12461[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12373);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12403;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12462 = state_12373;
state_12373 = G__12462;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = function(state_12373){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1.call(this,state_12373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__,jobs,results,process,async))
})();
var state__11858__auto__ = (function (){var statearr_12405 = f__11857__auto__.call(null);
(statearr_12405[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_12405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto__,jobs,results,process,async))
);

return c__11856__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args12463 = [];
var len__7280__auto___12466 = arguments.length;
var i__7281__auto___12467 = (0);
while(true){
if((i__7281__auto___12467 < len__7280__auto___12466)){
args12463.push((arguments[i__7281__auto___12467]));

var G__12468 = (i__7281__auto___12467 + (1));
i__7281__auto___12467 = G__12468;
continue;
} else {
}
break;
}

var G__12465 = args12463.length;
switch (G__12465) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12463.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args12470 = [];
var len__7280__auto___12473 = arguments.length;
var i__7281__auto___12474 = (0);
while(true){
if((i__7281__auto___12474 < len__7280__auto___12473)){
args12470.push((arguments[i__7281__auto___12474]));

var G__12475 = (i__7281__auto___12474 + (1));
i__7281__auto___12474 = G__12475;
continue;
} else {
}
break;
}

var G__12472 = args12470.length;
switch (G__12472) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12470.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args12477 = [];
var len__7280__auto___12530 = arguments.length;
var i__7281__auto___12531 = (0);
while(true){
if((i__7281__auto___12531 < len__7280__auto___12530)){
args12477.push((arguments[i__7281__auto___12531]));

var G__12532 = (i__7281__auto___12531 + (1));
i__7281__auto___12531 = G__12532;
continue;
} else {
}
break;
}

var G__12479 = args12477.length;
switch (G__12479) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12477.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11856__auto___12534 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___12534,tc,fc){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___12534,tc,fc){
return (function (state_12505){
var state_val_12506 = (state_12505[(1)]);
if((state_val_12506 === (7))){
var inst_12501 = (state_12505[(2)]);
var state_12505__$1 = state_12505;
var statearr_12507_12535 = state_12505__$1;
(statearr_12507_12535[(2)] = inst_12501);

(statearr_12507_12535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12506 === (1))){
var state_12505__$1 = state_12505;
var statearr_12508_12536 = state_12505__$1;
(statearr_12508_12536[(2)] = null);

(statearr_12508_12536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12506 === (4))){
var inst_12482 = (state_12505[(7)]);
var inst_12482__$1 = (state_12505[(2)]);
var inst_12483 = (inst_12482__$1 == null);
var state_12505__$1 = (function (){var statearr_12509 = state_12505;
(statearr_12509[(7)] = inst_12482__$1);

return statearr_12509;
})();
if(cljs.core.truth_(inst_12483)){
var statearr_12510_12537 = state_12505__$1;
(statearr_12510_12537[(1)] = (5));

} else {
var statearr_12511_12538 = state_12505__$1;
(statearr_12511_12538[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12506 === (13))){
var state_12505__$1 = state_12505;
var statearr_12512_12539 = state_12505__$1;
(statearr_12512_12539[(2)] = null);

(statearr_12512_12539[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12506 === (6))){
var inst_12482 = (state_12505[(7)]);
var inst_12488 = p.call(null,inst_12482);
var state_12505__$1 = state_12505;
if(cljs.core.truth_(inst_12488)){
var statearr_12513_12540 = state_12505__$1;
(statearr_12513_12540[(1)] = (9));

} else {
var statearr_12514_12541 = state_12505__$1;
(statearr_12514_12541[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12506 === (3))){
var inst_12503 = (state_12505[(2)]);
var state_12505__$1 = state_12505;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12505__$1,inst_12503);
} else {
if((state_val_12506 === (12))){
var state_12505__$1 = state_12505;
var statearr_12515_12542 = state_12505__$1;
(statearr_12515_12542[(2)] = null);

(statearr_12515_12542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12506 === (2))){
var state_12505__$1 = state_12505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12505__$1,(4),ch);
} else {
if((state_val_12506 === (11))){
var inst_12482 = (state_12505[(7)]);
var inst_12492 = (state_12505[(2)]);
var state_12505__$1 = state_12505;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12505__$1,(8),inst_12492,inst_12482);
} else {
if((state_val_12506 === (9))){
var state_12505__$1 = state_12505;
var statearr_12516_12543 = state_12505__$1;
(statearr_12516_12543[(2)] = tc);

(statearr_12516_12543[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12506 === (5))){
var inst_12485 = cljs.core.async.close_BANG_.call(null,tc);
var inst_12486 = cljs.core.async.close_BANG_.call(null,fc);
var state_12505__$1 = (function (){var statearr_12517 = state_12505;
(statearr_12517[(8)] = inst_12485);

return statearr_12517;
})();
var statearr_12518_12544 = state_12505__$1;
(statearr_12518_12544[(2)] = inst_12486);

(statearr_12518_12544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12506 === (14))){
var inst_12499 = (state_12505[(2)]);
var state_12505__$1 = state_12505;
var statearr_12519_12545 = state_12505__$1;
(statearr_12519_12545[(2)] = inst_12499);

(statearr_12519_12545[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12506 === (10))){
var state_12505__$1 = state_12505;
var statearr_12520_12546 = state_12505__$1;
(statearr_12520_12546[(2)] = fc);

(statearr_12520_12546[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12506 === (8))){
var inst_12494 = (state_12505[(2)]);
var state_12505__$1 = state_12505;
if(cljs.core.truth_(inst_12494)){
var statearr_12521_12547 = state_12505__$1;
(statearr_12521_12547[(1)] = (12));

} else {
var statearr_12522_12548 = state_12505__$1;
(statearr_12522_12548[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___12534,tc,fc))
;
return ((function (switch__11791__auto__,c__11856__auto___12534,tc,fc){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_12526 = [null,null,null,null,null,null,null,null,null];
(statearr_12526[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_12526[(1)] = (1));

return statearr_12526;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_12505){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_12505);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e12527){if((e12527 instanceof Object)){
var ex__11795__auto__ = e12527;
var statearr_12528_12549 = state_12505;
(statearr_12528_12549[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12505);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12527;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12550 = state_12505;
state_12505 = G__12550;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_12505){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_12505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___12534,tc,fc))
})();
var state__11858__auto__ = (function (){var statearr_12529 = f__11857__auto__.call(null);
(statearr_12529[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___12534);

return statearr_12529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___12534,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11856__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto__){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__){
return (function (state_12614){
var state_val_12615 = (state_12614[(1)]);
if((state_val_12615 === (7))){
var inst_12610 = (state_12614[(2)]);
var state_12614__$1 = state_12614;
var statearr_12616_12637 = state_12614__$1;
(statearr_12616_12637[(2)] = inst_12610);

(statearr_12616_12637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12615 === (1))){
var inst_12594 = init;
var state_12614__$1 = (function (){var statearr_12617 = state_12614;
(statearr_12617[(7)] = inst_12594);

return statearr_12617;
})();
var statearr_12618_12638 = state_12614__$1;
(statearr_12618_12638[(2)] = null);

(statearr_12618_12638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12615 === (4))){
var inst_12597 = (state_12614[(8)]);
var inst_12597__$1 = (state_12614[(2)]);
var inst_12598 = (inst_12597__$1 == null);
var state_12614__$1 = (function (){var statearr_12619 = state_12614;
(statearr_12619[(8)] = inst_12597__$1);

return statearr_12619;
})();
if(cljs.core.truth_(inst_12598)){
var statearr_12620_12639 = state_12614__$1;
(statearr_12620_12639[(1)] = (5));

} else {
var statearr_12621_12640 = state_12614__$1;
(statearr_12621_12640[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12615 === (6))){
var inst_12594 = (state_12614[(7)]);
var inst_12597 = (state_12614[(8)]);
var inst_12601 = (state_12614[(9)]);
var inst_12601__$1 = f.call(null,inst_12594,inst_12597);
var inst_12602 = cljs.core.reduced_QMARK_.call(null,inst_12601__$1);
var state_12614__$1 = (function (){var statearr_12622 = state_12614;
(statearr_12622[(9)] = inst_12601__$1);

return statearr_12622;
})();
if(inst_12602){
var statearr_12623_12641 = state_12614__$1;
(statearr_12623_12641[(1)] = (8));

} else {
var statearr_12624_12642 = state_12614__$1;
(statearr_12624_12642[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12615 === (3))){
var inst_12612 = (state_12614[(2)]);
var state_12614__$1 = state_12614;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12614__$1,inst_12612);
} else {
if((state_val_12615 === (2))){
var state_12614__$1 = state_12614;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12614__$1,(4),ch);
} else {
if((state_val_12615 === (9))){
var inst_12601 = (state_12614[(9)]);
var inst_12594 = inst_12601;
var state_12614__$1 = (function (){var statearr_12625 = state_12614;
(statearr_12625[(7)] = inst_12594);

return statearr_12625;
})();
var statearr_12626_12643 = state_12614__$1;
(statearr_12626_12643[(2)] = null);

(statearr_12626_12643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12615 === (5))){
var inst_12594 = (state_12614[(7)]);
var state_12614__$1 = state_12614;
var statearr_12627_12644 = state_12614__$1;
(statearr_12627_12644[(2)] = inst_12594);

(statearr_12627_12644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12615 === (10))){
var inst_12608 = (state_12614[(2)]);
var state_12614__$1 = state_12614;
var statearr_12628_12645 = state_12614__$1;
(statearr_12628_12645[(2)] = inst_12608);

(statearr_12628_12645[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12615 === (8))){
var inst_12601 = (state_12614[(9)]);
var inst_12604 = cljs.core.deref.call(null,inst_12601);
var state_12614__$1 = state_12614;
var statearr_12629_12646 = state_12614__$1;
(statearr_12629_12646[(2)] = inst_12604);

(statearr_12629_12646[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto__))
;
return ((function (switch__11791__auto__,c__11856__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__11792__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11792__auto____0 = (function (){
var statearr_12633 = [null,null,null,null,null,null,null,null,null,null];
(statearr_12633[(0)] = cljs$core$async$reduce_$_state_machine__11792__auto__);

(statearr_12633[(1)] = (1));

return statearr_12633;
});
var cljs$core$async$reduce_$_state_machine__11792__auto____1 = (function (state_12614){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_12614);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e12634){if((e12634 instanceof Object)){
var ex__11795__auto__ = e12634;
var statearr_12635_12647 = state_12614;
(statearr_12635_12647[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12614);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12634;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12648 = state_12614;
state_12614 = G__12648;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11792__auto__ = function(state_12614){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11792__auto____1.call(this,state_12614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11792__auto____0;
cljs$core$async$reduce_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11792__auto____1;
return cljs$core$async$reduce_$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__))
})();
var state__11858__auto__ = (function (){var statearr_12636 = f__11857__auto__.call(null);
(statearr_12636[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_12636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto__))
);

return c__11856__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args12649 = [];
var len__7280__auto___12701 = arguments.length;
var i__7281__auto___12702 = (0);
while(true){
if((i__7281__auto___12702 < len__7280__auto___12701)){
args12649.push((arguments[i__7281__auto___12702]));

var G__12703 = (i__7281__auto___12702 + (1));
i__7281__auto___12702 = G__12703;
continue;
} else {
}
break;
}

var G__12651 = args12649.length;
switch (G__12651) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12649.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11856__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto__){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__){
return (function (state_12676){
var state_val_12677 = (state_12676[(1)]);
if((state_val_12677 === (7))){
var inst_12658 = (state_12676[(2)]);
var state_12676__$1 = state_12676;
var statearr_12678_12705 = state_12676__$1;
(statearr_12678_12705[(2)] = inst_12658);

(statearr_12678_12705[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12677 === (1))){
var inst_12652 = cljs.core.seq.call(null,coll);
var inst_12653 = inst_12652;
var state_12676__$1 = (function (){var statearr_12679 = state_12676;
(statearr_12679[(7)] = inst_12653);

return statearr_12679;
})();
var statearr_12680_12706 = state_12676__$1;
(statearr_12680_12706[(2)] = null);

(statearr_12680_12706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12677 === (4))){
var inst_12653 = (state_12676[(7)]);
var inst_12656 = cljs.core.first.call(null,inst_12653);
var state_12676__$1 = state_12676;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12676__$1,(7),ch,inst_12656);
} else {
if((state_val_12677 === (13))){
var inst_12670 = (state_12676[(2)]);
var state_12676__$1 = state_12676;
var statearr_12681_12707 = state_12676__$1;
(statearr_12681_12707[(2)] = inst_12670);

(statearr_12681_12707[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12677 === (6))){
var inst_12661 = (state_12676[(2)]);
var state_12676__$1 = state_12676;
if(cljs.core.truth_(inst_12661)){
var statearr_12682_12708 = state_12676__$1;
(statearr_12682_12708[(1)] = (8));

} else {
var statearr_12683_12709 = state_12676__$1;
(statearr_12683_12709[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12677 === (3))){
var inst_12674 = (state_12676[(2)]);
var state_12676__$1 = state_12676;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12676__$1,inst_12674);
} else {
if((state_val_12677 === (12))){
var state_12676__$1 = state_12676;
var statearr_12684_12710 = state_12676__$1;
(statearr_12684_12710[(2)] = null);

(statearr_12684_12710[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12677 === (2))){
var inst_12653 = (state_12676[(7)]);
var state_12676__$1 = state_12676;
if(cljs.core.truth_(inst_12653)){
var statearr_12685_12711 = state_12676__$1;
(statearr_12685_12711[(1)] = (4));

} else {
var statearr_12686_12712 = state_12676__$1;
(statearr_12686_12712[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12677 === (11))){
var inst_12667 = cljs.core.async.close_BANG_.call(null,ch);
var state_12676__$1 = state_12676;
var statearr_12687_12713 = state_12676__$1;
(statearr_12687_12713[(2)] = inst_12667);

(statearr_12687_12713[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12677 === (9))){
var state_12676__$1 = state_12676;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12688_12714 = state_12676__$1;
(statearr_12688_12714[(1)] = (11));

} else {
var statearr_12689_12715 = state_12676__$1;
(statearr_12689_12715[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12677 === (5))){
var inst_12653 = (state_12676[(7)]);
var state_12676__$1 = state_12676;
var statearr_12690_12716 = state_12676__$1;
(statearr_12690_12716[(2)] = inst_12653);

(statearr_12690_12716[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12677 === (10))){
var inst_12672 = (state_12676[(2)]);
var state_12676__$1 = state_12676;
var statearr_12691_12717 = state_12676__$1;
(statearr_12691_12717[(2)] = inst_12672);

(statearr_12691_12717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12677 === (8))){
var inst_12653 = (state_12676[(7)]);
var inst_12663 = cljs.core.next.call(null,inst_12653);
var inst_12653__$1 = inst_12663;
var state_12676__$1 = (function (){var statearr_12692 = state_12676;
(statearr_12692[(7)] = inst_12653__$1);

return statearr_12692;
})();
var statearr_12693_12718 = state_12676__$1;
(statearr_12693_12718[(2)] = null);

(statearr_12693_12718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto__))
;
return ((function (switch__11791__auto__,c__11856__auto__){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_12697 = [null,null,null,null,null,null,null,null];
(statearr_12697[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_12697[(1)] = (1));

return statearr_12697;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_12676){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_12676);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e12698){if((e12698 instanceof Object)){
var ex__11795__auto__ = e12698;
var statearr_12699_12719 = state_12676;
(statearr_12699_12719[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12676);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12698;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12720 = state_12676;
state_12676 = G__12720;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_12676){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_12676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__))
})();
var state__11858__auto__ = (function (){var statearr_12700 = f__11857__auto__.call(null);
(statearr_12700[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_12700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto__))
);

return c__11856__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6873__auto__ = (((_ == null))?null:_);
var m__6874__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,_);
} else {
var m__6874__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6874__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m,ch);
} else {
var m__6874__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m);
} else {
var m__6874__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12942 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12942 = (function (mult,ch,cs,meta12943){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta12943 = meta12943;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12942.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_12944,meta12943__$1){
var self__ = this;
var _12944__$1 = this;
return (new cljs.core.async.t_cljs$core$async12942(self__.mult,self__.ch,self__.cs,meta12943__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async12942.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_12944){
var self__ = this;
var _12944__$1 = this;
return self__.meta12943;
});})(cs))
;

cljs.core.async.t_cljs$core$async12942.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12942.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async12942.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async12942.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12942.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12942.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12942.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12943","meta12943",-326935151,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async12942.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12942.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12942";

cljs.core.async.t_cljs$core$async12942.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async12942");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async12942 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async12942(mult__$1,ch__$1,cs__$1,meta12943){
return (new cljs.core.async.t_cljs$core$async12942(mult__$1,ch__$1,cs__$1,meta12943));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async12942(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11856__auto___13163 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___13163,cs,m,dchan,dctr,done){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___13163,cs,m,dchan,dctr,done){
return (function (state_13075){
var state_val_13076 = (state_13075[(1)]);
if((state_val_13076 === (7))){
var inst_13071 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13077_13164 = state_13075__$1;
(statearr_13077_13164[(2)] = inst_13071);

(statearr_13077_13164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (20))){
var inst_12976 = (state_13075[(7)]);
var inst_12986 = cljs.core.first.call(null,inst_12976);
var inst_12987 = cljs.core.nth.call(null,inst_12986,(0),null);
var inst_12988 = cljs.core.nth.call(null,inst_12986,(1),null);
var state_13075__$1 = (function (){var statearr_13078 = state_13075;
(statearr_13078[(8)] = inst_12987);

return statearr_13078;
})();
if(cljs.core.truth_(inst_12988)){
var statearr_13079_13165 = state_13075__$1;
(statearr_13079_13165[(1)] = (22));

} else {
var statearr_13080_13166 = state_13075__$1;
(statearr_13080_13166[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (27))){
var inst_12947 = (state_13075[(9)]);
var inst_13016 = (state_13075[(10)]);
var inst_13023 = (state_13075[(11)]);
var inst_13018 = (state_13075[(12)]);
var inst_13023__$1 = cljs.core._nth.call(null,inst_13016,inst_13018);
var inst_13024 = cljs.core.async.put_BANG_.call(null,inst_13023__$1,inst_12947,done);
var state_13075__$1 = (function (){var statearr_13081 = state_13075;
(statearr_13081[(11)] = inst_13023__$1);

return statearr_13081;
})();
if(cljs.core.truth_(inst_13024)){
var statearr_13082_13167 = state_13075__$1;
(statearr_13082_13167[(1)] = (30));

} else {
var statearr_13083_13168 = state_13075__$1;
(statearr_13083_13168[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (1))){
var state_13075__$1 = state_13075;
var statearr_13084_13169 = state_13075__$1;
(statearr_13084_13169[(2)] = null);

(statearr_13084_13169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (24))){
var inst_12976 = (state_13075[(7)]);
var inst_12993 = (state_13075[(2)]);
var inst_12994 = cljs.core.next.call(null,inst_12976);
var inst_12956 = inst_12994;
var inst_12957 = null;
var inst_12958 = (0);
var inst_12959 = (0);
var state_13075__$1 = (function (){var statearr_13085 = state_13075;
(statearr_13085[(13)] = inst_12956);

(statearr_13085[(14)] = inst_12957);

(statearr_13085[(15)] = inst_12959);

(statearr_13085[(16)] = inst_12993);

(statearr_13085[(17)] = inst_12958);

return statearr_13085;
})();
var statearr_13086_13170 = state_13075__$1;
(statearr_13086_13170[(2)] = null);

(statearr_13086_13170[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (39))){
var state_13075__$1 = state_13075;
var statearr_13090_13171 = state_13075__$1;
(statearr_13090_13171[(2)] = null);

(statearr_13090_13171[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (4))){
var inst_12947 = (state_13075[(9)]);
var inst_12947__$1 = (state_13075[(2)]);
var inst_12948 = (inst_12947__$1 == null);
var state_13075__$1 = (function (){var statearr_13091 = state_13075;
(statearr_13091[(9)] = inst_12947__$1);

return statearr_13091;
})();
if(cljs.core.truth_(inst_12948)){
var statearr_13092_13172 = state_13075__$1;
(statearr_13092_13172[(1)] = (5));

} else {
var statearr_13093_13173 = state_13075__$1;
(statearr_13093_13173[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (15))){
var inst_12956 = (state_13075[(13)]);
var inst_12957 = (state_13075[(14)]);
var inst_12959 = (state_13075[(15)]);
var inst_12958 = (state_13075[(17)]);
var inst_12972 = (state_13075[(2)]);
var inst_12973 = (inst_12959 + (1));
var tmp13087 = inst_12956;
var tmp13088 = inst_12957;
var tmp13089 = inst_12958;
var inst_12956__$1 = tmp13087;
var inst_12957__$1 = tmp13088;
var inst_12958__$1 = tmp13089;
var inst_12959__$1 = inst_12973;
var state_13075__$1 = (function (){var statearr_13094 = state_13075;
(statearr_13094[(13)] = inst_12956__$1);

(statearr_13094[(14)] = inst_12957__$1);

(statearr_13094[(15)] = inst_12959__$1);

(statearr_13094[(18)] = inst_12972);

(statearr_13094[(17)] = inst_12958__$1);

return statearr_13094;
})();
var statearr_13095_13174 = state_13075__$1;
(statearr_13095_13174[(2)] = null);

(statearr_13095_13174[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (21))){
var inst_12997 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13099_13175 = state_13075__$1;
(statearr_13099_13175[(2)] = inst_12997);

(statearr_13099_13175[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (31))){
var inst_13023 = (state_13075[(11)]);
var inst_13027 = done.call(null,null);
var inst_13028 = cljs.core.async.untap_STAR_.call(null,m,inst_13023);
var state_13075__$1 = (function (){var statearr_13100 = state_13075;
(statearr_13100[(19)] = inst_13027);

return statearr_13100;
})();
var statearr_13101_13176 = state_13075__$1;
(statearr_13101_13176[(2)] = inst_13028);

(statearr_13101_13176[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (32))){
var inst_13015 = (state_13075[(20)]);
var inst_13016 = (state_13075[(10)]);
var inst_13017 = (state_13075[(21)]);
var inst_13018 = (state_13075[(12)]);
var inst_13030 = (state_13075[(2)]);
var inst_13031 = (inst_13018 + (1));
var tmp13096 = inst_13015;
var tmp13097 = inst_13016;
var tmp13098 = inst_13017;
var inst_13015__$1 = tmp13096;
var inst_13016__$1 = tmp13097;
var inst_13017__$1 = tmp13098;
var inst_13018__$1 = inst_13031;
var state_13075__$1 = (function (){var statearr_13102 = state_13075;
(statearr_13102[(20)] = inst_13015__$1);

(statearr_13102[(10)] = inst_13016__$1);

(statearr_13102[(21)] = inst_13017__$1);

(statearr_13102[(22)] = inst_13030);

(statearr_13102[(12)] = inst_13018__$1);

return statearr_13102;
})();
var statearr_13103_13177 = state_13075__$1;
(statearr_13103_13177[(2)] = null);

(statearr_13103_13177[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (40))){
var inst_13043 = (state_13075[(23)]);
var inst_13047 = done.call(null,null);
var inst_13048 = cljs.core.async.untap_STAR_.call(null,m,inst_13043);
var state_13075__$1 = (function (){var statearr_13104 = state_13075;
(statearr_13104[(24)] = inst_13047);

return statearr_13104;
})();
var statearr_13105_13178 = state_13075__$1;
(statearr_13105_13178[(2)] = inst_13048);

(statearr_13105_13178[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (33))){
var inst_13034 = (state_13075[(25)]);
var inst_13036 = cljs.core.chunked_seq_QMARK_.call(null,inst_13034);
var state_13075__$1 = state_13075;
if(inst_13036){
var statearr_13106_13179 = state_13075__$1;
(statearr_13106_13179[(1)] = (36));

} else {
var statearr_13107_13180 = state_13075__$1;
(statearr_13107_13180[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (13))){
var inst_12966 = (state_13075[(26)]);
var inst_12969 = cljs.core.async.close_BANG_.call(null,inst_12966);
var state_13075__$1 = state_13075;
var statearr_13108_13181 = state_13075__$1;
(statearr_13108_13181[(2)] = inst_12969);

(statearr_13108_13181[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (22))){
var inst_12987 = (state_13075[(8)]);
var inst_12990 = cljs.core.async.close_BANG_.call(null,inst_12987);
var state_13075__$1 = state_13075;
var statearr_13109_13182 = state_13075__$1;
(statearr_13109_13182[(2)] = inst_12990);

(statearr_13109_13182[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (36))){
var inst_13034 = (state_13075[(25)]);
var inst_13038 = cljs.core.chunk_first.call(null,inst_13034);
var inst_13039 = cljs.core.chunk_rest.call(null,inst_13034);
var inst_13040 = cljs.core.count.call(null,inst_13038);
var inst_13015 = inst_13039;
var inst_13016 = inst_13038;
var inst_13017 = inst_13040;
var inst_13018 = (0);
var state_13075__$1 = (function (){var statearr_13110 = state_13075;
(statearr_13110[(20)] = inst_13015);

(statearr_13110[(10)] = inst_13016);

(statearr_13110[(21)] = inst_13017);

(statearr_13110[(12)] = inst_13018);

return statearr_13110;
})();
var statearr_13111_13183 = state_13075__$1;
(statearr_13111_13183[(2)] = null);

(statearr_13111_13183[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (41))){
var inst_13034 = (state_13075[(25)]);
var inst_13050 = (state_13075[(2)]);
var inst_13051 = cljs.core.next.call(null,inst_13034);
var inst_13015 = inst_13051;
var inst_13016 = null;
var inst_13017 = (0);
var inst_13018 = (0);
var state_13075__$1 = (function (){var statearr_13112 = state_13075;
(statearr_13112[(20)] = inst_13015);

(statearr_13112[(10)] = inst_13016);

(statearr_13112[(27)] = inst_13050);

(statearr_13112[(21)] = inst_13017);

(statearr_13112[(12)] = inst_13018);

return statearr_13112;
})();
var statearr_13113_13184 = state_13075__$1;
(statearr_13113_13184[(2)] = null);

(statearr_13113_13184[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (43))){
var state_13075__$1 = state_13075;
var statearr_13114_13185 = state_13075__$1;
(statearr_13114_13185[(2)] = null);

(statearr_13114_13185[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (29))){
var inst_13059 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13115_13186 = state_13075__$1;
(statearr_13115_13186[(2)] = inst_13059);

(statearr_13115_13186[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (44))){
var inst_13068 = (state_13075[(2)]);
var state_13075__$1 = (function (){var statearr_13116 = state_13075;
(statearr_13116[(28)] = inst_13068);

return statearr_13116;
})();
var statearr_13117_13187 = state_13075__$1;
(statearr_13117_13187[(2)] = null);

(statearr_13117_13187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (6))){
var inst_13007 = (state_13075[(29)]);
var inst_13006 = cljs.core.deref.call(null,cs);
var inst_13007__$1 = cljs.core.keys.call(null,inst_13006);
var inst_13008 = cljs.core.count.call(null,inst_13007__$1);
var inst_13009 = cljs.core.reset_BANG_.call(null,dctr,inst_13008);
var inst_13014 = cljs.core.seq.call(null,inst_13007__$1);
var inst_13015 = inst_13014;
var inst_13016 = null;
var inst_13017 = (0);
var inst_13018 = (0);
var state_13075__$1 = (function (){var statearr_13118 = state_13075;
(statearr_13118[(29)] = inst_13007__$1);

(statearr_13118[(20)] = inst_13015);

(statearr_13118[(30)] = inst_13009);

(statearr_13118[(10)] = inst_13016);

(statearr_13118[(21)] = inst_13017);

(statearr_13118[(12)] = inst_13018);

return statearr_13118;
})();
var statearr_13119_13188 = state_13075__$1;
(statearr_13119_13188[(2)] = null);

(statearr_13119_13188[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (28))){
var inst_13015 = (state_13075[(20)]);
var inst_13034 = (state_13075[(25)]);
var inst_13034__$1 = cljs.core.seq.call(null,inst_13015);
var state_13075__$1 = (function (){var statearr_13120 = state_13075;
(statearr_13120[(25)] = inst_13034__$1);

return statearr_13120;
})();
if(inst_13034__$1){
var statearr_13121_13189 = state_13075__$1;
(statearr_13121_13189[(1)] = (33));

} else {
var statearr_13122_13190 = state_13075__$1;
(statearr_13122_13190[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (25))){
var inst_13017 = (state_13075[(21)]);
var inst_13018 = (state_13075[(12)]);
var inst_13020 = (inst_13018 < inst_13017);
var inst_13021 = inst_13020;
var state_13075__$1 = state_13075;
if(cljs.core.truth_(inst_13021)){
var statearr_13123_13191 = state_13075__$1;
(statearr_13123_13191[(1)] = (27));

} else {
var statearr_13124_13192 = state_13075__$1;
(statearr_13124_13192[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (34))){
var state_13075__$1 = state_13075;
var statearr_13125_13193 = state_13075__$1;
(statearr_13125_13193[(2)] = null);

(statearr_13125_13193[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (17))){
var state_13075__$1 = state_13075;
var statearr_13126_13194 = state_13075__$1;
(statearr_13126_13194[(2)] = null);

(statearr_13126_13194[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (3))){
var inst_13073 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13075__$1,inst_13073);
} else {
if((state_val_13076 === (12))){
var inst_13002 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13127_13195 = state_13075__$1;
(statearr_13127_13195[(2)] = inst_13002);

(statearr_13127_13195[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (2))){
var state_13075__$1 = state_13075;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13075__$1,(4),ch);
} else {
if((state_val_13076 === (23))){
var state_13075__$1 = state_13075;
var statearr_13128_13196 = state_13075__$1;
(statearr_13128_13196[(2)] = null);

(statearr_13128_13196[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (35))){
var inst_13057 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13129_13197 = state_13075__$1;
(statearr_13129_13197[(2)] = inst_13057);

(statearr_13129_13197[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (19))){
var inst_12976 = (state_13075[(7)]);
var inst_12980 = cljs.core.chunk_first.call(null,inst_12976);
var inst_12981 = cljs.core.chunk_rest.call(null,inst_12976);
var inst_12982 = cljs.core.count.call(null,inst_12980);
var inst_12956 = inst_12981;
var inst_12957 = inst_12980;
var inst_12958 = inst_12982;
var inst_12959 = (0);
var state_13075__$1 = (function (){var statearr_13130 = state_13075;
(statearr_13130[(13)] = inst_12956);

(statearr_13130[(14)] = inst_12957);

(statearr_13130[(15)] = inst_12959);

(statearr_13130[(17)] = inst_12958);

return statearr_13130;
})();
var statearr_13131_13198 = state_13075__$1;
(statearr_13131_13198[(2)] = null);

(statearr_13131_13198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (11))){
var inst_12956 = (state_13075[(13)]);
var inst_12976 = (state_13075[(7)]);
var inst_12976__$1 = cljs.core.seq.call(null,inst_12956);
var state_13075__$1 = (function (){var statearr_13132 = state_13075;
(statearr_13132[(7)] = inst_12976__$1);

return statearr_13132;
})();
if(inst_12976__$1){
var statearr_13133_13199 = state_13075__$1;
(statearr_13133_13199[(1)] = (16));

} else {
var statearr_13134_13200 = state_13075__$1;
(statearr_13134_13200[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (9))){
var inst_13004 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13135_13201 = state_13075__$1;
(statearr_13135_13201[(2)] = inst_13004);

(statearr_13135_13201[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (5))){
var inst_12954 = cljs.core.deref.call(null,cs);
var inst_12955 = cljs.core.seq.call(null,inst_12954);
var inst_12956 = inst_12955;
var inst_12957 = null;
var inst_12958 = (0);
var inst_12959 = (0);
var state_13075__$1 = (function (){var statearr_13136 = state_13075;
(statearr_13136[(13)] = inst_12956);

(statearr_13136[(14)] = inst_12957);

(statearr_13136[(15)] = inst_12959);

(statearr_13136[(17)] = inst_12958);

return statearr_13136;
})();
var statearr_13137_13202 = state_13075__$1;
(statearr_13137_13202[(2)] = null);

(statearr_13137_13202[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (14))){
var state_13075__$1 = state_13075;
var statearr_13138_13203 = state_13075__$1;
(statearr_13138_13203[(2)] = null);

(statearr_13138_13203[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (45))){
var inst_13065 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13139_13204 = state_13075__$1;
(statearr_13139_13204[(2)] = inst_13065);

(statearr_13139_13204[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (26))){
var inst_13007 = (state_13075[(29)]);
var inst_13061 = (state_13075[(2)]);
var inst_13062 = cljs.core.seq.call(null,inst_13007);
var state_13075__$1 = (function (){var statearr_13140 = state_13075;
(statearr_13140[(31)] = inst_13061);

return statearr_13140;
})();
if(inst_13062){
var statearr_13141_13205 = state_13075__$1;
(statearr_13141_13205[(1)] = (42));

} else {
var statearr_13142_13206 = state_13075__$1;
(statearr_13142_13206[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (16))){
var inst_12976 = (state_13075[(7)]);
var inst_12978 = cljs.core.chunked_seq_QMARK_.call(null,inst_12976);
var state_13075__$1 = state_13075;
if(inst_12978){
var statearr_13143_13207 = state_13075__$1;
(statearr_13143_13207[(1)] = (19));

} else {
var statearr_13144_13208 = state_13075__$1;
(statearr_13144_13208[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (38))){
var inst_13054 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13145_13209 = state_13075__$1;
(statearr_13145_13209[(2)] = inst_13054);

(statearr_13145_13209[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (30))){
var state_13075__$1 = state_13075;
var statearr_13146_13210 = state_13075__$1;
(statearr_13146_13210[(2)] = null);

(statearr_13146_13210[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (10))){
var inst_12957 = (state_13075[(14)]);
var inst_12959 = (state_13075[(15)]);
var inst_12965 = cljs.core._nth.call(null,inst_12957,inst_12959);
var inst_12966 = cljs.core.nth.call(null,inst_12965,(0),null);
var inst_12967 = cljs.core.nth.call(null,inst_12965,(1),null);
var state_13075__$1 = (function (){var statearr_13147 = state_13075;
(statearr_13147[(26)] = inst_12966);

return statearr_13147;
})();
if(cljs.core.truth_(inst_12967)){
var statearr_13148_13211 = state_13075__$1;
(statearr_13148_13211[(1)] = (13));

} else {
var statearr_13149_13212 = state_13075__$1;
(statearr_13149_13212[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (18))){
var inst_13000 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13150_13213 = state_13075__$1;
(statearr_13150_13213[(2)] = inst_13000);

(statearr_13150_13213[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (42))){
var state_13075__$1 = state_13075;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13075__$1,(45),dchan);
} else {
if((state_val_13076 === (37))){
var inst_12947 = (state_13075[(9)]);
var inst_13043 = (state_13075[(23)]);
var inst_13034 = (state_13075[(25)]);
var inst_13043__$1 = cljs.core.first.call(null,inst_13034);
var inst_13044 = cljs.core.async.put_BANG_.call(null,inst_13043__$1,inst_12947,done);
var state_13075__$1 = (function (){var statearr_13151 = state_13075;
(statearr_13151[(23)] = inst_13043__$1);

return statearr_13151;
})();
if(cljs.core.truth_(inst_13044)){
var statearr_13152_13214 = state_13075__$1;
(statearr_13152_13214[(1)] = (39));

} else {
var statearr_13153_13215 = state_13075__$1;
(statearr_13153_13215[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (8))){
var inst_12959 = (state_13075[(15)]);
var inst_12958 = (state_13075[(17)]);
var inst_12961 = (inst_12959 < inst_12958);
var inst_12962 = inst_12961;
var state_13075__$1 = state_13075;
if(cljs.core.truth_(inst_12962)){
var statearr_13154_13216 = state_13075__$1;
(statearr_13154_13216[(1)] = (10));

} else {
var statearr_13155_13217 = state_13075__$1;
(statearr_13155_13217[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___13163,cs,m,dchan,dctr,done))
;
return ((function (switch__11791__auto__,c__11856__auto___13163,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__11792__auto__ = null;
var cljs$core$async$mult_$_state_machine__11792__auto____0 = (function (){
var statearr_13159 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13159[(0)] = cljs$core$async$mult_$_state_machine__11792__auto__);

(statearr_13159[(1)] = (1));

return statearr_13159;
});
var cljs$core$async$mult_$_state_machine__11792__auto____1 = (function (state_13075){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_13075);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e13160){if((e13160 instanceof Object)){
var ex__11795__auto__ = e13160;
var statearr_13161_13218 = state_13075;
(statearr_13161_13218[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13075);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13160;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13219 = state_13075;
state_13075 = G__13219;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11792__auto__ = function(state_13075){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11792__auto____1.call(this,state_13075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11792__auto____0;
cljs$core$async$mult_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11792__auto____1;
return cljs$core$async$mult_$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___13163,cs,m,dchan,dctr,done))
})();
var state__11858__auto__ = (function (){var statearr_13162 = f__11857__auto__.call(null);
(statearr_13162[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___13163);

return statearr_13162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___13163,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args13220 = [];
var len__7280__auto___13223 = arguments.length;
var i__7281__auto___13224 = (0);
while(true){
if((i__7281__auto___13224 < len__7280__auto___13223)){
args13220.push((arguments[i__7281__auto___13224]));

var G__13225 = (i__7281__auto___13224 + (1));
i__7281__auto___13224 = G__13225;
continue;
} else {
}
break;
}

var G__13222 = args13220.length;
switch (G__13222) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13220.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m,ch);
} else {
var m__6874__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m,ch);
} else {
var m__6874__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m);
} else {
var m__6874__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m,state_map);
} else {
var m__6874__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m,mode);
} else {
var m__6874__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___13237 = arguments.length;
var i__7281__auto___13238 = (0);
while(true){
if((i__7281__auto___13238 < len__7280__auto___13237)){
args__7287__auto__.push((arguments[i__7281__auto___13238]));

var G__13239 = (i__7281__auto___13238 + (1));
i__7281__auto___13238 = G__13239;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((3) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7288__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13231){
var map__13232 = p__13231;
var map__13232__$1 = ((((!((map__13232 == null)))?((((map__13232.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13232.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13232):map__13232);
var opts = map__13232__$1;
var statearr_13234_13240 = state;
(statearr_13234_13240[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__13232,map__13232__$1,opts){
return (function (val){
var statearr_13235_13241 = state;
(statearr_13235_13241[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__13232,map__13232__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_13236_13242 = state;
(statearr_13236_13242[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13227){
var G__13228 = cljs.core.first.call(null,seq13227);
var seq13227__$1 = cljs.core.next.call(null,seq13227);
var G__13229 = cljs.core.first.call(null,seq13227__$1);
var seq13227__$2 = cljs.core.next.call(null,seq13227__$1);
var G__13230 = cljs.core.first.call(null,seq13227__$2);
var seq13227__$3 = cljs.core.next.call(null,seq13227__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13228,G__13229,G__13230,seq13227__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async13406 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13406 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13407){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13407 = meta13407;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13406.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13408,meta13407__$1){
var self__ = this;
var _13408__$1 = this;
return (new cljs.core.async.t_cljs$core$async13406(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13407__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13406.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13408){
var self__ = this;
var _13408__$1 = this;
return self__.meta13407;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13406.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async13406.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13406.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async13406.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13406.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13406.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13406.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13406.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13406.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta13407","meta13407",1581476053,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13406.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13406.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13406";

cljs.core.async.t_cljs$core$async13406.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async13406");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async13406 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async13406(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13407){
return (new cljs.core.async.t_cljs$core$async13406(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13407));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async13406(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11856__auto___13569 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___13569,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___13569,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_13506){
var state_val_13507 = (state_13506[(1)]);
if((state_val_13507 === (7))){
var inst_13424 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
var statearr_13508_13570 = state_13506__$1;
(statearr_13508_13570[(2)] = inst_13424);

(statearr_13508_13570[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (20))){
var inst_13436 = (state_13506[(7)]);
var state_13506__$1 = state_13506;
var statearr_13509_13571 = state_13506__$1;
(statearr_13509_13571[(2)] = inst_13436);

(statearr_13509_13571[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (27))){
var state_13506__$1 = state_13506;
var statearr_13510_13572 = state_13506__$1;
(statearr_13510_13572[(2)] = null);

(statearr_13510_13572[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (1))){
var inst_13412 = (state_13506[(8)]);
var inst_13412__$1 = calc_state.call(null);
var inst_13414 = (inst_13412__$1 == null);
var inst_13415 = cljs.core.not.call(null,inst_13414);
var state_13506__$1 = (function (){var statearr_13511 = state_13506;
(statearr_13511[(8)] = inst_13412__$1);

return statearr_13511;
})();
if(inst_13415){
var statearr_13512_13573 = state_13506__$1;
(statearr_13512_13573[(1)] = (2));

} else {
var statearr_13513_13574 = state_13506__$1;
(statearr_13513_13574[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (24))){
var inst_13466 = (state_13506[(9)]);
var inst_13459 = (state_13506[(10)]);
var inst_13480 = (state_13506[(11)]);
var inst_13480__$1 = inst_13459.call(null,inst_13466);
var state_13506__$1 = (function (){var statearr_13514 = state_13506;
(statearr_13514[(11)] = inst_13480__$1);

return statearr_13514;
})();
if(cljs.core.truth_(inst_13480__$1)){
var statearr_13515_13575 = state_13506__$1;
(statearr_13515_13575[(1)] = (29));

} else {
var statearr_13516_13576 = state_13506__$1;
(statearr_13516_13576[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (4))){
var inst_13427 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
if(cljs.core.truth_(inst_13427)){
var statearr_13517_13577 = state_13506__$1;
(statearr_13517_13577[(1)] = (8));

} else {
var statearr_13518_13578 = state_13506__$1;
(statearr_13518_13578[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (15))){
var inst_13453 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
if(cljs.core.truth_(inst_13453)){
var statearr_13519_13579 = state_13506__$1;
(statearr_13519_13579[(1)] = (19));

} else {
var statearr_13520_13580 = state_13506__$1;
(statearr_13520_13580[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (21))){
var inst_13458 = (state_13506[(12)]);
var inst_13458__$1 = (state_13506[(2)]);
var inst_13459 = cljs.core.get.call(null,inst_13458__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13460 = cljs.core.get.call(null,inst_13458__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13461 = cljs.core.get.call(null,inst_13458__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_13506__$1 = (function (){var statearr_13521 = state_13506;
(statearr_13521[(13)] = inst_13460);

(statearr_13521[(12)] = inst_13458__$1);

(statearr_13521[(10)] = inst_13459);

return statearr_13521;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_13506__$1,(22),inst_13461);
} else {
if((state_val_13507 === (31))){
var inst_13488 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
if(cljs.core.truth_(inst_13488)){
var statearr_13522_13581 = state_13506__$1;
(statearr_13522_13581[(1)] = (32));

} else {
var statearr_13523_13582 = state_13506__$1;
(statearr_13523_13582[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (32))){
var inst_13465 = (state_13506[(14)]);
var state_13506__$1 = state_13506;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13506__$1,(35),out,inst_13465);
} else {
if((state_val_13507 === (33))){
var inst_13458 = (state_13506[(12)]);
var inst_13436 = inst_13458;
var state_13506__$1 = (function (){var statearr_13524 = state_13506;
(statearr_13524[(7)] = inst_13436);

return statearr_13524;
})();
var statearr_13525_13583 = state_13506__$1;
(statearr_13525_13583[(2)] = null);

(statearr_13525_13583[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (13))){
var inst_13436 = (state_13506[(7)]);
var inst_13443 = inst_13436.cljs$lang$protocol_mask$partition0$;
var inst_13444 = (inst_13443 & (64));
var inst_13445 = inst_13436.cljs$core$ISeq$;
var inst_13446 = (inst_13444) || (inst_13445);
var state_13506__$1 = state_13506;
if(cljs.core.truth_(inst_13446)){
var statearr_13526_13584 = state_13506__$1;
(statearr_13526_13584[(1)] = (16));

} else {
var statearr_13527_13585 = state_13506__$1;
(statearr_13527_13585[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (22))){
var inst_13465 = (state_13506[(14)]);
var inst_13466 = (state_13506[(9)]);
var inst_13464 = (state_13506[(2)]);
var inst_13465__$1 = cljs.core.nth.call(null,inst_13464,(0),null);
var inst_13466__$1 = cljs.core.nth.call(null,inst_13464,(1),null);
var inst_13467 = (inst_13465__$1 == null);
var inst_13468 = cljs.core._EQ_.call(null,inst_13466__$1,change);
var inst_13469 = (inst_13467) || (inst_13468);
var state_13506__$1 = (function (){var statearr_13528 = state_13506;
(statearr_13528[(14)] = inst_13465__$1);

(statearr_13528[(9)] = inst_13466__$1);

return statearr_13528;
})();
if(cljs.core.truth_(inst_13469)){
var statearr_13529_13586 = state_13506__$1;
(statearr_13529_13586[(1)] = (23));

} else {
var statearr_13530_13587 = state_13506__$1;
(statearr_13530_13587[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (36))){
var inst_13458 = (state_13506[(12)]);
var inst_13436 = inst_13458;
var state_13506__$1 = (function (){var statearr_13531 = state_13506;
(statearr_13531[(7)] = inst_13436);

return statearr_13531;
})();
var statearr_13532_13588 = state_13506__$1;
(statearr_13532_13588[(2)] = null);

(statearr_13532_13588[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (29))){
var inst_13480 = (state_13506[(11)]);
var state_13506__$1 = state_13506;
var statearr_13533_13589 = state_13506__$1;
(statearr_13533_13589[(2)] = inst_13480);

(statearr_13533_13589[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (6))){
var state_13506__$1 = state_13506;
var statearr_13534_13590 = state_13506__$1;
(statearr_13534_13590[(2)] = false);

(statearr_13534_13590[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (28))){
var inst_13476 = (state_13506[(2)]);
var inst_13477 = calc_state.call(null);
var inst_13436 = inst_13477;
var state_13506__$1 = (function (){var statearr_13535 = state_13506;
(statearr_13535[(7)] = inst_13436);

(statearr_13535[(15)] = inst_13476);

return statearr_13535;
})();
var statearr_13536_13591 = state_13506__$1;
(statearr_13536_13591[(2)] = null);

(statearr_13536_13591[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (25))){
var inst_13502 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
var statearr_13537_13592 = state_13506__$1;
(statearr_13537_13592[(2)] = inst_13502);

(statearr_13537_13592[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (34))){
var inst_13500 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
var statearr_13538_13593 = state_13506__$1;
(statearr_13538_13593[(2)] = inst_13500);

(statearr_13538_13593[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (17))){
var state_13506__$1 = state_13506;
var statearr_13539_13594 = state_13506__$1;
(statearr_13539_13594[(2)] = false);

(statearr_13539_13594[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (3))){
var state_13506__$1 = state_13506;
var statearr_13540_13595 = state_13506__$1;
(statearr_13540_13595[(2)] = false);

(statearr_13540_13595[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (12))){
var inst_13504 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13506__$1,inst_13504);
} else {
if((state_val_13507 === (2))){
var inst_13412 = (state_13506[(8)]);
var inst_13417 = inst_13412.cljs$lang$protocol_mask$partition0$;
var inst_13418 = (inst_13417 & (64));
var inst_13419 = inst_13412.cljs$core$ISeq$;
var inst_13420 = (inst_13418) || (inst_13419);
var state_13506__$1 = state_13506;
if(cljs.core.truth_(inst_13420)){
var statearr_13541_13596 = state_13506__$1;
(statearr_13541_13596[(1)] = (5));

} else {
var statearr_13542_13597 = state_13506__$1;
(statearr_13542_13597[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (23))){
var inst_13465 = (state_13506[(14)]);
var inst_13471 = (inst_13465 == null);
var state_13506__$1 = state_13506;
if(cljs.core.truth_(inst_13471)){
var statearr_13543_13598 = state_13506__$1;
(statearr_13543_13598[(1)] = (26));

} else {
var statearr_13544_13599 = state_13506__$1;
(statearr_13544_13599[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (35))){
var inst_13491 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
if(cljs.core.truth_(inst_13491)){
var statearr_13545_13600 = state_13506__$1;
(statearr_13545_13600[(1)] = (36));

} else {
var statearr_13546_13601 = state_13506__$1;
(statearr_13546_13601[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (19))){
var inst_13436 = (state_13506[(7)]);
var inst_13455 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13436);
var state_13506__$1 = state_13506;
var statearr_13547_13602 = state_13506__$1;
(statearr_13547_13602[(2)] = inst_13455);

(statearr_13547_13602[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (11))){
var inst_13436 = (state_13506[(7)]);
var inst_13440 = (inst_13436 == null);
var inst_13441 = cljs.core.not.call(null,inst_13440);
var state_13506__$1 = state_13506;
if(inst_13441){
var statearr_13548_13603 = state_13506__$1;
(statearr_13548_13603[(1)] = (13));

} else {
var statearr_13549_13604 = state_13506__$1;
(statearr_13549_13604[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (9))){
var inst_13412 = (state_13506[(8)]);
var state_13506__$1 = state_13506;
var statearr_13550_13605 = state_13506__$1;
(statearr_13550_13605[(2)] = inst_13412);

(statearr_13550_13605[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (5))){
var state_13506__$1 = state_13506;
var statearr_13551_13606 = state_13506__$1;
(statearr_13551_13606[(2)] = true);

(statearr_13551_13606[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (14))){
var state_13506__$1 = state_13506;
var statearr_13552_13607 = state_13506__$1;
(statearr_13552_13607[(2)] = false);

(statearr_13552_13607[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (26))){
var inst_13466 = (state_13506[(9)]);
var inst_13473 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_13466);
var state_13506__$1 = state_13506;
var statearr_13553_13608 = state_13506__$1;
(statearr_13553_13608[(2)] = inst_13473);

(statearr_13553_13608[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (16))){
var state_13506__$1 = state_13506;
var statearr_13554_13609 = state_13506__$1;
(statearr_13554_13609[(2)] = true);

(statearr_13554_13609[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (38))){
var inst_13496 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
var statearr_13555_13610 = state_13506__$1;
(statearr_13555_13610[(2)] = inst_13496);

(statearr_13555_13610[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (30))){
var inst_13460 = (state_13506[(13)]);
var inst_13466 = (state_13506[(9)]);
var inst_13459 = (state_13506[(10)]);
var inst_13483 = cljs.core.empty_QMARK_.call(null,inst_13459);
var inst_13484 = inst_13460.call(null,inst_13466);
var inst_13485 = cljs.core.not.call(null,inst_13484);
var inst_13486 = (inst_13483) && (inst_13485);
var state_13506__$1 = state_13506;
var statearr_13556_13611 = state_13506__$1;
(statearr_13556_13611[(2)] = inst_13486);

(statearr_13556_13611[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (10))){
var inst_13412 = (state_13506[(8)]);
var inst_13432 = (state_13506[(2)]);
var inst_13433 = cljs.core.get.call(null,inst_13432,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13434 = cljs.core.get.call(null,inst_13432,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13435 = cljs.core.get.call(null,inst_13432,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13436 = inst_13412;
var state_13506__$1 = (function (){var statearr_13557 = state_13506;
(statearr_13557[(7)] = inst_13436);

(statearr_13557[(16)] = inst_13434);

(statearr_13557[(17)] = inst_13435);

(statearr_13557[(18)] = inst_13433);

return statearr_13557;
})();
var statearr_13558_13612 = state_13506__$1;
(statearr_13558_13612[(2)] = null);

(statearr_13558_13612[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (18))){
var inst_13450 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
var statearr_13559_13613 = state_13506__$1;
(statearr_13559_13613[(2)] = inst_13450);

(statearr_13559_13613[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (37))){
var state_13506__$1 = state_13506;
var statearr_13560_13614 = state_13506__$1;
(statearr_13560_13614[(2)] = null);

(statearr_13560_13614[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (8))){
var inst_13412 = (state_13506[(8)]);
var inst_13429 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13412);
var state_13506__$1 = state_13506;
var statearr_13561_13615 = state_13506__$1;
(statearr_13561_13615[(2)] = inst_13429);

(statearr_13561_13615[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___13569,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__11791__auto__,c__11856__auto___13569,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__11792__auto__ = null;
var cljs$core$async$mix_$_state_machine__11792__auto____0 = (function (){
var statearr_13565 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13565[(0)] = cljs$core$async$mix_$_state_machine__11792__auto__);

(statearr_13565[(1)] = (1));

return statearr_13565;
});
var cljs$core$async$mix_$_state_machine__11792__auto____1 = (function (state_13506){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_13506);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e13566){if((e13566 instanceof Object)){
var ex__11795__auto__ = e13566;
var statearr_13567_13616 = state_13506;
(statearr_13567_13616[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13506);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13566;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13617 = state_13506;
state_13506 = G__13617;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11792__auto__ = function(state_13506){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11792__auto____1.call(this,state_13506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11792__auto____0;
cljs$core$async$mix_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11792__auto____1;
return cljs$core$async$mix_$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___13569,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11858__auto__ = (function (){var statearr_13568 = f__11857__auto__.call(null);
(statearr_13568[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___13569);

return statearr_13568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___13569,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6874__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,p,v,ch);
} else {
var m__6874__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args13618 = [];
var len__7280__auto___13621 = arguments.length;
var i__7281__auto___13622 = (0);
while(true){
if((i__7281__auto___13622 < len__7280__auto___13621)){
args13618.push((arguments[i__7281__auto___13622]));

var G__13623 = (i__7281__auto___13622 + (1));
i__7281__auto___13622 = G__13623;
continue;
} else {
}
break;
}

var G__13620 = args13618.length;
switch (G__13620) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13618.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,p);
} else {
var m__6874__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,p,v);
} else {
var m__6874__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args13626 = [];
var len__7280__auto___13751 = arguments.length;
var i__7281__auto___13752 = (0);
while(true){
if((i__7281__auto___13752 < len__7280__auto___13751)){
args13626.push((arguments[i__7281__auto___13752]));

var G__13753 = (i__7281__auto___13752 + (1));
i__7281__auto___13752 = G__13753;
continue;
} else {
}
break;
}

var G__13628 = args13626.length;
switch (G__13628) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13626.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6210__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6210__auto__,mults){
return (function (p1__13625_SHARP_){
if(cljs.core.truth_(p1__13625_SHARP_.call(null,topic))){
return p1__13625_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__13625_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6210__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async13629 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13629 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta13630){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta13630 = meta13630;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_13631,meta13630__$1){
var self__ = this;
var _13631__$1 = this;
return (new cljs.core.async.t_cljs$core$async13629(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta13630__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_13631){
var self__ = this;
var _13631__$1 = this;
return self__.meta13630;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13629.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13629.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta13630","meta13630",-470056836,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13629.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13629.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13629";

cljs.core.async.t_cljs$core$async13629.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async13629");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async13629 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async13629(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta13630){
return (new cljs.core.async.t_cljs$core$async13629(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta13630));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async13629(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11856__auto___13755 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___13755,mults,ensure_mult,p){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___13755,mults,ensure_mult,p){
return (function (state_13703){
var state_val_13704 = (state_13703[(1)]);
if((state_val_13704 === (7))){
var inst_13699 = (state_13703[(2)]);
var state_13703__$1 = state_13703;
var statearr_13705_13756 = state_13703__$1;
(statearr_13705_13756[(2)] = inst_13699);

(statearr_13705_13756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (20))){
var state_13703__$1 = state_13703;
var statearr_13706_13757 = state_13703__$1;
(statearr_13706_13757[(2)] = null);

(statearr_13706_13757[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (1))){
var state_13703__$1 = state_13703;
var statearr_13707_13758 = state_13703__$1;
(statearr_13707_13758[(2)] = null);

(statearr_13707_13758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (24))){
var inst_13682 = (state_13703[(7)]);
var inst_13691 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_13682);
var state_13703__$1 = state_13703;
var statearr_13708_13759 = state_13703__$1;
(statearr_13708_13759[(2)] = inst_13691);

(statearr_13708_13759[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (4))){
var inst_13634 = (state_13703[(8)]);
var inst_13634__$1 = (state_13703[(2)]);
var inst_13635 = (inst_13634__$1 == null);
var state_13703__$1 = (function (){var statearr_13709 = state_13703;
(statearr_13709[(8)] = inst_13634__$1);

return statearr_13709;
})();
if(cljs.core.truth_(inst_13635)){
var statearr_13710_13760 = state_13703__$1;
(statearr_13710_13760[(1)] = (5));

} else {
var statearr_13711_13761 = state_13703__$1;
(statearr_13711_13761[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (15))){
var inst_13676 = (state_13703[(2)]);
var state_13703__$1 = state_13703;
var statearr_13712_13762 = state_13703__$1;
(statearr_13712_13762[(2)] = inst_13676);

(statearr_13712_13762[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (21))){
var inst_13696 = (state_13703[(2)]);
var state_13703__$1 = (function (){var statearr_13713 = state_13703;
(statearr_13713[(9)] = inst_13696);

return statearr_13713;
})();
var statearr_13714_13763 = state_13703__$1;
(statearr_13714_13763[(2)] = null);

(statearr_13714_13763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (13))){
var inst_13658 = (state_13703[(10)]);
var inst_13660 = cljs.core.chunked_seq_QMARK_.call(null,inst_13658);
var state_13703__$1 = state_13703;
if(inst_13660){
var statearr_13715_13764 = state_13703__$1;
(statearr_13715_13764[(1)] = (16));

} else {
var statearr_13716_13765 = state_13703__$1;
(statearr_13716_13765[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (22))){
var inst_13688 = (state_13703[(2)]);
var state_13703__$1 = state_13703;
if(cljs.core.truth_(inst_13688)){
var statearr_13717_13766 = state_13703__$1;
(statearr_13717_13766[(1)] = (23));

} else {
var statearr_13718_13767 = state_13703__$1;
(statearr_13718_13767[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (6))){
var inst_13684 = (state_13703[(11)]);
var inst_13634 = (state_13703[(8)]);
var inst_13682 = (state_13703[(7)]);
var inst_13682__$1 = topic_fn.call(null,inst_13634);
var inst_13683 = cljs.core.deref.call(null,mults);
var inst_13684__$1 = cljs.core.get.call(null,inst_13683,inst_13682__$1);
var state_13703__$1 = (function (){var statearr_13719 = state_13703;
(statearr_13719[(11)] = inst_13684__$1);

(statearr_13719[(7)] = inst_13682__$1);

return statearr_13719;
})();
if(cljs.core.truth_(inst_13684__$1)){
var statearr_13720_13768 = state_13703__$1;
(statearr_13720_13768[(1)] = (19));

} else {
var statearr_13721_13769 = state_13703__$1;
(statearr_13721_13769[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (25))){
var inst_13693 = (state_13703[(2)]);
var state_13703__$1 = state_13703;
var statearr_13722_13770 = state_13703__$1;
(statearr_13722_13770[(2)] = inst_13693);

(statearr_13722_13770[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (17))){
var inst_13658 = (state_13703[(10)]);
var inst_13667 = cljs.core.first.call(null,inst_13658);
var inst_13668 = cljs.core.async.muxch_STAR_.call(null,inst_13667);
var inst_13669 = cljs.core.async.close_BANG_.call(null,inst_13668);
var inst_13670 = cljs.core.next.call(null,inst_13658);
var inst_13644 = inst_13670;
var inst_13645 = null;
var inst_13646 = (0);
var inst_13647 = (0);
var state_13703__$1 = (function (){var statearr_13723 = state_13703;
(statearr_13723[(12)] = inst_13645);

(statearr_13723[(13)] = inst_13647);

(statearr_13723[(14)] = inst_13646);

(statearr_13723[(15)] = inst_13644);

(statearr_13723[(16)] = inst_13669);

return statearr_13723;
})();
var statearr_13724_13771 = state_13703__$1;
(statearr_13724_13771[(2)] = null);

(statearr_13724_13771[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (3))){
var inst_13701 = (state_13703[(2)]);
var state_13703__$1 = state_13703;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13703__$1,inst_13701);
} else {
if((state_val_13704 === (12))){
var inst_13678 = (state_13703[(2)]);
var state_13703__$1 = state_13703;
var statearr_13725_13772 = state_13703__$1;
(statearr_13725_13772[(2)] = inst_13678);

(statearr_13725_13772[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (2))){
var state_13703__$1 = state_13703;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13703__$1,(4),ch);
} else {
if((state_val_13704 === (23))){
var state_13703__$1 = state_13703;
var statearr_13726_13773 = state_13703__$1;
(statearr_13726_13773[(2)] = null);

(statearr_13726_13773[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (19))){
var inst_13684 = (state_13703[(11)]);
var inst_13634 = (state_13703[(8)]);
var inst_13686 = cljs.core.async.muxch_STAR_.call(null,inst_13684);
var state_13703__$1 = state_13703;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13703__$1,(22),inst_13686,inst_13634);
} else {
if((state_val_13704 === (11))){
var inst_13658 = (state_13703[(10)]);
var inst_13644 = (state_13703[(15)]);
var inst_13658__$1 = cljs.core.seq.call(null,inst_13644);
var state_13703__$1 = (function (){var statearr_13727 = state_13703;
(statearr_13727[(10)] = inst_13658__$1);

return statearr_13727;
})();
if(inst_13658__$1){
var statearr_13728_13774 = state_13703__$1;
(statearr_13728_13774[(1)] = (13));

} else {
var statearr_13729_13775 = state_13703__$1;
(statearr_13729_13775[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (9))){
var inst_13680 = (state_13703[(2)]);
var state_13703__$1 = state_13703;
var statearr_13730_13776 = state_13703__$1;
(statearr_13730_13776[(2)] = inst_13680);

(statearr_13730_13776[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (5))){
var inst_13641 = cljs.core.deref.call(null,mults);
var inst_13642 = cljs.core.vals.call(null,inst_13641);
var inst_13643 = cljs.core.seq.call(null,inst_13642);
var inst_13644 = inst_13643;
var inst_13645 = null;
var inst_13646 = (0);
var inst_13647 = (0);
var state_13703__$1 = (function (){var statearr_13731 = state_13703;
(statearr_13731[(12)] = inst_13645);

(statearr_13731[(13)] = inst_13647);

(statearr_13731[(14)] = inst_13646);

(statearr_13731[(15)] = inst_13644);

return statearr_13731;
})();
var statearr_13732_13777 = state_13703__$1;
(statearr_13732_13777[(2)] = null);

(statearr_13732_13777[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (14))){
var state_13703__$1 = state_13703;
var statearr_13736_13778 = state_13703__$1;
(statearr_13736_13778[(2)] = null);

(statearr_13736_13778[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (16))){
var inst_13658 = (state_13703[(10)]);
var inst_13662 = cljs.core.chunk_first.call(null,inst_13658);
var inst_13663 = cljs.core.chunk_rest.call(null,inst_13658);
var inst_13664 = cljs.core.count.call(null,inst_13662);
var inst_13644 = inst_13663;
var inst_13645 = inst_13662;
var inst_13646 = inst_13664;
var inst_13647 = (0);
var state_13703__$1 = (function (){var statearr_13737 = state_13703;
(statearr_13737[(12)] = inst_13645);

(statearr_13737[(13)] = inst_13647);

(statearr_13737[(14)] = inst_13646);

(statearr_13737[(15)] = inst_13644);

return statearr_13737;
})();
var statearr_13738_13779 = state_13703__$1;
(statearr_13738_13779[(2)] = null);

(statearr_13738_13779[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (10))){
var inst_13645 = (state_13703[(12)]);
var inst_13647 = (state_13703[(13)]);
var inst_13646 = (state_13703[(14)]);
var inst_13644 = (state_13703[(15)]);
var inst_13652 = cljs.core._nth.call(null,inst_13645,inst_13647);
var inst_13653 = cljs.core.async.muxch_STAR_.call(null,inst_13652);
var inst_13654 = cljs.core.async.close_BANG_.call(null,inst_13653);
var inst_13655 = (inst_13647 + (1));
var tmp13733 = inst_13645;
var tmp13734 = inst_13646;
var tmp13735 = inst_13644;
var inst_13644__$1 = tmp13735;
var inst_13645__$1 = tmp13733;
var inst_13646__$1 = tmp13734;
var inst_13647__$1 = inst_13655;
var state_13703__$1 = (function (){var statearr_13739 = state_13703;
(statearr_13739[(12)] = inst_13645__$1);

(statearr_13739[(13)] = inst_13647__$1);

(statearr_13739[(14)] = inst_13646__$1);

(statearr_13739[(15)] = inst_13644__$1);

(statearr_13739[(17)] = inst_13654);

return statearr_13739;
})();
var statearr_13740_13780 = state_13703__$1;
(statearr_13740_13780[(2)] = null);

(statearr_13740_13780[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (18))){
var inst_13673 = (state_13703[(2)]);
var state_13703__$1 = state_13703;
var statearr_13741_13781 = state_13703__$1;
(statearr_13741_13781[(2)] = inst_13673);

(statearr_13741_13781[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13704 === (8))){
var inst_13647 = (state_13703[(13)]);
var inst_13646 = (state_13703[(14)]);
var inst_13649 = (inst_13647 < inst_13646);
var inst_13650 = inst_13649;
var state_13703__$1 = state_13703;
if(cljs.core.truth_(inst_13650)){
var statearr_13742_13782 = state_13703__$1;
(statearr_13742_13782[(1)] = (10));

} else {
var statearr_13743_13783 = state_13703__$1;
(statearr_13743_13783[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___13755,mults,ensure_mult,p))
;
return ((function (switch__11791__auto__,c__11856__auto___13755,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_13747 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13747[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_13747[(1)] = (1));

return statearr_13747;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_13703){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_13703);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e13748){if((e13748 instanceof Object)){
var ex__11795__auto__ = e13748;
var statearr_13749_13784 = state_13703;
(statearr_13749_13784[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13703);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13748;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13785 = state_13703;
state_13703 = G__13785;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_13703){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_13703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___13755,mults,ensure_mult,p))
})();
var state__11858__auto__ = (function (){var statearr_13750 = f__11857__auto__.call(null);
(statearr_13750[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___13755);

return statearr_13750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___13755,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args13786 = [];
var len__7280__auto___13789 = arguments.length;
var i__7281__auto___13790 = (0);
while(true){
if((i__7281__auto___13790 < len__7280__auto___13789)){
args13786.push((arguments[i__7281__auto___13790]));

var G__13791 = (i__7281__auto___13790 + (1));
i__7281__auto___13790 = G__13791;
continue;
} else {
}
break;
}

var G__13788 = args13786.length;
switch (G__13788) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13786.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args13793 = [];
var len__7280__auto___13796 = arguments.length;
var i__7281__auto___13797 = (0);
while(true){
if((i__7281__auto___13797 < len__7280__auto___13796)){
args13793.push((arguments[i__7281__auto___13797]));

var G__13798 = (i__7281__auto___13797 + (1));
i__7281__auto___13797 = G__13798;
continue;
} else {
}
break;
}

var G__13795 = args13793.length;
switch (G__13795) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13793.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args13800 = [];
var len__7280__auto___13871 = arguments.length;
var i__7281__auto___13872 = (0);
while(true){
if((i__7281__auto___13872 < len__7280__auto___13871)){
args13800.push((arguments[i__7281__auto___13872]));

var G__13873 = (i__7281__auto___13872 + (1));
i__7281__auto___13872 = G__13873;
continue;
} else {
}
break;
}

var G__13802 = args13800.length;
switch (G__13802) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13800.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11856__auto___13875 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___13875,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___13875,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_13841){
var state_val_13842 = (state_13841[(1)]);
if((state_val_13842 === (7))){
var state_13841__$1 = state_13841;
var statearr_13843_13876 = state_13841__$1;
(statearr_13843_13876[(2)] = null);

(statearr_13843_13876[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (1))){
var state_13841__$1 = state_13841;
var statearr_13844_13877 = state_13841__$1;
(statearr_13844_13877[(2)] = null);

(statearr_13844_13877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (4))){
var inst_13805 = (state_13841[(7)]);
var inst_13807 = (inst_13805 < cnt);
var state_13841__$1 = state_13841;
if(cljs.core.truth_(inst_13807)){
var statearr_13845_13878 = state_13841__$1;
(statearr_13845_13878[(1)] = (6));

} else {
var statearr_13846_13879 = state_13841__$1;
(statearr_13846_13879[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (15))){
var inst_13837 = (state_13841[(2)]);
var state_13841__$1 = state_13841;
var statearr_13847_13880 = state_13841__$1;
(statearr_13847_13880[(2)] = inst_13837);

(statearr_13847_13880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (13))){
var inst_13830 = cljs.core.async.close_BANG_.call(null,out);
var state_13841__$1 = state_13841;
var statearr_13848_13881 = state_13841__$1;
(statearr_13848_13881[(2)] = inst_13830);

(statearr_13848_13881[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (6))){
var state_13841__$1 = state_13841;
var statearr_13849_13882 = state_13841__$1;
(statearr_13849_13882[(2)] = null);

(statearr_13849_13882[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (3))){
var inst_13839 = (state_13841[(2)]);
var state_13841__$1 = state_13841;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13841__$1,inst_13839);
} else {
if((state_val_13842 === (12))){
var inst_13827 = (state_13841[(8)]);
var inst_13827__$1 = (state_13841[(2)]);
var inst_13828 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_13827__$1);
var state_13841__$1 = (function (){var statearr_13850 = state_13841;
(statearr_13850[(8)] = inst_13827__$1);

return statearr_13850;
})();
if(cljs.core.truth_(inst_13828)){
var statearr_13851_13883 = state_13841__$1;
(statearr_13851_13883[(1)] = (13));

} else {
var statearr_13852_13884 = state_13841__$1;
(statearr_13852_13884[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (2))){
var inst_13804 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_13805 = (0);
var state_13841__$1 = (function (){var statearr_13853 = state_13841;
(statearr_13853[(7)] = inst_13805);

(statearr_13853[(9)] = inst_13804);

return statearr_13853;
})();
var statearr_13854_13885 = state_13841__$1;
(statearr_13854_13885[(2)] = null);

(statearr_13854_13885[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (11))){
var inst_13805 = (state_13841[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_13841,(10),Object,null,(9));
var inst_13814 = chs__$1.call(null,inst_13805);
var inst_13815 = done.call(null,inst_13805);
var inst_13816 = cljs.core.async.take_BANG_.call(null,inst_13814,inst_13815);
var state_13841__$1 = state_13841;
var statearr_13855_13886 = state_13841__$1;
(statearr_13855_13886[(2)] = inst_13816);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13841__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (9))){
var inst_13805 = (state_13841[(7)]);
var inst_13818 = (state_13841[(2)]);
var inst_13819 = (inst_13805 + (1));
var inst_13805__$1 = inst_13819;
var state_13841__$1 = (function (){var statearr_13856 = state_13841;
(statearr_13856[(7)] = inst_13805__$1);

(statearr_13856[(10)] = inst_13818);

return statearr_13856;
})();
var statearr_13857_13887 = state_13841__$1;
(statearr_13857_13887[(2)] = null);

(statearr_13857_13887[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (5))){
var inst_13825 = (state_13841[(2)]);
var state_13841__$1 = (function (){var statearr_13858 = state_13841;
(statearr_13858[(11)] = inst_13825);

return statearr_13858;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13841__$1,(12),dchan);
} else {
if((state_val_13842 === (14))){
var inst_13827 = (state_13841[(8)]);
var inst_13832 = cljs.core.apply.call(null,f,inst_13827);
var state_13841__$1 = state_13841;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13841__$1,(16),out,inst_13832);
} else {
if((state_val_13842 === (16))){
var inst_13834 = (state_13841[(2)]);
var state_13841__$1 = (function (){var statearr_13859 = state_13841;
(statearr_13859[(12)] = inst_13834);

return statearr_13859;
})();
var statearr_13860_13888 = state_13841__$1;
(statearr_13860_13888[(2)] = null);

(statearr_13860_13888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (10))){
var inst_13809 = (state_13841[(2)]);
var inst_13810 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_13841__$1 = (function (){var statearr_13861 = state_13841;
(statearr_13861[(13)] = inst_13809);

return statearr_13861;
})();
var statearr_13862_13889 = state_13841__$1;
(statearr_13862_13889[(2)] = inst_13810);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13841__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (8))){
var inst_13823 = (state_13841[(2)]);
var state_13841__$1 = state_13841;
var statearr_13863_13890 = state_13841__$1;
(statearr_13863_13890[(2)] = inst_13823);

(statearr_13863_13890[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___13875,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__11791__auto__,c__11856__auto___13875,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_13867 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13867[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_13867[(1)] = (1));

return statearr_13867;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_13841){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_13841);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e13868){if((e13868 instanceof Object)){
var ex__11795__auto__ = e13868;
var statearr_13869_13891 = state_13841;
(statearr_13869_13891[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13841);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13868;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13892 = state_13841;
state_13841 = G__13892;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_13841){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_13841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___13875,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11858__auto__ = (function (){var statearr_13870 = f__11857__auto__.call(null);
(statearr_13870[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___13875);

return statearr_13870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___13875,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args13894 = [];
var len__7280__auto___13950 = arguments.length;
var i__7281__auto___13951 = (0);
while(true){
if((i__7281__auto___13951 < len__7280__auto___13950)){
args13894.push((arguments[i__7281__auto___13951]));

var G__13952 = (i__7281__auto___13951 + (1));
i__7281__auto___13951 = G__13952;
continue;
} else {
}
break;
}

var G__13896 = args13894.length;
switch (G__13896) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13894.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11856__auto___13954 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___13954,out){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___13954,out){
return (function (state_13926){
var state_val_13927 = (state_13926[(1)]);
if((state_val_13927 === (7))){
var inst_13906 = (state_13926[(7)]);
var inst_13905 = (state_13926[(8)]);
var inst_13905__$1 = (state_13926[(2)]);
var inst_13906__$1 = cljs.core.nth.call(null,inst_13905__$1,(0),null);
var inst_13907 = cljs.core.nth.call(null,inst_13905__$1,(1),null);
var inst_13908 = (inst_13906__$1 == null);
var state_13926__$1 = (function (){var statearr_13928 = state_13926;
(statearr_13928[(7)] = inst_13906__$1);

(statearr_13928[(8)] = inst_13905__$1);

(statearr_13928[(9)] = inst_13907);

return statearr_13928;
})();
if(cljs.core.truth_(inst_13908)){
var statearr_13929_13955 = state_13926__$1;
(statearr_13929_13955[(1)] = (8));

} else {
var statearr_13930_13956 = state_13926__$1;
(statearr_13930_13956[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13927 === (1))){
var inst_13897 = cljs.core.vec.call(null,chs);
var inst_13898 = inst_13897;
var state_13926__$1 = (function (){var statearr_13931 = state_13926;
(statearr_13931[(10)] = inst_13898);

return statearr_13931;
})();
var statearr_13932_13957 = state_13926__$1;
(statearr_13932_13957[(2)] = null);

(statearr_13932_13957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13927 === (4))){
var inst_13898 = (state_13926[(10)]);
var state_13926__$1 = state_13926;
return cljs.core.async.ioc_alts_BANG_.call(null,state_13926__$1,(7),inst_13898);
} else {
if((state_val_13927 === (6))){
var inst_13922 = (state_13926[(2)]);
var state_13926__$1 = state_13926;
var statearr_13933_13958 = state_13926__$1;
(statearr_13933_13958[(2)] = inst_13922);

(statearr_13933_13958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13927 === (3))){
var inst_13924 = (state_13926[(2)]);
var state_13926__$1 = state_13926;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13926__$1,inst_13924);
} else {
if((state_val_13927 === (2))){
var inst_13898 = (state_13926[(10)]);
var inst_13900 = cljs.core.count.call(null,inst_13898);
var inst_13901 = (inst_13900 > (0));
var state_13926__$1 = state_13926;
if(cljs.core.truth_(inst_13901)){
var statearr_13935_13959 = state_13926__$1;
(statearr_13935_13959[(1)] = (4));

} else {
var statearr_13936_13960 = state_13926__$1;
(statearr_13936_13960[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13927 === (11))){
var inst_13898 = (state_13926[(10)]);
var inst_13915 = (state_13926[(2)]);
var tmp13934 = inst_13898;
var inst_13898__$1 = tmp13934;
var state_13926__$1 = (function (){var statearr_13937 = state_13926;
(statearr_13937[(11)] = inst_13915);

(statearr_13937[(10)] = inst_13898__$1);

return statearr_13937;
})();
var statearr_13938_13961 = state_13926__$1;
(statearr_13938_13961[(2)] = null);

(statearr_13938_13961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13927 === (9))){
var inst_13906 = (state_13926[(7)]);
var state_13926__$1 = state_13926;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13926__$1,(11),out,inst_13906);
} else {
if((state_val_13927 === (5))){
var inst_13920 = cljs.core.async.close_BANG_.call(null,out);
var state_13926__$1 = state_13926;
var statearr_13939_13962 = state_13926__$1;
(statearr_13939_13962[(2)] = inst_13920);

(statearr_13939_13962[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13927 === (10))){
var inst_13918 = (state_13926[(2)]);
var state_13926__$1 = state_13926;
var statearr_13940_13963 = state_13926__$1;
(statearr_13940_13963[(2)] = inst_13918);

(statearr_13940_13963[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13927 === (8))){
var inst_13906 = (state_13926[(7)]);
var inst_13905 = (state_13926[(8)]);
var inst_13907 = (state_13926[(9)]);
var inst_13898 = (state_13926[(10)]);
var inst_13910 = (function (){var cs = inst_13898;
var vec__13903 = inst_13905;
var v = inst_13906;
var c = inst_13907;
return ((function (cs,vec__13903,v,c,inst_13906,inst_13905,inst_13907,inst_13898,state_val_13927,c__11856__auto___13954,out){
return (function (p1__13893_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__13893_SHARP_);
});
;})(cs,vec__13903,v,c,inst_13906,inst_13905,inst_13907,inst_13898,state_val_13927,c__11856__auto___13954,out))
})();
var inst_13911 = cljs.core.filterv.call(null,inst_13910,inst_13898);
var inst_13898__$1 = inst_13911;
var state_13926__$1 = (function (){var statearr_13941 = state_13926;
(statearr_13941[(10)] = inst_13898__$1);

return statearr_13941;
})();
var statearr_13942_13964 = state_13926__$1;
(statearr_13942_13964[(2)] = null);

(statearr_13942_13964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___13954,out))
;
return ((function (switch__11791__auto__,c__11856__auto___13954,out){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_13946 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13946[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_13946[(1)] = (1));

return statearr_13946;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_13926){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_13926);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e13947){if((e13947 instanceof Object)){
var ex__11795__auto__ = e13947;
var statearr_13948_13965 = state_13926;
(statearr_13948_13965[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13926);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13947;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13966 = state_13926;
state_13926 = G__13966;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_13926){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_13926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___13954,out))
})();
var state__11858__auto__ = (function (){var statearr_13949 = f__11857__auto__.call(null);
(statearr_13949[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___13954);

return statearr_13949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___13954,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args13967 = [];
var len__7280__auto___14016 = arguments.length;
var i__7281__auto___14017 = (0);
while(true){
if((i__7281__auto___14017 < len__7280__auto___14016)){
args13967.push((arguments[i__7281__auto___14017]));

var G__14018 = (i__7281__auto___14017 + (1));
i__7281__auto___14017 = G__14018;
continue;
} else {
}
break;
}

var G__13969 = args13967.length;
switch (G__13969) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13967.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11856__auto___14020 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___14020,out){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___14020,out){
return (function (state_13993){
var state_val_13994 = (state_13993[(1)]);
if((state_val_13994 === (7))){
var inst_13975 = (state_13993[(7)]);
var inst_13975__$1 = (state_13993[(2)]);
var inst_13976 = (inst_13975__$1 == null);
var inst_13977 = cljs.core.not.call(null,inst_13976);
var state_13993__$1 = (function (){var statearr_13995 = state_13993;
(statearr_13995[(7)] = inst_13975__$1);

return statearr_13995;
})();
if(inst_13977){
var statearr_13996_14021 = state_13993__$1;
(statearr_13996_14021[(1)] = (8));

} else {
var statearr_13997_14022 = state_13993__$1;
(statearr_13997_14022[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (1))){
var inst_13970 = (0);
var state_13993__$1 = (function (){var statearr_13998 = state_13993;
(statearr_13998[(8)] = inst_13970);

return statearr_13998;
})();
var statearr_13999_14023 = state_13993__$1;
(statearr_13999_14023[(2)] = null);

(statearr_13999_14023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (4))){
var state_13993__$1 = state_13993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13993__$1,(7),ch);
} else {
if((state_val_13994 === (6))){
var inst_13988 = (state_13993[(2)]);
var state_13993__$1 = state_13993;
var statearr_14000_14024 = state_13993__$1;
(statearr_14000_14024[(2)] = inst_13988);

(statearr_14000_14024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (3))){
var inst_13990 = (state_13993[(2)]);
var inst_13991 = cljs.core.async.close_BANG_.call(null,out);
var state_13993__$1 = (function (){var statearr_14001 = state_13993;
(statearr_14001[(9)] = inst_13990);

return statearr_14001;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13993__$1,inst_13991);
} else {
if((state_val_13994 === (2))){
var inst_13970 = (state_13993[(8)]);
var inst_13972 = (inst_13970 < n);
var state_13993__$1 = state_13993;
if(cljs.core.truth_(inst_13972)){
var statearr_14002_14025 = state_13993__$1;
(statearr_14002_14025[(1)] = (4));

} else {
var statearr_14003_14026 = state_13993__$1;
(statearr_14003_14026[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (11))){
var inst_13970 = (state_13993[(8)]);
var inst_13980 = (state_13993[(2)]);
var inst_13981 = (inst_13970 + (1));
var inst_13970__$1 = inst_13981;
var state_13993__$1 = (function (){var statearr_14004 = state_13993;
(statearr_14004[(10)] = inst_13980);

(statearr_14004[(8)] = inst_13970__$1);

return statearr_14004;
})();
var statearr_14005_14027 = state_13993__$1;
(statearr_14005_14027[(2)] = null);

(statearr_14005_14027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (9))){
var state_13993__$1 = state_13993;
var statearr_14006_14028 = state_13993__$1;
(statearr_14006_14028[(2)] = null);

(statearr_14006_14028[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (5))){
var state_13993__$1 = state_13993;
var statearr_14007_14029 = state_13993__$1;
(statearr_14007_14029[(2)] = null);

(statearr_14007_14029[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (10))){
var inst_13985 = (state_13993[(2)]);
var state_13993__$1 = state_13993;
var statearr_14008_14030 = state_13993__$1;
(statearr_14008_14030[(2)] = inst_13985);

(statearr_14008_14030[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (8))){
var inst_13975 = (state_13993[(7)]);
var state_13993__$1 = state_13993;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13993__$1,(11),out,inst_13975);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___14020,out))
;
return ((function (switch__11791__auto__,c__11856__auto___14020,out){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_14012 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14012[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_14012[(1)] = (1));

return statearr_14012;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_13993){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_13993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e14013){if((e14013 instanceof Object)){
var ex__11795__auto__ = e14013;
var statearr_14014_14031 = state_13993;
(statearr_14014_14031[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13993);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14013;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14032 = state_13993;
state_13993 = G__14032;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_13993){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_13993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___14020,out))
})();
var state__11858__auto__ = (function (){var statearr_14015 = f__11857__auto__.call(null);
(statearr_14015[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___14020);

return statearr_14015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___14020,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14040 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14040 = (function (map_LT_,f,ch,meta14041){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14041 = meta14041;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14040.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14042,meta14041__$1){
var self__ = this;
var _14042__$1 = this;
return (new cljs.core.async.t_cljs$core$async14040(self__.map_LT_,self__.f,self__.ch,meta14041__$1));
});

cljs.core.async.t_cljs$core$async14040.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14042){
var self__ = this;
var _14042__$1 = this;
return self__.meta14041;
});

cljs.core.async.t_cljs$core$async14040.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14040.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14040.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14040.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14040.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async14043 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14043 = (function (map_LT_,f,ch,meta14041,_,fn1,meta14044){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14041 = meta14041;
this._ = _;
this.fn1 = fn1;
this.meta14044 = meta14044;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14043.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_14045,meta14044__$1){
var self__ = this;
var _14045__$1 = this;
return (new cljs.core.async.t_cljs$core$async14043(self__.map_LT_,self__.f,self__.ch,self__.meta14041,self__._,self__.fn1,meta14044__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async14043.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_14045){
var self__ = this;
var _14045__$1 = this;
return self__.meta14044;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14043.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14043.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14043.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14043.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__14033_SHARP_){
return f1.call(null,(((p1__14033_SHARP_ == null))?null:self__.f.call(null,p1__14033_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async14043.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14041","meta14041",170389346,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async14040","cljs.core.async/t_cljs$core$async14040",829937921,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta14044","meta14044",837326151,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14043.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14043.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14043";

cljs.core.async.t_cljs$core$async14043.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async14043");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async14043 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14043(map_LT___$1,f__$1,ch__$1,meta14041__$1,___$2,fn1__$1,meta14044){
return (new cljs.core.async.t_cljs$core$async14043(map_LT___$1,f__$1,ch__$1,meta14041__$1,___$2,fn1__$1,meta14044));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async14043(self__.map_LT_,self__.f,self__.ch,self__.meta14041,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6198__auto__ = ret;
if(cljs.core.truth_(and__6198__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6198__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async14040.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14040.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async14040.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14041","meta14041",170389346,null)], null);
});

cljs.core.async.t_cljs$core$async14040.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14040.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14040";

cljs.core.async.t_cljs$core$async14040.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async14040");
});

cljs.core.async.__GT_t_cljs$core$async14040 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14040(map_LT___$1,f__$1,ch__$1,meta14041){
return (new cljs.core.async.t_cljs$core$async14040(map_LT___$1,f__$1,ch__$1,meta14041));
});

}

return (new cljs.core.async.t_cljs$core$async14040(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14049 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14049 = (function (map_GT_,f,ch,meta14050){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta14050 = meta14050;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14049.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14051,meta14050__$1){
var self__ = this;
var _14051__$1 = this;
return (new cljs.core.async.t_cljs$core$async14049(self__.map_GT_,self__.f,self__.ch,meta14050__$1));
});

cljs.core.async.t_cljs$core$async14049.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14051){
var self__ = this;
var _14051__$1 = this;
return self__.meta14050;
});

cljs.core.async.t_cljs$core$async14049.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14049.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14049.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14049.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14049.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14049.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async14049.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14050","meta14050",1640878147,null)], null);
});

cljs.core.async.t_cljs$core$async14049.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14049.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14049";

cljs.core.async.t_cljs$core$async14049.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async14049");
});

cljs.core.async.__GT_t_cljs$core$async14049 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async14049(map_GT___$1,f__$1,ch__$1,meta14050){
return (new cljs.core.async.t_cljs$core$async14049(map_GT___$1,f__$1,ch__$1,meta14050));
});

}

return (new cljs.core.async.t_cljs$core$async14049(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async14055 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14055 = (function (filter_GT_,p,ch,meta14056){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta14056 = meta14056;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14055.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14057,meta14056__$1){
var self__ = this;
var _14057__$1 = this;
return (new cljs.core.async.t_cljs$core$async14055(self__.filter_GT_,self__.p,self__.ch,meta14056__$1));
});

cljs.core.async.t_cljs$core$async14055.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14057){
var self__ = this;
var _14057__$1 = this;
return self__.meta14056;
});

cljs.core.async.t_cljs$core$async14055.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14055.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14055.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14055.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14055.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14055.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14055.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async14055.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14056","meta14056",-1652033110,null)], null);
});

cljs.core.async.t_cljs$core$async14055.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14055.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14055";

cljs.core.async.t_cljs$core$async14055.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async14055");
});

cljs.core.async.__GT_t_cljs$core$async14055 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async14055(filter_GT___$1,p__$1,ch__$1,meta14056){
return (new cljs.core.async.t_cljs$core$async14055(filter_GT___$1,p__$1,ch__$1,meta14056));
});

}

return (new cljs.core.async.t_cljs$core$async14055(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args14058 = [];
var len__7280__auto___14102 = arguments.length;
var i__7281__auto___14103 = (0);
while(true){
if((i__7281__auto___14103 < len__7280__auto___14102)){
args14058.push((arguments[i__7281__auto___14103]));

var G__14104 = (i__7281__auto___14103 + (1));
i__7281__auto___14103 = G__14104;
continue;
} else {
}
break;
}

var G__14060 = args14058.length;
switch (G__14060) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14058.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11856__auto___14106 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___14106,out){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___14106,out){
return (function (state_14081){
var state_val_14082 = (state_14081[(1)]);
if((state_val_14082 === (7))){
var inst_14077 = (state_14081[(2)]);
var state_14081__$1 = state_14081;
var statearr_14083_14107 = state_14081__$1;
(statearr_14083_14107[(2)] = inst_14077);

(statearr_14083_14107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14082 === (1))){
var state_14081__$1 = state_14081;
var statearr_14084_14108 = state_14081__$1;
(statearr_14084_14108[(2)] = null);

(statearr_14084_14108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14082 === (4))){
var inst_14063 = (state_14081[(7)]);
var inst_14063__$1 = (state_14081[(2)]);
var inst_14064 = (inst_14063__$1 == null);
var state_14081__$1 = (function (){var statearr_14085 = state_14081;
(statearr_14085[(7)] = inst_14063__$1);

return statearr_14085;
})();
if(cljs.core.truth_(inst_14064)){
var statearr_14086_14109 = state_14081__$1;
(statearr_14086_14109[(1)] = (5));

} else {
var statearr_14087_14110 = state_14081__$1;
(statearr_14087_14110[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14082 === (6))){
var inst_14063 = (state_14081[(7)]);
var inst_14068 = p.call(null,inst_14063);
var state_14081__$1 = state_14081;
if(cljs.core.truth_(inst_14068)){
var statearr_14088_14111 = state_14081__$1;
(statearr_14088_14111[(1)] = (8));

} else {
var statearr_14089_14112 = state_14081__$1;
(statearr_14089_14112[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14082 === (3))){
var inst_14079 = (state_14081[(2)]);
var state_14081__$1 = state_14081;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14081__$1,inst_14079);
} else {
if((state_val_14082 === (2))){
var state_14081__$1 = state_14081;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14081__$1,(4),ch);
} else {
if((state_val_14082 === (11))){
var inst_14071 = (state_14081[(2)]);
var state_14081__$1 = state_14081;
var statearr_14090_14113 = state_14081__$1;
(statearr_14090_14113[(2)] = inst_14071);

(statearr_14090_14113[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14082 === (9))){
var state_14081__$1 = state_14081;
var statearr_14091_14114 = state_14081__$1;
(statearr_14091_14114[(2)] = null);

(statearr_14091_14114[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14082 === (5))){
var inst_14066 = cljs.core.async.close_BANG_.call(null,out);
var state_14081__$1 = state_14081;
var statearr_14092_14115 = state_14081__$1;
(statearr_14092_14115[(2)] = inst_14066);

(statearr_14092_14115[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14082 === (10))){
var inst_14074 = (state_14081[(2)]);
var state_14081__$1 = (function (){var statearr_14093 = state_14081;
(statearr_14093[(8)] = inst_14074);

return statearr_14093;
})();
var statearr_14094_14116 = state_14081__$1;
(statearr_14094_14116[(2)] = null);

(statearr_14094_14116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14082 === (8))){
var inst_14063 = (state_14081[(7)]);
var state_14081__$1 = state_14081;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14081__$1,(11),out,inst_14063);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___14106,out))
;
return ((function (switch__11791__auto__,c__11856__auto___14106,out){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_14098 = [null,null,null,null,null,null,null,null,null];
(statearr_14098[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_14098[(1)] = (1));

return statearr_14098;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_14081){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_14081);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e14099){if((e14099 instanceof Object)){
var ex__11795__auto__ = e14099;
var statearr_14100_14117 = state_14081;
(statearr_14100_14117[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14081);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14099;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14118 = state_14081;
state_14081 = G__14118;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_14081){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_14081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___14106,out))
})();
var state__11858__auto__ = (function (){var statearr_14101 = f__11857__auto__.call(null);
(statearr_14101[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___14106);

return statearr_14101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___14106,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args14119 = [];
var len__7280__auto___14122 = arguments.length;
var i__7281__auto___14123 = (0);
while(true){
if((i__7281__auto___14123 < len__7280__auto___14122)){
args14119.push((arguments[i__7281__auto___14123]));

var G__14124 = (i__7281__auto___14123 + (1));
i__7281__auto___14123 = G__14124;
continue;
} else {
}
break;
}

var G__14121 = args14119.length;
switch (G__14121) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14119.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11856__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto__){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__){
return (function (state_14291){
var state_val_14292 = (state_14291[(1)]);
if((state_val_14292 === (7))){
var inst_14287 = (state_14291[(2)]);
var state_14291__$1 = state_14291;
var statearr_14293_14334 = state_14291__$1;
(statearr_14293_14334[(2)] = inst_14287);

(statearr_14293_14334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (20))){
var inst_14257 = (state_14291[(7)]);
var inst_14268 = (state_14291[(2)]);
var inst_14269 = cljs.core.next.call(null,inst_14257);
var inst_14243 = inst_14269;
var inst_14244 = null;
var inst_14245 = (0);
var inst_14246 = (0);
var state_14291__$1 = (function (){var statearr_14294 = state_14291;
(statearr_14294[(8)] = inst_14268);

(statearr_14294[(9)] = inst_14244);

(statearr_14294[(10)] = inst_14245);

(statearr_14294[(11)] = inst_14246);

(statearr_14294[(12)] = inst_14243);

return statearr_14294;
})();
var statearr_14295_14335 = state_14291__$1;
(statearr_14295_14335[(2)] = null);

(statearr_14295_14335[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (1))){
var state_14291__$1 = state_14291;
var statearr_14296_14336 = state_14291__$1;
(statearr_14296_14336[(2)] = null);

(statearr_14296_14336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (4))){
var inst_14232 = (state_14291[(13)]);
var inst_14232__$1 = (state_14291[(2)]);
var inst_14233 = (inst_14232__$1 == null);
var state_14291__$1 = (function (){var statearr_14297 = state_14291;
(statearr_14297[(13)] = inst_14232__$1);

return statearr_14297;
})();
if(cljs.core.truth_(inst_14233)){
var statearr_14298_14337 = state_14291__$1;
(statearr_14298_14337[(1)] = (5));

} else {
var statearr_14299_14338 = state_14291__$1;
(statearr_14299_14338[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (15))){
var state_14291__$1 = state_14291;
var statearr_14303_14339 = state_14291__$1;
(statearr_14303_14339[(2)] = null);

(statearr_14303_14339[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (21))){
var state_14291__$1 = state_14291;
var statearr_14304_14340 = state_14291__$1;
(statearr_14304_14340[(2)] = null);

(statearr_14304_14340[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (13))){
var inst_14244 = (state_14291[(9)]);
var inst_14245 = (state_14291[(10)]);
var inst_14246 = (state_14291[(11)]);
var inst_14243 = (state_14291[(12)]);
var inst_14253 = (state_14291[(2)]);
var inst_14254 = (inst_14246 + (1));
var tmp14300 = inst_14244;
var tmp14301 = inst_14245;
var tmp14302 = inst_14243;
var inst_14243__$1 = tmp14302;
var inst_14244__$1 = tmp14300;
var inst_14245__$1 = tmp14301;
var inst_14246__$1 = inst_14254;
var state_14291__$1 = (function (){var statearr_14305 = state_14291;
(statearr_14305[(9)] = inst_14244__$1);

(statearr_14305[(10)] = inst_14245__$1);

(statearr_14305[(14)] = inst_14253);

(statearr_14305[(11)] = inst_14246__$1);

(statearr_14305[(12)] = inst_14243__$1);

return statearr_14305;
})();
var statearr_14306_14341 = state_14291__$1;
(statearr_14306_14341[(2)] = null);

(statearr_14306_14341[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (22))){
var state_14291__$1 = state_14291;
var statearr_14307_14342 = state_14291__$1;
(statearr_14307_14342[(2)] = null);

(statearr_14307_14342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (6))){
var inst_14232 = (state_14291[(13)]);
var inst_14241 = f.call(null,inst_14232);
var inst_14242 = cljs.core.seq.call(null,inst_14241);
var inst_14243 = inst_14242;
var inst_14244 = null;
var inst_14245 = (0);
var inst_14246 = (0);
var state_14291__$1 = (function (){var statearr_14308 = state_14291;
(statearr_14308[(9)] = inst_14244);

(statearr_14308[(10)] = inst_14245);

(statearr_14308[(11)] = inst_14246);

(statearr_14308[(12)] = inst_14243);

return statearr_14308;
})();
var statearr_14309_14343 = state_14291__$1;
(statearr_14309_14343[(2)] = null);

(statearr_14309_14343[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (17))){
var inst_14257 = (state_14291[(7)]);
var inst_14261 = cljs.core.chunk_first.call(null,inst_14257);
var inst_14262 = cljs.core.chunk_rest.call(null,inst_14257);
var inst_14263 = cljs.core.count.call(null,inst_14261);
var inst_14243 = inst_14262;
var inst_14244 = inst_14261;
var inst_14245 = inst_14263;
var inst_14246 = (0);
var state_14291__$1 = (function (){var statearr_14310 = state_14291;
(statearr_14310[(9)] = inst_14244);

(statearr_14310[(10)] = inst_14245);

(statearr_14310[(11)] = inst_14246);

(statearr_14310[(12)] = inst_14243);

return statearr_14310;
})();
var statearr_14311_14344 = state_14291__$1;
(statearr_14311_14344[(2)] = null);

(statearr_14311_14344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (3))){
var inst_14289 = (state_14291[(2)]);
var state_14291__$1 = state_14291;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14291__$1,inst_14289);
} else {
if((state_val_14292 === (12))){
var inst_14277 = (state_14291[(2)]);
var state_14291__$1 = state_14291;
var statearr_14312_14345 = state_14291__$1;
(statearr_14312_14345[(2)] = inst_14277);

(statearr_14312_14345[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (2))){
var state_14291__$1 = state_14291;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14291__$1,(4),in$);
} else {
if((state_val_14292 === (23))){
var inst_14285 = (state_14291[(2)]);
var state_14291__$1 = state_14291;
var statearr_14313_14346 = state_14291__$1;
(statearr_14313_14346[(2)] = inst_14285);

(statearr_14313_14346[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (19))){
var inst_14272 = (state_14291[(2)]);
var state_14291__$1 = state_14291;
var statearr_14314_14347 = state_14291__$1;
(statearr_14314_14347[(2)] = inst_14272);

(statearr_14314_14347[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (11))){
var inst_14257 = (state_14291[(7)]);
var inst_14243 = (state_14291[(12)]);
var inst_14257__$1 = cljs.core.seq.call(null,inst_14243);
var state_14291__$1 = (function (){var statearr_14315 = state_14291;
(statearr_14315[(7)] = inst_14257__$1);

return statearr_14315;
})();
if(inst_14257__$1){
var statearr_14316_14348 = state_14291__$1;
(statearr_14316_14348[(1)] = (14));

} else {
var statearr_14317_14349 = state_14291__$1;
(statearr_14317_14349[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (9))){
var inst_14279 = (state_14291[(2)]);
var inst_14280 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_14291__$1 = (function (){var statearr_14318 = state_14291;
(statearr_14318[(15)] = inst_14279);

return statearr_14318;
})();
if(cljs.core.truth_(inst_14280)){
var statearr_14319_14350 = state_14291__$1;
(statearr_14319_14350[(1)] = (21));

} else {
var statearr_14320_14351 = state_14291__$1;
(statearr_14320_14351[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (5))){
var inst_14235 = cljs.core.async.close_BANG_.call(null,out);
var state_14291__$1 = state_14291;
var statearr_14321_14352 = state_14291__$1;
(statearr_14321_14352[(2)] = inst_14235);

(statearr_14321_14352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (14))){
var inst_14257 = (state_14291[(7)]);
var inst_14259 = cljs.core.chunked_seq_QMARK_.call(null,inst_14257);
var state_14291__$1 = state_14291;
if(inst_14259){
var statearr_14322_14353 = state_14291__$1;
(statearr_14322_14353[(1)] = (17));

} else {
var statearr_14323_14354 = state_14291__$1;
(statearr_14323_14354[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (16))){
var inst_14275 = (state_14291[(2)]);
var state_14291__$1 = state_14291;
var statearr_14324_14355 = state_14291__$1;
(statearr_14324_14355[(2)] = inst_14275);

(statearr_14324_14355[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14292 === (10))){
var inst_14244 = (state_14291[(9)]);
var inst_14246 = (state_14291[(11)]);
var inst_14251 = cljs.core._nth.call(null,inst_14244,inst_14246);
var state_14291__$1 = state_14291;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14291__$1,(13),out,inst_14251);
} else {
if((state_val_14292 === (18))){
var inst_14257 = (state_14291[(7)]);
var inst_14266 = cljs.core.first.call(null,inst_14257);
var state_14291__$1 = state_14291;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14291__$1,(20),out,inst_14266);
} else {
if((state_val_14292 === (8))){
var inst_14245 = (state_14291[(10)]);
var inst_14246 = (state_14291[(11)]);
var inst_14248 = (inst_14246 < inst_14245);
var inst_14249 = inst_14248;
var state_14291__$1 = state_14291;
if(cljs.core.truth_(inst_14249)){
var statearr_14325_14356 = state_14291__$1;
(statearr_14325_14356[(1)] = (10));

} else {
var statearr_14326_14357 = state_14291__$1;
(statearr_14326_14357[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto__))
;
return ((function (switch__11791__auto__,c__11856__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11792__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11792__auto____0 = (function (){
var statearr_14330 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14330[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11792__auto__);

(statearr_14330[(1)] = (1));

return statearr_14330;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11792__auto____1 = (function (state_14291){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_14291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e14331){if((e14331 instanceof Object)){
var ex__11795__auto__ = e14331;
var statearr_14332_14358 = state_14291;
(statearr_14332_14358[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14291);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14331;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14359 = state_14291;
state_14291 = G__14359;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11792__auto__ = function(state_14291){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11792__auto____1.call(this,state_14291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11792__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11792__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__))
})();
var state__11858__auto__ = (function (){var statearr_14333 = f__11857__auto__.call(null);
(statearr_14333[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_14333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto__))
);

return c__11856__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args14360 = [];
var len__7280__auto___14363 = arguments.length;
var i__7281__auto___14364 = (0);
while(true){
if((i__7281__auto___14364 < len__7280__auto___14363)){
args14360.push((arguments[i__7281__auto___14364]));

var G__14365 = (i__7281__auto___14364 + (1));
i__7281__auto___14364 = G__14365;
continue;
} else {
}
break;
}

var G__14362 = args14360.length;
switch (G__14362) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14360.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args14367 = [];
var len__7280__auto___14370 = arguments.length;
var i__7281__auto___14371 = (0);
while(true){
if((i__7281__auto___14371 < len__7280__auto___14370)){
args14367.push((arguments[i__7281__auto___14371]));

var G__14372 = (i__7281__auto___14371 + (1));
i__7281__auto___14371 = G__14372;
continue;
} else {
}
break;
}

var G__14369 = args14367.length;
switch (G__14369) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14367.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args14374 = [];
var len__7280__auto___14425 = arguments.length;
var i__7281__auto___14426 = (0);
while(true){
if((i__7281__auto___14426 < len__7280__auto___14425)){
args14374.push((arguments[i__7281__auto___14426]));

var G__14427 = (i__7281__auto___14426 + (1));
i__7281__auto___14426 = G__14427;
continue;
} else {
}
break;
}

var G__14376 = args14374.length;
switch (G__14376) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14374.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11856__auto___14429 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___14429,out){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___14429,out){
return (function (state_14400){
var state_val_14401 = (state_14400[(1)]);
if((state_val_14401 === (7))){
var inst_14395 = (state_14400[(2)]);
var state_14400__$1 = state_14400;
var statearr_14402_14430 = state_14400__$1;
(statearr_14402_14430[(2)] = inst_14395);

(statearr_14402_14430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14401 === (1))){
var inst_14377 = null;
var state_14400__$1 = (function (){var statearr_14403 = state_14400;
(statearr_14403[(7)] = inst_14377);

return statearr_14403;
})();
var statearr_14404_14431 = state_14400__$1;
(statearr_14404_14431[(2)] = null);

(statearr_14404_14431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14401 === (4))){
var inst_14380 = (state_14400[(8)]);
var inst_14380__$1 = (state_14400[(2)]);
var inst_14381 = (inst_14380__$1 == null);
var inst_14382 = cljs.core.not.call(null,inst_14381);
var state_14400__$1 = (function (){var statearr_14405 = state_14400;
(statearr_14405[(8)] = inst_14380__$1);

return statearr_14405;
})();
if(inst_14382){
var statearr_14406_14432 = state_14400__$1;
(statearr_14406_14432[(1)] = (5));

} else {
var statearr_14407_14433 = state_14400__$1;
(statearr_14407_14433[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14401 === (6))){
var state_14400__$1 = state_14400;
var statearr_14408_14434 = state_14400__$1;
(statearr_14408_14434[(2)] = null);

(statearr_14408_14434[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14401 === (3))){
var inst_14397 = (state_14400[(2)]);
var inst_14398 = cljs.core.async.close_BANG_.call(null,out);
var state_14400__$1 = (function (){var statearr_14409 = state_14400;
(statearr_14409[(9)] = inst_14397);

return statearr_14409;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14400__$1,inst_14398);
} else {
if((state_val_14401 === (2))){
var state_14400__$1 = state_14400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14400__$1,(4),ch);
} else {
if((state_val_14401 === (11))){
var inst_14380 = (state_14400[(8)]);
var inst_14389 = (state_14400[(2)]);
var inst_14377 = inst_14380;
var state_14400__$1 = (function (){var statearr_14410 = state_14400;
(statearr_14410[(7)] = inst_14377);

(statearr_14410[(10)] = inst_14389);

return statearr_14410;
})();
var statearr_14411_14435 = state_14400__$1;
(statearr_14411_14435[(2)] = null);

(statearr_14411_14435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14401 === (9))){
var inst_14380 = (state_14400[(8)]);
var state_14400__$1 = state_14400;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14400__$1,(11),out,inst_14380);
} else {
if((state_val_14401 === (5))){
var inst_14377 = (state_14400[(7)]);
var inst_14380 = (state_14400[(8)]);
var inst_14384 = cljs.core._EQ_.call(null,inst_14380,inst_14377);
var state_14400__$1 = state_14400;
if(inst_14384){
var statearr_14413_14436 = state_14400__$1;
(statearr_14413_14436[(1)] = (8));

} else {
var statearr_14414_14437 = state_14400__$1;
(statearr_14414_14437[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14401 === (10))){
var inst_14392 = (state_14400[(2)]);
var state_14400__$1 = state_14400;
var statearr_14415_14438 = state_14400__$1;
(statearr_14415_14438[(2)] = inst_14392);

(statearr_14415_14438[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14401 === (8))){
var inst_14377 = (state_14400[(7)]);
var tmp14412 = inst_14377;
var inst_14377__$1 = tmp14412;
var state_14400__$1 = (function (){var statearr_14416 = state_14400;
(statearr_14416[(7)] = inst_14377__$1);

return statearr_14416;
})();
var statearr_14417_14439 = state_14400__$1;
(statearr_14417_14439[(2)] = null);

(statearr_14417_14439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___14429,out))
;
return ((function (switch__11791__auto__,c__11856__auto___14429,out){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_14421 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14421[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_14421[(1)] = (1));

return statearr_14421;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_14400){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_14400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e14422){if((e14422 instanceof Object)){
var ex__11795__auto__ = e14422;
var statearr_14423_14440 = state_14400;
(statearr_14423_14440[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14400);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14422;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14441 = state_14400;
state_14400 = G__14441;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_14400){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_14400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___14429,out))
})();
var state__11858__auto__ = (function (){var statearr_14424 = f__11857__auto__.call(null);
(statearr_14424[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___14429);

return statearr_14424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___14429,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args14442 = [];
var len__7280__auto___14512 = arguments.length;
var i__7281__auto___14513 = (0);
while(true){
if((i__7281__auto___14513 < len__7280__auto___14512)){
args14442.push((arguments[i__7281__auto___14513]));

var G__14514 = (i__7281__auto___14513 + (1));
i__7281__auto___14513 = G__14514;
continue;
} else {
}
break;
}

var G__14444 = args14442.length;
switch (G__14444) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14442.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11856__auto___14516 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___14516,out){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___14516,out){
return (function (state_14482){
var state_val_14483 = (state_14482[(1)]);
if((state_val_14483 === (7))){
var inst_14478 = (state_14482[(2)]);
var state_14482__$1 = state_14482;
var statearr_14484_14517 = state_14482__$1;
(statearr_14484_14517[(2)] = inst_14478);

(statearr_14484_14517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14483 === (1))){
var inst_14445 = (new Array(n));
var inst_14446 = inst_14445;
var inst_14447 = (0);
var state_14482__$1 = (function (){var statearr_14485 = state_14482;
(statearr_14485[(7)] = inst_14446);

(statearr_14485[(8)] = inst_14447);

return statearr_14485;
})();
var statearr_14486_14518 = state_14482__$1;
(statearr_14486_14518[(2)] = null);

(statearr_14486_14518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14483 === (4))){
var inst_14450 = (state_14482[(9)]);
var inst_14450__$1 = (state_14482[(2)]);
var inst_14451 = (inst_14450__$1 == null);
var inst_14452 = cljs.core.not.call(null,inst_14451);
var state_14482__$1 = (function (){var statearr_14487 = state_14482;
(statearr_14487[(9)] = inst_14450__$1);

return statearr_14487;
})();
if(inst_14452){
var statearr_14488_14519 = state_14482__$1;
(statearr_14488_14519[(1)] = (5));

} else {
var statearr_14489_14520 = state_14482__$1;
(statearr_14489_14520[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14483 === (15))){
var inst_14472 = (state_14482[(2)]);
var state_14482__$1 = state_14482;
var statearr_14490_14521 = state_14482__$1;
(statearr_14490_14521[(2)] = inst_14472);

(statearr_14490_14521[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14483 === (13))){
var state_14482__$1 = state_14482;
var statearr_14491_14522 = state_14482__$1;
(statearr_14491_14522[(2)] = null);

(statearr_14491_14522[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14483 === (6))){
var inst_14447 = (state_14482[(8)]);
var inst_14468 = (inst_14447 > (0));
var state_14482__$1 = state_14482;
if(cljs.core.truth_(inst_14468)){
var statearr_14492_14523 = state_14482__$1;
(statearr_14492_14523[(1)] = (12));

} else {
var statearr_14493_14524 = state_14482__$1;
(statearr_14493_14524[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14483 === (3))){
var inst_14480 = (state_14482[(2)]);
var state_14482__$1 = state_14482;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14482__$1,inst_14480);
} else {
if((state_val_14483 === (12))){
var inst_14446 = (state_14482[(7)]);
var inst_14470 = cljs.core.vec.call(null,inst_14446);
var state_14482__$1 = state_14482;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14482__$1,(15),out,inst_14470);
} else {
if((state_val_14483 === (2))){
var state_14482__$1 = state_14482;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14482__$1,(4),ch);
} else {
if((state_val_14483 === (11))){
var inst_14462 = (state_14482[(2)]);
var inst_14463 = (new Array(n));
var inst_14446 = inst_14463;
var inst_14447 = (0);
var state_14482__$1 = (function (){var statearr_14494 = state_14482;
(statearr_14494[(7)] = inst_14446);

(statearr_14494[(10)] = inst_14462);

(statearr_14494[(8)] = inst_14447);

return statearr_14494;
})();
var statearr_14495_14525 = state_14482__$1;
(statearr_14495_14525[(2)] = null);

(statearr_14495_14525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14483 === (9))){
var inst_14446 = (state_14482[(7)]);
var inst_14460 = cljs.core.vec.call(null,inst_14446);
var state_14482__$1 = state_14482;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14482__$1,(11),out,inst_14460);
} else {
if((state_val_14483 === (5))){
var inst_14450 = (state_14482[(9)]);
var inst_14446 = (state_14482[(7)]);
var inst_14455 = (state_14482[(11)]);
var inst_14447 = (state_14482[(8)]);
var inst_14454 = (inst_14446[inst_14447] = inst_14450);
var inst_14455__$1 = (inst_14447 + (1));
var inst_14456 = (inst_14455__$1 < n);
var state_14482__$1 = (function (){var statearr_14496 = state_14482;
(statearr_14496[(11)] = inst_14455__$1);

(statearr_14496[(12)] = inst_14454);

return statearr_14496;
})();
if(cljs.core.truth_(inst_14456)){
var statearr_14497_14526 = state_14482__$1;
(statearr_14497_14526[(1)] = (8));

} else {
var statearr_14498_14527 = state_14482__$1;
(statearr_14498_14527[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14483 === (14))){
var inst_14475 = (state_14482[(2)]);
var inst_14476 = cljs.core.async.close_BANG_.call(null,out);
var state_14482__$1 = (function (){var statearr_14500 = state_14482;
(statearr_14500[(13)] = inst_14475);

return statearr_14500;
})();
var statearr_14501_14528 = state_14482__$1;
(statearr_14501_14528[(2)] = inst_14476);

(statearr_14501_14528[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14483 === (10))){
var inst_14466 = (state_14482[(2)]);
var state_14482__$1 = state_14482;
var statearr_14502_14529 = state_14482__$1;
(statearr_14502_14529[(2)] = inst_14466);

(statearr_14502_14529[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14483 === (8))){
var inst_14446 = (state_14482[(7)]);
var inst_14455 = (state_14482[(11)]);
var tmp14499 = inst_14446;
var inst_14446__$1 = tmp14499;
var inst_14447 = inst_14455;
var state_14482__$1 = (function (){var statearr_14503 = state_14482;
(statearr_14503[(7)] = inst_14446__$1);

(statearr_14503[(8)] = inst_14447);

return statearr_14503;
})();
var statearr_14504_14530 = state_14482__$1;
(statearr_14504_14530[(2)] = null);

(statearr_14504_14530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___14516,out))
;
return ((function (switch__11791__auto__,c__11856__auto___14516,out){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_14508 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14508[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_14508[(1)] = (1));

return statearr_14508;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_14482){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_14482);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e14509){if((e14509 instanceof Object)){
var ex__11795__auto__ = e14509;
var statearr_14510_14531 = state_14482;
(statearr_14510_14531[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14482);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14509;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14532 = state_14482;
state_14482 = G__14532;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_14482){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_14482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___14516,out))
})();
var state__11858__auto__ = (function (){var statearr_14511 = f__11857__auto__.call(null);
(statearr_14511[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___14516);

return statearr_14511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___14516,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args14533 = [];
var len__7280__auto___14607 = arguments.length;
var i__7281__auto___14608 = (0);
while(true){
if((i__7281__auto___14608 < len__7280__auto___14607)){
args14533.push((arguments[i__7281__auto___14608]));

var G__14609 = (i__7281__auto___14608 + (1));
i__7281__auto___14608 = G__14609;
continue;
} else {
}
break;
}

var G__14535 = args14533.length;
switch (G__14535) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14533.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11856__auto___14611 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto___14611,out){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___14611,out){
return (function (state_14577){
var state_val_14578 = (state_14577[(1)]);
if((state_val_14578 === (7))){
var inst_14573 = (state_14577[(2)]);
var state_14577__$1 = state_14577;
var statearr_14579_14612 = state_14577__$1;
(statearr_14579_14612[(2)] = inst_14573);

(statearr_14579_14612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14578 === (1))){
var inst_14536 = [];
var inst_14537 = inst_14536;
var inst_14538 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_14577__$1 = (function (){var statearr_14580 = state_14577;
(statearr_14580[(7)] = inst_14537);

(statearr_14580[(8)] = inst_14538);

return statearr_14580;
})();
var statearr_14581_14613 = state_14577__$1;
(statearr_14581_14613[(2)] = null);

(statearr_14581_14613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14578 === (4))){
var inst_14541 = (state_14577[(9)]);
var inst_14541__$1 = (state_14577[(2)]);
var inst_14542 = (inst_14541__$1 == null);
var inst_14543 = cljs.core.not.call(null,inst_14542);
var state_14577__$1 = (function (){var statearr_14582 = state_14577;
(statearr_14582[(9)] = inst_14541__$1);

return statearr_14582;
})();
if(inst_14543){
var statearr_14583_14614 = state_14577__$1;
(statearr_14583_14614[(1)] = (5));

} else {
var statearr_14584_14615 = state_14577__$1;
(statearr_14584_14615[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14578 === (15))){
var inst_14567 = (state_14577[(2)]);
var state_14577__$1 = state_14577;
var statearr_14585_14616 = state_14577__$1;
(statearr_14585_14616[(2)] = inst_14567);

(statearr_14585_14616[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14578 === (13))){
var state_14577__$1 = state_14577;
var statearr_14586_14617 = state_14577__$1;
(statearr_14586_14617[(2)] = null);

(statearr_14586_14617[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14578 === (6))){
var inst_14537 = (state_14577[(7)]);
var inst_14562 = inst_14537.length;
var inst_14563 = (inst_14562 > (0));
var state_14577__$1 = state_14577;
if(cljs.core.truth_(inst_14563)){
var statearr_14587_14618 = state_14577__$1;
(statearr_14587_14618[(1)] = (12));

} else {
var statearr_14588_14619 = state_14577__$1;
(statearr_14588_14619[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14578 === (3))){
var inst_14575 = (state_14577[(2)]);
var state_14577__$1 = state_14577;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14577__$1,inst_14575);
} else {
if((state_val_14578 === (12))){
var inst_14537 = (state_14577[(7)]);
var inst_14565 = cljs.core.vec.call(null,inst_14537);
var state_14577__$1 = state_14577;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14577__$1,(15),out,inst_14565);
} else {
if((state_val_14578 === (2))){
var state_14577__$1 = state_14577;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14577__$1,(4),ch);
} else {
if((state_val_14578 === (11))){
var inst_14545 = (state_14577[(10)]);
var inst_14541 = (state_14577[(9)]);
var inst_14555 = (state_14577[(2)]);
var inst_14556 = [];
var inst_14557 = inst_14556.push(inst_14541);
var inst_14537 = inst_14556;
var inst_14538 = inst_14545;
var state_14577__$1 = (function (){var statearr_14589 = state_14577;
(statearr_14589[(11)] = inst_14557);

(statearr_14589[(7)] = inst_14537);

(statearr_14589[(12)] = inst_14555);

(statearr_14589[(8)] = inst_14538);

return statearr_14589;
})();
var statearr_14590_14620 = state_14577__$1;
(statearr_14590_14620[(2)] = null);

(statearr_14590_14620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14578 === (9))){
var inst_14537 = (state_14577[(7)]);
var inst_14553 = cljs.core.vec.call(null,inst_14537);
var state_14577__$1 = state_14577;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14577__$1,(11),out,inst_14553);
} else {
if((state_val_14578 === (5))){
var inst_14545 = (state_14577[(10)]);
var inst_14541 = (state_14577[(9)]);
var inst_14538 = (state_14577[(8)]);
var inst_14545__$1 = f.call(null,inst_14541);
var inst_14546 = cljs.core._EQ_.call(null,inst_14545__$1,inst_14538);
var inst_14547 = cljs.core.keyword_identical_QMARK_.call(null,inst_14538,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_14548 = (inst_14546) || (inst_14547);
var state_14577__$1 = (function (){var statearr_14591 = state_14577;
(statearr_14591[(10)] = inst_14545__$1);

return statearr_14591;
})();
if(cljs.core.truth_(inst_14548)){
var statearr_14592_14621 = state_14577__$1;
(statearr_14592_14621[(1)] = (8));

} else {
var statearr_14593_14622 = state_14577__$1;
(statearr_14593_14622[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14578 === (14))){
var inst_14570 = (state_14577[(2)]);
var inst_14571 = cljs.core.async.close_BANG_.call(null,out);
var state_14577__$1 = (function (){var statearr_14595 = state_14577;
(statearr_14595[(13)] = inst_14570);

return statearr_14595;
})();
var statearr_14596_14623 = state_14577__$1;
(statearr_14596_14623[(2)] = inst_14571);

(statearr_14596_14623[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14578 === (10))){
var inst_14560 = (state_14577[(2)]);
var state_14577__$1 = state_14577;
var statearr_14597_14624 = state_14577__$1;
(statearr_14597_14624[(2)] = inst_14560);

(statearr_14597_14624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14578 === (8))){
var inst_14545 = (state_14577[(10)]);
var inst_14537 = (state_14577[(7)]);
var inst_14541 = (state_14577[(9)]);
var inst_14550 = inst_14537.push(inst_14541);
var tmp14594 = inst_14537;
var inst_14537__$1 = tmp14594;
var inst_14538 = inst_14545;
var state_14577__$1 = (function (){var statearr_14598 = state_14577;
(statearr_14598[(7)] = inst_14537__$1);

(statearr_14598[(14)] = inst_14550);

(statearr_14598[(8)] = inst_14538);

return statearr_14598;
})();
var statearr_14599_14625 = state_14577__$1;
(statearr_14599_14625[(2)] = null);

(statearr_14599_14625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___14611,out))
;
return ((function (switch__11791__auto__,c__11856__auto___14611,out){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_14603 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14603[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_14603[(1)] = (1));

return statearr_14603;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_14577){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_14577);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e14604){if((e14604 instanceof Object)){
var ex__11795__auto__ = e14604;
var statearr_14605_14626 = state_14577;
(statearr_14605_14626[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14577);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14604;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14627 = state_14577;
state_14577 = G__14627;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_14577){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_14577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___14611,out))
})();
var state__11858__auto__ = (function (){var statearr_14606 = f__11857__auto__.call(null);
(statearr_14606[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___14611);

return statearr_14606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto___14611,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
