// Compiled by ClojureScript 1.8.51 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.urls');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._id,new cljs.core.Keyword(null,"label","label",1718410804),"id",new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._id,new cljs.core.Keyword(null,"type","type",1174270348),"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.call(null,extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21582 = arguments.length;
var i__7281__auto___21583 = (0);
while(true){
if((i__7281__auto___21583 < len__7280__auto___21582)){
args__7287__auto__.push((arguments[i__7281__auto___21583]));

var G__21584 = (i__7281__auto___21583 + (1));
i__7281__auto___21583 = G__21584;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__21579){
var map__21580 = p__21579;
var map__21580__$1 = ((((!((map__21580 == null)))?((((map__21580.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21580.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21580):map__21580);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__21580__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,hatti.views.table.get_extra_fields.call(null,is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),cljs.core.not.call(null,is_filtered_dataview_QMARK_)))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq21577){
var G__21578 = cljs.core.first.call(null,seq21577);
var seq21577__$1 = cljs.core.next.call(null,seq21577);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__21578,seq21577__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__21585_SHARP_){
if(typeof p1__21585_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__21585_SHARP_);
} else {
return p1__21585_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__21589){
var vec__21590 = p__21589;
var fname = cljs.core.nth.call(null,vec__21590,(0),null);
var answer = cljs.core.nth.call(null,vec__21590,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__21586_SHARP_){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),[cljs.core.str(p1__21586_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,clj_value,language,true);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__21591 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__21591__$1 = ((((!((map__21591 == null)))?((((map__21591.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21591.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21591):map__21591);
var owner__$1 = cljs.core.get.call(null,map__21591__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__21591__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__21591__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = chimera.urls.last_url_param.call(null,owner__$1);
var project_id = chimera.urls.last_url_param.call(null,project);
var edit_link = chimera.urls.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info.right","span.tip-info.right",-1208244295),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-clone","i.fa.fa-clone",1946695810),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info.right","span.tip-info.right",-1208244295),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil-square-o","i.fa.fa-pencil-square-o",1550650091)], null)], null)], null)], null):null));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(70),"",hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args21594 = [];
var len__7280__auto___21624 = arguments.length;
var i__7281__auto___21625 = (0);
while(true){
if((i__7281__auto___21625 < len__7280__auto___21624)){
args21594.push((arguments[i__7281__auto___21625]));

var G__21626 = (i__7281__auto___21625 + (1));
i__7281__auto___21625 = G__21626;
continue;
} else {
}
break;
}

var G__21600 = args21594.length;
switch (G__21600) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7299__auto__ = (new cljs.core.IndexedSeq(args21594.slice((3)),(0),null));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7299__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__21601){
var map__21602 = p__21601;
var map__21602__$1 = ((((!((map__21602 == null)))?((((map__21602.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21602.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21602):map__21602);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__21602__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var owner = cljs.core.get.call(null,map__21602__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var has_hxl_QMARK_ = chimera.core.any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,((function (map__21602,map__21602__$1,is_filtered_dataview_QMARK_,owner){
return (function (p1__21593_SHARP_){
return (new cljs.core.Keyword(null,"hxl","hxl",-849576989).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"instance","instance",-2121349050).cljs$core$IFn$_invoke$arity$1(p1__21593_SHARP_)) == null);
});})(map__21602,map__21602__$1,is_filtered_dataview_QMARK_,owner))
,form));
var columns = (function (){var iter__6990__auto__ = ((function (has_hxl_QMARK_,map__21602,map__21602__$1,is_filtered_dataview_QMARK_,owner){
return (function hatti$views$table$iter__21604(s__21605){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__21602,map__21602__$1,is_filtered_dataview_QMARK_,owner){
return (function (){
var s__21605__$1 = s__21605;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21605__$1);
if(temp__4657__auto__){
var s__21605__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21605__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__21605__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__21607 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__21606 = (0);
while(true){
if((i__21606 < size__6989__auto__)){
var field = cljs.core._nth.call(null,c__6988__auto__,i__21606);
cljs.core.chunk_append.call(null,b__21607,(function (){var map__21616 = field;
var map__21616__$1 = ((((!((map__21616 == null)))?((((map__21616.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21616.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21616):map__21616);
var map__21617 = cljs.core.get.call(null,map__21616__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__21617__$1 = ((((!((map__21617 == null)))?((((map__21617.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21617.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21617):map__21617);
var hxl = cljs.core.get.call(null,map__21617__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__21616__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__21616__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__21616__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})());

var G__21628 = (i__21606 + (1));
i__21606 = G__21628;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21607),hatti$views$table$iter__21604.call(null,cljs.core.chunk_rest.call(null,s__21605__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21607),null);
}
} else {
var field = cljs.core.first.call(null,s__21605__$2);
return cljs.core.cons.call(null,(function (){var map__21620 = field;
var map__21620__$1 = ((((!((map__21620 == null)))?((((map__21620.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21620.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21620):map__21620);
var map__21621 = cljs.core.get.call(null,map__21620__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__21621__$1 = ((((!((map__21621 == null)))?((((map__21621.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21621.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21621):map__21621);
var hxl = cljs.core.get.call(null,map__21621__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__21620__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__21620__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__21620__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__21604.call(null,cljs.core.rest.call(null,s__21605__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__21602,map__21602__$1,is_filtered_dataview_QMARK_,owner))
,null,null));
});})(has_hxl_QMARK_,map__21602,map__21602__$1,is_filtered_dataview_QMARK_,owner))
;
return iter__6990__auto__.call(null,hatti.views.table.all_fields.call(null,form,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_));
})();
return cljs.core.clj__GT_js.call(null,cljs.core.conj.call(null,columns,hatti.views.table.actions_column.call(null,owner,has_hxl_QMARK_)));
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq21595){
var G__21596 = cljs.core.first.call(null,seq21595);
var seq21595__$1 = cljs.core.next.call(null,seq21595);
var G__21597 = cljs.core.first.call(null,seq21595__$1);
var seq21595__$2 = cljs.core.next.call(null,seq21595__$1);
var G__21598 = cljs.core.first.call(null,seq21595__$2);
var seq21595__$3 = cljs.core.next.call(null,seq21595__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__21596,G__21597,G__21598,seq21595__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false};
/**
 * Fixes the first column on slick table on horizontal scroll
 */
hatti.views.table.freeze_action_column_BANG_ = (function hatti$views$table$freeze_action_column_BANG_(){
var actions = document.getElementsByClassName("record-actions");
var sg_viewport = cljs.core.first.call(null,document.getElementsByClassName("slick-viewport"));
var seq__21634 = cljs.core.seq.call(null,actions);
var chunk__21635 = null;
var count__21636 = (0);
var i__21637 = (0);
while(true){
if((i__21637 < count__21636)){
var action = cljs.core._nth.call(null,chunk__21635,i__21637);
var leftOffset_21638 = parseInt(action.offsetLeft);
sg_viewport.addEventListener("scroll",((function (seq__21634,chunk__21635,count__21636,i__21637,leftOffset_21638,action,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__21634,chunk__21635,count__21636,i__21637,sl,leftOffset_21638,action,actions,sg_viewport){
return (function (p1__21629_SHARP_){
return action.style.borderRight = p1__21629_SHARP_;
});})(seq__21634,chunk__21635,count__21636,i__21637,sl,leftOffset_21638,action,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_.call(null,"1px dotted #ededed");
} else {
set_border_BANG_.call(null,"1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_21638)),cljs.core.str("px")].join('');
});})(seq__21634,chunk__21635,count__21636,i__21637,leftOffset_21638,action,actions,sg_viewport))
);

var G__21639 = seq__21634;
var G__21640 = chunk__21635;
var G__21641 = count__21636;
var G__21642 = (i__21637 + (1));
seq__21634 = G__21639;
chunk__21635 = G__21640;
count__21636 = G__21641;
i__21637 = G__21642;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__21634);
if(temp__4657__auto__){
var seq__21634__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21634__$1)){
var c__7021__auto__ = cljs.core.chunk_first.call(null,seq__21634__$1);
var G__21643 = cljs.core.chunk_rest.call(null,seq__21634__$1);
var G__21644 = c__7021__auto__;
var G__21645 = cljs.core.count.call(null,c__7021__auto__);
var G__21646 = (0);
seq__21634 = G__21643;
chunk__21635 = G__21644;
count__21636 = G__21645;
i__21637 = G__21646;
continue;
} else {
var action = cljs.core.first.call(null,seq__21634__$1);
var leftOffset_21647 = parseInt(action.offsetLeft);
sg_viewport.addEventListener("scroll",((function (seq__21634,chunk__21635,count__21636,i__21637,leftOffset_21647,action,seq__21634__$1,temp__4657__auto__,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__21634,chunk__21635,count__21636,i__21637,sl,leftOffset_21647,action,seq__21634__$1,temp__4657__auto__,actions,sg_viewport){
return (function (p1__21629_SHARP_){
return action.style.borderRight = p1__21629_SHARP_;
});})(seq__21634,chunk__21635,count__21636,i__21637,sl,leftOffset_21647,action,seq__21634__$1,temp__4657__auto__,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_.call(null,"1px dotted #ededed");
} else {
set_border_BANG_.call(null,"1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_21647)),cljs.core.str("px")].join('');
});})(seq__21634,chunk__21635,count__21636,i__21637,leftOffset_21647,action,seq__21634__$1,temp__4657__auto__,actions,sg_viewport))
);

var G__21648 = cljs.core.next.call(null,seq__21634__$1);
var G__21649 = null;
var G__21650 = (0);
var G__21651 = (0);
seq__21634 = G__21648;
chunk__21635 = G__21649;
count__21636 = G__21650;
i__21637 = G__21651;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__6990__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__21660(s__21661){
return (new cljs.core.LazySeq(null,(function (){
var s__21661__$1 = s__21661;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21661__$1);
if(temp__4657__auto__){
var s__21661__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21661__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__21661__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__21663 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__21662 = (0);
while(true){
if((i__21662 < size__6989__auto__)){
var vec__21666 = cljs.core._nth.call(null,c__6988__auto__,i__21662);
var handler_key = cljs.core.nth.call(null,vec__21666,(0),null);
var handler_function = cljs.core.nth.call(null,vec__21666,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__21663,event.subscribe(handler_function));

var G__21668 = (i__21662 + (1));
i__21662 = G__21668;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21663),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__21660.call(null,cljs.core.chunk_rest.call(null,s__21661__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21663),null);
}
} else {
var vec__21667 = cljs.core.first.call(null,s__21661__$2);
var handler_key = cljs.core.nth.call(null,vec__21667,(0),null);
var handler_function = cljs.core.nth.call(null,vec__21667,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__21660.call(null,cljs.core.rest.call(null,s__21661__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__6990__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__21677(s__21678){
return (new cljs.core.LazySeq(null,(function (){
var s__21678__$1 = s__21678;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21678__$1);
if(temp__4657__auto__){
var s__21678__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21678__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__21678__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__21680 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__21679 = (0);
while(true){
if((i__21679 < size__6989__auto__)){
var vec__21683 = cljs.core._nth.call(null,c__6988__auto__,i__21679);
var handler_key = cljs.core.nth.call(null,vec__21683,(0),null);
var handler_function = cljs.core.nth.call(null,vec__21683,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__21680,event.subscribe(handler_function));

var G__21685 = (i__21679 + (1));
i__21679 = G__21685;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21680),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__21677.call(null,cljs.core.chunk_rest.call(null,s__21678__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21680),null);
}
} else {
var vec__21684 = cljs.core.first.call(null,s__21678__$2);
var handler_key = cljs.core.nth.call(null,vec__21684,(0),null);
var handler_function = cljs.core.nth.call(null,vec__21684,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__21677.call(null,cljs.core.rest.call(null,s__21678__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__.call(null,event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__21686){
var map__21695 = p__21686;
var map__21695__$1 = ((((!((map__21695 == null)))?((((map__21695.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21695.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21695):map__21695);
var grid_event_handlers = cljs.core.get.call(null,map__21695__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__21695__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,true,current_language,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__21697 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__21697__$1 = ((((!((map__21697 == null)))?((((map__21697.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21697.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21697):map__21697);
var map__21698 = cljs.core.get.call(null,map__21697__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__21698__$1 = ((((!((map__21698 == null)))?((((map__21698.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21698.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21698):map__21698);
var map__21699 = cljs.core.get.call(null,map__21698__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__21699__$1 = ((((!((map__21699 == null)))?((((map__21699.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21699.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21699):map__21699);
var num_displayed_records = cljs.core.get.call(null,map__21699__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__21699__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__21697,map__21697__$1,map__21698,map__21698__$1,map__21699,map__21699__$1,num_displayed_records,total_page_count,map__21695,map__21695__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__21697,map__21697__$1,map__21698,map__21698__$1,map__21699,map__21699__$1,num_displayed_records,total_page_count,map__21695,map__21695__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__21697,map__21697__$1,map__21698,map__21698__$1,map__21699,map__21699__$1,num_displayed_records,total_page_count,map__21695,map__21695__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__21697,map__21697__$1,map__21698,map__21698__$1,map__21699,map__21699__$1,num_displayed_records,total_page_count,map__21695,map__21695__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__21697,map__21697__$1,map__21698,map__21698__$1,map__21699,map__21699__$1,num_displayed_records,total_page_count,map__21695,map__21695__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__21697,map__21697__$1,map__21698,map__21698__$1,map__21699,map__21699__$1,num_displayed_records,total_page_count,map__21695,map__21695__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__21697,map__21697__$1,map__21698,map__21698__$1,map__21699,map__21699__$1,num_displayed_records,total_page_count,map__21695,map__21695__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
});})(columns,SlickGrid,DataView,dataview,grid,map__21697,map__21697__$1,map__21698,map__21698__$1,map__21699,map__21699__$1,num_displayed_records,total_page_count,map__21695,map__21695__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__6210__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__11856__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto__,event_chan){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__,event_chan){
return (function (state_21964){
var state_val_21965 = (state_21964[(1)]);
if((state_val_21965 === (7))){
var inst_21873 = (state_21964[(7)]);
var inst_21873__$1 = (state_21964[(2)]);
var inst_21875 = (inst_21873__$1 == null);
var inst_21876 = cljs.core.not.call(null,inst_21875);
var state_21964__$1 = (function (){var statearr_21966 = state_21964;
(statearr_21966[(7)] = inst_21873__$1);

return statearr_21966;
})();
if(inst_21876){
var statearr_21967_22034 = state_21964__$1;
(statearr_21967_22034[(1)] = (8));

} else {
var statearr_21968_22035 = state_21964__$1;
(statearr_21968_22035[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (20))){
var inst_21903 = (state_21964[(8)]);
var inst_21895 = (state_21964[(9)]);
var inst_21912 = inst_21903.call(null,inst_21895);
var state_21964__$1 = state_21964;
var statearr_21969_22036 = state_21964__$1;
(statearr_21969_22036[(2)] = inst_21912);

(statearr_21969_22036[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (27))){
var state_21964__$1 = state_21964;
var statearr_21970_22037 = state_21964__$1;
(statearr_21970_22037[(2)] = null);

(statearr_21970_22037[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (1))){
var state_21964__$1 = state_21964;
var statearr_21971_22038 = state_21964__$1;
(statearr_21971_22038[(2)] = null);

(statearr_21971_22038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (24))){
var state_21964__$1 = state_21964;
var statearr_21972_22039 = state_21964__$1;
(statearr_21972_22039[(2)] = null);

(statearr_21972_22039[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (4))){
var state_21964__$1 = state_21964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21964__$1,(7),event_chan);
} else {
if((state_val_21965 === (15))){
var inst_21873 = (state_21964[(7)]);
var state_21964__$1 = state_21964;
var statearr_21973_22040 = state_21964__$1;
(statearr_21973_22040[(2)] = inst_21873);

(statearr_21973_22040[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (21))){
var state_21964__$1 = state_21964;
var statearr_21974_22041 = state_21964__$1;
(statearr_21974_22041[(2)] = null);

(statearr_21974_22041[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (31))){
var inst_21899 = (state_21964[(10)]);
var inst_21937 = (state_21964[(2)]);
var inst_21938 = cljs.core._EQ_.call(null,inst_21899,new cljs.core.Keyword(null,"table","table",-564943036));
var state_21964__$1 = (function (){var statearr_21975 = state_21964;
(statearr_21975[(11)] = inst_21937);

return statearr_21975;
})();
if(inst_21938){
var statearr_21976_22042 = state_21964__$1;
(statearr_21976_22042[(1)] = (32));

} else {
var statearr_21977_22043 = state_21964__$1;
(statearr_21977_22043[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (32))){
var inst_21873 = (state_21964[(7)]);
var inst_21893 = (state_21964[(12)]);
var inst_21894 = (state_21964[(13)]);
var inst_21896 = (state_21964[(14)]);
var inst_21904 = (state_21964[(15)]);
var inst_21897 = (state_21964[(16)]);
var inst_21903 = (state_21964[(8)]);
var inst_21898 = (state_21964[(17)]);
var inst_21899 = (state_21964[(10)]);
var inst_21895 = (state_21964[(9)]);
var inst_21951 = cljs.core.async.chan.call(null,(1));
var inst_21952 = (function (){var new_columns = inst_21898;
var submission_clicked = inst_21895;
var submission_unclicked = inst_21896;
var map__21871 = inst_21893;
var get_submission_data = inst_21904;
var c__11856__auto____$1 = inst_21951;
var re_render = inst_21899;
var update_data_BANG_ = inst_21903;
var submission_to_rank = inst_21894;
var e = inst_21873;
var filter_by = inst_21897;
return ((function (new_columns,submission_clicked,submission_unclicked,map__21871,get_submission_data,c__11856__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_21873,inst_21893,inst_21894,inst_21896,inst_21904,inst_21897,inst_21903,inst_21898,inst_21899,inst_21895,inst_21951,state_val_21965,c__11856__auto__,event_chan){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,map__21871,get_submission_data,c__11856__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_21873,inst_21893,inst_21894,inst_21896,inst_21904,inst_21897,inst_21903,inst_21898,inst_21899,inst_21895,inst_21951,state_val_21965,c__11856__auto__,event_chan){
return (function (state_21949){
var state_val_21950 = (state_21949[(1)]);
if((state_val_21950 === (1))){
var inst_21940 = cljs.core.async.timeout.call(null,(20));
var state_21949__$1 = state_21949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21949__$1,(2),inst_21940);
} else {
if((state_val_21950 === (2))){
var inst_21942 = (state_21949[(2)]);
var inst_21943 = grid.resizeCanvas();
var inst_21944 = grid.invalidateAllRows();
var inst_21945 = hatti.views.table.resizeColumns.call(null,grid);
var inst_21946 = grid.render();
var inst_21947 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_21949__$1 = (function (){var statearr_21978 = state_21949;
(statearr_21978[(7)] = inst_21945);

(statearr_21978[(8)] = inst_21943);

(statearr_21978[(9)] = inst_21946);

(statearr_21978[(10)] = inst_21944);

(statearr_21978[(11)] = inst_21942);

return statearr_21978;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21949__$1,inst_21947);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,map__21871,get_submission_data,c__11856__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_21873,inst_21893,inst_21894,inst_21896,inst_21904,inst_21897,inst_21903,inst_21898,inst_21899,inst_21895,inst_21951,state_val_21965,c__11856__auto__,event_chan))
;
return ((function (switch__11791__auto__,new_columns,submission_clicked,submission_unclicked,map__21871,get_submission_data,c__11856__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_21873,inst_21893,inst_21894,inst_21896,inst_21904,inst_21897,inst_21903,inst_21898,inst_21899,inst_21895,inst_21951,state_val_21965,c__11856__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__11792__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__11792__auto____0 = (function (){
var statearr_21982 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21982[(0)] = hatti$views$table$handle_table_events_$_state_machine__11792__auto__);

(statearr_21982[(1)] = (1));

return statearr_21982;
});
var hatti$views$table$handle_table_events_$_state_machine__11792__auto____1 = (function (state_21949){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_21949);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e21983){if((e21983 instanceof Object)){
var ex__11795__auto__ = e21983;
var statearr_21984_22044 = state_21949;
(statearr_21984_22044[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21949);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21983;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22045 = state_21949;
state_21949 = G__22045;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__11792__auto__ = function(state_21949){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__11792__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__11792__auto____1.call(this,state_21949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__11792__auto____0;
hatti$views$table$handle_table_events_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__11792__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,new_columns,submission_clicked,submission_unclicked,map__21871,get_submission_data,c__11856__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_21873,inst_21893,inst_21894,inst_21896,inst_21904,inst_21897,inst_21903,inst_21898,inst_21899,inst_21895,inst_21951,state_val_21965,c__11856__auto__,event_chan))
})();
var state__11858__auto__ = (function (){var statearr_21985 = f__11857__auto__.call(null);
(statearr_21985[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto____$1);

return statearr_21985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,map__21871,get_submission_data,c__11856__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_21873,inst_21893,inst_21894,inst_21896,inst_21904,inst_21897,inst_21903,inst_21898,inst_21899,inst_21895,inst_21951,state_val_21965,c__11856__auto__,event_chan))
})();
var inst_21953 = cljs.core.async.impl.dispatch.run.call(null,inst_21952);
var state_21964__$1 = (function (){var statearr_21986 = state_21964;
(statearr_21986[(18)] = inst_21953);

return statearr_21986;
})();
var statearr_21987_22046 = state_21964__$1;
(statearr_21987_22046[(2)] = inst_21951);

(statearr_21987_22046[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (33))){
var state_21964__$1 = state_21964;
var statearr_21988_22047 = state_21964__$1;
(statearr_21988_22047[(2)] = null);

(statearr_21988_22047[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (13))){
var inst_21885 = (state_21964[(2)]);
var state_21964__$1 = state_21964;
var statearr_21989_22048 = state_21964__$1;
(statearr_21989_22048[(2)] = inst_21885);

(statearr_21989_22048[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (22))){
var inst_21896 = (state_21964[(14)]);
var inst_21915 = (state_21964[(2)]);
var state_21964__$1 = (function (){var statearr_21990 = state_21964;
(statearr_21990[(19)] = inst_21915);

return statearr_21990;
})();
if(cljs.core.truth_(inst_21896)){
var statearr_21991_22049 = state_21964__$1;
(statearr_21991_22049[(1)] = (23));

} else {
var statearr_21992_22050 = state_21964__$1;
(statearr_21992_22050[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (29))){
var inst_21897 = (state_21964[(16)]);
var inst_21929 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_21930 = [inst_21897];
var inst_21931 = cljs.core.PersistentHashMap.fromArrays(inst_21929,inst_21930);
var inst_21932 = cljs.core.clj__GT_js.call(null,inst_21931);
var inst_21933 = dataview.setFilterArgs(inst_21932);
var inst_21934 = dataview.refresh();
var state_21964__$1 = (function (){var statearr_21993 = state_21964;
(statearr_21993[(20)] = inst_21933);

return statearr_21993;
})();
var statearr_21994_22051 = state_21964__$1;
(statearr_21994_22051[(2)] = inst_21934);

(statearr_21994_22051[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (6))){
var inst_21960 = (state_21964[(2)]);
var state_21964__$1 = state_21964;
var statearr_21995_22052 = state_21964__$1;
(statearr_21995_22052[(2)] = inst_21960);

(statearr_21995_22052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (28))){
var inst_21897 = (state_21964[(16)]);
var inst_21927 = (state_21964[(2)]);
var state_21964__$1 = (function (){var statearr_21996 = state_21964;
(statearr_21996[(21)] = inst_21927);

return statearr_21996;
})();
if(cljs.core.truth_(inst_21897)){
var statearr_21997_22053 = state_21964__$1;
(statearr_21997_22053[(1)] = (29));

} else {
var statearr_21998_22054 = state_21964__$1;
(statearr_21998_22054[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (25))){
var inst_21898 = (state_21964[(17)]);
var inst_21920 = (state_21964[(2)]);
var state_21964__$1 = (function (){var statearr_21999 = state_21964;
(statearr_21999[(22)] = inst_21920);

return statearr_21999;
})();
if(cljs.core.truth_(inst_21898)){
var statearr_22000_22055 = state_21964__$1;
(statearr_22000_22055[(1)] = (26));

} else {
var statearr_22001_22056 = state_21964__$1;
(statearr_22001_22056[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (34))){
var inst_21956 = (state_21964[(2)]);
var state_21964__$1 = (function (){var statearr_22002 = state_21964;
(statearr_22002[(23)] = inst_21956);

return statearr_22002;
})();
var statearr_22003_22057 = state_21964__$1;
(statearr_22003_22057[(2)] = null);

(statearr_22003_22057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (17))){
var inst_21894 = (state_21964[(13)]);
var inst_21904 = (state_21964[(15)]);
var inst_21903 = (state_21964[(8)]);
var inst_21906 = inst_21904.call(null,hatti.constants._rank,inst_21894);
var inst_21907 = inst_21903.call(null,inst_21906);
var state_21964__$1 = state_21964;
var statearr_22004_22058 = state_21964__$1;
(statearr_22004_22058[(2)] = inst_21907);

(statearr_22004_22058[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (3))){
var inst_21962 = (state_21964[(2)]);
var state_21964__$1 = state_21964;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21964__$1,inst_21962);
} else {
if((state_val_21965 === (12))){
var state_21964__$1 = state_21964;
var statearr_22005_22059 = state_21964__$1;
(statearr_22005_22059[(2)] = false);

(statearr_22005_22059[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (2))){
var state_21964__$1 = state_21964;
var statearr_22006_22060 = state_21964__$1;
(statearr_22006_22060[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (23))){
var inst_21903 = (state_21964[(8)]);
var inst_21917 = inst_21903.call(null,null);
var state_21964__$1 = state_21964;
var statearr_22008_22061 = state_21964__$1;
(statearr_22008_22061[(2)] = inst_21917);

(statearr_22008_22061[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (19))){
var inst_21895 = (state_21964[(9)]);
var inst_21910 = (state_21964[(2)]);
var state_21964__$1 = (function (){var statearr_22009 = state_21964;
(statearr_22009[(24)] = inst_21910);

return statearr_22009;
})();
if(cljs.core.truth_(inst_21895)){
var statearr_22010_22062 = state_21964__$1;
(statearr_22010_22062[(1)] = (20));

} else {
var statearr_22011_22063 = state_21964__$1;
(statearr_22011_22063[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (11))){
var state_21964__$1 = state_21964;
var statearr_22012_22064 = state_21964__$1;
(statearr_22012_22064[(2)] = true);

(statearr_22012_22064[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (9))){
var state_21964__$1 = state_21964;
var statearr_22013_22065 = state_21964__$1;
(statearr_22013_22065[(2)] = false);

(statearr_22013_22065[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (5))){
var state_21964__$1 = state_21964;
var statearr_22014_22066 = state_21964__$1;
(statearr_22014_22066[(2)] = null);

(statearr_22014_22066[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (14))){
var inst_21873 = (state_21964[(7)]);
var inst_21890 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21873);
var state_21964__$1 = state_21964;
var statearr_22015_22067 = state_21964__$1;
(statearr_22015_22067[(2)] = inst_21890);

(statearr_22015_22067[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (26))){
var inst_21898 = (state_21964[(17)]);
var inst_21922 = grid.setColumns(inst_21898);
var inst_21923 = hatti.views.table.resizeColumns.call(null,grid);
var inst_21924 = grid.render();
var state_21964__$1 = (function (){var statearr_22016 = state_21964;
(statearr_22016[(25)] = inst_21923);

(statearr_22016[(26)] = inst_21922);

return statearr_22016;
})();
var statearr_22017_22068 = state_21964__$1;
(statearr_22017_22068[(2)] = inst_21924);

(statearr_22017_22068[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (16))){
var inst_21873 = (state_21964[(7)]);
var inst_21893 = (state_21964[(12)]);
var inst_21894 = (state_21964[(13)]);
var inst_21896 = (state_21964[(14)]);
var inst_21897 = (state_21964[(16)]);
var inst_21903 = (state_21964[(8)]);
var inst_21898 = (state_21964[(17)]);
var inst_21899 = (state_21964[(10)]);
var inst_21895 = (state_21964[(9)]);
var inst_21893__$1 = (state_21964[(2)]);
var inst_21894__$1 = cljs.core.get.call(null,inst_21893__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_21895__$1 = cljs.core.get.call(null,inst_21893__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_21896__$1 = cljs.core.get.call(null,inst_21893__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_21897__$1 = cljs.core.get.call(null,inst_21893__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_21898__$1 = cljs.core.get.call(null,inst_21893__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_21899__$1 = cljs.core.get.call(null,inst_21893__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_21900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21901 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_21902 = (new cljs.core.PersistentVector(null,3,(5),inst_21900,inst_21901,null));
var inst_21903__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_21902);
var inst_21904 = (function (){var e = inst_21873;
var map__21871 = inst_21893__$1;
var submission_to_rank = inst_21894__$1;
var submission_clicked = inst_21895__$1;
var submission_unclicked = inst_21896__$1;
var filter_by = inst_21897__$1;
var new_columns = inst_21898__$1;
var re_render = inst_21899__$1;
var update_data_BANG_ = inst_21903__$1;
return ((function (e,map__21871,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_21873,inst_21893,inst_21894,inst_21896,inst_21897,inst_21903,inst_21898,inst_21899,inst_21895,inst_21893__$1,inst_21894__$1,inst_21895__$1,inst_21896__$1,inst_21897__$1,inst_21898__$1,inst_21899__$1,inst_21900,inst_21901,inst_21902,inst_21903__$1,state_val_21965,c__11856__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (e,map__21871,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_21873,inst_21893,inst_21894,inst_21896,inst_21897,inst_21903,inst_21898,inst_21899,inst_21895,inst_21893__$1,inst_21894__$1,inst_21895__$1,inst_21896__$1,inst_21897__$1,inst_21898__$1,inst_21899__$1,inst_21900,inst_21901,inst_21902,inst_21903__$1,state_val_21965,c__11856__auto__,event_chan){
return (function (p1__21703_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__21703_SHARP_,field));
});})(e,map__21871,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_21873,inst_21893,inst_21894,inst_21896,inst_21897,inst_21903,inst_21898,inst_21899,inst_21895,inst_21893__$1,inst_21894__$1,inst_21895__$1,inst_21896__$1,inst_21897__$1,inst_21898__$1,inst_21899__$1,inst_21900,inst_21901,inst_21902,inst_21903__$1,state_val_21965,c__11856__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(e,map__21871,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_21873,inst_21893,inst_21894,inst_21896,inst_21897,inst_21903,inst_21898,inst_21899,inst_21895,inst_21893__$1,inst_21894__$1,inst_21895__$1,inst_21896__$1,inst_21897__$1,inst_21898__$1,inst_21899__$1,inst_21900,inst_21901,inst_21902,inst_21903__$1,state_val_21965,c__11856__auto__,event_chan))
})();
var state_21964__$1 = (function (){var statearr_22018 = state_21964;
(statearr_22018[(12)] = inst_21893__$1);

(statearr_22018[(13)] = inst_21894__$1);

(statearr_22018[(14)] = inst_21896__$1);

(statearr_22018[(15)] = inst_21904);

(statearr_22018[(16)] = inst_21897__$1);

(statearr_22018[(8)] = inst_21903__$1);

(statearr_22018[(17)] = inst_21898__$1);

(statearr_22018[(10)] = inst_21899__$1);

(statearr_22018[(9)] = inst_21895__$1);

return statearr_22018;
})();
if(cljs.core.truth_(inst_21894__$1)){
var statearr_22019_22069 = state_21964__$1;
(statearr_22019_22069[(1)] = (17));

} else {
var statearr_22020_22070 = state_21964__$1;
(statearr_22020_22070[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (30))){
var state_21964__$1 = state_21964;
var statearr_22021_22071 = state_21964__$1;
(statearr_22021_22071[(2)] = null);

(statearr_22021_22071[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (10))){
var inst_21888 = (state_21964[(2)]);
var state_21964__$1 = state_21964;
if(cljs.core.truth_(inst_21888)){
var statearr_22022_22072 = state_21964__$1;
(statearr_22022_22072[(1)] = (14));

} else {
var statearr_22023_22073 = state_21964__$1;
(statearr_22023_22073[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (18))){
var state_21964__$1 = state_21964;
var statearr_22024_22074 = state_21964__$1;
(statearr_22024_22074[(2)] = null);

(statearr_22024_22074[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21965 === (8))){
var inst_21873 = (state_21964[(7)]);
var inst_21878 = inst_21873.cljs$lang$protocol_mask$partition0$;
var inst_21879 = (inst_21878 & (64));
var inst_21880 = inst_21873.cljs$core$ISeq$;
var inst_21881 = (inst_21879) || (inst_21880);
var state_21964__$1 = state_21964;
if(cljs.core.truth_(inst_21881)){
var statearr_22025_22075 = state_21964__$1;
(statearr_22025_22075[(1)] = (11));

} else {
var statearr_22026_22076 = state_21964__$1;
(statearr_22026_22076[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto__,event_chan))
;
return ((function (switch__11791__auto__,c__11856__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__11792__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__11792__auto____0 = (function (){
var statearr_22030 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22030[(0)] = hatti$views$table$handle_table_events_$_state_machine__11792__auto__);

(statearr_22030[(1)] = (1));

return statearr_22030;
});
var hatti$views$table$handle_table_events_$_state_machine__11792__auto____1 = (function (state_21964){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_21964);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e22031){if((e22031 instanceof Object)){
var ex__11795__auto__ = e22031;
var statearr_22032_22077 = state_21964;
(statearr_22032_22077[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21964);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22031;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22078 = state_21964;
state_21964 = G__22078;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__11792__auto__ = function(state_21964){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__11792__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__11792__auto____1.call(this,state_21964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__11792__auto____0;
hatti$views$table$handle_table_events_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__11792__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__,event_chan))
})();
var state__11858__auto__ = (function (){var statearr_22033 = f__11857__auto__.call(null);
(statearr_22033[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_22033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto__,event_chan))
);

return c__11856__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),k);

return colset_BANG_.call(null,k);
});
var iter__6990__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__22087(s__22088){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__22088__$1 = s__22088;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22088__$1);
if(temp__4657__auto__){
var s__22088__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22088__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__22088__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__22090 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__22089 = (0);
while(true){
if((i__22089 < size__6989__auto__)){
var vec__22093 = cljs.core._nth.call(null,c__6988__auto__,i__22089);
var k = cljs.core.nth.call(null,vec__22093,(0),null);
var v = cljs.core.nth.call(null,vec__22093,(1),null);
cljs.core.chunk_append.call(null,b__22090,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__22089,vec__22093,k,v,c__6988__auto__,size__6989__auto__,b__22090,s__22088__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__22089,vec__22093,k,v,c__6988__auto__,size__6989__auto__,b__22090,s__22088__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__22095 = (i__22089 + (1));
i__22089 = G__22095;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22090),hatti$views$table$render_options_$_iter__22087.call(null,cljs.core.chunk_rest.call(null,s__22088__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22090),null);
}
} else {
var vec__22094 = cljs.core.first.call(null,s__22088__$2);
var k = cljs.core.nth.call(null,vec__22094,(0),null);
var v = cljs.core.nth.call(null,vec__22094,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__22094,k,v,s__22088__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__22094,k,v,s__22088__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__22087.call(null,cljs.core.rest.call(null,s__22088__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__6990__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table22097 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table22097 = (function (_,owner,meta22098){
this._ = _;
this.owner = owner;
this.meta22098 = meta22098;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table22097.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22099,meta22098__$1){
var self__ = this;
var _22099__$1 = this;
return (new hatti.views.table.t_hatti$views$table22097(self__._,self__.owner,meta22098__$1));
});

hatti.views.table.t_hatti$views$table22097.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22099){
var self__ = this;
var _22099__$1 = this;
return self__.meta22098;
});

hatti.views.table.t_hatti$views$table22097.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table22097.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table22097.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table22097.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__22100){
var self__ = this;
var map__22101 = p__22100;
var map__22101__$1 = ((((!((map__22101 == null)))?((((map__22101.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22101.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22101):map__22101);
var name_or_label = cljs.core.get.call(null,map__22101__$1,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208));
var language = cljs.core.get.call(null,map__22101__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__22103 = om.core.get_shared.call(null,self__.owner);
var map__22103__$1 = ((((!((map__22103 == null)))?((((map__22103.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22103.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22103):map__22103);
var flat_form = cljs.core.get.call(null,map__22103__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__22103,map__22103__$1,flat_form,new_language,___$2,map__22101,map__22101__$1,name_or_label,language){
return (function (p1__22096_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__22096_SHARP_),new_language)], null));
});})(options,map__22103,map__22103__$1,flat_form,new_language,___$2,map__22101,map__22101__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,name_or_label);
} else {
}

return React.DOM.div({"className": "label-changer"},React.DOM.span({"className": "label-changer-label"},"Show:"),React.DOM.div({"id": "header-display-dropdown", "className": "drop-hover"},(function (){var attrs22107 = options.call(null,name_or_label);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs22107))?sablono.interpreter.attributes.call(null,attrs22107):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs22107))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i({"className": "fa fa-angle-down"})], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs22107),React.DOM.i({"className": "fa fa-angle-down"})], null))));
})(),React.DOM.ul({"className": "submenu no-dot"},sablono.interpreter.interpret.call(null,hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_)))));
});

hatti.views.table.t_hatti$views$table22097.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta22098","meta22098",-166178011,null)], null);
});

hatti.views.table.t_hatti$views$table22097.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table22097.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table22097";

hatti.views.table.t_hatti$views$table22097.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"hatti.views.table/t_hatti$views$table22097");
});

hatti.views.table.__GT_t_hatti$views$table22097 = (function hatti$views$table$__GT_t_hatti$views$table22097(___$1,owner__$1,meta22098){
return (new hatti.views.table.t_hatti$views$table22097(___$1,owner__$1,meta22098));
});

}

return (new hatti.views.table.t_hatti$views$table22097(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__11856__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto__,query){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__,query){
return (function (state_22154){
var state_val_22155 = (state_22154[(1)]);
if((state_val_22155 === (1))){
var inst_22140 = cljs.core.async.timeout.call(null,(150));
var state_22154__$1 = state_22154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22154__$1,(2),inst_22140);
} else {
if((state_val_22155 === (2))){
var inst_22142 = (state_22154[(2)]);
var inst_22143 = input.value;
var inst_22144 = cljs.core._EQ_.call(null,query,inst_22143);
var state_22154__$1 = (function (){var statearr_22156 = state_22154;
(statearr_22156[(7)] = inst_22142);

return statearr_22156;
})();
if(inst_22144){
var statearr_22157_22168 = state_22154__$1;
(statearr_22157_22168[(1)] = (3));

} else {
var statearr_22158_22169 = state_22154__$1;
(statearr_22158_22169[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22155 === (3))){
var inst_22146 = [query_event_key];
var inst_22147 = [query];
var inst_22148 = cljs.core.PersistentHashMap.fromArrays(inst_22146,inst_22147);
var inst_22149 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_22148);
var state_22154__$1 = state_22154;
var statearr_22159_22170 = state_22154__$1;
(statearr_22159_22170[(2)] = inst_22149);

(statearr_22159_22170[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22155 === (4))){
var state_22154__$1 = state_22154;
var statearr_22160_22171 = state_22154__$1;
(statearr_22160_22171[(2)] = null);

(statearr_22160_22171[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22155 === (5))){
var inst_22152 = (state_22154[(2)]);
var state_22154__$1 = state_22154;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22154__$1,inst_22152);
} else {
return null;
}
}
}
}
}
});})(c__11856__auto__,query))
;
return ((function (switch__11791__auto__,c__11856__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__11792__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__11792__auto____0 = (function (){
var statearr_22164 = [null,null,null,null,null,null,null,null];
(statearr_22164[(0)] = hatti$views$table$delayed_search_$_state_machine__11792__auto__);

(statearr_22164[(1)] = (1));

return statearr_22164;
});
var hatti$views$table$delayed_search_$_state_machine__11792__auto____1 = (function (state_22154){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_22154);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e22165){if((e22165 instanceof Object)){
var ex__11795__auto__ = e22165;
var statearr_22166_22172 = state_22154;
(statearr_22166_22172[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22154);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22165;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22173 = state_22154;
state_22154 = G__22173;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__11792__auto__ = function(state_22154){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__11792__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__11792__auto____1.call(this,state_22154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__11792__auto____0;
hatti$views$table$delayed_search_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__11792__auto____1;
return hatti$views$table$delayed_search_$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__,query))
})();
var state__11858__auto__ = (function (){var statearr_22167 = f__11857__auto__.call(null);
(statearr_22167[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_22167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto__,query))
);

return c__11856__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table22175 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table22175 = (function (_,owner,meta22176){
this._ = _;
this.owner = owner;
this.meta22176 = meta22176;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table22175.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22177,meta22176__$1){
var self__ = this;
var _22177__$1 = this;
return (new hatti.views.table.t_hatti$views$table22175(self__._,self__.owner,meta22176__$1));
});

hatti.views.table.t_hatti$views$table22175.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22177){
var self__ = this;
var _22177__$1 = this;
return self__.meta22176;
});

hatti.views.table.t_hatti$views$table22175.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table22175.prototype.om$core$IRender$render$arity$1 = (function (this__18961__auto__){
var self__ = this;
var this__18961__auto____$1 = this;
return React.DOM.div({"className": "table-search"},React.DOM.i({"className": "fa fa-search"}),sablono.interpreter.input.call(null,{"type": "text", "placeholder": "Search", "onChange": ((function (this__18961__auto____$1){
return (function (p1__22174_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__22174_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__18961__auto____$1))
}));
});

hatti.views.table.t_hatti$views$table22175.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta22176","meta22176",-1436376148,null)], null);
});

hatti.views.table.t_hatti$views$table22175.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table22175.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table22175";

hatti.views.table.t_hatti$views$table22175.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"hatti.views.table/t_hatti$views$table22175");
});

hatti.views.table.__GT_t_hatti$views$table22175 = (function hatti$views$table$__GT_t_hatti$views$table22175(___$1,owner__$1,meta22176){
return (new hatti.views.table.t_hatti$views$table22175(___$1,owner__$1,meta22176));
});

}

return (new hatti.views.table.t_hatti$views$table22175(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table22180 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table22180 = (function (app_state,owner,meta22181){
this.app_state = app_state;
this.owner = owner;
this.meta22181 = meta22181;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table22180.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22182,meta22181__$1){
var self__ = this;
var _22182__$1 = this;
return (new hatti.views.table.t_hatti$views$table22180(self__.app_state,self__.owner,meta22181__$1));
});

hatti.views.table.t_hatti$views$table22180.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22182){
var self__ = this;
var _22182__$1 = this;
return self__.meta22181;
});

hatti.views.table.t_hatti$views$table22180.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table22180.prototype.om$core$IRender$render$arity$1 = (function (this__18961__auto__){
var self__ = this;
var this__18961__auto____$1 = this;
return React.DOM.div({"className": "topbar"},React.DOM.div({"id": hatti.views.table.pager_id}),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.app_state)),React.DOM.div({"style": {"clear": "both"}}));
});

hatti.views.table.t_hatti$views$table22180.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta22181","meta22181",1077271691,null)], null);
});

hatti.views.table.t_hatti$views$table22180.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table22180.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table22180";

hatti.views.table.t_hatti$views$table22180.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"hatti.views.table/t_hatti$views$table22180");
});

hatti.views.table.__GT_t_hatti$views$table22180 = (function hatti$views$table$__GT_t_hatti$views$table22180(app_state__$1,owner__$1,meta22181){
return (new hatti.views.table.t_hatti$views$table22180(app_state__$1,owner__$1,meta22181));
});

}

return (new hatti.views.table.t_hatti$views$table22180(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq.call(null,data)){
var map__22188 = om.core.get_shared.call(null,owner);
var map__22188__$1 = ((((!((map__22188 == null)))?((((map__22188.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22188.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22188):map__22188);
var flat_form = cljs.core.get.call(null,map__22188__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__22188__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__22189 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__22189,(0),null);
var dataview = cljs.core.nth.call(null,vec__22189,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner,p__22192){
var map__22193 = p__22192;
var map__22193__$1 = ((((!((map__22193 == null)))?((((map__22193.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22193.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22193):map__22193);
var opts = map__22193__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__22193__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

if(typeof hatti.views.table.t_hatti$views$table22195 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table22195 = (function (app_state,owner,p__22192,map__22193,opts,slick_grid_event_handlers,meta22196){
this.app_state = app_state;
this.owner = owner;
this.p__22192 = p__22192;
this.map__22193 = map__22193;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta22196 = meta22196;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table22195.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__22193,map__22193__$1,opts,slick_grid_event_handlers){
return (function (_22197,meta22196__$1){
var self__ = this;
var _22197__$1 = this;
return (new hatti.views.table.t_hatti$views$table22195(self__.app_state,self__.owner,self__.p__22192,self__.map__22193,self__.opts,self__.slick_grid_event_handlers,meta22196__$1));
});})(map__22193,map__22193__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table22195.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__22193,map__22193__$1,opts,slick_grid_event_handlers){
return (function (_22197){
var self__ = this;
var _22197__$1 = this;
return self__.meta22196;
});})(map__22193,map__22193__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table22195.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table22195.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__22193,map__22193__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null)));
var map__22198 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__22198__$1 = ((((!((map__22198 == null)))?((((map__22198.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22198.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22198):map__22198);
var dataset_info = map__22198__$1;
var num_of_submissions = cljs.core.get.call(null,map__22198__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var with_info = ((function (no_data_QMARK_,map__22198,map__22198__$1,dataset_info,num_of_submissions,___$2,map__22193,map__22193__$1,opts,slick_grid_event_handlers){
return (function (p1__22191_SHARP_){
return cljs.core.merge.call(null,p1__22191_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),dataset_info], null));
});})(no_data_QMARK_,map__22198,map__22198__$1,dataset_info,num_of_submissions,___$2,map__22193,map__22193__$1,opts,slick_grid_event_handlers))
;
var attrs22200 = om.core.build.call(null,hatti.views.submission_view,with_info.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855)], null))),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null));
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs22200))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs22200)):{"className": "table-view"}),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs22200))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs22200),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null))));
});})(map__22193,map__22193__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table22195.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table22195.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__22193,map__22193__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__22209 = temp__4657__auto__;
var grid = cljs.core.nth.call(null,vec__22209,(0),null);
var dataview = cljs.core.nth.call(null,vec__22209,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__22193,map__22193__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table22195.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table22195.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__22193,map__22193__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__22210 = om.core.get_state.call(null,self__.owner);
var map__22210__$1 = ((((!((map__22210 == null)))?((((map__22210.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22210.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22210):map__22210);
var grid = cljs.core.get.call(null,map__22210__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__22210__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__22212 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__22212,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__22212,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__22193,map__22193__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table22195.getBasis = ((function (map__22193,map__22193__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__22192","p__22192",1374519145,null),new cljs.core.Symbol(null,"map__22193","map__22193",1651437709,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"meta22196","meta22196",1747126334,null)], null);
});})(map__22193,map__22193__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table22195.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table22195.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table22195";

hatti.views.table.t_hatti$views$table22195.cljs$lang$ctorPrWriter = ((function (map__22193,map__22193__$1,opts,slick_grid_event_handlers){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"hatti.views.table/t_hatti$views$table22195");
});})(map__22193,map__22193__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table22195 = ((function (map__22193,map__22193__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table22195(app_state__$1,owner__$1,p__22192__$1,map__22193__$2,opts__$1,slick_grid_event_handlers__$1,meta22196){
return (new hatti.views.table.t_hatti$views$table22195(app_state__$1,owner__$1,p__22192__$1,map__22193__$2,opts__$1,slick_grid_event_handlers__$1,meta22196));
});})(map__22193,map__22193__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table22195(app_state,owner,p__22192,map__22193__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
