// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('c2.maths');
goog.require('cljs.core');
c2.maths.Pi = Math.PI;
c2.maths.Tau = ((2) * c2.maths.Pi);
c2.maths.e = Math.E;
c2.maths.radians_per_degree = (c2.maths.Pi / (180));
c2.maths.rad = (function c2$maths$rad(x){
return (c2.maths.radians_per_degree * x);
});
c2.maths.deg = (function c2$maths$deg(x){
return (x / c2.maths.radians_per_degree);
});
c2.maths.sin = (function c2$maths$sin(x){
return Math.sin(x);
});
c2.maths.asin = (function c2$maths$asin(x){
return Math.asin(x);
});
c2.maths.cos = (function c2$maths$cos(x){
return Math.cos(x);
});
c2.maths.acos = (function c2$maths$acos(x){
return Math.acos(x);
});
c2.maths.tan = (function c2$maths$tan(x){
return Math.tan(x);
});
c2.maths.atan = (function c2$maths$atan(x){
return Math.atan(x);
});
c2.maths.expt = (function c2$maths$expt(var_args){
var args34655 = [];
var len__5627__auto___34658 = arguments.length;
var i__5628__auto___34659 = (0);
while(true){
if((i__5628__auto___34659 < len__5627__auto___34658)){
args34655.push((arguments[i__5628__auto___34659]));

var G__34660 = (i__5628__auto___34659 + (1));
i__5628__auto___34659 = G__34660;
continue;
} else {
}
break;
}

var G__34657 = args34655.length;
switch (G__34657) {
case 1:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34655.length)].join('')));

}
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.exp(x);
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return Math.pow(x,y);
});

c2.maths.expt.cljs$lang$maxFixedArity = 2;
c2.maths.sq = (function c2$maths$sq(x){
return c2.maths.expt.cljs$core$IFn$_invoke$arity$2(x,(2));
});
c2.maths.sqrt = (function c2$maths$sqrt(x){
return Math.sqrt(x);
});
c2.maths.floor = (function c2$maths$floor(x){
return Math.floor(x);
});
c2.maths.ceil = (function c2$maths$ceil(x){
return Math.ceil(x);
});
c2.maths.abs = (function c2$maths$abs(x){
return Math.abs(x);
});
c2.maths.log = (function c2$maths$log(var_args){
var args34662 = [];
var len__5627__auto___34665 = arguments.length;
var i__5628__auto___34666 = (0);
while(true){
if((i__5628__auto___34666 < len__5627__auto___34665)){
args34662.push((arguments[i__5628__auto___34666]));

var G__34667 = (i__5628__auto___34666 + (1));
i__5628__auto___34666 = G__34667;
continue;
} else {
}
break;
}

var G__34664 = args34662.length;
switch (G__34664) {
case 1:
return c2.maths.log.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.log.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34662.length)].join('')));

}
});

c2.maths.log.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.log(x);
});

c2.maths.log.cljs$core$IFn$_invoke$arity$2 = (function (base,x){
return (Math.log(x) / Math.log(base));
});

c2.maths.log.cljs$lang$maxFixedArity = 2;
c2.maths.log10 = (function c2$maths$log10(x){
return (Math.log(x) / Math.LN10);
});
/**
 * Returns 2-vector of min and max elements in xs.
 */
c2.maths.extent = (function c2$maths$extent(xs){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,xs),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,xs)], null);
});
/**
 * Arithemetic mean of collection
 */
c2.maths.mean = (function c2$maths$mean(xs){
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,xs) / cljs.core.count(xs));
});
/**
 * Median of a collection.
 */
c2.maths.median = (function c2$maths$median(xs){
var sorted = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(xs);
var n = cljs.core.count(xs);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(1))){
return cljs.core.first(sorted);
} else {
if(cljs.core.odd_QMARK_(n)){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sorted,((n + (1)) / (2)));
} else {
var mid = (n / (2));
return c2.maths.mean(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sorted,c2.maths.floor(mid)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sorted,c2.maths.ceil(mid))], null));

}
}
});
/**
 * Inclusive range; same as core/range, but includes the end.
 */
c2.maths.irange = (function c2$maths$irange(var_args){
var args34669 = [];
var len__5627__auto___34672 = arguments.length;
var i__5628__auto___34673 = (0);
while(true){
if((i__5628__auto___34673 < len__5627__auto___34672)){
args34669.push((arguments[i__5628__auto___34673]));

var G__34674 = (i__5628__auto___34673 + (1));
i__5628__auto___34673 = G__34674;
continue;
} else {
}
break;
}

var G__34671 = args34669.length;
switch (G__34671) {
case 1:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34669.length)].join('')));

}
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$1 = (function (start){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1(start);
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.range.cljs$core$IFn$_invoke$arity$2(start,end),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
var r = cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,end,step);
if((cljs.core.mod(cljs.core.first(r),step) === cljs.core.mod(end,step))){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(r,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
} else {
return r;
}
});

c2.maths.irange.cljs$lang$maxFixedArity = 3;
/**
 * Checks if bottom <= x <= top.
 */
c2.maths.within_QMARK_ = (function c2$maths$within_QMARK_(x,p__34676){
var vec__34678 = p__34676;
var bottom = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34678,(0),null);
var top = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34678,(1),null);
return ((bottom <= x)) && ((x <= top));
});
c2.maths.add = (function c2$maths$add(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34680 = arguments.length;
var i__5628__auto___34681 = (0);
while(true){
if((i__5628__auto___34681 < len__5627__auto___34680)){
args__5634__auto__.push((arguments[i__5628__auto___34681]));

var G__34682 = (i__5628__auto___34681 + (1));
i__5628__auto___34681 = G__34682;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.maths.add.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A + B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.add.cljs$lang$maxFixedArity = (0);

c2.maths.add.cljs$lang$applyTo = (function (seq34679){
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34679));
});
c2.maths.sub = (function c2$maths$sub(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34684 = arguments.length;
var i__5628__auto___34685 = (0);
while(true){
if((i__5628__auto___34685 < len__5627__auto___34684)){
args__5634__auto__.push((arguments[i__5628__auto___34685]));

var G__34686 = (i__5628__auto___34685 + (1));
i__5628__auto___34685 = G__34686;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(args),(1))){
if((typeof (0) === 'number') && (typeof cljs.core.first(args) === 'number')){
return ((0) - cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((0))) && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,(0),cljs.core.first(args));
} else {
if((typeof (0) === 'number') && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,cljs.core.replicate(cljs.core.count(cljs.core.first(args)),(0)),cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((0))) && (typeof cljs.core.first(args) === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,(0),cljs.core.replicate(cljs.core.count((0)),cljs.core.first(args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A - B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.sub.cljs$lang$maxFixedArity = (0);

c2.maths.sub.cljs$lang$applyTo = (function (seq34683){
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34683));
});
c2.maths.mul = (function c2$maths$mul(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34688 = arguments.length;
var i__5628__auto___34689 = (0);
while(true){
if((i__5628__auto___34689 < len__5627__auto___34688)){
args__5634__auto__.push((arguments[i__5628__auto___34689]));

var G__34690 = (i__5628__auto___34689 + (1));
i__5628__auto___34689 = G__34690;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A * B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.mul.cljs$lang$maxFixedArity = (0);

c2.maths.mul.cljs$lang$applyTo = (function (seq34687){
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34687));
});
c2.maths.div = (function c2$maths$div(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34692 = arguments.length;
var i__5628__auto___34693 = (0);
while(true){
if((i__5628__auto___34693 < len__5627__auto___34692)){
args__5634__auto__.push((arguments[i__5628__auto___34693]));

var G__34694 = (i__5628__auto___34693 + (1));
i__5628__auto___34693 = G__34694;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.maths.div.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(args),(1))){
if((typeof (1) === 'number') && (typeof cljs.core.first(args) === 'number')){
return ((1) / cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((1))) && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(1),cljs.core.first(args));
} else {
if((typeof (1) === 'number') && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,cljs.core.replicate(cljs.core.count(cljs.core.first(args)),(1)),cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((1))) && (typeof cljs.core.first(args) === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(1),cljs.core.replicate(cljs.core.count((1)),cljs.core.first(args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A / B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.div.cljs$lang$maxFixedArity = (0);

c2.maths.div.cljs$lang$applyTo = (function (seq34691){
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34691));
});
/**
 * Returns the quantiles of a dataset.
 * 
 * Kwargs:
 * 
 *   > *:probs*: ntiles of the data to return, defaults to `[0 0.25 0.5 0.75 1]`
 * 
 *   Algorithm is the same as R's quantile type=7.
 *   Transcribed from Jason Davies; https://github.com/jasondavies/science.js/blob/master/src/stats/quantiles.js
 */
c2.maths.quantile = (function c2$maths$quantile(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34710 = arguments.length;
var i__5628__auto___34711 = (0);
while(true){
if((i__5628__auto___34711 < len__5627__auto___34710)){
args__5634__auto__.push((arguments[i__5628__auto___34711]));

var G__34712 = (i__5628__auto___34711 + (1));
i__5628__auto___34711 = G__34712;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__34697){
var map__34698 = p__34697;
var map__34698__$1 = ((((!((map__34698 == null)))?((((map__34698.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34698.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34698):map__34698);
var probs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34698__$1,cljs.core.cst$kw$probs,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),0.25,0.5,0.75,(1)], null));
var xs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.sort.cljs$core$IFn$_invoke$arity$1(data));
var n_1 = (cljs.core.count(xs) - (1));
var iter__5341__auto__ = ((function (xs,n_1,map__34698,map__34698__$1,probs){
return (function c2$maths$iter__34700(s__34701){
return (new cljs.core.LazySeq(null,((function (xs,n_1,map__34698,map__34698__$1,probs){
return (function (){
var s__34701__$1 = s__34701;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__34701__$1);
if(temp__4425__auto__){
var s__34701__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34701__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__34701__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__34703 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__34702 = (0);
while(true){
if((i__34702 < size__5340__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__34702);
cljs.core.chunk_append(b__34703,(function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor(index) | (0));
var h = (index - lo);
var a = (function (){var G__34708 = (lo - (1));
return (xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(G__34708) : xs.call(null,G__34708));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,(0))){
return a;
} else {
return (a + (h * ((xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(lo) : xs.call(null,lo)) - a)));
}
})());

var G__34713 = (i__34702 + (1));
i__34702 = G__34713;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34703),c2$maths$iter__34700(cljs.core.chunk_rest(s__34701__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34703),null);
}
} else {
var q = cljs.core.first(s__34701__$2);
return cljs.core.cons((function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor(index) | (0));
var h = (index - lo);
var a = (function (){var G__34709 = (lo - (1));
return (xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(G__34709) : xs.call(null,G__34709));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,(0))){
return a;
} else {
return (a + (h * ((xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(lo) : xs.call(null,lo)) - a)));
}
})(),c2$maths$iter__34700(cljs.core.rest(s__34701__$2)));
}
} else {
return null;
}
break;
}
});})(xs,n_1,map__34698,map__34698__$1,probs))
,null,null));
});})(xs,n_1,map__34698,map__34698__$1,probs))
;
return iter__5341__auto__(probs);
});

c2.maths.quantile.cljs$lang$maxFixedArity = (1);

c2.maths.quantile.cljs$lang$applyTo = (function (seq34695){
var G__34696 = cljs.core.first(seq34695);
var seq34695__$1 = cljs.core.next(seq34695);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic(G__34696,seq34695__$1);
});
