// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async36006 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36006 = (function (fn_handler,f,meta36007){
this.fn_handler = fn_handler;
this.f = f;
this.meta36007 = meta36007;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36006.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36008,meta36007__$1){
var self__ = this;
var _36008__$1 = this;
return (new cljs.core.async.t_cljs$core$async36006(self__.fn_handler,self__.f,meta36007__$1));
});

cljs.core.async.t_cljs$core$async36006.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36008){
var self__ = this;
var _36008__$1 = this;
return self__.meta36007;
});

cljs.core.async.t_cljs$core$async36006.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async36006.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async36006.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async36006.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fn_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)))], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$meta36007], null);
});

cljs.core.async.t_cljs$core$async36006.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36006.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36006";

cljs.core.async.t_cljs$core$async36006.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async36006");
});

cljs.core.async.__GT_t_cljs$core$async36006 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async36006(fn_handler__$1,f__$1,meta36007){
return (new cljs.core.async.t_cljs$core$async36006(fn_handler__$1,f__$1,meta36007));
});

}

return (new cljs.core.async.t_cljs$core$async36006(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args36011 = [];
var len__5627__auto___36014 = arguments.length;
var i__5628__auto___36015 = (0);
while(true){
if((i__5628__auto___36015 < len__5627__auto___36014)){
args36011.push((arguments[i__5628__auto___36015]));

var G__36016 = (i__5628__auto___36015 + (1));
i__5628__auto___36015 = G__36016;
continue;
} else {
}
break;
}

var G__36013 = args36011.length;
switch (G__36013) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36011.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$sym$buf_DASH_or_DASH_n], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args36018 = [];
var len__5627__auto___36021 = arguments.length;
var i__5628__auto___36022 = (0);
while(true){
if((i__5628__auto___36022 < len__5627__auto___36021)){
args36018.push((arguments[i__5628__auto___36022]));

var G__36023 = (i__5628__auto___36022 + (1));
i__5628__auto___36022 = G__36023;
continue;
} else {
}
break;
}

var G__36020 = args36018.length;
switch (G__36020) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36018.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_36025 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_36025) : fn1.call(null,val_36025));
} else {
cljs.core.async.impl.dispatch.run(((function (val_36025,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_36025) : fn1.call(null,val_36025));
});})(val_36025,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args36026 = [];
var len__5627__auto___36029 = arguments.length;
var i__5628__auto___36030 = (0);
while(true){
if((i__5628__auto___36030 < len__5627__auto___36029)){
args36026.push((arguments[i__5628__auto___36030]));

var G__36031 = (i__5628__auto___36030 + (1));
i__5628__auto___36030 = G__36031;
continue;
} else {
}
break;
}

var G__36028 = args36026.length;
switch (G__36028) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36026.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4423__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5472__auto___36033 = n;
var x_36034 = (0);
while(true){
if((x_36034 < n__5472__auto___36033)){
(a[x_36034] = (0));

var G__36035 = (x_36034 + (1));
x_36034 = G__36035;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__36036 = (i + (1));
i = G__36036;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async36040 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36040 = (function (alt_flag,flag,meta36041){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta36041 = meta36041;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36040.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_36042,meta36041__$1){
var self__ = this;
var _36042__$1 = this;
return (new cljs.core.async.t_cljs$core$async36040(self__.alt_flag,self__.flag,meta36041__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async36040.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_36042){
var self__ = this;
var _36042__$1 = this;
return self__.meta36041;
});})(flag))
;

cljs.core.async.t_cljs$core$async36040.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async36040.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async36040.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async36040.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta36041], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async36040.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36040.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36040";

cljs.core.async.t_cljs$core$async36040.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async36040");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async36040 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async36040(alt_flag__$1,flag__$1,meta36041){
return (new cljs.core.async.t_cljs$core$async36040(alt_flag__$1,flag__$1,meta36041));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async36040(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async36046 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36046 = (function (alt_handler,flag,cb,meta36047){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta36047 = meta36047;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36046.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36048,meta36047__$1){
var self__ = this;
var _36048__$1 = this;
return (new cljs.core.async.t_cljs$core$async36046(self__.alt_handler,self__.flag,self__.cb,meta36047__$1));
});

cljs.core.async.t_cljs$core$async36046.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36048){
var self__ = this;
var _36048__$1 = this;
return self__.meta36047;
});

cljs.core.async.t_cljs$core$async36046.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async36046.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async36046.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async36046.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta36047], null);
});

cljs.core.async.t_cljs$core$async36046.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36046.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36046";

cljs.core.async.t_cljs$core$async36046.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async36046");
});

cljs.core.async.__GT_t_cljs$core$async36046 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async36046(alt_handler__$1,flag__$1,cb__$1,meta36047){
return (new cljs.core.async.t_cljs$core$async36046(alt_handler__$1,flag__$1,cb__$1,meta36047));
});

}

return (new cljs.core.async.t_cljs$core$async36046(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__36049_SHARP_){
var G__36053 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36049_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__36053) : fret.call(null,G__36053));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__36050_SHARP_){
var G__36054 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36050_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__36054) : fret.call(null,G__36054));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__4569__auto__ = wport;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return port;
}
})()], null));
} else {
var G__36055 = (i + (1));
i = G__36055;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4569__auto__ = ret;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4425__auto__ = (function (){var and__4557__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___36061 = arguments.length;
var i__5628__auto___36062 = (0);
while(true){
if((i__5628__auto___36062 < len__5627__auto___36061)){
args__5634__auto__.push((arguments[i__5628__auto___36062]));

var G__36063 = (i__5628__auto___36062 + (1));
i__5628__auto___36062 = G__36063;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__36058){
var map__36059 = p__36058;
var map__36059__$1 = ((((!((map__36059 == null)))?((((map__36059.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36059.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36059):map__36059);
var opts = map__36059__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq36056){
var G__36057 = cljs.core.first(seq36056);
var seq36056__$1 = cljs.core.next(seq36056);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__36057,seq36056__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args36064 = [];
var len__5627__auto___36114 = arguments.length;
var i__5628__auto___36115 = (0);
while(true){
if((i__5628__auto___36115 < len__5627__auto___36114)){
args36064.push((arguments[i__5628__auto___36115]));

var G__36116 = (i__5628__auto___36115 + (1));
i__5628__auto___36115 = G__36116;
continue;
} else {
}
break;
}

var G__36066 = args36064.length;
switch (G__36066) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36064.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8400__auto___36118 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___36118){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___36118){
return (function (state_36090){
var state_val_36091 = (state_36090[(1)]);
if((state_val_36091 === (7))){
var inst_36086 = (state_36090[(2)]);
var state_36090__$1 = state_36090;
var statearr_36092_36119 = state_36090__$1;
(statearr_36092_36119[(2)] = inst_36086);

(statearr_36092_36119[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (1))){
var state_36090__$1 = state_36090;
var statearr_36093_36120 = state_36090__$1;
(statearr_36093_36120[(2)] = null);

(statearr_36093_36120[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (4))){
var inst_36069 = (state_36090[(7)]);
var inst_36069__$1 = (state_36090[(2)]);
var inst_36070 = (inst_36069__$1 == null);
var state_36090__$1 = (function (){var statearr_36094 = state_36090;
(statearr_36094[(7)] = inst_36069__$1);

return statearr_36094;
})();
if(cljs.core.truth_(inst_36070)){
var statearr_36095_36121 = state_36090__$1;
(statearr_36095_36121[(1)] = (5));

} else {
var statearr_36096_36122 = state_36090__$1;
(statearr_36096_36122[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (13))){
var state_36090__$1 = state_36090;
var statearr_36097_36123 = state_36090__$1;
(statearr_36097_36123[(2)] = null);

(statearr_36097_36123[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (6))){
var inst_36069 = (state_36090[(7)]);
var state_36090__$1 = state_36090;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36090__$1,(11),to,inst_36069);
} else {
if((state_val_36091 === (3))){
var inst_36088 = (state_36090[(2)]);
var state_36090__$1 = state_36090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36090__$1,inst_36088);
} else {
if((state_val_36091 === (12))){
var state_36090__$1 = state_36090;
var statearr_36098_36124 = state_36090__$1;
(statearr_36098_36124[(2)] = null);

(statearr_36098_36124[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (2))){
var state_36090__$1 = state_36090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36090__$1,(4),from);
} else {
if((state_val_36091 === (11))){
var inst_36079 = (state_36090[(2)]);
var state_36090__$1 = state_36090;
if(cljs.core.truth_(inst_36079)){
var statearr_36099_36125 = state_36090__$1;
(statearr_36099_36125[(1)] = (12));

} else {
var statearr_36100_36126 = state_36090__$1;
(statearr_36100_36126[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (9))){
var state_36090__$1 = state_36090;
var statearr_36101_36127 = state_36090__$1;
(statearr_36101_36127[(2)] = null);

(statearr_36101_36127[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (5))){
var state_36090__$1 = state_36090;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36102_36128 = state_36090__$1;
(statearr_36102_36128[(1)] = (8));

} else {
var statearr_36103_36129 = state_36090__$1;
(statearr_36103_36129[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (14))){
var inst_36084 = (state_36090[(2)]);
var state_36090__$1 = state_36090;
var statearr_36104_36130 = state_36090__$1;
(statearr_36104_36130[(2)] = inst_36084);

(statearr_36104_36130[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (10))){
var inst_36076 = (state_36090[(2)]);
var state_36090__$1 = state_36090;
var statearr_36105_36131 = state_36090__$1;
(statearr_36105_36131[(2)] = inst_36076);

(statearr_36105_36131[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (8))){
var inst_36073 = cljs.core.async.close_BANG_(to);
var state_36090__$1 = state_36090;
var statearr_36106_36132 = state_36090__$1;
(statearr_36106_36132[(2)] = inst_36073);

(statearr_36106_36132[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___36118))
;
return ((function (switch__8335__auto__,c__8400__auto___36118){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_36110 = [null,null,null,null,null,null,null,null];
(statearr_36110[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_36110[(1)] = (1));

return statearr_36110;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_36090){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_36090);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e36111){if((e36111 instanceof Object)){
var ex__8339__auto__ = e36111;
var statearr_36112_36133 = state_36090;
(statearr_36112_36133[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36090);

return cljs.core.cst$kw$recur;
} else {
throw e36111;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__36134 = state_36090;
state_36090 = G__36134;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_36090){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_36090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___36118))
})();
var state__8402__auto__ = (function (){var statearr_36113 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_36113[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___36118);

return statearr_36113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___36118))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$pos_QMARK_,cljs.core.cst$sym$n)], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__36318){
var vec__36319 = p__36318;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36319,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36319,(1),null);
var job = vec__36319;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__8400__auto___36501 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___36501,res,vec__36319,v,p,job,jobs,results){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___36501,res,vec__36319,v,p,job,jobs,results){
return (function (state_36324){
var state_val_36325 = (state_36324[(1)]);
if((state_val_36325 === (1))){
var state_36324__$1 = state_36324;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36324__$1,(2),res,v);
} else {
if((state_val_36325 === (2))){
var inst_36321 = (state_36324[(2)]);
var inst_36322 = cljs.core.async.close_BANG_(res);
var state_36324__$1 = (function (){var statearr_36326 = state_36324;
(statearr_36326[(7)] = inst_36321);

return statearr_36326;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_36324__$1,inst_36322);
} else {
return null;
}
}
});})(c__8400__auto___36501,res,vec__36319,v,p,job,jobs,results))
;
return ((function (switch__8335__auto__,c__8400__auto___36501,res,vec__36319,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_36330 = [null,null,null,null,null,null,null,null];
(statearr_36330[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_36330[(1)] = (1));

return statearr_36330;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_36324){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_36324);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e36331){if((e36331 instanceof Object)){
var ex__8339__auto__ = e36331;
var statearr_36332_36502 = state_36324;
(statearr_36332_36502[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36324);

return cljs.core.cst$kw$recur;
} else {
throw e36331;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__36503 = state_36324;
state_36324 = G__36503;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_36324){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_36324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___36501,res,vec__36319,v,p,job,jobs,results))
})();
var state__8402__auto__ = (function (){var statearr_36333 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_36333[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___36501);

return statearr_36333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___36501,res,vec__36319,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__36334){
var vec__36335 = p__36334;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36335,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36335,(1),null);
var job = vec__36335;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__5472__auto___36504 = n;
var __36505 = (0);
while(true){
if((__36505 < n__5472__auto___36504)){
var G__36336_36506 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__36336_36506) {
case "compute":
var c__8400__auto___36508 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__36505,c__8400__auto___36508,G__36336_36506,n__5472__auto___36504,jobs,results,process,async){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (__36505,c__8400__auto___36508,G__36336_36506,n__5472__auto___36504,jobs,results,process,async){
return (function (state_36349){
var state_val_36350 = (state_36349[(1)]);
if((state_val_36350 === (1))){
var state_36349__$1 = state_36349;
var statearr_36351_36509 = state_36349__$1;
(statearr_36351_36509[(2)] = null);

(statearr_36351_36509[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36350 === (2))){
var state_36349__$1 = state_36349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36349__$1,(4),jobs);
} else {
if((state_val_36350 === (3))){
var inst_36347 = (state_36349[(2)]);
var state_36349__$1 = state_36349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36349__$1,inst_36347);
} else {
if((state_val_36350 === (4))){
var inst_36339 = (state_36349[(2)]);
var inst_36340 = process(inst_36339);
var state_36349__$1 = state_36349;
if(cljs.core.truth_(inst_36340)){
var statearr_36352_36510 = state_36349__$1;
(statearr_36352_36510[(1)] = (5));

} else {
var statearr_36353_36511 = state_36349__$1;
(statearr_36353_36511[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36350 === (5))){
var state_36349__$1 = state_36349;
var statearr_36354_36512 = state_36349__$1;
(statearr_36354_36512[(2)] = null);

(statearr_36354_36512[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36350 === (6))){
var state_36349__$1 = state_36349;
var statearr_36355_36513 = state_36349__$1;
(statearr_36355_36513[(2)] = null);

(statearr_36355_36513[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36350 === (7))){
var inst_36345 = (state_36349[(2)]);
var state_36349__$1 = state_36349;
var statearr_36356_36514 = state_36349__$1;
(statearr_36356_36514[(2)] = inst_36345);

(statearr_36356_36514[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__36505,c__8400__auto___36508,G__36336_36506,n__5472__auto___36504,jobs,results,process,async))
;
return ((function (__36505,switch__8335__auto__,c__8400__auto___36508,G__36336_36506,n__5472__auto___36504,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_36360 = [null,null,null,null,null,null,null];
(statearr_36360[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_36360[(1)] = (1));

return statearr_36360;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_36349){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_36349);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e36361){if((e36361 instanceof Object)){
var ex__8339__auto__ = e36361;
var statearr_36362_36515 = state_36349;
(statearr_36362_36515[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36349);

return cljs.core.cst$kw$recur;
} else {
throw e36361;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__36516 = state_36349;
state_36349 = G__36516;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_36349){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_36349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(__36505,switch__8335__auto__,c__8400__auto___36508,G__36336_36506,n__5472__auto___36504,jobs,results,process,async))
})();
var state__8402__auto__ = (function (){var statearr_36363 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_36363[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___36508);

return statearr_36363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(__36505,c__8400__auto___36508,G__36336_36506,n__5472__auto___36504,jobs,results,process,async))
);


break;
case "async":
var c__8400__auto___36517 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__36505,c__8400__auto___36517,G__36336_36506,n__5472__auto___36504,jobs,results,process,async){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (__36505,c__8400__auto___36517,G__36336_36506,n__5472__auto___36504,jobs,results,process,async){
return (function (state_36376){
var state_val_36377 = (state_36376[(1)]);
if((state_val_36377 === (1))){
var state_36376__$1 = state_36376;
var statearr_36378_36518 = state_36376__$1;
(statearr_36378_36518[(2)] = null);

(statearr_36378_36518[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (2))){
var state_36376__$1 = state_36376;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36376__$1,(4),jobs);
} else {
if((state_val_36377 === (3))){
var inst_36374 = (state_36376[(2)]);
var state_36376__$1 = state_36376;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36376__$1,inst_36374);
} else {
if((state_val_36377 === (4))){
var inst_36366 = (state_36376[(2)]);
var inst_36367 = async(inst_36366);
var state_36376__$1 = state_36376;
if(cljs.core.truth_(inst_36367)){
var statearr_36379_36519 = state_36376__$1;
(statearr_36379_36519[(1)] = (5));

} else {
var statearr_36380_36520 = state_36376__$1;
(statearr_36380_36520[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (5))){
var state_36376__$1 = state_36376;
var statearr_36381_36521 = state_36376__$1;
(statearr_36381_36521[(2)] = null);

(statearr_36381_36521[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (6))){
var state_36376__$1 = state_36376;
var statearr_36382_36522 = state_36376__$1;
(statearr_36382_36522[(2)] = null);

(statearr_36382_36522[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36377 === (7))){
var inst_36372 = (state_36376[(2)]);
var state_36376__$1 = state_36376;
var statearr_36383_36523 = state_36376__$1;
(statearr_36383_36523[(2)] = inst_36372);

(statearr_36383_36523[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__36505,c__8400__auto___36517,G__36336_36506,n__5472__auto___36504,jobs,results,process,async))
;
return ((function (__36505,switch__8335__auto__,c__8400__auto___36517,G__36336_36506,n__5472__auto___36504,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_36387 = [null,null,null,null,null,null,null];
(statearr_36387[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_36387[(1)] = (1));

return statearr_36387;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_36376){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_36376);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e36388){if((e36388 instanceof Object)){
var ex__8339__auto__ = e36388;
var statearr_36389_36524 = state_36376;
(statearr_36389_36524[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36376);

return cljs.core.cst$kw$recur;
} else {
throw e36388;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__36525 = state_36376;
state_36376 = G__36525;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_36376){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_36376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(__36505,switch__8335__auto__,c__8400__auto___36517,G__36336_36506,n__5472__auto___36504,jobs,results,process,async))
})();
var state__8402__auto__ = (function (){var statearr_36390 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_36390[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___36517);

return statearr_36390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(__36505,c__8400__auto___36517,G__36336_36506,n__5472__auto___36504,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__36526 = (__36505 + (1));
__36505 = G__36526;
continue;
} else {
}
break;
}

var c__8400__auto___36527 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___36527,jobs,results,process,async){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___36527,jobs,results,process,async){
return (function (state_36412){
var state_val_36413 = (state_36412[(1)]);
if((state_val_36413 === (1))){
var state_36412__$1 = state_36412;
var statearr_36414_36528 = state_36412__$1;
(statearr_36414_36528[(2)] = null);

(statearr_36414_36528[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36413 === (2))){
var state_36412__$1 = state_36412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36412__$1,(4),from);
} else {
if((state_val_36413 === (3))){
var inst_36410 = (state_36412[(2)]);
var state_36412__$1 = state_36412;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36412__$1,inst_36410);
} else {
if((state_val_36413 === (4))){
var inst_36393 = (state_36412[(7)]);
var inst_36393__$1 = (state_36412[(2)]);
var inst_36394 = (inst_36393__$1 == null);
var state_36412__$1 = (function (){var statearr_36415 = state_36412;
(statearr_36415[(7)] = inst_36393__$1);

return statearr_36415;
})();
if(cljs.core.truth_(inst_36394)){
var statearr_36416_36529 = state_36412__$1;
(statearr_36416_36529[(1)] = (5));

} else {
var statearr_36417_36530 = state_36412__$1;
(statearr_36417_36530[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36413 === (5))){
var inst_36396 = cljs.core.async.close_BANG_(jobs);
var state_36412__$1 = state_36412;
var statearr_36418_36531 = state_36412__$1;
(statearr_36418_36531[(2)] = inst_36396);

(statearr_36418_36531[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36413 === (6))){
var inst_36398 = (state_36412[(8)]);
var inst_36393 = (state_36412[(7)]);
var inst_36398__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_36399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36400 = [inst_36393,inst_36398__$1];
var inst_36401 = (new cljs.core.PersistentVector(null,2,(5),inst_36399,inst_36400,null));
var state_36412__$1 = (function (){var statearr_36419 = state_36412;
(statearr_36419[(8)] = inst_36398__$1);

return statearr_36419;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36412__$1,(8),jobs,inst_36401);
} else {
if((state_val_36413 === (7))){
var inst_36408 = (state_36412[(2)]);
var state_36412__$1 = state_36412;
var statearr_36420_36532 = state_36412__$1;
(statearr_36420_36532[(2)] = inst_36408);

(statearr_36420_36532[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36413 === (8))){
var inst_36398 = (state_36412[(8)]);
var inst_36403 = (state_36412[(2)]);
var state_36412__$1 = (function (){var statearr_36421 = state_36412;
(statearr_36421[(9)] = inst_36403);

return statearr_36421;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36412__$1,(9),results,inst_36398);
} else {
if((state_val_36413 === (9))){
var inst_36405 = (state_36412[(2)]);
var state_36412__$1 = (function (){var statearr_36422 = state_36412;
(statearr_36422[(10)] = inst_36405);

return statearr_36422;
})();
var statearr_36423_36533 = state_36412__$1;
(statearr_36423_36533[(2)] = null);

(statearr_36423_36533[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___36527,jobs,results,process,async))
;
return ((function (switch__8335__auto__,c__8400__auto___36527,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_36427 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36427[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_36427[(1)] = (1));

return statearr_36427;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_36412){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_36412);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e36428){if((e36428 instanceof Object)){
var ex__8339__auto__ = e36428;
var statearr_36429_36534 = state_36412;
(statearr_36429_36534[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36412);

return cljs.core.cst$kw$recur;
} else {
throw e36428;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__36535 = state_36412;
state_36412 = G__36535;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_36412){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_36412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___36527,jobs,results,process,async))
})();
var state__8402__auto__ = (function (){var statearr_36430 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_36430[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___36527);

return statearr_36430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___36527,jobs,results,process,async))
);


var c__8400__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto__,jobs,results,process,async){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__,jobs,results,process,async){
return (function (state_36468){
var state_val_36469 = (state_36468[(1)]);
if((state_val_36469 === (7))){
var inst_36464 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
var statearr_36470_36536 = state_36468__$1;
(statearr_36470_36536[(2)] = inst_36464);

(statearr_36470_36536[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (20))){
var state_36468__$1 = state_36468;
var statearr_36471_36537 = state_36468__$1;
(statearr_36471_36537[(2)] = null);

(statearr_36471_36537[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (1))){
var state_36468__$1 = state_36468;
var statearr_36472_36538 = state_36468__$1;
(statearr_36472_36538[(2)] = null);

(statearr_36472_36538[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (4))){
var inst_36433 = (state_36468[(7)]);
var inst_36433__$1 = (state_36468[(2)]);
var inst_36434 = (inst_36433__$1 == null);
var state_36468__$1 = (function (){var statearr_36473 = state_36468;
(statearr_36473[(7)] = inst_36433__$1);

return statearr_36473;
})();
if(cljs.core.truth_(inst_36434)){
var statearr_36474_36539 = state_36468__$1;
(statearr_36474_36539[(1)] = (5));

} else {
var statearr_36475_36540 = state_36468__$1;
(statearr_36475_36540[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (15))){
var inst_36446 = (state_36468[(8)]);
var state_36468__$1 = state_36468;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36468__$1,(18),to,inst_36446);
} else {
if((state_val_36469 === (21))){
var inst_36459 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
var statearr_36476_36541 = state_36468__$1;
(statearr_36476_36541[(2)] = inst_36459);

(statearr_36476_36541[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (13))){
var inst_36461 = (state_36468[(2)]);
var state_36468__$1 = (function (){var statearr_36477 = state_36468;
(statearr_36477[(9)] = inst_36461);

return statearr_36477;
})();
var statearr_36478_36542 = state_36468__$1;
(statearr_36478_36542[(2)] = null);

(statearr_36478_36542[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (6))){
var inst_36433 = (state_36468[(7)]);
var state_36468__$1 = state_36468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36468__$1,(11),inst_36433);
} else {
if((state_val_36469 === (17))){
var inst_36454 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
if(cljs.core.truth_(inst_36454)){
var statearr_36479_36543 = state_36468__$1;
(statearr_36479_36543[(1)] = (19));

} else {
var statearr_36480_36544 = state_36468__$1;
(statearr_36480_36544[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (3))){
var inst_36466 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36468__$1,inst_36466);
} else {
if((state_val_36469 === (12))){
var inst_36443 = (state_36468[(10)]);
var state_36468__$1 = state_36468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36468__$1,(14),inst_36443);
} else {
if((state_val_36469 === (2))){
var state_36468__$1 = state_36468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36468__$1,(4),results);
} else {
if((state_val_36469 === (19))){
var state_36468__$1 = state_36468;
var statearr_36481_36545 = state_36468__$1;
(statearr_36481_36545[(2)] = null);

(statearr_36481_36545[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (11))){
var inst_36443 = (state_36468[(2)]);
var state_36468__$1 = (function (){var statearr_36482 = state_36468;
(statearr_36482[(10)] = inst_36443);

return statearr_36482;
})();
var statearr_36483_36546 = state_36468__$1;
(statearr_36483_36546[(2)] = null);

(statearr_36483_36546[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (9))){
var state_36468__$1 = state_36468;
var statearr_36484_36547 = state_36468__$1;
(statearr_36484_36547[(2)] = null);

(statearr_36484_36547[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (5))){
var state_36468__$1 = state_36468;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36485_36548 = state_36468__$1;
(statearr_36485_36548[(1)] = (8));

} else {
var statearr_36486_36549 = state_36468__$1;
(statearr_36486_36549[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (14))){
var inst_36446 = (state_36468[(8)]);
var inst_36448 = (state_36468[(11)]);
var inst_36446__$1 = (state_36468[(2)]);
var inst_36447 = (inst_36446__$1 == null);
var inst_36448__$1 = cljs.core.not(inst_36447);
var state_36468__$1 = (function (){var statearr_36487 = state_36468;
(statearr_36487[(8)] = inst_36446__$1);

(statearr_36487[(11)] = inst_36448__$1);

return statearr_36487;
})();
if(inst_36448__$1){
var statearr_36488_36550 = state_36468__$1;
(statearr_36488_36550[(1)] = (15));

} else {
var statearr_36489_36551 = state_36468__$1;
(statearr_36489_36551[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (16))){
var inst_36448 = (state_36468[(11)]);
var state_36468__$1 = state_36468;
var statearr_36490_36552 = state_36468__$1;
(statearr_36490_36552[(2)] = inst_36448);

(statearr_36490_36552[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (10))){
var inst_36440 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
var statearr_36491_36553 = state_36468__$1;
(statearr_36491_36553[(2)] = inst_36440);

(statearr_36491_36553[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (18))){
var inst_36451 = (state_36468[(2)]);
var state_36468__$1 = state_36468;
var statearr_36492_36554 = state_36468__$1;
(statearr_36492_36554[(2)] = inst_36451);

(statearr_36492_36554[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36469 === (8))){
var inst_36437 = cljs.core.async.close_BANG_(to);
var state_36468__$1 = state_36468;
var statearr_36493_36555 = state_36468__$1;
(statearr_36493_36555[(2)] = inst_36437);

(statearr_36493_36555[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto__,jobs,results,process,async))
;
return ((function (switch__8335__auto__,c__8400__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_36497 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36497[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_36497[(1)] = (1));

return statearr_36497;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_36468){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_36468);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e36498){if((e36498 instanceof Object)){
var ex__8339__auto__ = e36498;
var statearr_36499_36556 = state_36468;
(statearr_36499_36556[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36468);

return cljs.core.cst$kw$recur;
} else {
throw e36498;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__36557 = state_36468;
state_36468 = G__36557;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_36468){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_36468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__,jobs,results,process,async))
})();
var state__8402__auto__ = (function (){var statearr_36500 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_36500[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_36500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto__,jobs,results,process,async))
);

return c__8400__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args36558 = [];
var len__5627__auto___36561 = arguments.length;
var i__5628__auto___36562 = (0);
while(true){
if((i__5628__auto___36562 < len__5627__auto___36561)){
args36558.push((arguments[i__5628__auto___36562]));

var G__36563 = (i__5628__auto___36562 + (1));
i__5628__auto___36562 = G__36563;
continue;
} else {
}
break;
}

var G__36560 = args36558.length;
switch (G__36560) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36558.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args36565 = [];
var len__5627__auto___36568 = arguments.length;
var i__5628__auto___36569 = (0);
while(true){
if((i__5628__auto___36569 < len__5627__auto___36568)){
args36565.push((arguments[i__5628__auto___36569]));

var G__36570 = (i__5628__auto___36569 + (1));
i__5628__auto___36569 = G__36570;
continue;
} else {
}
break;
}

var G__36567 = args36565.length;
switch (G__36567) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36565.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args36572 = [];
var len__5627__auto___36625 = arguments.length;
var i__5628__auto___36626 = (0);
while(true){
if((i__5628__auto___36626 < len__5627__auto___36625)){
args36572.push((arguments[i__5628__auto___36626]));

var G__36627 = (i__5628__auto___36626 + (1));
i__5628__auto___36626 = G__36627;
continue;
} else {
}
break;
}

var G__36574 = args36572.length;
switch (G__36574) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36572.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__8400__auto___36629 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___36629,tc,fc){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___36629,tc,fc){
return (function (state_36600){
var state_val_36601 = (state_36600[(1)]);
if((state_val_36601 === (7))){
var inst_36596 = (state_36600[(2)]);
var state_36600__$1 = state_36600;
var statearr_36602_36630 = state_36600__$1;
(statearr_36602_36630[(2)] = inst_36596);

(statearr_36602_36630[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (1))){
var state_36600__$1 = state_36600;
var statearr_36603_36631 = state_36600__$1;
(statearr_36603_36631[(2)] = null);

(statearr_36603_36631[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (4))){
var inst_36577 = (state_36600[(7)]);
var inst_36577__$1 = (state_36600[(2)]);
var inst_36578 = (inst_36577__$1 == null);
var state_36600__$1 = (function (){var statearr_36604 = state_36600;
(statearr_36604[(7)] = inst_36577__$1);

return statearr_36604;
})();
if(cljs.core.truth_(inst_36578)){
var statearr_36605_36632 = state_36600__$1;
(statearr_36605_36632[(1)] = (5));

} else {
var statearr_36606_36633 = state_36600__$1;
(statearr_36606_36633[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (13))){
var state_36600__$1 = state_36600;
var statearr_36607_36634 = state_36600__$1;
(statearr_36607_36634[(2)] = null);

(statearr_36607_36634[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (6))){
var inst_36577 = (state_36600[(7)]);
var inst_36583 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_36577) : p.call(null,inst_36577));
var state_36600__$1 = state_36600;
if(cljs.core.truth_(inst_36583)){
var statearr_36608_36635 = state_36600__$1;
(statearr_36608_36635[(1)] = (9));

} else {
var statearr_36609_36636 = state_36600__$1;
(statearr_36609_36636[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (3))){
var inst_36598 = (state_36600[(2)]);
var state_36600__$1 = state_36600;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36600__$1,inst_36598);
} else {
if((state_val_36601 === (12))){
var state_36600__$1 = state_36600;
var statearr_36610_36637 = state_36600__$1;
(statearr_36610_36637[(2)] = null);

(statearr_36610_36637[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (2))){
var state_36600__$1 = state_36600;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36600__$1,(4),ch);
} else {
if((state_val_36601 === (11))){
var inst_36577 = (state_36600[(7)]);
var inst_36587 = (state_36600[(2)]);
var state_36600__$1 = state_36600;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36600__$1,(8),inst_36587,inst_36577);
} else {
if((state_val_36601 === (9))){
var state_36600__$1 = state_36600;
var statearr_36611_36638 = state_36600__$1;
(statearr_36611_36638[(2)] = tc);

(statearr_36611_36638[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (5))){
var inst_36580 = cljs.core.async.close_BANG_(tc);
var inst_36581 = cljs.core.async.close_BANG_(fc);
var state_36600__$1 = (function (){var statearr_36612 = state_36600;
(statearr_36612[(8)] = inst_36580);

return statearr_36612;
})();
var statearr_36613_36639 = state_36600__$1;
(statearr_36613_36639[(2)] = inst_36581);

(statearr_36613_36639[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (14))){
var inst_36594 = (state_36600[(2)]);
var state_36600__$1 = state_36600;
var statearr_36614_36640 = state_36600__$1;
(statearr_36614_36640[(2)] = inst_36594);

(statearr_36614_36640[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (10))){
var state_36600__$1 = state_36600;
var statearr_36615_36641 = state_36600__$1;
(statearr_36615_36641[(2)] = fc);

(statearr_36615_36641[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36601 === (8))){
var inst_36589 = (state_36600[(2)]);
var state_36600__$1 = state_36600;
if(cljs.core.truth_(inst_36589)){
var statearr_36616_36642 = state_36600__$1;
(statearr_36616_36642[(1)] = (12));

} else {
var statearr_36617_36643 = state_36600__$1;
(statearr_36617_36643[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___36629,tc,fc))
;
return ((function (switch__8335__auto__,c__8400__auto___36629,tc,fc){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_36621 = [null,null,null,null,null,null,null,null,null];
(statearr_36621[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_36621[(1)] = (1));

return statearr_36621;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_36600){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_36600);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e36622){if((e36622 instanceof Object)){
var ex__8339__auto__ = e36622;
var statearr_36623_36644 = state_36600;
(statearr_36623_36644[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36600);

return cljs.core.cst$kw$recur;
} else {
throw e36622;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__36645 = state_36600;
state_36600 = G__36645;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_36600){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_36600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___36629,tc,fc))
})();
var state__8402__auto__ = (function (){var statearr_36624 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_36624[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___36629);

return statearr_36624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___36629,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8400__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto__){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__){
return (function (state_36692){
var state_val_36693 = (state_36692[(1)]);
if((state_val_36693 === (1))){
var inst_36678 = init;
var state_36692__$1 = (function (){var statearr_36694 = state_36692;
(statearr_36694[(7)] = inst_36678);

return statearr_36694;
})();
var statearr_36695_36710 = state_36692__$1;
(statearr_36695_36710[(2)] = null);

(statearr_36695_36710[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36693 === (2))){
var state_36692__$1 = state_36692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36692__$1,(4),ch);
} else {
if((state_val_36693 === (3))){
var inst_36690 = (state_36692[(2)]);
var state_36692__$1 = state_36692;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36692__$1,inst_36690);
} else {
if((state_val_36693 === (4))){
var inst_36681 = (state_36692[(8)]);
var inst_36681__$1 = (state_36692[(2)]);
var inst_36682 = (inst_36681__$1 == null);
var state_36692__$1 = (function (){var statearr_36696 = state_36692;
(statearr_36696[(8)] = inst_36681__$1);

return statearr_36696;
})();
if(cljs.core.truth_(inst_36682)){
var statearr_36697_36711 = state_36692__$1;
(statearr_36697_36711[(1)] = (5));

} else {
var statearr_36698_36712 = state_36692__$1;
(statearr_36698_36712[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36693 === (5))){
var inst_36678 = (state_36692[(7)]);
var state_36692__$1 = state_36692;
var statearr_36699_36713 = state_36692__$1;
(statearr_36699_36713[(2)] = inst_36678);

(statearr_36699_36713[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36693 === (6))){
var inst_36681 = (state_36692[(8)]);
var inst_36678 = (state_36692[(7)]);
var inst_36685 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_36678,inst_36681) : f.call(null,inst_36678,inst_36681));
var inst_36678__$1 = inst_36685;
var state_36692__$1 = (function (){var statearr_36700 = state_36692;
(statearr_36700[(7)] = inst_36678__$1);

return statearr_36700;
})();
var statearr_36701_36714 = state_36692__$1;
(statearr_36701_36714[(2)] = null);

(statearr_36701_36714[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36693 === (7))){
var inst_36688 = (state_36692[(2)]);
var state_36692__$1 = state_36692;
var statearr_36702_36715 = state_36692__$1;
(statearr_36702_36715[(2)] = inst_36688);

(statearr_36702_36715[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__8400__auto__))
;
return ((function (switch__8335__auto__,c__8400__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8336__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8336__auto____0 = (function (){
var statearr_36706 = [null,null,null,null,null,null,null,null,null];
(statearr_36706[(0)] = cljs$core$async$reduce_$_state_machine__8336__auto__);

(statearr_36706[(1)] = (1));

return statearr_36706;
});
var cljs$core$async$reduce_$_state_machine__8336__auto____1 = (function (state_36692){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_36692);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e36707){if((e36707 instanceof Object)){
var ex__8339__auto__ = e36707;
var statearr_36708_36716 = state_36692;
(statearr_36708_36716[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36692);

return cljs.core.cst$kw$recur;
} else {
throw e36707;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__36717 = state_36692;
state_36692 = G__36717;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8336__auto__ = function(state_36692){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8336__auto____1.call(this,state_36692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8336__auto____0;
cljs$core$async$reduce_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8336__auto____1;
return cljs$core$async$reduce_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__))
})();
var state__8402__auto__ = (function (){var statearr_36709 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_36709[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_36709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto__))
);

return c__8400__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args36718 = [];
var len__5627__auto___36770 = arguments.length;
var i__5628__auto___36771 = (0);
while(true){
if((i__5628__auto___36771 < len__5627__auto___36770)){
args36718.push((arguments[i__5628__auto___36771]));

var G__36772 = (i__5628__auto___36771 + (1));
i__5628__auto___36771 = G__36772;
continue;
} else {
}
break;
}

var G__36720 = args36718.length;
switch (G__36720) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36718.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8400__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto__){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__){
return (function (state_36745){
var state_val_36746 = (state_36745[(1)]);
if((state_val_36746 === (7))){
var inst_36727 = (state_36745[(2)]);
var state_36745__$1 = state_36745;
var statearr_36747_36774 = state_36745__$1;
(statearr_36747_36774[(2)] = inst_36727);

(statearr_36747_36774[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36746 === (1))){
var inst_36721 = cljs.core.seq(coll);
var inst_36722 = inst_36721;
var state_36745__$1 = (function (){var statearr_36748 = state_36745;
(statearr_36748[(7)] = inst_36722);

return statearr_36748;
})();
var statearr_36749_36775 = state_36745__$1;
(statearr_36749_36775[(2)] = null);

(statearr_36749_36775[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36746 === (4))){
var inst_36722 = (state_36745[(7)]);
var inst_36725 = cljs.core.first(inst_36722);
var state_36745__$1 = state_36745;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36745__$1,(7),ch,inst_36725);
} else {
if((state_val_36746 === (13))){
var inst_36739 = (state_36745[(2)]);
var state_36745__$1 = state_36745;
var statearr_36750_36776 = state_36745__$1;
(statearr_36750_36776[(2)] = inst_36739);

(statearr_36750_36776[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36746 === (6))){
var inst_36730 = (state_36745[(2)]);
var state_36745__$1 = state_36745;
if(cljs.core.truth_(inst_36730)){
var statearr_36751_36777 = state_36745__$1;
(statearr_36751_36777[(1)] = (8));

} else {
var statearr_36752_36778 = state_36745__$1;
(statearr_36752_36778[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36746 === (3))){
var inst_36743 = (state_36745[(2)]);
var state_36745__$1 = state_36745;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36745__$1,inst_36743);
} else {
if((state_val_36746 === (12))){
var state_36745__$1 = state_36745;
var statearr_36753_36779 = state_36745__$1;
(statearr_36753_36779[(2)] = null);

(statearr_36753_36779[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36746 === (2))){
var inst_36722 = (state_36745[(7)]);
var state_36745__$1 = state_36745;
if(cljs.core.truth_(inst_36722)){
var statearr_36754_36780 = state_36745__$1;
(statearr_36754_36780[(1)] = (4));

} else {
var statearr_36755_36781 = state_36745__$1;
(statearr_36755_36781[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36746 === (11))){
var inst_36736 = cljs.core.async.close_BANG_(ch);
var state_36745__$1 = state_36745;
var statearr_36756_36782 = state_36745__$1;
(statearr_36756_36782[(2)] = inst_36736);

(statearr_36756_36782[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36746 === (9))){
var state_36745__$1 = state_36745;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36757_36783 = state_36745__$1;
(statearr_36757_36783[(1)] = (11));

} else {
var statearr_36758_36784 = state_36745__$1;
(statearr_36758_36784[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36746 === (5))){
var inst_36722 = (state_36745[(7)]);
var state_36745__$1 = state_36745;
var statearr_36759_36785 = state_36745__$1;
(statearr_36759_36785[(2)] = inst_36722);

(statearr_36759_36785[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36746 === (10))){
var inst_36741 = (state_36745[(2)]);
var state_36745__$1 = state_36745;
var statearr_36760_36786 = state_36745__$1;
(statearr_36760_36786[(2)] = inst_36741);

(statearr_36760_36786[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36746 === (8))){
var inst_36722 = (state_36745[(7)]);
var inst_36732 = cljs.core.next(inst_36722);
var inst_36722__$1 = inst_36732;
var state_36745__$1 = (function (){var statearr_36761 = state_36745;
(statearr_36761[(7)] = inst_36722__$1);

return statearr_36761;
})();
var statearr_36762_36787 = state_36745__$1;
(statearr_36762_36787[(2)] = null);

(statearr_36762_36787[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto__))
;
return ((function (switch__8335__auto__,c__8400__auto__){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_36766 = [null,null,null,null,null,null,null,null];
(statearr_36766[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_36766[(1)] = (1));

return statearr_36766;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_36745){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_36745);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e36767){if((e36767 instanceof Object)){
var ex__8339__auto__ = e36767;
var statearr_36768_36788 = state_36745;
(statearr_36768_36788[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36745);

return cljs.core.cst$kw$recur;
} else {
throw e36767;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__36789 = state_36745;
state_36745 = G__36789;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_36745){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_36745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__))
})();
var state__8402__auto__ = (function (){var statearr_36769 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_36769[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_36769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto__))
);

return c__8400__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5224__auto__ = (((_ == null))?null:_);
var m__5225__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5225__auto__.call(null,_));
} else {
var m__5225__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__5225__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5225__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5225__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5225__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto__.call(null,m));
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__37014 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__37014) : cljs.core.atom.call(null,G__37014));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async37015 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37015 = (function (mult,ch,cs,meta37016){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta37016 = meta37016;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37015.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_37017,meta37016__$1){
var self__ = this;
var _37017__$1 = this;
return (new cljs.core.async.t_cljs$core$async37015(self__.mult,self__.ch,self__.cs,meta37016__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async37015.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_37017){
var self__ = this;
var _37017__$1 = this;
return self__.meta37016;
});})(cs))
;

cljs.core.async.t_cljs$core$async37015.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async37015.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async37015.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async37015.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37015.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37015.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__37018_37238 = self__.cs;
var G__37019_37239 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__37018_37238,G__37019_37239) : cljs.core.reset_BANG_.call(null,G__37018_37238,G__37019_37239));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37015.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta37016], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async37015.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37015.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37015";

cljs.core.async.t_cljs$core$async37015.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async37015");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async37015 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async37015(mult__$1,ch__$1,cs__$1,meta37016){
return (new cljs.core.async.t_cljs$core$async37015(mult__$1,ch__$1,cs__$1,meta37016));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async37015(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8400__auto___37240 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___37240,cs,m,dchan,dctr,done){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___37240,cs,m,dchan,dctr,done){
return (function (state_37150){
var state_val_37151 = (state_37150[(1)]);
if((state_val_37151 === (7))){
var inst_37146 = (state_37150[(2)]);
var state_37150__$1 = state_37150;
var statearr_37152_37241 = state_37150__$1;
(statearr_37152_37241[(2)] = inst_37146);

(statearr_37152_37241[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (20))){
var inst_37051 = (state_37150[(7)]);
var inst_37061 = cljs.core.first(inst_37051);
var inst_37062 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37061,(0),null);
var inst_37063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37061,(1),null);
var state_37150__$1 = (function (){var statearr_37153 = state_37150;
(statearr_37153[(8)] = inst_37062);

return statearr_37153;
})();
if(cljs.core.truth_(inst_37063)){
var statearr_37154_37242 = state_37150__$1;
(statearr_37154_37242[(1)] = (22));

} else {
var statearr_37155_37243 = state_37150__$1;
(statearr_37155_37243[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (27))){
var inst_37093 = (state_37150[(9)]);
var inst_37022 = (state_37150[(10)]);
var inst_37091 = (state_37150[(11)]);
var inst_37098 = (state_37150[(12)]);
var inst_37098__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37091,inst_37093);
var inst_37099 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37098__$1,inst_37022,done);
var state_37150__$1 = (function (){var statearr_37156 = state_37150;
(statearr_37156[(12)] = inst_37098__$1);

return statearr_37156;
})();
if(cljs.core.truth_(inst_37099)){
var statearr_37157_37244 = state_37150__$1;
(statearr_37157_37244[(1)] = (30));

} else {
var statearr_37158_37245 = state_37150__$1;
(statearr_37158_37245[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (1))){
var state_37150__$1 = state_37150;
var statearr_37159_37246 = state_37150__$1;
(statearr_37159_37246[(2)] = null);

(statearr_37159_37246[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (24))){
var inst_37051 = (state_37150[(7)]);
var inst_37068 = (state_37150[(2)]);
var inst_37069 = cljs.core.next(inst_37051);
var inst_37031 = inst_37069;
var inst_37032 = null;
var inst_37033 = (0);
var inst_37034 = (0);
var state_37150__$1 = (function (){var statearr_37160 = state_37150;
(statearr_37160[(13)] = inst_37068);

(statearr_37160[(14)] = inst_37034);

(statearr_37160[(15)] = inst_37032);

(statearr_37160[(16)] = inst_37031);

(statearr_37160[(17)] = inst_37033);

return statearr_37160;
})();
var statearr_37161_37247 = state_37150__$1;
(statearr_37161_37247[(2)] = null);

(statearr_37161_37247[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (39))){
var state_37150__$1 = state_37150;
var statearr_37165_37248 = state_37150__$1;
(statearr_37165_37248[(2)] = null);

(statearr_37165_37248[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (4))){
var inst_37022 = (state_37150[(10)]);
var inst_37022__$1 = (state_37150[(2)]);
var inst_37023 = (inst_37022__$1 == null);
var state_37150__$1 = (function (){var statearr_37166 = state_37150;
(statearr_37166[(10)] = inst_37022__$1);

return statearr_37166;
})();
if(cljs.core.truth_(inst_37023)){
var statearr_37167_37249 = state_37150__$1;
(statearr_37167_37249[(1)] = (5));

} else {
var statearr_37168_37250 = state_37150__$1;
(statearr_37168_37250[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (15))){
var inst_37034 = (state_37150[(14)]);
var inst_37032 = (state_37150[(15)]);
var inst_37031 = (state_37150[(16)]);
var inst_37033 = (state_37150[(17)]);
var inst_37047 = (state_37150[(2)]);
var inst_37048 = (inst_37034 + (1));
var tmp37162 = inst_37032;
var tmp37163 = inst_37031;
var tmp37164 = inst_37033;
var inst_37031__$1 = tmp37163;
var inst_37032__$1 = tmp37162;
var inst_37033__$1 = tmp37164;
var inst_37034__$1 = inst_37048;
var state_37150__$1 = (function (){var statearr_37169 = state_37150;
(statearr_37169[(14)] = inst_37034__$1);

(statearr_37169[(18)] = inst_37047);

(statearr_37169[(15)] = inst_37032__$1);

(statearr_37169[(16)] = inst_37031__$1);

(statearr_37169[(17)] = inst_37033__$1);

return statearr_37169;
})();
var statearr_37170_37251 = state_37150__$1;
(statearr_37170_37251[(2)] = null);

(statearr_37170_37251[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (21))){
var inst_37072 = (state_37150[(2)]);
var state_37150__$1 = state_37150;
var statearr_37174_37252 = state_37150__$1;
(statearr_37174_37252[(2)] = inst_37072);

(statearr_37174_37252[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (31))){
var inst_37098 = (state_37150[(12)]);
var inst_37102 = done(null);
var inst_37103 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37098);
var state_37150__$1 = (function (){var statearr_37175 = state_37150;
(statearr_37175[(19)] = inst_37102);

return statearr_37175;
})();
var statearr_37176_37253 = state_37150__$1;
(statearr_37176_37253[(2)] = inst_37103);

(statearr_37176_37253[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (32))){
var inst_37090 = (state_37150[(20)]);
var inst_37093 = (state_37150[(9)]);
var inst_37091 = (state_37150[(11)]);
var inst_37092 = (state_37150[(21)]);
var inst_37105 = (state_37150[(2)]);
var inst_37106 = (inst_37093 + (1));
var tmp37171 = inst_37090;
var tmp37172 = inst_37091;
var tmp37173 = inst_37092;
var inst_37090__$1 = tmp37171;
var inst_37091__$1 = tmp37172;
var inst_37092__$1 = tmp37173;
var inst_37093__$1 = inst_37106;
var state_37150__$1 = (function (){var statearr_37177 = state_37150;
(statearr_37177[(20)] = inst_37090__$1);

(statearr_37177[(9)] = inst_37093__$1);

(statearr_37177[(11)] = inst_37091__$1);

(statearr_37177[(22)] = inst_37105);

(statearr_37177[(21)] = inst_37092__$1);

return statearr_37177;
})();
var statearr_37178_37254 = state_37150__$1;
(statearr_37178_37254[(2)] = null);

(statearr_37178_37254[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (40))){
var inst_37118 = (state_37150[(23)]);
var inst_37122 = done(null);
var inst_37123 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37118);
var state_37150__$1 = (function (){var statearr_37179 = state_37150;
(statearr_37179[(24)] = inst_37122);

return statearr_37179;
})();
var statearr_37180_37255 = state_37150__$1;
(statearr_37180_37255[(2)] = inst_37123);

(statearr_37180_37255[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (33))){
var inst_37109 = (state_37150[(25)]);
var inst_37111 = cljs.core.chunked_seq_QMARK_(inst_37109);
var state_37150__$1 = state_37150;
if(inst_37111){
var statearr_37181_37256 = state_37150__$1;
(statearr_37181_37256[(1)] = (36));

} else {
var statearr_37182_37257 = state_37150__$1;
(statearr_37182_37257[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (13))){
var inst_37041 = (state_37150[(26)]);
var inst_37044 = cljs.core.async.close_BANG_(inst_37041);
var state_37150__$1 = state_37150;
var statearr_37183_37258 = state_37150__$1;
(statearr_37183_37258[(2)] = inst_37044);

(statearr_37183_37258[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (22))){
var inst_37062 = (state_37150[(8)]);
var inst_37065 = cljs.core.async.close_BANG_(inst_37062);
var state_37150__$1 = state_37150;
var statearr_37184_37259 = state_37150__$1;
(statearr_37184_37259[(2)] = inst_37065);

(statearr_37184_37259[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (36))){
var inst_37109 = (state_37150[(25)]);
var inst_37113 = cljs.core.chunk_first(inst_37109);
var inst_37114 = cljs.core.chunk_rest(inst_37109);
var inst_37115 = cljs.core.count(inst_37113);
var inst_37090 = inst_37114;
var inst_37091 = inst_37113;
var inst_37092 = inst_37115;
var inst_37093 = (0);
var state_37150__$1 = (function (){var statearr_37185 = state_37150;
(statearr_37185[(20)] = inst_37090);

(statearr_37185[(9)] = inst_37093);

(statearr_37185[(11)] = inst_37091);

(statearr_37185[(21)] = inst_37092);

return statearr_37185;
})();
var statearr_37186_37260 = state_37150__$1;
(statearr_37186_37260[(2)] = null);

(statearr_37186_37260[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (41))){
var inst_37109 = (state_37150[(25)]);
var inst_37125 = (state_37150[(2)]);
var inst_37126 = cljs.core.next(inst_37109);
var inst_37090 = inst_37126;
var inst_37091 = null;
var inst_37092 = (0);
var inst_37093 = (0);
var state_37150__$1 = (function (){var statearr_37187 = state_37150;
(statearr_37187[(20)] = inst_37090);

(statearr_37187[(27)] = inst_37125);

(statearr_37187[(9)] = inst_37093);

(statearr_37187[(11)] = inst_37091);

(statearr_37187[(21)] = inst_37092);

return statearr_37187;
})();
var statearr_37188_37261 = state_37150__$1;
(statearr_37188_37261[(2)] = null);

(statearr_37188_37261[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (43))){
var state_37150__$1 = state_37150;
var statearr_37189_37262 = state_37150__$1;
(statearr_37189_37262[(2)] = null);

(statearr_37189_37262[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (29))){
var inst_37134 = (state_37150[(2)]);
var state_37150__$1 = state_37150;
var statearr_37190_37263 = state_37150__$1;
(statearr_37190_37263[(2)] = inst_37134);

(statearr_37190_37263[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (44))){
var inst_37143 = (state_37150[(2)]);
var state_37150__$1 = (function (){var statearr_37191 = state_37150;
(statearr_37191[(28)] = inst_37143);

return statearr_37191;
})();
var statearr_37192_37264 = state_37150__$1;
(statearr_37192_37264[(2)] = null);

(statearr_37192_37264[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (6))){
var inst_37082 = (state_37150[(29)]);
var inst_37081 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_37082__$1 = cljs.core.keys(inst_37081);
var inst_37083 = cljs.core.count(inst_37082__$1);
var inst_37084 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_37083) : cljs.core.reset_BANG_.call(null,dctr,inst_37083));
var inst_37089 = cljs.core.seq(inst_37082__$1);
var inst_37090 = inst_37089;
var inst_37091 = null;
var inst_37092 = (0);
var inst_37093 = (0);
var state_37150__$1 = (function (){var statearr_37193 = state_37150;
(statearr_37193[(20)] = inst_37090);

(statearr_37193[(29)] = inst_37082__$1);

(statearr_37193[(9)] = inst_37093);

(statearr_37193[(11)] = inst_37091);

(statearr_37193[(21)] = inst_37092);

(statearr_37193[(30)] = inst_37084);

return statearr_37193;
})();
var statearr_37194_37265 = state_37150__$1;
(statearr_37194_37265[(2)] = null);

(statearr_37194_37265[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (28))){
var inst_37090 = (state_37150[(20)]);
var inst_37109 = (state_37150[(25)]);
var inst_37109__$1 = cljs.core.seq(inst_37090);
var state_37150__$1 = (function (){var statearr_37195 = state_37150;
(statearr_37195[(25)] = inst_37109__$1);

return statearr_37195;
})();
if(inst_37109__$1){
var statearr_37196_37266 = state_37150__$1;
(statearr_37196_37266[(1)] = (33));

} else {
var statearr_37197_37267 = state_37150__$1;
(statearr_37197_37267[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (25))){
var inst_37093 = (state_37150[(9)]);
var inst_37092 = (state_37150[(21)]);
var inst_37095 = (inst_37093 < inst_37092);
var inst_37096 = inst_37095;
var state_37150__$1 = state_37150;
if(cljs.core.truth_(inst_37096)){
var statearr_37198_37268 = state_37150__$1;
(statearr_37198_37268[(1)] = (27));

} else {
var statearr_37199_37269 = state_37150__$1;
(statearr_37199_37269[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (34))){
var state_37150__$1 = state_37150;
var statearr_37200_37270 = state_37150__$1;
(statearr_37200_37270[(2)] = null);

(statearr_37200_37270[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (17))){
var state_37150__$1 = state_37150;
var statearr_37201_37271 = state_37150__$1;
(statearr_37201_37271[(2)] = null);

(statearr_37201_37271[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (3))){
var inst_37148 = (state_37150[(2)]);
var state_37150__$1 = state_37150;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37150__$1,inst_37148);
} else {
if((state_val_37151 === (12))){
var inst_37077 = (state_37150[(2)]);
var state_37150__$1 = state_37150;
var statearr_37202_37272 = state_37150__$1;
(statearr_37202_37272[(2)] = inst_37077);

(statearr_37202_37272[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (2))){
var state_37150__$1 = state_37150;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37150__$1,(4),ch);
} else {
if((state_val_37151 === (23))){
var state_37150__$1 = state_37150;
var statearr_37203_37273 = state_37150__$1;
(statearr_37203_37273[(2)] = null);

(statearr_37203_37273[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (35))){
var inst_37132 = (state_37150[(2)]);
var state_37150__$1 = state_37150;
var statearr_37204_37274 = state_37150__$1;
(statearr_37204_37274[(2)] = inst_37132);

(statearr_37204_37274[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (19))){
var inst_37051 = (state_37150[(7)]);
var inst_37055 = cljs.core.chunk_first(inst_37051);
var inst_37056 = cljs.core.chunk_rest(inst_37051);
var inst_37057 = cljs.core.count(inst_37055);
var inst_37031 = inst_37056;
var inst_37032 = inst_37055;
var inst_37033 = inst_37057;
var inst_37034 = (0);
var state_37150__$1 = (function (){var statearr_37205 = state_37150;
(statearr_37205[(14)] = inst_37034);

(statearr_37205[(15)] = inst_37032);

(statearr_37205[(16)] = inst_37031);

(statearr_37205[(17)] = inst_37033);

return statearr_37205;
})();
var statearr_37206_37275 = state_37150__$1;
(statearr_37206_37275[(2)] = null);

(statearr_37206_37275[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (11))){
var inst_37051 = (state_37150[(7)]);
var inst_37031 = (state_37150[(16)]);
var inst_37051__$1 = cljs.core.seq(inst_37031);
var state_37150__$1 = (function (){var statearr_37207 = state_37150;
(statearr_37207[(7)] = inst_37051__$1);

return statearr_37207;
})();
if(inst_37051__$1){
var statearr_37208_37276 = state_37150__$1;
(statearr_37208_37276[(1)] = (16));

} else {
var statearr_37209_37277 = state_37150__$1;
(statearr_37209_37277[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (9))){
var inst_37079 = (state_37150[(2)]);
var state_37150__$1 = state_37150;
var statearr_37210_37278 = state_37150__$1;
(statearr_37210_37278[(2)] = inst_37079);

(statearr_37210_37278[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (5))){
var inst_37029 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_37030 = cljs.core.seq(inst_37029);
var inst_37031 = inst_37030;
var inst_37032 = null;
var inst_37033 = (0);
var inst_37034 = (0);
var state_37150__$1 = (function (){var statearr_37211 = state_37150;
(statearr_37211[(14)] = inst_37034);

(statearr_37211[(15)] = inst_37032);

(statearr_37211[(16)] = inst_37031);

(statearr_37211[(17)] = inst_37033);

return statearr_37211;
})();
var statearr_37212_37279 = state_37150__$1;
(statearr_37212_37279[(2)] = null);

(statearr_37212_37279[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (14))){
var state_37150__$1 = state_37150;
var statearr_37213_37280 = state_37150__$1;
(statearr_37213_37280[(2)] = null);

(statearr_37213_37280[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (45))){
var inst_37140 = (state_37150[(2)]);
var state_37150__$1 = state_37150;
var statearr_37214_37281 = state_37150__$1;
(statearr_37214_37281[(2)] = inst_37140);

(statearr_37214_37281[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (26))){
var inst_37082 = (state_37150[(29)]);
var inst_37136 = (state_37150[(2)]);
var inst_37137 = cljs.core.seq(inst_37082);
var state_37150__$1 = (function (){var statearr_37215 = state_37150;
(statearr_37215[(31)] = inst_37136);

return statearr_37215;
})();
if(inst_37137){
var statearr_37216_37282 = state_37150__$1;
(statearr_37216_37282[(1)] = (42));

} else {
var statearr_37217_37283 = state_37150__$1;
(statearr_37217_37283[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (16))){
var inst_37051 = (state_37150[(7)]);
var inst_37053 = cljs.core.chunked_seq_QMARK_(inst_37051);
var state_37150__$1 = state_37150;
if(inst_37053){
var statearr_37218_37284 = state_37150__$1;
(statearr_37218_37284[(1)] = (19));

} else {
var statearr_37219_37285 = state_37150__$1;
(statearr_37219_37285[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (38))){
var inst_37129 = (state_37150[(2)]);
var state_37150__$1 = state_37150;
var statearr_37220_37286 = state_37150__$1;
(statearr_37220_37286[(2)] = inst_37129);

(statearr_37220_37286[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (30))){
var state_37150__$1 = state_37150;
var statearr_37221_37287 = state_37150__$1;
(statearr_37221_37287[(2)] = null);

(statearr_37221_37287[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (10))){
var inst_37034 = (state_37150[(14)]);
var inst_37032 = (state_37150[(15)]);
var inst_37040 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37032,inst_37034);
var inst_37041 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37040,(0),null);
var inst_37042 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37040,(1),null);
var state_37150__$1 = (function (){var statearr_37222 = state_37150;
(statearr_37222[(26)] = inst_37041);

return statearr_37222;
})();
if(cljs.core.truth_(inst_37042)){
var statearr_37223_37288 = state_37150__$1;
(statearr_37223_37288[(1)] = (13));

} else {
var statearr_37224_37289 = state_37150__$1;
(statearr_37224_37289[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (18))){
var inst_37075 = (state_37150[(2)]);
var state_37150__$1 = state_37150;
var statearr_37225_37290 = state_37150__$1;
(statearr_37225_37290[(2)] = inst_37075);

(statearr_37225_37290[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (42))){
var state_37150__$1 = state_37150;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37150__$1,(45),dchan);
} else {
if((state_val_37151 === (37))){
var inst_37118 = (state_37150[(23)]);
var inst_37022 = (state_37150[(10)]);
var inst_37109 = (state_37150[(25)]);
var inst_37118__$1 = cljs.core.first(inst_37109);
var inst_37119 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37118__$1,inst_37022,done);
var state_37150__$1 = (function (){var statearr_37226 = state_37150;
(statearr_37226[(23)] = inst_37118__$1);

return statearr_37226;
})();
if(cljs.core.truth_(inst_37119)){
var statearr_37227_37291 = state_37150__$1;
(statearr_37227_37291[(1)] = (39));

} else {
var statearr_37228_37292 = state_37150__$1;
(statearr_37228_37292[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37151 === (8))){
var inst_37034 = (state_37150[(14)]);
var inst_37033 = (state_37150[(17)]);
var inst_37036 = (inst_37034 < inst_37033);
var inst_37037 = inst_37036;
var state_37150__$1 = state_37150;
if(cljs.core.truth_(inst_37037)){
var statearr_37229_37293 = state_37150__$1;
(statearr_37229_37293[(1)] = (10));

} else {
var statearr_37230_37294 = state_37150__$1;
(statearr_37230_37294[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___37240,cs,m,dchan,dctr,done))
;
return ((function (switch__8335__auto__,c__8400__auto___37240,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8336__auto__ = null;
var cljs$core$async$mult_$_state_machine__8336__auto____0 = (function (){
var statearr_37234 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37234[(0)] = cljs$core$async$mult_$_state_machine__8336__auto__);

(statearr_37234[(1)] = (1));

return statearr_37234;
});
var cljs$core$async$mult_$_state_machine__8336__auto____1 = (function (state_37150){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_37150);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e37235){if((e37235 instanceof Object)){
var ex__8339__auto__ = e37235;
var statearr_37236_37295 = state_37150;
(statearr_37236_37295[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37150);

return cljs.core.cst$kw$recur;
} else {
throw e37235;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__37296 = state_37150;
state_37150 = G__37296;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8336__auto__ = function(state_37150){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8336__auto____1.call(this,state_37150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8336__auto____0;
cljs$core$async$mult_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8336__auto____1;
return cljs$core$async$mult_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___37240,cs,m,dchan,dctr,done))
})();
var state__8402__auto__ = (function (){var statearr_37237 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_37237[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___37240);

return statearr_37237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___37240,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args37297 = [];
var len__5627__auto___37300 = arguments.length;
var i__5628__auto___37301 = (0);
while(true){
if((i__5628__auto___37301 < len__5627__auto___37300)){
args37297.push((arguments[i__5628__auto___37301]));

var G__37302 = (i__5628__auto___37301 + (1));
i__5628__auto___37301 = G__37302;
continue;
} else {
}
break;
}

var G__37299 = args37297.length;
switch (G__37299) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37297.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto__.call(null,m));
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5225__auto__.call(null,m,state_map));
} else {
var m__5225__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5225__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5225__auto__.call(null,m,mode));
} else {
var m__5225__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5225__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___37314 = arguments.length;
var i__5628__auto___37315 = (0);
while(true){
if((i__5628__auto___37315 < len__5627__auto___37314)){
args__5634__auto__.push((arguments[i__5628__auto___37315]));

var G__37316 = (i__5628__auto___37315 + (1));
i__5628__auto___37315 = G__37316;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__37308){
var map__37309 = p__37308;
var map__37309__$1 = ((((!((map__37309 == null)))?((((map__37309.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37309.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37309):map__37309);
var opts = map__37309__$1;
var statearr_37311_37317 = state;
(statearr_37311_37317[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts(((function (map__37309,map__37309__$1,opts){
return (function (val){
var statearr_37312_37318 = state;
(statearr_37312_37318[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__37309,map__37309__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_37313_37319 = state;
(statearr_37313_37319[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq37304){
var G__37305 = cljs.core.first(seq37304);
var seq37304__$1 = cljs.core.next(seq37304);
var G__37306 = cljs.core.first(seq37304__$1);
var seq37304__$2 = cljs.core.next(seq37304__$1);
var G__37307 = cljs.core.first(seq37304__$2);
var seq37304__$3 = cljs.core.next(seq37304__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__37305,G__37306,G__37307,seq37304__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__37486 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__37486) : cljs.core.atom.call(null,G__37486));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute) : cljs.core.atom.call(null,cljs.core.cst$kw$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async37487 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37487 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta37488){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta37488 = meta37488;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37487.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37489,meta37488__$1){
var self__ = this;
var _37489__$1 = this;
return (new cljs.core.async.t_cljs$core$async37487(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta37488__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37487.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37489){
var self__ = this;
var _37489__$1 = this;
return self__.meta37488;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37487.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async37487.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37487.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async37487.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37487.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37487.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__37490_37652 = self__.cs;
var G__37491_37653 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__37490_37652,G__37491_37653) : cljs.core.reset_BANG_.call(null,G__37490_37652,G__37491_37653));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37487.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37487.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$mode)], 0)))].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37487.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta37488], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37487.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37487.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37487";

cljs.core.async.t_cljs$core$async37487.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async37487");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async37487 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async37487(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta37488){
return (new cljs.core.async.t_cljs$core$async37487(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta37488));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async37487(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8400__auto___37654 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___37654,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___37654,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_37589){
var state_val_37590 = (state_37589[(1)]);
if((state_val_37590 === (7))){
var inst_37507 = (state_37589[(2)]);
var state_37589__$1 = state_37589;
var statearr_37591_37655 = state_37589__$1;
(statearr_37591_37655[(2)] = inst_37507);

(statearr_37591_37655[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (20))){
var inst_37519 = (state_37589[(7)]);
var state_37589__$1 = state_37589;
var statearr_37592_37656 = state_37589__$1;
(statearr_37592_37656[(2)] = inst_37519);

(statearr_37592_37656[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (27))){
var state_37589__$1 = state_37589;
var statearr_37593_37657 = state_37589__$1;
(statearr_37593_37657[(2)] = null);

(statearr_37593_37657[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (1))){
var inst_37495 = (state_37589[(8)]);
var inst_37495__$1 = calc_state();
var inst_37497 = (inst_37495__$1 == null);
var inst_37498 = cljs.core.not(inst_37497);
var state_37589__$1 = (function (){var statearr_37594 = state_37589;
(statearr_37594[(8)] = inst_37495__$1);

return statearr_37594;
})();
if(inst_37498){
var statearr_37595_37658 = state_37589__$1;
(statearr_37595_37658[(1)] = (2));

} else {
var statearr_37596_37659 = state_37589__$1;
(statearr_37596_37659[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (24))){
var inst_37549 = (state_37589[(9)]);
var inst_37542 = (state_37589[(10)]);
var inst_37563 = (state_37589[(11)]);
var inst_37563__$1 = (inst_37542.cljs$core$IFn$_invoke$arity$1 ? inst_37542.cljs$core$IFn$_invoke$arity$1(inst_37549) : inst_37542.call(null,inst_37549));
var state_37589__$1 = (function (){var statearr_37597 = state_37589;
(statearr_37597[(11)] = inst_37563__$1);

return statearr_37597;
})();
if(cljs.core.truth_(inst_37563__$1)){
var statearr_37598_37660 = state_37589__$1;
(statearr_37598_37660[(1)] = (29));

} else {
var statearr_37599_37661 = state_37589__$1;
(statearr_37599_37661[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (4))){
var inst_37510 = (state_37589[(2)]);
var state_37589__$1 = state_37589;
if(cljs.core.truth_(inst_37510)){
var statearr_37600_37662 = state_37589__$1;
(statearr_37600_37662[(1)] = (8));

} else {
var statearr_37601_37663 = state_37589__$1;
(statearr_37601_37663[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (15))){
var inst_37536 = (state_37589[(2)]);
var state_37589__$1 = state_37589;
if(cljs.core.truth_(inst_37536)){
var statearr_37602_37664 = state_37589__$1;
(statearr_37602_37664[(1)] = (19));

} else {
var statearr_37603_37665 = state_37589__$1;
(statearr_37603_37665[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (21))){
var inst_37541 = (state_37589[(12)]);
var inst_37541__$1 = (state_37589[(2)]);
var inst_37542 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37541__$1,cljs.core.cst$kw$solos);
var inst_37543 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37541__$1,cljs.core.cst$kw$mutes);
var inst_37544 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37541__$1,cljs.core.cst$kw$reads);
var state_37589__$1 = (function (){var statearr_37604 = state_37589;
(statearr_37604[(10)] = inst_37542);

(statearr_37604[(12)] = inst_37541__$1);

(statearr_37604[(13)] = inst_37543);

return statearr_37604;
})();
return cljs.core.async.ioc_alts_BANG_(state_37589__$1,(22),inst_37544);
} else {
if((state_val_37590 === (31))){
var inst_37571 = (state_37589[(2)]);
var state_37589__$1 = state_37589;
if(cljs.core.truth_(inst_37571)){
var statearr_37605_37666 = state_37589__$1;
(statearr_37605_37666[(1)] = (32));

} else {
var statearr_37606_37667 = state_37589__$1;
(statearr_37606_37667[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (32))){
var inst_37548 = (state_37589[(14)]);
var state_37589__$1 = state_37589;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37589__$1,(35),out,inst_37548);
} else {
if((state_val_37590 === (33))){
var inst_37541 = (state_37589[(12)]);
var inst_37519 = inst_37541;
var state_37589__$1 = (function (){var statearr_37607 = state_37589;
(statearr_37607[(7)] = inst_37519);

return statearr_37607;
})();
var statearr_37608_37668 = state_37589__$1;
(statearr_37608_37668[(2)] = null);

(statearr_37608_37668[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (13))){
var inst_37519 = (state_37589[(7)]);
var inst_37526 = inst_37519.cljs$lang$protocol_mask$partition0$;
var inst_37527 = (inst_37526 & (64));
var inst_37528 = inst_37519.cljs$core$ISeq$;
var inst_37529 = (inst_37527) || (inst_37528);
var state_37589__$1 = state_37589;
if(cljs.core.truth_(inst_37529)){
var statearr_37609_37669 = state_37589__$1;
(statearr_37609_37669[(1)] = (16));

} else {
var statearr_37610_37670 = state_37589__$1;
(statearr_37610_37670[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (22))){
var inst_37549 = (state_37589[(9)]);
var inst_37548 = (state_37589[(14)]);
var inst_37547 = (state_37589[(2)]);
var inst_37548__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37547,(0),null);
var inst_37549__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37547,(1),null);
var inst_37550 = (inst_37548__$1 == null);
var inst_37551 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37549__$1,change);
var inst_37552 = (inst_37550) || (inst_37551);
var state_37589__$1 = (function (){var statearr_37611 = state_37589;
(statearr_37611[(9)] = inst_37549__$1);

(statearr_37611[(14)] = inst_37548__$1);

return statearr_37611;
})();
if(cljs.core.truth_(inst_37552)){
var statearr_37612_37671 = state_37589__$1;
(statearr_37612_37671[(1)] = (23));

} else {
var statearr_37613_37672 = state_37589__$1;
(statearr_37613_37672[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (36))){
var inst_37541 = (state_37589[(12)]);
var inst_37519 = inst_37541;
var state_37589__$1 = (function (){var statearr_37614 = state_37589;
(statearr_37614[(7)] = inst_37519);

return statearr_37614;
})();
var statearr_37615_37673 = state_37589__$1;
(statearr_37615_37673[(2)] = null);

(statearr_37615_37673[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (29))){
var inst_37563 = (state_37589[(11)]);
var state_37589__$1 = state_37589;
var statearr_37616_37674 = state_37589__$1;
(statearr_37616_37674[(2)] = inst_37563);

(statearr_37616_37674[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (6))){
var state_37589__$1 = state_37589;
var statearr_37617_37675 = state_37589__$1;
(statearr_37617_37675[(2)] = false);

(statearr_37617_37675[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (28))){
var inst_37559 = (state_37589[(2)]);
var inst_37560 = calc_state();
var inst_37519 = inst_37560;
var state_37589__$1 = (function (){var statearr_37618 = state_37589;
(statearr_37618[(15)] = inst_37559);

(statearr_37618[(7)] = inst_37519);

return statearr_37618;
})();
var statearr_37619_37676 = state_37589__$1;
(statearr_37619_37676[(2)] = null);

(statearr_37619_37676[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (25))){
var inst_37585 = (state_37589[(2)]);
var state_37589__$1 = state_37589;
var statearr_37620_37677 = state_37589__$1;
(statearr_37620_37677[(2)] = inst_37585);

(statearr_37620_37677[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (34))){
var inst_37583 = (state_37589[(2)]);
var state_37589__$1 = state_37589;
var statearr_37621_37678 = state_37589__$1;
(statearr_37621_37678[(2)] = inst_37583);

(statearr_37621_37678[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (17))){
var state_37589__$1 = state_37589;
var statearr_37622_37679 = state_37589__$1;
(statearr_37622_37679[(2)] = false);

(statearr_37622_37679[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (3))){
var state_37589__$1 = state_37589;
var statearr_37623_37680 = state_37589__$1;
(statearr_37623_37680[(2)] = false);

(statearr_37623_37680[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (12))){
var inst_37587 = (state_37589[(2)]);
var state_37589__$1 = state_37589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37589__$1,inst_37587);
} else {
if((state_val_37590 === (2))){
var inst_37495 = (state_37589[(8)]);
var inst_37500 = inst_37495.cljs$lang$protocol_mask$partition0$;
var inst_37501 = (inst_37500 & (64));
var inst_37502 = inst_37495.cljs$core$ISeq$;
var inst_37503 = (inst_37501) || (inst_37502);
var state_37589__$1 = state_37589;
if(cljs.core.truth_(inst_37503)){
var statearr_37624_37681 = state_37589__$1;
(statearr_37624_37681[(1)] = (5));

} else {
var statearr_37625_37682 = state_37589__$1;
(statearr_37625_37682[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (23))){
var inst_37548 = (state_37589[(14)]);
var inst_37554 = (inst_37548 == null);
var state_37589__$1 = state_37589;
if(cljs.core.truth_(inst_37554)){
var statearr_37626_37683 = state_37589__$1;
(statearr_37626_37683[(1)] = (26));

} else {
var statearr_37627_37684 = state_37589__$1;
(statearr_37627_37684[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (35))){
var inst_37574 = (state_37589[(2)]);
var state_37589__$1 = state_37589;
if(cljs.core.truth_(inst_37574)){
var statearr_37628_37685 = state_37589__$1;
(statearr_37628_37685[(1)] = (36));

} else {
var statearr_37629_37686 = state_37589__$1;
(statearr_37629_37686[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (19))){
var inst_37519 = (state_37589[(7)]);
var inst_37538 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37519);
var state_37589__$1 = state_37589;
var statearr_37630_37687 = state_37589__$1;
(statearr_37630_37687[(2)] = inst_37538);

(statearr_37630_37687[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (11))){
var inst_37519 = (state_37589[(7)]);
var inst_37523 = (inst_37519 == null);
var inst_37524 = cljs.core.not(inst_37523);
var state_37589__$1 = state_37589;
if(inst_37524){
var statearr_37631_37688 = state_37589__$1;
(statearr_37631_37688[(1)] = (13));

} else {
var statearr_37632_37689 = state_37589__$1;
(statearr_37632_37689[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (9))){
var inst_37495 = (state_37589[(8)]);
var state_37589__$1 = state_37589;
var statearr_37633_37690 = state_37589__$1;
(statearr_37633_37690[(2)] = inst_37495);

(statearr_37633_37690[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (5))){
var state_37589__$1 = state_37589;
var statearr_37634_37691 = state_37589__$1;
(statearr_37634_37691[(2)] = true);

(statearr_37634_37691[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (14))){
var state_37589__$1 = state_37589;
var statearr_37635_37692 = state_37589__$1;
(statearr_37635_37692[(2)] = false);

(statearr_37635_37692[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (26))){
var inst_37549 = (state_37589[(9)]);
var inst_37556 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_37549);
var state_37589__$1 = state_37589;
var statearr_37636_37693 = state_37589__$1;
(statearr_37636_37693[(2)] = inst_37556);

(statearr_37636_37693[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (16))){
var state_37589__$1 = state_37589;
var statearr_37637_37694 = state_37589__$1;
(statearr_37637_37694[(2)] = true);

(statearr_37637_37694[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (38))){
var inst_37579 = (state_37589[(2)]);
var state_37589__$1 = state_37589;
var statearr_37638_37695 = state_37589__$1;
(statearr_37638_37695[(2)] = inst_37579);

(statearr_37638_37695[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (30))){
var inst_37549 = (state_37589[(9)]);
var inst_37542 = (state_37589[(10)]);
var inst_37543 = (state_37589[(13)]);
var inst_37566 = cljs.core.empty_QMARK_(inst_37542);
var inst_37567 = (inst_37543.cljs$core$IFn$_invoke$arity$1 ? inst_37543.cljs$core$IFn$_invoke$arity$1(inst_37549) : inst_37543.call(null,inst_37549));
var inst_37568 = cljs.core.not(inst_37567);
var inst_37569 = (inst_37566) && (inst_37568);
var state_37589__$1 = state_37589;
var statearr_37639_37696 = state_37589__$1;
(statearr_37639_37696[(2)] = inst_37569);

(statearr_37639_37696[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (10))){
var inst_37495 = (state_37589[(8)]);
var inst_37515 = (state_37589[(2)]);
var inst_37516 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37515,cljs.core.cst$kw$solos);
var inst_37517 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37515,cljs.core.cst$kw$mutes);
var inst_37518 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37515,cljs.core.cst$kw$reads);
var inst_37519 = inst_37495;
var state_37589__$1 = (function (){var statearr_37640 = state_37589;
(statearr_37640[(16)] = inst_37518);

(statearr_37640[(17)] = inst_37516);

(statearr_37640[(7)] = inst_37519);

(statearr_37640[(18)] = inst_37517);

return statearr_37640;
})();
var statearr_37641_37697 = state_37589__$1;
(statearr_37641_37697[(2)] = null);

(statearr_37641_37697[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (18))){
var inst_37533 = (state_37589[(2)]);
var state_37589__$1 = state_37589;
var statearr_37642_37698 = state_37589__$1;
(statearr_37642_37698[(2)] = inst_37533);

(statearr_37642_37698[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (37))){
var state_37589__$1 = state_37589;
var statearr_37643_37699 = state_37589__$1;
(statearr_37643_37699[(2)] = null);

(statearr_37643_37699[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37590 === (8))){
var inst_37495 = (state_37589[(8)]);
var inst_37512 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37495);
var state_37589__$1 = state_37589;
var statearr_37644_37700 = state_37589__$1;
(statearr_37644_37700[(2)] = inst_37512);

(statearr_37644_37700[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___37654,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8335__auto__,c__8400__auto___37654,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8336__auto__ = null;
var cljs$core$async$mix_$_state_machine__8336__auto____0 = (function (){
var statearr_37648 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37648[(0)] = cljs$core$async$mix_$_state_machine__8336__auto__);

(statearr_37648[(1)] = (1));

return statearr_37648;
});
var cljs$core$async$mix_$_state_machine__8336__auto____1 = (function (state_37589){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_37589);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e37649){if((e37649 instanceof Object)){
var ex__8339__auto__ = e37649;
var statearr_37650_37701 = state_37589;
(statearr_37650_37701[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37589);

return cljs.core.cst$kw$recur;
} else {
throw e37649;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__37702 = state_37589;
state_37589 = G__37702;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8336__auto__ = function(state_37589){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8336__auto____1.call(this,state_37589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8336__auto____0;
cljs$core$async$mix_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8336__auto____1;
return cljs$core$async$mix_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___37654,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8402__auto__ = (function (){var statearr_37651 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_37651[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___37654);

return statearr_37651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___37654,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5225__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5225__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5225__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5225__auto__.call(null,p,v,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5225__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args37703 = [];
var len__5627__auto___37706 = arguments.length;
var i__5628__auto___37707 = (0);
while(true){
if((i__5628__auto___37707 < len__5627__auto___37706)){
args37703.push((arguments[i__5628__auto___37707]));

var G__37708 = (i__5628__auto___37707 + (1));
i__5628__auto___37707 = G__37708;
continue;
} else {
}
break;
}

var G__37705 = args37703.length;
switch (G__37705) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37703.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5225__auto__.call(null,p));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__5225__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5225__auto__.call(null,p,v));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__5225__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args37711 = [];
var len__5627__auto___37839 = arguments.length;
var i__5628__auto___37840 = (0);
while(true){
if((i__5628__auto___37840 < len__5627__auto___37839)){
args37711.push((arguments[i__5628__auto___37840]));

var G__37841 = (i__5628__auto___37840 + (1));
i__5628__auto___37840 = G__37841;
continue;
} else {
}
break;
}

var G__37713 = args37711.length;
switch (G__37713) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37711.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__37714 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__37714) : cljs.core.atom.call(null,G__37714));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__4569__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__4569__auto__,mults){
return (function (p1__37710_SHARP_){
if(cljs.core.truth_((p1__37710_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__37710_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__37710_SHARP_.call(null,topic)))){
return p1__37710_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__37710_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__4569__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async37715 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37715 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta37716){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta37716 = meta37716;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37715.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_37717,meta37716__$1){
var self__ = this;
var _37717__$1 = this;
return (new cljs.core.async.t_cljs$core$async37715(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta37716__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37715.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_37717){
var self__ = this;
var _37717__$1 = this;
return self__.meta37716;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37715.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async37715.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37715.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async37715.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37715.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37715.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__37718 = self__.mults;
var G__37719 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__37718,G__37719) : cljs.core.reset_BANG_.call(null,G__37718,G__37719));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37715.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37715.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta37716], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37715.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37715.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37715";

cljs.core.async.t_cljs$core$async37715.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async37715");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async37715 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async37715(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37716){
return (new cljs.core.async.t_cljs$core$async37715(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37716));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async37715(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8400__auto___37843 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___37843,mults,ensure_mult,p){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___37843,mults,ensure_mult,p){
return (function (state_37791){
var state_val_37792 = (state_37791[(1)]);
if((state_val_37792 === (7))){
var inst_37787 = (state_37791[(2)]);
var state_37791__$1 = state_37791;
var statearr_37793_37844 = state_37791__$1;
(statearr_37793_37844[(2)] = inst_37787);

(statearr_37793_37844[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (20))){
var state_37791__$1 = state_37791;
var statearr_37794_37845 = state_37791__$1;
(statearr_37794_37845[(2)] = null);

(statearr_37794_37845[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (1))){
var state_37791__$1 = state_37791;
var statearr_37795_37846 = state_37791__$1;
(statearr_37795_37846[(2)] = null);

(statearr_37795_37846[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (24))){
var inst_37770 = (state_37791[(7)]);
var inst_37779 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_37770);
var state_37791__$1 = state_37791;
var statearr_37796_37847 = state_37791__$1;
(statearr_37796_37847[(2)] = inst_37779);

(statearr_37796_37847[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (4))){
var inst_37722 = (state_37791[(8)]);
var inst_37722__$1 = (state_37791[(2)]);
var inst_37723 = (inst_37722__$1 == null);
var state_37791__$1 = (function (){var statearr_37797 = state_37791;
(statearr_37797[(8)] = inst_37722__$1);

return statearr_37797;
})();
if(cljs.core.truth_(inst_37723)){
var statearr_37798_37848 = state_37791__$1;
(statearr_37798_37848[(1)] = (5));

} else {
var statearr_37799_37849 = state_37791__$1;
(statearr_37799_37849[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (15))){
var inst_37764 = (state_37791[(2)]);
var state_37791__$1 = state_37791;
var statearr_37800_37850 = state_37791__$1;
(statearr_37800_37850[(2)] = inst_37764);

(statearr_37800_37850[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (21))){
var inst_37784 = (state_37791[(2)]);
var state_37791__$1 = (function (){var statearr_37801 = state_37791;
(statearr_37801[(9)] = inst_37784);

return statearr_37801;
})();
var statearr_37802_37851 = state_37791__$1;
(statearr_37802_37851[(2)] = null);

(statearr_37802_37851[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (13))){
var inst_37746 = (state_37791[(10)]);
var inst_37748 = cljs.core.chunked_seq_QMARK_(inst_37746);
var state_37791__$1 = state_37791;
if(inst_37748){
var statearr_37803_37852 = state_37791__$1;
(statearr_37803_37852[(1)] = (16));

} else {
var statearr_37804_37853 = state_37791__$1;
(statearr_37804_37853[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (22))){
var inst_37776 = (state_37791[(2)]);
var state_37791__$1 = state_37791;
if(cljs.core.truth_(inst_37776)){
var statearr_37805_37854 = state_37791__$1;
(statearr_37805_37854[(1)] = (23));

} else {
var statearr_37806_37855 = state_37791__$1;
(statearr_37806_37855[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (6))){
var inst_37772 = (state_37791[(11)]);
var inst_37770 = (state_37791[(7)]);
var inst_37722 = (state_37791[(8)]);
var inst_37770__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_37722) : topic_fn.call(null,inst_37722));
var inst_37771 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_37772__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37771,inst_37770__$1);
var state_37791__$1 = (function (){var statearr_37807 = state_37791;
(statearr_37807[(11)] = inst_37772__$1);

(statearr_37807[(7)] = inst_37770__$1);

return statearr_37807;
})();
if(cljs.core.truth_(inst_37772__$1)){
var statearr_37808_37856 = state_37791__$1;
(statearr_37808_37856[(1)] = (19));

} else {
var statearr_37809_37857 = state_37791__$1;
(statearr_37809_37857[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (25))){
var inst_37781 = (state_37791[(2)]);
var state_37791__$1 = state_37791;
var statearr_37810_37858 = state_37791__$1;
(statearr_37810_37858[(2)] = inst_37781);

(statearr_37810_37858[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (17))){
var inst_37746 = (state_37791[(10)]);
var inst_37755 = cljs.core.first(inst_37746);
var inst_37756 = cljs.core.async.muxch_STAR_(inst_37755);
var inst_37757 = cljs.core.async.close_BANG_(inst_37756);
var inst_37758 = cljs.core.next(inst_37746);
var inst_37732 = inst_37758;
var inst_37733 = null;
var inst_37734 = (0);
var inst_37735 = (0);
var state_37791__$1 = (function (){var statearr_37811 = state_37791;
(statearr_37811[(12)] = inst_37732);

(statearr_37811[(13)] = inst_37733);

(statearr_37811[(14)] = inst_37757);

(statearr_37811[(15)] = inst_37734);

(statearr_37811[(16)] = inst_37735);

return statearr_37811;
})();
var statearr_37812_37859 = state_37791__$1;
(statearr_37812_37859[(2)] = null);

(statearr_37812_37859[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (3))){
var inst_37789 = (state_37791[(2)]);
var state_37791__$1 = state_37791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37791__$1,inst_37789);
} else {
if((state_val_37792 === (12))){
var inst_37766 = (state_37791[(2)]);
var state_37791__$1 = state_37791;
var statearr_37813_37860 = state_37791__$1;
(statearr_37813_37860[(2)] = inst_37766);

(statearr_37813_37860[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (2))){
var state_37791__$1 = state_37791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37791__$1,(4),ch);
} else {
if((state_val_37792 === (23))){
var state_37791__$1 = state_37791;
var statearr_37814_37861 = state_37791__$1;
(statearr_37814_37861[(2)] = null);

(statearr_37814_37861[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (19))){
var inst_37772 = (state_37791[(11)]);
var inst_37722 = (state_37791[(8)]);
var inst_37774 = cljs.core.async.muxch_STAR_(inst_37772);
var state_37791__$1 = state_37791;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37791__$1,(22),inst_37774,inst_37722);
} else {
if((state_val_37792 === (11))){
var inst_37746 = (state_37791[(10)]);
var inst_37732 = (state_37791[(12)]);
var inst_37746__$1 = cljs.core.seq(inst_37732);
var state_37791__$1 = (function (){var statearr_37815 = state_37791;
(statearr_37815[(10)] = inst_37746__$1);

return statearr_37815;
})();
if(inst_37746__$1){
var statearr_37816_37862 = state_37791__$1;
(statearr_37816_37862[(1)] = (13));

} else {
var statearr_37817_37863 = state_37791__$1;
(statearr_37817_37863[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (9))){
var inst_37768 = (state_37791[(2)]);
var state_37791__$1 = state_37791;
var statearr_37818_37864 = state_37791__$1;
(statearr_37818_37864[(2)] = inst_37768);

(statearr_37818_37864[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (5))){
var inst_37729 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_37730 = cljs.core.vals(inst_37729);
var inst_37731 = cljs.core.seq(inst_37730);
var inst_37732 = inst_37731;
var inst_37733 = null;
var inst_37734 = (0);
var inst_37735 = (0);
var state_37791__$1 = (function (){var statearr_37819 = state_37791;
(statearr_37819[(12)] = inst_37732);

(statearr_37819[(13)] = inst_37733);

(statearr_37819[(15)] = inst_37734);

(statearr_37819[(16)] = inst_37735);

return statearr_37819;
})();
var statearr_37820_37865 = state_37791__$1;
(statearr_37820_37865[(2)] = null);

(statearr_37820_37865[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (14))){
var state_37791__$1 = state_37791;
var statearr_37824_37866 = state_37791__$1;
(statearr_37824_37866[(2)] = null);

(statearr_37824_37866[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (16))){
var inst_37746 = (state_37791[(10)]);
var inst_37750 = cljs.core.chunk_first(inst_37746);
var inst_37751 = cljs.core.chunk_rest(inst_37746);
var inst_37752 = cljs.core.count(inst_37750);
var inst_37732 = inst_37751;
var inst_37733 = inst_37750;
var inst_37734 = inst_37752;
var inst_37735 = (0);
var state_37791__$1 = (function (){var statearr_37825 = state_37791;
(statearr_37825[(12)] = inst_37732);

(statearr_37825[(13)] = inst_37733);

(statearr_37825[(15)] = inst_37734);

(statearr_37825[(16)] = inst_37735);

return statearr_37825;
})();
var statearr_37826_37867 = state_37791__$1;
(statearr_37826_37867[(2)] = null);

(statearr_37826_37867[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (10))){
var inst_37732 = (state_37791[(12)]);
var inst_37733 = (state_37791[(13)]);
var inst_37734 = (state_37791[(15)]);
var inst_37735 = (state_37791[(16)]);
var inst_37740 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37733,inst_37735);
var inst_37741 = cljs.core.async.muxch_STAR_(inst_37740);
var inst_37742 = cljs.core.async.close_BANG_(inst_37741);
var inst_37743 = (inst_37735 + (1));
var tmp37821 = inst_37732;
var tmp37822 = inst_37733;
var tmp37823 = inst_37734;
var inst_37732__$1 = tmp37821;
var inst_37733__$1 = tmp37822;
var inst_37734__$1 = tmp37823;
var inst_37735__$1 = inst_37743;
var state_37791__$1 = (function (){var statearr_37827 = state_37791;
(statearr_37827[(12)] = inst_37732__$1);

(statearr_37827[(13)] = inst_37733__$1);

(statearr_37827[(15)] = inst_37734__$1);

(statearr_37827[(17)] = inst_37742);

(statearr_37827[(16)] = inst_37735__$1);

return statearr_37827;
})();
var statearr_37828_37868 = state_37791__$1;
(statearr_37828_37868[(2)] = null);

(statearr_37828_37868[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (18))){
var inst_37761 = (state_37791[(2)]);
var state_37791__$1 = state_37791;
var statearr_37829_37869 = state_37791__$1;
(statearr_37829_37869[(2)] = inst_37761);

(statearr_37829_37869[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37792 === (8))){
var inst_37734 = (state_37791[(15)]);
var inst_37735 = (state_37791[(16)]);
var inst_37737 = (inst_37735 < inst_37734);
var inst_37738 = inst_37737;
var state_37791__$1 = state_37791;
if(cljs.core.truth_(inst_37738)){
var statearr_37830_37870 = state_37791__$1;
(statearr_37830_37870[(1)] = (10));

} else {
var statearr_37831_37871 = state_37791__$1;
(statearr_37831_37871[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___37843,mults,ensure_mult,p))
;
return ((function (switch__8335__auto__,c__8400__auto___37843,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_37835 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37835[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_37835[(1)] = (1));

return statearr_37835;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_37791){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_37791);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e37836){if((e37836 instanceof Object)){
var ex__8339__auto__ = e37836;
var statearr_37837_37872 = state_37791;
(statearr_37837_37872[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37791);

return cljs.core.cst$kw$recur;
} else {
throw e37836;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__37873 = state_37791;
state_37791 = G__37873;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_37791){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_37791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___37843,mults,ensure_mult,p))
})();
var state__8402__auto__ = (function (){var statearr_37838 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_37838[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___37843);

return statearr_37838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___37843,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args37874 = [];
var len__5627__auto___37877 = arguments.length;
var i__5628__auto___37878 = (0);
while(true){
if((i__5628__auto___37878 < len__5627__auto___37877)){
args37874.push((arguments[i__5628__auto___37878]));

var G__37879 = (i__5628__auto___37878 + (1));
i__5628__auto___37878 = G__37879;
continue;
} else {
}
break;
}

var G__37876 = args37874.length;
switch (G__37876) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37874.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args37881 = [];
var len__5627__auto___37884 = arguments.length;
var i__5628__auto___37885 = (0);
while(true){
if((i__5628__auto___37885 < len__5627__auto___37884)){
args37881.push((arguments[i__5628__auto___37885]));

var G__37886 = (i__5628__auto___37885 + (1));
i__5628__auto___37885 = G__37886;
continue;
} else {
}
break;
}

var G__37883 = args37881.length;
switch (G__37883) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37881.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args37888 = [];
var len__5627__auto___37959 = arguments.length;
var i__5628__auto___37960 = (0);
while(true){
if((i__5628__auto___37960 < len__5627__auto___37959)){
args37888.push((arguments[i__5628__auto___37960]));

var G__37961 = (i__5628__auto___37960 + (1));
i__5628__auto___37960 = G__37961;
continue;
} else {
}
break;
}

var G__37890 = args37888.length;
switch (G__37890) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37888.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__8400__auto___37963 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___37963,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___37963,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_37929){
var state_val_37930 = (state_37929[(1)]);
if((state_val_37930 === (7))){
var state_37929__$1 = state_37929;
var statearr_37931_37964 = state_37929__$1;
(statearr_37931_37964[(2)] = null);

(statearr_37931_37964[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37930 === (1))){
var state_37929__$1 = state_37929;
var statearr_37932_37965 = state_37929__$1;
(statearr_37932_37965[(2)] = null);

(statearr_37932_37965[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37930 === (4))){
var inst_37893 = (state_37929[(7)]);
var inst_37895 = (inst_37893 < cnt);
var state_37929__$1 = state_37929;
if(cljs.core.truth_(inst_37895)){
var statearr_37933_37966 = state_37929__$1;
(statearr_37933_37966[(1)] = (6));

} else {
var statearr_37934_37967 = state_37929__$1;
(statearr_37934_37967[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37930 === (15))){
var inst_37925 = (state_37929[(2)]);
var state_37929__$1 = state_37929;
var statearr_37935_37968 = state_37929__$1;
(statearr_37935_37968[(2)] = inst_37925);

(statearr_37935_37968[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37930 === (13))){
var inst_37918 = cljs.core.async.close_BANG_(out);
var state_37929__$1 = state_37929;
var statearr_37936_37969 = state_37929__$1;
(statearr_37936_37969[(2)] = inst_37918);

(statearr_37936_37969[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37930 === (6))){
var state_37929__$1 = state_37929;
var statearr_37937_37970 = state_37929__$1;
(statearr_37937_37970[(2)] = null);

(statearr_37937_37970[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37930 === (3))){
var inst_37927 = (state_37929[(2)]);
var state_37929__$1 = state_37929;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37929__$1,inst_37927);
} else {
if((state_val_37930 === (12))){
var inst_37915 = (state_37929[(8)]);
var inst_37915__$1 = (state_37929[(2)]);
var inst_37916 = cljs.core.some(cljs.core.nil_QMARK_,inst_37915__$1);
var state_37929__$1 = (function (){var statearr_37938 = state_37929;
(statearr_37938[(8)] = inst_37915__$1);

return statearr_37938;
})();
if(cljs.core.truth_(inst_37916)){
var statearr_37939_37971 = state_37929__$1;
(statearr_37939_37971[(1)] = (13));

} else {
var statearr_37940_37972 = state_37929__$1;
(statearr_37940_37972[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37930 === (2))){
var inst_37892 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_37893 = (0);
var state_37929__$1 = (function (){var statearr_37941 = state_37929;
(statearr_37941[(9)] = inst_37892);

(statearr_37941[(7)] = inst_37893);

return statearr_37941;
})();
var statearr_37942_37973 = state_37929__$1;
(statearr_37942_37973[(2)] = null);

(statearr_37942_37973[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37930 === (11))){
var inst_37893 = (state_37929[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_37929,(10),Object,null,(9));
var inst_37902 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_37893) : chs__$1.call(null,inst_37893));
var inst_37903 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_37893) : done.call(null,inst_37893));
var inst_37904 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_37902,inst_37903);
var state_37929__$1 = state_37929;
var statearr_37943_37974 = state_37929__$1;
(statearr_37943_37974[(2)] = inst_37904);


cljs.core.async.impl.ioc_helpers.process_exception(state_37929__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_37930 === (9))){
var inst_37893 = (state_37929[(7)]);
var inst_37906 = (state_37929[(2)]);
var inst_37907 = (inst_37893 + (1));
var inst_37893__$1 = inst_37907;
var state_37929__$1 = (function (){var statearr_37944 = state_37929;
(statearr_37944[(10)] = inst_37906);

(statearr_37944[(7)] = inst_37893__$1);

return statearr_37944;
})();
var statearr_37945_37975 = state_37929__$1;
(statearr_37945_37975[(2)] = null);

(statearr_37945_37975[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37930 === (5))){
var inst_37913 = (state_37929[(2)]);
var state_37929__$1 = (function (){var statearr_37946 = state_37929;
(statearr_37946[(11)] = inst_37913);

return statearr_37946;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37929__$1,(12),dchan);
} else {
if((state_val_37930 === (14))){
var inst_37915 = (state_37929[(8)]);
var inst_37920 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_37915);
var state_37929__$1 = state_37929;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37929__$1,(16),out,inst_37920);
} else {
if((state_val_37930 === (16))){
var inst_37922 = (state_37929[(2)]);
var state_37929__$1 = (function (){var statearr_37947 = state_37929;
(statearr_37947[(12)] = inst_37922);

return statearr_37947;
})();
var statearr_37948_37976 = state_37929__$1;
(statearr_37948_37976[(2)] = null);

(statearr_37948_37976[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37930 === (10))){
var inst_37897 = (state_37929[(2)]);
var inst_37898 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_37929__$1 = (function (){var statearr_37949 = state_37929;
(statearr_37949[(13)] = inst_37897);

return statearr_37949;
})();
var statearr_37950_37977 = state_37929__$1;
(statearr_37950_37977[(2)] = inst_37898);


cljs.core.async.impl.ioc_helpers.process_exception(state_37929__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_37930 === (8))){
var inst_37911 = (state_37929[(2)]);
var state_37929__$1 = state_37929;
var statearr_37951_37978 = state_37929__$1;
(statearr_37951_37978[(2)] = inst_37911);

(statearr_37951_37978[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___37963,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8335__auto__,c__8400__auto___37963,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_37955 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37955[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_37955[(1)] = (1));

return statearr_37955;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_37929){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_37929);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e37956){if((e37956 instanceof Object)){
var ex__8339__auto__ = e37956;
var statearr_37957_37979 = state_37929;
(statearr_37957_37979[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37929);

return cljs.core.cst$kw$recur;
} else {
throw e37956;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__37980 = state_37929;
state_37929 = G__37980;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_37929){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_37929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___37963,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8402__auto__ = (function (){var statearr_37958 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_37958[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___37963);

return statearr_37958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___37963,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args37982 = [];
var len__5627__auto___38038 = arguments.length;
var i__5628__auto___38039 = (0);
while(true){
if((i__5628__auto___38039 < len__5627__auto___38038)){
args37982.push((arguments[i__5628__auto___38039]));

var G__38040 = (i__5628__auto___38039 + (1));
i__5628__auto___38039 = G__38040;
continue;
} else {
}
break;
}

var G__37984 = args37982.length;
switch (G__37984) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37982.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8400__auto___38042 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___38042,out){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___38042,out){
return (function (state_38014){
var state_val_38015 = (state_38014[(1)]);
if((state_val_38015 === (7))){
var inst_37993 = (state_38014[(7)]);
var inst_37994 = (state_38014[(8)]);
var inst_37993__$1 = (state_38014[(2)]);
var inst_37994__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37993__$1,(0),null);
var inst_37995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37993__$1,(1),null);
var inst_37996 = (inst_37994__$1 == null);
var state_38014__$1 = (function (){var statearr_38016 = state_38014;
(statearr_38016[(9)] = inst_37995);

(statearr_38016[(7)] = inst_37993__$1);

(statearr_38016[(8)] = inst_37994__$1);

return statearr_38016;
})();
if(cljs.core.truth_(inst_37996)){
var statearr_38017_38043 = state_38014__$1;
(statearr_38017_38043[(1)] = (8));

} else {
var statearr_38018_38044 = state_38014__$1;
(statearr_38018_38044[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (1))){
var inst_37985 = cljs.core.vec(chs);
var inst_37986 = inst_37985;
var state_38014__$1 = (function (){var statearr_38019 = state_38014;
(statearr_38019[(10)] = inst_37986);

return statearr_38019;
})();
var statearr_38020_38045 = state_38014__$1;
(statearr_38020_38045[(2)] = null);

(statearr_38020_38045[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (4))){
var inst_37986 = (state_38014[(10)]);
var state_38014__$1 = state_38014;
return cljs.core.async.ioc_alts_BANG_(state_38014__$1,(7),inst_37986);
} else {
if((state_val_38015 === (6))){
var inst_38010 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38021_38046 = state_38014__$1;
(statearr_38021_38046[(2)] = inst_38010);

(statearr_38021_38046[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (3))){
var inst_38012 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38014__$1,inst_38012);
} else {
if((state_val_38015 === (2))){
var inst_37986 = (state_38014[(10)]);
var inst_37988 = cljs.core.count(inst_37986);
var inst_37989 = (inst_37988 > (0));
var state_38014__$1 = state_38014;
if(cljs.core.truth_(inst_37989)){
var statearr_38023_38047 = state_38014__$1;
(statearr_38023_38047[(1)] = (4));

} else {
var statearr_38024_38048 = state_38014__$1;
(statearr_38024_38048[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (11))){
var inst_37986 = (state_38014[(10)]);
var inst_38003 = (state_38014[(2)]);
var tmp38022 = inst_37986;
var inst_37986__$1 = tmp38022;
var state_38014__$1 = (function (){var statearr_38025 = state_38014;
(statearr_38025[(10)] = inst_37986__$1);

(statearr_38025[(11)] = inst_38003);

return statearr_38025;
})();
var statearr_38026_38049 = state_38014__$1;
(statearr_38026_38049[(2)] = null);

(statearr_38026_38049[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (9))){
var inst_37994 = (state_38014[(8)]);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38014__$1,(11),out,inst_37994);
} else {
if((state_val_38015 === (5))){
var inst_38008 = cljs.core.async.close_BANG_(out);
var state_38014__$1 = state_38014;
var statearr_38027_38050 = state_38014__$1;
(statearr_38027_38050[(2)] = inst_38008);

(statearr_38027_38050[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (10))){
var inst_38006 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38028_38051 = state_38014__$1;
(statearr_38028_38051[(2)] = inst_38006);

(statearr_38028_38051[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (8))){
var inst_37986 = (state_38014[(10)]);
var inst_37995 = (state_38014[(9)]);
var inst_37993 = (state_38014[(7)]);
var inst_37994 = (state_38014[(8)]);
var inst_37998 = (function (){var cs = inst_37986;
var vec__37991 = inst_37993;
var v = inst_37994;
var c = inst_37995;
return ((function (cs,vec__37991,v,c,inst_37986,inst_37995,inst_37993,inst_37994,state_val_38015,c__8400__auto___38042,out){
return (function (p1__37981_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__37981_SHARP_);
});
;})(cs,vec__37991,v,c,inst_37986,inst_37995,inst_37993,inst_37994,state_val_38015,c__8400__auto___38042,out))
})();
var inst_37999 = cljs.core.filterv(inst_37998,inst_37986);
var inst_37986__$1 = inst_37999;
var state_38014__$1 = (function (){var statearr_38029 = state_38014;
(statearr_38029[(10)] = inst_37986__$1);

return statearr_38029;
})();
var statearr_38030_38052 = state_38014__$1;
(statearr_38030_38052[(2)] = null);

(statearr_38030_38052[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___38042,out))
;
return ((function (switch__8335__auto__,c__8400__auto___38042,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_38034 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38034[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_38034[(1)] = (1));

return statearr_38034;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_38014){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_38014);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e38035){if((e38035 instanceof Object)){
var ex__8339__auto__ = e38035;
var statearr_38036_38053 = state_38014;
(statearr_38036_38053[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38014);

return cljs.core.cst$kw$recur;
} else {
throw e38035;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__38054 = state_38014;
state_38014 = G__38054;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_38014){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_38014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___38042,out))
})();
var state__8402__auto__ = (function (){var statearr_38037 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_38037[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___38042);

return statearr_38037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___38042,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args38055 = [];
var len__5627__auto___38104 = arguments.length;
var i__5628__auto___38105 = (0);
while(true){
if((i__5628__auto___38105 < len__5627__auto___38104)){
args38055.push((arguments[i__5628__auto___38105]));

var G__38106 = (i__5628__auto___38105 + (1));
i__5628__auto___38105 = G__38106;
continue;
} else {
}
break;
}

var G__38057 = args38055.length;
switch (G__38057) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38055.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8400__auto___38108 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___38108,out){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___38108,out){
return (function (state_38081){
var state_val_38082 = (state_38081[(1)]);
if((state_val_38082 === (7))){
var inst_38063 = (state_38081[(7)]);
var inst_38063__$1 = (state_38081[(2)]);
var inst_38064 = (inst_38063__$1 == null);
var inst_38065 = cljs.core.not(inst_38064);
var state_38081__$1 = (function (){var statearr_38083 = state_38081;
(statearr_38083[(7)] = inst_38063__$1);

return statearr_38083;
})();
if(inst_38065){
var statearr_38084_38109 = state_38081__$1;
(statearr_38084_38109[(1)] = (8));

} else {
var statearr_38085_38110 = state_38081__$1;
(statearr_38085_38110[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38082 === (1))){
var inst_38058 = (0);
var state_38081__$1 = (function (){var statearr_38086 = state_38081;
(statearr_38086[(8)] = inst_38058);

return statearr_38086;
})();
var statearr_38087_38111 = state_38081__$1;
(statearr_38087_38111[(2)] = null);

(statearr_38087_38111[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38082 === (4))){
var state_38081__$1 = state_38081;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38081__$1,(7),ch);
} else {
if((state_val_38082 === (6))){
var inst_38076 = (state_38081[(2)]);
var state_38081__$1 = state_38081;
var statearr_38088_38112 = state_38081__$1;
(statearr_38088_38112[(2)] = inst_38076);

(statearr_38088_38112[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38082 === (3))){
var inst_38078 = (state_38081[(2)]);
var inst_38079 = cljs.core.async.close_BANG_(out);
var state_38081__$1 = (function (){var statearr_38089 = state_38081;
(statearr_38089[(9)] = inst_38078);

return statearr_38089;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38081__$1,inst_38079);
} else {
if((state_val_38082 === (2))){
var inst_38058 = (state_38081[(8)]);
var inst_38060 = (inst_38058 < n);
var state_38081__$1 = state_38081;
if(cljs.core.truth_(inst_38060)){
var statearr_38090_38113 = state_38081__$1;
(statearr_38090_38113[(1)] = (4));

} else {
var statearr_38091_38114 = state_38081__$1;
(statearr_38091_38114[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38082 === (11))){
var inst_38058 = (state_38081[(8)]);
var inst_38068 = (state_38081[(2)]);
var inst_38069 = (inst_38058 + (1));
var inst_38058__$1 = inst_38069;
var state_38081__$1 = (function (){var statearr_38092 = state_38081;
(statearr_38092[(8)] = inst_38058__$1);

(statearr_38092[(10)] = inst_38068);

return statearr_38092;
})();
var statearr_38093_38115 = state_38081__$1;
(statearr_38093_38115[(2)] = null);

(statearr_38093_38115[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38082 === (9))){
var state_38081__$1 = state_38081;
var statearr_38094_38116 = state_38081__$1;
(statearr_38094_38116[(2)] = null);

(statearr_38094_38116[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38082 === (5))){
var state_38081__$1 = state_38081;
var statearr_38095_38117 = state_38081__$1;
(statearr_38095_38117[(2)] = null);

(statearr_38095_38117[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38082 === (10))){
var inst_38073 = (state_38081[(2)]);
var state_38081__$1 = state_38081;
var statearr_38096_38118 = state_38081__$1;
(statearr_38096_38118[(2)] = inst_38073);

(statearr_38096_38118[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38082 === (8))){
var inst_38063 = (state_38081[(7)]);
var state_38081__$1 = state_38081;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38081__$1,(11),out,inst_38063);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___38108,out))
;
return ((function (switch__8335__auto__,c__8400__auto___38108,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_38100 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38100[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_38100[(1)] = (1));

return statearr_38100;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_38081){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_38081);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e38101){if((e38101 instanceof Object)){
var ex__8339__auto__ = e38101;
var statearr_38102_38119 = state_38081;
(statearr_38102_38119[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38081);

return cljs.core.cst$kw$recur;
} else {
throw e38101;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__38120 = state_38081;
state_38081 = G__38120;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_38081){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_38081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___38108,out))
})();
var state__8402__auto__ = (function (){var statearr_38103 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_38103[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___38108);

return statearr_38103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___38108,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async38130 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38130 = (function (map_LT_,f,ch,meta38131){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta38131 = meta38131;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38130.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38132,meta38131__$1){
var self__ = this;
var _38132__$1 = this;
return (new cljs.core.async.t_cljs$core$async38130(self__.map_LT_,self__.f,self__.ch,meta38131__$1));
});

cljs.core.async.t_cljs$core$async38130.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38132){
var self__ = this;
var _38132__$1 = this;
return self__.meta38131;
});

cljs.core.async.t_cljs$core$async38130.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async38130.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38130.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async38130.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async38130.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async38133 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38133 = (function (map_LT_,f,ch,meta38131,_,fn1,meta38134){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta38131 = meta38131;
this._ = _;
this.fn1 = fn1;
this.meta38134 = meta38134;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38133.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_38135,meta38134__$1){
var self__ = this;
var _38135__$1 = this;
return (new cljs.core.async.t_cljs$core$async38133(self__.map_LT_,self__.f,self__.ch,self__.meta38131,self__._,self__.fn1,meta38134__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async38133.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_38135){
var self__ = this;
var _38135__$1 = this;
return self__.meta38134;
});})(___$1))
;

cljs.core.async.t_cljs$core$async38133.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async38133.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38133.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__38121_SHARP_){
var G__38136 = (((p1__38121_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__38121_SHARP_) : self__.f.call(null,p1__38121_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__38136) : f1.call(null,G__38136));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async38133.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38131,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async38130], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta38134], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38133.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38133.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38133";

cljs.core.async.t_cljs$core$async38133.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38133");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async38133 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38133(map_LT___$1,f__$1,ch__$1,meta38131__$1,___$2,fn1__$1,meta38134){
return (new cljs.core.async.t_cljs$core$async38133(map_LT___$1,f__$1,ch__$1,meta38131__$1,___$2,fn1__$1,meta38134));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async38133(self__.map_LT_,self__.f,self__.ch,self__.meta38131,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4557__auto__ = ret;
if(cljs.core.truth_(and__4557__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__4557__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__38137 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__38137) : self__.f.call(null,G__38137));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async38130.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async38130.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async38130.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38131], null);
});

cljs.core.async.t_cljs$core$async38130.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38130.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38130";

cljs.core.async.t_cljs$core$async38130.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38130");
});

cljs.core.async.__GT_t_cljs$core$async38130 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38130(map_LT___$1,f__$1,ch__$1,meta38131){
return (new cljs.core.async.t_cljs$core$async38130(map_LT___$1,f__$1,ch__$1,meta38131));
});

}

return (new cljs.core.async.t_cljs$core$async38130(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async38141 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38141 = (function (map_GT_,f,ch,meta38142){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta38142 = meta38142;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38141.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38143,meta38142__$1){
var self__ = this;
var _38143__$1 = this;
return (new cljs.core.async.t_cljs$core$async38141(self__.map_GT_,self__.f,self__.ch,meta38142__$1));
});

cljs.core.async.t_cljs$core$async38141.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38143){
var self__ = this;
var _38143__$1 = this;
return self__.meta38142;
});

cljs.core.async.t_cljs$core$async38141.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async38141.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38141.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async38141.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38141.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async38141.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async38141.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38142], null);
});

cljs.core.async.t_cljs$core$async38141.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38141.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38141";

cljs.core.async.t_cljs$core$async38141.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38141");
});

cljs.core.async.__GT_t_cljs$core$async38141 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async38141(map_GT___$1,f__$1,ch__$1,meta38142){
return (new cljs.core.async.t_cljs$core$async38141(map_GT___$1,f__$1,ch__$1,meta38142));
});

}

return (new cljs.core.async.t_cljs$core$async38141(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async38147 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38147 = (function (filter_GT_,p,ch,meta38148){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta38148 = meta38148;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38147.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38149,meta38148__$1){
var self__ = this;
var _38149__$1 = this;
return (new cljs.core.async.t_cljs$core$async38147(self__.filter_GT_,self__.p,self__.ch,meta38148__$1));
});

cljs.core.async.t_cljs$core$async38147.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38149){
var self__ = this;
var _38149__$1 = this;
return self__.meta38148;
});

cljs.core.async.t_cljs$core$async38147.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async38147.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38147.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async38147.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async38147.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38147.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async38147.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async38147.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38148], null);
});

cljs.core.async.t_cljs$core$async38147.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38147.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38147";

cljs.core.async.t_cljs$core$async38147.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38147");
});

cljs.core.async.__GT_t_cljs$core$async38147 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async38147(filter_GT___$1,p__$1,ch__$1,meta38148){
return (new cljs.core.async.t_cljs$core$async38147(filter_GT___$1,p__$1,ch__$1,meta38148));
});

}

return (new cljs.core.async.t_cljs$core$async38147(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args38150 = [];
var len__5627__auto___38194 = arguments.length;
var i__5628__auto___38195 = (0);
while(true){
if((i__5628__auto___38195 < len__5627__auto___38194)){
args38150.push((arguments[i__5628__auto___38195]));

var G__38196 = (i__5628__auto___38195 + (1));
i__5628__auto___38195 = G__38196;
continue;
} else {
}
break;
}

var G__38152 = args38150.length;
switch (G__38152) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38150.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8400__auto___38198 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___38198,out){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___38198,out){
return (function (state_38173){
var state_val_38174 = (state_38173[(1)]);
if((state_val_38174 === (7))){
var inst_38169 = (state_38173[(2)]);
var state_38173__$1 = state_38173;
var statearr_38175_38199 = state_38173__$1;
(statearr_38175_38199[(2)] = inst_38169);

(statearr_38175_38199[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38174 === (1))){
var state_38173__$1 = state_38173;
var statearr_38176_38200 = state_38173__$1;
(statearr_38176_38200[(2)] = null);

(statearr_38176_38200[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38174 === (4))){
var inst_38155 = (state_38173[(7)]);
var inst_38155__$1 = (state_38173[(2)]);
var inst_38156 = (inst_38155__$1 == null);
var state_38173__$1 = (function (){var statearr_38177 = state_38173;
(statearr_38177[(7)] = inst_38155__$1);

return statearr_38177;
})();
if(cljs.core.truth_(inst_38156)){
var statearr_38178_38201 = state_38173__$1;
(statearr_38178_38201[(1)] = (5));

} else {
var statearr_38179_38202 = state_38173__$1;
(statearr_38179_38202[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38174 === (6))){
var inst_38155 = (state_38173[(7)]);
var inst_38160 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_38155) : p.call(null,inst_38155));
var state_38173__$1 = state_38173;
if(cljs.core.truth_(inst_38160)){
var statearr_38180_38203 = state_38173__$1;
(statearr_38180_38203[(1)] = (8));

} else {
var statearr_38181_38204 = state_38173__$1;
(statearr_38181_38204[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38174 === (3))){
var inst_38171 = (state_38173[(2)]);
var state_38173__$1 = state_38173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38173__$1,inst_38171);
} else {
if((state_val_38174 === (2))){
var state_38173__$1 = state_38173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38173__$1,(4),ch);
} else {
if((state_val_38174 === (11))){
var inst_38163 = (state_38173[(2)]);
var state_38173__$1 = state_38173;
var statearr_38182_38205 = state_38173__$1;
(statearr_38182_38205[(2)] = inst_38163);

(statearr_38182_38205[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38174 === (9))){
var state_38173__$1 = state_38173;
var statearr_38183_38206 = state_38173__$1;
(statearr_38183_38206[(2)] = null);

(statearr_38183_38206[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38174 === (5))){
var inst_38158 = cljs.core.async.close_BANG_(out);
var state_38173__$1 = state_38173;
var statearr_38184_38207 = state_38173__$1;
(statearr_38184_38207[(2)] = inst_38158);

(statearr_38184_38207[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38174 === (10))){
var inst_38166 = (state_38173[(2)]);
var state_38173__$1 = (function (){var statearr_38185 = state_38173;
(statearr_38185[(8)] = inst_38166);

return statearr_38185;
})();
var statearr_38186_38208 = state_38173__$1;
(statearr_38186_38208[(2)] = null);

(statearr_38186_38208[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38174 === (8))){
var inst_38155 = (state_38173[(7)]);
var state_38173__$1 = state_38173;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38173__$1,(11),out,inst_38155);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___38198,out))
;
return ((function (switch__8335__auto__,c__8400__auto___38198,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_38190 = [null,null,null,null,null,null,null,null,null];
(statearr_38190[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_38190[(1)] = (1));

return statearr_38190;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_38173){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_38173);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e38191){if((e38191 instanceof Object)){
var ex__8339__auto__ = e38191;
var statearr_38192_38209 = state_38173;
(statearr_38192_38209[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38173);

return cljs.core.cst$kw$recur;
} else {
throw e38191;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__38210 = state_38173;
state_38173 = G__38210;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_38173){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_38173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___38198,out))
})();
var state__8402__auto__ = (function (){var statearr_38193 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_38193[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___38198);

return statearr_38193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___38198,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args38211 = [];
var len__5627__auto___38214 = arguments.length;
var i__5628__auto___38215 = (0);
while(true){
if((i__5628__auto___38215 < len__5627__auto___38214)){
args38211.push((arguments[i__5628__auto___38215]));

var G__38216 = (i__5628__auto___38215 + (1));
i__5628__auto___38215 = G__38216;
continue;
} else {
}
break;
}

var G__38213 = args38211.length;
switch (G__38213) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38211.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8400__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto__){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto__){
return (function (state_38383){
var state_val_38384 = (state_38383[(1)]);
if((state_val_38384 === (7))){
var inst_38379 = (state_38383[(2)]);
var state_38383__$1 = state_38383;
var statearr_38385_38426 = state_38383__$1;
(statearr_38385_38426[(2)] = inst_38379);

(statearr_38385_38426[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (20))){
var inst_38349 = (state_38383[(7)]);
var inst_38360 = (state_38383[(2)]);
var inst_38361 = cljs.core.next(inst_38349);
var inst_38335 = inst_38361;
var inst_38336 = null;
var inst_38337 = (0);
var inst_38338 = (0);
var state_38383__$1 = (function (){var statearr_38386 = state_38383;
(statearr_38386[(8)] = inst_38335);

(statearr_38386[(9)] = inst_38338);

(statearr_38386[(10)] = inst_38336);

(statearr_38386[(11)] = inst_38337);

(statearr_38386[(12)] = inst_38360);

return statearr_38386;
})();
var statearr_38387_38427 = state_38383__$1;
(statearr_38387_38427[(2)] = null);

(statearr_38387_38427[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (1))){
var state_38383__$1 = state_38383;
var statearr_38388_38428 = state_38383__$1;
(statearr_38388_38428[(2)] = null);

(statearr_38388_38428[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (4))){
var inst_38324 = (state_38383[(13)]);
var inst_38324__$1 = (state_38383[(2)]);
var inst_38325 = (inst_38324__$1 == null);
var state_38383__$1 = (function (){var statearr_38389 = state_38383;
(statearr_38389[(13)] = inst_38324__$1);

return statearr_38389;
})();
if(cljs.core.truth_(inst_38325)){
var statearr_38390_38429 = state_38383__$1;
(statearr_38390_38429[(1)] = (5));

} else {
var statearr_38391_38430 = state_38383__$1;
(statearr_38391_38430[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (15))){
var state_38383__$1 = state_38383;
var statearr_38395_38431 = state_38383__$1;
(statearr_38395_38431[(2)] = null);

(statearr_38395_38431[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (21))){
var state_38383__$1 = state_38383;
var statearr_38396_38432 = state_38383__$1;
(statearr_38396_38432[(2)] = null);

(statearr_38396_38432[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (13))){
var inst_38335 = (state_38383[(8)]);
var inst_38338 = (state_38383[(9)]);
var inst_38336 = (state_38383[(10)]);
var inst_38337 = (state_38383[(11)]);
var inst_38345 = (state_38383[(2)]);
var inst_38346 = (inst_38338 + (1));
var tmp38392 = inst_38335;
var tmp38393 = inst_38336;
var tmp38394 = inst_38337;
var inst_38335__$1 = tmp38392;
var inst_38336__$1 = tmp38393;
var inst_38337__$1 = tmp38394;
var inst_38338__$1 = inst_38346;
var state_38383__$1 = (function (){var statearr_38397 = state_38383;
(statearr_38397[(8)] = inst_38335__$1);

(statearr_38397[(9)] = inst_38338__$1);

(statearr_38397[(10)] = inst_38336__$1);

(statearr_38397[(14)] = inst_38345);

(statearr_38397[(11)] = inst_38337__$1);

return statearr_38397;
})();
var statearr_38398_38433 = state_38383__$1;
(statearr_38398_38433[(2)] = null);

(statearr_38398_38433[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (22))){
var state_38383__$1 = state_38383;
var statearr_38399_38434 = state_38383__$1;
(statearr_38399_38434[(2)] = null);

(statearr_38399_38434[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (6))){
var inst_38324 = (state_38383[(13)]);
var inst_38333 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38324) : f.call(null,inst_38324));
var inst_38334 = cljs.core.seq(inst_38333);
var inst_38335 = inst_38334;
var inst_38336 = null;
var inst_38337 = (0);
var inst_38338 = (0);
var state_38383__$1 = (function (){var statearr_38400 = state_38383;
(statearr_38400[(8)] = inst_38335);

(statearr_38400[(9)] = inst_38338);

(statearr_38400[(10)] = inst_38336);

(statearr_38400[(11)] = inst_38337);

return statearr_38400;
})();
var statearr_38401_38435 = state_38383__$1;
(statearr_38401_38435[(2)] = null);

(statearr_38401_38435[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (17))){
var inst_38349 = (state_38383[(7)]);
var inst_38353 = cljs.core.chunk_first(inst_38349);
var inst_38354 = cljs.core.chunk_rest(inst_38349);
var inst_38355 = cljs.core.count(inst_38353);
var inst_38335 = inst_38354;
var inst_38336 = inst_38353;
var inst_38337 = inst_38355;
var inst_38338 = (0);
var state_38383__$1 = (function (){var statearr_38402 = state_38383;
(statearr_38402[(8)] = inst_38335);

(statearr_38402[(9)] = inst_38338);

(statearr_38402[(10)] = inst_38336);

(statearr_38402[(11)] = inst_38337);

return statearr_38402;
})();
var statearr_38403_38436 = state_38383__$1;
(statearr_38403_38436[(2)] = null);

(statearr_38403_38436[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (3))){
var inst_38381 = (state_38383[(2)]);
var state_38383__$1 = state_38383;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38383__$1,inst_38381);
} else {
if((state_val_38384 === (12))){
var inst_38369 = (state_38383[(2)]);
var state_38383__$1 = state_38383;
var statearr_38404_38437 = state_38383__$1;
(statearr_38404_38437[(2)] = inst_38369);

(statearr_38404_38437[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (2))){
var state_38383__$1 = state_38383;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38383__$1,(4),in$);
} else {
if((state_val_38384 === (23))){
var inst_38377 = (state_38383[(2)]);
var state_38383__$1 = state_38383;
var statearr_38405_38438 = state_38383__$1;
(statearr_38405_38438[(2)] = inst_38377);

(statearr_38405_38438[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (19))){
var inst_38364 = (state_38383[(2)]);
var state_38383__$1 = state_38383;
var statearr_38406_38439 = state_38383__$1;
(statearr_38406_38439[(2)] = inst_38364);

(statearr_38406_38439[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (11))){
var inst_38335 = (state_38383[(8)]);
var inst_38349 = (state_38383[(7)]);
var inst_38349__$1 = cljs.core.seq(inst_38335);
var state_38383__$1 = (function (){var statearr_38407 = state_38383;
(statearr_38407[(7)] = inst_38349__$1);

return statearr_38407;
})();
if(inst_38349__$1){
var statearr_38408_38440 = state_38383__$1;
(statearr_38408_38440[(1)] = (14));

} else {
var statearr_38409_38441 = state_38383__$1;
(statearr_38409_38441[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (9))){
var inst_38371 = (state_38383[(2)]);
var inst_38372 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_38383__$1 = (function (){var statearr_38410 = state_38383;
(statearr_38410[(15)] = inst_38371);

return statearr_38410;
})();
if(cljs.core.truth_(inst_38372)){
var statearr_38411_38442 = state_38383__$1;
(statearr_38411_38442[(1)] = (21));

} else {
var statearr_38412_38443 = state_38383__$1;
(statearr_38412_38443[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (5))){
var inst_38327 = cljs.core.async.close_BANG_(out);
var state_38383__$1 = state_38383;
var statearr_38413_38444 = state_38383__$1;
(statearr_38413_38444[(2)] = inst_38327);

(statearr_38413_38444[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (14))){
var inst_38349 = (state_38383[(7)]);
var inst_38351 = cljs.core.chunked_seq_QMARK_(inst_38349);
var state_38383__$1 = state_38383;
if(inst_38351){
var statearr_38414_38445 = state_38383__$1;
(statearr_38414_38445[(1)] = (17));

} else {
var statearr_38415_38446 = state_38383__$1;
(statearr_38415_38446[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (16))){
var inst_38367 = (state_38383[(2)]);
var state_38383__$1 = state_38383;
var statearr_38416_38447 = state_38383__$1;
(statearr_38416_38447[(2)] = inst_38367);

(statearr_38416_38447[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38384 === (10))){
var inst_38338 = (state_38383[(9)]);
var inst_38336 = (state_38383[(10)]);
var inst_38343 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_38336,inst_38338);
var state_38383__$1 = state_38383;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38383__$1,(13),out,inst_38343);
} else {
if((state_val_38384 === (18))){
var inst_38349 = (state_38383[(7)]);
var inst_38358 = cljs.core.first(inst_38349);
var state_38383__$1 = state_38383;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38383__$1,(20),out,inst_38358);
} else {
if((state_val_38384 === (8))){
var inst_38338 = (state_38383[(9)]);
var inst_38337 = (state_38383[(11)]);
var inst_38340 = (inst_38338 < inst_38337);
var inst_38341 = inst_38340;
var state_38383__$1 = state_38383;
if(cljs.core.truth_(inst_38341)){
var statearr_38417_38448 = state_38383__$1;
(statearr_38417_38448[(1)] = (10));

} else {
var statearr_38418_38449 = state_38383__$1;
(statearr_38418_38449[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto__))
;
return ((function (switch__8335__auto__,c__8400__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_38422 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38422[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__);

(statearr_38422[(1)] = (1));

return statearr_38422;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____1 = (function (state_38383){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_38383);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e38423){if((e38423 instanceof Object)){
var ex__8339__auto__ = e38423;
var statearr_38424_38450 = state_38383;
(statearr_38424_38450[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38383);

return cljs.core.cst$kw$recur;
} else {
throw e38423;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__38451 = state_38383;
state_38383 = G__38451;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__ = function(state_38383){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____1.call(this,state_38383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto__))
})();
var state__8402__auto__ = (function (){var statearr_38425 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_38425[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto__);

return statearr_38425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto__))
);

return c__8400__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args38452 = [];
var len__5627__auto___38455 = arguments.length;
var i__5628__auto___38456 = (0);
while(true){
if((i__5628__auto___38456 < len__5627__auto___38455)){
args38452.push((arguments[i__5628__auto___38456]));

var G__38457 = (i__5628__auto___38456 + (1));
i__5628__auto___38456 = G__38457;
continue;
} else {
}
break;
}

var G__38454 = args38452.length;
switch (G__38454) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38452.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args38459 = [];
var len__5627__auto___38462 = arguments.length;
var i__5628__auto___38463 = (0);
while(true){
if((i__5628__auto___38463 < len__5627__auto___38462)){
args38459.push((arguments[i__5628__auto___38463]));

var G__38464 = (i__5628__auto___38463 + (1));
i__5628__auto___38463 = G__38464;
continue;
} else {
}
break;
}

var G__38461 = args38459.length;
switch (G__38461) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38459.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args38466 = [];
var len__5627__auto___38517 = arguments.length;
var i__5628__auto___38518 = (0);
while(true){
if((i__5628__auto___38518 < len__5627__auto___38517)){
args38466.push((arguments[i__5628__auto___38518]));

var G__38519 = (i__5628__auto___38518 + (1));
i__5628__auto___38518 = G__38519;
continue;
} else {
}
break;
}

var G__38468 = args38466.length;
switch (G__38468) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38466.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8400__auto___38521 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___38521,out){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___38521,out){
return (function (state_38492){
var state_val_38493 = (state_38492[(1)]);
if((state_val_38493 === (7))){
var inst_38487 = (state_38492[(2)]);
var state_38492__$1 = state_38492;
var statearr_38494_38522 = state_38492__$1;
(statearr_38494_38522[(2)] = inst_38487);

(statearr_38494_38522[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38493 === (1))){
var inst_38469 = null;
var state_38492__$1 = (function (){var statearr_38495 = state_38492;
(statearr_38495[(7)] = inst_38469);

return statearr_38495;
})();
var statearr_38496_38523 = state_38492__$1;
(statearr_38496_38523[(2)] = null);

(statearr_38496_38523[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38493 === (4))){
var inst_38472 = (state_38492[(8)]);
var inst_38472__$1 = (state_38492[(2)]);
var inst_38473 = (inst_38472__$1 == null);
var inst_38474 = cljs.core.not(inst_38473);
var state_38492__$1 = (function (){var statearr_38497 = state_38492;
(statearr_38497[(8)] = inst_38472__$1);

return statearr_38497;
})();
if(inst_38474){
var statearr_38498_38524 = state_38492__$1;
(statearr_38498_38524[(1)] = (5));

} else {
var statearr_38499_38525 = state_38492__$1;
(statearr_38499_38525[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38493 === (6))){
var state_38492__$1 = state_38492;
var statearr_38500_38526 = state_38492__$1;
(statearr_38500_38526[(2)] = null);

(statearr_38500_38526[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38493 === (3))){
var inst_38489 = (state_38492[(2)]);
var inst_38490 = cljs.core.async.close_BANG_(out);
var state_38492__$1 = (function (){var statearr_38501 = state_38492;
(statearr_38501[(9)] = inst_38489);

return statearr_38501;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38492__$1,inst_38490);
} else {
if((state_val_38493 === (2))){
var state_38492__$1 = state_38492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38492__$1,(4),ch);
} else {
if((state_val_38493 === (11))){
var inst_38472 = (state_38492[(8)]);
var inst_38481 = (state_38492[(2)]);
var inst_38469 = inst_38472;
var state_38492__$1 = (function (){var statearr_38502 = state_38492;
(statearr_38502[(7)] = inst_38469);

(statearr_38502[(10)] = inst_38481);

return statearr_38502;
})();
var statearr_38503_38527 = state_38492__$1;
(statearr_38503_38527[(2)] = null);

(statearr_38503_38527[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38493 === (9))){
var inst_38472 = (state_38492[(8)]);
var state_38492__$1 = state_38492;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38492__$1,(11),out,inst_38472);
} else {
if((state_val_38493 === (5))){
var inst_38469 = (state_38492[(7)]);
var inst_38472 = (state_38492[(8)]);
var inst_38476 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38472,inst_38469);
var state_38492__$1 = state_38492;
if(inst_38476){
var statearr_38505_38528 = state_38492__$1;
(statearr_38505_38528[(1)] = (8));

} else {
var statearr_38506_38529 = state_38492__$1;
(statearr_38506_38529[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38493 === (10))){
var inst_38484 = (state_38492[(2)]);
var state_38492__$1 = state_38492;
var statearr_38507_38530 = state_38492__$1;
(statearr_38507_38530[(2)] = inst_38484);

(statearr_38507_38530[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38493 === (8))){
var inst_38469 = (state_38492[(7)]);
var tmp38504 = inst_38469;
var inst_38469__$1 = tmp38504;
var state_38492__$1 = (function (){var statearr_38508 = state_38492;
(statearr_38508[(7)] = inst_38469__$1);

return statearr_38508;
})();
var statearr_38509_38531 = state_38492__$1;
(statearr_38509_38531[(2)] = null);

(statearr_38509_38531[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___38521,out))
;
return ((function (switch__8335__auto__,c__8400__auto___38521,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_38513 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38513[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_38513[(1)] = (1));

return statearr_38513;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_38492){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_38492);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e38514){if((e38514 instanceof Object)){
var ex__8339__auto__ = e38514;
var statearr_38515_38532 = state_38492;
(statearr_38515_38532[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38492);

return cljs.core.cst$kw$recur;
} else {
throw e38514;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__38533 = state_38492;
state_38492 = G__38533;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_38492){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_38492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___38521,out))
})();
var state__8402__auto__ = (function (){var statearr_38516 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_38516[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___38521);

return statearr_38516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___38521,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args38534 = [];
var len__5627__auto___38604 = arguments.length;
var i__5628__auto___38605 = (0);
while(true){
if((i__5628__auto___38605 < len__5627__auto___38604)){
args38534.push((arguments[i__5628__auto___38605]));

var G__38606 = (i__5628__auto___38605 + (1));
i__5628__auto___38605 = G__38606;
continue;
} else {
}
break;
}

var G__38536 = args38534.length;
switch (G__38536) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38534.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8400__auto___38608 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___38608,out){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___38608,out){
return (function (state_38574){
var state_val_38575 = (state_38574[(1)]);
if((state_val_38575 === (7))){
var inst_38570 = (state_38574[(2)]);
var state_38574__$1 = state_38574;
var statearr_38576_38609 = state_38574__$1;
(statearr_38576_38609[(2)] = inst_38570);

(statearr_38576_38609[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (1))){
var inst_38537 = (new Array(n));
var inst_38538 = inst_38537;
var inst_38539 = (0);
var state_38574__$1 = (function (){var statearr_38577 = state_38574;
(statearr_38577[(7)] = inst_38538);

(statearr_38577[(8)] = inst_38539);

return statearr_38577;
})();
var statearr_38578_38610 = state_38574__$1;
(statearr_38578_38610[(2)] = null);

(statearr_38578_38610[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (4))){
var inst_38542 = (state_38574[(9)]);
var inst_38542__$1 = (state_38574[(2)]);
var inst_38543 = (inst_38542__$1 == null);
var inst_38544 = cljs.core.not(inst_38543);
var state_38574__$1 = (function (){var statearr_38579 = state_38574;
(statearr_38579[(9)] = inst_38542__$1);

return statearr_38579;
})();
if(inst_38544){
var statearr_38580_38611 = state_38574__$1;
(statearr_38580_38611[(1)] = (5));

} else {
var statearr_38581_38612 = state_38574__$1;
(statearr_38581_38612[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (15))){
var inst_38564 = (state_38574[(2)]);
var state_38574__$1 = state_38574;
var statearr_38582_38613 = state_38574__$1;
(statearr_38582_38613[(2)] = inst_38564);

(statearr_38582_38613[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (13))){
var state_38574__$1 = state_38574;
var statearr_38583_38614 = state_38574__$1;
(statearr_38583_38614[(2)] = null);

(statearr_38583_38614[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (6))){
var inst_38539 = (state_38574[(8)]);
var inst_38560 = (inst_38539 > (0));
var state_38574__$1 = state_38574;
if(cljs.core.truth_(inst_38560)){
var statearr_38584_38615 = state_38574__$1;
(statearr_38584_38615[(1)] = (12));

} else {
var statearr_38585_38616 = state_38574__$1;
(statearr_38585_38616[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (3))){
var inst_38572 = (state_38574[(2)]);
var state_38574__$1 = state_38574;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38574__$1,inst_38572);
} else {
if((state_val_38575 === (12))){
var inst_38538 = (state_38574[(7)]);
var inst_38562 = cljs.core.vec(inst_38538);
var state_38574__$1 = state_38574;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38574__$1,(15),out,inst_38562);
} else {
if((state_val_38575 === (2))){
var state_38574__$1 = state_38574;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38574__$1,(4),ch);
} else {
if((state_val_38575 === (11))){
var inst_38554 = (state_38574[(2)]);
var inst_38555 = (new Array(n));
var inst_38538 = inst_38555;
var inst_38539 = (0);
var state_38574__$1 = (function (){var statearr_38586 = state_38574;
(statearr_38586[(7)] = inst_38538);

(statearr_38586[(8)] = inst_38539);

(statearr_38586[(10)] = inst_38554);

return statearr_38586;
})();
var statearr_38587_38617 = state_38574__$1;
(statearr_38587_38617[(2)] = null);

(statearr_38587_38617[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (9))){
var inst_38538 = (state_38574[(7)]);
var inst_38552 = cljs.core.vec(inst_38538);
var state_38574__$1 = state_38574;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38574__$1,(11),out,inst_38552);
} else {
if((state_val_38575 === (5))){
var inst_38538 = (state_38574[(7)]);
var inst_38547 = (state_38574[(11)]);
var inst_38539 = (state_38574[(8)]);
var inst_38542 = (state_38574[(9)]);
var inst_38546 = (inst_38538[inst_38539] = inst_38542);
var inst_38547__$1 = (inst_38539 + (1));
var inst_38548 = (inst_38547__$1 < n);
var state_38574__$1 = (function (){var statearr_38588 = state_38574;
(statearr_38588[(11)] = inst_38547__$1);

(statearr_38588[(12)] = inst_38546);

return statearr_38588;
})();
if(cljs.core.truth_(inst_38548)){
var statearr_38589_38618 = state_38574__$1;
(statearr_38589_38618[(1)] = (8));

} else {
var statearr_38590_38619 = state_38574__$1;
(statearr_38590_38619[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (14))){
var inst_38567 = (state_38574[(2)]);
var inst_38568 = cljs.core.async.close_BANG_(out);
var state_38574__$1 = (function (){var statearr_38592 = state_38574;
(statearr_38592[(13)] = inst_38567);

return statearr_38592;
})();
var statearr_38593_38620 = state_38574__$1;
(statearr_38593_38620[(2)] = inst_38568);

(statearr_38593_38620[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (10))){
var inst_38558 = (state_38574[(2)]);
var state_38574__$1 = state_38574;
var statearr_38594_38621 = state_38574__$1;
(statearr_38594_38621[(2)] = inst_38558);

(statearr_38594_38621[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (8))){
var inst_38538 = (state_38574[(7)]);
var inst_38547 = (state_38574[(11)]);
var tmp38591 = inst_38538;
var inst_38538__$1 = tmp38591;
var inst_38539 = inst_38547;
var state_38574__$1 = (function (){var statearr_38595 = state_38574;
(statearr_38595[(7)] = inst_38538__$1);

(statearr_38595[(8)] = inst_38539);

return statearr_38595;
})();
var statearr_38596_38622 = state_38574__$1;
(statearr_38596_38622[(2)] = null);

(statearr_38596_38622[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___38608,out))
;
return ((function (switch__8335__auto__,c__8400__auto___38608,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_38600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38600[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_38600[(1)] = (1));

return statearr_38600;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_38574){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_38574);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e38601){if((e38601 instanceof Object)){
var ex__8339__auto__ = e38601;
var statearr_38602_38623 = state_38574;
(statearr_38602_38623[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38574);

return cljs.core.cst$kw$recur;
} else {
throw e38601;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__38624 = state_38574;
state_38574 = G__38624;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_38574){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_38574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___38608,out))
})();
var state__8402__auto__ = (function (){var statearr_38603 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_38603[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___38608);

return statearr_38603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___38608,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args38625 = [];
var len__5627__auto___38699 = arguments.length;
var i__5628__auto___38700 = (0);
while(true){
if((i__5628__auto___38700 < len__5627__auto___38699)){
args38625.push((arguments[i__5628__auto___38700]));

var G__38701 = (i__5628__auto___38700 + (1));
i__5628__auto___38700 = G__38701;
continue;
} else {
}
break;
}

var G__38627 = args38625.length;
switch (G__38627) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38625.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8400__auto___38703 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8400__auto___38703,out){
return (function (){
var f__8401__auto__ = (function (){var switch__8335__auto__ = ((function (c__8400__auto___38703,out){
return (function (state_38669){
var state_val_38670 = (state_38669[(1)]);
if((state_val_38670 === (7))){
var inst_38665 = (state_38669[(2)]);
var state_38669__$1 = state_38669;
var statearr_38671_38704 = state_38669__$1;
(statearr_38671_38704[(2)] = inst_38665);

(statearr_38671_38704[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38670 === (1))){
var inst_38628 = [];
var inst_38629 = inst_38628;
var inst_38630 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_38669__$1 = (function (){var statearr_38672 = state_38669;
(statearr_38672[(7)] = inst_38630);

(statearr_38672[(8)] = inst_38629);

return statearr_38672;
})();
var statearr_38673_38705 = state_38669__$1;
(statearr_38673_38705[(2)] = null);

(statearr_38673_38705[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38670 === (4))){
var inst_38633 = (state_38669[(9)]);
var inst_38633__$1 = (state_38669[(2)]);
var inst_38634 = (inst_38633__$1 == null);
var inst_38635 = cljs.core.not(inst_38634);
var state_38669__$1 = (function (){var statearr_38674 = state_38669;
(statearr_38674[(9)] = inst_38633__$1);

return statearr_38674;
})();
if(inst_38635){
var statearr_38675_38706 = state_38669__$1;
(statearr_38675_38706[(1)] = (5));

} else {
var statearr_38676_38707 = state_38669__$1;
(statearr_38676_38707[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38670 === (15))){
var inst_38659 = (state_38669[(2)]);
var state_38669__$1 = state_38669;
var statearr_38677_38708 = state_38669__$1;
(statearr_38677_38708[(2)] = inst_38659);

(statearr_38677_38708[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38670 === (13))){
var state_38669__$1 = state_38669;
var statearr_38678_38709 = state_38669__$1;
(statearr_38678_38709[(2)] = null);

(statearr_38678_38709[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38670 === (6))){
var inst_38629 = (state_38669[(8)]);
var inst_38654 = inst_38629.length;
var inst_38655 = (inst_38654 > (0));
var state_38669__$1 = state_38669;
if(cljs.core.truth_(inst_38655)){
var statearr_38679_38710 = state_38669__$1;
(statearr_38679_38710[(1)] = (12));

} else {
var statearr_38680_38711 = state_38669__$1;
(statearr_38680_38711[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38670 === (3))){
var inst_38667 = (state_38669[(2)]);
var state_38669__$1 = state_38669;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38669__$1,inst_38667);
} else {
if((state_val_38670 === (12))){
var inst_38629 = (state_38669[(8)]);
var inst_38657 = cljs.core.vec(inst_38629);
var state_38669__$1 = state_38669;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38669__$1,(15),out,inst_38657);
} else {
if((state_val_38670 === (2))){
var state_38669__$1 = state_38669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38669__$1,(4),ch);
} else {
if((state_val_38670 === (11))){
var inst_38633 = (state_38669[(9)]);
var inst_38637 = (state_38669[(10)]);
var inst_38647 = (state_38669[(2)]);
var inst_38648 = [];
var inst_38649 = inst_38648.push(inst_38633);
var inst_38629 = inst_38648;
var inst_38630 = inst_38637;
var state_38669__$1 = (function (){var statearr_38681 = state_38669;
(statearr_38681[(11)] = inst_38649);

(statearr_38681[(7)] = inst_38630);

(statearr_38681[(8)] = inst_38629);

(statearr_38681[(12)] = inst_38647);

return statearr_38681;
})();
var statearr_38682_38712 = state_38669__$1;
(statearr_38682_38712[(2)] = null);

(statearr_38682_38712[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38670 === (9))){
var inst_38629 = (state_38669[(8)]);
var inst_38645 = cljs.core.vec(inst_38629);
var state_38669__$1 = state_38669;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38669__$1,(11),out,inst_38645);
} else {
if((state_val_38670 === (5))){
var inst_38630 = (state_38669[(7)]);
var inst_38633 = (state_38669[(9)]);
var inst_38637 = (state_38669[(10)]);
var inst_38637__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38633) : f.call(null,inst_38633));
var inst_38638 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38637__$1,inst_38630);
var inst_38639 = cljs.core.keyword_identical_QMARK_(inst_38630,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_38640 = (inst_38638) || (inst_38639);
var state_38669__$1 = (function (){var statearr_38683 = state_38669;
(statearr_38683[(10)] = inst_38637__$1);

return statearr_38683;
})();
if(cljs.core.truth_(inst_38640)){
var statearr_38684_38713 = state_38669__$1;
(statearr_38684_38713[(1)] = (8));

} else {
var statearr_38685_38714 = state_38669__$1;
(statearr_38685_38714[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38670 === (14))){
var inst_38662 = (state_38669[(2)]);
var inst_38663 = cljs.core.async.close_BANG_(out);
var state_38669__$1 = (function (){var statearr_38687 = state_38669;
(statearr_38687[(13)] = inst_38662);

return statearr_38687;
})();
var statearr_38688_38715 = state_38669__$1;
(statearr_38688_38715[(2)] = inst_38663);

(statearr_38688_38715[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38670 === (10))){
var inst_38652 = (state_38669[(2)]);
var state_38669__$1 = state_38669;
var statearr_38689_38716 = state_38669__$1;
(statearr_38689_38716[(2)] = inst_38652);

(statearr_38689_38716[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38670 === (8))){
var inst_38629 = (state_38669[(8)]);
var inst_38633 = (state_38669[(9)]);
var inst_38637 = (state_38669[(10)]);
var inst_38642 = inst_38629.push(inst_38633);
var tmp38686 = inst_38629;
var inst_38629__$1 = tmp38686;
var inst_38630 = inst_38637;
var state_38669__$1 = (function (){var statearr_38690 = state_38669;
(statearr_38690[(7)] = inst_38630);

(statearr_38690[(14)] = inst_38642);

(statearr_38690[(8)] = inst_38629__$1);

return statearr_38690;
})();
var statearr_38691_38717 = state_38669__$1;
(statearr_38691_38717[(2)] = null);

(statearr_38691_38717[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8400__auto___38703,out))
;
return ((function (switch__8335__auto__,c__8400__auto___38703,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_38695 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38695[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_38695[(1)] = (1));

return statearr_38695;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_38669){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__(state_38669);
if(cljs.core.keyword_identical_QMARK_(result__8338__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e38696){if((e38696 instanceof Object)){
var ex__8339__auto__ = e38696;
var statearr_38697_38718 = state_38669;
(statearr_38697_38718[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38669);

return cljs.core.cst$kw$recur;
} else {
throw e38696;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8337__auto__,cljs.core.cst$kw$recur)){
var G__38719 = state_38669;
state_38669 = G__38719;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_38669){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_38669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8400__auto___38703,out))
})();
var state__8402__auto__ = (function (){var statearr_38698 = (f__8401__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8401__auto__.cljs$core$IFn$_invoke$arity$0() : f__8401__auto__.call(null));
(statearr_38698[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8400__auto___38703);

return statearr_38698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8402__auto__);
});})(c__8400__auto___38703,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
