// Compiled by ClojureScript 1.7.145 {}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
c2.dom.select;

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__5235__auto__ = (((x == null))?null:x);
var m__5236__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,x);
} else {
var m__5236__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return c2.dom.select.call(null,selector);
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render.call(null,v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args20369 = [];
var len__5638__auto___20372 = arguments.length;
var i__5639__auto___20373 = (0);
while(true){
if((i__5639__auto___20373 < len__5638__auto___20372)){
args20369.push((arguments[i__5639__auto___20373]));

var G__20374 = (i__5639__auto___20373 + (1));
i__5639__auto___20373 = G__20374;
continue;
} else {
}
break;
}

var G__20371 = args20369.length;
switch (G__20371) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20369.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;
/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args20376 = [];
var len__5638__auto___20379 = arguments.length;
var i__5639__auto___20380 = (0);
while(true){
if((i__5639__auto___20380 < len__5638__auto___20379)){
args20376.push((arguments[i__5639__auto___20380]));

var G__20381 = (i__5639__auto___20380 + (1));
i__5639__auto___20380 = G__20381;
continue;
} else {
}
break;
}

var G__20378 = args20376.length;
switch (G__20378) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20376.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;
/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom.call(null,node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom.call(null,node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.appendChild(c2.dom.__GT_dom.call(null,container),el__$1);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.insertChildAt(c2.dom.__GT_dom.call(null,container),el__$1,(0));

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
return goog.dom.removeNode(c2.dom.__GT_dom.call(null,el));
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom.call(null,new$);
goog.dom.replaceNode(new$__$1,c2.dom.__GT_dom.call(null,old));

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args20383 = [];
var len__5638__auto___20392 = arguments.length;
var i__5639__auto___20393 = (0);
while(true){
if((i__5639__auto___20393 < len__5638__auto___20392)){
args20383.push((arguments[i__5639__auto___20393]));

var G__20394 = (i__5639__auto___20393 + (1));
i__5639__auto___20393 = G__20394;
continue;
} else {
}
break;
}

var G__20385 = args20383.length;
switch (G__20385) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20383.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return goog.style.getComputedStyle(el__$1,cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__20386_20396 = cljs.core.seq.call(null,x);
var chunk__20387_20397 = null;
var count__20388_20398 = (0);
var i__20389_20399 = (0);
while(true){
if((i__20389_20399 < count__20388_20398)){
var vec__20390_20400 = cljs.core._nth.call(null,chunk__20387_20397,i__20389_20399);
var k_20401 = cljs.core.nth.call(null,vec__20390_20400,(0),null);
var v_20402 = cljs.core.nth.call(null,vec__20390_20400,(1),null);
c2.dom.style.call(null,el__$1,k_20401,v_20402);

var G__20403 = seq__20386_20396;
var G__20404 = chunk__20387_20397;
var G__20405 = count__20388_20398;
var G__20406 = (i__20389_20399 + (1));
seq__20386_20396 = G__20403;
chunk__20387_20397 = G__20404;
count__20388_20398 = G__20405;
i__20389_20399 = G__20406;
continue;
} else {
var temp__4657__auto___20407 = cljs.core.seq.call(null,seq__20386_20396);
if(temp__4657__auto___20407){
var seq__20386_20408__$1 = temp__4657__auto___20407;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20386_20408__$1)){
var c__5383__auto___20409 = cljs.core.chunk_first.call(null,seq__20386_20408__$1);
var G__20410 = cljs.core.chunk_rest.call(null,seq__20386_20408__$1);
var G__20411 = c__5383__auto___20409;
var G__20412 = cljs.core.count.call(null,c__5383__auto___20409);
var G__20413 = (0);
seq__20386_20396 = G__20410;
chunk__20387_20397 = G__20411;
count__20388_20398 = G__20412;
i__20389_20399 = G__20413;
continue;
} else {
var vec__20391_20414 = cljs.core.first.call(null,seq__20386_20408__$1);
var k_20415 = cljs.core.nth.call(null,vec__20391_20414,(0),null);
var v_20416 = cljs.core.nth.call(null,vec__20391_20414,(1),null);
c2.dom.style.call(null,el__$1,k_20415,v_20416);

var G__20417 = cljs.core.next.call(null,seq__20386_20408__$1);
var G__20418 = null;
var G__20419 = (0);
var G__20420 = (0);
seq__20386_20396 = G__20417;
chunk__20387_20397 = G__20418;
count__20388_20398 = G__20419;
i__20389_20399 = G__20420;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
goog.style.setStyle(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,k),((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"height","height",1025178622),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null).call(null,cljs.core.keyword.call(null,k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null)));

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args20421 = [];
var len__5638__auto___20434 = arguments.length;
var i__5639__auto___20435 = (0);
while(true){
if((i__5639__auto___20435 < len__5638__auto___20434)){
args20421.push((arguments[i__5639__auto___20435]));

var G__20436 = (i__5639__auto___20435 + (1));
i__5639__auto___20435 = G__20436;
continue;
} else {
}
break;
}

var G__20423 = args20421.length;
switch (G__20423) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20421.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom.call(null,el).attributes;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5352__auto__ = ((function (attrs){
return (function c2$dom$iter__20424(s__20425){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__20425__$1 = s__20425;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20425__$1);
if(temp__4657__auto__){
var s__20425__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20425__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__20425__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__20427 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__20426 = (0);
while(true){
if((i__20426 < size__5351__auto__)){
var i = cljs.core._nth.call(null,c__5350__auto__,i__20426);
cljs.core.chunk_append.call(null,b__20427,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null));

var G__20438 = (i__20426 + (1));
i__20426 = G__20438;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20427),c2$dom$iter__20424.call(null,cljs.core.chunk_rest.call(null,s__20425__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20427),null);
}
} else {
var i = cljs.core.first.call(null,s__20425__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__20424.call(null,cljs.core.rest.call(null,s__20425__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__5352__auto__.call(null,cljs.core.range.call(null,attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__20428_20439 = cljs.core.seq.call(null,x);
var chunk__20429_20440 = null;
var count__20430_20441 = (0);
var i__20431_20442 = (0);
while(true){
if((i__20431_20442 < count__20430_20441)){
var vec__20432_20443 = cljs.core._nth.call(null,chunk__20429_20440,i__20431_20442);
var k_20444 = cljs.core.nth.call(null,vec__20432_20443,(0),null);
var v_20445 = cljs.core.nth.call(null,vec__20432_20443,(1),null);
c2.dom.attr.call(null,el__$1,k_20444,v_20445);

var G__20446 = seq__20428_20439;
var G__20447 = chunk__20429_20440;
var G__20448 = count__20430_20441;
var G__20449 = (i__20431_20442 + (1));
seq__20428_20439 = G__20446;
chunk__20429_20440 = G__20447;
count__20430_20441 = G__20448;
i__20431_20442 = G__20449;
continue;
} else {
var temp__4657__auto___20450 = cljs.core.seq.call(null,seq__20428_20439);
if(temp__4657__auto___20450){
var seq__20428_20451__$1 = temp__4657__auto___20450;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20428_20451__$1)){
var c__5383__auto___20452 = cljs.core.chunk_first.call(null,seq__20428_20451__$1);
var G__20453 = cljs.core.chunk_rest.call(null,seq__20428_20451__$1);
var G__20454 = c__5383__auto___20452;
var G__20455 = cljs.core.count.call(null,c__5383__auto___20452);
var G__20456 = (0);
seq__20428_20439 = G__20453;
chunk__20429_20440 = G__20454;
count__20430_20441 = G__20455;
i__20431_20442 = G__20456;
continue;
} else {
var vec__20433_20457 = cljs.core.first.call(null,seq__20428_20451__$1);
var k_20458 = cljs.core.nth.call(null,vec__20433_20457,(0),null);
var v_20459 = cljs.core.nth.call(null,vec__20433_20457,(1),null);
c2.dom.attr.call(null,el__$1,k_20458,v_20459);

var G__20460 = cljs.core.next.call(null,seq__20428_20451__$1);
var G__20461 = null;
var G__20462 = (0);
var G__20463 = (0);
seq__20428_20439 = G__20460;
chunk__20429_20440 = G__20461;
count__20430_20441 = G__20462;
i__20431_20442 = G__20463;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name.call(null,k));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"style","style",-496642736),k)){
c2.dom.style.call(null,el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name.call(null,k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args20464 = [];
var len__5638__auto___20467 = arguments.length;
var i__5639__auto___20468 = (0);
while(true){
if((i__5639__auto___20468 < len__5638__auto___20467)){
args20464.push((arguments[i__5639__auto___20468]));

var G__20469 = (i__5639__auto___20468 + (1));
i__5639__auto___20468 = G__20469;
continue;
} else {
}
break;
}

var G__20466 = args20464.length;
switch (G__20466) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20464.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.getTextContent(c2.dom.__GT_dom.call(null,el));
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;
/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args20471 = [];
var len__5638__auto___20474 = arguments.length;
var i__5639__auto___20475 = (0);
while(true){
if((i__5639__auto___20475 < len__5638__auto___20474)){
args20471.push((arguments[i__5639__auto___20475]));

var G__20476 = (i__5639__auto___20475 + (1));
i__5639__auto___20475 = G__20476;
continue;
} else {
}
break;
}

var G__20473 = args20471.length;
switch (G__20473) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20471.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.forms.getValue(c2.dom.__GT_dom.call(null,el));
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;
/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
goog.dom.classes.enable(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,class$),classed_QMARK_);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__4580__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__4580__auto__)){
return or__4580__auto__;
} else {
var or__4580__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__4580__auto____$1)){
return or__4580__auto____$1;
} else {
return ((function (or__4580__auto____$1,or__4580__auto__){
return (function (p1__20478_SHARP_){
return setTimeout(((function (or__4580__auto____$1,or__4580__auto__){
return (function (){
return p1__20478_SHARP_.call(null);
});})(or__4580__auto____$1,or__4580__auto__))
,(10));
});
;})(or__4580__auto____$1,or__4580__auto__))
}
}
})();
