// Compiled by ClojureScript 1.7.145 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async14005 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14005 = (function (fn_handler,f,meta14006){
this.fn_handler = fn_handler;
this.f = f;
this.meta14006 = meta14006;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14005.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14007,meta14006__$1){
var self__ = this;
var _14007__$1 = this;
return (new cljs.core.async.t_cljs$core$async14005(self__.fn_handler,self__.f,meta14006__$1));
});

cljs.core.async.t_cljs$core$async14005.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14007){
var self__ = this;
var _14007__$1 = this;
return self__.meta14006;
});

cljs.core.async.t_cljs$core$async14005.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14005.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14005.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14005.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta14006","meta14006",322177320,null)], null);
});

cljs.core.async.t_cljs$core$async14005.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14005.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14005";

cljs.core.async.t_cljs$core$async14005.cljs$lang$ctorPrWriter = (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"cljs.core.async/t_cljs$core$async14005");
});

cljs.core.async.__GT_t_cljs$core$async14005 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async14005(fn_handler__$1,f__$1,meta14006){
return (new cljs.core.async.t_cljs$core$async14005(fn_handler__$1,f__$1,meta14006));
});

}

return (new cljs.core.async.t_cljs$core$async14005(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args14010 = [];
var len__5638__auto___14013 = arguments.length;
var i__5639__auto___14014 = (0);
while(true){
if((i__5639__auto___14014 < len__5638__auto___14013)){
args14010.push((arguments[i__5639__auto___14014]));

var G__14015 = (i__5639__auto___14014 + (1));
i__5639__auto___14014 = G__14015;
continue;
} else {
}
break;
}

var G__14012 = args14010.length;
switch (G__14012) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14010.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args14017 = [];
var len__5638__auto___14020 = arguments.length;
var i__5639__auto___14021 = (0);
while(true){
if((i__5639__auto___14021 < len__5638__auto___14020)){
args14017.push((arguments[i__5639__auto___14021]));

var G__14022 = (i__5639__auto___14021 + (1));
i__5639__auto___14021 = G__14022;
continue;
} else {
}
break;
}

var G__14019 = args14017.length;
switch (G__14019) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14017.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_14024 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_14024);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_14024,ret){
return (function (){
return fn1.call(null,val_14024);
});})(val_14024,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args14025 = [];
var len__5638__auto___14028 = arguments.length;
var i__5639__auto___14029 = (0);
while(true){
if((i__5639__auto___14029 < len__5638__auto___14028)){
args14025.push((arguments[i__5639__auto___14029]));

var G__14030 = (i__5639__auto___14029 + (1));
i__5639__auto___14029 = G__14030;
continue;
} else {
}
break;
}

var G__14027 = args14025.length;
switch (G__14027) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14025.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5483__auto___14032 = n;
var x_14033 = (0);
while(true){
if((x_14033 < n__5483__auto___14032)){
(a[x_14033] = (0));

var G__14034 = (x_14033 + (1));
x_14033 = G__14034;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__14035 = (i + (1));
i = G__14035;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async14039 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14039 = (function (alt_flag,flag,meta14040){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta14040 = meta14040;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14039.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14041,meta14040__$1){
var self__ = this;
var _14041__$1 = this;
return (new cljs.core.async.t_cljs$core$async14039(self__.alt_flag,self__.flag,meta14040__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14039.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14041){
var self__ = this;
var _14041__$1 = this;
return self__.meta14040;
});})(flag))
;

cljs.core.async.t_cljs$core$async14039.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14039.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async14039.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14039.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14040","meta14040",1017363724,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14039.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14039.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14039";

cljs.core.async.t_cljs$core$async14039.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"cljs.core.async/t_cljs$core$async14039");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14039 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14039(alt_flag__$1,flag__$1,meta14040){
return (new cljs.core.async.t_cljs$core$async14039(alt_flag__$1,flag__$1,meta14040));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14039(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14045 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14045 = (function (alt_handler,flag,cb,meta14046){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta14046 = meta14046;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14045.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14047,meta14046__$1){
var self__ = this;
var _14047__$1 = this;
return (new cljs.core.async.t_cljs$core$async14045(self__.alt_handler,self__.flag,self__.cb,meta14046__$1));
});

cljs.core.async.t_cljs$core$async14045.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14047){
var self__ = this;
var _14047__$1 = this;
return self__.meta14046;
});

cljs.core.async.t_cljs$core$async14045.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14045.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async14045.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14045.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14046","meta14046",2108185609,null)], null);
});

cljs.core.async.t_cljs$core$async14045.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14045.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14045";

cljs.core.async.t_cljs$core$async14045.cljs$lang$ctorPrWriter = (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"cljs.core.async/t_cljs$core$async14045");
});

cljs.core.async.__GT_t_cljs$core$async14045 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14045(alt_handler__$1,flag__$1,cb__$1,meta14046){
return (new cljs.core.async.t_cljs$core$async14045(alt_handler__$1,flag__$1,cb__$1,meta14046));
});

}

return (new cljs.core.async.t_cljs$core$async14045(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14048_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14048_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14049_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14049_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4580__auto__ = wport;
if(cljs.core.truth_(or__4580__auto__)){
return or__4580__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14050 = (i + (1));
i = G__14050;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4580__auto__ = ret;
if(cljs.core.truth_(or__4580__auto__)){
return or__4580__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__4568__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4568__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4568__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5645__auto__ = [];
var len__5638__auto___14056 = arguments.length;
var i__5639__auto___14057 = (0);
while(true){
if((i__5639__auto___14057 < len__5638__auto___14056)){
args__5645__auto__.push((arguments[i__5639__auto___14057]));

var G__14058 = (i__5639__auto___14057 + (1));
i__5639__auto___14057 = G__14058;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((1) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5646__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14053){
var map__14054 = p__14053;
var map__14054__$1 = ((((!((map__14054 == null)))?((((map__14054.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14054.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14054):map__14054);
var opts = map__14054__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14051){
var G__14052 = cljs.core.first.call(null,seq14051);
var seq14051__$1 = cljs.core.next.call(null,seq14051);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14052,seq14051__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args14059 = [];
var len__5638__auto___14109 = arguments.length;
var i__5639__auto___14110 = (0);
while(true){
if((i__5639__auto___14110 < len__5638__auto___14109)){
args14059.push((arguments[i__5639__auto___14110]));

var G__14111 = (i__5639__auto___14110 + (1));
i__5639__auto___14110 = G__14111;
continue;
} else {
}
break;
}

var G__14061 = args14059.length;
switch (G__14061) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14059.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8287__auto___14113 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___14113){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___14113){
return (function (state_14085){
var state_val_14086 = (state_14085[(1)]);
if((state_val_14086 === (7))){
var inst_14081 = (state_14085[(2)]);
var state_14085__$1 = state_14085;
var statearr_14087_14114 = state_14085__$1;
(statearr_14087_14114[(2)] = inst_14081);

(statearr_14087_14114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14086 === (1))){
var state_14085__$1 = state_14085;
var statearr_14088_14115 = state_14085__$1;
(statearr_14088_14115[(2)] = null);

(statearr_14088_14115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14086 === (4))){
var inst_14064 = (state_14085[(7)]);
var inst_14064__$1 = (state_14085[(2)]);
var inst_14065 = (inst_14064__$1 == null);
var state_14085__$1 = (function (){var statearr_14089 = state_14085;
(statearr_14089[(7)] = inst_14064__$1);

return statearr_14089;
})();
if(cljs.core.truth_(inst_14065)){
var statearr_14090_14116 = state_14085__$1;
(statearr_14090_14116[(1)] = (5));

} else {
var statearr_14091_14117 = state_14085__$1;
(statearr_14091_14117[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14086 === (13))){
var state_14085__$1 = state_14085;
var statearr_14092_14118 = state_14085__$1;
(statearr_14092_14118[(2)] = null);

(statearr_14092_14118[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14086 === (6))){
var inst_14064 = (state_14085[(7)]);
var state_14085__$1 = state_14085;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14085__$1,(11),to,inst_14064);
} else {
if((state_val_14086 === (3))){
var inst_14083 = (state_14085[(2)]);
var state_14085__$1 = state_14085;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14085__$1,inst_14083);
} else {
if((state_val_14086 === (12))){
var state_14085__$1 = state_14085;
var statearr_14093_14119 = state_14085__$1;
(statearr_14093_14119[(2)] = null);

(statearr_14093_14119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14086 === (2))){
var state_14085__$1 = state_14085;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14085__$1,(4),from);
} else {
if((state_val_14086 === (11))){
var inst_14074 = (state_14085[(2)]);
var state_14085__$1 = state_14085;
if(cljs.core.truth_(inst_14074)){
var statearr_14094_14120 = state_14085__$1;
(statearr_14094_14120[(1)] = (12));

} else {
var statearr_14095_14121 = state_14085__$1;
(statearr_14095_14121[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14086 === (9))){
var state_14085__$1 = state_14085;
var statearr_14096_14122 = state_14085__$1;
(statearr_14096_14122[(2)] = null);

(statearr_14096_14122[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14086 === (5))){
var state_14085__$1 = state_14085;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14097_14123 = state_14085__$1;
(statearr_14097_14123[(1)] = (8));

} else {
var statearr_14098_14124 = state_14085__$1;
(statearr_14098_14124[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14086 === (14))){
var inst_14079 = (state_14085[(2)]);
var state_14085__$1 = state_14085;
var statearr_14099_14125 = state_14085__$1;
(statearr_14099_14125[(2)] = inst_14079);

(statearr_14099_14125[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14086 === (10))){
var inst_14071 = (state_14085[(2)]);
var state_14085__$1 = state_14085;
var statearr_14100_14126 = state_14085__$1;
(statearr_14100_14126[(2)] = inst_14071);

(statearr_14100_14126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14086 === (8))){
var inst_14068 = cljs.core.async.close_BANG_.call(null,to);
var state_14085__$1 = state_14085;
var statearr_14101_14127 = state_14085__$1;
(statearr_14101_14127[(2)] = inst_14068);

(statearr_14101_14127[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto___14113))
;
return ((function (switch__8266__auto__,c__8287__auto___14113){
return (function() {
var cljs$core$async$state_machine__8267__auto__ = null;
var cljs$core$async$state_machine__8267__auto____0 = (function (){
var statearr_14105 = [null,null,null,null,null,null,null,null];
(statearr_14105[(0)] = cljs$core$async$state_machine__8267__auto__);

(statearr_14105[(1)] = (1));

return statearr_14105;
});
var cljs$core$async$state_machine__8267__auto____1 = (function (state_14085){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_14085);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e14106){if((e14106 instanceof Object)){
var ex__8270__auto__ = e14106;
var statearr_14107_14128 = state_14085;
(statearr_14107_14128[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14085);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14106;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14129 = state_14085;
state_14085 = G__14129;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$state_machine__8267__auto__ = function(state_14085){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8267__auto____1.call(this,state_14085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8267__auto____0;
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8267__auto____1;
return cljs$core$async$state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___14113))
})();
var state__8289__auto__ = (function (){var statearr_14108 = f__8288__auto__.call(null);
(statearr_14108[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___14113);

return statearr_14108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___14113))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14313){
var vec__14314 = p__14313;
var v = cljs.core.nth.call(null,vec__14314,(0),null);
var p = cljs.core.nth.call(null,vec__14314,(1),null);
var job = vec__14314;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8287__auto___14496 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___14496,res,vec__14314,v,p,job,jobs,results){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___14496,res,vec__14314,v,p,job,jobs,results){
return (function (state_14319){
var state_val_14320 = (state_14319[(1)]);
if((state_val_14320 === (1))){
var state_14319__$1 = state_14319;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14319__$1,(2),res,v);
} else {
if((state_val_14320 === (2))){
var inst_14316 = (state_14319[(2)]);
var inst_14317 = cljs.core.async.close_BANG_.call(null,res);
var state_14319__$1 = (function (){var statearr_14321 = state_14319;
(statearr_14321[(7)] = inst_14316);

return statearr_14321;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14319__$1,inst_14317);
} else {
return null;
}
}
});})(c__8287__auto___14496,res,vec__14314,v,p,job,jobs,results))
;
return ((function (switch__8266__auto__,c__8287__auto___14496,res,vec__14314,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0 = (function (){
var statearr_14325 = [null,null,null,null,null,null,null,null];
(statearr_14325[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__);

(statearr_14325[(1)] = (1));

return statearr_14325;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1 = (function (state_14319){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_14319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e14326){if((e14326 instanceof Object)){
var ex__8270__auto__ = e14326;
var statearr_14327_14497 = state_14319;
(statearr_14327_14497[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14319);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14326;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14498 = state_14319;
state_14319 = G__14498;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__ = function(state_14319){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1.call(this,state_14319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___14496,res,vec__14314,v,p,job,jobs,results))
})();
var state__8289__auto__ = (function (){var statearr_14328 = f__8288__auto__.call(null);
(statearr_14328[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___14496);

return statearr_14328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___14496,res,vec__14314,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14329){
var vec__14330 = p__14329;
var v = cljs.core.nth.call(null,vec__14330,(0),null);
var p = cljs.core.nth.call(null,vec__14330,(1),null);
var job = vec__14330;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5483__auto___14499 = n;
var __14500 = (0);
while(true){
if((__14500 < n__5483__auto___14499)){
var G__14331_14501 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14331_14501) {
case "compute":
var c__8287__auto___14503 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__14500,c__8287__auto___14503,G__14331_14501,n__5483__auto___14499,jobs,results,process,async){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (__14500,c__8287__auto___14503,G__14331_14501,n__5483__auto___14499,jobs,results,process,async){
return (function (state_14344){
var state_val_14345 = (state_14344[(1)]);
if((state_val_14345 === (1))){
var state_14344__$1 = state_14344;
var statearr_14346_14504 = state_14344__$1;
(statearr_14346_14504[(2)] = null);

(statearr_14346_14504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (2))){
var state_14344__$1 = state_14344;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14344__$1,(4),jobs);
} else {
if((state_val_14345 === (3))){
var inst_14342 = (state_14344[(2)]);
var state_14344__$1 = state_14344;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14344__$1,inst_14342);
} else {
if((state_val_14345 === (4))){
var inst_14334 = (state_14344[(2)]);
var inst_14335 = process.call(null,inst_14334);
var state_14344__$1 = state_14344;
if(cljs.core.truth_(inst_14335)){
var statearr_14347_14505 = state_14344__$1;
(statearr_14347_14505[(1)] = (5));

} else {
var statearr_14348_14506 = state_14344__$1;
(statearr_14348_14506[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (5))){
var state_14344__$1 = state_14344;
var statearr_14349_14507 = state_14344__$1;
(statearr_14349_14507[(2)] = null);

(statearr_14349_14507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (6))){
var state_14344__$1 = state_14344;
var statearr_14350_14508 = state_14344__$1;
(statearr_14350_14508[(2)] = null);

(statearr_14350_14508[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (7))){
var inst_14340 = (state_14344[(2)]);
var state_14344__$1 = state_14344;
var statearr_14351_14509 = state_14344__$1;
(statearr_14351_14509[(2)] = inst_14340);

(statearr_14351_14509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14500,c__8287__auto___14503,G__14331_14501,n__5483__auto___14499,jobs,results,process,async))
;
return ((function (__14500,switch__8266__auto__,c__8287__auto___14503,G__14331_14501,n__5483__auto___14499,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0 = (function (){
var statearr_14355 = [null,null,null,null,null,null,null];
(statearr_14355[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__);

(statearr_14355[(1)] = (1));

return statearr_14355;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1 = (function (state_14344){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_14344);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e14356){if((e14356 instanceof Object)){
var ex__8270__auto__ = e14356;
var statearr_14357_14510 = state_14344;
(statearr_14357_14510[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14344);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14356;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14511 = state_14344;
state_14344 = G__14511;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__ = function(state_14344){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1.call(this,state_14344);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__;
})()
;})(__14500,switch__8266__auto__,c__8287__auto___14503,G__14331_14501,n__5483__auto___14499,jobs,results,process,async))
})();
var state__8289__auto__ = (function (){var statearr_14358 = f__8288__auto__.call(null);
(statearr_14358[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___14503);

return statearr_14358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(__14500,c__8287__auto___14503,G__14331_14501,n__5483__auto___14499,jobs,results,process,async))
);


break;
case "async":
var c__8287__auto___14512 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__14500,c__8287__auto___14512,G__14331_14501,n__5483__auto___14499,jobs,results,process,async){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (__14500,c__8287__auto___14512,G__14331_14501,n__5483__auto___14499,jobs,results,process,async){
return (function (state_14371){
var state_val_14372 = (state_14371[(1)]);
if((state_val_14372 === (1))){
var state_14371__$1 = state_14371;
var statearr_14373_14513 = state_14371__$1;
(statearr_14373_14513[(2)] = null);

(statearr_14373_14513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14372 === (2))){
var state_14371__$1 = state_14371;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14371__$1,(4),jobs);
} else {
if((state_val_14372 === (3))){
var inst_14369 = (state_14371[(2)]);
var state_14371__$1 = state_14371;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14371__$1,inst_14369);
} else {
if((state_val_14372 === (4))){
var inst_14361 = (state_14371[(2)]);
var inst_14362 = async.call(null,inst_14361);
var state_14371__$1 = state_14371;
if(cljs.core.truth_(inst_14362)){
var statearr_14374_14514 = state_14371__$1;
(statearr_14374_14514[(1)] = (5));

} else {
var statearr_14375_14515 = state_14371__$1;
(statearr_14375_14515[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14372 === (5))){
var state_14371__$1 = state_14371;
var statearr_14376_14516 = state_14371__$1;
(statearr_14376_14516[(2)] = null);

(statearr_14376_14516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14372 === (6))){
var state_14371__$1 = state_14371;
var statearr_14377_14517 = state_14371__$1;
(statearr_14377_14517[(2)] = null);

(statearr_14377_14517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14372 === (7))){
var inst_14367 = (state_14371[(2)]);
var state_14371__$1 = state_14371;
var statearr_14378_14518 = state_14371__$1;
(statearr_14378_14518[(2)] = inst_14367);

(statearr_14378_14518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14500,c__8287__auto___14512,G__14331_14501,n__5483__auto___14499,jobs,results,process,async))
;
return ((function (__14500,switch__8266__auto__,c__8287__auto___14512,G__14331_14501,n__5483__auto___14499,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0 = (function (){
var statearr_14382 = [null,null,null,null,null,null,null];
(statearr_14382[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__);

(statearr_14382[(1)] = (1));

return statearr_14382;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1 = (function (state_14371){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_14371);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e14383){if((e14383 instanceof Object)){
var ex__8270__auto__ = e14383;
var statearr_14384_14519 = state_14371;
(statearr_14384_14519[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14371);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14383;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14520 = state_14371;
state_14371 = G__14520;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__ = function(state_14371){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1.call(this,state_14371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__;
})()
;})(__14500,switch__8266__auto__,c__8287__auto___14512,G__14331_14501,n__5483__auto___14499,jobs,results,process,async))
})();
var state__8289__auto__ = (function (){var statearr_14385 = f__8288__auto__.call(null);
(statearr_14385[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___14512);

return statearr_14385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(__14500,c__8287__auto___14512,G__14331_14501,n__5483__auto___14499,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__14521 = (__14500 + (1));
__14500 = G__14521;
continue;
} else {
}
break;
}

var c__8287__auto___14522 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___14522,jobs,results,process,async){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___14522,jobs,results,process,async){
return (function (state_14407){
var state_val_14408 = (state_14407[(1)]);
if((state_val_14408 === (1))){
var state_14407__$1 = state_14407;
var statearr_14409_14523 = state_14407__$1;
(statearr_14409_14523[(2)] = null);

(statearr_14409_14523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14408 === (2))){
var state_14407__$1 = state_14407;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14407__$1,(4),from);
} else {
if((state_val_14408 === (3))){
var inst_14405 = (state_14407[(2)]);
var state_14407__$1 = state_14407;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14407__$1,inst_14405);
} else {
if((state_val_14408 === (4))){
var inst_14388 = (state_14407[(7)]);
var inst_14388__$1 = (state_14407[(2)]);
var inst_14389 = (inst_14388__$1 == null);
var state_14407__$1 = (function (){var statearr_14410 = state_14407;
(statearr_14410[(7)] = inst_14388__$1);

return statearr_14410;
})();
if(cljs.core.truth_(inst_14389)){
var statearr_14411_14524 = state_14407__$1;
(statearr_14411_14524[(1)] = (5));

} else {
var statearr_14412_14525 = state_14407__$1;
(statearr_14412_14525[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14408 === (5))){
var inst_14391 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14407__$1 = state_14407;
var statearr_14413_14526 = state_14407__$1;
(statearr_14413_14526[(2)] = inst_14391);

(statearr_14413_14526[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14408 === (6))){
var inst_14393 = (state_14407[(8)]);
var inst_14388 = (state_14407[(7)]);
var inst_14393__$1 = cljs.core.async.chan.call(null,(1));
var inst_14394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14395 = [inst_14388,inst_14393__$1];
var inst_14396 = (new cljs.core.PersistentVector(null,2,(5),inst_14394,inst_14395,null));
var state_14407__$1 = (function (){var statearr_14414 = state_14407;
(statearr_14414[(8)] = inst_14393__$1);

return statearr_14414;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14407__$1,(8),jobs,inst_14396);
} else {
if((state_val_14408 === (7))){
var inst_14403 = (state_14407[(2)]);
var state_14407__$1 = state_14407;
var statearr_14415_14527 = state_14407__$1;
(statearr_14415_14527[(2)] = inst_14403);

(statearr_14415_14527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14408 === (8))){
var inst_14393 = (state_14407[(8)]);
var inst_14398 = (state_14407[(2)]);
var state_14407__$1 = (function (){var statearr_14416 = state_14407;
(statearr_14416[(9)] = inst_14398);

return statearr_14416;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14407__$1,(9),results,inst_14393);
} else {
if((state_val_14408 === (9))){
var inst_14400 = (state_14407[(2)]);
var state_14407__$1 = (function (){var statearr_14417 = state_14407;
(statearr_14417[(10)] = inst_14400);

return statearr_14417;
})();
var statearr_14418_14528 = state_14407__$1;
(statearr_14418_14528[(2)] = null);

(statearr_14418_14528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8287__auto___14522,jobs,results,process,async))
;
return ((function (switch__8266__auto__,c__8287__auto___14522,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0 = (function (){
var statearr_14422 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14422[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__);

(statearr_14422[(1)] = (1));

return statearr_14422;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1 = (function (state_14407){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_14407);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e14423){if((e14423 instanceof Object)){
var ex__8270__auto__ = e14423;
var statearr_14424_14529 = state_14407;
(statearr_14424_14529[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14407);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14423;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14530 = state_14407;
state_14407 = G__14530;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__ = function(state_14407){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1.call(this,state_14407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___14522,jobs,results,process,async))
})();
var state__8289__auto__ = (function (){var statearr_14425 = f__8288__auto__.call(null);
(statearr_14425[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___14522);

return statearr_14425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___14522,jobs,results,process,async))
);


var c__8287__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto__,jobs,results,process,async){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto__,jobs,results,process,async){
return (function (state_14463){
var state_val_14464 = (state_14463[(1)]);
if((state_val_14464 === (7))){
var inst_14459 = (state_14463[(2)]);
var state_14463__$1 = state_14463;
var statearr_14465_14531 = state_14463__$1;
(statearr_14465_14531[(2)] = inst_14459);

(statearr_14465_14531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (20))){
var state_14463__$1 = state_14463;
var statearr_14466_14532 = state_14463__$1;
(statearr_14466_14532[(2)] = null);

(statearr_14466_14532[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (1))){
var state_14463__$1 = state_14463;
var statearr_14467_14533 = state_14463__$1;
(statearr_14467_14533[(2)] = null);

(statearr_14467_14533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (4))){
var inst_14428 = (state_14463[(7)]);
var inst_14428__$1 = (state_14463[(2)]);
var inst_14429 = (inst_14428__$1 == null);
var state_14463__$1 = (function (){var statearr_14468 = state_14463;
(statearr_14468[(7)] = inst_14428__$1);

return statearr_14468;
})();
if(cljs.core.truth_(inst_14429)){
var statearr_14469_14534 = state_14463__$1;
(statearr_14469_14534[(1)] = (5));

} else {
var statearr_14470_14535 = state_14463__$1;
(statearr_14470_14535[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (15))){
var inst_14441 = (state_14463[(8)]);
var state_14463__$1 = state_14463;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14463__$1,(18),to,inst_14441);
} else {
if((state_val_14464 === (21))){
var inst_14454 = (state_14463[(2)]);
var state_14463__$1 = state_14463;
var statearr_14471_14536 = state_14463__$1;
(statearr_14471_14536[(2)] = inst_14454);

(statearr_14471_14536[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (13))){
var inst_14456 = (state_14463[(2)]);
var state_14463__$1 = (function (){var statearr_14472 = state_14463;
(statearr_14472[(9)] = inst_14456);

return statearr_14472;
})();
var statearr_14473_14537 = state_14463__$1;
(statearr_14473_14537[(2)] = null);

(statearr_14473_14537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (6))){
var inst_14428 = (state_14463[(7)]);
var state_14463__$1 = state_14463;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14463__$1,(11),inst_14428);
} else {
if((state_val_14464 === (17))){
var inst_14449 = (state_14463[(2)]);
var state_14463__$1 = state_14463;
if(cljs.core.truth_(inst_14449)){
var statearr_14474_14538 = state_14463__$1;
(statearr_14474_14538[(1)] = (19));

} else {
var statearr_14475_14539 = state_14463__$1;
(statearr_14475_14539[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (3))){
var inst_14461 = (state_14463[(2)]);
var state_14463__$1 = state_14463;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14463__$1,inst_14461);
} else {
if((state_val_14464 === (12))){
var inst_14438 = (state_14463[(10)]);
var state_14463__$1 = state_14463;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14463__$1,(14),inst_14438);
} else {
if((state_val_14464 === (2))){
var state_14463__$1 = state_14463;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14463__$1,(4),results);
} else {
if((state_val_14464 === (19))){
var state_14463__$1 = state_14463;
var statearr_14476_14540 = state_14463__$1;
(statearr_14476_14540[(2)] = null);

(statearr_14476_14540[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (11))){
var inst_14438 = (state_14463[(2)]);
var state_14463__$1 = (function (){var statearr_14477 = state_14463;
(statearr_14477[(10)] = inst_14438);

return statearr_14477;
})();
var statearr_14478_14541 = state_14463__$1;
(statearr_14478_14541[(2)] = null);

(statearr_14478_14541[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (9))){
var state_14463__$1 = state_14463;
var statearr_14479_14542 = state_14463__$1;
(statearr_14479_14542[(2)] = null);

(statearr_14479_14542[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (5))){
var state_14463__$1 = state_14463;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14480_14543 = state_14463__$1;
(statearr_14480_14543[(1)] = (8));

} else {
var statearr_14481_14544 = state_14463__$1;
(statearr_14481_14544[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (14))){
var inst_14441 = (state_14463[(8)]);
var inst_14443 = (state_14463[(11)]);
var inst_14441__$1 = (state_14463[(2)]);
var inst_14442 = (inst_14441__$1 == null);
var inst_14443__$1 = cljs.core.not.call(null,inst_14442);
var state_14463__$1 = (function (){var statearr_14482 = state_14463;
(statearr_14482[(8)] = inst_14441__$1);

(statearr_14482[(11)] = inst_14443__$1);

return statearr_14482;
})();
if(inst_14443__$1){
var statearr_14483_14545 = state_14463__$1;
(statearr_14483_14545[(1)] = (15));

} else {
var statearr_14484_14546 = state_14463__$1;
(statearr_14484_14546[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (16))){
var inst_14443 = (state_14463[(11)]);
var state_14463__$1 = state_14463;
var statearr_14485_14547 = state_14463__$1;
(statearr_14485_14547[(2)] = inst_14443);

(statearr_14485_14547[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (10))){
var inst_14435 = (state_14463[(2)]);
var state_14463__$1 = state_14463;
var statearr_14486_14548 = state_14463__$1;
(statearr_14486_14548[(2)] = inst_14435);

(statearr_14486_14548[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (18))){
var inst_14446 = (state_14463[(2)]);
var state_14463__$1 = state_14463;
var statearr_14487_14549 = state_14463__$1;
(statearr_14487_14549[(2)] = inst_14446);

(statearr_14487_14549[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14464 === (8))){
var inst_14432 = cljs.core.async.close_BANG_.call(null,to);
var state_14463__$1 = state_14463;
var statearr_14488_14550 = state_14463__$1;
(statearr_14488_14550[(2)] = inst_14432);

(statearr_14488_14550[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto__,jobs,results,process,async))
;
return ((function (switch__8266__auto__,c__8287__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0 = (function (){
var statearr_14492 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14492[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__);

(statearr_14492[(1)] = (1));

return statearr_14492;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1 = (function (state_14463){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_14463);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e14493){if((e14493 instanceof Object)){
var ex__8270__auto__ = e14493;
var statearr_14494_14551 = state_14463;
(statearr_14494_14551[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14463);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14493;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14552 = state_14463;
state_14463 = G__14552;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__ = function(state_14463){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1.call(this,state_14463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8267__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto__,jobs,results,process,async))
})();
var state__8289__auto__ = (function (){var statearr_14495 = f__8288__auto__.call(null);
(statearr_14495[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto__);

return statearr_14495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto__,jobs,results,process,async))
);

return c__8287__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args14553 = [];
var len__5638__auto___14556 = arguments.length;
var i__5639__auto___14557 = (0);
while(true){
if((i__5639__auto___14557 < len__5638__auto___14556)){
args14553.push((arguments[i__5639__auto___14557]));

var G__14558 = (i__5639__auto___14557 + (1));
i__5639__auto___14557 = G__14558;
continue;
} else {
}
break;
}

var G__14555 = args14553.length;
switch (G__14555) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14553.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args14560 = [];
var len__5638__auto___14563 = arguments.length;
var i__5639__auto___14564 = (0);
while(true){
if((i__5639__auto___14564 < len__5638__auto___14563)){
args14560.push((arguments[i__5639__auto___14564]));

var G__14565 = (i__5639__auto___14564 + (1));
i__5639__auto___14564 = G__14565;
continue;
} else {
}
break;
}

var G__14562 = args14560.length;
switch (G__14562) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14560.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args14567 = [];
var len__5638__auto___14620 = arguments.length;
var i__5639__auto___14621 = (0);
while(true){
if((i__5639__auto___14621 < len__5638__auto___14620)){
args14567.push((arguments[i__5639__auto___14621]));

var G__14622 = (i__5639__auto___14621 + (1));
i__5639__auto___14621 = G__14622;
continue;
} else {
}
break;
}

var G__14569 = args14567.length;
switch (G__14569) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14567.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8287__auto___14624 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___14624,tc,fc){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___14624,tc,fc){
return (function (state_14595){
var state_val_14596 = (state_14595[(1)]);
if((state_val_14596 === (7))){
var inst_14591 = (state_14595[(2)]);
var state_14595__$1 = state_14595;
var statearr_14597_14625 = state_14595__$1;
(statearr_14597_14625[(2)] = inst_14591);

(statearr_14597_14625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14596 === (1))){
var state_14595__$1 = state_14595;
var statearr_14598_14626 = state_14595__$1;
(statearr_14598_14626[(2)] = null);

(statearr_14598_14626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14596 === (4))){
var inst_14572 = (state_14595[(7)]);
var inst_14572__$1 = (state_14595[(2)]);
var inst_14573 = (inst_14572__$1 == null);
var state_14595__$1 = (function (){var statearr_14599 = state_14595;
(statearr_14599[(7)] = inst_14572__$1);

return statearr_14599;
})();
if(cljs.core.truth_(inst_14573)){
var statearr_14600_14627 = state_14595__$1;
(statearr_14600_14627[(1)] = (5));

} else {
var statearr_14601_14628 = state_14595__$1;
(statearr_14601_14628[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14596 === (13))){
var state_14595__$1 = state_14595;
var statearr_14602_14629 = state_14595__$1;
(statearr_14602_14629[(2)] = null);

(statearr_14602_14629[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14596 === (6))){
var inst_14572 = (state_14595[(7)]);
var inst_14578 = p.call(null,inst_14572);
var state_14595__$1 = state_14595;
if(cljs.core.truth_(inst_14578)){
var statearr_14603_14630 = state_14595__$1;
(statearr_14603_14630[(1)] = (9));

} else {
var statearr_14604_14631 = state_14595__$1;
(statearr_14604_14631[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14596 === (3))){
var inst_14593 = (state_14595[(2)]);
var state_14595__$1 = state_14595;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14595__$1,inst_14593);
} else {
if((state_val_14596 === (12))){
var state_14595__$1 = state_14595;
var statearr_14605_14632 = state_14595__$1;
(statearr_14605_14632[(2)] = null);

(statearr_14605_14632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14596 === (2))){
var state_14595__$1 = state_14595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14595__$1,(4),ch);
} else {
if((state_val_14596 === (11))){
var inst_14572 = (state_14595[(7)]);
var inst_14582 = (state_14595[(2)]);
var state_14595__$1 = state_14595;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14595__$1,(8),inst_14582,inst_14572);
} else {
if((state_val_14596 === (9))){
var state_14595__$1 = state_14595;
var statearr_14606_14633 = state_14595__$1;
(statearr_14606_14633[(2)] = tc);

(statearr_14606_14633[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14596 === (5))){
var inst_14575 = cljs.core.async.close_BANG_.call(null,tc);
var inst_14576 = cljs.core.async.close_BANG_.call(null,fc);
var state_14595__$1 = (function (){var statearr_14607 = state_14595;
(statearr_14607[(8)] = inst_14575);

return statearr_14607;
})();
var statearr_14608_14634 = state_14595__$1;
(statearr_14608_14634[(2)] = inst_14576);

(statearr_14608_14634[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14596 === (14))){
var inst_14589 = (state_14595[(2)]);
var state_14595__$1 = state_14595;
var statearr_14609_14635 = state_14595__$1;
(statearr_14609_14635[(2)] = inst_14589);

(statearr_14609_14635[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14596 === (10))){
var state_14595__$1 = state_14595;
var statearr_14610_14636 = state_14595__$1;
(statearr_14610_14636[(2)] = fc);

(statearr_14610_14636[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14596 === (8))){
var inst_14584 = (state_14595[(2)]);
var state_14595__$1 = state_14595;
if(cljs.core.truth_(inst_14584)){
var statearr_14611_14637 = state_14595__$1;
(statearr_14611_14637[(1)] = (12));

} else {
var statearr_14612_14638 = state_14595__$1;
(statearr_14612_14638[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto___14624,tc,fc))
;
return ((function (switch__8266__auto__,c__8287__auto___14624,tc,fc){
return (function() {
var cljs$core$async$state_machine__8267__auto__ = null;
var cljs$core$async$state_machine__8267__auto____0 = (function (){
var statearr_14616 = [null,null,null,null,null,null,null,null,null];
(statearr_14616[(0)] = cljs$core$async$state_machine__8267__auto__);

(statearr_14616[(1)] = (1));

return statearr_14616;
});
var cljs$core$async$state_machine__8267__auto____1 = (function (state_14595){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_14595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e14617){if((e14617 instanceof Object)){
var ex__8270__auto__ = e14617;
var statearr_14618_14639 = state_14595;
(statearr_14618_14639[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14595);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14617;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14640 = state_14595;
state_14595 = G__14640;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$state_machine__8267__auto__ = function(state_14595){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8267__auto____1.call(this,state_14595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8267__auto____0;
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8267__auto____1;
return cljs$core$async$state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___14624,tc,fc))
})();
var state__8289__auto__ = (function (){var statearr_14619 = f__8288__auto__.call(null);
(statearr_14619[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___14624);

return statearr_14619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___14624,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8287__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto__){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto__){
return (function (state_14687){
var state_val_14688 = (state_14687[(1)]);
if((state_val_14688 === (1))){
var inst_14673 = init;
var state_14687__$1 = (function (){var statearr_14689 = state_14687;
(statearr_14689[(7)] = inst_14673);

return statearr_14689;
})();
var statearr_14690_14705 = state_14687__$1;
(statearr_14690_14705[(2)] = null);

(statearr_14690_14705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14688 === (2))){
var state_14687__$1 = state_14687;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14687__$1,(4),ch);
} else {
if((state_val_14688 === (3))){
var inst_14685 = (state_14687[(2)]);
var state_14687__$1 = state_14687;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14687__$1,inst_14685);
} else {
if((state_val_14688 === (4))){
var inst_14676 = (state_14687[(8)]);
var inst_14676__$1 = (state_14687[(2)]);
var inst_14677 = (inst_14676__$1 == null);
var state_14687__$1 = (function (){var statearr_14691 = state_14687;
(statearr_14691[(8)] = inst_14676__$1);

return statearr_14691;
})();
if(cljs.core.truth_(inst_14677)){
var statearr_14692_14706 = state_14687__$1;
(statearr_14692_14706[(1)] = (5));

} else {
var statearr_14693_14707 = state_14687__$1;
(statearr_14693_14707[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14688 === (5))){
var inst_14673 = (state_14687[(7)]);
var state_14687__$1 = state_14687;
var statearr_14694_14708 = state_14687__$1;
(statearr_14694_14708[(2)] = inst_14673);

(statearr_14694_14708[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14688 === (6))){
var inst_14676 = (state_14687[(8)]);
var inst_14673 = (state_14687[(7)]);
var inst_14680 = f.call(null,inst_14673,inst_14676);
var inst_14673__$1 = inst_14680;
var state_14687__$1 = (function (){var statearr_14695 = state_14687;
(statearr_14695[(7)] = inst_14673__$1);

return statearr_14695;
})();
var statearr_14696_14709 = state_14687__$1;
(statearr_14696_14709[(2)] = null);

(statearr_14696_14709[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14688 === (7))){
var inst_14683 = (state_14687[(2)]);
var state_14687__$1 = state_14687;
var statearr_14697_14710 = state_14687__$1;
(statearr_14697_14710[(2)] = inst_14683);

(statearr_14697_14710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__8287__auto__))
;
return ((function (switch__8266__auto__,c__8287__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8267__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8267__auto____0 = (function (){
var statearr_14701 = [null,null,null,null,null,null,null,null,null];
(statearr_14701[(0)] = cljs$core$async$reduce_$_state_machine__8267__auto__);

(statearr_14701[(1)] = (1));

return statearr_14701;
});
var cljs$core$async$reduce_$_state_machine__8267__auto____1 = (function (state_14687){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_14687);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e14702){if((e14702 instanceof Object)){
var ex__8270__auto__ = e14702;
var statearr_14703_14711 = state_14687;
(statearr_14703_14711[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14687);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14702;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14712 = state_14687;
state_14687 = G__14712;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8267__auto__ = function(state_14687){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8267__auto____1.call(this,state_14687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8267__auto____0;
cljs$core$async$reduce_$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8267__auto____1;
return cljs$core$async$reduce_$_state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto__))
})();
var state__8289__auto__ = (function (){var statearr_14704 = f__8288__auto__.call(null);
(statearr_14704[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto__);

return statearr_14704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto__))
);

return c__8287__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args14713 = [];
var len__5638__auto___14765 = arguments.length;
var i__5639__auto___14766 = (0);
while(true){
if((i__5639__auto___14766 < len__5638__auto___14765)){
args14713.push((arguments[i__5639__auto___14766]));

var G__14767 = (i__5639__auto___14766 + (1));
i__5639__auto___14766 = G__14767;
continue;
} else {
}
break;
}

var G__14715 = args14713.length;
switch (G__14715) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14713.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8287__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto__){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto__){
return (function (state_14740){
var state_val_14741 = (state_14740[(1)]);
if((state_val_14741 === (7))){
var inst_14722 = (state_14740[(2)]);
var state_14740__$1 = state_14740;
var statearr_14742_14769 = state_14740__$1;
(statearr_14742_14769[(2)] = inst_14722);

(statearr_14742_14769[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14741 === (1))){
var inst_14716 = cljs.core.seq.call(null,coll);
var inst_14717 = inst_14716;
var state_14740__$1 = (function (){var statearr_14743 = state_14740;
(statearr_14743[(7)] = inst_14717);

return statearr_14743;
})();
var statearr_14744_14770 = state_14740__$1;
(statearr_14744_14770[(2)] = null);

(statearr_14744_14770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14741 === (4))){
var inst_14717 = (state_14740[(7)]);
var inst_14720 = cljs.core.first.call(null,inst_14717);
var state_14740__$1 = state_14740;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14740__$1,(7),ch,inst_14720);
} else {
if((state_val_14741 === (13))){
var inst_14734 = (state_14740[(2)]);
var state_14740__$1 = state_14740;
var statearr_14745_14771 = state_14740__$1;
(statearr_14745_14771[(2)] = inst_14734);

(statearr_14745_14771[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14741 === (6))){
var inst_14725 = (state_14740[(2)]);
var state_14740__$1 = state_14740;
if(cljs.core.truth_(inst_14725)){
var statearr_14746_14772 = state_14740__$1;
(statearr_14746_14772[(1)] = (8));

} else {
var statearr_14747_14773 = state_14740__$1;
(statearr_14747_14773[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14741 === (3))){
var inst_14738 = (state_14740[(2)]);
var state_14740__$1 = state_14740;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14740__$1,inst_14738);
} else {
if((state_val_14741 === (12))){
var state_14740__$1 = state_14740;
var statearr_14748_14774 = state_14740__$1;
(statearr_14748_14774[(2)] = null);

(statearr_14748_14774[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14741 === (2))){
var inst_14717 = (state_14740[(7)]);
var state_14740__$1 = state_14740;
if(cljs.core.truth_(inst_14717)){
var statearr_14749_14775 = state_14740__$1;
(statearr_14749_14775[(1)] = (4));

} else {
var statearr_14750_14776 = state_14740__$1;
(statearr_14750_14776[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14741 === (11))){
var inst_14731 = cljs.core.async.close_BANG_.call(null,ch);
var state_14740__$1 = state_14740;
var statearr_14751_14777 = state_14740__$1;
(statearr_14751_14777[(2)] = inst_14731);

(statearr_14751_14777[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14741 === (9))){
var state_14740__$1 = state_14740;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14752_14778 = state_14740__$1;
(statearr_14752_14778[(1)] = (11));

} else {
var statearr_14753_14779 = state_14740__$1;
(statearr_14753_14779[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14741 === (5))){
var inst_14717 = (state_14740[(7)]);
var state_14740__$1 = state_14740;
var statearr_14754_14780 = state_14740__$1;
(statearr_14754_14780[(2)] = inst_14717);

(statearr_14754_14780[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14741 === (10))){
var inst_14736 = (state_14740[(2)]);
var state_14740__$1 = state_14740;
var statearr_14755_14781 = state_14740__$1;
(statearr_14755_14781[(2)] = inst_14736);

(statearr_14755_14781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14741 === (8))){
var inst_14717 = (state_14740[(7)]);
var inst_14727 = cljs.core.next.call(null,inst_14717);
var inst_14717__$1 = inst_14727;
var state_14740__$1 = (function (){var statearr_14756 = state_14740;
(statearr_14756[(7)] = inst_14717__$1);

return statearr_14756;
})();
var statearr_14757_14782 = state_14740__$1;
(statearr_14757_14782[(2)] = null);

(statearr_14757_14782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto__))
;
return ((function (switch__8266__auto__,c__8287__auto__){
return (function() {
var cljs$core$async$state_machine__8267__auto__ = null;
var cljs$core$async$state_machine__8267__auto____0 = (function (){
var statearr_14761 = [null,null,null,null,null,null,null,null];
(statearr_14761[(0)] = cljs$core$async$state_machine__8267__auto__);

(statearr_14761[(1)] = (1));

return statearr_14761;
});
var cljs$core$async$state_machine__8267__auto____1 = (function (state_14740){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_14740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e14762){if((e14762 instanceof Object)){
var ex__8270__auto__ = e14762;
var statearr_14763_14783 = state_14740;
(statearr_14763_14783[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14740);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14762;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14784 = state_14740;
state_14740 = G__14784;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$state_machine__8267__auto__ = function(state_14740){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8267__auto____1.call(this,state_14740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8267__auto____0;
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8267__auto____1;
return cljs$core$async$state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto__))
})();
var state__8289__auto__ = (function (){var statearr_14764 = f__8288__auto__.call(null);
(statearr_14764[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto__);

return statearr_14764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto__))
);

return c__8287__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5235__auto__ = (((_ == null))?null:_);
var m__5236__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,_);
} else {
var m__5236__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5235__auto__ = (((m == null))?null:m);
var m__5236__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5236__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5235__auto__ = (((m == null))?null:m);
var m__5236__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,m,ch);
} else {
var m__5236__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5235__auto__ = (((m == null))?null:m);
var m__5236__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,m);
} else {
var m__5236__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15006 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15006 = (function (mult,ch,cs,meta15007){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta15007 = meta15007;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15006.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15008,meta15007__$1){
var self__ = this;
var _15008__$1 = this;
return (new cljs.core.async.t_cljs$core$async15006(self__.mult,self__.ch,self__.cs,meta15007__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15006.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15008){
var self__ = this;
var _15008__$1 = this;
return self__.meta15007;
});})(cs))
;

cljs.core.async.t_cljs$core$async15006.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15006.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15006.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async15006.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15006.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15006.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15006.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15007","meta15007",1091253033,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15006.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15006.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15006";

cljs.core.async.t_cljs$core$async15006.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"cljs.core.async/t_cljs$core$async15006");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15006 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15006(mult__$1,ch__$1,cs__$1,meta15007){
return (new cljs.core.async.t_cljs$core$async15006(mult__$1,ch__$1,cs__$1,meta15007));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15006(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8287__auto___15227 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___15227,cs,m,dchan,dctr,done){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___15227,cs,m,dchan,dctr,done){
return (function (state_15139){
var state_val_15140 = (state_15139[(1)]);
if((state_val_15140 === (7))){
var inst_15135 = (state_15139[(2)]);
var state_15139__$1 = state_15139;
var statearr_15141_15228 = state_15139__$1;
(statearr_15141_15228[(2)] = inst_15135);

(statearr_15141_15228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (20))){
var inst_15040 = (state_15139[(7)]);
var inst_15050 = cljs.core.first.call(null,inst_15040);
var inst_15051 = cljs.core.nth.call(null,inst_15050,(0),null);
var inst_15052 = cljs.core.nth.call(null,inst_15050,(1),null);
var state_15139__$1 = (function (){var statearr_15142 = state_15139;
(statearr_15142[(8)] = inst_15051);

return statearr_15142;
})();
if(cljs.core.truth_(inst_15052)){
var statearr_15143_15229 = state_15139__$1;
(statearr_15143_15229[(1)] = (22));

} else {
var statearr_15144_15230 = state_15139__$1;
(statearr_15144_15230[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (27))){
var inst_15082 = (state_15139[(9)]);
var inst_15087 = (state_15139[(10)]);
var inst_15011 = (state_15139[(11)]);
var inst_15080 = (state_15139[(12)]);
var inst_15087__$1 = cljs.core._nth.call(null,inst_15080,inst_15082);
var inst_15088 = cljs.core.async.put_BANG_.call(null,inst_15087__$1,inst_15011,done);
var state_15139__$1 = (function (){var statearr_15145 = state_15139;
(statearr_15145[(10)] = inst_15087__$1);

return statearr_15145;
})();
if(cljs.core.truth_(inst_15088)){
var statearr_15146_15231 = state_15139__$1;
(statearr_15146_15231[(1)] = (30));

} else {
var statearr_15147_15232 = state_15139__$1;
(statearr_15147_15232[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (1))){
var state_15139__$1 = state_15139;
var statearr_15148_15233 = state_15139__$1;
(statearr_15148_15233[(2)] = null);

(statearr_15148_15233[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (24))){
var inst_15040 = (state_15139[(7)]);
var inst_15057 = (state_15139[(2)]);
var inst_15058 = cljs.core.next.call(null,inst_15040);
var inst_15020 = inst_15058;
var inst_15021 = null;
var inst_15022 = (0);
var inst_15023 = (0);
var state_15139__$1 = (function (){var statearr_15149 = state_15139;
(statearr_15149[(13)] = inst_15022);

(statearr_15149[(14)] = inst_15021);

(statearr_15149[(15)] = inst_15023);

(statearr_15149[(16)] = inst_15020);

(statearr_15149[(17)] = inst_15057);

return statearr_15149;
})();
var statearr_15150_15234 = state_15139__$1;
(statearr_15150_15234[(2)] = null);

(statearr_15150_15234[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (39))){
var state_15139__$1 = state_15139;
var statearr_15154_15235 = state_15139__$1;
(statearr_15154_15235[(2)] = null);

(statearr_15154_15235[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (4))){
var inst_15011 = (state_15139[(11)]);
var inst_15011__$1 = (state_15139[(2)]);
var inst_15012 = (inst_15011__$1 == null);
var state_15139__$1 = (function (){var statearr_15155 = state_15139;
(statearr_15155[(11)] = inst_15011__$1);

return statearr_15155;
})();
if(cljs.core.truth_(inst_15012)){
var statearr_15156_15236 = state_15139__$1;
(statearr_15156_15236[(1)] = (5));

} else {
var statearr_15157_15237 = state_15139__$1;
(statearr_15157_15237[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (15))){
var inst_15022 = (state_15139[(13)]);
var inst_15021 = (state_15139[(14)]);
var inst_15023 = (state_15139[(15)]);
var inst_15020 = (state_15139[(16)]);
var inst_15036 = (state_15139[(2)]);
var inst_15037 = (inst_15023 + (1));
var tmp15151 = inst_15022;
var tmp15152 = inst_15021;
var tmp15153 = inst_15020;
var inst_15020__$1 = tmp15153;
var inst_15021__$1 = tmp15152;
var inst_15022__$1 = tmp15151;
var inst_15023__$1 = inst_15037;
var state_15139__$1 = (function (){var statearr_15158 = state_15139;
(statearr_15158[(13)] = inst_15022__$1);

(statearr_15158[(14)] = inst_15021__$1);

(statearr_15158[(15)] = inst_15023__$1);

(statearr_15158[(16)] = inst_15020__$1);

(statearr_15158[(18)] = inst_15036);

return statearr_15158;
})();
var statearr_15159_15238 = state_15139__$1;
(statearr_15159_15238[(2)] = null);

(statearr_15159_15238[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (21))){
var inst_15061 = (state_15139[(2)]);
var state_15139__$1 = state_15139;
var statearr_15163_15239 = state_15139__$1;
(statearr_15163_15239[(2)] = inst_15061);

(statearr_15163_15239[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (31))){
var inst_15087 = (state_15139[(10)]);
var inst_15091 = done.call(null,null);
var inst_15092 = cljs.core.async.untap_STAR_.call(null,m,inst_15087);
var state_15139__$1 = (function (){var statearr_15164 = state_15139;
(statearr_15164[(19)] = inst_15091);

return statearr_15164;
})();
var statearr_15165_15240 = state_15139__$1;
(statearr_15165_15240[(2)] = inst_15092);

(statearr_15165_15240[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (32))){
var inst_15082 = (state_15139[(9)]);
var inst_15079 = (state_15139[(20)]);
var inst_15080 = (state_15139[(12)]);
var inst_15081 = (state_15139[(21)]);
var inst_15094 = (state_15139[(2)]);
var inst_15095 = (inst_15082 + (1));
var tmp15160 = inst_15079;
var tmp15161 = inst_15080;
var tmp15162 = inst_15081;
var inst_15079__$1 = tmp15160;
var inst_15080__$1 = tmp15161;
var inst_15081__$1 = tmp15162;
var inst_15082__$1 = inst_15095;
var state_15139__$1 = (function (){var statearr_15166 = state_15139;
(statearr_15166[(9)] = inst_15082__$1);

(statearr_15166[(20)] = inst_15079__$1);

(statearr_15166[(12)] = inst_15080__$1);

(statearr_15166[(21)] = inst_15081__$1);

(statearr_15166[(22)] = inst_15094);

return statearr_15166;
})();
var statearr_15167_15241 = state_15139__$1;
(statearr_15167_15241[(2)] = null);

(statearr_15167_15241[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (40))){
var inst_15107 = (state_15139[(23)]);
var inst_15111 = done.call(null,null);
var inst_15112 = cljs.core.async.untap_STAR_.call(null,m,inst_15107);
var state_15139__$1 = (function (){var statearr_15168 = state_15139;
(statearr_15168[(24)] = inst_15111);

return statearr_15168;
})();
var statearr_15169_15242 = state_15139__$1;
(statearr_15169_15242[(2)] = inst_15112);

(statearr_15169_15242[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (33))){
var inst_15098 = (state_15139[(25)]);
var inst_15100 = cljs.core.chunked_seq_QMARK_.call(null,inst_15098);
var state_15139__$1 = state_15139;
if(inst_15100){
var statearr_15170_15243 = state_15139__$1;
(statearr_15170_15243[(1)] = (36));

} else {
var statearr_15171_15244 = state_15139__$1;
(statearr_15171_15244[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (13))){
var inst_15030 = (state_15139[(26)]);
var inst_15033 = cljs.core.async.close_BANG_.call(null,inst_15030);
var state_15139__$1 = state_15139;
var statearr_15172_15245 = state_15139__$1;
(statearr_15172_15245[(2)] = inst_15033);

(statearr_15172_15245[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (22))){
var inst_15051 = (state_15139[(8)]);
var inst_15054 = cljs.core.async.close_BANG_.call(null,inst_15051);
var state_15139__$1 = state_15139;
var statearr_15173_15246 = state_15139__$1;
(statearr_15173_15246[(2)] = inst_15054);

(statearr_15173_15246[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (36))){
var inst_15098 = (state_15139[(25)]);
var inst_15102 = cljs.core.chunk_first.call(null,inst_15098);
var inst_15103 = cljs.core.chunk_rest.call(null,inst_15098);
var inst_15104 = cljs.core.count.call(null,inst_15102);
var inst_15079 = inst_15103;
var inst_15080 = inst_15102;
var inst_15081 = inst_15104;
var inst_15082 = (0);
var state_15139__$1 = (function (){var statearr_15174 = state_15139;
(statearr_15174[(9)] = inst_15082);

(statearr_15174[(20)] = inst_15079);

(statearr_15174[(12)] = inst_15080);

(statearr_15174[(21)] = inst_15081);

return statearr_15174;
})();
var statearr_15175_15247 = state_15139__$1;
(statearr_15175_15247[(2)] = null);

(statearr_15175_15247[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (41))){
var inst_15098 = (state_15139[(25)]);
var inst_15114 = (state_15139[(2)]);
var inst_15115 = cljs.core.next.call(null,inst_15098);
var inst_15079 = inst_15115;
var inst_15080 = null;
var inst_15081 = (0);
var inst_15082 = (0);
var state_15139__$1 = (function (){var statearr_15176 = state_15139;
(statearr_15176[(9)] = inst_15082);

(statearr_15176[(20)] = inst_15079);

(statearr_15176[(12)] = inst_15080);

(statearr_15176[(21)] = inst_15081);

(statearr_15176[(27)] = inst_15114);

return statearr_15176;
})();
var statearr_15177_15248 = state_15139__$1;
(statearr_15177_15248[(2)] = null);

(statearr_15177_15248[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (43))){
var state_15139__$1 = state_15139;
var statearr_15178_15249 = state_15139__$1;
(statearr_15178_15249[(2)] = null);

(statearr_15178_15249[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (29))){
var inst_15123 = (state_15139[(2)]);
var state_15139__$1 = state_15139;
var statearr_15179_15250 = state_15139__$1;
(statearr_15179_15250[(2)] = inst_15123);

(statearr_15179_15250[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (44))){
var inst_15132 = (state_15139[(2)]);
var state_15139__$1 = (function (){var statearr_15180 = state_15139;
(statearr_15180[(28)] = inst_15132);

return statearr_15180;
})();
var statearr_15181_15251 = state_15139__$1;
(statearr_15181_15251[(2)] = null);

(statearr_15181_15251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (6))){
var inst_15071 = (state_15139[(29)]);
var inst_15070 = cljs.core.deref.call(null,cs);
var inst_15071__$1 = cljs.core.keys.call(null,inst_15070);
var inst_15072 = cljs.core.count.call(null,inst_15071__$1);
var inst_15073 = cljs.core.reset_BANG_.call(null,dctr,inst_15072);
var inst_15078 = cljs.core.seq.call(null,inst_15071__$1);
var inst_15079 = inst_15078;
var inst_15080 = null;
var inst_15081 = (0);
var inst_15082 = (0);
var state_15139__$1 = (function (){var statearr_15182 = state_15139;
(statearr_15182[(9)] = inst_15082);

(statearr_15182[(20)] = inst_15079);

(statearr_15182[(29)] = inst_15071__$1);

(statearr_15182[(30)] = inst_15073);

(statearr_15182[(12)] = inst_15080);

(statearr_15182[(21)] = inst_15081);

return statearr_15182;
})();
var statearr_15183_15252 = state_15139__$1;
(statearr_15183_15252[(2)] = null);

(statearr_15183_15252[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (28))){
var inst_15079 = (state_15139[(20)]);
var inst_15098 = (state_15139[(25)]);
var inst_15098__$1 = cljs.core.seq.call(null,inst_15079);
var state_15139__$1 = (function (){var statearr_15184 = state_15139;
(statearr_15184[(25)] = inst_15098__$1);

return statearr_15184;
})();
if(inst_15098__$1){
var statearr_15185_15253 = state_15139__$1;
(statearr_15185_15253[(1)] = (33));

} else {
var statearr_15186_15254 = state_15139__$1;
(statearr_15186_15254[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (25))){
var inst_15082 = (state_15139[(9)]);
var inst_15081 = (state_15139[(21)]);
var inst_15084 = (inst_15082 < inst_15081);
var inst_15085 = inst_15084;
var state_15139__$1 = state_15139;
if(cljs.core.truth_(inst_15085)){
var statearr_15187_15255 = state_15139__$1;
(statearr_15187_15255[(1)] = (27));

} else {
var statearr_15188_15256 = state_15139__$1;
(statearr_15188_15256[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (34))){
var state_15139__$1 = state_15139;
var statearr_15189_15257 = state_15139__$1;
(statearr_15189_15257[(2)] = null);

(statearr_15189_15257[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (17))){
var state_15139__$1 = state_15139;
var statearr_15190_15258 = state_15139__$1;
(statearr_15190_15258[(2)] = null);

(statearr_15190_15258[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (3))){
var inst_15137 = (state_15139[(2)]);
var state_15139__$1 = state_15139;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15139__$1,inst_15137);
} else {
if((state_val_15140 === (12))){
var inst_15066 = (state_15139[(2)]);
var state_15139__$1 = state_15139;
var statearr_15191_15259 = state_15139__$1;
(statearr_15191_15259[(2)] = inst_15066);

(statearr_15191_15259[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (2))){
var state_15139__$1 = state_15139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15139__$1,(4),ch);
} else {
if((state_val_15140 === (23))){
var state_15139__$1 = state_15139;
var statearr_15192_15260 = state_15139__$1;
(statearr_15192_15260[(2)] = null);

(statearr_15192_15260[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (35))){
var inst_15121 = (state_15139[(2)]);
var state_15139__$1 = state_15139;
var statearr_15193_15261 = state_15139__$1;
(statearr_15193_15261[(2)] = inst_15121);

(statearr_15193_15261[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (19))){
var inst_15040 = (state_15139[(7)]);
var inst_15044 = cljs.core.chunk_first.call(null,inst_15040);
var inst_15045 = cljs.core.chunk_rest.call(null,inst_15040);
var inst_15046 = cljs.core.count.call(null,inst_15044);
var inst_15020 = inst_15045;
var inst_15021 = inst_15044;
var inst_15022 = inst_15046;
var inst_15023 = (0);
var state_15139__$1 = (function (){var statearr_15194 = state_15139;
(statearr_15194[(13)] = inst_15022);

(statearr_15194[(14)] = inst_15021);

(statearr_15194[(15)] = inst_15023);

(statearr_15194[(16)] = inst_15020);

return statearr_15194;
})();
var statearr_15195_15262 = state_15139__$1;
(statearr_15195_15262[(2)] = null);

(statearr_15195_15262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (11))){
var inst_15040 = (state_15139[(7)]);
var inst_15020 = (state_15139[(16)]);
var inst_15040__$1 = cljs.core.seq.call(null,inst_15020);
var state_15139__$1 = (function (){var statearr_15196 = state_15139;
(statearr_15196[(7)] = inst_15040__$1);

return statearr_15196;
})();
if(inst_15040__$1){
var statearr_15197_15263 = state_15139__$1;
(statearr_15197_15263[(1)] = (16));

} else {
var statearr_15198_15264 = state_15139__$1;
(statearr_15198_15264[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (9))){
var inst_15068 = (state_15139[(2)]);
var state_15139__$1 = state_15139;
var statearr_15199_15265 = state_15139__$1;
(statearr_15199_15265[(2)] = inst_15068);

(statearr_15199_15265[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (5))){
var inst_15018 = cljs.core.deref.call(null,cs);
var inst_15019 = cljs.core.seq.call(null,inst_15018);
var inst_15020 = inst_15019;
var inst_15021 = null;
var inst_15022 = (0);
var inst_15023 = (0);
var state_15139__$1 = (function (){var statearr_15200 = state_15139;
(statearr_15200[(13)] = inst_15022);

(statearr_15200[(14)] = inst_15021);

(statearr_15200[(15)] = inst_15023);

(statearr_15200[(16)] = inst_15020);

return statearr_15200;
})();
var statearr_15201_15266 = state_15139__$1;
(statearr_15201_15266[(2)] = null);

(statearr_15201_15266[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (14))){
var state_15139__$1 = state_15139;
var statearr_15202_15267 = state_15139__$1;
(statearr_15202_15267[(2)] = null);

(statearr_15202_15267[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (45))){
var inst_15129 = (state_15139[(2)]);
var state_15139__$1 = state_15139;
var statearr_15203_15268 = state_15139__$1;
(statearr_15203_15268[(2)] = inst_15129);

(statearr_15203_15268[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (26))){
var inst_15071 = (state_15139[(29)]);
var inst_15125 = (state_15139[(2)]);
var inst_15126 = cljs.core.seq.call(null,inst_15071);
var state_15139__$1 = (function (){var statearr_15204 = state_15139;
(statearr_15204[(31)] = inst_15125);

return statearr_15204;
})();
if(inst_15126){
var statearr_15205_15269 = state_15139__$1;
(statearr_15205_15269[(1)] = (42));

} else {
var statearr_15206_15270 = state_15139__$1;
(statearr_15206_15270[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (16))){
var inst_15040 = (state_15139[(7)]);
var inst_15042 = cljs.core.chunked_seq_QMARK_.call(null,inst_15040);
var state_15139__$1 = state_15139;
if(inst_15042){
var statearr_15207_15271 = state_15139__$1;
(statearr_15207_15271[(1)] = (19));

} else {
var statearr_15208_15272 = state_15139__$1;
(statearr_15208_15272[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (38))){
var inst_15118 = (state_15139[(2)]);
var state_15139__$1 = state_15139;
var statearr_15209_15273 = state_15139__$1;
(statearr_15209_15273[(2)] = inst_15118);

(statearr_15209_15273[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (30))){
var state_15139__$1 = state_15139;
var statearr_15210_15274 = state_15139__$1;
(statearr_15210_15274[(2)] = null);

(statearr_15210_15274[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (10))){
var inst_15021 = (state_15139[(14)]);
var inst_15023 = (state_15139[(15)]);
var inst_15029 = cljs.core._nth.call(null,inst_15021,inst_15023);
var inst_15030 = cljs.core.nth.call(null,inst_15029,(0),null);
var inst_15031 = cljs.core.nth.call(null,inst_15029,(1),null);
var state_15139__$1 = (function (){var statearr_15211 = state_15139;
(statearr_15211[(26)] = inst_15030);

return statearr_15211;
})();
if(cljs.core.truth_(inst_15031)){
var statearr_15212_15275 = state_15139__$1;
(statearr_15212_15275[(1)] = (13));

} else {
var statearr_15213_15276 = state_15139__$1;
(statearr_15213_15276[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (18))){
var inst_15064 = (state_15139[(2)]);
var state_15139__$1 = state_15139;
var statearr_15214_15277 = state_15139__$1;
(statearr_15214_15277[(2)] = inst_15064);

(statearr_15214_15277[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (42))){
var state_15139__$1 = state_15139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15139__$1,(45),dchan);
} else {
if((state_val_15140 === (37))){
var inst_15011 = (state_15139[(11)]);
var inst_15107 = (state_15139[(23)]);
var inst_15098 = (state_15139[(25)]);
var inst_15107__$1 = cljs.core.first.call(null,inst_15098);
var inst_15108 = cljs.core.async.put_BANG_.call(null,inst_15107__$1,inst_15011,done);
var state_15139__$1 = (function (){var statearr_15215 = state_15139;
(statearr_15215[(23)] = inst_15107__$1);

return statearr_15215;
})();
if(cljs.core.truth_(inst_15108)){
var statearr_15216_15278 = state_15139__$1;
(statearr_15216_15278[(1)] = (39));

} else {
var statearr_15217_15279 = state_15139__$1;
(statearr_15217_15279[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (8))){
var inst_15022 = (state_15139[(13)]);
var inst_15023 = (state_15139[(15)]);
var inst_15025 = (inst_15023 < inst_15022);
var inst_15026 = inst_15025;
var state_15139__$1 = state_15139;
if(cljs.core.truth_(inst_15026)){
var statearr_15218_15280 = state_15139__$1;
(statearr_15218_15280[(1)] = (10));

} else {
var statearr_15219_15281 = state_15139__$1;
(statearr_15219_15281[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto___15227,cs,m,dchan,dctr,done))
;
return ((function (switch__8266__auto__,c__8287__auto___15227,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8267__auto__ = null;
var cljs$core$async$mult_$_state_machine__8267__auto____0 = (function (){
var statearr_15223 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15223[(0)] = cljs$core$async$mult_$_state_machine__8267__auto__);

(statearr_15223[(1)] = (1));

return statearr_15223;
});
var cljs$core$async$mult_$_state_machine__8267__auto____1 = (function (state_15139){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_15139);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e15224){if((e15224 instanceof Object)){
var ex__8270__auto__ = e15224;
var statearr_15225_15282 = state_15139;
(statearr_15225_15282[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15139);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15224;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15283 = state_15139;
state_15139 = G__15283;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8267__auto__ = function(state_15139){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8267__auto____1.call(this,state_15139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8267__auto____0;
cljs$core$async$mult_$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8267__auto____1;
return cljs$core$async$mult_$_state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___15227,cs,m,dchan,dctr,done))
})();
var state__8289__auto__ = (function (){var statearr_15226 = f__8288__auto__.call(null);
(statearr_15226[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___15227);

return statearr_15226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___15227,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15284 = [];
var len__5638__auto___15287 = arguments.length;
var i__5639__auto___15288 = (0);
while(true){
if((i__5639__auto___15288 < len__5638__auto___15287)){
args15284.push((arguments[i__5639__auto___15288]));

var G__15289 = (i__5639__auto___15288 + (1));
i__5639__auto___15288 = G__15289;
continue;
} else {
}
break;
}

var G__15286 = args15284.length;
switch (G__15286) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15284.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5235__auto__ = (((m == null))?null:m);
var m__5236__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,m,ch);
} else {
var m__5236__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5235__auto__ = (((m == null))?null:m);
var m__5236__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,m,ch);
} else {
var m__5236__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5235__auto__ = (((m == null))?null:m);
var m__5236__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,m);
} else {
var m__5236__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5235__auto__ = (((m == null))?null:m);
var m__5236__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,m,state_map);
} else {
var m__5236__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5235__auto__ = (((m == null))?null:m);
var m__5236__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,m,mode);
} else {
var m__5236__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5645__auto__ = [];
var len__5638__auto___15301 = arguments.length;
var i__5639__auto___15302 = (0);
while(true){
if((i__5639__auto___15302 < len__5638__auto___15301)){
args__5645__auto__.push((arguments[i__5639__auto___15302]));

var G__15303 = (i__5639__auto___15302 + (1));
i__5639__auto___15302 = G__15303;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((3) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15295){
var map__15296 = p__15295;
var map__15296__$1 = ((((!((map__15296 == null)))?((((map__15296.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15296.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15296):map__15296);
var opts = map__15296__$1;
var statearr_15298_15304 = state;
(statearr_15298_15304[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__15296,map__15296__$1,opts){
return (function (val){
var statearr_15299_15305 = state;
(statearr_15299_15305[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__15296,map__15296__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_15300_15306 = state;
(statearr_15300_15306[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15291){
var G__15292 = cljs.core.first.call(null,seq15291);
var seq15291__$1 = cljs.core.next.call(null,seq15291);
var G__15293 = cljs.core.first.call(null,seq15291__$1);
var seq15291__$2 = cljs.core.next.call(null,seq15291__$1);
var G__15294 = cljs.core.first.call(null,seq15291__$2);
var seq15291__$3 = cljs.core.next.call(null,seq15291__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15292,G__15293,G__15294,seq15291__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15470 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15470 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta15471){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta15471 = meta15471;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15472,meta15471__$1){
var self__ = this;
var _15472__$1 = this;
return (new cljs.core.async.t_cljs$core$async15470(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta15471__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15472){
var self__ = this;
var _15472__$1 = this;
return self__.meta15471;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15470.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15470.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta15471","meta15471",797443053,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15470.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15470.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15470";

cljs.core.async.t_cljs$core$async15470.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"cljs.core.async/t_cljs$core$async15470");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async15470 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async15470(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15471){
return (new cljs.core.async.t_cljs$core$async15470(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15471));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async15470(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8287__auto___15633 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___15633,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___15633,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_15570){
var state_val_15571 = (state_15570[(1)]);
if((state_val_15571 === (7))){
var inst_15488 = (state_15570[(2)]);
var state_15570__$1 = state_15570;
var statearr_15572_15634 = state_15570__$1;
(statearr_15572_15634[(2)] = inst_15488);

(statearr_15572_15634[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (20))){
var inst_15500 = (state_15570[(7)]);
var state_15570__$1 = state_15570;
var statearr_15573_15635 = state_15570__$1;
(statearr_15573_15635[(2)] = inst_15500);

(statearr_15573_15635[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (27))){
var state_15570__$1 = state_15570;
var statearr_15574_15636 = state_15570__$1;
(statearr_15574_15636[(2)] = null);

(statearr_15574_15636[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (1))){
var inst_15476 = (state_15570[(8)]);
var inst_15476__$1 = calc_state.call(null);
var inst_15478 = (inst_15476__$1 == null);
var inst_15479 = cljs.core.not.call(null,inst_15478);
var state_15570__$1 = (function (){var statearr_15575 = state_15570;
(statearr_15575[(8)] = inst_15476__$1);

return statearr_15575;
})();
if(inst_15479){
var statearr_15576_15637 = state_15570__$1;
(statearr_15576_15637[(1)] = (2));

} else {
var statearr_15577_15638 = state_15570__$1;
(statearr_15577_15638[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (24))){
var inst_15530 = (state_15570[(9)]);
var inst_15523 = (state_15570[(10)]);
var inst_15544 = (state_15570[(11)]);
var inst_15544__$1 = inst_15523.call(null,inst_15530);
var state_15570__$1 = (function (){var statearr_15578 = state_15570;
(statearr_15578[(11)] = inst_15544__$1);

return statearr_15578;
})();
if(cljs.core.truth_(inst_15544__$1)){
var statearr_15579_15639 = state_15570__$1;
(statearr_15579_15639[(1)] = (29));

} else {
var statearr_15580_15640 = state_15570__$1;
(statearr_15580_15640[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (4))){
var inst_15491 = (state_15570[(2)]);
var state_15570__$1 = state_15570;
if(cljs.core.truth_(inst_15491)){
var statearr_15581_15641 = state_15570__$1;
(statearr_15581_15641[(1)] = (8));

} else {
var statearr_15582_15642 = state_15570__$1;
(statearr_15582_15642[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (15))){
var inst_15517 = (state_15570[(2)]);
var state_15570__$1 = state_15570;
if(cljs.core.truth_(inst_15517)){
var statearr_15583_15643 = state_15570__$1;
(statearr_15583_15643[(1)] = (19));

} else {
var statearr_15584_15644 = state_15570__$1;
(statearr_15584_15644[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (21))){
var inst_15522 = (state_15570[(12)]);
var inst_15522__$1 = (state_15570[(2)]);
var inst_15523 = cljs.core.get.call(null,inst_15522__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_15524 = cljs.core.get.call(null,inst_15522__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_15525 = cljs.core.get.call(null,inst_15522__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_15570__$1 = (function (){var statearr_15585 = state_15570;
(statearr_15585[(12)] = inst_15522__$1);

(statearr_15585[(13)] = inst_15524);

(statearr_15585[(10)] = inst_15523);

return statearr_15585;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_15570__$1,(22),inst_15525);
} else {
if((state_val_15571 === (31))){
var inst_15552 = (state_15570[(2)]);
var state_15570__$1 = state_15570;
if(cljs.core.truth_(inst_15552)){
var statearr_15586_15645 = state_15570__$1;
(statearr_15586_15645[(1)] = (32));

} else {
var statearr_15587_15646 = state_15570__$1;
(statearr_15587_15646[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (32))){
var inst_15529 = (state_15570[(14)]);
var state_15570__$1 = state_15570;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15570__$1,(35),out,inst_15529);
} else {
if((state_val_15571 === (33))){
var inst_15522 = (state_15570[(12)]);
var inst_15500 = inst_15522;
var state_15570__$1 = (function (){var statearr_15588 = state_15570;
(statearr_15588[(7)] = inst_15500);

return statearr_15588;
})();
var statearr_15589_15647 = state_15570__$1;
(statearr_15589_15647[(2)] = null);

(statearr_15589_15647[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (13))){
var inst_15500 = (state_15570[(7)]);
var inst_15507 = inst_15500.cljs$lang$protocol_mask$partition0$;
var inst_15508 = (inst_15507 & (64));
var inst_15509 = inst_15500.cljs$core$ISeq$;
var inst_15510 = (inst_15508) || (inst_15509);
var state_15570__$1 = state_15570;
if(cljs.core.truth_(inst_15510)){
var statearr_15590_15648 = state_15570__$1;
(statearr_15590_15648[(1)] = (16));

} else {
var statearr_15591_15649 = state_15570__$1;
(statearr_15591_15649[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (22))){
var inst_15530 = (state_15570[(9)]);
var inst_15529 = (state_15570[(14)]);
var inst_15528 = (state_15570[(2)]);
var inst_15529__$1 = cljs.core.nth.call(null,inst_15528,(0),null);
var inst_15530__$1 = cljs.core.nth.call(null,inst_15528,(1),null);
var inst_15531 = (inst_15529__$1 == null);
var inst_15532 = cljs.core._EQ_.call(null,inst_15530__$1,change);
var inst_15533 = (inst_15531) || (inst_15532);
var state_15570__$1 = (function (){var statearr_15592 = state_15570;
(statearr_15592[(9)] = inst_15530__$1);

(statearr_15592[(14)] = inst_15529__$1);

return statearr_15592;
})();
if(cljs.core.truth_(inst_15533)){
var statearr_15593_15650 = state_15570__$1;
(statearr_15593_15650[(1)] = (23));

} else {
var statearr_15594_15651 = state_15570__$1;
(statearr_15594_15651[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (36))){
var inst_15522 = (state_15570[(12)]);
var inst_15500 = inst_15522;
var state_15570__$1 = (function (){var statearr_15595 = state_15570;
(statearr_15595[(7)] = inst_15500);

return statearr_15595;
})();
var statearr_15596_15652 = state_15570__$1;
(statearr_15596_15652[(2)] = null);

(statearr_15596_15652[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (29))){
var inst_15544 = (state_15570[(11)]);
var state_15570__$1 = state_15570;
var statearr_15597_15653 = state_15570__$1;
(statearr_15597_15653[(2)] = inst_15544);

(statearr_15597_15653[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (6))){
var state_15570__$1 = state_15570;
var statearr_15598_15654 = state_15570__$1;
(statearr_15598_15654[(2)] = false);

(statearr_15598_15654[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (28))){
var inst_15540 = (state_15570[(2)]);
var inst_15541 = calc_state.call(null);
var inst_15500 = inst_15541;
var state_15570__$1 = (function (){var statearr_15599 = state_15570;
(statearr_15599[(7)] = inst_15500);

(statearr_15599[(15)] = inst_15540);

return statearr_15599;
})();
var statearr_15600_15655 = state_15570__$1;
(statearr_15600_15655[(2)] = null);

(statearr_15600_15655[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (25))){
var inst_15566 = (state_15570[(2)]);
var state_15570__$1 = state_15570;
var statearr_15601_15656 = state_15570__$1;
(statearr_15601_15656[(2)] = inst_15566);

(statearr_15601_15656[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (34))){
var inst_15564 = (state_15570[(2)]);
var state_15570__$1 = state_15570;
var statearr_15602_15657 = state_15570__$1;
(statearr_15602_15657[(2)] = inst_15564);

(statearr_15602_15657[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (17))){
var state_15570__$1 = state_15570;
var statearr_15603_15658 = state_15570__$1;
(statearr_15603_15658[(2)] = false);

(statearr_15603_15658[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (3))){
var state_15570__$1 = state_15570;
var statearr_15604_15659 = state_15570__$1;
(statearr_15604_15659[(2)] = false);

(statearr_15604_15659[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (12))){
var inst_15568 = (state_15570[(2)]);
var state_15570__$1 = state_15570;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15570__$1,inst_15568);
} else {
if((state_val_15571 === (2))){
var inst_15476 = (state_15570[(8)]);
var inst_15481 = inst_15476.cljs$lang$protocol_mask$partition0$;
var inst_15482 = (inst_15481 & (64));
var inst_15483 = inst_15476.cljs$core$ISeq$;
var inst_15484 = (inst_15482) || (inst_15483);
var state_15570__$1 = state_15570;
if(cljs.core.truth_(inst_15484)){
var statearr_15605_15660 = state_15570__$1;
(statearr_15605_15660[(1)] = (5));

} else {
var statearr_15606_15661 = state_15570__$1;
(statearr_15606_15661[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (23))){
var inst_15529 = (state_15570[(14)]);
var inst_15535 = (inst_15529 == null);
var state_15570__$1 = state_15570;
if(cljs.core.truth_(inst_15535)){
var statearr_15607_15662 = state_15570__$1;
(statearr_15607_15662[(1)] = (26));

} else {
var statearr_15608_15663 = state_15570__$1;
(statearr_15608_15663[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (35))){
var inst_15555 = (state_15570[(2)]);
var state_15570__$1 = state_15570;
if(cljs.core.truth_(inst_15555)){
var statearr_15609_15664 = state_15570__$1;
(statearr_15609_15664[(1)] = (36));

} else {
var statearr_15610_15665 = state_15570__$1;
(statearr_15610_15665[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (19))){
var inst_15500 = (state_15570[(7)]);
var inst_15519 = cljs.core.apply.call(null,cljs.core.hash_map,inst_15500);
var state_15570__$1 = state_15570;
var statearr_15611_15666 = state_15570__$1;
(statearr_15611_15666[(2)] = inst_15519);

(statearr_15611_15666[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (11))){
var inst_15500 = (state_15570[(7)]);
var inst_15504 = (inst_15500 == null);
var inst_15505 = cljs.core.not.call(null,inst_15504);
var state_15570__$1 = state_15570;
if(inst_15505){
var statearr_15612_15667 = state_15570__$1;
(statearr_15612_15667[(1)] = (13));

} else {
var statearr_15613_15668 = state_15570__$1;
(statearr_15613_15668[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (9))){
var inst_15476 = (state_15570[(8)]);
var state_15570__$1 = state_15570;
var statearr_15614_15669 = state_15570__$1;
(statearr_15614_15669[(2)] = inst_15476);

(statearr_15614_15669[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (5))){
var state_15570__$1 = state_15570;
var statearr_15615_15670 = state_15570__$1;
(statearr_15615_15670[(2)] = true);

(statearr_15615_15670[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (14))){
var state_15570__$1 = state_15570;
var statearr_15616_15671 = state_15570__$1;
(statearr_15616_15671[(2)] = false);

(statearr_15616_15671[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (26))){
var inst_15530 = (state_15570[(9)]);
var inst_15537 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_15530);
var state_15570__$1 = state_15570;
var statearr_15617_15672 = state_15570__$1;
(statearr_15617_15672[(2)] = inst_15537);

(statearr_15617_15672[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (16))){
var state_15570__$1 = state_15570;
var statearr_15618_15673 = state_15570__$1;
(statearr_15618_15673[(2)] = true);

(statearr_15618_15673[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (38))){
var inst_15560 = (state_15570[(2)]);
var state_15570__$1 = state_15570;
var statearr_15619_15674 = state_15570__$1;
(statearr_15619_15674[(2)] = inst_15560);

(statearr_15619_15674[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (30))){
var inst_15530 = (state_15570[(9)]);
var inst_15524 = (state_15570[(13)]);
var inst_15523 = (state_15570[(10)]);
var inst_15547 = cljs.core.empty_QMARK_.call(null,inst_15523);
var inst_15548 = inst_15524.call(null,inst_15530);
var inst_15549 = cljs.core.not.call(null,inst_15548);
var inst_15550 = (inst_15547) && (inst_15549);
var state_15570__$1 = state_15570;
var statearr_15620_15675 = state_15570__$1;
(statearr_15620_15675[(2)] = inst_15550);

(statearr_15620_15675[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (10))){
var inst_15476 = (state_15570[(8)]);
var inst_15496 = (state_15570[(2)]);
var inst_15497 = cljs.core.get.call(null,inst_15496,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_15498 = cljs.core.get.call(null,inst_15496,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_15499 = cljs.core.get.call(null,inst_15496,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_15500 = inst_15476;
var state_15570__$1 = (function (){var statearr_15621 = state_15570;
(statearr_15621[(7)] = inst_15500);

(statearr_15621[(16)] = inst_15497);

(statearr_15621[(17)] = inst_15499);

(statearr_15621[(18)] = inst_15498);

return statearr_15621;
})();
var statearr_15622_15676 = state_15570__$1;
(statearr_15622_15676[(2)] = null);

(statearr_15622_15676[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (18))){
var inst_15514 = (state_15570[(2)]);
var state_15570__$1 = state_15570;
var statearr_15623_15677 = state_15570__$1;
(statearr_15623_15677[(2)] = inst_15514);

(statearr_15623_15677[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (37))){
var state_15570__$1 = state_15570;
var statearr_15624_15678 = state_15570__$1;
(statearr_15624_15678[(2)] = null);

(statearr_15624_15678[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15571 === (8))){
var inst_15476 = (state_15570[(8)]);
var inst_15493 = cljs.core.apply.call(null,cljs.core.hash_map,inst_15476);
var state_15570__$1 = state_15570;
var statearr_15625_15679 = state_15570__$1;
(statearr_15625_15679[(2)] = inst_15493);

(statearr_15625_15679[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto___15633,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8266__auto__,c__8287__auto___15633,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8267__auto__ = null;
var cljs$core$async$mix_$_state_machine__8267__auto____0 = (function (){
var statearr_15629 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15629[(0)] = cljs$core$async$mix_$_state_machine__8267__auto__);

(statearr_15629[(1)] = (1));

return statearr_15629;
});
var cljs$core$async$mix_$_state_machine__8267__auto____1 = (function (state_15570){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_15570);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e15630){if((e15630 instanceof Object)){
var ex__8270__auto__ = e15630;
var statearr_15631_15680 = state_15570;
(statearr_15631_15680[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15570);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15630;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15681 = state_15570;
state_15570 = G__15681;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8267__auto__ = function(state_15570){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8267__auto____1.call(this,state_15570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8267__auto____0;
cljs$core$async$mix_$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8267__auto____1;
return cljs$core$async$mix_$_state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___15633,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8289__auto__ = (function (){var statearr_15632 = f__8288__auto__.call(null);
(statearr_15632[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___15633);

return statearr_15632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___15633,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5235__auto__ = (((p == null))?null:p);
var m__5236__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5236__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5235__auto__ = (((p == null))?null:p);
var m__5236__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,p,v,ch);
} else {
var m__5236__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args15682 = [];
var len__5638__auto___15685 = arguments.length;
var i__5639__auto___15686 = (0);
while(true){
if((i__5639__auto___15686 < len__5638__auto___15685)){
args15682.push((arguments[i__5639__auto___15686]));

var G__15687 = (i__5639__auto___15686 + (1));
i__5639__auto___15686 = G__15687;
continue;
} else {
}
break;
}

var G__15684 = args15682.length;
switch (G__15684) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15682.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5235__auto__ = (((p == null))?null:p);
var m__5236__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,p);
} else {
var m__5236__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5235__auto__ = (((p == null))?null:p);
var m__5236__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5235__auto__)]);
if(!((m__5236__auto__ == null))){
return m__5236__auto__.call(null,p,v);
} else {
var m__5236__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5236__auto____$1 == null))){
return m__5236__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args15690 = [];
var len__5638__auto___15815 = arguments.length;
var i__5639__auto___15816 = (0);
while(true){
if((i__5639__auto___15816 < len__5638__auto___15815)){
args15690.push((arguments[i__5639__auto___15816]));

var G__15817 = (i__5639__auto___15816 + (1));
i__5639__auto___15816 = G__15817;
continue;
} else {
}
break;
}

var G__15692 = args15690.length;
switch (G__15692) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15690.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4580__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4580__auto__)){
return or__4580__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4580__auto__,mults){
return (function (p1__15689_SHARP_){
if(cljs.core.truth_(p1__15689_SHARP_.call(null,topic))){
return p1__15689_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__15689_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4580__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async15693 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15693 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta15694){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta15694 = meta15694;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15693.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_15695,meta15694__$1){
var self__ = this;
var _15695__$1 = this;
return (new cljs.core.async.t_cljs$core$async15693(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta15694__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15693.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_15695){
var self__ = this;
var _15695__$1 = this;
return self__.meta15694;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15693.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15693.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15693.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async15693.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15693.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15693.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15693.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15693.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta15694","meta15694",-606776363,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15693.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15693.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15693";

cljs.core.async.t_cljs$core$async15693.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"cljs.core.async/t_cljs$core$async15693");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async15693 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async15693(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15694){
return (new cljs.core.async.t_cljs$core$async15693(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15694));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async15693(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8287__auto___15819 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___15819,mults,ensure_mult,p){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___15819,mults,ensure_mult,p){
return (function (state_15767){
var state_val_15768 = (state_15767[(1)]);
if((state_val_15768 === (7))){
var inst_15763 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15769_15820 = state_15767__$1;
(statearr_15769_15820[(2)] = inst_15763);

(statearr_15769_15820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (20))){
var state_15767__$1 = state_15767;
var statearr_15770_15821 = state_15767__$1;
(statearr_15770_15821[(2)] = null);

(statearr_15770_15821[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (1))){
var state_15767__$1 = state_15767;
var statearr_15771_15822 = state_15767__$1;
(statearr_15771_15822[(2)] = null);

(statearr_15771_15822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (24))){
var inst_15746 = (state_15767[(7)]);
var inst_15755 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_15746);
var state_15767__$1 = state_15767;
var statearr_15772_15823 = state_15767__$1;
(statearr_15772_15823[(2)] = inst_15755);

(statearr_15772_15823[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (4))){
var inst_15698 = (state_15767[(8)]);
var inst_15698__$1 = (state_15767[(2)]);
var inst_15699 = (inst_15698__$1 == null);
var state_15767__$1 = (function (){var statearr_15773 = state_15767;
(statearr_15773[(8)] = inst_15698__$1);

return statearr_15773;
})();
if(cljs.core.truth_(inst_15699)){
var statearr_15774_15824 = state_15767__$1;
(statearr_15774_15824[(1)] = (5));

} else {
var statearr_15775_15825 = state_15767__$1;
(statearr_15775_15825[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (15))){
var inst_15740 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15776_15826 = state_15767__$1;
(statearr_15776_15826[(2)] = inst_15740);

(statearr_15776_15826[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (21))){
var inst_15760 = (state_15767[(2)]);
var state_15767__$1 = (function (){var statearr_15777 = state_15767;
(statearr_15777[(9)] = inst_15760);

return statearr_15777;
})();
var statearr_15778_15827 = state_15767__$1;
(statearr_15778_15827[(2)] = null);

(statearr_15778_15827[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (13))){
var inst_15722 = (state_15767[(10)]);
var inst_15724 = cljs.core.chunked_seq_QMARK_.call(null,inst_15722);
var state_15767__$1 = state_15767;
if(inst_15724){
var statearr_15779_15828 = state_15767__$1;
(statearr_15779_15828[(1)] = (16));

} else {
var statearr_15780_15829 = state_15767__$1;
(statearr_15780_15829[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (22))){
var inst_15752 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15752)){
var statearr_15781_15830 = state_15767__$1;
(statearr_15781_15830[(1)] = (23));

} else {
var statearr_15782_15831 = state_15767__$1;
(statearr_15782_15831[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (6))){
var inst_15748 = (state_15767[(11)]);
var inst_15746 = (state_15767[(7)]);
var inst_15698 = (state_15767[(8)]);
var inst_15746__$1 = topic_fn.call(null,inst_15698);
var inst_15747 = cljs.core.deref.call(null,mults);
var inst_15748__$1 = cljs.core.get.call(null,inst_15747,inst_15746__$1);
var state_15767__$1 = (function (){var statearr_15783 = state_15767;
(statearr_15783[(11)] = inst_15748__$1);

(statearr_15783[(7)] = inst_15746__$1);

return statearr_15783;
})();
if(cljs.core.truth_(inst_15748__$1)){
var statearr_15784_15832 = state_15767__$1;
(statearr_15784_15832[(1)] = (19));

} else {
var statearr_15785_15833 = state_15767__$1;
(statearr_15785_15833[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (25))){
var inst_15757 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15786_15834 = state_15767__$1;
(statearr_15786_15834[(2)] = inst_15757);

(statearr_15786_15834[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (17))){
var inst_15722 = (state_15767[(10)]);
var inst_15731 = cljs.core.first.call(null,inst_15722);
var inst_15732 = cljs.core.async.muxch_STAR_.call(null,inst_15731);
var inst_15733 = cljs.core.async.close_BANG_.call(null,inst_15732);
var inst_15734 = cljs.core.next.call(null,inst_15722);
var inst_15708 = inst_15734;
var inst_15709 = null;
var inst_15710 = (0);
var inst_15711 = (0);
var state_15767__$1 = (function (){var statearr_15787 = state_15767;
(statearr_15787[(12)] = inst_15708);

(statearr_15787[(13)] = inst_15733);

(statearr_15787[(14)] = inst_15711);

(statearr_15787[(15)] = inst_15709);

(statearr_15787[(16)] = inst_15710);

return statearr_15787;
})();
var statearr_15788_15835 = state_15767__$1;
(statearr_15788_15835[(2)] = null);

(statearr_15788_15835[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (3))){
var inst_15765 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15767__$1,inst_15765);
} else {
if((state_val_15768 === (12))){
var inst_15742 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15789_15836 = state_15767__$1;
(statearr_15789_15836[(2)] = inst_15742);

(statearr_15789_15836[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (2))){
var state_15767__$1 = state_15767;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15767__$1,(4),ch);
} else {
if((state_val_15768 === (23))){
var state_15767__$1 = state_15767;
var statearr_15790_15837 = state_15767__$1;
(statearr_15790_15837[(2)] = null);

(statearr_15790_15837[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (19))){
var inst_15748 = (state_15767[(11)]);
var inst_15698 = (state_15767[(8)]);
var inst_15750 = cljs.core.async.muxch_STAR_.call(null,inst_15748);
var state_15767__$1 = state_15767;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15767__$1,(22),inst_15750,inst_15698);
} else {
if((state_val_15768 === (11))){
var inst_15722 = (state_15767[(10)]);
var inst_15708 = (state_15767[(12)]);
var inst_15722__$1 = cljs.core.seq.call(null,inst_15708);
var state_15767__$1 = (function (){var statearr_15791 = state_15767;
(statearr_15791[(10)] = inst_15722__$1);

return statearr_15791;
})();
if(inst_15722__$1){
var statearr_15792_15838 = state_15767__$1;
(statearr_15792_15838[(1)] = (13));

} else {
var statearr_15793_15839 = state_15767__$1;
(statearr_15793_15839[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (9))){
var inst_15744 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15794_15840 = state_15767__$1;
(statearr_15794_15840[(2)] = inst_15744);

(statearr_15794_15840[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (5))){
var inst_15705 = cljs.core.deref.call(null,mults);
var inst_15706 = cljs.core.vals.call(null,inst_15705);
var inst_15707 = cljs.core.seq.call(null,inst_15706);
var inst_15708 = inst_15707;
var inst_15709 = null;
var inst_15710 = (0);
var inst_15711 = (0);
var state_15767__$1 = (function (){var statearr_15795 = state_15767;
(statearr_15795[(12)] = inst_15708);

(statearr_15795[(14)] = inst_15711);

(statearr_15795[(15)] = inst_15709);

(statearr_15795[(16)] = inst_15710);

return statearr_15795;
})();
var statearr_15796_15841 = state_15767__$1;
(statearr_15796_15841[(2)] = null);

(statearr_15796_15841[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (14))){
var state_15767__$1 = state_15767;
var statearr_15800_15842 = state_15767__$1;
(statearr_15800_15842[(2)] = null);

(statearr_15800_15842[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (16))){
var inst_15722 = (state_15767[(10)]);
var inst_15726 = cljs.core.chunk_first.call(null,inst_15722);
var inst_15727 = cljs.core.chunk_rest.call(null,inst_15722);
var inst_15728 = cljs.core.count.call(null,inst_15726);
var inst_15708 = inst_15727;
var inst_15709 = inst_15726;
var inst_15710 = inst_15728;
var inst_15711 = (0);
var state_15767__$1 = (function (){var statearr_15801 = state_15767;
(statearr_15801[(12)] = inst_15708);

(statearr_15801[(14)] = inst_15711);

(statearr_15801[(15)] = inst_15709);

(statearr_15801[(16)] = inst_15710);

return statearr_15801;
})();
var statearr_15802_15843 = state_15767__$1;
(statearr_15802_15843[(2)] = null);

(statearr_15802_15843[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (10))){
var inst_15708 = (state_15767[(12)]);
var inst_15711 = (state_15767[(14)]);
var inst_15709 = (state_15767[(15)]);
var inst_15710 = (state_15767[(16)]);
var inst_15716 = cljs.core._nth.call(null,inst_15709,inst_15711);
var inst_15717 = cljs.core.async.muxch_STAR_.call(null,inst_15716);
var inst_15718 = cljs.core.async.close_BANG_.call(null,inst_15717);
var inst_15719 = (inst_15711 + (1));
var tmp15797 = inst_15708;
var tmp15798 = inst_15709;
var tmp15799 = inst_15710;
var inst_15708__$1 = tmp15797;
var inst_15709__$1 = tmp15798;
var inst_15710__$1 = tmp15799;
var inst_15711__$1 = inst_15719;
var state_15767__$1 = (function (){var statearr_15803 = state_15767;
(statearr_15803[(12)] = inst_15708__$1);

(statearr_15803[(14)] = inst_15711__$1);

(statearr_15803[(15)] = inst_15709__$1);

(statearr_15803[(17)] = inst_15718);

(statearr_15803[(16)] = inst_15710__$1);

return statearr_15803;
})();
var statearr_15804_15844 = state_15767__$1;
(statearr_15804_15844[(2)] = null);

(statearr_15804_15844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (18))){
var inst_15737 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15805_15845 = state_15767__$1;
(statearr_15805_15845[(2)] = inst_15737);

(statearr_15805_15845[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (8))){
var inst_15711 = (state_15767[(14)]);
var inst_15710 = (state_15767[(16)]);
var inst_15713 = (inst_15711 < inst_15710);
var inst_15714 = inst_15713;
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15714)){
var statearr_15806_15846 = state_15767__$1;
(statearr_15806_15846[(1)] = (10));

} else {
var statearr_15807_15847 = state_15767__$1;
(statearr_15807_15847[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto___15819,mults,ensure_mult,p))
;
return ((function (switch__8266__auto__,c__8287__auto___15819,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8267__auto__ = null;
var cljs$core$async$state_machine__8267__auto____0 = (function (){
var statearr_15811 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15811[(0)] = cljs$core$async$state_machine__8267__auto__);

(statearr_15811[(1)] = (1));

return statearr_15811;
});
var cljs$core$async$state_machine__8267__auto____1 = (function (state_15767){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_15767);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e15812){if((e15812 instanceof Object)){
var ex__8270__auto__ = e15812;
var statearr_15813_15848 = state_15767;
(statearr_15813_15848[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15767);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15812;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15849 = state_15767;
state_15767 = G__15849;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$state_machine__8267__auto__ = function(state_15767){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8267__auto____1.call(this,state_15767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8267__auto____0;
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8267__auto____1;
return cljs$core$async$state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___15819,mults,ensure_mult,p))
})();
var state__8289__auto__ = (function (){var statearr_15814 = f__8288__auto__.call(null);
(statearr_15814[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___15819);

return statearr_15814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___15819,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args15850 = [];
var len__5638__auto___15853 = arguments.length;
var i__5639__auto___15854 = (0);
while(true){
if((i__5639__auto___15854 < len__5638__auto___15853)){
args15850.push((arguments[i__5639__auto___15854]));

var G__15855 = (i__5639__auto___15854 + (1));
i__5639__auto___15854 = G__15855;
continue;
} else {
}
break;
}

var G__15852 = args15850.length;
switch (G__15852) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15850.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args15857 = [];
var len__5638__auto___15860 = arguments.length;
var i__5639__auto___15861 = (0);
while(true){
if((i__5639__auto___15861 < len__5638__auto___15860)){
args15857.push((arguments[i__5639__auto___15861]));

var G__15862 = (i__5639__auto___15861 + (1));
i__5639__auto___15861 = G__15862;
continue;
} else {
}
break;
}

var G__15859 = args15857.length;
switch (G__15859) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15857.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args15864 = [];
var len__5638__auto___15935 = arguments.length;
var i__5639__auto___15936 = (0);
while(true){
if((i__5639__auto___15936 < len__5638__auto___15935)){
args15864.push((arguments[i__5639__auto___15936]));

var G__15937 = (i__5639__auto___15936 + (1));
i__5639__auto___15936 = G__15937;
continue;
} else {
}
break;
}

var G__15866 = args15864.length;
switch (G__15866) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15864.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8287__auto___15939 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___15939,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___15939,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_15905){
var state_val_15906 = (state_15905[(1)]);
if((state_val_15906 === (7))){
var state_15905__$1 = state_15905;
var statearr_15907_15940 = state_15905__$1;
(statearr_15907_15940[(2)] = null);

(statearr_15907_15940[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15906 === (1))){
var state_15905__$1 = state_15905;
var statearr_15908_15941 = state_15905__$1;
(statearr_15908_15941[(2)] = null);

(statearr_15908_15941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15906 === (4))){
var inst_15869 = (state_15905[(7)]);
var inst_15871 = (inst_15869 < cnt);
var state_15905__$1 = state_15905;
if(cljs.core.truth_(inst_15871)){
var statearr_15909_15942 = state_15905__$1;
(statearr_15909_15942[(1)] = (6));

} else {
var statearr_15910_15943 = state_15905__$1;
(statearr_15910_15943[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15906 === (15))){
var inst_15901 = (state_15905[(2)]);
var state_15905__$1 = state_15905;
var statearr_15911_15944 = state_15905__$1;
(statearr_15911_15944[(2)] = inst_15901);

(statearr_15911_15944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15906 === (13))){
var inst_15894 = cljs.core.async.close_BANG_.call(null,out);
var state_15905__$1 = state_15905;
var statearr_15912_15945 = state_15905__$1;
(statearr_15912_15945[(2)] = inst_15894);

(statearr_15912_15945[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15906 === (6))){
var state_15905__$1 = state_15905;
var statearr_15913_15946 = state_15905__$1;
(statearr_15913_15946[(2)] = null);

(statearr_15913_15946[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15906 === (3))){
var inst_15903 = (state_15905[(2)]);
var state_15905__$1 = state_15905;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15905__$1,inst_15903);
} else {
if((state_val_15906 === (12))){
var inst_15891 = (state_15905[(8)]);
var inst_15891__$1 = (state_15905[(2)]);
var inst_15892 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_15891__$1);
var state_15905__$1 = (function (){var statearr_15914 = state_15905;
(statearr_15914[(8)] = inst_15891__$1);

return statearr_15914;
})();
if(cljs.core.truth_(inst_15892)){
var statearr_15915_15947 = state_15905__$1;
(statearr_15915_15947[(1)] = (13));

} else {
var statearr_15916_15948 = state_15905__$1;
(statearr_15916_15948[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15906 === (2))){
var inst_15868 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_15869 = (0);
var state_15905__$1 = (function (){var statearr_15917 = state_15905;
(statearr_15917[(7)] = inst_15869);

(statearr_15917[(9)] = inst_15868);

return statearr_15917;
})();
var statearr_15918_15949 = state_15905__$1;
(statearr_15918_15949[(2)] = null);

(statearr_15918_15949[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15906 === (11))){
var inst_15869 = (state_15905[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_15905,(10),Object,null,(9));
var inst_15878 = chs__$1.call(null,inst_15869);
var inst_15879 = done.call(null,inst_15869);
var inst_15880 = cljs.core.async.take_BANG_.call(null,inst_15878,inst_15879);
var state_15905__$1 = state_15905;
var statearr_15919_15950 = state_15905__$1;
(statearr_15919_15950[(2)] = inst_15880);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15905__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15906 === (9))){
var inst_15869 = (state_15905[(7)]);
var inst_15882 = (state_15905[(2)]);
var inst_15883 = (inst_15869 + (1));
var inst_15869__$1 = inst_15883;
var state_15905__$1 = (function (){var statearr_15920 = state_15905;
(statearr_15920[(10)] = inst_15882);

(statearr_15920[(7)] = inst_15869__$1);

return statearr_15920;
})();
var statearr_15921_15951 = state_15905__$1;
(statearr_15921_15951[(2)] = null);

(statearr_15921_15951[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15906 === (5))){
var inst_15889 = (state_15905[(2)]);
var state_15905__$1 = (function (){var statearr_15922 = state_15905;
(statearr_15922[(11)] = inst_15889);

return statearr_15922;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15905__$1,(12),dchan);
} else {
if((state_val_15906 === (14))){
var inst_15891 = (state_15905[(8)]);
var inst_15896 = cljs.core.apply.call(null,f,inst_15891);
var state_15905__$1 = state_15905;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15905__$1,(16),out,inst_15896);
} else {
if((state_val_15906 === (16))){
var inst_15898 = (state_15905[(2)]);
var state_15905__$1 = (function (){var statearr_15923 = state_15905;
(statearr_15923[(12)] = inst_15898);

return statearr_15923;
})();
var statearr_15924_15952 = state_15905__$1;
(statearr_15924_15952[(2)] = null);

(statearr_15924_15952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15906 === (10))){
var inst_15873 = (state_15905[(2)]);
var inst_15874 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_15905__$1 = (function (){var statearr_15925 = state_15905;
(statearr_15925[(13)] = inst_15873);

return statearr_15925;
})();
var statearr_15926_15953 = state_15905__$1;
(statearr_15926_15953[(2)] = inst_15874);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15905__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15906 === (8))){
var inst_15887 = (state_15905[(2)]);
var state_15905__$1 = state_15905;
var statearr_15927_15954 = state_15905__$1;
(statearr_15927_15954[(2)] = inst_15887);

(statearr_15927_15954[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto___15939,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8266__auto__,c__8287__auto___15939,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8267__auto__ = null;
var cljs$core$async$state_machine__8267__auto____0 = (function (){
var statearr_15931 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15931[(0)] = cljs$core$async$state_machine__8267__auto__);

(statearr_15931[(1)] = (1));

return statearr_15931;
});
var cljs$core$async$state_machine__8267__auto____1 = (function (state_15905){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_15905);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e15932){if((e15932 instanceof Object)){
var ex__8270__auto__ = e15932;
var statearr_15933_15955 = state_15905;
(statearr_15933_15955[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15905);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15932;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15956 = state_15905;
state_15905 = G__15956;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$state_machine__8267__auto__ = function(state_15905){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8267__auto____1.call(this,state_15905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8267__auto____0;
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8267__auto____1;
return cljs$core$async$state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___15939,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8289__auto__ = (function (){var statearr_15934 = f__8288__auto__.call(null);
(statearr_15934[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___15939);

return statearr_15934;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___15939,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args15958 = [];
var len__5638__auto___16014 = arguments.length;
var i__5639__auto___16015 = (0);
while(true){
if((i__5639__auto___16015 < len__5638__auto___16014)){
args15958.push((arguments[i__5639__auto___16015]));

var G__16016 = (i__5639__auto___16015 + (1));
i__5639__auto___16015 = G__16016;
continue;
} else {
}
break;
}

var G__15960 = args15958.length;
switch (G__15960) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15958.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8287__auto___16018 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___16018,out){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___16018,out){
return (function (state_15990){
var state_val_15991 = (state_15990[(1)]);
if((state_val_15991 === (7))){
var inst_15970 = (state_15990[(7)]);
var inst_15969 = (state_15990[(8)]);
var inst_15969__$1 = (state_15990[(2)]);
var inst_15970__$1 = cljs.core.nth.call(null,inst_15969__$1,(0),null);
var inst_15971 = cljs.core.nth.call(null,inst_15969__$1,(1),null);
var inst_15972 = (inst_15970__$1 == null);
var state_15990__$1 = (function (){var statearr_15992 = state_15990;
(statearr_15992[(7)] = inst_15970__$1);

(statearr_15992[(8)] = inst_15969__$1);

(statearr_15992[(9)] = inst_15971);

return statearr_15992;
})();
if(cljs.core.truth_(inst_15972)){
var statearr_15993_16019 = state_15990__$1;
(statearr_15993_16019[(1)] = (8));

} else {
var statearr_15994_16020 = state_15990__$1;
(statearr_15994_16020[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15991 === (1))){
var inst_15961 = cljs.core.vec.call(null,chs);
var inst_15962 = inst_15961;
var state_15990__$1 = (function (){var statearr_15995 = state_15990;
(statearr_15995[(10)] = inst_15962);

return statearr_15995;
})();
var statearr_15996_16021 = state_15990__$1;
(statearr_15996_16021[(2)] = null);

(statearr_15996_16021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15991 === (4))){
var inst_15962 = (state_15990[(10)]);
var state_15990__$1 = state_15990;
return cljs.core.async.ioc_alts_BANG_.call(null,state_15990__$1,(7),inst_15962);
} else {
if((state_val_15991 === (6))){
var inst_15986 = (state_15990[(2)]);
var state_15990__$1 = state_15990;
var statearr_15997_16022 = state_15990__$1;
(statearr_15997_16022[(2)] = inst_15986);

(statearr_15997_16022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15991 === (3))){
var inst_15988 = (state_15990[(2)]);
var state_15990__$1 = state_15990;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15990__$1,inst_15988);
} else {
if((state_val_15991 === (2))){
var inst_15962 = (state_15990[(10)]);
var inst_15964 = cljs.core.count.call(null,inst_15962);
var inst_15965 = (inst_15964 > (0));
var state_15990__$1 = state_15990;
if(cljs.core.truth_(inst_15965)){
var statearr_15999_16023 = state_15990__$1;
(statearr_15999_16023[(1)] = (4));

} else {
var statearr_16000_16024 = state_15990__$1;
(statearr_16000_16024[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15991 === (11))){
var inst_15962 = (state_15990[(10)]);
var inst_15979 = (state_15990[(2)]);
var tmp15998 = inst_15962;
var inst_15962__$1 = tmp15998;
var state_15990__$1 = (function (){var statearr_16001 = state_15990;
(statearr_16001[(10)] = inst_15962__$1);

(statearr_16001[(11)] = inst_15979);

return statearr_16001;
})();
var statearr_16002_16025 = state_15990__$1;
(statearr_16002_16025[(2)] = null);

(statearr_16002_16025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15991 === (9))){
var inst_15970 = (state_15990[(7)]);
var state_15990__$1 = state_15990;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15990__$1,(11),out,inst_15970);
} else {
if((state_val_15991 === (5))){
var inst_15984 = cljs.core.async.close_BANG_.call(null,out);
var state_15990__$1 = state_15990;
var statearr_16003_16026 = state_15990__$1;
(statearr_16003_16026[(2)] = inst_15984);

(statearr_16003_16026[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15991 === (10))){
var inst_15982 = (state_15990[(2)]);
var state_15990__$1 = state_15990;
var statearr_16004_16027 = state_15990__$1;
(statearr_16004_16027[(2)] = inst_15982);

(statearr_16004_16027[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15991 === (8))){
var inst_15970 = (state_15990[(7)]);
var inst_15969 = (state_15990[(8)]);
var inst_15962 = (state_15990[(10)]);
var inst_15971 = (state_15990[(9)]);
var inst_15974 = (function (){var cs = inst_15962;
var vec__15967 = inst_15969;
var v = inst_15970;
var c = inst_15971;
return ((function (cs,vec__15967,v,c,inst_15970,inst_15969,inst_15962,inst_15971,state_val_15991,c__8287__auto___16018,out){
return (function (p1__15957_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__15957_SHARP_);
});
;})(cs,vec__15967,v,c,inst_15970,inst_15969,inst_15962,inst_15971,state_val_15991,c__8287__auto___16018,out))
})();
var inst_15975 = cljs.core.filterv.call(null,inst_15974,inst_15962);
var inst_15962__$1 = inst_15975;
var state_15990__$1 = (function (){var statearr_16005 = state_15990;
(statearr_16005[(10)] = inst_15962__$1);

return statearr_16005;
})();
var statearr_16006_16028 = state_15990__$1;
(statearr_16006_16028[(2)] = null);

(statearr_16006_16028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto___16018,out))
;
return ((function (switch__8266__auto__,c__8287__auto___16018,out){
return (function() {
var cljs$core$async$state_machine__8267__auto__ = null;
var cljs$core$async$state_machine__8267__auto____0 = (function (){
var statearr_16010 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16010[(0)] = cljs$core$async$state_machine__8267__auto__);

(statearr_16010[(1)] = (1));

return statearr_16010;
});
var cljs$core$async$state_machine__8267__auto____1 = (function (state_15990){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_15990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e16011){if((e16011 instanceof Object)){
var ex__8270__auto__ = e16011;
var statearr_16012_16029 = state_15990;
(statearr_16012_16029[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15990);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16011;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16030 = state_15990;
state_15990 = G__16030;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$state_machine__8267__auto__ = function(state_15990){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8267__auto____1.call(this,state_15990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8267__auto____0;
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8267__auto____1;
return cljs$core$async$state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___16018,out))
})();
var state__8289__auto__ = (function (){var statearr_16013 = f__8288__auto__.call(null);
(statearr_16013[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___16018);

return statearr_16013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___16018,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args16031 = [];
var len__5638__auto___16080 = arguments.length;
var i__5639__auto___16081 = (0);
while(true){
if((i__5639__auto___16081 < len__5638__auto___16080)){
args16031.push((arguments[i__5639__auto___16081]));

var G__16082 = (i__5639__auto___16081 + (1));
i__5639__auto___16081 = G__16082;
continue;
} else {
}
break;
}

var G__16033 = args16031.length;
switch (G__16033) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16031.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8287__auto___16084 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___16084,out){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___16084,out){
return (function (state_16057){
var state_val_16058 = (state_16057[(1)]);
if((state_val_16058 === (7))){
var inst_16039 = (state_16057[(7)]);
var inst_16039__$1 = (state_16057[(2)]);
var inst_16040 = (inst_16039__$1 == null);
var inst_16041 = cljs.core.not.call(null,inst_16040);
var state_16057__$1 = (function (){var statearr_16059 = state_16057;
(statearr_16059[(7)] = inst_16039__$1);

return statearr_16059;
})();
if(inst_16041){
var statearr_16060_16085 = state_16057__$1;
(statearr_16060_16085[(1)] = (8));

} else {
var statearr_16061_16086 = state_16057__$1;
(statearr_16061_16086[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16058 === (1))){
var inst_16034 = (0);
var state_16057__$1 = (function (){var statearr_16062 = state_16057;
(statearr_16062[(8)] = inst_16034);

return statearr_16062;
})();
var statearr_16063_16087 = state_16057__$1;
(statearr_16063_16087[(2)] = null);

(statearr_16063_16087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16058 === (4))){
var state_16057__$1 = state_16057;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16057__$1,(7),ch);
} else {
if((state_val_16058 === (6))){
var inst_16052 = (state_16057[(2)]);
var state_16057__$1 = state_16057;
var statearr_16064_16088 = state_16057__$1;
(statearr_16064_16088[(2)] = inst_16052);

(statearr_16064_16088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16058 === (3))){
var inst_16054 = (state_16057[(2)]);
var inst_16055 = cljs.core.async.close_BANG_.call(null,out);
var state_16057__$1 = (function (){var statearr_16065 = state_16057;
(statearr_16065[(9)] = inst_16054);

return statearr_16065;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16057__$1,inst_16055);
} else {
if((state_val_16058 === (2))){
var inst_16034 = (state_16057[(8)]);
var inst_16036 = (inst_16034 < n);
var state_16057__$1 = state_16057;
if(cljs.core.truth_(inst_16036)){
var statearr_16066_16089 = state_16057__$1;
(statearr_16066_16089[(1)] = (4));

} else {
var statearr_16067_16090 = state_16057__$1;
(statearr_16067_16090[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16058 === (11))){
var inst_16034 = (state_16057[(8)]);
var inst_16044 = (state_16057[(2)]);
var inst_16045 = (inst_16034 + (1));
var inst_16034__$1 = inst_16045;
var state_16057__$1 = (function (){var statearr_16068 = state_16057;
(statearr_16068[(8)] = inst_16034__$1);

(statearr_16068[(10)] = inst_16044);

return statearr_16068;
})();
var statearr_16069_16091 = state_16057__$1;
(statearr_16069_16091[(2)] = null);

(statearr_16069_16091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16058 === (9))){
var state_16057__$1 = state_16057;
var statearr_16070_16092 = state_16057__$1;
(statearr_16070_16092[(2)] = null);

(statearr_16070_16092[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16058 === (5))){
var state_16057__$1 = state_16057;
var statearr_16071_16093 = state_16057__$1;
(statearr_16071_16093[(2)] = null);

(statearr_16071_16093[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16058 === (10))){
var inst_16049 = (state_16057[(2)]);
var state_16057__$1 = state_16057;
var statearr_16072_16094 = state_16057__$1;
(statearr_16072_16094[(2)] = inst_16049);

(statearr_16072_16094[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16058 === (8))){
var inst_16039 = (state_16057[(7)]);
var state_16057__$1 = state_16057;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16057__$1,(11),out,inst_16039);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto___16084,out))
;
return ((function (switch__8266__auto__,c__8287__auto___16084,out){
return (function() {
var cljs$core$async$state_machine__8267__auto__ = null;
var cljs$core$async$state_machine__8267__auto____0 = (function (){
var statearr_16076 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16076[(0)] = cljs$core$async$state_machine__8267__auto__);

(statearr_16076[(1)] = (1));

return statearr_16076;
});
var cljs$core$async$state_machine__8267__auto____1 = (function (state_16057){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_16057);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e16077){if((e16077 instanceof Object)){
var ex__8270__auto__ = e16077;
var statearr_16078_16095 = state_16057;
(statearr_16078_16095[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16057);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16077;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16096 = state_16057;
state_16057 = G__16096;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$state_machine__8267__auto__ = function(state_16057){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8267__auto____1.call(this,state_16057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8267__auto____0;
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8267__auto____1;
return cljs$core$async$state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___16084,out))
})();
var state__8289__auto__ = (function (){var statearr_16079 = f__8288__auto__.call(null);
(statearr_16079[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___16084);

return statearr_16079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___16084,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16104 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16104 = (function (map_LT_,f,ch,meta16105){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16105 = meta16105;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16104.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16106,meta16105__$1){
var self__ = this;
var _16106__$1 = this;
return (new cljs.core.async.t_cljs$core$async16104(self__.map_LT_,self__.f,self__.ch,meta16105__$1));
});

cljs.core.async.t_cljs$core$async16104.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16106){
var self__ = this;
var _16106__$1 = this;
return self__.meta16105;
});

cljs.core.async.t_cljs$core$async16104.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16104.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16104.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16104.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16104.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16107 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16107 = (function (map_LT_,f,ch,meta16105,_,fn1,meta16108){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16105 = meta16105;
this._ = _;
this.fn1 = fn1;
this.meta16108 = meta16108;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16107.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16109,meta16108__$1){
var self__ = this;
var _16109__$1 = this;
return (new cljs.core.async.t_cljs$core$async16107(self__.map_LT_,self__.f,self__.ch,self__.meta16105,self__._,self__.fn1,meta16108__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16107.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16109){
var self__ = this;
var _16109__$1 = this;
return self__.meta16108;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16107.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16107.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16107.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16097_SHARP_){
return f1.call(null,(((p1__16097_SHARP_ == null))?null:self__.f.call(null,p1__16097_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16107.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16105","meta16105",-1866140093,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16104","cljs.core.async/t_cljs$core$async16104",-922211567,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16108","meta16108",281638834,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16107.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16107.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16107";

cljs.core.async.t_cljs$core$async16107.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"cljs.core.async/t_cljs$core$async16107");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16107 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16107(map_LT___$1,f__$1,ch__$1,meta16105__$1,___$2,fn1__$1,meta16108){
return (new cljs.core.async.t_cljs$core$async16107(map_LT___$1,f__$1,ch__$1,meta16105__$1,___$2,fn1__$1,meta16108));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16107(self__.map_LT_,self__.f,self__.ch,self__.meta16105,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4568__auto__ = ret;
if(cljs.core.truth_(and__4568__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4568__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16104.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16104.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16104.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16105","meta16105",-1866140093,null)], null);
});

cljs.core.async.t_cljs$core$async16104.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16104.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16104";

cljs.core.async.t_cljs$core$async16104.cljs$lang$ctorPrWriter = (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"cljs.core.async/t_cljs$core$async16104");
});

cljs.core.async.__GT_t_cljs$core$async16104 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16104(map_LT___$1,f__$1,ch__$1,meta16105){
return (new cljs.core.async.t_cljs$core$async16104(map_LT___$1,f__$1,ch__$1,meta16105));
});

}

return (new cljs.core.async.t_cljs$core$async16104(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16113 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16113 = (function (map_GT_,f,ch,meta16114){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta16114 = meta16114;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16115,meta16114__$1){
var self__ = this;
var _16115__$1 = this;
return (new cljs.core.async.t_cljs$core$async16113(self__.map_GT_,self__.f,self__.ch,meta16114__$1));
});

cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16115){
var self__ = this;
var _16115__$1 = this;
return self__.meta16114;
});

cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async16113.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16114","meta16114",-1384101444,null)], null);
});

cljs.core.async.t_cljs$core$async16113.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16113.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16113";

cljs.core.async.t_cljs$core$async16113.cljs$lang$ctorPrWriter = (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"cljs.core.async/t_cljs$core$async16113");
});

cljs.core.async.__GT_t_cljs$core$async16113 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16113(map_GT___$1,f__$1,ch__$1,meta16114){
return (new cljs.core.async.t_cljs$core$async16113(map_GT___$1,f__$1,ch__$1,meta16114));
});

}

return (new cljs.core.async.t_cljs$core$async16113(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async16119 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16119 = (function (filter_GT_,p,ch,meta16120){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta16120 = meta16120;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16119.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16121,meta16120__$1){
var self__ = this;
var _16121__$1 = this;
return (new cljs.core.async.t_cljs$core$async16119(self__.filter_GT_,self__.p,self__.ch,meta16120__$1));
});

cljs.core.async.t_cljs$core$async16119.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16121){
var self__ = this;
var _16121__$1 = this;
return self__.meta16120;
});

cljs.core.async.t_cljs$core$async16119.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16119.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16119.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16119.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16119.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16119.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16119.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async16119.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16120","meta16120",2004987801,null)], null);
});

cljs.core.async.t_cljs$core$async16119.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16119.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16119";

cljs.core.async.t_cljs$core$async16119.cljs$lang$ctorPrWriter = (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"cljs.core.async/t_cljs$core$async16119");
});

cljs.core.async.__GT_t_cljs$core$async16119 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async16119(filter_GT___$1,p__$1,ch__$1,meta16120){
return (new cljs.core.async.t_cljs$core$async16119(filter_GT___$1,p__$1,ch__$1,meta16120));
});

}

return (new cljs.core.async.t_cljs$core$async16119(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args16122 = [];
var len__5638__auto___16166 = arguments.length;
var i__5639__auto___16167 = (0);
while(true){
if((i__5639__auto___16167 < len__5638__auto___16166)){
args16122.push((arguments[i__5639__auto___16167]));

var G__16168 = (i__5639__auto___16167 + (1));
i__5639__auto___16167 = G__16168;
continue;
} else {
}
break;
}

var G__16124 = args16122.length;
switch (G__16124) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16122.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8287__auto___16170 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___16170,out){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___16170,out){
return (function (state_16145){
var state_val_16146 = (state_16145[(1)]);
if((state_val_16146 === (7))){
var inst_16141 = (state_16145[(2)]);
var state_16145__$1 = state_16145;
var statearr_16147_16171 = state_16145__$1;
(statearr_16147_16171[(2)] = inst_16141);

(statearr_16147_16171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (1))){
var state_16145__$1 = state_16145;
var statearr_16148_16172 = state_16145__$1;
(statearr_16148_16172[(2)] = null);

(statearr_16148_16172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (4))){
var inst_16127 = (state_16145[(7)]);
var inst_16127__$1 = (state_16145[(2)]);
var inst_16128 = (inst_16127__$1 == null);
var state_16145__$1 = (function (){var statearr_16149 = state_16145;
(statearr_16149[(7)] = inst_16127__$1);

return statearr_16149;
})();
if(cljs.core.truth_(inst_16128)){
var statearr_16150_16173 = state_16145__$1;
(statearr_16150_16173[(1)] = (5));

} else {
var statearr_16151_16174 = state_16145__$1;
(statearr_16151_16174[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (6))){
var inst_16127 = (state_16145[(7)]);
var inst_16132 = p.call(null,inst_16127);
var state_16145__$1 = state_16145;
if(cljs.core.truth_(inst_16132)){
var statearr_16152_16175 = state_16145__$1;
(statearr_16152_16175[(1)] = (8));

} else {
var statearr_16153_16176 = state_16145__$1;
(statearr_16153_16176[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (3))){
var inst_16143 = (state_16145[(2)]);
var state_16145__$1 = state_16145;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16145__$1,inst_16143);
} else {
if((state_val_16146 === (2))){
var state_16145__$1 = state_16145;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16145__$1,(4),ch);
} else {
if((state_val_16146 === (11))){
var inst_16135 = (state_16145[(2)]);
var state_16145__$1 = state_16145;
var statearr_16154_16177 = state_16145__$1;
(statearr_16154_16177[(2)] = inst_16135);

(statearr_16154_16177[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (9))){
var state_16145__$1 = state_16145;
var statearr_16155_16178 = state_16145__$1;
(statearr_16155_16178[(2)] = null);

(statearr_16155_16178[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (5))){
var inst_16130 = cljs.core.async.close_BANG_.call(null,out);
var state_16145__$1 = state_16145;
var statearr_16156_16179 = state_16145__$1;
(statearr_16156_16179[(2)] = inst_16130);

(statearr_16156_16179[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (10))){
var inst_16138 = (state_16145[(2)]);
var state_16145__$1 = (function (){var statearr_16157 = state_16145;
(statearr_16157[(8)] = inst_16138);

return statearr_16157;
})();
var statearr_16158_16180 = state_16145__$1;
(statearr_16158_16180[(2)] = null);

(statearr_16158_16180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (8))){
var inst_16127 = (state_16145[(7)]);
var state_16145__$1 = state_16145;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16145__$1,(11),out,inst_16127);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto___16170,out))
;
return ((function (switch__8266__auto__,c__8287__auto___16170,out){
return (function() {
var cljs$core$async$state_machine__8267__auto__ = null;
var cljs$core$async$state_machine__8267__auto____0 = (function (){
var statearr_16162 = [null,null,null,null,null,null,null,null,null];
(statearr_16162[(0)] = cljs$core$async$state_machine__8267__auto__);

(statearr_16162[(1)] = (1));

return statearr_16162;
});
var cljs$core$async$state_machine__8267__auto____1 = (function (state_16145){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_16145);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e16163){if((e16163 instanceof Object)){
var ex__8270__auto__ = e16163;
var statearr_16164_16181 = state_16145;
(statearr_16164_16181[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16145);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16163;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16182 = state_16145;
state_16145 = G__16182;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$state_machine__8267__auto__ = function(state_16145){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8267__auto____1.call(this,state_16145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8267__auto____0;
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8267__auto____1;
return cljs$core$async$state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___16170,out))
})();
var state__8289__auto__ = (function (){var statearr_16165 = f__8288__auto__.call(null);
(statearr_16165[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___16170);

return statearr_16165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___16170,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args16183 = [];
var len__5638__auto___16186 = arguments.length;
var i__5639__auto___16187 = (0);
while(true){
if((i__5639__auto___16187 < len__5638__auto___16186)){
args16183.push((arguments[i__5639__auto___16187]));

var G__16188 = (i__5639__auto___16187 + (1));
i__5639__auto___16187 = G__16188;
continue;
} else {
}
break;
}

var G__16185 = args16183.length;
switch (G__16185) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16183.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8287__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto__){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto__){
return (function (state_16355){
var state_val_16356 = (state_16355[(1)]);
if((state_val_16356 === (7))){
var inst_16351 = (state_16355[(2)]);
var state_16355__$1 = state_16355;
var statearr_16357_16398 = state_16355__$1;
(statearr_16357_16398[(2)] = inst_16351);

(statearr_16357_16398[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (20))){
var inst_16321 = (state_16355[(7)]);
var inst_16332 = (state_16355[(2)]);
var inst_16333 = cljs.core.next.call(null,inst_16321);
var inst_16307 = inst_16333;
var inst_16308 = null;
var inst_16309 = (0);
var inst_16310 = (0);
var state_16355__$1 = (function (){var statearr_16358 = state_16355;
(statearr_16358[(8)] = inst_16309);

(statearr_16358[(9)] = inst_16308);

(statearr_16358[(10)] = inst_16310);

(statearr_16358[(11)] = inst_16332);

(statearr_16358[(12)] = inst_16307);

return statearr_16358;
})();
var statearr_16359_16399 = state_16355__$1;
(statearr_16359_16399[(2)] = null);

(statearr_16359_16399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (1))){
var state_16355__$1 = state_16355;
var statearr_16360_16400 = state_16355__$1;
(statearr_16360_16400[(2)] = null);

(statearr_16360_16400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (4))){
var inst_16296 = (state_16355[(13)]);
var inst_16296__$1 = (state_16355[(2)]);
var inst_16297 = (inst_16296__$1 == null);
var state_16355__$1 = (function (){var statearr_16361 = state_16355;
(statearr_16361[(13)] = inst_16296__$1);

return statearr_16361;
})();
if(cljs.core.truth_(inst_16297)){
var statearr_16362_16401 = state_16355__$1;
(statearr_16362_16401[(1)] = (5));

} else {
var statearr_16363_16402 = state_16355__$1;
(statearr_16363_16402[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (15))){
var state_16355__$1 = state_16355;
var statearr_16367_16403 = state_16355__$1;
(statearr_16367_16403[(2)] = null);

(statearr_16367_16403[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (21))){
var state_16355__$1 = state_16355;
var statearr_16368_16404 = state_16355__$1;
(statearr_16368_16404[(2)] = null);

(statearr_16368_16404[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (13))){
var inst_16309 = (state_16355[(8)]);
var inst_16308 = (state_16355[(9)]);
var inst_16310 = (state_16355[(10)]);
var inst_16307 = (state_16355[(12)]);
var inst_16317 = (state_16355[(2)]);
var inst_16318 = (inst_16310 + (1));
var tmp16364 = inst_16309;
var tmp16365 = inst_16308;
var tmp16366 = inst_16307;
var inst_16307__$1 = tmp16366;
var inst_16308__$1 = tmp16365;
var inst_16309__$1 = tmp16364;
var inst_16310__$1 = inst_16318;
var state_16355__$1 = (function (){var statearr_16369 = state_16355;
(statearr_16369[(8)] = inst_16309__$1);

(statearr_16369[(14)] = inst_16317);

(statearr_16369[(9)] = inst_16308__$1);

(statearr_16369[(10)] = inst_16310__$1);

(statearr_16369[(12)] = inst_16307__$1);

return statearr_16369;
})();
var statearr_16370_16405 = state_16355__$1;
(statearr_16370_16405[(2)] = null);

(statearr_16370_16405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (22))){
var state_16355__$1 = state_16355;
var statearr_16371_16406 = state_16355__$1;
(statearr_16371_16406[(2)] = null);

(statearr_16371_16406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (6))){
var inst_16296 = (state_16355[(13)]);
var inst_16305 = f.call(null,inst_16296);
var inst_16306 = cljs.core.seq.call(null,inst_16305);
var inst_16307 = inst_16306;
var inst_16308 = null;
var inst_16309 = (0);
var inst_16310 = (0);
var state_16355__$1 = (function (){var statearr_16372 = state_16355;
(statearr_16372[(8)] = inst_16309);

(statearr_16372[(9)] = inst_16308);

(statearr_16372[(10)] = inst_16310);

(statearr_16372[(12)] = inst_16307);

return statearr_16372;
})();
var statearr_16373_16407 = state_16355__$1;
(statearr_16373_16407[(2)] = null);

(statearr_16373_16407[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (17))){
var inst_16321 = (state_16355[(7)]);
var inst_16325 = cljs.core.chunk_first.call(null,inst_16321);
var inst_16326 = cljs.core.chunk_rest.call(null,inst_16321);
var inst_16327 = cljs.core.count.call(null,inst_16325);
var inst_16307 = inst_16326;
var inst_16308 = inst_16325;
var inst_16309 = inst_16327;
var inst_16310 = (0);
var state_16355__$1 = (function (){var statearr_16374 = state_16355;
(statearr_16374[(8)] = inst_16309);

(statearr_16374[(9)] = inst_16308);

(statearr_16374[(10)] = inst_16310);

(statearr_16374[(12)] = inst_16307);

return statearr_16374;
})();
var statearr_16375_16408 = state_16355__$1;
(statearr_16375_16408[(2)] = null);

(statearr_16375_16408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (3))){
var inst_16353 = (state_16355[(2)]);
var state_16355__$1 = state_16355;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16355__$1,inst_16353);
} else {
if((state_val_16356 === (12))){
var inst_16341 = (state_16355[(2)]);
var state_16355__$1 = state_16355;
var statearr_16376_16409 = state_16355__$1;
(statearr_16376_16409[(2)] = inst_16341);

(statearr_16376_16409[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (2))){
var state_16355__$1 = state_16355;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16355__$1,(4),in$);
} else {
if((state_val_16356 === (23))){
var inst_16349 = (state_16355[(2)]);
var state_16355__$1 = state_16355;
var statearr_16377_16410 = state_16355__$1;
(statearr_16377_16410[(2)] = inst_16349);

(statearr_16377_16410[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (19))){
var inst_16336 = (state_16355[(2)]);
var state_16355__$1 = state_16355;
var statearr_16378_16411 = state_16355__$1;
(statearr_16378_16411[(2)] = inst_16336);

(statearr_16378_16411[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (11))){
var inst_16321 = (state_16355[(7)]);
var inst_16307 = (state_16355[(12)]);
var inst_16321__$1 = cljs.core.seq.call(null,inst_16307);
var state_16355__$1 = (function (){var statearr_16379 = state_16355;
(statearr_16379[(7)] = inst_16321__$1);

return statearr_16379;
})();
if(inst_16321__$1){
var statearr_16380_16412 = state_16355__$1;
(statearr_16380_16412[(1)] = (14));

} else {
var statearr_16381_16413 = state_16355__$1;
(statearr_16381_16413[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (9))){
var inst_16343 = (state_16355[(2)]);
var inst_16344 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_16355__$1 = (function (){var statearr_16382 = state_16355;
(statearr_16382[(15)] = inst_16343);

return statearr_16382;
})();
if(cljs.core.truth_(inst_16344)){
var statearr_16383_16414 = state_16355__$1;
(statearr_16383_16414[(1)] = (21));

} else {
var statearr_16384_16415 = state_16355__$1;
(statearr_16384_16415[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (5))){
var inst_16299 = cljs.core.async.close_BANG_.call(null,out);
var state_16355__$1 = state_16355;
var statearr_16385_16416 = state_16355__$1;
(statearr_16385_16416[(2)] = inst_16299);

(statearr_16385_16416[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (14))){
var inst_16321 = (state_16355[(7)]);
var inst_16323 = cljs.core.chunked_seq_QMARK_.call(null,inst_16321);
var state_16355__$1 = state_16355;
if(inst_16323){
var statearr_16386_16417 = state_16355__$1;
(statearr_16386_16417[(1)] = (17));

} else {
var statearr_16387_16418 = state_16355__$1;
(statearr_16387_16418[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (16))){
var inst_16339 = (state_16355[(2)]);
var state_16355__$1 = state_16355;
var statearr_16388_16419 = state_16355__$1;
(statearr_16388_16419[(2)] = inst_16339);

(statearr_16388_16419[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (10))){
var inst_16308 = (state_16355[(9)]);
var inst_16310 = (state_16355[(10)]);
var inst_16315 = cljs.core._nth.call(null,inst_16308,inst_16310);
var state_16355__$1 = state_16355;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16355__$1,(13),out,inst_16315);
} else {
if((state_val_16356 === (18))){
var inst_16321 = (state_16355[(7)]);
var inst_16330 = cljs.core.first.call(null,inst_16321);
var state_16355__$1 = state_16355;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16355__$1,(20),out,inst_16330);
} else {
if((state_val_16356 === (8))){
var inst_16309 = (state_16355[(8)]);
var inst_16310 = (state_16355[(10)]);
var inst_16312 = (inst_16310 < inst_16309);
var inst_16313 = inst_16312;
var state_16355__$1 = state_16355;
if(cljs.core.truth_(inst_16313)){
var statearr_16389_16420 = state_16355__$1;
(statearr_16389_16420[(1)] = (10));

} else {
var statearr_16390_16421 = state_16355__$1;
(statearr_16390_16421[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto__))
;
return ((function (switch__8266__auto__,c__8287__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8267__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8267__auto____0 = (function (){
var statearr_16394 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16394[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8267__auto__);

(statearr_16394[(1)] = (1));

return statearr_16394;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8267__auto____1 = (function (state_16355){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_16355);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e16395){if((e16395 instanceof Object)){
var ex__8270__auto__ = e16395;
var statearr_16396_16422 = state_16355;
(statearr_16396_16422[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16355);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16395;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16423 = state_16355;
state_16355 = G__16423;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8267__auto__ = function(state_16355){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8267__auto____1.call(this,state_16355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8267__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8267__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto__))
})();
var state__8289__auto__ = (function (){var statearr_16397 = f__8288__auto__.call(null);
(statearr_16397[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto__);

return statearr_16397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto__))
);

return c__8287__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args16424 = [];
var len__5638__auto___16427 = arguments.length;
var i__5639__auto___16428 = (0);
while(true){
if((i__5639__auto___16428 < len__5638__auto___16427)){
args16424.push((arguments[i__5639__auto___16428]));

var G__16429 = (i__5639__auto___16428 + (1));
i__5639__auto___16428 = G__16429;
continue;
} else {
}
break;
}

var G__16426 = args16424.length;
switch (G__16426) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16424.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args16431 = [];
var len__5638__auto___16434 = arguments.length;
var i__5639__auto___16435 = (0);
while(true){
if((i__5639__auto___16435 < len__5638__auto___16434)){
args16431.push((arguments[i__5639__auto___16435]));

var G__16436 = (i__5639__auto___16435 + (1));
i__5639__auto___16435 = G__16436;
continue;
} else {
}
break;
}

var G__16433 = args16431.length;
switch (G__16433) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16431.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args16438 = [];
var len__5638__auto___16489 = arguments.length;
var i__5639__auto___16490 = (0);
while(true){
if((i__5639__auto___16490 < len__5638__auto___16489)){
args16438.push((arguments[i__5639__auto___16490]));

var G__16491 = (i__5639__auto___16490 + (1));
i__5639__auto___16490 = G__16491;
continue;
} else {
}
break;
}

var G__16440 = args16438.length;
switch (G__16440) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16438.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8287__auto___16493 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___16493,out){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___16493,out){
return (function (state_16464){
var state_val_16465 = (state_16464[(1)]);
if((state_val_16465 === (7))){
var inst_16459 = (state_16464[(2)]);
var state_16464__$1 = state_16464;
var statearr_16466_16494 = state_16464__$1;
(statearr_16466_16494[(2)] = inst_16459);

(statearr_16466_16494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16465 === (1))){
var inst_16441 = null;
var state_16464__$1 = (function (){var statearr_16467 = state_16464;
(statearr_16467[(7)] = inst_16441);

return statearr_16467;
})();
var statearr_16468_16495 = state_16464__$1;
(statearr_16468_16495[(2)] = null);

(statearr_16468_16495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16465 === (4))){
var inst_16444 = (state_16464[(8)]);
var inst_16444__$1 = (state_16464[(2)]);
var inst_16445 = (inst_16444__$1 == null);
var inst_16446 = cljs.core.not.call(null,inst_16445);
var state_16464__$1 = (function (){var statearr_16469 = state_16464;
(statearr_16469[(8)] = inst_16444__$1);

return statearr_16469;
})();
if(inst_16446){
var statearr_16470_16496 = state_16464__$1;
(statearr_16470_16496[(1)] = (5));

} else {
var statearr_16471_16497 = state_16464__$1;
(statearr_16471_16497[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16465 === (6))){
var state_16464__$1 = state_16464;
var statearr_16472_16498 = state_16464__$1;
(statearr_16472_16498[(2)] = null);

(statearr_16472_16498[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16465 === (3))){
var inst_16461 = (state_16464[(2)]);
var inst_16462 = cljs.core.async.close_BANG_.call(null,out);
var state_16464__$1 = (function (){var statearr_16473 = state_16464;
(statearr_16473[(9)] = inst_16461);

return statearr_16473;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16464__$1,inst_16462);
} else {
if((state_val_16465 === (2))){
var state_16464__$1 = state_16464;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16464__$1,(4),ch);
} else {
if((state_val_16465 === (11))){
var inst_16444 = (state_16464[(8)]);
var inst_16453 = (state_16464[(2)]);
var inst_16441 = inst_16444;
var state_16464__$1 = (function (){var statearr_16474 = state_16464;
(statearr_16474[(10)] = inst_16453);

(statearr_16474[(7)] = inst_16441);

return statearr_16474;
})();
var statearr_16475_16499 = state_16464__$1;
(statearr_16475_16499[(2)] = null);

(statearr_16475_16499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16465 === (9))){
var inst_16444 = (state_16464[(8)]);
var state_16464__$1 = state_16464;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16464__$1,(11),out,inst_16444);
} else {
if((state_val_16465 === (5))){
var inst_16441 = (state_16464[(7)]);
var inst_16444 = (state_16464[(8)]);
var inst_16448 = cljs.core._EQ_.call(null,inst_16444,inst_16441);
var state_16464__$1 = state_16464;
if(inst_16448){
var statearr_16477_16500 = state_16464__$1;
(statearr_16477_16500[(1)] = (8));

} else {
var statearr_16478_16501 = state_16464__$1;
(statearr_16478_16501[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16465 === (10))){
var inst_16456 = (state_16464[(2)]);
var state_16464__$1 = state_16464;
var statearr_16479_16502 = state_16464__$1;
(statearr_16479_16502[(2)] = inst_16456);

(statearr_16479_16502[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16465 === (8))){
var inst_16441 = (state_16464[(7)]);
var tmp16476 = inst_16441;
var inst_16441__$1 = tmp16476;
var state_16464__$1 = (function (){var statearr_16480 = state_16464;
(statearr_16480[(7)] = inst_16441__$1);

return statearr_16480;
})();
var statearr_16481_16503 = state_16464__$1;
(statearr_16481_16503[(2)] = null);

(statearr_16481_16503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto___16493,out))
;
return ((function (switch__8266__auto__,c__8287__auto___16493,out){
return (function() {
var cljs$core$async$state_machine__8267__auto__ = null;
var cljs$core$async$state_machine__8267__auto____0 = (function (){
var statearr_16485 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16485[(0)] = cljs$core$async$state_machine__8267__auto__);

(statearr_16485[(1)] = (1));

return statearr_16485;
});
var cljs$core$async$state_machine__8267__auto____1 = (function (state_16464){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_16464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e16486){if((e16486 instanceof Object)){
var ex__8270__auto__ = e16486;
var statearr_16487_16504 = state_16464;
(statearr_16487_16504[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16464);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16486;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16505 = state_16464;
state_16464 = G__16505;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$state_machine__8267__auto__ = function(state_16464){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8267__auto____1.call(this,state_16464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8267__auto____0;
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8267__auto____1;
return cljs$core$async$state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___16493,out))
})();
var state__8289__auto__ = (function (){var statearr_16488 = f__8288__auto__.call(null);
(statearr_16488[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___16493);

return statearr_16488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___16493,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args16506 = [];
var len__5638__auto___16576 = arguments.length;
var i__5639__auto___16577 = (0);
while(true){
if((i__5639__auto___16577 < len__5638__auto___16576)){
args16506.push((arguments[i__5639__auto___16577]));

var G__16578 = (i__5639__auto___16577 + (1));
i__5639__auto___16577 = G__16578;
continue;
} else {
}
break;
}

var G__16508 = args16506.length;
switch (G__16508) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16506.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8287__auto___16580 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___16580,out){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___16580,out){
return (function (state_16546){
var state_val_16547 = (state_16546[(1)]);
if((state_val_16547 === (7))){
var inst_16542 = (state_16546[(2)]);
var state_16546__$1 = state_16546;
var statearr_16548_16581 = state_16546__$1;
(statearr_16548_16581[(2)] = inst_16542);

(statearr_16548_16581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (1))){
var inst_16509 = (new Array(n));
var inst_16510 = inst_16509;
var inst_16511 = (0);
var state_16546__$1 = (function (){var statearr_16549 = state_16546;
(statearr_16549[(7)] = inst_16510);

(statearr_16549[(8)] = inst_16511);

return statearr_16549;
})();
var statearr_16550_16582 = state_16546__$1;
(statearr_16550_16582[(2)] = null);

(statearr_16550_16582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (4))){
var inst_16514 = (state_16546[(9)]);
var inst_16514__$1 = (state_16546[(2)]);
var inst_16515 = (inst_16514__$1 == null);
var inst_16516 = cljs.core.not.call(null,inst_16515);
var state_16546__$1 = (function (){var statearr_16551 = state_16546;
(statearr_16551[(9)] = inst_16514__$1);

return statearr_16551;
})();
if(inst_16516){
var statearr_16552_16583 = state_16546__$1;
(statearr_16552_16583[(1)] = (5));

} else {
var statearr_16553_16584 = state_16546__$1;
(statearr_16553_16584[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (15))){
var inst_16536 = (state_16546[(2)]);
var state_16546__$1 = state_16546;
var statearr_16554_16585 = state_16546__$1;
(statearr_16554_16585[(2)] = inst_16536);

(statearr_16554_16585[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (13))){
var state_16546__$1 = state_16546;
var statearr_16555_16586 = state_16546__$1;
(statearr_16555_16586[(2)] = null);

(statearr_16555_16586[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (6))){
var inst_16511 = (state_16546[(8)]);
var inst_16532 = (inst_16511 > (0));
var state_16546__$1 = state_16546;
if(cljs.core.truth_(inst_16532)){
var statearr_16556_16587 = state_16546__$1;
(statearr_16556_16587[(1)] = (12));

} else {
var statearr_16557_16588 = state_16546__$1;
(statearr_16557_16588[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (3))){
var inst_16544 = (state_16546[(2)]);
var state_16546__$1 = state_16546;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16546__$1,inst_16544);
} else {
if((state_val_16547 === (12))){
var inst_16510 = (state_16546[(7)]);
var inst_16534 = cljs.core.vec.call(null,inst_16510);
var state_16546__$1 = state_16546;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16546__$1,(15),out,inst_16534);
} else {
if((state_val_16547 === (2))){
var state_16546__$1 = state_16546;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16546__$1,(4),ch);
} else {
if((state_val_16547 === (11))){
var inst_16526 = (state_16546[(2)]);
var inst_16527 = (new Array(n));
var inst_16510 = inst_16527;
var inst_16511 = (0);
var state_16546__$1 = (function (){var statearr_16558 = state_16546;
(statearr_16558[(7)] = inst_16510);

(statearr_16558[(10)] = inst_16526);

(statearr_16558[(8)] = inst_16511);

return statearr_16558;
})();
var statearr_16559_16589 = state_16546__$1;
(statearr_16559_16589[(2)] = null);

(statearr_16559_16589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (9))){
var inst_16510 = (state_16546[(7)]);
var inst_16524 = cljs.core.vec.call(null,inst_16510);
var state_16546__$1 = state_16546;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16546__$1,(11),out,inst_16524);
} else {
if((state_val_16547 === (5))){
var inst_16519 = (state_16546[(11)]);
var inst_16514 = (state_16546[(9)]);
var inst_16510 = (state_16546[(7)]);
var inst_16511 = (state_16546[(8)]);
var inst_16518 = (inst_16510[inst_16511] = inst_16514);
var inst_16519__$1 = (inst_16511 + (1));
var inst_16520 = (inst_16519__$1 < n);
var state_16546__$1 = (function (){var statearr_16560 = state_16546;
(statearr_16560[(11)] = inst_16519__$1);

(statearr_16560[(12)] = inst_16518);

return statearr_16560;
})();
if(cljs.core.truth_(inst_16520)){
var statearr_16561_16590 = state_16546__$1;
(statearr_16561_16590[(1)] = (8));

} else {
var statearr_16562_16591 = state_16546__$1;
(statearr_16562_16591[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (14))){
var inst_16539 = (state_16546[(2)]);
var inst_16540 = cljs.core.async.close_BANG_.call(null,out);
var state_16546__$1 = (function (){var statearr_16564 = state_16546;
(statearr_16564[(13)] = inst_16539);

return statearr_16564;
})();
var statearr_16565_16592 = state_16546__$1;
(statearr_16565_16592[(2)] = inst_16540);

(statearr_16565_16592[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (10))){
var inst_16530 = (state_16546[(2)]);
var state_16546__$1 = state_16546;
var statearr_16566_16593 = state_16546__$1;
(statearr_16566_16593[(2)] = inst_16530);

(statearr_16566_16593[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16547 === (8))){
var inst_16519 = (state_16546[(11)]);
var inst_16510 = (state_16546[(7)]);
var tmp16563 = inst_16510;
var inst_16510__$1 = tmp16563;
var inst_16511 = inst_16519;
var state_16546__$1 = (function (){var statearr_16567 = state_16546;
(statearr_16567[(7)] = inst_16510__$1);

(statearr_16567[(8)] = inst_16511);

return statearr_16567;
})();
var statearr_16568_16594 = state_16546__$1;
(statearr_16568_16594[(2)] = null);

(statearr_16568_16594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto___16580,out))
;
return ((function (switch__8266__auto__,c__8287__auto___16580,out){
return (function() {
var cljs$core$async$state_machine__8267__auto__ = null;
var cljs$core$async$state_machine__8267__auto____0 = (function (){
var statearr_16572 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16572[(0)] = cljs$core$async$state_machine__8267__auto__);

(statearr_16572[(1)] = (1));

return statearr_16572;
});
var cljs$core$async$state_machine__8267__auto____1 = (function (state_16546){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_16546);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e16573){if((e16573 instanceof Object)){
var ex__8270__auto__ = e16573;
var statearr_16574_16595 = state_16546;
(statearr_16574_16595[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16546);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16573;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16596 = state_16546;
state_16546 = G__16596;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$state_machine__8267__auto__ = function(state_16546){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8267__auto____1.call(this,state_16546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8267__auto____0;
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8267__auto____1;
return cljs$core$async$state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___16580,out))
})();
var state__8289__auto__ = (function (){var statearr_16575 = f__8288__auto__.call(null);
(statearr_16575[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___16580);

return statearr_16575;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___16580,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args16597 = [];
var len__5638__auto___16671 = arguments.length;
var i__5639__auto___16672 = (0);
while(true){
if((i__5639__auto___16672 < len__5638__auto___16671)){
args16597.push((arguments[i__5639__auto___16672]));

var G__16673 = (i__5639__auto___16672 + (1));
i__5639__auto___16672 = G__16673;
continue;
} else {
}
break;
}

var G__16599 = args16597.length;
switch (G__16599) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16597.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8287__auto___16675 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto___16675,out){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto___16675,out){
return (function (state_16641){
var state_val_16642 = (state_16641[(1)]);
if((state_val_16642 === (7))){
var inst_16637 = (state_16641[(2)]);
var state_16641__$1 = state_16641;
var statearr_16643_16676 = state_16641__$1;
(statearr_16643_16676[(2)] = inst_16637);

(statearr_16643_16676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16642 === (1))){
var inst_16600 = [];
var inst_16601 = inst_16600;
var inst_16602 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_16641__$1 = (function (){var statearr_16644 = state_16641;
(statearr_16644[(7)] = inst_16601);

(statearr_16644[(8)] = inst_16602);

return statearr_16644;
})();
var statearr_16645_16677 = state_16641__$1;
(statearr_16645_16677[(2)] = null);

(statearr_16645_16677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16642 === (4))){
var inst_16605 = (state_16641[(9)]);
var inst_16605__$1 = (state_16641[(2)]);
var inst_16606 = (inst_16605__$1 == null);
var inst_16607 = cljs.core.not.call(null,inst_16606);
var state_16641__$1 = (function (){var statearr_16646 = state_16641;
(statearr_16646[(9)] = inst_16605__$1);

return statearr_16646;
})();
if(inst_16607){
var statearr_16647_16678 = state_16641__$1;
(statearr_16647_16678[(1)] = (5));

} else {
var statearr_16648_16679 = state_16641__$1;
(statearr_16648_16679[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16642 === (15))){
var inst_16631 = (state_16641[(2)]);
var state_16641__$1 = state_16641;
var statearr_16649_16680 = state_16641__$1;
(statearr_16649_16680[(2)] = inst_16631);

(statearr_16649_16680[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16642 === (13))){
var state_16641__$1 = state_16641;
var statearr_16650_16681 = state_16641__$1;
(statearr_16650_16681[(2)] = null);

(statearr_16650_16681[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16642 === (6))){
var inst_16601 = (state_16641[(7)]);
var inst_16626 = inst_16601.length;
var inst_16627 = (inst_16626 > (0));
var state_16641__$1 = state_16641;
if(cljs.core.truth_(inst_16627)){
var statearr_16651_16682 = state_16641__$1;
(statearr_16651_16682[(1)] = (12));

} else {
var statearr_16652_16683 = state_16641__$1;
(statearr_16652_16683[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16642 === (3))){
var inst_16639 = (state_16641[(2)]);
var state_16641__$1 = state_16641;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16641__$1,inst_16639);
} else {
if((state_val_16642 === (12))){
var inst_16601 = (state_16641[(7)]);
var inst_16629 = cljs.core.vec.call(null,inst_16601);
var state_16641__$1 = state_16641;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16641__$1,(15),out,inst_16629);
} else {
if((state_val_16642 === (2))){
var state_16641__$1 = state_16641;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16641__$1,(4),ch);
} else {
if((state_val_16642 === (11))){
var inst_16605 = (state_16641[(9)]);
var inst_16609 = (state_16641[(10)]);
var inst_16619 = (state_16641[(2)]);
var inst_16620 = [];
var inst_16621 = inst_16620.push(inst_16605);
var inst_16601 = inst_16620;
var inst_16602 = inst_16609;
var state_16641__$1 = (function (){var statearr_16653 = state_16641;
(statearr_16653[(11)] = inst_16619);

(statearr_16653[(12)] = inst_16621);

(statearr_16653[(7)] = inst_16601);

(statearr_16653[(8)] = inst_16602);

return statearr_16653;
})();
var statearr_16654_16684 = state_16641__$1;
(statearr_16654_16684[(2)] = null);

(statearr_16654_16684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16642 === (9))){
var inst_16601 = (state_16641[(7)]);
var inst_16617 = cljs.core.vec.call(null,inst_16601);
var state_16641__$1 = state_16641;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16641__$1,(11),out,inst_16617);
} else {
if((state_val_16642 === (5))){
var inst_16605 = (state_16641[(9)]);
var inst_16609 = (state_16641[(10)]);
var inst_16602 = (state_16641[(8)]);
var inst_16609__$1 = f.call(null,inst_16605);
var inst_16610 = cljs.core._EQ_.call(null,inst_16609__$1,inst_16602);
var inst_16611 = cljs.core.keyword_identical_QMARK_.call(null,inst_16602,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_16612 = (inst_16610) || (inst_16611);
var state_16641__$1 = (function (){var statearr_16655 = state_16641;
(statearr_16655[(10)] = inst_16609__$1);

return statearr_16655;
})();
if(cljs.core.truth_(inst_16612)){
var statearr_16656_16685 = state_16641__$1;
(statearr_16656_16685[(1)] = (8));

} else {
var statearr_16657_16686 = state_16641__$1;
(statearr_16657_16686[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16642 === (14))){
var inst_16634 = (state_16641[(2)]);
var inst_16635 = cljs.core.async.close_BANG_.call(null,out);
var state_16641__$1 = (function (){var statearr_16659 = state_16641;
(statearr_16659[(13)] = inst_16634);

return statearr_16659;
})();
var statearr_16660_16687 = state_16641__$1;
(statearr_16660_16687[(2)] = inst_16635);

(statearr_16660_16687[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16642 === (10))){
var inst_16624 = (state_16641[(2)]);
var state_16641__$1 = state_16641;
var statearr_16661_16688 = state_16641__$1;
(statearr_16661_16688[(2)] = inst_16624);

(statearr_16661_16688[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16642 === (8))){
var inst_16605 = (state_16641[(9)]);
var inst_16609 = (state_16641[(10)]);
var inst_16601 = (state_16641[(7)]);
var inst_16614 = inst_16601.push(inst_16605);
var tmp16658 = inst_16601;
var inst_16601__$1 = tmp16658;
var inst_16602 = inst_16609;
var state_16641__$1 = (function (){var statearr_16662 = state_16641;
(statearr_16662[(14)] = inst_16614);

(statearr_16662[(7)] = inst_16601__$1);

(statearr_16662[(8)] = inst_16602);

return statearr_16662;
})();
var statearr_16663_16689 = state_16641__$1;
(statearr_16663_16689[(2)] = null);

(statearr_16663_16689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto___16675,out))
;
return ((function (switch__8266__auto__,c__8287__auto___16675,out){
return (function() {
var cljs$core$async$state_machine__8267__auto__ = null;
var cljs$core$async$state_machine__8267__auto____0 = (function (){
var statearr_16667 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16667[(0)] = cljs$core$async$state_machine__8267__auto__);

(statearr_16667[(1)] = (1));

return statearr_16667;
});
var cljs$core$async$state_machine__8267__auto____1 = (function (state_16641){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_16641);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e16668){if((e16668 instanceof Object)){
var ex__8270__auto__ = e16668;
var statearr_16669_16690 = state_16641;
(statearr_16669_16690[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16641);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16668;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16691 = state_16641;
state_16641 = G__16691;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
cljs$core$async$state_machine__8267__auto__ = function(state_16641){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8267__auto____1.call(this,state_16641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8267__auto____0;
cljs$core$async$state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8267__auto____1;
return cljs$core$async$state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto___16675,out))
})();
var state__8289__auto__ = (function (){var statearr_16670 = f__8288__auto__.call(null);
(statearr_16670[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto___16675);

return statearr_16670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto___16675,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
