// Compiled by ClojureScript 1.7.145 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__19750__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__19749 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__19749,(0),null);
var body = cljs.core.nthnext.call(null,vec__19749,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__19750 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__19751__i = 0, G__19751__a = new Array(arguments.length -  0);
while (G__19751__i < G__19751__a.length) {G__19751__a[G__19751__i] = arguments[G__19751__i + 0]; ++G__19751__i;}
  args = new cljs.core.IndexedSeq(G__19751__a,0);
} 
return G__19750__delegate.call(this,args);};
G__19750.cljs$lang$maxFixedArity = 0;
G__19750.cljs$lang$applyTo = (function (arglist__19752){
var args = cljs.core.seq(arglist__19752);
return G__19750__delegate(args);
});
G__19750.cljs$core$IFn$_invoke$arity$variadic = G__19750__delegate;
return G__19750;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5352__auto__ = (function sablono$core$update_arglists_$_iter__19757(s__19758){
return (new cljs.core.LazySeq(null,(function (){
var s__19758__$1 = s__19758;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19758__$1);
if(temp__4657__auto__){
var s__19758__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19758__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__19758__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__19760 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__19759 = (0);
while(true){
if((i__19759 < size__5351__auto__)){
var args = cljs.core._nth.call(null,c__5350__auto__,i__19759);
cljs.core.chunk_append.call(null,b__19760,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__19761 = (i__19759 + (1));
i__19759 = G__19761;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19760),sablono$core$update_arglists_$_iter__19757.call(null,cljs.core.chunk_rest.call(null,s__19758__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19760),null);
}
} else {
var args = cljs.core.first.call(null,s__19758__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__19757.call(null,cljs.core.rest.call(null,s__19758__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5352__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5645__auto__ = [];
var len__5638__auto___19767 = arguments.length;
var i__5639__auto___19768 = (0);
while(true){
if((i__5639__auto___19768 < len__5638__auto___19767)){
args__5645__auto__.push((arguments[i__5639__auto___19768]));

var G__19769 = (i__5639__auto___19768 + (1));
i__5639__auto___19768 = G__19769;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((0) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5646__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5352__auto__ = (function sablono$core$iter__19763(s__19764){
return (new cljs.core.LazySeq(null,(function (){
var s__19764__$1 = s__19764;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19764__$1);
if(temp__4657__auto__){
var s__19764__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19764__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__19764__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__19766 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__19765 = (0);
while(true){
if((i__19765 < size__5351__auto__)){
var style = cljs.core._nth.call(null,c__5350__auto__,i__19765);
cljs.core.chunk_append.call(null,b__19766,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__19770 = (i__19765 + (1));
i__19765 = G__19770;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19766),sablono$core$iter__19763.call(null,cljs.core.chunk_rest.call(null,s__19764__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19766),null);
}
} else {
var style = cljs.core.first.call(null,s__19764__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__19763.call(null,cljs.core.rest.call(null,s__19764__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5352__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq19762){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19762));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to19771 = (function sablono$core$link_to19771(var_args){
var args__5645__auto__ = [];
var len__5638__auto___19774 = arguments.length;
var i__5639__auto___19775 = (0);
while(true){
if((i__5639__auto___19775 < len__5638__auto___19774)){
args__5645__auto__.push((arguments[i__5639__auto___19775]));

var G__19776 = (i__5639__auto___19775 + (1));
i__5639__auto___19775 = G__19776;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((1) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((1)),(0))):null);
return sablono.core.link_to19771.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5646__auto__);
});

sablono.core.link_to19771.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to19771.cljs$lang$maxFixedArity = (1);

sablono.core.link_to19771.cljs$lang$applyTo = (function (seq19772){
var G__19773 = cljs.core.first.call(null,seq19772);
var seq19772__$1 = cljs.core.next.call(null,seq19772);
return sablono.core.link_to19771.cljs$core$IFn$_invoke$arity$variadic(G__19773,seq19772__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to19771);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to19777 = (function sablono$core$mail_to19777(var_args){
var args__5645__auto__ = [];
var len__5638__auto___19782 = arguments.length;
var i__5639__auto___19783 = (0);
while(true){
if((i__5639__auto___19783 < len__5638__auto___19782)){
args__5645__auto__.push((arguments[i__5639__auto___19783]));

var G__19784 = (i__5639__auto___19783 + (1));
i__5639__auto___19783 = G__19784;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((1) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((1)),(0))):null);
return sablono.core.mail_to19777.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5646__auto__);
});

sablono.core.mail_to19777.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__19780){
var vec__19781 = p__19780;
var content = cljs.core.nth.call(null,vec__19781,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4580__auto__ = content;
if(cljs.core.truth_(or__4580__auto__)){
return or__4580__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to19777.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to19777.cljs$lang$applyTo = (function (seq19778){
var G__19779 = cljs.core.first.call(null,seq19778);
var seq19778__$1 = cljs.core.next.call(null,seq19778);
return sablono.core.mail_to19777.cljs$core$IFn$_invoke$arity$variadic(G__19779,seq19778__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to19777);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list19785 = (function sablono$core$unordered_list19785(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5352__auto__ = (function sablono$core$unordered_list19785_$_iter__19790(s__19791){
return (new cljs.core.LazySeq(null,(function (){
var s__19791__$1 = s__19791;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19791__$1);
if(temp__4657__auto__){
var s__19791__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19791__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__19791__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__19793 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__19792 = (0);
while(true){
if((i__19792 < size__5351__auto__)){
var x = cljs.core._nth.call(null,c__5350__auto__,i__19792);
cljs.core.chunk_append.call(null,b__19793,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19794 = (i__19792 + (1));
i__19792 = G__19794;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19793),sablono$core$unordered_list19785_$_iter__19790.call(null,cljs.core.chunk_rest.call(null,s__19791__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19793),null);
}
} else {
var x = cljs.core.first.call(null,s__19791__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list19785_$_iter__19790.call(null,cljs.core.rest.call(null,s__19791__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5352__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list19785);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list19795 = (function sablono$core$ordered_list19795(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5352__auto__ = (function sablono$core$ordered_list19795_$_iter__19800(s__19801){
return (new cljs.core.LazySeq(null,(function (){
var s__19801__$1 = s__19801;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19801__$1);
if(temp__4657__auto__){
var s__19801__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19801__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__19801__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__19803 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__19802 = (0);
while(true){
if((i__19802 < size__5351__auto__)){
var x = cljs.core._nth.call(null,c__5350__auto__,i__19802);
cljs.core.chunk_append.call(null,b__19803,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19804 = (i__19802 + (1));
i__19802 = G__19804;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19803),sablono$core$ordered_list19795_$_iter__19800.call(null,cljs.core.chunk_rest.call(null,s__19801__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19803),null);
}
} else {
var x = cljs.core.first.call(null,s__19801__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list19795_$_iter__19800.call(null,cljs.core.rest.call(null,s__19801__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5352__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list19795);
/**
 * Create an image element.
 */
sablono.core.image19805 = (function sablono$core$image19805(var_args){
var args19806 = [];
var len__5638__auto___19809 = arguments.length;
var i__5639__auto___19810 = (0);
while(true){
if((i__5639__auto___19810 < len__5638__auto___19809)){
args19806.push((arguments[i__5639__auto___19810]));

var G__19811 = (i__5639__auto___19810 + (1));
i__5639__auto___19810 = G__19811;
continue;
} else {
}
break;
}

var G__19808 = args19806.length;
switch (G__19808) {
case 1:
return sablono.core.image19805.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image19805.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19806.length)].join('')));

}
});

sablono.core.image19805.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image19805.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image19805.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image19805);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__19813_SHARP_,p2__19814_SHARP_){
return [cljs.core.str(p1__19813_SHARP_),cljs.core.str("["),cljs.core.str(p2__19814_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__19815_SHARP_,p2__19816_SHARP_){
return [cljs.core.str(p1__19815_SHARP_),cljs.core.str("-"),cljs.core.str(p2__19816_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field19817 = (function sablono$core$color_field19817(var_args){
var args19818 = [];
var len__5638__auto___19885 = arguments.length;
var i__5639__auto___19886 = (0);
while(true){
if((i__5639__auto___19886 < len__5638__auto___19885)){
args19818.push((arguments[i__5639__auto___19886]));

var G__19887 = (i__5639__auto___19886 + (1));
i__5639__auto___19886 = G__19887;
continue;
} else {
}
break;
}

var G__19820 = args19818.length;
switch (G__19820) {
case 1:
return sablono.core.color_field19817.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field19817.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19818.length)].join('')));

}
});

sablono.core.color_field19817.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.color_field19817.call(null,name__6947__auto__,null);
});

sablono.core.color_field19817.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.color_field19817.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field19817);

/**
 * Creates a date input field.
 */
sablono.core.date_field19821 = (function sablono$core$date_field19821(var_args){
var args19822 = [];
var len__5638__auto___19889 = arguments.length;
var i__5639__auto___19890 = (0);
while(true){
if((i__5639__auto___19890 < len__5638__auto___19889)){
args19822.push((arguments[i__5639__auto___19890]));

var G__19891 = (i__5639__auto___19890 + (1));
i__5639__auto___19890 = G__19891;
continue;
} else {
}
break;
}

var G__19824 = args19822.length;
switch (G__19824) {
case 1:
return sablono.core.date_field19821.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field19821.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19822.length)].join('')));

}
});

sablono.core.date_field19821.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.date_field19821.call(null,name__6947__auto__,null);
});

sablono.core.date_field19821.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.date_field19821.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field19821);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field19825 = (function sablono$core$datetime_field19825(var_args){
var args19826 = [];
var len__5638__auto___19893 = arguments.length;
var i__5639__auto___19894 = (0);
while(true){
if((i__5639__auto___19894 < len__5638__auto___19893)){
args19826.push((arguments[i__5639__auto___19894]));

var G__19895 = (i__5639__auto___19894 + (1));
i__5639__auto___19894 = G__19895;
continue;
} else {
}
break;
}

var G__19828 = args19826.length;
switch (G__19828) {
case 1:
return sablono.core.datetime_field19825.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field19825.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19826.length)].join('')));

}
});

sablono.core.datetime_field19825.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.datetime_field19825.call(null,name__6947__auto__,null);
});

sablono.core.datetime_field19825.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.datetime_field19825.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field19825);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field19829 = (function sablono$core$datetime_local_field19829(var_args){
var args19830 = [];
var len__5638__auto___19897 = arguments.length;
var i__5639__auto___19898 = (0);
while(true){
if((i__5639__auto___19898 < len__5638__auto___19897)){
args19830.push((arguments[i__5639__auto___19898]));

var G__19899 = (i__5639__auto___19898 + (1));
i__5639__auto___19898 = G__19899;
continue;
} else {
}
break;
}

var G__19832 = args19830.length;
switch (G__19832) {
case 1:
return sablono.core.datetime_local_field19829.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field19829.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19830.length)].join('')));

}
});

sablono.core.datetime_local_field19829.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.datetime_local_field19829.call(null,name__6947__auto__,null);
});

sablono.core.datetime_local_field19829.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.datetime_local_field19829.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field19829);

/**
 * Creates a email input field.
 */
sablono.core.email_field19833 = (function sablono$core$email_field19833(var_args){
var args19834 = [];
var len__5638__auto___19901 = arguments.length;
var i__5639__auto___19902 = (0);
while(true){
if((i__5639__auto___19902 < len__5638__auto___19901)){
args19834.push((arguments[i__5639__auto___19902]));

var G__19903 = (i__5639__auto___19902 + (1));
i__5639__auto___19902 = G__19903;
continue;
} else {
}
break;
}

var G__19836 = args19834.length;
switch (G__19836) {
case 1:
return sablono.core.email_field19833.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field19833.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19834.length)].join('')));

}
});

sablono.core.email_field19833.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.email_field19833.call(null,name__6947__auto__,null);
});

sablono.core.email_field19833.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.email_field19833.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field19833);

/**
 * Creates a file input field.
 */
sablono.core.file_field19837 = (function sablono$core$file_field19837(var_args){
var args19838 = [];
var len__5638__auto___19905 = arguments.length;
var i__5639__auto___19906 = (0);
while(true){
if((i__5639__auto___19906 < len__5638__auto___19905)){
args19838.push((arguments[i__5639__auto___19906]));

var G__19907 = (i__5639__auto___19906 + (1));
i__5639__auto___19906 = G__19907;
continue;
} else {
}
break;
}

var G__19840 = args19838.length;
switch (G__19840) {
case 1:
return sablono.core.file_field19837.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field19837.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19838.length)].join('')));

}
});

sablono.core.file_field19837.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.file_field19837.call(null,name__6947__auto__,null);
});

sablono.core.file_field19837.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.file_field19837.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field19837);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field19841 = (function sablono$core$hidden_field19841(var_args){
var args19842 = [];
var len__5638__auto___19909 = arguments.length;
var i__5639__auto___19910 = (0);
while(true){
if((i__5639__auto___19910 < len__5638__auto___19909)){
args19842.push((arguments[i__5639__auto___19910]));

var G__19911 = (i__5639__auto___19910 + (1));
i__5639__auto___19910 = G__19911;
continue;
} else {
}
break;
}

var G__19844 = args19842.length;
switch (G__19844) {
case 1:
return sablono.core.hidden_field19841.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field19841.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19842.length)].join('')));

}
});

sablono.core.hidden_field19841.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.hidden_field19841.call(null,name__6947__auto__,null);
});

sablono.core.hidden_field19841.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.hidden_field19841.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field19841);

/**
 * Creates a month input field.
 */
sablono.core.month_field19845 = (function sablono$core$month_field19845(var_args){
var args19846 = [];
var len__5638__auto___19913 = arguments.length;
var i__5639__auto___19914 = (0);
while(true){
if((i__5639__auto___19914 < len__5638__auto___19913)){
args19846.push((arguments[i__5639__auto___19914]));

var G__19915 = (i__5639__auto___19914 + (1));
i__5639__auto___19914 = G__19915;
continue;
} else {
}
break;
}

var G__19848 = args19846.length;
switch (G__19848) {
case 1:
return sablono.core.month_field19845.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field19845.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19846.length)].join('')));

}
});

sablono.core.month_field19845.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.month_field19845.call(null,name__6947__auto__,null);
});

sablono.core.month_field19845.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.month_field19845.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field19845);

/**
 * Creates a number input field.
 */
sablono.core.number_field19849 = (function sablono$core$number_field19849(var_args){
var args19850 = [];
var len__5638__auto___19917 = arguments.length;
var i__5639__auto___19918 = (0);
while(true){
if((i__5639__auto___19918 < len__5638__auto___19917)){
args19850.push((arguments[i__5639__auto___19918]));

var G__19919 = (i__5639__auto___19918 + (1));
i__5639__auto___19918 = G__19919;
continue;
} else {
}
break;
}

var G__19852 = args19850.length;
switch (G__19852) {
case 1:
return sablono.core.number_field19849.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field19849.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19850.length)].join('')));

}
});

sablono.core.number_field19849.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.number_field19849.call(null,name__6947__auto__,null);
});

sablono.core.number_field19849.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.number_field19849.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field19849);

/**
 * Creates a password input field.
 */
sablono.core.password_field19853 = (function sablono$core$password_field19853(var_args){
var args19854 = [];
var len__5638__auto___19921 = arguments.length;
var i__5639__auto___19922 = (0);
while(true){
if((i__5639__auto___19922 < len__5638__auto___19921)){
args19854.push((arguments[i__5639__auto___19922]));

var G__19923 = (i__5639__auto___19922 + (1));
i__5639__auto___19922 = G__19923;
continue;
} else {
}
break;
}

var G__19856 = args19854.length;
switch (G__19856) {
case 1:
return sablono.core.password_field19853.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field19853.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19854.length)].join('')));

}
});

sablono.core.password_field19853.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.password_field19853.call(null,name__6947__auto__,null);
});

sablono.core.password_field19853.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.password_field19853.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field19853);

/**
 * Creates a range input field.
 */
sablono.core.range_field19857 = (function sablono$core$range_field19857(var_args){
var args19858 = [];
var len__5638__auto___19925 = arguments.length;
var i__5639__auto___19926 = (0);
while(true){
if((i__5639__auto___19926 < len__5638__auto___19925)){
args19858.push((arguments[i__5639__auto___19926]));

var G__19927 = (i__5639__auto___19926 + (1));
i__5639__auto___19926 = G__19927;
continue;
} else {
}
break;
}

var G__19860 = args19858.length;
switch (G__19860) {
case 1:
return sablono.core.range_field19857.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field19857.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19858.length)].join('')));

}
});

sablono.core.range_field19857.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.range_field19857.call(null,name__6947__auto__,null);
});

sablono.core.range_field19857.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.range_field19857.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field19857);

/**
 * Creates a search input field.
 */
sablono.core.search_field19861 = (function sablono$core$search_field19861(var_args){
var args19862 = [];
var len__5638__auto___19929 = arguments.length;
var i__5639__auto___19930 = (0);
while(true){
if((i__5639__auto___19930 < len__5638__auto___19929)){
args19862.push((arguments[i__5639__auto___19930]));

var G__19931 = (i__5639__auto___19930 + (1));
i__5639__auto___19930 = G__19931;
continue;
} else {
}
break;
}

var G__19864 = args19862.length;
switch (G__19864) {
case 1:
return sablono.core.search_field19861.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field19861.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19862.length)].join('')));

}
});

sablono.core.search_field19861.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.search_field19861.call(null,name__6947__auto__,null);
});

sablono.core.search_field19861.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.search_field19861.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field19861);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field19865 = (function sablono$core$tel_field19865(var_args){
var args19866 = [];
var len__5638__auto___19933 = arguments.length;
var i__5639__auto___19934 = (0);
while(true){
if((i__5639__auto___19934 < len__5638__auto___19933)){
args19866.push((arguments[i__5639__auto___19934]));

var G__19935 = (i__5639__auto___19934 + (1));
i__5639__auto___19934 = G__19935;
continue;
} else {
}
break;
}

var G__19868 = args19866.length;
switch (G__19868) {
case 1:
return sablono.core.tel_field19865.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field19865.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19866.length)].join('')));

}
});

sablono.core.tel_field19865.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.tel_field19865.call(null,name__6947__auto__,null);
});

sablono.core.tel_field19865.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.tel_field19865.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field19865);

/**
 * Creates a text input field.
 */
sablono.core.text_field19869 = (function sablono$core$text_field19869(var_args){
var args19870 = [];
var len__5638__auto___19937 = arguments.length;
var i__5639__auto___19938 = (0);
while(true){
if((i__5639__auto___19938 < len__5638__auto___19937)){
args19870.push((arguments[i__5639__auto___19938]));

var G__19939 = (i__5639__auto___19938 + (1));
i__5639__auto___19938 = G__19939;
continue;
} else {
}
break;
}

var G__19872 = args19870.length;
switch (G__19872) {
case 1:
return sablono.core.text_field19869.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field19869.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19870.length)].join('')));

}
});

sablono.core.text_field19869.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.text_field19869.call(null,name__6947__auto__,null);
});

sablono.core.text_field19869.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.text_field19869.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field19869);

/**
 * Creates a time input field.
 */
sablono.core.time_field19873 = (function sablono$core$time_field19873(var_args){
var args19874 = [];
var len__5638__auto___19941 = arguments.length;
var i__5639__auto___19942 = (0);
while(true){
if((i__5639__auto___19942 < len__5638__auto___19941)){
args19874.push((arguments[i__5639__auto___19942]));

var G__19943 = (i__5639__auto___19942 + (1));
i__5639__auto___19942 = G__19943;
continue;
} else {
}
break;
}

var G__19876 = args19874.length;
switch (G__19876) {
case 1:
return sablono.core.time_field19873.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field19873.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19874.length)].join('')));

}
});

sablono.core.time_field19873.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.time_field19873.call(null,name__6947__auto__,null);
});

sablono.core.time_field19873.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.time_field19873.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field19873);

/**
 * Creates a url input field.
 */
sablono.core.url_field19877 = (function sablono$core$url_field19877(var_args){
var args19878 = [];
var len__5638__auto___19945 = arguments.length;
var i__5639__auto___19946 = (0);
while(true){
if((i__5639__auto___19946 < len__5638__auto___19945)){
args19878.push((arguments[i__5639__auto___19946]));

var G__19947 = (i__5639__auto___19946 + (1));
i__5639__auto___19946 = G__19947;
continue;
} else {
}
break;
}

var G__19880 = args19878.length;
switch (G__19880) {
case 1:
return sablono.core.url_field19877.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field19877.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19878.length)].join('')));

}
});

sablono.core.url_field19877.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.url_field19877.call(null,name__6947__auto__,null);
});

sablono.core.url_field19877.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.url_field19877.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field19877);

/**
 * Creates a week input field.
 */
sablono.core.week_field19881 = (function sablono$core$week_field19881(var_args){
var args19882 = [];
var len__5638__auto___19949 = arguments.length;
var i__5639__auto___19950 = (0);
while(true){
if((i__5639__auto___19950 < len__5638__auto___19949)){
args19882.push((arguments[i__5639__auto___19950]));

var G__19951 = (i__5639__auto___19950 + (1));
i__5639__auto___19950 = G__19951;
continue;
} else {
}
break;
}

var G__19884 = args19882.length;
switch (G__19884) {
case 1:
return sablono.core.week_field19881.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field19881.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19882.length)].join('')));

}
});

sablono.core.week_field19881.cljs$core$IFn$_invoke$arity$1 = (function (name__6947__auto__){
return sablono.core.week_field19881.call(null,name__6947__auto__,null);
});

sablono.core.week_field19881.cljs$core$IFn$_invoke$arity$2 = (function (name__6947__auto__,value__6948__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__6947__auto__,value__6948__auto__);
});

sablono.core.week_field19881.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field19881);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box19953 = (function sablono$core$check_box19953(var_args){
var args19954 = [];
var len__5638__auto___19957 = arguments.length;
var i__5639__auto___19958 = (0);
while(true){
if((i__5639__auto___19958 < len__5638__auto___19957)){
args19954.push((arguments[i__5639__auto___19958]));

var G__19959 = (i__5639__auto___19958 + (1));
i__5639__auto___19958 = G__19959;
continue;
} else {
}
break;
}

var G__19956 = args19954.length;
switch (G__19956) {
case 1:
return sablono.core.check_box19953.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box19953.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box19953.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19954.length)].join('')));

}
});

sablono.core.check_box19953.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box19953.call(null,name,null);
});

sablono.core.check_box19953.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box19953.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box19953.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box19953.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box19953);
/**
 * Creates a radio button.
 */
sablono.core.radio_button19961 = (function sablono$core$radio_button19961(var_args){
var args19962 = [];
var len__5638__auto___19965 = arguments.length;
var i__5639__auto___19966 = (0);
while(true){
if((i__5639__auto___19966 < len__5638__auto___19965)){
args19962.push((arguments[i__5639__auto___19966]));

var G__19967 = (i__5639__auto___19966 + (1));
i__5639__auto___19966 = G__19967;
continue;
} else {
}
break;
}

var G__19964 = args19962.length;
switch (G__19964) {
case 1:
return sablono.core.radio_button19961.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button19961.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button19961.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19962.length)].join('')));

}
});

sablono.core.radio_button19961.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button19961.call(null,group,null);
});

sablono.core.radio_button19961.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button19961.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button19961.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button19961.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button19961);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options19969 = (function sablono$core$select_options19969(var_args){
var args19970 = [];
var len__5638__auto___19981 = arguments.length;
var i__5639__auto___19982 = (0);
while(true){
if((i__5639__auto___19982 < len__5638__auto___19981)){
args19970.push((arguments[i__5639__auto___19982]));

var G__19983 = (i__5639__auto___19982 + (1));
i__5639__auto___19982 = G__19983;
continue;
} else {
}
break;
}

var G__19972 = args19970.length;
switch (G__19972) {
case 1:
return sablono.core.select_options19969.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options19969.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19970.length)].join('')));

}
});

sablono.core.select_options19969.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options19969.call(null,coll,null);
});

sablono.core.select_options19969.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__5352__auto__ = (function sablono$core$iter__19973(s__19974){
return (new cljs.core.LazySeq(null,(function (){
var s__19974__$1 = s__19974;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19974__$1);
if(temp__4657__auto__){
var s__19974__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19974__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__19974__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__19976 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__19975 = (0);
while(true){
if((i__19975 < size__5351__auto__)){
var x = cljs.core._nth.call(null,c__5350__auto__,i__19975);
cljs.core.chunk_append.call(null,b__19976,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19979 = x;
var text = cljs.core.nth.call(null,vec__19979,(0),null);
var val = cljs.core.nth.call(null,vec__19979,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19979,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19969.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__19985 = (i__19975 + (1));
i__19975 = G__19985;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19976),sablono$core$iter__19973.call(null,cljs.core.chunk_rest.call(null,s__19974__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19976),null);
}
} else {
var x = cljs.core.first.call(null,s__19974__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19980 = x;
var text = cljs.core.nth.call(null,vec__19980,(0),null);
var val = cljs.core.nth.call(null,vec__19980,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19980,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19969.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__19973.call(null,cljs.core.rest.call(null,s__19974__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5352__auto__.call(null,coll);
});

sablono.core.select_options19969.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options19969);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down19986 = (function sablono$core$drop_down19986(var_args){
var args19987 = [];
var len__5638__auto___19990 = arguments.length;
var i__5639__auto___19991 = (0);
while(true){
if((i__5639__auto___19991 < len__5638__auto___19990)){
args19987.push((arguments[i__5639__auto___19991]));

var G__19992 = (i__5639__auto___19991 + (1));
i__5639__auto___19991 = G__19992;
continue;
} else {
}
break;
}

var G__19989 = args19987.length;
switch (G__19989) {
case 2:
return sablono.core.drop_down19986.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down19986.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19987.length)].join('')));

}
});

sablono.core.drop_down19986.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down19986.call(null,name,options,null);
});

sablono.core.drop_down19986.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down19986.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down19986);
/**
 * Creates a text area element.
 */
sablono.core.text_area19994 = (function sablono$core$text_area19994(var_args){
var args19995 = [];
var len__5638__auto___19998 = arguments.length;
var i__5639__auto___19999 = (0);
while(true){
if((i__5639__auto___19999 < len__5638__auto___19998)){
args19995.push((arguments[i__5639__auto___19999]));

var G__20000 = (i__5639__auto___19999 + (1));
i__5639__auto___19999 = G__20000;
continue;
} else {
}
break;
}

var G__19997 = args19995.length;
switch (G__19997) {
case 1:
return sablono.core.text_area19994.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area19994.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19995.length)].join('')));

}
});

sablono.core.text_area19994.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area19994.call(null,name,null);
});

sablono.core.text_area19994.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area19994.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area19994);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label20002 = (function sablono$core$label20002(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label20002);
/**
 * Creates a submit button.
 */
sablono.core.submit_button20003 = (function sablono$core$submit_button20003(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button20003);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button20004 = (function sablono$core$reset_button20004(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button20004);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to20005 = (function sablono$core$form_to20005(var_args){
var args__5645__auto__ = [];
var len__5638__auto___20010 = arguments.length;
var i__5639__auto___20011 = (0);
while(true){
if((i__5639__auto___20011 < len__5638__auto___20010)){
args__5645__auto__.push((arguments[i__5639__auto___20011]));

var G__20012 = (i__5639__auto___20011 + (1));
i__5639__auto___20011 = G__20012;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((1) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((1)),(0))):null);
return sablono.core.form_to20005.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5646__auto__);
});

sablono.core.form_to20005.cljs$core$IFn$_invoke$arity$variadic = (function (p__20008,body){
var vec__20009 = p__20008;
var method = cljs.core.nth.call(null,vec__20009,(0),null);
var action = cljs.core.nth.call(null,vec__20009,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to20005.cljs$lang$maxFixedArity = (1);

sablono.core.form_to20005.cljs$lang$applyTo = (function (seq20006){
var G__20007 = cljs.core.first.call(null,seq20006);
var seq20006__$1 = cljs.core.next.call(null,seq20006);
return sablono.core.form_to20005.cljs$core$IFn$_invoke$arity$variadic(G__20007,seq20006__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to20005);
