// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('hatti.constants');
goog.require('hatti.ona.forms');
goog.require('hatti.utils');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"radius": (6), "fillColor": "#f30", "reset": {"fillColor": "#f30"}, "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9},cljs.core.cst$kw$hover,{"fillColor": "#631400"},cljs.core.cst$kw$clicked,{"fillColor": "#ad2300"}], null),cljs.core.cst$kw$shape,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8},cljs.core.cst$kw$hover,{"fillColor": "#631400", "color": "#222"},cljs.core.cst$kw$clicked,{"fillColor": "#ad2300", "color": "#222"}], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"color": "#f30", "opacity": (1), "weight": (6), "reset": {"color": "#f30"}},cljs.core.cst$kw$hover,{"color": "#631400"},cljs.core.cst$kw$clicked,{"color": "#ad2300"}], null)], null);
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(marker_or_keyword,style_type){
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype(marker_or_keyword));
var G__25748 = (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.ona_styles) : kw.call(null,hatti.map.utils.ona_styles));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__25748) : style_type.call(null,G__25748));
});
hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(s);
var tc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(t);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.select_keys(sc,cljs.core.keys(tc)),cljs.core.select_keys(tc,cljs.core.keys(sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args25749 = [];
var len__5627__auto___25753 = arguments.length;
var i__5628__auto___25754 = (0);
while(true){
if((i__5628__auto___25754 < len__5627__auto___25753)){
args25749.push((arguments[i__5628__auto___25754]));

var G__25755 = (i__5628__auto___25754 + (1));
i__5628__auto___25754 = G__25755;
continue;
} else {
}
break;
}

var G__25751 = args25749.length;
switch (G__25751) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25749.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
var G__25752 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker));
return (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(G__25752) : kw.call(null,G__25752));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;
/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker),hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = (marker__GT_style.cljs$core$IFn$_invoke$arity$1 ? marker__GT_style.cljs$core$IFn$_invoke$arity$1(marker) : marker__GT_style.call(null,marker));
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return marker.setStyle(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reset,style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(style,cljs.core.cst$kw$reset,style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4423__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4423__auto__)){
var rstyle = temp__4423__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__4569__auto__ = hatti.map.utils.is_clicked_QMARK_(marker);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var G__25758 = hatti.map.utils.get_id(marker);
return (id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25758) : id_selected_QMARK_.call(null,G__25758));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style(marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$hover));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__5634__auto__ = [];
var len__5627__auto___25768 = arguments.length;
var i__5628__auto___25769 = (0);
while(true){
if((i__5628__auto___25769 < len__5627__auto___25768)){
args__5634__auto__.push((arguments[i__5628__auto___25769]));

var G__25770 = (i__5628__auto___25769 + (1));
i__5628__auto___25769 = G__25770;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__25761){
var map__25762 = p__25761;
var map__25762__$1 = ((((!((map__25762 == null)))?((((map__25762.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25762.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25762):map__25762);
var preserve_clicked_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__25762__$1,cljs.core.cst$kw$preserve_DASH_clicked_QMARK_,true);
var seq__25764 = cljs.core.seq(markers);
var chunk__25765 = null;
var count__25766 = (0);
var i__25767 = (0);
while(true){
if((i__25767 < count__25766)){
var marker = chunk__25765.cljs$core$IIndexed$_nth$arity$2(null,i__25767);
if(cljs.core.not((function (){var and__4557__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__4557__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__25771 = seq__25764;
var G__25772 = chunk__25765;
var G__25773 = count__25766;
var G__25774 = (i__25767 + (1));
seq__25764 = G__25771;
chunk__25765 = G__25772;
count__25766 = G__25773;
i__25767 = G__25774;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__25764);
if(temp__4425__auto__){
var seq__25764__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__25764__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__25764__$1);
var G__25775 = cljs.core.chunk_rest(seq__25764__$1);
var G__25776 = c__5372__auto__;
var G__25777 = cljs.core.count(c__5372__auto__);
var G__25778 = (0);
seq__25764 = G__25775;
chunk__25765 = G__25776;
count__25766 = G__25777;
i__25767 = G__25778;
continue;
} else {
var marker = cljs.core.first(seq__25764__$1);
if(cljs.core.not((function (){var and__4557__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__4557__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__25779 = cljs.core.next(seq__25764__$1);
var G__25780 = null;
var G__25781 = (0);
var G__25782 = (0);
seq__25764 = G__25779;
chunk__25765 = G__25780;
count__25766 = G__25781;
i__25767 = G__25782;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq25759){
var G__25760 = cljs.core.first(seq25759);
var seq25759__$1 = cljs.core.next(seq25759);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__25760,seq25759__$1);
});
hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string(maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"Feature",cljs.core.cst$kw$properties,cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._rank),(index + (1)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id),record_id], true, false),cljs.core.cst$kw$geometry,geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__5482__auto__ = (function (){var G__25783 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25783) : cljs.core.atom.call(null,G__25783));
})();
var prefer_table__5483__auto__ = (function (){var G__25784 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25784) : cljs.core.atom.call(null,G__25784));
})();
var method_cache__5484__auto__ = (function (){var G__25785 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25785) : cljs.core.atom.call(null,G__25785));
})();
var cached_hierarchy__5485__auto__ = (function (){var G__25786 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25786) : cljs.core.atom.call(null,G__25786));
})();
var hierarchy__5486__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("hatti.map.utils","get-as-geom"),((function (method_table__5482__auto__,prefer_table__5483__auto__,method_cache__5484__auto__,cached_hierarchy__5485__auto__,hierarchy__5486__auto__){
return (function() { 
var G__25789__delegate = function (record,field,p__25787){
var vec__25788 = p__25787;
var repeat_child_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25788,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return cljs.core.cst$kw$repeat;
} else {
return cljs.core.cst$kw$default;

}
};
var G__25789 = function (record,field,var_args){
var p__25787 = null;
if (arguments.length > 2) {
var G__25790__i = 0, G__25790__a = new Array(arguments.length -  2);
while (G__25790__i < G__25790__a.length) {G__25790__a[G__25790__i] = arguments[G__25790__i + 2]; ++G__25790__i;}
  p__25787 = new cljs.core.IndexedSeq(G__25790__a,0);
} 
return G__25789__delegate.call(this,record,field,p__25787);};
G__25789.cljs$lang$maxFixedArity = 2;
G__25789.cljs$lang$applyTo = (function (arglist__25791){
var record = cljs.core.first(arglist__25791);
arglist__25791 = cljs.core.next(arglist__25791);
var field = cljs.core.first(arglist__25791);
var p__25787 = cljs.core.rest(arglist__25791);
return G__25789__delegate(record,field,p__25787);
});
G__25789.cljs$core$IFn$_invoke$arity$variadic = G__25789__delegate;
return G__25789;
})()
;})(method_table__5482__auto__,prefer_table__5483__auto__,method_cache__5484__auto__,cached_hierarchy__5485__auto__,hierarchy__5486__auto__))
,cljs.core.cst$kw$default,hierarchy__5486__auto__,method_table__5482__auto__,prefer_table__5483__auto__,method_cache__5484__auto__,cached_hierarchy__5485__auto__));
})();
}
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$repeat,(function (record,p__25792){
var map__25793 = p__25792;
var map__25793__$1 = ((((!((map__25793 == null)))?((((map__25793.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25793.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25793):map__25793);
var field = map__25793__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25793__$1,cljs.core.cst$kw$children);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25793__$1,cljs.core.cst$kw$full_DASH_name);
var iter__5341__auto__ = ((function (map__25793,map__25793__$1,field,children,full_name){
return (function hatti$map$utils$iter__25795(s__25796){
return (new cljs.core.LazySeq(null,((function (map__25793,map__25793__$1,field,children,full_name){
return (function (){
var s__25796__$1 = s__25796;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__25796__$1);
if(temp__4425__auto__){
var s__25796__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__25796__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__25796__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__25798 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__25797 = (0);
while(true){
if((i__25797 < size__5340__auto__)){
var child_record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__25797);
cljs.core.chunk_append(b__25798,(function (){var iter__5341__auto__ = ((function (i__25797,child_record,c__5339__auto__,size__5340__auto__,b__25798,s__25796__$2,temp__4425__auto__,map__25793,map__25793__$1,field,children,full_name){
return (function hatti$map$utils$iter__25795_$_iter__25813(s__25814){
return (new cljs.core.LazySeq(null,((function (i__25797,child_record,c__5339__auto__,size__5340__auto__,b__25798,s__25796__$2,temp__4425__auto__,map__25793,map__25793__$1,field,children,full_name){
return (function (){
var s__25814__$1 = s__25814;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__25814__$1);
if(temp__4425__auto____$1){
var s__25814__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__25814__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first(s__25814__$2);
var size__5340__auto____$1 = cljs.core.count(c__5339__auto____$1);
var b__25816 = cljs.core.chunk_buffer(size__5340__auto____$1);
if((function (){var i__25815 = (0);
while(true){
if((i__25815 < size__5340__auto____$1)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto____$1,i__25815);
cljs.core.chunk_append(b__25816,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__25825 = (i__25815 + (1));
i__25815 = G__25825;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25816),hatti$map$utils$iter__25795_$_iter__25813(cljs.core.chunk_rest(s__25814__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25816),null);
}
} else {
var child = cljs.core.first(s__25814__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__25795_$_iter__25813(cljs.core.rest(s__25814__$2)));
}
} else {
return null;
}
break;
}
});})(i__25797,child_record,c__5339__auto__,size__5340__auto__,b__25798,s__25796__$2,temp__4425__auto__,map__25793,map__25793__$1,field,children,full_name))
,null,null));
});})(i__25797,child_record,c__5339__auto__,size__5340__auto__,b__25798,s__25796__$2,temp__4425__auto__,map__25793,map__25793__$1,field,children,full_name))
;
return iter__5341__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})());

var G__25826 = (i__25797 + (1));
i__25797 = G__25826;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25798),hatti$map$utils$iter__25795(cljs.core.chunk_rest(s__25796__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25798),null);
}
} else {
var child_record = cljs.core.first(s__25796__$2);
return cljs.core.cons((function (){var iter__5341__auto__ = ((function (child_record,s__25796__$2,temp__4425__auto__,map__25793,map__25793__$1,field,children,full_name){
return (function hatti$map$utils$iter__25795_$_iter__25819(s__25820){
return (new cljs.core.LazySeq(null,((function (child_record,s__25796__$2,temp__4425__auto__,map__25793,map__25793__$1,field,children,full_name){
return (function (){
var s__25820__$1 = s__25820;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__25820__$1);
if(temp__4425__auto____$1){
var s__25820__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__25820__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__25820__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__25822 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__25821 = (0);
while(true){
if((i__25821 < size__5340__auto__)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__25821);
cljs.core.chunk_append(b__25822,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__25827 = (i__25821 + (1));
i__25821 = G__25827;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25822),hatti$map$utils$iter__25795_$_iter__25819(cljs.core.chunk_rest(s__25820__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25822),null);
}
} else {
var child = cljs.core.first(s__25820__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__25795_$_iter__25819(cljs.core.rest(s__25820__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__25796__$2,temp__4425__auto__,map__25793,map__25793__$1,field,children,full_name))
,null,null));
});})(child_record,s__25796__$2,temp__4425__auto__,map__25793,map__25793__$1,field,children,full_name))
;
return iter__5341__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__25795(cljs.core.rest(s__25796__$2)));
}
} else {
return null;
}
break;
}
});})(map__25793,map__25793__$1,field,children,full_name))
,null,null));
});})(map__25793,map__25793__$1,field,children,full_name))
;
return iter__5341__auto__(cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,full_name));
}));
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq(s)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,"n/a"))){
var iter__5341__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__25830(s__25831){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__25831__$1 = s__25831;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__25831__$1);
if(temp__4425__auto__){
var s__25831__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__25831__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__25831__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__25833 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__25832 = (0);
while(true){
if((i__25832 < size__5340__auto__)){
var coord_string = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__25832);
cljs.core.chunk_append(b__25833,(function (){var vec__25838 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25838,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25838,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25838,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25838,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})());

var G__25841 = (i__25832 + (1));
i__25832 = G__25841;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25833),hatti$map$utils$iter__25830(cljs.core.chunk_rest(s__25831__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25833),null);
}
} else {
var coord_string = cljs.core.first(s__25831__$2);
return cljs.core.cons((function (){var vec__25839 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25839,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25839,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25839,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25839,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})(),hatti$map$utils$iter__25830(cljs.core.rest(s__25831__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__5341__auto__(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__25840 = geotype;
switch (G__25840) {
case "Point":
return ((function (G__25840,geotype,parse){
return (function (p1__25828_SHARP_){
return cljs.core.first(parse(p1__25828_SHARP_));
});
;})(G__25840,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__25840,geotype,parse){
return (function (p1__25829_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse(p1__25829_SHARP_)],null));
});
;})(G__25840,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield));
var coords = (coordfn.cljs$core$IFn$_invoke$arity$1 ? coordfn.cljs$core$IFn$_invoke$arity$1(value) : coordfn.call(null,value));
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(geofield))){
return cljs.core.cst$kw$geom.cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__4569__auto__ = (coords == null);
if(or__4569__auto__){
return or__4569__auto__;
} else {
return cljs.core.some(cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,geotype,cljs.core.cst$kw$coordinates,coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args25844 = [];
var len__5627__auto___25857 = arguments.length;
var i__5628__auto___25858 = (0);
while(true){
if((i__5628__auto___25858 < len__5627__auto___25857)){
args25844.push((arguments[i__5628__auto___25858]));

var G__25859 = (i__5628__auto___25858 + (1));
i__5628__auto___25858 = G__25859;
continue;
} else {
}
break;
}

var G__25846 = args25844.length;
switch (G__25846) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25844.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3(dataset,form,hatti.ona.forms.default_geofield(form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__5341__auto__ = (function hatti$map$utils$iter__25847(s__25848){
return (new cljs.core.LazySeq(null,(function (){
var s__25848__$1 = s__25848;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__25848__$1);
if(temp__4425__auto__){
var s__25848__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__25848__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__25848__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__25850 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__25849 = (0);
while(true){
if((i__25849 < size__5340__auto__)){
var vec__25855 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__25849);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25855,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25855,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append(b__25850,((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__25849,s__25848__$1,geom_or_geoms,vec__25855,idx,record,c__5339__auto__,size__5340__auto__,b__25850,s__25848__$2,temp__4425__auto__){
return (function (p1__25843_SHARP_){
return hatti.map.utils.make_feature(p1__25843_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(i__25849,s__25848__$1,geom_or_geoms,vec__25855,idx,record,c__5339__auto__,size__5340__auto__,b__25850,s__25848__$2,temp__4425__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))));

var G__25861 = (i__25849 + (1));
i__25849 = G__25861;
continue;
} else {
var G__25862 = (i__25849 + (1));
i__25849 = G__25862;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25850),hatti$map$utils$iter__25847(cljs.core.chunk_rest(s__25848__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25850),null);
}
} else {
var vec__25856 = cljs.core.first(s__25848__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25856,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25856,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons(((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (s__25848__$1,geom_or_geoms,vec__25856,idx,record,s__25848__$2,temp__4425__auto__){
return (function (p1__25843_SHARP_){
return hatti.map.utils.make_feature(p1__25843_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(s__25848__$1,geom_or_geoms,vec__25856,idx,record,s__25848__$2,temp__4425__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))),hatti$map$utils$iter__25847(cljs.core.rest(s__25848__$2)));
} else {
var G__25863 = cljs.core.rest(s__25848__$2);
s__25848__$1 = G__25863;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(hatti.utils.indexed(dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,cljs.core.flatten(features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;
/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__25865){
var map__25868 = p__25865;
var map__25868__$1 = ((((!((map__25868 == null)))?((((map__25868.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25868.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25868):map__25868);
var mapbox_tiles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25868__$1,cljs.core.cst$kw$mapbox_DASH_tiles);
var include_google_maps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25868__$1,cljs.core.cst$kw$include_DASH_google_DASH_maps_QMARK_);
var layers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__25868,map__25868__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__25864_SHARP_){
return L.tileLayer(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(p1__25864_SHARP_));
});})(map__25868,map__25868__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name,mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js(nlayers));
var m = L.map(id,{"layers": cljs.core.first(layers), "zoomControl": false});
var z = L.control.zoom.call(null,{"position": "bottomleft"});
z.addTo(m);

L.control.layers.call(null,named_layers,null,{"position": "bottomleft"}).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank,((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style(marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style(marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not(layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__5634__auto__ = [];
var len__5627__auto___25882 = arguments.length;
var i__5628__auto___25883 = (0);
while(true){
if((i__5628__auto___25883 < len__5627__auto___25882)){
args__5634__auto__.push((arguments[i__5628__auto___25883]));

var G__25884 = (i__5628__auto___25883 + (1));
i__5628__auto___25883 = G__25884;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__25879){
var map__25880 = p__25879;
var map__25880__$1 = ((((!((map__25880 == null)))?((((map__25880.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25880.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25880):map__25880);
var rezoom_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25880__$1,cljs.core.cst$kw$rezoom_QMARK_);
var on_events = ((function (map__25880,map__25880__$1,rezoom_QMARK_){
return (function (p1__25870_SHARP_,p2__25871_SHARP_){
return hatti.map.utils.register_mouse_events(p1__25870_SHARP_,p2__25871_SHARP_,event_chan);
});})(map__25880,map__25880__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__25880,map__25880__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style(geometry_type,cljs.core.cst$kw$normal);
});})(on_events,geometry_type,map__25880,map__25880__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__25880,map__25880__$1,rezoom_QMARK_){
return (function (p1__25873_SHARP_,p2__25872_SHARP_){
return L.circleMarker(p2__25872_SHARP_);
});})(on_events,geometry_type,stylefn,map__25880,map__25880__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js(geojson),{"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn});
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__25880,map__25880__$1,rezoom_QMARK_){
return (function (p1__25874_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__25874_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$properties,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__25880,map__25880__$1,rezoom_QMARK_))
,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$feature_DASH_layer,feature_layer,cljs.core.cst$kw$markers,markers,cljs.core.cst$kw$id_DASH__GT_marker,cljs.core.zipmap(ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq25875){
var G__25876 = cljs.core.first(seq25875);
var seq25875__$1 = cljs.core.next(seq25875);
var G__25877 = cljs.core.first(seq25875__$1);
var seq25875__$2 = cljs.core.next(seq25875__$1);
var G__25878 = cljs.core.first(seq25875__$2);
var seq25875__$3 = cljs.core.next(seq25875__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__25876,G__25877,G__25878,seq25875__$3);
});
