// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('chimera.urls');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__5341__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__27187(s__27188){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__27188__$1 = s__27188;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27188__$1);
if(temp__4425__auto__){
var s__27188__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27188__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27188__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27190 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27189 = (0);
while(true){
if((i__27189 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27189);
cljs.core.chunk_append(b__27190,(function (){var iter__5341__auto__ = ((function (i__27189,datum,c__5339__auto__,size__5340__auto__,b__27190,s__27188__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__27187_$_iter__27205(s__27206){
return (new cljs.core.LazySeq(null,((function (i__27189,datum,c__5339__auto__,size__5340__auto__,b__27190,s__27188__$2,temp__4425__auto__,osmfields){
return (function (){
var s__27206__$1 = s__27206;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__27206__$1);
if(temp__4425__auto____$1){
var s__27206__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__27206__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first(s__27206__$2);
var size__5340__auto____$1 = cljs.core.count(c__5339__auto____$1);
var b__27208 = cljs.core.chunk_buffer(size__5340__auto____$1);
if((function (){var i__27207 = (0);
while(true){
if((i__27207 < size__5340__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto____$1,i__27207);
cljs.core.chunk_append(b__27208,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__27217 = (i__27207 + (1));
i__27207 = G__27217;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27208),hatti$ona$post_process$ona_osm_link_$_iter__27187_$_iter__27205(cljs.core.chunk_rest(s__27206__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27208),null);
}
} else {
var field = cljs.core.first(s__27206__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__27187_$_iter__27205(cljs.core.rest(s__27206__$2)));
}
} else {
return null;
}
break;
}
});})(i__27189,datum,c__5339__auto__,size__5340__auto__,b__27190,s__27188__$2,temp__4425__auto__,osmfields))
,null,null));
});})(i__27189,datum,c__5339__auto__,size__5340__auto__,b__27190,s__27188__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})());

var G__27218 = (i__27189 + (1));
i__27189 = G__27218;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27190),hatti$ona$post_process$ona_osm_link_$_iter__27187(cljs.core.chunk_rest(s__27188__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27190),null);
}
} else {
var datum = cljs.core.first(s__27188__$2);
return cljs.core.cons((function (){var iter__5341__auto__ = ((function (datum,s__27188__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__27187_$_iter__27211(s__27212){
return (new cljs.core.LazySeq(null,((function (datum,s__27188__$2,temp__4425__auto__,osmfields){
return (function (){
var s__27212__$1 = s__27212;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__27212__$1);
if(temp__4425__auto____$1){
var s__27212__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__27212__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27212__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27214 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27213 = (0);
while(true){
if((i__27213 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27213);
cljs.core.chunk_append(b__27214,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__27219 = (i__27213 + (1));
i__27213 = G__27219;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27214),hatti$ona$post_process$ona_osm_link_$_iter__27187_$_iter__27211(cljs.core.chunk_rest(s__27212__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27214),null);
}
} else {
var field = cljs.core.first(s__27212__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__27187_$_iter__27211(cljs.core.rest(s__27212__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__27188__$2,temp__4425__auto__,osmfields))
,null,null));
});})(datum,s__27188__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__27187(cljs.core.rest(s__27188__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5341__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__27221 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__27221);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$features) : osmgeo.call(null,cljs.core.cst$kw$features));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__27244(s__27245){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__27245__$1 = s__27245;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27245__$1);
if(temp__4425__auto__){
var s__27245__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27245__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27245__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27247 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27246 = (0);
while(true){
if((i__27246 < size__5340__auto__)){
var map__27258 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27246);
var map__27258__$1 = ((((!((map__27258 == null)))?((((map__27258.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27258.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27258):map__27258);
var feature = map__27258__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27258__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27258__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27258__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__27247,(function (){var map__27260 = properties;
var map__27260__$1 = ((((!((map__27260 == null)))?((((map__27260.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27260.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27260):map__27260);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27260__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27260__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27260__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__27266 = (i__27246 + (1));
i__27246 = G__27266;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27247),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__27244(cljs.core.chunk_rest(s__27245__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27247),null);
}
} else {
var map__27262 = cljs.core.first(s__27245__$2);
var map__27262__$1 = ((((!((map__27262 == null)))?((((map__27262.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27262.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27262):map__27262);
var feature = map__27262__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27262__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27262__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27262__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__27264 = properties;
var map__27264__$1 = ((((!((map__27264 == null)))?((((map__27264.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27264.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27264):map__27264);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27264__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27264__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27264__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__27244(cljs.core.rest(s__27245__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5341__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__27267_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__27267_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4423__auto__ = (function (){var G__27279 = osm_val__GT_osm_id(osm_val);
return (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(G__27279) : osm_data.call(null,G__27279));
})();
if(cljs.core.truth_(temp__4423__auto__)){
var osm_submission_data = temp__4423__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5341__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__27280(s__27281){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__27281__$1 = s__27281;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27281__$1);
if(temp__4425__auto__){
var s__27281__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27281__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27281__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27283 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27282 = (0);
while(true){
if((i__27282 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27282);
cljs.core.chunk_append(b__27283,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__27290 = (i__27282 + (1));
i__27282 = G__27290;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27283),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__27280(cljs.core.chunk_rest(s__27281__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27283),null);
}
} else {
var datum = cljs.core.first(s__27281__$2);
return cljs.core.cons(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__27280(cljs.core.rest(s__27281__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5341__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__27286 = cljs.core.seq(osm_fields);
var chunk__27287 = null;
var count__27288 = (0);
var i__27289 = (0);
while(true){
if((i__27289 < count__27288)){
var osm_field = chunk__27287.cljs$core$IIndexed$_nth$arity$2(null,i__27289);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__27291 = seq__27286;
var G__27292 = chunk__27287;
var G__27293 = count__27288;
var G__27294 = (i__27289 + (1));
seq__27286 = G__27291;
chunk__27287 = G__27292;
count__27288 = G__27293;
i__27289 = G__27294;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__27286);
if(temp__4425__auto__){
var seq__27286__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27286__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__27286__$1);
var G__27295 = cljs.core.chunk_rest(seq__27286__$1);
var G__27296 = c__5372__auto__;
var G__27297 = cljs.core.count(c__5372__auto__);
var G__27298 = (0);
seq__27286 = G__27295;
chunk__27287 = G__27296;
count__27288 = G__27297;
i__27289 = G__27298;
continue;
} else {
var osm_field = cljs.core.first(seq__27286__$1);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__27299 = cljs.core.next(seq__27286__$1);
var G__27300 = null;
var G__27301 = (0);
var G__27302 = (0);
seq__27286 = G__27299;
chunk__27287 = G__27300;
count__27288 = G__27301;
i__27289 = G__27302;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4569__auto__ = attachments;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments");
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__27303_SHARP_){
return chimera.urls.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__27303_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5634__auto__ = [];
var len__5627__auto___27316 = arguments.length;
var i__5628__auto___27317 = (0);
while(true){
if((i__5628__auto___27317 < len__5627__auto___27316)){
args__5634__auto__.push((arguments[i__5628__auto___27317]));

var G__27318 = (i__5628__auto___27317 + (1));
i__5628__auto___27317 = G__27318;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__27307){
var map__27308 = p__27307;
var map__27308__$1 = ((((!((map__27308 == null)))?((((map__27308.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27308.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27308):map__27308);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27308__$1,cljs.core.cst$kw$attachments);
var image_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.image_QMARK_,flat_form);
var iter__5341__auto__ = ((function (image_fields,map__27308,map__27308__$1,attachments){
return (function hatti$ona$post_process$iter__27310(s__27311){
return (new cljs.core.LazySeq(null,((function (image_fields,map__27308,map__27308__$1,attachments){
return (function (){
var s__27311__$1 = s__27311;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27311__$1);
if(temp__4425__auto__){
var s__27311__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27311__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27311__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27313 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27312 = (0);
while(true){
if((i__27312 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27312);
cljs.core.chunk_append(b__27313,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__27312,attach_map,record,c__5339__auto__,size__5340__auto__,b__27313,s__27311__$2,temp__4425__auto__,image_fields,map__27308,map__27308__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__27312,attach_map,record,c__5339__auto__,size__5340__auto__,b__27313,s__27311__$2,temp__4425__auto__,image_fields,map__27308,map__27308__$1,attachments))
,record,image_fields);
})());

var G__27319 = (i__27312 + (1));
i__27312 = G__27319;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27313),hatti$ona$post_process$iter__27310(cljs.core.chunk_rest(s__27311__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27313),null);
}
} else {
var record = cljs.core.first(s__27311__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__27311__$2,temp__4425__auto__,image_fields,map__27308,map__27308__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__27311__$2,temp__4425__auto__,image_fields,map__27308,map__27308__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__27310(cljs.core.rest(s__27311__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__27308,map__27308__$1,attachments))
,null,null));
});})(image_fields,map__27308,map__27308__$1,attachments))
;
return iter__5341__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq27304){
var G__27305 = cljs.core.first(seq27304);
var seq27304__$1 = cljs.core.next(seq27304);
var G__27306 = cljs.core.first(seq27304__$1);
var seq27304__$2 = cljs.core.next(seq27304__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__27305,G__27306,seq27304__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments")], 0)));
});})(repeat_fields))
;
var iter__5341__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__27326(s__27327){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__27327__$1 = s__27327;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27327__$1);
if(temp__4425__auto__){
var s__27327__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27327__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27327__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27329 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27328 = (0);
while(true){
if((i__27328 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27328);
cljs.core.chunk_append(b__27329,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__27332 = (i__27328 + (1));
i__27328 = G__27332;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27329),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__27326(cljs.core.chunk_rest(s__27327__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27329),null);
}
} else {
var record = cljs.core.first(s__27327__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__27326(cljs.core.rest(s__27327__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5341__auto__(data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___27340 = arguments.length;
var i__5628__auto___27341 = (0);
while(true){
if((i__5628__auto___27341 < len__5627__auto___27340)){
args__5634__auto__.push((arguments[i__5628__auto___27341]));

var G__27342 = (i__5628__auto___27341 + (1));
i__5628__auto___27341 = G__27342;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__27337){
var map__27338 = p__27337;
var map__27338__$1 = ((((!((map__27338 == null)))?((((map__27338.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27338.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27338):map__27338);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27338__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__27338,map__27338__$1,app_data_keys){
return (function (p1__27333_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__27333_SHARP_));
});})(map__27338,map__27338__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq27334){
var G__27335 = cljs.core.first(seq27334);
var seq27334__$1 = cljs.core.next(seq27334);
var G__27336 = cljs.core.first(seq27334__$1);
var seq27334__$2 = cljs.core.next(seq27334__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__27335,G__27336,seq27334__$2);
});
