// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"id",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___29097 = arguments.length;
var i__5628__auto___29098 = (0);
while(true){
if((i__5628__auto___29098 < len__5627__auto___29097)){
args__5634__auto__.push((arguments[i__5628__auto___29098]));

var G__29099 = (i__5628__auto___29098 + (1));
i__5628__auto___29098 = G__29099;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__29094){
var map__29095 = p__29094;
var map__29095__$1 = ((((!((map__29095 == null)))?((((map__29095.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29095.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29095):map__29095);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29095__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq29092){
var G__29093 = cljs.core.first(seq29092);
var seq29092__$1 = cljs.core.next(seq29092);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__29093,seq29092__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__29100_SHARP_){
if(typeof p1__29100_SHARP_ === 'string'){
return clojure.string.lower_case(p1__29100_SHARP_);
} else {
return p1__29100_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__29104){
var vec__29105 = p__29104;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29105,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29105,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__29101_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__29101_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(field,clj_value,language,true);
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__29106 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__29106__$1 = ((((!((map__29106 == null)))?((((map__29106.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29106.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29106):map__29106);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29106__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29106__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29106__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$right,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_clone,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$right,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil_DASH_square_DASH_o], null)], null)], null)], null):null)], 0));
});
}));
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],["record-actions header",(70),"",(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args29108 = [];
var len__5627__auto___29132 = arguments.length;
var i__5628__auto___29133 = (0);
while(true){
if((i__5628__auto___29133 < len__5627__auto___29132)){
args29108.push((arguments[i__5628__auto___29133]));

var G__29134 = (i__5628__auto___29133 + (1));
i__5628__auto___29133 = G__29134;
continue;
} else {
}
break;
}

var G__29114 = args29108.length;
switch (G__29114) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args29108.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2(form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns(form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__29115){
var map__29116 = p__29115;
var map__29116__$1 = ((((!((map__29116 == null)))?((((map__29116.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29116.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29116):map__29116);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29116__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29116__$1,cljs.core.cst$kw$owner);
var columns = (function (){var iter__5341__auto__ = ((function (map__29116,map__29116__$1,is_filtered_dataview_QMARK_,owner){
return (function hatti$views$table$iter__29118(s__29119){
return (new cljs.core.LazySeq(null,((function (map__29116,map__29116__$1,is_filtered_dataview_QMARK_,owner){
return (function (){
var s__29119__$1 = s__29119;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__29119__$1);
if(temp__4425__auto__){
var s__29119__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29119__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29119__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29121 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29120 = (0);
while(true){
if((i__29120 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29120);
cljs.core.chunk_append(b__29121,(function (){var map__29128 = field;
var map__29128__$1 = ((((!((map__29128 == null)))?((((map__29128.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29128.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29128):map__29128);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29128__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29128__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29128__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})());

var G__29136 = (i__29120 + (1));
i__29120 = G__29136;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29121),hatti$views$table$iter__29118(cljs.core.chunk_rest(s__29119__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29121),null);
}
} else {
var field = cljs.core.first(s__29119__$2);
return cljs.core.cons((function (){var map__29130 = field;
var map__29130__$1 = ((((!((map__29130 == null)))?((((map__29130.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29130.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29130):map__29130);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29130__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29130__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29130__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})(),hatti$views$table$iter__29118(cljs.core.rest(s__29119__$2)));
}
} else {
return null;
}
break;
}
});})(map__29116,map__29116__$1,is_filtered_dataview_QMARK_,owner))
,null,null));
});})(map__29116,map__29116__$1,is_filtered_dataview_QMARK_,owner))
;
return iter__5341__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})();
return cljs.core.clj__GT_js(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(columns,hatti.views.table.actions_column(owner)));
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq29109){
var G__29110 = cljs.core.first(seq29109);
var seq29109__$1 = cljs.core.next(seq29109);
var G__29111 = cljs.core.first(seq29109__$1);
var seq29109__$2 = cljs.core.next(seq29109__$1);
var G__29112 = cljs.core.first(seq29109__$2);
var seq29109__$3 = cljs.core.next(seq29109__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__29110,G__29111,G__29112,seq29109__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__29138 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__29138);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false};
/**
 * Fixes the first column on slick table on horizontal scroll
 */
hatti.views.table.freeze_action_column_BANG_ = (function hatti$views$table$freeze_action_column_BANG_(){
var actions = document.getElementsByClassName("record-actions");
var sg_viewport = cljs.core.first(document.getElementsByClassName("slick-viewport"));
var seq__29146 = cljs.core.seq(actions);
var chunk__29147 = null;
var count__29148 = (0);
var i__29149 = (0);
while(true){
if((i__29149 < count__29148)){
var action = chunk__29147.cljs$core$IIndexed$_nth$arity$2(null,i__29149);
var leftOffset_29152 = (function (){var G__29150 = action.offsetLeft;
return parseInt(G__29150);
})();
sg_viewport.addEventListener("scroll",((function (seq__29146,chunk__29147,count__29148,i__29149,leftOffset_29152,action,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__29146,chunk__29147,count__29148,i__29149,sl,leftOffset_29152,action,actions,sg_viewport){
return (function (p1__29139_SHARP_){
return action.style.borderRight = p1__29139_SHARP_;
});})(seq__29146,chunk__29147,count__29148,i__29149,sl,leftOffset_29152,action,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_("1px dotted #ededed");
} else {
set_border_BANG_("1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_29152)),cljs.core.str("px")].join('');
});})(seq__29146,chunk__29147,count__29148,i__29149,leftOffset_29152,action,actions,sg_viewport))
);

var G__29153 = seq__29146;
var G__29154 = chunk__29147;
var G__29155 = count__29148;
var G__29156 = (i__29149 + (1));
seq__29146 = G__29153;
chunk__29147 = G__29154;
count__29148 = G__29155;
i__29149 = G__29156;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__29146);
if(temp__4425__auto__){
var seq__29146__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__29146__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__29146__$1);
var G__29157 = cljs.core.chunk_rest(seq__29146__$1);
var G__29158 = c__5372__auto__;
var G__29159 = cljs.core.count(c__5372__auto__);
var G__29160 = (0);
seq__29146 = G__29157;
chunk__29147 = G__29158;
count__29148 = G__29159;
i__29149 = G__29160;
continue;
} else {
var action = cljs.core.first(seq__29146__$1);
var leftOffset_29161 = (function (){var G__29151 = action.offsetLeft;
return parseInt(G__29151);
})();
sg_viewport.addEventListener("scroll",((function (seq__29146,chunk__29147,count__29148,i__29149,leftOffset_29161,action,seq__29146__$1,temp__4425__auto__,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__29146,chunk__29147,count__29148,i__29149,sl,leftOffset_29161,action,seq__29146__$1,temp__4425__auto__,actions,sg_viewport){
return (function (p1__29139_SHARP_){
return action.style.borderRight = p1__29139_SHARP_;
});})(seq__29146,chunk__29147,count__29148,i__29149,sl,leftOffset_29161,action,seq__29146__$1,temp__4425__auto__,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_("1px dotted #ededed");
} else {
set_border_BANG_("1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_29161)),cljs.core.str("px")].join('');
});})(seq__29146,chunk__29147,count__29148,i__29149,leftOffset_29161,action,seq__29146__$1,temp__4425__auto__,actions,sg_viewport))
);

var G__29162 = cljs.core.next(seq__29146__$1);
var G__29163 = null;
var G__29164 = (0);
var G__29165 = (0);
seq__29146 = G__29162;
chunk__29147 = G__29163;
count__29148 = G__29164;
i__29149 = G__29165;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__29176(s__29177){
return (new cljs.core.LazySeq(null,(function (){
var s__29177__$1 = s__29177;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__29177__$1);
if(temp__4425__auto__){
var s__29177__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29177__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29177__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29179 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29178 = (0);
while(true){
if((i__29178 < size__5340__auto__)){
var vec__29184 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29178);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29184,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29184,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__29179,event.subscribe(handler_function));

var G__29186 = (i__29178 + (1));
i__29178 = G__29186;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29179),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__29176(cljs.core.chunk_rest(s__29177__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29179),null);
}
} else {
var vec__29185 = cljs.core.first(s__29177__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29185,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29185,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__29176(cljs.core.rest(s__29177__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__29197(s__29198){
return (new cljs.core.LazySeq(null,(function (){
var s__29198__$1 = s__29198;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__29198__$1);
if(temp__4425__auto__){
var s__29198__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29198__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29198__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29200 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29199 = (0);
while(true){
if((i__29199 < size__5340__auto__)){
var vec__29205 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29199);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29205,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29205,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__29200,event.subscribe(handler_function));

var G__29207 = (i__29199 + (1));
i__29199 = G__29207;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29200),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__29197(cljs.core.chunk_rest(s__29198__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29200),null);
}
} else {
var vec__29206 = cljs.core.first(s__29198__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29206,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29206,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__29197(cljs.core.rest(s__29198__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__29208){
var map__29218 = p__29208;
var map__29218__$1 = ((((!((map__29218 == null)))?((((map__29218.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29218.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29218):map__29218);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29218__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29218__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,true,current_language,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__29220 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__29220__$1 = ((((!((map__29220 == null)))?((((map__29220.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29220.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29220):map__29220);
var map__29221 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29220__$1,cljs.core.cst$kw$table_DASH_page);
var map__29221__$1 = ((((!((map__29221 == null)))?((((map__29221.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29221.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29221):map__29221);
var map__29222 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29221__$1,cljs.core.cst$kw$paging);
var map__29222__$1 = ((((!((map__29222 == null)))?((((map__29222.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29222.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29222):map__29222);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29222__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29222__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__29220,map__29220__$1,map__29221,map__29221__$1,map__29222,map__29222__$1,num_displayed_records,total_page_count,map__29218,map__29218__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__29220,map__29220__$1,map__29221,map__29221__$1,map__29222,map__29222__$1,num_displayed_records,total_page_count,map__29218,map__29218__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__29220,map__29220__$1,map__29221,map__29221__$1,map__29222,map__29222__$1,num_displayed_records,total_page_count,map__29218,map__29218__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__29220,map__29220__$1,map__29221,map__29221__$1,map__29222,map__29222__$1,num_displayed_records,total_page_count,map__29218,map__29218__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__29220,map__29220__$1,map__29221,map__29221__$1,map__29222,map__29222__$1,num_displayed_records,total_page_count,map__29218,map__29218__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__29220,map__29220__$1,map__29221,map__29221__$1,map__29222,map__29222__$1,num_displayed_records,total_page_count,map__29218,map__29218__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__29220,map__29220__$1,map__29221,map__29221__$1,map__29222,map__29222__$1,num_displayed_records,total_page_count,map__29218,map__29218__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__29226 = elem.getAttribute("data-id");
return parseInt(G__29226);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
});})(columns,SlickGrid,DataView,dataview,grid,map__29220,map__29220__$1,map__29221,map__29221__$1,map__29222,map__29222__$1,num_displayed_records,total_page_count,map__29218,map__29218__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__8268__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8268__auto__,event_chan){
return (function (){
var f__8269__auto__ = (function (){var switch__8247__auto__ = ((function (c__8268__auto__,event_chan){
return (function (state_29488){
var state_val_29489 = (state_29488[(1)]);
if((state_val_29489 === (7))){
var inst_29397 = (state_29488[(7)]);
var inst_29397__$1 = (state_29488[(2)]);
var inst_29399 = (inst_29397__$1 == null);
var inst_29400 = cljs.core.not(inst_29399);
var state_29488__$1 = (function (){var statearr_29490 = state_29488;
(statearr_29490[(7)] = inst_29397__$1);

return statearr_29490;
})();
if(inst_29400){
var statearr_29491_29558 = state_29488__$1;
(statearr_29491_29558[(1)] = (8));

} else {
var statearr_29492_29559 = state_29488__$1;
(statearr_29492_29559[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (20))){
var inst_29427 = (state_29488[(8)]);
var inst_29419 = (state_29488[(9)]);
var inst_29436 = (inst_29427.cljs$core$IFn$_invoke$arity$1 ? inst_29427.cljs$core$IFn$_invoke$arity$1(inst_29419) : inst_29427.call(null,inst_29419));
var state_29488__$1 = state_29488;
var statearr_29493_29560 = state_29488__$1;
(statearr_29493_29560[(2)] = inst_29436);

(statearr_29493_29560[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (27))){
var state_29488__$1 = state_29488;
var statearr_29494_29561 = state_29488__$1;
(statearr_29494_29561[(2)] = null);

(statearr_29494_29561[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (1))){
var state_29488__$1 = state_29488;
var statearr_29495_29562 = state_29488__$1;
(statearr_29495_29562[(2)] = null);

(statearr_29495_29562[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (24))){
var state_29488__$1 = state_29488;
var statearr_29496_29563 = state_29488__$1;
(statearr_29496_29563[(2)] = null);

(statearr_29496_29563[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (4))){
var state_29488__$1 = state_29488;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29488__$1,(7),event_chan);
} else {
if((state_val_29489 === (15))){
var inst_29397 = (state_29488[(7)]);
var state_29488__$1 = state_29488;
var statearr_29497_29564 = state_29488__$1;
(statearr_29497_29564[(2)] = inst_29397);

(statearr_29497_29564[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (21))){
var state_29488__$1 = state_29488;
var statearr_29498_29565 = state_29488__$1;
(statearr_29498_29565[(2)] = null);

(statearr_29498_29565[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (31))){
var inst_29423 = (state_29488[(10)]);
var inst_29461 = (state_29488[(2)]);
var inst_29462 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29423,cljs.core.cst$kw$table);
var state_29488__$1 = (function (){var statearr_29499 = state_29488;
(statearr_29499[(11)] = inst_29461);

return statearr_29499;
})();
if(inst_29462){
var statearr_29500_29566 = state_29488__$1;
(statearr_29500_29566[(1)] = (32));

} else {
var statearr_29501_29567 = state_29488__$1;
(statearr_29501_29567[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (32))){
var inst_29397 = (state_29488[(7)]);
var inst_29427 = (state_29488[(8)]);
var inst_29418 = (state_29488[(12)]);
var inst_29417 = (state_29488[(13)]);
var inst_29428 = (state_29488[(14)]);
var inst_29422 = (state_29488[(15)]);
var inst_29420 = (state_29488[(16)]);
var inst_29421 = (state_29488[(17)]);
var inst_29423 = (state_29488[(10)]);
var inst_29419 = (state_29488[(9)]);
var inst_29475 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_29476 = (function (){var new_columns = inst_29422;
var submission_clicked = inst_29419;
var submission_unclicked = inst_29420;
var get_submission_data = inst_29428;
var re_render = inst_29423;
var update_data_BANG_ = inst_29427;
var submission_to_rank = inst_29418;
var e = inst_29397;
var filter_by = inst_29421;
var c__8268__auto____$1 = inst_29475;
var map__29395 = inst_29417;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,c__8268__auto____$1,map__29395,inst_29397,inst_29427,inst_29418,inst_29417,inst_29428,inst_29422,inst_29420,inst_29421,inst_29423,inst_29419,inst_29475,state_val_29489,c__8268__auto__,event_chan){
return (function (){
var f__8269__auto__ = (function (){var switch__8247__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,c__8268__auto____$1,map__29395,inst_29397,inst_29427,inst_29418,inst_29417,inst_29428,inst_29422,inst_29420,inst_29421,inst_29423,inst_29419,inst_29475,state_val_29489,c__8268__auto__,event_chan){
return (function (state_29473){
var state_val_29474 = (state_29473[(1)]);
if((state_val_29474 === (1))){
var inst_29464 = cljs.core.async.timeout((20));
var state_29473__$1 = state_29473;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29473__$1,(2),inst_29464);
} else {
if((state_val_29474 === (2))){
var inst_29466 = (state_29473[(2)]);
var inst_29467 = grid.resizeCanvas();
var inst_29468 = grid.invalidateAllRows();
var inst_29469 = hatti.views.table.resizeColumns(grid);
var inst_29470 = grid.render();
var inst_29471 = hatti.views.table.init_sg_pager(grid,dataview);
var state_29473__$1 = (function (){var statearr_29502 = state_29473;
(statearr_29502[(7)] = inst_29468);

(statearr_29502[(8)] = inst_29467);

(statearr_29502[(9)] = inst_29469);

(statearr_29502[(10)] = inst_29470);

(statearr_29502[(11)] = inst_29466);

return statearr_29502;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29473__$1,inst_29471);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,c__8268__auto____$1,map__29395,inst_29397,inst_29427,inst_29418,inst_29417,inst_29428,inst_29422,inst_29420,inst_29421,inst_29423,inst_29419,inst_29475,state_val_29489,c__8268__auto__,event_chan))
;
return ((function (switch__8247__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,c__8268__auto____$1,map__29395,inst_29397,inst_29427,inst_29418,inst_29417,inst_29428,inst_29422,inst_29420,inst_29421,inst_29423,inst_29419,inst_29475,state_val_29489,c__8268__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8248__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8248__auto____0 = (function (){
var statearr_29506 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29506[(0)] = hatti$views$table$handle_table_events_$_state_machine__8248__auto__);

(statearr_29506[(1)] = (1));

return statearr_29506;
});
var hatti$views$table$handle_table_events_$_state_machine__8248__auto____1 = (function (state_29473){
while(true){
var ret_value__8249__auto__ = (function (){try{while(true){
var result__8250__auto__ = switch__8247__auto__(state_29473);
if(cljs.core.keyword_identical_QMARK_(result__8250__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8250__auto__;
}
break;
}
}catch (e29507){if((e29507 instanceof Object)){
var ex__8251__auto__ = e29507;
var statearr_29508_29568 = state_29473;
(statearr_29508_29568[(5)] = ex__8251__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29473);

return cljs.core.cst$kw$recur;
} else {
throw e29507;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8249__auto__,cljs.core.cst$kw$recur)){
var G__29569 = state_29473;
state_29473 = G__29569;
continue;
} else {
return ret_value__8249__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8248__auto__ = function(state_29473){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8248__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8248__auto____1.call(this,state_29473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8248__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8248__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8248__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8248__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8248__auto__;
})()
;})(switch__8247__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,c__8268__auto____$1,map__29395,inst_29397,inst_29427,inst_29418,inst_29417,inst_29428,inst_29422,inst_29420,inst_29421,inst_29423,inst_29419,inst_29475,state_val_29489,c__8268__auto__,event_chan))
})();
var state__8270__auto__ = (function (){var statearr_29509 = (f__8269__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8269__auto__.cljs$core$IFn$_invoke$arity$0() : f__8269__auto__.call(null));
(statearr_29509[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8268__auto____$1);

return statearr_29509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8270__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,c__8268__auto____$1,map__29395,inst_29397,inst_29427,inst_29418,inst_29417,inst_29428,inst_29422,inst_29420,inst_29421,inst_29423,inst_29419,inst_29475,state_val_29489,c__8268__auto__,event_chan))
})();
var inst_29477 = cljs.core.async.impl.dispatch.run(inst_29476);
var state_29488__$1 = (function (){var statearr_29510 = state_29488;
(statearr_29510[(18)] = inst_29477);

return statearr_29510;
})();
var statearr_29511_29570 = state_29488__$1;
(statearr_29511_29570[(2)] = inst_29475);

(statearr_29511_29570[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (33))){
var state_29488__$1 = state_29488;
var statearr_29512_29571 = state_29488__$1;
(statearr_29512_29571[(2)] = null);

(statearr_29512_29571[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (13))){
var inst_29409 = (state_29488[(2)]);
var state_29488__$1 = state_29488;
var statearr_29513_29572 = state_29488__$1;
(statearr_29513_29572[(2)] = inst_29409);

(statearr_29513_29572[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (22))){
var inst_29420 = (state_29488[(16)]);
var inst_29439 = (state_29488[(2)]);
var state_29488__$1 = (function (){var statearr_29514 = state_29488;
(statearr_29514[(19)] = inst_29439);

return statearr_29514;
})();
if(cljs.core.truth_(inst_29420)){
var statearr_29515_29573 = state_29488__$1;
(statearr_29515_29573[(1)] = (23));

} else {
var statearr_29516_29574 = state_29488__$1;
(statearr_29516_29574[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (29))){
var inst_29421 = (state_29488[(17)]);
var inst_29453 = [cljs.core.cst$kw$query];
var inst_29454 = [inst_29421];
var inst_29455 = cljs.core.PersistentHashMap.fromArrays(inst_29453,inst_29454);
var inst_29456 = cljs.core.clj__GT_js(inst_29455);
var inst_29457 = dataview.setFilterArgs(inst_29456);
var inst_29458 = dataview.refresh();
var state_29488__$1 = (function (){var statearr_29517 = state_29488;
(statearr_29517[(20)] = inst_29457);

return statearr_29517;
})();
var statearr_29518_29575 = state_29488__$1;
(statearr_29518_29575[(2)] = inst_29458);

(statearr_29518_29575[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (6))){
var inst_29484 = (state_29488[(2)]);
var state_29488__$1 = state_29488;
var statearr_29519_29576 = state_29488__$1;
(statearr_29519_29576[(2)] = inst_29484);

(statearr_29519_29576[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (28))){
var inst_29421 = (state_29488[(17)]);
var inst_29451 = (state_29488[(2)]);
var state_29488__$1 = (function (){var statearr_29520 = state_29488;
(statearr_29520[(21)] = inst_29451);

return statearr_29520;
})();
if(cljs.core.truth_(inst_29421)){
var statearr_29521_29577 = state_29488__$1;
(statearr_29521_29577[(1)] = (29));

} else {
var statearr_29522_29578 = state_29488__$1;
(statearr_29522_29578[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (25))){
var inst_29422 = (state_29488[(15)]);
var inst_29444 = (state_29488[(2)]);
var state_29488__$1 = (function (){var statearr_29523 = state_29488;
(statearr_29523[(22)] = inst_29444);

return statearr_29523;
})();
if(cljs.core.truth_(inst_29422)){
var statearr_29524_29579 = state_29488__$1;
(statearr_29524_29579[(1)] = (26));

} else {
var statearr_29525_29580 = state_29488__$1;
(statearr_29525_29580[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (34))){
var inst_29480 = (state_29488[(2)]);
var state_29488__$1 = (function (){var statearr_29526 = state_29488;
(statearr_29526[(23)] = inst_29480);

return statearr_29526;
})();
var statearr_29527_29581 = state_29488__$1;
(statearr_29527_29581[(2)] = null);

(statearr_29527_29581[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (17))){
var inst_29427 = (state_29488[(8)]);
var inst_29418 = (state_29488[(12)]);
var inst_29428 = (state_29488[(14)]);
var inst_29430 = (inst_29428.cljs$core$IFn$_invoke$arity$2 ? inst_29428.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_29418) : inst_29428.call(null,hatti.constants._rank,inst_29418));
var inst_29431 = (inst_29427.cljs$core$IFn$_invoke$arity$1 ? inst_29427.cljs$core$IFn$_invoke$arity$1(inst_29430) : inst_29427.call(null,inst_29430));
var state_29488__$1 = state_29488;
var statearr_29528_29582 = state_29488__$1;
(statearr_29528_29582[(2)] = inst_29431);

(statearr_29528_29582[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (3))){
var inst_29486 = (state_29488[(2)]);
var state_29488__$1 = state_29488;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29488__$1,inst_29486);
} else {
if((state_val_29489 === (12))){
var state_29488__$1 = state_29488;
var statearr_29529_29583 = state_29488__$1;
(statearr_29529_29583[(2)] = false);

(statearr_29529_29583[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (2))){
var state_29488__$1 = state_29488;
var statearr_29530_29584 = state_29488__$1;
(statearr_29530_29584[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (23))){
var inst_29427 = (state_29488[(8)]);
var inst_29441 = (inst_29427.cljs$core$IFn$_invoke$arity$1 ? inst_29427.cljs$core$IFn$_invoke$arity$1(null) : inst_29427.call(null,null));
var state_29488__$1 = state_29488;
var statearr_29532_29585 = state_29488__$1;
(statearr_29532_29585[(2)] = inst_29441);

(statearr_29532_29585[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (19))){
var inst_29419 = (state_29488[(9)]);
var inst_29434 = (state_29488[(2)]);
var state_29488__$1 = (function (){var statearr_29533 = state_29488;
(statearr_29533[(24)] = inst_29434);

return statearr_29533;
})();
if(cljs.core.truth_(inst_29419)){
var statearr_29534_29586 = state_29488__$1;
(statearr_29534_29586[(1)] = (20));

} else {
var statearr_29535_29587 = state_29488__$1;
(statearr_29535_29587[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (11))){
var state_29488__$1 = state_29488;
var statearr_29536_29588 = state_29488__$1;
(statearr_29536_29588[(2)] = true);

(statearr_29536_29588[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (9))){
var state_29488__$1 = state_29488;
var statearr_29537_29589 = state_29488__$1;
(statearr_29537_29589[(2)] = false);

(statearr_29537_29589[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (5))){
var state_29488__$1 = state_29488;
var statearr_29538_29590 = state_29488__$1;
(statearr_29538_29590[(2)] = null);

(statearr_29538_29590[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (14))){
var inst_29397 = (state_29488[(7)]);
var inst_29414 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29397);
var state_29488__$1 = state_29488;
var statearr_29539_29591 = state_29488__$1;
(statearr_29539_29591[(2)] = inst_29414);

(statearr_29539_29591[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (26))){
var inst_29422 = (state_29488[(15)]);
var inst_29446 = grid.setColumns(inst_29422);
var inst_29447 = hatti.views.table.resizeColumns(grid);
var inst_29448 = grid.render();
var state_29488__$1 = (function (){var statearr_29540 = state_29488;
(statearr_29540[(25)] = inst_29446);

(statearr_29540[(26)] = inst_29447);

return statearr_29540;
})();
var statearr_29541_29592 = state_29488__$1;
(statearr_29541_29592[(2)] = inst_29448);

(statearr_29541_29592[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (16))){
var inst_29397 = (state_29488[(7)]);
var inst_29427 = (state_29488[(8)]);
var inst_29418 = (state_29488[(12)]);
var inst_29417 = (state_29488[(13)]);
var inst_29422 = (state_29488[(15)]);
var inst_29420 = (state_29488[(16)]);
var inst_29421 = (state_29488[(17)]);
var inst_29423 = (state_29488[(10)]);
var inst_29419 = (state_29488[(9)]);
var inst_29417__$1 = (state_29488[(2)]);
var inst_29418__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29417__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_29419__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29417__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_29420__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29417__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_29421__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29417__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_29422__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29417__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_29423__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29417__$1,cljs.core.cst$kw$re_DASH_render);
var inst_29424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29425 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_29426 = (new cljs.core.PersistentVector(null,3,(5),inst_29424,inst_29425,null));
var inst_29427__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_29426);
var inst_29428 = (function (){var e = inst_29397;
var map__29395 = inst_29417__$1;
var submission_to_rank = inst_29418__$1;
var submission_clicked = inst_29419__$1;
var submission_unclicked = inst_29420__$1;
var filter_by = inst_29421__$1;
var new_columns = inst_29422__$1;
var re_render = inst_29423__$1;
var update_data_BANG_ = inst_29427__$1;
return ((function (e,map__29395,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29397,inst_29427,inst_29418,inst_29417,inst_29422,inst_29420,inst_29421,inst_29423,inst_29419,inst_29417__$1,inst_29418__$1,inst_29419__$1,inst_29420__$1,inst_29421__$1,inst_29422__$1,inst_29423__$1,inst_29424,inst_29425,inst_29426,inst_29427__$1,state_val_29489,c__8268__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (e,map__29395,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29397,inst_29427,inst_29418,inst_29417,inst_29422,inst_29420,inst_29421,inst_29423,inst_29419,inst_29417__$1,inst_29418__$1,inst_29419__$1,inst_29420__$1,inst_29421__$1,inst_29422__$1,inst_29423__$1,inst_29424,inst_29425,inst_29426,inst_29427__$1,state_val_29489,c__8268__auto__,event_chan){
return (function (p1__29227_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__29227_SHARP_,field));
});})(e,map__29395,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29397,inst_29427,inst_29418,inst_29417,inst_29422,inst_29420,inst_29421,inst_29423,inst_29419,inst_29417__$1,inst_29418__$1,inst_29419__$1,inst_29420__$1,inst_29421__$1,inst_29422__$1,inst_29423__$1,inst_29424,inst_29425,inst_29426,inst_29427__$1,state_val_29489,c__8268__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(e,map__29395,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29397,inst_29427,inst_29418,inst_29417,inst_29422,inst_29420,inst_29421,inst_29423,inst_29419,inst_29417__$1,inst_29418__$1,inst_29419__$1,inst_29420__$1,inst_29421__$1,inst_29422__$1,inst_29423__$1,inst_29424,inst_29425,inst_29426,inst_29427__$1,state_val_29489,c__8268__auto__,event_chan))
})();
var state_29488__$1 = (function (){var statearr_29542 = state_29488;
(statearr_29542[(8)] = inst_29427__$1);

(statearr_29542[(12)] = inst_29418__$1);

(statearr_29542[(13)] = inst_29417__$1);

(statearr_29542[(14)] = inst_29428);

(statearr_29542[(15)] = inst_29422__$1);

(statearr_29542[(16)] = inst_29420__$1);

(statearr_29542[(17)] = inst_29421__$1);

(statearr_29542[(10)] = inst_29423__$1);

(statearr_29542[(9)] = inst_29419__$1);

return statearr_29542;
})();
if(cljs.core.truth_(inst_29418__$1)){
var statearr_29543_29593 = state_29488__$1;
(statearr_29543_29593[(1)] = (17));

} else {
var statearr_29544_29594 = state_29488__$1;
(statearr_29544_29594[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (30))){
var state_29488__$1 = state_29488;
var statearr_29545_29595 = state_29488__$1;
(statearr_29545_29595[(2)] = null);

(statearr_29545_29595[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (10))){
var inst_29412 = (state_29488[(2)]);
var state_29488__$1 = state_29488;
if(cljs.core.truth_(inst_29412)){
var statearr_29546_29596 = state_29488__$1;
(statearr_29546_29596[(1)] = (14));

} else {
var statearr_29547_29597 = state_29488__$1;
(statearr_29547_29597[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (18))){
var state_29488__$1 = state_29488;
var statearr_29548_29598 = state_29488__$1;
(statearr_29548_29598[(2)] = null);

(statearr_29548_29598[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29489 === (8))){
var inst_29397 = (state_29488[(7)]);
var inst_29402 = inst_29397.cljs$lang$protocol_mask$partition0$;
var inst_29403 = (inst_29402 & (64));
var inst_29404 = inst_29397.cljs$core$ISeq$;
var inst_29405 = (inst_29403) || (inst_29404);
var state_29488__$1 = state_29488;
if(cljs.core.truth_(inst_29405)){
var statearr_29549_29599 = state_29488__$1;
(statearr_29549_29599[(1)] = (11));

} else {
var statearr_29550_29600 = state_29488__$1;
(statearr_29550_29600[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8268__auto__,event_chan))
;
return ((function (switch__8247__auto__,c__8268__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8248__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8248__auto____0 = (function (){
var statearr_29554 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29554[(0)] = hatti$views$table$handle_table_events_$_state_machine__8248__auto__);

(statearr_29554[(1)] = (1));

return statearr_29554;
});
var hatti$views$table$handle_table_events_$_state_machine__8248__auto____1 = (function (state_29488){
while(true){
var ret_value__8249__auto__ = (function (){try{while(true){
var result__8250__auto__ = switch__8247__auto__(state_29488);
if(cljs.core.keyword_identical_QMARK_(result__8250__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8250__auto__;
}
break;
}
}catch (e29555){if((e29555 instanceof Object)){
var ex__8251__auto__ = e29555;
var statearr_29556_29601 = state_29488;
(statearr_29556_29601[(5)] = ex__8251__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29488);

return cljs.core.cst$kw$recur;
} else {
throw e29555;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8249__auto__,cljs.core.cst$kw$recur)){
var G__29602 = state_29488;
state_29488 = G__29602;
continue;
} else {
return ret_value__8249__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8248__auto__ = function(state_29488){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8248__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8248__auto____1.call(this,state_29488);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8248__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8248__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8248__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8248__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8248__auto__;
})()
;})(switch__8247__auto__,c__8268__auto__,event_chan))
})();
var state__8270__auto__ = (function (){var statearr_29557 = (f__8269__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8269__auto__.cljs$core$IFn$_invoke$arity$0() : f__8269__auto__.call(null));
(statearr_29557[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8268__auto__);

return statearr_29557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8270__auto__);
});})(c__8268__auto__,event_chan))
);

return c__8268__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__29613(s__29614){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__29614__$1 = s__29614;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__29614__$1);
if(temp__4425__auto__){
var s__29614__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29614__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29614__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29616 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29615 = (0);
while(true){
if((i__29615 < size__5340__auto__)){
var vec__29621 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29615);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29621,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29621,(1),null);
cljs.core.chunk_append(b__29616,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__29615,vec__29621,k,v,c__5339__auto__,size__5340__auto__,b__29616,s__29614__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__29615,vec__29621,k,v,c__5339__auto__,size__5340__auto__,b__29616,s__29614__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__29623 = (i__29615 + (1));
i__29615 = G__29623;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29616),hatti$views$table$render_options_$_iter__29613(cljs.core.chunk_rest(s__29614__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29616),null);
}
} else {
var vec__29622 = cljs.core.first(s__29614__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29622,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29622,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__29622,k,v,s__29614__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__29622,k,v,s__29614__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__29613(cljs.core.rest(s__29614__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table29625 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29625 = (function (_,owner,meta29626){
this._ = _;
this.owner = owner;
this.meta29626 = meta29626;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29625.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29627,meta29626__$1){
var self__ = this;
var _29627__$1 = this;
return (new hatti.views.table.t_hatti$views$table29625(self__._,self__.owner,meta29626__$1));
});

hatti.views.table.t_hatti$views$table29625.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29627){
var self__ = this;
var _29627__$1 = this;
return self__.meta29626;
});

hatti.views.table.t_hatti$views$table29625.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table29625.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table29625.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table29625.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__29628){
var self__ = this;
var map__29629 = p__29628;
var map__29629__$1 = ((((!((map__29629 == null)))?((((map__29629.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29629.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29629):map__29629);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29629__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29629__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__29631 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__29631__$1 = ((((!((map__29631 == null)))?((((map__29631.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29631.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29631):map__29631);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29631__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__29631,map__29631__$1,flat_form,new_language,___$2,map__29629,map__29629__$1,name_or_label,language){
return (function (p1__29624_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns(flat_form,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__29624_SHARP_),new_language)], null));
});})(options,map__29631,map__29631__$1,flat_form,new_language,___$2,map__29629,map__29629__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__29640 = {"className": "label-changer"};
var G__29641 = (function (){var G__29643 = {"className": "label-changer-label"};
var G__29644 = "Show:";
return React.DOM.span(G__29643,G__29644);
})();
var G__29642 = (function (){var G__29645 = {"id": "header-display-dropdown", "className": "drop-hover"};
var G__29646 = (function (){var attrs29635 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs29635))?sablono.interpreter.attributes(attrs29635):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs29635))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__29648 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__29648);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs29635),(function (){var G__29649 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__29649);
})()], null))));
})();
var G__29647 = (function (){var G__29650 = {"className": "submenu no-dot"};
var G__29651 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__29650,G__29651);
})();
return React.DOM.div(G__29645,G__29646,G__29647);
})();
return React.DOM.div(G__29640,G__29641,G__29642);
});

hatti.views.table.t_hatti$views$table29625.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta29626], null);
});

hatti.views.table.t_hatti$views$table29625.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29625.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29625";

hatti.views.table.t_hatti$views$table29625.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29625");
});

hatti.views.table.__GT_t_hatti$views$table29625 = (function hatti$views$table$__GT_t_hatti$views$table29625(___$1,owner__$1,meta29626){
return (new hatti.views.table.t_hatti$views$table29625(___$1,owner__$1,meta29626));
});

}

return (new hatti.views.table.t_hatti$views$table29625(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__8268__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8268__auto__,query){
return (function (){
var f__8269__auto__ = (function (){var switch__8247__auto__ = ((function (c__8268__auto__,query){
return (function (state_29694){
var state_val_29695 = (state_29694[(1)]);
if((state_val_29695 === (1))){
var inst_29680 = cljs.core.async.timeout((150));
var state_29694__$1 = state_29694;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29694__$1,(2),inst_29680);
} else {
if((state_val_29695 === (2))){
var inst_29682 = (state_29694[(2)]);
var inst_29683 = input.value;
var inst_29684 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_29683);
var state_29694__$1 = (function (){var statearr_29696 = state_29694;
(statearr_29696[(7)] = inst_29682);

return statearr_29696;
})();
if(inst_29684){
var statearr_29697_29708 = state_29694__$1;
(statearr_29697_29708[(1)] = (3));

} else {
var statearr_29698_29709 = state_29694__$1;
(statearr_29698_29709[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29695 === (3))){
var inst_29686 = [query_event_key];
var inst_29687 = [query];
var inst_29688 = cljs.core.PersistentHashMap.fromArrays(inst_29686,inst_29687);
var inst_29689 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_29688);
var state_29694__$1 = state_29694;
var statearr_29699_29710 = state_29694__$1;
(statearr_29699_29710[(2)] = inst_29689);

(statearr_29699_29710[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29695 === (4))){
var state_29694__$1 = state_29694;
var statearr_29700_29711 = state_29694__$1;
(statearr_29700_29711[(2)] = null);

(statearr_29700_29711[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29695 === (5))){
var inst_29692 = (state_29694[(2)]);
var state_29694__$1 = state_29694;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29694__$1,inst_29692);
} else {
return null;
}
}
}
}
}
});})(c__8268__auto__,query))
;
return ((function (switch__8247__auto__,c__8268__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__8248__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__8248__auto____0 = (function (){
var statearr_29704 = [null,null,null,null,null,null,null,null];
(statearr_29704[(0)] = hatti$views$table$delayed_search_$_state_machine__8248__auto__);

(statearr_29704[(1)] = (1));

return statearr_29704;
});
var hatti$views$table$delayed_search_$_state_machine__8248__auto____1 = (function (state_29694){
while(true){
var ret_value__8249__auto__ = (function (){try{while(true){
var result__8250__auto__ = switch__8247__auto__(state_29694);
if(cljs.core.keyword_identical_QMARK_(result__8250__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8250__auto__;
}
break;
}
}catch (e29705){if((e29705 instanceof Object)){
var ex__8251__auto__ = e29705;
var statearr_29706_29712 = state_29694;
(statearr_29706_29712[(5)] = ex__8251__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29694);

return cljs.core.cst$kw$recur;
} else {
throw e29705;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8249__auto__,cljs.core.cst$kw$recur)){
var G__29713 = state_29694;
state_29694 = G__29713;
continue;
} else {
return ret_value__8249__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__8248__auto__ = function(state_29694){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__8248__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__8248__auto____1.call(this,state_29694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__8248__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__8248__auto____0;
hatti$views$table$delayed_search_$_state_machine__8248__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__8248__auto____1;
return hatti$views$table$delayed_search_$_state_machine__8248__auto__;
})()
;})(switch__8247__auto__,c__8268__auto__,query))
})();
var state__8270__auto__ = (function (){var statearr_29707 = (f__8269__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8269__auto__.cljs$core$IFn$_invoke$arity$0() : f__8269__auto__.call(null));
(statearr_29707[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8268__auto__);

return statearr_29707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8270__auto__);
});})(c__8268__auto__,query))
);

return c__8268__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table29715 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29715 = (function (_,owner,meta29716){
this._ = _;
this.owner = owner;
this.meta29716 = meta29716;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29715.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29717,meta29716__$1){
var self__ = this;
var _29717__$1 = this;
return (new hatti.views.table.t_hatti$views$table29715(self__._,self__.owner,meta29716__$1));
});

hatti.views.table.t_hatti$views$table29715.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29717){
var self__ = this;
var _29717__$1 = this;
return self__.meta29716;
});

hatti.views.table.t_hatti$views$table29715.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table29715.prototype.om$core$IRender$render$arity$1 = (function (this__6323__auto__){
var self__ = this;
var this__6323__auto____$1 = this;
var G__29720 = {"className": "table-search"};
var G__29721 = (function (){var G__29723 = {"className": "fa fa-search"};
return React.DOM.i(G__29723);
})();
var G__29722 = (function (){var G__29724 = {"type": "text", "placeholder": "Search", "onChange": ((function (G__29720,G__29721,this__6323__auto____$1){
return (function (p1__29714_SHARP_){
return hatti.views.table.delayed_search(p1__29714_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__29720,G__29721,this__6323__auto____$1))
};
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__29724) : sablono.interpreter.input.call(null,G__29724));
})();
return React.DOM.div(G__29720,G__29721,G__29722);
});

hatti.views.table.t_hatti$views$table29715.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta29716], null);
});

hatti.views.table.t_hatti$views$table29715.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29715.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29715";

hatti.views.table.t_hatti$views$table29715.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29715");
});

hatti.views.table.__GT_t_hatti$views$table29715 = (function hatti$views$table$__GT_t_hatti$views$table29715(___$1,owner__$1,meta29716){
return (new hatti.views.table.t_hatti$views$table29715(___$1,owner__$1,meta29716));
});

}

return (new hatti.views.table.t_hatti$views$table29715(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table29725 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29725 = (function (app_state,owner,meta29726){
this.app_state = app_state;
this.owner = owner;
this.meta29726 = meta29726;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29725.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29727,meta29726__$1){
var self__ = this;
var _29727__$1 = this;
return (new hatti.views.table.t_hatti$views$table29725(self__.app_state,self__.owner,meta29726__$1));
});

hatti.views.table.t_hatti$views$table29725.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29727){
var self__ = this;
var _29727__$1 = this;
return self__.meta29726;
});

hatti.views.table.t_hatti$views$table29725.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table29725.prototype.om$core$IRender$render$arity$1 = (function (this__6323__auto__){
var self__ = this;
var this__6323__auto____$1 = this;
var G__29730 = {"className": "topbar"};
var G__29731 = (function (){var G__29735 = {"id": hatti.views.table.pager_id};
return React.DOM.div(G__29735);
})();
var G__29732 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,null));
var G__29733 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.app_state));
var G__29734 = (function (){var G__29736 = {"style": {"clear": "both"}};
return React.DOM.div(G__29736);
})();
return React.DOM.div(G__29730,G__29731,G__29732,G__29733,G__29734);
});

hatti.views.table.t_hatti$views$table29725.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta29726], null);
});

hatti.views.table.t_hatti$views$table29725.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29725.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29725";

hatti.views.table.t_hatti$views$table29725.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29725");
});

hatti.views.table.__GT_t_hatti$views$table29725 = (function hatti$views$table$__GT_t_hatti$views$table29725(app_state__$1,owner__$1,meta29726){
return (new hatti.views.table.t_hatti$views$table29725(app_state__$1,owner__$1,meta29726));
});

}

return (new hatti.views.table.t_hatti$views$table29725(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq(data)){
var map__29740 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__29740__$1 = ((((!((map__29740 == null)))?((((map__29740.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29740.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29740):map__29740);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29740__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29740__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__29741 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29741,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29741,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,p__29744){
var map__29745 = p__29744;
var map__29745__$1 = ((((!((map__29745 == null)))?((((map__29745.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29745.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29745):map__29745);
var opts = map__29745__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29745__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

if(typeof hatti.views.table.t_hatti$views$table29747 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29747 = (function (app_state,owner,p__29744,map__29745,opts,slick_grid_event_handlers,meta29748){
this.app_state = app_state;
this.owner = owner;
this.p__29744 = p__29744;
this.map__29745 = map__29745;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta29748 = meta29748;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29747.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__29745,map__29745__$1,opts,slick_grid_event_handlers){
return (function (_29749,meta29748__$1){
var self__ = this;
var _29749__$1 = this;
return (new hatti.views.table.t_hatti$views$table29747(self__.app_state,self__.owner,self__.p__29744,self__.map__29745,self__.opts,self__.slick_grid_event_handlers,meta29748__$1));
});})(map__29745,map__29745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29747.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__29745,map__29745__$1,opts,slick_grid_event_handlers){
return (function (_29749){
var self__ = this;
var _29749__$1 = this;
return self__.meta29748;
});})(map__29745,map__29745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29747.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table29747.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__29745,map__29745__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null)));
var map__29750 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__29750__$1 = ((((!((map__29750 == null)))?((((map__29750.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29750.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29750):map__29750);
var dataset_info = map__29750__$1;
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29750__$1,cljs.core.cst$kw$num_of_submissions);
var with_info = ((function (no_data_QMARK_,map__29750,map__29750__$1,dataset_info,num_of_submissions,___$2,map__29745,map__29745__$1,opts,slick_grid_event_handlers){
return (function (p1__29743_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__29743_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dataset_DASH_info,dataset_info], null)], 0));
});})(no_data_QMARK_,map__29750,map__29750__$1,dataset_info,num_of_submissions,___$2,map__29745,map__29745__$1,opts,slick_grid_event_handlers))
;
var attrs29752 = om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked], null))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs29752))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs29752], 0))):{"className": "table-view"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs29752))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__29753 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__29754 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__29759 = {"className": "empty-state"};
var G__29760 = "No data";
return React.DOM.span(G__29759,G__29760);
})():(function (){var G__29762 = null;
var G__29763 = (function (){var G__29765 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__29765);
})();
var G__29764 = "Loading...";
return React.DOM.span(G__29762,G__29763,G__29764);
})());
return React.DOM.div(G__29753,G__29754);
})()], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs29752),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__29766 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__29767 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__29772 = {"className": "empty-state"};
var G__29773 = "No data";
return React.DOM.span(G__29772,G__29773);
})():(function (){var G__29775 = null;
var G__29776 = (function (){var G__29778 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__29778);
})();
var G__29777 = "Loading...";
return React.DOM.span(G__29775,G__29776,G__29777);
})());
return React.DOM.div(G__29766,G__29767);
})()], null))));
});})(map__29745,map__29745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29747.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table29747.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__29745,map__29745__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__29779 = temp__4425__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29779,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29779,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__29745,map__29745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29747.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table29747.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__29745,map__29745__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__29780 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__29780__$1 = ((((!((map__29780 == null)))?((((map__29780.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29780.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29780):map__29780);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29780__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29780__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__29782 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29782,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29782,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__29745,map__29745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29747.getBasis = ((function (map__29745,map__29745__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__29744,cljs.core.cst$sym$map__29745,cljs.core.cst$sym$opts,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$meta29748], null);
});})(map__29745,map__29745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29747.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29747.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29747";

hatti.views.table.t_hatti$views$table29747.cljs$lang$ctorPrWriter = ((function (map__29745,map__29745__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29747");
});})(map__29745,map__29745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table29747 = ((function (map__29745,map__29745__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table29747(app_state__$1,owner__$1,p__29744__$1,map__29745__$2,opts__$1,slick_grid_event_handlers__$1,meta29748){
return (new hatti.views.table.t_hatti$views$table29747(app_state__$1,owner__$1,p__29744__$1,map__29745__$2,opts__$1,slick_grid_event_handlers__$1,meta29748));
});})(map__29745,map__29745__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table29747(app_state,owner,p__29744,map__29745__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
