// Compiled by ClojureScript 1.7.145 {}
goog.provide('cljs_time.internal.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.format');
cljs_time.internal.core._EQ_ = (function cljs_time$internal$core$_EQ_(var_args){
var args__5645__auto__ = [];
var len__5638__auto___12576 = arguments.length;
var i__5639__auto___12577 = (0);
while(true){
if((i__5639__auto___12577 < len__5638__auto___12576)){
args__5645__auto__.push((arguments[i__5639__auto___12577]));

var G__12578 = (i__5639__auto___12577 + (1));
i__5639__auto___12577 = G__12578;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((0) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((0)),(0))):null);
return cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5646__auto__);
});

cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core.every_QMARK_.call(null,(function (p1__12573_SHARP_){
return (p1__12573_SHARP_ instanceof goog.date.Date);
}),args)){
return cljs.core.apply.call(null,cljs.core._EQ_,cljs.core.map.call(null,(function (p1__12574_SHARP_){
return p1__12574_SHARP_.getTime();
}),args));
} else {
return cljs.core.apply.call(null,cljs.core._EQ_,args);

}
});

cljs_time.internal.core._EQ_.cljs$lang$maxFixedArity = (0);

cljs_time.internal.core._EQ_.cljs$lang$applyTo = (function (seq12575){
return cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq12575));
});
cljs_time.internal.core.leap_year_QMARK_ = (function cljs_time$internal$core$leap_year_QMARK_(y){
if((cljs.core.mod.call(null,y,(400)) === (0))){
return true;
} else {
if((cljs.core.mod.call(null,y,(100)) === (0))){
return false;
} else {
if((cljs.core.mod.call(null,y,(4)) === (0))){
return true;
} else {
return false;

}
}
}
});
cljs_time.internal.core.days_in_month = new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [(31),(28),(31),(30),(31),(30),(31),(31),(30),(31),(30),(31)], null);
cljs_time.internal.core.year_corrected_dim = (function cljs_time$internal$core$year_corrected_dim(year,month){
var G__12580 = cljs_time.internal.core.days_in_month.call(null,(cljs.core.truth_(cljs_time.internal.core._EQ_.call(null,month,(1)))?(11):(month - (1))));
if(cljs.core.truth_((function (){var and__4568__auto__ = cljs_time.internal.core.leap_year_QMARK_.call(null,year);
if(cljs.core.truth_(and__4568__auto__)){
return cljs_time.internal.core._EQ_.call(null,month,(2));
} else {
return and__4568__auto__;
}
})())){
return (G__12580 + (1));
} else {
return G__12580;
}
});
cljs_time.internal.core.valid_date_QMARK_ = (function cljs_time$internal$core$valid_date_QMARK_(p__12581){
var map__12584 = p__12581;
var map__12584__$1 = ((((!((map__12584 == null)))?((((map__12584.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12584.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12584):map__12584);
var d = map__12584__$1;
var years = cljs.core.get.call(null,map__12584__$1,new cljs.core.Keyword(null,"years","years",-1298579689));
var months = cljs.core.get.call(null,map__12584__$1,new cljs.core.Keyword(null,"months","months",-45571637));
var days = cljs.core.get.call(null,map__12584__$1,new cljs.core.Keyword(null,"days","days",-1394072564));
var hours = cljs.core.get.call(null,map__12584__$1,new cljs.core.Keyword(null,"hours","hours",58380855));
var minutes = cljs.core.get.call(null,map__12584__$1,new cljs.core.Keyword(null,"minutes","minutes",1319166394));
var seconds = cljs.core.get.call(null,map__12584__$1,new cljs.core.Keyword(null,"seconds","seconds",-445266194));
var millis = cljs.core.get.call(null,map__12584__$1,new cljs.core.Keyword(null,"millis","millis",-1338288387));
var months__$1 = (months + (1));
var _GT__LT_ = ((function (months__$1,map__12584,map__12584__$1,d,years,months,days,hours,minutes,seconds,millis){
return (function cljs_time$internal$core$valid_date_QMARK__$__GT__LT_(a,b,x){
return ((x >= a)) && ((x <= b));
});})(months__$1,map__12584,map__12584__$1,d,years,months,days,hours,minutes,seconds,millis))
;
if(cljs.core.truth_((function (){var and__4568__auto__ = years;
if(cljs.core.truth_(and__4568__auto__)){
var and__4568__auto____$1 = _GT__LT_.call(null,(1),(12),months__$1);
if(cljs.core.truth_(and__4568__auto____$1)){
var and__4568__auto____$2 = _GT__LT_.call(null,(1),cljs_time.internal.core.year_corrected_dim.call(null,years,months__$1),days);
if(cljs.core.truth_(and__4568__auto____$2)){
var and__4568__auto____$3 = _GT__LT_.call(null,(0),(23),hours);
if(cljs.core.truth_(and__4568__auto____$3)){
var and__4568__auto____$4 = _GT__LT_.call(null,(0),(59),minutes);
if(cljs.core.truth_(and__4568__auto____$4)){
var and__4568__auto____$5 = _GT__LT_.call(null,(0),(60),seconds);
if(cljs.core.truth_(and__4568__auto____$5)){
return _GT__LT_.call(null,(0),(999),millis);
} else {
return and__4568__auto____$5;
}
} else {
return and__4568__auto____$4;
}
} else {
return and__4568__auto____$3;
}
} else {
return and__4568__auto____$2;
}
} else {
return and__4568__auto____$1;
}
} else {
return and__4568__auto__;
}
})())){
return d;
} else {
throw cljs.core.ex_info.call(null,"Date is not valid",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"invalid-date","invalid-date",2030506573),new cljs.core.Keyword(null,"date","date",-1463434462),d], null));
}
});
cljs_time.internal.core.index_of = (function cljs_time$internal$core$index_of(coll,x){
return cljs.core.first.call(null,cljs.core.keep_indexed.call(null,(function (p1__12587_SHARP_,p2__12586_SHARP_){
if(cljs.core.truth_(cljs_time.internal.core._EQ_.call(null,p2__12586_SHARP_,x))){
return p1__12587_SHARP_;
} else {
return null;
}
}),coll));
});
cljs_time.internal.core.period = (function cljs_time$internal$core$period(var_args){
var args12588 = [];
var len__5638__auto___12594 = arguments.length;
var i__5639__auto___12595 = (0);
while(true){
if((i__5639__auto___12595 < len__5638__auto___12594)){
args12588.push((arguments[i__5639__auto___12595]));

var G__12596 = (i__5639__auto___12595 + (1));
i__5639__auto___12595 = G__12596;
continue;
} else {
}
break;
}

var G__12593 = args12588.length;
switch (G__12593) {
case 2:
return cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5657__auto__ = (new cljs.core.IndexedSeq(args12588.slice((2)),(0)));
return cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5657__auto__);

}
});

cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$2 = (function (period,value){
return cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.fromArray([period,value], true, false),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("cljs-time.core","period","cljs-time.core/period",1354080486)], null));
});

cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$variadic = (function (p1,v1,kvs){
return cljs.core.apply.call(null,cljs.core.assoc,cljs_time.internal.core.period.call(null,p1,v1),kvs);
});

cljs_time.internal.core.period.cljs$lang$applyTo = (function (seq12589){
var G__12590 = cljs.core.first.call(null,seq12589);
var seq12589__$1 = cljs.core.next.call(null,seq12589);
var G__12591 = cljs.core.first.call(null,seq12589__$1);
var seq12589__$2 = cljs.core.next.call(null,seq12589__$1);
return cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$variadic(G__12590,G__12591,seq12589__$2);
});

cljs_time.internal.core.period.cljs$lang$maxFixedArity = (2);
/**
 * Formats a string using goog.string.format.
 */
cljs_time.internal.core.format = (function cljs_time$internal$core$format(var_args){
var args__5645__auto__ = [];
var len__5638__auto___12600 = arguments.length;
var i__5639__auto___12601 = (0);
while(true){
if((i__5639__auto___12601 < len__5638__auto___12600)){
args__5645__auto__.push((arguments[i__5639__auto___12601]));

var G__12602 = (i__5639__auto___12601 + (1));
i__5639__auto___12601 = G__12602;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((1) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((1)),(0))):null);
return cljs_time.internal.core.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5646__auto__);
});

cljs_time.internal.core.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
var args__$1 = cljs.core.map.call(null,(function (x){
if(((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol))){
return [cljs.core.str(x)].join('');
} else {
return x;
}
}),args);
return cljs.core.apply.call(null,goog.string.format,fmt,args__$1);
});

cljs_time.internal.core.format.cljs$lang$maxFixedArity = (1);

cljs_time.internal.core.format.cljs$lang$applyTo = (function (seq12598){
var G__12599 = cljs.core.first.call(null,seq12598);
var seq12598__$1 = cljs.core.next.call(null,seq12598);
return cljs_time.internal.core.format.cljs$core$IFn$_invoke$arity$variadic(G__12599,seq12598__$1);
});
/**
 * Remove the need to pull in gstring/format code in advanced compilation
 */
cljs_time.internal.core.zero_pad = (function cljs_time$internal$core$zero_pad(var_args){
var args12603 = [];
var len__5638__auto___12606 = arguments.length;
var i__5639__auto___12607 = (0);
while(true){
if((i__5639__auto___12607 < len__5638__auto___12606)){
args12603.push((arguments[i__5639__auto___12607]));

var G__12608 = (i__5639__auto___12607 + (1));
i__5639__auto___12607 = G__12608;
continue;
} else {
}
break;
}

var G__12605 = args12603.length;
switch (G__12605) {
case 1:
return cljs_time.internal.core.zero_pad.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.core.zero_pad.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12603.length)].join('')));

}
});

cljs_time.internal.core.zero_pad.cljs$core$IFn$_invoke$arity$1 = (function (n){
if((((0) <= n)) && ((n <= (9)))){
return [cljs.core.str("0"),cljs.core.str(n)].join('');
} else {
return [cljs.core.str(n)].join('');
}
});

cljs_time.internal.core.zero_pad.cljs$core$IFn$_invoke$arity$2 = (function (n,zeros){
if(((1) > zeros)){
return [cljs.core.str(n)].join('');
} else {
return [cljs.core.str(clojure.string.join.call(null,cljs.core.take.call(null,(zeros - cljs.core.count.call(null,[cljs.core.str(n)].join(''))),cljs.core.repeat.call(null,"0")))),cljs.core.str(n)].join('');
}
});

cljs_time.internal.core.zero_pad.cljs$lang$maxFixedArity = 2;
