// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('inflections.core');
goog.require('sablono.core');
/**
 * Convert json to js using JSON.parse
 */
hatti.utils.json__GT_js = (function hatti$utils$json__GT_js(s){
return JSON.parse(s);
});
/**
 * Given a seq, produces a two-el seq. [a b c] => [[0 a] [1 b] [2 c]].
 */
hatti.utils.indexed = (function hatti$utils$indexed(coll){
return cljs.core.map_indexed.call(null,cljs.core.vector,coll);
});
/**
 * Helper function to create a click function that prevents default
 */
hatti.utils.click_fn = (function hatti$utils$click_fn(f){
return (function (event){
event.preventDefault();

return f.call(null);
});
});
/**
 * Create an appropriately pluralized string prefix by number.
 */
hatti.utils.pluralize_number = (function hatti$utils$pluralize_number(number,kind){
return clojure.string.join.call(null," ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [number,((cljs.core._EQ_.call(null,(1),number))?kind:inflections.core.plural.call(null,kind))], null));
});
/**
 * True if substring is a substring of string
 */
hatti.utils.substring_QMARK_ = (function hatti$utils$substring_QMARK_(var_args){
var args7027 = [];
var len__5638__auto___7036 = arguments.length;
var i__5639__auto___7037 = (0);
while(true){
if((i__5639__auto___7037 < len__5638__auto___7036)){
args7027.push((arguments[i__5639__auto___7037]));

var G__7038 = (i__5639__auto___7037 + (1));
i__5639__auto___7037 = G__7038;
continue;
} else {
}
break;
}

var G__7032 = args7027.length;
switch (G__7032) {
case 2:
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5657__auto__ = (new cljs.core.IndexedSeq(args7027.slice((2)),(0)));
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5657__auto__);

}
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (substring,string){
return cljs.core.complement.call(null,cljs.core.nil_QMARK_).call(null,cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,substring),string));
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,string,p__7033){
var map__7034 = p__7033;
var map__7034__$1 = ((((!((map__7034 == null)))?((((map__7034.cljs$lang$protocol_mask$partition0$ & (64))) || (map__7034.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7034):map__7034);
var case_sensitive_QMARK_ = cljs.core.get.call(null,map__7034__$1,new cljs.core.Keyword(null,"case-sensitive?","case-sensitive?",-2133754107));
if(cljs.core.truth_(case_sensitive_QMARK_)){
return hatti.utils.substring_QMARK_.call(null,substring,string);
} else {
return hatti.utils.substring_QMARK_.call(null,clojure.string.lower_case.call(null,substring),clojure.string.lower_case.call(null,string));
}
});

hatti.utils.substring_QMARK_.cljs$lang$applyTo = (function (seq7028){
var G__7029 = cljs.core.first.call(null,seq7028);
var seq7028__$1 = cljs.core.next.call(null,seq7028);
var G__7030 = cljs.core.first.call(null,seq7028__$1);
var seq7028__$2 = cljs.core.next.call(null,seq7028__$1);
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__7029,G__7030,seq7028__$2);
});

hatti.utils.substring_QMARK_.cljs$lang$maxFixedArity = (2);
hatti.utils.hyphen__GT_camel_case = (function hatti$utils$hyphen__GT_camel_case(source_string){
return clojure.string.replace.call(null,source_string,/(-)(.)/,(function (p1__7040_SHARP_){
var vec__7042 = p1__7040_SHARP_;
var _ = cljs.core.nth.call(null,vec__7042,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__7042,(1),null);
var letter_to_uppercase = cljs.core.nth.call(null,vec__7042,(2),null);
return clojure.string.upper_case.call(null,letter_to_uppercase);
}));
});
hatti.utils.generate_component = (function hatti$utils$generate_component(element_definition_vector){
return sablono.interpreter.interpret.call(null,element_definition_vector);
});
/**
 * This function generates HTML from hiccup-style vectors, and concatenates
 *   the resulting markup. Strings are returned unaffected.
 */
hatti.utils.generate_html = (function hatti$utils$generate_html(var_args){
var args__5645__auto__ = [];
var len__5638__auto___7044 = arguments.length;
var i__5639__auto___7045 = (0);
while(true){
if((i__5639__auto___7045 < len__5638__auto___7044)){
args__5645__auto__.push((arguments[i__5639__auto___7045]));

var G__7046 = (i__5639__auto___7045 + (1));
i__5639__auto___7045 = G__7046;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((0) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((0)),(0))):null);
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(argseq__5646__auto__);
});

hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic = (function (element_definition_vectors){
var components = cljs.core.map.call(null,hatti.utils.generate_component,element_definition_vectors);
var components_as_static_markup = cljs.core.map.call(null,((function (components){
return (function (component){
if(typeof component === 'string'){
return component;
} else {
return sablono.core.render_static.call(null,component);
}
});})(components))
,components);
return clojure.string.join.call(null,components_as_static_markup);
});

hatti.utils.generate_html.cljs$lang$maxFixedArity = (0);

hatti.utils.generate_html.cljs$lang$applyTo = (function (seq7043){
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq7043));
});
