// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._id,new cljs.core.Keyword(null,"label","label",1718410804),"id",new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._id,new cljs.core.Keyword(null,"type","type",1174270348),"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.call(null,extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5645__auto__ = [];
var len__5638__auto___10830 = arguments.length;
var i__5639__auto___10831 = (0);
while(true){
if((i__5639__auto___10831 < len__5638__auto___10830)){
args__5645__auto__.push((arguments[i__5639__auto___10831]));

var G__10832 = (i__5639__auto___10831 + (1));
i__5639__auto___10831 = G__10832;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((1) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5646__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__10827){
var map__10828 = p__10827;
var map__10828__$1 = ((((!((map__10828 == null)))?((((map__10828.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10828.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10828):map__10828);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__10828__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,hatti.views.table.get_extra_fields.call(null,is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),cljs.core.not.call(null,is_filtered_dataview_QMARK_)))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq10825){
var G__10826 = cljs.core.first.call(null,seq10825);
var seq10825__$1 = cljs.core.next.call(null,seq10825);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__10826,seq10825__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__10833_SHARP_){
if(typeof p1__10833_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__10833_SHARP_);
} else {
return p1__10833_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__10837){
var vec__10838 = p__10837;
var fname = cljs.core.nth.call(null,vec__10838,(0),null);
var answer = cljs.core.nth.call(null,vec__10838,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__10834_SHARP_){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),[cljs.core.str(p1__10834_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,clj_value,language,true);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__10839 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__10839__$1 = ((((!((map__10839 == null)))?((((map__10839.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10839.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10839):map__10839);
var owner__$1 = cljs.core.get.call(null,map__10839__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__10839__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__10839__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = chimera.urls.last_url_param.call(null,owner__$1);
var project_id = chimera.urls.last_url_param.call(null,project);
var edit_link = chimera.urls.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info.right","span.tip-info.right",-1208244295),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-clone","i.fa.fa-clone",1946695810),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info.right","span.tip-info.right",-1208244295),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil-square-o","i.fa.fa-pencil-square-o",1550650091)], null)], null)], null)], null):null));
});
}));
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],["record-actions header",(70),"",hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args10841 = [];
var len__5638__auto___10863 = arguments.length;
var i__5639__auto___10864 = (0);
while(true){
if((i__5639__auto___10864 < len__5638__auto___10863)){
args10841.push((arguments[i__5639__auto___10864]));

var G__10865 = (i__5639__auto___10864 + (1));
i__5639__auto___10864 = G__10865;
continue;
} else {
}
break;
}

var G__10847 = args10841.length;
switch (G__10847) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5657__auto__ = (new cljs.core.IndexedSeq(args10841.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5657__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__10848){
var map__10849 = p__10848;
var map__10849__$1 = ((((!((map__10849 == null)))?((((map__10849.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10849.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10849):map__10849);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__10849__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var owner = cljs.core.get.call(null,map__10849__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var columns = (function (){var iter__5352__auto__ = ((function (map__10849,map__10849__$1,is_filtered_dataview_QMARK_,owner){
return (function hatti$views$table$iter__10851(s__10852){
return (new cljs.core.LazySeq(null,((function (map__10849,map__10849__$1,is_filtered_dataview_QMARK_,owner){
return (function (){
var s__10852__$1 = s__10852;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__10852__$1);
if(temp__4657__auto__){
var s__10852__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__10852__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__10852__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__10854 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__10853 = (0);
while(true){
if((i__10853 < size__5351__auto__)){
var field = cljs.core._nth.call(null,c__5350__auto__,i__10853);
cljs.core.chunk_append.call(null,b__10854,(function (){var map__10859 = field;
var map__10859__$1 = ((((!((map__10859 == null)))?((((map__10859.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10859.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10859):map__10859);
var name = cljs.core.get.call(null,map__10859__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__10859__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__10859__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})());

var G__10867 = (i__10853 + (1));
i__10853 = G__10867;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10854),hatti$views$table$iter__10851.call(null,cljs.core.chunk_rest.call(null,s__10852__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10854),null);
}
} else {
var field = cljs.core.first.call(null,s__10852__$2);
return cljs.core.cons.call(null,(function (){var map__10861 = field;
var map__10861__$1 = ((((!((map__10861 == null)))?((((map__10861.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10861.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10861):map__10861);
var name = cljs.core.get.call(null,map__10861__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__10861__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__10861__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})(),hatti$views$table$iter__10851.call(null,cljs.core.rest.call(null,s__10852__$2)));
}
} else {
return null;
}
break;
}
});})(map__10849,map__10849__$1,is_filtered_dataview_QMARK_,owner))
,null,null));
});})(map__10849,map__10849__$1,is_filtered_dataview_QMARK_,owner))
;
return iter__5352__auto__.call(null,hatti.views.table.all_fields.call(null,form,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_));
})();
return cljs.core.clj__GT_js.call(null,cljs.core.conj.call(null,columns,hatti.views.table.actions_column.call(null,owner)));
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq10842){
var G__10843 = cljs.core.first.call(null,seq10842);
var seq10842__$1 = cljs.core.next.call(null,seq10842);
var G__10844 = cljs.core.first.call(null,seq10842__$1);
var seq10842__$2 = cljs.core.next.call(null,seq10842__$1);
var G__10845 = cljs.core.first.call(null,seq10842__$2);
var seq10842__$3 = cljs.core.next.call(null,seq10842__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__10843,G__10844,G__10845,seq10842__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false};
/**
 * Fixes the first column on slick table on horizontal scroll
 */
hatti.views.table.freeze_action_column_BANG_ = (function hatti$views$table$freeze_action_column_BANG_(){
var actions = document.getElementsByClassName("record-actions");
var sg_viewport = cljs.core.first.call(null,document.getElementsByClassName("slick-viewport"));
var seq__10873 = cljs.core.seq.call(null,actions);
var chunk__10874 = null;
var count__10875 = (0);
var i__10876 = (0);
while(true){
if((i__10876 < count__10875)){
var action = cljs.core._nth.call(null,chunk__10874,i__10876);
var leftOffset_10877 = parseInt(action.offsetLeft);
sg_viewport.addEventListener("scroll",((function (seq__10873,chunk__10874,count__10875,i__10876,leftOffset_10877,action,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__10873,chunk__10874,count__10875,i__10876,sl,leftOffset_10877,action,actions,sg_viewport){
return (function (p1__10868_SHARP_){
return action.style.borderRight = p1__10868_SHARP_;
});})(seq__10873,chunk__10874,count__10875,i__10876,sl,leftOffset_10877,action,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_.call(null,"1px dotted #ededed");
} else {
set_border_BANG_.call(null,"1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_10877)),cljs.core.str("px")].join('');
});})(seq__10873,chunk__10874,count__10875,i__10876,leftOffset_10877,action,actions,sg_viewport))
);

var G__10878 = seq__10873;
var G__10879 = chunk__10874;
var G__10880 = count__10875;
var G__10881 = (i__10876 + (1));
seq__10873 = G__10878;
chunk__10874 = G__10879;
count__10875 = G__10880;
i__10876 = G__10881;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__10873);
if(temp__4657__auto__){
var seq__10873__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10873__$1)){
var c__5383__auto__ = cljs.core.chunk_first.call(null,seq__10873__$1);
var G__10882 = cljs.core.chunk_rest.call(null,seq__10873__$1);
var G__10883 = c__5383__auto__;
var G__10884 = cljs.core.count.call(null,c__5383__auto__);
var G__10885 = (0);
seq__10873 = G__10882;
chunk__10874 = G__10883;
count__10875 = G__10884;
i__10876 = G__10885;
continue;
} else {
var action = cljs.core.first.call(null,seq__10873__$1);
var leftOffset_10886 = parseInt(action.offsetLeft);
sg_viewport.addEventListener("scroll",((function (seq__10873,chunk__10874,count__10875,i__10876,leftOffset_10886,action,seq__10873__$1,temp__4657__auto__,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__10873,chunk__10874,count__10875,i__10876,sl,leftOffset_10886,action,seq__10873__$1,temp__4657__auto__,actions,sg_viewport){
return (function (p1__10868_SHARP_){
return action.style.borderRight = p1__10868_SHARP_;
});})(seq__10873,chunk__10874,count__10875,i__10876,sl,leftOffset_10886,action,seq__10873__$1,temp__4657__auto__,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_.call(null,"1px dotted #ededed");
} else {
set_border_BANG_.call(null,"1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_10886)),cljs.core.str("px")].join('');
});})(seq__10873,chunk__10874,count__10875,i__10876,leftOffset_10886,action,seq__10873__$1,temp__4657__auto__,actions,sg_viewport))
);

var G__10887 = cljs.core.next.call(null,seq__10873__$1);
var G__10888 = null;
var G__10889 = (0);
var G__10890 = (0);
seq__10873 = G__10887;
chunk__10874 = G__10888;
count__10875 = G__10889;
i__10876 = G__10890;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5352__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__10899(s__10900){
return (new cljs.core.LazySeq(null,(function (){
var s__10900__$1 = s__10900;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__10900__$1);
if(temp__4657__auto__){
var s__10900__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__10900__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__10900__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__10902 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__10901 = (0);
while(true){
if((i__10901 < size__5351__auto__)){
var vec__10905 = cljs.core._nth.call(null,c__5350__auto__,i__10901);
var handler_key = cljs.core.nth.call(null,vec__10905,(0),null);
var handler_function = cljs.core.nth.call(null,vec__10905,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__10902,event.subscribe(handler_function));

var G__10907 = (i__10901 + (1));
i__10901 = G__10907;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10902),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__10899.call(null,cljs.core.chunk_rest.call(null,s__10900__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10902),null);
}
} else {
var vec__10906 = cljs.core.first.call(null,s__10900__$2);
var handler_key = cljs.core.nth.call(null,vec__10906,(0),null);
var handler_function = cljs.core.nth.call(null,vec__10906,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__10899.call(null,cljs.core.rest.call(null,s__10900__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5352__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5352__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__10916(s__10917){
return (new cljs.core.LazySeq(null,(function (){
var s__10917__$1 = s__10917;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__10917__$1);
if(temp__4657__auto__){
var s__10917__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__10917__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__10917__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__10919 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__10918 = (0);
while(true){
if((i__10918 < size__5351__auto__)){
var vec__10922 = cljs.core._nth.call(null,c__5350__auto__,i__10918);
var handler_key = cljs.core.nth.call(null,vec__10922,(0),null);
var handler_function = cljs.core.nth.call(null,vec__10922,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__10919,event.subscribe(handler_function));

var G__10924 = (i__10918 + (1));
i__10918 = G__10924;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10919),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__10916.call(null,cljs.core.chunk_rest.call(null,s__10917__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10919),null);
}
} else {
var vec__10923 = cljs.core.first.call(null,s__10917__$2);
var handler_key = cljs.core.nth.call(null,vec__10923,(0),null);
var handler_function = cljs.core.nth.call(null,vec__10923,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__10916.call(null,cljs.core.rest.call(null,s__10917__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5352__auto__.call(null,event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__10925){
var map__10934 = p__10925;
var map__10934__$1 = ((((!((map__10934 == null)))?((((map__10934.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10934.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10934):map__10934);
var grid_event_handlers = cljs.core.get.call(null,map__10934__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__10934__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,true,current_language,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__10936 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__10936__$1 = ((((!((map__10936 == null)))?((((map__10936.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10936.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10936):map__10936);
var map__10937 = cljs.core.get.call(null,map__10936__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__10937__$1 = ((((!((map__10937 == null)))?((((map__10937.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10937.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10937):map__10937);
var map__10938 = cljs.core.get.call(null,map__10937__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__10938__$1 = ((((!((map__10938 == null)))?((((map__10938.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10938.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10938):map__10938);
var num_displayed_records = cljs.core.get.call(null,map__10938__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__10938__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__10936,map__10936__$1,map__10937,map__10937__$1,map__10938,map__10938__$1,num_displayed_records,total_page_count,map__10934,map__10934__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__10936,map__10936__$1,map__10937,map__10937__$1,map__10938,map__10938__$1,num_displayed_records,total_page_count,map__10934,map__10934__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__10936,map__10936__$1,map__10937,map__10937__$1,map__10938,map__10938__$1,num_displayed_records,total_page_count,map__10934,map__10934__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__10936,map__10936__$1,map__10937,map__10937__$1,map__10938,map__10938__$1,num_displayed_records,total_page_count,map__10934,map__10934__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__10936,map__10936__$1,map__10937,map__10937__$1,map__10938,map__10938__$1,num_displayed_records,total_page_count,map__10934,map__10934__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__10936,map__10936__$1,map__10937,map__10937__$1,map__10938,map__10938__$1,num_displayed_records,total_page_count,map__10934,map__10934__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__10936,map__10936__$1,map__10937,map__10937__$1,map__10938,map__10938__$1,num_displayed_records,total_page_count,map__10934,map__10934__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
});})(columns,SlickGrid,DataView,dataview,grid,map__10936,map__10936__$1,map__10937,map__10937__$1,map__10938,map__10938__$1,num_displayed_records,total_page_count,map__10934,map__10934__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4580__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4580__auto__)){
return or__4580__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__8287__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto__,event_chan){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto__,event_chan){
return (function (state_11203){
var state_val_11204 = (state_11203[(1)]);
if((state_val_11204 === (7))){
var inst_11112 = (state_11203[(7)]);
var inst_11112__$1 = (state_11203[(2)]);
var inst_11114 = (inst_11112__$1 == null);
var inst_11115 = cljs.core.not.call(null,inst_11114);
var state_11203__$1 = (function (){var statearr_11205 = state_11203;
(statearr_11205[(7)] = inst_11112__$1);

return statearr_11205;
})();
if(inst_11115){
var statearr_11206_11273 = state_11203__$1;
(statearr_11206_11273[(1)] = (8));

} else {
var statearr_11207_11274 = state_11203__$1;
(statearr_11207_11274[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (20))){
var inst_11134 = (state_11203[(8)]);
var inst_11142 = (state_11203[(9)]);
var inst_11151 = inst_11142.call(null,inst_11134);
var state_11203__$1 = state_11203;
var statearr_11208_11275 = state_11203__$1;
(statearr_11208_11275[(2)] = inst_11151);

(statearr_11208_11275[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (27))){
var state_11203__$1 = state_11203;
var statearr_11209_11276 = state_11203__$1;
(statearr_11209_11276[(2)] = null);

(statearr_11209_11276[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (1))){
var state_11203__$1 = state_11203;
var statearr_11210_11277 = state_11203__$1;
(statearr_11210_11277[(2)] = null);

(statearr_11210_11277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (24))){
var state_11203__$1 = state_11203;
var statearr_11211_11278 = state_11203__$1;
(statearr_11211_11278[(2)] = null);

(statearr_11211_11278[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (4))){
var state_11203__$1 = state_11203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11203__$1,(7),event_chan);
} else {
if((state_val_11204 === (15))){
var inst_11112 = (state_11203[(7)]);
var state_11203__$1 = state_11203;
var statearr_11212_11279 = state_11203__$1;
(statearr_11212_11279[(2)] = inst_11112);

(statearr_11212_11279[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (21))){
var state_11203__$1 = state_11203;
var statearr_11213_11280 = state_11203__$1;
(statearr_11213_11280[(2)] = null);

(statearr_11213_11280[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (31))){
var inst_11138 = (state_11203[(10)]);
var inst_11176 = (state_11203[(2)]);
var inst_11177 = cljs.core._EQ_.call(null,inst_11138,new cljs.core.Keyword(null,"table","table",-564943036));
var state_11203__$1 = (function (){var statearr_11214 = state_11203;
(statearr_11214[(11)] = inst_11176);

return statearr_11214;
})();
if(inst_11177){
var statearr_11215_11281 = state_11203__$1;
(statearr_11215_11281[(1)] = (32));

} else {
var statearr_11216_11282 = state_11203__$1;
(statearr_11216_11282[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (32))){
var inst_11137 = (state_11203[(12)]);
var inst_11134 = (state_11203[(8)]);
var inst_11135 = (state_11203[(13)]);
var inst_11138 = (state_11203[(10)]);
var inst_11133 = (state_11203[(14)]);
var inst_11142 = (state_11203[(9)]);
var inst_11132 = (state_11203[(15)]);
var inst_11136 = (state_11203[(16)]);
var inst_11143 = (state_11203[(17)]);
var inst_11112 = (state_11203[(7)]);
var inst_11190 = cljs.core.async.chan.call(null,(1));
var inst_11191 = (function (){var new_columns = inst_11137;
var submission_clicked = inst_11134;
var submission_unclicked = inst_11135;
var c__8287__auto____$1 = inst_11190;
var get_submission_data = inst_11143;
var re_render = inst_11138;
var update_data_BANG_ = inst_11142;
var submission_to_rank = inst_11133;
var e = inst_11112;
var map__11110 = inst_11132;
var filter_by = inst_11136;
return ((function (new_columns,submission_clicked,submission_unclicked,c__8287__auto____$1,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,map__11110,filter_by,inst_11137,inst_11134,inst_11135,inst_11138,inst_11133,inst_11142,inst_11132,inst_11136,inst_11143,inst_11112,inst_11190,state_val_11204,c__8287__auto__,event_chan){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,c__8287__auto____$1,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,map__11110,filter_by,inst_11137,inst_11134,inst_11135,inst_11138,inst_11133,inst_11142,inst_11132,inst_11136,inst_11143,inst_11112,inst_11190,state_val_11204,c__8287__auto__,event_chan){
return (function (state_11188){
var state_val_11189 = (state_11188[(1)]);
if((state_val_11189 === (1))){
var inst_11179 = cljs.core.async.timeout.call(null,(20));
var state_11188__$1 = state_11188;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11188__$1,(2),inst_11179);
} else {
if((state_val_11189 === (2))){
var inst_11181 = (state_11188[(2)]);
var inst_11182 = grid.resizeCanvas();
var inst_11183 = grid.invalidateAllRows();
var inst_11184 = hatti.views.table.resizeColumns.call(null,grid);
var inst_11185 = grid.render();
var inst_11186 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_11188__$1 = (function (){var statearr_11217 = state_11188;
(statearr_11217[(7)] = inst_11182);

(statearr_11217[(8)] = inst_11183);

(statearr_11217[(9)] = inst_11184);

(statearr_11217[(10)] = inst_11185);

(statearr_11217[(11)] = inst_11181);

return statearr_11217;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11188__$1,inst_11186);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,c__8287__auto____$1,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,map__11110,filter_by,inst_11137,inst_11134,inst_11135,inst_11138,inst_11133,inst_11142,inst_11132,inst_11136,inst_11143,inst_11112,inst_11190,state_val_11204,c__8287__auto__,event_chan))
;
return ((function (switch__8266__auto__,new_columns,submission_clicked,submission_unclicked,c__8287__auto____$1,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,map__11110,filter_by,inst_11137,inst_11134,inst_11135,inst_11138,inst_11133,inst_11142,inst_11132,inst_11136,inst_11143,inst_11112,inst_11190,state_val_11204,c__8287__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8267__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8267__auto____0 = (function (){
var statearr_11221 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11221[(0)] = hatti$views$table$handle_table_events_$_state_machine__8267__auto__);

(statearr_11221[(1)] = (1));

return statearr_11221;
});
var hatti$views$table$handle_table_events_$_state_machine__8267__auto____1 = (function (state_11188){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_11188);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e11222){if((e11222 instanceof Object)){
var ex__8270__auto__ = e11222;
var statearr_11223_11283 = state_11188;
(statearr_11223_11283[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11188);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11222;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11284 = state_11188;
state_11188 = G__11284;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8267__auto__ = function(state_11188){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8267__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8267__auto____1.call(this,state_11188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8267__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8267__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8267__auto__;
})()
;})(switch__8266__auto__,new_columns,submission_clicked,submission_unclicked,c__8287__auto____$1,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,map__11110,filter_by,inst_11137,inst_11134,inst_11135,inst_11138,inst_11133,inst_11142,inst_11132,inst_11136,inst_11143,inst_11112,inst_11190,state_val_11204,c__8287__auto__,event_chan))
})();
var state__8289__auto__ = (function (){var statearr_11224 = f__8288__auto__.call(null);
(statearr_11224[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto____$1);

return statearr_11224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,c__8287__auto____$1,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,map__11110,filter_by,inst_11137,inst_11134,inst_11135,inst_11138,inst_11133,inst_11142,inst_11132,inst_11136,inst_11143,inst_11112,inst_11190,state_val_11204,c__8287__auto__,event_chan))
})();
var inst_11192 = cljs.core.async.impl.dispatch.run.call(null,inst_11191);
var state_11203__$1 = (function (){var statearr_11225 = state_11203;
(statearr_11225[(18)] = inst_11192);

return statearr_11225;
})();
var statearr_11226_11285 = state_11203__$1;
(statearr_11226_11285[(2)] = inst_11190);

(statearr_11226_11285[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (33))){
var state_11203__$1 = state_11203;
var statearr_11227_11286 = state_11203__$1;
(statearr_11227_11286[(2)] = null);

(statearr_11227_11286[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (13))){
var inst_11124 = (state_11203[(2)]);
var state_11203__$1 = state_11203;
var statearr_11228_11287 = state_11203__$1;
(statearr_11228_11287[(2)] = inst_11124);

(statearr_11228_11287[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (22))){
var inst_11135 = (state_11203[(13)]);
var inst_11154 = (state_11203[(2)]);
var state_11203__$1 = (function (){var statearr_11229 = state_11203;
(statearr_11229[(19)] = inst_11154);

return statearr_11229;
})();
if(cljs.core.truth_(inst_11135)){
var statearr_11230_11288 = state_11203__$1;
(statearr_11230_11288[(1)] = (23));

} else {
var statearr_11231_11289 = state_11203__$1;
(statearr_11231_11289[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (29))){
var inst_11136 = (state_11203[(16)]);
var inst_11168 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_11169 = [inst_11136];
var inst_11170 = cljs.core.PersistentHashMap.fromArrays(inst_11168,inst_11169);
var inst_11171 = cljs.core.clj__GT_js.call(null,inst_11170);
var inst_11172 = dataview.setFilterArgs(inst_11171);
var inst_11173 = dataview.refresh();
var state_11203__$1 = (function (){var statearr_11232 = state_11203;
(statearr_11232[(20)] = inst_11172);

return statearr_11232;
})();
var statearr_11233_11290 = state_11203__$1;
(statearr_11233_11290[(2)] = inst_11173);

(statearr_11233_11290[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (6))){
var inst_11199 = (state_11203[(2)]);
var state_11203__$1 = state_11203;
var statearr_11234_11291 = state_11203__$1;
(statearr_11234_11291[(2)] = inst_11199);

(statearr_11234_11291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (28))){
var inst_11136 = (state_11203[(16)]);
var inst_11166 = (state_11203[(2)]);
var state_11203__$1 = (function (){var statearr_11235 = state_11203;
(statearr_11235[(21)] = inst_11166);

return statearr_11235;
})();
if(cljs.core.truth_(inst_11136)){
var statearr_11236_11292 = state_11203__$1;
(statearr_11236_11292[(1)] = (29));

} else {
var statearr_11237_11293 = state_11203__$1;
(statearr_11237_11293[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (25))){
var inst_11137 = (state_11203[(12)]);
var inst_11159 = (state_11203[(2)]);
var state_11203__$1 = (function (){var statearr_11238 = state_11203;
(statearr_11238[(22)] = inst_11159);

return statearr_11238;
})();
if(cljs.core.truth_(inst_11137)){
var statearr_11239_11294 = state_11203__$1;
(statearr_11239_11294[(1)] = (26));

} else {
var statearr_11240_11295 = state_11203__$1;
(statearr_11240_11295[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (34))){
var inst_11195 = (state_11203[(2)]);
var state_11203__$1 = (function (){var statearr_11241 = state_11203;
(statearr_11241[(23)] = inst_11195);

return statearr_11241;
})();
var statearr_11242_11296 = state_11203__$1;
(statearr_11242_11296[(2)] = null);

(statearr_11242_11296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (17))){
var inst_11133 = (state_11203[(14)]);
var inst_11142 = (state_11203[(9)]);
var inst_11143 = (state_11203[(17)]);
var inst_11145 = inst_11143.call(null,hatti.constants._rank,inst_11133);
var inst_11146 = inst_11142.call(null,inst_11145);
var state_11203__$1 = state_11203;
var statearr_11243_11297 = state_11203__$1;
(statearr_11243_11297[(2)] = inst_11146);

(statearr_11243_11297[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (3))){
var inst_11201 = (state_11203[(2)]);
var state_11203__$1 = state_11203;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11203__$1,inst_11201);
} else {
if((state_val_11204 === (12))){
var state_11203__$1 = state_11203;
var statearr_11244_11298 = state_11203__$1;
(statearr_11244_11298[(2)] = false);

(statearr_11244_11298[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (2))){
var state_11203__$1 = state_11203;
var statearr_11245_11299 = state_11203__$1;
(statearr_11245_11299[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (23))){
var inst_11142 = (state_11203[(9)]);
var inst_11156 = inst_11142.call(null,null);
var state_11203__$1 = state_11203;
var statearr_11247_11300 = state_11203__$1;
(statearr_11247_11300[(2)] = inst_11156);

(statearr_11247_11300[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (19))){
var inst_11134 = (state_11203[(8)]);
var inst_11149 = (state_11203[(2)]);
var state_11203__$1 = (function (){var statearr_11248 = state_11203;
(statearr_11248[(24)] = inst_11149);

return statearr_11248;
})();
if(cljs.core.truth_(inst_11134)){
var statearr_11249_11301 = state_11203__$1;
(statearr_11249_11301[(1)] = (20));

} else {
var statearr_11250_11302 = state_11203__$1;
(statearr_11250_11302[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (11))){
var state_11203__$1 = state_11203;
var statearr_11251_11303 = state_11203__$1;
(statearr_11251_11303[(2)] = true);

(statearr_11251_11303[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (9))){
var state_11203__$1 = state_11203;
var statearr_11252_11304 = state_11203__$1;
(statearr_11252_11304[(2)] = false);

(statearr_11252_11304[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (5))){
var state_11203__$1 = state_11203;
var statearr_11253_11305 = state_11203__$1;
(statearr_11253_11305[(2)] = null);

(statearr_11253_11305[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (14))){
var inst_11112 = (state_11203[(7)]);
var inst_11129 = cljs.core.apply.call(null,cljs.core.hash_map,inst_11112);
var state_11203__$1 = state_11203;
var statearr_11254_11306 = state_11203__$1;
(statearr_11254_11306[(2)] = inst_11129);

(statearr_11254_11306[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (26))){
var inst_11137 = (state_11203[(12)]);
var inst_11161 = grid.setColumns(inst_11137);
var inst_11162 = hatti.views.table.resizeColumns.call(null,grid);
var inst_11163 = grid.render();
var state_11203__$1 = (function (){var statearr_11255 = state_11203;
(statearr_11255[(25)] = inst_11161);

(statearr_11255[(26)] = inst_11162);

return statearr_11255;
})();
var statearr_11256_11307 = state_11203__$1;
(statearr_11256_11307[(2)] = inst_11163);

(statearr_11256_11307[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (16))){
var inst_11137 = (state_11203[(12)]);
var inst_11134 = (state_11203[(8)]);
var inst_11135 = (state_11203[(13)]);
var inst_11138 = (state_11203[(10)]);
var inst_11133 = (state_11203[(14)]);
var inst_11142 = (state_11203[(9)]);
var inst_11132 = (state_11203[(15)]);
var inst_11136 = (state_11203[(16)]);
var inst_11112 = (state_11203[(7)]);
var inst_11132__$1 = (state_11203[(2)]);
var inst_11133__$1 = cljs.core.get.call(null,inst_11132__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_11134__$1 = cljs.core.get.call(null,inst_11132__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_11135__$1 = cljs.core.get.call(null,inst_11132__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_11136__$1 = cljs.core.get.call(null,inst_11132__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_11137__$1 = cljs.core.get.call(null,inst_11132__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_11138__$1 = cljs.core.get.call(null,inst_11132__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_11139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11140 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_11141 = (new cljs.core.PersistentVector(null,3,(5),inst_11139,inst_11140,null));
var inst_11142__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_11141);
var inst_11143 = (function (){var e = inst_11112;
var map__11110 = inst_11132__$1;
var submission_to_rank = inst_11133__$1;
var submission_clicked = inst_11134__$1;
var submission_unclicked = inst_11135__$1;
var filter_by = inst_11136__$1;
var new_columns = inst_11137__$1;
var re_render = inst_11138__$1;
var update_data_BANG_ = inst_11142__$1;
return ((function (e,map__11110,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_11137,inst_11134,inst_11135,inst_11138,inst_11133,inst_11142,inst_11132,inst_11136,inst_11112,inst_11132__$1,inst_11133__$1,inst_11134__$1,inst_11135__$1,inst_11136__$1,inst_11137__$1,inst_11138__$1,inst_11139,inst_11140,inst_11141,inst_11142__$1,state_val_11204,c__8287__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (e,map__11110,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_11137,inst_11134,inst_11135,inst_11138,inst_11133,inst_11142,inst_11132,inst_11136,inst_11112,inst_11132__$1,inst_11133__$1,inst_11134__$1,inst_11135__$1,inst_11136__$1,inst_11137__$1,inst_11138__$1,inst_11139,inst_11140,inst_11141,inst_11142__$1,state_val_11204,c__8287__auto__,event_chan){
return (function (p1__10942_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__10942_SHARP_,field));
});})(e,map__11110,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_11137,inst_11134,inst_11135,inst_11138,inst_11133,inst_11142,inst_11132,inst_11136,inst_11112,inst_11132__$1,inst_11133__$1,inst_11134__$1,inst_11135__$1,inst_11136__$1,inst_11137__$1,inst_11138__$1,inst_11139,inst_11140,inst_11141,inst_11142__$1,state_val_11204,c__8287__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(e,map__11110,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_11137,inst_11134,inst_11135,inst_11138,inst_11133,inst_11142,inst_11132,inst_11136,inst_11112,inst_11132__$1,inst_11133__$1,inst_11134__$1,inst_11135__$1,inst_11136__$1,inst_11137__$1,inst_11138__$1,inst_11139,inst_11140,inst_11141,inst_11142__$1,state_val_11204,c__8287__auto__,event_chan))
})();
var state_11203__$1 = (function (){var statearr_11257 = state_11203;
(statearr_11257[(12)] = inst_11137__$1);

(statearr_11257[(8)] = inst_11134__$1);

(statearr_11257[(13)] = inst_11135__$1);

(statearr_11257[(10)] = inst_11138__$1);

(statearr_11257[(14)] = inst_11133__$1);

(statearr_11257[(9)] = inst_11142__$1);

(statearr_11257[(15)] = inst_11132__$1);

(statearr_11257[(16)] = inst_11136__$1);

(statearr_11257[(17)] = inst_11143);

return statearr_11257;
})();
if(cljs.core.truth_(inst_11133__$1)){
var statearr_11258_11308 = state_11203__$1;
(statearr_11258_11308[(1)] = (17));

} else {
var statearr_11259_11309 = state_11203__$1;
(statearr_11259_11309[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (30))){
var state_11203__$1 = state_11203;
var statearr_11260_11310 = state_11203__$1;
(statearr_11260_11310[(2)] = null);

(statearr_11260_11310[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (10))){
var inst_11127 = (state_11203[(2)]);
var state_11203__$1 = state_11203;
if(cljs.core.truth_(inst_11127)){
var statearr_11261_11311 = state_11203__$1;
(statearr_11261_11311[(1)] = (14));

} else {
var statearr_11262_11312 = state_11203__$1;
(statearr_11262_11312[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (18))){
var state_11203__$1 = state_11203;
var statearr_11263_11313 = state_11203__$1;
(statearr_11263_11313[(2)] = null);

(statearr_11263_11313[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (8))){
var inst_11112 = (state_11203[(7)]);
var inst_11117 = inst_11112.cljs$lang$protocol_mask$partition0$;
var inst_11118 = (inst_11117 & (64));
var inst_11119 = inst_11112.cljs$core$ISeq$;
var inst_11120 = (inst_11118) || (inst_11119);
var state_11203__$1 = state_11203;
if(cljs.core.truth_(inst_11120)){
var statearr_11264_11314 = state_11203__$1;
(statearr_11264_11314[(1)] = (11));

} else {
var statearr_11265_11315 = state_11203__$1;
(statearr_11265_11315[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto__,event_chan))
;
return ((function (switch__8266__auto__,c__8287__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__8267__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__8267__auto____0 = (function (){
var statearr_11269 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11269[(0)] = hatti$views$table$handle_table_events_$_state_machine__8267__auto__);

(statearr_11269[(1)] = (1));

return statearr_11269;
});
var hatti$views$table$handle_table_events_$_state_machine__8267__auto____1 = (function (state_11203){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_11203);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e11270){if((e11270 instanceof Object)){
var ex__8270__auto__ = e11270;
var statearr_11271_11316 = state_11203;
(statearr_11271_11316[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11203);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11270;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11317 = state_11203;
state_11203 = G__11317;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__8267__auto__ = function(state_11203){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__8267__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__8267__auto____1.call(this,state_11203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__8267__auto____0;
hatti$views$table$handle_table_events_$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__8267__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto__,event_chan))
})();
var state__8289__auto__ = (function (){var statearr_11272 = f__8288__auto__.call(null);
(statearr_11272[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto__);

return statearr_11272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto__,event_chan))
);

return c__8287__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),k);

return colset_BANG_.call(null,k);
});
var iter__5352__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__11326(s__11327){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__11327__$1 = s__11327;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__11327__$1);
if(temp__4657__auto__){
var s__11327__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11327__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__11327__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__11329 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__11328 = (0);
while(true){
if((i__11328 < size__5351__auto__)){
var vec__11332 = cljs.core._nth.call(null,c__5350__auto__,i__11328);
var k = cljs.core.nth.call(null,vec__11332,(0),null);
var v = cljs.core.nth.call(null,vec__11332,(1),null);
cljs.core.chunk_append.call(null,b__11329,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__11328,vec__11332,k,v,c__5350__auto__,size__5351__auto__,b__11329,s__11327__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__11328,vec__11332,k,v,c__5350__auto__,size__5351__auto__,b__11329,s__11327__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__11334 = (i__11328 + (1));
i__11328 = G__11334;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11329),hatti$views$table$render_options_$_iter__11326.call(null,cljs.core.chunk_rest.call(null,s__11327__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11329),null);
}
} else {
var vec__11333 = cljs.core.first.call(null,s__11327__$2);
var k = cljs.core.nth.call(null,vec__11333,(0),null);
var v = cljs.core.nth.call(null,vec__11333,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__11333,k,v,s__11327__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__11333,k,v,s__11327__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__11326.call(null,cljs.core.rest.call(null,s__11327__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5352__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table11336 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table11336 = (function (_,owner,meta11337){
this._ = _;
this.owner = owner;
this.meta11337 = meta11337;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table11336.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11338,meta11337__$1){
var self__ = this;
var _11338__$1 = this;
return (new hatti.views.table.t_hatti$views$table11336(self__._,self__.owner,meta11337__$1));
});

hatti.views.table.t_hatti$views$table11336.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11338){
var self__ = this;
var _11338__$1 = this;
return self__.meta11337;
});

hatti.views.table.t_hatti$views$table11336.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table11336.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table11336.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table11336.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__11339){
var self__ = this;
var map__11340 = p__11339;
var map__11340__$1 = ((((!((map__11340 == null)))?((((map__11340.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11340.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11340):map__11340);
var name_or_label = cljs.core.get.call(null,map__11340__$1,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208));
var language = cljs.core.get.call(null,map__11340__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__11342 = om.core.get_shared.call(null,self__.owner);
var map__11342__$1 = ((((!((map__11342 == null)))?((((map__11342.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11342.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11342):map__11342);
var flat_form = cljs.core.get.call(null,map__11342__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__11342,map__11342__$1,flat_form,new_language,___$2,map__11340,map__11340__$1,name_or_label,language){
return (function (p1__11335_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__11335_SHARP_),new_language)], null));
});})(options,map__11342,map__11342__$1,flat_form,new_language,___$2,map__11340,map__11340__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,name_or_label);
} else {
}

return React.DOM.div({"className": "label-changer"},React.DOM.span({"className": "label-changer-label"},"Show:"),React.DOM.div({"id": "header-display-dropdown", "className": "drop-hover"},(function (){var attrs11346 = options.call(null,name_or_label);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs11346))?sablono.interpreter.attributes.call(null,attrs11346):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs11346))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i({"className": "fa fa-angle-down"})], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs11346),React.DOM.i({"className": "fa fa-angle-down"})], null))));
})(),React.DOM.ul({"className": "submenu no-dot"},sablono.interpreter.interpret.call(null,hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_)))));
});

hatti.views.table.t_hatti$views$table11336.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta11337","meta11337",-1542697892,null)], null);
});

hatti.views.table.t_hatti$views$table11336.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table11336.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table11336";

hatti.views.table.t_hatti$views$table11336.cljs$lang$ctorPrWriter = (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"hatti.views.table/t_hatti$views$table11336");
});

hatti.views.table.__GT_t_hatti$views$table11336 = (function hatti$views$table$__GT_t_hatti$views$table11336(___$1,owner__$1,meta11337){
return (new hatti.views.table.t_hatti$views$table11336(___$1,owner__$1,meta11337));
});

}

return (new hatti.views.table.t_hatti$views$table11336(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__8287__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto__,query){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto__,query){
return (function (state_11393){
var state_val_11394 = (state_11393[(1)]);
if((state_val_11394 === (1))){
var inst_11379 = cljs.core.async.timeout.call(null,(150));
var state_11393__$1 = state_11393;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11393__$1,(2),inst_11379);
} else {
if((state_val_11394 === (2))){
var inst_11381 = (state_11393[(2)]);
var inst_11382 = input.value;
var inst_11383 = cljs.core._EQ_.call(null,query,inst_11382);
var state_11393__$1 = (function (){var statearr_11395 = state_11393;
(statearr_11395[(7)] = inst_11381);

return statearr_11395;
})();
if(inst_11383){
var statearr_11396_11407 = state_11393__$1;
(statearr_11396_11407[(1)] = (3));

} else {
var statearr_11397_11408 = state_11393__$1;
(statearr_11397_11408[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11394 === (3))){
var inst_11385 = [query_event_key];
var inst_11386 = [query];
var inst_11387 = cljs.core.PersistentHashMap.fromArrays(inst_11385,inst_11386);
var inst_11388 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_11387);
var state_11393__$1 = state_11393;
var statearr_11398_11409 = state_11393__$1;
(statearr_11398_11409[(2)] = inst_11388);

(statearr_11398_11409[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11394 === (4))){
var state_11393__$1 = state_11393;
var statearr_11399_11410 = state_11393__$1;
(statearr_11399_11410[(2)] = null);

(statearr_11399_11410[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11394 === (5))){
var inst_11391 = (state_11393[(2)]);
var state_11393__$1 = state_11393;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11393__$1,inst_11391);
} else {
return null;
}
}
}
}
}
});})(c__8287__auto__,query))
;
return ((function (switch__8266__auto__,c__8287__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__8267__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__8267__auto____0 = (function (){
var statearr_11403 = [null,null,null,null,null,null,null,null];
(statearr_11403[(0)] = hatti$views$table$delayed_search_$_state_machine__8267__auto__);

(statearr_11403[(1)] = (1));

return statearr_11403;
});
var hatti$views$table$delayed_search_$_state_machine__8267__auto____1 = (function (state_11393){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_11393);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e11404){if((e11404 instanceof Object)){
var ex__8270__auto__ = e11404;
var statearr_11405_11411 = state_11393;
(statearr_11405_11411[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11393);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11404;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11412 = state_11393;
state_11393 = G__11412;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__8267__auto__ = function(state_11393){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__8267__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__8267__auto____1.call(this,state_11393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__8267__auto____0;
hatti$views$table$delayed_search_$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__8267__auto____1;
return hatti$views$table$delayed_search_$_state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto__,query))
})();
var state__8289__auto__ = (function (){var statearr_11406 = f__8288__auto__.call(null);
(statearr_11406[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto__);

return statearr_11406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto__,query))
);

return c__8287__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table11414 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table11414 = (function (_,owner,meta11415){
this._ = _;
this.owner = owner;
this.meta11415 = meta11415;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table11414.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11416,meta11415__$1){
var self__ = this;
var _11416__$1 = this;
return (new hatti.views.table.t_hatti$views$table11414(self__._,self__.owner,meta11415__$1));
});

hatti.views.table.t_hatti$views$table11414.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11416){
var self__ = this;
var _11416__$1 = this;
return self__.meta11415;
});

hatti.views.table.t_hatti$views$table11414.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table11414.prototype.om$core$IRender$render$arity$1 = (function (this__6334__auto__){
var self__ = this;
var this__6334__auto____$1 = this;
return React.DOM.div({"className": "table-search"},React.DOM.i({"className": "fa fa-search"}),sablono.interpreter.input.call(null,{"type": "text", "placeholder": "Search", "onChange": ((function (this__6334__auto____$1){
return (function (p1__11413_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__11413_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__6334__auto____$1))
}));
});

hatti.views.table.t_hatti$views$table11414.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta11415","meta11415",11316009,null)], null);
});

hatti.views.table.t_hatti$views$table11414.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table11414.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table11414";

hatti.views.table.t_hatti$views$table11414.cljs$lang$ctorPrWriter = (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"hatti.views.table/t_hatti$views$table11414");
});

hatti.views.table.__GT_t_hatti$views$table11414 = (function hatti$views$table$__GT_t_hatti$views$table11414(___$1,owner__$1,meta11415){
return (new hatti.views.table.t_hatti$views$table11414(___$1,owner__$1,meta11415));
});

}

return (new hatti.views.table.t_hatti$views$table11414(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table11419 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table11419 = (function (app_state,owner,meta11420){
this.app_state = app_state;
this.owner = owner;
this.meta11420 = meta11420;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table11419.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11421,meta11420__$1){
var self__ = this;
var _11421__$1 = this;
return (new hatti.views.table.t_hatti$views$table11419(self__.app_state,self__.owner,meta11420__$1));
});

hatti.views.table.t_hatti$views$table11419.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11421){
var self__ = this;
var _11421__$1 = this;
return self__.meta11420;
});

hatti.views.table.t_hatti$views$table11419.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table11419.prototype.om$core$IRender$render$arity$1 = (function (this__6334__auto__){
var self__ = this;
var this__6334__auto____$1 = this;
return React.DOM.div({"className": "topbar"},React.DOM.div({"id": hatti.views.table.pager_id}),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.app_state)),React.DOM.div({"style": {"clear": "both"}}));
});

hatti.views.table.t_hatti$views$table11419.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta11420","meta11420",1428579944,null)], null);
});

hatti.views.table.t_hatti$views$table11419.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table11419.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table11419";

hatti.views.table.t_hatti$views$table11419.cljs$lang$ctorPrWriter = (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"hatti.views.table/t_hatti$views$table11419");
});

hatti.views.table.__GT_t_hatti$views$table11419 = (function hatti$views$table$__GT_t_hatti$views$table11419(app_state__$1,owner__$1,meta11420){
return (new hatti.views.table.t_hatti$views$table11419(app_state__$1,owner__$1,meta11420));
});

}

return (new hatti.views.table.t_hatti$views$table11419(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq.call(null,data)){
var map__11427 = om.core.get_shared.call(null,owner);
var map__11427__$1 = ((((!((map__11427 == null)))?((((map__11427.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11427.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11427):map__11427);
var flat_form = cljs.core.get.call(null,map__11427__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__11427__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__11428 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__11428,(0),null);
var dataview = cljs.core.nth.call(null,vec__11428,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner,p__11431){
var map__11432 = p__11431;
var map__11432__$1 = ((((!((map__11432 == null)))?((((map__11432.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11432.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11432):map__11432);
var opts = map__11432__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__11432__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

if(typeof hatti.views.table.t_hatti$views$table11434 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table11434 = (function (app_state,owner,p__11431,map__11432,opts,slick_grid_event_handlers,meta11435){
this.app_state = app_state;
this.owner = owner;
this.p__11431 = p__11431;
this.map__11432 = map__11432;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta11435 = meta11435;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table11434.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__11432,map__11432__$1,opts,slick_grid_event_handlers){
return (function (_11436,meta11435__$1){
var self__ = this;
var _11436__$1 = this;
return (new hatti.views.table.t_hatti$views$table11434(self__.app_state,self__.owner,self__.p__11431,self__.map__11432,self__.opts,self__.slick_grid_event_handlers,meta11435__$1));
});})(map__11432,map__11432__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11434.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__11432,map__11432__$1,opts,slick_grid_event_handlers){
return (function (_11436){
var self__ = this;
var _11436__$1 = this;
return self__.meta11435;
});})(map__11432,map__11432__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11434.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table11434.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__11432,map__11432__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null)));
var map__11437 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__11437__$1 = ((((!((map__11437 == null)))?((((map__11437.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11437.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11437):map__11437);
var dataset_info = map__11437__$1;
var num_of_submissions = cljs.core.get.call(null,map__11437__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var with_info = ((function (no_data_QMARK_,map__11437,map__11437__$1,dataset_info,num_of_submissions,___$2,map__11432,map__11432__$1,opts,slick_grid_event_handlers){
return (function (p1__11430_SHARP_){
return cljs.core.merge.call(null,p1__11430_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),dataset_info], null));
});})(no_data_QMARK_,map__11437,map__11437__$1,dataset_info,num_of_submissions,___$2,map__11432,map__11432__$1,opts,slick_grid_event_handlers))
;
var attrs11439 = om.core.build.call(null,hatti.views.submission_view,with_info.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855)], null))),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null));
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs11439))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs11439)):{"className": "table-view"}),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs11439))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs11439),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null))));
});})(map__11432,map__11432__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11434.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table11434.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__11432,map__11432__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__11448 = temp__4657__auto__;
var grid = cljs.core.nth.call(null,vec__11448,(0),null);
var dataview = cljs.core.nth.call(null,vec__11448,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__11432,map__11432__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11434.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table11434.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__11432,map__11432__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__11449 = om.core.get_state.call(null,self__.owner);
var map__11449__$1 = ((((!((map__11449 == null)))?((((map__11449.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11449.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11449):map__11449);
var grid = cljs.core.get.call(null,map__11449__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__11449__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__11451 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__11451,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__11451,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__11432,map__11432__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11434.getBasis = ((function (map__11432,map__11432__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__11431","p__11431",402806063,null),new cljs.core.Symbol(null,"map__11432","map__11432",-1087735981,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"meta11435","meta11435",1744338359,null)], null);
});})(map__11432,map__11432__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11434.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table11434.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table11434";

hatti.views.table.t_hatti$views$table11434.cljs$lang$ctorPrWriter = ((function (map__11432,map__11432__$1,opts,slick_grid_event_handlers){
return (function (this__5178__auto__,writer__5179__auto__,opt__5180__auto__){
return cljs.core._write.call(null,writer__5179__auto__,"hatti.views.table/t_hatti$views$table11434");
});})(map__11432,map__11432__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table11434 = ((function (map__11432,map__11432__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table11434(app_state__$1,owner__$1,p__11431__$1,map__11432__$2,opts__$1,slick_grid_event_handlers__$1,meta11435){
return (new hatti.views.table.t_hatti$views$table11434(app_state__$1,owner__$1,p__11431__$1,map__11432__$2,opts__$1,slick_grid_event_handlers__$1,meta11435));
});})(map__11432,map__11432__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table11434(app_state,owner,p__11431,map__11432__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
