// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('cljs_time.internal.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.format');
cljs_time.internal.core._EQ_ = (function cljs_time$internal$core$_EQ_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___31082 = arguments.length;
var i__7281__auto___31083 = (0);
while(true){
if((i__7281__auto___31083 < len__7280__auto___31082)){
args__7287__auto__.push((arguments[i__7281__auto___31083]));

var G__31084 = (i__7281__auto___31083 + (1));
i__7281__auto___31083 = G__31084;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core.every_QMARK_((function (p1__31079_SHARP_){
return (p1__31079_SHARP_ instanceof goog.date.Date);
}),args)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31080_SHARP_){
return p1__31080_SHARP_.getTime();
}),args));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);

}
});

cljs_time.internal.core._EQ_.cljs$lang$maxFixedArity = (0);

cljs_time.internal.core._EQ_.cljs$lang$applyTo = (function (seq31081){
return cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31081));
});
cljs_time.internal.core.leap_year_QMARK_ = (function cljs_time$internal$core$leap_year_QMARK_(y){
if((cljs.core.mod(y,(400)) === (0))){
return true;
} else {
if((cljs.core.mod(y,(100)) === (0))){
return false;
} else {
if((cljs.core.mod(y,(4)) === (0))){
return true;
} else {
return false;

}
}
}
});
cljs_time.internal.core.days_in_month = new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [(31),(28),(31),(30),(31),(30),(31),(31),(30),(31),(30),(31)], null);
cljs_time.internal.core.year_corrected_dim = (function cljs_time$internal$core$year_corrected_dim(year,month){
var G__31087 = (function (){var G__31088 = (cljs.core.truth_(cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([month,(1)], 0)))?(11):(month - (1)));
return (cljs_time.internal.core.days_in_month.cljs$core$IFn$_invoke$arity$1 ? cljs_time.internal.core.days_in_month.cljs$core$IFn$_invoke$arity$1(G__31088) : cljs_time.internal.core.days_in_month.call(null,G__31088));
})();
if(cljs.core.truth_((function (){var and__6198__auto__ = cljs_time.internal.core.leap_year_QMARK_(year);
if(cljs.core.truth_(and__6198__auto__)){
return cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([month,(2)], 0));
} else {
return and__6198__auto__;
}
})())){
return (G__31087 + (1));
} else {
return G__31087;
}
});
cljs_time.internal.core.valid_date_QMARK_ = (function cljs_time$internal$core$valid_date_QMARK_(p__31089){
var map__31092 = p__31089;
var map__31092__$1 = ((((!((map__31092 == null)))?((((map__31092.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31092.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31092):map__31092);
var d = map__31092__$1;
var years = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31092__$1,cljs.core.cst$kw$years);
var months = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31092__$1,cljs.core.cst$kw$months);
var days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31092__$1,cljs.core.cst$kw$days);
var hours = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31092__$1,cljs.core.cst$kw$hours);
var minutes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31092__$1,cljs.core.cst$kw$minutes);
var seconds = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31092__$1,cljs.core.cst$kw$seconds);
var millis = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31092__$1,cljs.core.cst$kw$millis);
var months__$1 = (months + (1));
var _GT__LT_ = ((function (months__$1,map__31092,map__31092__$1,d,years,months,days,hours,minutes,seconds,millis){
return (function cljs_time$internal$core$valid_date_QMARK__$__GT__LT_(a,b,x){
return ((x >= a)) && ((x <= b));
});})(months__$1,map__31092,map__31092__$1,d,years,months,days,hours,minutes,seconds,millis))
;
if(cljs.core.truth_((function (){var and__6198__auto__ = years;
if(cljs.core.truth_(and__6198__auto__)){
var and__6198__auto____$1 = _GT__LT_((1),(12),months__$1);
if(cljs.core.truth_(and__6198__auto____$1)){
var and__6198__auto____$2 = _GT__LT_((1),cljs_time.internal.core.year_corrected_dim(years,months__$1),days);
if(cljs.core.truth_(and__6198__auto____$2)){
var and__6198__auto____$3 = _GT__LT_((0),(23),hours);
if(cljs.core.truth_(and__6198__auto____$3)){
var and__6198__auto____$4 = _GT__LT_((0),(59),minutes);
if(cljs.core.truth_(and__6198__auto____$4)){
var and__6198__auto____$5 = _GT__LT_((0),(60),seconds);
if(cljs.core.truth_(and__6198__auto____$5)){
return _GT__LT_((0),(999),millis);
} else {
return and__6198__auto____$5;
}
} else {
return and__6198__auto____$4;
}
} else {
return and__6198__auto____$3;
}
} else {
return and__6198__auto____$2;
}
} else {
return and__6198__auto____$1;
}
} else {
return and__6198__auto__;
}
})())){
return d;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Date is not valid",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,cljs.core.cst$kw$invalid_DASH_date,cljs.core.cst$kw$date,d], null));
}
});
cljs_time.internal.core.index_of = (function cljs_time$internal$core$index_of(coll,x){
return cljs.core.first(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (p1__31095_SHARP_,p2__31094_SHARP_){
if(cljs.core.truth_(cljs_time.internal.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p2__31094_SHARP_,x], 0)))){
return p1__31095_SHARP_;
} else {
return null;
}
}),coll));
});
cljs_time.internal.core.period = (function cljs_time$internal$core$period(var_args){
var args31096 = [];
var len__7280__auto___31102 = arguments.length;
var i__7281__auto___31103 = (0);
while(true){
if((i__7281__auto___31103 < len__7280__auto___31102)){
args31096.push((arguments[i__7281__auto___31103]));

var G__31104 = (i__7281__auto___31103 + (1));
i__7281__auto___31103 = G__31104;
continue;
} else {
}
break;
}

var G__31101 = args31096.length;
switch (G__31101) {
case 2:
return cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7299__auto__ = (new cljs.core.IndexedSeq(args31096.slice((2)),(0),null));
return cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7299__auto__);

}
});

cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$2 = (function (period,value){
return cljs.core.with_meta(cljs.core.PersistentArrayMap.fromArray([period,value], true, false),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.cst$kw$cljs_DASH_time$core_SLASH_period], null));
});

cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$variadic = (function (p1,v1,kvs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc,cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$2(p1,v1),kvs);
});

cljs_time.internal.core.period.cljs$lang$applyTo = (function (seq31097){
var G__31098 = cljs.core.first(seq31097);
var seq31097__$1 = cljs.core.next(seq31097);
var G__31099 = cljs.core.first(seq31097__$1);
var seq31097__$2 = cljs.core.next(seq31097__$1);
return cljs_time.internal.core.period.cljs$core$IFn$_invoke$arity$variadic(G__31098,G__31099,seq31097__$2);
});

cljs_time.internal.core.period.cljs$lang$maxFixedArity = (2);
/**
 * Formats a string using goog.string.format.
 */
cljs_time.internal.core.format = (function cljs_time$internal$core$format(var_args){
var args__7287__auto__ = [];
var len__7280__auto___31108 = arguments.length;
var i__7281__auto___31109 = (0);
while(true){
if((i__7281__auto___31109 < len__7280__auto___31108)){
args__7287__auto__.push((arguments[i__7281__auto___31109]));

var G__31110 = (i__7281__auto___31109 + (1));
i__7281__auto___31109 = G__31110;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return cljs_time.internal.core.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

cljs_time.internal.core.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
var args__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
if(((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol))){
return [cljs.core.str(x)].join('');
} else {
return x;
}
}),args);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args__$1);
});

cljs_time.internal.core.format.cljs$lang$maxFixedArity = (1);

cljs_time.internal.core.format.cljs$lang$applyTo = (function (seq31106){
var G__31107 = cljs.core.first(seq31106);
var seq31106__$1 = cljs.core.next(seq31106);
return cljs_time.internal.core.format.cljs$core$IFn$_invoke$arity$variadic(G__31107,seq31106__$1);
});
/**
 * Remove the need to pull in gstring/format code in advanced compilation
 */
cljs_time.internal.core.zero_pad = (function cljs_time$internal$core$zero_pad(var_args){
var args31111 = [];
var len__7280__auto___31114 = arguments.length;
var i__7281__auto___31115 = (0);
while(true){
if((i__7281__auto___31115 < len__7280__auto___31114)){
args31111.push((arguments[i__7281__auto___31115]));

var G__31116 = (i__7281__auto___31115 + (1));
i__7281__auto___31115 = G__31116;
continue;
} else {
}
break;
}

var G__31113 = args31111.length;
switch (G__31113) {
case 1:
return cljs_time.internal.core.zero_pad.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.core.zero_pad.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31111.length)].join('')));

}
});

cljs_time.internal.core.zero_pad.cljs$core$IFn$_invoke$arity$1 = (function (n){
if((((0) <= n)) && ((n <= (9)))){
return [cljs.core.str("0"),cljs.core.str(n)].join('');
} else {
return [cljs.core.str(n)].join('');
}
});

cljs_time.internal.core.zero_pad.cljs$core$IFn$_invoke$arity$2 = (function (n,zeros){
if(((1) > zeros)){
return [cljs.core.str(n)].join('');
} else {
return [cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.take.cljs$core$IFn$_invoke$arity$2((zeros - cljs.core.count([cljs.core.str(n)].join(''))),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("0")))),cljs.core.str(n)].join('');
}
});

cljs_time.internal.core.zero_pad.cljs$lang$maxFixedArity = 2;
