// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('hatti.shared');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('cljs.core.async');
goog.require('sablono.core');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('hatti.utils.om.state');
goog.require('chimera.urls');
hatti.shared.event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.event_multi_chan = cljs.core.async.mult(hatti.shared.event_chan);
hatti.shared.event_tap = (function hatti$shared$event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.external_event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.external_event_multi_chan = cljs.core.async.mult(hatti.shared.external_event_chan);
hatti.shared.external_event_tap = (function hatti$shared$external_event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.external_event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.default_fields = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,"_submission_time",cljs.core.cst$kw$label,"Submission Time",cljs.core.cst$kw$name,"_submission_time",cljs.core.cst$kw$type,"datetime"], null)], null);
/**
 * An initial, empty, app-state, which can be modified to change dataviews.
 */
hatti.shared.empty_app_state = (function hatti$shared$empty_app_state(){
var G__33920 = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$api_DASH_url,cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$status,cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$chart_DASH_page,cljs.core.cst$kw$languages,cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$views,cljs.core.cst$kw$data],["//api.ona.io/api/v1/",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null)], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,(0),cljs.core.cst$kw$loading_QMARK_,true], null),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$visible_DASH_charts,hatti.shared.default_fields,cljs.core.cst$kw$chart_DASH_data,cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$current,null,cljs.core.cst$kw$all,cljs.core.PersistentVector.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null),cljs.core.cst$kw$geofield,cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$all,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$overview,cljs.core.cst$kw$map,cljs.core.cst$kw$table,cljs.core.cst$kw$chart,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$settings], null),cljs.core.cst$kw$selected,cljs.core.cst$kw$overview], null),cljs.core.PersistentVector.EMPTY]);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33920) : cljs.core.atom.call(null,G__33920));
});
hatti.shared.app_state = hatti.shared.empty_app_state();
/**
 * Given a function over data, run a transact on data inside app-state.
 */
hatti.shared.transact_app_data_BANG_ = (function hatti$shared$transact_app_data_BANG_(app_state,transact_fn){
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null),transact_fn);
});
/**
 * Given `data` received from the server, update the app-state.
 * Sorts by submission time, and adds rank to the data, for table + map views.
 */
hatti.shared.update_app_data_BANG_ = (function hatti$shared$update_app_data_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___33928 = arguments.length;
var i__7281__auto___33929 = (0);
while(true){
if((i__7281__auto___33929 < len__7280__auto___33928)){
args__7287__auto__.push((arguments[i__7281__auto___33929]));

var G__33930 = (i__7281__auto___33929 + (1));
i__7281__auto___33929 = G__33930;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((2) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((2)),(0),null)):null);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7288__auto__);
});

hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__33925){
var map__33926 = p__33925;
var map__33926__$1 = ((((!((map__33926 == null)))?((((map__33926.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33926.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33926):map__33926);
var rerank_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33926__$1,cljs.core.cst$kw$rerank_QMARK_);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33926__$1,cljs.core.cst$kw$completed_QMARK_);
var sort_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33926__$1,cljs.core.cst$kw$sort_DASH_field);
var current_start_index = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33926__$1,cljs.core.cst$kw$current_DASH_start_DASH_index,(0));
var add_rank = ((function (map__33926,map__33926__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (i,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,hatti.constants._rank,(current_start_index + (i + (1))));
});})(map__33926,map__33926__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
;
var data__$1 = (cljs.core.truth_((function (){var and__6198__auto__ = rerank_QMARK_;
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.seq(data);
} else {
return and__6198__auto__;
}
})())?cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (add_rank,map__33926,map__33926__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (p1__33921_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__33921_SHARP_,(function (){var or__6210__auto__ = sort_field;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return hatti.constants._submission_time;
}
})());
});})(add_rank,map__33926,map__33926__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
,data))):cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,data)));
var total_records = cljs.core.count(data__$1);
hatti.shared.transact_app_data_BANG_(app_state,((function (add_rank,data__$1,total_records,map__33926,map__33926__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (_){
return data__$1;
});})(add_rank,data__$1,total_records,map__33926,map__33926__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
);

return chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,total_records,cljs.core.cst$kw$loading_QMARK_,cljs.core.not(completed_QMARK_)], null));
});

hatti.shared.update_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.update_app_data_BANG_.cljs$lang$applyTo = (function (seq33922){
var G__33923 = cljs.core.first(seq33922);
var seq33922__$1 = cljs.core.next(seq33922);
var G__33924 = cljs.core.first(seq33922__$1);
var seq33922__$2 = cljs.core.next(seq33922__$1);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33923,G__33924,seq33922__$2);
});
/**
 * Add to app data.
 */
hatti.shared.add_to_app_data_BANG_ = (function hatti$shared$add_to_app_data_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___33937 = arguments.length;
var i__7281__auto___33938 = (0);
while(true){
if((i__7281__auto___33938 < len__7280__auto___33937)){
args__7287__auto__.push((arguments[i__7281__auto___33938]));

var G__33939 = (i__7281__auto___33938 + (1));
i__7281__auto___33938 = G__33939;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((2) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((2)),(0),null)):null);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7288__auto__);
});

hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__33934){
var map__33935 = p__33934;
var map__33935__$1 = ((((!((map__33935 == null)))?((((map__33935.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33935.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33935):map__33935);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33935__$1,cljs.core.cst$kw$completed_QMARK_);
var old_data = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)));
hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(app_state,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(old_data,data),cljs.core.array_seq([cljs.core.cst$kw$rerank_QMARK_,completed_QMARK_], 0));

return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status,cljs.core.cst$kw$loading_QMARK_], null),cljs.core.not(completed_QMARK_));
});

hatti.shared.add_to_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.add_to_app_data_BANG_.cljs$lang$applyTo = (function (seq33931){
var G__33932 = cljs.core.first(seq33931);
var seq33931__$1 = cljs.core.next(seq33931);
var G__33933 = cljs.core.first(seq33931__$1);
var seq33931__$2 = cljs.core.next(seq33931__$1);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33932,G__33933,seq33931__$2);
});
hatti.shared.language_cursor = (function hatti$shared$language_cursor(){
return om.core.ref_cursor(cljs.core.cst$kw$languages.cljs$core$IFn$_invoke$arity$1(om.core.root_cursor(hatti.shared.app_state)));
});
/**
 * A language selector and a following divider.
 */
hatti.shared.language_selector = (function hatti$shared$language_selector(_,owner){
if(typeof hatti.shared.t_hatti$shared33996 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.shared.t_hatti$shared33996 = (function (language_selector,_,owner,meta33997){
this.language_selector = language_selector;
this._ = _;
this.owner = owner;
this.meta33997 = meta33997;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.shared.t_hatti$shared33996.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33998,meta33997__$1){
var self__ = this;
var _33998__$1 = this;
return (new hatti.shared.t_hatti$shared33996(self__.language_selector,self__._,self__.owner,meta33997__$1));
});

hatti.shared.t_hatti$shared33996.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33998){
var self__ = this;
var _33998__$1 = this;
return self__.meta33997;
});

hatti.shared.t_hatti$shared33996.prototype.om$core$IRender$ = true;

hatti.shared.t_hatti$shared33996.prototype.om$core$IRender$render$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var map__33999 = om.core.observe(self__.owner,hatti.shared.language_cursor());
var map__33999__$1 = ((((!((map__33999 == null)))?((((map__33999.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33999.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33999):map__33999);
var ls = map__33999__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33999__$1,cljs.core.cst$kw$current);
var all = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33999__$1,cljs.core.cst$kw$all);
var get_update_handler = ((function (map__33999,map__33999__$1,ls,current,all,___$2){
return (function (language){
return ((function (map__33999,map__33999__$1,ls,current,all,___$2){
return (function (event){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(ls,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$current], null),language);

return event.preventDefault();
});
;})(map__33999,map__33999__$1,ls,current,all,___$2))
});})(map__33999,map__33999__$1,ls,current,all,___$2))
;
var stringify = ((function (map__33999,map__33999__$1,ls,current,all,get_update_handler,___$2){
return (function (p1__33940_SHARP_){
if((p1__33940_SHARP_ instanceof cljs.core.Keyword)){
return cljs.core.name(p1__33940_SHARP_);
} else {
return [cljs.core.str(p1__33940_SHARP_)].join('');
}
});})(map__33999,map__33999__$1,ls,current,all,get_update_handler,___$2))
;
var G__34008 = {"className": "language-selector-inner"};
var G__34009 = (function (){var G__34011 = {"className": "dropdown drop-hover"};
var G__34012 = (function (){var G__34016 = {"style": {"marginRight": ".2em"}, "className": "fa fa-globe"};
return React.DOM.i(G__34016);
})();
var G__34013 = (function (){var attrs34003 = (cljs.core.truth_(hatti.ona.forms.english_QMARK_(current))?"EN":stringify(current));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs34003))?sablono.interpreter.attributes(attrs34003):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs34003))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs34003)], null))));
})();
var G__34014 = (function (){var G__34017 = {"style": {"marginLeft": ".5em"}, "className": "fa fa-angle-down"};
return React.DOM.i(G__34017);
})();
var G__34015 = (function (){var G__34018 = {"className": "submenu"};
var G__34019 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__6990__auto__ = ((function (G__34018,G__34011,G__34012,G__34013,G__34014,G__34008,map__33999,map__33999__$1,ls,current,all,get_update_handler,stringify,___$2){
return (function hatti$shared$language_selector_$_iter__34020(s__34021){
return (new cljs.core.LazySeq(null,((function (G__34018,G__34011,G__34012,G__34013,G__34014,G__34008,map__33999,map__33999__$1,ls,current,all,get_update_handler,stringify,___$2){
return (function (){
var s__34021__$1 = s__34021;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34021__$1);
if(temp__4657__auto__){
var s__34021__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34021__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__34021__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__34023 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__34022 = (0);
while(true){
if((i__34022 < size__6989__auto__)){
var language = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__34022);
cljs.core.chunk_append(b__34023,(function (){var G__34040 = null;
var G__34041 = (function (){var G__34042 = {"href": "#", "onClick": get_update_handler(language)};
var G__34043 = sablono.interpreter.interpret(stringify(language));
return React.DOM.a(G__34042,G__34043);
})();
return React.DOM.li(G__34040,G__34041);
})());

var G__34051 = (i__34022 + (1));
i__34022 = G__34051;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34023),hatti$shared$language_selector_$_iter__34020(cljs.core.chunk_rest(s__34021__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34023),null);
}
} else {
var language = cljs.core.first(s__34021__$2);
return cljs.core.cons((function (){var G__34046 = null;
var G__34047 = (function (){var G__34048 = {"href": "#", "onClick": get_update_handler(language)};
var G__34049 = sablono.interpreter.interpret(stringify(language));
return React.DOM.a(G__34048,G__34049);
})();
return React.DOM.li(G__34046,G__34047);
})(),hatti$shared$language_selector_$_iter__34020(cljs.core.rest(s__34021__$2)));
}
} else {
return null;
}
break;
}
});})(G__34018,G__34011,G__34012,G__34013,G__34014,G__34008,map__33999,map__33999__$1,ls,current,all,get_update_handler,stringify,___$2))
,null,null));
});})(G__34018,G__34011,G__34012,G__34013,G__34014,G__34008,map__33999,map__33999__$1,ls,current,all,get_update_handler,stringify,___$2))
;
return iter__6990__auto__(all);
})());
return React.DOM.ul(G__34018,G__34019);
})();
return React.DOM.span(G__34011,G__34012,G__34013,G__34014,G__34015);
})();
var G__34010 = (function (){var G__34050 = {"className": "divider"};
return React.DOM.div(G__34050);
})();
return React.DOM.div(G__34008,G__34009,G__34010);
});

hatti.shared.t_hatti$shared33996.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$language_DASH_selector,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"A language selector and a following divider."], null)),cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta33997], null);
});

hatti.shared.t_hatti$shared33996.cljs$lang$type = true;

hatti.shared.t_hatti$shared33996.cljs$lang$ctorStr = "hatti.shared/t_hatti$shared33996";

hatti.shared.t_hatti$shared33996.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"hatti.shared/t_hatti$shared33996");
});

hatti.shared.__GT_t_hatti$shared33996 = (function hatti$shared$language_selector_$___GT_t_hatti$shared33996(language_selector__$1,___$1,owner__$1,meta33997){
return (new hatti.shared.t_hatti$shared33996(language_selector__$1,___$1,owner__$1,meta33997));
});

}

return (new hatti.shared.t_hatti$shared33996(hatti$shared$language_selector,_,owner,cljs.core.PersistentArrayMap.EMPTY));
});
