// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__30173__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__30172 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30172,(0),null);
var body = cljs.core.nthnext(vec__30172,(1));
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.first(body),cljs.core.first(args)], 0)),cljs.core.rest(body));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.first(args),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__30173 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__30174__i = 0, G__30174__a = new Array(arguments.length -  0);
while (G__30174__i < G__30174__a.length) {G__30174__a[G__30174__i] = arguments[G__30174__i + 0]; ++G__30174__i;}
  args = new cljs.core.IndexedSeq(G__30174__a,0);
} 
return G__30173__delegate.call(this,args);};
G__30173.cljs$lang$maxFixedArity = 0;
G__30173.cljs$lang$applyTo = (function (arglist__30175){
var args = cljs.core.seq(arglist__30175);
return G__30173__delegate(args);
});
G__30173.cljs$core$IFn$_invoke$arity$variadic = G__30173__delegate;
return G__30173;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__6990__auto__ = (function sablono$core$update_arglists_$_iter__30182(s__30183){
return (new cljs.core.LazySeq(null,(function (){
var s__30183__$1 = s__30183;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__30183__$1);
if(temp__4657__auto__){
var s__30183__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30183__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__30183__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__30185 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__30184 = (0);
while(true){
if((i__30184 < size__6989__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__30184);
cljs.core.chunk_append(b__30185,cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)));

var G__30188 = (i__30184 + (1));
i__30184 = G__30188;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30185),sablono$core$update_arglists_$_iter__30182(cljs.core.chunk_rest(s__30183__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30185),null);
}
} else {
var args = cljs.core.first(s__30183__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)),sablono$core$update_arglists_$_iter__30182(cljs.core.rest(s__30183__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__(arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7287__auto__ = [];
var len__7280__auto___30196 = arguments.length;
var i__7281__auto___30197 = (0);
while(true){
if((i__7281__auto___30197 < len__7280__auto___30196)){
args__7287__auto__.push((arguments[i__7281__auto___30197]));

var G__30198 = (i__7281__auto___30197 + (1));
i__7281__auto___30197 = G__30198;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__6990__auto__ = (function sablono$core$iter__30190(s__30191){
return (new cljs.core.LazySeq(null,(function (){
var s__30191__$1 = s__30191;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__30191__$1);
if(temp__4657__auto__){
var s__30191__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30191__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__30191__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__30193 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__30192 = (0);
while(true){
if((i__30192 < size__6989__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__30192);
cljs.core.chunk_append(b__30193,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null));

var G__30199 = (i__30192 + (1));
i__30192 = G__30199;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30193),sablono$core$iter__30190(cljs.core.chunk_rest(s__30191__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30193),null);
}
} else {
var style = cljs.core.first(s__30191__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null),sablono$core$iter__30190(cljs.core.rest(s__30191__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq30189){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq30189));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__30204 = goog.dom.getDocument().body;
var G__30205 = (function (){var G__30206 = "script";
var G__30207 = {"src": src};
return goog.dom.createDom(G__30206,G__30207);
})();
return goog.dom.appendChild(G__30204,G__30205);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to30208 = (function sablono$core$link_to30208(var_args){
var args__7287__auto__ = [];
var len__7280__auto___30211 = arguments.length;
var i__7281__auto___30212 = (0);
while(true){
if((i__7281__auto___30212 < len__7280__auto___30211)){
args__7287__auto__.push((arguments[i__7281__auto___30212]));

var G__30213 = (i__7281__auto___30212 + (1));
i__7281__auto___30212 = G__30213;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to30208.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

sablono.core.link_to30208.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([url], 0))], null),content], null);
});

sablono.core.link_to30208.cljs$lang$maxFixedArity = (1);

sablono.core.link_to30208.cljs$lang$applyTo = (function (seq30209){
var G__30210 = cljs.core.first(seq30209);
var seq30209__$1 = cljs.core.next(seq30209);
return sablono.core.link_to30208.cljs$core$IFn$_invoke$arity$variadic(G__30210,seq30209__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to30208);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to30214 = (function sablono$core$mail_to30214(var_args){
var args__7287__auto__ = [];
var len__7280__auto___30219 = arguments.length;
var i__7281__auto___30220 = (0);
while(true){
if((i__7281__auto___30220 < len__7280__auto___30219)){
args__7287__auto__.push((arguments[i__7281__auto___30220]));

var G__30221 = (i__7281__auto___30220 + (1));
i__7281__auto___30220 = G__30221;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to30214.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

sablono.core.mail_to30214.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__30217){
var vec__30218 = p__30217;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30218,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6210__auto__ = content;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to30214.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to30214.cljs$lang$applyTo = (function (seq30215){
var G__30216 = cljs.core.first(seq30215);
var seq30215__$1 = cljs.core.next(seq30215);
return sablono.core.mail_to30214.cljs$core$IFn$_invoke$arity$variadic(G__30216,seq30215__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to30214);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list30222 = (function sablono$core$unordered_list30222(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__6990__auto__ = (function sablono$core$unordered_list30222_$_iter__30229(s__30230){
return (new cljs.core.LazySeq(null,(function (){
var s__30230__$1 = s__30230;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__30230__$1);
if(temp__4657__auto__){
var s__30230__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30230__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__30230__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__30232 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__30231 = (0);
while(true){
if((i__30231 < size__6989__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__30231);
cljs.core.chunk_append(b__30232,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__30235 = (i__30231 + (1));
i__30231 = G__30235;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30232),sablono$core$unordered_list30222_$_iter__30229(cljs.core.chunk_rest(s__30230__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30232),null);
}
} else {
var x = cljs.core.first(s__30230__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$unordered_list30222_$_iter__30229(cljs.core.rest(s__30230__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list30222);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list30236 = (function sablono$core$ordered_list30236(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol,(function (){var iter__6990__auto__ = (function sablono$core$ordered_list30236_$_iter__30243(s__30244){
return (new cljs.core.LazySeq(null,(function (){
var s__30244__$1 = s__30244;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__30244__$1);
if(temp__4657__auto__){
var s__30244__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30244__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__30244__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__30246 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__30245 = (0);
while(true){
if((i__30245 < size__6989__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__30245);
cljs.core.chunk_append(b__30246,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__30249 = (i__30245 + (1));
i__30245 = G__30249;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30246),sablono$core$ordered_list30236_$_iter__30243(cljs.core.chunk_rest(s__30244__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30246),null);
}
} else {
var x = cljs.core.first(s__30244__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$ordered_list30236_$_iter__30243(cljs.core.rest(s__30244__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list30236);
/**
 * Create an image element.
 */
sablono.core.image30250 = (function sablono$core$image30250(var_args){
var args30251 = [];
var len__7280__auto___30254 = arguments.length;
var i__7281__auto___30255 = (0);
while(true){
if((i__7281__auto___30255 < len__7280__auto___30254)){
args30251.push((arguments[i__7281__auto___30255]));

var G__30256 = (i__7281__auto___30255 + (1));
i__7281__auto___30255 = G__30256;
continue;
} else {
}
break;
}

var G__30253 = args30251.length;
switch (G__30253) {
case 1:
return sablono.core.image30250.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image30250.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30251.length)].join('')));

}
});

sablono.core.image30250.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0))], null)], null);
});

sablono.core.image30250.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0)),cljs.core.cst$kw$alt,alt], null)], null);
});

sablono.core.image30250.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs(sablono.core.image30250);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__30258_SHARP_,p2__30259_SHARP_){
return [cljs.core.str(p1__30258_SHARP_),cljs.core.str("["),cljs.core.str(p2__30259_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__30260_SHARP_,p2__30261_SHARP_){
return [cljs.core.str(p1__30260_SHARP_),cljs.core.str("-"),cljs.core.str(p2__30261_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field30262 = (function sablono$core$color_field30262(var_args){
var args30263 = [];
var len__7280__auto___30330 = arguments.length;
var i__7281__auto___30331 = (0);
while(true){
if((i__7281__auto___30331 < len__7280__auto___30330)){
args30263.push((arguments[i__7281__auto___30331]));

var G__30332 = (i__7281__auto___30331 + (1));
i__7281__auto___30331 = G__30332;
continue;
} else {
}
break;
}

var G__30265 = args30263.length;
switch (G__30265) {
case 1:
return sablono.core.color_field30262.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field30262.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30263.length)].join('')));

}
});

sablono.core.color_field30262.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.color_field30262.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.color_field30262.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$color)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.color_field30262.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field30262);

/**
 * Creates a date input field.
 */
sablono.core.date_field30266 = (function sablono$core$date_field30266(var_args){
var args30267 = [];
var len__7280__auto___30334 = arguments.length;
var i__7281__auto___30335 = (0);
while(true){
if((i__7281__auto___30335 < len__7280__auto___30334)){
args30267.push((arguments[i__7281__auto___30335]));

var G__30336 = (i__7281__auto___30335 + (1));
i__7281__auto___30335 = G__30336;
continue;
} else {
}
break;
}

var G__30269 = args30267.length;
switch (G__30269) {
case 1:
return sablono.core.date_field30266.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field30266.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30267.length)].join('')));

}
});

sablono.core.date_field30266.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.date_field30266.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.date_field30266.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$date)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.date_field30266.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field30266);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field30270 = (function sablono$core$datetime_field30270(var_args){
var args30271 = [];
var len__7280__auto___30338 = arguments.length;
var i__7281__auto___30339 = (0);
while(true){
if((i__7281__auto___30339 < len__7280__auto___30338)){
args30271.push((arguments[i__7281__auto___30339]));

var G__30340 = (i__7281__auto___30339 + (1));
i__7281__auto___30339 = G__30340;
continue;
} else {
}
break;
}

var G__30273 = args30271.length;
switch (G__30273) {
case 1:
return sablono.core.datetime_field30270.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field30270.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30271.length)].join('')));

}
});

sablono.core.datetime_field30270.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.datetime_field30270.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.datetime_field30270.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.datetime_field30270.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field30270);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field30274 = (function sablono$core$datetime_local_field30274(var_args){
var args30275 = [];
var len__7280__auto___30342 = arguments.length;
var i__7281__auto___30343 = (0);
while(true){
if((i__7281__auto___30343 < len__7280__auto___30342)){
args30275.push((arguments[i__7281__auto___30343]));

var G__30344 = (i__7281__auto___30343 + (1));
i__7281__auto___30343 = G__30344;
continue;
} else {
}
break;
}

var G__30277 = args30275.length;
switch (G__30277) {
case 1:
return sablono.core.datetime_local_field30274.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field30274.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30275.length)].join('')));

}
});

sablono.core.datetime_local_field30274.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.datetime_local_field30274.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.datetime_local_field30274.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime_DASH_local)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.datetime_local_field30274.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field30274);

/**
 * Creates a email input field.
 */
sablono.core.email_field30278 = (function sablono$core$email_field30278(var_args){
var args30279 = [];
var len__7280__auto___30346 = arguments.length;
var i__7281__auto___30347 = (0);
while(true){
if((i__7281__auto___30347 < len__7280__auto___30346)){
args30279.push((arguments[i__7281__auto___30347]));

var G__30348 = (i__7281__auto___30347 + (1));
i__7281__auto___30347 = G__30348;
continue;
} else {
}
break;
}

var G__30281 = args30279.length;
switch (G__30281) {
case 1:
return sablono.core.email_field30278.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field30278.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30279.length)].join('')));

}
});

sablono.core.email_field30278.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.email_field30278.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.email_field30278.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$email)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.email_field30278.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field30278);

/**
 * Creates a file input field.
 */
sablono.core.file_field30282 = (function sablono$core$file_field30282(var_args){
var args30283 = [];
var len__7280__auto___30350 = arguments.length;
var i__7281__auto___30351 = (0);
while(true){
if((i__7281__auto___30351 < len__7280__auto___30350)){
args30283.push((arguments[i__7281__auto___30351]));

var G__30352 = (i__7281__auto___30351 + (1));
i__7281__auto___30351 = G__30352;
continue;
} else {
}
break;
}

var G__30285 = args30283.length;
switch (G__30285) {
case 1:
return sablono.core.file_field30282.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field30282.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30283.length)].join('')));

}
});

sablono.core.file_field30282.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.file_field30282.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.file_field30282.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$file)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.file_field30282.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field30282);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field30286 = (function sablono$core$hidden_field30286(var_args){
var args30287 = [];
var len__7280__auto___30354 = arguments.length;
var i__7281__auto___30355 = (0);
while(true){
if((i__7281__auto___30355 < len__7280__auto___30354)){
args30287.push((arguments[i__7281__auto___30355]));

var G__30356 = (i__7281__auto___30355 + (1));
i__7281__auto___30355 = G__30356;
continue;
} else {
}
break;
}

var G__30289 = args30287.length;
switch (G__30289) {
case 1:
return sablono.core.hidden_field30286.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field30286.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30287.length)].join('')));

}
});

sablono.core.hidden_field30286.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.hidden_field30286.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.hidden_field30286.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$hidden)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.hidden_field30286.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field30286);

/**
 * Creates a month input field.
 */
sablono.core.month_field30290 = (function sablono$core$month_field30290(var_args){
var args30291 = [];
var len__7280__auto___30358 = arguments.length;
var i__7281__auto___30359 = (0);
while(true){
if((i__7281__auto___30359 < len__7280__auto___30358)){
args30291.push((arguments[i__7281__auto___30359]));

var G__30360 = (i__7281__auto___30359 + (1));
i__7281__auto___30359 = G__30360;
continue;
} else {
}
break;
}

var G__30293 = args30291.length;
switch (G__30293) {
case 1:
return sablono.core.month_field30290.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field30290.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30291.length)].join('')));

}
});

sablono.core.month_field30290.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.month_field30290.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.month_field30290.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$month)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.month_field30290.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field30290);

/**
 * Creates a number input field.
 */
sablono.core.number_field30294 = (function sablono$core$number_field30294(var_args){
var args30295 = [];
var len__7280__auto___30362 = arguments.length;
var i__7281__auto___30363 = (0);
while(true){
if((i__7281__auto___30363 < len__7280__auto___30362)){
args30295.push((arguments[i__7281__auto___30363]));

var G__30364 = (i__7281__auto___30363 + (1));
i__7281__auto___30363 = G__30364;
continue;
} else {
}
break;
}

var G__30297 = args30295.length;
switch (G__30297) {
case 1:
return sablono.core.number_field30294.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field30294.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30295.length)].join('')));

}
});

sablono.core.number_field30294.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.number_field30294.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.number_field30294.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$number)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.number_field30294.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field30294);

/**
 * Creates a password input field.
 */
sablono.core.password_field30298 = (function sablono$core$password_field30298(var_args){
var args30299 = [];
var len__7280__auto___30366 = arguments.length;
var i__7281__auto___30367 = (0);
while(true){
if((i__7281__auto___30367 < len__7280__auto___30366)){
args30299.push((arguments[i__7281__auto___30367]));

var G__30368 = (i__7281__auto___30367 + (1));
i__7281__auto___30367 = G__30368;
continue;
} else {
}
break;
}

var G__30301 = args30299.length;
switch (G__30301) {
case 1:
return sablono.core.password_field30298.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field30298.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30299.length)].join('')));

}
});

sablono.core.password_field30298.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.password_field30298.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.password_field30298.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$password)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.password_field30298.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field30298);

/**
 * Creates a range input field.
 */
sablono.core.range_field30302 = (function sablono$core$range_field30302(var_args){
var args30303 = [];
var len__7280__auto___30370 = arguments.length;
var i__7281__auto___30371 = (0);
while(true){
if((i__7281__auto___30371 < len__7280__auto___30370)){
args30303.push((arguments[i__7281__auto___30371]));

var G__30372 = (i__7281__auto___30371 + (1));
i__7281__auto___30371 = G__30372;
continue;
} else {
}
break;
}

var G__30305 = args30303.length;
switch (G__30305) {
case 1:
return sablono.core.range_field30302.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field30302.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30303.length)].join('')));

}
});

sablono.core.range_field30302.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.range_field30302.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.range_field30302.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$range)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.range_field30302.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field30302);

/**
 * Creates a search input field.
 */
sablono.core.search_field30306 = (function sablono$core$search_field30306(var_args){
var args30307 = [];
var len__7280__auto___30374 = arguments.length;
var i__7281__auto___30375 = (0);
while(true){
if((i__7281__auto___30375 < len__7280__auto___30374)){
args30307.push((arguments[i__7281__auto___30375]));

var G__30376 = (i__7281__auto___30375 + (1));
i__7281__auto___30375 = G__30376;
continue;
} else {
}
break;
}

var G__30309 = args30307.length;
switch (G__30309) {
case 1:
return sablono.core.search_field30306.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field30306.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30307.length)].join('')));

}
});

sablono.core.search_field30306.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.search_field30306.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.search_field30306.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$search)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.search_field30306.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field30306);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field30310 = (function sablono$core$tel_field30310(var_args){
var args30311 = [];
var len__7280__auto___30378 = arguments.length;
var i__7281__auto___30379 = (0);
while(true){
if((i__7281__auto___30379 < len__7280__auto___30378)){
args30311.push((arguments[i__7281__auto___30379]));

var G__30380 = (i__7281__auto___30379 + (1));
i__7281__auto___30379 = G__30380;
continue;
} else {
}
break;
}

var G__30313 = args30311.length;
switch (G__30313) {
case 1:
return sablono.core.tel_field30310.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field30310.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30311.length)].join('')));

}
});

sablono.core.tel_field30310.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.tel_field30310.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.tel_field30310.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$tel)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.tel_field30310.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field30310);

/**
 * Creates a text input field.
 */
sablono.core.text_field30314 = (function sablono$core$text_field30314(var_args){
var args30315 = [];
var len__7280__auto___30382 = arguments.length;
var i__7281__auto___30383 = (0);
while(true){
if((i__7281__auto___30383 < len__7280__auto___30382)){
args30315.push((arguments[i__7281__auto___30383]));

var G__30384 = (i__7281__auto___30383 + (1));
i__7281__auto___30383 = G__30384;
continue;
} else {
}
break;
}

var G__30317 = args30315.length;
switch (G__30317) {
case 1:
return sablono.core.text_field30314.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field30314.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30315.length)].join('')));

}
});

sablono.core.text_field30314.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.text_field30314.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.text_field30314.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$text)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.text_field30314.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field30314);

/**
 * Creates a time input field.
 */
sablono.core.time_field30318 = (function sablono$core$time_field30318(var_args){
var args30319 = [];
var len__7280__auto___30386 = arguments.length;
var i__7281__auto___30387 = (0);
while(true){
if((i__7281__auto___30387 < len__7280__auto___30386)){
args30319.push((arguments[i__7281__auto___30387]));

var G__30388 = (i__7281__auto___30387 + (1));
i__7281__auto___30387 = G__30388;
continue;
} else {
}
break;
}

var G__30321 = args30319.length;
switch (G__30321) {
case 1:
return sablono.core.time_field30318.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field30318.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30319.length)].join('')));

}
});

sablono.core.time_field30318.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.time_field30318.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.time_field30318.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$time)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.time_field30318.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field30318);

/**
 * Creates a url input field.
 */
sablono.core.url_field30322 = (function sablono$core$url_field30322(var_args){
var args30323 = [];
var len__7280__auto___30390 = arguments.length;
var i__7281__auto___30391 = (0);
while(true){
if((i__7281__auto___30391 < len__7280__auto___30390)){
args30323.push((arguments[i__7281__auto___30391]));

var G__30392 = (i__7281__auto___30391 + (1));
i__7281__auto___30391 = G__30392;
continue;
} else {
}
break;
}

var G__30325 = args30323.length;
switch (G__30325) {
case 1:
return sablono.core.url_field30322.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field30322.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30323.length)].join('')));

}
});

sablono.core.url_field30322.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.url_field30322.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.url_field30322.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$url)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.url_field30322.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field30322);

/**
 * Creates a week input field.
 */
sablono.core.week_field30326 = (function sablono$core$week_field30326(var_args){
var args30327 = [];
var len__7280__auto___30394 = arguments.length;
var i__7281__auto___30395 = (0);
while(true){
if((i__7281__auto___30395 < len__7280__auto___30394)){
args30327.push((arguments[i__7281__auto___30395]));

var G__30396 = (i__7281__auto___30395 + (1));
i__7281__auto___30395 = G__30396;
continue;
} else {
}
break;
}

var G__30329 = args30327.length;
switch (G__30329) {
case 1:
return sablono.core.week_field30326.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field30326.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30327.length)].join('')));

}
});

sablono.core.week_field30326.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.week_field30326.cljs$core$IFn$_invoke$arity$2(name__15385__auto__,null);
});

sablono.core.week_field30326.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$week)].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.week_field30326.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field30326);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box30398 = (function sablono$core$check_box30398(var_args){
var args30399 = [];
var len__7280__auto___30402 = arguments.length;
var i__7281__auto___30403 = (0);
while(true){
if((i__7281__auto___30403 < len__7280__auto___30402)){
args30399.push((arguments[i__7281__auto___30403]));

var G__30404 = (i__7281__auto___30403 + (1));
i__7281__auto___30403 = G__30404;
continue;
} else {
}
break;
}

var G__30401 = args30399.length;
switch (G__30401) {
case 1:
return sablono.core.check_box30398.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box30398.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box30398.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30399.length)].join('')));

}
});

sablono.core.check_box30398.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box30398.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.check_box30398.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box30398.cljs$core$IFn$_invoke$arity$3(name,checked_QMARK_,"true");
});

sablono.core.check_box30398.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.check_box30398.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box30398);
/**
 * Creates a radio button.
 */
sablono.core.radio_button30406 = (function sablono$core$radio_button30406(var_args){
var args30407 = [];
var len__7280__auto___30410 = arguments.length;
var i__7281__auto___30411 = (0);
while(true){
if((i__7281__auto___30411 < len__7280__auto___30410)){
args30407.push((arguments[i__7281__auto___30411]));

var G__30412 = (i__7281__auto___30411 + (1));
i__7281__auto___30411 = G__30412;
continue;
} else {
}
break;
}

var G__30409 = args30407.length;
switch (G__30409) {
case 1:
return sablono.core.radio_button30406.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button30406.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button30406.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30407.length)].join('')));

}
});

sablono.core.radio_button30406.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button30406.cljs$core$IFn$_invoke$arity$2(group,null);
});

sablono.core.radio_button30406.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button30406.cljs$core$IFn$_invoke$arity$3(group,checked_QMARK_,"true");
});

sablono.core.radio_button30406.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$name,sablono.core.make_name(group),cljs.core.cst$kw$id,sablono.core.make_id([cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([group], 0))),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([value], 0)))].join('')),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.radio_button30406.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button30406);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options30414 = (function sablono$core$select_options30414(var_args){
var args30415 = [];
var len__7280__auto___30428 = arguments.length;
var i__7281__auto___30429 = (0);
while(true){
if((i__7281__auto___30429 < len__7280__auto___30428)){
args30415.push((arguments[i__7281__auto___30429]));

var G__30430 = (i__7281__auto___30429 + (1));
i__7281__auto___30429 = G__30430;
continue;
} else {
}
break;
}

var G__30417 = args30415.length;
switch (G__30417) {
case 1:
return sablono.core.select_options30414.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options30414.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30415.length)].join('')));

}
});

sablono.core.select_options30414.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options30414.cljs$core$IFn$_invoke$arity$2(coll,null);
});

sablono.core.select_options30414.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__6990__auto__ = (function sablono$core$iter__30418(s__30419){
return (new cljs.core.LazySeq(null,(function (){
var s__30419__$1 = s__30419;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__30419__$1);
if(temp__4657__auto__){
var s__30419__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30419__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__30419__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__30421 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__30420 = (0);
while(true){
if((i__30420 < size__6989__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__30420);
cljs.core.chunk_append(b__30421,((cljs.core.sequential_QMARK_(x))?(function (){var vec__30426 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30426,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30426,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30426,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options30414.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)));

var G__30432 = (i__30420 + (1));
i__30420 = G__30432;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30421),sablono$core$iter__30418(cljs.core.chunk_rest(s__30419__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30421),null);
}
} else {
var x = cljs.core.first(s__30419__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__30427 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30427,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30427,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30427,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options30414.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)),sablono$core$iter__30418(cljs.core.rest(s__30419__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__(coll);
});

sablono.core.select_options30414.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options30414);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down30433 = (function sablono$core$drop_down30433(var_args){
var args30434 = [];
var len__7280__auto___30437 = arguments.length;
var i__7281__auto___30438 = (0);
while(true){
if((i__7281__auto___30438 < len__7280__auto___30437)){
args30434.push((arguments[i__7281__auto___30438]));

var G__30439 = (i__7281__auto___30438 + (1));
i__7281__auto___30438 = G__30439;
continue;
} else {
}
break;
}

var G__30436 = args30434.length;
switch (G__30436) {
case 2:
return sablono.core.drop_down30433.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down30433.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30434.length)].join('')));

}
});

sablono.core.drop_down30433.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down30433.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down30433.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down30433.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down30433);
/**
 * Creates a text area element.
 */
sablono.core.text_area30441 = (function sablono$core$text_area30441(var_args){
var args30442 = [];
var len__7280__auto___30445 = arguments.length;
var i__7281__auto___30446 = (0);
while(true){
if((i__7281__auto___30446 < len__7280__auto___30445)){
args30442.push((arguments[i__7281__auto___30446]));

var G__30447 = (i__7281__auto___30446 + (1));
i__7281__auto___30446 = G__30447;
continue;
} else {
}
break;
}

var G__30444 = args30442.length;
switch (G__30444) {
case 1:
return sablono.core.text_area30441.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area30441.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30442.length)].join('')));

}
});

sablono.core.text_area30441.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area30441.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.text_area30441.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});

sablono.core.text_area30441.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area30441);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label30449 = (function sablono$core$label30449(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$htmlFor,sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label30449);
/**
 * Creates a submit button.
 */
sablono.core.submit_button30450 = (function sablono$core$submit_button30450(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button30450);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button30451 = (function sablono$core$reset_button30451(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"reset",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button30451);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to30452 = (function sablono$core$form_to30452(var_args){
var args__7287__auto__ = [];
var len__7280__auto___30457 = arguments.length;
var i__7281__auto___30458 = (0);
while(true){
if((i__7281__auto___30458 < len__7280__auto___30457)){
args__7287__auto__.push((arguments[i__7281__auto___30458]));

var G__30459 = (i__7281__auto___30458 + (1));
i__7281__auto___30458 = G__30459;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to30452.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

sablono.core.form_to30452.cljs$core$IFn$_invoke$arity$variadic = (function (p__30455,body){
var vec__30456 = p__30455;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30456,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30456,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$get,null,cljs.core.cst$kw$post,null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,method_str,cljs.core.cst$kw$action,action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,"POST",cljs.core.cst$kw$action,action_uri], null),(sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2("_method",method_str) : sablono.core.hidden_field.call(null,"_method",method_str))], null)),body));
});

sablono.core.form_to30452.cljs$lang$maxFixedArity = (1);

sablono.core.form_to30452.cljs$lang$applyTo = (function (seq30453){
var G__30454 = cljs.core.first(seq30453);
var seq30453__$1 = cljs.core.next(seq30453);
return sablono.core.form_to30452.cljs$core$IFn$_invoke$arity$variadic(G__30454,seq30453__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to30452);
