// Compiled by ClojureScript 1.8.51 {}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('chimera.urls');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten.call(null,(function (){var iter__6990__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__19779(s__19780){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__19780__$1 = s__19780;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19780__$1);
if(temp__4657__auto__){
var s__19780__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19780__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__19780__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__19782 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__19781 = (0);
while(true){
if((i__19781 < size__6989__auto__)){
var datum = cljs.core._nth.call(null,c__6988__auto__,i__19781);
cljs.core.chunk_append.call(null,b__19782,(function (){var iter__6990__auto__ = ((function (i__19781,datum,c__6988__auto__,size__6989__auto__,b__19782,s__19780__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__19779_$_iter__19791(s__19792){
return (new cljs.core.LazySeq(null,((function (i__19781,datum,c__6988__auto__,size__6989__auto__,b__19782,s__19780__$2,temp__4657__auto__,osmfields){
return (function (){
var s__19792__$1 = s__19792;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__19792__$1);
if(temp__4657__auto____$1){
var s__19792__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19792__$2)){
var c__6988__auto____$1 = cljs.core.chunk_first.call(null,s__19792__$2);
var size__6989__auto____$1 = cljs.core.count.call(null,c__6988__auto____$1);
var b__19794 = cljs.core.chunk_buffer.call(null,size__6989__auto____$1);
if((function (){var i__19793 = (0);
while(true){
if((i__19793 < size__6989__auto____$1)){
var field = cljs.core._nth.call(null,c__6988__auto____$1,i__19793);
cljs.core.chunk_append.call(null,b__19794,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6198__auto__ = osmdatum;
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6198__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__19799 = (i__19793 + (1));
i__19793 = G__19799;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19794),hatti$ona$post_process$ona_osm_link_$_iter__19779_$_iter__19791.call(null,cljs.core.chunk_rest.call(null,s__19792__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19794),null);
}
} else {
var field = cljs.core.first.call(null,s__19792__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6198__auto__ = osmdatum;
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6198__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__19779_$_iter__19791.call(null,cljs.core.rest.call(null,s__19792__$2)));
}
} else {
return null;
}
break;
}
});})(i__19781,datum,c__6988__auto__,size__6989__auto__,b__19782,s__19780__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__19781,datum,c__6988__auto__,size__6989__auto__,b__19782,s__19780__$2,temp__4657__auto__,osmfields))
;
return iter__6990__auto__.call(null,osmfields);
})());

var G__19800 = (i__19781 + (1));
i__19781 = G__19800;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19782),hatti$ona$post_process$ona_osm_link_$_iter__19779.call(null,cljs.core.chunk_rest.call(null,s__19780__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19782),null);
}
} else {
var datum = cljs.core.first.call(null,s__19780__$2);
return cljs.core.cons.call(null,(function (){var iter__6990__auto__ = ((function (datum,s__19780__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__19779_$_iter__19795(s__19796){
return (new cljs.core.LazySeq(null,((function (datum,s__19780__$2,temp__4657__auto__,osmfields){
return (function (){
var s__19796__$1 = s__19796;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__19796__$1);
if(temp__4657__auto____$1){
var s__19796__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19796__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__19796__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__19798 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__19797 = (0);
while(true){
if((i__19797 < size__6989__auto__)){
var field = cljs.core._nth.call(null,c__6988__auto__,i__19797);
cljs.core.chunk_append.call(null,b__19798,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6198__auto__ = osmdatum;
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6198__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__19801 = (i__19797 + (1));
i__19797 = G__19801;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19798),hatti$ona$post_process$ona_osm_link_$_iter__19779_$_iter__19795.call(null,cljs.core.chunk_rest.call(null,s__19796__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19798),null);
}
} else {
var field = cljs.core.first.call(null,s__19796__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6198__auto__ = osmdatum;
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6198__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__19779_$_iter__19795.call(null,cljs.core.rest.call(null,s__19796__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__19780__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__19780__$2,temp__4657__auto__,osmfields))
;
return iter__6990__auto__.call(null,osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__19779.call(null,cljs.core.rest.call(null,s__19780__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__6990__auto__.call(null,data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.call(null,osmtogeojson(jQuery.parseXML(osm_xml_string)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link.call(null,data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson.call(null,osm_xml);
var featureset = osmgeo.call(null,new cljs.core.Keyword(null,"features","features",-1146962336));
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6990__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__19822(s__19823){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__19823__$1 = s__19823;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19823__$1);
if(temp__4657__auto__){
var s__19823__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19823__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__19823__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__19825 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__19824 = (0);
while(true){
if((i__19824 < size__6989__auto__)){
var map__19834 = cljs.core._nth.call(null,c__6988__auto__,i__19824);
var map__19834__$1 = ((((!((map__19834 == null)))?((((map__19834.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19834.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19834):map__19834);
var feature = map__19834__$1;
var type = cljs.core.get.call(null,map__19834__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__19834__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__19834__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
cljs.core.chunk_append.call(null,b__19825,(function (){var map__19836 = properties;
var map__19836__$1 = ((((!((map__19836 == null)))?((((map__19836.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19836.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19836):map__19836);
var type__$1 = cljs.core.get.call(null,map__19836__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__19836__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__19836__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})());

var G__19842 = (i__19824 + (1));
i__19824 = G__19842;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19825),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__19822.call(null,cljs.core.chunk_rest.call(null,s__19823__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19825),null);
}
} else {
var map__19838 = cljs.core.first.call(null,s__19823__$2);
var map__19838__$1 = ((((!((map__19838 == null)))?((((map__19838.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19838.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19838):map__19838);
var feature = map__19838__$1;
var type = cljs.core.get.call(null,map__19838__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__19838__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__19838__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
return cljs.core.cons.call(null,(function (){var map__19840 = properties;
var map__19840__$1 = ((((!((map__19840 == null)))?((((map__19840.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19840.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19840):map__19840);
var type__$1 = cljs.core.get.call(null,map__19840__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__19840__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__19840__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__19822.call(null,cljs.core.rest.call(null,s__19823__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__6990__auto__.call(null,featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq.call(null,osm_fields)){
var data = cljs.core.get_in.call(null,app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data.call(null,data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__19843_SHARP_){
return cljs.core.re_find.call(null,/[-]?[0-9]+/,p1__19843_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = osm_data.call(null,osm_val__GT_osm_id.call(null,osm_val));
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__6990__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__19852(s__19853){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__19853__$1 = s__19853;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19853__$1);
if(temp__4657__auto__){
var s__19853__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19853__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__19853__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__19855 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__19854 = (0);
while(true){
if((i__19854 < size__6989__auto__)){
var datum = cljs.core._nth.call(null,c__6988__auto__,i__19854);
cljs.core.chunk_append.call(null,b__19855,cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__19860 = (i__19854 + (1));
i__19854 = G__19860;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19855),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__19852.call(null,cljs.core.chunk_rest.call(null,s__19853__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19855),null);
}
} else {
var datum = cljs.core.first.call(null,s__19853__$2);
return cljs.core.cons.call(null,cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__19852.call(null,cljs.core.rest.call(null,s__19853__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__6990__auto__.call(null,data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__19856 = cljs.core.seq.call(null,osm_fields);
var chunk__19857 = null;
var count__19858 = (0);
var i__19859 = (0);
while(true){
if((i__19859 < count__19858)){
var osm_field = cljs.core._nth.call(null,chunk__19857,i__19859);
chimera.om.state.transact_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__19861 = seq__19856;
var G__19862 = chunk__19857;
var G__19863 = count__19858;
var G__19864 = (i__19859 + (1));
seq__19856 = G__19861;
chunk__19857 = G__19862;
count__19858 = G__19863;
i__19859 = G__19864;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__19856);
if(temp__4657__auto__){
var seq__19856__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19856__$1)){
var c__7021__auto__ = cljs.core.chunk_first.call(null,seq__19856__$1);
var G__19865 = cljs.core.chunk_rest.call(null,seq__19856__$1);
var G__19866 = c__7021__auto__;
var G__19867 = cljs.core.count.call(null,c__7021__auto__);
var G__19868 = (0);
seq__19856 = G__19865;
chunk__19857 = G__19866;
count__19858 = G__19867;
i__19859 = G__19868;
continue;
} else {
var osm_field = cljs.core.first.call(null,seq__19856__$1);
chimera.om.state.transact_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__19869 = cljs.core.next.call(null,seq__19856__$1);
var G__19870 = null;
var G__19871 = (0);
var G__19872 = (0);
seq__19856 = G__19869;
chunk__19857 = G__19870;
count__19858 = G__19871;
i__19859 = G__19872;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.call(null,media_obj,"id");
var fname = cljs.core.get.call(null,media_obj,"filename");
var file_url = hatti.ona.urls.media_url.call(null,media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"filename","filename",-1428840783),fname,new cljs.core.Keyword(null,"download_url","download_url",-2115471203),file_url,new cljs.core.Keyword(null,"small_download_url","small_download_url",1654303565),[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__6210__auto__ = attachments;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return cljs.core.get.call(null,record,"_attachments");
}
})();
var fnames = cljs.core.map.call(null,((function (attachments__$1){
return (function (p1__19873_SHARP_){
return chimera.urls.last_url_param.call(null,cljs.core.get.call(null,p1__19873_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap.call(null,fnames,cljs.core.map.call(null,hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.call(null,fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__7287__auto__ = [];
var len__7280__auto___19884 = arguments.length;
var i__7281__auto___19885 = (0);
while(true){
if((i__7281__auto___19885 < len__7280__auto___19884)){
args__7287__auto__.push((arguments[i__7281__auto___19885]));

var G__19886 = (i__7281__auto___19885 + (1));
i__7281__auto___19885 = G__19886;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((2) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7288__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__19877){
var map__19878 = p__19877;
var map__19878__$1 = ((((!((map__19878 == null)))?((((map__19878.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19878.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19878):map__19878);
var attachments = cljs.core.get.call(null,map__19878__$1,new cljs.core.Keyword(null,"attachments","attachments",-1535547830));
var image_fields = cljs.core.filter.call(null,hatti.ona.forms.image_QMARK_,flat_form);
var iter__6990__auto__ = ((function (image_fields,map__19878,map__19878__$1,attachments){
return (function hatti$ona$post_process$iter__19880(s__19881){
return (new cljs.core.LazySeq(null,((function (image_fields,map__19878,map__19878__$1,attachments){
return (function (){
var s__19881__$1 = s__19881;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19881__$1);
if(temp__4657__auto__){
var s__19881__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19881__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__19881__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__19883 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__19882 = (0);
while(true){
if((i__19882 < size__6989__auto__)){
var record = cljs.core._nth.call(null,c__6988__auto__,i__19882);
cljs.core.chunk_append.call(null,b__19883,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (i__19882,attach_map,record,c__6988__auto__,size__6989__auto__,b__19883,s__19881__$2,temp__4657__auto__,image_fields,map__19878,map__19878__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__19882,attach_map,record,c__6988__auto__,size__6989__auto__,b__19883,s__19881__$2,temp__4657__auto__,image_fields,map__19878,map__19878__$1,attachments))
,record,image_fields);
})());

var G__19887 = (i__19882 + (1));
i__19882 = G__19887;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19883),hatti$ona$post_process$iter__19880.call(null,cljs.core.chunk_rest.call(null,s__19881__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19883),null);
}
} else {
var record = cljs.core.first.call(null,s__19881__$2);
return cljs.core.cons.call(null,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (attach_map,record,s__19881__$2,temp__4657__auto__,image_fields,map__19878,map__19878__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__19881__$2,temp__4657__auto__,image_fields,map__19878,map__19878__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__19880.call(null,cljs.core.rest.call(null,s__19881__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__19878,map__19878__$1,attachments))
,null,null));
});})(image_fields,map__19878,map__19878__$1,attachments))
;
return iter__6990__auto__.call(null,data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq19874){
var G__19875 = cljs.core.first.call(null,seq19874);
var seq19874__$1 = cljs.core.next.call(null,seq19874);
var G__19876 = cljs.core.first.call(null,seq19874__$1);
var seq19874__$2 = cljs.core.next.call(null,seq19874__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__19875,G__19876,seq19874__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.call(null,hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.call(null,record,key,hatti.ona.post_process.integrate_attachments.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.call(null,record,key),new cljs.core.Keyword(null,"attachments","attachments",-1535547830),cljs.core.get.call(null,record,"_attachments")));
});})(repeat_fields))
;
var iter__6990__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__19892(s__19893){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__19893__$1 = s__19893;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19893__$1);
if(temp__4657__auto__){
var s__19893__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19893__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__19893__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__19895 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__19894 = (0);
while(true){
if((i__19894 < size__6989__auto__)){
var record = cljs.core._nth.call(null,c__6988__auto__,i__19894);
cljs.core.chunk_append.call(null,b__19895,cljs.core.reduce.call(null,integrate,record,repeat_fields));

var G__19896 = (i__19894 + (1));
i__19894 = G__19896;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19895),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__19892.call(null,cljs.core.chunk_rest.call(null,s__19893__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19895),null);
}
} else {
var record = cljs.core.first.call(null,s__19893__$2);
return cljs.core.cons.call(null,cljs.core.reduce.call(null,integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__19892.call(null,cljs.core.rest.call(null,s__19893__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__6990__auto__.call(null,data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___19904 = arguments.length;
var i__7281__auto___19905 = (0);
while(true){
if((i__7281__auto___19905 < len__7280__auto___19904)){
args__7287__auto__.push((arguments[i__7281__auto___19905]));

var G__19906 = (i__7281__auto___19905 + (1));
i__7281__auto___19905 = G__19906;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((2) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7288__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__19901){
var map__19902 = p__19901;
var map__19902__$1 = ((((!((map__19902 == null)))?((((map__19902.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19902.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19902):map__19902);
var app_data_keys = cljs.core.get.call(null,map__19902__$1,new cljs.core.Keyword(null,"app-data-keys","app-data-keys",-662378404),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
return chimera.om.state.transact_BANG_.call(null,app_state,app_data_keys,((function (map__19902,map__19902__$1,app_data_keys){
return (function (p1__19897_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats.call(null,flat_form,hatti.ona.post_process.integrate_attachments.call(null,flat_form,p1__19897_SHARP_));
});})(map__19902,map__19902__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq19898){
var G__19899 = cljs.core.first.call(null,seq19898);
var seq19898__$1 = cljs.core.next.call(null,seq19898);
var G__19900 = cljs.core.first.call(null,seq19898__$1);
var seq19898__$2 = cljs.core.next.call(null,seq19898__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19899,G__19900,seq19898__$2);
});
