// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('c2.svg');
goog.require('cljs.core');
goog.require('c2.core');
goog.require('c2.maths');
goog.require('c2.dom');
/**
 * Ensure that coordinates (potentially map of `{:x :y}`) are a seq or vector pair.
 */
c2.svg.__GT_xy = (function c2$svg$__GT_xy(coordinates){
if((cljs.core.sequential_QMARK_(coordinates)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),cljs.core.count(coordinates)))){
return coordinates;
} else {
if(cljs.core.map_QMARK_(coordinates)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(coordinates),cljs.core.cst$kw$y.cljs$core$IFn$_invoke$arity$1(coordinates)], null);
} else {
return null;
}
}
});
c2.svg.translate = (function c2$svg$translate(coordinates){
var vec__32116 = c2.svg.__GT_xy(coordinates);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32116,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32116,(1),null);
return [cljs.core.str("translate("),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
});
c2.svg.scale = (function c2$svg$scale(coordinates){
if(typeof coordinates === 'number'){
return [cljs.core.str("scale("),cljs.core.str(coordinates),cljs.core.str(")")].join('');
} else {
var vec__32118 = c2.svg.__GT_xy(coordinates);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32118,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32118,(1),null);
return [cljs.core.str("scale("),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
}
});
c2.svg.rotate = (function c2$svg$rotate(var_args){
var args32119 = [];
var len__7280__auto___32123 = arguments.length;
var i__7281__auto___32124 = (0);
while(true){
if((i__7281__auto___32124 < len__7280__auto___32123)){
args32119.push((arguments[i__7281__auto___32124]));

var G__32125 = (i__7281__auto___32124 + (1));
i__7281__auto___32124 = G__32125;
continue;
} else {
}
break;
}

var G__32121 = args32119.length;
switch (G__32121) {
case 1:
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32119.length)].join('')));

}
});

c2.svg.rotate.cljs$core$IFn$_invoke$arity$1 = (function (angle){
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$2(angle,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null));
});

c2.svg.rotate.cljs$core$IFn$_invoke$arity$2 = (function (angle,coordinates){
var vec__32122 = c2.svg.__GT_xy(coordinates);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32122,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32122,(1),null);
return [cljs.core.str("rotate("),cljs.core.str(angle),cljs.core.str(","),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
});

c2.svg.rotate.cljs$lang$maxFixedArity = 2;
/**
 * Returns map of `{:x :y :width :height}` containing SVG element bounding box.
 * All coordinates are in userspace. Ref [SVG spec](http://www.w3.org/TR/SVG/types.html#InterfaceSVGLocatable)
 */
c2.svg.get_bounds = (function c2$svg$get_bounds($svg_el){
var b = $svg_el.getBBox();
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$x,b.x,cljs.core.cst$kw$y,b.y,cljs.core.cst$kw$width,b.width,cljs.core.cst$kw$height,b.height], null);
});
/**
 * Returns a transform string that will scale and center provided element `{:width :height :x :y}` within container `{:width :height}`.
 */
c2.svg.transform_to_center = (function c2$svg$transform_to_center(element,container){
var map__32131 = element;
var map__32131__$1 = ((((!((map__32131 == null)))?((((map__32131.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32131.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32131):map__32131);
var ew = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32131__$1,cljs.core.cst$kw$width);
var eh = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32131__$1,cljs.core.cst$kw$height);
var x = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32131__$1,cljs.core.cst$kw$x);
var y = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32131__$1,cljs.core.cst$kw$y);
var map__32132 = container;
var map__32132__$1 = ((((!((map__32132 == null)))?((((map__32132.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32132.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32132):map__32132);
var w = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32132__$1,cljs.core.cst$kw$width);
var h = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32132__$1,cljs.core.cst$kw$height);
var s = (function (){var x__6548__auto__ = (h / eh);
var y__6549__auto__ = (w / ew);
return ((x__6548__auto__ < y__6549__auto__) ? x__6548__auto__ : y__6549__auto__);
})();
return [cljs.core.str(c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((w / (2)) - (s * (ew / (2)))),((h / (2)) - (s * (eh / (2))))], null))),cljs.core.str(" "),cljs.core.str(c2.svg.scale(s)),cljs.core.str(" "),cljs.core.str(c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(- x),(- y)], null)))].join('');
});
/**
 * Scales and centers `$svg-el` within its parent SVG container.
 * Uses parent's width and height attributes only.
 */
c2.svg.transform_to_center_BANG_ = (function c2$svg$transform_to_center_BANG_($svg_el){
var $svg = $svg_el.ownerSVGElement;
var t = c2.svg.transform_to_center(c2.svg.get_bounds($svg_el),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,(function (){var G__32137 = c2.dom.attr.cljs$core$IFn$_invoke$arity$2($svg,cljs.core.cst$kw$width);
return parseFloat(G__32137);
})(),cljs.core.cst$kw$height,(function (){var G__32138 = c2.dom.attr.cljs$core$IFn$_invoke$arity$2($svg,cljs.core.cst$kw$height);
return parseFloat(G__32138);
})()], null));
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3($svg_el,cljs.core.cst$kw$transform,t);
});
/**
 * Returns axis <g> hiccup vector for provided input `scale` and collection of `ticks` (numbers).
 * Direction away from the data frame is defined to be positive; use negative margins and widths to render axis inside of data frame.
 * 
 * Kwargs:
 * 
 * > *:orientation* &in; (`:top`, `:bottom`, `:left`, `:right`), where the axis should be relative to the data frame, defaults to `:left`
 * 
 * > *:formatter* fn run on tick values, defaults to `str`
 * 
 * > *:major-tick-width* width of ticks (minor ticks not yet implemented), defaults to 6
 * 
 * > *:text-margin* distance between axis and start of text, defaults to 9
 * 
 * > *:label* axis label, centered on axis; :left and :right orientation labels are rotated by +/- pi/2, respectively
 * 
 * > *:label-margin* distance between axis and label, defaults to 28
 */
c2.svg.axis = (function c2$svg$axis(var_args){
var args__7287__auto__ = [];
var len__7280__auto___32151 = arguments.length;
var i__7281__auto___32152 = (0);
while(true){
if((i__7281__auto___32152 < len__7280__auto___32151)){
args__7287__auto__.push((arguments[i__7281__auto___32152]));

var G__32153 = (i__7281__auto___32152 + (1));
i__7281__auto___32152 = G__32153;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((2) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((2)),(0),null)):null);
return c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7288__auto__);
});

c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic = (function (scale,ticks,p__32142){
var map__32143 = p__32142;
var map__32143__$1 = ((((!((map__32143 == null)))?((((map__32143.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32143.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32143):map__32143);
var orientation = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32143__$1,cljs.core.cst$kw$orientation,cljs.core.cst$kw$left);
var formatter = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32143__$1,cljs.core.cst$kw$formatter,cljs.core.str);
var major_tick_width = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32143__$1,cljs.core.cst$kw$major_DASH_tick_DASH_width,(6));
var text_margin = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32143__$1,cljs.core.cst$kw$text_DASH_margin,(9));
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32143__$1,cljs.core.cst$kw$label);
var label_margin = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32143__$1,cljs.core.cst$kw$label_DASH_margin,(28));
var vec__32145 = (function (){var G__32146 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__32146) {
case "left":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x,cljs.core.cst$kw$y,cljs.core.cst$kw$x1,cljs.core.cst$kw$x2,cljs.core.cst$kw$y1,cljs.core.cst$kw$y2], null);

break;
case "right":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x,cljs.core.cst$kw$y,cljs.core.cst$kw$x1,cljs.core.cst$kw$x2,cljs.core.cst$kw$y1,cljs.core.cst$kw$y2], null);

break;
case "top":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$y,cljs.core.cst$kw$x,cljs.core.cst$kw$y1,cljs.core.cst$kw$y2,cljs.core.cst$kw$x1,cljs.core.cst$kw$x2], null);

break;
case "bottom":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$y,cljs.core.cst$kw$x,cljs.core.cst$kw$y1,cljs.core.cst$kw$y2,cljs.core.cst$kw$x1,cljs.core.cst$kw$x2], null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(orientation)].join('')));

}
})();
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32145,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32145,(1),null);
var x1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32145,(2),null);
var x2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32145,(3),null);
var y1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32145,(4),null);
var y2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32145,(5),null);
var parity = (function (){var G__32147 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__32147) {
case "left":
return (-1);

break;
case "top":
return (-1);

break;
case "right":
return (1);

break;
case "bottom":
return (1);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(orientation)].join('')));

}
})();
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,[cljs.core.str("axis "),cljs.core.str(cljs.core.name(orientation))].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line$rule,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [y1,y2], null),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(scale)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$ticks,c2.core.unify(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,ticks,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(scale)),((function (vec__32145,x,y,x1,x2,y1,y2,parity,map__32143,map__32143__$1,orientation,formatter,major_tick_width,text_margin,label,label_margin){
return (function (p__32148){
var vec__32149 = p__32148;
var d = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32149,(0),null);
var scale__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32149,(1),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$tick$major_DASH_tick,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(cljs.core.PersistentArrayMap.fromArray([x,(0),y,(scale__$1.cljs$core$IFn$_invoke$arity$1 ? scale__$1.cljs$core$IFn$_invoke$arity$1(d) : scale__$1.call(null,d))], true, false))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,cljs.core.PersistentArrayMap.fromArray([x,(parity * text_margin)], true, false),(formatter.cljs$core$IFn$_invoke$arity$1 ? formatter.cljs$core$IFn$_invoke$arity$1(d) : formatter.call(null,d))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,cljs.core.PersistentArrayMap.fromArray([x1,(0),x2,(parity * major_tick_width)], true, false)], null)], null);
});})(vec__32145,x,y,x1,x2,y1,y2,parity,map__32143,map__32143__$1,orientation,formatter,major_tick_width,text_margin,label,label_margin))
)], null),(cljs.core.truth_(label)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,[cljs.core.str(c2.svg.translate(cljs.core.PersistentArrayMap.fromArray([x,(parity * label_margin),y,c2.maths.mean(cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(scale))], true, false))),cljs.core.str(" "),cljs.core.str((function (){var G__32150 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__32150) {
case "left":
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$1((-90));

break;
case "right":
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$1((90));

break;
default:
return "";

}
})())].join('')], null),label], null):null)], null);
});

c2.svg.axis.cljs$lang$maxFixedArity = (2);

c2.svg.axis.cljs$lang$applyTo = (function (seq32139){
var G__32140 = cljs.core.first(seq32139);
var seq32139__$1 = cljs.core.next(seq32139);
var G__32141 = cljs.core.first(seq32139__$1);
var seq32139__$2 = cljs.core.next(seq32139__$1);
return c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic(G__32140,G__32141,seq32139__$2);
});
c2.svg.ArcMax = (c2.maths.Tau - 1.0E-7);
/**
 * Calculate SVG path data for a circle of `radius` starting at 3 o'clock and sweeping in positive y.
 */
c2.svg.circle = (function c2$svg$circle(var_args){
var args32157 = [];
var len__7280__auto___32161 = arguments.length;
var i__7281__auto___32162 = (0);
while(true){
if((i__7281__auto___32162 < len__7280__auto___32161)){
args32157.push((arguments[i__7281__auto___32162]));

var G__32163 = (i__7281__auto___32162 + (1));
i__7281__auto___32162 = G__32163;
continue;
} else {
}
break;
}

var G__32159 = args32157.length;
switch (G__32159) {
case 1:
return c2.svg.circle.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.svg.circle.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32157.length)].join('')));

}
});

c2.svg.circle.cljs$core$IFn$_invoke$arity$1 = (function (radius){
return c2.svg.circle.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),radius);
});

c2.svg.circle.cljs$core$IFn$_invoke$arity$2 = (function (coordinates,radius){
var vec__32160 = c2.svg.__GT_xy(coordinates);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32160,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32160,(1),null);
return [cljs.core.str("M"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str(y),cljs.core.str("A"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str((y + radius)),cljs.core.str(" 0 1,1"),cljs.core.str((- (x + radius))),cljs.core.str(","),cljs.core.str(y),cljs.core.str("A"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str((y + radius)),cljs.core.str(" 0 1,1"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str(y)].join('');
});

c2.svg.circle.cljs$lang$maxFixedArity = 2;
/**
 * Calculate SVG path data for an arc.
 */
c2.svg.arc = (function c2$svg$arc(var_args){
var args__7287__auto__ = [];
var len__7280__auto___32170 = arguments.length;
var i__7281__auto___32171 = (0);
while(true){
if((i__7281__auto___32171 < len__7280__auto___32170)){
args__7287__auto__.push((arguments[i__7281__auto___32171]));

var G__32172 = (i__7281__auto___32171 + (1));
i__7281__auto___32171 = G__32172;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic = (function (p__32166){
var map__32167 = p__32166;
var map__32167__$1 = ((((!((map__32167 == null)))?((((map__32167.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32167.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32167):map__32167);
var inner_radius = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32167__$1,cljs.core.cst$kw$inner_DASH_radius,(0));
var outer_radius = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32167__$1,cljs.core.cst$kw$outer_DASH_radius,(1));
var start_angle = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32167__$1,cljs.core.cst$kw$start_DASH_angle,(0));
var end_angle = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32167__$1,cljs.core.cst$kw$end_DASH_angle,c2.maths.Pi);
var angle_offset = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32167__$1,cljs.core.cst$kw$angle_DASH_offset,(0));
var r0 = inner_radius;
var r1 = outer_radius;
var vec__32169 = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(angle_offset + start_angle),(angle_offset + end_angle)], null));
var a0 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32169,(0),null);
var a1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32169,(1),null);
var da = (a1 - a0);
var large_arc_flag = (((da < c2.maths.Pi))?"0":"1");
var s0 = c2.maths.sin(a0);
var c0 = c2.maths.cos(a0);
var s1 = c2.maths.sin(a1);
var c1 = c2.maths.cos(a1);
if((da >= c2.svg.ArcMax)){
return [cljs.core.str("M0,"),cljs.core.str(r1),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 1,1 0,"),cljs.core.str((- r1)),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 1,1 0,"),cljs.core.str(r1),cljs.core.str(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),r0))?[cljs.core.str("M0,"),cljs.core.str(r0),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 1,0 0,"),cljs.core.str((- r0)),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 1,0 0,"),cljs.core.str(r0)].join(''):null)),cljs.core.str("Z")].join('');
} else {
return [cljs.core.str("M"),cljs.core.str((r1 * c0)),cljs.core.str(","),cljs.core.str((r1 * s0)),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 "),cljs.core.str(large_arc_flag),cljs.core.str(",1 "),cljs.core.str((r1 * c1)),cljs.core.str(","),cljs.core.str((r1 * s1)),cljs.core.str(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),r0))?[cljs.core.str("L"),cljs.core.str((r0 * c1)),cljs.core.str(","),cljs.core.str((r0 * s1)),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 "),cljs.core.str(large_arc_flag),cljs.core.str(",0 "),cljs.core.str((r0 * c0)),cljs.core.str(","),cljs.core.str((r0 * s0))].join(''):"L0,0")),cljs.core.str("Z")].join('');
}
});

c2.svg.arc.cljs$lang$maxFixedArity = (0);

c2.svg.arc.cljs$lang$applyTo = (function (seq32165){
return c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32165));
});
