// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('hatti.constants');
goog.require('hatti.ona.forms');
goog.require('hatti.utils');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"radius": (6), "fillColor": "#f30", "reset": {"fillColor": "#f30"}, "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9},cljs.core.cst$kw$hover,{"fillColor": "#631400"},cljs.core.cst$kw$clicked,{"fillColor": "#ad2300"}], null),cljs.core.cst$kw$shape,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8},cljs.core.cst$kw$hover,{"fillColor": "#631400", "color": "#222"},cljs.core.cst$kw$clicked,{"fillColor": "#ad2300", "color": "#222"}], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,{"color": "#f30", "opacity": (1), "weight": (6), "reset": {"color": "#f30"}},cljs.core.cst$kw$hover,{"color": "#631400"},cljs.core.cst$kw$clicked,{"color": "#ad2300"}], null)], null);
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(marker_or_keyword,style_type){
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype(marker_or_keyword));
var G__30768 = (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.ona_styles) : kw.call(null,hatti.map.utils.ona_styles));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__30768) : style_type.call(null,G__30768));
});
hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(s);
var tc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(t);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.select_keys(sc,cljs.core.keys(tc)),cljs.core.select_keys(tc,cljs.core.keys(sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args30769 = [];
var len__7280__auto___30773 = arguments.length;
var i__7281__auto___30774 = (0);
while(true){
if((i__7281__auto___30774 < len__7280__auto___30773)){
args30769.push((arguments[i__7281__auto___30774]));

var G__30775 = (i__7281__auto___30774 + (1));
i__7281__auto___30774 = G__30775;
continue;
} else {
}
break;
}

var G__30771 = args30769.length;
switch (G__30771) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30769.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
var G__30772 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker));
return (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(G__30772) : kw.call(null,G__30772));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;
/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker),hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = (marker__GT_style.cljs$core$IFn$_invoke$arity$1 ? marker__GT_style.cljs$core$IFn$_invoke$arity$1(marker) : marker__GT_style.call(null,marker));
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return marker.setStyle(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reset,style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(style,cljs.core.cst$kw$reset,style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4655__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4655__auto__)){
var rstyle = temp__4655__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__6210__auto__ = hatti.map.utils.is_clicked_QMARK_(marker);
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
var G__30778 = hatti.map.utils.get_id(marker);
return (id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__30778) : id_selected_QMARK_.call(null,G__30778));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style(marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$hover));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__7287__auto__ = [];
var len__7280__auto___30788 = arguments.length;
var i__7281__auto___30789 = (0);
while(true){
if((i__7281__auto___30789 < len__7280__auto___30788)){
args__7287__auto__.push((arguments[i__7281__auto___30789]));

var G__30790 = (i__7281__auto___30789 + (1));
i__7281__auto___30789 = G__30790;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__30781){
var map__30782 = p__30781;
var map__30782__$1 = ((((!((map__30782 == null)))?((((map__30782.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30782.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30782):map__30782);
var preserve_clicked_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30782__$1,cljs.core.cst$kw$preserve_DASH_clicked_QMARK_,true);
var seq__30784 = cljs.core.seq(markers);
var chunk__30785 = null;
var count__30786 = (0);
var i__30787 = (0);
while(true){
if((i__30787 < count__30786)){
var marker = chunk__30785.cljs$core$IIndexed$_nth$arity$2(null,i__30787);
if(cljs.core.not((function (){var and__6198__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6198__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6198__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__30791 = seq__30784;
var G__30792 = chunk__30785;
var G__30793 = count__30786;
var G__30794 = (i__30787 + (1));
seq__30784 = G__30791;
chunk__30785 = G__30792;
count__30786 = G__30793;
i__30787 = G__30794;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__30784);
if(temp__4657__auto__){
var seq__30784__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__30784__$1)){
var c__7021__auto__ = cljs.core.chunk_first(seq__30784__$1);
var G__30795 = cljs.core.chunk_rest(seq__30784__$1);
var G__30796 = c__7021__auto__;
var G__30797 = cljs.core.count(c__7021__auto__);
var G__30798 = (0);
seq__30784 = G__30795;
chunk__30785 = G__30796;
count__30786 = G__30797;
i__30787 = G__30798;
continue;
} else {
var marker = cljs.core.first(seq__30784__$1);
if(cljs.core.not((function (){var and__6198__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6198__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6198__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__30799 = cljs.core.next(seq__30784__$1);
var G__30800 = null;
var G__30801 = (0);
var G__30802 = (0);
seq__30784 = G__30799;
chunk__30785 = G__30800;
count__30786 = G__30801;
i__30787 = G__30802;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq30779){
var G__30780 = cljs.core.first(seq30779);
var seq30779__$1 = cljs.core.next(seq30779);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__30780,seq30779__$1);
});
hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string(maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"Feature",cljs.core.cst$kw$properties,cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._rank),(index + (1)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id),record_id], true, false),cljs.core.cst$kw$geometry,geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__7135__auto__ = (function (){var G__30803 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30803) : cljs.core.atom.call(null,G__30803));
})();
var prefer_table__7136__auto__ = (function (){var G__30804 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30804) : cljs.core.atom.call(null,G__30804));
})();
var method_cache__7137__auto__ = (function (){var G__30805 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30805) : cljs.core.atom.call(null,G__30805));
})();
var cached_hierarchy__7138__auto__ = (function (){var G__30806 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30806) : cljs.core.atom.call(null,G__30806));
})();
var hierarchy__7139__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("hatti.map.utils","get-as-geom"),((function (method_table__7135__auto__,prefer_table__7136__auto__,method_cache__7137__auto__,cached_hierarchy__7138__auto__,hierarchy__7139__auto__){
return (function() { 
var G__30809__delegate = function (record,field,p__30807){
var vec__30808 = p__30807;
var repeat_child_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30808,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return cljs.core.cst$kw$repeat;
} else {
return cljs.core.cst$kw$default;

}
};
var G__30809 = function (record,field,var_args){
var p__30807 = null;
if (arguments.length > 2) {
var G__30810__i = 0, G__30810__a = new Array(arguments.length -  2);
while (G__30810__i < G__30810__a.length) {G__30810__a[G__30810__i] = arguments[G__30810__i + 2]; ++G__30810__i;}
  p__30807 = new cljs.core.IndexedSeq(G__30810__a,0);
} 
return G__30809__delegate.call(this,record,field,p__30807);};
G__30809.cljs$lang$maxFixedArity = 2;
G__30809.cljs$lang$applyTo = (function (arglist__30811){
var record = cljs.core.first(arglist__30811);
arglist__30811 = cljs.core.next(arglist__30811);
var field = cljs.core.first(arglist__30811);
var p__30807 = cljs.core.rest(arglist__30811);
return G__30809__delegate(record,field,p__30807);
});
G__30809.cljs$core$IFn$_invoke$arity$variadic = G__30809__delegate;
return G__30809;
})()
;})(method_table__7135__auto__,prefer_table__7136__auto__,method_cache__7137__auto__,cached_hierarchy__7138__auto__,hierarchy__7139__auto__))
,cljs.core.cst$kw$default,hierarchy__7139__auto__,method_table__7135__auto__,prefer_table__7136__auto__,method_cache__7137__auto__,cached_hierarchy__7138__auto__));
})();
}
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$repeat,(function (record,p__30812){
var map__30813 = p__30812;
var map__30813__$1 = ((((!((map__30813 == null)))?((((map__30813.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30813.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30813):map__30813);
var field = map__30813__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30813__$1,cljs.core.cst$kw$children);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30813__$1,cljs.core.cst$kw$full_DASH_name);
var iter__6990__auto__ = ((function (map__30813,map__30813__$1,field,children,full_name){
return (function hatti$map$utils$iter__30815(s__30816){
return (new cljs.core.LazySeq(null,((function (map__30813,map__30813__$1,field,children,full_name){
return (function (){
var s__30816__$1 = s__30816;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__30816__$1);
if(temp__4657__auto__){
var s__30816__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30816__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__30816__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__30818 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__30817 = (0);
while(true){
if((i__30817 < size__6989__auto__)){
var child_record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__30817);
cljs.core.chunk_append(b__30818,(function (){var iter__6990__auto__ = ((function (i__30817,child_record,c__6988__auto__,size__6989__auto__,b__30818,s__30816__$2,temp__4657__auto__,map__30813,map__30813__$1,field,children,full_name){
return (function hatti$map$utils$iter__30815_$_iter__30833(s__30834){
return (new cljs.core.LazySeq(null,((function (i__30817,child_record,c__6988__auto__,size__6989__auto__,b__30818,s__30816__$2,temp__4657__auto__,map__30813,map__30813__$1,field,children,full_name){
return (function (){
var s__30834__$1 = s__30834;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__30834__$1);
if(temp__4657__auto____$1){
var s__30834__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__30834__$2)){
var c__6988__auto____$1 = cljs.core.chunk_first(s__30834__$2);
var size__6989__auto____$1 = cljs.core.count(c__6988__auto____$1);
var b__30836 = cljs.core.chunk_buffer(size__6989__auto____$1);
if((function (){var i__30835 = (0);
while(true){
if((i__30835 < size__6989__auto____$1)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto____$1,i__30835);
cljs.core.chunk_append(b__30836,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__30845 = (i__30835 + (1));
i__30835 = G__30845;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30836),hatti$map$utils$iter__30815_$_iter__30833(cljs.core.chunk_rest(s__30834__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30836),null);
}
} else {
var child = cljs.core.first(s__30834__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__30815_$_iter__30833(cljs.core.rest(s__30834__$2)));
}
} else {
return null;
}
break;
}
});})(i__30817,child_record,c__6988__auto__,size__6989__auto__,b__30818,s__30816__$2,temp__4657__auto__,map__30813,map__30813__$1,field,children,full_name))
,null,null));
});})(i__30817,child_record,c__6988__auto__,size__6989__auto__,b__30818,s__30816__$2,temp__4657__auto__,map__30813,map__30813__$1,field,children,full_name))
;
return iter__6990__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})());

var G__30846 = (i__30817 + (1));
i__30817 = G__30846;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30818),hatti$map$utils$iter__30815(cljs.core.chunk_rest(s__30816__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30818),null);
}
} else {
var child_record = cljs.core.first(s__30816__$2);
return cljs.core.cons((function (){var iter__6990__auto__ = ((function (child_record,s__30816__$2,temp__4657__auto__,map__30813,map__30813__$1,field,children,full_name){
return (function hatti$map$utils$iter__30815_$_iter__30839(s__30840){
return (new cljs.core.LazySeq(null,((function (child_record,s__30816__$2,temp__4657__auto__,map__30813,map__30813__$1,field,children,full_name){
return (function (){
var s__30840__$1 = s__30840;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__30840__$1);
if(temp__4657__auto____$1){
var s__30840__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__30840__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__30840__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__30842 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__30841 = (0);
while(true){
if((i__30841 < size__6989__auto__)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__30841);
cljs.core.chunk_append(b__30842,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__30847 = (i__30841 + (1));
i__30841 = G__30847;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30842),hatti$map$utils$iter__30815_$_iter__30839(cljs.core.chunk_rest(s__30840__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30842),null);
}
} else {
var child = cljs.core.first(s__30840__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__30815_$_iter__30839(cljs.core.rest(s__30840__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__30816__$2,temp__4657__auto__,map__30813,map__30813__$1,field,children,full_name))
,null,null));
});})(child_record,s__30816__$2,temp__4657__auto__,map__30813,map__30813__$1,field,children,full_name))
;
return iter__6990__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__30815(cljs.core.rest(s__30816__$2)));
}
} else {
return null;
}
break;
}
});})(map__30813,map__30813__$1,field,children,full_name))
,null,null));
});})(map__30813,map__30813__$1,field,children,full_name))
;
return iter__6990__auto__(cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,full_name));
}));
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq(s)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,"n/a"))){
var iter__6990__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__30850(s__30851){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__30851__$1 = s__30851;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__30851__$1);
if(temp__4657__auto__){
var s__30851__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30851__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__30851__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__30853 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__30852 = (0);
while(true){
if((i__30852 < size__6989__auto__)){
var coord_string = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__30852);
cljs.core.chunk_append(b__30853,(function (){var vec__30858 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30858,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30858,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30858,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30858,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})());

var G__30861 = (i__30852 + (1));
i__30852 = G__30861;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30853),hatti$map$utils$iter__30850(cljs.core.chunk_rest(s__30851__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30853),null);
}
} else {
var coord_string = cljs.core.first(s__30851__$2);
return cljs.core.cons((function (){var vec__30859 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30859,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30859,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30859,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30859,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})(),hatti$map$utils$iter__30850(cljs.core.rest(s__30851__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__6990__auto__(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__30860 = geotype;
switch (G__30860) {
case "Point":
return ((function (G__30860,geotype,parse){
return (function (p1__30848_SHARP_){
return cljs.core.first(parse(p1__30848_SHARP_));
});
;})(G__30860,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__30860,geotype,parse){
return (function (p1__30849_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse(p1__30849_SHARP_)],null));
});
;})(G__30860,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield));
var coords = (coordfn.cljs$core$IFn$_invoke$arity$1 ? coordfn.cljs$core$IFn$_invoke$arity$1(value) : coordfn.call(null,value));
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(geofield))){
return cljs.core.cst$kw$geom.cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__6210__auto__ = (coords == null);
if(or__6210__auto__){
return or__6210__auto__;
} else {
return cljs.core.some(cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,geotype,cljs.core.cst$kw$coordinates,coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args30864 = [];
var len__7280__auto___30877 = arguments.length;
var i__7281__auto___30878 = (0);
while(true){
if((i__7281__auto___30878 < len__7280__auto___30877)){
args30864.push((arguments[i__7281__auto___30878]));

var G__30879 = (i__7281__auto___30878 + (1));
i__7281__auto___30878 = G__30879;
continue;
} else {
}
break;
}

var G__30866 = args30864.length;
switch (G__30866) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30864.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3(dataset,form,hatti.ona.forms.default_geofield(form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__6990__auto__ = (function hatti$map$utils$iter__30867(s__30868){
return (new cljs.core.LazySeq(null,(function (){
var s__30868__$1 = s__30868;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__30868__$1);
if(temp__4657__auto__){
var s__30868__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30868__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__30868__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__30870 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__30869 = (0);
while(true){
if((i__30869 < size__6989__auto__)){
var vec__30875 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__30869);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30875,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30875,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append(b__30870,((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__30869,s__30868__$1,geom_or_geoms,vec__30875,idx,record,c__6988__auto__,size__6989__auto__,b__30870,s__30868__$2,temp__4657__auto__){
return (function (p1__30863_SHARP_){
return hatti.map.utils.make_feature(p1__30863_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(i__30869,s__30868__$1,geom_or_geoms,vec__30875,idx,record,c__6988__auto__,size__6989__auto__,b__30870,s__30868__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))));

var G__30881 = (i__30869 + (1));
i__30869 = G__30881;
continue;
} else {
var G__30882 = (i__30869 + (1));
i__30869 = G__30882;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30870),hatti$map$utils$iter__30867(cljs.core.chunk_rest(s__30868__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30870),null);
}
} else {
var vec__30876 = cljs.core.first(s__30868__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30876,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30876,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons(((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (s__30868__$1,geom_or_geoms,vec__30876,idx,record,s__30868__$2,temp__4657__auto__){
return (function (p1__30863_SHARP_){
return hatti.map.utils.make_feature(p1__30863_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(s__30868__$1,geom_or_geoms,vec__30876,idx,record,s__30868__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))),hatti$map$utils$iter__30867(cljs.core.rest(s__30868__$2)));
} else {
var G__30883 = cljs.core.rest(s__30868__$2);
s__30868__$1 = G__30883;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__(hatti.utils.indexed(dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,cljs.core.flatten(features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;
/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__30885){
var map__30888 = p__30885;
var map__30888__$1 = ((((!((map__30888 == null)))?((((map__30888.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30888.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30888):map__30888);
var mapbox_tiles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30888__$1,cljs.core.cst$kw$mapbox_DASH_tiles);
var include_google_maps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30888__$1,cljs.core.cst$kw$include_DASH_google_DASH_maps_QMARK_);
var layers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__30888,map__30888__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__30884_SHARP_){
return L.tileLayer(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(p1__30884_SHARP_));
});})(map__30888,map__30888__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name,mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js(nlayers));
var m = L.map(id,{"layers": cljs.core.first(layers), "zoomControl": false});
var z = L.control.zoom.call(null,{"position": "bottomleft"});
z.addTo(m);

L.control.layers.call(null,named_layers,null,{"position": "bottomleft"}).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank,((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style(marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style(marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not(layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__7287__auto__ = [];
var len__7280__auto___30902 = arguments.length;
var i__7281__auto___30903 = (0);
while(true){
if((i__7281__auto___30903 < len__7280__auto___30902)){
args__7287__auto__.push((arguments[i__7281__auto___30903]));

var G__30904 = (i__7281__auto___30903 + (1));
i__7281__auto___30903 = G__30904;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((3) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7288__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__30899){
var map__30900 = p__30899;
var map__30900__$1 = ((((!((map__30900 == null)))?((((map__30900.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30900.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30900):map__30900);
var rezoom_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30900__$1,cljs.core.cst$kw$rezoom_QMARK_);
var on_events = ((function (map__30900,map__30900__$1,rezoom_QMARK_){
return (function (p1__30890_SHARP_,p2__30891_SHARP_){
return hatti.map.utils.register_mouse_events(p1__30890_SHARP_,p2__30891_SHARP_,event_chan);
});})(map__30900,map__30900__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__30900,map__30900__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style(geometry_type,cljs.core.cst$kw$normal);
});})(on_events,geometry_type,map__30900,map__30900__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__30900,map__30900__$1,rezoom_QMARK_){
return (function (p1__30893_SHARP_,p2__30892_SHARP_){
return L.circleMarker(p2__30892_SHARP_);
});})(on_events,geometry_type,stylefn,map__30900,map__30900__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js(geojson),{"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn});
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__30900,map__30900__$1,rezoom_QMARK_){
return (function (p1__30894_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__30894_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$properties,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__30900,map__30900__$1,rezoom_QMARK_))
,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$feature_DASH_layer,feature_layer,cljs.core.cst$kw$markers,markers,cljs.core.cst$kw$id_DASH__GT_marker,cljs.core.zipmap(ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq30895){
var G__30896 = cljs.core.first(seq30895);
var seq30895__$1 = cljs.core.next(seq30895);
var G__30897 = cljs.core.first(seq30895__$1);
var seq30895__$2 = cljs.core.next(seq30895__$1);
var G__30898 = cljs.core.first(seq30895__$2);
var seq30895__$3 = cljs.core.next(seq30895__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__30896,G__30897,G__30898,seq30895__$3);
});
