// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__11856__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto__){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__){
return (function (state_32505){
var state_val_32506 = (state_32505[(1)]);
if((state_val_32506 === (7))){
var inst_32462 = (state_32505[(7)]);
var inst_32462__$1 = (state_32505[(2)]);
var inst_32464 = (inst_32462__$1 == null);
var inst_32465 = cljs.core.not(inst_32464);
var state_32505__$1 = (function (){var statearr_32507 = state_32505;
(statearr_32507[(7)] = inst_32462__$1);

return statearr_32507;
})();
if(inst_32465){
var statearr_32508_32545 = state_32505__$1;
(statearr_32508_32545[(1)] = (8));

} else {
var statearr_32509_32546 = state_32505__$1;
(statearr_32509_32546[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (20))){
var inst_32484 = (state_32505[(8)]);
var inst_32492 = (state_32505[(2)]);
var state_32505__$1 = (function (){var statearr_32510 = state_32505;
(statearr_32510[(9)] = inst_32492);

return statearr_32510;
})();
if(cljs.core.truth_(inst_32484)){
var statearr_32511_32547 = state_32505__$1;
(statearr_32511_32547[(1)] = (21));

} else {
var statearr_32512_32548 = state_32505__$1;
(statearr_32512_32548[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (1))){
var state_32505__$1 = state_32505;
var statearr_32513_32549 = state_32505__$1;
(statearr_32513_32549[(2)] = null);

(statearr_32513_32549[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (4))){
var state_32505__$1 = state_32505;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32505__$1,(7),agg_data_channel);
} else {
if((state_val_32506 === (15))){
var inst_32462 = (state_32505[(7)]);
var state_32505__$1 = state_32505;
var statearr_32514_32550 = state_32505__$1;
(statearr_32514_32550[(2)] = inst_32462);

(statearr_32514_32550[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (21))){
var inst_32494 = cljs.core.async.close_BANG_(agg_data_channel);
var state_32505__$1 = state_32505;
var statearr_32515_32551 = state_32505__$1;
(statearr_32515_32551[(2)] = inst_32494);

(statearr_32515_32551[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (13))){
var inst_32474 = (state_32505[(2)]);
var state_32505__$1 = state_32505;
var statearr_32516_32552 = state_32505__$1;
(statearr_32516_32552[(2)] = inst_32474);

(statearr_32516_32552[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (22))){
var state_32505__$1 = state_32505;
var statearr_32517_32553 = state_32505__$1;
(statearr_32517_32553[(2)] = null);

(statearr_32517_32553[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (6))){
var inst_32501 = (state_32505[(2)]);
var state_32505__$1 = state_32505;
var statearr_32518_32554 = state_32505__$1;
(statearr_32518_32554[(2)] = inst_32501);

(statearr_32518_32554[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (17))){
var inst_32483 = (state_32505[(10)]);
var inst_32484 = (state_32505[(8)]);
var inst_32486 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_32483,inst_32484) : callback.call(null,inst_32483,inst_32484));
var state_32505__$1 = state_32505;
var statearr_32519_32555 = state_32505__$1;
(statearr_32519_32555[(2)] = inst_32486);

(statearr_32519_32555[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (3))){
var inst_32503 = (state_32505[(2)]);
var state_32505__$1 = state_32505;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32505__$1,inst_32503);
} else {
if((state_val_32506 === (12))){
var state_32505__$1 = state_32505;
var statearr_32520_32556 = state_32505__$1;
(statearr_32520_32556[(2)] = false);

(statearr_32520_32556[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (2))){
var state_32505__$1 = state_32505;
var statearr_32521_32557 = state_32505__$1;
(statearr_32521_32557[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (23))){
var inst_32497 = (state_32505[(2)]);
var state_32505__$1 = (function (){var statearr_32523 = state_32505;
(statearr_32523[(11)] = inst_32497);

return statearr_32523;
})();
var statearr_32524_32558 = state_32505__$1;
(statearr_32524_32558[(2)] = null);

(statearr_32524_32558[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (19))){
var inst_32489 = (state_32505[(2)]);
var inst_32490 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_32505__$1 = (function (){var statearr_32525 = state_32505;
(statearr_32525[(12)] = inst_32489);

return statearr_32525;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32505__$1,(20),inst_32490);
} else {
if((state_val_32506 === (11))){
var state_32505__$1 = state_32505;
var statearr_32526_32559 = state_32505__$1;
(statearr_32526_32559[(2)] = true);

(statearr_32526_32559[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (9))){
var state_32505__$1 = state_32505;
var statearr_32527_32560 = state_32505__$1;
(statearr_32527_32560[(2)] = false);

(statearr_32527_32560[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (5))){
var state_32505__$1 = state_32505;
var statearr_32528_32561 = state_32505__$1;
(statearr_32528_32561[(2)] = null);

(statearr_32528_32561[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (14))){
var inst_32462 = (state_32505[(7)]);
var inst_32479 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32462);
var state_32505__$1 = state_32505;
var statearr_32529_32562 = state_32505__$1;
(statearr_32529_32562[(2)] = inst_32479);

(statearr_32529_32562[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (16))){
var inst_32483 = (state_32505[(10)]);
var inst_32482 = (state_32505[(2)]);
var inst_32483__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32482,cljs.core.cst$kw$data);
var inst_32484 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32482,cljs.core.cst$kw$completed_QMARK_);
var state_32505__$1 = (function (){var statearr_32530 = state_32505;
(statearr_32530[(10)] = inst_32483__$1);

(statearr_32530[(8)] = inst_32484);

return statearr_32530;
})();
if(cljs.core.truth_(inst_32483__$1)){
var statearr_32531_32563 = state_32505__$1;
(statearr_32531_32563[(1)] = (17));

} else {
var statearr_32532_32564 = state_32505__$1;
(statearr_32532_32564[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (10))){
var inst_32477 = (state_32505[(2)]);
var state_32505__$1 = state_32505;
if(cljs.core.truth_(inst_32477)){
var statearr_32533_32565 = state_32505__$1;
(statearr_32533_32565[(1)] = (14));

} else {
var statearr_32534_32566 = state_32505__$1;
(statearr_32534_32566[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (18))){
var state_32505__$1 = state_32505;
var statearr_32535_32567 = state_32505__$1;
(statearr_32535_32567[(2)] = null);

(statearr_32535_32567[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32506 === (8))){
var inst_32462 = (state_32505[(7)]);
var inst_32467 = inst_32462.cljs$lang$protocol_mask$partition0$;
var inst_32468 = (inst_32467 & (64));
var inst_32469 = inst_32462.cljs$core$ISeq$;
var inst_32470 = (inst_32468) || (inst_32469);
var state_32505__$1 = state_32505;
if(cljs.core.truth_(inst_32470)){
var statearr_32536_32568 = state_32505__$1;
(statearr_32536_32568[(1)] = (11));

} else {
var statearr_32537_32569 = state_32505__$1;
(statearr_32537_32569[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto__))
;
return ((function (switch__11791__auto__,c__11856__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto____0 = (function (){
var statearr_32541 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32541[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto__);

(statearr_32541[(1)] = (1));

return statearr_32541;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto____1 = (function (state_32505){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_32505);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e32542){if((e32542 instanceof Object)){
var ex__11795__auto__ = e32542;
var statearr_32543_32570 = state_32505;
(statearr_32543_32570[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32505);

return cljs.core.cst$kw$recur;
} else {
throw e32542;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__32571 = state_32505;
state_32505 = G__32571;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto__ = function(state_32505){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto____1.call(this,state_32505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__))
})();
var state__11858__auto__ = (function (){var statearr_32544 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_32544[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_32544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto__))
);

return c__11856__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__32574_32576 = agg;
var G__32575_32577 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32574_32576,G__32575_32577) : cljs.core.reset_BANG_.call(null,G__32574_32576,G__32575_32577));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___32585 = arguments.length;
var i__7281__auto___32586 = (0);
while(true){
if((i__7281__auto___32586 < len__7280__auto___32585)){
args__7287__auto__.push((arguments[i__7281__auto___32586]));

var G__32587 = (i__7281__auto___32586 + (1));
i__7281__auto___32586 = G__32587;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((2) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7288__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__32581){
var map__32582 = p__32581;
var map__32582__$1 = ((((!((map__32582 == null)))?((((map__32582.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32582.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32582):map__32582);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32582__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__32584 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32584) : cljs.core.atom.call(null,G__32584));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__32582,map__32582__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__32582,map__32582__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__32582,map__32582__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__32582,map__32582__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq32578){
var G__32579 = cljs.core.first(seq32578);
var seq32578__$1 = cljs.core.next(seq32578);
var G__32580 = cljs.core.first(seq32578__$1);
var seq32578__$2 = cljs.core.next(seq32578__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32579,G__32580,seq32578__$2);
});
