// Compiled by ClojureScript 1.8.51 {}
goog.provide('c2.maths');
goog.require('cljs.core');
c2.maths.Pi = Math.PI;
c2.maths.Tau = ((2) * c2.maths.Pi);
c2.maths.e = Math.E;
c2.maths.radians_per_degree = (c2.maths.Pi / (180));
c2.maths.rad = (function c2$maths$rad(x){
return (c2.maths.radians_per_degree * x);
});
c2.maths.deg = (function c2$maths$deg(x){
return (x / c2.maths.radians_per_degree);
});
c2.maths.sin = (function c2$maths$sin(x){
return Math.sin(x);
});
c2.maths.asin = (function c2$maths$asin(x){
return Math.asin(x);
});
c2.maths.cos = (function c2$maths$cos(x){
return Math.cos(x);
});
c2.maths.acos = (function c2$maths$acos(x){
return Math.acos(x);
});
c2.maths.tan = (function c2$maths$tan(x){
return Math.tan(x);
});
c2.maths.atan = (function c2$maths$atan(x){
return Math.atan(x);
});
c2.maths.expt = (function c2$maths$expt(var_args){
var args16243 = [];
var len__7280__auto___16246 = arguments.length;
var i__7281__auto___16247 = (0);
while(true){
if((i__7281__auto___16247 < len__7280__auto___16246)){
args16243.push((arguments[i__7281__auto___16247]));

var G__16248 = (i__7281__auto___16247 + (1));
i__7281__auto___16247 = G__16248;
continue;
} else {
}
break;
}

var G__16245 = args16243.length;
switch (G__16245) {
case 1:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16243.length)].join('')));

}
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.exp(x);
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return Math.pow(x,y);
});

c2.maths.expt.cljs$lang$maxFixedArity = 2;
c2.maths.sq = (function c2$maths$sq(x){
return c2.maths.expt.call(null,x,(2));
});
c2.maths.sqrt = (function c2$maths$sqrt(x){
return Math.sqrt(x);
});
c2.maths.floor = (function c2$maths$floor(x){
return Math.floor(x);
});
c2.maths.ceil = (function c2$maths$ceil(x){
return Math.ceil(x);
});
c2.maths.abs = (function c2$maths$abs(x){
return Math.abs(x);
});
c2.maths.log = (function c2$maths$log(var_args){
var args16250 = [];
var len__7280__auto___16253 = arguments.length;
var i__7281__auto___16254 = (0);
while(true){
if((i__7281__auto___16254 < len__7280__auto___16253)){
args16250.push((arguments[i__7281__auto___16254]));

var G__16255 = (i__7281__auto___16254 + (1));
i__7281__auto___16254 = G__16255;
continue;
} else {
}
break;
}

var G__16252 = args16250.length;
switch (G__16252) {
case 1:
return c2.maths.log.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.log.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16250.length)].join('')));

}
});

c2.maths.log.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.log(x);
});

c2.maths.log.cljs$core$IFn$_invoke$arity$2 = (function (base,x){
return (Math.log(x) / Math.log(base));
});

c2.maths.log.cljs$lang$maxFixedArity = 2;
c2.maths.log10 = (function c2$maths$log10(x){
return (Math.log(x) / Math.LN10);
});
/**
 * Returns 2-vector of min and max elements in xs.
 */
c2.maths.extent = (function c2$maths$extent(xs){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core.min,xs),cljs.core.apply.call(null,cljs.core.max,xs)], null);
});
/**
 * Arithemetic mean of collection
 */
c2.maths.mean = (function c2$maths$mean(xs){
return (cljs.core.reduce.call(null,cljs.core._PLUS_,xs) / cljs.core.count.call(null,xs));
});
/**
 * Median of a collection.
 */
c2.maths.median = (function c2$maths$median(xs){
var sorted = cljs.core.sort.call(null,xs);
var n = cljs.core.count.call(null,xs);
if(cljs.core._EQ_.call(null,n,(1))){
return cljs.core.first.call(null,sorted);
} else {
if(cljs.core.odd_QMARK_.call(null,n)){
return cljs.core.nth.call(null,sorted,((n + (1)) / (2)));
} else {
var mid = (n / (2));
return c2.maths.mean.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nth.call(null,sorted,c2.maths.floor.call(null,mid)),cljs.core.nth.call(null,sorted,c2.maths.ceil.call(null,mid))], null));

}
}
});
/**
 * Inclusive range; same as core/range, but includes the end.
 */
c2.maths.irange = (function c2$maths$irange(var_args){
var args16257 = [];
var len__7280__auto___16260 = arguments.length;
var i__7281__auto___16261 = (0);
while(true){
if((i__7281__auto___16261 < len__7280__auto___16260)){
args16257.push((arguments[i__7281__auto___16261]));

var G__16262 = (i__7281__auto___16261 + (1));
i__7281__auto___16261 = G__16262;
continue;
} else {
}
break;
}

var G__16259 = args16257.length;
switch (G__16259) {
case 1:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16257.length)].join('')));

}
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$1 = (function (start){
return cljs.core.range.call(null,start);
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.concat.call(null,cljs.core.range.call(null,start,end),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
var r = cljs.core.range.call(null,start,end,step);
if((cljs.core.mod.call(null,cljs.core.first.call(null,r),step) === cljs.core.mod.call(null,end,step))){
return cljs.core.concat.call(null,r,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
} else {
return r;
}
});

c2.maths.irange.cljs$lang$maxFixedArity = 3;
/**
 * Checks if bottom <= x <= top.
 */
c2.maths.within_QMARK_ = (function c2$maths$within_QMARK_(x,p__16264){
var vec__16266 = p__16264;
var bottom = cljs.core.nth.call(null,vec__16266,(0),null);
var top = cljs.core.nth.call(null,vec__16266,(1),null);
return ((bottom <= x)) && ((x <= top));
});
c2.maths.add = (function c2$maths$add(var_args){
var args__7287__auto__ = [];
var len__7280__auto___16268 = arguments.length;
var i__7281__auto___16269 = (0);
while(true){
if((i__7281__auto___16269 < len__7280__auto___16268)){
args__7287__auto__.push((arguments[i__7281__auto___16269]));

var G__16270 = (i__7281__auto___16269 + (1));
i__7281__auto___16269 = G__16270;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

c2.maths.add.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.call(null,(function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A + B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._PLUS_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._PLUS_,cljs.core.replicate.call(null,cljs.core.count.call(null,B),A),B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (typeof B === 'number')){
return cljs.core.map.call(null,cljs.core._PLUS_,A,cljs.core.replicate.call(null,cljs.core.count.call(null,A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.add.cljs$lang$maxFixedArity = (0);

c2.maths.add.cljs$lang$applyTo = (function (seq16267){
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16267));
});
c2.maths.sub = (function c2$maths$sub(var_args){
var args__7287__auto__ = [];
var len__7280__auto___16272 = arguments.length;
var i__7281__auto___16273 = (0);
while(true){
if((i__7281__auto___16273 < len__7280__auto___16272)){
args__7287__auto__.push((arguments[i__7281__auto___16273]));

var G__16274 = (i__7281__auto___16273 + (1));
i__7281__auto___16273 = G__16274;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,args),(1))){
if((typeof (0) === 'number') && (typeof cljs.core.first.call(null,args) === 'number')){
return ((0) - cljs.core.first.call(null,args));
} else {
if((cljs.core.coll_QMARK_.call(null,(0))) && (cljs.core.coll_QMARK_.call(null,cljs.core.first.call(null,args)))){
return cljs.core.map.call(null,cljs.core._,(0),cljs.core.first.call(null,args));
} else {
if((typeof (0) === 'number') && (cljs.core.coll_QMARK_.call(null,cljs.core.first.call(null,args)))){
return cljs.core.map.call(null,cljs.core._,cljs.core.replicate.call(null,cljs.core.count.call(null,cljs.core.first.call(null,args)),(0)),cljs.core.first.call(null,args));
} else {
if((cljs.core.coll_QMARK_.call(null,(0))) && (typeof cljs.core.first.call(null,args) === 'number')){
return cljs.core.map.call(null,cljs.core._,(0),cljs.core.replicate.call(null,cljs.core.count.call(null,(0)),cljs.core.first.call(null,args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.call(null,(function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A - B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._,cljs.core.replicate.call(null,cljs.core.count.call(null,B),A),B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (typeof B === 'number')){
return cljs.core.map.call(null,cljs.core._,A,cljs.core.replicate.call(null,cljs.core.count.call(null,A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.sub.cljs$lang$maxFixedArity = (0);

c2.maths.sub.cljs$lang$applyTo = (function (seq16271){
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16271));
});
c2.maths.mul = (function c2$maths$mul(var_args){
var args__7287__auto__ = [];
var len__7280__auto___16276 = arguments.length;
var i__7281__auto___16277 = (0);
while(true){
if((i__7281__auto___16277 < len__7280__auto___16276)){
args__7287__auto__.push((arguments[i__7281__auto___16277]));

var G__16278 = (i__7281__auto___16277 + (1));
i__7281__auto___16277 = G__16278;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.call(null,(function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A * B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._STAR_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._STAR_,cljs.core.replicate.call(null,cljs.core.count.call(null,B),A),B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (typeof B === 'number')){
return cljs.core.map.call(null,cljs.core._STAR_,A,cljs.core.replicate.call(null,cljs.core.count.call(null,A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.mul.cljs$lang$maxFixedArity = (0);

c2.maths.mul.cljs$lang$applyTo = (function (seq16275){
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16275));
});
c2.maths.div = (function c2$maths$div(var_args){
var args__7287__auto__ = [];
var len__7280__auto___16280 = arguments.length;
var i__7281__auto___16281 = (0);
while(true){
if((i__7281__auto___16281 < len__7280__auto___16280)){
args__7287__auto__.push((arguments[i__7281__auto___16281]));

var G__16282 = (i__7281__auto___16281 + (1));
i__7281__auto___16281 = G__16282;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

c2.maths.div.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,args),(1))){
if((typeof (1) === 'number') && (typeof cljs.core.first.call(null,args) === 'number')){
return ((1) / cljs.core.first.call(null,args));
} else {
if((cljs.core.coll_QMARK_.call(null,(1))) && (cljs.core.coll_QMARK_.call(null,cljs.core.first.call(null,args)))){
return cljs.core.map.call(null,cljs.core._SLASH_,(1),cljs.core.first.call(null,args));
} else {
if((typeof (1) === 'number') && (cljs.core.coll_QMARK_.call(null,cljs.core.first.call(null,args)))){
return cljs.core.map.call(null,cljs.core._SLASH_,cljs.core.replicate.call(null,cljs.core.count.call(null,cljs.core.first.call(null,args)),(1)),cljs.core.first.call(null,args));
} else {
if((cljs.core.coll_QMARK_.call(null,(1))) && (typeof cljs.core.first.call(null,args) === 'number')){
return cljs.core.map.call(null,cljs.core._SLASH_,(1),cljs.core.replicate.call(null,cljs.core.count.call(null,(1)),cljs.core.first.call(null,args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.call(null,(function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A / B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._SLASH_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._SLASH_,cljs.core.replicate.call(null,cljs.core.count.call(null,B),A),B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (typeof B === 'number')){
return cljs.core.map.call(null,cljs.core._SLASH_,A,cljs.core.replicate.call(null,cljs.core.count.call(null,A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.div.cljs$lang$maxFixedArity = (0);

c2.maths.div.cljs$lang$applyTo = (function (seq16279){
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16279));
});
/**
 * Returns the quantiles of a dataset.
 * 
 * Kwargs:
 * 
 *   > *:probs*: ntiles of the data to return, defaults to `[0 0.25 0.5 0.75 1]`
 * 
 *   Algorithm is the same as R's quantile type=7.
 *   Transcribed from Jason Davies; https://github.com/jasondavies/science.js/blob/master/src/stats/quantiles.js
 */
c2.maths.quantile = (function c2$maths$quantile(var_args){
var args__7287__auto__ = [];
var len__7280__auto___16292 = arguments.length;
var i__7281__auto___16293 = (0);
while(true){
if((i__7281__auto___16293 < len__7280__auto___16292)){
args__7287__auto__.push((arguments[i__7281__auto___16293]));

var G__16294 = (i__7281__auto___16293 + (1));
i__7281__auto___16293 = G__16294;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__16285){
var map__16286 = p__16285;
var map__16286__$1 = ((((!((map__16286 == null)))?((((map__16286.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16286.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16286):map__16286);
var probs = cljs.core.get.call(null,map__16286__$1,new cljs.core.Keyword(null,"probs","probs",-1201894224),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),0.25,0.5,0.75,(1)], null));
var xs = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.sort.call(null,data));
var n_1 = (cljs.core.count.call(null,xs) - (1));
var iter__6990__auto__ = ((function (xs,n_1,map__16286,map__16286__$1,probs){
return (function c2$maths$iter__16288(s__16289){
return (new cljs.core.LazySeq(null,((function (xs,n_1,map__16286,map__16286__$1,probs){
return (function (){
var s__16289__$1 = s__16289;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__16289__$1);
if(temp__4657__auto__){
var s__16289__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16289__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__16289__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__16291 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__16290 = (0);
while(true){
if((i__16290 < size__6989__auto__)){
var q = cljs.core._nth.call(null,c__6988__auto__,i__16290);
cljs.core.chunk_append.call(null,b__16291,(function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor.call(null,index) | (0));
var h = (index - lo);
var a = xs.call(null,(lo - (1)));
if(cljs.core._EQ_.call(null,h,(0))){
return a;
} else {
return (a + (h * (xs.call(null,lo) - a)));
}
})());

var G__16295 = (i__16290 + (1));
i__16290 = G__16295;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16291),c2$maths$iter__16288.call(null,cljs.core.chunk_rest.call(null,s__16289__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16291),null);
}
} else {
var q = cljs.core.first.call(null,s__16289__$2);
return cljs.core.cons.call(null,(function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor.call(null,index) | (0));
var h = (index - lo);
var a = xs.call(null,(lo - (1)));
if(cljs.core._EQ_.call(null,h,(0))){
return a;
} else {
return (a + (h * (xs.call(null,lo) - a)));
}
})(),c2$maths$iter__16288.call(null,cljs.core.rest.call(null,s__16289__$2)));
}
} else {
return null;
}
break;
}
});})(xs,n_1,map__16286,map__16286__$1,probs))
,null,null));
});})(xs,n_1,map__16286,map__16286__$1,probs))
;
return iter__6990__auto__.call(null,probs);
});

c2.maths.quantile.cljs$lang$maxFixedArity = (1);

c2.maths.quantile.cljs$lang$applyTo = (function (seq16283){
var G__16284 = cljs.core.first.call(null,seq16283);
var seq16283__$1 = cljs.core.next.call(null,seq16283);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic(G__16284,seq16283__$1);
});
