// Compiled by ClojureScript 1.7.145 {}
goog.provide('c2.scale');
goog.require('cljs.core');
goog.require('c2.maths');

/**
 * @interface
 */
c2.scale.IInvertable = function(){};

/**
 * Inverted scale
 */
c2.scale.invert = (function c2$scale$invert(scale){
if((!((scale == null))) && (!((scale.c2$scale$IInvertable$invert$arity$1 == null)))){
return scale.c2$scale$IInvertable$invert$arity$1(scale);
} else {
var x__5224__auto__ = (((scale == null))?null:scale);
var m__5225__auto__ = (c2.scale.invert[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,scale);
} else {
var m__5225__auto____$1 = (c2.scale.invert["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,scale);
} else {
throw cljs.core.missing_protocol.call(null,"IInvertable.invert",scale);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {c2.scale.IInvertable}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._linear = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._linear.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5183__auto__,k__5184__auto__){
var self__ = this;
var this__5183__auto____$1 = this;
return cljs.core._lookup.call(null,this__5183__auto____$1,k__5184__auto__,null);
});

c2.scale._linear.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5185__auto__,k12522,else__5186__auto__){
var self__ = this;
var this__5185__auto____$1 = this;
var G__12525 = (((k12522 instanceof cljs.core.Keyword))?k12522.fqn:null);
switch (G__12525) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k12522,else__5186__auto__);

}
});

c2.scale._linear.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5197__auto__,writer__5198__auto__,opts__5199__auto__){
var self__ = this;
var this__5197__auto____$1 = this;
var pr_pair__5200__auto__ = ((function (this__5197__auto____$1){
return (function (keyval__5201__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5198__auto__,cljs.core.pr_writer,""," ","",opts__5199__auto__,keyval__5201__auto__);
});})(this__5197__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__5198__auto__,pr_pair__5200__auto__,"#c2.scale._linear{",", ","}",opts__5199__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain","domain",1847214937),self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null))], null),self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IIterable$ = true;

c2.scale._linear.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12521){
var self__ = this;
var G__12521__$1 = this;
return (new cljs.core.RecordIter((0),G__12521__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.Keyword(null,"range","range",1639692286)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

c2.scale._linear.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5181__auto__){
var self__ = this;
var this__5181__auto____$1 = this;
return self__.__meta;
});

c2.scale._linear.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5177__auto__){
var self__ = this;
var this__5177__auto____$1 = this;
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._linear.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5187__auto__){
var self__ = this;
var this__5187__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5178__auto__){
var self__ = this;
var this__5178__auto____$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_imap.call(null,this__5178__auto____$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

c2.scale._linear.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__5179__auto__,other__5180__auto__){
var self__ = this;
var this__5179__auto____$1 = this;
if(cljs.core.truth_((function (){var and__4557__auto__ = other__5180__auto__;
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (this__5179__auto____$1.constructor === other__5180__auto__.constructor);
if(and__4557__auto____$1){
return cljs.core.equiv_map.call(null,this__5179__auto____$1,other__5180__auto__);
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._linear.prototype.c2$scale$IInvertable$ = true;

c2.scale._linear.prototype.c2$scale$IInvertable$invert$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"domain","domain",1847214937),self__.range,new cljs.core.Keyword(null,"range","range",1639692286),self__.domain);
});

c2.scale._linear.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5192__auto__,k__5193__auto__){
var self__ = this;
var this__5192__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"domain","domain",1847214937),null,new cljs.core.Keyword(null,"range","range",1639692286),null], null), null),k__5193__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5192__auto____$1),self__.__meta),k__5193__auto__);
} else {
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5193__auto__)),null));
}
});

c2.scale._linear.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5190__auto__,k__5191__auto__,G__12521){
var self__ = this;
var this__5190__auto____$1 = this;
var pred__12526 = cljs.core.keyword_identical_QMARK_;
var expr__12527 = k__5191__auto__;
if(cljs.core.truth_(pred__12526.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),expr__12527))){
return (new c2.scale._linear(G__12521,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__12526.call(null,new cljs.core.Keyword(null,"range","range",1639692286),expr__12527))){
return (new c2.scale._linear(self__.domain,G__12521,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5191__auto__,G__12521),null));
}
}
});

c2.scale._linear.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5195__auto__){
var self__ = this;
var this__5195__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain","domain",1847214937),self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null))], null),self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5182__auto__,G__12521){
var self__ = this;
var this__5182__auto____$1 = this;
return (new c2.scale._linear(self__.domain,self__.range,G__12521,self__.__extmap,self__.__hash));
});

c2.scale._linear.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5188__auto__,entry__5189__auto__){
var self__ = this;
var this__5188__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5189__auto__)){
return cljs.core._assoc.call(null,this__5188__auto____$1,cljs.core._nth.call(null,entry__5189__auto__,(0)),cljs.core._nth.call(null,entry__5189__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5188__auto____$1,entry__5189__auto__);
}
});

c2.scale._linear.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var domain_length = (cljs.core.last.call(null,self__.domain) - cljs.core.first.call(null,self__.domain));
var range_length = (cljs.core.last.call(null,self__.range) - cljs.core.first.call(null,self__.range));
return (cljs.core.first.call(null,self__.range) + (range_length * ((x - cljs.core.first.call(null,self__.domain)) / domain_length)));
});

c2.scale._linear.prototype.apply = (function (self__,args12524){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args12524)));
});

c2.scale._linear.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
var domain_length = (cljs.core.last.call(null,self__.domain) - cljs.core.first.call(null,self__.domain));
var range_length = (cljs.core.last.call(null,self__.range) - cljs.core.first.call(null,self__.range));
return (cljs.core.first.call(null,self__.range) + (range_length * ((x - cljs.core.first.call(null,self__.domain)) / domain_length)));
});

c2.scale._linear.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"domain","domain",-807220832,null),new cljs.core.Symbol(null,"range","range",-1014743483,null)], null);
});

c2.scale._linear.cljs$lang$type = true;

c2.scale._linear.cljs$lang$ctorPrSeq = (function (this__5217__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"c2.scale/_linear");
});

c2.scale._linear.cljs$lang$ctorPrWriter = (function (this__5217__auto__,writer__5218__auto__){
return cljs.core._write.call(null,writer__5218__auto__,"c2.scale/_linear");
});

c2.scale.__GT__linear = (function c2$scale$__GT__linear(domain,range){
return (new c2.scale._linear(domain,range,null,null,null));
});

c2.scale.map__GT__linear = (function c2$scale$map__GT__linear(G__12523){
return (new c2.scale._linear(new cljs.core.Keyword(null,"domain","domain",1847214937).cljs$core$IFn$_invoke$arity$1(G__12523),new cljs.core.Keyword(null,"range","range",1639692286).cljs$core$IFn$_invoke$arity$1(G__12523),null,cljs.core.dissoc.call(null,G__12523,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.Keyword(null,"range","range",1639692286)),null));
});


c2.scale.linear = (function c2$scale$linear(var_args){
var args__5634__auto__ = [];
var len__5627__auto___12531 = arguments.length;
var i__5628__auto___12532 = (0);
while(true){
if((i__5628__auto___12532 < len__5627__auto___12531)){
args__5634__auto__.push((arguments[i__5628__auto___12532]));

var G__12533 = (i__5628__auto___12532 + (1));
i__5628__auto___12532 = G__12533;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__linear.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.call(null,cljs.core.hash_map,kwargs)));
});

c2.scale.linear.cljs$lang$maxFixedArity = (0);

c2.scale.linear.cljs$lang$applyTo = (function (seq12529){
return c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq12529));
});
c2.scale.log;

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._power = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._power.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5183__auto__,k__5184__auto__){
var self__ = this;
var this__5183__auto____$1 = this;
return cljs.core._lookup.call(null,this__5183__auto____$1,k__5184__auto__,null);
});

c2.scale._power.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5185__auto__,k12535,else__5186__auto__){
var self__ = this;
var this__5185__auto____$1 = this;
var G__12538 = (((k12535 instanceof cljs.core.Keyword))?k12535.fqn:null);
switch (G__12538) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k12535,else__5186__auto__);

}
});

c2.scale._power.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5197__auto__,writer__5198__auto__,opts__5199__auto__){
var self__ = this;
var this__5197__auto____$1 = this;
var pr_pair__5200__auto__ = ((function (this__5197__auto____$1){
return (function (keyval__5201__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5198__auto__,cljs.core.pr_writer,""," ","",opts__5199__auto__,keyval__5201__auto__);
});})(this__5197__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__5198__auto__,pr_pair__5200__auto__,"#c2.scale._power{",", ","}",opts__5199__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain","domain",1847214937),self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null))], null),self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IIterable$ = true;

c2.scale._power.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12534){
var self__ = this;
var G__12534__$1 = this;
return (new cljs.core.RecordIter((0),G__12534__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.Keyword(null,"range","range",1639692286)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

c2.scale._power.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5181__auto__){
var self__ = this;
var this__5181__auto____$1 = this;
return self__.__meta;
});

c2.scale._power.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5177__auto__){
var self__ = this;
var this__5177__auto____$1 = this;
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._power.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5187__auto__){
var self__ = this;
var this__5187__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5178__auto__){
var self__ = this;
var this__5178__auto____$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_imap.call(null,this__5178__auto____$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

c2.scale._power.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__5179__auto__,other__5180__auto__){
var self__ = this;
var this__5179__auto____$1 = this;
if(cljs.core.truth_((function (){var and__4557__auto__ = other__5180__auto__;
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (this__5179__auto____$1.constructor === other__5180__auto__.constructor);
if(and__4557__auto____$1){
return cljs.core.equiv_map.call(null,this__5179__auto____$1,other__5180__auto__);
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._power.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5192__auto__,k__5193__auto__){
var self__ = this;
var this__5192__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"domain","domain",1847214937),null,new cljs.core.Keyword(null,"range","range",1639692286),null], null), null),k__5193__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5192__auto____$1),self__.__meta),k__5193__auto__);
} else {
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5193__auto__)),null));
}
});

c2.scale._power.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5190__auto__,k__5191__auto__,G__12534){
var self__ = this;
var this__5190__auto____$1 = this;
var pred__12539 = cljs.core.keyword_identical_QMARK_;
var expr__12540 = k__5191__auto__;
if(cljs.core.truth_(pred__12539.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),expr__12540))){
return (new c2.scale._power(G__12534,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__12539.call(null,new cljs.core.Keyword(null,"range","range",1639692286),expr__12540))){
return (new c2.scale._power(self__.domain,G__12534,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5191__auto__,G__12534),null));
}
}
});

c2.scale._power.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5195__auto__){
var self__ = this;
var this__5195__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain","domain",1847214937),self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null))], null),self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5182__auto__,G__12534){
var self__ = this;
var this__5182__auto____$1 = this;
return (new c2.scale._power(self__.domain,self__.range,G__12534,self__.__extmap,self__.__hash));
});

c2.scale._power.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5188__auto__,entry__5189__auto__){
var self__ = this;
var this__5188__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5189__auto__)){
return cljs.core._assoc.call(null,this__5188__auto____$1,cljs.core._nth.call(null,entry__5189__auto__,(0)),cljs.core._nth.call(null,entry__5189__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5188__auto____$1,entry__5189__auto__);
}
});

c2.scale._power.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.comp.call(null,c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),cljs.core.map.call(null,c2.maths.expt,self__.domain),new cljs.core.Keyword(null,"range","range",1639692286),self__.range),c2.maths.expt).call(null,x);
});

c2.scale._power.prototype.apply = (function (self__,args12537){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args12537)));
});

c2.scale._power.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
return cljs.core.comp.call(null,c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),cljs.core.map.call(null,c2.maths.expt,self__.domain),new cljs.core.Keyword(null,"range","range",1639692286),self__.range),c2.maths.expt).call(null,x);
});

c2.scale._power.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"domain","domain",-807220832,null),new cljs.core.Symbol(null,"range","range",-1014743483,null)], null);
});

c2.scale._power.cljs$lang$type = true;

c2.scale._power.cljs$lang$ctorPrSeq = (function (this__5217__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"c2.scale/_power");
});

c2.scale._power.cljs$lang$ctorPrWriter = (function (this__5217__auto__,writer__5218__auto__){
return cljs.core._write.call(null,writer__5218__auto__,"c2.scale/_power");
});

c2.scale.__GT__power = (function c2$scale$__GT__power(domain,range){
return (new c2.scale._power(domain,range,null,null,null));
});

c2.scale.map__GT__power = (function c2$scale$map__GT__power(G__12536){
return (new c2.scale._power(new cljs.core.Keyword(null,"domain","domain",1847214937).cljs$core$IFn$_invoke$arity$1(G__12536),new cljs.core.Keyword(null,"range","range",1639692286).cljs$core$IFn$_invoke$arity$1(G__12536),null,cljs.core.dissoc.call(null,G__12536,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.Keyword(null,"range","range",1639692286)),null));
});


c2.scale.power = (function c2$scale$power(var_args){
var args__5634__auto__ = [];
var len__5627__auto___12544 = arguments.length;
var i__5628__auto___12545 = (0);
while(true){
if((i__5628__auto___12545 < len__5627__auto___12544)){
args__5634__auto__.push((arguments[i__5628__auto___12545]));

var G__12546 = (i__5628__auto___12545 + (1));
i__5628__auto___12545 = G__12546;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.scale.power.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.scale.power.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__power.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.call(null,cljs.core.hash_map,kwargs)));
});

c2.scale.power.cljs$lang$maxFixedArity = (0);

c2.scale.power.cljs$lang$applyTo = (function (seq12542){
return c2.scale.power.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq12542));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._log = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._log.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5183__auto__,k__5184__auto__){
var self__ = this;
var this__5183__auto____$1 = this;
return cljs.core._lookup.call(null,this__5183__auto____$1,k__5184__auto__,null);
});

c2.scale._log.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5185__auto__,k12548,else__5186__auto__){
var self__ = this;
var this__5185__auto____$1 = this;
var G__12551 = (((k12548 instanceof cljs.core.Keyword))?k12548.fqn:null);
switch (G__12551) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k12548,else__5186__auto__);

}
});

c2.scale._log.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5197__auto__,writer__5198__auto__,opts__5199__auto__){
var self__ = this;
var this__5197__auto____$1 = this;
var pr_pair__5200__auto__ = ((function (this__5197__auto____$1){
return (function (keyval__5201__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5198__auto__,cljs.core.pr_writer,""," ","",opts__5199__auto__,keyval__5201__auto__);
});})(this__5197__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__5198__auto__,pr_pair__5200__auto__,"#c2.scale._log{",", ","}",opts__5199__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain","domain",1847214937),self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null))], null),self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IIterable$ = true;

c2.scale._log.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12547){
var self__ = this;
var G__12547__$1 = this;
return (new cljs.core.RecordIter((0),G__12547__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.Keyword(null,"range","range",1639692286)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

c2.scale._log.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5181__auto__){
var self__ = this;
var this__5181__auto____$1 = this;
return self__.__meta;
});

c2.scale._log.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5177__auto__){
var self__ = this;
var this__5177__auto____$1 = this;
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._log.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5187__auto__){
var self__ = this;
var this__5187__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5178__auto__){
var self__ = this;
var this__5178__auto____$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_imap.call(null,this__5178__auto____$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

c2.scale._log.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__5179__auto__,other__5180__auto__){
var self__ = this;
var this__5179__auto____$1 = this;
if(cljs.core.truth_((function (){var and__4557__auto__ = other__5180__auto__;
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (this__5179__auto____$1.constructor === other__5180__auto__.constructor);
if(and__4557__auto____$1){
return cljs.core.equiv_map.call(null,this__5179__auto____$1,other__5180__auto__);
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._log.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5192__auto__,k__5193__auto__){
var self__ = this;
var this__5192__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"domain","domain",1847214937),null,new cljs.core.Keyword(null,"range","range",1639692286),null], null), null),k__5193__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5192__auto____$1),self__.__meta),k__5193__auto__);
} else {
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5193__auto__)),null));
}
});

c2.scale._log.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5190__auto__,k__5191__auto__,G__12547){
var self__ = this;
var this__5190__auto____$1 = this;
var pred__12552 = cljs.core.keyword_identical_QMARK_;
var expr__12553 = k__5191__auto__;
if(cljs.core.truth_(pred__12552.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),expr__12553))){
return (new c2.scale._log(G__12547,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__12552.call(null,new cljs.core.Keyword(null,"range","range",1639692286),expr__12553))){
return (new c2.scale._log(self__.domain,G__12547,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5191__auto__,G__12547),null));
}
}
});

c2.scale._log.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5195__auto__){
var self__ = this;
var this__5195__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain","domain",1847214937),self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null))], null),self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5182__auto__,G__12547){
var self__ = this;
var this__5182__auto____$1 = this;
return (new c2.scale._log(self__.domain,self__.range,G__12547,self__.__extmap,self__.__hash));
});

c2.scale._log.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5188__auto__,entry__5189__auto__){
var self__ = this;
var this__5188__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5189__auto__)){
return cljs.core._assoc.call(null,this__5188__auto____$1,cljs.core._nth.call(null,entry__5189__auto__,(0)),cljs.core._nth.call(null,entry__5189__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5188__auto____$1,entry__5189__auto__);
}
});

c2.scale._log.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.comp.call(null,c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),cljs.core.map.call(null,c2.maths.log,self__.domain),new cljs.core.Keyword(null,"range","range",1639692286),self__.range),c2.maths.log).call(null,x);
});

c2.scale._log.prototype.apply = (function (self__,args12550){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args12550)));
});

c2.scale._log.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
return cljs.core.comp.call(null,c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),cljs.core.map.call(null,c2.maths.log,self__.domain),new cljs.core.Keyword(null,"range","range",1639692286),self__.range),c2.maths.log).call(null,x);
});

c2.scale._log.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"domain","domain",-807220832,null),new cljs.core.Symbol(null,"range","range",-1014743483,null)], null);
});

c2.scale._log.cljs$lang$type = true;

c2.scale._log.cljs$lang$ctorPrSeq = (function (this__5217__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"c2.scale/_log");
});

c2.scale._log.cljs$lang$ctorPrWriter = (function (this__5217__auto__,writer__5218__auto__){
return cljs.core._write.call(null,writer__5218__auto__,"c2.scale/_log");
});

c2.scale.__GT__log = (function c2$scale$__GT__log(domain,range){
return (new c2.scale._log(domain,range,null,null,null));
});

c2.scale.map__GT__log = (function c2$scale$map__GT__log(G__12549){
return (new c2.scale._log(new cljs.core.Keyword(null,"domain","domain",1847214937).cljs$core$IFn$_invoke$arity$1(G__12549),new cljs.core.Keyword(null,"range","range",1639692286).cljs$core$IFn$_invoke$arity$1(G__12549),null,cljs.core.dissoc.call(null,G__12549,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.Keyword(null,"range","range",1639692286)),null));
});


c2.scale.log = (function c2$scale$log(var_args){
var args__5634__auto__ = [];
var len__5627__auto___12557 = arguments.length;
var i__5628__auto___12558 = (0);
while(true){
if((i__5628__auto___12558 < len__5627__auto___12557)){
args__5634__auto__.push((arguments[i__5628__auto___12558]));

var G__12559 = (i__5628__auto___12558 + (1));
i__5628__auto___12558 = G__12559;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.scale.log.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.scale.log.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__log.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(10)], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.call(null,cljs.core.hash_map,kwargs)));
});

c2.scale.log.cljs$lang$maxFixedArity = (0);

c2.scale.log.cljs$lang$applyTo = (function (seq12555){
return c2.scale.log.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq12555));
});
