// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.shared');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$overview,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$overview,cljs.core.cst$kw$label,"Overview",cljs.core.cst$kw$component,hatti.views.overview_page], null),cljs.core.cst$kw$photos,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$photos,cljs.core.cst$kw$label,"Photos",cljs.core.cst$kw$component,hatti.views.photos_page], null),cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$map,cljs.core.cst$kw$label,"Map",cljs.core.cst$kw$component,hatti.views.map_page], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$table,cljs.core.cst$kw$label,"Table",cljs.core.cst$kw$component,hatti.views.table_page], null),cljs.core.cst$kw$chart,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$chart,cljs.core.cst$kw$label,"Charts",cljs.core.cst$kw$component,hatti.views.chart_page], null),cljs.core.cst$kw$saved_DASH_charts,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$label,"Dashboard",cljs.core.cst$kw$component,hatti.views.saved_charts_page], null),cljs.core.cst$kw$settings,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$settings,cljs.core.cst$kw$label,"Settings",cljs.core.cst$kw$component,hatti.views.settings_page], null)], null);
hatti.views.dataview_actions.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview37090 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview37090 = (function (cursor,owner,meta37091){
this.cursor = cursor;
this.owner = owner;
this.meta37091 = meta37091;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview37090.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37092,meta37091__$1){
var self__ = this;
var _37092__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview37090(self__.cursor,self__.owner,meta37091__$1));
});

hatti.views.dataview.t_hatti$views$dataview37090.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37092){
var self__ = this;
var _37092__$1 = this;
return self__.meta37091;
});

hatti.views.dataview.t_hatti$views$dataview37090.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview37090.prototype.om$core$IRender$render$arity$1 = (function (this__18961__auto__){
var self__ = this;
var this__18961__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview37090.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta37091], null);
});

hatti.views.dataview.t_hatti$views$dataview37090.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview37090.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview37090";

hatti.views.dataview.t_hatti$views$dataview37090.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"hatti.views.dataview/t_hatti$views$dataview37090");
});

hatti.views.dataview.__GT_t_hatti$views$dataview37090 = (function hatti$views$dataview$__GT_t_hatti$views$dataview37090(cursor__$1,owner__$1,meta37091){
return (new hatti.views.dataview.t_hatti$views$dataview37090(cursor__$1,owner__$1,meta37091));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview37090(cursor,owner,null));
}));
hatti.views.dataview_infobar.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__37093,owner){
var map__37094 = p__37093;
var map__37094__$1 = ((((!((map__37094 == null)))?((((map__37094.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37094.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37094):map__37094);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37094__$1,cljs.core.cst$kw$dataset_DASH_info);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37094__$1,cljs.core.cst$kw$status);
if(typeof hatti.views.dataview.t_hatti$views$dataview37096 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview37096 = (function (p__37093,owner,map__37094,dataset_info,status,meta37097){
this.p__37093 = p__37093;
this.owner = owner;
this.map__37094 = map__37094;
this.dataset_info = dataset_info;
this.status = status;
this.meta37097 = meta37097;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview37096.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__37094,map__37094__$1,dataset_info,status){
return (function (_37098,meta37097__$1){
var self__ = this;
var _37098__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview37096(self__.p__37093,self__.owner,self__.map__37094,self__.dataset_info,self__.status,meta37097__$1));
});})(map__37094,map__37094__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview37096.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__37094,map__37094__$1,dataset_info,status){
return (function (_37098){
var self__ = this;
var _37098__$1 = this;
return self__.meta37097;
});})(map__37094,map__37094__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview37096.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview37096.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__37094,map__37094__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var langs = hatti.ona.forms.get_languages(form);
var default_lang = hatti.ona.forms.default_lang(langs);
var lang_state = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$all,langs,cljs.core.cst$kw$default,default_lang,cljs.core.cst$kw$current,default_lang], null);
if(cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))){
return chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$languages], null),lang_state);
} else {
return null;
}
});})(map__37094,map__37094__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview37096.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview37096.prototype.om$core$IRender$render$arity$1 = ((function (map__37094,map__37094__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var map__37099 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__37099__$1 = ((((!((map__37099 == null)))?((((map__37099.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37099.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37099):map__37099);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37099__$1,cljs.core.cst$kw$dataset_DASH_id);
var map__37100 = self__.dataset_info;
var map__37100__$1 = ((((!((map__37100 == null)))?((((map__37100.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37100.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37100):map__37100);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37100__$1,cljs.core.cst$kw$num_of_submissions);
var map__37101 = self__.status;
var map__37101__$1 = ((((!((map__37101 == null)))?((((map__37101.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37101.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37101):map__37101);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37101__$1,cljs.core.cst$kw$loading_QMARK_);
var total_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37101__$1,cljs.core.cst$kw$total_DASH_records);
var G__37109 = {"className": "right rec-summary rec-margin"};
var G__37110 = (function (){var attrs37105 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))?om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.shared.language_selector,null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs37105))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,"language-selector"], null),attrs37105], 0))):{"id": "language-selector"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs37105))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs37105)], null))));
})();
var G__37111 = (function (){var G__37114 = {"id": "data-status"};
var G__37115 = (function (){var attrs37106 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs37106))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs37106], 0))):{"className": "rec"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs37106))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs37106),sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null))));
})();
return React.DOM.div(G__37114,G__37115);
})();
var G__37112 = (function (){var G__37116 = {"className": "divider"};
return React.DOM.div(G__37116);
})();
var G__37113 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_actions,dataset_id));
return React.DOM.div(G__37109,G__37110,G__37111,G__37112,G__37113);
});})(map__37094,map__37094__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview37096.getBasis = ((function (map__37094,map__37094__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__37093,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__37094,cljs.core.cst$sym$dataset_DASH_info,cljs.core.cst$sym$status,cljs.core.cst$sym$meta37097], null);
});})(map__37094,map__37094__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview37096.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview37096.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview37096";

hatti.views.dataview.t_hatti$views$dataview37096.cljs$lang$ctorPrWriter = ((function (map__37094,map__37094__$1,dataset_info,status){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"hatti.views.dataview/t_hatti$views$dataview37096");
});})(map__37094,map__37094__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview37096 = ((function (map__37094,map__37094__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview37096(p__37093__$1,owner__$1,map__37094__$2,dataset_info__$1,status__$1,meta37097){
return (new hatti.views.dataview.t_hatti$views$dataview37096(p__37093__$1,owner__$1,map__37094__$2,dataset_info__$1,status__$1,meta37097));
});})(map__37094,map__37094__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview37096(p__37093,owner,map__37094__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_(cljs.core.set(views),view__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.tabbed_dataview.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview37120 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview37120 = (function (app_state,owner,opts,meta37121){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta37121 = meta37121;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview37120.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37122,meta37121__$1){
var self__ = this;
var _37122__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview37120(self__.app_state,self__.owner,self__.opts,meta37121__$1));
});

hatti.views.dataview.t_hatti$views$dataview37120.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37122){
var self__ = this;
var _37122__$1 = this;
return self__.meta37121;
});

hatti.views.dataview.t_hatti$views$dataview37120.prototype.om$core$IInitState$ = true;

hatti.views.dataview.t_hatti$views$dataview37120.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var geopoints_QMARK_ = cljs.core.cst$kw$instances_with_geopoints.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state));
var no_geodata_QMARK_ = cljs.core.not((function (){var or__6210__auto__ = geopoints_QMARK_;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
var or__6210__auto____$1 = cljs.core.some(hatti.ona.forms.geopoint_QMARK_,form);
if(cljs.core.truth_(or__6210__auto____$1)){
return or__6210__auto____$1;
} else {
return cljs.core.some(hatti.ona.forms.geofield_QMARK_,form);
}
}
})());
if((no_geodata_QMARK_) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$map,cljs.core.cst$kw$selected.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))))){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$selected], null),cljs.core.cst$kw$table);
} else {
}

return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$no_DASH_geodata_QMARK_,no_geodata_QMARK_], null);
});

hatti.views.dataview.t_hatti$views$dataview37120.prototype.om$core$IRenderState$ = true;

hatti.views.dataview.t_hatti$views$dataview37120.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,p__37123){
var self__ = this;
var map__37124 = p__37123;
var map__37124__$1 = ((((!((map__37124 == null)))?((((map__37124.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37124.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37124):map__37124);
var no_geodata_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37124__$1,cljs.core.cst$kw$no_DASH_geodata_QMARK_);
var ___$1 = this;
var active_view = cljs.core.cst$kw$selected.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state));
var view__GT_display = ((function (active_view,___$1,map__37124,map__37124__$1,no_geodata_QMARK_){
return (function (p1__37117_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,p1__37117_SHARP_)){
return "block";
} else {
return "none";
}
});})(active_view,___$1,map__37124,map__37124__$1,no_geodata_QMARK_))
;
var view__GT_cls = ((function (active_view,view__GT_display,___$1,map__37124,map__37124__$1,no_geodata_QMARK_){
return (function (p1__37118_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,p1__37118_SHARP_)){
return "clicked";
} else {
return null;
}
});})(active_view,view__GT_display,___$1,map__37124,map__37124__$1,no_geodata_QMARK_))
;
var dataviews = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview.dataview_map,cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__37124,map__37124__$1,no_geodata_QMARK_){
return (function (p__37126){
var map__37127 = p__37126;
var map__37127__$1 = ((((!((map__37127 == null)))?((((map__37127.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37127.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37127):map__37127);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37127__$1,cljs.core.cst$kw$view);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37127__$1,cljs.core.cst$kw$label);
var active_QMARK_ = cljs.core.some(((function (map__37127,map__37127__$1,view,label,active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__37124,map__37124__$1,no_geodata_QMARK_){
return (function (p1__37119_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,p1__37119_SHARP_);
});})(map__37127,map__37127__$1,view,label,active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__37124,map__37124__$1,no_geodata_QMARK_))
,cljs.core.cst$kw$active.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state)));
if(cljs.core.truth_((function (){var and__6198__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$map);
if(and__6198__auto__){
return no_geodata_QMARK_;
} else {
return and__6198__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,"inactive",cljs.core.cst$kw$title,"No geodata"], null),cljs.core.name(view)], null);
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$map)) && ((cljs.core.cst$kw$num_of_submissions.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state)) > hatti.constants.mapping_threshold))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,"inactive",cljs.core.cst$kw$title,chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("Map does not support more than %d points.",cljs.core.array_seq([hatti.constants.mapping_threshold], 0))], null),cljs.core.name(view)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,(cljs.core.truth_(active_QMARK_)?[cljs.core.str("#/"),cljs.core.str(cljs.core.name(view))].join(''):null),cljs.core.cst$kw$class,(cljs.core.truth_(active_QMARK_)?view__GT_cls(view):"inactive")], null),label], null);

}
}
});})(active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__37124,map__37124__$1,no_geodata_QMARK_))
;
var G__37130 = {"className": "tab-container dataset-tabs"};
var G__37131 = (function (){var attrs37129 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(dv__GT_link,dataviews);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs37129))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs37129], 0))):{"className": "tab-bar"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs37129))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs37129),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})();
var G__37132 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__6990__auto__ = ((function (G__37130,G__37131,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__37124,map__37124__$1,no_geodata_QMARK_){
return (function hatti$views$dataview$iter__37133(s__37134){
return (new cljs.core.LazySeq(null,((function (G__37130,G__37131,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__37124,map__37124__$1,no_geodata_QMARK_){
return (function (){
var s__37134__$1 = s__37134;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37134__$1);
if(temp__4657__auto__){
var s__37134__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37134__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__37134__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__37136 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__37135 = (0);
while(true){
if((i__37135 < size__6989__auto__)){
var map__37147 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__37135);
var map__37147__$1 = ((((!((map__37147 == null)))?((((map__37147.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37147.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37147):map__37147);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37147__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37147__$1,cljs.core.cst$kw$view);
cljs.core.chunk_append(b__37136,(function (){var G__37149 = {"style": {"display": view__GT_display(view)}, "className": [cljs.core.str("tab-page "),cljs.core.str(cljs.core.name(view)),cljs.core.str("-page")].join('')};
var G__37150 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,view))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(cljs.core.name(view))].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null):null));
return React.DOM.div(G__37149,G__37150);
})());

var G__37155 = (i__37135 + (1));
i__37135 = G__37155;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37136),hatti$views$dataview$iter__37133(cljs.core.chunk_rest(s__37134__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37136),null);
}
} else {
var map__37151 = cljs.core.first(s__37134__$2);
var map__37151__$1 = ((((!((map__37151 == null)))?((((map__37151.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37151.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37151):map__37151);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37151__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37151__$1,cljs.core.cst$kw$view);
return cljs.core.cons((function (){var G__37153 = {"style": {"display": view__GT_display(view)}, "className": [cljs.core.str("tab-page "),cljs.core.str(cljs.core.name(view)),cljs.core.str("-page")].join('')};
var G__37154 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,view))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(cljs.core.name(view))].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null):null));
return React.DOM.div(G__37153,G__37154);
})(),hatti$views$dataview$iter__37133(cljs.core.rest(s__37134__$2)));
}
} else {
return null;
}
break;
}
});})(G__37130,G__37131,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__37124,map__37124__$1,no_geodata_QMARK_))
,null,null));
});})(G__37130,G__37131,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__37124,map__37124__$1,no_geodata_QMARK_))
;
return iter__6990__auto__(dataviews);
})());
return React.DOM.div(G__37130,G__37131,G__37132);
});

hatti.views.dataview.t_hatti$views$dataview37120.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta37121], null);
});

hatti.views.dataview.t_hatti$views$dataview37120.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview37120.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview37120";

hatti.views.dataview.t_hatti$views$dataview37120.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"hatti.views.dataview/t_hatti$views$dataview37120");
});

hatti.views.dataview.__GT_t_hatti$views$dataview37120 = (function hatti$views$dataview$__GT_t_hatti$views$dataview37120(app_state__$1,owner__$1,opts__$1,meta37121){
return (new hatti.views.dataview.t_hatti$views$dataview37120(app_state__$1,owner__$1,opts__$1,meta37121));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview37120(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
